#ifndef _ECS_CHAMP_POST_ENS_H_
#define _ECS_CHAMP_POST_ENS_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associes  la structure `ecs_champ_t' dcrivant un champ
 *   et ralisant les sorties pour post-traitement EnSight
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C ou BFT
 *----------------------------------------------------------------------------*/

#include <bft_file.h>


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles du  paquetage global "Post-Traitement"
 *----------------------------------------------------------------------------*/

#include "ecs_post_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_famille_publ.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_champ_publ.h"


/*============================================================================
 *                       Dfinition de macro
 *============================================================================*/


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui crit les connectivits des lments
 *   selon leur type gometrique
 *
 *  Les lments doivent avoir t tris suivant leur type gometrique
 *----------------------------------------------------------------------------*/

void ecs_champ_post_ens__ecr_part
(
 const char            *const nom_maillage    ,
       ecs_champ_t     *const champ_som       ,
       ecs_champ_t     *const champ_def       ,
       ecs_champ_t     *const champ_famille   ,
 const ecs_famille_t   *const famille_tete    ,
 const ecs_tab_int_t   *const tab_elt_typ_geo ,
       ecs_post_ens_t  *const cas_ens
) ;


/*----------------------------------------------------------------------------
 *  Fonction crivant le champ  sortir au format Ensight
 *---------------------------------------------------------------------------*/

void ecs_champ_post_ens__ecr_val
(
 const ecs_tab_int_t   *const tab_val       ,
 const char            *const nom_maillage  ,
 const char            *const nom_champ     ,
       ecs_post_ens_t  *const cas_ens
) ;


#endif /* _ECS_CHAMP_POST_ENS_H_ */

