#ifndef _ECS_CGNS_PRIV_H_
#define _ECS_CGNS_PRIV_H_

/*============================================================================
 *  Dfinition de la structure `_ecs_cgns_t' pour les sorties au format CGNS
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/

#include "ecs_config.h"

#if defined(HAVE_CGNS)


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles du  paquetage global "CGNS"
 *----------------------------------------------------------------------------*/

#if defined(HAVE_CGNS)

#ifdef __cplusplus
extern "C" {
#endif

#include <cgnslib.h>

#ifdef __cplusplus
}
#endif

#endif /* HAVE_CGNS */


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_cgns_publ.h"


/*============================================================================
 *                         Dfinitions d'numerations
 *============================================================================*/


/*============================================================================
 *                          Dfinitions de types
 *============================================================================*/


/* Structure d'information sur les maillages pour le post traitement          */

typedef struct {

  char                * nom_maillage  ; /* Nom du maillage CGNS               */

  char                * nom_fic       ; /* Nom du fichier CGNS                */
  int                   num_fic       ; /* Identificateur de fichier CGNS     */

  /* Informations sur tat du cas en post traitement */

  int                   num_sol_stat  ; /* Num. sorties                       */

  int                   dim_espace    ; /* Dimension de l'espace associ      */
  int                   dim_entite    ; /* Dimension entits maillage         */
  ecs_int_t             nbr_polyedres ; /* Nombre de polydres  ignorer      */

  ecs_bool_t            fic_ouvert    ; /* Fichier ouvert ou non ?            */

} ecs_cgns_base_t ;


/* Structure dfinissant un cas CGNS                                          */

struct _ecs_cgns_t {

  /* Informations principales (pr et post traitement) */

  char                * nom_cas       ; /* Nom du cas                         */
  ecs_bool_t            single        ; /* Forcer  une seule section ?       */

  ecs_int_t             nbr_bases     ; /* Nombre de ``bases''                */
  ecs_cgns_base_t    ** tab_bases     ; /* Descripteurs des ``bases''         */

} ;


/*============================================================================
 *                       Dfinition de macros
 *============================================================================*/

#define ECS_CGNS_TAILLE_NOM    32      /* Longueur nom max (la documentation
                                          ne prcise rien, mais les exemples
                                          CGNS et le fichier ADF.h prvoient
                                          des chanes de 32 caractres)       */


/* Compatibilit avec diverses versions de CGNS */

#if !defined(CG_OK)
#define CG_OK  ALL_OK
#endif

#endif /* HAVE_CGNS */

#endif /* _ECS_CGNS_PRIV_H_ */

