#ifndef _ECS_VEC_REAL_TRI_H_
#define _ECS_VEC_REAL_TRI_H_

/*============================================================================
 *  Prototypes des fonctions
 *  associees a la structure `ecs_vec_real_t' decrivant un vecteur indexe reel
 *   et realisant des fonctionnalites de tri
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilite
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_vec_real_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *    Fonction de tri lexicographique d'une table de listes de rels.
 *  La liste n'est pas modifie directement, mais on construit une table de
 *  renumrotation, afin de pouvoir appliquer cette rnumerotation  d'autres
 *  tableaux dpendant de la table.
 *
 *    Le tri utilis est de type "heapsort", de complexit O(nlog(n)). Les
 *  lments sont rangs en ordre croissant.
 *----------------------------------------------------------------------------*/

void ecs_vec_real__trie
(
 const ecs_vec_real_t *const this_vec  , /* --> Indexe des reels  trier      */
       ecs_tab_int_t  *const vect_renum, /* <-> Tableau de renumrotation     */
 const ecs_real_t            tolerance   /* --> Tolrance                     */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui trie un vecteur d'entiers en renvoyant le vecteur trie
 *----------------------------------------------------------------------------*/

void ecs_vec_real__trie_et_renvoie
(
 const ecs_vec_real_t *const this_vec       , /* --> Rels  trier            */
       ecs_vec_real_t *const vec_trie       , /* <-- Rels tris              */
       ecs_tab_int_t  *const vect_renum_pos , /* <-> Renum. des positions     */
 const ecs_real_t            tolerance        /* --> Tolrance                     */
) ;


#endif /* _ECS_VEC_REAL_TRI_H_ */
