#ifndef _ECS_VEC_INT_ATT_H_
#define _ECS_VEC_INT_ATT_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associes  la structure `ecs_vec_int_t' dcrivant un vecteur index entier
 *   et propres aux vecteurs indexs
 *      lis aux champs auxiliaires de type "attribut"
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_vec_int_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui assemble :
 *  - une table de positions donne dans une table de positions rceptrice
 *  - la table des valeurs correspondante dans la table des valeurs rceptrice
 *
 *  Les 2 tables de positions doivent avoir le mme nombre de positions
 *  (et les tables de valeurs doivent tre de mme type !)
 *
 *  Seule la table rceptrice est modifie,
 *   la table  assembler reste inchange
 * ----------------------------------------------------------------------------
 *
 *  Exemple : (pour des tables de valeurs entires)
 *  =======
 *
 *  Soit la table  assembler :
 *
 *                         .---.---..---..---.---.---.
 *     assemb->val_tab     | 5 | 3 || 4 || 5 | 2 | 6 |
 *                         `---'---'`---'`---'---'---'
 *                           0   1    2    3   4   5
 *
 *
 *                         .---.---.---.---.---.
 *     assemb->pos_tab     | 1 | 3 | 4 | 4 | 7 |
 *                         `---'---'---'---'---'
 *                           0   1   2   3   4
 *
 *
 *  dans la table rceptrice :
 *
 *                         .---..---..---.---..---.
 *     recept->val_tab     | 4 || 5 || 6 | 6 || 1 |
 *                         `---'`---'`---'---'`---'
 *                           0    1    2   3    4
 *
 *
 *                         .---.---.---.---.---.
 *     recept->pos_tab     | 1 | 2 | 3 | 5 | 6 |
 *                         `---'---'---'---'---'
 *                           0   1   2   3   4
 *
 *
 *  La table rceptrice devient :
 *
 *                         .---.---.---..---.---..---.---..---.---.---.---.
 *     recept->val_tab     | 4 | 5 | 3 || 5 | 4 || 6 | 6 || 1 | 5 | 2 | 6 |
 *                         `---'---'---'`---'---'`---'---'`---'---'---'---'
 *                           0   1   2    3   4    5   6    7   8   9   10
 *
 *
 *                         .---.---.---.---.---.
 *     recept->pos_tab     | 1 | 4 | 6 | 8 | 12|
 *                         `---'---'---'---'---'
 *                           0   1   2   3   4
 *
 *----------------------------------------------------------------------------*/

void ecs_vec_int_att__assemble
(
 ecs_vec_int_t *const vec_int_recept,
 ecs_vec_int_t *const vec_int_assemb
) ;


/*----------------------------------------------------------------------------
 *  Fonction ralisant la transformation d'un vecteur index
 *   en fusionnant les proprits de ses lments
 *   qui sont identiquement transforms par le vecteur de transformation donn
 *----------------------------------------------------------------------------*/

void ecs_vec_int_att__fusionne
(
       ecs_vec_int_t *const this_vec_int,
       size_t               nbr_elt_new,
 const ecs_tab_int_t        vect_transf
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie la liste des numros de famille des lments
 *
 *  Pour les lments de famille 0 ou n'ayant pas de famille, on leur
 *   attribue le numro de famille par dfaut
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_vec_int_att__fam_elt
(
 ecs_vec_int_t  *const this_vec_int_fam,
 ecs_tab_int_t  *const tab_nbr_elt_fam
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie la liste des numros de famille
 *   des lments filtrs par la liste optionnelle donne en argument
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_vec_int_att__liste_elt_fam
(
       ecs_vec_int_t   *const this_vec_int_fam,
 const ecs_tab_int_t   *const liste_filtre,
 const ecs_tab_bool_t  *const indic_famille
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui comptabilise, pour chaque valeur d'attribut,
 *   les nombres d'lments ayant la meme valeur d'attribut
 *----------------------------------------------------------------------------*/

ecs_int_t * ecs_vec_int_att__cpt_elt_val
(
 const ecs_vec_int_t  *const vec_int_att,
       size_t                nbr_val_att
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui cre une liste d'lments ayant pour valeur de l'attribut
 *   la valeur donne en argument
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_vec_int_att__cree_liste
(
 ecs_vec_int_t  *const vec_int_att,
 int                   valeur_att
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui remplace les rfrences  des lments
 *  en des rfrences  d'autres lments lis aux premiers
 *  par un vecteur index contenant des valeurs positives mais pouvant
 *  contenir la valeur 0
 *----------------------------------------------------------------------------*/

ecs_vec_int_t * ecs_vec_int__ret_remplace_ref_att
(
       ecs_vec_int_t *const vec_rep,
 const ecs_vec_int_t *const vec_def
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renumrote  partir de `1' les rfrences
 *   des numros de descripteurs
 *   dans le tableau des valeurs d'un attribut donn
 *
 *  La fonction renvoie un tableau de renumrotation des descripteurs
 *   d'un attribut de rfrence donn
 *   Si le numro de descripteur n'a pas t renumrote, on lui attribue
 *    la valeur `num_descr_defaut' dans le tableau de renumrotation
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_vec_int_att__renum_descr
(
       ecs_vec_int_t  *const vec_att,
 const ecs_int_t             num_descr_defaut,
       size_t                nbr_descr_old
) ;


#endif /* _ECS_VEC_INT_ATT_H_ */
