#ifndef _ECS_FAMILLE_CHAINE_H_
#define _ECS_FAMILLE_CHAINE_H_

/*============================================================================
 *  Prototypes des fonctions de base
 *   associes  une liste chane de structures `ecs_famille_t' dcrivant
 *   une famille
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C ou BFT
 *----------------------------------------------------------------------------*/

#include <bft_file.h>


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_descr_publ.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_famille_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui cre une liste chane de familles  partir :
 *   - des dfinitions de chaque famille en fonction des numros de descripteur
 *   - de la liste chane des descripteurs
 *  La fonction renvoie la tte de la liste chane
 *----------------------------------------------------------------------------*/

ecs_famille_t * ecs_famille_chaine__cree
(
       ecs_int_t   * *const def_fam_descr , /* Dfinition des familles        */
 const ecs_int_t     *const nbr_descr_fam , /* Nombre de descripteurs par fam */
 const ecs_int_t            num_fam_deb   , /* Premier numro de famille      */
 const ecs_int_t            nbr_fam       , /* Nombre de familles             */
       ecs_descr_t   *const descr_tete      /* Liste chane des descripteurs */
) ;


/*----------------------------------------------------------------------------
 *  Fonction librant la portion d'une liste chane de familles
 *    partir d'un noeud dont le pointeur est donn en argument.
 *  Le noeud est  NULL au retour de la fonction
 *----------------------------------------------------------------------------*/

void ecs_famille_chaine__detruit
(
 ecs_famille_t * * this_fam_noeud
) ;


/*----------------------------------------------------------------------------
 *  Fonction imprimant  partir d'un noeud `ecs_famille_t' donn
 *   une liste chane de champs
 *   sur le flux dcrit par la structure `bft_file_t'
 *----------------------------------------------------------------------------*/

void ecs_famille_chaine__imprime
(
 const ecs_famille_t  *const this_fam_noeud ,
       ecs_int_t             imp_col        ,
       bft_file_t     *const fic_imp
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie la taille en octets
 *   d'une chane de structures `ecs_famille_t'
 *----------------------------------------------------------------------------*/

float ecs_famille_chaine__ret_taille
(
 const ecs_famille_t *const this_fam_noeud
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui ajoute  la fin d'une liste chane de familles
 *   rceptrice dont la tte est donne,
 *   une liste chane de familles  concatner dont la tte est donne
 *----------------------------------------------------------------------------*/

void ecs_famille_chaine__ajoute
(
 ecs_famille_t *      * this_fam_tete   ,
 ecs_famille_t *const   fam_concat_tete
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui affiche la dfinition de la famille de numro donn
 *    partir de la liste chane des familles dont la tte est donne
 *----------------------------------------------------------------------------*/

void ecs_famille_chaine__affiche
(
 const ecs_int_t            num_fam  ,
       ecs_famille_t *const fam_tete
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie le nombre de familles
 *   de la liste chane des familles dont la tte est donne
 *----------------------------------------------------------------------------*/

ecs_int_t ecs_famille_chaine__ret_nbr
(
 const ecs_famille_t *const fam_tete
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui copie une liste chane de familles
 *   dont la tte est donne
 *----------------------------------------------------------------------------*/

ecs_famille_t * ecs_famille_chaine__copie
(
 ecs_famille_t * famille_tete
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie pour chaque numro de famille
 *   le nombre et la liste des identificateurs de type couleur
 *   des descripteurs de la famille
 *----------------------------------------------------------------------------*/

ecs_tab_int_t * ecs_famille_chaine__ret_ide
(
 ecs_famille_t   *const fam_tete
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie pour chaque numro de famille
 *   le nombre et une liste de pointeurs sur les noms des identificateurs
 *   de type groupe des descripteurs de la famille
 *----------------------------------------------------------------------------*/

ecs_tab_char_t * ecs_famille_chaine__ret_nom
(
 ecs_famille_t   *const fam_tete
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui affiche par attribut (couleur ou groupe),
 *   les numros des familles auxquelles l'attribut appartient
 *    partir d'une liste chane de familles dont la tte est donne
 *----------------------------------------------------------------------------*/

void ecs_famille_chaine__aff_fam_att
(
 ecs_famille_t *const fam_tete
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit les 2 listes chanes de descripteurs de type
 *   "couleur" et "groupe"
 *   pour chaque numro de famille contenu dans le tableau donn
 *   et  partir de la liste chane des familles
 *
 *  Cette fonction dtermine aussi les 2 tableaux donnant pour chaque famille
 *   respectivement la liste des numros de couleurs associes  la famille
 *               et la liste des numros de groupes  associes  la famille
 *----------------------------------------------------------------------------*/

void ecs_famille_chaine__cree_descr
(
 ecs_famille_t   *const famille            ,
 ecs_tab_int_t          tab_fam            ,
 ecs_descr_t   * *const descr_tete_couleur ,
 ecs_descr_t   * *const descr_tete_groupe  ,
 ecs_tab_int_t   *const tab_couleur_fam    ,
 ecs_tab_int_t   *const tab_groupe_fam     ,
 ecs_int_t       *const nbr_max_att_fam
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie un tableau indiquant pour chaque numro de
 *   famille si cette famille contient l'un des attributs (couleur ou groupe)
 *   fournis en argument.
 *
 *  La libration du tableau est  la charge du code appelant
 *----------------------------------------------------------------------------*/

ecs_tab_bool_t ecs_famille_chaine__indic_fam_att
(
 const ecs_famille_t   *const fam_tete      ,
 const ecs_tab_int_t          liste_couleur ,
 const ecs_tab_char_t         liste_groupe
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit un tableau de description d'attributs
 *   dcrits par une liste chane de familles, avec pour chacun la
 *   liste des lments portant cet attribut ( partir du numro de
 *   famille associ  chaque lment et donn par tab_fam_ent)
 *
 *  Les arguments prefixe_coul et prefixe_grp permettent de dterminer les
 *   chanes de caractres prcdent ventuellement les numros de couleur ou
 *   noms de groupe dans le tableau rsultant tab_nom_desc.
 *  L'argument "grouper_ident" indique si l'on doit combiner les attributs
 *   appartenant exactement aux mmes familles.
 *
 *  La libration des tableaux tab_nom_desc et tab_lst_desc est  la
 *   charge de la fonction utilisatrice.
 *----------------------------------------------------------------------------*/

void ecs_famille_chaine__att_fam_elt
(
 const ecs_famille_t     * fam_tete      ,
 const ecs_tab_int_t       tab_fam_elt   ,
 const char              * prefixe_coul  ,
 const char              * prefixe_grp   ,
       ecs_bool_t          grouper_ident ,
       ecs_tab_char_t    * tab_nom_descr ,
       ecs_tab_int_t   * * tab_lst_descr
) ;


#endif /* _ECS_FAMILLE_CHAINE_H_ */
