#ifndef _ECS_DESCR_PRIV_H_
#define _ECS_DESCR_PRIV_H_

/*============================================================================
 *  Dfinition privee de la structure `ecs_descr_t' dcrivant
 *   un descripteur de champ de type "attribut"
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_descr_publ.h"


/*============================================================================
 *                       Dfinition de macros
 *============================================================================*/


/*============================================================================
 *                       Dfinition de la structure
 *============================================================================*/


/*============================================================================
 *    Structure gnrale utilise pour dcrire des attributs de type couleur
 *  ou groupe.
 *
 *  Correspondance I-DEAS  : ide     : numro de couleur ou groupe
 *                           nom     : nom de groupe
 *
 *  Correspondance IggHEXA : ide     : numro de face CAO associe (-> couleur)
 *                           nom     : -
 *
 *  Correspondance MED     : ide     : valeur entire d'attribut entier
 *                           nom     : description d'attribut entier ou
 *                                     nom de groupe
 *
 *  Remarques :  Cette structure pourrait tre facilement tendue pour grr
 *               directement des descriptions de conditions aux limites.
 *============================================================================*/

struct _ecs_descr_t {

  ecs_int_t            num         ;  /* Numro         du descripteur        */
  ECS_DESCR_TYP_E      typ_e       ;  /* Type           du descripteur        */
  ecs_int_t            ide         ;  /* Identificateur du descripteur        */
  char               * nom         ;  /* Nom            du descripteur        */
  struct
  _ecs_descr_t       * l_descr_sui ;  /* Pointeur sur le descripteur suivant  */
                                      /* ds. liste chane des descripteurs   */

} ;


#endif /* _ECS_DESCR_PRIV_H_ */
