#ifndef _ECS_CHAMP_VEC_REAL_H_
#define _ECS_CHAMP_VEC_REAL_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associees a la structure `ecs_champ_t' decrivant un champ
 *   et liees a la structure `ecs_vec_real_t'
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilite
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_vec_real_publ.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_champ_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction construisant un vecteur `ecs_vec_real_t' associe au champ donne
 *  Fonction construisant un vecteur `ecs_vec_real_t' associe au champ donne
 *
 *  Si les tables sont REGLEES, les tableaux sont construits
 *
 *  Cette fonction doit etre utilisee conjointement avec :
 *  - soit `ecs_champ__transfere_vec_real()'
 *                               si le contenu du vecteur   a change
 *  - soit `ecs_champ__libere_vec_real()'
 *                               si le contenu du vecteur n'a pas ete modifie
 *  Ceci afin de reconstuire, si necessaire, les tables REGLEES
 *----------------------------------------------------------------------------*/

ecs_vec_real_t * ecs_champ__initialise_vec_real
(
 ecs_champ_t *this_champ
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui transfere le contenu d'un vecteur `ecs_vec_real_t'
 *   dans les tables d'un champ donne
 *
 *  Les tables sont transformees en REGLES si possible
 *
 *  La structure `ecs_vec_real_t' est liberee
 *----------------------------------------------------------------------------*/

void ecs_champ__transfere_vec_real
(
 ecs_champ_t    *this_champ , /* <-> Champ pour lequel transfert est effectue */
 ecs_vec_real_t *vec_real     /* <-> Vecteur `ecs_vec_real_t' a transferer    */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui libere le tableau d'une table REGLEE qui a ete
 *   precedemment developpe par l'appel de `ecs_champ__initialise_vec_real()'
 *  et qui detruit le vecteur `ecs_vec_real_t' qui a ete
 *   precedemment cree      par l'appel de `ecs_champ__initialise_vec_real()'
 *----------------------------------------------------------------------------*/

void ecs_champ__libere_vec_real
(
 ecs_champ_t     *this_champ ,/* <-> Champ associe au vecteur                 */
 ecs_vec_real_t  *vec_real    /* <-> Vecteur `ecs_vec_real_t' a detruire      */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui cree un champ a partir
 *   du contenu d'un vecteur `ecs_vec_real_t'
 *
 *  Seules les tables sont remplies
 *   (elles sont transformees en REGLES si possible)
 *
 *  Les autres membres de la structure prennent leur valeur d'initialisation
 *
 *  La structure `ecs_vec_real_t' est liberee
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_champ__init_avec_vec_real
(
       ecs_vec_real_t *      vec_real ,           /* --> Vecteur a transferer */
 const char           *const nom
) ;


#endif /* _ECS_CHAMP_VEC_REAL_H_ */
