#ifndef _ECS_CHAMP_VEC_INT_H_
#define _ECS_CHAMP_VEC_INT_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associes  la structure `ecs_champ_t' dcrivant un champ
 *   et lies  la structure `ecs_vec_int_t'
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_vec_int_publ.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_champ_publ.h"



/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction construisant un vecteur `ecs_vec_int_t' associ au champ donn
 *  Fonction construisant un vecteur `ecs_vec_int_t' associ au champ donn
 *
 *  Si les tables sont REGLEES, les tableaux sont construits
 *
 *  Cette fonction doit tre utilise conjointement avec :
 *  - soit `ecs_champ__transfere_vec_int()'
 *                               si le contenu du vecteur   a chang
 *  - soit `ecs_champ__libere_vec_int()'
 *                               si le contenu du vecteur n'a pas t modifi
 *  Ceci afin de reconstuire, si ncessaire, les tables REGLEES
 *----------------------------------------------------------------------------*/

ecs_vec_int_t * ecs_champ__initialise_vec_int
(
 ecs_champ_t *this_champ
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui transfre le contenu d'un vecteur `ecs_vec_int_t'
 *   dans les tables d'un champ donn
 *
 *  Les tables sont transformes en REGLES si possible
 *
 *  La structure `ecs_vec_int_t' est libre
 *----------------------------------------------------------------------------*/

void ecs_champ__transfere_vec_int
(
 ecs_champ_t    *this_champ,  /* <-> Champ dans lequel on transfre `vec_int' */
 ecs_vec_int_t  *vec_int      /* <-> Vecteur `ecs_vec_int_t' a transfrer     */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui libre le tableau d'une table REGLEE qui a t
 *   precedmment developp par l'appel de `ecs_champ__initialise_vec_int()'
 *  et qui dtruit le vecteur `ecs_vec_int_t' qui a t
 *   prcdemment cr      par l'appel de `ecs_champ__initialise_vec_int()'
 *----------------------------------------------------------------------------*/

void ecs_champ__libere_vec_int
(
 ecs_champ_t    * this_champ,                 /* <-> Champ associ au vecteur */
 ecs_vec_int_t  * vec_int                     /* <-> Vecteur  dtruire       */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui cre un champ  partir
 *   du contenu d'un vecteur `ecs_vec_int_t'
 *
 *  Seuls le nom du champ et les tables du champ sont remplis
 *   (les tables sont transformes en REGLES si possible)
 *
 *  Les autres membres de la structure prennent leur valeur d'initialisation
 *
 *  La structure `ecs_vec_int_t' est libre
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_champ__init_avec_vec_int
(
       ecs_vec_int_t  *      vec_int,             /* --> Vecteur  transferer */
 const char           *const nom
) ;


/*----------------------------------------------------------------------------
 *  Fonction ralisant la transformation du contenu d'un champ donn,
 *   dpendant des rfrences  un autre champ,
 *   en un contenu qui depend des indices de cet autre champ
 *----------------------------------------------------------------------------*/

void ecs_champ__reference_en_indice
(
 ecs_champ_t  *this_champ_transf,      /* <-> Champ des valeurs  transformer */
 ecs_champ_t  *     champ_ref          /* --> Champ des valeurs de rfrence  */
) ;


/*----------------------------------------------------------------------------
 *  Fonction ralisant la transformation d'un champ
 *   en appliquant directement le vecteur de transformation donn
 *   sur ses lments
 *----------------------------------------------------------------------------*/

void ecs_champ__transforme_val
(
       ecs_champ_t    *const this_champ,
       size_t                nbr_elt_new,
 const ecs_tab_int_t         vect_transf
) ;


/*----------------------------------------------------------------------------
 *  Fonction ralisant la transformation d'un champ
 *   en appliquant directement le vecteur de transformation donn
 *   sur ses valeurs
 *----------------------------------------------------------------------------*/

void ecs_champ__transforme_pos
(
       ecs_champ_t    *const this_champ,
       size_t                nbr_elt_ref,
 const ecs_tab_int_t         vect_transf
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui incrmente les valeurs d'un champ donn
 *   d'une constante donne
 *----------------------------------------------------------------------------*/

void ecs_champ__incremente_val
(
 ecs_champ_t  * this_champ,
 ecs_int_t      increment
) ;


/*----------------------------------------------------------------------------
 *  Fonction ralisant la transformation d'un champ
 *   en appliquant directement le vecteur de transformation donn
 *   sur les valeurs associes  ses lments
 *----------------------------------------------------------------------------*/

void ecs_champ__renumerote
(
       ecs_champ_t    *const this_champ ,
 const ecs_tab_int_t         vect_transf
) ;


void ecs_champ__renumerote_et_sgn
(
       ecs_champ_t    *const this_champ  ,
 const ecs_tab_int_t         vect_transf ,
 const ecs_tab_int_t         signe_elt
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui retourne le tableau des valeurs du champ donn,
 *   dimensionn au nombre de rfrences distinctes du champ,
 *   (valeurs qui correspondent a des rfrences)
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_champ__ret_reference
(
 ecs_champ_t  *const this_champ
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui remplace les rfrences  des lments
 *  en des rfrences  d'autres lments lis aux premiers
 *  par un champ de type "dfinition"
 *----------------------------------------------------------------------------*/

void ecs_champ__remplace_ref
(
 ecs_champ_t *const champ_rep ,
 ecs_champ_t *const champ_def
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit la  table de connectivit inverse
 *  "sous-lments -> lments"
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_champ__inverse
(
 ecs_champ_t  *const champ_def_elt ,
 size_t              nbr_sselt
) ;



#endif /* _ECS_CHAMP_VEC_INT_H_ */
