#ifndef _ECS_CHAMP_VEC_H_
#define _ECS_CHAMP_VEC_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associees a la structure `ecs_champ_t' decrivant un champ
 *   et liees aux structures `ecs_vec_int_t' et `ecs_vec_real_t'
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilite
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_vec_int_publ.h"
#include "ecs_vec_real_publ.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_champ_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui determine un nouveau champ a partir d'un champ de reference
 *   en extrayant de ce dernier les elements selectionnes
 *   par le tableau de booleens
 *
 *  Cette fonction renvoie le champ qui definit les anciens elements
 *   du champ de reference en fonction des nouveaux elements du champ renvoye
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_champ__extrait
(
 ecs_champ_t          * *      this_champ_new  ,
 ecs_champ_t            *const champ_ref       ,
 const ecs_tab_bool_t          bool_elt_select
) ;



#endif /* _ECS_CHAMP_VEC_H_ */
