#ifndef _ECS_CHAMP_PRIV_H_
#define _ECS_CHAMP_PRIV_H_

/*============================================================================
 *  Dfinition prive de la structure `_ecs_champ_t' dcrivant un champ
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_descr_publ.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_champ_publ.h"


/*============================================================================
 *                       Dfinition de macros
 *============================================================================*/


/*============================================================================
 *                       Dfinition des structures
 *============================================================================*/

struct _ecs_champ_t {

  size_t                nbr_elt     ;  /* Nombre d'lments associs          */
  ecs_type_t            typ_val     ;  /* Type des valeurs                    */

  size_t                pos_pas     ;  /* Pas des positions si elles          */
                                       /* forment une REGLE (0 sinon)         */
  ecs_size_t          * pos_tab     ;  /* Positions des valeurs du champ      */
                                       /* (NULL si elles forment une REGLE)   */

  void                * val_tab     ;  /* Valeurs du champ                    */

  char                * nom         ;  /* Nom du champ                        */

  ecs_descr_t         * descr       ;  /* Tte de la liste chane des        */
                                       /*  descripteurs de champ "attribut"   */
  struct
  _ecs_champ_t        * l_champ_sui ;  /* Lien entre les champs auxiliaires : */
                                       /*  structure `_ecs_champ_t' suivante  */
  ECS_CHAMP_STATUT_E    statut_e    ;  /* Statut du champ dans une            */
                                       /*  transformation de type dcoupage   */
                                       /*  ou recollement                     */

} ;


/*============================================================================
 *
 *  Schma d'association entre les tables "positions" et "valeurs"
 * ----------------------------------------------------------------
 *
 *
 * Table des valeurs `val->tab' (de dimension `pos->tab[pos->nbr-1]-1')
 *
 * .---.-------..------.-------.------..------.-------..-------.------.
 * |   |  ...  ||      |  ...  |      ||      |  ...  ||  ...  |      |
 * `---'-------'`------'-------'------'`------'-------'`-------'------'
 *   0           iVal-1         jVal-2  jVal-1                  nVal-2 nVal-1
 *
 *                  |                      |                              |
 *                  |                      |                              |
 *                  `----------.       .---'          .-------------------'
 *                             |       |              |
 *            .-----.-------.------.------.-------.------.
 *            |  1  |  ...  | iVal | jVal |  ...  | nVal |
 *            `-----'-------'------'------'-------'------'
 *               0            iPos  iPos+1          nPos = pos->nbr - 1
 *
 * Table des positions `pos->tab' (de dimension `pos->nbr')
 *
 *============================================================================*/


/*============================================================================
 *                            Proprits des champs
 *
 *  --------------------------------------------------------------------------
 *  Proprits des champs "principaux"
 *             ("index", "type gomtrique", "dfinition")
 *  --------------------------------------------------------------------------
 *
 *  - val         : valeurs entires
 *  - descr       = NULL
 *  - l_champ_sui = NULL
 *  - statut_e    = ECS_CHAMP_STATUT_INDEFINI
 *
 *  Proprits du champ "index"
 *  --------------------------------------------------------------------------
 *  - Table des positions "pos" : REGLE de raison unit
 *
 *  Proprits du champ "type gomtrique"
 *  --------------------------------------------------------------------------
 *  - Table des positions "pos" : REGLE de raison unite
 *  --------------------------------------------------------------------------
 *
 *
 *  --------------------------------------------------------------------------
 *  Proprits des champs "auxiliaires"
 *             (champs de type "attribut")
 *  --------------------------------------------------------------------------
 *
 *  Proprits des champs "attribut"
 *  --------------------------------------------------------------------------
 *  - val        :    valeurs entires
 *  - statut_e   =    ECS_CHAMP_STATUT_INDEFINI
 *                 ou ECS_CHAMP_STATUT_REF_ELT
 *                 ou ECS_CHAMP_STATUT_HERITABLE
 *============================================================================*/

#endif /* _ECS_CHAMP_PRIV_H_ */
