#ifndef _ECS_CMD_PRIV_H_
#define _ECS_CMD_PRIV_H_

/*============================================================================
 *  Dfinition prive de la structure `_ecs_cmd_t' decrivant
 *   les options de la ligne de commande
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/

#include "ecs_config.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
*----------------------------------------------------------------------------*/

#include "ecs_param_rc_glob.h"
#include "ecs_param_perio_glob.h"
#include "ecs_pre.h"
#include "ecs_select_fac_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/


/*============================================================================
 *                       Dfinition de macros
 *============================================================================*/


#define ECS_CMD_INIT_RC_FRACTION_DIST_I                           0.0
#define ECS_CMD_INIT_RC_FRACTION_DIST                           "0.1"
#define ECS_CMD_INIT_RC_FRACTION_DIST_S                         0.499

#define ECS_CMD_INIT_RC_EPSILON_PLAN_I                            0.6
#define ECS_CMD_INIT_RC_EPSILON_PLAN                            "0.8"
#define ECS_CMD_INIT_RC_EPSILON_PLAN_S                         0.9999

#define ECS_CMD_INIT_PERIO_ROTA_ANGLE_I                        -361.0
#define ECS_CMD_INIT_PERIO_ROTA_ANGLE_S                         361.0

#define ECS_CMD_LIGNE_MAX                                        1024


/*----------------------------------------------------------------------------
 * Dfinition des noms de fichiers et d'extensions
 *----------------------------------------------------------------------------*/

#define ECS_CMD_EXEC_NAME                                       "ecs"

#define ECS_CMD_FILE_DUMP_DEFAULT                    "ecs_dump.ascii"

#define ECS_CMD_OUTFILE_NAME_DEFAULT                     "output.ecs"

#define ECS_CMD_POST_CASE_DEFAULT                        "preprocess"
#define ECS_CMD_POST_DIR_ENS_EXT                           ".ensight"


/*----------------------------------------------------------------------------
 * Dfinition des mots-cles pour les options de la ligne de commande
 *----------------------------------------------------------------------------*/

#define ECS_CMD_KEY_MESH_GRP_SECTION                        "section"
#define ECS_CMD_KEY_MESH_GRP_ZONE                              "zone"


/*----------------------------------------------------------------------------
 *  Dfinition des options de la ligne de commande
 *----------------------------------------------------------------------------*/

#define ECS_CMD_OPTION_CASE                                   "-case"

#define ECS_CMD_OPTION_CWD                                     "-cwd"
#define ECS_CMD_OPTION_DUMP                                   "-dump"
#define ECS_CMD_OPTION_NULL_COMM                          "-sim-comm"
#define ECS_CMD_OPTION_NULL_COMM_1                              "-sc"
#define ECS_CMD_OPTION_FMT_MESH_FILE                        "-format"
#define ECS_CMD_OPTION_NUM_MESH                                "-num"
#define ECS_CMD_OPTION_GRP_CEL_MESH                        "-grp-cel"
#define ECS_CMD_OPTION_GRP_FAC_MESH                        "-grp-fac"

#define ECS_CMD_OPTION_FAC_COLOR                             "-color"
#define ECS_CMD_OPTION_FAC_GROUP                             "-group"
#define ECS_CMD_OPTION_INVSEL                               "-invsel"

#define ECS_CMD_OPTION_HELP                                   "-help"
#define ECS_CMD_OPTION_HELP_1                                    "-h"
#define ECS_CMD_OPTION_INPUT_FILE                               "-in"
#define ECS_CMD_OPTION_INPUT_FILE_1                              "-i"

#if defined(HAVE_CGNS)
#define ECS_CMD_OPTION_POST_CGNS                              "-cgns"
#endif /* HAVE_CGNS */
#define ECS_CMD_OPTION_POST_ENS                            "-ensight"
#define ECS_CMD_OPTION_POST_ENS_1                              "-ens"
#if defined(HAVE_MED)
#define ECS_CMD_OPTION_POST_MED                                "-med"
#endif /* HAVE_MED */

#define ECS_CMD_OPTION_POST_DEC_POLY                   "-divide-poly"
#define ECS_CMD_OPTION_POST_SINGLE_PART                     "-simple"
#define ECS_CMD_OPTION_POST_TEXT                              "-text"
#define ECS_CMD_OPTION_POST_BIG_ENDIAN                  "-big-endian"
#define ECS_CMD_OPTION_POST_VOLUME                          "-volume"
#define ECS_CMD_OPTION_POST_BORD                          "-boundary"
#define ECS_CMD_OPTION_POST_INFO                              "-info"

#define ECS_CMD_OPTION_MESH_FILE                              "-mesh"
#define ECS_CMD_OPTION_MESH_FILE_1                               "-m"
#define ECS_CMD_OPTION_ORIENT_CORREC                      "-reorient"
#define ECS_CMD_OPTION_OUTPUT_FILE                             "-out"
#define ECS_CMD_OPTION_OUTPUT_FILE_1                             "-o"

#define ECS_CMD_OPTION_RC                                     "-join"
#define ECS_CMD_OPTION_RC_2                                      "-j"
#define ECS_CMD_OPTION_RC_FRACTION_DIST                   "-fraction"
#define ECS_CMD_OPTION_RC_EPSILON_PLAN                       "-plane"
#define ECS_CMD_OPTION_RC_SEMI_CONFORME                  "-semi-conf"

#define ECS_CMD_OPTION_PERIO                              "-periodic"
#define ECS_CMD_OPTION_PERIO_2                               "-perio"
#define ECS_CMD_OPTION_PERIO_TRANS                           "-trans"
#define ECS_CMD_OPTION_PERIO_ROTA                             "-rota"
#define ECS_CMD_OPTION_PERIO_ANGLE                           "-angle"
#define ECS_CMD_OPTION_PERIO_DIR                               "-dir"
#define ECS_CMD_OPTION_PERIO_PTINV                           "-invpt"
#define ECS_CMD_OPTION_PERIO_MAT                            "-matrix"

#define ECS_CMD_OPTION_SELECT_FAC_INT                     "-int-face"

#define ECS_CMD_OPTION_VERSION                             "-version"


/*============================================================================
 *                       Dfinition des structures
 *============================================================================*/

struct _ecs_cmd_post_t {

  ecs_bool_t          dec_poly ;       /* dcoupage des polygones */
  ecs_bool_t          simple ;         /* pas de subdivision des "parts"
                                          (EnSight, CGNS) */
  ecs_bool_t          text ;           /* version texte (EnSight) */
  ecs_bool_t          big_endian ;     /* binaire big-endian (EnSight) */

  ecs_bool_t          volume ;         /* sortie du volume */
  ecs_bool_t          bord ;           /* sortie des faces de bord */
  ecs_bool_t          info ;           /* sortie des maillages d'information */

} ;


struct _ecs_cmd_rc_t {

  ecs_param_rc_t   param_rc ;       /* paramtres de tolrance */
  ecs_select_fac_t select_fac_rc ;  /* faces  slectionner */

} ;


struct _ecs_cmd_t {

  char                   *nom_cas ;
  ecs_int_t               nbr_dump ;
  ecs_int_t              *liste_num_maillage ;
  ecs_pre_format_t       *liste_fmt_maillage ;
  ecs_bool_t             *liste_grp_maillage ;
  ecs_tab_char_t          liste_fic_maillage ;

#if defined(HAVE_CGNS)
  ecs_cmd_post_t         *post_cgns ;
#endif /* HAVE_CGNS */
  ecs_cmd_post_t         *post_ens ;
#if defined(HAVE_MED)
  ecs_cmd_post_t         *post_med ;
#endif /* HAVE_MED */

  ecs_bool_t              bool_correct_orient ;

  ecs_bool_t              sim_comm ;

  int                     nbr_cmd_rc ;
  struct _ecs_cmd_rc_t  **liste_cmd_rc ;

  int                     nbr_cmd_perio ;

  ecs_select_fac_t       *cmd_select_fac_int ;

} ;


#endif /* _ECS_CMD_PRIV_H_ */
