/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.ant;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.XMLDefaultHandler;
import org.eclipse.pde.internal.core.builders.SchemaTransformer;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaDescriptor;
import org.eclipse.pde.internal.core.util.HeaderMap;
import org.eclipse.pde.internal.core.util.SAXParserWrapper;
import org.xml.sax.helpers.DefaultHandler;

public class ConvertSchemaToHTML
extends Task {
    private SchemaTransformer fTransformer = new SchemaTransformer();
    private String manifest;
    private String destination;
    private URL cssURL;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (!this.validateDestination()) {
            return;
        }
        IPluginModelBase model = this.readManifestFile();
        if (model == null) {
            return;
        }
        String pluginID = model.getPluginBase().getId();
        if (pluginID == null) {
            pluginID = this.getPluginID();
        }
        IPluginExtensionPoint[] extPoints = model.getPluginBase().getExtensionPoints();
        int i = 0;
        while (i < extPoints.length) {
            block18: {
                String schemaLocation = extPoints[i].getSchema();
                PrintWriter out = null;
                if (schemaLocation != null && !schemaLocation.equals("")) {
                    Object var16_17;
                    Schema schema = null;
                    SAXParserWrapper parser = null;
                    try {
                        block17: {
                            try {
                                File directory;
                                parser = new SAXParserWrapper();
                                File schemaFile = new File(model.getInstallLocation(), schemaLocation);
                                XMLDefaultHandler handler = new XMLDefaultHandler();
                                parser.parse(schemaFile, (DefaultHandler)handler);
                                URL url = schemaFile.toURL();
                                SchemaDescriptor desc = new SchemaDescriptor(extPoints[i].getFullId(), url);
                                schema = (Schema)desc.getSchema(false);
                                File file = directory = new Path(this.destination).isAbsolute() ? new File(this.destination) : new File(this.getProject().getBaseDir(), this.destination);
                                if (!(directory.exists() && directory.isDirectory() || directory.mkdirs())) {
                                    schema.dispose();
                                    var16_17 = null;
                                    if (out != null) {
                                        out.close();
                                    }
                                    if (schema != null) {
                                        schema.dispose();
                                    }
                                    return;
                                }
                                String id = extPoints[i].getId();
                                if (id.indexOf(46) == -1) {
                                    id = String.valueOf(pluginID) + "." + id;
                                }
                                File file2 = new File(directory, String.valueOf(id.replace('.', '_')) + ".html");
                                out = new PrintWriter((Writer)new FileWriter(file2), true);
                                this.fTransformer.transform((ISchema)schema, out, this.cssURL, (byte)1);
                            }
                            catch (Exception e) {
                                if (e.getMessage() == null) break block17;
                                System.out.println(e.getMessage());
                            }
                        }
                        var16_17 = null;
                        if (out != null) {
                            out.close();
                        }
                        if (schema == null) break block18;
                    }
                    catch (Throwable throwable) {
                        var16_17 = null;
                        if (out != null) {
                            out.close();
                        }
                        if (schema != null) {
                            schema.dispose();
                        }
                        throw throwable;
                    }
                    schema.dispose();
                }
            }
            ++i;
        }
    }

    private String getPluginID() {
        File file = new Path(this.manifest).isAbsolute() ? new File(this.manifest) : new File(this.getProject().getBaseDir(), this.manifest);
        File OSGiFile = new File(file.getParentFile(), "META-INF/MANIFEST.MF");
        if (OSGiFile.exists()) {
            String value;
            block5: {
                Map headers = ManifestElement.parseBundleManifest((InputStream)new FileInputStream(OSGiFile), (Map)new HeaderMap());
                value = headers.get("Bundle-SymbolicName").toString();
                if (value != null) break block5;
                return null;
            }
            try {
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)value);
                if (elements.length > 0) {
                    return elements[0].getValue();
                }
            }
            catch (Exception e1) {
                System.out.print(e1.getMessage());
            }
        }
        return null;
    }

    public void setManifest(String manifest) {
        this.manifest = manifest;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public URL getCSSURL() {
        return this.cssURL;
    }

    public void setCSSURL(String url) {
        try {
            this.cssURL = new URL(url);
        }
        catch (MalformedURLException e) {
            PDECore.logException((Throwable)e);
        }
    }

    public void setCSSURL(URL url) {
        this.cssURL = url;
    }

    private IPluginModelBase readManifestFile() {
        ExternalFragmentModel model;
        block10: {
            BufferedInputStream stream;
            File file;
            block9: {
                if (this.manifest == null) {
                    System.out.println(NLS.bind((String)PDECoreMessages.Builders_Convert_missingAttribute, (Object)"manifest"));
                    return null;
                }
                file = new Path(this.manifest).isAbsolute() ? new File(this.manifest) : new File(this.getProject().getBaseDir(), this.manifest);
                stream = null;
                try {
                    stream = new BufferedInputStream(new FileInputStream(file));
                }
                catch (Exception e) {
                    if (e.getMessage() != null) {
                        System.out.println(e.getMessage());
                    }
                    return null;
                }
                model = null;
                if (file.getName().toLowerCase(Locale.ENGLISH).equals("fragment.xml")) {
                    model = new ExternalFragmentModel();
                    break block9;
                }
                if (file.getName().toLowerCase(Locale.ENGLISH).equals("plugin.xml")) {
                    model = new ExternalPluginModel();
                    break block9;
                }
                System.out.println(NLS.bind((String)PDECoreMessages.Builders_Convert_illegalValue, (Object)"manifest"));
                return null;
            }
            try {
                String parentPath = file.getParentFile().getAbsolutePath();
                model.setInstallLocation(parentPath);
                model.load((InputStream)stream, false);
                ((InputStream)stream).close();
            }
            catch (Exception e) {
                if (e.getMessage() == null) break block10;
                System.out.println(e.getMessage());
            }
        }
        return model;
    }

    private boolean validateDestination() {
        boolean valid = true;
        if (this.destination == null) {
            System.out.println(NLS.bind((String)PDECoreMessages.Builders_Convert_missingAttribute, (Object)"destination"));
            valid = false;
        } else if (!new Path(this.destination).isValidPath(this.destination)) {
            System.out.println(NLS.bind((String)PDECoreMessages.Builders_Convert_illegalValue, (Object)"destination"));
            valid = false;
        }
        return valid;
    }
}

