#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Author : Steven Harper
# License : GNU GENERAL PUBLIC LICENSE V2
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
import pygtk
pygtk.require('2.0')
import gtk
import commands
import time
import os
import sys
import warnings
import random
from threading import Thread
import EasyCryptConfig
import EasyCryptPopupMenu
import gettext
import popen2
import optparse

APP_PATH="/usr/share/applications/easycrypt.desktop"
#WEBSITE="https://launchpad.net/easycrypt"
WEBSITE="http://www.squeezedonkey.com/wiki/linux/index.php?title=EasyCrypt"
CMD_TEST_TRUECRYPT="which truecrypt"
CMD_TEST_TRUECRYPT_VERSION_43a="truecrypt --version"
CMD_TEST_TRUECRYPT_VERSION_6x="truecrypt -t --version"

BASIC_SUDO_COMMAND = "sudo"
URL_TRUECRYPT_DOWNLOAD="http://www.truecrypt.org/downloads.php"

# Size presets
SIZE_PRESETS = {1: "690",2: "4000",3: "8000"}
SIZE_LABELS = ["CD (690MB)","DVD5 (4000MB)","DVD9 (8000MB)"]

DEBUG = False
SPACE = 0


# normal debug function
# just call debug(your text)
def debug(text, add = False, remove = False):
	global DEBUG
	global SPACE
	if DEBUG:
		if remove and SPACE >= 3:
			SPACE = SPACE - 3
		if SPACE == 0:
			print text
		else:
			print ' '*(SPACE+1) + '|--' + text
		if add:
			SPACE = SPACE + 3

#debug for beginning of function
def debug_begin(text):
	debug('[**]['+text+']', True, False)
#debug for end of function
def debug_end(text):
	debug("[**][end "+text+']', False, True)

	

class TrueCryptCommandRunner4_3a(Thread):
	def __init__(self, command, cryptLocation, mountPoint, pw, pw2, keyfile, keyfile2, job):
		Thread.__init__(self)
		self.theCommand = command
		self.theCryptLocation = cryptLocation
		self.theMountPoint = mountPoint
		self.thePw = pw
		self.thePw2 = pw2
		self.theKeyfile = keyfile
		self.theKeyfile2 = keyfile2
		self.theJob = job
		self.doneRunning = False
	def run(self):
		print "TrueCryptCommandRunner4_3a job:",self.theJob,self.theCommand
		self.returnVal = ""
		if self.theJob == "create":
			fout, fin, ferr = os.popen3(self.theCommand)
			fout.write(self.thePw+"\n")
			fout.flush()
			fout.write(self.thePw+"\n")
			fout.flush()
			fout.write(self.theKeyfile+"\n")
			fout.flush()
			if len(self.theKeyfile) > 0:
				fout.write("\n")
				fout.flush()
			errStr = ferr.readline()
			print "err:",errStr
			if errStr.find("truecrypt: Password must be composed only of US-ASCII") > -1 :
				self.doneRunning = True
				self.returnVal = errStr
				return
			line = fin.readline()
			lastLine = ""
			while len(line) > 0 and len(lastLine) > 0: 
				lastLine = line
				line = fin.readline()
			self.returnVal = ferr.readline()
			ferr.close()
			fin.close()
			fout.close()
					
		if self.theJob == "open":
			mounts = commands.getoutput("gksudo \"echo pie\"")
			fin, fout = popen2.popen2(self.theCommand)
			fout.write(self.theCryptLocation+"\n")
			fout.flush()
			fout.write(self.theMountPoint+"\n")
			fout.flush()
			fout.write("n\n")
			fout.flush()
			fout.write(self.theKeyfile+"\n")
			fout.flush()
			if len(self.theKeyfile) > 0:
				fout.write("\n")
				fout.flush()
			fout.write(self.thePw+"\n")
			fout.flush()
			fin.readlines()
			fin.close()
			fout.close()
			
		if self.theJob == "change":
			fout, fin, ferr = os.popen3(self.theCommand)
			
			fout.write(self.theKeyfile+"\n")
			fout.flush()
			if len(self.theKeyfile) > 0:
				fout.write("\n")
				fout.flush()
			fout.write(self.thePw+"\n")
			fout.flush()

			fout.write(self.theKeyfile2+"\n")
			fout.flush()
			if len(self.theKeyfile2) > 0:
				fout.write("\n")
				fout.flush()
			
			fout.write(self.thePw2+"\n")
			fout.flush()
			fout.write(self.thePw2+"\n")
			fout.flush()
			self.returnVal = ferr.readline()
			ferr.close;
			fin.close()
			fout.close()
			
		self.doneRunning = True

class TrueCryptCommandRunner5_1(Thread):
	def __init__(self, command, cryptLocation, mountPoint, pw, pw2, keyfile, keyfile2, job):
		Thread.__init__(self)
		self.theCommand = command
		self.theCryptLocation = cryptLocation
		self.theMountPoint = mountPoint
		self.thePw = pw
		self.thePw2 = pw2
		self.theKeyfile = keyfile
		self.theKeyfile2 = keyfile2
		self.theJob = job
		self.doneRunning = False
	def run(self):
		print "TrueCryptCommandRunner5_1 job:",self.theJob,self.theCommand
		self.returnVal = ""
		if self.theJob == "create":
			fout, fin, ferr = os.popen3(self.theCommand)
			fout.write("1\n")
			fout.flush()
			fout.write(self.thePw+"\n")
			fout.flush()
			if len(self.thePw) < 12:
				fout.write("y\n")
				fout.flush()
			fout.write(self.thePw+"\n")
			fout.flush()
			fout.write(self.theKeyfile+"\n")
			fout.flush()
			if len(self.theKeyfile) > 0:
				fout.write("\n")
				fout.flush()
			errStr = ferr.readline()
			print "err:",errStr
			if errStr.find("Password must contain only ASCII characters") > -1 :
				self.doneRunning = True
				self.returnVal = errStr
				return
			line = fin.readline()
			lastLine = ""
			while len(line) > 0 and len(lastLine) > 0: 
				lastLine = line
				line = fin.readline()
			self.returnVal = ferr.readline()
			ferr.close()
			fin.close()
			fout.close()
					
		if self.theJob == "open":
			mounts = commands.getoutput("gksudo \"echo pie\"")
			fout, fin, ferr = os.popen3(self.theCommand)
			fout.write(self.theCryptLocation+"\n")
			fout.flush()
			if len(self.theMountPoint) >0:
				fout.write(self.theMountPoint+"\n")
				fout.flush()
			fout.write(self.thePw+"\n")
			fout.flush()
			fout.write(self.theKeyfile+"\n")
			fout.flush()
			if len(self.theKeyfile) > 0:
				fout.write("\n")
				fout.flush()
			fout.write("n\n")
			fout.flush()
			errStr = fin.readline()
			print "read:",errStr
			errStr = fin.readline()
			print "read:",errStr
			if errStr.find("Incorrect password"):
				self.doneRunning = True
				self.returnVal = errStr
				return
			fin.readlines()
			ferr.close()
			fin.close()
			fout.close()
			
		if self.theJob == "change":
			fout, fin, ferr = os.popen3(self.theCommand)
			
			fout.write(self.thePw+"\n")
			fout.flush()
			fout.write(self.thePw2+"\n")
			fout.flush()
			if len(self.thePw2) < 20:
				fout.write("y\n")
				fout.flush()
			fout.write(self.thePw2+"\n")
			fout.flush()
			
			fout.write(self.theKeyfile2+"\n")
			fout.flush()
			if len(self.theKeyfile2) > 0:
				fout.write("\n")
				fout.flush()

			self.returnVal = ferr.readline()
			ferr.close;
			fin.close()
			fout.close()
			
		self.doneRunning = True
		

class ThreadedCommandRunner(Thread):
	def __init__ (self, command):
		Thread.__init__(self)
		self.theCommand = command
		self.doneRunning = False
	def run(self):
		debug_begin("ThreadedCommandRunner job: " + self.theCommand)
		commandOutput = commands.getoutput(self.theCommand)
		self.doneRunning = True
		debug_end("ThreadedCommandRunner job: " + self.theCommand)

class SizeOfCrypt(Thread):
	def __init__ (self, EasyCryptInstance):
		Thread.__init__(self)
		self.returnString = 0
		self.done = False;
		self.EasyCryptInstance = EasyCryptInstance
	def run(self):
		cryptLocation = self.EasyCryptInstance.selectedCrypt
		debug_begin("SizeOfCrypt Started " + cryptLocation)
		while (not self.done):
			try :
				statResult = os.stat(cryptLocation)
				self.returnString = statResult[6]
			#raise OSError if file does not exist
			except OSError:
				pass
			time.sleep(0.1)
		debug_end("SizeOfCrypt Started " + cryptLocation)

def encodeFilePath(passedString):
	encodedString = passedString.replace(' ', '\\ ')
	return encodedString

def decodeFilePath(passedString):
	decodedString = passedString.replace('\\ ', ' ')
	return decodedString

def intToStr(passedInt):
	theInt = {'int' : passedInt}
	theIntStr = "%(int).0f" %theInt
	return theIntStr

class EasyCrypt:
	
	root=os.getcwd()
	LANGSXML_PATH = os.path.join(root, "data/langs.xml")
	ICON_PATH_WINDOW = os.path.join(root, "icons/easycrypt.png")
	ICON_PATH_TRAY = os.path.join(root, "icons/easycrypt_tray.png")
	IMAGE_ABOUT_SPLASH = os.path.join(root, "icons/about_splash.png")
	IMAGE_WELCOME_SPLASH = os.path.join(root, "icons/easycrypt.png")
	US_FULLPATH=__file__
	
	CRYPT_MOUNT_POINT = "/media/"
	CRYPT_MOUNT_POINT_STD = "crypt"
	
	transLoc = os.path.join(root, "locale")
	try:
		t = gettext.translation("easycrypt", transLoc)
	except :
		print "failed to load localised text, defaulting to English (en)"
		t = gettext.translation("easycrypt", transLoc, languages=['en'])

	_ = t.ugettext
	t.install()
	

	def __init__(self):
		debug_begin('function __init__ EasyCrypt')
		self.version = "0.2.3.2"
		debug("Easy Crypt "+self.version+" ("+time.strftime("%Y/%m/%d %H:%M:%S", time.localtime())+")")
		debug("root is " + self.root)
		self.isExpert = False
		self.afterSelectCryptDoAction = ""
		self.selectedKeyFile = ""
		self.needsOpenAsUser = True
		# count used for mountpoints in expert mode, such as  cryptname-1, cryptname-2 ..
		self.some_count = 0
		
		self.home = os.path.expanduser( "~/" )
		debug("home is " + self.home)
		self.default_crypt = os.path.join(self.home,".easycrypt-crypt")
		self.default_mount = os.path.join(self.CRYPT_MOUNT_POINT, self.CRYPT_MOUNT_POINT_STD)

		configPath = os.path.join(self.home,".config/easycrypt.conf")
		
		self.hasTrueCryptV4_3a = False
		self.hasTrueCryptV5_0 = False
		self.hasTrueCryptV5_1 = False
		self.hasTrueCryptV5_X = False
		self.hasTrueCryptV6_1 = False
		self.hasTrueCryptV6_X = False
		self.truecrypt_high_version = ""
		
		needToSeeWelcome = False
		if not os.path.exists(decodeFilePath(configPath)):
			debug("first run show them the welcome")
			needToSeeWelcome = True
		
		# Load or default the config
		self.easyCryptConfig = EasyCryptConfig.EasyCryptConfig(configPath)
		
		self.crypt_path = self.easyCryptConfig.getOption("crypt")
		self.crypt_rand = self.easyCryptConfig.getOption("crypt-gen-random")
		self.setting_mode = self.easyCryptConfig.getOption("mode")
		if self.setting_mode == _("expert"):
			self.isExpert = True
		
		# self.currentCrypts is now a dictionnary :
		# keys are filenames, values are mountpoints
		self.currentCrypts = {}
		# selectedCrypt contains the name of the currently selected crypt
		# it is a key in currentCrypts
		self.selectedCrypt = ""
		
		if not self.isExpert :
			#first time we launch EasyCrypt, we have no crypt, so don't assume we have one here
			#next time, we may have deleted default crypt or default mount
			if os.path.isfile(self.default_crypt) and os.path.exists(decodeFilePath(self.default_mount)) :
				self.currentCrypts[self.default_crypt] = self.default_mount
				self.selectedCrypt = self.default_crypt
				
		self.sudo_command = "gksudo"
		sudo = commands.getoutput("which gksudo")
		if len(sudo) > 0:
			self.sudo_command = "gksudo"
		else :
			sudo = commands.getoutput("which kdesud")
			if len(sudo) > 0:
				self.sudo_command = "kdesud"
				
		debug("sudo command will be " + self.sudo_command)
		
		# Create the status icon object
		self.status_icon = gtk.StatusIcon()
		self.updateTrayIcon()
		self.status_icon.connect('popup-menu', self.trayIconClicked)
		self.status_icon.connect('activate', self.trayIconLeftClicked) 

		self.popup_menu = EasyCryptPopupMenu.EasyCryptPopupMenu(self)
		self.status_icon.set_visible(True)
		
		if (needToSeeWelcome):
			self.showWelcomeWindow()
			
		debug_end('function __init__ EasyCrypt')
	
	def updateTrayIcon(self):
		debug_begin('function updateTrayIcon')
		trayText = _("Easy Crypt")
		
		if self.isExpert :
			#if we have keys
			if len(self.currentCrypts) > 0 :
			#iterate over dictionnary
				for k in self.currentCrypts.items():
					#k is in the form (crypt_name, crypt_mountpoint)
					trayText = trayText + "\n" + k[0] + " : " + k[1] 
			# otherelse,  no crypt opened
			else :
				trayText = trayText + "\n" + _("No Crypts Open")
				
		else :
			if self.checkOpened() :
				trayText = trayText + "\n" + _("Crypt opened")
			else :
				trayText = trayText + "\n" + _("Crypt not opened")
		
		self.status_icon.set_tooltip(trayText)
		self.status_icon.set_from_file( self.ICON_PATH_TRAY)
		debug_end('function updateTrayIcon')
	
	def chooseNewCryptLocation(self):
		debug_begin('function chooseNewCryptLocation')
		dialog = gtk.FileChooserDialog(_("New Crypt Location"),None,gtk.FILE_CHOOSER_ACTION_SAVE,(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))
		dialog.set_default_response(gtk.RESPONSE_OK)
		dialog.set_show_hidden(True)
		dialog.set_do_overwrite_confirmation(True)
		dialog.set_current_folder(self.home)
		response = dialog.run()
		if response == gtk.RESPONSE_OK:
			debug(dialog.get_filename() + ' selected')
			
			self.workingFolder = dialog.get_current_folder()
			
			cryptName = encodeFilePath(dialog.get_filename())
			self.selectedCrypt = cryptName
			cryptMount = self.calculateMountPoint()
			self.currentCrypts[cryptName] = cryptMount
			

		elif response == gtk.RESPONSE_CANCEL:
			debug('Closed, no files selected')
			self.selectedCrypt = ""
		dialog.destroy()
		debug_end('function chooseNewCryptLocation')
		
	def selectCurrentCryptLocation(self):
		debug_begin('function selectCurrentCryptLocation')
		dialog = gtk.FileChooserDialog(_("Open Existing Crypt"),None,gtk.FILE_CHOOSER_ACTION_OPEN,(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))
		dialog.set_default_response(gtk.RESPONSE_OK)
		dialog.set_show_hidden(True)
		dialog.set_current_folder(self.home)
		#dialog.set_do_overwrite_confirmation(True)
		response = dialog.run()
		if response == gtk.RESPONSE_OK:
			debug(dialog.get_filename() + ' selected')

			cryptName = encodeFilePath(dialog.get_filename())
			self.selectedCrypt = cryptName
			cryptMount = self.calculateMountPoint()
			self.currentCrypts[cryptName] = cryptMount
			

		elif response == gtk.RESPONSE_CANCEL:
			debug('Closed, no files selected')
			self.selectedCrypt = ""

		dialog.destroy()
		debug_end('function selectCurrentCryptLocation')

	def clearKeyFile(self, event, type):
		debug_begin('function clearKeyFile')
		if type == "new":
			self.selectedKeyFileNew = ""
			self.textbox_select_keyfile_new.set_text(self.selectedKeyFileNew)
		else:
			self.selectedKeyFile = ""
			self.textbox_select_keyfile.set_text(self.selectedKeyFile)
		debug_end('function clearKeyFile')

	def selectKeyFile(self, event, type):
		debug_begin('function selectKeyFile')
		dialog = gtk.FileChooserDialog(_("Select Keyfile"),None,gtk.FILE_CHOOSER_ACTION_OPEN,(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))
		dialog.set_default_response(gtk.RESPONSE_OK)
		dialog.set_show_hidden(False)
		dialog.set_current_folder(self.home)
		#dialog.set_do_overwrite_confirmation(True)
		response = dialog.run()
		if response == gtk.RESPONSE_OK:
			debug(dialog.get_filename() + ' selected')
			if type == "new":
				self.selectedKeyFileNew = dialog.get_filename()
				self.textbox_select_keyfile_new.set_text(self.selectedKeyFileNew)
			else:
				self.selectedKeyFile = dialog.get_filename()
				self.textbox_select_keyfile.set_text(self.selectedKeyFile)
		elif response == gtk.RESPONSE_CANCEL:
			debug('Closed, no file selected')
			if type == "new":
				self.selectedKeyFileNew = ""
			else :
				self.selectedKeyFile = ""

		dialog.destroy()
		debug_end('function selectKeyFile')

	def fileTypeAtLocation(self,workingFolder):
		debug_begin('function fileTypeAtLocation')
		mounts = commands.getoutput("cat /proc/mounts")
		lines = mounts.splitlines(False)
		highest = -1
		detectedType = "none"
		workingFolder = workingFolder+"/"
		for v in lines:
			elements = v.split()
			if len(elements) > 2:
				location = elements[1] + "/"
				type = elements[2]
				match = workingFolder.find(location)
				if match != -1:
					match = match+len(location)
				#print workingFolder,location,match
				if match > highest and type != "rootfs":
					highest = match
					detectedType = type
		debug_end('function fileTypeAtLocation')
		return detectedType
					

	def howMuchSpaceInKb(self):
		debug_begin('function howMuchSpaceInKb')
		detectedType = self.fileTypeAtLocation(self.workingFolder)
		capMax = False
		if detectedType == "vfat":
			debug("max size is 2000")
			capMax = True

		debug("df -Pk "+self.workingFolder+" | tail -1 | awk {'print $4'}")
		checkAmountLeft = commands.getoutput("df -Pk "+self.workingFolder+" | tail -1 | awk {'print $4'}")
		debug("size left " + checkAmountLeft)

		if capMax:
			cap = 2000 * 1024
			if int(checkAmountLeft) > cap:
				debug("capped")
				return cap
			else :
				debug("dont need to cap")
		
		debug_end('function howMuchSpaceInKb')
		return int(checkAmountLeft)


	def checkWeAreAlone(self):
		debug_begin('function checkWeAreAlone')
		debug("checking : ps -ef | grep \"pyt[h]on "+self.US_FULLPATH+"\"")
		checkAnother = commands.getoutput("ps -ef | grep \"pyt[h]on "+self.US_FULLPATH+"\"")
		lines = checkAnother.splitlines(False)
		if len(lines) > 1:
			print "We are not alone, another trycrypt appears to be running!\n" + checkAnother
			debug_end('function checkWeAreAlone')
			return True 
		debug_end('function checkWeAreAlone')
		return False
	
	def getTextForCommandChange(self, crypt_rand, cryptLocation):
		debug_begin('function getTextForCommandChange')
		if self.hasTrueCryptV4_3a:
			debug_end('function getTextForCommandChange')
			return "truecrypt --o --random-source "+crypt_rand+" -C " +cryptLocation				
		else:
			if self.hasTrueCryptV5_1 or self.hasTrueCryptV5_X or self.hasTrueCryptV6_1 or self.hasTrueCryptV6_X:
				debug_end('function getTextForCommandChange')
				return "truecrypt -t --random-source="+crypt_rand+" -C " +cryptLocation
		debug_end('function getTextForCommandChange')
		return ""
	
	def getTextForCommandCreate(self, encType,hashType,fsType,sizeInMB,targetSizeInBytes,crypt_rand,cryptLocation) :
		debug_begin('function getTextForCommandCreate')
		if self.hasTrueCryptV4_3a:
			debug_end('function getTextForCommandCreate')
			return "truecrypt --disable-progress --encryption "+encType+" --hash "+hashType+" --filesystem "+fsType+" --size "+sizeInMB+" --type normal --random-source "+crypt_rand+" --o -c "+cryptLocation				
		else:
			if self.hasTrueCryptV5_1 or self.hasTrueCryptV5_X or self.hasTrueCryptV6_1 or self.hasTrueCryptV6_X:
				debug_end('function getTextForCommandCreate')
				return "truecrypt -t --encryption="+encType+" --hash="+hashType+" --filesystem="+fsType+" --size="+targetSizeInBytes+" --random-source="+crypt_rand+" -c "+cryptLocation	
			else:
				debug_end('function getTextForCommandCreate')
				return "truecrypt -t --encryption="+encType+" --hash="+hashType+" --filesystem="+fsType+" --size="+targetSizeInBytes+" --random-source="+crypt_rand+" -c "+cryptLocation							
		debug_end('function getTextForCommandCreate')
		return ""
	
	def getTextForCommandClose(self):
		debug_begin('function getTextForCommandClose')
		if self.hasTrueCryptV4_3a:
			debug_end('function getTextForCommandClose')
			return "truecrypt -d"				
		else:
			if self.hasTrueCryptV5_1 or self.hasTrueCryptV5_X or self.hasTrueCryptV6_1 or self.hasTrueCryptV6_X:
				debug_end('function getTextForCommandClose')
				return "truecrypt -t -d"
			else:
				debug_end('function getTextForCommandClose')
				return "truecrypt -t -d"
		debug_end('function getTextForCommandClose')
		return ""
	
	def getTextForCommandListOpened(self):
		debug_begin('function getTextForCommandListOpened')
		if self.hasTrueCryptV4_3a:
			debug_end('function getTextForCommandListOpened')
			return self.sudo_command+" \"truecrypt -l\""				
		else:
			if self.hasTrueCryptV5_1 or self.hasTrueCryptV5_X or self.hasTrueCryptV6_1 or self.hasTrueCryptV6_X:
				debug_end('function getTextForCommandListOpened')
				return "truecrypt -t -l"
			else:
				debug_end('function getTextForCommandListOpened')
				return "truecrypt -t -l"
		debug_end('function getTextForCommandListOpened')
		return ""
	
	def getTextForCommandOpen(self, asUser, fstype):
		debug_begin('function getTextForCommandOpen')
		if self.hasTrueCryptV4_3a:
			if asUser:
				debug_end('function getTextForCommandOpen')
				return "truecrypt -u -i"
			else :
				debug_end('function getTextForCommandOpen')
				return "truecrypt -i"				
		else:
			if self.hasTrueCryptV5_1 or self.hasTrueCryptV5_X or self.hasTrueCryptV6_1 or self.hasTrueCryptV6_X:
				if asUser:
					debug_end('function getTextForCommandOpen')
					return "truecrypt -t --mount"
				else:
					debug_end('function getTextForCommandOpen')
					return "truecrypt -t --mount --filesystem="+fstype
			else:
				if asUser:
					debug_end('function getTextForCommandOpen')
					return "truecrypt -t --mount"
				else:
					debug_end('function getTextForCommandOpen')
					return "truecrypt -t --mount --filesystem="+fstype
		debug_end('function getTextForCommandOpen')
		return ""
	
	def determinTruecryptVersion(self):
		debug_begin('function determinTruecryptVersion')
		self.hasTrueCryptV4_3a = False
		self.hasTrueCryptV5_0 = False
		self.hasTrueCryptV5_1 = False
		self.hasTrueCryptV5_X = False
		self.hasTrueCryptV6_1 = False
		self.truecrypt_high_version = ""
		outputString = commands.getoutput(CMD_TEST_TRUECRYPT_VERSION_6x)
		if outputString == "TrueCrypt 6.1" :
			debug("found 6.1")
			debug("detected 6.1")
			self.hasTrueCryptV6_1 = True
		else :
			if outputString == "TrueCrypt 6.0a" :
				debug("found 6.0a")
				debug("detected 6.0a")
				self.hasTrueCryptV6_1 = True
			else :
				if outputString.find("TrueCrypt 6.1") > -1:
					debug("found 6.X")
					self.hasTrueCryptV6_X = True
				else :
					if outputString == "TrueCrypt 5.1" :
						debug("found 5.1")
						debug("detected 5.1")
						self.hasTrueCryptV5_1 = True
					else :
						if outputString == "TrueCrypt 5.0" :
							debug("detected 5.0")
							self.hasTrueCryptV5_0 = True
						else :
							if outputString.find("TrueCrypt 5.") > -1 :
								debug("detected 5.x")
								self.hasTrueCryptV5_X = True
								self.truecrypt_high_version = outputString.replace("TrueCrypt ","",1)
							else:
								outputString = commands.getoutput(CMD_TEST_TRUECRYPT_VERSION_43a)
								lines = outputString.splitlines(False)
								if len(lines) > 0 :
									debug("got enough lines")
									if lines[0] == "truecrypt 4.3a" :
										debug("detected 4.3")
										self.hasTrueCryptV4_3a = True
		debug_end('function determinTruecryptVersion')
	
	def lookForTruecrypt(self):
		debug_begin('function lookForTruecrypt')
		debug("looking for truecrypt")
		outputString = commands.getoutput(CMD_TEST_TRUECRYPT)
		if len(outputString) == 0:
			debug("no truecrypt")
			dialog = gtk.MessageDialog( None, gtk.DIALOG_MODAL, gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO, _("You don't seem to have Truecrypt installed\n\nCan I please open a Browser for you to get it?") + '\n' + URL_TRUECRYPT_DOWNLOAD)
			dialog.set_title(_("TrueCrypt not Installed"))
			dialog.width, dialog.height = dialog.get_size()
			icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
			gtk.window_set_default_icon_list( (icon) )
			ret = dialog.run()
			if ret==gtk.RESPONSE_YES:
				debug("they clicked yes")
				self.gotourl(URL_TRUECRYPT_DOWNLOAD)
			else:
				debug("they clicked no")
			dialog.destroy()
			debug_end('function lookForTruecrypt')
			return False
		else :
			debug("found truecrypt")
			self.determinTruecryptVersion()
			if self.hasTrueCryptV5_0:
				debug("bad truecrypt")
				dialog = gtk.MessageDialog( None, gtk.DIALOG_MODAL, gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO, _("The version of TrueCrypt you have is not Compatible\n\nCan I please open a Browser for you so you can update TrueCrypt?\n\nMay I suggest you get either 4.3a or 5.1\n") + '\n' + URL_TRUECRYPT_DOWNLOAD)
				dialog.set_title(_("TrueCrypt version not Compatible"))
				dialog.width, dialog.height = dialog.get_size()
				icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
				gtk.window_set_default_icon_list( (icon) )
				ret = dialog.run()
				if ret==gtk.RESPONSE_YES:
					debug("they clicked yes")
					self.gotourl(URL_TRUECRYPT_DOWNLOAD)
				else:
					debug("they clicked no")
				dialog.destroy()
				debug_end('function lookForTruecrypt')
				return False
			debug_end('function lookForTruecrypt')
			return True
	
	def checkOpened(self):
		debug_begin('function checkOpened')
		detectMounted = commands.getoutput(self.getTextForCommandListOpened())
		cryptLocation = decodeFilePath(self.selectedCrypt)
		lines = detectMounted.splitlines(False)
		if self.hasTrueCryptV4_3a:
			for v in lines:
				debug("current mount " + v)
				location = v.find(decodeFilePath(cryptLocation))
				if location > -1:
					debug("found at " + str(location))
					if location + len(decodeFilePath(cryptLocation)) == len(v):
						debug("hurrah")
						debug_end('function checkOpened')
						return True
					else:
						debug("red herring")
		else:
			if self.hasTrueCryptV5_1 or self.hasTrueCryptV5_X or self.hasTrueCryptV6_1 or self.hasTrueCryptV6_X:
				for v in lines:
					debug("current mount " + v)
					location = v.find(decodeFilePath(cryptLocation)+" ")
					if location > -1:
						debug("hurrah")
						debug_end('function checkOpened')
						return True
			else:
				for v in lines:
					debug("current mount " + v)
					location = v.find(decodeFilePath(cryptLocation)+" ")
					if location > -1:
						debug("hurrah")
						debug_end('function checkOpened')
						return True
				
		debug_end('function checkOpened')
		return False
		
	def makeRandom(self):
		debug_begin('function makeRandom')
		debug(commands.getoutput("touch "+self.crypt_rand))
		file = open(self.crypt_rand,"w")
		for i in range(0, 700, 1) :
			file.write(random.choice('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890'))
		file.close()
		debug_end('function makeRandom')
		
	def removeRandom(self):
		debug_begin('function removeRandom')
		try :
			os.unlink(self.crypt_rand)
		# "no such file or directory" raises OSError
		except OSError,e :
			print e.strerror + " : " + e.filename
		debug_end('function removeRandom')

	
	def calculateMountPoint(self):
		debug_begin('function calculateMountPoint')
		
		cryptLocation = self.selectedCrypt
		cryptName = self.CRYPT_MOUNT_POINT_STD
		if self.easyCryptConfig.getOption("use_filename_as_mountname") == "yes":
			bits = os.path.split(cryptLocation)
			cryptName = bits[1]
		else:
			if self.isExpert:
				cryptName = cryptName + "-" + str(self.some_count)
				self.some_count = self.some_count + 1
				
		debug('cryptName : '+cryptName)
		debug('Mount point : '+os.path.join(self.CRYPT_MOUNT_POINT, cryptName))
		debug_end('function calculateMountPoint')
		return os.path.join(self.CRYPT_MOUNT_POINT, cryptName)
		
	def openCrypt(self, withMountPoint, asUser):
		debug_begin('function openCrypt')
		debug("Opening crypt with mount point : " + str(withMountPoint))
		
		cryptLocation = self.selectedCrypt
		mountPoint = self.currentCrypts[self.selectedCrypt]
		debug("Mount point for crypt : " + mountPoint)
		
		fstype = ""
		if withMountPoint == True :
			debug("Opening "+cryptLocation+" at "+mountPoint)
		
			debug("checking mountpoint "+decodeFilePath(mountPoint))
			if not os.path.exists(decodeFilePath(mountPoint)):
				debug("need to make mountpoint "+mountPoint)
				debug(commands.getoutput(self.sudo_command+" \"mkdir -p "+encodeFilePath(mountPoint)+"\""))
		else :
			debug("defaulting mount point as blank")
			fstype = "none"
			mountPoint = ""
				
		asUserBit = ""	
		if asUser:
			asUserBit = " -u"
		else:
			if len(fstype) == 0:
				fstype = "ext3"
			
		password = self.textbox_password_value
		
		if self.isExpert and self.easyCryptConfig.getOption("show_keyfile_options") == "yes":
			if len(self.selectedKeyFile) > 0:
				if len(self.textbox_password_value) == 0:
					password = ""
		
		commandOpenAsUser = self.getTextForCommandOpen(asUser, fstype)
		debug(BASIC_SUDO_COMMAND+" "+commandOpenAsUser)
		if self.hasTrueCryptV4_3a:
			opener = TrueCryptCommandRunner4_3a(BASIC_SUDO_COMMAND+" "+commandOpenAsUser,decodeFilePath(cryptLocation),decodeFilePath(mountPoint), password, "",self.selectedKeyFile , "", "open")
		else :
			if self.hasTrueCryptV5_1 or self.hasTrueCryptV5_X or self.hasTrueCryptV6_1 or self.hasTrueCryptV6_X:
				opener = TrueCryptCommandRunner5_1(BASIC_SUDO_COMMAND+" "+commandOpenAsUser,decodeFilePath(cryptLocation),decodeFilePath(mountPoint), password, "",self.selectedKeyFile , "", "open")
			else :
				opener = TrueCryptCommandRunner5_1(BASIC_SUDO_COMMAND+" "+commandOpenAsUser,decodeFilePath(cryptLocation),decodeFilePath(mountPoint), password, "",self.selectedKeyFile , "", "open")
		opener.start()		
		while not opener.doneRunning :
			time.sleep(0.2)
			while gtk.events_pending():
				gtk.main_iteration()
		
		if not self.checkOpened() :
			
			dialog = gtk.MessageDialog( None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_OK, _("Incorrect Password, please try again"))
			dialog.set_title(_("Wrong Password"))
			dialog.width, dialog.height = dialog.get_size()
			icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
			gtk.window_set_default_icon_list( (icon) )
			ret = dialog.run()
			dialog.destroy()
			
			debug_end('function openCrypt')
			return False
		
		self.updateTrayIcon()
		debug_end('function openCrypt')
		return True
			
	def closeCrypt(self, removeFromList):
		debug_begin('function closeCrypt')
		if self.selectedCrypt != "":
			
			mountPoint = self.currentCrypts[self.selectedCrypt]
			
			if not removeFromList:
				cryptLocation = self.selectedCrypt
				debug("getting mapper name for : " + cryptLocation)
				commandToRun = self.getTextForCommandListOpened()
				debug( commandToRun + " | grep "+cryptLocation)
				mount = commands.getoutput(commandToRun + " | grep "+cryptLocation)
				debug("got mount line " + mount)
				lines = mount.split()
				if len(lines) > 0:
					
					if self.hasTrueCryptV4_3a:
						debug("possible line " + lines[0])
						mountPoint = lines[0]
					else :
						if self.hasTrueCryptV5_1 or self.hasTrueCryptV5_X or self.hasTrueCryptV6_1 or self.hasTrueCryptV6_X:
							debug("possible line " + lines[1])
							mountPoint = lines[1]
			
			debug( "Closing Crypt " + mountPoint)
			debug("output of closing crypt : "+ commands.getoutput(self.sudo_command+" \""+self.getTextForCommandClose()+" "+mountPoint+"\""))
			#remove the crypt from the list
			if self.isExpert and removeFromList:
				del(self.currentCrypts[self.selectedCrypt])
				self.selectedCrypt = ""
				
			self.updateTrayIcon()			
		else :
			debug("Crypt not selected")
			
		debug_end('function closeCrypt')
		
	def closeAllCrypts(self):
		debug_begin('function closeAllCrypts')
		debug("Closing All Crypts")
		
		if self.isExpert :
			#if we have opened crypts, we will iterate
			for k in self.currentCrypts.items():
				#k is in the form (crypt_name, crypt_mountpoint)
				mountPoint = k[1]
				debug("closing "+mountPoint)    
				# we only close the crypts WE opened
				# if somebody else opened crypts via a console, don't close them
				# as we are not aware of them here
				debug(commands.getoutput(self.sudo_command+" \""+self.getTextForCommandClose()+" "+mountPoint+"\""))
			# now, let's empty our crypt dictionnary
			self.currentCrypts.clear()
			self.selectedCrypt = ""
		else :
			if self.checkOpened(): 
				mountPoint = self.currentCrypts[self.selectedCrypt]
				debug("closing " + mountPoint)
				debug(commands.getoutput(self.sudo_command+" \""+self.getTextForCommandClose()+" "+mountPoint+"\""))

		debug("closed all")	
		self.updateTrayIcon()
		debug_end('function closeAllCrypts')
		
	def deleteCrypt(self):
		debug_begin('function deleteCrypt')
		cryptLocation = self.selectedCrypt
		debug("deleting crypt " + cryptLocation)
		debug(commands.getoutput("rm "+cryptLocation))
		debug_end('function deleteCrypt')

	
	def makeCrypt(self, cryptSize):
		debug_begin('function makeCrypt')
		self.lastCreateNeedsChowning = False
		
		cryptLocation = self.selectedCrypt
		
		if self.checkOpened() :
			debug("crypt mounted - unmounting")
			self.closeCrypt(True)
		
		debug("ok lets bosh the old one")
		self.deleteCrypt()
		
		values = {'size' : cryptSize}
		valuesBytes  = {'size' : cryptSize * 1024 *1024}
		targetSizeInBytes = cryptSize * 1024 *1024
		size = "%(size).0fM" %values
		sizeInBytes = "%(size).0f" %valuesBytes
		self.makeRandom()
		current = SizeOfCrypt(self)
		current.start()
		debug(commands.getoutput(self.sudo_command+" echo \"need this to make crypt silently\""))
		
		fsType_choice=""
		encType = "AES"
		hashType = "WHIRLPOOL"
		fsType = "FAT"
		if self.isExpert :
			iter = self.cbo_encType.get_active_iter()
			encType = self.cbo_encType.get_model().get_value(iter, 0)
			iter = self.cbo_hashType.get_active_iter()
			hashType = self.cbo_hashType.get_model().get_value(iter, 0)
			iter = self.cbo_fsType.get_active_iter()
			fsType_choice = self.cbo_fsType.get_model().get_value(iter, 0)
			debug("chosen fs : "+fsType_choice)
			if fsType_choice != "FAT":
				fsType = "NONE"
		
		password = self.textbox_password_value
		
		self.needsOpenAsUser = True
		keyfilePath = ""
		if self.isExpert and self.easyCryptConfig.getOption("show_keyfile_options") == "yes":
			if len(self.selectedKeyFile) > 0:
				if len(self.textbox_password_value) == 0:
					password = ""
				keyfilePath = self.selectedKeyFile
		
		commandToRun = self.getTextForCommandCreate(encType,hashType,fsType,str(size),str(sizeInBytes),self.crypt_rand,cryptLocation)
		debug(commandToRun)
		
		if self.hasTrueCryptV4_3a:
			maker = TrueCryptCommandRunner4_3a(commandToRun,cryptLocation,"", password, "", keyfilePath, "", "create")
		else :
			if self.hasTrueCryptV5_1 or self.hasTrueCryptV5_X or self.hasTrueCryptV6_1 or self.hasTrueCryptV6_X:
				maker = TrueCryptCommandRunner5_1(commandToRun,cryptLocation,"", password, "", keyfilePath, "", "create")
			else :
				maker = TrueCryptCommandRunner5_1(commandToRun,cryptLocation,"", password, "", keyfilePath, "", "create")
		maker.start()
		
		while not maker.doneRunning :
			time.sleep(0.2)
			percentDone = (float(current.returnString) / targetSizeInBytes) *100
			debug("done : " + str(percentDone))
			self.progressbar.set_value(percentDone)
			currentValues = {'size' : (float(current.returnString))/1024/1024}
			self.progressbar.set_text("%(size).0fMB" %currentValues)
			while gtk.events_pending():
				gtk.main_iteration()
			
		current.done = True
		
		self.removeRandom()
		
		if maker.returnVal.find("ASCII") > -1 :
			dialog = gtk.MessageDialog( None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_OK, _("To maintain portability,\n\nPassword must be composed only of US-ASCII printable characters\n\nPlease choose another password"))
			dialog.set_title(_("Password Problem"))
			dialog.width, dialog.height = dialog.get_size()
			icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
			gtk.window_set_default_icon_list( (icon) )
			ret = dialog.run()
			dialog.destroy()
			self.textbox_password.set_text("")
			self.textbox_password_retype.set_text("")
			self.textbox_password.grab_focus()
			debug_end('function makeCrypt')
			return False
				
		if self.isExpert:
			if fsType_choice != "FAT":
				self.changeFormat(fsType_choice)
				if fsType_choice != "NTFS" :
					self.lastCreateNeedsChowning = True
				
		debug_end('function makeCrypt')
		return True
	
	def changeOwnership(self):
		debug_begin('function changeOwnership')
		currentUser =  commands.getoutput("whoami")
		mount = encodeFilePath(self.currentCrypts[self.selectedCrypt])
		theCommand = self.sudo_command+" \"chown "+currentUser+" "+mount+"\""
		debug(theCommand)
		
		maker = ThreadedCommandRunner(theCommand)
		maker.start()
		while not maker.doneRunning :
			while gtk.events_pending():
				gtk.main_iteration()
		debug("done")
		debug_end('function changeOwnership')
	
	def changeFormat(self, format):
		debug_begin('function changeFormat')
		self.openCrypt(False, False)
		
		cryptLocation = self.selectedCrypt
		debug("getting mapper name for : "+cryptLocation)
		commandToRun = self.getTextForCommandListOpened()
		debug(commandToRun+" | grep "+cryptLocation)
		mount = commands.getoutput(commandToRun+" | grep "+cryptLocation)
		debug("got mount line " + mount)
		lines = mount.split()
		if len(lines) > 0:
			
			if self.hasTrueCryptV4_3a:
				debug("possible line " + lines[0])
				mountPoint = lines[0]
			else :
				if self.hasTrueCryptV5_1 or self.hasTrueCryptV5_X or self.hasTrueCryptV6_1 or self.hasTrueCryptV6_X:
					debug("possible line " + lines[2])
					mountPoint = lines[2]
			
			formatString = "mkfs -t ext3"
			if format == "EXT3":
				formatSting = "mkfs -t ext3"
			if format == "EXT2":
				formatSting = "mkfs -t ext2"
			if format == "NTFS":
				formatSting = "mkfs -t ntfs"
			
			maker = ThreadedCommandRunner(self.sudo_command+" \""+formatSting+" "+mountPoint+"\"")
			maker.start()
		
			while not maker.doneRunning :
				while gtk.events_pending():
					gtk.main_iteration()

			self.needsOpenAsUser = False
		debug("opened without mount")
		self.closeCrypt(False)
		debug_end('function changeFormat')
	
	def changePassword(self, event):
		debug_begin('function changePassword')
		cryptLocation = self.selectedCrypt
		debug("changing password for "+cryptLocation)
		if (len(self.textbox_change_password_current.get_text()) > 0 and len(self.textbox_change_password.get_text()) > 0) or (self.isExpert and self.easyCryptConfig.getOption("show_keyfile_options") == "yes" and (len(self.selectedKeyFile) > 0 or len(self.selectedKeyFileNew) > 0)) :
			if self.textbox_change_password.get_text() == self.textbox_change_password_retype.get_text() :
				debug("we can do it")
				debug(commands.getoutput(self.sudo_command+" echo \"need this to change crypt silently\""))
				self.makeRandom()
				
				password = self.textbox_change_password_current.get_text()
				newPassword = self.textbox_change_password.get_text()
				
				keyfilePath = ""
				keyfilePathNew = ""
				if self.isExpert and self.easyCryptConfig.getOption("show_keyfile_options") == "yes":
					if len(self.selectedKeyFile) > 0:
						if len(self.textbox_change_password_current.get_text()) == 0:
							password = ""
						keyfilePath = self.selectedKeyFile
					if len(self.selectedKeyFileNew) > 0:
						if len(self.textbox_change_password.get_text()) == 0:
							newPassword = ""
						keyfilePathNew = self.selectedKeyFileNew
				
				commandToRun = self.getTextForCommandChange(self.crypt_rand,cryptLocation)
				debug(commandToRun)
				
				if self.hasTrueCryptV4_3a:
					changer = TrueCryptCommandRunner4_3a(commandToRun, cryptLocation, "", password,newPassword,keyfilePath,keyfilePathNew, "change")
				else :
					if self.hasTrueCryptV5_1 or self.hasTrueCryptV5_X or self.hasTrueCryptV6_1 or self.hasTrueCryptV6_X:
						changer = TrueCryptCommandRunner5_1(commandToRun, cryptLocation, "", password,newPassword,keyfilePath,keyfilePathNew, "change")
				if self.hasTrueCryptV5_1 or self.hasTrueCryptV5_X or self.hasTrueCryptV6_1 or self.hasTrueCryptV6_X:
					self.closeCrypt(False)
				
				changer.start()
				while not changer.doneRunning :
					time.sleep(0.2)
					while gtk.events_pending():
						gtk.main_iteration()
						
				debug(changer.returnVal)
				
				#commandOutput = commands.getoutput("truecrypt -k "+keyfilePath+" --keyfile-add "+keyfilePathNew+" --o --random-source "+self.crypt_rand+" -C " +cryptLocation)
				#print commandOutput
				if len( changer.returnVal) > 0: 
					debug("err")
					dialog = gtk.MessageDialog( None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_OK, _("Incorrect Password, please try again"))
					dialog.set_title(_("Wrong Password"))
					dialog.width, dialog.height = dialog.get_size()
					icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
					gtk.window_set_default_icon_list( (icon) )
					ret = dialog.run()
					dialog.destroy()
					self.textbox_change_password_current.set_text("")
					self.textbox_change_password_current.grab_focus()
				else :
					if self.hasTrueCryptV5_1 or self.hasTrueCryptV5_X or self.hasTrueCryptV6_1 or self.hasTrueCryptV6_X:
						self.textbox_password_value = newPassword
						self.selectedKeyFile = keyfilePathNew
						self.openCrypt(True,True)
					self.password_change_window.hide()
					
				self.removeRandom()

			else :
				dialog = gtk.MessageDialog( None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_OK, _("The two Passwords you entered do not Match\n\nPlease re-enter them"))
				dialog.set_title(_("Passwords Must Match"))
				dialog.width, dialog.height = dialog.get_size()
				icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
				gtk.window_set_default_icon_list( (icon) )
				ret = dialog.run()
				dialog.destroy()
				self.textbox_change_password.set_text("")
				self.textbox_change_password_retype.set_text("")
				self.textbox_change_password.grab_focus()
				
		debug_end('function changePassword')
	
	def afterPasswordDoAction(self, event):
		debug_begin('function afterPasswordDoAction')
		self.textbox_password_value = self.textbox_password.get_text()
		if len(self.textbox_password_value) > 0 or (self.isExpert and self.easyCryptConfig.getOption("show_keyfile_options") == "yes" and len(self.selectedKeyFile) > 0):
			debug("got password now doing action " + self.nextAction)
			if self.nextAction == "open" :
				mountAsUser = True
				if self.isUnixFS.get_active() == gtk.TRUE:
					mountAsUser = False
				
				if self.isExpert and self.easyCryptConfig.getOption("modifiable_mount_path") == "yes":
					self.currentCrypts[self.selectedCrypt] = self.textbox_mountPath.get_text()
				
				if self.openCrypt(True, mountAsUser):
					self.password_window.hide()
			if self.nextAction == "create" :
				
				if self.textbox_password.get_text() == self.textbox_password_retype.get_text() :
					if self.makeCrypt(self.crypt_size.get_value()):
						if self.openCrypt(True, self.needsOpenAsUser):
							if self.lastCreateNeedsChowning:
								debug("need to chown mount")
								self.changeOwnership()
							debug("hiding create window")
							self.password_window.hide()
				else :
					dialog = gtk.MessageDialog( None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_OK, _("The two Passwords you entered do not Match\n\nPlease re-enter them"))
					dialog.set_title(_("Passwords Must Match"))
					dialog.width, dialog.height = dialog.get_size()
					icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
					gtk.window_set_default_icon_list( (icon) )
					ret = dialog.run()
					dialog.destroy()
					self.textbox_password.set_text("")
					self.textbox_password_retype.set_text("")
					self.textbox_password.grab_focus()
					
		debug_end('function afterPasswordDoAction')
			
	def selectCrypt(self):
		debug_begin('function selectCrypt')
		if not self.isExpert :
			self.selectedCrypt = self.default_crypt
		debug_end('function selectCrypt')
			
	def toggleShowPasswordsCreate(self,button):
		debug_begin('function toggleShowPasswordsCreate')
		if self.showPasswords.get_active() ==  gtk.FALSE :
			self.textbox_password.set_visibility( gtk.FALSE )
			self.textbox_password_retype.set_visibility( gtk.FALSE )
		else :
			self.textbox_password.set_visibility( gtk.TRUE )
			self.textbox_password_retype.set_visibility( gtk.TRUE )	
		debug_end('function toggleShowPasswordsCreate')
		
	def getCryptPasswordThenAction(self, action):
		debug_begin('function getCryptPasswordsThenAction')
		self.nextAction = action
		self.password_window = gtk.Window( gtk.WINDOW_TOPLEVEL )
		if action == "open":
			self.password_window.set_title(_("Opening Crypt"))
		if action =="create" :
			self.password_window.set_title(_("Make New Crypt"))
		self.password_window.set_border_width( 5 )
		self.password_window.set_position( gtk.WIN_POS_CENTER )
		self.password_window.set_modal( gtk.FALSE )
		self.password_window.set_resizable(gtk.FALSE)
		icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
		gtk.window_set_default_icon_list( (icon) )
		
		# Register events
		self.password_window.connect( "delete_event", self.onDelete_password_window )
		
		#window.show()
		self.password_window.resize(380,10)

		table = gtk.Table( rows=3, columns=2, homogeneous=gtk.FALSE )
		self.password_window.add(table)
		tableVPos = 0
		
		label_title = gtk.Label()
		label_title.set_markup('<span size="large" weight="bold">'+_("Enter CRYPT Password")+'</span>')
		table.attach(label_title,  0, 2, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
		label_title.show()
		tableVPos=tableVPos+1
		
		self.textbox_password = gtk.Entry( max=0 )
		self.textbox_password.set_text("")
		self.textbox_password.set_visibility( gtk.FALSE )
		self.textbox_password.set_invisible_char( '*' )
		table.attach(self.textbox_password,  0, 2, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
		self.textbox_password.set_activates_default(True)
		self.textbox_password.show()
		tableVPos=tableVPos+1
		
		if action == "create":
			
			spaceleft = self.howMuchSpaceInKb()
			spaceleft = spaceleft / 1024
			self.lastSpaceLeft = spaceleft
			
			label_retype = gtk.Label()
			label_retype.set_markup('<span size="large" weight="bold">'+_("Retype Password")+'</span>')
			table.attach(label_retype,  0, 1, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
			label_retype.show()
			
			alignment = gtk.Alignment( 1.0, 0.0, 0.0, 0.0 )
			self.showPasswords = gtk.CheckButton(_("Show Passwords"))
			alignment.add( self.showPasswords )
			table.attach( alignment, 1, 2, tableVPos, tableVPos+1 )
			alignment.show()
			self.showPasswords.set_active( gtk.FALSE )
			self.showPasswords.show()
			self.showPasswords.connect("toggled", self.toggleShowPasswordsCreate)
			tableVPos=tableVPos+1
			
			self.textbox_password_retype = gtk.Entry( max=0 )
			self.textbox_password_retype.set_text("")
			self.textbox_password_retype.set_visibility( gtk.FALSE )
			self.textbox_password_retype.set_invisible_char( '*' )
			table.attach(self.textbox_password_retype,  0, 2, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
			self.textbox_password_retype.set_activates_default(True)
			self.textbox_password_retype.show()
			tableVPos=tableVPos+1
			
			
		if self.isExpert and self.easyCryptConfig.getOption("show_keyfile_options") == "yes":
			
			label_optional_keyfile = gtk.Label()
			label_optional_keyfile.set_markup('<span size="large" weight="bold">'+_("Optional Keyfile")+'</span>')
			table.attach(label_optional_keyfile,  0, 2, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
			label_optional_keyfile.show()
			tableVPos=tableVPos+1
			
			self.textbox_select_keyfile = gtk.Entry( max=0 )
			self.textbox_select_keyfile.set_text("")
			table.attach(self.textbox_select_keyfile,  0, 2, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
			self.textbox_select_keyfile.show()
			tableVPos=tableVPos+1
			
			button_clear_keyfile = gtk.Button( _("Clear Keyfile") )
			table.attach( button_clear_keyfile, 0, 1, tableVPos, tableVPos+1, ypadding=1 )
			button_clear_keyfile.connect( "clicked", self.clearKeyFile, "")
			button_clear_keyfile.show()
			
			self.selectedKeyFile = ""
			button_select_keyfile = gtk.Button( _("Select Keyfile") )
			table.attach( button_select_keyfile, 1, 2, tableVPos, tableVPos+1, ypadding=1 )
			button_select_keyfile.connect( "clicked", self.selectKeyFile, "")
			button_select_keyfile.show()
			tableVPos=tableVPos+1
			
		if action == "open":		
			
			if self.isExpert and self.easyCryptConfig.getOption("modifiable_mount_path") == "yes":
				label_mountPath = gtk.Label()
				label_mountPath.set_markup('<span size="large" weight="bold">'+_("Mount Path")+'</span>')
				table.attach(label_mountPath,  0, 2, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
				label_mountPath.show()
				tableVPos=tableVPos+1
				
				self.textbox_mountPath = gtk.Entry( max=0 )
				self.textbox_mountPath.set_text(self.currentCrypts[self.selectedCrypt])
				table.attach(self.textbox_mountPath,  0, 2, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
				self.textbox_mountPath.set_activates_default(True)
				self.textbox_mountPath.show()
				tableVPos=tableVPos+1
				
			self.isUnixFS = gtk.CheckButton(_("Unix Filesystem (e.g. ext3)"))
			table.attach( self.isUnixFS, 0, 2, tableVPos, tableVPos+1 )
			self.isUnixFS.set_active( gtk.FALSE )
			self.isUnixFS.show()
			tableVPos=tableVPos+1
			
		if action == "create":

			# Add label: Select Crypt Size
			label_select_size = gtk.Label()
			label_select_size.set_markup('<span size="large" weight="bold">'+_("Select Crypt Size")+'</span>')
			table.attach( label_select_size,  0, 2, tableVPos, tableVPos+1,xpadding=2,ypadding=1 )
			label_select_size.show()
			tableVPos=tableVPos+1

			# Add GTK.ENTRY for manually entering the crypt size
			self.crypt_size_txt = gtk.Entry( max=0 )
			table.attach( self.crypt_size_txt, 1, 2, tableVPos, tableVPos+1 )
			self.crypt_size_txt.show()
			self.crypt_size_txt.set_text("50")
			self.crypt_size_txt.set_activates_default(True)
			self.crypt_size_txt.connect("changed", self.formatSizeValueFromEntry)

			# Add Combobox with presets
			self.cbo_size_preset=gtk.combo_box_new_text()
			self.cbo_size_preset.append_text(_("Manual Size"))
			for i,textLabel in enumerate(SIZE_LABELS ):
				self.cbo_size_preset.append_text(textLabel)
			table.attach( self.cbo_size_preset, 0, 1, tableVPos, tableVPos+1, xpadding=2,ypadding=1 )
			self.cbo_size_preset.connect("changed", self.formatSizeValueFromPresets)
			self.cbo_size_preset.show()
			self.cbo_size_preset.set_active(0)
			tableVPos=tableVPos+1

			# Add GTK.HSCALE for selecting the crypt size
			self.crypt_size = gtk.HScale()
			self.crypt_size.show()	
			table.attach(self.crypt_size,  0, 2, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
			self.crypt_size.set_digits(0)
			self.crypt_size.set_update_policy(gtk.UPDATE_CONTINUOUS)
			self.crypt_size.set_value_pos(gtk.POS_TOP)
			self.crypt_size.set_range(1,spaceleft)
			self.crypt_size.set_increments(1, 10)
			self.crypt_size.set_value(50)
			self.crypt_size.connect("change-value", self.formatSizeValue)
			#self.volume.connect("change-value", self.changevolume)
			tableVPos=tableVPos+1
	
			if self.isExpert:
				label_encType = gtk.Label()
				label_encType.set_markup(_("Encryption Algorithm"))
				table.attach(label_encType,  0, 1, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
				label_encType.show()
				
				self.cbo_encType=gtk.combo_box_new_text()
				self.cbo_encType.append_text("AES")
				self.cbo_encType.append_text("Serpent")
				self.cbo_encType.append_text("Twofish")
				self.cbo_encType.append_text("AES-Twofish")
				self.cbo_encType.append_text("AES-Twofish-Serpent")
				self.cbo_encType.append_text("Serpent-AES")
				self.cbo_encType.append_text("Serpent-Twofish-AES")
				self.cbo_encType.append_text("Twofish-Serpent")
				self.cbo_encType.set_active(0)
				table.attach(self.cbo_encType,  1, 2, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
				self.cbo_encType.show()
				tableVPos=tableVPos+1
				
				
				label_hashType = gtk.Label()
				label_hashType.set_markup(_("Hash Algorithm"))
				table.attach(label_hashType,  0, 1, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
				label_hashType.show()
				
				self.cbo_hashType=gtk.combo_box_new_text()
				self.cbo_hashType.append_text("Whirlpool")
				self.cbo_hashType.append_text("SHA-1")
				self.cbo_hashType.append_text("RIPEMD-160")
				self.cbo_hashType.set_active(0)
				table.attach(self.cbo_hashType,  1, 2, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
				self.cbo_hashType.show()
				tableVPos=tableVPos+1
				
				
				label_fsType = gtk.Label()
				label_fsType.set_markup(_("File System Format"))
				table.attach(label_fsType,  0, 1, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
				label_fsType.show()
				
				self.cbo_fsType=gtk.combo_box_new_text()
				self.cbo_fsType.append_text("FAT")
				self.cbo_fsType.append_text("EXT3")
				if self.hasTrueCryptV4_3a :
					self.cbo_fsType.append_text("EXT2")
					ntfs = commands.getoutput("which mkfs.ntfs")
					if len(ntfs) > 0:
						self.cbo_fsType.append_text("NTFS")
				
				self.cbo_fsType.set_active(0)
				table.attach(self.cbo_fsType,  1, 2, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
				self.cbo_fsType.show()
				tableVPos=tableVPos+1

			# Display progressbar
			self.progressbar = gtk.ProgressBar()
			self.progressbar.show()	
			self.progressbar.set_value(0)
			self.progressbar.set_text("0MB")
			table.attach(self.progressbar,  0, 2, tableVPos, tableVPos+1,xpadding=5,ypadding=5)
			tableVPos=tableVPos+1
		
		# Add 'Cancel' button
		button_cancel = gtk.Button( stock=gtk.STOCK_CANCEL )
		table.attach( button_cancel, 0, 1, tableVPos, tableVPos+1, ypadding=1 )
		button_cancel.connect( "clicked", self.onDelete_password_window )
		button_cancel.show()
		
		# Add 'Open' button
		if action == "open":
			button_open = gtk.Button( stock=gtk.STOCK_OPEN )
		if action =="create" :
			button_open = gtk.Button( stock=gtk.STOCK_NEW )
		table.attach( button_open, 1, 2, tableVPos, tableVPos+1, ypadding=1 )
		button_open.connect( "clicked", self.afterPasswordDoAction )
		button_open.show()
		tableVPos=tableVPos+1
		
		button_open.set_flags(gtk.CAN_DEFAULT)
		button_open.grab_default()
		self.password_window.set_default(button_open)
		
		table.show()
		self.password_window.show()
		debug_end('function getCryptPasswordsThenAction')
	
	def toggleShowPasswordsChange(self,button):
		debug_begin('function toggleShowPasswordsChange')
		if self.showPasswordsChange.get_active() ==  gtk.FALSE :
			self.textbox_change_password_current.set_visibility( gtk.FALSE )
			self.textbox_change_password.set_visibility( gtk.FALSE )
			self.textbox_change_password_retype.set_visibility( gtk.FALSE )
		else :
			self.textbox_change_password_current.set_visibility( gtk.TRUE )
			self.textbox_change_password.set_visibility( gtk.TRUE )
			self.textbox_change_password_retype.set_visibility( gtk.TRUE )	
		debug_end('function toggleShowPasswordsChange')
	
	def changePasswordWindow(self):
		debug_begin('function changePasswordsWindow')
		self.password_change_window = gtk.Window( gtk.WINDOW_TOPLEVEL )
		self.password_change_window.set_title(_("Change Password"))
		self.password_change_window.set_border_width( 5 )
		self.password_change_window.set_position( gtk.WIN_POS_CENTER )
		self.password_change_window.set_modal( gtk.FALSE )
		self.password_change_window.set_resizable(gtk.FALSE)
		icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
		gtk.window_set_default_icon_list( (icon) )
		
		# Register events
		self.password_change_window.connect( "delete_event", self.onDelete_change_password_window )
		
		#window.show()
		self.password_change_window.resize(380,10)

		table = gtk.Table( rows=3, columns=1, homogeneous=gtk.FALSE )
		self.password_change_window.add(table)

		
		label_title = gtk.Label()
		label_title.set_markup('<span size="large" weight="bold">'+_("Change Crypt Password")+'</span>')
		table.attach(label_title,  0, 2, 0, 1,xpadding=2,ypadding=1)
		label_title.show()
		
		alignment = gtk.Alignment( 1.0, 0.0, 0.0, 0.0 )
		self.showPasswordsChange = gtk.CheckButton(_("Show Passwords"))
		alignment.add( self.showPasswordsChange )
		table.attach( alignment, 0, 2, 1, 2 )
		alignment.show()
		self.showPasswordsChange.set_active( gtk.FALSE )
		self.showPasswordsChange.show()
		self.showPasswordsChange.connect("toggled", self.toggleShowPasswordsChange)
		
		label_current = gtk.Label()
		label_current.set_markup(_("Current Password"))
		table.attach(label_current,  0, 1, 2, 3,xpadding=2,ypadding=1)
		label_current.show()
		
		self.textbox_change_password_current = gtk.Entry( max=0 )
		self.textbox_change_password_current.set_text("")
		self.textbox_change_password_current.set_visibility( gtk.FALSE )
		self.textbox_change_password_current.set_invisible_char( '*' )
		table.attach(self.textbox_change_password_current,  1, 2, 2, 3,xpadding=2,ypadding=1)
		self.textbox_change_password_current.set_activates_default(True)
		self.textbox_change_password_current.show()
		
		label_new = gtk.Label()
		label_new.set_markup(_("New Password"))
		table.attach(label_new,  0, 1, 3, 4,xpadding=2,ypadding=1)
		label_new.show()
		
		self.textbox_change_password = gtk.Entry( max=0 )
		self.textbox_change_password.set_text("")
		self.textbox_change_password.set_visibility( gtk.FALSE )
		self.textbox_change_password.set_invisible_char( '*' )
		table.attach(self.textbox_change_password,  1, 2, 3, 4,xpadding=2,ypadding=1)
		self.textbox_change_password.set_activates_default(True)
		self.textbox_change_password.show()
		
		label_retype = gtk.Label()
		label_retype.set_markup(_("Retype New Password"))
		table.attach(label_retype,  0, 1, 4, 5,xpadding=2,ypadding=1)
		label_retype.show()
			
		self.textbox_change_password_retype = gtk.Entry( max=0 )
		self.textbox_change_password_retype.set_text("")
		self.textbox_change_password_retype.set_visibility( gtk.FALSE )
		self.textbox_change_password_retype.set_invisible_char( '*' )
		table.attach(self.textbox_change_password_retype,  1, 2, 4, 5,xpadding=2,ypadding=1)
		self.textbox_change_password_retype.set_activates_default(True)
		self.textbox_change_password_retype.show()
		
		
		tableVPos = 5
		if self.isExpert and self.easyCryptConfig.getOption("show_keyfile_options") == "yes":
			
			label_optional_keyfile = gtk.Label()
			label_optional_keyfile.set_markup('<span size="large" weight="bold">'+_("Optional Keyfiles")+'</span>')
			table.attach(label_optional_keyfile,  0, 2, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
			label_optional_keyfile.show()
			tableVPos=tableVPos+1
			
			self.textbox_select_keyfile = gtk.Entry( max=0 )
			self.textbox_select_keyfile.set_text("")
			table.attach(self.textbox_select_keyfile,  0, 2, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
			self.textbox_select_keyfile.show()
			tableVPos=tableVPos+1
			
			button_clear_keyfile = gtk.Button( _("Clear Current Keyfile") )
			table.attach( button_clear_keyfile, 0, 1, tableVPos, tableVPos+1, ypadding=1 )
			button_clear_keyfile.connect( "clicked", self.clearKeyFile, "")
			button_clear_keyfile.show()
			
			self.selectedKeyFile = ""
			button_select_keyfile = gtk.Button( _("Select Current Keyfile") )
			table.attach( button_select_keyfile, 1, 2, tableVPos, tableVPos+1, ypadding=1 )
			button_select_keyfile.connect( "clicked", self.selectKeyFile, "")
			button_select_keyfile.show()
			tableVPos=tableVPos+1
		
			self.textbox_select_keyfile_new = gtk.Entry( max=0 )
			self.textbox_select_keyfile_new.set_text("")
			table.attach(self.textbox_select_keyfile_new,  0, 2, tableVPos, tableVPos+1,xpadding=2,ypadding=1)
			self.textbox_select_keyfile_new.show()
			tableVPos=tableVPos+1
			
			button_clear_keyfile_new = gtk.Button( _("Clear New Keyfile") )
			table.attach( button_clear_keyfile_new, 0, 1, tableVPos, tableVPos+1, ypadding=1 )
			button_clear_keyfile_new.connect( "clicked", self.clearKeyFile, "new")
			button_clear_keyfile_new.show()
			
			self.selectedKeyFileNew = ""
			button_select_keyfile_new = gtk.Button( _("Select New Keyfile") )
			table.attach( button_select_keyfile_new, 1, 2, tableVPos, tableVPos+1, ypadding=1 )
			button_select_keyfile_new.connect( "clicked", self.selectKeyFile, "new")
			button_select_keyfile_new.show()
			tableVPos=tableVPos+1
		
		# Add 'Cancel' button
		button_cancel = gtk.Button( stock=gtk.STOCK_CANCEL )
		table.attach( button_cancel, 0, 1, tableVPos, tableVPos+1, ypadding=1 )
		button_cancel.connect( "clicked", self.onDelete_change_password_window )
		button_cancel.show()
		
		button_ok = gtk.Button( stock=gtk.STOCK_OK )
		table.attach( button_ok, 1, 2, tableVPos, tableVPos+1, ypadding=1 )
		button_ok.connect( "clicked", self.changePassword )
		button_ok.show()
		
		button_ok.set_flags(gtk.CAN_DEFAULT)
		button_ok.grab_default()
		self.password_change_window.set_default(button_ok)
		
		table.show()
		self.password_change_window.show()
		debug_end('function changePasswordsWindow')
	
	def selectCryptFromList(self):
		debug_begin('function selectCryptFromList')
		debug('self.currentCrypts : ' + str(self.currentCrypts))
		#if we have no crypts opened
		if len(self.currentCrypts) == 0:
			if self.afterSelectCryptDoAction == "changepassword" :
				dialog = gtk.MessageDialog( None, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, _("Please open the Crypt you wish to change."))
				dialog.set_title(_("Open the Crypt first"))
				dialog.width, dialog.height = dialog.get_size()
				icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
				gtk.window_set_default_icon_list( (icon) )
				ret = dialog.run()
				dialog.destroy()
			debug_end('function selectCryptFromList')
			return
		
		self.select_crypt_window = gtk.Window( gtk.WINDOW_TOPLEVEL )
		self.select_crypt_window.set_title(_("Select an Open Crypt"))
		self.select_crypt_window.set_border_width( 5 )
		self.select_crypt_window.set_position( gtk.WIN_POS_CENTER )
		self.select_crypt_window.set_modal( gtk.TRUE )
		self.select_crypt_window.set_resizable(gtk.FALSE)
		icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
		gtk.window_set_default_icon_list( (icon) )
		
		# Register events
		self.select_crypt_window.connect( "delete_event", self.onDelete_select_crypt_window )
		
		#window.show()
		self.select_crypt_window.resize(380,10)

		table = gtk.Table( rows=3, columns=1, homogeneous=gtk.FALSE )
		self.select_crypt_window.add(table)
		
		label_title = gtk.Label()
		label_title.set_markup('<span size="large" weight="bold">'+_("Choose a Crypt")+'</span>')
		table.attach(label_title,  0, 2, 0, 1,xpadding=2,ypadding=1)
		label_title.show()
		
		largestPos = 0
		numMounted = 0
		i = 0

		self.selectedButtons = {}

		# we iterate over the crypt, sorted in alphabetical order
		for k in sorted(self.currentCrypts.keys()):
			mountPoint = self.currentCrypts[k]
			button = gtk.Button(decodeFilePath(mountPoint)+"  ("+decodeFilePath(k)+")")
			table.attach( button, 0, 2, i+1, i+2, ypadding=1 )
			# pass the index and crypt name to the function
			button.connect( "clicked", self.chooseAnOpenCrypt, i , k)
			button.show()
			self.selectedButtons[i] = button
			numMounted = numMounted+1
			i = i+1
		# as we incremented i a last time, just give largestPos i+1
		largestPos = i+1

		if self.afterSelectCryptDoAction == "close" and numMounted > 1 :
			button = gtk.Button(_("Close All Crypts") )
			table.attach( button, 0, 2, largestPos+1, largestPos+2, ypadding=1 )
			button.connect( "clicked", self.closeAllCryptsSelectOption )
			button.show()
			largestPos = largestPos+2
		
		button = gtk.Button(stock=gtk.STOCK_CANCEL)
		table.attach( button, 0, 2, largestPos+1, largestPos+2, ypadding=1 )
		button.connect( "clicked", self.onDelete_select_crypt_window )
		button.show()
		
		table.show()
		self.select_crypt_window.show()
		debug_end('function selectCryptFromList')
	
	def closeAllCryptsSelectOption(self, event):
		debug_begin('function closeAllCryptsSelectOption')
		self.closeAllCrypts();
		self.select_crypt_window.hide()
		debug_end('function closeAllCryptsSelectOption')
	
	def chooseAnOpenCrypt(self, event, i, crypt_name):
		debug_begin('function chooseAnOpenCrypt')
		debug("Selected item "+str(i))
		self.selectedCrypt = crypt_name
		if self.afterSelectCryptDoAction == "close":
			debug("Closing selected")
			self.closeCrypt(True)
			if (self.isExpert):
				debug("hiding button "+str(i))
				self.selectedButtons[i].hide()
				numMounted = 0
				# if a crypt is still open, don't close window
				if len(self.currentCrypts) > 0 :
					debug_end('function chooseAnOpenCrypt')
					return
		if self.afterSelectCryptDoAction == "changepassword":
			debug("Changing Password")
			self.changePasswordWindow()
		self.select_crypt_window.hide()
		debug_end('function chooseAnOpenCrypt')
		
	def formatSizeValue(self, scale, scroll, value):
		debug_begin('function formatSizeValue')
		# Update crypt_size_txt value
		if value > self.lastSpaceLeft :
			value = self.lastSpaceLeft
		
		self.crypt_size_txt.set_text("%.f" % value)
		# Return dict containing crypt size
		values = {'size' : value}
		debug_end('function formatSizeValue')
		return "%(size).0fMB" %values

	# Get the crypt size from the entry box
	def formatSizeValueFromEntry(self, entry, boing=None):
		debug_begin('function formatSizeValueFromEntry')
		try:
			# Cast from string to float
			v = int(entry.get_text())
			values = {'size' : v}
			# Update slider with value
			self.crypt_size.set_value(v)
			# Detect to see if its in list
			gotMatch = False
			for i,item in enumerate(SIZE_PRESETS):
				#print v,SIZE_PRESETS[item]
				if v == int(SIZE_PRESETS[item]):
					self.cbo_size_preset.set_active(i+1)
					gotMatch = True
			if not gotMatch :
				self.cbo_size_preset.set_active(0)
			debug_end('function formatSizeValueFromEntry')
			return "%(size).0fMB" %values
		except:
			debug("ignoring text")
		debug_end('function formatSizeValueFromEntry')

	# Get the crypt size from the presets combobox
	def formatSizeValueFromPresets(self, cbo):
		debug_begin('function formatSizeValueFromPresets')
		# Get active element from preset combobox
		selectedItem = cbo.get_active()
		if selectedItem > 0:
			selectedValue = SIZE_PRESETS[cbo.get_active()]
			v = float(selectedValue)
			
			if v > self.lastSpaceLeft :
				cbo.set_active(0)
				debug_end('function formatSizeValueFromPresets')
				return
			
			values = {'size' : v}
			# Update slider and entry with size value
			self.crypt_size.set_value(v)
			self.crypt_size_txt.set_text("%(size).0f" %values)
			debug_end('function formatSizeValueFromPresets')
			return "%(size).0fMB" %values
	
	def showWelcomeWindow(self):
		debug_begin('function showWelcomeWindow')
		self.welcome_window = gtk.Window( gtk.WINDOW_TOPLEVEL )
		self.welcome_window.set_title(_("Welcome to Easy Crypt"))
		self.welcome_window.set_border_width( 5 )
		self.welcome_window.set_position( gtk.WIN_POS_CENTER )
		self.welcome_window.set_modal( gtk.TRUE )
		self.welcome_window.set_resizable(gtk.FALSE)
		icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
		gtk.window_set_default_icon_list( (icon) )

		# Register events
		self.welcome_window.connect( "delete_event", self.onDelete_welcome )
		
		#window.show()
		self.welcome_window.resize(380,150)
		
		table = gtk.Table( rows=5, columns=2, homogeneous=gtk.FALSE )
		self.welcome_window.add(table)
		
		label_title = gtk.Label()
		label_title.set_markup('<span size="x-large" weight="bold">'+_("Welcome to Easy Crypt")+'</span>\n\n'+_("To access Easy Crypt, Right click on the Easy Crypt icon in the System Tray")+'\n\n'+_("Easy Crypt has defaulted to normal mode, in this mode the crypt file is hidden,\nto see it you will have to enable 'Show Hidden Files' (shortcut CTRL+h)")+'\n'+_("The crypt files default location in normal mode is:")+'\n\n'+self.default_crypt+'\n\n'+_("To store crypts elsewhere, use the Tray Icon to change the preferences to expert mode\nExpert mode has many additional features")+'\n')
		table.attach(label_title,  0, 2, 0, 1,xpadding=2,ypadding=1)
		label_title.show()
		
		splash = gtk.Image()
		splash.set_from_file(self.IMAGE_WELCOME_SPLASH)
		table.attach(splash,  0, 2, 1, 2,xpadding=2,ypadding=1)
		splash.show()
		
		# Add 'Close' button
		button_close = gtk.Button( stock=gtk.STOCK_CLOSE )
		table.attach( button_close, 0, 1, 2, 3, ypadding=1 )
		button_close.connect( "clicked", self.onDelete_welcome )
		button_close.show()
		
		# Add 'Setup' button
		button_createCrypt = gtk.Button( _("Setup Crypt Now"))
		table.attach( button_createCrypt, 1, 2, 2, 3, ypadding=1 )
		button_createCrypt.connect( "clicked", self.doFirstCreateEvent )
		button_createCrypt.show()
		
		button_createCrypt.set_flags(gtk.CAN_DEFAULT)
		button_createCrypt.grab_default()
		self.welcome_window.set_default(button_createCrypt)
		
		label_title = gtk.Label(_("Version") +' '+self.version)
		table.attach(label_title,  0, 2, 3, 4,xpadding=2,ypadding=1)
		label_title.show()
		table.show()
		
		self.welcome_window.show()
		debug_end('function showWelcomeWindow')
		
		
	def showAboutWindow(self):
		debug_begin('function showAboutWindow')
		self.about_window = gtk.Window( gtk.WINDOW_TOPLEVEL )
		self.about_window.set_title(_("About Easy Crypt"))
		self.about_window.set_border_width( 5 )
		self.about_window.set_position( gtk.WIN_POS_CENTER )
		self.about_window.set_modal( gtk.FALSE )
		self.about_window.set_resizable(gtk.FALSE)
		icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
		gtk.window_set_default_icon_list( (icon) )

		# Register events
		self.about_window.connect( "delete_event", self.onDelete_about )
		
		#window.show()
		self.about_window.resize(380,150)

		table = gtk.Table( rows=5, columns=1, homogeneous=gtk.FALSE )
		self.about_window.add(table)
		
		label_title = gtk.Label()
		label_title.set_markup('<span size="x-large" weight="bold">'+_("Easy Crypt")+'</span>\n  '+_("Version") +' '+self.version)
		table.attach(label_title,  0, 1, 0, 1,xpadding=2,ypadding=1)
		label_title.show()

		
		splash = gtk.Image()
		splash.set_from_file(self.IMAGE_ABOUT_SPLASH)
		table.attach(splash,  0, 1, 1, 2,xpadding=2,ypadding=1)
		splash.show()
		
		# Add 'Website' button
		button_visit = gtk.Button( label=_("Visit _Easy Crypt Website") )
		button_visit.set_use_underline(True)
		table.attach( button_visit, 0, 1, 2, 3, ypadding=1 )
		button_visit.connect( "clicked", self.gotourlMain )
		button_visit.show()
		
		# Add 'Website' button
		button_visit = gtk.Button( label=_("Visit _TrueCrypt Website") )
		button_visit.set_use_underline(True)
		table.attach( button_visit, 0, 1, 3, 4, ypadding=1 )
		button_visit.connect( "clicked", self.gotoTrueCryptWebsite )
		button_visit.show()
		
		label_blurb = gtk.Label()
		truecryptDetectionText = _("TrueCrypt not Installed")
		if self.hasTrueCryptV4_3a:
			truecryptDetectionText = _("Detected TrueCrypt Version") + ": 4.3"
		else:
			if self.hasTrueCryptV5_0:
				truecryptDetectionText = _("Detected TrueCrypt Version") + ": 5.0"
			else:
				if self.hasTrueCryptV5_1:
					truecryptDetectionText = _("Detected TrueCrypt Version") + ": 5.1"
				else :
					if self.hasTrueCryptV5_X:
						truecryptDetectionText = _("Detected TrueCrypt Version") + ": " + self.truecrypt_high_version
					else :
						if self.hasTrueCryptV6_1:
							truecryptDetectionText = _("Detected TrueCrypt Version") + ": 6.1"
						else :
							if self.hasTrueCryptV6_X:
								truecryptDetectionText = _("Detected TrueCrypt Version") + ": 6.X"
					
		label_blurb.set_markup('\n<span size="larger" weight="bold">'+_("Written by Steven Harper")+'</span>\n\n'+_("Uses the most Excellent Truecrypt")+'\n\n'+truecryptDetectionText+'\n')
		table.attach(label_blurb,  0, 1, 4, 5,xpadding=2,ypadding=1)
		label_blurb.show()
		
		# Add 'Close' button
		button_close = gtk.Button( stock=gtk.STOCK_CLOSE )
		table.attach( button_close, 0, 1, 5, 6, ypadding=1 )
		button_close.connect( "clicked", self.onDelete_about )
		button_close.show()
		
		table.show()
		self.about_window.show()
		debug_end('function showAboutWindow')
	
	def gotoTrueCryptWebsite(self, event):
		debug_begin('function gotoTrueCryptWebsite')
		self.gotourl(URL_TRUECRYPT_DOWNLOAD)
		debug_end('function gotoTrueCryptWebsite')
		
	def gotourlMain(self, event):
		debug_begin('function gotourlMain')
		self.gotourl(WEBSITE)
		debug_end('function gotourlMain')
		
	def gotourl( self, location):
		debug_begin('function gotourl')
		os.system("/usr/bin/x-www-browser "+location+" &")
		debug_end('function gotourl')
	def trayIconLeftClicked(self, status_icon):
		debug_begin('function trayIconLeftClicked')
		self.popup_menu.menu.popup (None, None, gtk.status_icon_position_menu, 0, 0, self.status_icon)
		debug_end('function trayIconLeftClicked')
	def trayIconClicked(self, status_icon, button, activate_time):
		debug_begin('function trayIconClicked')
		debug("clicked tray "+ str(button))
		self.popup_menu.menu.popup(None, None, gtk.status_icon_position_menu, button, activate_time, self.status_icon)
		debug_end('function trayIconClicked')

	def doChangePasswordEvent(self,menuItem):
		debug_begin('function doChangePasswordEvent')
		if self.isExpert:
			self.afterSelectCryptDoAction = "changepassword"
			self.selectCryptFromList()
		else :
			self.changePasswordWindow()
		debug_end('function doChangePasswordEvent')
	
	def doFirstCreateEvent(self, event):
		debug_begin('function doFirstCreateEvent')
		self.workingFolder = self.home
		self.welcome_window.hide()
		self.getCryptPasswordThenAction("create")
		debug_end('function doFirstCreateEvent')
	
	def doReCreateEvent(self,menuItem):
		debug_begin('function doReCreateEvent')
		if not os.path.exists(decodeFilePath(self.default_crypt)):
			self.workingFolder = self.home
			self.getCryptPasswordThenAction("create")
		else : 
			dialog = gtk.MessageDialog( None, gtk.DIALOG_MODAL, gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO, _("WARNING\n\nRe Creating a Crypt will Destory it's contents\n\nAre you Sure?"))
			dialog.set_title(_("Warning"))
			dialog.width, dialog.height = dialog.get_size()
			icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
			gtk.window_set_default_icon_list( (icon) )
			ret = dialog.run()
			if ret==gtk.RESPONSE_YES:
				self.workingFolder = self.home
				self.getCryptPasswordThenAction("create")
			else:
				debug("they clicked no")
			dialog.destroy()
		debug_end('function doReCreateEvent')
		
	def doConfigEvent(self,menuItem):
		debug_begin('function doConfigEvent')
		self.showConfigWindow()
		debug_end('function doConfigEvent')
		
	def doCreateEvent(self,menuItem):
		debug_begin('function doCreateEvent')
		if self.lookForTruecrypt():
			self.chooseNewCryptLocation()
			if self.selectedCrypt != "":
				for k in sorted(self.currentCrypts.keys()):
					mountPoint = self.currentCrypts[k]
					#if we try to create a new crypt in another crypt
					if self.selectedCrypt.find(mountPoint+"/") > -1 :
						del(self.currentCrypts[self.selectedCrypt])
						self.selectedCrypt = ""
						dialog = gtk.MessageDialog( None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_OK, _("A crypt cannot be stored within another crypt\n\nPlease select another location"))
						dialog.set_title(_("Unable to make crypt"))
						dialog.width, dialog.height = dialog.get_size()
						icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
						gtk.window_set_default_icon_list( (icon) )
						ret = dialog.run()
						dialog.destroy()
						self.doCreateEvent(None)
						debug_end('function doCreateEvent')
						return
				self.getCryptPasswordThenAction("create")
		debug_end('function doCreateEvent')
	
	def doOpenEvent(self,menuItem):
		debug_begin('function doOpenEvent')
		
		if self.lookForTruecrypt():
			
			self.workingFolder = self.home
			
			if self.isExpert:
				self.selectCurrentCryptLocation()
			
			if self.selectedCrypt != "":
			
				cryptLocation = self.selectedCrypt
		
				if not self.checkOpened():
					debug("Checking for crypt " + cryptLocation)
					if not os.path.exists(decodeFilePath(cryptLocation)):
						debug("need to make crypt " + cryptLocation)
						dialog = gtk.MessageDialog( None, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, _("There is no Crypt made\n\nWe need to make a new Crypt"))
						dialog.set_title(_("No Crypt found"))
						dialog.width, dialog.height = dialog.get_size()
						icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
						gtk.window_set_default_icon_list( (icon) )
						ret = dialog.run()
						dialog.destroy()
						self.getCryptPasswordThenAction("create")
					else:	
						self.getCryptPasswordThenAction("open")
				else:
					if self.isExpert:
						debug("Already Opened")
						self.selectedCrypt = ""
						dialog = gtk.MessageDialog( None, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, _("This Crypt is already open"))
						dialog.set_title(_("Crypt already open"))
						dialog.width, dialog.height = dialog.get_size()
						icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
						gtk.window_set_default_icon_list( (icon) )
						ret = dialog.run()
						dialog.destroy()	
						
		debug_end('function doOpenEvent')
						
				
	def doCloseEvent(self,menuItem):
		debug_begin('function doCloseEvent')
		if self.isExpert:
			self.afterSelectCryptDoAction = "close"
			self.selectCryptFromList()
		else:	
			self.closeCrypt(True)
		debug_end('function doCloseEvent')
			
	def showConfigWindow(self):
		debug_begin('function doShowConfigWindow')
		self.config_window = gtk.Window( gtk.WINDOW_TOPLEVEL )	
		self.config_window.set_title(_("Preferences"))
		self.config_window.set_border_width( 5 )
		self.config_window.set_position( gtk.WIN_POS_CENTER )
		self.config_window.set_modal( gtk.TRUE )
		self.config_window.set_resizable(gtk.FALSE)
		icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
		gtk.window_set_default_icon_list( (icon) )

		# Register eventsICON_PATH_WRONGFIRMWAR
		self.config_window.connect( "delete_event", self.onDelete_config )
		
		#window.show()
		self.config_window.resize(450,10)

		table = gtk.Table( rows=3, columns=2, homogeneous=gtk.FALSE )
		self.config_window.add(table)
		
		labelExpertOptions = gtk.Label()
		labelExpertOptions.set_markup('<span size="larger" weight="bold">'+_("General Options")+'</span>')
		table.attach( labelExpertOptions, 0, 2, 0, 1 )
		labelExpertOptions.show()
		
		# authtype here
		self.lbl_mode=gtk.Label(_("Easy Crypt Mode  "))
		self.lbl_mode.set_alignment(0, 0.5)
		self.cbo_mode=gtk.combo_box_new_text()
		if (self.easyCryptConfig.getOption("mode") == _("expert")):
			self.cbo_mode.append_text(_("expert"))
			self.cbo_mode.append_text(_("normal"))
		else:
			self.cbo_mode.append_text(_("normal"))
			self.cbo_mode.append_text(_("expert"))
		self.cbo_mode.set_active(0)
		# Attach combobox and label
		table.attach( self.lbl_mode, 0, 1, 1, 2 )
		self.lbl_mode.show()
		table.attach( self.cbo_mode, 1, 2, 1, 2, ypadding=0 )
		self.cbo_mode.show()
		
		# Checkbox for Autostart on login
		alignment = gtk.Alignment( 0.0, 0.0, 0.0, 0.0 )
		self.autostart_on_login = gtk.CheckButton(_("Auto Start on Login"))
		alignment.add( self.autostart_on_login )

		table.attach( alignment, 0, 2, 2, 3 )
		alignment.show()
		if self.easyCryptConfig.getOption("autostart_on_login") == "yes":
			self.autostart_on_login.set_active( gtk.TRUE )
		else:
			self.autostart_on_login.set_active( gtk.FALSE )
		self.autostart_on_login.show()
		
		# Checkbox for Use Only Stock Icons
		alignment = gtk.Alignment( 0.0, 0.0, 0.0, 0.0 )
		self.use_stock_icons = gtk.CheckButton(_("Use Standard Theme Icons"))
		alignment.add( self.use_stock_icons )

		table.attach( alignment, 0, 2, 3, 4 )
		alignment.show()
		if self.easyCryptConfig.getOption("use_stock_icons") == "yes":
			self.use_stock_icons.set_active( gtk.TRUE )
		else:
			self.use_stock_icons.set_active( gtk.FALSE )
		self.use_stock_icons.show()
		
		
		separator = gtk.HSeparator()
		table.attach( separator, 0, 2, 4, 5 )
		separator.show()
		
		labelExpertOptions = gtk.Label()
		labelExpertOptions.set_markup('\n<span size="larger" weight="bold">'+_("Expert Options")+'</span>')
		table.attach( labelExpertOptions, 0, 2, 5, 6 )
		labelExpertOptions.show()
		
		# Checkbox for Use Crypt filename as mount name
		alignment = gtk.Alignment( 0.0, 0.0, 0.0, 0.0 )
		self.use_filename_as_mountname = gtk.CheckButton(_("Use Crypt filename as mount name"))
		alignment.add( self.use_filename_as_mountname )
		table.attach( alignment, 0, 2, 6, 7 )
		alignment.show()
		if self.easyCryptConfig.getOption("use_filename_as_mountname") == "yes":
			self.use_filename_as_mountname.set_active( gtk.TRUE )
		else:
			self.use_filename_as_mountname.set_active( gtk.FALSE )
		self.use_filename_as_mountname.show()
		
		# Checkbox for Use Crypt filename as mount name
		alignment = gtk.Alignment( 0.0, 0.0, 0.0, 0.0 )
		self.show_keyfile_options = gtk.CheckButton(_("Show Keyfile options"))
		alignment.add( self.show_keyfile_options )
		table.attach( alignment, 0, 2, 7, 8 )
		alignment.show()
		if self.easyCryptConfig.getOption("show_keyfile_options") == "yes":
			self.show_keyfile_options.set_active( gtk.TRUE )
		else:
			self.show_keyfile_options.set_active( gtk.FALSE )
		self.show_keyfile_options.show()
		
		# Checkbox for Modify Mount Path
		alignment = gtk.Alignment( 0.0, 0.0, 0.0, 0.0 )
		self.show_modifiable_mount_path_options = gtk.CheckButton(_("Modifiable Mount Path"))
		alignment.add( self.show_modifiable_mount_path_options )
		table.attach( alignment, 0, 2, 8, 9 )
		alignment.show()
		if self.easyCryptConfig.getOption("modifiable_mount_path") == "yes":
			self.show_modifiable_mount_path_options.set_active( gtk.TRUE )
		else:
			self.show_modifiable_mount_path_options.set_active( gtk.FALSE )
		self.show_modifiable_mount_path_options.show()
		
		# Add 'Save' button
		button_close = gtk.Button( stock=gtk.STOCK_CANCEL )
		table.attach( button_close, 0, 1, 9, 10, ypadding=1 )

		button_close.connect( "clicked", self.onDelete_config )
		button_close.show()

		# Add 'Save' button
		button_save = gtk.Button( stock=gtk.STOCK_OK )
		table.attach( button_save, 1, 2, 9, 10, ypadding=1 )
		button_save.connect( "clicked", self.saveConfig )
		button_save.show()


		table.show()
		self.config_window.show()
		debug_end('function doShowConfigWindow')
		
	def saveConfig(self, event):
		debug_begin('function saveConfig')
		modeChanged = True;
		
		iter = self.cbo_mode.get_active_iter()
		selectedMode = self.cbo_mode.get_model().get_value(iter, 0)
		debug("setting mode to "+selectedMode+" old setting "+self.easyCryptConfig.getOption("mode"))
		if selectedMode == self.easyCryptConfig.getOption("mode"):
			modeChanged = False	
		
		self.easyCryptConfig.setOption("mode",selectedMode)
		
		if self.autostart_on_login.get_active() == gtk.TRUE :
			self.easyCryptConfig.setOption("autostart_on_login","yes")
		else:
			self.easyCryptConfig.setOption("autostart_on_login","no")
			
		if self.use_stock_icons.get_active() == gtk.TRUE :
			self.easyCryptConfig.setOption("use_stock_icons","yes")
		else:
			self.easyCryptConfig.setOption("use_stock_icons","no")
		
		if self.use_filename_as_mountname.get_active() == gtk.TRUE :
			self.easyCryptConfig.setOption("use_filename_as_mountname","yes")
		else:
			self.easyCryptConfig.setOption("use_filename_as_mountname","no")
		
		if self.show_keyfile_options.get_active() == gtk.TRUE :
			self.easyCryptConfig.setOption("show_keyfile_options","yes")
		else:
			self.easyCryptConfig.setOption("show_keyfile_options","no")
		
		if self.show_modifiable_mount_path_options.get_active() == gtk.TRUE :
			self.easyCryptConfig.setOption("modifiable_mount_path","yes")
		else:
			self.easyCryptConfig.setOption("modifiable_mount_path","no")
		
		# Now Save
		self.easyCryptConfig.writeConfig()

		# Now do Any actions needed
		if self.easyCryptConfig.getOption("autostart_on_login") == "yes":
			self.createAutoStartOnLoginFile()
		else :
			self.removeAutoStartOnLoginFile()
			
		self.onDelete_config(None, None)
		
		if modeChanged:
			
			needWarn = False
			if self.isExpert:
				# note this is still the old one
				if len(self.currentCrypts) > 0:
						needWarn = True
			else:
				# note this is if the old setting was normal
				if self.checkOpened():
					needWarn = True
			
			if needWarn:
				dialog = gtk.MessageDialog( None, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, _("You have changed the Mode\n\nAny Crypts you have open will now be closed."))
				dialog.width, dialog.height = dialog.get_size()
				icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
				gtk.window_set_default_icon_list( (icon) )
				ret = dialog.run()
				dialog.destroy()
			
			self.closeAllCrypts()
			
			self.currentCrypts.clear()
			self.selectedCrypt = ""		
			
			if self.easyCryptConfig.getOption("mode") == _("normal"):
				self.isExpert = False
			else :
				self.isExpert = True
				
			self.popup_menu = EasyCryptPopupMenu.EasyCryptPopupMenu(self)
			
			if not self.isExpert :
				self.currentCrypts[self.default_crypt] = self.default_mount
				self.selectedCrypt = self.default_crypt
			
			self.updateTrayIcon()
			
		debug_end('function saveConfig')
		
	def removeAutoStartOnLoginFile(self):
		debug_begin('function removeAutoStartOnLoginFile')
		autoThere = False
		if os.path.exists(os.path.join(self.home, ".config/autostart/easycrypt.desktop")):
			debug("Found one!")
			autoThere = True			
		if autoThere :
			#Replace this with proper Python one
			debug("Removing old autostart on login")
			outputString = commands.getoutput("rm ~/.config/autostart/easycrypt.desktop")
			if len(outputString) > 0 : debug(outputString)
		debug_end('function removeAutoStartOnLoginFile')

	def createAutoStartOnLoginFile(self):
		debug_begin('function createAutoStartOnLoginFile')

		if not os.path.exists(os.path.join(self.home, ".config/autostart")): 
			outputString = commands.getoutput("mkdir -p ~/.config/autostart")
			if len(outputString) > 0 : debug(outputString)
		outputString = commands.getoutput("cp "+APP_PATH +" ~/.config/autostart/")
		if len(outputString) > 0 :debug(outputString)		
		debug_end('function createAutoStartOnLoginFile')
	
	def onDelete_about( self, widget, data=None ):
		debug_begin('function onDelete_about')
		self.about_window.destroy()
		debug_end('function onDelete_about')
	
	def onDelete_welcome( self, widget, data=None ):
		debug_begin('function onDelete_welcome')
		self.welcome_window.destroy()	
		debug_end('function onDelete_welcome')
	
	def onDelete_password_window( self, widget, data=None ):
		debug_begin('function onDelete_password_window')
		if self.isExpert:
			if self.selectedCrypt != "":
				debug("clearing crypt from list")
				del(self.currentCrypts[self.selectedCrypt])
				self.selectedCrypt = ""	
		self.password_window.destroy()
		debug_end('function onDelete_password_window')
		
	def onDelete_change_password_window( self, widget, data=None ):
		debug_begin('function onDelete_change_password_window')
		self.password_change_window.destroy()
		debug_end('function onDelete_change_password_window')
		
	def onDelete_select_crypt_window( self, widget, data=None ):
		debug_begin('function onDelete_select_crypt_window')
		self.select_crypt_window.destroy()
		debug_end('function onDelete_select_crypt_window')
		
	def onDelete_config( self, widget, data=None ):
		debug_begin('function onDelete_config')
		self.config_window.destroy()
		debug_end('function onDelete_config')
		
	def showAboutWindowEvent(self,menuItem):
		debug_begin('function showAboutWindowEvent')
		self.showAboutWindow()
		debug_end('function showAboutWindowEvent')

	def hide(self):
		debug_begin('function hide')
		self.window.hide()
		debug_end('function hide')

	def onDelete(self, widget, data=None ):
		debug_begin('function onDelete')
		self.exit(None)
		debug_end('function onDelete')
		return gtk.TRUE 
	
	def exit(self, event):
		debug_begin('function exit')
		needToPrompt = False

		if self.isExpert :
			# if we have some crypts open, do some stuff
			if len(self.currentCrypts) > 0 :
				needToPrompt = True
				dialogText = _("Easy Crypt still has the following Crypts open")+"\n"
				for k in sorted(self.currentCrypts.keys()):
					mountPoint = self.currentCrypts[k]
					dialogText = dialogText + "\n" + decodeFilePath(k) + " : " + decodeFilePath(mountPoint)
				# at the end, add end of message
				dialogText = dialogText + "\n\n"+_("These Crypts will be closed if you close Easy Crypt")
		else :
			if self.checkOpened() :
				needToPrompt = True
				dialogText = _("Easy Crypt still has the Crypt Open\n\nThe Crypt will be closed if you close Easy Crypt")

		if needToPrompt:	
			dialogText = dialogText + "\n\n" + _("Are you sure you want to close Easy Crypt?")
			dialog = gtk.MessageDialog( None, gtk.DIALOG_MODAL, gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO, dialogText)
			dialog.set_title(_("Are you sure"))
			dialog.width, dialog.height = dialog.get_size()
			icon = gtk.gdk.pixbuf_new_from_file(self.ICON_PATH_WINDOW)
			gtk.window_set_default_icon_list( (icon) )
			ret = dialog.run()
			if ret==gtk.RESPONSE_YES:
				debug("they clicked yes")
				self.closeAllCrypts();
				dialog.destroy()
				debug_end('function exit')
				gtk.main_quit(0)
			else:
				debug("they clicked no")
				dialog.destroy()
		else :
			gtk.main_quit(0)
		debug_end('function exit')
					

	def main(self):
		gtk.main()

def start():
	warnings.filterwarnings( action="ignore", category=DeprecationWarning)
	theEasyCrypt = EasyCrypt()
	#parse options
	parser = optparse.OptionParser()
	parser.add_option("-d", "--debug", dest="debug",action="store_true", default = False, help=theEasyCrypt._("enable debug output to console"))
	(options, args) = parser.parse_args()
	global DEBUG
	DEBUG = options.debug

	if theEasyCrypt.checkWeAreAlone():
		exit(0)
	try:
		theEasyCrypt.lookForTruecrypt()
		theEasyCrypt.main()
	except KeyboardInterrupt:
		debug("closing")
		theEasyCrypt.closeAllCrypts()

if __name__ == "__main__":
	start()
