function [L, U, P] = ilu(A, setup)
% Partially implement function ilu using the (now deprecated) luinc

% Copyright (C) 2013 Dynare Team
%
% This file is part of Dynare.
%
% Dynare is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% Dynare is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Dynare.  If not, see <http://www.gnu.org/licenses/>.

  if nargout ~= 2
      error('Only two output arguments supported')
  end
  if nargin ~= 2
      error('Only two input arguments supported')
  end

  if isfield(setup, 'type')
      if setup.type ~= 'ilutp'
          error(['Unsupported type: ' setup.type ])
      end
  end
  
  if isfield(setup, 'milu')
      if setup.milu == 'off'
          setup.milu = 0;
      else
          error(['Unsupported milu: ' setup.milu ])
      end
  end
  
  [L, U] = luinc(A, setup);
end
