/*  $Header: /cvsroot/dvipdfmx/src/pdfobj.h,v 1.14 2004/03/14 04:23:03 hirata Exp $

    This is dvipdfmx, an eXtended version of dvipdfm by Mark A. Wicks.

    Copyright (C) 2002 by Jin-Hwan Cho and Shunsaku Hirata,
    the dvipdfmx project team <dvipdfmx@project.ktug.or.kr>
    
    Copyright (C) 1998, 1999 by Mark A. Wicks <mwicks@kettering.edu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
*/

#ifndef _PDFOBJ_H_
#define _PDFOBJ_H_

#include <stdio.h>

/* Here is the complete list of PDF object types */

#define	PDF_BOOLEAN	1
#define	PDF_NUMBER	2
#define PDF_STRING	3
#define PDF_NAME	4
#define PDF_ARRAY	5
#define PDF_DICT	6
#define PDF_STREAM	7
#define PDF_NULL        8
#define PDF_INDIRECT	9

#define PDF_OBJ_INVALID 0
#define PDF_UNDEFINED   PDF_OBJ_INVALID

typedef int pdf_obj_type;

#define STREAM_COMPRESS (1 << 0)

typedef struct pdf_obj      pdf_obj;
typedef void                pdf_null;
typedef struct pdf_boolean  pdf_boolean;
typedef struct pdf_number   pdf_number;
typedef struct pdf_string   pdf_string;
typedef struct pdf_name     pdf_name;
typedef struct pdf_array    pdf_array;
typedef struct pdf_dict     pdf_dict;
typedef struct pdf_stream   pdf_stream;
typedef struct pdf_indirect pdf_indirect;

/* External interface to pdf routines */

extern void     pdf_obj_set_verbose (void);
extern void     pdf_error_cleanup (void);

extern void     pdf_out_init      (const char *filename);
extern void     pdf_out_flush     (void);
extern void     pdf_set_version   (unsigned version);
extern unsigned pdf_get_version   (void);

extern pdf_obj *pdf_new_obj     (int type);
extern void     pdf_release_obj (pdf_obj *object);
extern int      pdf_obj_typeof  (pdf_obj *object);

#define PDF_OBJ_NUMBERTYPE(o)   ((o) && pdf_obj_typeof((o)) == PDF_NUMBER)
#define PDF_OBJ_BOOLEANTYPE(o)  ((o) && pdf_obj_typeof((o)) == PDF_BOOLEAN)
#define PDF_OBJ_STRINGTYPE(o)   ((o) && pdf_obj_typeof((o)) == PDF_STRING)
#define PDF_OBJ_NAMETYPE(o)     ((o) && pdf_obj_typeof((o)) == PDF_NAME)
#define PDF_OBJ_ARRAYTYPE(o)    ((o) && pdf_obj_typeof((o)) == PDF_ARRAY)
#define PDF_OBJ_NULLTYPE(o)     ((o) && pdf_obj_typeof((o)) == PDF_NULL)
#define PDF_OBJ_DICTTYPE(o)     ((o) && pdf_obj_typeof((o)) == PDF_DICT)
#define PDF_OBJ_STREAMTYPE(o)   ((o) && pdf_obj_typeof((o)) == PDF_STREAM)
#define PDF_OBJ_INDIRECTTYPE(o) ((o) && pdf_obj_typeof((o)) == PDF_INDIRECT)

#define PDF_OBJ_TYPEOF(o)       pdf_obj_typeof((o))


extern pdf_obj *pdf_ref_obj     (pdf_obj *object);
extern pdf_obj *pdf_link_obj    (pdf_obj *object);

extern pdf_obj *pdf_new_null    (void);

extern pdf_obj *pdf_new_boolean   (char value);
extern void     pdf_set_boolean   (pdf_obj *object, char value);
extern char     pdf_boolean_value (pdf_obj *object);

/* ? */
extern void pdf_set_info    (pdf_obj *object);
extern void pdf_set_root    (pdf_obj *object);
extern void pdf_set_encrypt (pdf_obj *object);

extern pdf_obj *pdf_new_number   (double value);
extern void     pdf_set_number   (pdf_obj *object, double value);
extern double   pdf_number_value (pdf_obj *number);

extern pdf_obj  *pdf_new_string    (const void *str, unsigned length);
extern void      pdf_set_string    (pdf_obj *object, unsigned char *str, unsigned length);
extern void     *pdf_string_value  (pdf_obj *object);
extern unsigned  pdf_string_length (pdf_obj *object);

/* Name does not include the / */
extern pdf_obj *pdf_new_name   (const char *name);
extern void     pdf_set_name   (pdf_obj *object, const char *name);
extern char    *pdf_name_value (pdf_obj *object);

extern pdf_obj *pdf_new_array     (void);
extern void     pdf_add_array     (pdf_obj *array, pdf_obj *object);
#define pdf_push_array(a,e) pdf_add_array((a),(e))
extern void     pdf_put_array     (pdf_obj *array, unsigned idx, pdf_obj *object);
/* Negative index means array->size - idx. */
extern pdf_obj *pdf_get_array     (pdf_obj *array, long idx);
extern unsigned pdf_array_length  (pdf_obj *array);

extern void     pdf_unshift_array (pdf_obj *array, pdf_obj *object);
extern pdf_obj *pdf_shift_array   (pdf_obj *array);
extern pdf_obj *pdf_pop_array     (pdf_obj *array);

extern pdf_obj *pdf_new_dict    (void);
extern void     pdf_add_dict    (pdf_obj *dict,  pdf_obj *key, pdf_obj *value); 
extern void     pdf_remove_dict (pdf_obj *dict,  const char *name);
extern void     pdf_merge_dict  (pdf_obj *dict1, pdf_obj *dict2);
extern pdf_obj *pdf_lookup_dict (pdf_obj *dict,  const char *name);

extern void     pdf_obj_set_compression (int level);

extern pdf_obj *pdf_new_stream    (int flags);
extern void     pdf_add_stream    (pdf_obj *stream, const void *stream_data, long length);
extern pdf_obj *pdf_stream_dict   (pdf_obj *stream);
extern long     pdf_stream_length (pdf_obj *stream);
extern void     pdf_stream_set_flags (pdf_obj *stream, int flags);
extern int      pdf_stream_get_flags (pdf_obj *stream);
extern const void *pdf_stream_dataptr (pdf_obj *stream);

extern int      check_for_pdf (FILE *file);
extern pdf_obj *pdf_open      (FILE *file);
extern void     pdf_close     (void);

extern pdf_obj *pdf_deref_obj   (pdf_obj *object);
extern pdf_obj *pdf_read_object (unsigned long obj_no);

extern int pdfobj_escape_str (char *buffer, int size, const unsigned char *s, int len);

extern pdf_obj *pdf_new_ref (unsigned long label, int generation);

#endif  /* _PDFOBJ_H_ */
