/////////////////////////////////////////////////////////////////////////////
// Name:        StatusBar.cpp
// Purpose:     Status bar for main window
// Author:      Alex Thuering
// Created:     28.12.2008
// RCS-ID:      $Id: StatusBar.cpp,v 1.6 2012/04/15 12:06:54 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
#include "StatusBar.h"
#include "DVD.h"

class StatSideText: public wxControl {
public:
	StatSideText(wxWindow *parent): wxControl(parent, wxID_ANY) {}
	~StatSideText() {};
	virtual void OnPaint(wxPaintEvent& event);
	virtual void OnEraseBackground(wxEraseEvent &event) {}
private:
	DECLARE_EVENT_TABLE();
};

BEGIN_EVENT_TABLE(StatSideText, wxControl)
	EVT_PAINT(StatSideText::OnPaint)
	EVT_ERASE_BACKGROUND(StatSideText::OnEraseBackground)
END_EVENT_TABLE()

void StatSideText::OnPaint(wxPaintEvent &event) {
	wxPaintDC dc(this);
	wxCoord w, h, cw, ch;
	const wxString& label = wxControl::GetLabel();
	dc.GetTextExtent(label, &w, &h);
	GetClientSize(&cw, &ch);
	dc.DrawText(label, (cw-w)/2, 0);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// StatusBar ///////////////////////////////
/////////////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(StatusBar, wxStatusBar)
	EVT_SIZE(StatusBar::OnSize)
END_EVENT_TABLE()

StatusBar::StatusBar(wxWindow* parent): wxStatusBar(parent, wxID_ANY) {
	static const int widths[] = { -1, 150, 136, 80 };
	SetFieldsCount(4, widths);
	m_gauge = new wxGauge(this, wxID_ANY, 100);
	m_fillText = new wxStaticText(this, wxID_ANY, wxT(""));
	m_bitrate = new wxStaticText(this, wxID_ANY, wxT(""));
}

StatusBar::~StatusBar() {
	// nothing to do
}

void StatusBar::SetFillStatus(long size, long sizeTotal, long fixSize, int fixDuration,
		int videoBitrate, bool videoBitrateAuto, int audioBitrate) {
	int dur = fixDuration + (size-fixSize)*8/(videoBitrate + audioBitrate)/60;
	int bitrateForTotal = !videoBitrateAuto || videoBitrate < 4500 ? videoBitrate : 4500;
	int durTotal = sizeTotal > 0 ? fixDuration + (sizeTotal-fixSize)*8/(bitrateForTotal + audioBitrate)/60 : 0;
	if (durTotal > 0)
		m_fillText->SetLabel(wxString::Format(_("%d/%d Minutes"), dur, durTotal));
	else
		m_fillText->SetLabel(wxString::Format(_("%d Minutes"), dur));
	m_fillText->SetForegroundColour(durTotal > 0 && dur > durTotal ? *wxRED : *wxBLACK);
	wxString text = videoBitrate % 1000 == 0
			? wxString::Format(_("%d MB/s"), videoBitrate/1000)
			: wxString::Format(_("%.1f MB/s"), ((double)videoBitrate)/1000);
	m_bitrate->SetLabel(text);
	m_bitrate->SetForegroundColour(videoBitrate >= 4500 ? *wxBLACK :
			(videoBitrate >= 3500 ? wxColour(200, 100, 0) : *wxRED));
	m_gauge->SetValue(durTotal > 0 ? dur * 100 / durTotal : 0);
}

void StatusBar::OnSize(wxSizeEvent& event) {
	wxRect rect;
	GetFieldRect(1, rect);
	m_gauge->SetSize(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
	GetFieldRect(2, rect);
	m_fillText->SetSize(rect.x + 3, rect.y + 3, rect.width - 3, rect.height - 3);
	GetFieldRect(3, rect);
	m_bitrate->SetSize(rect.x + 3, rect.y + 3, rect.width - 3, rect.height - 3);
	event.Skip();
}
