/////////////////////////////////////////////////////////////////////////////
// Name:        Config.h
// Purpose:     Configuration
// Author:      Alex Thuering
// Created:     27.03.2003
// RCS-ID:      $Id: Config.h,v 1.81 2012/11/05 21:13:14 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef DS_CONFIG_H
#define DS_CONFIG_H

#include <wx/wx.h>
#include <wx/config.h>
#include <wx/thread.h>
#include <wx/filename.h>

const wxString DEF_VERSION		= wxT("");
const int DEF_LANGUAGE			= wxLANGUAGE_UNKNOWN;
const wxString DEF_LANGUAGE_CODE= wxT("");
const wxString DEF_DISC_LABEL	= wxT("DVD");
const int DEF_DISC_CAPACITY		= 2;
const int DEF_POST_COMMAND		= 1;
const int DEF_VIDEO_FORMAT		= 2;
const int DEF_AUDIO_FORMAT		= 3;
const wxString DEF_AUDIO_LANG	= wxT("");
const wxString DEF_SUBTITLE_LANG= wxT("");
const int DEF_SPECT_RATIO		= 1;
const int DEF_CHAPTER_LENGTH	= 10;
const wxString DEF_BUTTON		= wxT("frame-v2.xml");
const wxString DEF_TEXT_BUTTON	= wxT("text-v3.xml");
const bool DEF_ACCEPT_INVALID_ACTIONS = false;
const wxString DEF_FILE_BROWSER_DIR = wxT("");
#define DEF_FILE_BROWSER_LAST_DIR wxGetHomeDir()
#define DEF_LAST_PROJECT_DIR wxGetHomeDir()
#define DEF_LAST_ADD_DIR wxGetHomeDir()
const int DEF_UNDO_HISTORY_SIZE = 100;
const bool DEF_REMOVE_TEMP = true;
const bool DEF_VBR = false;
const int DEF_VIDEO_BITRATE = -1;
const int DEF_AUDIO_BITRATE = 224;
const int DEF_MENU_FRAME_COUNT = 12;
const int DEF_MENU_VIDEO_BITRATE = 6000;
const bool DEF_DRAW_BUTTONS_ON_BACKGROUND = true;
const int DEF_SLIDESHOW_VIDEO_BITRATE = 6000;
const int DEF_THREAD_COUNT = wxThread::GetCPUCount() > 0 ? wxThread::GetCPUCount() : 1;
const int DEF_DVD_RESERVED_SPACE = 0; // KB
#define DEF_GEN_TEMP_DIR wxFileName::GetTempDir()
#ifdef __WXMSW__
	const bool DEF_PREVIEW_DO        = false;
	const wxString DEF_PREVIEW_CMD   = _T("wmplayer");
	const wxString DEF_BURN_DEVICE   = _T("");
	const wxString DEF_ADD_ECC_CMD   = _T("\"C:\\Program Files\\dvdisaster\\dvdisaster\" -mRS02 -n dvd -c -i \"$FILE\"");
#else
	const bool DEF_PREVIEW_DO        = true;
	const wxString DEF_PREVIEW_CMD   = _T("xine \"dvd:/$DIR\"");
	const wxString DEF_BURN_DEVICE   = _T("/dev/dvd");
	const wxString DEF_ADD_ECC_CMD   = _T("dvdisaster -mRS02 -n dvd -c -i \"$FILE\"");
#endif
const bool DEF_USE_MPLEX = false;
const bool DEF_USE_MPLEX_FOR_MENUS = true;
#ifdef USE_FFMPEG
const wxString DEF_AVCONV_CMD    = _T("ffmpeg");
#else
const wxString DEF_AVCONV_CMD    = _T("avconv");
#endif
const wxString DEF_MPLEX_CMD     = _T("mplex -f 8 -S 0 -M -V -o \"$FILE_OUT\" \"$FILE_VIDEO\" \"$FILE_AUDIO\"");
const wxString DEF_SPUMUX_CMD    = _T("spumux -P -s $STREAM \"$FILE_CONF\"");
const wxString DEF_DVDAUTHOR_CMD = _T("dvdauthor -o \"$DIR\" -x \"$FILE_CONF\"");
const wxString DEF_ISO_CMD       = _T("mkisofs -V \"$VOL_ID\" -o \"$FILE\" -dvd-video \"$DIR\"");
const wxString DEF_ISO_SIZE_CMD  = _T("mkisofs -quiet -print-size \"$DIR\"");
const wxString DEF_BURN_SCAN_CMD = _T("dvd+rw-mediainfo $DEVICE");
const wxString DEF_BURN_CMD      = _T("growisofs -V \"$VOL_ID\" -dvd-compat -Z $DEV -dvd-video \"$DIR\" $SPEEDSTR");
const wxString DEF_BURN_SPEED_OPT= _T("-speed=$SPEED");
#ifdef __WXMAC__
const wxString DEF_BURN_ISO_CMD  = _T("/usr/bin/hdiutil burn -device \"$DEV\" $SPEEDSTR \"$FILE\"");
const wxString DEF_FORMAT_CMD    = _T("/usr/bin/hdiutil burn -device \"$DEV\" -erase");
#else
const wxString DEF_BURN_ISO_CMD  = _T("growisofs -dvd-compat -Z $DEV=\"$FILE\" -use-the-force-luke=dao:$SIZE $SPEEDSTR");
const wxString DEF_FORMAT_CMD    = _T("dvd+rw-format -force $DEV");
#endif
const bool DEF_GENERATE_DO       = false;
const bool DEF_ISO_DO            = false;
const bool DEF_BURN_DO           = true;
const bool DEF_FORMAT_DO         = false;
#define DEF_ISO_SAVETO (wxGetHomeDir() + wxFILE_SEP_PATH)
const int DEF_BURN_SPEED         = 0;
const bool DEF_ADD_ECC_DO        = false;

#define CONFIG_PROP(name, cfgName, defValue)\
  CONFIG_PROP_T(name, cfgName, defValue, wxString, wxString)

#define CONFIG_PROP_BOOL(name, cfgName, defValue)\
  CONFIG_PROP_T(name, cfgName, defValue, bool, long)

#define CONFIG_PROP_INT(name, cfgName, defValue)\
  CONFIG_PROP_T(name, cfgName, defValue, int, long)

#define CONFIG_PROP_T(name, cfgName, defValue, cfgType, cfgType2)\
  cfgType Get##name(bool def = false)\
  { return def ? (cfgType2) defValue : cfg->Read(cfgName, (cfgType2) defValue); }\
  void Set##name(cfgType value)\
  { wxLogNull log; if (value == defValue) cfg->DeleteEntry(cfgName); else cfg->Write(cfgName, value); }

class Config {
public:
    void Init();
    bool Flush() { return cfg->Flush(); }
    bool DeleteAll() { return cfg->DeleteAll(); }
    bool DeleteGroup(wxString group) { return cfg->DeleteGroup(group); }
	
    bool IsMainWinMaximized();
    wxRect GetMainWinLocation();
    void SetMainWinLocation(wxRect rect, bool isMaximized);
    
    wxConfigBase* GetConfigBase() { return cfg; }
	
	CONFIG_PROP(Version,  _T("Version"), DEF_VERSION)
	CONFIG_PROP(LanguageCode, _T("Interface/LanguageCode"), DEF_LANGUAGE_CODE)
    CONFIG_PROP(DefDiscLabel, _T("Interface/DefDiscLabel"), DEF_DISC_LABEL)
    CONFIG_PROP_INT(DefDiscCapacity, _T("Interface/DefDiscCapacity"), DEF_DISC_CAPACITY)
    CONFIG_PROP_INT(DefPostCommand, _T("Interface/DefPostCommand"), DEF_POST_COMMAND)
	
	CONFIG_PROP_INT(DefVideoFormat, _T("Interface/DefVideoFormat"), DEF_VIDEO_FORMAT)
	CONFIG_PROP_INT(DefAudioFormat, _T("Interface/DefAudioFormat"), DEF_AUDIO_FORMAT)
	CONFIG_PROP(DefAudioLanguage, _T("Interface/DefAudioLanguage"), DEF_AUDIO_LANG)
	CONFIG_PROP(DefSubtitleLanguage, _T("Interface/DefSubtitleLanguage"), DEF_SUBTITLE_LANG)
	CONFIG_PROP_INT(DefAspectRatio, _T("Interface/DefAspectRatio"), DEF_SPECT_RATIO)
	CONFIG_PROP_INT(DefChapterLength, _T("Interface/DefChapterLength"), DEF_CHAPTER_LENGTH)
	CONFIG_PROP(DefButton, _T("Interface/DefButton"), DEF_BUTTON)
	CONFIG_PROP(DefTextButton, _T("Interface/DefTextButton"), DEF_TEXT_BUTTON)
	CONFIG_PROP_BOOL(AcceptInvalidActions, _T("Interface/AcceptInvalidActions"), DEF_ACCEPT_INVALID_ACTIONS)
	CONFIG_PROP(FileBrowserDir, _T("Interface/FileBrowserDir"), DEF_FILE_BROWSER_DIR)
	CONFIG_PROP(FileBrowserLastDir, _T("Interface/FileBrowserLastDir"), DEF_FILE_BROWSER_LAST_DIR)
	CONFIG_PROP(LastProjectDir, _T("Interface/LastProjectDir"), DEF_LAST_PROJECT_DIR)
	CONFIG_PROP(LastAddDir, _T("Interface/LastAddDir"), DEF_LAST_ADD_DIR)
	CONFIG_PROP_INT(UndoHistorySize, _T("Interface/UndoHistorySize"), DEF_UNDO_HISTORY_SIZE)
	CONFIG_PROP_BOOL(ShowWelcomeDlg, _T("Interface/ShowWelcomeDlg"), true)
	CONFIG_PROP_BOOL(ShowTitleDeletePrompt, _T("Interface/ShowTitleDeletePrompt"), true)
	CONFIG_PROP_BOOL(ClearThumbnailCache, _T("Interface/ClearThumbnailCache"), true)
	
	CONFIG_PROP(TempDir, _T("Generate/TempDir"), DEF_GEN_TEMP_DIR)
	CONFIG_PROP_BOOL(RemoveTempFiles, _T("Generate/RemoveTempFiles"), DEF_REMOVE_TEMP)
	CONFIG_PROP_INT(Vbr, _T("Generate/Vbr"), DEF_VBR)
	CONFIG_PROP_INT(VideoBitrate, _T("Generate/VideoBitrate"), DEF_VIDEO_BITRATE)
	CONFIG_PROP_INT(AudioBitrate, _T("Generate/AudioBitrate"), DEF_AUDIO_BITRATE)
	CONFIG_PROP_INT(MenuFrameCount,_T("Generate/MenuFrameCount"), DEF_MENU_FRAME_COUNT)
	CONFIG_PROP_INT(MenuVideoBitrate, _T("Generate/MenuVideoBitrate"), DEF_MENU_VIDEO_BITRATE)
	CONFIG_PROP_BOOL(DrawButtonsOnBackground, _T("Generate/DrawButtonsOnBackground"), DEF_DRAW_BUTTONS_ON_BACKGROUND)
    CONFIG_PROP_INT(SlideshowVideoBitrate, _T("Generate/SlideshowVideoBitrate"), DEF_SLIDESHOW_VIDEO_BITRATE)
    CONFIG_PROP_INT(ThreadCount, _T("Generate/ThreadCount"), DEF_THREAD_COUNT)
    CONFIG_PROP_INT(DvdReservedSpace, _T("Generate/DvdReservedSpace"), DEF_DVD_RESERVED_SPACE)
    CONFIG_PROP_BOOL(UseMplex, _T("Generate/UseMplex"), DEF_USE_MPLEX)
    CONFIG_PROP_BOOL(UseMplexForMenus, _T("Generate/UseMplexForMenus"), DEF_USE_MPLEX_FOR_MENUS)
    CONFIG_PROP(AVConvCmd, _T("Generate/AVConvCmd"), DEF_AVCONV_CMD)
    CONFIG_PROP(MplexCmd, _T("Generate/MplexCmd"), DEF_MPLEX_CMD)
	CONFIG_PROP(SpumuxCmd, _T("Generate/SpumuxCmd"), DEF_SPUMUX_CMD)
	CONFIG_PROP(DvdauthorCmd, _T("Generate/DvdauthorCmd"), DEF_DVDAUTHOR_CMD)
	
	CONFIG_PROP_BOOL(PreviewDo, _T("Preview/Do"), DEF_PREVIEW_DO)
	CONFIG_PROP(PreviewCmd, _T("Preview/Cmd"), DEF_PREVIEW_CMD)
	
	CONFIG_PROP_BOOL(GenerateDo, _T("Generate/Do"), DEF_GENERATE_DO)
	
	CONFIG_PROP_BOOL(IsoDo, _T("Iso/Do"), DEF_ISO_DO)
	CONFIG_PROP(IsoCmd, _T("Iso/Cmd"), DEF_ISO_CMD)
	CONFIG_PROP(IsoSizeCmd, _T("Iso/SizeCmd"), DEF_ISO_SIZE_CMD)
	CONFIG_PROP(IsoSaveTo,  _T("Iso/SaveTo"), DEF_ISO_SAVETO)
	
	CONFIG_PROP_BOOL(BurnDo, _T("Burn/Do"), DEF_BURN_DO)
	CONFIG_PROP(BurnCmd, _T("Burn/Cmd"), DEF_BURN_CMD)
	CONFIG_PROP(BurnISOCmd, _T("Burn/ISOCmd"), DEF_BURN_ISO_CMD)
	CONFIG_PROP(BurnDevice, _T("Burn/Device"), DEF_BURN_DEVICE)
	CONFIG_PROP(BurnScanCmd, _T("Burn/ScanSmd"), DEF_BURN_SCAN_CMD)
	CONFIG_PROP(BurnSpeedOpt, _T("Burn/SpeedOpt"), DEF_BURN_SPEED_OPT)
	CONFIG_PROP_INT(BurnSpeed, _T("Burn/Speed"), DEF_BURN_SPEED)
	
	CONFIG_PROP_BOOL(FormatDo, _T("Burn/FormatDo"), DEF_FORMAT_DO)
	CONFIG_PROP(FormatCmd, _T("Burn/FormatCmd"), DEF_FORMAT_CMD)
	
	CONFIG_PROP_BOOL(AddECCDo, _T("AddECC/Do"), DEF_ADD_ECC_DO)
	CONFIG_PROP(AddECCCmd, _T("AddECC/Cmd"), DEF_ADD_ECC_CMD)
	
  protected:
    wxConfigBase* cfg;
};

extern Config s_config;

#endif //DS_CONFIG_H
