#! /bin/bash

#  dvdisaster: German homepage translation
#  Copyright (C) 2004-2007 Carsten Gnrlich
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA,
#  or direct your browser at http://www.gnu.org.

# ----- Translations for phrases used in create.bash

function dictionary_de()
{  trans_encoding="ISO-8859-1"

   trans_version="Version"

   trans_to_internet="Zur Internet-Version"
   trans_to_berlios="bersicht (auf BerliOS)"
   trans_to_sourceforge="bersicht (auf SourceForge.net)"

   trans_back="Zurck"

   trans_contents="Inhalt"
   trans_hosting="Diese Seiten liegen auf"

   trans_fdl="Die unvernderte Wiedergabe und Verteilung dieses gesamten Textes in beliebiger Form ist gestattet, sofern dieser Hinweis erhalten bleibt."
   trans_copyright="Copyright 2004-2007 Carsten Gnrlich."
   trans_modified="Die Informationen in diesem Handbuch beziehen sich auf die Originalversion von dvdisaster und sind mglicherweise nicht zutreffend."
}


# ----- These are the "inlined" html pages.

function inline_contents_de()
{  title="Abbildung(en)"
}

function inline1de()
{  cat >> $1 <<EOF

<tr align="center"><td><h3>Abbildung: Stark verkratzter Datentrger</h3><p></td></tr>
<tr align="center"><td>
<center><img src="../images/scratch-img.jpg" alt="verkratzter Datentrger"></center>
<br clear="all">
</td></tr>
<tr><td>
Dieser Datentrger wurde ohne Hlle in einem Rucksack transportiert;
die runden Abdrcke stammen von einer Flasche Mineralwasser. Die Kratzer
erscheinen in dem Foto allerdings durch Reflektionen
des Blitzlichtes etwas berzeichnet.</td></tr>
EOF
}

function inline2de()
{  cat >> $1 <<EOF

<tr align="center"><td><h3>Abbildungen: Fehleranalyse</h3><p></td></tr>
<tr align="center"><td>
<center><img src="images/scratch-scan.png" alt="Verkratzten Datentrger einlesen"></center>
<br clear="all">
</td></tr>
<tr><td>
Beim Einlesen von Datentrgern zeigt dvdisaster die Lesegeschwindigkeit (blaue Kurve) 
und die Anzahl der Lesefehler an. Mit Hilfe der Spirale kann man die ungefhre Verteilung
der Lesefehler von innen nach auen abschtzen. Die Mastblichkeit der
Darstellung darf aber nicht berinterpretiert werden, da der exakte Winkel zwischen zwei Segmenten
aus technischen Grnden nicht den wirklichen Verhltnissen auf dem Datentrger entspricht.
<pre> 

</pre>
</td></tr>
<tr align="center"><td>
<center><img src="images/scratch-corr.png" alt="Verkratzten Datentrger reparieren"></center>
<br clear="all">
</td></tr>
<tr><td>
Dieses Diagramm zeigt die zu korrigierenden Fehler pro Fehlerkorrekturbereich und vermittelt
damit einen Eindruck von der Auslastung der <a href="background10.html">Fehlerkorrektur</a> von dvdisaster.

Die Fehlerkurve entspricht <i>nicht</i> der rumlichen Anordnung der Lesefehler
auf dem Datentrger, denn das Verfahren basiert gerade darauf, 
die Lesefehler gleichmig ber alle Fehlerkorrekturbereiche zu verteilen.<p>

Pro Fehlerkorrekturbereich knnen bei Verwendung der
Grundeinstellungen maximal 32 Lesefehler repariert werden (grne Linie).
Wenn diese Linie berschritten wird, ist der Inhalt des Datentrgers 
nicht mehr vollstndig wiederherstellbar.

</td></tr>
EOF
}

# ----- Individual page contents 

# ----- Default home page

function index_contents_de()
{  local file="$1.html"
   local query=$2
   local page=$3
   local lang=$4

   case $query in
   title)   title="berblick" ;;

   link)    link_title="berblick" ;;
   link0)   link_title="berblick" ;;
   link10)   link_title="Beispiele fr die Fehlerkorrektur" ;;   
   link20)   link_title="dvdisaster ergnzt PI/PO-Analysen" ;;
   link30)   link_title="Vor- und  Nachteile von dvdisaster" ;;

   content*) eval "index$page$lang $file" ;;
   esac 
}

function index0de()
{  cat >> $1 <<EOF

<h3>Das dvdisaster-Projekt</h3>

CD- und DVD-Datentrger behalten ihre Daten nur eine endlich lange Zeit (normalerweise
viele Jahre). Danach beginnt typischerweise ein langsamer Datenverlust, 
indem von auen nach innen immer mehr Lesefehler auftreten.<p>

<b>Archivieren mit Schutz vor Datenverlust</b><p>

dvdisaster archiviert Daten so auf CD/DVD (<a href="qa10.html#media">untersttzte Formate</a>), 
da sie auch dann noch wiederherstellbar sind, 
wenn der Datentrger bereits einige Lesefehler enthlt. Dadurch
knnen Sie Ihre Daten noch vollstndig auf einen neuen Datentrger retten.<p>

Der Schutz vor Datenverlust geschieht durch das Anlegen von Fehlerkorrektur-Daten.
Diese werden entweder dem Datentrger hinzugefgt oder
in zustzlichen Fehlerkorrektur-Dateien aufbewahrt. 
dvdisaster arbeitet auf der <a href="background20.html">Abbild-Ebene</a> und ist dadurch
vom Dateisystem des Datentrgers unabhngig.
Die maximale Kapazitt der Fehlerkorrektur ist einstellbar.<p>

<b>Hufige Miverstndnisse ber dvdisaster:</b>

<ul>
<li>dvdisaster kann defekte CDs/DVDs nicht wieder lesbar machen.
Ohne Fehlerkorrektur-Daten kann ein beschdigter Datentrger <i>nicht</i> 
wiederhergestellt werden.<p></li> 
<li><img src="images/exclude_from_search_terms.png" align="middle"><br>
Solche Funktionen sind mit den Zielen und dem inneren Aufbau von dvdisaster nicht vereinbar.</li>
</ul>

<p>
<a href="index10.html">Beispiele fr die Fehlerkorrektur...</a>
EOF
}

function index10de()
{ 
  create_inline inline de 1 index10.html "zu den Beispielen fr die Fehlerkorrektur"
  create_inline inline de 2 index10.html "zu den Beispielen fr die Fehlerkorrektur"
 
  cat >> $1 <<EOF
<h3>Beispiele fr die Fehlerkorrektur</h3>

<table><tr><td valign="top">
<b><a name="scratches">Stark verkratzter Datentrger.</a></b> &nbsp;

Dieser Datentrger wurde ohne Hlle in einem Rucksack transportiert;
die runden Abdrcke stammen von einer Flasche Mineralwasser. Die Kratzer
erscheinen in dem Foto allerdings durch Reflektionen
des Blitzlichtes etwas berzeichnet.<p>

Eine Oberflchenanalyse des Datentrgers ergibt rund 135.000 unlesbare
Sektoren (von insgesamt ca. 2.200.000, also 6% defekte Sektoren).
Bei der <a href="example40.html">Wiederherstellung</a> des Datentrger-Abbildes
(mit Grundeinstellungen)
treten im schlechtesten <a href="background10.html">ECC-Bereich</a> 22 Fehler auf.
Dies entspricht einer maximal 69%-igen Auslastung der Fehlerkorrektur
unter den gewhlten Einstellungen.<p>


</td><td width=110>
<a href="inline1.html">
<img src="../images/scratch-img.jpg" alt="verkratzter Datentrger" width=100 height=97></a>
<br clear="all">
<a href="inline2.html">
<img src="images/scratch-scan.png" alt="verkratzten Datentrger lesen" width=100 height=74></a>
<br clear="all">
<a href="inline2.html">
<img src="images/scratch-corr.png" alt="verkratzten Datentrger reparieren" width=100 height=74></a>
</td></tr></table>

<a href="index20.html">Warum PI/PO-Analysen alleine nicht ausreichen...</a>
EOF
}

function index20de()
{  cat >> $1 <<EOF
<h3>dvdisaster als Ergnzung zu PI/PO-Analysen</h3>

<a href="qa.html#pipo">PI/PO-Analysen</a> sind ein wertvolles Werkzeug 
zur berprfung und Optimierung der Brennqualitt.
<p>

Aber: Die <b>Lebensdauer</b> von DVD-Datentrgern lt sich durch 
PI/PO-Analysen <b>nicht zuverlssig voraussagen</b>!

<ul>
<li> PI/PO-Analysen erlauben keine Aussage darber,
wie viele Kratzer oder Wochen Alterung ein Datentrger noch
verkraftet, bevor erste unlesbare Sektoren auftreten.<p></li>

<li>Das Umkopieren eines Datentrgers aufgrund schlechter
PI/PO-Werte erweist sich hufig als zu voreilig - 
manchmal "leben" solche DVDs noch viel lnger als erwartet.<p></li>

<li>Andererseits kann man (ohne ein Werkzeug wie dvdisaster) mit dem Umkopieren 
natrlich nicht warten, bis Lesefehler auftreten - 
dann wren die ersten Daten schlielich schon verloren.</li>
</ul>

<a href="index30.html">Vor- und Nachteile von dvdisaster zusammengefat...</a>
EOF
}


function index30de()
{  cat >> $1 <<EOF
<h3>Vorteile von dvdisaster:</h3>

<ul>
<li><b>Schutz</b> vor unvorhergesehener Beschdigung (in <a href="background10.html">bestimmten Grenzen</a>).<p></li>
<li>berprfen auf Lesefehler geht <b>schneller</b> als eine PI/PO-Analyse.<br>
Je nach Laufwerk mit bis zu 16-facher Lesegeschwindigkeit.<p></li>
<li><b>Kostensparend:</b> Datentrger brauchen erst dann umkopiert zu werden,
wenn sie wirklich defekt sind.</li>
</ul>

<h3>Nachteile von dvdisaster:</h3>

<ul>
<li>Fehlerkorrektur-Daten <b>mssen erzeugt werden, bevor</b> der 
Datentrger kaputt geht (am besten gleich beim Brennen des Datentrgers).<p></li>
<li>Die Fehlerkorrektur-Daten bentigen <b>zustzlichen Speicherplatz</b>;
entweder direkt auf dem zu schtzenden Datentrger oder auf zustzlichen
Datentrgern.
In der Grundeinstellung betrgt der
Speicherplatzbedarf 15% der Originaldaten (ca. 700MB fr eine volle einschichtige DVD).<p></li>
<li><a href="background10.html">kein garantierter Schutz</a> vor Datenverlust.</li>
</ul>

<p>

Schauen Sie auch in die  <a href="background.html">Hintergrundinformationen</a>, um mehr ber die
Arbeitsweise von dvdisaster zu erfahren.
EOF
}


# ----- Examples

function example_contents_de()
{  local file="$1.html"
   local query=$2
   local page=$3
   local lang=$4

   case $query in
   title)   title="Beispiele" ;;

   link)    link_title="Beispiele und Bildschirmfotos" ;;
   link10)   link_title="Datentrger auf Lesefehler prfen" ;;

   link20)   link_title="Fehlerkorrektur-Daten erzeugen" ;;
   link21)   link_title="als Datei" ;;
   link22)   link_title="im Abbild" ;;

   link30)   link_title="Beschdigten Datentrger einlesen" ;;
   link40)   link_title="Datentrger-Abbild rekonstruieren" ;;
   link50)   link_title="Informationen ber Abbild und Fehlerkorrektur-Daten anzeigen" ;;

   content*) eval "example$page$lang $file" ;;
   esac 
}

function example0de()
{  cat >> $1 <<EOF

<h3>Worber mchten Sie mehr erfahren?</h3>

<table>
<tr>
<td valign="top">
  <a href="example10.html"><b>Datentrger prfen</b></a><br>
  Eine Untersuchung der Lesegeschwindigkeit und Lesbarkeit
  des Datentrgers.
</td>
<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
<td valign="top">
 <a href="example20.html"><b>Fehlerkorrektur-Daten erzeugen</b></a><br>
Fehlerkorrektur-Daten knnen innerhalb des Abbilds oder
als eigenstndige Datei abgelegt werden.
</td>
</tr>
<tr>
<td>
<a href="example1.html">
  <img src="images/ex-scan.png" alt="Datentrger prfen" border=0 width=275>
</a>
</td>
<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
<td>
<a href="example3.html#ecc">
  <img src="images/ex-create.png" alt="Fehlerkorrektur-Daten erzeugen" border=0 width=264>
</a>
</td>
</tr>

<tr><td colspan=3>&nbsp;</td></tr>

<tr>
<td valign="top">
  <a href="example30.html"><b>Beschdigten Datentrger einlesen</b></a><br>
  Ein speziell angepates <a href="background50.html">Leseverfahren</a>
  liest Daten von beschdigten Datentrgern.
</td>
<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
<td>
  <a href="example40.html"><b>Datentrger-Abbild rekonstruieren</b></a><br>
  Unlesbare Sektoren werden mit Hilfe von
  <a href="example20.html">Fehlerkorrektur-Daten</a>
  wiederhergestellt.
</td>
</tr>
<tr>
<td>
<a href="example4.html">
  <img src="images/ex-read-a.png" alt="beschdigten Datentrger lesen" border=0 width=264>
</a>
</td>
<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
<td>
<a href="example5.html">
  <img src="images/ex-fix.png" alt="beschdigten Datentrger reparieren" border=0 width=264>
</a>
</td>
</tr>
</table>

<pre> </pre>

<b>Weitere Informationen:</b>

<ul>
<li><a href="example50.html">Informationen ber
                             Abbild- und Fehlerkorrektur-Daten anzeigen</a><p></li>

<li><a href="background70.html">Tips zum Aufbewahren der Fehlerkorrektur-Datei</a></li>
</ul>

Die <b>vollstndigen Informationen zur Bedienung von dvdisaster</b> befinden sich ab 
Version 0.72 nicht mehr in diesen Seiten, sondern an folgenden Stellen:

<ul>
<li>Einstellmglichkeiten in der Benutzeroberflche:<br>
Die entsprechenden Dialoge enthalten Verweise in das eingebaute Hilfesystem.<p></li>
<li>Kommandozeile:<br>
Die mglichen Aufrufparameter sind in der "Unix manual page" zu dvdisaster beschrieben.</li>
</ul>

EOF
}

function example1de()
{  cat >> $1 <<EOF

<tr align="center"><td><h3>Bildschirmfoto: Datentrger auf Lesefehler berprfen</h3><p></td></tr>
<tr align="center"><td>
<center><img src="images/ex-scan.png" alt="Bildschirmfoto"></center>
<br clear="all">
</td></tr>
<tr><td>

Die graphische Darstellung zeigt den Fortschritt der berprfung:<p>

<ul>
<li>Die <b>Geschwindigkeitskurve</b> liefert eine grobe bersicht ber den Datentrger-Zustand,
weil das Laufwerk beim Lesen abbremst, wenn die Qualitt des Datentrgers schlechter wird.<p>

Um auszuschlieen, da andere Systemaktivitten die Lesegeschwindigkeit beeinflussen,
sollten Sie whrend der berprfung keine anderen Programme laufen lassen und auch das
dvdisaster-Fenster nicht bedienen.<p></li>

<li>Die <b>Spirale</b> gibt eine (nicht mastabsgetreue) 
bersicht ber den <b>Datentrger-Zustand</b>.
Rote Markierungen weisen auf Lesefehler hin!
<table width=100%><tr><td bgcolor=#000000 width=2><img width=1 height=1 alt=""></td><td>
Sobald Lesefehler auf dem Datentrger auftreten, mssen Sie
schnellstmglich versuchen, das <a href="example40.html">Datentrger-Abbild zu rekonstruieren</a> 
und auf einen neuen Datentrger bertragen. </td></tr></table><p>
</li>

<li>Durch Anklicken des 
<img src="images/btn-protocol.png" alt="Protokoll" align="middle">--Symbols
erhalten Sie zustzliche Informationen ber den Lesevorgang.<p></li>
</ul>

</td></tr>
EOF
}


function example10de()
{  
  create_inline example de 1 example10.html "zum berprfen des Datentrgers"


cat >> $1 <<EOF
<h3>Datentrger auf Lesefehler berprfen</h3>

Um festzustellen, ob ein Datentrger Lesefehler enthlt, 
gehen Sie wie folgt vor: <p>

(Hinweis: Zum Zugriff auf das CD/DVD-Laufwerk werden in Windows 2000 und XP entweder 
<b>Systemverwalter-Rechte</b> oder ein <a href="qa10.html#aspi">ASPI</a>-Treiber bentigt.)<p>


<table width="100%" border="0" cellspacing="0" cellpadding="10">
<tr valign="top" $BGCOLOR1>
<td>1.</td>
<td>Legen Sie den Datentrger in das Laufwerk.</td>
<td></td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>2.</td>
<td>Whlen Sie das Laufwerk aus.</td>
<td><img src="../images/btn-drive.png" alt="Laufwerks-Auswahl"></td>
</tr>

<tr valign="top" $BGCOLOR1>
<td>3a.</td>
<td>nur bei Verwendung von Fehlerkorrektur-Dateien (RS01):<p>
Falls Sie fr den Datentrger eine passende Fehlerkorrektur-Datei besitzen,
geben Sie ihren Namen ein.
Der Prfvorgang bentigt nicht zwingend eine 
Fehlerkorrektur-Datei, kann aber die darin
enthaltenen Informationen nutzen.</td>
<td><img src="../images/btn-eccfile.png" alt="Fehlerkorrektur-Datei-Auswahl"><p>
Das <img src="../images/open-ecc.png" alt="Dateiauswahl-Knopf" align="middle">-Symbol ffnet die Dateiauswahl.</td>
</tr>
 
<tr valign="top" $BGCOLOR2>
<td>3b.</td>
<td colspan="2">
nur bei Verwendung von erweiterten Abbildern (RS02):<p>

ffnen Sie den Einstellungs-Dialog mit dem 
<img src="../images/open-preferences.png" alt="Einstellungs-Knopf" align=middle>-Symbol.
Whlen Sie "ECC/RS02" bei den  Einstellungen zur Ermittlung der Abbild-Gre,
damit der Datentrger vollstndig berprft wird.<p>
<img src="images/select-size.png" alt="Bildschirmfoto">
</td>
</tr>

<tr valign="top" $BGCOLOR1>
<td>4.</td>
<td>Beginnen Sie die berprfung mit dem "Prfen"-Knopf.</td>
<td><img src="images/btn-scan.png" alt="Prfen-Knopf"></td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>5.</td>
<td>Verfolgen Sie den Fortschritt der berprfung in der graphischen Darstellung.</td>
<td><a href="example1.html"><img src="images/ex-scan.png" alt="Bildschirmfoto" width="200"></a><p>
</td>
</tr>
</table>

<p>

<b>Wie oft sollte man berprfen?</b><br>
 Das hngt von der Qualitt der Rohlinge 
und den Lagerungsbedingungen ab. Als Richtlinie fr einmal beschreibbare CD- und DVD-Datentrger
mit unbekannter Qualitt kann man nehmen:

<ol>
<li> 3 Tage nach dem Brennen (bis dahin das Abbild auf der Festplatte aufheben!), </li>
<li> 14 Tage nach dem Brennen, </li>
<li> 3 Monate nach dem Brennen, </li>
<li> dann alle weiteren 6 Monate berprfen.</li>
</ol>

Wenn Sie viele gleichartige Rohlinge aus der Produktion eines Markenherstellers verwenden, 
reicht gegebenenfalls auch ein stichprobenhaftes berprfen von 2-3 Datentrgern pro Monat und Produktionsserie.<p>

<hr><p>

<a name="cli"></a>
<h3>berprfung in der Kommandozeile durchfhren</h3>

In der Kommandozeilen-Betriebsart bentigen Sie die folgenden Parameter
(Grundeinstellungen in Klammern):

<table>
<tr>
<td>-s / --scan</td>
<td>berprfen</td>
</tr>
<tr>
<td>-d / --device&nbsp;</td>
<td>Laufwerk auswhlen (/dev/cdrom)</td>
</tr>
<tr>
<td>-e / --ecc</td>
<td>nur fr <a href="background30.html">RS01</a>: Fehlerkorrektur-Datei auswhlen (medium.ecc)</td>
</tr>
<tr>
<td>-j / --jump</td>
<td>berspringe Sektoren nach einem Lesefehler (16)</td>
</tr>
</table><p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>dvdisaster -s -d /dev/hdc -e korrektur.ecc</b><br>
dvdisaster-${project_version} Copyright 2004-2007 Carsten Gnrlich.<br>
Dies ist freie Software; es gelten die Bedingungen der<br>
GNU GENERAL PUBLIC LICENSE aus dem Quelltext.<p>

Laufwerk: /dev/hdc, &nbsp;ATAPI DVD+RW 8X4X12 B2K7<br>
Datentrger: DVD+R, 2224288 Sektoren, 1 Schicht(en)<p>

Untersuche Datentrger auf Lesefehler.<br>
Warte 5 Sekunden auf das Hochdrehen des Laufwerks...<br>
Sektor 57664: Medium Error; Unrecovered read error. berspringe 15 Sektoren.<br>
Sektor 57728: Medium Error; Unrecovered read error. berspringe 15 Sektoren.<br>
[... weitere Berichte ber Lesefehler ...] <br>
Sektor 716640: Medium Error; Unrecovered read error. berspringe 15 Sektoren.<br>
Leseposition: 100.0% ( 2.4x)<br>
33840 unlesbare Sektoren.
</td></tr></table><p>

Die Beschreibung des Lesefehlers (hier: "Medium Error; ...") kann 
je nach verwendeter Laufwerks-Firmware auch anders lauten.
EOF
}

function example2de()
{  cat >> $1 <<EOF

<tr align="center"><td><h3>Bildschirmfoto: Datentrger-Abbild erstellen</h3><p></td></tr>
<tr align="center"><td>
<center><img src="images/ex-read.png" alt="Bildschirmfoto"></center>
<br clear="all">
</td></tr>

<tr><td>
Die graphische Darstellung zeigt den Fortschritt des Lesevorgangs:
<ul>
<li>Die <b>Spirale</b> gibt eine (nicht mastabsgetreue) 
bersicht ber den <b>Datentrger-Zustand</b>.<br>
Rote Markierungen weisen auf Lesefehler hin!<p></li>

<li>
Die Fehlerkorrektur-Datei kann <i>nicht erstellt werden</i>, 
wenn das Abbild unvollstndig ist oder Lesefehler aufweist.
Erstellen Sie die Fehlerkorrektur-Datei deshalb sofort
nach dem Brennen des Datentrgers.<p></li>

<li>Durch Anklicken des 
<img src="images/btn-protocol.png" alt="Protokoll" align="middle">--Symbols
erhalten Sie zustzliche Informationen.</li>
</ul>

</td></tr>
EOF
}

function example3de()
{  cat >> $1 <<EOF

<tr align="center"><td>
<h3>Bildschirmfoto: Fehlerkorrektur-Datei erzeugen</h3><p></td></tr>
<tr align="center"><td>
<center><img src="images/ex-create.png" alt="Bildschirmfoto"></center>
<br clear="all">
</td></tr>

<tr><td>
Die Prozentwerte zeigen den Fortschritt des Vorgangs.
Auf einem durchschnittlichen 2Ghz-Rechner werden mit der 
voreingestellten Redundanz etwa 10min fr eine volle einschichtige DVD bentigt.<p>

<b>Weitere Hinweise</b>:

<ul>
<li>Nach dem erfolgreichen Erstellen der Fehlerkorrektur-Datei wird die Abbild-Datei nicht mehr
bentigt.<br>
Wenn Sie einen anderen Datentrger einlesen, wird dvdisaster
die bereits bestehende Abbild-Datei automatisch berschreiben.<p></li>

<li>
Verwahren Sie die Fehlerkorrektur-Datei auf 
einem <a href="background70.html">zuverlssigen Speichermedium</a>!
</li>

<li>berprfen Sie danach den Datentrger regelmig auf Lesefehler.</li>

</ul>
</td></tr>


EOF
}

function example7de()
{  cat >> $1 <<EOF

<tr align="center"><td>
<h3>Bildschirmfoto: Abbild mit Fehlerkorrektur-Daten erweitern</h3><p></td></tr>
<tr align="center"><td>
<center><img src="images/ex-create-rs02.png" alt="Bildschirmfoto"></center>
<br clear="all">
</td></tr>

<tr><td>
Die Verarbeitungsgeschwindigkeit hngt vom vorhandenen Platz auf dem
Datentrger ab. Auf einem durchschnittlichen 2Ghz-Rechner werden ungefhr
10 bis 20 Minuten fr eine volle einschichtige DVD bentigt.<p>

<b>Hinweis</b>:

<ul>
<li>berprfen Sie den Datentrger nach dem Brennen regelmig auf Lesefehler.</li>

</ul>
</td></tr>


EOF
}

function example20de()
{  
   cat >> $1 <<EOF
<h3>Fehlerkorrektur-Daten erzeugen</h3>

Die Fehlerkorrektur-Daten spielen bei dvdisaster eine zentrale Rolle:<br>
Sie werden zur Rekonstruktion von unlesbaren Sektoren bentigt.<p>

Fehlerkorrektur-Daten knnen entweder in einer separaten
<a href="background30.html#file">Fehlerkorrektur-Datei</a>
oder direkt <a href="background30.html#image">innerhalb des Abbilds</a> abgelegt werden,
mit entsprechenden <a href="background30.html#table">Vor- und Nachteilen</a>.<p>

Als kurze Entscheidungshilfe:<p>

<b>Bentigen Sie Fehlerkorrektur-Daten fr einen bereits gebrannten Datentrger?</b><p>

&nbsp; Ja: <a href="example21.html">Erzeugen Sie eine Fehlerkorrektur-Datei.</a><p>

&nbsp; Nein: nchste Frage<p>

<b>Sind auf dem zu brennenden Datentrger mindestens 20% frei?</b><p>

&nbsp; Ja: <a href="example22.html">Erweitern Sie das Abbild um Fehlerkorrektur-Daten.</a><p>

&nbsp; Nein: <a href="example21.html">Erzeugen Sie eine Fehlerkorrektur-Datei.</a><p>
EOF

}

function example21de()
{  create_inline example de 2 example21.html "zum Erstellen der Fehlerkorrektur-Datei"
   create_inline example de 3 example21.html "zum Erstellen der Fehlerkorrektur-Datei"
 
   cat >> $1 <<EOF
<h3>Fehlerkorrektur-Datei erzeugen</h3>

<b>Erstellen Sie zunchst ein Datentrger-Abbild auf der Festplatte:</b><p>

<table width="100%" border="0" cellspacing="0" cellpadding="10">
<tr valign="top" $BGCOLOR1>
<td>1.</td>
<td>Legen Sie den Datentrger in das Laufwerk.</td>
<td></td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>2.</td>
<td>Whlen Sie das Laufwerk aus.</td>
<td><img src="../images/btn-drive.png" alt="Laufwerks-Auswahl"></td>
</tr>

<tr valign="top" $BGCOLOR1>
<td>3.</td>
<td>Whlen Sie eine Abbild-Datei aus.
Achten Sie darauf, gengend Speicherplatz fr das Abbild zu haben.<p>
</td>
<td><img src="../images/btn-image.png" alt="Abbild-Datei-Auswahl"><p>
Das <img src="../images/open-img.png" alt="Dateiauswahl-Knopf" align="middle">-Symbol ffnet die Dateiauswahl.</td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>4.</td>
<td>Beginnen Sie das Einlesen mit dem "Lesen"-Knopf.</td>
<td><img src="images/btn-read.png" alt="Lesen-Knopf"></td>
</tr>

<tr valign="top" $BGCOLOR1>
<td>5.</td>
<td>Verfolgen Sie den Fortschritt des Lesevorgangs in der graphischen Darstellung.</td>
<td><a href="example2.html"><img src="images/ex-read.png" alt="Bildschirmfoto" width="200"></a><p>
</td>
</tr>
</table>

<pre> </pre>

<b>Erzeugen Sie anschlieend die Fehlerkorrektur-Datei:</b><p>
Dies setzt voraus, da das Abbild ohne Lesefehler eingelesen wurde.<p>

<table width="100%" border="0" cellspacing="0" cellpadding="10">
<tr valign="top" $BGCOLOR1>
<td>1.</td>
<td>
Whlen Sie die Abbild-Datei aus.
Die zuletzt eingelesene Abbild-Datei ist bereits voreingestellt.<p>
</td>
<td><img src="../images/btn-image.png" alt="Abbild-Datei-Auswahl"><p>
Das <img src="../images/open-img.png" alt="Dateiauswahl-Knopf" align="middle">-Symbol ffnet die Dateiauswahl.</td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>2.</td>
<td>
Whlen Sie die Fehlerkorrektur-Datei aus.<p>
</td>
<td><img src="../images/btn-eccfile.png" alt="Fehlerkorrektur-Datei-Auswahl"><p>
Das <img src="../images/open-ecc.png" alt="Dateiauswahl-Knopf" align="middle">-Symbol ffnet die Dateiauswahl.</td>
</tr>

<tr valign="top" $BGCOLOR1>
<td>3.</td>
<td colspan="2">
ffnen Sie den Einstellungs-Dialog mit dem 
<img src="../images/open-preferences.png" alt="Einstellungs-Knopf" align=middle>-Symbol.<br>
Whlen Sie "Abspeichern in: Fehlerkorrektur-Datei (RS01)".<p>
<img src="images/select-rs01.png" alt="Bildschirmfoto">
</td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>4.</td>
<td>Erstellen Sie die Fehlerkorrektur-Datei durch Klick auf den "Erzeugen"-Knopf.</td>
<td><img src="images/btn-create.png" alt="Erzeugen-Knopf"></td>
</tr>

<tr valign="top" $BGCOLOR1>
<td>5.</td>
<td>Verfolgen Sie den Fortschritt des Vorgangs.</td>
<td><a href="example3.html"><img src="images/ex-create.png" alt="Bildschirmfoto" width="200"></a><p>
</td>
</tr>
</table><p>

Verwahren Sie die Fehlerkorrektur-Datei auf 
einem <a href="background70.html">zuverlssigen Speichermedium</a>,
und berprfen Sie den Datentrger anschlieend regelmig auf Lesefehler.

<hr><p>

<h3>Fehlerkorrektur-Datei in der Kommandozeile erzeugen</h3>

Zum Einlesen des Abbildes bentigen Sie die folgenden Parameter
(Grundeinstellungen in Klammern):

<table>
<tr>
<td>-r/ --read</td>
<td>Einlesen</td>
</tr>
<tr>
<td>-d / --device&nbsp;</td>
<td>Laufwerk auswhlen (/dev/cdrom)</td>
</tr>
<tr>
<td>-i / --image</td>
<td>Abbild-Datei auswhlen (medium.iso)</td>
</tr>
</table><p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>dvdisaster -r -d /dev/hdc -i abbild.iso</b><br>
dvdisaster-${project_version} Copyright 2004-2007 Carsten Gnrlich.<br>
Dies ist freie Software; es gelten die Bedingungen der<br>
GNU GENERAL PUBLIC LICENSE aus dem Quelltext.<p>

Laufwerk: /dev/hdc, &nbsp;ATAPI DVD+RW 8X4X12 B2K7<br>
Datentrger: DVD+R, 2224288 Sektoren, 1 Schicht(en)<p>

Erzeuge neues Abbild abbild.iso.<br>
Warte 5 Sekunden auf das Hochdrehen des Laufwerks...<br>
Leseposition: 100.0% ( 7.7x)<br>
Alle Sektoren erfolgreich eingelesen.
</td></tr></table><p>

Whrend des Einlesens werden der Fortschritt in Prozent und die momentane
Lesegeschwindigkeit des Laufwerks angezeigt. Erzeugen Sie anschlieend die 
Fehlerkorrektur-Datei mit folgendem Aufruf:<p>

<table>
<tr>
<td>-c/ --create</td>
<td>Fehlerkorrektur-Datei erzeugen</td>
</tr>
<tr>
<td>-i / --image</td>
<td>Abbild-Datei auswhlen (medium.iso)</td>
</tr>
<tr>
<td>-e / --ecc</td>
<td>Fehlerkorrektur-Datei auswhlen (medium.ecc)</td>
</tr>
<tr>
<td>-n / --redundancy&nbsp;</td>
<td>Redundanz auswhlen (32 Nullstellen = 14.3%)</td>
</tr>
</table><p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>dvdisaster -c -i abbild.iso -e korrektur.ecc </b><br>
dvdisaster-${project_version} Copyright 2004-2007 Carsten Gnrlich.<br>
Dies ist freie Software; es gelten die Bedingungen der<br>
GNU GENERAL PUBLIC LICENSE aus dem Quelltext.<p>

ffne abbild.iso: 2224288 Datentrger-Sektoren.<br>
Prfe Abbild-Sektoren : 100%<br>
Kodiere mit Methode RS01: 32 Nullstellen, 14.3% Redundanz.<br>
Kodierungs-Fortschritt: 100.0%<br>
Fehlerkorrektur-Datei "korrektur.ecc" wurde erzeugt.<br>
Verwahren Sie die Datei auf einem zuverlssigen Datentrger.
</td></tr></table><p>

Anhand der Prozentanzeige knnen Sie den Fortschritt des Vorgangs beobachten.<p>

Danach finden Sie die Fehlerkorrektur-Datei <i>korrektur.ecc</i> im aktuellen 
Verzeichnis:<p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>ls -lA</b><br>
-rwx------    1 user     linux    653721680 2004-07-02 22:45 korrektur.ecc<br>
-rwx------    1 user     linux    4555341824 2004-07-02 21:31 abbild.iso<br>
</td></tr></table><p>

Die Abbild-Datei knnen Sie jetzt lschen, <p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>rm -f abbild.iso</b><br>
</td></tr></table><p>

aber die Fehlerkorrektur-Datei mssen Sie auf 
einem <a href="background70.html">zuverlssigen Speichermedium</a>
aufbewahren!<p>

<u>Tip:</u> Fassen Sie die Aktionen zum Einlesen 
und zum Erzeugen der Fehlerkorrektur-Datei
zusammen. Dann entfllt das berprfen des Abbildes im zweiten Schritt:<p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; dvdisaster <b>-r -c</b> -d /dev/hdc -i abbild.iso -e korrektur.ecc<br>
u.s.w.
</td></tr></table>
EOF
}

function example22de()
{  create_inline example de 7 example22.html "zum Erstellen der Fehlerkorrektur-Daten"
  
   cat >> $1 <<EOF
<h3>Abbild um Fehlerkorrektur-Daten erweitern</h3>

Das <a href="background30.html#image">RS02-Fehlerkorrektur-Verfahren</a> ermglicht es,
Nutzdaten und Fehlerkorrektur-Daten auf dem gleichen Datentrger unterzubringen.<br>

Dazu mssen Sie das Abbild vor dem Brennen mit dvdisaster bearbeiten.

Erzeugen Sie zunchst ein Abbild mit Ihrer Brennsoftware und legen es auf der Festplatte
ab. Erweitern Sie danach das Abbild mit dvdisaster um Fehlerkorrektur-Informationen 
und brennen Sie das erweiterte Abbild schlielich auf einen Datentrger:<p>

<table width="100%" border="0" cellspacing="0" cellpadding="10">
<tr valign="top" $BGCOLOR1>
<td>1.</td>
<td>
Verwenden Sie eine handelsbliche Brennsoftware, 
um ein ISO- oder UDF-Abbild auf der Festplatte zu erzeugen.
Andere Abbild-Typen fhren zum Datenverlust!
</td>
<td></td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>2.</td>
<td>
Whlen Sie die erzeugte Abbild-Datei aus.<p>
</td>
<td><img src="../images/btn-image.png" alt="Abbild-Datei-Auswahl"><p>
Das <img src="../images/open-img.png" alt="Dateiauswahl-Knopf" align="middle">-Symbol ffnet die Dateiauswahl.</td>
</tr>

<tr valign="top" $BGCOLOR1>
<td>3.</td>
<td colspan="2">
ffnen Sie den Einstellungs-Dialog mit dem 
<img src="../images/open-preferences.png" alt="Einstellungs-Knopf" align=middle>-Symbol.<br>
Whlen Sie "Abspeichern in: Erweitertes Abbild (RS02)".<p>
<img src="images/select-rs02.png" alt="Bildschirmfoto">
</td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>4.</td>
<td>Erstellen Sie die Fehlerkorrektur-Daten durch Klick auf den "Erzeugen"-Knopf.</td>
<td><img src="images/btn-create.png" alt="Erzeugen-Knopf"></td>
</tr>

<tr valign="top" $BGCOLOR1>
<td>5.</td>
<td>Verfolgen Sie den Fortschritt des Vorgangs.</td>
<td><a href="example7.html"><img src="images/ex-create-rs02.png" alt="Bildschirmfoto" width="200"></a><p>
</td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>6.</td>
<td>Schreiben Sie das erweiterte Abbild mit Ihrer Brennsoftware auf einen Datentrger.</td>
<td></td>
</tr>
</table><p>

Einige Brennprogramme sind mit den erweiterten Abbildern nicht kompatibel
und beschdigen die Fehlerkorrektur-Daten. Fhren Sie zumindest nach dem ersten
Brennvorgang die nachfolgende berprfung durch.<p>

<table width="100%" border="0" cellspacing="0" cellpadding="10">

<tr valign="top" $BGCOLOR1>
<td>1.</td>
<td>Whlen Sie das Laufwerk aus, in dem sich der gerade gebrannte
Datentrger befindet.</td>
<td><img src="../images/btn-drive.png" alt="Laufwerks-Auswahl"></td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>2.</td>
<td>Whlen Sie einen neuen Namen fr die Abbild-Datei aus
(also nicht den Namen des Abbildes, das Sie zum Brennen verwendet haben!)<p>
</td>
<td><img src="images/btn-new-image.png" alt="Abbild-Datei-Auswahl"><p>
Das <img src="../images/open-img.png" alt="Dateiauswahl-Knopf" align="middle">-Symbol ffnet die Dateiauswahl.</td>
</tr>

<tr valign="top" $BGCOLOR1>
<td>3.</td>
<td>Beginnen Sie das Einlesen mit dem "Lesen"-Knopf.</td>
<td><img src="images/btn-read.png" alt="Lesen-Knopf"></td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>4.</td>
<td>Verfolgen Sie den Fortschritt des Lesevorgangs in der graphischen Darstellung.</td>
<td><a href="example2.html"><img src="images/ex-read.png" alt="Bildschirmfoto" width="200"></a><p>

</td>
</tr>
<tr valign="top" $BGCOLOR1>
<td>5.</td>
<td>Wenn das Einlesen beendet wurde, klicken Sie auf den "Vergleichen"-Knopf.
Dies berprft die Fehlerkorrektur-Informationen in dem zurckgelesenen Abbild. </td>
<td><img src="images/btn-compare.png" alt="Vergleichen-Knopf"></td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>4.</td>
<td>Verfolgen Sie den Fortschritt des Vergleichs.<p>
Wenn der Vergleich ohne Fehlermeldungen beendet wird, ist Ihre Brennsoftware
mit den erweiterten Abbildern kompatibel.
</td>
<td><a href="example6.html#rs02"><img src="images/ex-compare-rs02.png" alt="Bildschirmfoto" width="200"></a><p>
</td>
</tr>

</table>


<pre> </pre>

<h3>Abbild um Fehlerkorrektur-Daten erweitern (mit der Kommandozeile)</h3>

<b>Erstellen Sie ein Abbild mit den zu sichernden Daten.</b><p>

Verwenden Sie eine handelsbliche Brennsoftware, 
um ein ISO- oder UDF-Abbild auf der Festplatte zu erzeugen.
Andere Abbild-Typen fhren zum Datenverlust!<p>

<b>Erweitern Sie das Abbild um die Fehlerkorrektur-Informationen.</b><p>

Dazu bentigen Sie die folgenden Parameter
(Grundeinstellungen in Klammern):

<table>
<tr>
<td>-c/ --create</td>
<td>Fehlerkorrektur-Informationen hinzufgen</td>
</tr>
<tr>
<td>-m / --method&nbsp;</td>
<td>Fehlerkorrektur-Verfahren auswhlen</td>
</tr>
<tr>
<td>-n / --redundancy</td>
<td>maximale Datentrger-Gre in Sektoren (Gre des kleinstmgl. Datentrgers)</td>
</tr>
</table><p>

Wenn Sie mit der Brennsoftware das Abbild "abbild.iso" erzeugt haben, geben Sie ein:<p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>dvdisaster -c -mRS02 -i abbild.iso</b><br>
dvdisaster-${project_version} Copyright 2004-2007 Carsten Gnrlich.<br>
Dies ist freie Software; es gelten die Bedingungen der<br>
GNU GENERAL PUBLIC LICENSE aus dem Quelltext.<p>

ffne abbild.iso: 284234 Datentrger-Sektoren.<p>

Erweitere Abbild mit dem RS02-Verfahren:<br>
555M Daten, 143M Fehlerkorrektur-Daten (52 Nullstellen; 25.6% Redundanz)<br>
Berechne Sektoren-Prfsummen: 100%<br>
Erweitere das Abbild: 100%<br>
Kodierungs-Fortschritt: 100.0%<br>
Das Abbild wurde um Fehlerkorrektur-Informationen erweitert.<br>
Die neue Abbild-Gre ist 357818 Sektoren.
</td></tr>
</table><p>

<b>Schreiben Sie das Abbild auf den Datentrger.</b><p>

Verwenden Sie die Brennsoftware, um das erweiterte Abbild 
auf den Datentrger zu schreiben. <p>

Einige Brennprogramme sind mit den erweiterten Abbildern nicht kompatibel
und beschdigen die Fehlerkorrektur-Daten. Fhren Sie zumindest 
nach dem ersten Brennvorgang die nachfolgende berprfung durch.<p>

Lesen Sie das Abbild nach dem Brennen mit dvdisaster wieder ein:<p>

<table>
<tr>
<td>-r/ --read</td>
<td>Einlesen</td>
</tr>
<tr>
<td>-d / --device&nbsp;</td>
<td>Laufwerk auswhlen (/dev/cdrom)</td>
</tr>
<tr>
<td>-i / --image</td>
<td>Abbild-Datei auswhlen (medium.iso)</td>
</tr>
</table><p>

<table class="example" width="100%" bgcolor="#ffffe0"><tr><td>
user@linux&gt; <b>dvdisaster -r -d/dev/hdc -i abbild-neu.iso</b><br>
dvdisaster-${project_version} Copyright 2004-2007 Carsten Gnrlich.<br>
Dies ist freie Software; es gelten die Bedingungen der<br>
GNU GENERAL PUBLIC LICENSE aus dem Quelltext.<p>

Laufwerk: /dev/hdc, &nbsp; ATAPI DVD+RW 8X4X12 B2K7<br>
Datentrger: Daten-CD Mode 1, 357818 Sektoren<p>

Erzeuge neues Abbild abbild-neu.iso.<br>
Warte 5 Sekunden auf das Hochdrehen des Laufwerks...<br>
Leseposition: 100.0% (35.1x)<br>
Alle Sektoren erfolgreich eingelesen.
</td></tr>
</table><p>

berprfen Sie das Abbild:<p>

<table>
<tr>
<td>-t/ --test</td>
<td>Abbild berprfen</td>
</tr>
<tr>
<td>-i / --image</td>
<td>Abbild-Datei auswhlen (medium.iso)</td>
</tr>
</table><p>

<table class="example" width="100%" bgcolor="#ffffe0"><tr><td>
user@linux&gt; <b>dvdisaster -t -i abbild-neu.iso</b><br>
dvdisaster-${project_version} Copyright 2004-2007 Carsten Gnrlich.<br>
Dies ist freie Software; es gelten die Bedingungen der<br>
GNU GENERAL PUBLIC LICENSE aus dem Quelltext.<p>

/dvd/abbild-neu.iso: vorhanden, enthlt 357818 Datentrger-Sektoren.<br>
- gutes Abbild      : Alle Sektoren vorhanden<br>
- Daten-md5sum      : 4eca3615a88a11ba68466226295c4bcb<p>

Fehlerkorrektur-Daten: Erzeugt von dvdisaster-${project_version}<br>
- Methode           : RS02, 52 Nullstellen, 25.6% Redundanz.<br>
- Bentigt          : dvdisaster-0.66 (gut)<br>
- Daten-md5sum      : 4eca3615a88a11ba68466226295c4bcb (gut)<br>
- CRC-md5sum        : 9776489c12e12cbabfe5145da4f6ae66 (gut)<br>
- Ecc-md5sum        : e975aed39c962eeabedd9d6cbdbfc45e (gut)
</td></tr>
</table>
EOF
}

function example4de()
{  cat >> $1 <<EOF

<tr align="center"><td>
<h3>Bildschirmfoto: Beschdigten Datentrger einlesen</h3><p></td></tr>
<tr align="center"><td>
<center><img src="images/ex-read-a.png" alt="Bildschirmfoto"></center>
<br clear="all">
</td></tr>

<tr><td>
Bercksichtigen Sie, da das Einlesen eines beschdigten Datentrgers 
mehrere Stunden dauern kann.
</td></tr>


EOF
}

function example30de()
{  create_inline example de 4 example30.html "zum Einlesen beschdigter Datentrger"
 
   cat >> $1 <<EOF
<h3>Beschdigten Datentrger einlesen</h3>

dvdisaster enthlt ein <a href="background50.html">Leseverfahren</a>, 
das an das Einlesen beschdigter Datentrger angepat ist:<p>

<table width="100%" border="0" cellspacing="0" cellpadding="10">
<tr valign="top" $BGCOLOR1>
<td>1.</td>
<td>Legen Sie den Datentrger in das Laufwerk.</td>
<td></td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>2.</td>
<td>Whlen Sie das Laufwerk aus.</td>
<td><img src="../images/btn-drive.png" alt="Laufwerks-Auswahl"></td>
</tr>

<tr valign="top" $BGCOLOR1>
<td>3.</td>
<td>
Whlen Sie die Abbild-Datei aus.<p>
</td>
<td><img src="../images/btn-image.png" alt="Abbild-Datei-Auswahl"><p>
Das <img src="../images/open-img.png" alt="Dateiauswahl-Knopf" align="middle">-Symbol ffnet die Dateiauswahl.</td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>4a.</td>
<td>nur bei Verwendung von Fehlerkorrektur-Dateien (RS01):<p>

Whlen Sie die Fehlerkorrektur-Datei aus.
Diese Datei wird jetzt schon bentigt, damit dvdisaster ermitteln kann, 
wann es gengend Informationen zur Wiederherstellung des
Abbildes besitzt.<p>
</td>
<td><img src="../images/btn-eccfile.png" alt="Fehlerkorrektur-Datei-Auswahl"><p>
Das <img src="../images/open-ecc.png" alt="Dateiauswahl-Knopf" align="middle">-Symbol ffnet die Dateiauswahl.</td>
</tr>

<tr valign="top" $BGCOLOR1>
<td>4b.</td>
<td colspan="2">
nur bei Verwendung von erweiterten Abbildern (RS02):<p>

ffnen Sie den Einstellungs-Dialog mit dem 
<img src="../images/open-preferences.png" alt="Einstellungs-Knopf" align=middle>-Symbol.
Whlen Sie "ECC/RS02" bei den  Einstellungen zur Ermittlung der Abbild-Gre,
damit der Datentrger vollstndig gelesen wird.<p>
<img src="images/select-size.png" alt="Bildschirmfoto">
</td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>5.</td>
<td colspan="2">
ffnen Sie den Einstellungs-Dialog mit dem 
<img src="../images/open-preferences.png" alt="Einstellungs-Knopf" align=middle>-Symbol.<br>
Whlen Sie das angepate Leseverfahren aus.<p>
<img src="images/select-adaptive.png" alt="Bildschirmfoto">
</td>
</tr>

<tr valign="top" $BGCOLOR1>
<td>6.</td>
<td>Beginnen Sie mit dem Einlesen durch Klick auf den "Lesen"-Knopf.</td>
<td><img src="images/btn-read.png" alt="Lesen-Knopf"></td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>7.</td>
<td>Verfolgen Sie den Fortschritt des Vorgangs.</td>
<td><a href="example4.html"><img src="images/ex-read-a.png" alt="Bildschirmfoto" width="200"></a><p>
</td>
</tr>
</table><p>

Wenn der Lesevorgang mit der Ausgabe beendet wird, da gengend Informationen
fr eine erfolgreiche Wiederherstellung vorhanden sind, 
<a href="example40.html">stellen</a> Sie die noch fehlenden
Sektoren aus den Fehlerkorrektur-Daten <a href="example40.html">wieder her.</a><p>

Anderenfalls mssen Sie probieren, das Abbild erneut 
einzulesen <a href="background60.html#reading-tips">(ein paar Tips dazu)</a>.
In diesem Fall versucht dvdisaster nur die fehlenden Sektoren noch einmal zu lesen.

<hr><p>

<h3>Beschdigten Datentrger in der Kommandozeile einlesen</h3>

Zum Einlesen des beschdigten Datentrgers bentigen Sie die folgenden Parameter
(Grundeinstellungen in Klammern):

<table>
<tr>
<td>-r/ --read</td>
<td>Einlesen</td>
</tr>
<tr>
<td>--adaptive-read</td>
<td>Leseverfahren fr beschdigte Datentrger verwenden</td>
</tr>
<tr>
<td>-d / --device&nbsp;</td>
<td>Laufwerk auswhlen (/dev/cdrom)</td>
</tr>
<tr>
<td>-i / --image</td>
<td>Abbild-Datei auswhlen (medium.iso)</td>
</tr>
<tr>
<td>-e / --ecc</td>
<td>nur fr <a href="background30.html">RS01</a>: Fehlerkorrektur-Datei auswhlen (medium.ecc)</td>
</tr>
</table><p>

Beispiel zum Lesen eines beschdigten Datentrgers mit Hilfe einer <b>Fehlerkorrektur-Datei</b>:<p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>dvdisaster -r --adaptive-read -i abbild.iso -e korrektur.ecc</b><br>
dvdisaster-${project_version} Copyright 2004-2007 Carsten Gnrlich.<br>
Dies ist freie Software; es gelten die Bedingungen der<br>
GNU GENERAL PUBLIC LICENSE aus dem Quelltext.<p>

Laufwerk: /dev/cdrom, &nbsp;ATAPI DVD+RW 8X4X12 B2K7<br>
Datentrger: DVD+R, 2224288 Sektoren, 1 Schicht(en)<p>

Angepates Leseverfahren: Versuche gengend Daten fr die Fehlerkorrektur zu sammeln.<br>
Erzeuge neues Abbild abbild.iso.<br>
Reparierbar:  2.6% (korrigierbar: 0; lese in [0..2224288], Gre 2224288)<br>
Sektoren 57264-57279: Medium Error; Unrecovered read error.<br>
Auffllen des Abbild-Bereichs [57280..1083504]<br>
[... weitere Berichte ber den Lesevorgang ...]<br>
Reparierbar: 100.0% (korrigierbar: 319200; lese in [320304..327065], Gre 6762)<br>
Gengend Daten zur Wiederherstellung des Abbildes vorhanden.
</td></tr></table><p>

Beispiel zum Lesen eines beschdigten Datentrgers mit einem <b>erweiterten Abbild (RS02)</b>:<p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>dvdisaster -r --adaptive-read -i abbild.iso</b><br>
dvdisaster-${project_version} Copyright 2004-2007 Carsten Gnrlich.<br>
Dies ist freie Software; es gelten die Bedingungen der<br>
GNU GENERAL PUBLIC LICENSE aus dem Quelltext.<p>

Laufwerk: /dev/cdrom, &nbsp;ATAPI DVD+RW 8X4X12 B2K7<br>
Datentrger: DVD+R, 2224288 Sektoren, Ecc, 1 Schicht(en)<p>

Angepates Leseverfahren: Versuche gengend Daten fr die Fehlerkorrektur zu sammeln.<br>
Erzeuge neues Abbild abbild.iso.<br>
Reparierbar:  2.6% (korrigierbar: 0; lese in [0..2224288], Gre 2224288)<br>
Sektoren 57264-57279: Medium Error; Unrecovered read error.<br>
Auffllen des Abbild-Bereichs [57280..1083504]<br>
[... weitere Berichte ber den Lesevorgang ...]<br>
Reparierbar: 100.0% (korrigierbar: 319200; lese in [320304..327065], Gre 6762)<br>
Gengend Daten zur Wiederherstellung des Abbildes vorhanden.
</td></tr></table><p>
EOF
}

function example5de()
{  cat >> $1 <<EOF

<tr align="center"><td>
<h3>Bildschirmfoto: Datentrger-Abbild wiederherstellen</h3><p></td></tr>
<tr align="center"><td>
<center><img src="images/ex-fix.png" alt="Bildschirmfoto"></center>
<br clear="all">
</td></tr>

<tr><td>
Das Bildschirmfoto zeigt die Wiederherstellung mit Hilfe einer Fehlerkorrektur-Datei;
die Ausgabe ndert sich bei der Verwendung erweiterter Abbilder nur in der Kopfzeile.
Der Fortschritt der Rekonstruktion wird in Prozent angezeigt.
<p>

<ul>
<li>Die Meldung "Gut! Alle Sektoren wurden repariert." bedeutet, da das Abbild
des Datentrgers vollstndig wiederhergestellt werden konnte. Das reparierte 
Abbild lt sich mit einer geeigneten Brennsoftware
auf einen neuen Datentrger schreiben. 
<p></li>

<li>Wenn unkorrigierbare Sektoren brigbleiben, 
lesen Sie das Abbild erneut 
ein <a href="background60.html#reading-tips">(ein paar Tips dazu)</a>.
In diesem Fall versucht dvdisaster nur die fehlenden Sektoren noch einmal zu lesen.
Dadurch erhalten Sie gegebenenfalls gengend Daten fr einen zweiten erfolgreichen 
Fehlerkorrektur-Durchlauf.<p></li>

<li>Die rote Fehlerkurve entspricht <i>nicht</i> der rumlichen Anordnung der Lesefehler
auf dem Datentrger, denn das Verfahren basiert gerade darauf, 
Lesefehler gleichmig ber alle Fehlerkorrekturbereiche zu verteilen.<br>
Die grne Linie kennzeichnet die Leistungsgrenze der Fehlerkorrektur. Wenn sie
berschritten wird, kann der Datentrger-Inhalt mit den zu diesem Zeitpunkt vorhandenen
Daten nicht vollstndig wiederhergestellt werden.
Falls die Linie nur knapp berschritten wird,
hilft manchmal ein <a href="background60.html#reading-tips">weiterer Leseversuch</a>.<p>
</li>

<li>Wenn Sie das Abbild mit dem "angepaten Lese-Verfahren" einlesen,
wird die Fehlerkorrektur immer maximal ausgelastet.</li>
</ul>
</td></tr>


EOF
}


function example40de()
{  create_inline example de 5 example40.html "zum Wiederherstellen des Abbildes"

   cat >> $1 <<EOF
<h3>Datentrger-Abbild rekonstruieren</h3>

Zum Wiederherstellen der Daten eines defekten Datentrgers mssen Sie zunchst
versuchen, so <a href="example30.html">viele Daten wie mglich davon einzulesen</a>.
Zustzlich bentigen Sie die <a href="example20.html">zugehrigen Fehlerkorrektur-Daten</a>,
die Sie hoffentlich zu einem Zeitpunkt angelegt haben, als der Datentrger noch
lesbar war:<p>

<table width="100%" border="0" cellspacing="0" cellpadding="10">
<tr valign="top" $BGCOLOR1>
<td>1.</td>
<td>
Whlen Sie die Abbild-Datei aus.<p>
</td>
<td><img src="../images/btn-image.png" alt="Abbild-Datei-Auswahl"><p>
Das <img src="../images/open-img.png" alt="Dateiauswahl-Knopf" align="middle">-Symbol ffnet die Dateiauswahl.</td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>2.</td>
<td>
Wenn Sie mit Fehlerkorrektur-Dateien arbeiten, 
whlen Sie die zugehrige Fehlerkorrektur-Datei aus.
Lassen Sie das Eingabefeld leer wenn Sie erweiterte Abbilder verwenden.
<p>
</td>
<td><img src="../images/btn-eccfile.png" alt="Fehlerkorrektur-Datei-Auswahl"><p>
Das <img src="../images/open-ecc.png" alt="Dateiauswahl-Knopf" align="middle">-Symbol ffnet die Dateiauswahl.</td>
</tr>

<tr valign="top" $BGCOLOR1>
<td>3.</td>
<td>Fhren Sie die Wiederherstellung durch Klick auf den "Reparieren"-Knopf aus.</td>
<td><img src="images/btn-fix.png" alt="Reparieren-Knopf"></td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>4.</td>
<td>Verfolgen Sie den Fortschritt der Wiederherstellung.<p>
Whrend der Wiederherstellung sind Phasen hoher Festplatten-Aktivitt normal.</td>
<td><a href="example5.html"><img src="images/ex-fix.png" alt="Bildschirmfoto" width="200"></a><p>
</td>
</tr>
</table><p>

Wenn das Abbild erfolgreich wiederhergestellt wurde, knnen Sie es mit einer
handelsblichen Brennsoftware auf einen neuen Datentrger bertragen.

<hr><p>

<h3>Abbild in der Kommandozeile wiederherstellen</h3>

Zur Wiederherstellung des Abbildes bentigen Sie die folgenden Parameter
(Grundeinstellungen in Klammern):

<table>
<tr>
<td>-f/ --fix</td>
<td>Wiederherstellen</td>
</tr>
<tr>
<td>-i / --image</td>
<td>Abbild-Datei auswhlen (medium.iso)</td>
</tr>
<tr>
<td>-e / --ecc</td>
<td>nur fr <a href="background30.html">RS01</a>: Fehlerkorrektur-Datei auswhlen (medium.ecc)</td>
</tr>
</table><p>

Bei der Verwendung von erweiterten Abbildern entfllt die Angabe der
Fehlerkorrektur-Datei.<p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>dvdisaster -f -i abbild.iso -e korrektur.ecc</b><br>
dvdisaster-${project_version} Copyright 2004-2007 Carsten Gnrlich.<br>
Dies ist freie Software; es gelten die Bedingungen der<br>
GNU GENERAL PUBLIC LICENSE aus dem Quelltext.<p>

ffne abbild.iso: 2224288 Datentrger-Sektoren.<p>

"Fix"-Modus: Reparierbare Sektoren werden im Abbild wiederhergestellt.<br>
&nbsp;&nbsp;&nbsp;    5 reparierte Sektoren: 708225 59850 69825 79800 199500 <br>
&nbsp;&nbsp;&nbsp;    6 reparierte Sektoren: 708226 59851 69826 79801 89776 199501<br>
[... weitere Berichte ber reparierte Sektoren ...] <br>
&nbsp;&nbsp;&nbsp;    5 reparierte Sektoren: 708224 59849 69824 79799 199499<br>
Reparatur-Fortschritt: 100.0% <br>
Reparierte Sektoren: 33264 <br>  
Gut! Alle Sektoren wurden repariert.<br>
Auslschungen pro Ecc-Bereich: Mittelwert =  3.3; Schlechtester = 7.
</td></tr></table><p>

EOF
}

function example6de()
{  cat >> $1 <<EOF

<tr align="center"><td>
<h3>Bildschirmfoto: Datentrger-Abbild mit Fehlerkorrektur-Datei vergleichen</h3><p></td></tr>
<tr align="center"><td>
<center><img src="images/ex-compare.png" alt="Bildschirmfoto"></center>
<br clear="all">
</td></tr>

<tr align="center"><td>
<a name="rs02"></a>
<h3>Bildschirmfoto: Erweitertes Datentrger-Abbild mit darin enthaltenen Fehlerkorrektur-Daten vergleichen</h3><p></td></tr>
<tr align="center"><td>
<center><img src="images/ex-compare-rs02.png" alt="Bildschirmfoto"></center>
<br clear="all">
</td></tr>

<tr><td>

Der Vergleich kann eine Weile dauern, da beide 
Dateien komplett gelesen (aber nicht verndert) werden.<p>


Danach erhalten Sie die folgenden Informationen:<p>

<ul>
<li><b>Felder "Abbild-Datei" und "Datentrger-Zustand".</b><p> 
Diese Felder geben Aufschlu darber, ob das Abbild eine Fehlerkorrektur
bentigt. Bei noch unkorrigierten Lesefehlern ist die Anzahl der fehlenden
Sektoren grer als Null. Prfsummenfehler deuten hingegen auf
<a href="qa20.html#crc">Bedienungs-Fehler oder Hardware-Probleme</a> hin.<p></li>

<li><b>Feld "Fehlerkorrektur-Datei" bzw. "-Daten"</b>.<p>
Hier knnen Sie sehen, 
mit welchen Einstellungen die Fehlerkorrektur-Daten erstellt worden 
sind und ob sie mit der verwendeten
Version von dvdisaster verarbeitet werden knnen.<br>
Falls eine Fehlerkorrektur-Datei zu einem anderen Abbild gehrt oder 
beschdigt ist, erscheinen Warnungen im Bereich der letzten vier Eintrge.<p></li>

<li><b>Hinweis:</b> Wenn das Abbild mit einer anderen Software als dvdisaster eingelesen
worden ist, wird das Ergebnis des Vergleichs unzuverlssig.
Insbesondere erscheinen in diesem Fall alle fehlenden Sektoren als Prfsummenfehler.</li>
</ul>
</td></tr>
EOF
}

function example50de()
{  create_inline example de 6 example50.html "zum Vergleichen von Abbild- und Fehlerkorrektur-Dateien"

   cat >> $1 <<EOF
<h3>Informationen ber Abbild und Fehlerkorrektur-Daten anzeigen</h3>

Diese Funktion liefert Informationen ber Abbild- und Fehlerkorrektur-Daten,
die sich bereits auf der Festplatte befinden:<p>

<table width="100%" border="0" cellspacing="0" cellpadding="10">
<tr valign="top" $BGCOLOR1>
<td>1.</td>
<td>
Whlen Sie die Abbild-Datei aus.<p>
</td>
<td><img src="../images/btn-image.png" alt="Abbild-Datei-Auswahl"><p>
Das <img src="../images/open-img.png" alt="Dateiauswahl-Knopf" align="middle">-Symbol ffnet die Dateiauswahl.</td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>2.</td>
<td>
Wenn Sie mit Fehlerkorrektur-Dateien arbeiten, whlen Sie
die zugehrige Fehlerkorrektur-Datei aus. Lassen Sie das Eingabefeld leer
wenn Sie erweiterte Abbilder verwenden.<p>
</td>
<td><img src="../images/btn-eccfile.png" alt="Fehlerkorrektur-Datei-Auswahl"><p>
Das <img src="../images/open-ecc.png" alt="Dateiauswahl-Knopf" align="middle">-Symbol ffnet die Dateiauswahl.</td>
</tr>

<tr valign="top" $BGCOLOR1>
<td>3.</td>
<td>Vergleichen Sie das Abbild mit den Fehlerkorrektur-Daten
durch Klick auf den "Vergleichen"-Knopf.</td>
<td><img src="images/btn-compare.png" alt="Vergleichen-Knopf"></td>
</tr>

<tr valign="top" $BGCOLOR2>
<td>4.</td>
<td>Verfolgen Sie den Fortschritt des Vergleichs.</td>
<td><a href="example6.html"><img src="images/ex-compare.png" alt="Bildschirmfoto" width="200"></a><p>
</td>
</tr>
</table><p>

<hr><p>

<h3>Abbild- und Fehlerkorrektur-Daten in der Kommandozeile vergleichen</h3>

Fr den Vergleich bentigen Sie die folgenden Parameter
(Grundeinstellungen in Klammern):

<table>
<tr>
<td>-t/ --test</td>
<td>Vergleichen</td>
</tr>
<tr>
<td>-i / --image</td>
<td>Abbild-Datei auswhlen (medium.iso)</td>
</tr>
<tr>
<td>-e / --ecc</td>
<td>nur fr <a href="background30.html">RS01</a>: Fehlerkorrektur-Datei auswhlen (medium.ecc)</td>
</tr>
</table><p>

Beispiel zum Vergleichen eines Abbilds mit der zugehrigen Fehlerkorrektur-Datei:<p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>dvdisaster -t -i abbild.iso -e korrektur.ecc</b><br>
dvdisaster-${project_version} Copyright 2004-2007 Carsten Gnrlich.<br>
Dies ist freie Software; es gelten die Bedingungen der<br>
GNU GENERAL PUBLIC LICENSE aus dem Quelltext.<p>

/dvd/abbild.iso: vorhanden, enthlt 2224288 Datentrger-Sektoren.<br>
- Gutes Abbild      : Alle Sektoren vorhanden<br>
- Abbild-md5sum     : 55cdd507e8d96af0da0667ce4365c7ae<p>

/dvd/korrektur.ecc: Erzeugt von dvdisaster-0.62.<br>
- Methode           : RS01, 32 Nullstellen, 14.3% Redundanz.<br>
- Bentigt          : dvdisaster-0.55 (gut)<br>
- Datentr.-Sektoren : 2224288 (gut)<br>
- Abbild-md5sum     : 55cdd507e8d96af0da0667ce4365c7ae (gut)<br>
- Fingerabdruck     : pat (gut)<br>
- Ecc-Bereiche      : 20428800 (gut)<br>
- Ecc-md5sum        : 4bdf5ed398e7662ac93c9d08e1ba9ff2 (gut)
</td></tr></table><p>

Beispiel zum Prfen eines mit Fehlerkorrektur-Daten erweiterten Abbilds:<p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>dvdisaster -t -i abbild.iso</b><br>
dvdisaster-${project_version} Copyright 2004-2007 Carsten Gnrlich.<br>
Dies ist freie Software; es gelten die Bedingungen der<br>
GNU GENERAL PUBLIC LICENSE aus dem Quelltext.<p>

/dvd/abbild.iso: vorhanden, enthlt 2281713 Datentrger-Sektoren.<br>
- Gutes Abbild      : Alle Sektoren vorhanden<br>
- Daten-md5sum      : 1b6ad314c0cbaa1874841c41ee05a620<p>

Fehlerkorrektur-Daten: Erzeugt von dvdisaster-0.70<br>
- Methode           : RS02, 94 Nullstellen, 58.4% Redundanz.<br>
- Bentigt          : dvdisaster-0.66 (gut)<br>
- Datentr.-Sektoren : 2281713 (gut)<br>
- Daten-md5sum      : 1b6ad314c0cbaa1874841c41ee05a620 (gut)<br>
- CRC-md5sum        : 105381481a7d5e490d3a53ae66e19f79 (gut)<br>
- Ecc-md5sum        : 5d04d3746a228dd8ad23442aeb80d838 (gut)
</td></tr></table><p>

EOF
}

# ----- Downloads

function download_contents_de()
{  local file="$1.html"
   local query=$2
   local page=$3
   local lang=$4

   case $query in
   title)   title="Herunterladen" ;;

   link)    link_title="Herunterladen" ;;
   link10)   link_title="Systemanforderungen" ;;
   link20)   link_title="Installation" ;;

   content*) eval "download$page$lang $file" ;;
   esac 
}

function download0de()
{  cat >> $1 <<EOF
<h3>dvdisaster herunterladen</h3>

dvdisaster untersttzt die Betriebssysteme Darwin/Mac OS X, FreeBSD, Linux, NetBSD und Windows
in den <a href="download10.html">aktuellen Versionen</a>.<p>

Laden Sie sich bitte entweder den Quellkode oder eine Binrversion 
aus der folgenden Liste herunter. Die Pakete knnen mit
einer <a href="#signature">digitalen Unterschrift</a> auf 
ihren Ursprungszustand berprft werden.<p>

Um die Binrversion fr Windows zu installieren, rufen Sie das Programm nach dem
Herunterladen auf und folgen dem Dialog. Fr die Installation
der Quellkode-Version gibt es <a href="download20.html">Installationshinweise</a>.

<pre> </pre>

<!---
<b>Entwickler-Versionen</b> - neu und experimentell fr erfahrene Benutzer!<p> 
<b>Stabile Versionen</b> - zum Einstieg empfohlen<p> 
--->

<b>Alpha-/Entwickler-Versionen</b> - neu und experimentell fr erfahrene Benutzer!<p> 

Wir suchen Tester fr die nchste dvdisaster-Version.<br>
Die neueste <a href="../en/download30.html">experimentelle Version</a> 
ist <a href="../en/download30.html">${cooked_version}</a>;<br> 
eine Beschreibung gibt es zur Zeit nur in englischer Sprache. <p>

<b>Stabile Versionen</b> - zum Einstieg empfohlen<p> 

<table width="100%" $IDXCOLOR cellpadding="0" cellspacing="5">
<tr><td><b>dvdisaster-0.70</b></td><td align="right">20-Jan-2007</td></tr>
<tr bgcolor="#000000"><td colspan="2"><img width=1 height=1 alt=""></td></tr>
<tr><td colspan="2">
  <table>
    <tr><td align="right">&nbsp;&nbsp;Quellkode fr alle Betriebssysteme:&nbsp;</td>
        <td><a href="${tar_0_70}">dvdisaster-0.70.4.tar.bz2</a></td></tr>
    <tr><td align="right">Digitale Unterschrift:&nbsp;</td>
        <td><a href="${tar_0_70_sig}">dvdisaster-0.70.4.tar.bz2.gpg</a></td></tr>
    <tr><td align="right">Binrversion fr Windows:&nbsp;</td>
        <td><a href="${setup_0_70}">dvdisaster-0.70.4-setup.exe</a></td></tr>
    <tr><td align="right">Digitale Unterschrift:&nbsp;</td>
        <td><a href="${setup_0_70_sig}">dvdisaster-0.70.4-setup.exe.gpg</a></td></tr>
  </table>
</td></tr>
<tr bgcolor="#000000"><td colspan="2"><img width=1 height=1 alt=""></td></tr>
<tr><td colspan="2">
Das <a href="background30.html">RS02-Fehlerkorrektur-Verfahren</a>
wird in der graphischen Benutzeroberflche vollstndig untersttzt.
Damit erzeugte Abbilder knnen nun auch
mit dem <a href="background50.html">angepaten Leseverfahren</a>
 verarbeitet werden.<p>

Julian Einwag hat damit begonnen, dvdisaster 
fr <a href="download20.html#darwin">Mac OS X / Darwin</a> anzupassen.<p>

Daniel Nylander hat die Bildschirmtexte ins Schwedische bersetzt.<p>

<b>Patches</b> (kleine nderungen nach Version 0.70; die obigen Dateien wurden erneuert):<br>

<b>pl4</b> ist besser kompatibel zu zweischichtigen DVDs 
(DVD-R DL und DVD+R DL).<br> 
Einige kleinere Fehler wurden behoben. <i>(20-Jan-2007)</i>.<p>

<b>pl3</b> behebt einen Fehler bei der Erkennung von nicht untersttzten CDs,
der unter Umstnden einen blauen Bildschirm unter Windows erzeugte.
Abbruchmglichkeit whrend der RS02-Erkennung fr DVD RW hinzugefgt.
<i>(10-Dez-2006)</i>.<p>

<b>pl2</b> behebt eine fehlerhafte Speicherfreigabe beim Schlieen des Programms.
Das Auspacken der Bildschirmfotos fr die Dokumentation auf PPC-Plattformen wurde
korrigiert. Nur die Quellkode-Archive wurden erneuert. 
<i>(03-Okt-2006)</i>.<p>

<b>pl1</b> behebt einen Fehler im angepaten Lesen fr RS02, durch den unter bestimmten
Bedingungen nicht gengend Daten fr eine erfolgreiche Wiederherstellung gelesen wurden.
Ein paar kleine Verbesserungen an der Dokumentation und der Benutzbarkeit sind auch dabei.
<i>(30-Jul-2006)</i>
</td></tr></table><p>

Der dvdisaster-Quellkode wird auch in einem
<a href="http://sourceforge.net/cvs/?group_id=157550">CVS-Archiv</a>
bereitgestellt.

<pre> </pre>

<b>ltere Versionen</b><p> 

<table width="100%" $IDXCOLOR cellpadding="0" cellspacing="5">
<tr><td><b>dvdisaster-0.66</b></td><td align="right">25-Mr-2006</td></tr>
<tr bgcolor="#000000"><td colspan="2"><img width=1 height=1 alt=""></td></tr>
<tr><td colspan="2">
  <table>
    <tr><td align="right">&nbsp;&nbsp;Quellkode fr alle Betriebssysteme:&nbsp;</td>
        <td><a href="${tar_0_66}">dvdisaster-0.66.3.tar.bz2</a></td></tr>
    <tr><td align="right">Digitale Unterschrift:&nbsp;</td>
        <td><a href="${tar_0_66_sig}">dvdisaster-0.66.3.tar.bz2.gpg</a></td></tr>
    <tr><td align="right">Binrversion fr Windows:&nbsp;</td>
        <td><a href="${setup_0_66}">dvdisaster-0.66.3-setup.exe</a></td></tr>
    <tr><td align="right">Digitale Unterschrift:&nbsp;</td>
        <td><a href="${setup_0_66_sig}">dvdisaster-0.66.3-setup.exe.gpg</a></td></tr>
  </table>
</td></tr>
<tr bgcolor="#000000"><td colspan="2"><img width=1 height=1 alt=""></td></tr>
<tr><td colspan="2">
Abbilder werden bereits beim <a href="example10.html">Prfen</a> mit der
Fehlerkorrektur-Datei abgeglichen. Das Erzeugen von Dateien kann nach 
behobenem Speicherplatzmangel auf der Festplatte fortgesetzt werden.<p>

<i>Neues <a href="background30.html">Fehlerkorrektur-Verfahren</a> ohne 
Fehlerkorrektur-Datei:</i> 
Fehlerkorrektur-Informationen knnen direkt an das Abbild angehngt werden.
Das Verfahren ist noch experimentell und in dieser Version nur in der
Kommandozeile verfgbar. Schauen Sie auch in 
das <a href="http://sourceforge.net/cvs/?group_id=157550">CVS-Archiv</a>,
um die Weiterentwicklung des neuen Verfahrens zu verfolgen (bentigt Kenntnisse
zum Erzeugen von Programmen aus dem Quellkode).<p>

<b>Patches</b> (kleine nderungen nach Version 0.66; die obigen Dateien wurden erneuert):<br>
<b>pl3</b> behebt eine fehlerhafte Installation des Benutzerhandbuchs
unter bestimmten Windows-Versionen. Andere Betriebssysteme sind nicht betroffen.
</td></tr></table><p>

<pre> </pre>

<table width="100%" $IDXCOLOR cellpadding="0" cellspacing="5">
<tr><td><b>dvdisaster-0.65</b></td><td align="right">14-Jan-2006</td></tr>
<tr bgcolor="#000000"><td colspan="2"><img width=1 height=1 alt=""></td></tr>
<tr><td colspan="2">
  <table>
    <tr><td align="right">&nbsp;&nbsp;Quellkode fr alle Betriebssysteme:&nbsp;</td>
        <td><a href="${tar_0_65}">dvdisaster-0.65.tar.bz2</a></td></tr>
    <tr><td align="right">Digitale Unterschrift:&nbsp;</td>
        <td><a href="${tar_0_65_sig}">dvdisaster-0.65.tar.bz2.gpg</a></td></tr>
    <tr><td align="right">Binrversion fr Windows:&nbsp;</td>
        <td><a href="${setup_0_65}">dvdisaster-0.65-setup.exe</a></td></tr>
    <tr><td align="right">Digitale Unterschrift:&nbsp;</td>
        <td><a href="${setup_0_65_sig}">dvdisaster-0.65-setup.exe.gpg</a></td></tr>
  </table>
</td></tr>
<tr bgcolor="#000000"><td colspan="2"><img width=1 height=1 alt=""></td></tr>
<tr><td colspan="2">
<i>Alle Betriebssysteme:</i>
<ul>
<li>Das Prfen des Abbildes entfllt bei der Erstellung der Fehlerkorrekturdatei,<br>
wenn das Abbild unmittelbar vorher eingelesen wurde.</li>
<li>Fehlerkorrektur-Dateien knnen in 2GB groe Segmente aufgeteilt werden.</li>
<li>Tschechische bersetzung von Lubo&#353; Stan&#283;k.</li>
</ul>
<i>FreeBSD:</i>
<ul>
<li>wird mit dieser Version erstmalig untersttzt.</li>
</ul>
<i>Windows:</i>
<ul>
<li>komplette Untersttzung fr FAT32-Dateisysteme (s.o.)</li>
<li>Binrversion wird jetzt mit Gtk+2.6-Bibliotheken ausgeliefert.</li>
</ul>
</td></tr></table><p>

<pre> </pre>

<table width="100%" $IDXCOLOR cellpadding="0" cellspacing="5">
<tr><td><b>dvdisaster-0.64 (pl2)</b></td><td align="right">01-Nov-2005</td></tr>
<tr bgcolor="#000000"><td colspan="2"><img width=1 height=1 alt=""></td></tr>
<tr><td colspan="2">
  <table>
    <tr><td align="right">&nbsp;&nbsp;Quellkode (Linux/Windows):&nbsp;</td>
        <td><a href="http://download.berlios.de/dvdisaster/dvdisaster-0.64.2.tar.bz2">dvdisaster-0.64.2.tar.bz2</a></td></tr>
    <tr><td align="right">Digitale Unterschrift:&nbsp;</td>
        <td><a href="http://download.berlios.de/dvdisaster/dvdisaster-0.64.2.tar.bz2.gpg">dvdisaster-0.64.2.tar.bz2.gpg</a></td></tr>
    <tr><td align="right">Binrversion fr Windows:&nbsp;</td>
        <td><a href="http://download.berlios.de/dvdisaster/dvdisaster-0.64.2-setup.exe">dvdisaster-0.64.2-setup.exe</a></td></tr>
    <tr><td align="right">Digitale Unterschrift:&nbsp;</td>
        <td><a href="http://download.berlios.de/dvdisaster/dvdisaster-0.64.2-setup.exe.gpg">dvdisaster-0.64.2-setup.exe.gpg</a></td></tr>
  </table>
</td></tr>
<tr bgcolor="#000000"><td colspan="2"><img width=1 height=1 alt=""></td></tr>
<tr><td colspan="2">
Diese Version kann die Abbild-Gre aus dem
UDF/ISO-Dateisystem bestimmen, um 
die <a href="qa20.html#plusrw">Grenerkennung von -RW/+RW-Medien</a> zu verbessern.
Das Einlesen von Abbildern und das Erzeugen der zugehrigen Fehlerkorrektur-Datei
kann jetzt zusammen mit einem Mausklick durchgefhrt werden.
Auerdem gibt es eine Reihe von kleinen Verbesserungen in den Bereichen
Laufwerksuntersttzung, Abrundung der Funktionalitt 
sowie einige kleinere Bugs weniger ;-)<p>
<b>Patches</b> (kleine nderungen nach Version 0.64; die obigen Dateien wurden erneuert):<br>
<b>pl1</b> verhindert Absturz sofort nach dem Programmaufruf  bei Verwendung von gtk+-2.6; 
betrifft nur die Linux-Version.<br>
<b>pl2</b> repariert die -u-Kommandozeilenoption und
pat Dateinamen-Berechtigungen unter Linux an Unix-Konventionen an.

</td></tr></table><p>

<table width="100%" $IDXCOLOR cellpadding="0" cellspacing="5">
<tr><td><b>dvdisaster-0.63</b></td><td align="right">01-Aug-2005</td></tr>
<tr bgcolor="#000000"><td colspan="2"><img width=1 height=1 alt=""></td></tr>
<tr><td colspan="2">
  <table>
    <tr><td align="right">&nbsp;&nbsp;Quellkode (Linux/Windows):&nbsp;</td>
        <td><a href="http://download.berlios.de/dvdisaster/dvdisaster-0.63.tbz">dvdisaster-0.63.tbz</a></td></tr>
    <tr><td align="right">Digitale Unterschrift:&nbsp;</td>
        <td><a href="http://download.berlios.de/dvdisaster/dvdisaster-0.63.tbz.gpg">dvdisaster-0.63.tbz.gpg</a></td></tr>
    <tr><td align="right">Binrversion fr Windows:&nbsp;</td>
        <td><a href="http://download.berlios.de/dvdisaster/dvdisaster-0.63-setup.exe">dvdisaster-0.63-setup.exe</a></td></tr>
    <tr><td align="right">Digitale Unterschrift:&nbsp;</td>
        <td><a href="http://download.berlios.de/dvdisaster/dvdisaster-0.63-setup.exe.gpg">dvdisaster-0.63-setup.exe.gpg</a></td></tr>
  </table>
</td></tr>
<tr bgcolor="#000000"><td colspan="2"><img width=1 height=1 alt=""></td></tr>
<tr><td colspan="2">
Enthlt ein <a href="example40.html">verbessertes Verfahren</a> zum
Lesen defekter Datentrger, 
das durch einen Artikel im c't-Magazin 16/2005 motiviert wurde.
</td></tr></table><p>

<pre> </pre>

<b>Historische Versionen</b><p>

<table width="100%" $IDXCOLOR cellpadding="0" cellspacing="5">
<tr><td><b>dvdisaster-0.55</b></td><td align="right">20-Feb-2005</td></tr>
<tr bgcolor="#000000"><td colspan="2"><img width=1 height=1 alt=""></td></tr>
<tr><td colspan="2">
  <table>
    <tr><td align="right">&nbsp;&nbsp;Quellkode (Linux/Windows):&nbsp;</td>
        <td><a href="http://download.berlios.de/dvdisaster/dvdisaster-0.55.tgz">dvdisaster-0.55.tgz</a></td></tr>
    <tr><td align="right">Digitale Unterschrift:&nbsp;</td>
        <td><a href="http://download.berlios.de/dvdisaster/dvdisaster-0.55.tgz.gpg">dvdisaster-0.55.tgz.gpg</a></td></tr>
    <tr><td align="right">Binrversion fr Windows:&nbsp;</td>
        <td><a href="http://download.berlios.de/dvdisaster/dvdisaster-0.55.zip">dvdisaster-0.55.zip</a></td></tr>
    <tr><td align="right">Digitale Unterschrift:&nbsp;</td>
        <td><a href="http://download.berlios.de/dvdisaster/dvdisaster-0.55.zip.gpg">dvdisaster-0.55.zip.gpg</a></td></tr>
  </table>
</td></tr>
<tr bgcolor="#000000"><td colspan="2"><img width=1 height=1 alt=""></td></tr>
<tr><td colspan="2">
Dies ist die letzte reine Kommandozeilen-Version von dvdisaster.
</td></tr></table><p>

<pre> </pre>

<a name="signature"><b>Was ist die digitale Unterschrift?</b></a><p>

Die herunterladbaren Quellkode-Pakete enthalten
eine mit <a href="http://www.gnupg.org/gnupg.html">GnuPG</a> erstellte 
digitale Unterschrift, damit Sie nachprfen knnen,
ob sich die Software in ihrem ursprnglichen Zustand befindet.<p>

Zur berprfung der Echtheit des <a href="../pubkey.asc">ffentlichen Schlssels</a> 
vergleichen Sie seinen "Fingerabdruck" am besten mit demjenigen, der in der Fuzeile
meiner EMails angegeben ist. Schicken Sie mir bei Bedarf eine EMail mit dem
Betreff "GPG Fingerabdruck".
EOF
}


function download10de()
{  cat >> $1 <<EOF
<h3>Systemanforderungen</h3>

<ul>
 <li><b>x86-kompatible</b> Hardware in der <b>32bit</b>-Betriebsart
  (64-bit Untersttzung siehe Betriebssysteme);
  PowerPC und Sparc ab Version 0.72,<p></li>
 <li>ein aktuelles CD- oder DVD-Laufwerk mit ATAPI- oder SCSI-Schnittstelle,<p></li>
 <li>mindestens P4 mit 2Ghz oder vergleichbare Rechenleistung.<p>
</ul>

<h3>Betriebssysteme</h3>

<ul>
 <li><b>FreeBSD</b> ab Version <b>6.0</b><br> 
     (fr ATAPI-Laufwerke mu der Kernel neu bersetzt werden)<p>
 </li>
 <li><b>Linux</b> ab Kernel <b>2.6.7</b>, 64bit mglich<br> 
     (Kernel >= 2.4.20 sind mglich, aber nicht empfohlen!)<p>
 </li>
 <li><b>Mac OS X</b> ab Version 10.4 (Tiger),<br> 
      auf x86 und PowerPC-Hardware.<p>
 </li>
 <li><b>NetBSD</b> ab Version 3.1.<p></li>

 <li><b>Windows</b> <b>2000</b> oder <b>XP</b><br>
     Windows 98 und ME sind mglich, aber fr die Bearbeitung von DVD nicht empfohlen.<br>
     Die Benutzung unter Windows Vista (R) ist mglich, aber weitgehend ungetestet.
 </li>
</ul>

EOF
}


function download20de()
{  cat >> $1 <<EOF
<h3>Installation der Quellkode-Version</h3>

<b>Bentigte Werkzeuge und Bibliotheken</b><p>

dvdisaster bentigt die blichen 
<a href="http://www.gnu.org/">GNU</a>-Entwicklungswerkzeuge 
zum bersetzen von C-Programmen.<p>

Abhngig vom Betriebssystem brauchen Sie auerdem:

<ul>
<li>Die <a href="http://www.gnu.org/software/gettext/">gettext</a>-Bibliothek</li>
<li>Die <a href="http://www.gnu.org/software/libiconv/">iconv</a>-Bibliothek (nur fr Windows)</li>
<li>Das Werkzeug <a href="http://www.freedesktop.org/software/pkgconfig/releases">pkgconfig</a></li>
<li>Die <a href="http://www.gtk.org">GTK+-Bibliothek</a> ab Version 2.2 einschlielich aller Hilfsbibliotheken</li>
</ul>

Bei FreeBSD und Linux sind diese Werkzeuge auf den
mitgelieferten Datentrgern normalerweise vorhanden.
Manchmal sind die Pakete nicht vollstndig installiert; in diesem
Fall mssen die Entwicklerversionen nachinstalliert werden.
Diese Versionen erkennen Sie typerweise an den Namensendungen
"-devel" oder "-dev".<p>

<a name="windows"></a>
<b>Hinweise fr Windows</b><p>

Fr Windows sind die GNU-Werkzeuge in der
<a href="http://www.mingw.org">Mingw</a>-Umgebung enthalten;
Cygwin wird nicht untersttzt.<p>

Das <a href="http://www.gtk.org">Gtk+</a>-Projekt bietet
spezielle Versionen dieser Bibliotheken 
<a href="http://www.gimp.org/~tml/gimp/win32/downloads.html">fr Windows</a> an.
Sie bentigen sowohl die normalen Bibliotheken als auch die "-devel"-Versionen.<p> 

<a name="darwin"></a>
<b>Hinweise fr Mac OS X / Darwin</b><p>

dvdisaster wurde von Julian Einwag an  
<a href="http://de.wikipedia.org/wiki/Darwin_%28Betriebssystem%29">Darwin</a>
angepat, dem Unix-Unterbau von Mac OS X. 
Momentan mu dvdisaster unter
Mac OS X als <a href="http://developer.apple.com/opensource/tools/runningX11.html">X11-Anwendung bersetzt und betrieben</a> werden,
weil eine Aqua-Version der <a href="http://www.gtk.org">Gtk+-Bibliothek</a> 
zwar bereits in Arbeit ist, aber noch nicht stabil luft. Sobald sich dies ndert,
wird dvdisaster ohne X11 unter Mac OS X lauffhig sein.<p>

Mac OS X erlaubt in der Grundeinstellung nur seiner eigenen Benutzeroberflche
einen Zugriff auf CD/DVD-Laufwerke. Damit dvdisaster auf die Laufwerke zugreifen kann, 
mssen Sie die Laufwerke vorher "unmounten".<p>

<a name="freebsd"></a>
<b>Hinweise fr FreeBSD</b><p>

FreeBSD hat keinen einheitlichen CD-ROM-Treiber vorinstalliert, der sowohl SCSI- als
auch ATAPI-Laufwerke untersttzt (wie dies unter Linux und Windows der Fall ist).
Dadurch kann dvdisaster auf einem frisch installierten FreeBSD-System keine 
ATAPI-Laufwerke ansprechen. Um einen passenden Treiber nachzuinstallieren,
mssen Sie einen Kernel mit dem zustzlichen Modul<p>

<tt>device atapicam</tt><p>

erzeugen. Die Module <i>ata</i>, <i>scbus</i>, <i>cd</i>
und <i>pass</i> werden ebenfalls bentigt, sind aber bei FreeBSD 6.0 
schon voreingestellt. Zum bersetzen der dvdisaster-Quellen bentigen Sie
auerdem GNU make (gmake) und die bash-Kommandozeile.<p>

<b>bersetzen des Quellkodes</b><p>

Um den Quellkode zu bersetzen, fhren Sie bitte die folgenden Schritte
in einer Eingabeaufforderung durch.<p>

Packen Sie das Quellkode-Archiv aus:<p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>tar xjf $project_package.tar.bz2</b><br>
</td></tr></table><p>

Wechseln Sie in das dadurch erzeugte Verzeichnis:<p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>cd $project_package</b><br>
</td></tr></table><p>

Rufen Sie das Konfigurations-Skript auf:<p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>bash configure</b><br>
<i>[... viele Ausgaben des Konfigurationsskriptes ...]</i>
</td></tr></table><p>

Das Skript wird Ihnen gegebenenfalls Hinweise ber fehlende 
Bibliotheken geben. "bash configure --help" liefert Informationen darber,
wie man den Pfad zu einer bereits installierten Bibliothek setzen kann.<p>

Wenn das Konfigurations-Skript ohne Fehlermeldungen abgearbeitet ist,
bersetzen Sie den Quellkode in das ausfhrbare Programm:<p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>gmake</b><br>
<i>[... viele Ausgaben des bersetzungsprozesses ...]</i>
</td></tr></table><p>

Rufen Sie das Programm testweise auf:<p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>./dvdisaster</b><br>
<i>[... nach einer Weile ffnet sich das Hauptfenster ...]</i>
</td></tr></table><p>

Sie knnen das Programm direkt aus dem aktuellen Verzeichnis
aufrufen und verwenden. Eine Kopie der dvdisaster-Internetseiten
befindet sich brigens im Unterverzeichnis <i>documentation/de.</i><p>

Optional knnen Sie das Programm und die Dokumentation auch
in Ihrem System installieren lassen:<p>

<table class="example" width=100% bgcolor=#ffffe0><tr><td>
user@linux&gt; <b>gmake install</b><br>
<i>[... Ausgaben des Installationsvorganges ...]</i>
</td></tr></table><p>

Beachten Sie vorher die Ausgabe des "<tt>configure</tt>"-Skriptes oder geben 
Sie "<tt>gmake show</tt>" ein um zu erfahren, in welche Unterverzeichnisse
die Programmkomponenten installiert werden. <p>
Rufen Sie "<tt>bash configure --help</tt>" auf, um
Informationen darber zu erhalten, wie Sie diese Pfade an Ihr System
anpassen knnen.

<pre> </pre>

<font size="+1">Viel Erfolg bei der Benutzung von dvdisaster!</font>
EOF
}

# ----- Questions and Answers

function qa_contents_de()
{  local file="$1.html"
   local query=$2
   local page=$3
   local lang=$4

   case $query in
   title)   title="Fragen und Antworten" ;;

   link)    link_title="Fragen und Antworten" ;;
   link10)   link_title="Technische Fragen" ;;
   link20)   link_title="Fehlermeldungen" ;;

   content*) eval "qa$page$lang $file" ;;
   esac 
}

function qa0de()
{  cat >> $1 <<EOF
<h3><a name="top">Allgemeine Fragen und Antworten</a></h3>

<a href="#pronounce">1.1 Wie spricht man "dvdisaster" aus?</a><p>
<a href="#pipo">1.2 Wo gibt es mehr Informationen zu PI/PO-Analysen?</a><p>
<a href="#compat">1.3 Ist dvdisaster mit nachfolgenden Versionen kompatibel?</a>

<pre> </pre><hr><pre> </pre>

<b><a name="pronounce">1.1 Wie spricht man "dvdisaster" aus?</a></b><p>
Da der Wortstamm <i>disaster</i> aus dem Englischen kommt, 
spricht man es etwa wie "diwidisaster" aus. 
<div align=right><a href="#top">&uarr;</a></div>


<b><a name="pipo">1.2 Wo gibt es mehr Informationen zu PI/PO-Analysen?</a></b><p>
DVDs enthalten einen Fehlerkorrektur-Mechanismus, der nach einem
<a href="background10.html">hnlichen Prinzip</a> wie dvdisaster arbeitet.
Die Fehlerkorrektur findet bei DVDs in zwei Ebenen bzw. Schritten statt, 
die als PI und PO bezeichnet werden. Erst wenn ein Fehler auf beiden
Ebenen nicht korrigierbar ist, meldet das Laufwerk unlesbare Sektoren
und es gibt Arbeit fr dvdisaster (oder der Datentrger ist reif fr den Mll). <p>

Fr einige DVD-Laufwerke gibt es Programme, die ermitteln knnen, 
wie hufig die beiden Fehlerkorrektur-Ebenen beim Auslesen einer DVD beansprucht werden. 
Im Internet gibt es viele interessante Foren mit Verweisen auf diese Werkzeuge. 
Dort finden sich auch einige gut gemachte Artikel darber, 
wie man aus den gemessenen PI/PO-Werten Rckschlsse
auf die Qualitt der betreffenden Datentrger ziehen kann. 
<div align=right><a href="#top">&uarr;</a></div><p>

<b><a name="compat">1.3 Ist dvdisaster mit nachfolgenden Versionen kompatibel?</a></b><p>
Ja, denn dvdisaster ist fr eine Datenarchivierung ber viele Jahre vorgesehen. 
Sie knnen beim Umstieg auf eine neuere Version von dvdisaster die Abbild- und
Fehlerkorrekturdateien von Vorgngerversionen weiter verwenden und brauchen
diese <i>nicht</i> neu zu erzeugen.<p>
<div align=right><a href="#top">&uarr;</a></div><p>

EOF
}


function qa10de()
{  cat >> $1 <<EOF
<h3><a name="top">Technische Fragen</a></h3>

<a href="#nls">2.1 In welchen bersetzungen ist das Programm verfgbar?</a><p>
<a href="#media">2.2 Welche Datentrger-Typen werden untersttzt?</a><p>
<a href="#filesystem">2.3 Welche Dateisysteme werden untersttzt?</a><p>
<a href="#aspi">2.4 Was bedeuten "SPTI" und "ASPI"?</a><p>

<pre> </pre><hr><pre> </pre>

<b><a name="nls">2.1 In welchen bersetzungen ist das Programm verfgbar?</a></b><p>

dvdisaster beinhaltet Bildschirmtexte in den folgenden Sprachen:<p>

<table>
<tr><td>&nbsp;&nbsp;&nbsp;</td><td>Deutsch</td><td>--</td><td>vollstndig</td></tr>
<tr><td></td><td>Englisch</td><td>--</td><td>vollstndig</td></tr>
<tr><td></td><td>Italienisch</td><td>--</td><td>bis Version 0.65</td></tr>
<tr><td></td><td>Russisch</td><td>--</td><td>vollstndig</td></tr>
<tr><td></td><td>Schwedisch</td><td>--</td><td>vollstndig</td></tr>
<tr><td></td><td>Tschechisch</td><td>--</td><td>bis Version 0.66</td></tr>
</table><p>

bersetzer/-innen fr andere Sprachen sind willkommen!<p>

dvdisaster bernimmt die Spracheinstellungen des Betriebssystems
automatisch. Falls die lokale Sprache noch nicht untersttzt wird,
werden englische Texte verwendet. Eine andere Sprache kann mit Hilfe
von Umgebungsvariablen eingestellt werden.<p>

Zum Beispiel fr die bash-Kommandozeile und deutsche Sprache:

<pre>export LANG=de_DE</pre>

Wenn Umlaute nicht richtig oder als "a,"o,"u usw. dargestellt werden,
fehlt eventuell noch: <p>

<tt>export OUTPUT_CHARSET=iso-8859-1</tt> (X11, XTerm)

<div align=right><a href="#top">&uarr;</a></div>



<b><a name="media">2.2 Welche Datentrger-Typen werden untersttzt?</a></b><p>

dvdisaster untersttzt einmal oder mehrmals beschreibbare CD- und DVD-Datentrger.
Datentrger mit Mehrfachsitzungen (engl.: multisession)
oder einem Kopierschutz knnen <i>nicht</i> verwendet werden.<p>

Untersttzte Datentrger nach Typ:<p>

<b>CD-R, CD-RW</b><p>

<ul>
 <li>nur Daten-CDs werden untersttzt.</li>
</ul>

<b>DVD-R, DVD+R</b><p>

<ul>
<li>Keine weiteren Einschrnkungen bekannt.</li>
</ul>

<b>DVD-R DL, DVD+R DL (zweischichtig)</b>
<ul>
<li>
Das Laufwerk mu die <a href="qa20.html#dvdrom">Erkennung
des Datentrger-Typs</a> ermglichen. Dies erfordert typischerweise 
Laufwerke, die auch zweischichtige Medien beschreiben knnen.
</li>
</ul>

<b>DVD-RW, DVD+RW</b><p>

<ul>
<li>Einige Laufwerke liefern eine <a href="qa20.html#plusrw">falsche Abbild-Gre</a>.<br>
Abhilfe: Abbildgre aus dem ISO/UDF- oder ECC/RS02-Dateisystem ermitteln.
</li>
</ul>

<b>DVD-RAM</b><p>
<ul>
<li>Mssen wie DVD-R/-RW mit einem ISO/UDF-Abbild beschrieben sein.</li>
<li>Keine Untersttzung bei Einsatz als Wechselspeichermedium / packet writing.</li>
<li>hnliche Probleme mit der Erkennung der <a href="qa20.html#rw">Abbild-Gre</a>
wie oben beschrieben mglich.</li>
</ul>

<b>Nicht verwendbare Typen</b> (kein Einlesen des Abbildes mglich):<p> 
DVD-ROM (geprete DVDs) sowie Audio-CD und Video-CD.

<div align=right><a href="#top">&uarr;</a></div><p>


<b><a name="filesystem">2.3 Welche Dateisysteme werden untersttzt?</a></b><p>

dvdisaster arbeitet ausschlielich auf der Ebene von 
<a href="background20.html">Datentrger-Abbildern</a>,
auf die es sektorweise zugreift. 
Daher ist es unerheblich, mit welchem Dateisystem der Datentrger formatiert wurde. <p>
Weil dvdisaster die Struktur der Dateisysteme nicht kennt bzw. nutzt,
kann es keine logischen Fehler darin beheben und insbesondere keine
verlorengegangenen oder gelschten Dateien wiederherstellen.
<div align=right><a href="#top">&uarr;</a></div><p>


<b><a name="aspi">2.4 Was bedeuten "SPTI" und "ASPI"?</a></b><p>

Windows 98 und ME verwenden ASPI als Treiber, um CD/DVD-Laufwerke 
anzusprechen. Windows NT und seine Nachfolger
sind hingegen mit der Schnittstelle SPTI ausgerstet, erlauben
jedoch auch noch die zustzliche Installation von ASPI-Treibern.<p>

<i>&gt;&nbsp; Vor- und Nachteile von ASPI unter Windows NT/2000/XP?</i><p>

<table>
<tr valign=top><td>+</td><td>Es werden keine Systemverwalterrechte fr den Zugriff
auf die Laufwerke bentigt.</td></tr>
<tr valign=top><td>-</td><td>ASPI erlaubt manchmal keine eindeutige Zuordnung von Laufwerksbuchstaben.</td></tr>
<tr valign=top><td>-</td><td>Einige Brennprogramme installieren ihre 
eigenen ASPI-Versionen.
Die zustzliche Installation eines fremden ASPI-Treibers kann die Funktion
der vorhandenen Brennsoftware stren.</td></tr>
</table><p>

<i>&gt;&nbsp; Welche ASPI-Version wird fr die Benutzung mit dvdisaster empfohlen?</i><p>

Adaptec stellt seine ASPI-Treiber zum kostenlosen Herunterladen bereit.
Unter Windows 2000/XP erkennen die Versionen 4.72.* manchmal keine
Laufwerke. In diesem Fall hilft typischerweise die Installation der
lteren Version 4.60.<p>

<i>&gt;&nbsp; Die Laufwerksbuchstaben stimmen unter ASPI nicht!</i><p>

Die ASPI-Treiber verwenden ein eigenes System von Laufwerkskennungen,
das nicht zu den Laufwerksbuchstaben von Windows kompatibel ist.<br>
Um eine einheitliche Benutzerschnittstelle fr SPTI und ASPI zu bieten, 
versucht dvdisaster zu erraten, wie die Laufwerke unter ASPI zugeordnet sind.
Diese Zuordnung gelingt nicht in allen Konfigurationen.<p>

Mit Hilfe der --list -Funktion kann man 
die aktuelle Zuordnung von Laufwerksbuchstaben herausfinden.<p>

<i>&gt;&nbsp; Wie kann man zwischen SPTI und ASPI auswhlen?</i><p>

In der Grundeinstellung whlt dvdisaster automatisch zwischen SPTI und
ASPI aus, wobei SPTI bevorzugt wird.
Die Benutzung von ASPI kann allerdings erzwungen werden; 
nheres dazu steht in der Beschreibung
der --list -Funktion.

<div align=right><a href="#top">&uarr;</a></div><p>

EOF
}


function qa20de()
{  cat >> $1 <<EOF
<h3>Fehlermeldungen und Probleme</h3>

<a href="#tao">3.1 Was bedeutet "Warnung: 2 Sektoren fehlen am Ende des Datentrgers..."?</a><p>
<a href="#block">3.2 Das Programm hngt nach dem Aufruf.</a><p>
<a href="#crc">3.3 Was bedeutet die Meldung "CRC error, sector: n"?</a><p>
<a href="#plusrw">3.4 Lesefehler oder falsche Abbild-Gre bei -RW/+RW/-RAM-Datentrgern</a><p>
<a href="#dvdrom">3.5 Selbstgebrannter Datentrger wird als "DVD-ROM" erkannt und abgelehnt.</a><p>
<a href="#freebsd">3.6 Unter FreeBSD erscheinen keine Laufwerke.</a><p>
<a href="#v40error">3.7 "Fehlerkorrekturdatei wurde mit Version 0.40.7 erzeugt"</a><p>

<pre> </pre><hr><pre> </pre>

<b><a name="tao">3.1 Was bedeutet "Warnung: 2 Sektoren fehlen am Ende des Datentrgers..."?</a></b><p>
Diese Warnung tritt bei CD-Datentrgern auf, die im "TAO"-Modus ("track at once")
gebrannt wurden. Manche Laufwerke liefern fr diese Medien eine um 2 zu groe Lnge
fr das Abbild zurck. Dadurch entstehen 2 Pseudo-Lesefehler am Ende des Datentrgers, 
die jedoch <i>keinen</i> Datenverlust bedeuten. <p>

Da man dem Datentrger nicht ansehen kann, in welcher Betriebsart er gebrannt wurde,
geht dvdisaster davon aus, da eine "TAO"-CD vorliegt, wenn nur die letzten beiden
Sektoren unlesbar sind, und das Abbild wird um diese beiden Sektoren verkrzt.
Ob dies zutreffend ist, mssen Sie von Fall zu Fall selbst entscheiden
und gegebenenfalls mit der --dao -Option 
oder dem Dialog zum Lesen und Prfen einen 
Hinweis geben, um diese Sektoren als echte Lesefehler zu betrachten.<p>

Wenn Sie Datentrger mit nur einer Sitzung erzeugen, sollten Sie daher immer
im Modus "DAO / Disc at once" (manchmal auch "SAO / Session at once" genannt) brennen, 
um diese Probleme zu vermeiden. 
<div align=right><a href="#top">&uarr;</a></div>


<b><a name="block">3.2 Das Programm hngt nach dem Aufruf</a></b><p>
Unter alten Linux-Versionen (Kernel 2.4.x) bleibt das Programm 
manchmal nach dem Starten hngen, bevor es mit der ersten
Aktion beginnt. Es lt sich dann weder mit Strg-C noch mit "kill -9"
unterbrechen.<p>

Werfen Sie den Datentrger aus, damit sich das Programm beendet.
Legen Sie das Speichermedium dann wieder ein und warten Sie, 
bis das Laufwerk den Datentrger erkennt und zur Ruhe kommt.
Ein erneuter Aufruf von dvdisaster sollte jetzt funktionieren. 
<div align=right><a href="#top">&uarr;</a></div>


<b><a name="crc">3.3 Was bedeutet die Meldung "CRC error, sector: n"?</a></b><p>
Der betreffende Sektor konnte gelesen werden, aber die Prfsumme seines Inhalts
stimmt nicht mit ihrem Gegenstck in der Fehlerkorrekturdatei berein. 
Dies kann mehrere Ursachen haben:<p>
<ul>
<li>Das Datentrger-Abbild wurde mit Schreibrechten in das System eingebunden
und dadurch verndert (typisches Indiz: CRC-Fehler in Sektor 64 und in den Sektoren 200 bis 400).</li>
<li>Es gibt technische Probleme mit dem verwendeten Computersystem,
insbesondere bei der Kommunikation mit den Massenspeichern.</li>
</ul>

Falls Sie technische Probleme vermuten, erstellen  
Sie versuchsweise eine zweite Version des Abbildes und der Fehlerkorrekturdatei
und <a href="example50.html">vergleichen Sie die Dateien erneut</a>. 
Wenn der Fehler verschwindet oder an einer anderen Stelle auftritt,
hat Ihr Rechner mglicherweise ein Problem mit defektem Hauptspeicher, 
fehlerhafter Laufwerks-Verkabelung oder falsch
eingestellten Taktfrequenzen.
<div align=right><a href="#top">&uarr;</a></div>

<b><a name="plusrw">3.4 Lesefehler oder falsche Abbild-Gre bei -RW/+RW/-RAM-Datentrgern</a></b><p>

Einige Laufwerke liefern bei -RW/+RW/-RAM-Datentrgern fehlerhafte Informationen ber die
Abbild-Gre. Besonders hufig sind die folgenden beiden Flle:<p>

<table>
<tr><td valign="top">Fehler:</td>
<td>Das Laufwerk liefert den Umfang des grten jemals auf den Datentrger geschriebenen Abbildes 
anstelle der tatschlichen Abbild-Gre.
</td></tr>
<tr><td valign="top">Auswirkung:</td>
<td>Ein Datentrger wird gelscht und dann mit einer 100MB groen Datei beschrieben.
Beim Zurcklesen ist das Abbild aber einige GB gro und es enthlt
noch die Reste lterer Abbilder.
</td></tr>
<tr><td><pre> </pre></td><td></td></tr>
<tr><td valign="top">Fehler:</td>
<td>Das Laufwerk liefert die maximale Datentrger-Kapazitt (typischerweise 2295104 Sektoren)
anstelle der tatschlich genutzten Sektoren.
</td></tr>
<tr><td valign="top">Auswirkung:</td>
<td>Beim Einlesen des Abbilds treten ab einer bestimmten Stelle nur noch Lesefehler auf;
die Dateien auf dem Datentrger sind aber alle vollstndig.
</td></tr>
</table><p>

Mgliche Abhilfe: <p>

<table width=100%><tr><td bgcolor=#000000 width=2><img width=1 height=1 alt=""></td><td>
Verwenden Sie die Option zum Bestimmen der Abbildgre 
aus dem ISO/UDF- bzw. ECC/RS02 Dateisystem.
</td></tr></table><p>

Falls bei einem beschdigten Datentrgers die bentigten ISO/UDF-Sektoren 
auf dem Abbild unlesbar sind und eine Fehlerkorrektur-Datei verwendet wird, 
haben Sie zwei Mglichkeiten:

<ul>
<li>Fhren Sie die <a href="example50.html">"Vergleichen"</a>-Funktion nur mit der 
Fehlerkorrektur-Datei aus. Entnehmen Sie die korrekte Abbild-Gre der Ausgabe und 
schrnken Sie den Lesebereich entsprechend ein.
</li>
<li>Lesen Sie einfach das Abbild mit der zu groen Lnge ein. Wenn Sie nach dem Aufruf
der <a href="example40.html#repair">"Reparieren"</a>-Funktion gefragt werden, ob das Abbild
abgeschnitten werden soll, antworten Sie mit "OK".
</li>
</ul>

<div align=right><a href="#top">&uarr;</a></div>


<b><a name="dvdrom">3.5 Selbstgebrannter Datentrger wird als "DVD-ROM" erkannt und abgelehnt.</a></b><p>

Wahrscheinlich wurde der "book type" des Rohlings beim Brennen auf "DVD-ROM" gesetzt.
dvdisaster kann solche Datentrger typischerweise nur auf Laufwerken verarbeiten,
die das entsprechende Format auch schreiben knnen.<p>

Eine zweischichtige DVD+R mit falschem "book type" wird zum Beispiel nur auf einem 
Brenner angenommen, der auch solche Rohlinge schreiben kann.<p>

Versuchen Sie in diesen Fllen, das Abbild mit einem anderen Laufwerk einzulesen.

<div align=right><a href="#top">&uarr;</a></div>


<b><a name="freebsd">3.6 Unter FreeBSD erscheinen keine Laufwerke.</a></b><p>

<ul>
<li>Unter FreeBSD wird fr ATAPI-Laufwerke (das sind fast alle heute gebruchlichen Typen)
mglicherweise ein <a href="download20.html#freebsd">Neubersetzen des Kernels</a>
bentigt, um die Laufwerke mit dvdisaster verwenden zu knnen. 
<li>Sie mssen Lese- und Schreibrechte auf dem betreffenden Gert 
(z.B. /dev/pass0) haben.
</ul>

<div align=right><a href="#top">&uarr;</a></div>


<b><a name="v40error">3.7 "Fehlerkorrekturdatei wurde mit Version 0.40.7 erzeugt"</a></b><p>

Die <a href="http://sourceforge.net/cvs/?group_id=157550">CVS-Versionen</a> von 
dvdisaster markieren ihre Fehlerkorrektur-Dateien mit einem
speziellen Bit. Dies bewirkt in den dvdisaster-Versionen bis einschlielich
0.65 flschlicherweise die obige Fehlermeldung. Bitte verwenden Sie die CVS-Versionen
nur zusammen mit dvdisaster 0.66 oder neueren Versionen.

<div align=right><a href="#top">&uarr;</a></div>

EOF
}


# ----- Background information

function background_contents_de()
{  local file="$1.html"
   local query=$2
   local page=$3
   local lang=$4

   case $query in
   title)   title="Hintergrundinformationen" ;;
 
   link)    link_title="Hintergrundinformationen" ;;
   link10)   link_title="Eigenschaften der Fehlerkorrektur" ;;   
   link20)   link_title="Datenrekonstruktion auf Abbild-Ebene" ;;   
   link30)   link_title="RS01 und RS02" ;;   
   link40)   link_title="Lineares Lese-Verfahren" ;;   
   link50)   link_title="Angepates Lese-Verfahren" ;;   
   link60)   link_title="Bemerkungen zu Lesefehlern" ;;   
   link70)   link_title="Fehlerkorrektur-Datei aufbewahren" ;;
   link80)   link_title="Arbeitsweise der Fehlerkorrektur" ;;

   content*) eval "background$page$lang $file"
	    return 0
	    ;;
   esac 
}

function background0de()
{  cat >> $1 <<EOF

<h3>Hintergrundinformationen</h3>

Die Informationen in diesem Abschnitt werden nicht unbedingt fr die
Bedienung von dvdisaster bentigt. Sie sind aber hilfreich um zu verstehen
wie dvdisaster funktioniert und knnen Ihnen dabei helfen, das Programm
entsprechend Ihren Bedrfnissen anzuwenden.

<ol>
<li><a href="background10.html">Eigenschaften der Reed-Solomon-Fehlerkorrektur</a><p></li>
<li><a href="background20.html">Datenrekonstruktion auf Abbild-Ebene</a><p></li>
<li><a href="background30.html">Die RS01 und RS02-Verfahren</a><p></li>
<li><a href="background40.html">Arbeitsweise des linearen Lese-Verfahrens</a><p></li>   
<li><a href="background50.html">Arbeitsweise des angepaten Lese-Verfahrens</a><p></li>   
<li><a href="background60.html">Einige Bemerkungen zu Lesefehlern</a><p></li>   
<li><a href="background70.html">Tips zum Aufbewahren der Fehlerkorrektur-Datei</a><p></li>
</ol>

EOF
}


function background10de()
{  cat >> $1 <<EOF
<h3>Technische Eigenschaften der Fehlerkorrektur</h3>

Diese Seite skizziert die Grundideen hinter dvdisaster, damit Sie abschtzen knnen,
ob es Ihren Anforderungen zur Datensicherung gengt. Im Zweifelsfall sollten Sie
dvdisaster nicht einsetzen oder zustzliche Sicherungsstrategien anwenden.<p>

<b>Fehlerkorrektur-Verfahren.</b> &nbsp; dvdisaster verwendet einen 
<a href="http://en.wikipedia.org/wiki/Reed-Solomon_error_correction">Reed-Solomon</a>-Kode
mit einem auf die Behandlung von Auslschungen optimierten Fehlerkorrektur-Algorithmus.
Die Implementierung bezieht eine Menge Inspiration und Programmcode aus der
hervorragenden <a href="http://www.ka9q.net/code/fec/">Reed-Solomon-Bibliothek</a>
von <a href="http://www.ka9q.net/">Phil Karn</a>.

<p>

In der Grundeinstellung bilden
jeweils 223 Datentrger-Sektoren einen Fehlerkorrektur ("ECC") - Bereich.
Auf dem Datentrger auftretende Lesefehler werden als Auslschungen betrachtet,
so da pro ECC-Bereich bis zu 
32 defekte Sektoren<sup><a href="#footnote1">*)</a></sup> rekonstruierbar sind.<p>

Die 223 Sektoren werden so ausgewhlt, da sie sich gleichmig ber die gesamte
Datentrger-Oberflche verteilen. Dadurch knnen groe zusammenhngende Bereiche von defekten Sektoren 
korrigiert werden, bevor die kritische Anzahl von 
32 Defekten<sup><a href="#footnote1">*)</a></sup> pro ECC-Bereich erreicht wird. 
Dieses Fehlermuster ist besonders typisch fr alternde Datentrger, bei denen im Auenbereich gehuft 
Fehler auftreten, und fr Kratzer entlang der Datenspirale. <p>

Radiale oder diagonale Kratzer werden hingegen in der Regel schon im Laufwerk selbst korrigiert.
Fr diese Flle ist die verwendete Fehlerkorrektur weder besonders gut noch besonders schlecht geeignet.<p>

<b>Grenzen der Fehlerkorrektur.</b> &nbsp; Im schlechtesten Fall reichen schon 
33 defekte Sektoren<sup><a href="#footnote1">*)</a></sup> auf dem
Datentrger, um seine Wiederherstellung zu verhindern. Damit diese Wirkung eintritt, mssen die Fehler
wie ein Schrotschu ber den Datentrger verteilt sein und alle im gleichen ECC-Bereich liegen -
das ist eher unwahrscheinlich. <br>
Erfahrungstests haben ergeben, da bei normaler Alterung ca. 10% an Sektoren ausfallen knnen,
bevor die kritsche Anzahl von 33 Defekten pro ECC-Bereich<sup><a href="#footnote1">*)</a></sup>
erreicht wird.<br>
Bei <a href="index10.html">Kratzern</a> wird die Ausfallschwelle frher erreicht; deshalb empfiehlt sich eine stndige Sichtkontrolle
und ein sofortiges Umkopieren von Datentrgern, die durch Kratzer verursachte Lesefehler aufweisen. <p>

<b>Technische Einschrnkungen.</b> &nbsp; Viele Laufwerke erkennen den Datentrger nicht mehr, 
wenn die Einfhrungszone ("Lead in") vor dem ersten Sektor (nahe dem Innenloch) beschdigt ist.
In diesem Fall knnen Sie dvdisaster nicht mehr anwenden, um den Inhalt des Datentrgers zu retten. <p>

Es ist <i>nicht mglich</i>, die Qualitt <b>minderwertiger Datentrger</b> durch dvdisaster aufzuwerten.
Billige Rohlinge knnen bereits nach wenigen Tagen so stark verfallen, da die Kapazitt des
Fehlerkorrekturkodes berschritten wird. 

<pre> </pre>
<table width="50%"><tr><td><hr></td></tr></table>

<font size="-1">
<a name="footnote1"><sup>*)</sup></a> Die angegebene Grenze 
von 32 korrigierbaren Defekten pro ECC-Bereich ist die Grundeinstellung.
Sie knnen hier andere Werte einstellen
und so die Leistungfhigkeit der Fehlerkorrektur anpassen.
</font>
<p>
EOF
}

function background20de()
{  cat >> $1 <<EOF
<h3>Datenrekonstruktion auf Abbild-Ebene</h3>

Eine Datentrger-Rekonstruktion mit fehlerkorrigierenden Kodes findet in
zwei Schritten statt:

<ol>
<li>Zuerst wird versucht, mglichst viele Daten von dem Datentrger zu lesen.<p></li>
<li>Dann werden die noch fehlenden Daten durch den Fehlerkorrektur-Kode rekonstruiert.</li>
</ol>

Die Ausbeute an noch lesbaren Daten (Schritt 1) hngt nicht nur von dem
verwendeten Laufwerk ab, sondern auch davon, auf welcher logischen Ebene 
auf den Datentrger zugegriffen wird. Diese Seite erklrt die logischen Ebenen
und warum dvdisaster auf der Ebene von Abbildern arbeitet:<p>

<b>Logische Ebenen eines Datentrgers</b><p>

CD- und DVD-Datentrger sind in <i>Daten-Sektoren</i> von jeweils 2048 Bytes aufgeteilt.
Liest man diese Sektoren nacheinander aus und speichert sie ab, 
so erhlt man ein <i>Abbild</i> des Datentrgers.<p>

Das Arbeiten mit einzelnen Sektoren ist aus Benutzersicht sehr unhandlich. 
Deshalb werden Datentrger
mit einem <i>Dateisystem</i> versehen, das Daten-Sektoren zu <i>Dateien</i> 
zusammenfat. Dies erfordert eine genaue Buchfhrung darber, aus welchen
Daten-Sektoren die Dateien bestehen (sowie weitere Merkmale wie 
Dateinamen und Zugriffsrechte). Fr diese Buchfhrung
wird ein Teil der Daten-Sektoren reserviert und mit entsprechenden Datenstrukturen
gefllt.<p>

Datentrger lassen sich somit in verschiedene <i>logische Ebenen</i> einteilen: 
Betrachtet man den Inhalt eines Datentrgers als eine Folge von Daten-Sektoren,
so arbeitet man auf der <i>Abbild-Ebene</i>. Stellt man ihn sich hingegen als eine
Menge von Dateien vor, so befindet man sich auf der <i>Dateisystem-Ebene</i>.<p>

In Hinsicht auf die Daten-Rekonstruktion haben die beiden Ebenen unterschiedliche 
Eigenschaften:<p>


<a name="file"> </a>
<b>Probleme beim Lesen auf Dateisystem-Ebene</b><p>

Beim Lesen auf Dateisystem-Ebene wird versucht, die auf einem
defekten Datentrger enthaltenen Dateien einzeln soweit wie mglich auszulesen.<p>

Dabei entsteht ein Problem, wenn Daten-Sektoren beschdigt sind, 
die zur Buchfhrung im Dateisystem dienen. Dies kann bewirken, da die Liste
aller Dateien auf dem Datentrger unvollstndig ist. Oder die Zuordnung
von Daten-Sektoren zu Dateien ist nicht mehr vorhanden.
Dadurch gehen Dateien oder Teile davon verloren, 
selbst wenn die zugehrigen Daten-Sektoren 
noch technisch lesbar sind. Das ist schlecht, denn auch die noch lesbaren Anteile
von beschdigten Dateien sind fr den Fehlerkorrektur-Kode wichtig.<p>

Ein besonders schlechter Fall entsteht, wenn die Fehlerkorrektur-Daten auch 
in Dateien abgelegt sind. Dann werden die Fehlerkorrektur-Daten gebraucht, 
um das zugehrige Dateisystem zu reparieren, aber aufgrund des defekten 
Dateisystems ist kein Zugriff auf die Fehlerkorrektur-Daten mglich.
Das fhrt zum vollstndigen Datenverlust und hat auch Konsequenzen fr das 
<a href="#eccfile"> Aufheben von Fehlerkorrektur-Dateien</a> - dazu gleich mehr.
<p>

Mit einem Abbild-basierten Ansatz sieht die Situation hingegen besser aus:<p>

<a name="image"> </a>
<b>Vorteile beim Lesen auf Abbild-Ebene</b><p>

Beim Einlesen auf der Abbild-Ebene wird auf die Daten-Sektoren durch direkte Kommunikation
mit der Laufwerks-Hardware zugegriffen.<p>

Der Erfolg beim Einlesen von Daten-Sektoren hngt nur von den Lesefhigkeiten des
Laufwerks ab, nicht aber vom Zustand des Dateisystems. Lesefehler in einem Sektor
verhindern nicht den Zugriff auf andere Sektoren. Weil <i>alle</i> noch technisch 
lesbaren Daten gerettet werden knnen, liefert das Verfahren die gnstigste
Ausgangsbasis fr die Fehlerkorrektur.<p>

Das Abbild enthlt alle Daten-Sektoren des Datentrgers. Deshalb ist nach der 
Wiederherstellung des Abbilds auch das darauf gespeicherte Dateisystem 
wieder vollstndig. Ein Schutz des Datentrgers auf der Abbild-Ebene ist damit
umfassender als eine Fehlerkorrektur auf der Datei-Ebene.<p>

dvdisaster arbeitet ausschlielich auf der Abbild-Ebene, um von diesen Vorteilen
zu profitieren. Mit dem neuen <a href="background30.html">RS02-Verfahren</a>
ist sogar ein Ablegen der Fehlerkorrektur-Daten auf dem selben Datentrger 
mglich, weil das Auslesen der Fehlerkorrektur-Daten auf der Abbild-Ebene
nicht durch Fehler an anderen Stellen verhindert wird (beschdigte 
Sektoren mit Fehlerkorrektur-Daten verringern natrlich die Leistung der 
Fehlerkorrektur, machen sie aber nicht unmglich).<p>

Das <a href="background30.html">RS01-Verfahren</a> schtzt Datentrger ebenfalls
auf der Abbild-Ebene, legt die Fehlerkorrektur-Informationen aber in Dateien ab.
Auf mgliche Fallgruben in diesem Zusammenhang weist der nchste Abschnitt hin.<p>

<a name="eccfile"> </a>
<b>Konsequenzen fr das Aufbewahren von Fehlerkorrektur-Dateien</b><p>

Datentrger sind durch die mit dvdisaster erzeugten Fehlerkorrektur-Daten
auf Abbild-Ebene geschtzt. Aber was ist mit den Fehlerkorrektur-Dateien selbst?<p>

Da Fehlerkorrektur-Dateien auf Dateisystem-Ebene gelesen werden, unterliegen sie
den entsprechenden Einschrnkungen. Wenn der Datentrger mit den
Fehlerkorrektur-Dateien schadhaft wird, ist nicht mehr
sichergestellt, da sich die Fehlerkorrektur-Dateien noch vollstndig lesen
lassen.<p>

<table width=100%><tr><td bgcolor=#000000 width=2><img width=1 height=1 alt=""></td><td>
Deshalb ist es unverzichtbar, auch Fehlerkorrektur-Dateien auf der
Abbild-Ebene zu schtzen: Die 
<a href="background70.html">Datentrger mit Fehlerkorrektur-Dateien</a> 
mssen ebenfalls mit dvdisaster gesichert werden.
</td></tr></table><p>


Weil dies vorausgesetzt wird, enthalten die Fehlerkorrektur-Dateien <i>keinen</i> 
eigenen Schutz gegen Beschdigung! Dies wrde auch nicht viel nutzen:
Natrlich knnten die Fehlerkorrektur-Dateien so erweitert werden, 
da sie auch im beschdigten Zustand 
noch eine verminderte Fehlerkorrektur leisten. 
Aber egal wie ausgeklgelt  der innere Schutz-Mechanismus auch wre, 
es bliebe ein Schutz auf Dateisystem-Ebene mit den oben beschriebenen Nachteilen!<p>

Hinzu kommt, da die dafr bentigte Rechenzeit und Redundanz besser 
auf der Abbild-Ebene investiert sind: Die Reed-Solomon-Fehlerkorrektur profitiert davon,
wenn Fehlerkorrektur-Informationen ber groe Datenmengen verteilt werden. 
Das Abbild als Ganzes lt sich besser schtzen als die einzelnen 
Fehlerkorrektur-Dateien darin.
EOF
}

function background30de()
{  cat >> $1 <<EOF
<h3>bersicht ber die RS01- und RS02-Fehlerkorrektur-Verfahren</h3>

dvdisaster verfgt ber zwei Fehlerkorrektur-Verfahren RS01 und RS02.
RS01 ist das bisherige und erprobte Verfahren, whrend sich RS02 
gerade in Entwicklung befindet. RS02 ist momentan nur in der Kommandozeile
verfgbar und wird mit Version 0.70 vollstndig in die graphische 
Benutzeroberflche integriert.<p>

<b>Vergleich der beiden Verfahren.</b>

RS01 und RS02 setzen die gleiche 
<a href="background10.html">Reed-Solomon</a>-Fehlerkorrektur ein.
Sie berechnen Fehlerkorrektur-Informationen zu CD/DVD-Abbildern mit dem Ziel,
spter unlesbar gewordene Abbild-Sektoren aus diesen Informationen wiederherzustellen.<p>

Die Unterschiede liegen in der Art, wie die Fehlerkorrektur-Informationen abgelegt werden:<p>

<ul>
<li>
<a name="file"> </a>
RS01 erzeugt <b>Fehlerkorrektur-Dateien,</b> die unabhngig von dem
zugehrigen Abbild aufbewahrt werden. Da ein Schutz von Daten auf
<a href="background20.html#file">Datei-Ebene</a> schwierig ist, 
mssen Fehlerkorrektur-Dateien auf Datentrgern gespeichert werden,
die selbst mit dvdisaster gegen Datenverlust geschtzt sind.<p></li>

<li>
<a name="image"> </a>
Beim RS02-Verfahren wird zunchst ein Abbild der zu sichernden Daten 
auf der Festplatte mit Hilfe einer Brennsoftware erzeugt. Vor dem Schreiben auf
den Datentrger wird dieses <b>Abbild</b> jedoch mit dvdisaster um 
Fehlerkorrektur-Daten <b>erweitert</b>.
Dadurch befinden sich die zu schtzenden Daten zusammen mit den 
Fehlerkorrektur-Informationen auf dem selben Datentrger. 
Defekte Sektoren in den Fehlerkorrektur-Informationen verringern
die Kapazitt der Fehlerkorrektur, machen diese aber nicht unmglich - ein
zweiter Datentrger zum Aufbewahren oder Schtzen 
der Fehlerkorrektur-Informationen wird nicht bentigt.<p></li>
</ul>


<a name="table"> </a>
<b>Vergleich zum Ablegen der Fehlerkorrektur-Informationen</b><p>

<table width="100%" border="1" cellspacing="0" cellpadding="5">
<tr>
<td width="50%"><i>Fehlerkorrektur-Dateien</i></td>
<td width="50%"><i>Fehlerkorrektur-Daten im Abbild</i></td>
</tr>
<tr valign="top">
<td> Redundanz kann beliebig gro gewhlt werden</td>
<td> Redundanz ist durch freien Platz auf dem Datentrger beschrnkt<br>
(= Kapazitt des Datentrgers - Gre des ursprnglichen Abbildes)</td>
</tr>

<tr valign="top">
<td>bereits wirksam ab 15% Redundanz, weil die Fehlerkorrektur-Daten
nach Voraussetzung unbeschdigt vorliegen</td>
<td>bentigt mehr Redundanz (empfohlen: 20-30%), 
um Verluste von Fehlerkorrektur-Daten auszugleichen</td> 
</tr>

<tr valign="top">
<td>der Datentrger kann beliebig voll sein</td>
<td>die nutzbare Datentrger-Kapazitt sinkt entsprechend der erzielten Redundanz</td>
</tr>

<tr valign="top">
<td> knnen nachtrglich fr bereits existierende Datentrger
erzeugt werden</td>
<td> nur beim Brennen neuer Datentrger anwendbar, weil das Abbild vorher 
um Fehlerkorrektur-Daten erweitert werden mu</td>
</tr>

<tr valign="top">
<td> unabhngige Speicherung von den zu schtzenden Daten erhht Datensicherheit</td>
<td> gemeinsame Aufbewahrung von Nutzdaten und Fehlerkorrektur-Daten auf dem gleichen Datentrger vermindert die Fehlerkorrektur-Kapazitt</td>
</tr>

<tr valign="top">
<td>Zuordnung von Fehlerkorrektur-Dateien zu Datentrgern
mu geeignet realisiert werden. Fehlerkorrektur-Dateien mssen
vor Beschdigung geschtzt werden</td>
<td>Einfache Lsung mit einem Datentrger; Fehlerkorrektur-Informationen mssen nicht
katalogisiert oder geschtzt werden</td></tr>

<tr valign="top">
<td> keine Kompatibilittsprobleme beim Abspielen </td>
<td> um Fehlerkorrektur-Daten erweiterte Abbilder
 sind mglicherweise nicht berall abspielbar</td>
</tr>
</table><p>

EOF
}

function background40de()
{  cat >> $1 <<EOF
<h3><b>Das lineare Lese-Verfahren</b></h3>
<p>

In dvdisaster sind zwei verschiedene Leseverfahren enthalten.<p>

<b>Anwendungen fr das lineare Leseverfahren:</b><p>
<ul>
<li>Abbilder von unbeschdigten Datentrgern zum Erzeugen einer Fehlerkorrekturdatei einlesen</li>
<li>Lesegeschwindigkeitskurve zum Prfen des Datentrger-Zustandes ermitteln</li>
</ul>

<b>Anwendungen fr das <a href="background50.html">angepate Leseverfahren:</a></b><p>
<ul>
<li> Inhalt von beschdigten Datentrgern rekonstruieren
</li>
</ul>

<pre> </pre>

<b>Eigenschaften des linearen Verfahrens.</b><p>

 CD- und DVD-Datentrger 
sind in Sektoren aufgeteilt, die mit Null beginnend numeriert sind 
und jeweils 2048 Bytes an Daten enthalten.<p>

Das lineare Leseverfahren liest den Datentrger vom Anfang (Sektor 0)
bis zum Ende (letzter Sektor) ein. Die Lesegeschwindigkeit wird 
graphisch dargestellt, um die <a href="background40.html#quality">Qualitt des Datentrgers</a>
abschtzen zu knnen:<p>

<center><img src="images/bg-linear.png" alt="Bildschirmfoto"><br>
Bildschirmausschnitt: lineares Leseverfahren</center>

<pre> </pre>


<a name="configure"></a>
<b>Einstellmglichkeiten.</b><p>

<b>Anzahl der zu berspringenden Sektoren nach einem Lesefehler.</b>
Leseversuche von defekten Sektoren kosten viel Zeit und bewirken in ungnstigen Fllen
einen erhhten Verschlei des Laufwerks. Lesefehler treten aber typischerweise nicht einzeln,
sondern ber lngere Bereiche auf. Daher gibt es eine 
Einstellmglichkeit nach einem Lesefehler
eine Anzahl nachfolgender Sektoren zu berspringen. Diese Sektoren werden ohne weitere Leseversuche 
als defekt angenommen. Dies hat die folgenden Auswirkungen:<p>


<ul>
<li>Das berspringen einer groen Anzahl von Sektoren (z.B <b>1024</b>) ergibt eine schnelle
bersicht ber die Beschdigung des Datentrgers.<br>
Es liefert aber in der Regel nicht gengend Daten fr eine erfolgreiche Fehlerkorrektur.<p></li> 
<li>Kleinere Werte von <b>16, 32 oder 64</b> sind ein guter Kompromi zwischen verringerter 
Bearbeitungszeit und Wiederherstellbarkeit des Datentrger-Abbildes.<p></li>
</ul>

Auf DVD-Datentrgern erstrecken sich Lesefehler aus technischen Grnden meist ber
mindestens 16 Sektoren. Daher lohnt es sich fr DVD nicht, 
einen Wert kleiner als 16 einzustellen.
<p>

<a name="range"></a>
<b>Einschrnkung des Lesebereiches.</b>
Der Einlesevorgang kann 
auf einen Teil des Datentrgers eingeschrnkt werden.
Dies ist bei mehrfachen Einlese-Versuchen von beschdigten Datentrgern hilfreich.

<pre> </pre>

<a name="quality"></a>
<b>Abschtzung der Datentrger-Qualitt.</b><p>

<a name="error"></a>
<b>Die Geschwindigkeitskurve.</b>
Viele Laufwerke verringern ihre Lesegeschwindigkeit in Bereichen
des Datentrgers, die sich in einem schlechten Zustand befinden:
<ul>
<li>Einbrche in der Lesegeschwindigkeit knnen ein Warnzeichen fr ein
baldiges Versagen des Datentrgers darstellen.</li>
<li>
Es gibt aber auch Laufwerke, die "bis zum bitteren Ende" mit voller
Geschwindigkeit lesen. Man sich also nicht darauf verlassen,
da sich ein Versagen des Datentrgers durch Unterbrechungen in der 
Geschwindigkeitskurve ankndigt.
</li>
</ul><p>

Die Lesekurve ist bei der
<a href="example10.html"> "Prfen"</a>-Funktion am aussagekrftigsten.
In der 
<a href="example30.html"> "Lesen"</a>-Betriebsart
werden die gelesenen Daten gleichzeitig auf der
Festplatte abgelegt, was je nach Betriebssystem und verwendeter Hardware kleine
Verzgerungen und damit Unregelmigkeiten in der Lesekurve bewirkt.<p>

<b>Lesefehler.</b>
Lesefehler werden <a href="example1.html">rot in der Spirale markiert</a> bzw. 
<a href="example10.html#cli">in der Kommandozeile ausgegeben</a>.
An diesen Stellen konnte der Datentrger im momentanen Durchlauf nicht vollstndig gelesen werden:
<ul>
<li>Es ist damit wahrscheinlich, da der Datentrger defekt ist. </li>
<li>Das Abbild sollte jetzt schnellstmglich
<a href="example40.html"> rekonstruiert</a> und auf einen neuen Datentrger geschrieben werden.</li>
</ul>
EOF
}


function background50de()
{  cat >> $1 <<EOF
<h3>Das angepate Lese-Verfahren</h3>
<p>

dvdisaster enthlt zwei verschiedene Leseverfahren.<p>

<b>Anwendungen fr das angepate Leseverfahren:</b><p>
<ul>
<li> Inhalt von beschdigten Datentrgern rekonstruieren
</li>
</ul>

<b>Anwendungen fr das <a href="background40.html">lineare Leseverfahren:</a></b><p>
<ul>
<li>Abbilder von unbeschdigten Datentrgern zum Erzeugen einer Fehlerkorrekturdatei einlesen</li>
<li>Lesegeschwindigkeitskurve zum Prfen des Datentrger-Zustandes ermitteln</li>
</ul>

<pre> </pre>

<b>Eigenschaften des angepaten Verfahrens.</b><p>

Das angepate Verfahren setzt eine "Teile-und-Herrsche" ("divide-and-conquer") - Strategie ein,
um mglichst schnell die noch lesbaren Stellen eines beschdigten Datentrgers zu ermitteln 
und auszulesen.
Die Strategie geht auf einen Artikel von Harald Bgeholz im c't-Magazin 16/2005 
zurck, wo sie zusammen mit dem Programm <i>h2cdimage</i> verffentlicht wurde:

<ol>
<li> 
  Zu Anfang wird der Datentrger als ein einziger noch nicht gelesenener Bereich betrachtet. 
Das Lesen beginnt mit Sektor Null.<p>
</li>
<li>
Der Lesevorgang wird solange linear fortgesetzt,
bis entweder das Ende des momentanen Bereiches erreicht ist oder ein Lesefehler auftritt.<p>
</li>
<li>
Der Lesevorgang wird entweder beendet, wenn (3a) gengend Sektoren fr eine Fehlerkorrektur 
gelesen wurden oder (3b) keine unlesbaren Bereiche oberhalb einer bestimmten Gre 
mehr vorhanden sind.
<p>
</li>
<li>Anderenfalls wird der grte noch nicht gelesene Bereich auf dem Datentrger bestimmt
und in der Mitte aufgeteilt. Der Lesevorgang wird in der Mitte wie in Schritt 2 fortgesetzt.
Die erste Hlfte des aufgeteilten Bereiches verbleibt hingegen als noch nicht gelesenener Bereich
fr einen spteren Durchlauf.<p>
</li>
</ol>

Das Abbruchkriterium (3a) ist besonders wirkungsvoll: Es beendet das Einlesen sofort,
wenn die absolut notwendigen Sektoren zur Wiederherstellung des Abbildes mit Hilfe 
der Fehlerkorrektur gelesen worden sind.
Dies kann die Bearbeitungszeit  gegenber einem vollstndigen Einlese-Versuch um bis zu 90% verkrzen,
erfordert aber natrlich, da man die zugehrige Fehlerkorrektur-Datei zur Hand hat.<p>

<center><img src="images/bg-adaptive.png" alt="Bildschirmfoto"><br>
Bildschirmausschnitt: angepates Leseverfahren</center>

<pre> </pre>

<a name="configure"></a>
<b>Einstellmglichkeiten</b><p>

<b>Fehlerkorrekturdatei.</b> Angepates Lesen funktioniert am besten, wenn die zum Abbild gehrende
Fehlerkorrektur-Datei vorhanden ist. Das setzt natrlich voraus, da man diese Datei
zu einem Zeitpunkt <a href="example20.html">erzeugt</a> hat, 
als der Datentrger noch vollstndig lesbar war.

Um die Fehlerkorrektur-Datei zu nutzen, mu sie vor Beginn des Lesens 
<a href="example30.html">ausgewhlt</a> werden.<p>

<b>Einschrnkung des adaptiven Lesebereiches.</b> Der Einlesevorgang 
kann auf einen Teil des Datentrgers eingeschrnkt werden. 

Bei der Verwendung einer Fehlerkorrektur-Datei ist das Einschrnken 
des Lesebereichs nicht sinnvoll, da es gegebenenfalls das Einlesen von Sektoren
verhindert, die zur Fehlerkorrektur bentigt werden.
Ohne Fehlerkorrektur-Datei kann es hingegen bei mehrfachen Einlese-Versuchen 
von beschdigten Datentrgern hilfreich sein.<p>

<b>Lesen vorzeitig beenden.</b>Wenn keine Fehlerkorrektur-Datei vorhanden ist, wird der Lesevorgang beendet, sobald keine
unlesbaren Bereiche oberhalb 
einer bestimmten Gre mehr vorhanden sind.<p>

Der Wert zum Beenden sollte nicht kleiner als 128 eingestellt werden.
Anderenfalls werden in der Schluphase des Einlesens sehr viele Neupositionierungen des
Laserschlittens im Laufwerk durchgefhrt. Darunter leidet sowohl die Lebensdauer als auch die
Lesefhigkeit des Laufwerks. Gnstiger ist es typischerweise, frher mit den adaptiven
Lesen aufzuhren und die letzten Sektoren mit dem <a href="background40.html">linearen Leseverfahren</a>
zu vervollstndigen.
EOF
}


function background60de()
{  cat >> $1 <<EOF
<h3>Ein paar Hintergrnde zu Lesefehlern</h3>

DVDs verfgen ber einen eigenen Fehlerkorrektur-Kode, der kleinere
Material- und Brennfehler ausgleicht und so die gespeicherten Daten
schtzt. Wenn der Brenner und die Rohlinge kompatibel und 
von hoher Qualitt sind, ist die eingebaute Fehlerkorrektur 
direkt nach dem Brennen nur schwach ausgelastet. Sie verfgt dann
ber gengend Kapazitt, um die whrend der Benutzung des Datentrgers
auftretenden Verschlei- und Alterungserscheinungen fr viele Jahre
auszugleichen.<p>

Erst wenn die Reserven der eingebauten Fehlerkorrektur erschpft sind,
entstehen Lesefehler, die Sie in dvdisaster mit 
der <a href="example10.html">"Prfen"</a>-Funktion feststellen knnen.
Dabei ist die folgende Unterscheidung wichtig:<p>


<b>Lesefehler direkt nach dem Brennen.</b> <br>Wenn unlesbare Sektoren
direkt nach dem Brennen auftreten, ist das ein Hinweis auf

<ul>
<li>Produktionsfehler bei den Rohlingen, oder</li>
<li>Rohlinge, die nicht mit dem Brenner kompatibel sind</li>
</ul>

In diesem Fall hilft nur ein Entsorgen der defekten Rohlinge und ein
erneutes Brennen auf einwandfreie Ware, gegebenenfalls verbunden mit
einem Herstellerwechsel.<p>

Der Versuch, derartige Fehlbrnde mit Hilfe einer Fehlerkorrekturdatei
am Leben zu erhalten, endet hingegen ziemlich sicher mit einem Datenverlust.<p>

<b>Lesefehler nach einigen Monaten/Jahren.</b> Die eingebaute Fehlerkorrektur des
Datentrgers wird mit zunehmender Lebensdauer immer strker belastet, 
bis schlielich Lesefehler entstehen.
Dies hat sowohl mechanische Ursachen (Kratzer, Verziehen des Materials) als
auch chemische Hintergrnde (Zerfall des Farbstoffes und/oder der Spiegelschicht).<p>

Typischerweise treten diese Effekte auf, whrend der Datentrger fr einige 
Monate gelagert wird, und es ist danach auch mit den unten beschriebenen Tips
nicht mehr mglich, den Datentrger wieder komplett einzulesen. <p>

Deshalb ist es wichtig, rechtzeitig mit dvdisaster die zugehrigen
<a href="example20.html">Fehlerkorrektur-Daten</a> zu erzeugen, weil
dadurch innerhalb <a href="background10.html">bestimmter Grenzen</a> 
der Inhalt von Sektoren berechnet (= wiederhergestellt) werden kann,
die von keinem Laufwerk mehr gelesen werden knnen.<p>

Dabei braucht man den Datentrger typischerweise nicht bis auf den letzten
lesbaren Sektor "auszuquetschen": 
Das <a href="background50.html">angepate Leseverfahren</a>
von dvdisaster berprft beim Lesen stndig, ob gengend Daten fr
die Fehlerkorrektur zur Verfgung stehen. Sobald dies der Fall ist,
wird der Lesevorgang beendet und die bis dahin noch nicht gelesenen
Sektoren werden aus der Fehlerkorrektur-Datei wiederhergestellt.<p>

<a name="reading-tips"><b>Einige Tips zum effektiven Auslesen beschdigter Datentrger</b></a><p>

Die "Ausbeute" beim Lesen beschdigter Datentrger hngt von mehreren Umstnden ab:

<ul>
<li><b>Nicht alle Laufwerke sind gleich gebaut.</b><br>
Verschiedene Laufwerke haben auch verschieden gute Lesefhigkeiten. 
Nutzen Sie die Mglichkeit von dvdisaster, ein Abbild mit mehreren Lesevorgngen
zu vervollstndigen, und setzen Sie dabei verschiedene Laufwerke ein. 
bertragen Sie die Abbild-Datei mit Hilfe eines Netzwerks oder mit RW-Datentrgern,
um Laufwerke in verschiedenen Rechnern einsetzen zu knnen.<p></li>
<li><b>Auswerfen und wieder einlegen.</b><br>
Ab und zu hilft es, den Datentrger auszuwerfen, 
um ein Viertel zu drehen und dann einen neuen Leseversuch zu starten.<p></li>
<li><b>Kalte Laufwerke lesen besser.</b><br>
Einige Laufwerke haben im kalten Zustand bessere Leseeigenschaften.
Schalten Sie den Rechner ber Nacht aus und versuchen Sie es am nchsten Morgen noch mal.<p>
"Kalt" heit brigens Raumtemperatur - Ein Aufenthalt im Khlschrank ist fr 
Hardware und Datentrger ziemlich ungesund.<p></li>
</ul>
EOF
}


function background70de()
{  cat >> $1 <<EOF
<h3>Tips zum Aufbewahren der Fehlerkorrektur-Datei</h3>

Zur Zeit gibt es kaum Wechselspeichersysteme, 
die eine wirtschaftliche Alternative zu CD/DVD-Formaten darstellen.
Vermutlich werden Sie daher Ihre Fehlerkorrektur-Dateien auch auf CD/DVD
speichern. <p>


Dagegen ist nichts einzuwenden, aber Sie mssen sich dabei bewut sein,
da sich Ihre Nutzdaten und die Fehlerkorrektur-Dateien auf 
Speichermedien mit hnlicher Verllichkeit befinden.
Wenn Lesefehler
auf einem zu rekonstruierenden Datentrger auftreten, so mssen Sie damit rechnen,
da die zur gleichen Zeit erstellte Scheibe mit den Fehlerkorrektur-Daten
ebenfalls nicht mehr vollstndig lesbar ist.<p>

Deshalb ist es wichtig, die Fehlerkorrektur-Dateien
genauso wie die brigen Daten zu schtzen. Am einfachsten geht dies, wenn Sie die
Fehlerkorrektur-Dateien in Ihre normale Datensicherung mit einbeziehen. 
Dazu zwei Anregungen:<p>

<b>1. Fehlerkorrektur-Dateien auf eigenen Datentrgern sammeln:</b><p>

Wenn Sie Fehlerkorrektur-Dateien auf extra dafr vorgesehenen Datentrgern speichern,
ist es <a href="background20.html#eccfile">wichtig</a>, diese Datentrger ebenfalls
mit dvdisaster zu schtzen. Um zu verhindern, da man eine endlose Kette 
(Fehlerkorrektur-Dateien ber Fehlerkorrektur-Dateien ber ...) erhlt, 
hilft folgender Kniff:<p>

Angenommen, Sie knnen jeweils 5 Fehlerkorrektur-Dateien pro Datentrger speichern.
Legen Sie die ersten fnf Fehlerkorrektur-Dateien auf dem ersten Datentrger ab
und erzeugen Sie dann eine weitere Fehlerkorrektur-Datei fr diesen Datentrger.
Speichern Sie die neu erzeugte Fehlerkorrektur-Datei zusammen mit vier weiteren auf dem
zweiten Datentrger. Wenn Sie so weitermachen, sind stets alle Fehlerkorrekur-Dateien
bis auf diejenigen vom letzten Datentrger mit dvdisaster gesichert.<p>

<b>2. Fehlerkorrektur-Dateien jeweils auf dem nchsten Datentrger speichern:</b><p>

Wenn Sie Ihre DVDs nicht randvoll mit Nutzdaten (also mit weniger als 4GB) beschreiben,
knnen Sie die Fehlerkorrektur-Dateien innerhalb einer Serie von DVDs jeweils
auf dem nchsten Datentrger ablegen.<p>

EOF
}

# ----- Impressum

function imprint_contents_de()
{  local file="$1.html"
   local query=$2
   local page=$3
   local lang=$4

   case $query in
   title)   title="Impressum" ;;
 
   link)    link_title="Impressum" ;;

   content*) eval "imprint$page$lang $file"
	    return 0
	    ;;
   esac 
}

function imprint0de()
{  cat >> $1 <<EOF

   <h3>Impressum</h3>

   Carsten Gnrlich <br>
   Beerenkamp 23 <br>
   59514 Welver / Deutschland<br>
   Tel.: +49 2384 941174<pre> </pre>
   E-Mail: carsten@dvdisaster.de<br>
   Internet: www.dvdisaster.de

   <pre> </pre>

   Inhaltlich Verantwortlicher: <p>
   Carsten Gnrlich (Anschrift wie oben).

   <pre> </pre>

   Das Impressum gilt fr die Internetprsenz unter den Adressen<br>
   <a href="http://www.dvdisaster.com">www.dvdisaster.com</a>, &nbsp;
   <a href="http://www.dvdisaster.de">www.dvdisaster.de</a>, &nbsp;
   <a href="http://www.dvdisaster.org">www.dvdisaster.org</a><br>
   und unter den Unterdomnen 
   <a href="http://dvdisaster.berlios.de">dvdisaster.berlios.de</a> und
   <a href="http://dvdisaster.sourceforge.net">dvdisaster.sourceforge.net</a>.

EOF
}

