#Edited by Dan:
#Now takes raw encoding as arguments for Set/Get EncodedText.
#Also removed some uneeded code.

#***************************************************************************
#drDetectUTF_8
#	Programmer:	limodou
#	E-mail:		limodou@users.sourceforge.net
#
#	Copyright 2004 limodou
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#	DrPython is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

def utf8Detect(text):
	"""Detect if a string is utf-8 encoding"""
	lastch=0
	begin=0
	BOM=True
	BOMchs=(0xEF, 0xBB, 0xBF)
	good=0
	bad=0
	for char in text:
		ch=ord(char)
		if begin<3:
			BOM=(BOMchs[begin]==ch) and BOM
			begin += 1
			continue
		if (begin==4) and (BOM==True):
			break;
		if (ch & 0xC0) == 0x80:
			if (lastch & 0xC0) == 0xC0:
				good += 1
			elif (lastch &0x80) == 0:
				bad += 1
		elif (lastch & 0xC0) == 0xC0:
			bad += 1
		
		lastch = ch

	#modi limodou 2004/04/16
	#if all characters are ascii, its encoding also can be ascii encoding or default encoding
	#in most cases, I think it's better that not recognizing it as utf-8 encoding
	if (((begin == 4) and (BOM == True)) or
		(good >= bad and good>0)):
		return True
	else:
		return False

#/drDetectUTF_8
#***************************************************************************

#Edited by Dan for 3.6.2
#SetText function limodou 2004/04/16
#Edited a tad by Dan 2004/04/13
#if encoding is None, then use default encoding
#only support specified encoding or default encoding
#should support utf-8 encoding auto detect
def SetEncodedText(frame, txtctrl, text, encoding):
	isUnicode=txtctrl.GetCodePage()!=0
	if isUnicode:
		try:
			sText=unicode(text, 'utf-8')
		except:
			frame.ShowMessage(("Error Encoding utf-8\n"), "DrPython Error")
			sText=text
	else:
		#Bug report John Bell
		try:
			#utf-8 auto detect limodou 2004/04/14
			sText=unicode(text, encoding).encode(encoding)	#convert utf-8 encoding to default encoding
			#set utf-8 encoding in preference
		except:
			#Do Nothing
			sText = text

	txtctrl.SetText(sText)
#end limodou

#Edited by Dan for 3.6.2
#GetText function limodou 2004/04/16
#if encoding is None, then use txtctrl.locale
#most of the time should be encodingid when save a file
def GetEncodedText(txtctrl, encoding):
	isUnicode=txtctrl.GetCodePage()!=0
	text=txtctrl.GetText()
	try:
		if isUnicode:
			sText=text.encode('utf-8')
		else:
			sText=unicode(text, encoding).encode(encoding)
	except:
		sText=text

	return sText
#end limodou