#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#	DrPython is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#drScript Dialog

import os.path
import wx
import drScrolledMessageDialog
from drProperty import *
from drPrefsFile import ExtractPreferenceFromText
import drShortcutsFile

class drTreeItemData(wx.TreeItemData):
	def __init__(self, Line, Shortcut, Keycode):
		wx.TreeItemData.__init__(self)
		self.Line = Line
		self.Shortcut = Shortcut
		self.Keycode = Keycode
	
def BuildTreeFromString(dialog, tree, branch, thestring):
	line = " "
	roots = [branch]
	rootindex = 0
	#Shortcuts
	Shortcuts = []
	Keycodes = []
	ShortcutIndex = 0
	map(Shortcuts.append, dialog.parent.DrScriptShortcuts[dialog.parent.drscriptmenu.ExampleScriptCount:])
	map(Keycodes.append, dialog.parent.DrScriptKeycodeArray[dialog.parent.drscriptmenu.ExampleScriptCount:])	
	lastCount = 0
	i = 0
	lastI = 0
	while (len(line) > 0):
		i = thestring.find('\n')
		if (i > -1):
			line = thestring[0:(i + 1)]
			lastI = i + 1
			thestring = thestring[lastI:]
			c = line.count('\t')
			line = line[c:].rstrip()
			while (lastCount > c):
				roots.pop()
				rootindex = rootindex - 1
				lastCount = lastCount - 1
			if line.find("title") > -1:
				line_title = ExtractPreferenceFromText(line, "title")	
				currentItem = tree.AppendItem(roots[rootindex], line_title)			
				tree.SetPyData(currentItem, drTreeItemData(line, Shortcuts[ShortcutIndex], Keycodes[ShortcutIndex]))
				ShortcutIndex = ShortcutIndex + 1
				tree.SetItemImage(currentItem, 2, wx.TreeItemIcon_Normal)
				tree.SetItemImage(currentItem, 2, wx.TreeItemIcon_Selected)
			elif (line[0] == '>'):
				currentItem = tree.AppendItem(roots[rootindex], line)
				tree.SetPyData(currentItem, drTreeItemData(line, None, None))
				tree.SetItemImage(currentItem, 0, wx.TreeItemIcon_Normal)
				tree.SetItemImage(currentItem, 1, wx.TreeItemIcon_Expanded)
				roots.append(currentItem)
				rootindex = rootindex + 1
				lastCount = c + 1
		else:
			line = ""

def CheckBranch(tree, branch):
	t = tree.GetItemText(branch)
	if (t[0] == '>'):
		ccount = tree.GetChildrenCount(branch, 0)
		if (ccount < 1):
			tree.SetBadBranch(branch)
			return 0
		else:
			if (wx.MAJOR_VERSION >= 2) and (wx.MINOR_VERSION >= 5):
				b, cookie = tree.GetFirstChild(branch)
			else:
				b, cookie = tree.GetFirstChild(branch, 1)
			rvalue = CheckBranch(tree, b)
			x = 1
			while (x < ccount):
				b, cookie = tree.GetNextChild(branch, cookie)
				rvalue = rvalue and CheckBranch(tree, b)
				x = x + 1
			return rvalue
	return 1

def CreateBranchString(tree, branch, tablevel):	
	t = tree.GetItemText(branch)
	x = 0
	y = ""
	while (x < tablevel):
		y = y + '\t'
		x = x + 1
	y = y + t + "\n"
	s = y
	if (t[0] == '>'):
		ccount = tree.GetChildrenCount(branch, 0)
		if (ccount > 0):
			if (wx.MAJOR_VERSION >= 2) and (wx.MINOR_VERSION >= 5):
				b, cookie = tree.GetFirstChild(branch)
			else:
				b, cookie = tree.GetFirstChild(branch, 1)
			s = s + CreateBranchString(tree, b, (tablevel + 1))
			x = 1
			while (x < ccount):
				b, cookie = tree.GetNextChild(branch, cookie)
				s = s + CreateBranchString(tree, b, (tablevel + 1))
				x = x + 1
	return s

def GetShortcutArrays(tree, branch):
	Shortcuts = []
	Keycodes = []
	t = tree.GetItemText(branch)
	if not (t[0] == '>'):
		data = tree.GetPyData(branch)
		if data.Shortcut is not None:
			#Make sure the name is updated if there was a rename.
			data.Shortcut.Name = t
			Shortcuts.append(data.Shortcut)
			Keycodes.append(data.Keycode)		
	else:
		ccount = tree.GetChildrenCount(branch, 0)
		if (ccount > 0):
			if (wx.MAJOR_VERSION >= 2) and (wx.MINOR_VERSION >= 5):
				b, cookie = tree.GetFirstChild(branch)
			else:
				b, cookie = tree.GetFirstChild(branch, 1)
			s, k = GetShortcutArrays(tree, b)
			Shortcuts.extend(s)
			Keycodes.extend(k)
			x = 1
			while (x < ccount):
				b, cookie = tree.GetNextChild(branch, cookie)
				s, k = GetShortcutArrays(tree, b)
				Shortcuts.extend(s)
				Keycodes.extend(k)				
				x = x + 1
				
	return Shortcuts, Keycodes
	
def WriteBranch(tree, branch, filehandle, tablevel):
	t = tree.GetItemText(branch)
	if tablevel > -1:
		data = tree.GetPyData(branch)
		if data is not None:
			x = 0
			y = ""
			while (x < tablevel):
				y = y + '\t'
				x = x + 1
			title = ExtractPreferenceFromText(data.Line, "title")
			if len(title) > 0:
				if not (title == t):
					data.Line = data.Line[:data.Line.find("<title>")] + "<title>" + t  + "</title>"
			y = y + data.Line + "\n"
			filehandle.write(y)
		else:
			print "Error at:", t
	if (t[0] == '>'):
		ccount = tree.GetChildrenCount(branch, 0)
		if (ccount > 0):
			if (wx.MAJOR_VERSION >= 2) and (wx.MINOR_VERSION >= 5):
				b, cookie = tree.GetFirstChild(branch)
			else:
				b, cookie = tree.GetFirstChild(branch, 1)
			WriteBranch(tree, b, filehandle, (tablevel + 1))
			x = 1
			while (x < ccount):
				b, cookie = tree.GetNextChild(branch, cookie)
				WriteBranch(tree, b, filehandle, (tablevel + 1))
				x = x + 1	

class drTree(wx.TreeCtrl):
	def __init__(self, parent, id, point, size, style):
		wx.TreeCtrl.__init__(self, parent, id, point, size, style)
		
		self.grandparent = self.GetGrandParent()
		style = self.grandparent.prefs.drscriptstyle
		yarrr = convertStyleStringToWXFontArray(style)
		
		self.parent = parent
		
		imagesize = (16,16)
		
		self.imagelist = wx.ImageList(imagesize[0], imagesize[1])
		self.images = [wx.BitmapFromImage(wx.Image(self.grandparent.bitmapdirectory + "/16/folder.png", wx.BITMAP_TYPE_PNG)), \
		wx.BitmapFromImage(wx.Image(self.grandparent.bitmapdirectory + "/16/folder open.png", wx.BITMAP_TYPE_PNG)), \
		wx.BitmapFromImage(wx.Image(self.grandparent.bitmapdirectory + "/16/drscript.png", wx.BITMAP_TYPE_PNG))]
				
		map(self.imagelist.Add, self.images)
		
		self.SetImageList(self.imagelist)
		
		w = wx.Font(yarrr[1], wx.NORMAL, wx.NORMAL, wx.NORMAL, yarrr[2])
		
		w.SetFaceName(yarrr[0])
		
		if (yarrr[3]):
			w.SetWeight(wx.BOLD)
		else:
			w.SetWeight(wx.NORMAL)
		if (yarrr[4]):
			w.SetStyle(wx.ITALIC)
		else:
			w.SetStyle(wx.NORMAL)
		
		self.SetFont(w)
					
		f = convertColorPropertyToColorArray(getStyleProperty("fore", style))
		b = convertColorPropertyToColorArray(getStyleProperty("back", style))
				
		self.TextColor = wx.Colour(f[0], f[1], f[2])
		
		self.SetForegroundColour(self.TextColor)
							
		self.badbranch = 0
		self.dragging = 0
		self.draggingId = self.GetRootItem()
		self.dragString = ""
		
		self.SetBackgroundColour(wx.Colour(b[0], b[1], b[2]))

		self.edittext = ""

		self.Bind(wx.EVT_TREE_BEGIN_DRAG,  self.OnBeginDrag, id=id)
		self.Bind(wx.EVT_TREE_ITEM_ACTIVATED,  self.OnItemActivated, id=id)
		self.Bind(wx.EVT_LEFT_UP, self.OnLeftUp)
		self.Bind(wx.EVT_MOTION, self.OnMotion)
		self.Bind(wx.EVT_TREE_END_LABEL_EDIT, self.OnLabelEdited)
		self.Bind(wx.EVT_LEFT_DOWN, self.OnLabelEdited)
	
	def GetBadBranch(self):
		return self.badbranch		
				
	def OnBeginDrag(self, event):				
		self.draggingId = self.GetSelection()
		if (self.draggingId == self.GetRootItem()) or (not self.draggingId.IsOk()):
			return
				
		t = self.GetItemText(self.draggingId)
		if (t[0] == '>'):
			self.dragString = CreateBranchString(self, self.draggingId, 0)
		
		self.SetCursor(wx.StockCursor(wx.CURSOR_HAND))
		self.dragging = 1
					
	def OnItemActivated(self, event):
		sel = self.GetSelection()
		if (not sel.IsOk()):
			return
		self.edittext = self.GetItemText(sel)
		self.EditLabel(sel)
	
	def OnLabelEdited(self, event):
		if len(self.edittext) > 0:
			if self.edittext[0] == '>':
				sel = self.GetSelection()
				text = self.GetItemText(sel)
				if not text[0] == '>':
					self.SetItemText(sel, '>' + text)
		event.Skip()
		
	def OnLeftUp(self, event):
		self.SetCursor(wx.STANDARD_CURSOR)
		if (self.dragging):
			self.dragging = 0
			item, flags = self.HitTest(event.GetPosition())
			if (item.IsOk()):
				if (item == self.draggingId):
					return
				t = self.GetItemText(item)
				olditem = self.GetItemParent(item)
				if not (t[0] == '>'):
					olditem = item
					item = self.GetItemParent(item)				
				icon = [wx.TreeItemIcon_Normal, wx.TreeItemIcon_Selected]
				iconNum = [2, 2]
				if len(self.dragString) > 0:
					if self.dragString[0] == '>':
						icon = [wx.TreeItemIcon_Normal, wx.TreeItemIcon_Expanded]
						iconNum = [0, 1]
						
				olddata = self.GetPyData(self.draggingId)
				
				if t[0] == '>':
					newbranch = self.InsertItemBefore(item, 0, self.GetItemText(self.draggingId))
				else:
					newbranch = self.InsertItem(item, olditem, self.GetItemText(self.draggingId))			
				
				self.SetPyData(newbranch, olddata)
				
				self.SetItemImage(newbranch, iconNum[0], icon[0])
				self.SetItemImage(newbranch, iconNum[1], icon[1])	
				if len(self.dragString) > 0:
					BuildTreeFromString(self.parent, self, newbranch, self.dragString)
				self.Delete(self.draggingId)
				self.SelectItem(newbranch)
			self.dragString = ""
				
	def OnMotion(self, event):
		if (self.dragging):		
			sel, flags = self.HitTest(event.GetPosition())			
			if (sel.IsOk()):
				self.SelectItem(sel)						
		event.Skip()
		
	def SetBadBranch(self, branch):
		self.badbranch = branch	

class drScriptDialog(wx.Dialog):
	def __init__(self, parent):
		wx.Dialog.__init__(self, parent, -1, ("Edit Script Menu"), wx.Point(50, 50), wx.Size(-1, -1), wx.DEFAULT_DIALOG_STYLE | wx.MAXIMIZE_BOX | wx.THICK_FRAME | wx.RESIZE_BORDER)
		
		self.ID_ADD_FOLDER = 1002
		self.ID_REMOVE = 1003
		self.ID_SAVE = 1005
				
		self.theSizer = wx.BoxSizer(wx.VERTICAL)
		
		self.cmdSizer = wx.BoxSizer(wx.HORIZONTAL)
		
		self.homedirectory = parent.homedirectory
		self.drscriptsfile = parent.homedirectory + "/drscript.dat"
		
		self.btnAddFolder = wx.Button(self, self.ID_ADD_FOLDER, "Add &Folder")
		self.btnRemove = wx.Button(self, self.ID_REMOVE, "&Remove")
		self.btnSave = wx.Button(self, self.ID_SAVE, "&Save")
		
		self.cmdSizer.Add(self.btnAddFolder, 0, wx.SHAPED)
		self.cmdSizer.Add(self.btnRemove, 0, wx.SHAPED)
		self.cmdSizer.Add(self.btnSave, 0, wx.SHAPED)

		self.theSizer.Add(self.cmdSizer, 0, wx.SHAPED | wx.ALIGN_CENTER)
		
		self.parent = parent
		
		self.drscriptstree = drTree(self, -1, wx.Point(0, 0), wx.Size(400, 200), wx.TR_DEFAULT_STYLE | wx.TR_EDIT_LABELS)
		self.theSizer.Add(self.drscriptstree, 9, wx.EXPAND)
	
		root = self.drscriptstree.AddRoot(">DrScript Menu")

		self.drscriptstree.SetItemImage(root, 0, wx.TreeItemIcon_Normal)
		self.drscriptstree.SetItemImage(root, 1, wx.TreeItemIcon_Expanded)
		
		self.btnClose = wx.Button(self, 101, "&Close")
		self.theSizer.Add(wx.StaticText(self, -1, ""), 0, wx.ALIGN_CENTER | wx.SHAPED)
		self.theSizer.Add(self.btnClose, 0, wx.SHAPED | wx.ALIGN_CENTER)
		self.btnClose.SetDefault()
		
		self.SetAutoLayout(True)
		self.SetSizerAndFit(self.theSizer)
		
		self.initialize()
		
		self.drscriptstree.Expand(root)
		
		self.Bind(wx.EVT_BUTTON,  self.OnbtnAddFolder, id=self.ID_ADD_FOLDER)
		self.Bind(wx.EVT_BUTTON,  self.OnbtnRemove, id=self.ID_REMOVE)
		self.Bind(wx.EVT_BUTTON,  self.OnbtnSave, id=self.ID_SAVE)
		self.Bind(wx.EVT_BUTTON,  self.OnbtnClose, id=101)

		self.parent.LoadDialogSizeAndPosition(self, 'drscriptdialog.sizeandposition.dat')

	def OnCloseW(self, event):
		self.parent.SaveDialogSizeAndPosition(self, 'drscriptdialog.sizeandposition.dat')
		if event is not None:
			event.Skip()				
				
	def initialize(self):
		if (os.path.exists(self.drscriptsfile)):
			try:
				f = open(self.drscriptsfile, 'r')
				text = f.read()
				if len(text) > 0:
					BuildTreeFromString(self, self.drscriptstree, self.drscriptstree.GetRootItem(), text)
				f.close()
			except:
				drScrolledMessageDialog.ShowMessage(self.parent, ("Your drscripts file is a tad messed up.\n"), "Error")
				
	def OnbtnAddFolder(self, event):
		sel = self.drscriptstree.GetSelection()
		if (not sel.IsOk()):
			if self.drscriptstree.GetCount() < 2:
				sel = self.drscriptstree.GetRootItem()
			else:
				return
		if (self.drscriptstree.GetItemText(sel)[0] == '>'):
			d = wx.TextEntryDialog(self, 'Enter Bookmark Folder:', 'Add Bookmark Folder', '')
			if (d.ShowModal() == wx.ID_OK):
				v = d.GetValue()
				sel = self.drscriptstree.GetSelection()
				item = self.drscriptstree.AppendItem(sel, ">" + v)
				self.drscriptstree.SetPyData(item, drTreeItemData(">" + v, None, None))
				self.drscriptstree.SetItemImage(item, 0, wx.TreeItemIcon_Normal)
				self.drscriptstree.SetItemImage(item, 1, wx.TreeItemIcon_Expanded)
			d.Destroy()
		else:
			drScrolledMessageDialog.ShowMessage(self, "You can only add a folder to another folder.\nSelect either \"Bookmarks\", or a folder.", "Bad Bookmark Folder")
		
	def OnbtnClose(self, event):
		self.Close(1)
		
	def OnbtnRemove(self, event):
		sel = self.drscriptstree.GetSelection()
		if (not sel.IsOk()):
			return
		if (sel == self.drscriptstree.GetRootItem()):
			drScrolledMessageDialog.ShowMessage(self, "You can't remove the Root Item.\n", "Mistake")
			return			
		t = self.drscriptstree.GetItemText(sel)
		message = 'This will remove the drscript: "' + t + '"'
		if (self.drscriptstree.GetItemText(sel)[0] == '>'):
			message = 'This will remove all drscripts in folder: "' + t + '"!'
		d = wx.MessageDialog(self, (message + "\nAre you sure you want to do this?"), "DrPython", wx.YES_NO | wx.ICON_QUESTION)
		answer = d.ShowModal()
		d.Destroy()
		if (answer == wx.ID_NO):
			return
		try:	
			self.drscriptstree.Delete(sel)
		except:


			drScrolledMessageDialog.ShowMessage(self, ("Something went wrong trying to remove that item....\nWhat's it called....\nOh yes: " + t + "\n"), "Error")
			return	
	
	def OnbtnSave(self, event):
		if (not os.path.exists(self.homedirectory)):
			drScrolledMessageDialog.ShowMessage(self, ("Dude, you've got some problems...\nYour homedirectory (" + self.homedirectory + ") does not exist!\nLet's not bother speculating about how or why.\nRead the help file for this truly screwed up situation.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed this problem."), "Huge Error")
			return
		try:
			root = self.drscriptstree.GetRootItem()
			f = open(self.drscriptsfile, 'w')
			WriteBranch(self.drscriptstree, root, f, -1)
			f.close()
			
			#Sync Shortcuts:
			s, k = GetShortcutArrays(self.drscriptstree, root)
			self.parent.DrScriptShortcuts = self.parent.DrScriptShortcuts[:self.parent.drscriptmenu.ExampleScriptCount]
			self.parent.DrScriptKeycodeArray = self.parent.DrScriptKeycodeArray[:self.parent.drscriptmenu.ExampleScriptCount]
			map(lambda x: self.parent.DrScriptShortcuts.append(x), s)
			map(lambda x: self.parent.DrScriptKeycodeArray.append(x), k)
			
			#Sync the Shortcuts File:
			shortcutsfile = self.homedirectory + "/drscript.shortcuts.dat"
			try:			
				drShortcutsFile.WriteShortcuts(shortcutsfile, self.parent.DrScriptShortcuts, "", False)
			except IOError:			
				drScrolledMessageDialog.ShowMessage(self, ("There were some problems writing to:\n"  + shortcutsfile + "\nEither the file is having metaphysical issues, or you do not have permission to write.\nFor metaphysical issues, consult the documentation.\nFor permission issues, change the permissions on the directory to allow yourself write access.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed the problem."), "Write Error")
				return
		except IOError:			
			drScrolledMessageDialog.ShowMessage(self, ("There were some problems writing to:\n"  + self.drscriptsfile + "\nEither the file is having metaphysical issues, or you do not have permission to write.\nFor metaphysical issues, consult the documentation.\nFor permission issues, change the permissions on the directory to allow yourself write access.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed the problem."), "Write Error")
			return
		if self.parent.prefs.enablefeedback:
			drScrolledMessageDialog.ShowMessage(self, ("Succesfully wrote to:\n"  + self.drscriptsfile), "Saved Bookmarks")