%define name       drivel
%define version    2.0.1
%define release    1
%define prefix     /usr
%define sysconfdir /etc
%define gettext_package drivel

Summary:    A journal or "blog" client
Name:       %{name}
Version:    %{version}
Release:    %{release}
Epoch:      1
License:    GPL
Group:      Applications
Vendor:     Dropline Systems
Url:        http://www.dropline.net/drivel
Source:     %{name}-%{version}.tar.bz2
Packager:   Todd Kulesza <todd@dropline.net>
BuildRoot:  /var/tmp/%{name}-%{version}-root
BuildRequires: scrollkeeper >= @SCROLLKEEPER_BUILD_REQUIRED@
Requires:   glib2 >= 2.4.0
Requires:   gtk2 >= 2.4.0
Prefix:     %{prefix}


%description
Drivel is an advanced journal client for the GNOME desktop.  It had been 
designed with usability in mind, and presents an elegant user interface.
Supported journal types include LiveJournal, MovableType, Blogger, Atom,
and Advogato.

%prep
%setup -q

%build
%configure --disable-schemas-install --disable-mime-update --disable-desktop-update
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

# Remove the Shared MIME Database files, these need to be created after
# package installation
#/bin/rm -f %{buildroot}/%{_datadir}/mime/XMLnamespaces
#/bin/rm -f %{buildroot}/%{_datadir}/mime/globs
#/bin/rm -f %{buildroot}/%{_datadir}/mime/magic
#/bin/rm -f %{buildroot}/%{_datadir}/mime/application/x-drivel.xml

%clean
rm -rf $RPM_BUILD_ROOT

# Clean out files that should not be part of the rpm.
# This is the recommended way of dealing with it for RH8
rm -rf $RPM_BUILD_ROOT/var/scrollkeeper/*

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
SCHEMAS="drivel.schemas"
for S in $SCHEMAS; do
  gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/$S > /dev/null
done
if (update-mime-database -v &> /dev/null); then
  update-mime-database "%{_datadir}/mime" > /dev/null
fi
if which scrollkeeper-update > /dev/null 2>&1; then 
	scrollkeeper-update -q -o %{_datadir}/omf/drivel
fi
if (update-desktop-database -v &> /dev/null); then
  update-desktop-database > /dev/null
fi

%postun
if (update-mime-database -v &> /dev/null); then
  update-mime-database "%{_datadir}/mime" > /dev/null
fi
if which scrollkeeper-update > /dev/null 2>&1; then
	scrollkeeper-update -q
fi
if (update-desktop-database -v &> /dev/null); then
  update-desktop-database > /dev/null
fi
/bin/true ## for rpmlint, -p requires absolute path and is just dumb

%files
%defattr(-, root, root)
%doc AUTHORS COPYING COPYING-DOCS ChangeLog NEWS README TODO
%{_bindir}/drivel
%{_datadir}/applications/gnome-drivel.desktop
%{_datadir}/application-registry/drivel.applications
%{_datadir}/drivel/glade/drivel.glade
%{_datadir}/drivel/languages/livejournal.lang
%{_datadir}/gnome/help/drivel/*
%{_datadir}/icons/gnome/48x48/mimetypes/gnome-mime-application-x-drivel.png
%{_datadir}/locale/*
%{_datadir}/mime/packages/drivel.xml
%{_datadir}/mime-info/drivel.keys
%{_datadir}/mime-info/drivel.mime
%{_datadir}/omf/drivel/drivel-C.omf
%{_datadir}/pixmaps/drivel-48.png
%{_datadir}/pixmaps/drivel/*.png
%{_datadir}/pixmaps/drivel/*.xpm
%config %{_sysconfdir}/gconf/schemas/*

%changelog

* Sun Jun 5 2005 Todd Kulesza <todd@dropline.net>
- Update for Drivel 2.0.

* Sun Jan 9 2005 Todd Kulesza <todd@dropline.net>
- Don't run ldconfig after install, Drivel doesn't include libraries.

* Sat Jan 8 2005 Todd Kulesza <todd@dropline.net>
- Use the new --disable-mime-update and --disable-desktop-update parameters.

* Mon Jan 3 2005 Todd Kulesza <todd@dropline.net>
- Run update-desktop-database after installation.
- Renamed the MIME icon and desktop entry.

* Thu Nov 25 2004 Todd Kulesza <todd@dropline.net>
- Fixed up the scrollkeeper install/uninstall code.

* Sat Aug 28 2004 Todd Kulesza <todd@dropline.net>
- Add a user manual.

* Sat Jul 31 2004 Todd Kulesza <todd@dropline.net>
- Add Shared MIME Database support.
