%define name       drivel
%define version    0.9.4
%define release    1
%define prefix     /usr
%define sysconfdir /etc
%define gettext_package drivel

Summary:    A LiveJournal client
Name:       %{name}
Version:    %{version}
Release:    %{release}
Epoch:      1
License:    GPL
Group:      Applications
Vendor:     Dropline Systems
Url:        http://www.dropline.net/drivel
Source:     %{name}-%{version}.tar.bz2
Packager:   Todd Kulesza <todd@dropline.net>
BuildRoot:  /var/tmp/%{name}-%{version}-root
Requires:   glib2 >= 2.0.0
Requires:   gtk2 >= 2.0.0
Requires:   libgnome >= 2.0.0
Requires:   libgnomeui >= 2.0.0
Requires:   gnome-vfs2 >= 2.0.0
Requires:   gconf2 >= 2.0.0
Requires:   curl >= 7.10.0
BuildRequires:   glib2-devel >= 2.0.0
BuildRequires:   gtk2-devel >= 2.0.0
BuildRequires:   libgnome-devel >= 2.0.0
BuildRequires:   libgnomeui-devel >= 2.0.0
BuildRequires:   gnome-vfs2-devel >= 2.0.0
BuildRequires:   gconf2-devel >= 2.0.0
Prefix:     %{prefix}


%description
Drivel is an advanced LiveJournal client for the GNOME desktop.  While 
maintaining a full set of features, it had been designed with usability 
in mind, and presents an elegant user interface.

%prep
%setup

%build
%configure --disable-schemas-install
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

# Clean out files that should not be part of the rpm.
# This is the recommended way of dealing with it for RH8
rm -rf $RPM_BUILD_ROOT/var/scrollkeeper/*

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
SCHEMAS="drivel.schemas"
for S in $SCHEMAS; do
  gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/$S > /dev/null
done
/sbin/ldconfig

%postun
/sbin/ldconfig
/bin/true ## for rpmlint, -p requires absolute path and is just dumb

%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog NEWS README TODO
%{_bindir}/drivel
%{_datadir}/pixmaps/livejournal.png
%{_datadir}/pixmaps/drivel/*.png
%{_datadir}/applications/drivel.desktop
%config %{_sysconfdir}/gconf/schemas/*
