/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __SPU_H__
#define __SPU_H__

#include <glib.h>

typedef struct {        // CLUT == Color LookUp Table
    guint8:8;
    guint8 y:8;
    guint8 cr:8;
    guint8 cb:8;
} __attribute__ ((packed)) clut_t_;

struct spu_img_struct {
	guchar *data;		// 7-4: mixer key, 3-0: color index
	guint x;		// x start of subpicture area
	guint y;		// y start of subpicture area
	gint width;		// width of subpicture area
	gint height;		// height of subpicture area
	guchar clut_index[4];	// color lookup table
	guchar trans[4];	// mixer key table
	guint time_execute;	// time in ms
	clut_t_ *clut;          // YUV-CLUT
	guint _x;		// current destination x, y
	guint _y;
	guint offset[2];	// address in PXD to fetch next rle-code from, one per field
	gint xbase;
        gint ybase;
        gint cliptop;
        gint clipbottom;
	gint clipleft;
	gint clipright;
};


typedef struct spu_clut_struct {
#ifdef WORDS_BIGENDIAN
guint8	entry0	: 4;
guint8	entry1	: 4;
guint8	entry2	: 4;
guint8	entry3	: 4;
#else
guint8  entry2  : 4;
guint8  entry3  : 4;
guint8  entry0  : 4;
guint8  entry1  : 4;
#endif
} spu_clut_t;

extern gchar* SPU_LD;
extern guint spu_clut[16];

#ifdef __cplusplus
extern "C" {
#endif
void spu_init(gint language, gint sx, gint sy, gint ctop, gint cbottom, gint cleft, gint cright, gdouble FR, gchar* clutfile, gchar* log_domain);
void spu_overlay(guint8*[3],guint,guint,guint);
void spu_render(guchar* data, glong pts);
void decode_spu(guchar *data_start, guchar *data_end);
guint buffer_spupack(guint *length, guchar **start, guchar *end);
gint spu_parse_header(struct spu_img_struct *spu, guchar *pkt_data, guint pkt_len);
void spu_parse_data(struct spu_img_struct *spu);
#ifdef __cplusplus
}
#endif

#endif
