import java.util.*;
import junit.framework.*;


/**
 * Unit test for the IGMisc class
 *
 * @author Ben Secrest &lt;blsecres@users.sourceforge.net&gt;
 * @version $Id: IGMiscTest.java,v 1.1 2002/08/29 02:13:59 blsecres Exp $
 */
public class IGMiscTest extends TestCase {
    /* test relative */

    /* test rmFileName */


    /**
     * Test the method arrayToString
     */
    public void testArrayToString() {
	String simpleString1 = "alpha beta gamma delta epsilon";
	String simpleString2 = "alpha, beta, gamma, delta, epsilon";
	String[] stringArray = new String[]{"alpha", "beta", "gamma", "delta",
	    "epsilon"};

	Assert.assertEquals(simpleString1,
		IGMisc.arrayToString(stringArray, null));
	Assert.assertEquals(simpleString2,
		IGMisc.arrayToString(stringArray, ", "));

	Assert.assertEquals(null, IGMisc.arrayToString(null, null));
    }


    /**
     * Test the method stringToArray
     */
    public void testStringToArray() {
	String simpleString1 = "alpha\tbeta\rgamma\ndelta     epsilon";
	String simpleString2 = "alpha,\tbeta,\rgamma,\ndelta,     epsilon,";
	String[] stringArray = new String[]{"alpha", "beta", "gamma", "delta",
	    "epsilon"};

	// split on default values
	Assert.assertTrue(Arrays.equals(stringArray,
		    IGMisc.stringToArray(simpleString1, null)));
	Assert.assertFalse(Arrays.equals(stringArray,
		    IGMisc.stringToArray(simpleString2, null)));

	// split on comma
	Assert.assertFalse(Arrays.equals(stringArray,
		    IGMisc.stringToArray(simpleString1, ",")));
	Assert.assertTrue(Arrays.equals(stringArray,
		    IGMisc.stringToArray(simpleString2, ",")));

	Assert.assertEquals(null, IGMisc.stringToArray(null, null));
    }

    
    /**
     * Test hashSetToStringArray
     */
    public void testHashSetToStringArray() {
	String[] stringArray = new String[]{"alpha", "beta", "delta",
	    "epsilon", "gamma"};
	HashSet hash = new HashSet(5);
	hash.add(new String("alpha"));
	hash.add(new String("beta"));
	hash.add(new String("gamma"));
	hash.add(new String("delta"));
	hash.add(new String("epsilon"));

	String[] result = IGMisc.hashSetToStringArray(hash);
	Arrays.sort(result, new Comparator() {
	    public int compare(Object o1, Object o2) {
		return ((String) o1).compareTo((String) o2);
	    }
	});

	Assert.assertTrue(Arrays.equals(result, stringArray));
	Assert.assertEquals(null, IGMisc.hashSetToStringArray(null));
    }


    /**
     * Test isURL
     */
    public void testIsURL() {
	Assert.assertTrue(IGMisc.isURL("http://www.sourceforge.net/"));
	Assert.assertFalse(IGMisc.isURL("www.sourceforge.net/projects/"));

	Assert.assertFalse(IGMisc.isURL("/usr/src/sys/arch/i386/"));
	Assert.assertTrue(IGMisc.isURL("file:///usr/src/sys/arch/i386"));

	Assert.assertFalse(IGMisc.isURL(null));
    }
}
