"""
This module contains compiletime information about the
dolfin python library, which can be utilized at runtime.

The file is automatically generated by the generateswigcode.py script
in the dolfin/swig directory."""

try:
    from collections import OrderedDict
except ImportError:
    from dolfin_utils.ordereddict import OrderedDict

# A list of shared_ptr declared classes in dolfin
shared_ptr_classes = ['AdaptiveLinearVariationalSolver', 'AdaptiveNonlinearVariationalSolver', 'BasisFunction', 'BelosKrylovSolver', 'BoundaryMesh', 'BoundingBoxTree', 'Box', 'BoxMesh', 'CellFunction<std::size_t>', 'CholmodCholeskySolver', 'Constant', 'DirichletBC', 'DofMap', 'DomainBoundary', 'EdgeFunction<std::size_t>', 'EigenKrylovSolver', 'EigenLUSolver', 'EigenMatrix', 'EigenVector', 'ErrorControl', 'Expression', 'ExpressionWrapper', 'FaceFunction<std::size_t>', 'FacetArea', 'FacetFunction<std::size_t>', 'File', 'FiniteElement', 'Form', 'Function', 'FunctionSpace', 'GaussQuadrature', 'GaussianQuadrature', 'GenericAdaptiveVariationalSolver', 'GenericDofMap', 'GenericFile', 'GenericFunction', 'GenericLUSolver', 'GenericLinearOperator', 'GenericLinearSolver', 'GenericMatrix', 'GenericPreconditioner', 'GenericTensor', 'GenericVTKPlottable', 'GenericVector', 'GlobalParameters', 'GoalFunctional', 'HDF5File', 'Hierarchical<dolfin::DirichletBC>', 'Hierarchical<dolfin::ErrorControl>', 'Hierarchical<dolfin::Form>', 'Hierarchical<dolfin::Function>', 'Hierarchical<dolfin::FunctionSpace>', 'Hierarchical<dolfin::LinearVariationalProblem>', 'Hierarchical<dolfin::Mesh>', 'Hierarchical<dolfin::MeshFunction<std::size_t> >', 'Hierarchical<dolfin::NonlinearVariationalProblem>', 'Ifpack2Preconditioner', 'IndexMap', 'IntervalMesh', 'KrylovSolver', 'LUSolver', 'Lagrange', 'LinearAlgebraObject', 'LinearOperator', 'LinearSolver', 'LinearVariationalProblem', 'LinearVariationalSolver', 'LobattoQuadrature', 'LocalMeshData', 'Matrix', 'Mesh', 'MeshCoordinates', 'MeshData', 'MeshDisplacement', 'MeshFunction<std::size_t>', 'MeshHierarchy', 'MeshPointIntersection', 'MueluPreconditioner', 'MultiMesh', 'MultiMeshDofMap', 'MultiMeshFunction', 'MultiMeshFunctionSpace', 'MultiMeshSubSpace', 'MultiStageScheme', 'NewtonSolver', 'NonlinearVariationalProblem', 'NonlinearVariationalSolver', 'PETScBaseMatrix', 'PETScKrylovSolver', 'PETScLUSolver', 'PETScLinearOperator', 'PETScMatrix', 'PETScObject', 'PETScPreconditioner', 'PETScSNESSolver', 'PETScTAOSolver', 'PETScUserPreconditioner', 'PETScVector', 'PaStiXLUSolver', 'Parameters', 'PointIntegralSolver', 'Quadrature', 'RadauQuadrature', 'Rectangle', 'RectangleMesh', 'SLEPcEigenSolver', 'Scalar', 'SparsityPattern', 'SpecialFacetFunction', 'SphericalShellMesh', 'SubDomain', 'SubMesh', 'SubSpace', 'TAOLinearBoundSolver', 'Table', 'TensorLayout', 'TimeSeries', 'TimeSeriesHDF5', 'TpetraMatrix', 'TpetraVector', 'TrilinosPreconditioner', 'UmfpackLUSolver', 'UnitCubeMesh', 'UnitDiscMesh', 'UnitHexMesh', 'UnitIntervalMesh', 'UnitQuadMesh', 'UnitSquareMesh', 'UnitTetrahedronMesh', 'UnitTriangleMesh', 'VTKPlottableGenericFunction', 'VTKPlottableMesh', 'VTKPlottableMeshFunction', 'VTKPlotter', 'Variable', 'Vector', 'VertexFunction<std::size_t>', 'X3DOM', 'XDMFFile']

# An OrderedDict of all dolfin declared and its meta info
dolfin_type_def = OrderedDict([
('ufc::function', dict([
  ('bases', []),
  ('derived', ['BasisFunction', 'Constant', 'Expression', 'FacetArea', 'Function', 'GenericFunction', 'MeshCoordinates', 'MeshDisplacement', 'SpecialFacetFunction']),
  ('header', 'ufc.h'),
  ('module', ''),
  ('submodule', '')
])),
('la_index', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/common/types.h'),
  ('module', 'common'),
  ('submodule', 'common')
])),
('TimingClear', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/common/timing.h'),
  ('module', 'common'),
  ('submodule', 'common')
])),
('TimingType', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/common/timing.h'),
  ('module', 'common'),
  ('submodule', 'common')
])),
('Array', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/common/Array.h'),
  ('module', 'common'),
  ('submodule', 'common')
])),
('ArrayView', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/common/ArrayView.h'),
  ('module', 'common'),
  ('submodule', 'common')
])),
('IndexSet', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/common/IndexSet.h'),
  ('module', 'common'),
  ('submodule', 'common')
])),
('Set', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/common/Set.h'),
  ('module', 'common'),
  ('submodule', 'common')
])),
('Timer', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/common/Timer.h'),
  ('module', 'common'),
  ('submodule', 'common')
])),
('Variable', dict([
  ('bases', []),
  ('derived', ['AdaptiveLinearVariationalSolver', 'AdaptiveNonlinearVariationalSolver', 'BelosKrylovSolver', 'BoundaryMesh', 'BoxMesh', 'CellFunction', 'Constant', 'DirichletBC', 'DofMap', 'EdgeFunction', 'EigenKrylovSolver', 'EigenLUSolver', 'EigenMatrix', 'EigenVector', 'ErrorControl', 'Expression', 'FaceFunction', 'FacetArea', 'FacetFunction', 'Function', 'FunctionSpace', 'GenericAdaptiveVariationalSolver', 'GenericDofMap', 'GenericFunction', 'GenericLUSolver', 'GenericLinearOperator', 'GenericLinearSolver', 'GenericMatrix', 'GenericTensor', 'GenericVector', 'HDF5File', 'Ifpack2Preconditioner', 'IntervalMesh', 'KrylovSolver', 'LUSolver', 'Lagrange', 'LinearAlgebraObject', 'LinearOperator', 'LinearSolver', 'LinearVariationalSolver', 'LocalMeshData', 'Matrix', 'Mesh', 'MeshCoordinates', 'MeshData', 'MeshDisplacement', 'MeshFunction', 'MeshValueCollection', 'MueluPreconditioner', 'MultiMesh', 'MultiMeshFunction', 'MultiMeshFunctionSpace', 'MultiMeshSubSpace', 'MultiStageScheme', 'NewtonSolver', 'NonlinearVariationalSolver', 'PETScBaseMatrix', 'PETScKrylovSolver', 'PETScLUSolver', 'PETScLinearOperator', 'PETScMatrix', 'PETScPreconditioner', 'PETScVector', 'PointIntegralSolver', 'RectangleMesh', 'SLEPcEigenSolver', 'Scalar', 'SpecialFacetFunction', 'SphericalShellMesh', 'SubMesh', 'TAOLinearBoundSolver', 'Table', 'TensorLayout', 'TimeSeries', 'TpetraMatrix', 'TpetraVector', 'UnitCubeMesh', 'UnitDiscMesh', 'UnitHexMesh', 'UnitIntervalMesh', 'UnitQuadMesh', 'UnitSquareMesh', 'UnitTetrahedronMesh', 'UnitTriangleMesh', 'VTKPlotter', 'Vector', 'VertexFunction', 'XDMFFile']),
  ('header', 'dolfin/common/Variable.h'),
  ('module', 'common'),
  ('submodule', 'common')
])),
('Hierarchical', dict([
  ('bases', []),
  ('derived', ['BoundaryMesh', 'BoxMesh', 'CellFunction', 'DirichletBC', 'EdgeFunction', 'ErrorControl', 'FaceFunction', 'FacetFunction', 'Form', 'Function', 'FunctionSpace', 'GoalFunctional', 'IntervalMesh', 'LinearVariationalProblem', 'Mesh', 'MeshFunction', 'NonlinearVariationalProblem', 'RectangleMesh', 'SphericalShellMesh', 'SubMesh', 'UnitCubeMesh', 'UnitDiscMesh', 'UnitHexMesh', 'UnitIntervalMesh', 'UnitQuadMesh', 'UnitSquareMesh', 'UnitTetrahedronMesh', 'UnitTriangleMesh', 'VertexFunction']),
  ('header', 'dolfin/common/Hierarchical.h'),
  ('module', 'common'),
  ('submodule', 'common')
])),
('MPI_Comm', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/common/MPI.h'),
  ('module', 'common'),
  ('submodule', 'common')
])),
('MPI', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/common/MPI.h'),
  ('module', 'common'),
  ('submodule', 'common')
])),
('MPIInfo', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/common/MPI.h'),
  ('module', 'common'),
  ('submodule', 'common')
])),
('SubSystemsManager', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/common/SubSystemsManager.h'),
  ('module', 'common'),
  ('submodule', 'common')
])),
('BoolParameter', dict([
  ('bases', ['Parameter']),
  ('derived', []),
  ('header', 'dolfin/parameter/Parameter.h'),
  ('module', 'common'),
  ('submodule', 'parameter')
])),
('DoubleParameter', dict([
  ('bases', ['Parameter']),
  ('derived', []),
  ('header', 'dolfin/parameter/Parameter.h'),
  ('module', 'common'),
  ('submodule', 'parameter')
])),
('IntParameter', dict([
  ('bases', ['Parameter']),
  ('derived', []),
  ('header', 'dolfin/parameter/Parameter.h'),
  ('module', 'common'),
  ('submodule', 'parameter')
])),
('Parameter', dict([
  ('bases', []),
  ('derived', ['BoolParameter', 'DoubleParameter', 'IntParameter', 'StringParameter']),
  ('header', 'dolfin/parameter/Parameter.h'),
  ('module', 'common'),
  ('submodule', 'parameter')
])),
('StringParameter', dict([
  ('bases', ['Parameter']),
  ('derived', []),
  ('header', 'dolfin/parameter/Parameter.h'),
  ('module', 'common'),
  ('submodule', 'parameter')
])),
('Parameters', dict([
  ('bases', []),
  ('derived', ['GlobalParameters']),
  ('header', 'dolfin/parameter/Parameters.h'),
  ('module', 'common'),
  ('submodule', 'parameter')
])),
('GlobalParameters', dict([
  ('bases', ['Parameters']),
  ('derived', []),
  ('header', 'dolfin/parameter/GlobalParameters.h'),
  ('module', 'common'),
  ('submodule', 'parameter')
])),
('Event', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/log/Event.h'),
  ('module', 'common'),
  ('submodule', 'log')
])),
('Progress', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/log/Progress.h'),
  ('module', 'common'),
  ('submodule', 'log')
])),
('Table', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/log/Table.h'),
  ('module', 'common'),
  ('submodule', 'log')
])),
('TableEntry', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/log/Table.h'),
  ('module', 'common'),
  ('submodule', 'log')
])),
('CellType', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/CellType.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshTopology', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/MeshTopology.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshGeometry', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/MeshGeometry.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshDomains', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/MeshDomains.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshData', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/mesh/MeshData.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('Mesh', dict([
  ('bases', ['Hierarchical', 'Variable']),
  ('derived', ['BoundaryMesh', 'BoxMesh', 'IntervalMesh', 'RectangleMesh', 'SphericalShellMesh', 'SubMesh', 'UnitCubeMesh', 'UnitDiscMesh', 'UnitHexMesh', 'UnitIntervalMesh', 'UnitQuadMesh', 'UnitSquareMesh', 'UnitTetrahedronMesh', 'UnitTriangleMesh']),
  ('header', 'dolfin/mesh/Mesh.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshEntity', dict([
  ('bases', []),
  ('derived', ['Cell', 'Edge', 'Face', 'Facet', 'FacetCell', 'Vertex']),
  ('header', 'dolfin/mesh/MeshEntity.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshEntityIterator', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/MeshEntityIterator.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshEntityIteratorBase', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/MeshEntityIteratorBase.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('SubsetIterator', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/SubsetIterator.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('VertexIterator', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/Vertex.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('Vertex', dict([
  ('bases', ['MeshEntity']),
  ('derived', []),
  ('header', 'dolfin/mesh/Vertex.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('VertexFunction', dict([
  ('bases', ['Hierarchical', 'MeshFunction', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/mesh/Vertex.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('EdgeIterator', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/Edge.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('Edge', dict([
  ('bases', ['MeshEntity']),
  ('derived', []),
  ('header', 'dolfin/mesh/Edge.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('EdgeFunction', dict([
  ('bases', ['Hierarchical', 'MeshFunction', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/mesh/Edge.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('FaceIterator', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/Face.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('Face', dict([
  ('bases', ['MeshEntity']),
  ('derived', []),
  ('header', 'dolfin/mesh/Face.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('FaceFunction', dict([
  ('bases', ['Hierarchical', 'MeshFunction', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/mesh/Face.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('FacetIterator', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/Facet.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('Facet', dict([
  ('bases', ['MeshEntity']),
  ('derived', []),
  ('header', 'dolfin/mesh/Facet.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('FacetFunction', dict([
  ('bases', ['Hierarchical', 'MeshFunction', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/mesh/Facet.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('CellIterator', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/Cell.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('Cell', dict([
  ('bases', ['MeshEntity']),
  ('derived', ['FacetCell']),
  ('header', 'dolfin/mesh/Cell.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('CellFunction', dict([
  ('bases', ['Hierarchical', 'MeshFunction', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/mesh/Cell.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('FacetCell', dict([
  ('bases', ['Cell', 'MeshEntity']),
  ('derived', []),
  ('header', 'dolfin/mesh/FacetCell.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshConnectivity', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/MeshConnectivity.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshEditor', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/MeshEditor.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('DynamicMeshEditor', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/DynamicMeshEditor.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('LocalMeshValueCollection', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/LocalMeshValueCollection.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshFunction', dict([
  ('bases', ['Hierarchical', 'Variable']),
  ('derived', ['CellFunction', 'EdgeFunction', 'FaceFunction', 'FacetFunction', 'VertexFunction']),
  ('header', 'dolfin/mesh/MeshFunction.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshValueCollection', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/mesh/MeshValueCollection.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshColoring', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/MeshColoring.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshRenumbering', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/MeshRenumbering.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshTransformation', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/MeshTransformation.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('LocalMeshData', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/mesh/LocalMeshData.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('SubDomain', dict([
  ('bases', []),
  ('derived', ['DomainBoundary']),
  ('header', 'dolfin/mesh/SubDomain.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('SubMesh', dict([
  ('bases', ['Hierarchical', 'Mesh', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/mesh/SubMesh.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('DomainBoundary', dict([
  ('bases', ['SubDomain']),
  ('derived', []),
  ('header', 'dolfin/mesh/DomainBoundary.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('BoundaryMesh', dict([
  ('bases', ['Hierarchical', 'Mesh', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/mesh/BoundaryMesh.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('PeriodicBoundaryComputation', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/PeriodicBoundaryComputation.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshQuality', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/MeshQuality.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('quadrature_rule', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/MultiMesh.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MultiMesh', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/mesh/MultiMesh.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshHierarchy', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/MeshHierarchy.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('MeshPartitioning', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/mesh/MeshPartitioning.h'),
  ('module', 'mesh'),
  ('submodule', 'mesh')
])),
('BoxMesh', dict([
  ('bases', ['Hierarchical', 'Mesh', 'Variable']),
  ('derived', ['UnitCubeMesh']),
  ('header', 'dolfin/generation/BoxMesh.h'),
  ('module', 'mesh'),
  ('submodule', 'generation')
])),
('IntervalMesh', dict([
  ('bases', ['Hierarchical', 'Mesh', 'Variable']),
  ('derived', ['UnitIntervalMesh']),
  ('header', 'dolfin/generation/IntervalMesh.h'),
  ('module', 'mesh'),
  ('submodule', 'generation')
])),
('RectangleMesh', dict([
  ('bases', ['Hierarchical', 'Mesh', 'Variable']),
  ('derived', ['UnitSquareMesh']),
  ('header', 'dolfin/generation/RectangleMesh.h'),
  ('module', 'mesh'),
  ('submodule', 'generation')
])),
('UnitTetrahedronMesh', dict([
  ('bases', ['Hierarchical', 'Mesh', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/generation/UnitTetrahedronMesh.h'),
  ('module', 'mesh'),
  ('submodule', 'generation')
])),
('UnitCubeMesh', dict([
  ('bases', ['BoxMesh', 'Hierarchical', 'Mesh', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/generation/UnitCubeMesh.h'),
  ('module', 'mesh'),
  ('submodule', 'generation')
])),
('UnitIntervalMesh', dict([
  ('bases', ['Hierarchical', 'IntervalMesh', 'Mesh', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/generation/UnitIntervalMesh.h'),
  ('module', 'mesh'),
  ('submodule', 'generation')
])),
('UnitTriangleMesh', dict([
  ('bases', ['Hierarchical', 'Mesh', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/generation/UnitTriangleMesh.h'),
  ('module', 'mesh'),
  ('submodule', 'generation')
])),
('UnitSquareMesh', dict([
  ('bases', ['Hierarchical', 'Mesh', 'RectangleMesh', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/generation/UnitSquareMesh.h'),
  ('module', 'mesh'),
  ('submodule', 'generation')
])),
('UnitQuadMesh', dict([
  ('bases', ['Hierarchical', 'Mesh', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/generation/UnitQuadMesh.h'),
  ('module', 'mesh'),
  ('submodule', 'generation')
])),
('UnitHexMesh', dict([
  ('bases', ['Hierarchical', 'Mesh', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/generation/UnitHexMesh.h'),
  ('module', 'mesh'),
  ('submodule', 'generation')
])),
('UnitDiscMesh', dict([
  ('bases', ['Hierarchical', 'Mesh', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/generation/UnitDiscMesh.h'),
  ('module', 'mesh'),
  ('submodule', 'generation')
])),
('SphericalShellMesh', dict([
  ('bases', ['Hierarchical', 'Mesh', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/generation/SphericalShellMesh.h'),
  ('module', 'mesh'),
  ('submodule', 'generation')
])),
('Point', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/geometry/Point.h'),
  ('module', 'mesh'),
  ('submodule', 'geometry')
])),
('BoundingBoxTree', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/geometry/BoundingBoxTree.h'),
  ('module', 'mesh'),
  ('submodule', 'geometry')
])),
('GenericBoundingBoxTree', dict([
  ('bases', []),
  ('derived', ['BoundingBoxTree3D']),
  ('header', 'dolfin/geometry/GenericBoundingBoxTree.h'),
  ('module', 'mesh'),
  ('submodule', 'geometry')
])),
('BoundingBoxTree3D', dict([
  ('bases', ['GenericBoundingBoxTree']),
  ('derived', []),
  ('header', 'dolfin/geometry/BoundingBoxTree3D.h'),
  ('module', 'mesh'),
  ('submodule', 'geometry')
])),
('MeshPointIntersection', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/geometry/MeshPointIntersection.h'),
  ('module', 'mesh'),
  ('submodule', 'geometry')
])),
('Graph', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/graph/Graph.h'),
  ('module', 'mesh'),
  ('submodule', 'graph')
])),
('graph_set_type', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/graph/Graph.h'),
  ('module', 'mesh'),
  ('submodule', 'graph')
])),
('GraphBuilder', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/graph/GraphBuilder.h'),
  ('module', 'mesh'),
  ('submodule', 'graph')
])),
('BoostGraphOrdering', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/graph/BoostGraphOrdering.h'),
  ('module', 'mesh'),
  ('submodule', 'graph')
])),
('SCOTCH', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/graph/SCOTCH.h'),
  ('module', 'mesh'),
  ('submodule', 'graph')
])),
('E', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/la/LinearAlgebraObject.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('LinearAlgebraObject', dict([
  ('bases', ['Variable']),
  ('derived', ['EigenMatrix', 'EigenVector', 'GenericLinearOperator', 'GenericMatrix', 'GenericTensor', 'GenericVector', 'LinearOperator', 'Matrix', 'PETScLinearOperator', 'PETScMatrix', 'PETScVector', 'Scalar', 'TpetraMatrix', 'TpetraVector', 'Vector']),
  ('header', 'dolfin/la/LinearAlgebraObject.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('GenericLinearOperator', dict([
  ('bases', ['LinearAlgebraObject', 'Variable']),
  ('derived', ['EigenMatrix', 'GenericMatrix', 'LinearOperator', 'Matrix', 'PETScLinearOperator', 'PETScMatrix', 'TpetraMatrix']),
  ('header', 'dolfin/la/GenericLinearOperator.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('GenericTensor', dict([
  ('bases', ['LinearAlgebraObject', 'Variable']),
  ('derived', ['EigenMatrix', 'EigenVector', 'GenericMatrix', 'GenericVector', 'Matrix', 'PETScMatrix', 'PETScVector', 'Scalar', 'TpetraMatrix', 'TpetraVector', 'Vector']),
  ('header', 'dolfin/la/GenericTensor.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('GenericMatrix', dict([
  ('bases', ['GenericLinearOperator', 'GenericTensor', 'LinearAlgebraObject', 'Variable']),
  ('derived', ['EigenMatrix', 'Matrix', 'PETScMatrix', 'TpetraMatrix']),
  ('header', 'dolfin/la/GenericMatrix.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('GenericVector', dict([
  ('bases', ['GenericTensor', 'LinearAlgebraObject', 'Variable']),
  ('derived', ['EigenVector', 'PETScVector', 'TpetraVector', 'Vector']),
  ('header', 'dolfin/la/GenericVector.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('VectorSpaceBasis', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/la/VectorSpaceBasis.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('GenericLinearSolver', dict([
  ('bases', ['Variable']),
  ('derived', ['BelosKrylovSolver', 'EigenKrylovSolver', 'EigenLUSolver', 'GenericLUSolver', 'KrylovSolver', 'LUSolver', 'LinearSolver', 'PETScKrylovSolver', 'PETScLUSolver']),
  ('header', 'dolfin/la/GenericLinearSolver.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('GenericLUSolver', dict([
  ('bases', ['GenericLinearSolver', 'Variable']),
  ('derived', ['EigenLUSolver', 'LUSolver', 'PETScLUSolver']),
  ('header', 'dolfin/la/GenericLUSolver.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('PETScOptions', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/la/PETScOptions.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('PETScObject', dict([
  ('bases', []),
  ('derived', ['PETScBaseMatrix', 'PETScKrylovSolver', 'PETScLUSolver', 'PETScLinearOperator', 'PETScMatrix', 'PETScPreconditioner', 'PETScSNESSolver', 'PETScTAOSolver', 'PETScUserPreconditioner', 'PETScVector', 'SLEPcEigenSolver', 'TAOLinearBoundSolver']),
  ('header', 'dolfin/la/PETScObject.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('PETScBaseMatrix', dict([
  ('bases', ['PETScObject', 'Variable']),
  ('derived', ['PETScLinearOperator', 'PETScMatrix']),
  ('header', 'dolfin/la/PETScBaseMatrix.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('EigenMatrix', dict([
  ('bases', ['GenericLinearOperator', 'GenericMatrix', 'GenericTensor', 'LinearAlgebraObject', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/EigenMatrix.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('PETScMatrix', dict([
  ('bases', ['GenericLinearOperator', 'GenericMatrix', 'GenericTensor', 'LinearAlgebraObject', 'PETScBaseMatrix', 'PETScObject', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/PETScMatrix.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('PETScLinearOperator', dict([
  ('bases', ['GenericLinearOperator', 'LinearAlgebraObject', 'PETScBaseMatrix', 'PETScObject', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/PETScLinearOperator.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('PETScPreconditioner', dict([
  ('bases', ['PETScObject', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/PETScPreconditioner.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('TpetraMatrix', dict([
  ('bases', ['GenericLinearOperator', 'GenericMatrix', 'GenericTensor', 'LinearAlgebraObject', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/TpetraMatrix.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('EigenKrylovSolver', dict([
  ('bases', ['GenericLinearSolver', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/EigenKrylovSolver.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('EigenLUSolver', dict([
  ('bases', ['GenericLUSolver', 'GenericLinearSolver', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/EigenLUSolver.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('PETScKrylovSolver', dict([
  ('bases', ['GenericLinearSolver', 'PETScObject', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/PETScKrylovSolver.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('PETScLUSolver', dict([
  ('bases', ['GenericLUSolver', 'GenericLinearSolver', 'PETScObject', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/PETScLUSolver.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('BelosKrylovSolver', dict([
  ('bases', ['GenericLinearSolver', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/BelosKrylovSolver.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('TrilinosPreconditioner', dict([
  ('bases', []),
  ('derived', ['Ifpack2Preconditioner', 'MueluPreconditioner']),
  ('header', 'dolfin/la/TrilinosPreconditioner.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('MueluPreconditioner', dict([
  ('bases', ['TrilinosPreconditioner', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/MueluPreconditioner.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('Ifpack2Preconditioner', dict([
  ('bases', ['TrilinosPreconditioner', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/Ifpack2Preconditioner.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('CoordinateMatrix', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/la/CoordinateMatrix.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('EigenVector', dict([
  ('bases', ['GenericTensor', 'GenericVector', 'LinearAlgebraObject', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/EigenVector.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('PETScVector', dict([
  ('bases', ['GenericTensor', 'GenericVector', 'LinearAlgebraObject', 'PETScObject', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/PETScVector.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('TpetraVector', dict([
  ('bases', ['GenericTensor', 'GenericVector', 'LinearAlgebraObject', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/TpetraVector.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('TensorLayout', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/la/TensorLayout.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('SparsityPattern', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/la/SparsityPattern.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('IndexMap', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/la/IndexMap.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('GenericLinearAlgebraFactory', dict([
  ('bases', []),
  ('derived', ['DefaultFactory', 'EigenFactory', 'PETScFactory', 'TpetraFactory']),
  ('header', 'dolfin/la/GenericLinearAlgebraFactory.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('DefaultFactory', dict([
  ('bases', ['GenericLinearAlgebraFactory']),
  ('derived', []),
  ('header', 'dolfin/la/DefaultFactory.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('EigenFactory', dict([
  ('bases', ['GenericLinearAlgebraFactory']),
  ('derived', []),
  ('header', 'dolfin/la/EigenFactory.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('PETScUserPreconditioner', dict([
  ('bases', ['PETScObject']),
  ('derived', []),
  ('header', 'dolfin/la/PETScUserPreconditioner.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('PETScFactory', dict([
  ('bases', ['GenericLinearAlgebraFactory']),
  ('derived', []),
  ('header', 'dolfin/la/PETScFactory.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('TpetraFactory', dict([
  ('bases', ['GenericLinearAlgebraFactory']),
  ('derived', []),
  ('header', 'dolfin/la/TpetraFactory.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('SLEPcEigenSolver', dict([
  ('bases', ['PETScObject', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/SLEPcEigenSolver.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('Vector', dict([
  ('bases', ['GenericTensor', 'GenericVector', 'LinearAlgebraObject', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/Vector.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('Matrix', dict([
  ('bases', ['GenericLinearOperator', 'GenericMatrix', 'GenericTensor', 'LinearAlgebraObject', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/Matrix.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('Scalar', dict([
  ('bases', ['GenericTensor', 'LinearAlgebraObject', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/Scalar.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('LinearSolver', dict([
  ('bases', ['GenericLinearSolver', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/LinearSolver.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('KrylovSolver', dict([
  ('bases', ['GenericLinearSolver', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/KrylovSolver.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('LUSolver', dict([
  ('bases', ['GenericLUSolver', 'GenericLinearSolver', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/LUSolver.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('BlockVector', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/la/BlockVector.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('BlockMatrix', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/la/BlockMatrix.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('LinearOperator', dict([
  ('bases', ['GenericLinearOperator', 'LinearAlgebraObject', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/la/LinearOperator.h'),
  ('module', 'la'),
  ('submodule', 'la')
])),
('NonlinearProblem', dict([
  ('bases', []),
  ('derived', ['OptimisationProblem']),
  ('header', 'dolfin/nls/NonlinearProblem.h'),
  ('module', 'la'),
  ('submodule', 'nls')
])),
('NewtonSolver', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/nls/NewtonSolver.h'),
  ('module', 'la'),
  ('submodule', 'nls')
])),
('OptimisationProblem', dict([
  ('bases', ['NonlinearProblem']),
  ('derived', []),
  ('header', 'dolfin/nls/OptimisationProblem.h'),
  ('module', 'la'),
  ('submodule', 'nls')
])),
('PETScSNESSolver', dict([
  ('bases', ['PETScObject']),
  ('derived', []),
  ('header', 'dolfin/nls/PETScSNESSolver.h'),
  ('module', 'la'),
  ('submodule', 'nls')
])),
('PETScTAOSolver', dict([
  ('bases', ['PETScObject']),
  ('derived', []),
  ('header', 'dolfin/nls/PETScTAOSolver.h'),
  ('module', 'la'),
  ('submodule', 'nls')
])),
('TAOLinearBoundSolver', dict([
  ('bases', ['PETScObject', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/nls/TAOLinearBoundSolver.h'),
  ('module', 'la'),
  ('submodule', 'nls')
])),
('GenericFunction', dict([
  ('bases', ['Variable', 'ufc::function']),
  ('derived', ['Constant', 'Expression', 'FacetArea', 'Function', 'MeshCoordinates', 'MeshDisplacement', 'SpecialFacetFunction']),
  ('header', 'dolfin/function/GenericFunction.h'),
  ('module', 'function'),
  ('submodule', 'function')
])),
('Expression', dict([
  ('bases', ['GenericFunction', 'Variable', 'ufc::function']),
  ('derived', ['Constant', 'FacetArea', 'MeshCoordinates', 'MeshDisplacement', 'SpecialFacetFunction']),
  ('header', 'dolfin/function/Expression.h'),
  ('module', 'function'),
  ('submodule', 'function')
])),
('FunctionAXPY', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/function/FunctionAXPY.h'),
  ('module', 'function'),
  ('submodule', 'function')
])),
('Function', dict([
  ('bases', ['GenericFunction', 'Hierarchical', 'Variable', 'ufc::function']),
  ('derived', []),
  ('header', 'dolfin/function/Function.h'),
  ('module', 'function'),
  ('submodule', 'function')
])),
('FunctionSpace', dict([
  ('bases', ['Hierarchical', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/function/FunctionSpace.h'),
  ('module', 'function'),
  ('submodule', 'function')
])),
('Constant', dict([
  ('bases', ['Expression', 'GenericFunction', 'Variable', 'ufc::function']),
  ('derived', []),
  ('header', 'dolfin/function/Constant.h'),
  ('module', 'function'),
  ('submodule', 'function')
])),
('FacetArea', dict([
  ('bases', ['Expression', 'GenericFunction', 'Variable', 'ufc::function']),
  ('derived', []),
  ('header', 'dolfin/function/SpecialFunctions.h'),
  ('module', 'function'),
  ('submodule', 'function')
])),
('MeshCoordinates', dict([
  ('bases', ['Expression', 'GenericFunction', 'Variable', 'ufc::function']),
  ('derived', []),
  ('header', 'dolfin/function/SpecialFunctions.h'),
  ('module', 'function'),
  ('submodule', 'function')
])),
('SpecialFacetFunction', dict([
  ('bases', ['Expression', 'GenericFunction', 'Variable', 'ufc::function']),
  ('derived', []),
  ('header', 'dolfin/function/SpecialFacetFunction.h'),
  ('module', 'function'),
  ('submodule', 'function')
])),
('MultiMeshFunction', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/function/MultiMeshFunction.h'),
  ('module', 'function'),
  ('submodule', 'function')
])),
('MultiMeshFunctionSpace', dict([
  ('bases', ['Variable']),
  ('derived', ['MultiMeshSubSpace']),
  ('header', 'dolfin/function/MultiMeshFunctionSpace.h'),
  ('module', 'function'),
  ('submodule', 'function')
])),
('MultiMeshSubSpace', dict([
  ('bases', ['MultiMeshFunctionSpace', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/function/MultiMeshSubSpace.h'),
  ('module', 'function'),
  ('submodule', 'function')
])),
('FunctionAssigner', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/function/FunctionAssigner.h'),
  ('module', 'function'),
  ('submodule', 'function')
])),
('LagrangeInterpolator', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/function/LagrangeInterpolator.h'),
  ('module', 'function'),
  ('submodule', 'function')
])),
('Lagrange', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/math/Lagrange.h'),
  ('module', 'function'),
  ('submodule', 'math')
])),
('Legendre', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/math/Legendre.h'),
  ('module', 'function'),
  ('submodule', 'math')
])),
('ALE', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/ale/ALE.h'),
  ('module', 'function'),
  ('submodule', 'ale')
])),
('MeshDisplacement', dict([
  ('bases', ['Expression', 'GenericFunction', 'Variable', 'ufc::function']),
  ('derived', []),
  ('header', 'dolfin/ale/MeshDisplacement.h'),
  ('module', 'function'),
  ('submodule', 'ale')
])),
('GenericDofMap', dict([
  ('bases', ['Variable']),
  ('derived', ['DofMap']),
  ('header', 'dolfin/fem/GenericDofMap.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('DofMap', dict([
  ('bases', ['GenericDofMap', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/fem/DofMap.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('Equation', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/fem/Equation.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('FiniteElement', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/fem/FiniteElement.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('BasisFunction', dict([
  ('bases', ['ufc::function']),
  ('derived', []),
  ('header', 'dolfin/fem/BasisFunction.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('DiscreteOperators', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/fem/DiscreteOperators.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('DirichletBC', dict([
  ('bases', ['Hierarchical', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/fem/DirichletBC.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('PointSource', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/fem/PointSource.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('LocalAssembler', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/fem/LocalAssembler.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('LocalSolver', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/fem/LocalSolver.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('Form', dict([
  ('bases', ['Hierarchical']),
  ('derived', ['GoalFunctional']),
  ('header', 'dolfin/fem/Form.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('AssemblerBase', dict([
  ('bases', []),
  ('derived', ['Assembler', 'MultiMeshAssembler', 'OpenMpAssembler', 'SystemAssembler']),
  ('header', 'dolfin/fem/AssemblerBase.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('Assembler', dict([
  ('bases', ['AssemblerBase']),
  ('derived', []),
  ('header', 'dolfin/fem/Assembler.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('SparsityPatternBuilder', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/fem/SparsityPatternBuilder.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('SystemAssembler', dict([
  ('bases', ['AssemblerBase']),
  ('derived', []),
  ('header', 'dolfin/fem/SystemAssembler.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('LinearVariationalProblem', dict([
  ('bases', ['Hierarchical']),
  ('derived', []),
  ('header', 'dolfin/fem/LinearVariationalProblem.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('LinearVariationalSolver', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/fem/LinearVariationalSolver.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('NonlinearVariationalProblem', dict([
  ('bases', ['Hierarchical']),
  ('derived', []),
  ('header', 'dolfin/fem/NonlinearVariationalProblem.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('NonlinearVariationalSolver', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/fem/NonlinearVariationalSolver.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('MultiMeshAssembler', dict([
  ('bases', ['AssemblerBase']),
  ('derived', []),
  ('header', 'dolfin/fem/MultiMeshAssembler.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('MultiMeshDirichletBC', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/fem/MultiMeshDirichletBC.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('MultiMeshDofMap', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/fem/MultiMeshDofMap.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('MultiMeshForm', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/fem/MultiMeshForm.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('OpenMpAssembler', dict([
  ('bases', ['AssemblerBase']),
  ('derived', []),
  ('header', 'dolfin/fem/OpenMpAssembler.h'),
  ('module', 'fem'),
  ('submodule', 'fem')
])),
('MultiStageScheme', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/multistage/MultiStageScheme.h'),
  ('module', 'fem'),
  ('submodule', 'multistage')
])),
('RKSolver', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/multistage/RKSolver.h'),
  ('module', 'fem'),
  ('submodule', 'multistage')
])),
('PointIntegralSolver', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/multistage/PointIntegralSolver.h'),
  ('module', 'fem'),
  ('submodule', 'multistage')
])),
('GenericAdaptiveVariationalSolver', dict([
  ('bases', ['Variable']),
  ('derived', ['AdaptiveLinearVariationalSolver', 'AdaptiveNonlinearVariationalSolver']),
  ('header', 'dolfin/adaptivity/GenericAdaptiveVariationalSolver.h'),
  ('module', 'fem'),
  ('submodule', 'adaptivity')
])),
('AdaptiveLinearVariationalSolver', dict([
  ('bases', ['GenericAdaptiveVariationalSolver', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/adaptivity/AdaptiveLinearVariationalSolver.h'),
  ('module', 'fem'),
  ('submodule', 'adaptivity')
])),
('AdaptiveNonlinearVariationalSolver', dict([
  ('bases', ['GenericAdaptiveVariationalSolver', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/adaptivity/AdaptiveNonlinearVariationalSolver.h'),
  ('module', 'fem'),
  ('submodule', 'adaptivity')
])),
('GoalFunctional', dict([
  ('bases', ['Form', 'Hierarchical']),
  ('derived', []),
  ('header', 'dolfin/adaptivity/GoalFunctional.h'),
  ('module', 'fem'),
  ('submodule', 'adaptivity')
])),
('ErrorControl', dict([
  ('bases', ['Hierarchical', 'Variable']),
  ('derived', []),
  ('header', 'dolfin/adaptivity/ErrorControl.h'),
  ('module', 'fem'),
  ('submodule', 'adaptivity')
])),
('Extrapolation', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/adaptivity/Extrapolation.h'),
  ('module', 'fem'),
  ('submodule', 'adaptivity')
])),
('TimeSeries', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/adaptivity/TimeSeries.h'),
  ('module', 'fem'),
  ('submodule', 'adaptivity')
])),
('VTKPlotter', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/plot/VTKPlotter.h'),
  ('module', 'io'),
  ('submodule', 'plot')
])),
('GenericFile', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/io/GenericFile.h'),
  ('module', 'io'),
  ('submodule', 'io')
])),
('File', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/io/File.h'),
  ('module', 'io'),
  ('submodule', 'io')
])),
('hid_t', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/io/XDMFFile.h'),
  ('module', 'io'),
  ('submodule', 'io')
])),
('XDMFFile', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/io/XDMFFile.h'),
  ('module', 'io'),
  ('submodule', 'io')
])),
('HDF5File', dict([
  ('bases', ['Variable']),
  ('derived', []),
  ('header', 'dolfin/io/HDF5File.h'),
  ('module', 'io'),
  ('submodule', 'io')
])),
('HDF5Attribute', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/io/HDF5Attribute.h'),
  ('module', 'io'),
  ('submodule', 'io')
])),
('X3DOM', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/io/X3DOM.h'),
  ('module', 'io'),
  ('submodule', 'io')
])),
('X3DOMParameters', dict([
  ('bases', []),
  ('derived', []),
  ('header', 'dolfin/io/X3DOM.h'),
  ('module', 'io'),
  ('submodule', 'io')
]))
])

# A map between modules and its submodules
module_to_submodules = OrderedDict([
('common', ['common', 'parameter', 'log']),
('mesh', ['mesh', 'generation', 'geometry', 'refinement', 'graph']),
('la', ['la', 'nls']),
('function', ['function', 'math', 'ale']),
('fem', ['fem', 'multistage', 'adaptivity']),
('io', ['plot', 'io'])
])

# A reverse map between submodules and modules
submodule_info = OrderedDict([
('common', dict([
  ('has_post', True),
  ('has_pre', True),
  ('headers', ['dolfin/common/init.h', 'dolfin/common/defines.h', 'dolfin/common/version.h', 'dolfin/common/types.h', 'dolfin/common/constants.h', 'dolfin/common/timing.h', 'dolfin/common/Array.h', 'dolfin/common/ArrayView.h', 'dolfin/common/IndexSet.h', 'dolfin/common/Set.h', 'dolfin/common/Timer.h', 'dolfin/common/Variable.h', 'dolfin/common/Hierarchical.h', 'dolfin/common/MPI.h', 'dolfin/common/SubSystemsManager.h']),
  ('module', 'common')
])),
('parameter', dict([
  ('has_post', True),
  ('has_pre', True),
  ('headers', ['dolfin/parameter/Parameter.h', 'dolfin/parameter/Parameters.h', 'dolfin/parameter/GlobalParameters.h']),
  ('module', 'common')
])),
('log', dict([
  ('has_post', True),
  ('has_pre', True),
  ('headers', ['dolfin/log/log.h', 'dolfin/log/Event.h', 'dolfin/log/Progress.h', 'dolfin/log/Table.h', 'dolfin/log/LogLevel.h']),
  ('module', 'common')
])),
('mesh', dict([
  ('has_post', True),
  ('has_pre', True),
  ('headers', ['dolfin/mesh/CellType.h', 'dolfin/mesh/MeshTopology.h', 'dolfin/mesh/MeshGeometry.h', 'dolfin/mesh/MeshDomains.h', 'dolfin/mesh/MeshData.h', 'dolfin/mesh/Mesh.h', 'dolfin/mesh/MeshEntity.h', 'dolfin/mesh/MeshEntityIterator.h', 'dolfin/mesh/MeshEntityIteratorBase.h', 'dolfin/mesh/SubsetIterator.h', 'dolfin/mesh/Vertex.h', 'dolfin/mesh/Edge.h', 'dolfin/mesh/Face.h', 'dolfin/mesh/Facet.h', 'dolfin/mesh/Cell.h', 'dolfin/mesh/FacetCell.h', 'dolfin/mesh/MeshConnectivity.h', 'dolfin/mesh/MeshEditor.h', 'dolfin/mesh/DynamicMeshEditor.h', 'dolfin/mesh/LocalMeshValueCollection.h', 'dolfin/mesh/MeshFunction.h', 'dolfin/mesh/MeshValueCollection.h', 'dolfin/mesh/MeshColoring.h', 'dolfin/mesh/MeshRenumbering.h', 'dolfin/mesh/MeshTransformation.h', 'dolfin/mesh/LocalMeshData.h', 'dolfin/mesh/SubDomain.h', 'dolfin/mesh/SubMesh.h', 'dolfin/mesh/DomainBoundary.h', 'dolfin/mesh/BoundaryMesh.h', 'dolfin/mesh/PeriodicBoundaryComputation.h', 'dolfin/mesh/MeshQuality.h', 'dolfin/mesh/MultiMesh.h', 'dolfin/mesh/MeshHierarchy.h', 'dolfin/mesh/MeshPartitioning.h']),
  ('module', 'mesh')
])),
('generation', dict([
  ('has_post', True),
  ('has_pre', False),
  ('headers', ['dolfin/generation/BoxMesh.h', 'dolfin/generation/IntervalMesh.h', 'dolfin/generation/RectangleMesh.h', 'dolfin/generation/UnitTetrahedronMesh.h', 'dolfin/generation/UnitCubeMesh.h', 'dolfin/generation/UnitIntervalMesh.h', 'dolfin/generation/UnitTriangleMesh.h', 'dolfin/generation/UnitSquareMesh.h', 'dolfin/generation/UnitQuadMesh.h', 'dolfin/generation/UnitHexMesh.h', 'dolfin/generation/UnitDiscMesh.h', 'dolfin/generation/SphericalShellMesh.h']),
  ('module', 'mesh')
])),
('geometry', dict([
  ('has_post', True),
  ('has_pre', True),
  ('headers', ['dolfin/geometry/Point.h', 'dolfin/geometry/BoundingBoxTree.h', 'dolfin/geometry/GenericBoundingBoxTree.h', 'dolfin/geometry/BoundingBoxTree3D.h', 'dolfin/geometry/MeshPointIntersection.h', 'dolfin/geometry/intersect.h']),
  ('module', 'mesh')
])),
('refinement', dict([
  ('has_post', False),
  ('has_pre', False),
  ('headers', ['dolfin/refinement/refine.h']),
  ('module', 'mesh')
])),
('graph', dict([
  ('has_post', True),
  ('has_pre', True),
  ('headers', ['dolfin/graph/Graph.h', 'dolfin/graph/GraphBuilder.h', 'dolfin/graph/BoostGraphOrdering.h', 'dolfin/graph/SCOTCH.h']),
  ('module', 'mesh')
])),
('la', dict([
  ('has_post', True),
  ('has_pre', True),
  ('headers', ['dolfin/la/LinearAlgebraObject.h', 'dolfin/la/GenericLinearOperator.h', 'dolfin/la/GenericTensor.h', 'dolfin/la/GenericMatrix.h', 'dolfin/la/GenericVector.h', 'dolfin/la/VectorSpaceBasis.h', 'dolfin/la/GenericLinearSolver.h', 'dolfin/la/GenericLUSolver.h', 'dolfin/la/PETScOptions.h', 'dolfin/la/PETScObject.h', 'dolfin/la/PETScBaseMatrix.h', 'dolfin/la/EigenMatrix.h', 'dolfin/la/PETScMatrix.h', 'dolfin/la/PETScLinearOperator.h', 'dolfin/la/PETScPreconditioner.h', 'dolfin/la/TpetraMatrix.h', 'dolfin/la/EigenKrylovSolver.h', 'dolfin/la/EigenLUSolver.h', 'dolfin/la/PETScKrylovSolver.h', 'dolfin/la/PETScLUSolver.h', 'dolfin/la/BelosKrylovSolver.h', 'dolfin/la/TrilinosPreconditioner.h', 'dolfin/la/MueluPreconditioner.h', 'dolfin/la/Ifpack2Preconditioner.h', 'dolfin/la/CoordinateMatrix.h', 'dolfin/la/EigenVector.h', 'dolfin/la/PETScVector.h', 'dolfin/la/TpetraVector.h', 'dolfin/la/TensorLayout.h', 'dolfin/la/SparsityPattern.h', 'dolfin/la/IndexMap.h', 'dolfin/la/GenericLinearAlgebraFactory.h', 'dolfin/la/DefaultFactory.h', 'dolfin/la/EigenFactory.h', 'dolfin/la/PETScUserPreconditioner.h', 'dolfin/la/PETScFactory.h', 'dolfin/la/TpetraFactory.h', 'dolfin/la/SLEPcEigenSolver.h', 'dolfin/la/Vector.h', 'dolfin/la/Matrix.h', 'dolfin/la/Scalar.h', 'dolfin/la/LinearSolver.h', 'dolfin/la/KrylovSolver.h', 'dolfin/la/LUSolver.h', 'dolfin/la/solve.h', 'dolfin/la/test_nullspace.h', 'dolfin/la/BlockVector.h', 'dolfin/la/BlockMatrix.h', 'dolfin/la/LinearOperator.h']),
  ('module', 'la')
])),
('nls', dict([
  ('has_post', False),
  ('has_pre', True),
  ('headers', ['dolfin/nls/NonlinearProblem.h', 'dolfin/nls/NewtonSolver.h', 'dolfin/nls/OptimisationProblem.h', 'dolfin/nls/PETScSNESSolver.h', 'dolfin/nls/PETScTAOSolver.h', 'dolfin/nls/TAOLinearBoundSolver.h']),
  ('module', 'la')
])),
('function', dict([
  ('has_post', True),
  ('has_pre', True),
  ('headers', ['dolfin/function/GenericFunction.h', 'dolfin/function/Expression.h', 'dolfin/function/FunctionAXPY.h', 'dolfin/function/Function.h', 'dolfin/function/FunctionSpace.h', 'dolfin/function/Constant.h', 'dolfin/function/SpecialFunctions.h', 'dolfin/function/SpecialFacetFunction.h', 'dolfin/function/MultiMeshFunction.h', 'dolfin/function/MultiMeshFunctionSpace.h', 'dolfin/function/MultiMeshSubSpace.h', 'dolfin/function/FunctionAssigner.h', 'dolfin/function/assign.h', 'dolfin/function/LagrangeInterpolator.h']),
  ('module', 'function')
])),
('math', dict([
  ('has_post', False),
  ('has_pre', False),
  ('headers', ['dolfin/math/basic.h', 'dolfin/math/Lagrange.h', 'dolfin/math/Legendre.h']),
  ('module', 'function')
])),
('ale', dict([
  ('has_post', False),
  ('has_pre', True),
  ('headers', ['dolfin/ale/ALE.h', 'dolfin/ale/MeshDisplacement.h']),
  ('module', 'function')
])),
('fem', dict([
  ('has_post', True),
  ('has_pre', True),
  ('headers', ['dolfin/fem/GenericDofMap.h', 'dolfin/fem/DofMap.h', 'dolfin/fem/fem_utils.h', 'dolfin/fem/Equation.h', 'dolfin/fem/FiniteElement.h', 'dolfin/fem/BasisFunction.h', 'dolfin/fem/DiscreteOperators.h', 'dolfin/fem/DirichletBC.h', 'dolfin/fem/PointSource.h', 'dolfin/fem/assemble.h', 'dolfin/fem/assemble_local.h', 'dolfin/fem/LocalAssembler.h', 'dolfin/fem/LocalSolver.h', 'dolfin/fem/solve.h', 'dolfin/fem/Form.h', 'dolfin/fem/AssemblerBase.h', 'dolfin/fem/Assembler.h', 'dolfin/fem/SparsityPatternBuilder.h', 'dolfin/fem/SystemAssembler.h', 'dolfin/fem/LinearVariationalProblem.h', 'dolfin/fem/LinearVariationalSolver.h', 'dolfin/fem/NonlinearVariationalProblem.h', 'dolfin/fem/NonlinearVariationalSolver.h', 'dolfin/fem/MultiMeshAssembler.h', 'dolfin/fem/MultiMeshDirichletBC.h', 'dolfin/fem/MultiMeshDofMap.h', 'dolfin/fem/MultiMeshForm.h', 'dolfin/fem/OpenMpAssembler.h']),
  ('module', 'fem')
])),
('multistage', dict([
  ('has_post', False),
  ('has_pre', True),
  ('headers', ['dolfin/multistage/MultiStageScheme.h', 'dolfin/multistage/RKSolver.h', 'dolfin/multistage/PointIntegralSolver.h']),
  ('module', 'fem')
])),
('adaptivity', dict([
  ('has_post', True),
  ('has_pre', True),
  ('headers', ['dolfin/adaptivity/GenericAdaptiveVariationalSolver.h', 'dolfin/adaptivity/AdaptiveLinearVariationalSolver.h', 'dolfin/adaptivity/AdaptiveNonlinearVariationalSolver.h', 'dolfin/adaptivity/GoalFunctional.h', 'dolfin/adaptivity/ErrorControl.h', 'dolfin/adaptivity/Extrapolation.h', 'dolfin/adaptivity/TimeSeries.h', 'dolfin/adaptivity/adapt.h', 'dolfin/adaptivity/marking.h', 'dolfin/adaptivity/adaptivesolve.h']),
  ('module', 'fem')
])),
('plot', dict([
  ('has_post', False),
  ('has_pre', True),
  ('headers', ['dolfin/plot/plot.h', 'dolfin/plot/VTKPlotter.h']),
  ('module', 'io')
])),
('io', dict([
  ('has_post', True),
  ('has_pre', True),
  ('headers', ['dolfin/io/GenericFile.h', 'dolfin/io/File.h', 'dolfin/io/XDMFFile.h', 'dolfin/io/HDF5File.h', 'dolfin/io/HDF5Attribute.h', 'dolfin/io/X3DOM.h']),
  ('module', 'io')
]))
])
