// This code conforms with the UFC specification version 2016.1.0
// and was automatically generated by FFC version 2016.1.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   optimize:                       True
//   precision:                      15
//   quadrature_degree:              -1
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __FORMS_H
#define __FORMS_H
#include <stdexcept>
#include <ufc.h>

class forms_finite_element_0: public ufc::finite_element
{
public:

  forms_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  ~forms_finite_element_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Lagrange', triangle, 1)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::triangle;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t geometric_dimension() const final override
  {
    return 2;
  }

  std::size_t space_dimension() const final override
  {
    return 3;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 1;
  }

  const char * family() const final override
  {
    return "Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 3; r++)
    {
      _evaluate_basis(r, &dof_values, x, coordinate_dofs, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[2][1];
    for (unsigned int row = 0; row < 2; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[2][2];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[2];
    for (unsigned int r = 0; r < 2; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 3; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new forms_finite_element_0();
  }

};


class forms_finite_element_1: public ufc::finite_element
{
public:

  forms_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  ~forms_finite_element_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "VectorElement(FiniteElement('Lagrange', triangle, 1), dim=2)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::triangle;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t geometric_dimension() const final override
  {
    return 2;
  }

  std::size_t space_dimension() const final override
  {
    return 6;
  }

  std::size_t value_rank() const final override
  {
    return 1;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  std::size_t value_size() const final override
  {
    return 2;
  }

  std::size_t reference_value_rank() const final override
  {
    return 1;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  std::size_t reference_value_size() const final override
  {
    return 2;
  }

  std::size_t degree() const final override
  {
    return 1;
  }

  const char * family() const final override
  {
    return "Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis(r, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[2][1];
    for (unsigned int row = 0; row < 2; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[2][2];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 6; r++)
    {
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[4];
    for (unsigned int r = 0; r < 4; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 4:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[3] = vals[1];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[4] = vals[1];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[5] = vals[1];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[2] = dof_values[1];
    vertex_values[4] = dof_values[2];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[3];
    vertex_values[3] = dof_values[4];
    vertex_values[5] = dof_values[5];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[0];
    dof_coordinates[7] = coordinate_dofs[1];
    dof_coordinates[8] = coordinate_dofs[2];
    dof_coordinates[9] = coordinate_dofs[3];
    dof_coordinates[10] = coordinate_dofs[4];
    dof_coordinates[11] = coordinate_dofs[5];
  }

  std::size_t num_sub_elements() const final override
  {
    return 2;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new forms_finite_element_0();
        break;
      }
    case 1:
      {
        return new forms_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new forms_finite_element_1();
  }

};


class forms_finite_element_2: public ufc::finite_element
{
public:

  forms_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  ~forms_finite_element_2() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Nedelec 1st kind H(curl)', triangle, 3)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::triangle;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t geometric_dimension() const final override
  {
    return 2;
  }

  std::size_t space_dimension() const final override
  {
    return 15;
  }

  std::size_t value_rank() const final override
  {
    return 1;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  std::size_t value_size() const final override
  {
    return 2;
  }

  std::size_t reference_value_rank() const final override
  {
    return 1;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  std::size_t reference_value_size() const final override
  {
    return 2;
  }

  std::size_t degree() const final override
  {
    return 3;
  }

  const char * family() const final override
  {
    return "Nedelec 1st kind H(curl)";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, -0.169533172561123, 0.0841793787126843, -0.11664236870396, 0.0, -0.146820034222103, 0.0729014804399754, -0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.321678327423669, -0.134687005940295, 0.0972019739199672, 0.260579710864614, -0.12987926104263, 0.0976879837895672, -0.0631345340345131};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      } // end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
      values[1] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.078246079643595, -0.168358757425368, 0.349927106111882, 0.0, 0.0677630927178938, -0.145802960879951, 0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, -0.16518616813648, 0.235702260395516, -0.272165526975909, -0.120267558860591, 0.146820034222104, -0.224536559755125, 0.176776695296637};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      } // end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
      values[1] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, -0.0391230398217976, -0.0841793787126843, -0.349927106111882, 0.0, -0.033881546358947, -0.0729014804399755, -0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.0608580619450188, 0.0, 0.213844342623929, 0.0601337794302956, 0.0395284707521045, 0.112268279877563, -0.138895974875929};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      } // end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
      values[1] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.169533172561123, 0.0841793787126841, 0.116642368703961, 0.0, 0.146820034222103, 0.0729014804399755, 0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.491211499984792, 0.218866384652979, 0.213844342623928, -0.260579710864614, 0.0169407731794734, -0.0247865033495917, 0.0378807204207079};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      } // end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
      values[1] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, -0.0782460796435953, -0.168358757425368, -0.349927106111882, 0.0, -0.067763092717894, -0.145802960879951, -0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, -0.243432247780074, -0.404061017820884, -0.622092633087791, 0.120267558860591, 0.0790569415042094, 0.0787335988751738, -0.126269068069027};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      } // end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
      values[1] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.0391230398217974, -0.084179378712684, 0.349927106111882, 0.0, 0.0338815463589468, -0.0729014804399754, 0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.0999811017668155, -0.0841793787126837, 0.563771448735811, -0.0601337794302957, 0.0734100171110521, -0.185169760317538, 0.164149788489734};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      } // end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
      values[1] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.382536389368687, 0.303045763365663, 0.311046316543896, 0.0, -0.0903507902905252, -0.145802960879951, -0.202030508910442};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.169533172561123, 0.0841793787126839, 0.116642368703961, 0.160356745147454, 0.0677630927178938, 0.0320766513935894, -0.0757614408414161};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      } // end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
      values[1] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, -0.765072778737375, 0.0, -0.155523158271948, 0.0, 0.18070158058105, 0.0, 0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, -0.382536389368687, 0.0673435029701476, -0.0777615791359738, -0.320713490294909, 0.0903507902905254, -0.0641533027871787, 0.0505076272276106};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      } // end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
      values[1] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.382536389368687, -0.303045763365664, 0.311046316543896, 0.0, -0.090350790290525, 0.145802960879951, -0.202030508910442};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.213003216807565, -0.21886638465298, 0.194403947839935, 0.160356745147455, -0.15811388300842, 0.177879612273541, -0.126269068069027};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      } // end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
      values[1] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {3.99999999999986, 0.0, 0.0, -0.368855556781646, -0.476190476190459, -1.64957219768459, 0.0, -0.31943828249996, -0.412393049421147, 0.571428571428549};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.614759261302741, 0.476190476190461, -0.549857399228195, 0.566946709513821, 0.159719141249981, -0.453632354363262, 0.357142857142845};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      } // end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
      values[1] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 3.99999999999986, 0.0, -0.677630927178917, 1.80795671491133, 0.0, 0.0, -0.586845597326944, -1.26269068069022, 0.0};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 1.05409255338942, 1.16642368703957, -0.336717514850724, 1.04154761224408, 0.684653196881437, -0.580837713117501, 0.218704441319919};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      } // end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
      values[1] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 3.99999999999986, 0.13041013273932, -0.841793787126808, 0.933138949631659, 0.0, 0.112938487863152, -0.72901480439973, -2.02030508910435};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, -0.347760353971518, 0.336717514850726, 1.3608276348795, -0.200445931434311, 0.621161683247338, 0.597792139607781, -0.883883476483157};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      } // end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
      values[1] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
        break;
      }
    case 12:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.0, 0.952380952380918, 0.0, 0.0, 0.0, 0.824786098842294, 0.0};
      
      static const double coefficients1[10] = \
      {3.99999999999986, 0.0, 0.0, -1.59837407938713, 0.476190476190459, -0.549857399228198, 0.0, -0.63887656499992, 0.412393049421147, -0.142857142857138};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      } // end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
      values[1] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
        break;
      }
    case 13:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 1.35526185435783, 0.0, 0.0, 0.0, 1.17369119465389, 0.0, 0.0};
      
      static const double coefficients1[10] = \
      {0.0, 3.99999999999986, 0.0, 0.677630927178915, -0.524890659167806, 0.0, -2.08309522448817, 0.586845597326943, -0.101015254455218, 0.0};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      } // end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
      values[1] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
        break;
      }
    case 14:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.0, 1.68358757425362, 0.0, 0.0, 0.0, 1.45802960879946, 0.0};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 3.99999999999986, 0.825930840682368, 0.84179378712681, -1.78851632012734, 0.0, -1.12938487863153, 0.72901480439973, -0.252538136138043};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      } // end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
      values[1] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 15; r++)
    {
      _evaluate_basis(r, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 3)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[8][3];
    for (unsigned int row = 0; row < 8; row++)
    {
      for (unsigned int col = 0; col < 3; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[8][8];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, -0.169533172561123, 0.0841793787126843, -0.11664236870396, 0.0, -0.146820034222103, 0.0729014804399754, -0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.321678327423669, -0.134687005940295, 0.0972019739199672, 0.260579710864614, -0.12987926104263, 0.0976879837895672, -0.0631345340345131};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, -4.61061686781004e-14, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004134, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025258, -0.912870929175281, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106457, 5.18459255872625, -1.49666295470956, 6.83130051063972, -1.05830052442583, 0.305505046330388, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749982, 2.19089023002068, 2.52982212813469, 8.08290376865477, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.6994845223857, 4.20000000000001, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000002, 0.0, -2.82842712474623, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare array of reference derivatives on physical element.
      double derivatives_p[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives_p[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.078246079643595, -0.168358757425368, 0.349927106111882, 0.0, 0.0677630927178938, -0.145802960879951, 0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, -0.16518616813648, 0.235702260395516, -0.272165526975909, -0.120267558860591, 0.146820034222104, -0.224536559755125, 0.176776695296637};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, -4.61061686781004e-14, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004134, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025258, -0.912870929175281, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106457, 5.18459255872625, -1.49666295470956, 6.83130051063972, -1.05830052442583, 0.305505046330388, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749982, 2.19089023002068, 2.52982212813469, 8.08290376865477, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.6994845223857, 4.20000000000001, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000002, 0.0, -2.82842712474623, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare array of reference derivatives on physical element.
      double derivatives_p[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives_p[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, -0.0391230398217976, -0.0841793787126843, -0.349927106111882, 0.0, -0.033881546358947, -0.0729014804399755, -0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.0608580619450188, 0.0, 0.213844342623929, 0.0601337794302956, 0.0395284707521045, 0.112268279877563, -0.138895974875929};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, -4.61061686781004e-14, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004134, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025258, -0.912870929175281, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106457, 5.18459255872625, -1.49666295470956, 6.83130051063972, -1.05830052442583, 0.305505046330388, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749982, 2.19089023002068, 2.52982212813469, 8.08290376865477, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.6994845223857, 4.20000000000001, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000002, 0.0, -2.82842712474623, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare array of reference derivatives on physical element.
      double derivatives_p[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives_p[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.169533172561123, 0.0841793787126841, 0.116642368703961, 0.0, 0.146820034222103, 0.0729014804399755, 0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.491211499984792, 0.218866384652979, 0.213844342623928, -0.260579710864614, 0.0169407731794734, -0.0247865033495917, 0.0378807204207079};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, -4.61061686781004e-14, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004134, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025258, -0.912870929175281, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106457, 5.18459255872625, -1.49666295470956, 6.83130051063972, -1.05830052442583, 0.305505046330388, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749982, 2.19089023002068, 2.52982212813469, 8.08290376865477, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.6994845223857, 4.20000000000001, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000002, 0.0, -2.82842712474623, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare array of reference derivatives on physical element.
      double derivatives_p[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives_p[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, -0.0782460796435953, -0.168358757425368, -0.349927106111882, 0.0, -0.067763092717894, -0.145802960879951, -0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, -0.243432247780074, -0.404061017820884, -0.622092633087791, 0.120267558860591, 0.0790569415042094, 0.0787335988751738, -0.126269068069027};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, -4.61061686781004e-14, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004134, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025258, -0.912870929175281, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106457, 5.18459255872625, -1.49666295470956, 6.83130051063972, -1.05830052442583, 0.305505046330388, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749982, 2.19089023002068, 2.52982212813469, 8.08290376865477, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.6994845223857, 4.20000000000001, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000002, 0.0, -2.82842712474623, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare array of reference derivatives on physical element.
      double derivatives_p[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives_p[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.0391230398217974, -0.084179378712684, 0.349927106111882, 0.0, 0.0338815463589468, -0.0729014804399754, 0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.0999811017668155, -0.0841793787126837, 0.563771448735811, -0.0601337794302957, 0.0734100171110521, -0.185169760317538, 0.164149788489734};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, -4.61061686781004e-14, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004134, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025258, -0.912870929175281, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106457, 5.18459255872625, -1.49666295470956, 6.83130051063972, -1.05830052442583, 0.305505046330388, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749982, 2.19089023002068, 2.52982212813469, 8.08290376865477, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.6994845223857, 4.20000000000001, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000002, 0.0, -2.82842712474623, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare array of reference derivatives on physical element.
      double derivatives_p[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives_p[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.382536389368687, 0.303045763365663, 0.311046316543896, 0.0, -0.0903507902905252, -0.145802960879951, -0.202030508910442};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.169533172561123, 0.0841793787126839, 0.116642368703961, 0.160356745147454, 0.0677630927178938, 0.0320766513935894, -0.0757614408414161};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, -4.61061686781004e-14, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004134, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025258, -0.912870929175281, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106457, 5.18459255872625, -1.49666295470956, 6.83130051063972, -1.05830052442583, 0.305505046330388, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749982, 2.19089023002068, 2.52982212813469, 8.08290376865477, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.6994845223857, 4.20000000000001, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000002, 0.0, -2.82842712474623, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare array of reference derivatives on physical element.
      double derivatives_p[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives_p[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, -0.765072778737375, 0.0, -0.155523158271948, 0.0, 0.18070158058105, 0.0, 0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, -0.382536389368687, 0.0673435029701476, -0.0777615791359738, -0.320713490294909, 0.0903507902905254, -0.0641533027871787, 0.0505076272276106};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, -4.61061686781004e-14, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004134, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025258, -0.912870929175281, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106457, 5.18459255872625, -1.49666295470956, 6.83130051063972, -1.05830052442583, 0.305505046330388, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749982, 2.19089023002068, 2.52982212813469, 8.08290376865477, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.6994845223857, 4.20000000000001, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000002, 0.0, -2.82842712474623, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare array of reference derivatives on physical element.
      double derivatives_p[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives_p[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.382536389368687, -0.303045763365664, 0.311046316543896, 0.0, -0.090350790290525, 0.145802960879951, -0.202030508910442};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.213003216807565, -0.21886638465298, 0.194403947839935, 0.160356745147455, -0.15811388300842, 0.177879612273541, -0.126269068069027};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, -4.61061686781004e-14, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004134, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025258, -0.912870929175281, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106457, 5.18459255872625, -1.49666295470956, 6.83130051063972, -1.05830052442583, 0.305505046330388, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749982, 2.19089023002068, 2.52982212813469, 8.08290376865477, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.6994845223857, 4.20000000000001, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000002, 0.0, -2.82842712474623, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare array of reference derivatives on physical element.
      double derivatives_p[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives_p[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {3.99999999999986, 0.0, 0.0, -0.368855556781646, -0.476190476190459, -1.64957219768459, 0.0, -0.31943828249996, -0.412393049421147, 0.571428571428549};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.614759261302741, 0.476190476190461, -0.549857399228195, 0.566946709513821, 0.159719141249981, -0.453632354363262, 0.357142857142845};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, -4.61061686781004e-14, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004134, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025258, -0.912870929175281, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106457, 5.18459255872625, -1.49666295470956, 6.83130051063972, -1.05830052442583, 0.305505046330388, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749982, 2.19089023002068, 2.52982212813469, 8.08290376865477, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.6994845223857, 4.20000000000001, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000002, 0.0, -2.82842712474623, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare array of reference derivatives on physical element.
      double derivatives_p[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives_p[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 3.99999999999986, 0.0, -0.677630927178917, 1.80795671491133, 0.0, 0.0, -0.586845597326944, -1.26269068069022, 0.0};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 1.05409255338942, 1.16642368703957, -0.336717514850724, 1.04154761224408, 0.684653196881437, -0.580837713117501, 0.218704441319919};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, -4.61061686781004e-14, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004134, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025258, -0.912870929175281, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106457, 5.18459255872625, -1.49666295470956, 6.83130051063972, -1.05830052442583, 0.305505046330388, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749982, 2.19089023002068, 2.52982212813469, 8.08290376865477, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.6994845223857, 4.20000000000001, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000002, 0.0, -2.82842712474623, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare array of reference derivatives on physical element.
      double derivatives_p[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives_p[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 3.99999999999986, 0.13041013273932, -0.841793787126808, 0.933138949631659, 0.0, 0.112938487863152, -0.72901480439973, -2.02030508910435};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, -0.347760353971518, 0.336717514850726, 1.3608276348795, -0.200445931434311, 0.621161683247338, 0.597792139607781, -0.883883476483157};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, -4.61061686781004e-14, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004134, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025258, -0.912870929175281, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106457, 5.18459255872625, -1.49666295470956, 6.83130051063972, -1.05830052442583, 0.305505046330388, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749982, 2.19089023002068, 2.52982212813469, 8.08290376865477, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.6994845223857, 4.20000000000001, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000002, 0.0, -2.82842712474623, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare array of reference derivatives on physical element.
      double derivatives_p[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives_p[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.0, 0.952380952380918, 0.0, 0.0, 0.0, 0.824786098842294, 0.0};
      
      static const double coefficients1[10] = \
      {3.99999999999986, 0.0, 0.0, -1.59837407938713, 0.476190476190459, -0.549857399228198, 0.0, -0.63887656499992, 0.412393049421147, -0.142857142857138};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, -4.61061686781004e-14, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004134, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025258, -0.912870929175281, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106457, 5.18459255872625, -1.49666295470956, 6.83130051063972, -1.05830052442583, 0.305505046330388, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749982, 2.19089023002068, 2.52982212813469, 8.08290376865477, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.6994845223857, 4.20000000000001, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000002, 0.0, -2.82842712474623, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare array of reference derivatives on physical element.
      double derivatives_p[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives_p[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 1.35526185435783, 0.0, 0.0, 0.0, 1.17369119465389, 0.0, 0.0};
      
      static const double coefficients1[10] = \
      {0.0, 3.99999999999986, 0.0, 0.677630927178915, -0.524890659167806, 0.0, -2.08309522448817, 0.586845597326943, -0.101015254455218, 0.0};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, -4.61061686781004e-14, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004134, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025258, -0.912870929175281, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106457, 5.18459255872625, -1.49666295470956, 6.83130051063972, -1.05830052442583, 0.305505046330388, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749982, 2.19089023002068, 2.52982212813469, 8.08290376865477, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.6994845223857, 4.20000000000001, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000002, 0.0, -2.82842712474623, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare array of reference derivatives on physical element.
      double derivatives_p[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives_p[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.0, 1.68358757425362, 0.0, 0.0, 0.0, 1.45802960879946, 0.0};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 3.99999999999986, 0.825930840682368, 0.84179378712681, -1.78851632012734, 0.0, -1.12938487863153, 0.72901480439973, -0.252538136138043};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, -4.61061686781004e-14, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004134, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025258, -0.912870929175281, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106457, 5.18459255872625, -1.49666295470956, 6.83130051063972, -1.05830052442583, 0.305505046330388, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749982, 2.19089023002068, 2.52982212813469, 8.08290376865477, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.6994845223857, 4.20000000000001, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000002, 0.0, -2.82842712474623, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare array of reference derivatives on physical element.
      double derivatives_p[16];
      for (unsigned int r = 0; r < 16; r++)
      {
        derivatives_p[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[2]*tmp_ref1);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[3]*tmp_ref1);
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 15; r++)
    {
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 3)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[16];
    for (unsigned int r = 0; r < 16; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 15; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[2];
    
    double result;
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    switch (i)
    {
    case 0:
      {
        y[0] = 0.75*coordinate_dofs[2] + 0.25*coordinate_dofs[4];
      y[1] = 0.75*coordinate_dofs[3] + 0.25*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J[0]*vals[0] + J[2]*vals[1]) + (J[1]*vals[0] + J[3]*vals[1]);
      return result;
        break;
      }
    case 1:
      {
        y[0] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[4];
      y[1] = 0.5*coordinate_dofs[3] + 0.5*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J[0]*vals[0] + J[2]*vals[1]) + (J[1]*vals[0] + J[3]*vals[1]);
      return result;
        break;
      }
    case 2:
      {
        y[0] = 0.25*coordinate_dofs[2] + 0.75*coordinate_dofs[4];
      y[1] = 0.25*coordinate_dofs[3] + 0.75*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J[0]*vals[0] + J[2]*vals[1]) + (J[1]*vals[0] + J[3]*vals[1]);
      return result;
        break;
      }
    case 3:
      {
        y[0] = 0.75*coordinate_dofs[0] + 0.25*coordinate_dofs[4];
      y[1] = 0.75*coordinate_dofs[1] + 0.25*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      result = (J[1]*vals[0] + J[3]*vals[1]);
      return result;
        break;
      }
    case 4:
      {
        y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[4];
      y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      result = (J[1]*vals[0] + J[3]*vals[1]);
      return result;
        break;
      }
    case 5:
      {
        y[0] = 0.25*coordinate_dofs[0] + 0.75*coordinate_dofs[4];
      y[1] = 0.25*coordinate_dofs[1] + 0.75*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      result = (J[1]*vals[0] + J[3]*vals[1]);
      return result;
        break;
      }
    case 6:
      {
        y[0] = 0.75*coordinate_dofs[0] + 0.25*coordinate_dofs[2];
      y[1] = 0.75*coordinate_dofs[1] + 0.25*coordinate_dofs[3];
      f.evaluate(vals, y, c);
      result = (J[0]*vals[0] + J[2]*vals[1]);
      return result;
        break;
      }
    case 7:
      {
        y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[2];
      y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[3];
      f.evaluate(vals, y, c);
      result = (J[0]*vals[0] + J[2]*vals[1]);
      return result;
        break;
      }
    case 8:
      {
        y[0] = 0.25*coordinate_dofs[0] + 0.75*coordinate_dofs[2];
      y[1] = 0.25*coordinate_dofs[1] + 0.75*coordinate_dofs[3];
      f.evaluate(vals, y, c);
      result = (J[0]*vals[0] + J[2]*vals[1]);
      return result;
        break;
      }
    case 9:
      {
        result = 0.0;
      double X_9[36][2] = {{0.0327753666145, 0.0293164271598}, {0.0287653330126, 0.148078599668}, {0.022386872978, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.00779187470129, 0.76923386203}, {0.00246669715267, 0.92694567132}, {0.164429241595, 0.0293164271598}, {0.14431148695, 0.148078599668}, {0.112311681781, 0.336984690281}, {0.0747589734626, 0.558671518772}, {0.0390907007328, 0.76923386203}, {0.0123750604174, 0.92694567132}, {0.369529924372, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.252403568077, 0.336984690281}, {0.168009519121, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.273318962107, 0.558671518772}, {0.142915682994, 0.76923386203}, {0.0452432465649, 0.92694567132}, {0.806254331245, 0.0293164271598}, {0.707609913381, 0.148078599668}, {0.550703627938, 0.336984690281}, {0.366569507766, 0.558671518772}, {0.191675437237, 0.76923386203}, {0.0606792682628, 0.92694567132}, {0.937908206226, 0.0293164271598}, {0.823156067319, 0.148078599668}, {0.640628436741, 0.336984690281}, {0.426426917862, 0.558671518772}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}};
      int D_9[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
      double W_9[36][1] = {{0.00438000703533}, {0.00821012828325}, {0.00852813657368}, {0.00597613827346}, {0.00266246789938}, {0.000529299521057}, {0.00922307258049}, {0.0172882391377}, {0.0179578758575}, {0.0125840795694}, {0.0056064144375}, {0.00111455709092}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.0163217665744}, {0.00727161547759}, {0.00144559962225}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.0163217665744}, {0.00727161547759}, {0.00144559962225}, {0.00922307258049}, {0.0172882391377}, {0.0179578758575}, {0.0125840795694}, {0.0056064144375}, {0.00111455709092}, {0.00438000703533}, {0.00821012828325}, {0.00852813657368}, {0.00597613827346}, {0.00266246789938}, {0.000529299521057}};
      double copy_9[2];
      // Loop over points
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_9[r][0] - X_9[r][1];
        const double w1 = X_9[r][0];
        const double w2 = X_9[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*coordinate_dofs[0] + w1*coordinate_dofs[2] + w2*coordinate_dofs[4];
        y[1] = w0*coordinate_dofs[1] + w1*coordinate_dofs[3] + w2*coordinate_dofs[5];
        // Evaluate function at physical point
        f.evaluate(vals, y, c);
        // Map function to reference element
        copy_9[0] = J[0]*vals[0] + J[2]*vals[1];
        copy_9[1] = J[1]*vals[0] + J[3]*vals[1];
        // Loop over directions
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_9[D_9[r][s]]*W_9[r][s];
        } // end loop over 's'
      } // end loop over 'r'
      return result;
        break;
      }
    case 10:
      {
        result = 0.0;
      double X_10[36][2] = {{0.0327753666145, 0.0293164271598}, {0.0287653330126, 0.148078599668}, {0.022386872978, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.00779187470129, 0.76923386203}, {0.00246669715267, 0.92694567132}, {0.164429241595, 0.0293164271598}, {0.14431148695, 0.148078599668}, {0.112311681781, 0.336984690281}, {0.0747589734626, 0.558671518772}, {0.0390907007328, 0.76923386203}, {0.0123750604174, 0.92694567132}, {0.369529924372, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.252403568077, 0.336984690281}, {0.168009519121, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.273318962107, 0.558671518772}, {0.142915682994, 0.76923386203}, {0.0452432465649, 0.92694567132}, {0.806254331245, 0.0293164271598}, {0.707609913381, 0.148078599668}, {0.550703627938, 0.336984690281}, {0.366569507766, 0.558671518772}, {0.191675437237, 0.76923386203}, {0.0606792682628, 0.92694567132}, {0.937908206226, 0.0293164271598}, {0.823156067319, 0.148078599668}, {0.640628436741, 0.336984690281}, {0.426426917862, 0.558671518772}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}};
      int D_10[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
      double W_10[36][1] = {{-0.00971097319454}, {-0.0159756941744}, {-0.0129148084988}, {-0.00602410954055}, {-0.00140335236045}, {-8.83197279225e-05}, {-0.014499997977}, {-0.0238542037517}, {-0.0192838239128}, {-0.0089949353583}, {-0.00209542400951}, {-0.000131875132445}, {-0.00678703358623}, {-0.0111654692844}, {-0.00902620543637}, {-0.00421027151037}, {-0.000980807938907}, {-6.17269708946e-05}, {0.00678703358623}, {0.0111654692844}, {0.00902620543637}, {0.00421027151037}, {0.000980807938907}, {6.17269708946e-05}, {0.014499997977}, {0.0238542037517}, {0.0192838239128}, {0.0089949353583}, {0.00209542400951}, {0.000131875132445}, {0.00971097319454}, {0.0159756941744}, {0.0129148084988}, {0.00602410954055}, {0.00140335236045}, {8.83197279225e-05}};
      double copy_10[2];
      // Loop over points
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_10[r][0] - X_10[r][1];
        const double w1 = X_10[r][0];
        const double w2 = X_10[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*coordinate_dofs[0] + w1*coordinate_dofs[2] + w2*coordinate_dofs[4];
        y[1] = w0*coordinate_dofs[1] + w1*coordinate_dofs[3] + w2*coordinate_dofs[5];
        // Evaluate function at physical point
        f.evaluate(vals, y, c);
        // Map function to reference element
        copy_10[0] = J[0]*vals[0] + J[2]*vals[1];
        copy_10[1] = J[1]*vals[0] + J[3]*vals[1];
        // Loop over directions
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_10[D_10[r][s]]*W_10[r][s];
        } // end loop over 's'
      } // end loop over 'r'
      return result;
        break;
      }
    case 11:
      {
        result = 0.0;
      double X_11[36][2] = {{0.0327753666145, 0.0293164271598}, {0.0287653330126, 0.148078599668}, {0.022386872978, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.00779187470129, 0.76923386203}, {0.00246669715267, 0.92694567132}, {0.164429241595, 0.0293164271598}, {0.14431148695, 0.148078599668}, {0.112311681781, 0.336984690281}, {0.0747589734626, 0.558671518772}, {0.0390907007328, 0.76923386203}, {0.0123750604174, 0.92694567132}, {0.369529924372, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.252403568077, 0.336984690281}, {0.168009519121, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.273318962107, 0.558671518772}, {0.142915682994, 0.76923386203}, {0.0452432465649, 0.92694567132}, {0.806254331245, 0.0293164271598}, {0.707609913381, 0.148078599668}, {0.550703627938, 0.336984690281}, {0.366569507766, 0.558671518772}, {0.191675437237, 0.76923386203}, {0.0606792682628, 0.92694567132}, {0.937908206226, 0.0293164271598}, {0.823156067319, 0.148078599668}, {0.640628436741, 0.336984690281}, {0.426426917862, 0.558671518772}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}};
      int D_11[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
      double W_11[36][1] = {{-0.0056494841656}, {-0.00645290853773}, {0.000132112736967}, {0.00571336122195}, {0.00492388644484}, {0.00133303229957}, {-0.0118962371707}, {-0.0135880247038}, {0.000278192558146}, {0.0120307444266}, {0.010368330848}, {0.00280699404177}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {0.0156040814239}, {0.0134479025608}, {0.00364071931307}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {0.0156040814239}, {0.0134479025608}, {0.00364071931307}, {-0.0118962371707}, {-0.0135880247038}, {0.000278192558146}, {0.0120307444266}, {0.010368330848}, {0.00280699404177}, {-0.0056494841656}, {-0.00645290853773}, {0.000132112736967}, {0.00571336122195}, {0.00492388644484}, {0.00133303229957}};
      double copy_11[2];
      // Loop over points
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_11[r][0] - X_11[r][1];
        const double w1 = X_11[r][0];
        const double w2 = X_11[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*coordinate_dofs[0] + w1*coordinate_dofs[2] + w2*coordinate_dofs[4];
        y[1] = w0*coordinate_dofs[1] + w1*coordinate_dofs[3] + w2*coordinate_dofs[5];
        // Evaluate function at physical point
        f.evaluate(vals, y, c);
        // Map function to reference element
        copy_11[0] = J[0]*vals[0] + J[2]*vals[1];
        copy_11[1] = J[1]*vals[0] + J[3]*vals[1];
        // Loop over directions
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_11[D_11[r][s]]*W_11[r][s];
        } // end loop over 's'
      } // end loop over 'r'
      return result;
        break;
      }
    case 12:
      {
        result = 0.0;
      double X_12[36][2] = {{0.0327753666145, 0.0293164271598}, {0.0287653330126, 0.148078599668}, {0.022386872978, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.00779187470129, 0.76923386203}, {0.00246669715267, 0.92694567132}, {0.164429241595, 0.0293164271598}, {0.14431148695, 0.148078599668}, {0.112311681781, 0.336984690281}, {0.0747589734626, 0.558671518772}, {0.0390907007328, 0.76923386203}, {0.0123750604174, 0.92694567132}, {0.369529924372, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.252403568077, 0.336984690281}, {0.168009519121, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.273318962107, 0.558671518772}, {0.142915682994, 0.76923386203}, {0.0452432465649, 0.92694567132}, {0.806254331245, 0.0293164271598}, {0.707609913381, 0.148078599668}, {0.550703627938, 0.336984690281}, {0.366569507766, 0.558671518772}, {0.191675437237, 0.76923386203}, {0.0606792682628, 0.92694567132}, {0.937908206226, 0.0293164271598}, {0.823156067319, 0.148078599668}, {0.640628436741, 0.336984690281}, {0.426426917862, 0.558671518772}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}};
      int D_12[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
      double W_12[36][1] = {{0.00438000703533}, {0.00821012828325}, {0.00852813657368}, {0.00597613827346}, {0.00266246789938}, {0.000529299521057}, {0.00922307258049}, {0.0172882391377}, {0.0179578758575}, {0.0125840795694}, {0.0056064144375}, {0.00111455709092}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.0163217665744}, {0.00727161547759}, {0.00144559962225}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.0163217665744}, {0.00727161547759}, {0.00144559962225}, {0.00922307258049}, {0.0172882391377}, {0.0179578758575}, {0.0125840795694}, {0.0056064144375}, {0.00111455709092}, {0.00438000703533}, {0.00821012828325}, {0.00852813657368}, {0.00597613827346}, {0.00266246789938}, {0.000529299521057}};
      double copy_12[2];
      // Loop over points
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_12[r][0] - X_12[r][1];
        const double w1 = X_12[r][0];
        const double w2 = X_12[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*coordinate_dofs[0] + w1*coordinate_dofs[2] + w2*coordinate_dofs[4];
        y[1] = w0*coordinate_dofs[1] + w1*coordinate_dofs[3] + w2*coordinate_dofs[5];
        // Evaluate function at physical point
        f.evaluate(vals, y, c);
        // Map function to reference element
        copy_12[0] = J[0]*vals[0] + J[2]*vals[1];
        copy_12[1] = J[1]*vals[0] + J[3]*vals[1];
        // Loop over directions
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_12[D_12[r][s]]*W_12[r][s];
        } // end loop over 's'
      } // end loop over 'r'
      return result;
        break;
      }
    case 13:
      {
        result = 0.0;
      double X_13[36][2] = {{0.0327753666145, 0.0293164271598}, {0.0287653330126, 0.148078599668}, {0.022386872978, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.00779187470129, 0.76923386203}, {0.00246669715267, 0.92694567132}, {0.164429241595, 0.0293164271598}, {0.14431148695, 0.148078599668}, {0.112311681781, 0.336984690281}, {0.0747589734626, 0.558671518772}, {0.0390907007328, 0.76923386203}, {0.0123750604174, 0.92694567132}, {0.369529924372, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.252403568077, 0.336984690281}, {0.168009519121, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.273318962107, 0.558671518772}, {0.142915682994, 0.76923386203}, {0.0452432465649, 0.92694567132}, {0.806254331245, 0.0293164271598}, {0.707609913381, 0.148078599668}, {0.550703627938, 0.336984690281}, {0.366569507766, 0.558671518772}, {0.191675437237, 0.76923386203}, {0.0606792682628, 0.92694567132}, {0.937908206226, 0.0293164271598}, {0.823156067319, 0.148078599668}, {0.640628436741, 0.336984690281}, {0.426426917862, 0.558671518772}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}};
      int D_13[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
      double W_13[36][1] = {{-0.00971097319454}, {-0.0159756941744}, {-0.0129148084988}, {-0.00602410954055}, {-0.00140335236045}, {-8.83197279225e-05}, {-0.014499997977}, {-0.0238542037517}, {-0.0192838239128}, {-0.0089949353583}, {-0.00209542400951}, {-0.000131875132445}, {-0.00678703358623}, {-0.0111654692844}, {-0.00902620543637}, {-0.00421027151037}, {-0.000980807938907}, {-6.17269708946e-05}, {0.00678703358623}, {0.0111654692844}, {0.00902620543637}, {0.00421027151037}, {0.000980807938907}, {6.17269708946e-05}, {0.014499997977}, {0.0238542037517}, {0.0192838239128}, {0.0089949353583}, {0.00209542400951}, {0.000131875132445}, {0.00971097319454}, {0.0159756941744}, {0.0129148084988}, {0.00602410954055}, {0.00140335236045}, {8.83197279225e-05}};
      double copy_13[2];
      // Loop over points
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_13[r][0] - X_13[r][1];
        const double w1 = X_13[r][0];
        const double w2 = X_13[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*coordinate_dofs[0] + w1*coordinate_dofs[2] + w2*coordinate_dofs[4];
        y[1] = w0*coordinate_dofs[1] + w1*coordinate_dofs[3] + w2*coordinate_dofs[5];
        // Evaluate function at physical point
        f.evaluate(vals, y, c);
        // Map function to reference element
        copy_13[0] = J[0]*vals[0] + J[2]*vals[1];
        copy_13[1] = J[1]*vals[0] + J[3]*vals[1];
        // Loop over directions
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_13[D_13[r][s]]*W_13[r][s];
        } // end loop over 's'
      } // end loop over 'r'
      return result;
        break;
      }
    case 14:
      {
        result = 0.0;
      double X_14[36][2] = {{0.0327753666145, 0.0293164271598}, {0.0287653330126, 0.148078599668}, {0.022386872978, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.00779187470129, 0.76923386203}, {0.00246669715267, 0.92694567132}, {0.164429241595, 0.0293164271598}, {0.14431148695, 0.148078599668}, {0.112311681781, 0.336984690281}, {0.0747589734626, 0.558671518772}, {0.0390907007328, 0.76923386203}, {0.0123750604174, 0.92694567132}, {0.369529924372, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.252403568077, 0.336984690281}, {0.168009519121, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.273318962107, 0.558671518772}, {0.142915682994, 0.76923386203}, {0.0452432465649, 0.92694567132}, {0.806254331245, 0.0293164271598}, {0.707609913381, 0.148078599668}, {0.550703627938, 0.336984690281}, {0.366569507766, 0.558671518772}, {0.191675437237, 0.76923386203}, {0.0606792682628, 0.92694567132}, {0.937908206226, 0.0293164271598}, {0.823156067319, 0.148078599668}, {0.640628436741, 0.336984690281}, {0.426426917862, 0.558671518772}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}};
      int D_14[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
      double W_14[36][1] = {{-0.0056494841656}, {-0.00645290853773}, {0.000132112736967}, {0.00571336122195}, {0.00492388644484}, {0.00133303229957}, {-0.0118962371707}, {-0.0135880247038}, {0.000278192558146}, {0.0120307444266}, {0.010368330848}, {0.00280699404177}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {0.0156040814239}, {0.0134479025608}, {0.00364071931307}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {0.0156040814239}, {0.0134479025608}, {0.00364071931307}, {-0.0118962371707}, {-0.0135880247038}, {0.000278192558146}, {0.0120307444266}, {0.010368330848}, {0.00280699404177}, {-0.0056494841656}, {-0.00645290853773}, {0.000132112736967}, {0.00571336122195}, {0.00492388644484}, {0.00133303229957}};
      double copy_14[2];
      // Loop over points
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_14[r][0] - X_14[r][1];
        const double w1 = X_14[r][0];
        const double w2 = X_14[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*coordinate_dofs[0] + w1*coordinate_dofs[2] + w2*coordinate_dofs[4];
        y[1] = w0*coordinate_dofs[1] + w1*coordinate_dofs[3] + w2*coordinate_dofs[5];
        // Evaluate function at physical point
        f.evaluate(vals, y, c);
        // Map function to reference element
        copy_14[0] = J[0]*vals[0] + J[2]*vals[1];
        copy_14[1] = J[1]*vals[0] + J[3]*vals[1];
        // Loop over directions
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_14[D_14[r][s]]*W_14[r][s];
        } // end loop over 's'
      } // end loop over 'r'
      return result;
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[2];
    
    double result;
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    y[0] = 0.75*coordinate_dofs[2] + 0.25*coordinate_dofs[4];
    y[1] = 0.75*coordinate_dofs[3] + 0.25*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J[0]*vals[0] + J[2]*vals[1]) + (J[1]*vals[0] + J[3]*vals[1]);
    values[0] = result;
    y[0] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[4];
    y[1] = 0.5*coordinate_dofs[3] + 0.5*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J[0]*vals[0] + J[2]*vals[1]) + (J[1]*vals[0] + J[3]*vals[1]);
    values[1] = result;
    y[0] = 0.25*coordinate_dofs[2] + 0.75*coordinate_dofs[4];
    y[1] = 0.25*coordinate_dofs[3] + 0.75*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J[0]*vals[0] + J[2]*vals[1]) + (J[1]*vals[0] + J[3]*vals[1]);
    values[2] = result;
    y[0] = 0.75*coordinate_dofs[0] + 0.25*coordinate_dofs[4];
    y[1] = 0.75*coordinate_dofs[1] + 0.25*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    result = (J[1]*vals[0] + J[3]*vals[1]);
    values[3] = result;
    y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[4];
    y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    result = (J[1]*vals[0] + J[3]*vals[1]);
    values[4] = result;
    y[0] = 0.25*coordinate_dofs[0] + 0.75*coordinate_dofs[4];
    y[1] = 0.25*coordinate_dofs[1] + 0.75*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    result = (J[1]*vals[0] + J[3]*vals[1]);
    values[5] = result;
    y[0] = 0.75*coordinate_dofs[0] + 0.25*coordinate_dofs[2];
    y[1] = 0.75*coordinate_dofs[1] + 0.25*coordinate_dofs[3];
    f.evaluate(vals, y, c);
    result = (J[0]*vals[0] + J[2]*vals[1]);
    values[6] = result;
    y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[2];
    y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[3];
    f.evaluate(vals, y, c);
    result = (J[0]*vals[0] + J[2]*vals[1]);
    values[7] = result;
    y[0] = 0.25*coordinate_dofs[0] + 0.75*coordinate_dofs[2];
    y[1] = 0.25*coordinate_dofs[1] + 0.75*coordinate_dofs[3];
    f.evaluate(vals, y, c);
    result = (J[0]*vals[0] + J[2]*vals[1]);
    values[8] = result;
    result = 0.0;
    double X_9[36][2] = {{0.0327753666145, 0.0293164271598}, {0.0287653330126, 0.148078599668}, {0.022386872978, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.00779187470129, 0.76923386203}, {0.00246669715267, 0.92694567132}, {0.164429241595, 0.0293164271598}, {0.14431148695, 0.148078599668}, {0.112311681781, 0.336984690281}, {0.0747589734626, 0.558671518772}, {0.0390907007328, 0.76923386203}, {0.0123750604174, 0.92694567132}, {0.369529924372, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.252403568077, 0.336984690281}, {0.168009519121, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.273318962107, 0.558671518772}, {0.142915682994, 0.76923386203}, {0.0452432465649, 0.92694567132}, {0.806254331245, 0.0293164271598}, {0.707609913381, 0.148078599668}, {0.550703627938, 0.336984690281}, {0.366569507766, 0.558671518772}, {0.191675437237, 0.76923386203}, {0.0606792682628, 0.92694567132}, {0.937908206226, 0.0293164271598}, {0.823156067319, 0.148078599668}, {0.640628436741, 0.336984690281}, {0.426426917862, 0.558671518772}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}};
    int D_9[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
    double W_9[36][1] = {{0.00438000703533}, {0.00821012828325}, {0.00852813657368}, {0.00597613827346}, {0.00266246789938}, {0.000529299521057}, {0.00922307258049}, {0.0172882391377}, {0.0179578758575}, {0.0125840795694}, {0.0056064144375}, {0.00111455709092}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.0163217665744}, {0.00727161547759}, {0.00144559962225}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.0163217665744}, {0.00727161547759}, {0.00144559962225}, {0.00922307258049}, {0.0172882391377}, {0.0179578758575}, {0.0125840795694}, {0.0056064144375}, {0.00111455709092}, {0.00438000703533}, {0.00821012828325}, {0.00852813657368}, {0.00597613827346}, {0.00266246789938}, {0.000529299521057}};
    double copy_9[2];
    // Loop over points
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_9[r][0] - X_9[r][1];
      const double w1 = X_9[r][0];
      const double w2 = X_9[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*coordinate_dofs[0] + w1*coordinate_dofs[2] + w2*coordinate_dofs[4];
      y[1] = w0*coordinate_dofs[1] + w1*coordinate_dofs[3] + w2*coordinate_dofs[5];
      // Evaluate function at physical point
      f.evaluate(vals, y, c);
      // Map function to reference element
      copy_9[0] = J[0]*vals[0] + J[2]*vals[1];
      copy_9[1] = J[1]*vals[0] + J[3]*vals[1];
      // Loop over directions
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_9[D_9[r][s]]*W_9[r][s];
      } // end loop over 's'
    } // end loop over 'r'
    values[9] = result;
    result = 0.0;
    double X_10[36][2] = {{0.0327753666145, 0.0293164271598}, {0.0287653330126, 0.148078599668}, {0.022386872978, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.00779187470129, 0.76923386203}, {0.00246669715267, 0.92694567132}, {0.164429241595, 0.0293164271598}, {0.14431148695, 0.148078599668}, {0.112311681781, 0.336984690281}, {0.0747589734626, 0.558671518772}, {0.0390907007328, 0.76923386203}, {0.0123750604174, 0.92694567132}, {0.369529924372, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.252403568077, 0.336984690281}, {0.168009519121, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.273318962107, 0.558671518772}, {0.142915682994, 0.76923386203}, {0.0452432465649, 0.92694567132}, {0.806254331245, 0.0293164271598}, {0.707609913381, 0.148078599668}, {0.550703627938, 0.336984690281}, {0.366569507766, 0.558671518772}, {0.191675437237, 0.76923386203}, {0.0606792682628, 0.92694567132}, {0.937908206226, 0.0293164271598}, {0.823156067319, 0.148078599668}, {0.640628436741, 0.336984690281}, {0.426426917862, 0.558671518772}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}};
    int D_10[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
    double W_10[36][1] = {{-0.00971097319454}, {-0.0159756941744}, {-0.0129148084988}, {-0.00602410954055}, {-0.00140335236045}, {-8.83197279225e-05}, {-0.014499997977}, {-0.0238542037517}, {-0.0192838239128}, {-0.0089949353583}, {-0.00209542400951}, {-0.000131875132445}, {-0.00678703358623}, {-0.0111654692844}, {-0.00902620543637}, {-0.00421027151037}, {-0.000980807938907}, {-6.17269708946e-05}, {0.00678703358623}, {0.0111654692844}, {0.00902620543637}, {0.00421027151037}, {0.000980807938907}, {6.17269708946e-05}, {0.014499997977}, {0.0238542037517}, {0.0192838239128}, {0.0089949353583}, {0.00209542400951}, {0.000131875132445}, {0.00971097319454}, {0.0159756941744}, {0.0129148084988}, {0.00602410954055}, {0.00140335236045}, {8.83197279225e-05}};
    double copy_10[2];
    // Loop over points
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_10[r][0] - X_10[r][1];
      const double w1 = X_10[r][0];
      const double w2 = X_10[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*coordinate_dofs[0] + w1*coordinate_dofs[2] + w2*coordinate_dofs[4];
      y[1] = w0*coordinate_dofs[1] + w1*coordinate_dofs[3] + w2*coordinate_dofs[5];
      // Evaluate function at physical point
      f.evaluate(vals, y, c);
      // Map function to reference element
      copy_10[0] = J[0]*vals[0] + J[2]*vals[1];
      copy_10[1] = J[1]*vals[0] + J[3]*vals[1];
      // Loop over directions
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_10[D_10[r][s]]*W_10[r][s];
      } // end loop over 's'
    } // end loop over 'r'
    values[10] = result;
    result = 0.0;
    double X_11[36][2] = {{0.0327753666145, 0.0293164271598}, {0.0287653330126, 0.148078599668}, {0.022386872978, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.00779187470129, 0.76923386203}, {0.00246669715267, 0.92694567132}, {0.164429241595, 0.0293164271598}, {0.14431148695, 0.148078599668}, {0.112311681781, 0.336984690281}, {0.0747589734626, 0.558671518772}, {0.0390907007328, 0.76923386203}, {0.0123750604174, 0.92694567132}, {0.369529924372, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.252403568077, 0.336984690281}, {0.168009519121, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.273318962107, 0.558671518772}, {0.142915682994, 0.76923386203}, {0.0452432465649, 0.92694567132}, {0.806254331245, 0.0293164271598}, {0.707609913381, 0.148078599668}, {0.550703627938, 0.336984690281}, {0.366569507766, 0.558671518772}, {0.191675437237, 0.76923386203}, {0.0606792682628, 0.92694567132}, {0.937908206226, 0.0293164271598}, {0.823156067319, 0.148078599668}, {0.640628436741, 0.336984690281}, {0.426426917862, 0.558671518772}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}};
    int D_11[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
    double W_11[36][1] = {{-0.0056494841656}, {-0.00645290853773}, {0.000132112736967}, {0.00571336122195}, {0.00492388644484}, {0.00133303229957}, {-0.0118962371707}, {-0.0135880247038}, {0.000278192558146}, {0.0120307444266}, {0.010368330848}, {0.00280699404177}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {0.0156040814239}, {0.0134479025608}, {0.00364071931307}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {0.0156040814239}, {0.0134479025608}, {0.00364071931307}, {-0.0118962371707}, {-0.0135880247038}, {0.000278192558146}, {0.0120307444266}, {0.010368330848}, {0.00280699404177}, {-0.0056494841656}, {-0.00645290853773}, {0.000132112736967}, {0.00571336122195}, {0.00492388644484}, {0.00133303229957}};
    double copy_11[2];
    // Loop over points
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_11[r][0] - X_11[r][1];
      const double w1 = X_11[r][0];
      const double w2 = X_11[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*coordinate_dofs[0] + w1*coordinate_dofs[2] + w2*coordinate_dofs[4];
      y[1] = w0*coordinate_dofs[1] + w1*coordinate_dofs[3] + w2*coordinate_dofs[5];
      // Evaluate function at physical point
      f.evaluate(vals, y, c);
      // Map function to reference element
      copy_11[0] = J[0]*vals[0] + J[2]*vals[1];
      copy_11[1] = J[1]*vals[0] + J[3]*vals[1];
      // Loop over directions
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_11[D_11[r][s]]*W_11[r][s];
      } // end loop over 's'
    } // end loop over 'r'
    values[11] = result;
    result = 0.0;
    double X_12[36][2] = {{0.0327753666145, 0.0293164271598}, {0.0287653330126, 0.148078599668}, {0.022386872978, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.00779187470129, 0.76923386203}, {0.00246669715267, 0.92694567132}, {0.164429241595, 0.0293164271598}, {0.14431148695, 0.148078599668}, {0.112311681781, 0.336984690281}, {0.0747589734626, 0.558671518772}, {0.0390907007328, 0.76923386203}, {0.0123750604174, 0.92694567132}, {0.369529924372, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.252403568077, 0.336984690281}, {0.168009519121, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.273318962107, 0.558671518772}, {0.142915682994, 0.76923386203}, {0.0452432465649, 0.92694567132}, {0.806254331245, 0.0293164271598}, {0.707609913381, 0.148078599668}, {0.550703627938, 0.336984690281}, {0.366569507766, 0.558671518772}, {0.191675437237, 0.76923386203}, {0.0606792682628, 0.92694567132}, {0.937908206226, 0.0293164271598}, {0.823156067319, 0.148078599668}, {0.640628436741, 0.336984690281}, {0.426426917862, 0.558671518772}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}};
    int D_12[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
    double W_12[36][1] = {{0.00438000703533}, {0.00821012828325}, {0.00852813657368}, {0.00597613827346}, {0.00266246789938}, {0.000529299521057}, {0.00922307258049}, {0.0172882391377}, {0.0179578758575}, {0.0125840795694}, {0.0056064144375}, {0.00111455709092}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.0163217665744}, {0.00727161547759}, {0.00144559962225}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.0163217665744}, {0.00727161547759}, {0.00144559962225}, {0.00922307258049}, {0.0172882391377}, {0.0179578758575}, {0.0125840795694}, {0.0056064144375}, {0.00111455709092}, {0.00438000703533}, {0.00821012828325}, {0.00852813657368}, {0.00597613827346}, {0.00266246789938}, {0.000529299521057}};
    double copy_12[2];
    // Loop over points
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_12[r][0] - X_12[r][1];
      const double w1 = X_12[r][0];
      const double w2 = X_12[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*coordinate_dofs[0] + w1*coordinate_dofs[2] + w2*coordinate_dofs[4];
      y[1] = w0*coordinate_dofs[1] + w1*coordinate_dofs[3] + w2*coordinate_dofs[5];
      // Evaluate function at physical point
      f.evaluate(vals, y, c);
      // Map function to reference element
      copy_12[0] = J[0]*vals[0] + J[2]*vals[1];
      copy_12[1] = J[1]*vals[0] + J[3]*vals[1];
      // Loop over directions
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_12[D_12[r][s]]*W_12[r][s];
      } // end loop over 's'
    } // end loop over 'r'
    values[12] = result;
    result = 0.0;
    double X_13[36][2] = {{0.0327753666145, 0.0293164271598}, {0.0287653330126, 0.148078599668}, {0.022386872978, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.00779187470129, 0.76923386203}, {0.00246669715267, 0.92694567132}, {0.164429241595, 0.0293164271598}, {0.14431148695, 0.148078599668}, {0.112311681781, 0.336984690281}, {0.0747589734626, 0.558671518772}, {0.0390907007328, 0.76923386203}, {0.0123750604174, 0.92694567132}, {0.369529924372, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.252403568077, 0.336984690281}, {0.168009519121, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.273318962107, 0.558671518772}, {0.142915682994, 0.76923386203}, {0.0452432465649, 0.92694567132}, {0.806254331245, 0.0293164271598}, {0.707609913381, 0.148078599668}, {0.550703627938, 0.336984690281}, {0.366569507766, 0.558671518772}, {0.191675437237, 0.76923386203}, {0.0606792682628, 0.92694567132}, {0.937908206226, 0.0293164271598}, {0.823156067319, 0.148078599668}, {0.640628436741, 0.336984690281}, {0.426426917862, 0.558671518772}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}};
    int D_13[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
    double W_13[36][1] = {{-0.00971097319454}, {-0.0159756941744}, {-0.0129148084988}, {-0.00602410954055}, {-0.00140335236045}, {-8.83197279225e-05}, {-0.014499997977}, {-0.0238542037517}, {-0.0192838239128}, {-0.0089949353583}, {-0.00209542400951}, {-0.000131875132445}, {-0.00678703358623}, {-0.0111654692844}, {-0.00902620543637}, {-0.00421027151037}, {-0.000980807938907}, {-6.17269708946e-05}, {0.00678703358623}, {0.0111654692844}, {0.00902620543637}, {0.00421027151037}, {0.000980807938907}, {6.17269708946e-05}, {0.014499997977}, {0.0238542037517}, {0.0192838239128}, {0.0089949353583}, {0.00209542400951}, {0.000131875132445}, {0.00971097319454}, {0.0159756941744}, {0.0129148084988}, {0.00602410954055}, {0.00140335236045}, {8.83197279225e-05}};
    double copy_13[2];
    // Loop over points
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_13[r][0] - X_13[r][1];
      const double w1 = X_13[r][0];
      const double w2 = X_13[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*coordinate_dofs[0] + w1*coordinate_dofs[2] + w2*coordinate_dofs[4];
      y[1] = w0*coordinate_dofs[1] + w1*coordinate_dofs[3] + w2*coordinate_dofs[5];
      // Evaluate function at physical point
      f.evaluate(vals, y, c);
      // Map function to reference element
      copy_13[0] = J[0]*vals[0] + J[2]*vals[1];
      copy_13[1] = J[1]*vals[0] + J[3]*vals[1];
      // Loop over directions
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_13[D_13[r][s]]*W_13[r][s];
      } // end loop over 's'
    } // end loop over 'r'
    values[13] = result;
    result = 0.0;
    double X_14[36][2] = {{0.0327753666145, 0.0293164271598}, {0.0287653330126, 0.148078599668}, {0.022386872978, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.00779187470129, 0.76923386203}, {0.00246669715267, 0.92694567132}, {0.164429241595, 0.0293164271598}, {0.14431148695, 0.148078599668}, {0.112311681781, 0.336984690281}, {0.0747589734626, 0.558671518772}, {0.0390907007328, 0.76923386203}, {0.0123750604174, 0.92694567132}, {0.369529924372, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.252403568077, 0.336984690281}, {0.168009519121, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.273318962107, 0.558671518772}, {0.142915682994, 0.76923386203}, {0.0452432465649, 0.92694567132}, {0.806254331245, 0.0293164271598}, {0.707609913381, 0.148078599668}, {0.550703627938, 0.336984690281}, {0.366569507766, 0.558671518772}, {0.191675437237, 0.76923386203}, {0.0606792682628, 0.92694567132}, {0.937908206226, 0.0293164271598}, {0.823156067319, 0.148078599668}, {0.640628436741, 0.336984690281}, {0.426426917862, 0.558671518772}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}};
    int D_14[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
    double W_14[36][1] = {{-0.0056494841656}, {-0.00645290853773}, {0.000132112736967}, {0.00571336122195}, {0.00492388644484}, {0.00133303229957}, {-0.0118962371707}, {-0.0135880247038}, {0.000278192558146}, {0.0120307444266}, {0.010368330848}, {0.00280699404177}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {0.0156040814239}, {0.0134479025608}, {0.00364071931307}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {0.0156040814239}, {0.0134479025608}, {0.00364071931307}, {-0.0118962371707}, {-0.0135880247038}, {0.000278192558146}, {0.0120307444266}, {0.010368330848}, {0.00280699404177}, {-0.0056494841656}, {-0.00645290853773}, {0.000132112736967}, {0.00571336122195}, {0.00492388644484}, {0.00133303229957}};
    double copy_14[2];
    // Loop over points
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_14[r][0] - X_14[r][1];
      const double w1 = X_14[r][0];
      const double w2 = X_14[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*coordinate_dofs[0] + w1*coordinate_dofs[2] + w2*coordinate_dofs[4];
      y[1] = w0*coordinate_dofs[1] + w1*coordinate_dofs[3] + w2*coordinate_dofs[5];
      // Evaluate function at physical point
      f.evaluate(vals, y, c);
      // Map function to reference element
      copy_14[0] = J[0]*vals[0] + J[2]*vals[1];
      copy_14[1] = J[1]*vals[0] + J[3]*vals[1];
      // Loop over directions
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_14[D_14[r][s]]*W_14[r][s];
      } // end loop over 's'
    } // end loop over 'r'
    values[14] = result;
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Evaluate function and change variables
    vertex_values[0] = dof_values[3]*K[2]*3.0 + dof_values[4]*(K[2]*(-3.0)) + dof_values[5]*K[2] + dof_values[6]*K[0]*3.0 + dof_values[7]*(K[0]*(-3.0)) + dof_values[8]*K[0] + dof_values[11]*(K[2]*(1.1990408666e-14)) + dof_values[14]*(K[0]*(-1.07435785403e-14));
    vertex_values[2] = dof_values[0]*K[2]*3.0 + dof_values[1]*(K[2]*(-3.0)) + dof_values[2]*K[2] + dof_values[6]*(K[0] + K[2]) + dof_values[7]*(K[0]*(-3.0) + K[2]*(-3.0)) + dof_values[8]*(K[0]*3.0 + K[2]*3.0) + dof_values[9]*(K[2]*(-1.52100554374e-14)) + dof_values[10]*(K[2]*(-2.65343302885e-14)) + dof_values[11]*(K[2]*(2.44249065418e-14)) + dof_values[12]*(K[2]*(1.44051437445e-14)) + dof_values[14]*(K[0]*(1.10167927423e-14) + K[2]*(3.43058914609e-14));
    vertex_values[4] = dof_values[0]*(K[0]*(-1.0)) + dof_values[1]*K[0]*3.0 + dof_values[2]*(K[0]*(-3.0)) + dof_values[3]*(K[0] + K[2]) + dof_values[4]*(K[0]*(-3.0) + K[2]*(-3.0)) + dof_values[5]*(K[0]*3.0 + K[2]*3.0) + dof_values[9]*(K[0]*(-1.1990408666e-14)) + dof_values[11]*(K[0]*(2.13162820728e-14) + K[2]*(-1.06581410364e-14)) + dof_values[12]*(K[0]*(1.14203343109e-14)) + dof_values[14]*(K[0]*(2.54750955873e-14));
    vertex_values[1] = dof_values[3]*K[3]*3.0 + dof_values[4]*(K[3]*(-3.0)) + dof_values[5]*K[3] + dof_values[6]*K[1]*3.0 + dof_values[7]*(K[1]*(-3.0)) + dof_values[8]*K[1] + dof_values[11]*(K[3]*(1.1990408666e-14)) + dof_values[14]*(K[1]*(-1.07435785403e-14));
    vertex_values[3] = dof_values[0]*K[3]*3.0 + dof_values[1]*(K[3]*(-3.0)) + dof_values[2]*K[3] + dof_values[6]*(K[1] + K[3]) + dof_values[7]*(K[1]*(-3.0) + K[3]*(-3.0)) + dof_values[8]*(K[1]*3.0 + K[3]*3.0) + dof_values[9]*(K[3]*(-1.52100554374e-14)) + dof_values[10]*(K[3]*(-2.65343302885e-14)) + dof_values[11]*(K[3]*(2.44249065418e-14)) + dof_values[12]*(K[3]*(1.44051437445e-14)) + dof_values[14]*(K[1]*(1.10167927423e-14) + K[3]*(3.43058914609e-14));
    vertex_values[5] = dof_values[0]*(K[1]*(-1.0)) + dof_values[1]*K[1]*3.0 + dof_values[2]*(K[1]*(-3.0)) + dof_values[3]*(K[1] + K[3]) + dof_values[4]*(K[1]*(-3.0) + K[3]*(-3.0)) + dof_values[5]*(K[1]*3.0 + K[3]*3.0) + dof_values[9]*(K[1]*(-1.1990408666e-14)) + dof_values[11]*(K[1]*(2.13162820728e-14) + K[3]*(-1.06581410364e-14)) + dof_values[12]*(K[1]*(1.14203343109e-14)) + dof_values[14]*(K[1]*(2.54750955873e-14));
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    throw std::runtime_error("tabulate_dof_coordinates is not defined for this element");
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new forms_finite_element_2();
  }

};


class forms_dofmap_0: public ufc::dofmap
{
public:

  forms_dofmap_0() : ufc::dofmap()
  {
    // Do nothing
  }

  ~forms_dofmap_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Lagrange', triangle, 1)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return num_global_entities[0];
  }

  std::size_t num_element_dofs() const final override
  {
    return 3;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 2;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    dofs[0] = entity_indices[0][0];
    dofs[1] = entity_indices[0][1];
    dofs[2] = entity_indices[0][2];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new forms_dofmap_0();
  }

};


class forms_dofmap_1: public ufc::dofmap
{
public:

  forms_dofmap_1() : ufc::dofmap()
  {
    // Do nothing
  }

  ~forms_dofmap_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for VectorElement(FiniteElement('Lagrange', triangle, 1), dim=2)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return 2*num_global_entities[0];
  }

  std::size_t num_element_dofs() const final override
  {
    return 6;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 4;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    offset += num_global_entities[0];
    dofs[3] = offset + entity_indices[0][0];
    dofs[4] = offset + entity_indices[0][1];
    dofs[5] = offset + entity_indices[0][2];
    offset += num_global_entities[0];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 4;
      dofs[3] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 5;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 2;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new forms_dofmap_0();
        break;
      }
    case 1:
      {
        return new forms_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new forms_dofmap_1();
  }

};


class forms_dofmap_2: public ufc::dofmap
{
public:

  forms_dofmap_2() : ufc::dofmap()
  {
    // Do nothing
  }

  ~forms_dofmap_2() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Nedelec 1st kind H(curl)', triangle, 3)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return 3*num_global_entities[1] + 6*num_global_entities[2];
  }

  std::size_t num_element_dofs() const final override
  {
    return 15;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 3;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    unsigned int offset = 0;
    dofs[0] = offset + 3*entity_indices[1][0];
    dofs[1] = offset + 3*entity_indices[1][0] + 1;
    dofs[2] = offset + 3*entity_indices[1][0] + 2;
    dofs[3] = offset + 3*entity_indices[1][1];
    dofs[4] = offset + 3*entity_indices[1][1] + 1;
    dofs[5] = offset + 3*entity_indices[1][1] + 2;
    dofs[6] = offset + 3*entity_indices[1][2];
    dofs[7] = offset + 3*entity_indices[1][2] + 1;
    dofs[8] = offset + 3*entity_indices[1][2] + 2;
    offset += 3*num_global_entities[1];
    dofs[9] = offset + 6*entity_indices[2][0];
    dofs[10] = offset + 6*entity_indices[2][0] + 1;
    dofs[11] = offset + 6*entity_indices[2][0] + 2;
    dofs[12] = offset + 6*entity_indices[2][0] + 3;
    dofs[13] = offset + 6*entity_indices[2][0] + 4;
    dofs[14] = offset + 6*entity_indices[2][0] + 5;
    offset += 6*num_global_entities[2];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 3;
      dofs[1] = 4;
      dofs[2] = 5;
        break;
      }
    case 2:
      {
        dofs[0] = 6;
      dofs[1] = 7;
      dofs[2] = 8;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 2;
          break;
        }
      case 1:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 6;
        dofs[1] = 7;
        dofs[2] = 8;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 9;
      dofs[1] = 10;
      dofs[2] = 11;
      dofs[3] = 12;
      dofs[4] = 13;
      dofs[5] = 14;
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new forms_dofmap_2();
  }

};


class forms_cell_integral_0_otherwise: public ufc::cell_integral
{
public:

  forms_cell_integral_0_otherwise() : ufc::cell_integral()
  {
    
  }

  ~forms_cell_integral_0_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute cell volume
    
    
    // Compute circumradius of triangle in 2D
    
    
    // Array of quadrature weights.
    static const double W6[6] = {0.054975871827661, 0.054975871827661, 0.054975871827661, 0.111690794839005, 0.111690794839005, 0.111690794839005};
    // Quadrature points on the UFC reference element: (0.816847572980459, 0.091576213509771), (0.091576213509771, 0.816847572980459), (0.091576213509771, 0.091576213509771), (0.10810301816807, 0.445948490915965), (0.445948490915965, 0.10810301816807), (0.445948490915965, 0.445948490915965)
    
    // Values of basis functions at quadrature points.
    static const double FE0_C0_D01[6][15] = \
    {{-2.84278477949184, 2.60133169408135, -0.632753871377718, 1.85982644165773, -0.635415018413128, 1.61571220921182, 2.32942687730161, -3.32302980327736, -5.80496552817115, 16.7566247559307, 28.2503375501111, -10.3125950058212, -5.56045205045065, 17.1175226659555, -9.82958337834074},
    {-1.79074768975489, 5.75744296329208, -10.10108767901, 4.75292843843425, -11.6818044606508, 7.13890693033065, -0.021689692394002, 0.104074179473834, -0.265803924839846, -16.8318933605097, 0.917612187043342, -25.93348252975, 16.7566247559308, 3.45115998442157, 29.6218074867925},
    {-0.730727158911757, 0.369744598943501, -1.15078897513995, 1.3815974724088, -1.67148522593758, 0.499918661642905, -11.562274986093, 6.6872894314358, -1.92358289948969, 14.9533198088331, -30.9705674032021, -19.4780023354879, 3.68187849877406, 6.7640427126909, 6.50870313497023},
    {0.565452740291985, -0.671420571424322, 2.08901867938574, -1.60411004260619, 2.74873517605273, -1.05036137707154, 1.90640810299339, -0.306199418639676, 0.748063316684344, -1.03300141506715, 15.1714233065577, 29.9298875179393, -5.87553297436219, -4.86317762376486, -10.3865730231417},
    {0.793731867204473, 0.0134168093131892, 0.0345065371732516, -0.976342443596814, 0.351804343471491, 0.148104039219088, -2.56551891256163, -1.543441746175, -2.01177024702696, 19.6926017532208, 9.24055761475929, -13.0772891857657, -1.03300141506724, -7.82861046966403, -1.82610576392334},
    {-0.957138495883974, -2.14608846111384, -0.00427037407145336, 2.74910419187173, -1.43784293086166, -1.7876953219163, 3.34906346933697, -2.09584669297285, 1.09505522467394, -15.4312459652902, 2.32121430766113, 18.0366977074507, 10.1368887622925, 18.6226537852274, 17.9196569598769}};
    
    static const double FE0_C1_D10[6][15] = \
    {{10.10108767901, -5.7574429632921, 1.7907476897549, -0.0216896923939655, 0.104074179473834, -0.265803924839887, 4.75292843843424, -11.6818044606508, 7.13890693033065, 16.7566247559307, 27.3788177817851, -11.8221115243628, -16.8318933605096, -22.0002485858417, 13.7614167296771},
    {0.632753871377706, -2.60133169408132, 2.84278477949182, 2.32942687730165, -3.32302980327736, -5.80496552817115, 1.85982644165772, -0.63541501841312, 1.61571220921181, -5.56045205045061, 0.0460924187174552, 19.7390011677438, 16.7566247559306, 5.19419952107392, 29.6218074867923},
    {1.15078897513995, -0.369744598943472, 0.730727158911739, -11.562274986093, 6.6872894314358, -1.9235828994897, 1.3815974724088, -1.67148522593759, 0.499918661642887, 3.68187849877416, 9.01872361692117, 2.60348125398806, 14.9533198088331, -32.3537285391062, -17.0822969730473},
    {-0.0345065371732545, -0.0134168093131667, -0.793731867204488, -2.56551891256162, -1.543441746175, -2.01177024702697, -0.976342443596817, 0.351804343471491, 0.148104039219076, -1.03300141506717, -5.49575921638676, -5.86672266110032, 19.6926017532208, -6.70498584012899, 14.5412022323982},
    {-2.08901867938574, 0.671420571424334, -0.565452740291991, 1.90640810299341, -0.306199418639673, 0.748063316684322, -1.60411004260618, 2.74873517605271, -1.05036137707154, -5.87553297436212, -11.4266249081851, 0.981651146274372, -1.03300141506719, 33.505754576225, -1.82610576392324},
    {0.00427037407145088, 2.14608846111387, 0.957138495883958, 3.34906346933699, -2.09584669297285, 1.09505522467393, 2.74910419187172, -1.43784293086166, -1.78769532191632, 10.1368887622926, 24.8302050469698, 7.16786278395084, -15.4312459652903, 16.7808455688634, -7.0081182956628}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 225; r++)
    {
      A[r] = 0.0;
    } // end loop over 'r'
    // Number of operations to compute geometry constants: 22.
    double G[2];
    G[0] = det*(K[0]*K[0]*K[3]*K[3] + K[1]*K[2]*(K[1]*K[2]-2.0*K[0]*K[3]));
    G[1] = det*(K[1]*K[2]*(2.0*K[0]*K[3] - K[1]*K[2]) - K[0]*K[0]*K[3]*K[3]);
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 16212
    for (unsigned int ip = 0; ip < 6; ip++)
    {
      
      // Number of operations to compute ip constants: 2
      double I[2];
      // Number of operations: 1
      I[0] = G[0]*W6[ip];
      
      // Number of operations: 1
      I[1] = G[1]*W6[ip];
      
      
      // Number of operations for primary indices: 2700
      for (unsigned int j = 0; j < 15; j++)
      {
        for (unsigned int k = 0; k < 15; k++)
        {
          // Number of operations to compute entry: 12
          A[j*15 + k] += (FE0_C0_D01[ip][j]*FE0_C0_D01[ip][k]*I[0] + FE0_C0_D01[ip][j]*FE0_C1_D10[ip][k]*I[1] + FE0_C0_D01[ip][k]*FE0_C1_D10[ip][j]*I[1] + FE0_C1_D10[ip][j]*FE0_C1_D10[ip][k]*I[0]);
        } // end loop over 'k'
      } // end loop over 'j'
    } // end loop over 'ip'
  }

};


class forms_cell_integral_1_otherwise: public ufc::cell_integral
{
public:

  forms_cell_integral_1_otherwise() : ufc::cell_integral()
  {
    
  }

  ~forms_cell_integral_1_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    8
    // Number of operations (multiply-add pairs) for tensor contraction: 777
    // Total number of operations (multiply-add pairs):                  788
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K[0]*K[0] + K[1]*K[1]);
    const double G0_0_1 = det*(K[0]*K[2] + K[1]*K[3]);
    const double G0_1_0 = det*(K[2]*K[0] + K[3]*K[1]);
    const double G0_1_1 = det*(K[2]*K[2] + K[3]*K[3]);
    
    // Compute element tensor
    A[0] = 0.0216269841269843*G0_0_0 - 0.0111607142857143*G0_0_1 - 0.0111607142857143*G0_1_0 + 0.0573412698412703*G0_1_1;
    A[1] = -0.0298611111111111*G0_0_0 + 0.00595238095238089*G0_0_1 + 0.00992063492063497*G0_1_0 - 0.0487103174603178*G0_1_1;
    A[2] = 0.0176587301587301*G0_0_0 - 0.00471230158730154*G0_0_1 - 0.00471230158730159*G0_1_0 + 0.0176587301587302*G0_1_1;
    A[3] = -0.0154265873015874*G0_0_0 - 0.0244791666666667*G0_0_1 + 0.00905257936507938*G0_1_0 + 0.0186011904761907*G0_1_1;
    A[4] = 0.0174603174603173*G0_0_0 + 0.0216765873015871*G0_0_1 - 0.00570436507936507*G0_1_0 - 0.0119047619047619*G0_1_1;
    A[5] = -0.0238591269841269*G0_0_0 - 0.0326636904761905*G0_0_1 + 0.00682043650793654*G0_1_0 + 0.0111607142857142*G0_1_1;
    A[6] = -0.0131448412698412*G0_0_0 - 0.00880456349206351*G0_0_1 + 0.0306795634920637*G0_1_0 + 0.0238591269841271*G0_1_1;
    A[7] = 0.027777777777778*G0_0_0 + 0.0141369047619048*G0_0_1 - 0.0727678571428578*G0_1_0 - 0.0611111111111116*G0_1_1;
    A[8] = -0.0205853174603176*G0_0_0 - 0.00706845238095234*G0_0_1 + 0.0582093253968257*G0_1_0 + 0.0511408730158734*G0_1_1;
    A[9] = 0.0434926790015489*G0_0_0 - 0.0231493291459878*G0_0_1 - 0.062433039211904*G0_1_0 + 0.0350747411302844*G0_1_1;
    A[10] = 0.0652955661583499*G0_0_0 - 0.051549131177644*G0_0_1 - 0.127154523571519*G0_1_0 + 0.0652955661583486*G0_1_1;
    A[11] = -0.0168650793650807*G0_0_0 - 0.00744047619047546*G0_0_1 + 0.0719246031746*G0_1_0 - 0.010912698412699*G0_1_1;
    A[12] = 0.0350747411302842*G0_0_0 + 0.128373552536837*G0_0_1 - 0.0119254119842966*G0_1_0 - 0.124866078423811*G0_1_1;
    A[13] = -0.100520805796406*G0_0_0 - 0.0631476856926132*G0_0_1 + 0.0708800553692599*G0_1_0 - 0.0850560664431105*G0_1_1;
    A[14] = 0.0620039682539667*G0_0_0 + 0.0959821428571382*G0_0_1 - 0.0210813492063486*G0_1_0 + 0.053075396825397*G0_1_1;
    A[15] = -0.0298611111111111*G0_0_0 + 0.00992063492063497*G0_0_1 + 0.00595238095238089*G0_1_0 - 0.0487103174603178*G0_1_1;
    A[16] = 0.0686507936507938*G0_0_0 - 0.0128968253968254*G0_0_1 - 0.0128968253968254*G0_1_0 + 0.0686507936507944*G0_1_1;
    A[17] = -0.0487103174603175*G0_0_0 + 0.00595238095238087*G0_0_1 + 0.00992063492063497*G0_1_0 - 0.0298611111111114*G0_1_1;
    A[18] = 0.0174603174603174*G0_0_0 + 0.0231646825396825*G0_0_1 - 0.00421626984126976*G0_1_0 - 0.0104166666666667*G0_1_1;
    A[19] = -0.0438492063492063*G0_0_0 - 0.0532738095238095*G0_0_1 + 0.00942460317460318*G0_1_0 + 0.0178571428571429*G0_1_1;
    A[20] = 0.0611111111111113*G0_0_0 + 0.0752480158730162*G0_0_1 - 0.0116567460317461*G0_1_0 - 0.0252976190476191*G0_1_1;
    A[21] = 0.0104166666666666*G0_0_0 + 0.00421626984126973*G0_0_1 - 0.0231646825396826*G0_1_0 - 0.0174603174603175*G0_1_1;
    A[22] = -0.0178571428571429*G0_0_0 - 0.00942460317460317*G0_0_1 + 0.0532738095238099*G0_1_0 + 0.0438492063492066*G0_1_1;
    A[23] = 0.0252976190476192*G0_0_0 + 0.0116567460317461*G0_0_1 - 0.0752480158730165*G0_1_0 - 0.0611111111111117*G0_1_1;
    A[24] = -0.0785674201318339*G0_0_0 - 0.00982092751647953*G0_0_1 + 0.136089995585501*G0_1_0 + 0.0701494822605691*G0_1_1;
    A[25] = -0.0532674355502326*G0_0_0 - 0.00859152186294119*G0_0_1 + 0.183858567866929*G0_1_0 + 0.0841969142568198*G0_1_1;
    A[26] = -0.0049603174603145*G0_0_0 + 0.0198412698412682*G0_0_1 - 0.162698412698407*G0_1_0 - 0.102182539682537*G0_1_1;
    A[27] = -0.0701494822605685*G0_0_0 - 0.1360899955855*G0_0_1 + 0.00982092751647951*G0_1_0 + 0.0785674201318346*G0_1_1;
    A[28] = 0.0463942180598786*G0_0_0 + 0.0489716746187606*G0_0_1 - 0.0128872827944101*G0_1_0 + 0.0309294787065843*G0_1_1;
    A[29] = -0.124007936507933*G0_0_0 - 0.240575396825387*G0_0_1 + 0.0173611111111106*G0_1_0 + 0.0436507936507933*G0_1_1;
    A[30] = 0.0176587301587301*G0_0_0 - 0.00471230158730159*G0_0_1 - 0.00471230158730154*G0_1_0 + 0.0176587301587302*G0_1_1;
    A[31] = -0.0487103174603175*G0_0_0 + 0.00992063492063497*G0_0_1 + 0.00595238095238087*G0_1_0 - 0.0298611111111114*G0_1_1;
    A[32] = 0.0573412698412701*G0_0_0 - 0.0111607142857143*G0_0_1 - 0.0111607142857143*G0_1_0 + 0.0216269841269844*G0_1_1;
    A[33] = -0.0238591269841271*G0_0_0 - 0.0306795634920636*G0_0_1 + 0.00880456349206354*G0_1_0 + 0.0131448412698413*G0_1_1;
    A[34] = 0.0611111111111114*G0_0_0 + 0.0727678571428576*G0_0_1 - 0.0141369047619048*G0_1_0 - 0.0277777777777779*G0_1_1;
    A[35] = -0.0511408730158732*G0_0_0 - 0.0582093253968256*G0_0_1 + 0.00706845238095235*G0_1_0 + 0.0205853174603176*G0_1_1;
    A[36] = -0.0186011904761906*G0_0_0 - 0.00905257936507938*G0_0_1 + 0.0244791666666668*G0_1_0 + 0.0154265873015874*G0_1_1;
    A[37] = 0.011904761904762*G0_0_0 + 0.00570436507936506*G0_0_1 - 0.0216765873015873*G0_1_0 - 0.0174603174603174*G0_1_1;
    A[38] = -0.0111607142857143*G0_0_0 - 0.00682043650793651*G0_0_1 + 0.0326636904761907*G0_1_0 + 0.0238591269841271*G0_1_1;
    A[39] = 0.124866078423811*G0_0_0 + 0.0119254119842966*G0_0_1 - 0.128373552536838*G0_1_0 - 0.0350747411302846*G0_1_1;
    A[40] = -0.00343660874517758*G0_0_0 - 0.0171830437258811*G0_0_1 - 0.0515491311776426*G0_1_0 - 0.00343660874517666*G0_1_1;
    A[41] = 0.100198412698408*G0_0_0 - 0.071924603174601*G0_0_1 + 0.102678571428568*G0_1_0 + 0.118055555555553*G0_1_1;
    A[42] = -0.0350747411302849*G0_0_0 + 0.062433039211904*G0_0_1 + 0.0231493291459879*G0_1_0 - 0.0434926790015497*G0_1_1;
    A[43] = -0.0231971090299389*G0_0_0 + 0.0012887282794408*G0_0_1 + 0.0322182069860271*G0_1_0 - 0.018042195912174*G0_1_1;
    A[44] = -0.0620039682539678*G0_0_0 + 0.146081349206342*G0_0_1 + 0.0409226190476185*G0_1_0 - 0.0649801587301586*G0_1_1;
    A[45] = -0.0154265873015874*G0_0_0 + 0.00905257936507938*G0_0_1 - 0.0244791666666667*G0_1_0 + 0.0186011904761907*G0_1_1;
    A[46] = 0.0174603174603174*G0_0_0 - 0.00421626984126976*G0_0_1 + 0.0231646825396825*G0_1_0 - 0.0104166666666667*G0_1_1;
    A[47] = -0.0238591269841271*G0_0_0 + 0.00880456349206354*G0_0_1 - 0.0306795634920636*G0_1_0 + 0.0131448412698413*G0_1_1;
    A[48] = 0.0216269841269843*G0_0_0 + 0.0327876984126987*G0_0_1 + 0.0327876984126987*G0_1_0 + 0.101289682539683*G0_1_1;
    A[49] = -0.0298611111111113*G0_0_0 - 0.0358134920634922*G0_0_1 - 0.0397817460317463*G0_1_0 - 0.0944444444444448*G0_1_1;
    A[50] = 0.0176587301587301*G0_0_0 + 0.0223710317460317*G0_0_1 + 0.0223710317460317*G0_1_0 + 0.0447420634920634*G0_1_1;
    A[51] = 0.0205853174603176*G0_0_0 + 0.0135168650793652*G0_0_1 + 0.0787946428571432*G0_1_0 + 0.0205853174603176*G0_1_1;
    A[52] = -0.027777777777778*G0_0_0 - 0.0136408730158731*G0_0_1 - 0.100545634920636*G0_1_0 - 0.0252976190476193*G0_1_1;
    A[53] = 0.0131448412698412*G0_0_0 + 0.00434027777777768*G0_0_1 + 0.0438244047619048*G0_1_0 + 0.0111607142857143*G0_1_1;
    A[54] = -0.0785674201318343*G0_0_0 + 0.0266568032590163*G0_0_1 - 0.152925871328036*G0_1_0 + 0.0420896893563414*G0_1_1;
    A[55] = -0.0352252396380562*G0_0_0 + 0.0794715772322013*G0_0_1 + 0.021049228564203*G0_1_0 + 0.115985545149699*G0_1_1;
    A[56] = -0.0451388888888867*G0_0_0 + 0.0434027777777767*G0_0_1 + 0.00570436507936481*G0_1_0 + 0.0520833333333316*G0_1_1;
    A[57] = 0.0350747411302847*G0_0_0 - 0.0932988114065537*G0_0_1 + 0.0470001531145815*G0_1_0 - 0.206239477846068*G0_1_1;
    A[58] = 0.100520805796406*G0_0_0 + 0.0373731201037923*G0_0_1 + 0.171400861165665*G0_1_0 + 0.193309241916163*G0_1_1;
    A[59] = 0.0620039682539675*G0_0_0 - 0.0339781746031718*G0_0_1 + 0.0830853174603163*G0_1_0 + 0.0401785714285732*G0_1_1;
    A[60] = 0.0174603174603173*G0_0_0 - 0.00570436507936507*G0_0_1 + 0.0216765873015871*G0_1_0 - 0.0119047619047619*G0_1_1;
    A[61] = -0.0438492063492063*G0_0_0 + 0.00942460317460318*G0_0_1 - 0.0532738095238095*G0_1_0 + 0.0178571428571429*G0_1_1;
    A[62] = 0.0611111111111114*G0_0_0 - 0.0141369047619048*G0_0_1 + 0.0727678571428576*G0_1_0 - 0.0277777777777779*G0_1_1;
    A[63] = -0.0298611111111113*G0_0_0 - 0.0397817460317463*G0_0_1 - 0.0358134920634922*G0_1_0 - 0.0944444444444448*G0_1_1;
    A[64] = 0.0686507936507941*G0_0_0 + 0.0815476190476196*G0_0_1 + 0.0815476190476196*G0_1_0 + 0.163095238095239*G0_1_1;
    A[65] = -0.0487103174603175*G0_0_0 - 0.0546626984126985*G0_0_1 - 0.0586309523809526*G0_1_0 - 0.0944444444444449*G0_1_1;
    A[66] = -0.0252976190476193*G0_0_0 - 0.0136408730158731*G0_0_1 - 0.100545634920636*G0_1_0 - 0.0277777777777779*G0_1_1;
    A[67] = 0.017857142857143*G0_0_0 + 0.00843253968253968*G0_0_1 + 0.0711309523809526*G0_1_0 + 0.0178571428571429*G0_1_1;
    A[68] = -0.0104166666666666*G0_0_0 - 0.00620039682539679*G0_0_1 - 0.033581349206349*G0_1_0 - 0.0119047619047618*G0_1_1;
    A[69] = 0.148716902392403*G0_0_0 + 0.00280597929042259*G0_0_1 + 0.294627825494385*G0_1_0;
    A[70] = -0.00687321749035419*G0_0_0 - 0.0472533702461735*G0_0_1 - 0.177844502562873*G0_1_0 - 0.103098262355288*G0_1_1;
    A[71] = 0.128968253968249*G0_0_0 - 0.0917658730158704*G0_0_1 - 0.0163690476190467*G0_1_0 - 0.178571428571424*G0_1_1;
    A[72] = -0.0701494822605693*G0_0_0 + 0.0659405133249319*G0_0_1 - 0.079970409777049*G0_1_0 + 0.134687005940288*G0_1_1;
    A[73] = -0.0463942180598787*G0_0_0 + 0.00257745655888145*G0_0_1 - 0.0592815008542884*G0_1_0 - 0.0412393049421134*G0_1_1;
    A[74] = -0.124007936507935*G0_0_0 + 0.116567460317454*G0_0_1 - 0.141369047619045*G0_1_0 + 0.142857142857138*G0_1_1;
    A[75] = -0.0238591269841269*G0_0_0 + 0.00682043650793654*G0_0_1 - 0.0326636904761905*G0_1_0 + 0.0111607142857142*G0_1_1;
    A[76] = 0.0611111111111113*G0_0_0 - 0.0116567460317461*G0_0_1 + 0.0752480158730162*G0_1_0 - 0.0252976190476191*G0_1_1;
    A[77] = -0.0511408730158732*G0_0_0 + 0.00706845238095235*G0_0_1 - 0.0582093253968256*G0_1_0 + 0.0205853174603176*G0_1_1;
    A[78] = 0.0176587301587301*G0_0_0 + 0.0223710317460317*G0_0_1 + 0.0223710317460317*G0_1_0 + 0.0447420634920634*G0_1_1;
    A[79] = -0.0487103174603175*G0_0_0 - 0.0586309523809526*G0_0_1 - 0.0546626984126985*G0_1_0 - 0.0944444444444449*G0_1_1;
    A[80] = 0.05734126984127*G0_0_0 + 0.0685019841269844*G0_0_1 + 0.0685019841269844*G0_1_0 + 0.101289682539683*G0_1_1;
    A[81] = 0.0111607142857143*G0_0_0 + 0.0043402777777777*G0_0_1 + 0.0438244047619049*G0_1_0 + 0.0131448412698412*G0_1_1;
    A[82] = -0.0119047619047619*G0_0_0 - 0.0062003968253968*G0_0_1 - 0.033581349206349*G0_1_0 - 0.0104166666666665*G0_1_1;
    A[83] = 0.0186011904761906*G0_0_0 + 0.00954861111111118*G0_0_1 + 0.0430803571428573*G0_1_0 + 0.0186011904761905*G0_1_1;
    A[84] = -0.0897913372935259*G0_0_0 - 0.0154328860973251*G0_0_1 - 0.195015560684377*G0_1_0 - 0.0420896893563413*G0_1_1;
    A[85] = -0.0266337177751162*G0_0_0 - 0.0107394023286764*G0_0_1 - 0.00730279358350018*G0_1_0 - 0.0128872827944117*G0_1_1;
    A[86] = -0.0381944444444409*G0_0_0 + 0.0359623015872999*G0_0_1 + 0.105406746031745*G0_1_0 + 0.126488095238092*G0_1_1;
    A[87] = -0.035074741130284*G0_0_0 - 0.0975077803421881*G0_0_1 - 0.0582240702762717*G0_1_0 - 0.164149788489726*G0_1_1;
    A[88] = 0.0231971090299388*G0_0_0 + 0.0244858373093799*G0_0_1 + 0.0554153160159658*G0_1_0 + 0.0747462402075818*G0_1_1;
    A[89] = -0.0620039682539664*G0_0_0 - 0.208085317460309*G0_0_1 - 0.102926587301585*G0_1_0 - 0.313988095238087*G0_1_1;
    A[90] = -0.0131448412698412*G0_0_0 + 0.0306795634920637*G0_0_1 - 0.00880456349206351*G0_1_0 + 0.0238591269841271*G0_1_1;
    A[91] = 0.0104166666666666*G0_0_0 - 0.0231646825396826*G0_0_1 + 0.00421626984126974*G0_1_0 - 0.0174603174603175*G0_1_1;
    A[92] = -0.0186011904761906*G0_0_0 + 0.0244791666666668*G0_0_1 - 0.00905257936507937*G0_1_0 + 0.0154265873015874*G0_1_1;
    A[93] = 0.0205853174603176*G0_0_0 + 0.0787946428571432*G0_0_1 + 0.0135168650793652*G0_1_0 + 0.0205853174603176*G0_1_1;
    A[94] = -0.0252976190476193*G0_0_0 - 0.100545634920636*G0_0_1 - 0.0136408730158731*G0_1_0 - 0.0277777777777779*G0_1_1;
    A[95] = 0.0111607142857143*G0_0_0 + 0.0438244047619049*G0_0_1 + 0.0043402777777777*G0_1_0 + 0.0131448412698412*G0_1_1;
    A[96] = 0.101289682539683*G0_0_0 + 0.0327876984126987*G0_0_1 + 0.0327876984126987*G0_1_0 + 0.0216269841269843*G0_1_1;
    A[97] = -0.0944444444444449*G0_0_0 - 0.0397817460317463*G0_0_1 - 0.0358134920634922*G0_1_0 - 0.0298611111111112*G0_1_1;
    A[98] = 0.0447420634920634*G0_0_0 + 0.0223710317460318*G0_0_1 + 0.0223710317460317*G0_1_0 + 0.0176587301587301*G0_1_1;
    A[99] = -0.206239477846067*G0_0_0 + 0.0470001531145812*G0_0_1 - 0.0932988114065536*G0_1_0 + 0.0350747411302844*G0_1_1;
    A[100] = 0.131450284502993*G0_0_0 + 0.157654426184961*G0_0_1 - 0.0107394023286737*G0_1_0 + 0.103957414541582*G0_1_1;
    A[101] = 0.147321428571423*G0_0_0 + 0.106894841269839*G0_0_1 + 0.0493551587301572*G0_1_0 + 0.0560515873015862*G0_1_1;
    A[102] = 0.0420896893563414*G0_0_0 - 0.152925871328035*G0_0_1 + 0.0266568032590163*G0_1_0 - 0.0785674201318341*G0_1_1;
    A[103] = 0.103098262355287*G0_0_0 + 0.0154647393532916*G0_0_1 + 0.0773236967664657*G0_1_0 - 0.0567040442954069*G0_1_1;
    A[104] = 0.0744047619047604*G0_0_0 + 0.0153769841269829*G0_0_1 + 0.0471230158730151*G0_1_0 - 0.00793650793650777*G0_1_1;
    A[105] = 0.027777777777778*G0_0_0 - 0.0727678571428578*G0_0_1 + 0.0141369047619048*G0_1_0 - 0.0611111111111116*G0_1_1;
    A[106] = -0.0178571428571429*G0_0_0 + 0.0532738095238099*G0_0_1 - 0.00942460317460317*G0_1_0 + 0.0438492063492066*G0_1_1;
    A[107] = 0.011904761904762*G0_0_0 - 0.0216765873015873*G0_0_1 + 0.00570436507936506*G0_1_0 - 0.0174603174603174*G0_1_1;
    A[108] = -0.027777777777778*G0_0_0 - 0.100545634920636*G0_0_1 - 0.0136408730158731*G0_1_0 - 0.0252976190476193*G0_1_1;
    A[109] = 0.017857142857143*G0_0_0 + 0.0711309523809526*G0_0_1 + 0.00843253968253968*G0_1_0 + 0.0178571428571429*G0_1_1;
    A[110] = -0.0119047619047619*G0_0_0 - 0.033581349206349*G0_0_1 - 0.0062003968253968*G0_1_0 - 0.0104166666666665*G0_1_1;
    A[111] = -0.0944444444444449*G0_0_0 - 0.0358134920634922*G0_0_1 - 0.0397817460317463*G0_1_0 - 0.0298611111111113*G0_1_1;
    A[112] = 0.163095238095239*G0_0_0 + 0.0815476190476197*G0_0_1 + 0.0815476190476197*G0_1_0 + 0.0686507936507941*G0_1_1;
    A[113] = -0.0944444444444449*G0_0_0 - 0.0586309523809528*G0_0_1 - 0.0546626984126985*G0_1_0 - 0.0487103174603177*G0_1_1;
    A[114] = 0.134687005940288*G0_0_0 - 0.0799704097770483*G0_0_1 + 0.0659405133249319*G0_1_0 - 0.0701494822605688*G0_1_1;
    A[115] = 0.103098262355288*G0_0_0 - 0.152069936974049*G0_0_1 + 0.102239110168991*G0_1_0 - 0.130591132316698*G0_1_1;
    A[116] = -0.107142857142853*G0_0_0 + 0.0193452380952387*G0_0_1 - 0.0560515873015849*G0_1_0 + 0.0218253968253971*G0_1_1;
    A[117] = 0.294627825494385*G0_0_1 + 0.00280597929042261*G0_1_0 + 0.148716902392403*G0_1_1;
    A[118] = -0.206196524710575*G0_0_0 - 0.103098262355287*G0_0_1 - 0.103098262355287*G0_1_0 + 0.10825317547305*G0_1_1;
    A[119] = -0.145833333333333*G0_0_1 + 0.00496031746031713*G0_1_0 - 0.0704365079365082*G0_1_1;
    A[120] = -0.0205853174603176*G0_0_0 + 0.0582093253968257*G0_0_1 - 0.00706845238095234*G0_1_0 + 0.0511408730158734*G0_1_1;
    A[121] = 0.0252976190476192*G0_0_0 - 0.0752480158730165*G0_0_1 + 0.0116567460317461*G0_1_0 - 0.0611111111111117*G0_1_1;
    A[122] = -0.0111607142857143*G0_0_0 + 0.0326636904761907*G0_0_1 - 0.00682043650793651*G0_1_0 + 0.0238591269841271*G0_1_1;
    A[123] = 0.0131448412698412*G0_0_0 + 0.0438244047619048*G0_0_1 + 0.00434027777777769*G0_1_0 + 0.0111607142857143*G0_1_1;
    A[124] = -0.0104166666666666*G0_0_0 - 0.033581349206349*G0_0_1 - 0.00620039682539679*G0_1_0 - 0.0119047619047618*G0_1_1;
    A[125] = 0.0186011904761906*G0_0_0 + 0.0430803571428573*G0_0_1 + 0.00954861111111118*G0_1_0 + 0.0186011904761905*G0_1_1;
    A[126] = 0.0447420634920634*G0_0_0 + 0.0223710317460317*G0_0_1 + 0.0223710317460318*G0_1_0 + 0.0176587301587301*G0_1_1;
    A[127] = -0.0944444444444449*G0_0_0 - 0.0546626984126985*G0_0_1 - 0.0586309523809528*G0_1_0 - 0.0487103174603177*G0_1_1;
    A[128] = 0.101289682539683*G0_0_0 + 0.0685019841269847*G0_0_1 + 0.0685019841269847*G0_1_0 + 0.0573412698412704*G0_1_1;
    A[129] = -0.164149788489726*G0_0_0 - 0.0582240702762727*G0_0_1 - 0.0975077803421886*G0_1_0 - 0.0350747411302848*G0_1_1;
    A[130] = -0.234548546858281*G0_0_0 - 0.0614293813200277*G0_0_1 - 0.167964252420488*G0_1_0 - 0.0420984571284106*G0_1_1;
    A[131] = 0.221726190476183*G0_0_0 + 0.0994543650793625*G0_0_1 + 0.125248015873011*G0_1_0 + 0.0510912698412682*G0_1_1;
    A[132] = -0.0420896893563413*G0_0_0 - 0.195015560684376*G0_0_1 - 0.0154328860973251*G0_1_0 - 0.0897913372935261*G0_1_1;
    A[133] = 0.103098262355287*G0_0_0 + 0.0876335230019949*G0_0_1 + 0.0257745655888211*G0_1_0 - 0.0463942180598777*G0_1_1;
    A[134] = -0.0744047619047604*G0_0_0 - 0.0590277777777771*G0_0_1 - 0.0272817460317454*G0_1_0 - 0.00396825396825412*G0_1_1;
    A[135] = 0.0434926790015489*G0_0_0 - 0.0624330392119039*G0_0_1 - 0.0231493291459878*G0_1_0 + 0.0350747411302844*G0_1_1;
    A[136] = -0.0785674201318339*G0_0_0 + 0.136089995585501*G0_0_1 - 0.00982092751647953*G0_1_0 + 0.0701494822605691*G0_1_1;
    A[137] = 0.124866078423811*G0_0_0 - 0.128373552536838*G0_0_1 + 0.0119254119842966*G0_1_0 - 0.0350747411302846*G0_1_1;
    A[138] = -0.0785674201318343*G0_0_0 - 0.152925871328036*G0_0_1 + 0.0266568032590163*G0_1_0 + 0.0420896893563414*G0_1_1;
    A[139] = 0.148716902392403*G0_0_0 + 0.294627825494385*G0_0_1 + 0.00280597929042259*G0_1_0;
    A[140] = -0.0897913372935259*G0_0_0 - 0.195015560684377*G0_0_1 - 0.0154328860973251*G0_1_0 - 0.0420896893563413*G0_1_1;
    A[141] = -0.206239477846067*G0_0_0 - 0.0932988114065536*G0_0_1 + 0.0470001531145812*G0_1_0 + 0.0350747411302844*G0_1_1;
    A[142] = 0.134687005940288*G0_0_0 + 0.0659405133249319*G0_0_1 - 0.0799704097770483*G0_1_0 - 0.0701494822605688*G0_1_1;
    A[143] = -0.164149788489726*G0_0_0 - 0.0975077803421886*G0_0_1 - 0.0582240702762727*G0_1_0 - 0.0350747411302848*G0_1_1;
    A[144] = 4.92063492063457*G0_0_0 + 0.198412698412687*G0_0_1 + 0.198412698412687*G0_1_0 + 0.396825396825376*G0_1_1;
    A[145] = 0.0243004934799687*G0_0_0 - 0.0607512336999672*G0_0_1 + 0.230854688059913*G0_1_0 + 0.607512336999765*G0_1_1;
    A[146] = -0.519106168728172*G0_0_0 - 0.806719045996497*G0_0_1 - 0.301642773720431*G0_1_0 - 0.350747411302832*G0_1_1;
    A[147] = -0.198412698412691*G0_0_0 + 4.30555555555524*G0_0_1 + 0.0198412698412689*G0_1_0 - 0.198412698412688*G0_1_1;
    A[148] = -0.21870444131989*G0_0_0 - 0.0364507402199858*G0_0_1 + 0.255155181539901*G0_1_0 - 0.218704441319914*G0_1_1;
    A[149] = -0.350747411302835*G0_0_0 + 0.54015101340635*G0_0_1 + 0.0350747411302834*G0_1_0 + 0.322687618398611*G0_1_1;
    A[150] = 0.0652955661583499*G0_0_0 - 0.127154523571519*G0_0_1 - 0.051549131177644*G0_1_0 + 0.0652955661583486*G0_1_1;
    A[151] = -0.0532674355502326*G0_0_0 + 0.183858567866929*G0_0_1 - 0.00859152186294119*G0_1_0 + 0.0841969142568198*G0_1_1;
    A[152] = -0.00343660874517759*G0_0_0 - 0.0515491311776426*G0_0_1 - 0.0171830437258811*G0_1_0 - 0.00343660874517665*G0_1_1;
    A[153] = -0.0352252396380562*G0_0_0 + 0.0210492285642029*G0_0_1 + 0.0794715772322013*G0_1_0 + 0.115985545149699*G0_1_1;
    A[154] = -0.00687321749035419*G0_0_0 - 0.177844502562873*G0_0_1 - 0.0472533702461735*G0_1_0 - 0.103098262355288*G0_1_1;
    A[155] = -0.0266337177751162*G0_0_0 - 0.00730279358350017*G0_0_1 - 0.0107394023286764*G0_1_0 - 0.0128872827944117*G0_1_1;
    A[156] = 0.131450284502993*G0_0_0 - 0.0107394023286737*G0_0_1 + 0.157654426184961*G0_1_0 + 0.103957414541582*G0_1_1;
    A[157] = 0.103098262355288*G0_0_0 + 0.102239110168991*G0_0_1 - 0.152069936974049*G0_1_0 - 0.130591132316698*G0_1_1;
    A[158] = -0.234548546858281*G0_0_0 - 0.167964252420488*G0_0_1 - 0.0614293813200277*G0_1_0 - 0.0420984571284106*G0_1_1;
    A[159] = 0.0243004934799691*G0_0_0 + 0.230854688059914*G0_0_1 - 0.0607512336999671*G0_1_0 + 0.607512336999765*G0_1_1;
    A[160] = 5.41666666666634*G0_0_0 + 0.431547619047605*G0_0_1 + 0.431547619047605*G0_1_0 + 1.13095238095232*G0_1_1;
    A[161] = -0.189013480984689*G0_0_0 - 0.0687321749035171*G0_0_1 - 0.274928699614087*G0_1_0 - 0.189013480984688*G0_1_1;
    A[162] = 0.170103454359941*G0_0_0 + 0.449559129379812*G0_0_1 + 0.157953207619939*G0_1_0 - 0.413108389159829*G0_1_1;
    A[163] = -0.401785714285697*G0_0_0 + 3.59374999999975*G0_0_1 + 0.558035714285683*G0_1_0 - 0.401785714285688*G0_1_1;
    A[164] = 0.300703265202923*G0_0_0 + 0.176126198190276*G0_0_1 + 0.279224460545564*G0_1_0 + 0.30070326520292*G0_1_1;
    A[165] = -0.0168650793650807*G0_0_0 + 0.0719246031746*G0_0_1 - 0.00744047619047546*G0_1_0 - 0.010912698412699*G0_1_1;
    A[166] = -0.0049603174603145*G0_0_0 - 0.162698412698407*G0_0_1 + 0.0198412698412682*G0_1_0 - 0.102182539682537*G0_1_1;
    A[167] = 0.100198412698408*G0_0_0 + 0.102678571428568*G0_0_1 - 0.071924603174601*G0_1_0 + 0.118055555555553*G0_1_1;
    A[168] = -0.0451388888888868*G0_0_0 + 0.00570436507936479*G0_0_1 + 0.0434027777777767*G0_1_0 + 0.0520833333333316*G0_1_1;
    A[169] = 0.128968253968249*G0_0_0 - 0.0163690476190467*G0_0_1 - 0.0917658730158704*G0_1_0 - 0.178571428571424*G0_1_1;
    A[170] = -0.0381944444444409*G0_0_0 + 0.105406746031745*G0_0_1 + 0.0359623015872999*G0_1_0 + 0.126488095238092*G0_1_1;
    A[171] = 0.147321428571423*G0_0_0 + 0.0493551587301572*G0_0_1 + 0.106894841269839*G0_1_0 + 0.0560515873015862*G0_1_1;
    A[172] = -0.107142857142852*G0_0_0 - 0.0560515873015849*G0_0_1 + 0.0193452380952387*G0_1_0 + 0.0218253968253971*G0_1_1;
    A[173] = 0.221726190476183*G0_0_0 + 0.125248015873011*G0_0_1 + 0.0994543650793625*G0_1_0 + 0.0510912698412682*G0_1_1;
    A[174] = -0.519106168728172*G0_0_0 - 0.301642773720431*G0_0_1 - 0.806719045996497*G0_1_0 - 0.350747411302832*G0_1_1;
    A[175] = -0.189013480984688*G0_0_0 - 0.274928699614087*G0_0_1 - 0.0687321749035171*G0_1_0 - 0.189013480984688*G0_1_1;
    A[176] = 5.55555555555519*G0_0_0 + 0.590277777777742*G0_0_1 + 0.590277777777743*G0_1_0 + 0.912698412698366*G0_1_1;
    A[177] = -0.350747411302833*G0_0_0 - 0.301642773720428*G0_0_1 + 0.203433498555644*G0_1_0 - 0.0140298964520951*G0_1_1;
    A[178] = 0.0773236967664695*G0_0_0 + 0.167534676327341*G0_0_1 + 0.0644364139720519*G0_1_0 + 0.0773236967664695*G0_1_1;
    A[179] = -0.62003968253965*G0_0_0 + 3.39533730158706*G0_0_1 + 0.359623015872999*G0_1_0 - 0.620039682539656*G0_1_1;
    A[180] = 0.0350747411302842*G0_0_0 - 0.0119254119842966*G0_0_1 + 0.128373552536837*G0_1_0 - 0.124866078423811*G0_1_1;
    A[181] = -0.0701494822605685*G0_0_0 + 0.00982092751647951*G0_0_1 - 0.1360899955855*G0_1_0 + 0.0785674201318346*G0_1_1;
    A[182] = -0.0350747411302849*G0_0_0 + 0.0231493291459879*G0_0_1 + 0.062433039211904*G0_1_0 - 0.0434926790015497*G0_1_1;
    A[183] = 0.0350747411302847*G0_0_0 + 0.0470001531145815*G0_0_1 - 0.0932988114065537*G0_1_0 - 0.206239477846068*G0_1_1;
    A[184] = -0.0701494822605693*G0_0_0 - 0.079970409777049*G0_0_1 + 0.0659405133249319*G0_1_0 + 0.134687005940288*G0_1_1;
    A[185] = -0.035074741130284*G0_0_0 - 0.0582240702762717*G0_0_1 - 0.0975077803421881*G0_1_0 - 0.164149788489726*G0_1_1;
    A[186] = 0.0420896893563414*G0_0_0 + 0.0266568032590163*G0_0_1 - 0.152925871328035*G0_1_0 - 0.0785674201318341*G0_1_1;
    A[187] = 0.00280597929042261*G0_0_1 + 0.294627825494385*G0_1_0 + 0.148716902392403*G0_1_1;
    A[188] = -0.0420896893563413*G0_0_0 - 0.0154328860973251*G0_0_1 - 0.195015560684376*G0_1_0 - 0.0897913372935261*G0_1_1;
    A[189] = -0.198412698412691*G0_0_0 + 0.0198412698412689*G0_0_1 + 4.30555555555524*G0_1_0 - 0.198412698412688*G0_1_1;
    A[190] = 0.170103454359941*G0_0_0 + 0.157953207619939*G0_0_1 + 0.449559129379812*G0_1_0 - 0.413108389159829*G0_1_1;
    A[191] = -0.350747411302833*G0_0_0 + 0.203433498555644*G0_0_1 - 0.301642773720428*G0_1_0 - 0.0140298964520952*G0_1_1;
    A[192] = 0.396825396825376*G0_0_0 + 0.198412698412685*G0_0_1 + 0.198412698412685*G0_1_0 + 4.92063492063457*G0_1_1;
    A[193] = -0.145802960879936*G0_0_1 - 0.729014804399693*G0_1_0 - 0.437408882639822*G0_1_1;
    A[194] = 0.701494822605665*G0_0_0 + 0.35074741130283*G0_0_1 + 0.350747411302829*G0_1_0 + 0.280597929042239*G0_1_1;
    A[195] = -0.100520805796406*G0_0_0 + 0.0708800553692599*G0_0_1 - 0.0631476856926132*G0_1_0 - 0.0850560664431105*G0_1_1;
    A[196] = 0.0463942180598786*G0_0_0 - 0.0128872827944101*G0_0_1 + 0.0489716746187606*G0_1_0 + 0.0309294787065843*G0_1_1;
    A[197] = -0.0231971090299389*G0_0_0 + 0.0322182069860271*G0_0_1 + 0.00128872827944081*G0_1_0 - 0.018042195912174*G0_1_1;
    A[198] = 0.100520805796406*G0_0_0 + 0.171400861165665*G0_0_1 + 0.0373731201037923*G0_1_0 + 0.193309241916163*G0_1_1;
    A[199] = -0.0463942180598787*G0_0_0 - 0.0592815008542884*G0_0_1 + 0.00257745655888145*G0_1_0 - 0.0412393049421134*G0_1_1;
    A[200] = 0.0231971090299388*G0_0_0 + 0.0554153160159658*G0_0_1 + 0.0244858373093799*G0_1_0 + 0.0747462402075818*G0_1_1;
    A[201] = 0.103098262355287*G0_0_0 + 0.0773236967664657*G0_0_1 + 0.0154647393532916*G0_1_0 - 0.0567040442954069*G0_1_1;
    A[202] = -0.206196524710575*G0_0_0 - 0.103098262355287*G0_0_1 - 0.103098262355287*G0_1_0 + 0.10825317547305*G0_1_1;
    A[203] = 0.103098262355287*G0_0_0 + 0.0257745655888211*G0_0_1 + 0.0876335230019949*G0_1_0 - 0.0463942180598777*G0_1_1;
    A[204] = -0.21870444131989*G0_0_0 + 0.255155181539901*G0_0_1 - 0.0364507402199856*G0_1_0 - 0.218704441319914*G0_1_1;
    A[205] = -0.401785714285697*G0_0_0 + 0.558035714285683*G0_0_1 + 3.59374999999975*G0_1_0 - 0.401785714285688*G0_1_1;
    A[206] = 0.0773236967664696*G0_0_0 + 0.0644364139720519*G0_0_1 + 0.167534676327341*G0_1_0 + 0.0773236967664695*G0_1_1;
    A[207] = -0.729014804399693*G0_0_1 - 0.145802960879936*G0_1_0 - 0.437408882639822*G0_1_1;
    A[208] = 0.803571428571384*G0_0_0 + 0.401785714285689*G0_0_1 + 0.401785714285689*G0_1_0 + 5.35714285714249*G0_1_1;
    A[209] = -0.0515491311776319*G0_0_1 - 0.257745655888202*G0_1_0 - 0.15464739353292*G0_1_1;
    A[210] = 0.0620039682539667*G0_0_0 - 0.0210813492063486*G0_0_1 + 0.0959821428571382*G0_1_0 + 0.053075396825397*G0_1_1;
    A[211] = -0.124007936507933*G0_0_0 + 0.0173611111111106*G0_0_1 - 0.240575396825387*G0_1_0 + 0.0436507936507933*G0_1_1;
    A[212] = -0.0620039682539678*G0_0_0 + 0.0409226190476185*G0_0_1 + 0.146081349206342*G0_1_0 - 0.0649801587301586*G0_1_1;
    A[213] = 0.0620039682539675*G0_0_0 + 0.0830853174603163*G0_0_1 - 0.0339781746031718*G0_1_0 + 0.0401785714285732*G0_1_1;
    A[214] = -0.124007936507935*G0_0_0 - 0.141369047619045*G0_0_1 + 0.116567460317454*G0_1_0 + 0.142857142857138*G0_1_1;
    A[215] = -0.0620039682539664*G0_0_0 - 0.102926587301585*G0_0_1 - 0.208085317460309*G0_1_0 - 0.313988095238087*G0_1_1;
    A[216] = 0.0744047619047604*G0_0_0 + 0.0471230158730151*G0_0_1 + 0.0153769841269829*G0_1_0 - 0.00793650793650776*G0_1_1;
    A[217] = 0.00496031746031713*G0_0_1 - 0.145833333333333*G0_1_0 - 0.0704365079365082*G0_1_1;
    A[218] = -0.0744047619047604*G0_0_0 - 0.0272817460317454*G0_0_1 - 0.0590277777777771*G0_1_0 - 0.00396825396825412*G0_1_1;
    A[219] = -0.350747411302835*G0_0_0 + 0.0350747411302834*G0_0_1 + 0.54015101340635*G0_1_0 + 0.322687618398611*G0_1_1;
    A[220] = 0.300703265202923*G0_0_0 + 0.279224460545564*G0_0_1 + 0.176126198190276*G0_1_0 + 0.30070326520292*G0_1_1;
    A[221] = -0.62003968253965*G0_0_0 + 0.359623015872999*G0_0_1 + 3.39533730158706*G0_1_0 - 0.620039682539656*G0_1_1;
    A[222] = 0.701494822605665*G0_0_0 + 0.350747411302829*G0_0_1 + 0.350747411302829*G0_1_0 + 0.280597929042239*G0_1_1;
    A[223] = -0.257745655888202*G0_0_1 - 0.051549131177632*G0_1_0 - 0.154647393532921*G0_1_1;
    A[224] = 1.2400793650793*G0_0_0 + 0.620039682539645*G0_0_1 + 0.620039682539645*G0_1_0 + 5.61507936507903*G0_1_1;
  }

};


class forms_form_0: public ufc::form
{
public:

  forms_form_0() : ufc::form()
  {
    // Do nothing
  }

  ~forms_form_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "5ef7c449a95d7b424e9547ea1c3d1f06f62528b17ae4ce1a269846967409026af4c96e4c25d91f5b45e7fa670566e64f97f09f8d53deac0d681e42447247ea67";
  }

  std::size_t rank() const final override
  {
    return 2;
  }

  std::size_t num_coefficients() const final override
  {
    return 0;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new forms_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new forms_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new forms_finite_element_2();
        break;
      }
    case 1:
      {
        return new forms_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new forms_dofmap_2();
        break;
      }
    case 1:
      {
        return new forms_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return false;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new forms_cell_integral_0_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};


class forms_form_1: public ufc::form
{
public:

  forms_form_1() : ufc::form()
  {
    // Do nothing
  }

  ~forms_form_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "108dafa0472311164e3d035eb30e30f4cf3ca036a1737d9e5ebc3b6566301b7e8745210ebbd68d48e8bf6b07ac5d7b23237e4d0bc8f94b17f4dc7d592b22029c";
  }

  std::size_t rank() const final override
  {
    return 2;
  }

  std::size_t num_coefficients() const final override
  {
    return 0;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new forms_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new forms_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new forms_finite_element_2();
        break;
      }
    case 1:
      {
        return new forms_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new forms_dofmap_2();
        break;
      }
    case 1:
      {
        return new forms_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return false;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new forms_cell_integral_1_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/mesh/Mesh.h>
#include <dolfin/mesh/MultiMesh.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/fem/MultiMeshForm.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/MultiMeshFunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>
#include <dolfin/function/MultiMeshCoefficientAssigner.h>
#include <dolfin/adaptivity/ErrorControl.h>
#include <dolfin/adaptivity/GoalFunctional.h>
#include <dolfin/la/GenericVector.h>

namespace Forms
{

class Form_a_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_a_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<forms_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<forms_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_a_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<forms_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<forms_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_a_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_a_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<forms_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<forms_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_a_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<forms_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<forms_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_a_MultiMeshFunctionSpace_0: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_a_MultiMeshFunctionSpace_0(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_a_FunctionSpace_0(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

class Form_a_MultiMeshFunctionSpace_1: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_a_MultiMeshFunctionSpace_1(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_a_FunctionSpace_1(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

class Form_a: public dolfin::Form
{
public:

  // Constructor
  Form_a(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = std::make_shared<const forms_form_0>();
  }

  // Destructor
  ~Form_a()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return "unnamed";
  }

  // Typedefs
  typedef Form_a_FunctionSpace_0 TestSpace;
  typedef Form_a_FunctionSpace_1 TrialSpace;
  typedef Form_a_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_a_MultiMeshFunctionSpace_1 MultiMeshTrialSpace;

  // Coefficients
};

class MultiMeshForm_a: public dolfin::MultiMeshForm
{
public:

  // Constructor
  MultiMeshForm_a(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V1, std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0):
    dolfin::MultiMeshForm(V1, V0)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<const dolfin::Form> a(new Form_a(V1->part(part), V0->part(part)));
      add(a);
    }

    // Build multimesh form
    build();

    /// Assign coefficients

  }

  // Destructor
  ~MultiMeshForm_a()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return "unnamed";
  }

  // Typedefs
  typedef Form_a_FunctionSpace_0 TestSpace;
  typedef Form_a_FunctionSpace_1 TrialSpace;
  typedef Form_a_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_a_MultiMeshFunctionSpace_1 MultiMeshTrialSpace;

  // Coefficients
};

class Form_L_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_L_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<forms_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<forms_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_L_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<forms_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<forms_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_L_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_L_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<forms_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<forms_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_L_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<forms_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<forms_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_L_MultiMeshFunctionSpace_0: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_L_MultiMeshFunctionSpace_0(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_L_FunctionSpace_0(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

class Form_L_MultiMeshFunctionSpace_1: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_L_MultiMeshFunctionSpace_1(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_L_FunctionSpace_1(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

class Form_L: public dolfin::Form
{
public:

  // Constructor
  Form_L(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = std::make_shared<const forms_form_1>();
  }

  // Destructor
  ~Form_L()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return "unnamed";
  }

  // Typedefs
  typedef Form_L_FunctionSpace_0 TestSpace;
  typedef Form_L_FunctionSpace_1 TrialSpace;
  typedef Form_L_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_L_MultiMeshFunctionSpace_1 MultiMeshTrialSpace;

  // Coefficients
};

class MultiMeshForm_L: public dolfin::MultiMeshForm
{
public:

  // Constructor
  MultiMeshForm_L(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V1, std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0):
    dolfin::MultiMeshForm(V1, V0)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<const dolfin::Form> a(new Form_L(V1->part(part), V0->part(part)));
      add(a);
    }

    // Build multimesh form
    build();

    /// Assign coefficients

  }

  // Destructor
  ~MultiMeshForm_L()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return "unnamed";
  }

  // Typedefs
  typedef Form_L_FunctionSpace_0 TestSpace;
  typedef Form_L_FunctionSpace_1 TrialSpace;
  typedef Form_L_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_L_MultiMeshFunctionSpace_1 MultiMeshTrialSpace;

  // Coefficients
};

// Class typedefs
typedef Form_a::TestSpace FunctionSpace;
typedef Form_a::MultiMeshTestSpace MultiMeshFunctionSpace;

}

#endif
