// This code conforms with the UFC specification version 2016.1.0
// and was automatically generated by FFC version 2016.1.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   optimize:                       False
//   precision:                      15
//   quadrature_degree:              -1
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __HYPERELASTICITY_H
#define __HYPERELASTICITY_H
#include <cmath>
#include <stdexcept>
#include <ufc.h>

class hyperelasticity_finite_element_0: public ufc::finite_element
{
public:

  hyperelasticity_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  ~hyperelasticity_finite_element_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Lagrange', tetrahedron, 1)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::tetrahedron;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t geometric_dimension() const final override
  {
    return 3;
  }

  std::size_t space_dimension() const final override
  {
    return 4;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 1;
  }

  const char * family() const final override
  {
    return "Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 4; r++)
    {
      _evaluate_basis(r, &dof_values, x, coordinate_dofs, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[3][1];
    for (unsigned int row = 0; row < 3; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[3][3];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[3];
    for (unsigned int r = 0; r < 3; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 4; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[6];
    dof_coordinates[7] = coordinate_dofs[7];
    dof_coordinates[8] = coordinate_dofs[8];
    dof_coordinates[9] = coordinate_dofs[9];
    dof_coordinates[10] = coordinate_dofs[10];
    dof_coordinates[11] = coordinate_dofs[11];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new hyperelasticity_finite_element_0();
  }

};


class hyperelasticity_finite_element_1: public ufc::finite_element
{
public:

  hyperelasticity_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  ~hyperelasticity_finite_element_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "VectorElement(FiniteElement('Lagrange', tetrahedron, 1), dim=3)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::tetrahedron;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t geometric_dimension() const final override
  {
    return 3;
  }

  std::size_t space_dimension() const final override
  {
    return 12;
  }

  std::size_t value_rank() const final override
  {
    return 1;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  std::size_t value_size() const final override
  {
    return 3;
  }

  std::size_t reference_value_rank() const final override
  {
    return 1;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  std::size_t reference_value_size() const final override
  {
    return 3;
  }

  std::size_t degree() const final override
  {
    return 1;
  }

  const char * family() const final override
  {
    return "Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    values[2] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values[3] = {0.0, 0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 12; r++)
    {
      _evaluate_basis(r, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 3; s++)
      {
        values[r*3 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[3][1];
    for (unsigned int row = 0; row < 3; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[3][3];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 12; r++)
    {
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[9];
    for (unsigned int r = 0; r < 9; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 12; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 6:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 7:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 8:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 9:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 10:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 11:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[4] = vals[1];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[5] = vals[1];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[6] = vals[1];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[7] = vals[1];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[8] = vals[2];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[9] = vals[2];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[10] = vals[2];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[11] = vals[2];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[3] = dof_values[1];
    vertex_values[6] = dof_values[2];
    vertex_values[9] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[4];
    vertex_values[4] = dof_values[5];
    vertex_values[7] = dof_values[6];
    vertex_values[10] = dof_values[7];
    // Evaluate function and change variables
    vertex_values[2] = dof_values[8];
    vertex_values[5] = dof_values[9];
    vertex_values[8] = dof_values[10];
    vertex_values[11] = dof_values[11];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[6];
    dof_coordinates[7] = coordinate_dofs[7];
    dof_coordinates[8] = coordinate_dofs[8];
    dof_coordinates[9] = coordinate_dofs[9];
    dof_coordinates[10] = coordinate_dofs[10];
    dof_coordinates[11] = coordinate_dofs[11];
    dof_coordinates[12] = coordinate_dofs[0];
    dof_coordinates[13] = coordinate_dofs[1];
    dof_coordinates[14] = coordinate_dofs[2];
    dof_coordinates[15] = coordinate_dofs[3];
    dof_coordinates[16] = coordinate_dofs[4];
    dof_coordinates[17] = coordinate_dofs[5];
    dof_coordinates[18] = coordinate_dofs[6];
    dof_coordinates[19] = coordinate_dofs[7];
    dof_coordinates[20] = coordinate_dofs[8];
    dof_coordinates[21] = coordinate_dofs[9];
    dof_coordinates[22] = coordinate_dofs[10];
    dof_coordinates[23] = coordinate_dofs[11];
    dof_coordinates[24] = coordinate_dofs[0];
    dof_coordinates[25] = coordinate_dofs[1];
    dof_coordinates[26] = coordinate_dofs[2];
    dof_coordinates[27] = coordinate_dofs[3];
    dof_coordinates[28] = coordinate_dofs[4];
    dof_coordinates[29] = coordinate_dofs[5];
    dof_coordinates[30] = coordinate_dofs[6];
    dof_coordinates[31] = coordinate_dofs[7];
    dof_coordinates[32] = coordinate_dofs[8];
    dof_coordinates[33] = coordinate_dofs[9];
    dof_coordinates[34] = coordinate_dofs[10];
    dof_coordinates[35] = coordinate_dofs[11];
  }

  std::size_t num_sub_elements() const final override
  {
    return 3;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new hyperelasticity_finite_element_1();
  }

};


class hyperelasticity_finite_element_2: public ufc::finite_element
{
public:

  hyperelasticity_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  ~hyperelasticity_finite_element_2() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Real', tetrahedron, 0)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::tetrahedron;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t geometric_dimension() const final override
  {
    return 3;
  }

  std::size_t space_dimension() const final override
  {
    return 1;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 0;
  }

  const char * family() const final override
  {
    return "Real";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    
    // Compute subdeterminants
    
    // Get coordinates and map to the reference (FIAT) element
    
    
    // Reset values
    *values = 0.0;
    
    // Array of basisvalues
    double basisvalues[1] = {0.0};
    
    // Declare helper variables
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients
    static const double coefficients0[1] = \
    {1.0};
    
    // Compute value(s)
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    } // end loop over 'r'
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Element is constant, calling evaluate_basis.
    _evaluate_basis(0, values, x, coordinate_dofs, cell_orientation);
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 0)
    {
    return ;
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Element is constant, calling evaluate_basis_derivatives.
    _evaluate_basis_derivatives(0, n, values, x, coordinate_dofs, cell_orientation);
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = 0.25*coordinate_dofs[0] + 0.25*coordinate_dofs[3] + 0.25*coordinate_dofs[6] + 0.25*coordinate_dofs[9];
      y[1] = 0.25*coordinate_dofs[1] + 0.25*coordinate_dofs[4] + 0.25*coordinate_dofs[7] + 0.25*coordinate_dofs[10];
      y[2] = 0.25*coordinate_dofs[2] + 0.25*coordinate_dofs[5] + 0.25*coordinate_dofs[8] + 0.25*coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = 0.25*coordinate_dofs[0] + 0.25*coordinate_dofs[3] + 0.25*coordinate_dofs[6] + 0.25*coordinate_dofs[9];
    y[1] = 0.25*coordinate_dofs[1] + 0.25*coordinate_dofs[4] + 0.25*coordinate_dofs[7] + 0.25*coordinate_dofs[10];
    y[2] = 0.25*coordinate_dofs[2] + 0.25*coordinate_dofs[5] + 0.25*coordinate_dofs[8] + 0.25*coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
    vertex_values[3] = dof_values[0];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = 0.25*coordinate_dofs[0] + 0.25*coordinate_dofs[3] + 0.25*coordinate_dofs[6] + 0.25*coordinate_dofs[9];
    dof_coordinates[1] = 0.25*coordinate_dofs[1] + 0.25*coordinate_dofs[4] + 0.25*coordinate_dofs[7] + 0.25*coordinate_dofs[10];
    dof_coordinates[2] = 0.25*coordinate_dofs[2] + 0.25*coordinate_dofs[5] + 0.25*coordinate_dofs[8] + 0.25*coordinate_dofs[11];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new hyperelasticity_finite_element_2();
  }

};


class hyperelasticity_dofmap_0: public ufc::dofmap
{
public:

  hyperelasticity_dofmap_0() : ufc::dofmap()
  {
    // Do nothing
  }

  ~hyperelasticity_dofmap_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Lagrange', tetrahedron, 1)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return num_global_entities[0];
  }

  std::size_t num_element_dofs() const final override
  {
    return 4;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 3;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    dofs[0] = entity_indices[0][0];
    dofs[1] = entity_indices[0][1];
    dofs[2] = entity_indices[0][2];
    dofs[3] = entity_indices[0][3];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new hyperelasticity_dofmap_0();
  }

};


class hyperelasticity_dofmap_1: public ufc::dofmap
{
public:

  hyperelasticity_dofmap_1() : ufc::dofmap()
  {
    // Do nothing
  }

  ~hyperelasticity_dofmap_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for VectorElement(FiniteElement('Lagrange', tetrahedron, 1), dim=3)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return 3*num_global_entities[0];
  }

  std::size_t num_element_dofs() const final override
  {
    return 12;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 9;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 3;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    dofs[3] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[4] = offset + entity_indices[0][0];
    dofs[5] = offset + entity_indices[0][1];
    dofs[6] = offset + entity_indices[0][2];
    dofs[7] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[8] = offset + entity_indices[0][0];
    dofs[9] = offset + entity_indices[0][1];
    dofs[10] = offset + entity_indices[0][2];
    dofs[11] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 9;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 11;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 10;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 4;
        dofs[2] = 8;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 5;
        dofs[2] = 9;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 6;
        dofs[2] = 10;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 7;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 3;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new hyperelasticity_dofmap_1();
  }

};


class hyperelasticity_dofmap_2: public ufc::dofmap
{
public:

  hyperelasticity_dofmap_2() : ufc::dofmap()
  {
    // Do nothing
  }

  ~hyperelasticity_dofmap_2() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Real', tetrahedron, 0)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return 1;
  }

  std::size_t num_element_dofs() const final override
  {
    return 1;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 0;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    dofs[0] = 0;
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new hyperelasticity_dofmap_2();
  }

};


class hyperelasticity_cell_integral_0_otherwise: public ufc::cell_integral
{
public:

  hyperelasticity_cell_integral_0_otherwise() : ufc::cell_integral()
  {
    
  }

  ~hyperelasticity_cell_integral_0_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({true, true, false, true, true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute cell volume
    
    
    // Compute circumradius
    
    
    // Array of quadrature weights.
    static const double W4[4] = {0.0416666666666667, 0.0416666666666667, 0.0416666666666667, 0.0416666666666667};
    // Quadrature points on the UFC reference element: (0.585410196624969, 0.138196601125011, 0.138196601125011), (0.138196601125011, 0.585410196624969, 0.138196601125011), (0.138196601125011, 0.138196601125011, 0.585410196624969), (0.138196601125011, 0.138196601125011, 0.138196601125011)
    
    // Values of basis functions at quadrature points.
    static const double FE0[4][1] = \
    {{1.0},
    {1.0},
    {1.0},
    {1.0}};
    
    static const double FE1_C0[4][12] = \
    {{0.138196601125009, 0.585410196624969, 0.138196601125011, 0.138196601125011, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.138196601125009, 0.138196601125011, 0.585410196624969, 0.138196601125011, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.138196601125009, 0.138196601125011, 0.138196601125011, 0.585410196624969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.585410196624967, 0.138196601125011, 0.138196601125011, 0.138196601125011, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE1_C0_D001[4][12] = \
    {{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE1_C0_D010[4][12] = \
    {{-1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE1_C0_D100[4][12] = \
    {{-1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE1_C1[4][12] = \
    {{0.0, 0.0, 0.0, 0.0, 0.138196601125009, 0.585410196624969, 0.138196601125011, 0.138196601125011, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.138196601125009, 0.138196601125011, 0.585410196624969, 0.138196601125011, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.138196601125009, 0.138196601125011, 0.138196601125011, 0.585410196624969, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.585410196624967, 0.138196601125011, 0.138196601125011, 0.138196601125011, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE1_C1_D001[4][12] = \
    {{0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE1_C1_D010[4][12] = \
    {{0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE1_C1_D100[4][12] = \
    {{0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE1_C2[4][12] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.138196601125009, 0.585410196624969, 0.138196601125011, 0.138196601125011},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.138196601125009, 0.138196601125011, 0.585410196624969, 0.138196601125011},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.138196601125009, 0.138196601125011, 0.138196601125011, 0.585410196624969},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.585410196624967, 0.138196601125011, 0.138196601125011, 0.138196601125011}};
    
    static const double FE1_C2_D001[4][12] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0}};
    
    static const double FE1_C2_D010[4][12] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0}};
    
    static const double FE1_C2_D100[4][12] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 12; r++)
    {
      A[r] = 0.0;
    } // end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', False), ('ignore ones', False), ('ignore zero tables', False), ('optimisation', False), ('remove zero terms', False)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 47248
    for (unsigned int ip = 0; ip < 4; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      double F1 = 0.0;
      double F2 = 0.0;
      double F3 = 0.0;
      double F4 = 0.0;
      double F5 = 0.0;
      double F6 = 0.0;
      double F7 = 0.0;
      double F8 = 0.0;
      double F9 = 0.0;
      double F10 = 0.0;
      double F11 = 0.0;
      double F12 = 0.0;
      double F13 = 0.0;
      
      // Total number of operations to compute function values = 4
      for (unsigned int r = 0; r < 1; r++)
      {
        F0 += FE0[ip][0]*w[3][0];
        F10 += FE0[ip][0]*w[4][0];
      } // end loop over 'r'
      
      // Total number of operations to compute function values = 288
      for (unsigned int r = 0; r < 12; r++)
      {
        F1 += FE1_C0_D100[ip][r]*w[0][r];
        F2 += FE1_C0_D010[ip][r]*w[0][r];
        F3 += FE1_C0_D001[ip][r]*w[0][r];
        F4 += FE1_C2_D100[ip][r]*w[0][r];
        F5 += FE1_C2_D010[ip][r]*w[0][r];
        F6 += FE1_C2_D001[ip][r]*w[0][r];
        F7 += FE1_C1_D100[ip][r]*w[0][r];
        F8 += FE1_C1_D010[ip][r]*w[0][r];
        F9 += FE1_C1_D001[ip][r]*w[0][r];
        F11 += FE1_C0[ip][r]*w[1][r];
        F12 += FE1_C1[ip][r]*w[1][r];
        F13 += FE1_C2[ip][r]*w[1][r];
      } // end loop over 'r'
      
      // Number of operations for primary indices: 11520
      for (unsigned int j = 0; j < 12; j++)
      {
        // Number of operations to compute entry: 960
        A[j] += ((((((((((((((K[0]*FE1_C1_D100[ip][j] + K[3]*FE1_C1_D010[ip][j] + K[6]*FE1_C1_D001[ip][j]))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + ((K[2]*FE1_C2_D100[ip][j] + K[5]*FE1_C2_D010[ip][j] + K[8]*FE1_C2_D001[ip][j]))*((K[0]*F7 + K[3]*F8 + K[6]*F9))))*(-1.0) + (((K[0]*FE1_C2_D100[ip][j] + K[3]*FE1_C2_D010[ip][j] + K[6]*FE1_C2_D001[ip][j]))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE1_C1_D100[ip][j] + K[5]*FE1_C1_D010[ip][j] + K[8]*FE1_C1_D001[ip][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE1_C0_D100[ip][j] + K[4]*FE1_C0_D010[ip][j] + K[7]*FE1_C0_D001[ip][j]))*((((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[0]*F4 + K[3]*F5 + K[6]*F6)) + (-1.0)*(((K[0]*F7 + K[3]*F8 + K[6]*F9))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)))))) + (((((((K[1]*FE1_C2_D100[ip][j] + K[4]*FE1_C2_D010[ip][j] + K[7]*FE1_C2_D001[ip][j]))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE1_C1_D100[ip][j] + K[5]*FE1_C1_D010[ip][j] + K[8]*FE1_C1_D001[ip][j]))*((K[1]*F4 + K[4]*F5 + K[7]*F6))))*(-1.0) + (((K[1]*FE1_C1_D100[ip][j] + K[4]*FE1_C1_D010[ip][j] + K[7]*FE1_C1_D001[ip][j]))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + ((K[2]*FE1_C2_D100[ip][j] + K[5]*FE1_C2_D010[ip][j] + K[8]*FE1_C2_D001[ip][j]))*(((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0)))))*(((K[0]*F1 + K[3]*F2 + K[6]*F3) + 1.0)) + ((K[0]*FE1_C0_D100[ip][j] + K[3]*FE1_C0_D010[ip][j] + K[6]*FE1_C0_D001[ip][j]))*(((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + (-1.0)*(((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6))))))) + (((((((K[0]*FE1_C2_D100[ip][j] + K[3]*FE1_C2_D010[ip][j] + K[6]*FE1_C2_D001[ip][j]))*(((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0)) + ((K[1]*FE1_C1_D100[ip][j] + K[4]*FE1_C1_D010[ip][j] + K[7]*FE1_C1_D001[ip][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE1_C1_D100[ip][j] + K[3]*FE1_C1_D010[ip][j] + K[6]*FE1_C1_D001[ip][j]))*((K[1]*F4 + K[4]*F5 + K[7]*F6)) + ((K[1]*FE1_C2_D100[ip][j] + K[4]*FE1_C2_D010[ip][j] + K[7]*FE1_C2_D001[ip][j]))*((K[0]*F7 + K[3]*F8 + K[6]*F9)))))*((K[2]*F1 + K[5]*F2 + K[8]*F3)) + ((K[2]*FE1_C0_D100[ip][j] + K[5]*FE1_C0_D010[ip][j] + K[8]*FE1_C0_D001[ip][j]))*((((K[0]*F7 + K[3]*F8 + K[6]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6)) + (-1.0)*((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))))/((((((K[0]*F1 + K[3]*F2 + K[6]*F3) + 1.0))*(((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + (-1.0)*(((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6))))) + ((K[1]*F1 + K[4]*F2 + K[7]*F3))*((((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[0]*F4 + K[3]*F5 + K[6]*F6)) + (-1.0)*(((K[0]*F7 + K[3]*F8 + K[6]*F9))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)))))) + ((K[2]*F1 + K[5]*F2 + K[8]*F3))*((((K[0]*F7 + K[3]*F8 + K[6]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6)) + (-1.0)*((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))))))*2.0)*(std::log((((((K[0]*F1 + K[3]*F2 + K[6]*F3) + 1.0))*(((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + (-1.0)*(((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6))))) + ((K[1]*F1 + K[4]*F2 + K[7]*F3))*((((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[0]*F4 + K[3]*F5 + K[6]*F6)) + (-1.0)*(((K[0]*F7 + K[3]*F8 + K[6]*F9))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)))))) + ((K[2]*F1 + K[5]*F2 + K[8]*F3))*((((K[0]*F7 + K[3]*F8 + K[6]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6)) + (-1.0)*((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))))))*F10/(2.0) + ((((((((((((K[0]*FE1_C1_D100[ip][j] + K[3]*FE1_C1_D010[ip][j] + K[6]*FE1_C1_D001[ip][j]))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + ((K[2]*FE1_C2_D100[ip][j] + K[5]*FE1_C2_D010[ip][j] + K[8]*FE1_C2_D001[ip][j]))*((K[0]*F7 + K[3]*F8 + K[6]*F9))))*(-1.0) + (((K[0]*FE1_C2_D100[ip][j] + K[3]*FE1_C2_D010[ip][j] + K[6]*FE1_C2_D001[ip][j]))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE1_C1_D100[ip][j] + K[5]*FE1_C1_D010[ip][j] + K[8]*FE1_C1_D001[ip][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE1_C0_D100[ip][j] + K[4]*FE1_C0_D010[ip][j] + K[7]*FE1_C0_D001[ip][j]))*((((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[0]*F4 + K[3]*F5 + K[6]*F6)) + (-1.0)*(((K[0]*F7 + K[3]*F8 + K[6]*F9))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)))))) + (((((((K[1]*FE1_C2_D100[ip][j] + K[4]*FE1_C2_D010[ip][j] + K[7]*FE1_C2_D001[ip][j]))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE1_C1_D100[ip][j] + K[5]*FE1_C1_D010[ip][j] + K[8]*FE1_C1_D001[ip][j]))*((K[1]*F4 + K[4]*F5 + K[7]*F6))))*(-1.0) + (((K[1]*FE1_C1_D100[ip][j] + K[4]*FE1_C1_D010[ip][j] + K[7]*FE1_C1_D001[ip][j]))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + ((K[2]*FE1_C2_D100[ip][j] + K[5]*FE1_C2_D010[ip][j] + K[8]*FE1_C2_D001[ip][j]))*(((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0)))))*(((K[0]*F1 + K[3]*F2 + K[6]*F3) + 1.0)) + ((K[0]*FE1_C0_D100[ip][j] + K[3]*FE1_C0_D010[ip][j] + K[6]*FE1_C0_D001[ip][j]))*(((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + (-1.0)*(((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6))))))) + (((((((K[0]*FE1_C2_D100[ip][j] + K[3]*FE1_C2_D010[ip][j] + K[6]*FE1_C2_D001[ip][j]))*(((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0)) + ((K[1]*FE1_C1_D100[ip][j] + K[4]*FE1_C1_D010[ip][j] + K[7]*FE1_C1_D001[ip][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE1_C1_D100[ip][j] + K[3]*FE1_C1_D010[ip][j] + K[6]*FE1_C1_D001[ip][j]))*((K[1]*F4 + K[4]*F5 + K[7]*F6)) + ((K[1]*FE1_C2_D100[ip][j] + K[4]*FE1_C2_D010[ip][j] + K[7]*FE1_C2_D001[ip][j]))*((K[0]*F7 + K[3]*F8 + K[6]*F9)))))*((K[2]*F1 + K[5]*F2 + K[8]*F3)) + ((K[2]*FE1_C0_D100[ip][j] + K[5]*FE1_C0_D010[ip][j] + K[8]*FE1_C0_D001[ip][j]))*((((K[0]*F7 + K[3]*F8 + K[6]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6)) + (-1.0)*((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))))/((((((K[0]*F1 + K[3]*F2 + K[6]*F3) + 1.0))*(((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + (-1.0)*(((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6))))) + ((K[1]*F1 + K[4]*F2 + K[7]*F3))*((((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[0]*F4 + K[3]*F5 + K[6]*F6)) + (-1.0)*(((K[0]*F7 + K[3]*F8 + K[6]*F9))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)))))) + ((K[2]*F1 + K[5]*F2 + K[8]*F3))*((((K[0]*F7 + K[3]*F8 + K[6]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6)) + (-1.0)*((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))))))*F0)*(-1.0) + (((2.0*(((K[0]*FE1_C0_D100[ip][j] + K[3]*FE1_C0_D010[ip][j] + K[6]*FE1_C0_D001[ip][j]))*(((K[0]*F1 + K[3]*F2 + K[6]*F3) + 1.0))) + 2.0*(((K[0]*FE1_C1_D100[ip][j] + K[3]*FE1_C1_D010[ip][j] + K[6]*FE1_C1_D001[ip][j]))*((K[0]*F7 + K[3]*F8 + K[6]*F9))) + 2.0*(((K[0]*FE1_C2_D100[ip][j] + K[3]*FE1_C2_D010[ip][j] + K[6]*FE1_C2_D001[ip][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))) + (2.0*(((K[1]*FE1_C0_D100[ip][j] + K[4]*FE1_C0_D010[ip][j] + K[7]*FE1_C0_D001[ip][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))) + 2.0*(((K[1]*FE1_C1_D100[ip][j] + K[4]*FE1_C1_D010[ip][j] + K[7]*FE1_C1_D001[ip][j]))*(((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))) + 2.0*(((K[1]*FE1_C2_D100[ip][j] + K[4]*FE1_C2_D010[ip][j] + K[7]*FE1_C2_D001[ip][j]))*((K[1]*F4 + K[4]*F5 + K[7]*F6)))) + (2.0*(((K[2]*FE1_C0_D100[ip][j] + K[5]*FE1_C0_D010[ip][j] + K[8]*FE1_C0_D001[ip][j]))*((K[2]*F1 + K[5]*F2 + K[8]*F3))) + 2.0*(((K[2]*FE1_C1_D100[ip][j] + K[5]*FE1_C1_D010[ip][j] + K[8]*FE1_C1_D001[ip][j]))*((K[2]*F7 + K[5]*F8 + K[8]*F9))) + 2.0*(((K[2]*FE1_C2_D100[ip][j] + K[5]*FE1_C2_D010[ip][j] + K[8]*FE1_C2_D001[ip][j]))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0))))))*F0/(2.0))) + ((FE1_C0[ip][j]*F11 + FE1_C1[ip][j]*F12 + FE1_C2[ip][j]*F13))*(-1.0))*W4[ip]*det;
      } // end loop over 'j'
    } // end loop over 'ip'
  }

};


class hyperelasticity_exterior_facet_integral_0_otherwise: public ufc::exterior_facet_integral
{
public:

  hyperelasticity_exterior_facet_integral_0_otherwise() : ufc::exterior_facet_integral()
  {
    
  }

  ~hyperelasticity_exterior_facet_integral_0_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({false, false, true, false, false});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       std::size_t facet,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      59
    // Number of operations (multiply-add pairs) for geometry tensor:    12
    // Number of operations (multiply-add pairs) for tensor contraction: 90
    // Total number of operations (multiply-add pairs):                  161
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Get vertices on face
    static unsigned int face_vertices[4][3] = {{1, 2, 3}, {0, 2, 3}, {0, 1, 3}, {0, 1, 2}};
    const unsigned int v0 = face_vertices[facet][0];
    const unsigned int v1 = face_vertices[facet][1];
    const unsigned int v2 = face_vertices[facet][2];
    
    // Compute scale factor (area of face scaled by area of reference triangle)
    const double a0 = (coordinate_dofs[3*v0 + 1]*coordinate_dofs[3*v1 + 2]  + coordinate_dofs[3*v0 + 2]*coordinate_dofs[3*v2 + 1]  + coordinate_dofs[3*v1 + 1]*coordinate_dofs[3*v2 + 2]) - (coordinate_dofs[3*v2 + 1]*coordinate_dofs[3*v1 + 2] + coordinate_dofs[3*v2 + 2]*coordinate_dofs[3*v0 + 1] + coordinate_dofs[3*v1 + 1]*coordinate_dofs[3*v0 + 2]);
    
    const double a1 = (coordinate_dofs[3*v0 + 2]*coordinate_dofs[3*v1 + 0]  + coordinate_dofs[3*v0 + 0]*coordinate_dofs[3*v2 + 2] + coordinate_dofs[3*v1 + 2]*coordinate_dofs[3*v2 + 0]) - (coordinate_dofs[3*v2 + 2]*coordinate_dofs[3*v1 + 0]  + coordinate_dofs[3*v2 + 0]*coordinate_dofs[3*v0 + 2] + coordinate_dofs[3*v1 + 2]*coordinate_dofs[3*v0 + 0]);
    
    const double a2 = (coordinate_dofs[3*v0 + 0]*coordinate_dofs[3*v1 + 1]  + coordinate_dofs[3*v0 + 1]*coordinate_dofs[3*v2 + 0]  + coordinate_dofs[3*v1 + 0]*coordinate_dofs[3*v2 + 1]) - (coordinate_dofs[3*v2 + 0]*coordinate_dofs[3*v1 + 1]  + coordinate_dofs[3*v2 + 1]*coordinate_dofs[3*v0 + 0]  + coordinate_dofs[3*v1 + 0]*coordinate_dofs[3*v0 + 1]);
    
    const double det = std::sqrt(a0*a0 + a1*a1 + a2*a2);
    
    
    // Compute geometry tensor
    const double G0_0 = det*w[2][0]*(1.0);
    const double G0_1 = det*w[2][1]*(1.0);
    const double G0_2 = det*w[2][2]*(1.0);
    const double G0_3 = det*w[2][3]*(1.0);
    const double G0_4 = det*w[2][4]*(1.0);
    const double G0_5 = det*w[2][5]*(1.0);
    const double G0_6 = det*w[2][6]*(1.0);
    const double G0_7 = det*w[2][7]*(1.0);
    const double G0_8 = det*w[2][8]*(1.0);
    const double G0_9 = det*w[2][9]*(1.0);
    const double G0_10 = det*w[2][10]*(1.0);
    const double G0_11 = det*w[2][11]*(1.0);
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.0;
      A[1] = -0.0833333333333333*G0_1 - 0.0416666666666667*G0_2 - 0.0416666666666667*G0_3;
      A[2] = -0.0416666666666667*G0_1 - 0.0833333333333333*G0_2 - 0.0416666666666667*G0_3;
      A[3] = -0.0416666666666667*G0_1 - 0.0416666666666667*G0_2 - 0.0833333333333333*G0_3;
      A[4] = 0.0;
      A[5] = -0.0833333333333333*G0_5 - 0.0416666666666667*G0_6 - 0.0416666666666667*G0_7;
      A[6] = -0.0416666666666667*G0_5 - 0.0833333333333333*G0_6 - 0.0416666666666667*G0_7;
      A[7] = -0.0416666666666667*G0_5 - 0.0416666666666667*G0_6 - 0.0833333333333333*G0_7;
      A[8] = 0.0;
      A[9] = -0.0833333333333333*G0_9 - 0.0416666666666667*G0_10 - 0.0416666666666667*G0_11;
      A[10] = -0.0416666666666667*G0_9 - 0.0833333333333333*G0_10 - 0.0416666666666667*G0_11;
      A[11] = -0.0416666666666667*G0_9 - 0.0416666666666667*G0_10 - 0.0833333333333333*G0_11;
        break;
      }
    case 1:
      {
        A[0] = -0.0833333333333334*G0_0 - 0.0416666666666667*G0_2 - 0.0416666666666667*G0_3;
      A[1] = 0.0;
      A[2] = -0.0416666666666667*G0_0 - 0.0833333333333333*G0_2 - 0.0416666666666667*G0_3;
      A[3] = -0.0416666666666667*G0_0 - 0.0416666666666667*G0_2 - 0.0833333333333333*G0_3;
      A[4] = -0.0833333333333334*G0_4 - 0.0416666666666667*G0_6 - 0.0416666666666667*G0_7;
      A[5] = 0.0;
      A[6] = -0.0416666666666667*G0_4 - 0.0833333333333333*G0_6 - 0.0416666666666667*G0_7;
      A[7] = -0.0416666666666667*G0_4 - 0.0416666666666667*G0_6 - 0.0833333333333333*G0_7;
      A[8] = -0.0833333333333334*G0_8 - 0.0416666666666667*G0_10 - 0.0416666666666667*G0_11;
      A[9] = 0.0;
      A[10] = -0.0416666666666667*G0_8 - 0.0833333333333333*G0_10 - 0.0416666666666667*G0_11;
      A[11] = -0.0416666666666667*G0_8 - 0.0416666666666667*G0_10 - 0.0833333333333333*G0_11;
        break;
      }
    case 2:
      {
        A[0] = -0.0833333333333333*G0_0 - 0.0416666666666667*G0_1 - 0.0416666666666667*G0_3;
      A[1] = -0.0416666666666667*G0_0 - 0.0833333333333333*G0_1 - 0.0416666666666667*G0_3;
      A[2] = 0.0;
      A[3] = -0.0416666666666667*G0_0 - 0.0416666666666666*G0_1 - 0.0833333333333333*G0_3;
      A[4] = -0.0833333333333333*G0_4 - 0.0416666666666667*G0_5 - 0.0416666666666667*G0_7;
      A[5] = -0.0416666666666667*G0_4 - 0.0833333333333333*G0_5 - 0.0416666666666667*G0_7;
      A[6] = 0.0;
      A[7] = -0.0416666666666667*G0_4 - 0.0416666666666666*G0_5 - 0.0833333333333333*G0_7;
      A[8] = -0.0833333333333333*G0_8 - 0.0416666666666667*G0_9 - 0.0416666666666667*G0_11;
      A[9] = -0.0416666666666667*G0_8 - 0.0833333333333333*G0_9 - 0.0416666666666667*G0_11;
      A[10] = 0.0;
      A[11] = -0.0416666666666667*G0_8 - 0.0416666666666666*G0_9 - 0.0833333333333333*G0_11;
        break;
      }
    case 3:
      {
        A[0] = -0.0833333333333334*G0_0 - 0.0416666666666667*G0_1 - 0.0416666666666667*G0_2;
      A[1] = -0.0416666666666667*G0_0 - 0.0833333333333333*G0_1 - 0.0416666666666666*G0_2;
      A[2] = -0.0416666666666667*G0_0 - 0.0416666666666666*G0_1 - 0.0833333333333333*G0_2;
      A[3] = 0.0;
      A[4] = -0.0833333333333334*G0_4 - 0.0416666666666667*G0_5 - 0.0416666666666667*G0_6;
      A[5] = -0.0416666666666667*G0_4 - 0.0833333333333333*G0_5 - 0.0416666666666666*G0_6;
      A[6] = -0.0416666666666667*G0_4 - 0.0416666666666666*G0_5 - 0.0833333333333333*G0_6;
      A[7] = 0.0;
      A[8] = -0.0833333333333334*G0_8 - 0.0416666666666667*G0_9 - 0.0416666666666667*G0_10;
      A[9] = -0.0416666666666667*G0_8 - 0.0833333333333333*G0_9 - 0.0416666666666666*G0_10;
      A[10] = -0.0416666666666667*G0_8 - 0.0416666666666666*G0_9 - 0.0833333333333333*G0_10;
      A[11] = 0.0;
        break;
      }
    }
    
  }

};


class hyperelasticity_cell_integral_1_otherwise: public ufc::cell_integral
{
public:

  hyperelasticity_cell_integral_1_otherwise() : ufc::cell_integral()
  {
    
  }

  ~hyperelasticity_cell_integral_1_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({true, true, true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute cell volume
    
    
    // Compute circumradius
    
    
    // Array of quadrature weights.
    static const double W1 = 0.166666666666667;
    // Quadrature points on the UFC reference element: (0.25, 0.25, 0.25)
    
    // Values of basis functions at quadrature points.
    static const double FE0[1][1] = \
    {{1.0}};
    
    static const double FE1_C0_D001[1][12] = \
    {{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE1_C0_D010[1][12] = \
    {{-1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE1_C0_D100[1][12] = \
    {{-1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE1_C1_D001[1][12] = \
    {{0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE1_C1_D010[1][12] = \
    {{0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE1_C1_D100[1][12] = \
    {{0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE1_C2_D001[1][12] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0}};
    
    static const double FE1_C2_D010[1][12] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0}};
    
    static const double FE1_C2_D100[1][12] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 144; r++)
    {
      A[r] = 0.0;
    } // end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', False), ('ignore ones', False), ('ignore zero tables', False), ('optimisation', False), ('remove zero terms', False)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 492268
    for (unsigned int ip = 0; ip < 1; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      double F1 = 0.0;
      double F2 = 0.0;
      double F3 = 0.0;
      double F4 = 0.0;
      double F5 = 0.0;
      double F6 = 0.0;
      double F7 = 0.0;
      double F8 = 0.0;
      double F9 = 0.0;
      double F10 = 0.0;
      
      // Total number of operations to compute function values = 4
      for (unsigned int r = 0; r < 1; r++)
      {
        F0 += FE0[0][0]*w[1][0];
        F10 += FE0[0][0]*w[2][0];
      } // end loop over 'r'
      
      // Total number of operations to compute function values = 216
      for (unsigned int r = 0; r < 12; r++)
      {
        F1 += FE1_C2_D100[0][r]*w[0][r];
        F2 += FE1_C2_D010[0][r]*w[0][r];
        F3 += FE1_C2_D001[0][r]*w[0][r];
        F4 += FE1_C1_D100[0][r]*w[0][r];
        F5 += FE1_C1_D010[0][r]*w[0][r];
        F6 += FE1_C1_D001[0][r]*w[0][r];
        F7 += FE1_C0_D100[0][r]*w[0][r];
        F8 += FE1_C0_D010[0][r]*w[0][r];
        F9 += FE1_C0_D001[0][r]*w[0][r];
      } // end loop over 'r'
      
      // Number of operations for primary indices: 492048
      for (unsigned int j = 0; j < 12; j++)
      {
        for (unsigned int k = 0; k < 12; k++)
        {
          // Number of operations to compute entry: 3417
          A[j*12 + k] += (((((((((((((((((K[0]*FE1_C1_D100[0][k] + K[3]*FE1_C1_D010[0][k] + K[6]*FE1_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][k] + K[5]*FE1_C2_D010[0][k] + K[8]*FE1_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE1_C2_D100[0][k] + K[3]*FE1_C2_D010[0][k] + K[6]*FE1_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][k] + K[5]*FE1_C1_D010[0][k] + K[8]*FE1_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))*((K[1]*F7 + K[4]*F8 + K[7]*F9)) + ((K[1]*FE1_C0_D100[0][k] + K[4]*FE1_C0_D010[0][k] + K[7]*FE1_C0_D001[0][k]))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + (((((((K[1]*FE1_C2_D100[0][k] + K[4]*FE1_C2_D010[0][k] + K[7]*FE1_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][k] + K[5]*FE1_C1_D010[0][k] + K[8]*FE1_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE1_C1_D100[0][k] + K[4]*FE1_C1_D010[0][k] + K[7]*FE1_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][k] + K[5]*FE1_C2_D010[0][k] + K[8]*FE1_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)))))*(((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0)) + ((K[0]*FE1_C0_D100[0][k] + K[3]*FE1_C0_D010[0][k] + K[6]*FE1_C0_D001[0][k]))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))))) + (((((((K[0]*FE1_C2_D100[0][k] + K[3]*FE1_C2_D010[0][k] + K[6]*FE1_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE1_C1_D100[0][k] + K[4]*FE1_C1_D010[0][k] + K[7]*FE1_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE1_C1_D100[0][k] + K[3]*FE1_C1_D010[0][k] + K[6]*FE1_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE1_C2_D100[0][k] + K[4]*FE1_C2_D010[0][k] + K[7]*FE1_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE1_C0_D100[0][k] + K[5]*FE1_C0_D010[0][k] + K[8]*FE1_C0_D001[0][k]))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))))))*((((((((((K[0]*FE1_C1_D100[0][j] + K[3]*FE1_C1_D010[0][j] + K[6]*FE1_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][j] + K[5]*FE1_C2_D010[0][j] + K[8]*FE1_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE1_C2_D100[0][j] + K[3]*FE1_C2_D010[0][j] + K[6]*FE1_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][j] + K[5]*FE1_C1_D010[0][j] + K[8]*FE1_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))*((K[1]*F7 + K[4]*F8 + K[7]*F9)) + ((K[1]*FE1_C0_D100[0][j] + K[4]*FE1_C0_D010[0][j] + K[7]*FE1_C0_D001[0][j]))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + (((((((K[1]*FE1_C2_D100[0][j] + K[4]*FE1_C2_D010[0][j] + K[7]*FE1_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][j] + K[5]*FE1_C1_D010[0][j] + K[8]*FE1_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE1_C1_D100[0][j] + K[4]*FE1_C1_D010[0][j] + K[7]*FE1_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][j] + K[5]*FE1_C2_D010[0][j] + K[8]*FE1_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)))))*(((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0)) + ((K[0]*FE1_C0_D100[0][j] + K[3]*FE1_C0_D010[0][j] + K[6]*FE1_C0_D001[0][j]))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))))) + (((((((K[0]*FE1_C2_D100[0][j] + K[3]*FE1_C2_D010[0][j] + K[6]*FE1_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE1_C1_D100[0][j] + K[4]*FE1_C1_D010[0][j] + K[7]*FE1_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE1_C1_D100[0][j] + K[3]*FE1_C1_D010[0][j] + K[6]*FE1_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE1_C2_D100[0][j] + K[4]*FE1_C2_D010[0][j] + K[7]*FE1_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE1_C0_D100[0][j] + K[5]*FE1_C0_D010[0][j] + K[8]*FE1_C0_D001[0][j]))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))))/((((((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))) + ((K[1]*F7 + K[4]*F8 + K[7]*F9))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + ((K[2]*F7 + K[5]*F8 + K[8]*F9))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))))))*(-1.0) + ((((((((((K[0]*FE1_C1_D100[0][j] + K[3]*FE1_C1_D010[0][j] + K[6]*FE1_C1_D001[0][j]))*((K[2]*FE1_C2_D100[0][k] + K[5]*FE1_C2_D010[0][k] + K[8]*FE1_C2_D001[0][k])) + ((K[0]*FE1_C1_D100[0][k] + K[3]*FE1_C1_D010[0][k] + K[6]*FE1_C1_D001[0][k]))*((K[2]*FE1_C2_D100[0][j] + K[5]*FE1_C2_D010[0][j] + K[8]*FE1_C2_D001[0][j]))))*(-1.0) + (((K[2]*FE1_C1_D100[0][j] + K[5]*FE1_C1_D010[0][j] + K[8]*FE1_C1_D001[0][j]))*((K[0]*FE1_C2_D100[0][k] + K[3]*FE1_C2_D010[0][k] + K[6]*FE1_C2_D001[0][k])) + ((K[2]*FE1_C1_D100[0][k] + K[5]*FE1_C1_D010[0][k] + K[8]*FE1_C1_D001[0][k]))*((K[0]*FE1_C2_D100[0][j] + K[3]*FE1_C2_D010[0][j] + K[6]*FE1_C2_D001[0][j])))))*((K[1]*F7 + K[4]*F8 + K[7]*F9)) + ((K[1]*FE1_C0_D100[0][k] + K[4]*FE1_C0_D010[0][k] + K[7]*FE1_C0_D001[0][k]))*((((((K[0]*FE1_C1_D100[0][j] + K[3]*FE1_C1_D010[0][j] + K[6]*FE1_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][j] + K[5]*FE1_C2_D010[0][j] + K[8]*FE1_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE1_C2_D100[0][j] + K[3]*FE1_C2_D010[0][j] + K[6]*FE1_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][j] + K[5]*FE1_C1_D010[0][j] + K[8]*FE1_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))) + ((K[1]*FE1_C0_D100[0][j] + K[4]*FE1_C0_D010[0][j] + K[7]*FE1_C0_D001[0][j]))*((((((K[0]*FE1_C1_D100[0][k] + K[3]*FE1_C1_D010[0][k] + K[6]*FE1_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][k] + K[5]*FE1_C2_D010[0][k] + K[8]*FE1_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE1_C2_D100[0][k] + K[3]*FE1_C2_D010[0][k] + K[6]*FE1_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][k] + K[5]*FE1_C1_D010[0][k] + K[8]*FE1_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))) + ((((((((K[2]*FE1_C1_D100[0][j] + K[5]*FE1_C1_D010[0][j] + K[8]*FE1_C1_D001[0][j]))*((K[1]*FE1_C2_D100[0][k] + K[4]*FE1_C2_D010[0][k] + K[7]*FE1_C2_D001[0][k])) + ((K[2]*FE1_C1_D100[0][k] + K[5]*FE1_C1_D010[0][k] + K[8]*FE1_C1_D001[0][k]))*((K[1]*FE1_C2_D100[0][j] + K[4]*FE1_C2_D010[0][j] + K[7]*FE1_C2_D001[0][j]))))*(-1.0) + (((K[1]*FE1_C1_D100[0][j] + K[4]*FE1_C1_D010[0][j] + K[7]*FE1_C1_D001[0][j]))*((K[2]*FE1_C2_D100[0][k] + K[5]*FE1_C2_D010[0][k] + K[8]*FE1_C2_D001[0][k])) + ((K[1]*FE1_C1_D100[0][k] + K[4]*FE1_C1_D010[0][k] + K[7]*FE1_C1_D001[0][k]))*((K[2]*FE1_C2_D100[0][j] + K[5]*FE1_C2_D010[0][j] + K[8]*FE1_C2_D001[0][j])))))*(((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0)) + ((K[0]*FE1_C0_D100[0][k] + K[3]*FE1_C0_D010[0][k] + K[6]*FE1_C0_D001[0][k]))*((((((K[1]*FE1_C2_D100[0][j] + K[4]*FE1_C2_D010[0][j] + K[7]*FE1_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][j] + K[5]*FE1_C1_D010[0][j] + K[8]*FE1_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE1_C1_D100[0][j] + K[4]*FE1_C1_D010[0][j] + K[7]*FE1_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][j] + K[5]*FE1_C2_D010[0][j] + K[8]*FE1_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)))))) + ((K[0]*FE1_C0_D100[0][j] + K[3]*FE1_C0_D010[0][j] + K[6]*FE1_C0_D001[0][j]))*((((((K[1]*FE1_C2_D100[0][k] + K[4]*FE1_C2_D010[0][k] + K[7]*FE1_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][k] + K[5]*FE1_C1_D010[0][k] + K[8]*FE1_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE1_C1_D100[0][k] + K[4]*FE1_C1_D010[0][k] + K[7]*FE1_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][k] + K[5]*FE1_C2_D010[0][k] + K[8]*FE1_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))))))) + ((((((((K[1]*FE1_C1_D100[0][j] + K[4]*FE1_C1_D010[0][j] + K[7]*FE1_C1_D001[0][j]))*((K[0]*FE1_C2_D100[0][k] + K[3]*FE1_C2_D010[0][k] + K[6]*FE1_C2_D001[0][k])) + ((K[1]*FE1_C1_D100[0][k] + K[4]*FE1_C1_D010[0][k] + K[7]*FE1_C1_D001[0][k]))*((K[0]*FE1_C2_D100[0][j] + K[3]*FE1_C2_D010[0][j] + K[6]*FE1_C2_D001[0][j]))))*(-1.0) + (((K[0]*FE1_C1_D100[0][j] + K[3]*FE1_C1_D010[0][j] + K[6]*FE1_C1_D001[0][j]))*((K[1]*FE1_C2_D100[0][k] + K[4]*FE1_C2_D010[0][k] + K[7]*FE1_C2_D001[0][k])) + ((K[0]*FE1_C1_D100[0][k] + K[3]*FE1_C1_D010[0][k] + K[6]*FE1_C1_D001[0][k]))*((K[1]*FE1_C2_D100[0][j] + K[4]*FE1_C2_D010[0][j] + K[7]*FE1_C2_D001[0][j])))))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE1_C0_D100[0][k] + K[5]*FE1_C0_D010[0][k] + K[8]*FE1_C0_D001[0][k]))*((((((K[0]*FE1_C2_D100[0][j] + K[3]*FE1_C2_D010[0][j] + K[6]*FE1_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE1_C1_D100[0][j] + K[4]*FE1_C1_D010[0][j] + K[7]*FE1_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE1_C1_D100[0][j] + K[3]*FE1_C1_D010[0][j] + K[6]*FE1_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE1_C2_D100[0][j] + K[4]*FE1_C2_D010[0][j] + K[7]*FE1_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))) + ((K[2]*FE1_C0_D100[0][j] + K[5]*FE1_C0_D010[0][j] + K[8]*FE1_C0_D001[0][j]))*((((((K[0]*FE1_C2_D100[0][k] + K[3]*FE1_C2_D010[0][k] + K[6]*FE1_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE1_C1_D100[0][k] + K[4]*FE1_C1_D010[0][k] + K[7]*FE1_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE1_C1_D100[0][k] + K[3]*FE1_C1_D010[0][k] + K[6]*FE1_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE1_C2_D100[0][k] + K[4]*FE1_C2_D010[0][k] + K[7]*FE1_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))))))/((((((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))) + ((K[1]*F7 + K[4]*F8 + K[7]*F9))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + ((K[2]*F7 + K[5]*F8 + K[8]*F9))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))))))*2.0)*(std::log((((((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))) + ((K[1]*F7 + K[4]*F8 + K[7]*F9))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + ((K[2]*F7 + K[5]*F8 + K[8]*F9))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))))) + (((((((((((K[0]*FE1_C1_D100[0][j] + K[3]*FE1_C1_D010[0][j] + K[6]*FE1_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][j] + K[5]*FE1_C2_D010[0][j] + K[8]*FE1_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE1_C2_D100[0][j] + K[3]*FE1_C2_D010[0][j] + K[6]*FE1_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][j] + K[5]*FE1_C1_D010[0][j] + K[8]*FE1_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))*((K[1]*F7 + K[4]*F8 + K[7]*F9)) + ((K[1]*FE1_C0_D100[0][j] + K[4]*FE1_C0_D010[0][j] + K[7]*FE1_C0_D001[0][j]))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + (((((((K[1]*FE1_C2_D100[0][j] + K[4]*FE1_C2_D010[0][j] + K[7]*FE1_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][j] + K[5]*FE1_C1_D010[0][j] + K[8]*FE1_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE1_C1_D100[0][j] + K[4]*FE1_C1_D010[0][j] + K[7]*FE1_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][j] + K[5]*FE1_C2_D010[0][j] + K[8]*FE1_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)))))*(((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0)) + ((K[0]*FE1_C0_D100[0][j] + K[3]*FE1_C0_D010[0][j] + K[6]*FE1_C0_D001[0][j]))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))))) + (((((((K[0]*FE1_C2_D100[0][j] + K[3]*FE1_C2_D010[0][j] + K[6]*FE1_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE1_C1_D100[0][j] + K[4]*FE1_C1_D010[0][j] + K[7]*FE1_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE1_C1_D100[0][j] + K[3]*FE1_C1_D010[0][j] + K[6]*FE1_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE1_C2_D100[0][j] + K[4]*FE1_C2_D010[0][j] + K[7]*FE1_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE1_C0_D100[0][j] + K[5]*FE1_C0_D010[0][j] + K[8]*FE1_C0_D001[0][j]))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))))/((((((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))) + ((K[1]*F7 + K[4]*F8 + K[7]*F9))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + ((K[2]*F7 + K[5]*F8 + K[8]*F9))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))))))*2.0)*((((((((((K[0]*FE1_C1_D100[0][k] + K[3]*FE1_C1_D010[0][k] + K[6]*FE1_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][k] + K[5]*FE1_C2_D010[0][k] + K[8]*FE1_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE1_C2_D100[0][k] + K[3]*FE1_C2_D010[0][k] + K[6]*FE1_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][k] + K[5]*FE1_C1_D010[0][k] + K[8]*FE1_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))*((K[1]*F7 + K[4]*F8 + K[7]*F9)) + ((K[1]*FE1_C0_D100[0][k] + K[4]*FE1_C0_D010[0][k] + K[7]*FE1_C0_D001[0][k]))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + (((((((K[1]*FE1_C2_D100[0][k] + K[4]*FE1_C2_D010[0][k] + K[7]*FE1_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][k] + K[5]*FE1_C1_D010[0][k] + K[8]*FE1_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE1_C1_D100[0][k] + K[4]*FE1_C1_D010[0][k] + K[7]*FE1_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][k] + K[5]*FE1_C2_D010[0][k] + K[8]*FE1_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)))))*(((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0)) + ((K[0]*FE1_C0_D100[0][k] + K[3]*FE1_C0_D010[0][k] + K[6]*FE1_C0_D001[0][k]))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))))) + (((((((K[0]*FE1_C2_D100[0][k] + K[3]*FE1_C2_D010[0][k] + K[6]*FE1_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE1_C1_D100[0][k] + K[4]*FE1_C1_D010[0][k] + K[7]*FE1_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE1_C1_D100[0][k] + K[3]*FE1_C1_D010[0][k] + K[6]*FE1_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE1_C2_D100[0][k] + K[4]*FE1_C2_D010[0][k] + K[7]*FE1_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE1_C0_D100[0][k] + K[5]*FE1_C0_D010[0][k] + K[8]*FE1_C0_D001[0][k]))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))))/((((((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))) + ((K[1]*F7 + K[4]*F8 + K[7]*F9))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + ((K[2]*F7 + K[5]*F8 + K[8]*F9))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))))))))*F10/(2.0) + (((((((((((((((K[0]*FE1_C1_D100[0][k] + K[3]*FE1_C1_D010[0][k] + K[6]*FE1_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][k] + K[5]*FE1_C2_D010[0][k] + K[8]*FE1_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE1_C2_D100[0][k] + K[3]*FE1_C2_D010[0][k] + K[6]*FE1_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][k] + K[5]*FE1_C1_D010[0][k] + K[8]*FE1_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))*((K[1]*F7 + K[4]*F8 + K[7]*F9)) + ((K[1]*FE1_C0_D100[0][k] + K[4]*FE1_C0_D010[0][k] + K[7]*FE1_C0_D001[0][k]))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + (((((((K[1]*FE1_C2_D100[0][k] + K[4]*FE1_C2_D010[0][k] + K[7]*FE1_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][k] + K[5]*FE1_C1_D010[0][k] + K[8]*FE1_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE1_C1_D100[0][k] + K[4]*FE1_C1_D010[0][k] + K[7]*FE1_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][k] + K[5]*FE1_C2_D010[0][k] + K[8]*FE1_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)))))*(((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0)) + ((K[0]*FE1_C0_D100[0][k] + K[3]*FE1_C0_D010[0][k] + K[6]*FE1_C0_D001[0][k]))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))))) + (((((((K[0]*FE1_C2_D100[0][k] + K[3]*FE1_C2_D010[0][k] + K[6]*FE1_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE1_C1_D100[0][k] + K[4]*FE1_C1_D010[0][k] + K[7]*FE1_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE1_C1_D100[0][k] + K[3]*FE1_C1_D010[0][k] + K[6]*FE1_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE1_C2_D100[0][k] + K[4]*FE1_C2_D010[0][k] + K[7]*FE1_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE1_C0_D100[0][k] + K[5]*FE1_C0_D010[0][k] + K[8]*FE1_C0_D001[0][k]))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))))))*((((((((((K[0]*FE1_C1_D100[0][j] + K[3]*FE1_C1_D010[0][j] + K[6]*FE1_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][j] + K[5]*FE1_C2_D010[0][j] + K[8]*FE1_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE1_C2_D100[0][j] + K[3]*FE1_C2_D010[0][j] + K[6]*FE1_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][j] + K[5]*FE1_C1_D010[0][j] + K[8]*FE1_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))*((K[1]*F7 + K[4]*F8 + K[7]*F9)) + ((K[1]*FE1_C0_D100[0][j] + K[4]*FE1_C0_D010[0][j] + K[7]*FE1_C0_D001[0][j]))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + (((((((K[1]*FE1_C2_D100[0][j] + K[4]*FE1_C2_D010[0][j] + K[7]*FE1_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][j] + K[5]*FE1_C1_D010[0][j] + K[8]*FE1_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE1_C1_D100[0][j] + K[4]*FE1_C1_D010[0][j] + K[7]*FE1_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][j] + K[5]*FE1_C2_D010[0][j] + K[8]*FE1_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)))))*(((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0)) + ((K[0]*FE1_C0_D100[0][j] + K[3]*FE1_C0_D010[0][j] + K[6]*FE1_C0_D001[0][j]))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))))) + (((((((K[0]*FE1_C2_D100[0][j] + K[3]*FE1_C2_D010[0][j] + K[6]*FE1_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE1_C1_D100[0][j] + K[4]*FE1_C1_D010[0][j] + K[7]*FE1_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE1_C1_D100[0][j] + K[3]*FE1_C1_D010[0][j] + K[6]*FE1_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE1_C2_D100[0][j] + K[4]*FE1_C2_D010[0][j] + K[7]*FE1_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE1_C0_D100[0][j] + K[5]*FE1_C0_D010[0][j] + K[8]*FE1_C0_D001[0][j]))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))))/((((((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))) + ((K[1]*F7 + K[4]*F8 + K[7]*F9))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + ((K[2]*F7 + K[5]*F8 + K[8]*F9))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))))))*(-1.0) + ((((((((((K[0]*FE1_C1_D100[0][j] + K[3]*FE1_C1_D010[0][j] + K[6]*FE1_C1_D001[0][j]))*((K[2]*FE1_C2_D100[0][k] + K[5]*FE1_C2_D010[0][k] + K[8]*FE1_C2_D001[0][k])) + ((K[0]*FE1_C1_D100[0][k] + K[3]*FE1_C1_D010[0][k] + K[6]*FE1_C1_D001[0][k]))*((K[2]*FE1_C2_D100[0][j] + K[5]*FE1_C2_D010[0][j] + K[8]*FE1_C2_D001[0][j]))))*(-1.0) + (((K[2]*FE1_C1_D100[0][j] + K[5]*FE1_C1_D010[0][j] + K[8]*FE1_C1_D001[0][j]))*((K[0]*FE1_C2_D100[0][k] + K[3]*FE1_C2_D010[0][k] + K[6]*FE1_C2_D001[0][k])) + ((K[2]*FE1_C1_D100[0][k] + K[5]*FE1_C1_D010[0][k] + K[8]*FE1_C1_D001[0][k]))*((K[0]*FE1_C2_D100[0][j] + K[3]*FE1_C2_D010[0][j] + K[6]*FE1_C2_D001[0][j])))))*((K[1]*F7 + K[4]*F8 + K[7]*F9)) + ((K[1]*FE1_C0_D100[0][k] + K[4]*FE1_C0_D010[0][k] + K[7]*FE1_C0_D001[0][k]))*((((((K[0]*FE1_C1_D100[0][j] + K[3]*FE1_C1_D010[0][j] + K[6]*FE1_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][j] + K[5]*FE1_C2_D010[0][j] + K[8]*FE1_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE1_C2_D100[0][j] + K[3]*FE1_C2_D010[0][j] + K[6]*FE1_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][j] + K[5]*FE1_C1_D010[0][j] + K[8]*FE1_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))) + ((K[1]*FE1_C0_D100[0][j] + K[4]*FE1_C0_D010[0][j] + K[7]*FE1_C0_D001[0][j]))*((((((K[0]*FE1_C1_D100[0][k] + K[3]*FE1_C1_D010[0][k] + K[6]*FE1_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][k] + K[5]*FE1_C2_D010[0][k] + K[8]*FE1_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE1_C2_D100[0][k] + K[3]*FE1_C2_D010[0][k] + K[6]*FE1_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][k] + K[5]*FE1_C1_D010[0][k] + K[8]*FE1_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))) + ((((((((K[2]*FE1_C1_D100[0][j] + K[5]*FE1_C1_D010[0][j] + K[8]*FE1_C1_D001[0][j]))*((K[1]*FE1_C2_D100[0][k] + K[4]*FE1_C2_D010[0][k] + K[7]*FE1_C2_D001[0][k])) + ((K[2]*FE1_C1_D100[0][k] + K[5]*FE1_C1_D010[0][k] + K[8]*FE1_C1_D001[0][k]))*((K[1]*FE1_C2_D100[0][j] + K[4]*FE1_C2_D010[0][j] + K[7]*FE1_C2_D001[0][j]))))*(-1.0) + (((K[1]*FE1_C1_D100[0][j] + K[4]*FE1_C1_D010[0][j] + K[7]*FE1_C1_D001[0][j]))*((K[2]*FE1_C2_D100[0][k] + K[5]*FE1_C2_D010[0][k] + K[8]*FE1_C2_D001[0][k])) + ((K[1]*FE1_C1_D100[0][k] + K[4]*FE1_C1_D010[0][k] + K[7]*FE1_C1_D001[0][k]))*((K[2]*FE1_C2_D100[0][j] + K[5]*FE1_C2_D010[0][j] + K[8]*FE1_C2_D001[0][j])))))*(((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0)) + ((K[0]*FE1_C0_D100[0][k] + K[3]*FE1_C0_D010[0][k] + K[6]*FE1_C0_D001[0][k]))*((((((K[1]*FE1_C2_D100[0][j] + K[4]*FE1_C2_D010[0][j] + K[7]*FE1_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][j] + K[5]*FE1_C1_D010[0][j] + K[8]*FE1_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE1_C1_D100[0][j] + K[4]*FE1_C1_D010[0][j] + K[7]*FE1_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][j] + K[5]*FE1_C2_D010[0][j] + K[8]*FE1_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)))))) + ((K[0]*FE1_C0_D100[0][j] + K[3]*FE1_C0_D010[0][j] + K[6]*FE1_C0_D001[0][j]))*((((((K[1]*FE1_C2_D100[0][k] + K[4]*FE1_C2_D010[0][k] + K[7]*FE1_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE1_C1_D100[0][k] + K[5]*FE1_C1_D010[0][k] + K[8]*FE1_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE1_C1_D100[0][k] + K[4]*FE1_C1_D010[0][k] + K[7]*FE1_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE1_C2_D100[0][k] + K[5]*FE1_C2_D010[0][k] + K[8]*FE1_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))))))) + ((((((((K[1]*FE1_C1_D100[0][j] + K[4]*FE1_C1_D010[0][j] + K[7]*FE1_C1_D001[0][j]))*((K[0]*FE1_C2_D100[0][k] + K[3]*FE1_C2_D010[0][k] + K[6]*FE1_C2_D001[0][k])) + ((K[1]*FE1_C1_D100[0][k] + K[4]*FE1_C1_D010[0][k] + K[7]*FE1_C1_D001[0][k]))*((K[0]*FE1_C2_D100[0][j] + K[3]*FE1_C2_D010[0][j] + K[6]*FE1_C2_D001[0][j]))))*(-1.0) + (((K[0]*FE1_C1_D100[0][j] + K[3]*FE1_C1_D010[0][j] + K[6]*FE1_C1_D001[0][j]))*((K[1]*FE1_C2_D100[0][k] + K[4]*FE1_C2_D010[0][k] + K[7]*FE1_C2_D001[0][k])) + ((K[0]*FE1_C1_D100[0][k] + K[3]*FE1_C1_D010[0][k] + K[6]*FE1_C1_D001[0][k]))*((K[1]*FE1_C2_D100[0][j] + K[4]*FE1_C2_D010[0][j] + K[7]*FE1_C2_D001[0][j])))))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE1_C0_D100[0][k] + K[5]*FE1_C0_D010[0][k] + K[8]*FE1_C0_D001[0][k]))*((((((K[0]*FE1_C2_D100[0][j] + K[3]*FE1_C2_D010[0][j] + K[6]*FE1_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE1_C1_D100[0][j] + K[4]*FE1_C1_D010[0][j] + K[7]*FE1_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE1_C1_D100[0][j] + K[3]*FE1_C1_D010[0][j] + K[6]*FE1_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE1_C2_D100[0][j] + K[4]*FE1_C2_D010[0][j] + K[7]*FE1_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))) + ((K[2]*FE1_C0_D100[0][j] + K[5]*FE1_C0_D010[0][j] + K[8]*FE1_C0_D001[0][j]))*((((((K[0]*FE1_C2_D100[0][k] + K[3]*FE1_C2_D010[0][k] + K[6]*FE1_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE1_C1_D100[0][k] + K[4]*FE1_C1_D010[0][k] + K[7]*FE1_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE1_C1_D100[0][k] + K[3]*FE1_C1_D010[0][k] + K[6]*FE1_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE1_C2_D100[0][k] + K[4]*FE1_C2_D010[0][k] + K[7]*FE1_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))))))/((((((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))) + ((K[1]*F7 + K[4]*F8 + K[7]*F9))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + ((K[2]*F7 + K[5]*F8 + K[8]*F9))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))))))*F0)*(-1.0) + (((2.0*(((K[0]*FE1_C0_D100[0][j] + K[3]*FE1_C0_D010[0][j] + K[6]*FE1_C0_D001[0][j]))*((K[0]*FE1_C0_D100[0][k] + K[3]*FE1_C0_D010[0][k] + K[6]*FE1_C0_D001[0][k]))) + 2.0*(((K[0]*FE1_C1_D100[0][j] + K[3]*FE1_C1_D010[0][j] + K[6]*FE1_C1_D001[0][j]))*((K[0]*FE1_C1_D100[0][k] + K[3]*FE1_C1_D010[0][k] + K[6]*FE1_C1_D001[0][k]))) + 2.0*(((K[0]*FE1_C2_D100[0][j] + K[3]*FE1_C2_D010[0][j] + K[6]*FE1_C2_D001[0][j]))*((K[0]*FE1_C2_D100[0][k] + K[3]*FE1_C2_D010[0][k] + K[6]*FE1_C2_D001[0][k])))) + (2.0*(((K[1]*FE1_C0_D100[0][j] + K[4]*FE1_C0_D010[0][j] + K[7]*FE1_C0_D001[0][j]))*((K[1]*FE1_C0_D100[0][k] + K[4]*FE1_C0_D010[0][k] + K[7]*FE1_C0_D001[0][k]))) + 2.0*(((K[1]*FE1_C1_D100[0][j] + K[4]*FE1_C1_D010[0][j] + K[7]*FE1_C1_D001[0][j]))*((K[1]*FE1_C1_D100[0][k] + K[4]*FE1_C1_D010[0][k] + K[7]*FE1_C1_D001[0][k]))) + 2.0*(((K[1]*FE1_C2_D100[0][j] + K[4]*FE1_C2_D010[0][j] + K[7]*FE1_C2_D001[0][j]))*((K[1]*FE1_C2_D100[0][k] + K[4]*FE1_C2_D010[0][k] + K[7]*FE1_C2_D001[0][k])))) + (2.0*(((K[2]*FE1_C0_D100[0][j] + K[5]*FE1_C0_D010[0][j] + K[8]*FE1_C0_D001[0][j]))*((K[2]*FE1_C0_D100[0][k] + K[5]*FE1_C0_D010[0][k] + K[8]*FE1_C0_D001[0][k]))) + 2.0*(((K[2]*FE1_C1_D100[0][j] + K[5]*FE1_C1_D010[0][j] + K[8]*FE1_C1_D001[0][j]))*((K[2]*FE1_C1_D100[0][k] + K[5]*FE1_C1_D010[0][k] + K[8]*FE1_C1_D001[0][k]))) + 2.0*(((K[2]*FE1_C2_D100[0][j] + K[5]*FE1_C2_D010[0][j] + K[8]*FE1_C2_D001[0][j]))*((K[2]*FE1_C2_D100[0][k] + K[5]*FE1_C2_D010[0][k] + K[8]*FE1_C2_D001[0][k]))))))*F0/(2.0)))*W1*det;
        } // end loop over 'k'
      } // end loop over 'j'
    } // end loop over 'ip'
  }

};


class hyperelasticity_form_0: public ufc::form
{
public:

  hyperelasticity_form_0() : ufc::form()
  {
    // Do nothing
  }

  ~hyperelasticity_form_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "a07b9447da6ae9d949071750728923b9a3830037df8dc006b3d5d1a798c395ca9f4f9042a3d9dc5ac3f20404c374f55a83569594155770a581a577ace2d220c2";
  }

  std::size_t rank() const final override
  {
    return 1;
  }

  std::size_t num_coefficients() const final override
  {
    return 5;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0, 1, 2, 3, 4});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new hyperelasticity_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new hyperelasticity_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 3:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 4:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 5:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 3:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 4:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 5:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return true;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new hyperelasticity_cell_integral_0_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return new hyperelasticity_exterior_facet_integral_0_otherwise();
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};


class hyperelasticity_form_1: public ufc::form
{
public:

  hyperelasticity_form_1() : ufc::form()
  {
    // Do nothing
  }

  ~hyperelasticity_form_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "89b4df7f5669048713d37817883c73cd4ce5dc8d75fb4c6225803635d0742d0817b6a13559cd5dca2c8aaa5729e7969608bcc70b489943c2173ef1583e467241";
  }

  std::size_t rank() const final override
  {
    return 2;
  }

  std::size_t num_coefficients() const final override
  {
    return 3;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0, 3, 4});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new hyperelasticity_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new hyperelasticity_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 3:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 4:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 3:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 4:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return false;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new hyperelasticity_cell_integral_1_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/mesh/Mesh.h>
#include <dolfin/mesh/MultiMesh.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/fem/MultiMeshForm.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/MultiMeshFunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>
#include <dolfin/function/MultiMeshCoefficientAssigner.h>
#include <dolfin/adaptivity/ErrorControl.h>
#include <dolfin/adaptivity/GoalFunctional.h>
#include <dolfin/la/GenericVector.h>

namespace HyperElasticity
{

class CoefficientSpace_B: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_B(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_B(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_T: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_T(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_T(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_lmbda: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_lmbda(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_lmbda(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_mu: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_mu(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_mu(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_u: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_u(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_u(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_F_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_F_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_F_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_F_MultiMeshFunctionSpace_0: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_F_MultiMeshFunctionSpace_0(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_F_FunctionSpace_0(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

typedef CoefficientSpace_u Form_F_FunctionSpace_1;

typedef CoefficientSpace_B Form_F_FunctionSpace_2;

typedef CoefficientSpace_T Form_F_FunctionSpace_3;

typedef CoefficientSpace_mu Form_F_FunctionSpace_4;

typedef CoefficientSpace_lmbda Form_F_FunctionSpace_5;

class Form_F: public dolfin::Form
{
public:

  // Constructor
  Form_F(std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 5), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    _function_spaces[0] = V0;

    _ufc_form = std::make_shared<const hyperelasticity_form_0>();
  }

  // Constructor
  Form_F(std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> B, std::shared_ptr<const dolfin::GenericFunction> T, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::Form(1, 5), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    _function_spaces[0] = V0;

    this->u = u;
    this->B = B;
    this->T = T;
    this->mu = mu;
    this->lmbda = lmbda;

    _ufc_form = std::make_shared<const hyperelasticity_form_0>();
  }

  // Destructor
  ~Form_F()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "B")
      return 1;
    else if (name == "T")
      return 2;
    else if (name == "mu")
      return 3;
    else if (name == "lmbda")
      return 4;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "B";
    case 2:
      return "T";
    case 3:
      return "mu";
    case 4:
      return "lmbda";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_F_FunctionSpace_0 TestSpace;
  typedef Form_F_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_F_FunctionSpace_1 CoefficientSpace_u;
  typedef Form_F_FunctionSpace_2 CoefficientSpace_B;
  typedef Form_F_FunctionSpace_3 CoefficientSpace_T;
  typedef Form_F_FunctionSpace_4 CoefficientSpace_mu;
  typedef Form_F_FunctionSpace_5 CoefficientSpace_lmbda;

  // Coefficients
  dolfin::CoefficientAssigner u;
  dolfin::CoefficientAssigner B;
  dolfin::CoefficientAssigner T;
  dolfin::CoefficientAssigner mu;
  dolfin::CoefficientAssigner lmbda;
};

class MultiMeshForm_F: public dolfin::MultiMeshForm
{
public:

  // Constructor
  MultiMeshForm_F(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0):
    dolfin::MultiMeshForm(V0), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<const dolfin::Form> a(new Form_F(V0->part(part)));
      add(a);
    }

    // Build multimesh form
    build();

    /// Assign coefficients

  }

  // Constructor
  MultiMeshForm_F(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> B, std::shared_ptr<const dolfin::GenericFunction> T, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::MultiMeshForm(V0), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<const dolfin::Form> a(new Form_F(V0->part(part)));
      add(a);
    }

    // Build multimesh form
    build();

    /// Assign coefficients
    this->u = u;
    this->B = B;
    this->T = T;
    this->mu = mu;
    this->lmbda = lmbda;

  }

  // Destructor
  ~MultiMeshForm_F()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "B")
      return 1;
    else if (name == "T")
      return 2;
    else if (name == "mu")
      return 3;
    else if (name == "lmbda")
      return 4;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "B";
    case 2:
      return "T";
    case 3:
      return "mu";
    case 4:
      return "lmbda";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_F_FunctionSpace_0 TestSpace;
  typedef Form_F_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_F_FunctionSpace_1 CoefficientSpace_u;
  typedef Form_F_FunctionSpace_2 CoefficientSpace_B;
  typedef Form_F_FunctionSpace_3 CoefficientSpace_T;
  typedef Form_F_FunctionSpace_4 CoefficientSpace_mu;
  typedef Form_F_FunctionSpace_5 CoefficientSpace_lmbda;

  // Coefficients
  dolfin::MultiMeshCoefficientAssigner u;
  dolfin::MultiMeshCoefficientAssigner B;
  dolfin::MultiMeshCoefficientAssigner T;
  dolfin::MultiMeshCoefficientAssigner mu;
  dolfin::MultiMeshCoefficientAssigner lmbda;
};

class Form_J_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_J_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_J_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_J_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_J_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_J_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<hyperelasticity_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<hyperelasticity_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_J_MultiMeshFunctionSpace_0: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_J_MultiMeshFunctionSpace_0(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_J_FunctionSpace_0(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

class Form_J_MultiMeshFunctionSpace_1: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_J_MultiMeshFunctionSpace_1(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_J_FunctionSpace_1(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

typedef CoefficientSpace_u Form_J_FunctionSpace_2;

typedef CoefficientSpace_mu Form_J_FunctionSpace_3;

typedef CoefficientSpace_lmbda Form_J_FunctionSpace_4;

class Form_J: public dolfin::Form
{
public:

  // Constructor
  Form_J(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = std::make_shared<const hyperelasticity_form_1>();
  }

  // Constructor
  Form_J(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->u = u;
    this->mu = mu;
    this->lmbda = lmbda;

    _ufc_form = std::make_shared<const hyperelasticity_form_1>();
  }

  // Destructor
  ~Form_J()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "mu")
      return 1;
    else if (name == "lmbda")
      return 2;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "mu";
    case 2:
      return "lmbda";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_J_FunctionSpace_0 TestSpace;
  typedef Form_J_FunctionSpace_1 TrialSpace;
  typedef Form_J_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_J_MultiMeshFunctionSpace_1 MultiMeshTrialSpace;
  typedef Form_J_FunctionSpace_2 CoefficientSpace_u;
  typedef Form_J_FunctionSpace_3 CoefficientSpace_mu;
  typedef Form_J_FunctionSpace_4 CoefficientSpace_lmbda;

  // Coefficients
  dolfin::CoefficientAssigner u;
  dolfin::CoefficientAssigner mu;
  dolfin::CoefficientAssigner lmbda;
};

class MultiMeshForm_J: public dolfin::MultiMeshForm
{
public:

  // Constructor
  MultiMeshForm_J(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V1, std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0):
    dolfin::MultiMeshForm(V1, V0), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<const dolfin::Form> a(new Form_J(V1->part(part), V0->part(part)));
      add(a);
    }

    // Build multimesh form
    build();

    /// Assign coefficients

  }

  // Constructor
  MultiMeshForm_J(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V1, std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::MultiMeshForm(V1, V0), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<const dolfin::Form> a(new Form_J(V1->part(part), V0->part(part)));
      add(a);
    }

    // Build multimesh form
    build();

    /// Assign coefficients
    this->u = u;
    this->mu = mu;
    this->lmbda = lmbda;

  }

  // Destructor
  ~MultiMeshForm_J()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "mu")
      return 1;
    else if (name == "lmbda")
      return 2;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "mu";
    case 2:
      return "lmbda";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_J_FunctionSpace_0 TestSpace;
  typedef Form_J_FunctionSpace_1 TrialSpace;
  typedef Form_J_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_J_MultiMeshFunctionSpace_1 MultiMeshTrialSpace;
  typedef Form_J_FunctionSpace_2 CoefficientSpace_u;
  typedef Form_J_FunctionSpace_3 CoefficientSpace_mu;
  typedef Form_J_FunctionSpace_4 CoefficientSpace_lmbda;

  // Coefficients
  dolfin::MultiMeshCoefficientAssigner u;
  dolfin::MultiMeshCoefficientAssigner mu;
  dolfin::MultiMeshCoefficientAssigner lmbda;
};

// Class typedefs
typedef Form_J BilinearForm;
typedef MultiMeshForm_J MultiMeshBilinearForm;
typedef Form_J JacobianForm;
typedef MultiMeshForm_J MultiMeshJacobianForm;
typedef Form_F LinearForm;
typedef MultiMeshForm_F MultiMeshLinearForm;
typedef Form_F ResidualForm;
typedef MultiMeshForm_F MultiMeshResidualForm;
typedef Form_F::TestSpace FunctionSpace;
typedef Form_F::MultiMeshTestSpace MultiMeshFunctionSpace;

}

#endif
