// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=la, header=ublas.h)
// Documentation extracted from: (module=la, header=LinearAlgebraObject.h)
%feature("docstring")  dolfin::LinearAlgebraObject "
This is a common base class for all DOLFIN linear algebra
objects. In particular, it provides casting mechanisms between
different types.
";

%feature("docstring")  dolfin::LinearAlgebraObject::down_cast "
**Overloaded versions**

* down_cast\ ()

  Cast object to its derived class, if possible (const version).
  An error is thrown if the cast is unsuccessful.

* down_cast\ ()

  Cast object to its derived class, if possible (non-const version).
  An error is thrown if the cast is unsuccessful.

* down_cast\ (A)

  Cast shared pointer object to its derived class, if possible.
  Caller must check for success (returns null if cast fails).
";

%feature("docstring")  dolfin::LinearAlgebraObject::instance "
**Overloaded versions**

* instance\ ()

  Return concrete instance / unwrap (const version)

* instance\ ()

  Return concrete instance / unwrap (non-const version)
";

%feature("docstring")  dolfin::LinearAlgebraObject::shared_instance "
**Overloaded versions**

* shared_instance\ ()

  Return concrete shared ptr instance / unwrap (const version)

* shared_instance\ ()

  Return concrete shared ptr instance / unwrap (non-const version)
";

%feature("docstring")  dolfin::LinearAlgebraObject::as_type "
**Overloaded versions**

* as_type\ (x)

  Cast object to its derived class, if possible (non-const version).
  An error is thrown if the cast is unsuccessful.

* as_type\ (x)

  Cast shared pointer object to its derived class, if possible.
  Caller must check for success (returns null if cast fails).
";

%feature("docstring")  dolfin::LinearAlgebraObject::has_type "
Check whether the object matches a specific type
";

// Documentation extracted from: (module=la, header=GenericLinearOperator.h)
%feature("docstring")  dolfin::GenericLinearOperator "
This class defines a common interface for linear operators,
including actual matrices (class :py:class:`GenericMatrix`) and linear
operators only defined in terms of their action on vectors.

This class is used internally by DOLFIN to define a class
hierarchy of backend independent linear operators and solvers.
Users should not interface to this class directly but instead
use the :py:class:`LinearOperator` class.
";

%feature("docstring")  dolfin::GenericLinearOperator::size "
Return size of given dimension
";

%feature("docstring")  dolfin::GenericLinearOperator::mult "
Compute matrix-vector product y = Ax
";

%feature("docstring")  dolfin::GenericLinearOperator::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=GenericTensor.h)
%feature("docstring")  dolfin::GenericTensor "
This class defines a common interface for arbitrary rank tensors.
";

%feature("docstring")  dolfin::GenericTensor::init "
Initialize zero tensor using tensor layout
";

%feature("docstring")  dolfin::GenericTensor::empty "
Return true if empty
";

%feature("docstring")  dolfin::GenericTensor::rank "
Return tensor rank (number of dimensions)
";

%feature("docstring")  dolfin::GenericTensor::size "
Return size of given dimension
";

%feature("docstring")  dolfin::GenericTensor::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::GenericTensor::get "
Get block of values
";

%feature("docstring")  dolfin::GenericTensor::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::GenericTensor::set_local "
Set block of values using local indices
";

%feature("docstring")  dolfin::GenericTensor::add "
**Overloaded versions**

* add\ (block, rows)

  Add block of values using global indices

* add\ (block, rows)

  Add block of values using global indices

* add\ (block, num_rows, rows)

  Add block of values using global indices
";

%feature("docstring")  dolfin::GenericTensor::add_local "
**Overloaded versions**

* add_local\ (block, rows)

  Add block of values using local indices

* add_local\ (block, rows)

  Add block of values using local indices

* add_local\ (block, num_rows, rows)

  Add block of values using local indices
";

%feature("docstring")  dolfin::GenericTensor::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::GenericTensor::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::GenericTensor::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::GenericTensor::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::GenericTensor::factory "
Return linear algebra backend factory
";

// Documentation extracted from: (module=la, header=GenericMatrix.h)
%feature("docstring")  dolfin::GenericMatrix "
This class defines a common interface for matrices.
";

%feature("docstring")  dolfin::GenericMatrix::rank "
Return tensor rank (number of dimensions)
";

%feature("docstring")  dolfin::GenericMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::GenericMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::GenericMatrix::nnz "
Return number of non-zero entries in matrix (collective)
";

%feature("docstring")  dolfin::GenericMatrix::get "
**Overloaded versions**

* get\ (block, num_rows, rows)

  Get block of values

* get\ (block, m, rows, n, cols)

  Get block of values
";

%feature("docstring")  dolfin::GenericMatrix::set "
**Overloaded versions**

* set\ (block, num_rows, rows)

  Set block of values using global indices

* set\ (block, m, rows, n, cols)

  Set block of values using global indices
";

%feature("docstring")  dolfin::GenericMatrix::set_local "
**Overloaded versions**

* set_local\ (block, num_rows, rows)

  Set block of values using local indices

* set_local\ (block, m, rows, n, cols)

  Set block of values using local indices
";

%feature("docstring")  dolfin::GenericMatrix::add "
**Overloaded versions**

* add\ (block, num_rows, rows)

  Add block of values using global indices

* add\ (block, rows)

  Add block of values using global indices

* add\ (block, rows)

  Add block of values using global indices

* add\ (block, m, rows, n, cols)

  Add block of values using global indices
";

%feature("docstring")  dolfin::GenericMatrix::add_local "
**Overloaded versions**

* add_local\ (block, num_rows, rows)

  Add block of values using local indices

* add_local\ (block, rows)

  Add block of values using local indices

* add_local\ (block, rows)

  Add block of values using local indices

* add_local\ (block, m, rows, n, cols)

  Add block of values using local indices
";

%feature("docstring")  dolfin::GenericMatrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows (global row indices) to zero
";

%feature("docstring")  dolfin::GenericMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::GenericMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::GenericMatrix::copy "
Return copy of matrix
";

%feature("docstring")  dolfin::GenericMatrix::init_vector "
Initialize vector z to be compatible with the matrix-vector
product y = Ax. In the parallel case, both size and layout are
important.

*Arguments*
    dim (int)
        The dimension (axis): dim = 0 --> z = y, dim = 1 --> z = x
";

%feature("docstring")  dolfin::GenericMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::GenericMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::GenericMatrix::getrow "
Get non-zero values of given row (global index) on local process
";

%feature("docstring")  dolfin::GenericMatrix::setrow "
Set values for given row (global index) on local process
";

%feature("docstring")  dolfin::GenericMatrix::zero_local "
Set given rows (local row indices) to zero
";

%feature("docstring")  dolfin::GenericMatrix::ident "
Set given rows (global row indices) to identity matrix
";

%feature("docstring")  dolfin::GenericMatrix::ident_local "
Set given rows (local row indices) to identity matrix
";

%feature("docstring")  dolfin::GenericMatrix::transpmult "
Matrix-vector product, y = A^T x. The y vector must either be
zero-sized or have correct size and parallel layout.
";

%feature("docstring")  dolfin::GenericMatrix::set_diagonal "
Set diagonal of a matrix
";

%feature("docstring")  dolfin::GenericMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::GenericMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::GenericMatrix::operator+= "
Add given matrix
";

%feature("docstring")  dolfin::GenericMatrix::operator-= "
Subtract given matrix
";

%feature("docstring")  dolfin::GenericMatrix::is_symmetric "
Test if matrix is symmetric
";

%feature("docstring")  dolfin::GenericMatrix::operator= "
Assignment operator
";

%feature("docstring")  dolfin::GenericMatrix::data "
Return pointers to underlying compressed row/column storage data
For compressed row storage, data = (row_pointer[#rows +1],
column_index[#nz], matrix_values[#nz], nz)
";

%feature("docstring")  dolfin::GenericMatrix::operator "
Get value of given entry
";

%feature("docstring")  dolfin::GenericMatrix::getitem "
Get value of given entry
";

%feature("docstring")  dolfin::GenericMatrix::setitem "
Set given entry to value. apply(\"insert\") must be called
before using using the object.
";

%feature("docstring")  dolfin::GenericMatrix::ident_zeros "
Insert one on the diagonal for all zero rows
";

%feature("docstring")  dolfin::GenericMatrix::compressed "
Build compressed version of matrix (zeros removed)
";

// Documentation extracted from: (module=la, header=GenericSparsityPattern.h)
%feature("docstring")  dolfin::GenericSparsityPattern "
Base class (interface) for generic tensor sparsity patterns.
Currently, this interface is mostly limited to matrices.
";

%feature("docstring")  dolfin::GenericSparsityPattern::GenericSparsityPattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::GenericSparsityPattern::init "
Initialize sparsity pattern for a generic tensor
";

%feature("docstring")  dolfin::GenericSparsityPattern::insert_global "
Insert non-zero entries using global indices
";

%feature("docstring")  dolfin::GenericSparsityPattern::insert_local "
Insert non-zero entries using local (process-wise) entries
";

%feature("docstring")  dolfin::GenericSparsityPattern::rank "
Return rank
";

%feature("docstring")  dolfin::GenericSparsityPattern::primary_dim "
Return primary dimension (e.g., 0=row partition, 1=column
partition)
";

%feature("docstring")  dolfin::GenericSparsityPattern::local_range "
Return local range for dimension dim
";

%feature("docstring")  dolfin::GenericSparsityPattern::num_nonzeros "
Return total number of nonzeros in local_range
";

%feature("docstring")  dolfin::GenericSparsityPattern::num_nonzeros_diagonal "
Fill vector with number of nonzeros for diagonal block in
local_range for primary dimension
";

%feature("docstring")  dolfin::GenericSparsityPattern::num_nonzeros_off_diagonal "
Fill vector with number of nonzeros for off-diagonal block in
local_range for primary dimension
";

%feature("docstring")  dolfin::GenericSparsityPattern::num_local_nonzeros "
Fill vector with number of nonzeros in local_range for primary
dimension
";

%feature("docstring")  dolfin::GenericSparsityPattern::diagonal_pattern "
Return underlying sparsity pattern (diagonal). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::GenericSparsityPattern::off_diagonal_pattern "
Return underlying sparsity pattern (off-diagonal). Options
are 'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::GenericSparsityPattern::apply "
Finalize sparsity pattern
";

%feature("docstring")  dolfin::GenericSparsityPattern::mpi_comm "
Return MPI communicator
";

// Documentation extracted from: (module=la, header=GenericVector.h)
%feature("docstring")  dolfin::GenericVector "
This class defines a common interface for vectors.
";

%feature("docstring")  dolfin::GenericVector::init "
**Overloaded versions**

* init\ (tensor_layout)

  Initialize zero tensor using sparsity pattern

* init\ (comm, N)

  Initialize vector to global size N

* init\ (comm, range)

  Initialize vector with given local ownership range

* init\ (comm, range, local_to_global_map, ghost_indices)

  Initialise vector with given ownership range and with ghost
  values
";

%feature("docstring")  dolfin::GenericVector::rank "
Return tensor rank (number of dimensions)
";

%feature("docstring")  dolfin::GenericVector::size "
**Overloaded versions**

* size\ (dim)

  Return size of given dimension

* size\ ()

  Return global size of vector
";

%feature("docstring")  dolfin::GenericVector::local_range "
**Overloaded versions**

* local_range\ (dim)

  Return local ownership range

* local_range\ ()

  Return local ownership range of a vector
";

%feature("docstring")  dolfin::GenericVector::get "
**Overloaded versions**

* get\ (block, num_rows, rows)

  Get block of values using global indices

* get\ (block, m, rows)

  Get block of values using global indices (values must all live
  on the local process, ghosts cannot be accessed)
";

%feature("docstring")  dolfin::GenericVector::get_local "
**Overloaded versions**

* get_local\ (block, num_rows, rows)

  Get block of values using local indices

* get_local\ (block, m, rows)

  Get block of values using local indices (values must all live
  on the local process, ghost are accessible)

* get_local\ (values)

  Get all values on local process
";

%feature("docstring")  dolfin::GenericVector::set "
**Overloaded versions**

* set\ (block, num_rows, rows)

  Set block of values using global indices

* set\ (block, m, rows)

  Set block of values using global indices
";

%feature("docstring")  dolfin::GenericVector::set_local "
**Overloaded versions**

* set_local\ (block, num_rows, rows)

  Set block of values using local indices

* set_local\ (block, m, rows)

  Set block of values using local indices

* set_local\ (values)

  Set all values on local process
";

%feature("docstring")  dolfin::GenericVector::add "
**Overloaded versions**

* add\ (block, num_rows, rows)

  Add block of values using global indices

* add\ (block, rows)

  Add block of values using global indices

* add\ (block, rows)

  Add block of values using global indices

* add\ (block, m, rows)

  Add block of values using global indices
";

%feature("docstring")  dolfin::GenericVector::add_local "
**Overloaded versions**

* add_local\ (block, num_rows, rows)

  Add block of values using local indices

* add_local\ (block, rows)

  Add block of values using local indices

* add_local\ (block, rows)

  Add block of values using local indices

* add_local\ (block, m, rows)

  Add block of values using local indices

* add_local\ (values)

  Add values to each entry on local process
";

%feature("docstring")  dolfin::GenericVector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::GenericVector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::GenericVector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::GenericVector::copy "
Return copy of vector
";

%feature("docstring")  dolfin::GenericVector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::GenericVector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::GenericVector::gather "
**Overloaded versions**

* gather\ (x, indices)

  Gather entries into local vector x

* gather\ (x, indices)

  Gather entries into x
";

%feature("docstring")  dolfin::GenericVector::gather_on_zero "
Gather all entries into x on process 0
";

%feature("docstring")  dolfin::GenericVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::GenericVector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::GenericVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::GenericVector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::GenericVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::GenericVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::GenericVector::sum "
**Overloaded versions**

* sum\ ()

  Return sum of vector

* sum\ (rows)

  Return sum of selected rows in vector. Repeated entries are
  only summed once.
";

%feature("docstring")  dolfin::GenericVector::operator*= "
**Overloaded versions**

* operator*=\ (a)

  Multiply vector by given number

* operator*=\ (x)

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::GenericVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::GenericVector::operator+= "
**Overloaded versions**

* operator+=\ (x)

  Add given vector

* operator+=\ (a)

  Add number to all components of a vector
";

%feature("docstring")  dolfin::GenericVector::operator-= "
**Overloaded versions**

* operator-=\ (x)

  Subtract given vector

* operator-=\ (a)

  Subtract number from all components of a vector
";

%feature("docstring")  dolfin::GenericVector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator
";

%feature("docstring")  dolfin::GenericVector::data "
**Overloaded versions**

* data\ ()

  Return pointer to underlying data (const version)

* data\ ()

  Return pointer to underlying data
";

%feature("docstring")  dolfin::GenericVector::operator[] "
Get value of given entry
";

%feature("docstring")  dolfin::GenericVector::getitem "
Get value of given entry
";

%feature("docstring")  dolfin::GenericVector::setitem "
Set given entry to value. apply(\"insert\") should be called
before using using the object.
";

// Documentation extracted from: (module=la, header=VectorSpaceBasis.h)
%feature("docstring")  dolfin::VectorSpaceBasis "
This class defines a basis for vector spaces,
typically used for expressing nullspaces, transpose nullspaces
and near nullspaces of singular operators
";

%feature("docstring")  dolfin::VectorSpaceBasis::VectorSpaceBasis "
Constructor
";

%feature("docstring")  dolfin::VectorSpaceBasis::is_orthonormal "
Test if basis is orthonormal
";

%feature("docstring")  dolfin::VectorSpaceBasis::is_orthogonal "
Test if basis is orthogonal
";

%feature("docstring")  dolfin::VectorSpaceBasis::orthogonalize "
Orthogonalize x with respect to basis
";

%feature("docstring")  dolfin::VectorSpaceBasis::dim "
Dimension of the basis
";

%feature("docstring")  dolfin::VectorSpaceBasis::operator[] "
Get a particular basis vector
";

// Documentation extracted from: (module=la, header=GenericLinearSolver.h)
%feature("docstring")  dolfin::GenericLinearSolver "
This class provides a general solver for linear systems Ax = b.
";

%feature("docstring")  dolfin::GenericLinearSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::GenericLinearSolver::set_operators "
Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::GenericLinearSolver::set_nullspace "
Set null space of the operator (matrix). This is used to solve
singular systems
";

%feature("docstring")  dolfin::GenericLinearSolver::solve "
**Overloaded versions**

* solve\ (A, x, b)

  Solve linear system Ax = b

* solve\ (x, b)

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::GenericLinearSolver::solve_transpose "
**Overloaded versions**

* solve_transpose\ (A, x, b)

  Solve linear system A^Tx = b

* solve_transpose\ (x, b)

  Solve linear system A^Tx = b
";

%feature("docstring")  dolfin::GenericLinearSolver::parameter_type "
Return parameter type: \"krylov_solver\" or \"lu_solver\"
";

%feature("docstring")  dolfin::GenericLinearSolver::update_parameters "
Update solver parameters (useful for LinearSolver wrapper)
";

// Documentation extracted from: (module=la, header=GenericLUSolver.h)
%feature("docstring")  dolfin::GenericLUSolver "
This a base class for LU solvers
";

%feature("docstring")  dolfin::GenericLUSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::GenericLUSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::GenericLUSolver::solve_transpose "
**Overloaded versions**

* solve_transpose\ (x, b)

  Solve linear system A^Tx = b

* solve_transpose\ (A, x, b)

  Solve linear system A^Tx = b
";

// Documentation extracted from: (module=la, header=GenericPreconditioner.h)
%feature("docstring")  dolfin::GenericPreconditioner "
This class provides a common base preconditioners.
";

%feature("docstring")  dolfin::GenericPreconditioner::set_nullspace "
Set the (approximate) null space of the preconditioner operator
(matrix). This is required for certain preconditioner types,
e.g. smoothed aggregation multigrid
";

%feature("docstring")  dolfin::GenericPreconditioner::set_coordinates "
Set the coordinates of the operator (matrix) rows and geometric
dimension d. This is can be used by required for certain
preconditioners, e.g. ML. The input for this function can be
generated using GenericDofMap::tabulate_all_dofs.
";

// Documentation extracted from: (module=la, header=PETScOptions.h)
%feature("docstring")  dolfin::PETScOptions "
These class provides static functions that permit users to set
and retrieve PETSc options via the PETSc option/parameter
system. The option should be prefixed by '-', e.g.

    PETScOptions::set(\"mat_mumps_icntl_14\", 40.0);
";

%feature("docstring")  dolfin::PETScOptions::set "
**Overloaded versions**

* set\ (option)

  Set PETSc option that takes no value

* set\ (option, value)

  Set PETSc boolean option

* set\ (option, value)

  Set PETSc integer option

* set\ (option, value)

  Set PETSc double option

* set\ (option, value)

  Set PETSc string option

* set\ (option, value)

  Genetic function for setting PETSc option
";

%feature("docstring")  dolfin::PETScOptions::clear "
Clear PETSc option
";

// Documentation extracted from: (module=la, header=PETScObject.h)
%feature("docstring")  dolfin::PETScObject "
This class calls SubSystemsManager to initialise PETSc.

All PETSc objects must be derived from this class.
";

%feature("docstring")  dolfin::PETScObject::PETScObject "
Constructor. Ensures that PETSc has been initialised.
";

%feature("docstring")  dolfin::PETScObject::petsc_error "
Print error message for PETSc calls that return an error
";

// Documentation extracted from: (module=la, header=PETScBaseMatrix.h)
%feature("docstring")  dolfin::PETScBaseMatrix "
This class is a base class for matrices that can be used in
PETScKrylovSolver.
";

%feature("docstring")  dolfin::PETScBaseMatrix::PETScBaseMatrix "
**Overloaded versions**

* PETScBaseMatrix\ ()

  Constructor

* PETScBaseMatrix\ (A)

  Constructor

* PETScBaseMatrix\ (A)

  Copy constructor
";

%feature("docstring")  dolfin::PETScBaseMatrix::size "
Return number of rows (dim = 0) or columns (dim = 1)
";

%feature("docstring")  dolfin::PETScBaseMatrix::local_range "
Return local range along dimension dim
";

%feature("docstring")  dolfin::PETScBaseMatrix::init_vector "
Initialize vector to be compatible with the matrix-vector product
y = Ax. In the parallel case, both size and layout are
important.

*Arguments*
    dim (int)
        The dimension (axis): dim = 0 --> z = y, dim = 1 --> z = x
";

%feature("docstring")  dolfin::PETScBaseMatrix::mat "
Return PETSc Mat pointer
";

%feature("docstring")  dolfin::PETScBaseMatrix::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=uBLASFactory.h)
%feature("docstring")  dolfin::uBLASFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::uBLASFactory::create_vector "
Create empty vector
";

%feature("docstring")  dolfin::uBLASFactory::create_layout "
Create empty tensor layout
";

%feature("docstring")  dolfin::uBLASFactory::create_linear_operator "
Create empty linear operator
";

%feature("docstring")  dolfin::uBLASFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::uBLASFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::uBLASFactory::lu_solver_methods "
Return a list of available LU solver methods
";

%feature("docstring")  dolfin::uBLASFactory::krylov_solver_methods "
Return a list of available Krylov solver methods
";

%feature("docstring")  dolfin::uBLASFactory::krylov_solver_preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::uBLASFactory::instance "
Return singleton instance
";

// Documentation extracted from: (module=la, header=uBLASMatrix.h)
%feature("docstring")  dolfin::uBLASMatrix "
This class provides a simple matrix class based on uBLAS.
It is a simple wrapper for a uBLAS matrix implementing the
GenericMatrix interface.

The interface is intentionally simple. For advanced usage,
access the underlying uBLAS matrix and use the standard
uBLAS interface which is documented at
http://www.boost.org/libs/numeric/ublas/doc/index.htm.

Developer note: specialised member functions must be
inlined to avoid link errors.
";

%feature("docstring")  dolfin::uBLASMatrix::uBLASMatrix "
**Overloaded versions**

* uBLASMatrix\ ()

  Create empty matrix

* uBLASMatrix\ (M, N)

  Create M x N matrix

* uBLASMatrix\ (A)

  Copy constructor

* uBLASMatrix\ (A)

  Create matrix from given uBLAS matrix expression
";

%feature("docstring")  dolfin::uBLASMatrix::init "
Initialize zero tensor using tenor layout
";

%feature("docstring")  dolfin::uBLASMatrix::empty "
Return true if empty
";

%feature("docstring")  dolfin::uBLASMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::uBLASMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::uBLASMatrix::nnz "
Return number of non-zero entries in matrix
";

%feature("docstring")  dolfin::uBLASMatrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows (global row indices) to zero
";

%feature("docstring")  dolfin::uBLASMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::uBLASMatrix::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::uBLASMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::uBLASMatrix::copy "
Return copy of matrix
";

%feature("docstring")  dolfin::uBLASMatrix::resize "
Resize matrix to M x N
";

%feature("docstring")  dolfin::uBLASMatrix::init_vector "
Initialise vector z to be compatible with the matrix-vector product
y = Ax. In the parallel case, both size and layout are
important.

*Arguments*
    dim (int)
        The dimension (axis): dim = 0 --> z = y, dim = 1 --> z = x
";

%feature("docstring")  dolfin::uBLASMatrix::get "
Get block of values
";

%feature("docstring")  dolfin::uBLASMatrix::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::uBLASMatrix::set_local "
Set block of values using local indices
";

%feature("docstring")  dolfin::uBLASMatrix::add "
Add block of values using global indices
";

%feature("docstring")  dolfin::uBLASMatrix::add_local "
Add block of values using local indices
";

%feature("docstring")  dolfin::uBLASMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::uBLASMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::uBLASMatrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::uBLASMatrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::uBLASMatrix::zero_local "
Set given rows (local row indices) to zero
";

%feature("docstring")  dolfin::uBLASMatrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::uBLASMatrix::ident_local "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::uBLASMatrix::mult "
Matrix-vector product, y = Ax
";

%feature("docstring")  dolfin::uBLASMatrix::transpmult "
Matrix-vector product, y = A^T x
";

%feature("docstring")  dolfin::uBLASMatrix::set_diagonal "
Set diagonal of a matrix
";

%feature("docstring")  dolfin::uBLASMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::uBLASMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::uBLASMatrix::operator= "
**Overloaded versions**

* operator=\ (A)

  Assignment operator

* operator=\ (A)

  Assignment operator
";

%feature("docstring")  dolfin::uBLASMatrix::data "
Return pointers to underlying compressed storage data
See GenericMatrix for documentation.
";

%feature("docstring")  dolfin::uBLASMatrix::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::uBLASMatrix::mat "
**Overloaded versions**

* mat\ ()

  Return reference to uBLAS matrix (const version)

* mat\ ()

  Return reference to uBLAS matrix (non-const version)
";

%feature("docstring")  dolfin::uBLASMatrix::solve "
Solve Ax = b out-of-place using uBLAS (A is not destroyed)
";

%feature("docstring")  dolfin::uBLASMatrix::solve_in_place "
Solve Ax = b in-place using uBLAS(A is destroyed)
";

%feature("docstring")  dolfin::uBLASMatrix::invert "
Compute inverse of matrix
";

%feature("docstring")  dolfin::uBLASMatrix::lump "
Lump matrix into vector m
";

%feature("docstring")  dolfin::uBLASMatrix::compress "
Compress matrix (eliminate all non-zeros from a sparse matrix)
";

%feature("docstring")  dolfin::uBLASMatrix::operator "
Access value of given entry
";

// Documentation extracted from: (module=la, header=uBLASLinearOperator.h)
%feature("docstring")  dolfin::uBLASLinearOperator::uBLASLinearOperator "
Constructor
";

%feature("docstring")  dolfin::uBLASLinearOperator::size "
Return size of given dimension
";

%feature("docstring")  dolfin::uBLASLinearOperator::mult "
Compute matrix-vector product y = Ax
";

%feature("docstring")  dolfin::uBLASLinearOperator::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=PETScMatrix.h)
%feature("docstring")  dolfin::PETScMatrix "
This class provides a simple matrix class based on PETSc.
It is a wrapper for a PETSc matrix pointer (Mat)
implementing the GenericMatrix interface.

The interface is intentionally simple. For advanced usage,
access the PETSc Mat pointer using the function mat() and
use the standard PETSc interface.
";

%feature("docstring")  dolfin::PETScMatrix::PETScMatrix "
**Overloaded versions**

* PETScMatrix\ (use_gpu=false)

  Create empty matrix

* PETScMatrix\ (A)

  Create a wrapper around a PETSc Mat pointer

* PETScMatrix\ (A)

  Copy constructor
";

%feature("docstring")  dolfin::PETScMatrix::init "
Initialize zero tensor using tensor layout
";

%feature("docstring")  dolfin::PETScMatrix::empty "
Return true if empty
";

%feature("docstring")  dolfin::PETScMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::PETScMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::PETScMatrix::nnz "
Return number of non-zero entries in matrix (collective)
";

%feature("docstring")  dolfin::PETScMatrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows (global row indices) to zero
";

%feature("docstring")  dolfin::PETScMatrix::apply "
Finalize assembly of tensor. The following values are recognized
for the mode parameter:

  add    - corresponds to PETSc MatAssemblyBegin+End(MAT_FINAL_ASSEMBLY)
  insert - corresponds to PETSc MatAssemblyBegin+End(MAT_FINAL_ASSEMBLY)
  flush  - corresponds to PETSc MatAssemblyBegin+End(MAT_FLUSH_ASSEMBLY)
";

%feature("docstring")  dolfin::PETScMatrix::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::PETScMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScMatrix::copy "
Return copy of matrix
";

%feature("docstring")  dolfin::PETScMatrix::init_vector "
Initialize vector z to be compatible with the matrix-vector product
y = Ax. In the parallel case, both size and layout are
important.

*Arguments*
    dim (int)
        The dimension (axis): dim = 0 --> z = y, dim = 1 --> z = x
";

%feature("docstring")  dolfin::PETScMatrix::get "
Get block of values
";

%feature("docstring")  dolfin::PETScMatrix::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::PETScMatrix::set_local "
Set block of values using local indices
";

%feature("docstring")  dolfin::PETScMatrix::add "
Add block of values using global indices
";

%feature("docstring")  dolfin::PETScMatrix::add_local "
Add block of values using local indices
";

%feature("docstring")  dolfin::PETScMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::PETScMatrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::PETScMatrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::PETScMatrix::zero_local "
Set given rows (local row indices) to zero
";

%feature("docstring")  dolfin::PETScMatrix::ident "
Set given rows (global row indices) to identity matrix
";

%feature("docstring")  dolfin::PETScMatrix::ident_local "
Set given rows (local row indices) to identity matrix
";

%feature("docstring")  dolfin::PETScMatrix::set_diagonal "
Set diagonal of a matrix
";

%feature("docstring")  dolfin::PETScMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::PETScMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::PETScMatrix::operator= "
**Overloaded versions**

* operator=\ (A)

  Assignment operator

* operator=\ (A)

  Assignment operator
";

%feature("docstring")  dolfin::PETScMatrix::is_symmetric "
Test if matrix is symmetric
";

%feature("docstring")  dolfin::PETScMatrix::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::PETScMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::PETScMatrix::binary_dump "
Dump matrix to PETSc binary format
";

// Documentation extracted from: (module=la, header=PETScLinearOperator.h)
%feature("docstring")  dolfin::PETScLinearOperator::PETScLinearOperator "
Constructor
";

%feature("docstring")  dolfin::PETScLinearOperator::size "
Return size of given dimension
";

%feature("docstring")  dolfin::PETScLinearOperator::mult "
Compute matrix-vector product y = Ax
";

%feature("docstring")  dolfin::PETScLinearOperator::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScLinearOperator::wrapper "
**Overloaded versions**

* wrapper\ ()

  Return pointer to wrapper (const version)

* wrapper\ ()

  Return pointer to wrapper (const version)
";

// Documentation extracted from: (module=la, header=PETScPreconditioner.h)
%feature("docstring")  dolfin::PETScPreconditioner "
This class is a wrapper for configuring PETSc
preconditioners. It does not own a preconditioner. It can take a
PETScKrylovSolver and set the preconditioner type and
parameters.
";

%feature("docstring")  dolfin::PETScPreconditioner::PETScPreconditioner "
Create a particular preconditioner object
";

%feature("docstring")  dolfin::PETScPreconditioner::set "
Set the preconditioner type and parameters
";

%feature("docstring")  dolfin::PETScPreconditioner::set_nullspace "
Set the (near) null space of the preconditioner operator
(matrix). This is required for certain preconditioner types,
e.g. smoothed aggregation multigrid
";

%feature("docstring")  dolfin::PETScPreconditioner::near_nullspace "
Return the PETSc null space
";

%feature("docstring")  dolfin::PETScPreconditioner::set_coordinates "
Set the coordinates of the operator (matrix) rows and
geometric dimension d. This is can be used by required for
certain preconditioners, e.g. ML. The input for this function
can be generated using GenericDofMap::tabulate_all_dofs.
";

%feature("docstring")  dolfin::PETScPreconditioner::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScPreconditioner::preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::PETScPreconditioner::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=PETScKrylovSolver.h)
%feature("docstring")  dolfin::PETScKrylovSolver "
This class implements Krylov methods for linear systems
of the form Ax = b. It is a wrapper for the Krylov solvers
of PETSc.
";

%feature("docstring")  dolfin::PETScKrylovSolver::PETScKrylovSolver "
**Overloaded versions**

* PETScKrylovSolver\ (\"default\", \"default\")

  Create Krylov solver for a particular method and names
  preconditioner

* PETScKrylovSolver\ (method, preconditioner)

  Create Krylov solver for a particular method and
  PETScPreconditioner

* PETScKrylovSolver\ (method, preconditioner)

  Create Krylov solver for a particular method and
  PETScPreconditioner (shared_ptr version)

* PETScKrylovSolver\ (method, preconditioner)

  Create Krylov solver for a particular method and
  PETScPreconditioner

* PETScKrylovSolver\ (method, preconditioner)

  Create Krylov solver for a particular method and
  PETScPreconditioner (shared_ptr version)

* PETScKrylovSolver\ (ksp)

  Create solver wrapper of a PETSc KSP object
";

%feature("docstring")  dolfin::PETScKrylovSolver::set_operator "
**Overloaded versions**

* set_operator\ (A)

  Set operator (matrix)

* set_operator\ (A)

  Set operator (matrix)
";

%feature("docstring")  dolfin::PETScKrylovSolver::set_operators "
**Overloaded versions**

* set_operators\ (A, P)

  Set operator (matrix) and preconditioner matrix

* set_operators\ (A, P)

  Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::PETScKrylovSolver::set_nullspace "
Set null space of the operator (matrix). This is used to solve
singular systems
";

%feature("docstring")  dolfin::PETScKrylovSolver::get_operator "
Get operator (matrix)
";

%feature("docstring")  dolfin::PETScKrylovSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (A, x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (A, x, b)

  Solve linear system Ax = b and return number of iterations
";

%feature("docstring")  dolfin::PETScKrylovSolver::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScKrylovSolver::ksp "
Return PETSc KSP pointer
";

%feature("docstring")  dolfin::PETScKrylovSolver::methods "
Return a list of available solver methods
";

%feature("docstring")  dolfin::PETScKrylovSolver::preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::PETScKrylovSolver::set_options_prefix "
Set options prefix
";

%feature("docstring")  dolfin::PETScKrylovSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=PETScLUSolver.h)
%feature("docstring")  dolfin::PETScLUSolver "
This class implements the direct solution (LU factorization) for
linear systems of the form Ax = b. It is a wrapper for the LU
solver of PETSc.
";

%feature("docstring")  dolfin::PETScLUSolver::PETScLUSolver "
**Overloaded versions**

* PETScLUSolver\ (method=\"default\")

  Constructor

* PETScLUSolver\ (A, method=\"default\")

  Constructor
";

%feature("docstring")  dolfin::PETScLUSolver::set_operator "
**Overloaded versions**

* set_operator\ (A)

  Set operator (matrix)

* set_operator\ (A)

  Set operator (matrix)
";

%feature("docstring")  dolfin::PETScLUSolver::get_operator "
Get operator (matrix)
";

%feature("docstring")  dolfin::PETScLUSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b

* solve\ (x, b, transpose)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::PETScLUSolver::solve_transpose "
**Overloaded versions**

* solve_transpose\ (x, b)

  Solve linear system A^Tx = b

* solve_transpose\ (A, x, b)

  Solve linear system A^Tx = b

* solve_transpose\ (A, x, b)

  Solve linear system A^Tx = b
";

%feature("docstring")  dolfin::PETScLUSolver::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScLUSolver::ksp "
Return PETSc KSP pointer
";

%feature("docstring")  dolfin::PETScLUSolver::methods "
Return a list of available solver methods
";

%feature("docstring")  dolfin::PETScLUSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=CholmodCholeskySolver.h)
%feature("docstring")  dolfin::CholmodCholeskySolver "
This class implements the direct solution (Cholesky
factorization) of linear systems of the form Ax = b. Sparse
matrices are solved using CHOLMOD
http://www.cise.ufl.edu/research/sparse/cholmod/ if installed.
";

%feature("docstring")  dolfin::CholmodCholeskySolver::CholmodCholeskySolver "
**Overloaded versions**

* CholmodCholeskySolver\ ()

  Constructor

* CholmodCholeskySolver\ (A)

  Constructor
";

%feature("docstring")  dolfin::CholmodCholeskySolver::set_operator "
Solve the operator (matrix)
";

%feature("docstring")  dolfin::CholmodCholeskySolver::solve "
Solve linear system Ax = b for a sparse matrix using CHOLMOD
";

%feature("docstring")  dolfin::CholmodCholeskySolver::factorize "
Cholesky-factor sparse matrix A if CHOLMOD is installed
";

%feature("docstring")  dolfin::CholmodCholeskySolver::factorized_solve "
Solve factorized system (CHOLMOD).
";

%feature("docstring")  dolfin::CholmodCholeskySolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::Cholmod::clear "
Clear data
";

%feature("docstring")  dolfin::Cholmod::init "
Initialise with matrix
";

%feature("docstring")  dolfin::Cholmod::factorize "
Factorize
";

%feature("docstring")  dolfin::Cholmod::factorized_solve "
Factorized solve
";

%feature("docstring")  dolfin::Cholmod::residual "
Compute residual: b-Ax
";

%feature("docstring")  dolfin::Cholmod::residual_norm "
Compute residual norm
";

%feature("docstring")  dolfin::Cholmod::refine_once "
Perform one refinement
";

%feature("docstring")  dolfin::Cholmod::check_status "
Check status flag returned by an CHOLMOD function
";

// Documentation extracted from: (module=la, header=UmfpackLUSolver.h)
%feature("docstring")  dolfin::UmfpackLUSolver "
This class implements the direct solution (LU factorization) of
linear systems of the form Ax = b using UMFPACK
(http://www.cise.ufl.edu/research/sparse/umfpack/) if installed.
";

%feature("docstring")  dolfin::UmfpackLUSolver::UmfpackLUSolver "
**Overloaded versions**

* UmfpackLUSolver\ ()

  Constructor

* UmfpackLUSolver\ (A)

  Constructor
";

%feature("docstring")  dolfin::UmfpackLUSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::UmfpackLUSolver::get_operator "
Return the operator (matrix)
";

%feature("docstring")  dolfin::UmfpackLUSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b for a sparse matrix using UMFPACK
  if installed

* solve\ (A, x, b)

  Solve linear system
";

%feature("docstring")  dolfin::UmfpackLUSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::UmfpackLUSolver::umfpack_check_status "
Check status flag returned by an UMFPACK function
";

// Documentation extracted from: (module=la, header=MUMPSLUSolver.h)
%feature("docstring")  dolfin::MUMPSLUSolver "
This class implements the direct solution (LU factorization) for
linear systems of the form Ax = b. It is a wrapper for the MUMPS
LU solver.
";

%feature("docstring")  dolfin::MUMPSLUSolver::MUMPSLUSolver "
**Overloaded versions**

* MUMPSLUSolver\ (A)

  Constructor

* MUMPSLUSolver\ (A)

  Constructor
";

%feature("docstring")  dolfin::MUMPSLUSolver::solve "
Solve linear system Ax = b
";

%feature("docstring")  dolfin::MUMPSLUSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=PaStiXLUSolver.h)
%feature("docstring")  dolfin::PaStiXLUSolver::PaStiXLUSolver "
**Overloaded versions**

* PaStiXLUSolver\ (A)

  Constructor

* PaStiXLUSolver\ (A)

  Constructor
";

%feature("docstring")  dolfin::PaStiXLUSolver::solve "
Solve Ax = b
";

%feature("docstring")  dolfin::PaStiXLUSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=STLMatrix.h)
%feature("docstring")  dolfin::STLMatrix "
Simple STL-based implementation of the GenericMatrix interface.
The sparse matrix is stored as a pair of std::vector of
std::vector, one for the columns and one for the values.

Historically, this class has undergone a number of different
incarnations, based on various combinations of std::vector,
std::set and std::map. The current implementation has proven to
be the fastest.
";

%feature("docstring")  dolfin::STLMatrix::STLMatrix "
Create empty matrix
";

%feature("docstring")  dolfin::STLMatrix::init "
--- Implementation of the GenericTensor interface ---
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::STLMatrix::empty "
Return true if empty
";

%feature("docstring")  dolfin::STLMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::STLMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::STLMatrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows (global row indices) to zero
";

%feature("docstring")  dolfin::STLMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::STLMatrix::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::STLMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::STLMatrix::copy "
Return copy of matrix
";

%feature("docstring")  dolfin::STLMatrix::init_vector "
Initialize vector z to be compatible with the matrix-vector
product y = Ax. In the parallel case, both size and layout are
important.

*Arguments*
    dim (int)
        The dimension (axis): dim = 0 --> z = y, dim = 1 --> z = x
";

%feature("docstring")  dolfin::STLMatrix::get "
Get block of values
";

%feature("docstring")  dolfin::STLMatrix::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::STLMatrix::set_local "
Set block of values using local indices
";

%feature("docstring")  dolfin::STLMatrix::add "
Add block of values using global indices
";

%feature("docstring")  dolfin::STLMatrix::add_local "
Add block of values using local indices
";

%feature("docstring")  dolfin::STLMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::STLMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::STLMatrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::STLMatrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::STLMatrix::zero_local "
Set given rows (local row indices) to zero
";

%feature("docstring")  dolfin::STLMatrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::STLMatrix::ident_local "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::STLMatrix::set_diagonal "
Set diagonal of a matrix
";

%feature("docstring")  dolfin::STLMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::STLMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::STLMatrix::operator= "
Assignment operator
";

%feature("docstring")  dolfin::STLMatrix::factory "
--- Specialized matrix functions ---
Return linear algebra backend factory
";

%feature("docstring")  dolfin::STLMatrix::block_size "
--- STLMatrix interface ---
Return matrix block size
";

%feature("docstring")  dolfin::STLMatrix::clear "
Clear matrix. Destroys data and sparse layout
";

%feature("docstring")  dolfin::STLMatrix::csr "
Return matrix in CSR format
";

%feature("docstring")  dolfin::STLMatrix::csc "
Return matrix in CSC format
";

%feature("docstring")  dolfin::STLMatrix::nnz "
Return number of global non-zero entries
";

%feature("docstring")  dolfin::STLMatrix::local_nnz "
Return number of local non-zero entries
";

%feature("docstring")  dolfin::STLMatrix::compressed_storage "
Return matrix in compressed format
";

// Documentation extracted from: (module=la, header=CoordinateMatrix.h)
%feature("docstring")  dolfin::CoordinateMatrix "
Coordinate sparse matrix.
";

%feature("docstring")  dolfin::CoordinateMatrix::CoordinateMatrix "
Constructor
";

%feature("docstring")  dolfin::CoordinateMatrix::norm "
Return norm of matrix
";

// Documentation extracted from: (module=la, header=uBLASVector.h)
%feature("docstring")  dolfin::uBLASVector "
This class provides a simple vector class based on uBLAS.
It is a simple wrapper for a uBLAS vector implementing the
GenericVector interface.

The interface is intentionally simple. For advanced usage,
access the underlying uBLAS vector and use the standard
uBLAS interface which is documented at
http://www.boost.org/libs/numeric/ublas/doc/index.htm.
";

%feature("docstring")  dolfin::uBLASVector::uBLASVector "
**Overloaded versions**

* uBLASVector\ ()

  Create empty vector

* uBLASVector\ (N)

  Create vector of size N

* uBLASVector\ (x)

  Copy constructor

* uBLASVector\ (x)

  Construct vector from a ublas_vector
";

%feature("docstring")  dolfin::uBLASVector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::uBLASVector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::uBLASVector::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::uBLASVector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::uBLASVector::copy "
Create copy of tensor
";

%feature("docstring")  dolfin::uBLASVector::init "
**Overloaded versions**

* init\ (comm, N)

  Initialize vector to size N

* init\ (comm, range)

  Resize vector with given ownership range

* init\ (comm, range, local_to_global_map, ghost_indices)

  Resize vector with given ownership range and with ghost values
";

%feature("docstring")  dolfin::uBLASVector::empty "
Return true if vector is empty
";

%feature("docstring")  dolfin::uBLASVector::size "
Return true if vector is empty
";

%feature("docstring")  dolfin::uBLASVector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::uBLASVector::local_range "
Return local ownership range of a vector
";

%feature("docstring")  dolfin::uBLASVector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::uBLASVector::get "
Get block of values using global indices
";

%feature("docstring")  dolfin::uBLASVector::get_local "
**Overloaded versions**

* get_local\ (block, m, rows)

  Get block of values using local indices

* get_local\ (values)

  Get all values on local process
";

%feature("docstring")  dolfin::uBLASVector::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::uBLASVector::set_local "
**Overloaded versions**

* set_local\ (block, m, rows)

  Set block of values using local indices

* set_local\ (values)

  Set all values on local process
";

%feature("docstring")  dolfin::uBLASVector::add "
Add block of values using global indices
";

%feature("docstring")  dolfin::uBLASVector::add_local "
**Overloaded versions**

* add_local\ (block, m, rows)

  Add block of values using local indices

* add_local\ (values)

  Add values to each entry on local process
";

%feature("docstring")  dolfin::uBLASVector::gather "
**Overloaded versions**

* gather\ (x, indices)

  Gather entries into local vector x

* gather\ (x, indices)

  Gather entries into x
";

%feature("docstring")  dolfin::uBLASVector::gather_on_zero "
Gather all entries into x on process 0
";

%feature("docstring")  dolfin::uBLASVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::uBLASVector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::uBLASVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::uBLASVector::norm "
Compute norm of vector
";

%feature("docstring")  dolfin::uBLASVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::uBLASVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::uBLASVector::sum "
**Overloaded versions**

* sum\ ()

  Return sum of values of vector

* sum\ (rows)

  Return sum of selected rows in vector. Repeated entries are
  only summed once.
";

%feature("docstring")  dolfin::uBLASVector::operator*= "
**Overloaded versions**

* operator*=\ (a)

  Multiply vector by given number

* operator*=\ (x)

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::uBLASVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::uBLASVector::operator+= "
**Overloaded versions**

* operator+=\ (x)

  Add given vector

* operator+=\ (a)

  Add number to all components of a vector
";

%feature("docstring")  dolfin::uBLASVector::operator-= "
**Overloaded versions**

* operator-=\ (x)

  Subtract given vector

* operator-=\ (a)

  Subtract number from all components of a vector
";

%feature("docstring")  dolfin::uBLASVector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator

* operator=\ (x)

  Assignment operator
";

%feature("docstring")  dolfin::uBLASVector::data "
**Overloaded versions**

* data\ ()

  Return pointer to underlying data (const version)

* data\ ()

  Return pointer to underlying data
";

%feature("docstring")  dolfin::uBLASVector::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::uBLASVector::resize "
Resize vector to size N
";

%feature("docstring")  dolfin::uBLASVector::vec "
**Overloaded versions**

* vec\ ()

  Return reference to uBLAS vector (const version)

* vec\ ()

  Return reference to uBLAS vector (non-const version)
";

%feature("docstring")  dolfin::uBLASVector::operator[] "
**Overloaded versions**

* operator[]\ (i)

  Access value of given entry (const version)

* operator[]\ (i)

  Access value of given entry (non-const version)
";

// Documentation extracted from: (module=la, header=PETScVector.h)
%feature("docstring")  dolfin::PETScVector "
This class provides a simple vector class based on PETSc.
It is a simple wrapper for a PETSc vector pointer (Vec)
implementing the GenericVector interface.

The interface is intentionally simple. For advanced usage,
access the PETSc Vec pointer using the function vec() and
use the standard PETSc interface.
";

%feature("docstring")  dolfin::PETScVector::PETScVector "
**Overloaded versions**

* PETScVector\ ()

  Create empty vector

* PETScVector\ (comm, N, use_gpu=false)

  Create vector of size N

* PETScVector\ (sparsity_pattern)

  Create vector

* PETScVector\ (x)

  Copy constructor

* PETScVector\ (x)

  Create vector wrapper of PETSc Vec pointer
";

%feature("docstring")  dolfin::PETScVector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::PETScVector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::PETScVector::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::PETScVector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScVector::copy "
Return copy of vector
";

%feature("docstring")  dolfin::PETScVector::init "
**Overloaded versions**

* init\ (comm, N)

  Initialize vector to global size N

* init\ (comm, range)

  Initialize vector with given ownership range

* init\ (comm, range, local_to_global_map, ghost_indices)

  Initialize vector with given ownership range and with ghost values
";

%feature("docstring")  dolfin::PETScVector::empty "
Return true if vector is empty
";

%feature("docstring")  dolfin::PETScVector::size "
Return size of vector
";

%feature("docstring")  dolfin::PETScVector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::PETScVector::local_range "
Return ownership range of a vector
";

%feature("docstring")  dolfin::PETScVector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::PETScVector::get "
Get block of values using global indices (all values must be
owned by local process, ghosts cannot be accessed)
";

%feature("docstring")  dolfin::PETScVector::get_local "
**Overloaded versions**

* get_local\ (block, m, rows)

  Get block of values using local indices

* get_local\ (values)

  Get all values on local process
";

%feature("docstring")  dolfin::PETScVector::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::PETScVector::set_local "
**Overloaded versions**

* set_local\ (block, m, rows)

  Set block of values using local indices

* set_local\ (values)

  Set all values on local process
";

%feature("docstring")  dolfin::PETScVector::add "
Add block of values using global indices
";

%feature("docstring")  dolfin::PETScVector::add_local "
**Overloaded versions**

* add_local\ (block, m, rows)

  Add block of values using local indices

* add_local\ (values)

  Add values to each entry on local process
";

%feature("docstring")  dolfin::PETScVector::gather "
**Overloaded versions**

* gather\ (y, indices)

  Gather vector entries into a local vector

* gather\ (x, indices)

  Gather entries into x
";

%feature("docstring")  dolfin::PETScVector::gather_on_zero "
Gather all entries into x on process 0
";

%feature("docstring")  dolfin::PETScVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::PETScVector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::PETScVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::PETScVector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::PETScVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::PETScVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::PETScVector::sum "
**Overloaded versions**

* sum\ ()

  Return sum of values of vector

* sum\ (rows)

  Return sum of selected rows in vector
";

%feature("docstring")  dolfin::PETScVector::operator*= "
**Overloaded versions**

* operator*=\ (a)

  Multiply vector by given number

* operator*=\ (x)

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::PETScVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::PETScVector::operator+= "
**Overloaded versions**

* operator+=\ (x)

  Add given vector

* operator+=\ (a)

  Add number to all components of a vector
";

%feature("docstring")  dolfin::PETScVector::operator-= "
**Overloaded versions**

* operator-=\ (x)

  Subtract given vector

* operator-=\ (a)

  Subtract number from all components of a vector
";

%feature("docstring")  dolfin::PETScVector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator

* operator=\ (x)

  Assignment operator
";

%feature("docstring")  dolfin::PETScVector::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::PETScVector::vec "
Return pointer to PETSc Vec object
";

// Documentation extracted from: (module=la, header=SparsityPattern.h)
%feature("docstring")  dolfin::SparsityPattern "
This class implements the GenericSparsityPattern interface.  It
is used by most linear algebra backends.
";

%feature("docstring")  dolfin::SparsityPattern::SparsityPattern "
**Overloaded versions**

* SparsityPattern\ (primary_dim)

  Create empty sparsity pattern

* SparsityPattern\ (mpi_comm, dims, ownership_range, local_to_global, off_process_owner, block_sizes, primary_dim)

  Create sparsity pattern for a generic tensor
";

%feature("docstring")  dolfin::SparsityPattern::init "
Initialize sparsity pattern for a generic tensor
";

%feature("docstring")  dolfin::SparsityPattern::insert_global "
Insert non-zero entries using global indices
";

%feature("docstring")  dolfin::SparsityPattern::insert_local "
Insert non-zero entries using local (process-wise) indices
";

%feature("docstring")  dolfin::SparsityPattern::rank "
Return rank
";

%feature("docstring")  dolfin::SparsityPattern::local_range "
Return local range for dimension dim
";

%feature("docstring")  dolfin::SparsityPattern::num_nonzeros "
Return number of local nonzeros
";

%feature("docstring")  dolfin::SparsityPattern::num_nonzeros_diagonal "
Fill array with number of nonzeros for diagonal block in
local_range for dimension 0. For matrices, fill array with
number of nonzeros per local row for diagonal block
";

%feature("docstring")  dolfin::SparsityPattern::num_nonzeros_off_diagonal "
Fill array with number of nonzeros for off-diagonal block in
local_range for dimension 0. For matrices, fill array with
number of nonzeros per local row for off-diagonal block
";

%feature("docstring")  dolfin::SparsityPattern::num_local_nonzeros "
Fill vector with number of nonzeros in local_range for
dimension 0
";

%feature("docstring")  dolfin::SparsityPattern::apply "
Finalize sparsity pattern
";

%feature("docstring")  dolfin::SparsityPattern::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::SparsityPattern::diagonal_pattern "
Return underlying sparsity pattern (diagonal). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::SparsityPattern::off_diagonal_pattern "
Return underlying sparsity pattern (off-diagonal). Options are
'sorted' and 'unsorted'.
";

// Documentation extracted from: (module=la, header=GenericLinearAlgebraFactory.h)
%feature("docstring")  dolfin::GenericLinearAlgebraFactory::GenericLinearAlgebraFactory "
Constructor
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::create_vector "
Create empty vector
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::create_layout "
Create empty tensor layout
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::create_linear_operator "
Create empty linear operator
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::lu_solver_methods "
Return a list of available LU solver methods.
This function should be overloaded by subclass if non-empty.
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::krylov_solver_methods "
Return a list of available Krylov solver methods.
This function should be overloaded by subclass if non-empty.
";

%feature("docstring")  dolfin::GenericLinearAlgebraFactory::krylov_solver_preconditioners "
Return a list of available preconditioners.
This function should be overloaded by subclass if non-empty.
";

// Documentation extracted from: (module=la, header=DefaultFactory.h)
%feature("docstring")  dolfin::DefaultFactory::DefaultFactory "
Constructor
";

%feature("docstring")  dolfin::DefaultFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::DefaultFactory::create_vector "
Create empty vector
";

%feature("docstring")  dolfin::DefaultFactory::create_layout "
Create empty tensor layout
";

%feature("docstring")  dolfin::DefaultFactory::create_linear_operator "
Create empty linear operator
";

%feature("docstring")  dolfin::DefaultFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::DefaultFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::DefaultFactory::lu_solver_methods "
Return a list of available LU solver methods
";

%feature("docstring")  dolfin::DefaultFactory::krylov_solver_methods "
Return a list of available Krylov solver methods
";

%feature("docstring")  dolfin::DefaultFactory::krylov_solver_preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::DefaultFactory::factory "
Return instance of default backend
";

// Documentation extracted from: (module=la, header=PETScUserPreconditioner.h)
%feature("docstring")  dolfin::PETScUserPreconditioner "
This class specifies the interface for user-defined Krylov
method PETScPreconditioners. A user wishing to implement her own
PETScPreconditioner needs only supply a function that approximately
solves the linear system given a right-hand side.
";

%feature("docstring")  dolfin::PETScUserPreconditioner::PETScUserPreconditioner "
Constructor
";

%feature("docstring")  dolfin::PETScUserPreconditioner::solve "
Solve linear system approximately for given right-hand side b
";

// Documentation extracted from: (module=la, header=PETScFactory.h)
%feature("docstring")  dolfin::PETScFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::PETScFactory::create_vector "
Create empty vector
";

%feature("docstring")  dolfin::PETScFactory::create_layout "
Create empty tensor layout
";

%feature("docstring")  dolfin::PETScFactory::create_linear_operator "
Create empty linear operator
";

%feature("docstring")  dolfin::PETScFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::PETScFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::PETScFactory::lu_solver_methods "
Return a list of available LU solver methods
";

%feature("docstring")  dolfin::PETScFactory::krylov_solver_methods "
Return a list of available Krylov solver methods
";

%feature("docstring")  dolfin::PETScFactory::krylov_solver_preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::PETScFactory::instance "
Return singleton instance
";

%feature("docstring")  dolfin::PETScFactory::PETScFactory "
Private constructor
";

// Documentation extracted from: (module=la, header=PETScCuspFactory.h)
%feature("docstring")  dolfin::PETScCuspFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::PETScCuspFactory::create_vector "
Create empty vector
";

%feature("docstring")  dolfin::PETScCuspFactory::create_layout "
Create empty tensor layout
";

%feature("docstring")  dolfin::PETScCuspFactory::create_linear_operator "
Create empty linear operator
";

%feature("docstring")  dolfin::PETScCuspFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::PETScCuspFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::PETScCuspFactory::lu_solver_methods "
Return a list of available LU solver methods
";

%feature("docstring")  dolfin::PETScCuspFactory::krylov_solver_methods "
Return a list of available Krylov solver methods
";

%feature("docstring")  dolfin::PETScCuspFactory::krylov_solver_preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::PETScCuspFactory::instance "
Return singleton instance
";

%feature("docstring")  dolfin::PETScCuspFactory::PETScCuspFactory "
Private constructor
";

// Documentation extracted from: (module=la, header=STLFactory.h)
%feature("docstring")  dolfin::STLFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::STLFactory::create_vector "
Create empty vector
";

%feature("docstring")  dolfin::STLFactory::create_layout "
Create empty tensor layout
";

%feature("docstring")  dolfin::STLFactory::create_linear_operator "
Create empty linear operator
";

%feature("docstring")  dolfin::STLFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::STLFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::STLFactory::instance "
Return singleton instance
";

// Documentation extracted from: (module=la, header=SLEPcEigenSolver.h)
%feature("docstring")  dolfin::SLEPcEigenSolver "
This class provides an eigenvalue solver for PETSc matrices.
It is a wrapper for the SLEPc eigenvalue solver.

The following parameters may be specified to control the solver.

1. \"spectrum\"

This parameter controls which part of the spectrum to compute.
Possible values are

  \"largest magnitude\"   (eigenvalues with largest magnitude)
  \"smallest magnitude\"  (eigenvalues with smallest magnitude)
  \"largest real\"        (eigenvalues with largest double part)
  \"smallest real\"       (eigenvalues with smallest double part)
  \"largest imaginary\"   (eigenvalues with largest imaginary part)
  \"smallest imaginary\"  (eigenvalues with smallest imaginary part)

For SLEPc versions >= 3.1 , the following values are also possible

  \"target magnitude\"    (eigenvalues closest to target in magnitude)
  \"target real\"         (eigenvalues closest to target in real part)
  \"target imaginary\"    (eigenvalues closest to target in imaginary part)

The default is \"largest magnitude\"

2. \"solver\"

This parameter controls which algorithm is used by SLEPc.
Possible values are

  \"power\"               (power iteration)
  \"subspace\"            (subspace iteration)
  \"arnoldi\"             (Arnoldi)
  \"lanczos\"             (Lanczos)
  \"krylov-schur\"        (Krylov-Schur)
  \"lapack\"              (LAPACK, all values, direct, small systems only)
  \"arpack\"              (ARPACK)

The default is \"krylov-schur\"

3. \"tolerance\"

This parameter controls the tolerance used by SLEPc.
Possible values are positive double numbers.

The default is 1e-15;

4. \"maximum_iterations\"

This parameter controls the maximum number of iterations used by SLEPc.
Possible values are positive integers.

Note that both the tolerance and the number of iterations must be
specified if either one is specified.

5. \"problem_type\"

This parameter can be used to give extra information about the
type of the eigenvalue problem. Some solver types require this
extra piece of information. Possible values are:

  \"hermitian\"               (Hermitian)
  \"non_hermitian\"           (Non-Hermitian)
  \"gen_hermitian\"           (Generalized Hermitian)
  \"gen_non_hermitian\"       (Generalized Non-Hermitian)
  \"pos_gen_non_hermitian\"   (Generalized Non-Hermitian with positive semidefinite B)

6. \"spectral_transform\"

This parameter controls the application of a spectral transform. A
spectral transform can be used to enhance the convergence of the
eigensolver and in particular to only compute eigenvalues in the
interior of the spectrum. Possible values are:

  \"shift-and-invert\"      (A shift-and-invert transform)

Note that if a spectral transform is given, then also a non-zero
spectral shift parameter has to be provided.

The default is no spectral transform.

7. \"spectral_shift\"

This parameter controls the spectral shift used by the spectral
transform and must be provided if a spectral transform is given. The
possible values are real numbers.

";

%feature("docstring")  dolfin::SLEPcEigenSolver::SLEPcEigenSolver "
**Overloaded versions**

* SLEPcEigenSolver\ (A)

  Create eigenvalue solver for Ax = \lambda x

* SLEPcEigenSolver\ (A, B)

  Create eigenvalue solver Ax = \lambda Bx

* SLEPcEigenSolver\ (A)

  Create eigenvalue solver for Ax = \lambda x

* SLEPcEigenSolver\ (A, B)

  Create eigenvalue solver for Ax = \lambda x
";

%feature("docstring")  dolfin::SLEPcEigenSolver::solve "
**Overloaded versions**

* solve\ ()

  Compute all eigenpairs of the matrix A (solve Ax = \lambda x)

* solve\ (n)

  Compute the n first eigenpairs of the matrix A (solve Ax = \lambda x)
";

%feature("docstring")  dolfin::SLEPcEigenSolver::get_eigenvalue "
**Overloaded versions**

* get_eigenvalue\ (lr, lc)

  Get the first eigenvalue

* get_eigenvalue\ (lr, lc, i)

  Get eigenvalue i
";

%feature("docstring")  dolfin::SLEPcEigenSolver::get_eigenpair "
**Overloaded versions**

* get_eigenpair\ (lr, lc, r, c)

  Get the first eigenpair

* get_eigenpair\ (lr, lc, r, c)

  Get the first eigenpair

* get_eigenpair\ (lr, lc, r, c, i)

  Get eigenpair i

* get_eigenpair\ (lr, lc, r, c, i)

  Get eigenpair i
";

%feature("docstring")  dolfin::SLEPcEigenSolver::get_iteration_number "
Get the number of iterations used by the solver
";

%feature("docstring")  dolfin::SLEPcEigenSolver::get_number_converged "
Get the number of converged eigenvalues
";

%feature("docstring")  dolfin::SLEPcEigenSolver::set_deflation_space "
Set deflation space
";

%feature("docstring")  dolfin::SLEPcEigenSolver::eps "
Return SLEPc EPS pointer
";

%feature("docstring")  dolfin::SLEPcEigenSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::SLEPcEigenSolver::read_parameters "
Callback for changes in parameter values
";

// Documentation extracted from: (module=la, header=uBLASSparseMatrix.h)
// Documentation extracted from: (module=la, header=uBLASDenseMatrix.h)
// Documentation extracted from: (module=la, header=uBLASPreconditioner.h)
%feature("docstring")  dolfin::uBLASPreconditioner "
This class specifies the interface for preconditioners for the
uBLAS Krylov solver.
";

%feature("docstring")  dolfin::uBLASPreconditioner::uBLASPreconditioner "
Constructor
";

%feature("docstring")  dolfin::uBLASPreconditioner::init "
**Overloaded versions**

* init\ (P)

  Initialise preconditioner (sparse matrix)

* init\ (P)

  Initialise preconditioner (dense matrix)

* init\ (P)

  Initialise preconditioner (virtual matrix)
";

%feature("docstring")  dolfin::uBLASPreconditioner::solve "
Solve linear system (M^-1)Ax = y
";

// Documentation extracted from: (module=la, header=uBLASKrylovSolver.h)
%feature("docstring")  dolfin::uBLASKrylovSolver "
This class implements Krylov methods for linear systems
of the form Ax = b using uBLAS data types.
";

%feature("docstring")  dolfin::uBLASKrylovSolver::uBLASKrylovSolver "
**Overloaded versions**

* uBLASKrylovSolver\ (method=\"default\", preconditioner=\"default\")

  Create Krylov solver for a particular method and preconditioner

* uBLASKrylovSolver\ (pc)

  Create Krylov solver for a particular uBLASPreconditioner

* uBLASKrylovSolver\ (method, pc)

  Create Krylov solver for a particular method and uBLASPreconditioner
";

%feature("docstring")  dolfin::uBLASKrylovSolver::set_operator "
Solve the operator (matrix)
";

%feature("docstring")  dolfin::uBLASKrylovSolver::set_operators "
Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::uBLASKrylovSolver::get_operator "
Return the operator (matrix)
";

%feature("docstring")  dolfin::uBLASKrylovSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (A, x, b)

  Solve linear system Ax = b and return number of iterations
";

%feature("docstring")  dolfin::uBLASKrylovSolver::methods "
Return a list of available solver methods
";

%feature("docstring")  dolfin::uBLASKrylovSolver::preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::uBLASKrylovSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::uBLASKrylovSolver::solve_krylov "
Select solver and solve linear system Ax = b and return number
of iterations
";

%feature("docstring")  dolfin::uBLASKrylovSolver::solveCG "
Solve linear system Ax = b using CG
";

%feature("docstring")  dolfin::uBLASKrylovSolver::solveGMRES "
Solve linear system Ax = b using restarted GMRES
";

%feature("docstring")  dolfin::uBLASKrylovSolver::solveBiCGStab "
Solve linear system Ax = b using BiCGStab
";

%feature("docstring")  dolfin::uBLASKrylovSolver::select_preconditioner "
Select and create named preconditioner
";

%feature("docstring")  dolfin::uBLASKrylovSolver::read_parameters "
Read solver parameters
";

// Documentation extracted from: (module=la, header=uBLASILUPreconditioner.h)
%feature("docstring")  dolfin::uBLASILUPreconditioner "
This class implements an incomplete LU factorization (ILU)
preconditioner for the uBLAS Krylov solver.
";

%feature("docstring")  dolfin::uBLASILUPreconditioner::uBLASILUPreconditioner "
Constructor
";

%feature("docstring")  dolfin::uBLASILUPreconditioner::solve "
Solve linear system Ax = b approximately
";

// Documentation extracted from: (module=la, header=Vector.h)
%feature("docstring")  dolfin::Vector "
This class provides the default DOLFIN vector class,
based on the default DOLFIN linear algebra backend.
";

%feature("docstring")  dolfin::Vector::Vector "
**Overloaded versions**

* Vector\ ()

  Create empty vector

* Vector\ (comm, N)

  Create vector of size N

* Vector\ (x)

  Copy constructor

* Vector\ (x)

  Create a Vector from a GenericVector
";

%feature("docstring")  dolfin::Vector::copy "
Return copy of vector
";

%feature("docstring")  dolfin::Vector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::Vector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::Vector::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::Vector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Vector::init "
**Overloaded versions**

* init\ (comm, N)

  Initialize vector to size N

* init\ (comm, range)

  Initialize vector with given ownership range

* init\ (comm, range, local_to_global_map, ghost_indices)

  Initialize vector with given ownership range and with ghost
  values
";

%feature("docstring")  dolfin::Vector::empty "
Return true if vector is empty
";

%feature("docstring")  dolfin::Vector::size "
Return size of vector
";

%feature("docstring")  dolfin::Vector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::Vector::local_range "
Return local ownership range of a vector
";

%feature("docstring")  dolfin::Vector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::Vector::get "
Get block of values using global indices (values must all live
on the local process, ghosts are no accessible)
";

%feature("docstring")  dolfin::Vector::get_local "
**Overloaded versions**

* get_local\ (block, m, rows)

  Get block of values using local indices (values must all live
  on the local process)

* get_local\ (values)

  Get all values on local process
";

%feature("docstring")  dolfin::Vector::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::Vector::set_local "
**Overloaded versions**

* set_local\ (block, m, rows)

  Set block of values using local indices

* set_local\ (values)

  Set all values on local process
";

%feature("docstring")  dolfin::Vector::add "
Add block of values using global indices
";

%feature("docstring")  dolfin::Vector::add_local "
**Overloaded versions**

* add_local\ (block, m, rows)

  Add block of values using local indices

* add_local\ (values)

  Add values to each entry on local process
";

%feature("docstring")  dolfin::Vector::gather "
**Overloaded versions**

* gather\ (x, indices)

  Gather entries into local vector x

* gather\ (x, indices)

  Gather entries into x
";

%feature("docstring")  dolfin::Vector::gather_on_zero "
Gather all entries into x on process 0
";

%feature("docstring")  dolfin::Vector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::Vector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::Vector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::Vector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::Vector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::Vector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::Vector::sum "
Return sum of values of vector
";

%feature("docstring")  dolfin::Vector::operator*= "
**Overloaded versions**

* operator*=\ (a)

  Multiply vector by given number

* operator*=\ (x)

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::Vector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::Vector::operator+= "
**Overloaded versions**

* operator+=\ (x)

  Add given vector

* operator+=\ (a)

  Add number to all components of a vector
";

%feature("docstring")  dolfin::Vector::operator-= "
**Overloaded versions**

* operator-=\ (x)

  Subtract given vector

* operator-=\ (a)

  Subtract number from all components of a vector
";

%feature("docstring")  dolfin::Vector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator

* operator=\ (x)

  Assignment operator
";

%feature("docstring")  dolfin::Vector::data "
**Overloaded versions**

* data\ ()

  Return pointer to underlying data (const version)

* data\ ()

  Return pointer to underlying data
";

%feature("docstring")  dolfin::Vector::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::Vector::instance "
**Overloaded versions**

* instance\ ()

  Return concrete instance / unwrap (const version)

* instance\ ()

  Return concrete instance / unwrap (non-const version)
";

// Documentation extracted from: (module=la, header=Matrix.h)
%feature("docstring")  dolfin::Matrix "
This class provides the default DOLFIN matrix class,
based on the default DOLFIN linear algebra backend.
";

%feature("docstring")  dolfin::Matrix::Matrix "
**Overloaded versions**

* Matrix\ ()

  Create empty matrix

* Matrix\ (A)

  Copy constructor

* Matrix\ (A)

  Create a Vector from a GenericVector
";

%feature("docstring")  dolfin::Matrix::init "
Initialize zero tensor using tensor layout
";

%feature("docstring")  dolfin::Matrix::empty "
Return true if matrix is empty
";

%feature("docstring")  dolfin::Matrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::Matrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::Matrix::nnz "
Return number of non-zero entries in matrix (collective)
";

%feature("docstring")  dolfin::Matrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows to zero
";

%feature("docstring")  dolfin::Matrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::Matrix::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::Matrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Matrix::copy "
Return copy of matrix
";

%feature("docstring")  dolfin::Matrix::init_vector "
Resize vector y such that is it compatible with matrix for
multiplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
case, size and layout are important.
";

%feature("docstring")  dolfin::Matrix::get "
Get block of values
";

%feature("docstring")  dolfin::Matrix::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::Matrix::set_local "
Set block of values using local indices
";

%feature("docstring")  dolfin::Matrix::add "
Add block of values using global indices
";

%feature("docstring")  dolfin::Matrix::add_local "
Add block of values using local indices
";

%feature("docstring")  dolfin::Matrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::Matrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::Matrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::Matrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::Matrix::zero_local "
Set given rows (local row indices) to zero
";

%feature("docstring")  dolfin::Matrix::ident "
Set given rows (global row indices) to identity matrix
";

%feature("docstring")  dolfin::Matrix::ident_local "
Set given rows (local row indices) to identity matrix
";

%feature("docstring")  dolfin::Matrix::set_diagonal "
Set diagonal of a matrix
";

%feature("docstring")  dolfin::Matrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::Matrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::Matrix::operator= "
**Overloaded versions**

* operator=\ (A)

  Assignment operator

* operator=\ (A)

  Assignment operator
";

%feature("docstring")  dolfin::Matrix::is_symmetric "
Test if matrix is symmetric
";

%feature("docstring")  dolfin::Matrix::data "
Return pointers to underlying compressed storage data.
See GenericMatrix for documentation.
";

%feature("docstring")  dolfin::Matrix::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::Matrix::instance "
**Overloaded versions**

* instance\ ()

  Return concrete instance / unwrap (const version)

* instance\ ()

  Return concrete instance / unwrap (non-const version)
";

// Documentation extracted from: (module=la, header=Scalar.h)
%feature("docstring")  dolfin::Scalar "
This class represents a real-valued scalar quantity and
implements the GenericTensor interface for scalars.
";

%feature("docstring")  dolfin::Scalar::Scalar "
Create zero scalar
";

%feature("docstring")  dolfin::Scalar::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::Scalar::empty "
Return true if empty
";

%feature("docstring")  dolfin::Scalar::rank "
Return tensor rank (number of dimensions)
";

%feature("docstring")  dolfin::Scalar::size "
Return size of given dimension
";

%feature("docstring")  dolfin::Scalar::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::Scalar::get "
Get block of values
";

%feature("docstring")  dolfin::Scalar::set "
Set block of values using global indices
";

%feature("docstring")  dolfin::Scalar::set_local "
Set block of values using local indices
";

%feature("docstring")  dolfin::Scalar::add "
**Overloaded versions**

* add\ (block, num_rows, rows)

  Add block of values using global indices

* add\ (block, rows)

  Add block of values using global indices

* add\ (block, rows)

  Add block of values using global indices
";

%feature("docstring")  dolfin::Scalar::add_local "
**Overloaded versions**

* add_local\ (block, num_rows, rows)

  Add block of values using local indices

* add_local\ (block, rows)

  Add block of values using local indices

* add_local\ (block, rows)

  Add block of values using local indices
";

%feature("docstring")  dolfin::Scalar::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::Scalar::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::Scalar::mpi_comm "
Return MPI communicator
";

%feature("docstring")  dolfin::Scalar::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Scalar::copy "
Return copy of scalar
";

%feature("docstring")  dolfin::Scalar::factory "
Return a factory for the default linear algebra backend
";

%feature("docstring")  dolfin::Scalar::get_scalar_value "
Get final value (assumes prior apply(), not part of GenericTensor interface)
";

%feature("docstring")  dolfin::Scalar::add_local_value "
Add to local increment (added for testing, remove if we add a better way from python)
";

// Documentation extracted from: (module=la, header=LinearSolver.h)
%feature("docstring")  dolfin::LinearSolver "
This class provides a general solver for linear systems Ax = b.
";

%feature("docstring")  dolfin::LinearSolver::LinearSolver "
Create linear solver
";

%feature("docstring")  dolfin::LinearSolver::set_operator "
Set the operator (matrix)
";

%feature("docstring")  dolfin::LinearSolver::set_operators "
Set the operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::LinearSolver::solve "
**Overloaded versions**

* solve\ (A, x, b)

  Solve linear system Ax = b

* solve\ (x, b)

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::LinearSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::LinearSolver::update_parameters "
Update solver parameters (pass parameters down to wrapped implementation)
";

%feature("docstring")  dolfin::LinearSolver::parameter_type "
Return parameter type: \"krylov_solver\" or \"lu_solver\"
";

// Documentation extracted from: (module=la, header=KrylovSolver.h)
%feature("docstring")  dolfin::KrylovSolver "
This class defines an interface for a Krylov solver. The
appropriate solver is chosen on the basis of the matrix/vector
type.
";

%feature("docstring")  dolfin::KrylovSolver::KrylovSolver "
**Overloaded versions**

* KrylovSolver\ (method=\"default\", preconditioner=\"default\")

  Constructor

* KrylovSolver\ (A, method=\"default\", preconditioner=\"default\")

  Constructor
";

%feature("docstring")  dolfin::KrylovSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::KrylovSolver::set_operators "
Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::KrylovSolver::set_nullspace "
Set null space of the operator (matrix). This is used to solve
singular systems
";

%feature("docstring")  dolfin::KrylovSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::KrylovSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::KrylovSolver::update_parameters "
Update solver parameters (pass parameters down to wrapped implementation)
";

%feature("docstring")  dolfin::KrylovSolver::parameter_type "
Return parameter type: \"krylov_solver\" or \"lu_solver\"
";

// Documentation extracted from: (module=la, header=LUSolver.h)
%feature("docstring")  dolfin::LUSolver "
LU solver for the built-in LA backends.
";

%feature("docstring")  dolfin::LUSolver::LUSolver "
**Overloaded versions**

* LUSolver\ (\"default\")

  Constructor

* LUSolver\ (A, method=\"default\")

  Constructor
";

%feature("docstring")  dolfin::LUSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::LUSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system
";

%feature("docstring")  dolfin::LUSolver::solve_transpose "
**Overloaded versions**

* solve_transpose\ (x, b)

  Solve linear system A^Tx = b

* solve_transpose\ (A, x, b)

  Solve linear system
";

%feature("docstring")  dolfin::LUSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::LUSolver::update_parameters "
Update solver parameters (pass parameters down to wrapped
implementation)
";

// Documentation extracted from: (module=la, header=solve.h)
%feature("docstring")  dolfin::solve "
Solve linear system Ax = b
";

%feature("docstring")  dolfin::list_linear_algebra_backends "
List available linear algebra backends
";

%feature("docstring")  dolfin::list_linear_solver_methods "
List available solver methods for current linear algebra backend
";

%feature("docstring")  dolfin::list_lu_solver_methods "
List available LU methods for current linear algebra backend
";

%feature("docstring")  dolfin::list_krylov_solver_methods "
List available Krylov methods for current linear algebra backend
";

%feature("docstring")  dolfin::list_krylov_solver_preconditioners "
List available preconditioners for current linear algebra
backend
";

%feature("docstring")  dolfin::has_lu_solver_method "
Return true if LU method for the current linear algebra backend is
available
";

%feature("docstring")  dolfin::has_krylov_solver_method "
Return true if Krylov method for the current linear algebra
backend is available
";

%feature("docstring")  dolfin::has_krylov_solver_preconditioner "
Return true if Preconditioner for the current linear algebra
backend is available
";

%feature("docstring")  dolfin::linear_algebra_backends "
Return available linear algebra backends
";

%feature("docstring")  dolfin::linear_solver_methods "
Return a list of available solver methods for current linear
algebra backend
";

%feature("docstring")  dolfin::lu_solver_methods "
Return a list of available LU methods for current linear algebra
backend
";

%feature("docstring")  dolfin::krylov_solver_methods "
Return a list of available Krylov methods for current linear
algebra backend
";

%feature("docstring")  dolfin::krylov_solver_preconditioners "
Return a list of available preconditioners for current linear
algebra backend
";

%feature("docstring")  dolfin::residual "
Compute residual ||Ax - b||
";

%feature("docstring")  dolfin::norm "
Compute norm of vector. Valid norm types are \"l2\", \"l1\" and
\"linf\".
";

%feature("docstring")  dolfin::normalize "
Normalize vector according to given normalization type
";

// Documentation extracted from: (module=la, header=test_nullspace.h)
%feature("docstring")  dolfin::in_nullspace "
Check whether a vector space basis is in the nullspace of a
given operator. The string option 'type' can be \"right\" for the
right nullspace (Ax=0) or \"left\" for the left nullspace (A^Tx =
0). To test the left nullspace, A must also be of type
GenericMatrix.
";

// Documentation extracted from: (module=la, header=BlockVector.h)
%feature("docstring")  dolfin::BlockVector::BlockVector "
Constructor
";

%feature("docstring")  dolfin::BlockVector::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::BlockVector::set_block "
Set function
";

%feature("docstring")  dolfin::BlockVector::get_block "
**Overloaded versions**

* get_block\ (i)

  Get sub-vector (const)

* get_block\ ()

  Get sub-vector (non-const)
";

%feature("docstring")  dolfin::BlockVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::BlockVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::BlockVector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::BlockVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::BlockVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::BlockVector::operator*= "
Multiply vector by given number
";

%feature("docstring")  dolfin::BlockVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::BlockVector::operator+= "
Add given vector
";

%feature("docstring")  dolfin::BlockVector::operator-= "
Subtract given vector
";

%feature("docstring")  dolfin::BlockVector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator
";

%feature("docstring")  dolfin::BlockVector::empty "
Return true if empty
";

%feature("docstring")  dolfin::BlockVector::size "
Number of vectors
";

%feature("docstring")  dolfin::BlockVector::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=BlockMatrix.h)
%feature("docstring")  dolfin::BlockMatrix::set_block "
Set block
";

%feature("docstring")  dolfin::BlockMatrix::get_block "
**Overloaded versions**

* get_block\ (i, j)

  Get block (const version)

* get_block\ (i, j)

  Get block
";

%feature("docstring")  dolfin::BlockMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::BlockMatrix::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::BlockMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::BlockMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::BlockMatrix::mult "
Matrix-vector product, y = Ax
";

%feature("docstring")  dolfin::BlockMatrix::schur_approximation "
Create a crude explicit Schur approximation  of S = D - C A^-1
B of  (A B; C  D) If symmetry !=  0, then the  caller promises
that B = symmetry * transpose(C).
";

// Documentation extracted from: (module=la, header=LinearOperator.h)
%feature("docstring")  dolfin::LinearOperator "
This class defines an interface for linear operators defined
only in terms of their action (matrix-vector product) and can be
used for matrix-free solution of linear systems. The linear
algebra backend is decided at run-time based on the present
value of the \"linear_algebra_backend\" parameter.

To define a linear operator, users need to inherit from this
class and overload the function mult(x, y) which defines the
action of the matrix on the vector x as y = Ax.
";

%feature("docstring")  dolfin::LinearOperator::LinearOperator "
Create linear operator
";

%feature("docstring")  dolfin::LinearOperator::size "
Return size of given dimension
";

%feature("docstring")  dolfin::LinearOperator::mult "
Compute matrix-vector product y = Ax
";

%feature("docstring")  dolfin::LinearOperator::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::LinearOperator::instance "
**Overloaded versions**

* instance\ ()

  Return concrete instance / unwrap (const version)

* instance\ ()

  Return concrete instance / unwrap (non-const version)
";

%feature("docstring")  dolfin::LinearOperator::shared_instance "
**Overloaded versions**

* shared_instance\ ()

  Return concrete instance / unwrap (const shared pointer version)

* shared_instance\ ()

  Return concrete instance / unwrap (shared pointer version)
";

