// This code conforms with the UFC specification version 1.5.0
// and was automatically generated by FFC version 1.5.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   restrict_keyword:               ''
//   split:                          True

#include "CahnHilliard3D.h"

/// Constructor
cahnhilliard3d_finite_element_0::cahnhilliard3d_finite_element_0() : ufc::finite_element()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_finite_element_0::~cahnhilliard3d_finite_element_0()
{
    // Do nothing
}

/// Return a string identifying the finite element
const char* cahnhilliard3d_finite_element_0::signature() const
{
    return "FiniteElement('Real', Domain(Cell('tetrahedron', 3)), 0, None)";
}

/// Return the cell shape
ufc::shape cahnhilliard3d_finite_element_0::cell_shape() const
{
    return ufc::tetrahedron;
}

/// Return the topological dimension of the cell shape
std::size_t cahnhilliard3d_finite_element_0::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the cell shape
std::size_t cahnhilliard3d_finite_element_0::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the finite element function space
std::size_t cahnhilliard3d_finite_element_0::space_dimension() const
{
    return 1;
}

/// Return the rank of the value space
std::size_t cahnhilliard3d_finite_element_0::value_rank() const
{
    return 0;
}

/// Return the dimension of the value space for axis i
std::size_t cahnhilliard3d_finite_element_0::value_dimension(std::size_t i) const
{
    return 1;
}

/// Evaluate basis function i at given point x in cell
void cahnhilliard3d_finite_element_0::_evaluate_basis(std::size_t i,
                                    double* values,
                                    const double* x,
                                    const double* vertex_coordinates,
                                    int cell_orientation)
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    
    // Compute subdeterminants
    
    // Get coordinates and map to the reference (FIAT) element
    
    
    // Reset values
    *values = 0.0;
    
    // Array of basisvalues
    double basisvalues[1] = {0.0};
    
    // Declare helper variables
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients
    static const double coefficients0[1] = \
    {1.0};
    
    // Compute value(s)
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    } // end loop over 'r'
}

/// Evaluate all basis functions at given point x in cell
void cahnhilliard3d_finite_element_0::_evaluate_basis_all(double* values,
                                        const double* x,
                                        const double* vertex_coordinates,
                                        int cell_orientation)
{
    // Element is constant, calling evaluate_basis.
    _evaluate_basis(0, values, x, vertex_coordinates, cell_orientation);
}

/// Evaluate order n derivatives of basis function i at given point x in cell
void cahnhilliard3d_finite_element_0::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double* values,
                                                const double* x,
                                                const double* vertex_coordinates,
                                                int cell_orientation)
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 0)
    {
    return ;
    }
    
}

/// Evaluate order n derivatives of all basis functions at given point x in cell
void cahnhilliard3d_finite_element_0::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double* values,
                                                    const double* x,
                                                    const double* vertex_coordinates,
                                                    int cell_orientation)
{
    // Element is constant, calling evaluate_basis_derivatives.
    _evaluate_basis_derivatives(0, n, values, x, vertex_coordinates, cell_orientation);
}

/// Evaluate linear functional for dof i on the function f
double cahnhilliard3d_finite_element_0::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double* vertex_coordinates,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
      y[1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
      y[2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
}

/// Evaluate linear functionals for all dofs on the function f
void cahnhilliard3d_finite_element_0::evaluate_dofs(double* values,
                                  const ufc::function& f,
                                  const double* vertex_coordinates,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    y[1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    y[2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
}

/// Interpolate vertex values from dof values
void cahnhilliard3d_finite_element_0::interpolate_vertex_values(double* vertex_values,
                                              const double* dof_values,
                                              const double* vertex_coordinates,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
    vertex_values[3] = dof_values[0];
}

/// Map coordinate xhat from reference cell to coordinate x in cell
void cahnhilliard3d_finite_element_0::map_from_reference_cell(double* x,
                                            const double* xhat,
                                            const ufc::cell& c) const
{
    throw std::runtime_error("map_from_reference_cell not yet implemented.");
}

/// Map from coordinate x in cell to coordinate xhat in reference cell
void cahnhilliard3d_finite_element_0::map_to_reference_cell(double* xhat,
                                          const double* x,
                                          const ufc::cell& c) const
{
    throw std::runtime_error("map_to_reference_cell not yet implemented.");
}

/// Return the number of sub elements (for a mixed element)
std::size_t cahnhilliard3d_finite_element_0::num_sub_elements() const
{
    return 0;
}

/// Create a new finite element for sub element i (for a mixed element)
ufc::finite_element* cahnhilliard3d_finite_element_0::create_sub_element(std::size_t i) const
{
    return 0;
}

/// Create a new class instance
ufc::finite_element* cahnhilliard3d_finite_element_0::create() const
{
    return new cahnhilliard3d_finite_element_0();
}


/// Constructor
cahnhilliard3d_finite_element_1::cahnhilliard3d_finite_element_1() : ufc::finite_element()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_finite_element_1::~cahnhilliard3d_finite_element_1()
{
    // Do nothing
}

/// Return a string identifying the finite element
const char* cahnhilliard3d_finite_element_1::signature() const
{
    return "FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3)), 1, None)";
}

/// Return the cell shape
ufc::shape cahnhilliard3d_finite_element_1::cell_shape() const
{
    return ufc::tetrahedron;
}

/// Return the topological dimension of the cell shape
std::size_t cahnhilliard3d_finite_element_1::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the cell shape
std::size_t cahnhilliard3d_finite_element_1::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the finite element function space
std::size_t cahnhilliard3d_finite_element_1::space_dimension() const
{
    return 4;
}

/// Return the rank of the value space
std::size_t cahnhilliard3d_finite_element_1::value_rank() const
{
    return 0;
}

/// Return the dimension of the value space for axis i
std::size_t cahnhilliard3d_finite_element_1::value_dimension(std::size_t i) const
{
    return 1;
}

/// Evaluate basis function i at given point x in cell
void cahnhilliard3d_finite_element_1::_evaluate_basis(std::size_t i,
                                    double* values,
                                    const double* x,
                                    const double* vertex_coordinates,
                                    int cell_orientation)
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
}

/// Evaluate all basis functions at given point x in cell
void cahnhilliard3d_finite_element_1::_evaluate_basis_all(double* values,
                                        const double* x,
                                        const double* vertex_coordinates,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 4; r++)
    {
      _evaluate_basis(r, &dof_values, x, vertex_coordinates, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
}

/// Evaluate order n derivatives of basis function i at given point x in cell
void cahnhilliard3d_finite_element_1::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double* values,
                                                const double* x,
                                                const double* vertex_coordinates,
                                                int cell_orientation)
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[3][1];
    for (unsigned int row = 0; row < 3; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[3][3];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
}

/// Evaluate order n derivatives of all basis functions at given point x in cell
void cahnhilliard3d_finite_element_1::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double* values,
                                                    const double* x,
                                                    const double* vertex_coordinates,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[3];
    for (unsigned int r = 0; r < 3; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 4; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

/// Evaluate linear functional for dof i on the function f
double cahnhilliard3d_finite_element_1::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double* vertex_coordinates,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
}

/// Evaluate linear functionals for all dofs on the function f
void cahnhilliard3d_finite_element_1::evaluate_dofs(double* values,
                                  const ufc::function& f,
                                  const double* vertex_coordinates,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
}

/// Interpolate vertex values from dof values
void cahnhilliard3d_finite_element_1::interpolate_vertex_values(double* vertex_values,
                                              const double* dof_values,
                                              const double* vertex_coordinates,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
}

/// Map coordinate xhat from reference cell to coordinate x in cell
void cahnhilliard3d_finite_element_1::map_from_reference_cell(double* x,
                                            const double* xhat,
                                            const ufc::cell& c) const
{
    throw std::runtime_error("map_from_reference_cell not yet implemented.");
}

/// Map from coordinate x in cell to coordinate xhat in reference cell
void cahnhilliard3d_finite_element_1::map_to_reference_cell(double* xhat,
                                          const double* x,
                                          const ufc::cell& c) const
{
    throw std::runtime_error("map_to_reference_cell not yet implemented.");
}

/// Return the number of sub elements (for a mixed element)
std::size_t cahnhilliard3d_finite_element_1::num_sub_elements() const
{
    return 0;
}

/// Create a new finite element for sub element i (for a mixed element)
ufc::finite_element* cahnhilliard3d_finite_element_1::create_sub_element(std::size_t i) const
{
    return 0;
}

/// Create a new class instance
ufc::finite_element* cahnhilliard3d_finite_element_1::create() const
{
    return new cahnhilliard3d_finite_element_1();
}


/// Constructor
cahnhilliard3d_finite_element_2::cahnhilliard3d_finite_element_2() : ufc::finite_element()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_finite_element_2::~cahnhilliard3d_finite_element_2()
{
    // Do nothing
}

/// Return a string identifying the finite element
const char* cahnhilliard3d_finite_element_2::signature() const
{
    return "MixedElement(FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3)), 1, None), FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3)), 1, None), **{'value_shape': (2,) })";
}

/// Return the cell shape
ufc::shape cahnhilliard3d_finite_element_2::cell_shape() const
{
    return ufc::tetrahedron;
}

/// Return the topological dimension of the cell shape
std::size_t cahnhilliard3d_finite_element_2::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the cell shape
std::size_t cahnhilliard3d_finite_element_2::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the finite element function space
std::size_t cahnhilliard3d_finite_element_2::space_dimension() const
{
    return 8;
}

/// Return the rank of the value space
std::size_t cahnhilliard3d_finite_element_2::value_rank() const
{
    return 1;
}

/// Return the dimension of the value space for axis i
std::size_t cahnhilliard3d_finite_element_2::value_dimension(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
}

/// Evaluate basis function i at given point x in cell
void cahnhilliard3d_finite_element_2::_evaluate_basis(std::size_t i,
                                    double* values,
                                    const double* x,
                                    const double* vertex_coordinates,
                                    int cell_orientation)
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
}

/// Evaluate all basis functions at given point x in cell
void cahnhilliard3d_finite_element_2::_evaluate_basis_all(double* values,
                                        const double* x,
                                        const double* vertex_coordinates,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 8; r++)
    {
      _evaluate_basis(r, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

/// Evaluate order n derivatives of basis function i at given point x in cell
void cahnhilliard3d_finite_element_2::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double* values,
                                                const double* x,
                                                const double* vertex_coordinates,
                                                int cell_orientation)
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[3][1];
    for (unsigned int row = 0; row < 3; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[3][3];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
}

/// Evaluate order n derivatives of all basis functions at given point x in cell
void cahnhilliard3d_finite_element_2::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double* values,
                                                    const double* x,
                                                    const double* vertex_coordinates,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 8; r++)
    {
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[6];
    for (unsigned int r = 0; r < 6; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 8; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

/// Evaluate linear functional for dof i on the function f
double cahnhilliard3d_finite_element_2::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double* vertex_coordinates,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 6:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 7:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    }
    
    return 0.0;
}

/// Evaluate linear functionals for all dofs on the function f
void cahnhilliard3d_finite_element_2::evaluate_dofs(double* values,
                                  const ufc::function& f,
                                  const double* vertex_coordinates,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[4] = vals[1];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[5] = vals[1];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[6] = vals[1];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[7] = vals[1];
}

/// Interpolate vertex values from dof values
void cahnhilliard3d_finite_element_2::interpolate_vertex_values(double* vertex_values,
                                              const double* dof_values,
                                              const double* vertex_coordinates,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[2] = dof_values[1];
    vertex_values[4] = dof_values[2];
    vertex_values[6] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[4];
    vertex_values[3] = dof_values[5];
    vertex_values[5] = dof_values[6];
    vertex_values[7] = dof_values[7];
}

/// Map coordinate xhat from reference cell to coordinate x in cell
void cahnhilliard3d_finite_element_2::map_from_reference_cell(double* x,
                                            const double* xhat,
                                            const ufc::cell& c) const
{
    throw std::runtime_error("map_from_reference_cell not yet implemented.");
}

/// Map from coordinate x in cell to coordinate xhat in reference cell
void cahnhilliard3d_finite_element_2::map_to_reference_cell(double* xhat,
                                          const double* x,
                                          const ufc::cell& c) const
{
    throw std::runtime_error("map_to_reference_cell not yet implemented.");
}

/// Return the number of sub elements (for a mixed element)
std::size_t cahnhilliard3d_finite_element_2::num_sub_elements() const
{
    return 2;
}

/// Create a new finite element for sub element i (for a mixed element)
ufc::finite_element* cahnhilliard3d_finite_element_2::create_sub_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_finite_element_1();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_finite_element_1();
        break;
      }
    }
    
    return 0;
}

/// Create a new class instance
ufc::finite_element* cahnhilliard3d_finite_element_2::create() const
{
    return new cahnhilliard3d_finite_element_2();
}

/// Constructor
cahnhilliard3d_dofmap_0::cahnhilliard3d_dofmap_0() : ufc::dofmap()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_dofmap_0::~cahnhilliard3d_dofmap_0()
{
    // Do nothing
}

/// Return a string identifying the dofmap
const char* cahnhilliard3d_dofmap_0::signature() const
{
    return "FFC dofmap for FiniteElement('Real', Domain(Cell('tetrahedron', 3)), 0, None)";
}

/// Return true iff mesh entities of topological dimension d are needed
bool cahnhilliard3d_dofmap_0::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
}

/// Return the topological dimension of the associated cell shape
std::size_t cahnhilliard3d_dofmap_0::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the associated cell shape
std::size_t cahnhilliard3d_dofmap_0::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the global finite element function space
std::size_t cahnhilliard3d_dofmap_0::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return 1;
}

/// Return the dimension of the local finite element function space for a cell
std::size_t cahnhilliard3d_dofmap_0::local_dimension() const
{
    return 1;
}

/// Return the number of dofs on each cell facet
std::size_t cahnhilliard3d_dofmap_0::num_facet_dofs() const
{
    return 0;
}

/// Return the number of dofs associated with each cell entity of dimension d
std::size_t cahnhilliard3d_dofmap_0::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 1;
        break;
      }
    }
    
    return 0;
}

/// Tabulate the local-to-global mapping of dofs on a cell
void cahnhilliard3d_dofmap_0::tabulate_dofs(std::size_t* dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const ufc::cell& c) const
{
    dofs[0] = 0;
}

/// Tabulate the local-to-local mapping from facet dofs to cell dofs
void cahnhilliard3d_dofmap_0::tabulate_facet_dofs(std::size_t* dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
}

/// Tabulate the local-to-local mapping of dofs on entity (d, i)
void cahnhilliard3d_dofmap_0::tabulate_entity_dofs(std::size_t* dofs,
                                  std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
}

/// Tabulate the coordinates of all dofs on a cell
void cahnhilliard3d_dofmap_0::tabulate_coordinates(double* dof_coordinates,
                                         const double* vertex_coordinates) const
{
    dof_coordinates[0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    dof_coordinates[1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    dof_coordinates[2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
}

/// Return the number of sub dofmaps (for a mixed element)
std::size_t cahnhilliard3d_dofmap_0::num_sub_dofmaps() const
{
    return 0;
}

/// Create a new dofmap for sub dofmap i (for a mixed element)
ufc::dofmap* cahnhilliard3d_dofmap_0::create_sub_dofmap(std::size_t i) const
{
    return 0;
}

/// Create a new class instance
ufc::dofmap* cahnhilliard3d_dofmap_0::create() const
{
    return new cahnhilliard3d_dofmap_0();
}

/// Constructor
cahnhilliard3d_dofmap_1::cahnhilliard3d_dofmap_1() : ufc::dofmap()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_dofmap_1::~cahnhilliard3d_dofmap_1()
{
    // Do nothing
}

/// Return a string identifying the dofmap
const char* cahnhilliard3d_dofmap_1::signature() const
{
    return "FFC dofmap for FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3)), 1, None)";
}

/// Return true iff mesh entities of topological dimension d are needed
bool cahnhilliard3d_dofmap_1::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
}

/// Return the topological dimension of the associated cell shape
std::size_t cahnhilliard3d_dofmap_1::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the associated cell shape
std::size_t cahnhilliard3d_dofmap_1::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the global finite element function space
std::size_t cahnhilliard3d_dofmap_1::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return num_global_entities[0];
}

/// Return the dimension of the local finite element function space for a cell
std::size_t cahnhilliard3d_dofmap_1::local_dimension() const
{
    return 4;
}

/// Return the number of dofs on each cell facet
std::size_t cahnhilliard3d_dofmap_1::num_facet_dofs() const
{
    return 3;
}

/// Return the number of dofs associated with each cell entity of dimension d
std::size_t cahnhilliard3d_dofmap_1::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
}

/// Tabulate the local-to-global mapping of dofs on a cell
void cahnhilliard3d_dofmap_1::tabulate_dofs(std::size_t* dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const ufc::cell& c) const
{
    dofs[0] = c.entity_indices[0][0];
    dofs[1] = c.entity_indices[0][1];
    dofs[2] = c.entity_indices[0][2];
    dofs[3] = c.entity_indices[0][3];
}

/// Tabulate the local-to-local mapping from facet dofs to cell dofs
void cahnhilliard3d_dofmap_1::tabulate_facet_dofs(std::size_t* dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
}

/// Tabulate the local-to-local mapping of dofs on entity (d, i)
void cahnhilliard3d_dofmap_1::tabulate_entity_dofs(std::size_t* dofs,
                                  std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
}

/// Tabulate the coordinates of all dofs on a cell
void cahnhilliard3d_dofmap_1::tabulate_coordinates(double* dof_coordinates,
                                         const double* vertex_coordinates) const
{
    dof_coordinates[0] = vertex_coordinates[0];
    dof_coordinates[1] = vertex_coordinates[1];
    dof_coordinates[2] = vertex_coordinates[2];
    dof_coordinates[3] = vertex_coordinates[3];
    dof_coordinates[4] = vertex_coordinates[4];
    dof_coordinates[5] = vertex_coordinates[5];
    dof_coordinates[6] = vertex_coordinates[6];
    dof_coordinates[7] = vertex_coordinates[7];
    dof_coordinates[8] = vertex_coordinates[8];
    dof_coordinates[9] = vertex_coordinates[9];
    dof_coordinates[10] = vertex_coordinates[10];
    dof_coordinates[11] = vertex_coordinates[11];
}

/// Return the number of sub dofmaps (for a mixed element)
std::size_t cahnhilliard3d_dofmap_1::num_sub_dofmaps() const
{
    return 0;
}

/// Create a new dofmap for sub dofmap i (for a mixed element)
ufc::dofmap* cahnhilliard3d_dofmap_1::create_sub_dofmap(std::size_t i) const
{
    return 0;
}

/// Create a new class instance
ufc::dofmap* cahnhilliard3d_dofmap_1::create() const
{
    return new cahnhilliard3d_dofmap_1();
}

/// Constructor
cahnhilliard3d_dofmap_2::cahnhilliard3d_dofmap_2() : ufc::dofmap()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_dofmap_2::~cahnhilliard3d_dofmap_2()
{
    // Do nothing
}

/// Return a string identifying the dofmap
const char* cahnhilliard3d_dofmap_2::signature() const
{
    return "FFC dofmap for MixedElement(FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3)), 1, None), FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3)), 1, None), **{'value_shape': (2,) })";
}

/// Return true iff mesh entities of topological dimension d are needed
bool cahnhilliard3d_dofmap_2::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
}

/// Return the topological dimension of the associated cell shape
std::size_t cahnhilliard3d_dofmap_2::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the associated cell shape
std::size_t cahnhilliard3d_dofmap_2::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the global finite element function space
std::size_t cahnhilliard3d_dofmap_2::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return 2*num_global_entities[0];
}

/// Return the dimension of the local finite element function space for a cell
std::size_t cahnhilliard3d_dofmap_2::local_dimension() const
{
    return 8;
}

/// Return the number of dofs on each cell facet
std::size_t cahnhilliard3d_dofmap_2::num_facet_dofs() const
{
    return 6;
}

/// Return the number of dofs associated with each cell entity of dimension d
std::size_t cahnhilliard3d_dofmap_2::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
}

/// Tabulate the local-to-global mapping of dofs on a cell
void cahnhilliard3d_dofmap_2::tabulate_dofs(std::size_t* dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const ufc::cell& c) const
{
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[4] = offset + c.entity_indices[0][0];
    dofs[5] = offset + c.entity_indices[0][1];
    dofs[6] = offset + c.entity_indices[0][2];
    dofs[7] = offset + c.entity_indices[0][3];
    offset += num_global_entities[0];
}

/// Tabulate the local-to-local mapping from facet dofs to cell dofs
void cahnhilliard3d_dofmap_2::tabulate_facet_dofs(std::size_t* dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 6;
      dofs[5] = 7;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 6;
      dofs[5] = 7;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 7;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
        break;
      }
    }
    
}

/// Tabulate the local-to-local mapping of dofs on entity (d, i)
void cahnhilliard3d_dofmap_2::tabulate_entity_dofs(std::size_t* dofs,
                                  std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 6;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 7;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
}

/// Tabulate the coordinates of all dofs on a cell
void cahnhilliard3d_dofmap_2::tabulate_coordinates(double* dof_coordinates,
                                         const double* vertex_coordinates) const
{
    dof_coordinates[0] = vertex_coordinates[0];
    dof_coordinates[1] = vertex_coordinates[1];
    dof_coordinates[2] = vertex_coordinates[2];
    dof_coordinates[3] = vertex_coordinates[3];
    dof_coordinates[4] = vertex_coordinates[4];
    dof_coordinates[5] = vertex_coordinates[5];
    dof_coordinates[6] = vertex_coordinates[6];
    dof_coordinates[7] = vertex_coordinates[7];
    dof_coordinates[8] = vertex_coordinates[8];
    dof_coordinates[9] = vertex_coordinates[9];
    dof_coordinates[10] = vertex_coordinates[10];
    dof_coordinates[11] = vertex_coordinates[11];
    dof_coordinates[12] = vertex_coordinates[0];
    dof_coordinates[13] = vertex_coordinates[1];
    dof_coordinates[14] = vertex_coordinates[2];
    dof_coordinates[15] = vertex_coordinates[3];
    dof_coordinates[16] = vertex_coordinates[4];
    dof_coordinates[17] = vertex_coordinates[5];
    dof_coordinates[18] = vertex_coordinates[6];
    dof_coordinates[19] = vertex_coordinates[7];
    dof_coordinates[20] = vertex_coordinates[8];
    dof_coordinates[21] = vertex_coordinates[9];
    dof_coordinates[22] = vertex_coordinates[10];
    dof_coordinates[23] = vertex_coordinates[11];
}

/// Return the number of sub dofmaps (for a mixed element)
std::size_t cahnhilliard3d_dofmap_2::num_sub_dofmaps() const
{
    return 2;
}

/// Create a new dofmap for sub dofmap i (for a mixed element)
ufc::dofmap* cahnhilliard3d_dofmap_2::create_sub_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_dofmap_1();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_dofmap_1();
        break;
      }
    }
    
    return 0;
}

/// Create a new class instance
ufc::dofmap* cahnhilliard3d_dofmap_2::create() const
{
    return new cahnhilliard3d_dofmap_2();
}

/// Constructor
cahnhilliard3d_cell_integral_0_otherwise::cahnhilliard3d_cell_integral_0_otherwise() : ufc::cell_integral()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_cell_integral_0_otherwise::~cahnhilliard3d_cell_integral_0_otherwise()
{
    // Do nothing
}

/// Tabulate which form coefficients are used by this integral
const std::vector<bool> & cahnhilliard3d_cell_integral_0_otherwise::enabled_coefficients() const
{
    static const std::vector<bool> enabled({true, true, true, true, true});
    return enabled;
}

/// Tabulate the tensor for the contribution from a local cell
void cahnhilliard3d_cell_integral_0_otherwise::tabulate_tensor(double*  A,
                                    const double * const *  w,
                                    const double*  vertex_coordinates,
                                    int cell_orientation) const
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute cell volume
    
    
    // Compute circumradius
    
    
    // Array of quadrature weights.
    static const double W14[14] = {0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.0147649707904968, 0.0147649707904968, 0.0147649707904968, 0.0147649707904968, 0.0221397911142651, 0.0221397911142651, 0.0221397911142651, 0.0221397911142651};
    // Quadrature points on the UFC reference element: (0.0, 0.5, 0.5), (0.5, 0.0, 0.5), (0.5, 0.5, 0.0), (0.5, 0.0, 0.0), (0.0, 0.5, 0.0), (0.0, 0.0, 0.5), (0.698419704324387, 0.100526765225204, 0.100526765225204), (0.100526765225204, 0.100526765225204, 0.100526765225204), (0.100526765225204, 0.100526765225204, 0.698419704324387), (0.100526765225204, 0.698419704324387, 0.100526765225204), (0.0568813795204234, 0.314372873493192, 0.314372873493192), (0.314372873493192, 0.314372873493192, 0.314372873493192), (0.314372873493192, 0.314372873493192, 0.0568813795204234), (0.314372873493192, 0.0568813795204234, 0.314372873493192)
    
    // Values of basis functions at quadrature points.
    static const double FE0_C0[14][4] = \
    {{0.0, 0.0, 0.5, 0.5},
    {0.0, 0.5, 0.0, 0.5},
    {0.0, 0.5, 0.5, 0.0},
    {0.5, 0.5, 0.0, 0.0},
    {0.5, 0.0, 0.5, 0.0},
    {0.5, 0.0, 0.0, 0.5},
    {0.100526765225205, 0.698419704324386, 0.100526765225205, 0.100526765225205},
    {0.698419704324387, 0.100526765225204, 0.100526765225205, 0.100526765225205},
    {0.100526765225205, 0.100526765225204, 0.100526765225205, 0.698419704324386},
    {0.100526765225205, 0.100526765225204, 0.698419704324386, 0.100526765225205},
    {0.314372873493192, 0.0568813795204234, 0.314372873493192, 0.314372873493192},
    {0.0568813795204235, 0.314372873493192, 0.314372873493192, 0.314372873493192},
    {0.314372873493192, 0.314372873493192, 0.314372873493192, 0.0568813795204234},
    {0.314372873493192, 0.314372873493192, 0.0568813795204235, 0.314372873493192}};
    
    // Array of non-zero columns
    static const unsigned int nzc12[4] = {0, 1, 2, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc16[4] = {4, 5, 6, 7};
    
    static const double FE0_C0_D001[14][2] = \
    {{-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc13[2] = {0, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc14[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc15[2] = {0, 1};
    
    // Array of non-zero columns
    static const unsigned int nzc17[2] = {4, 7};
    
    // Array of non-zero columns
    static const unsigned int nzc18[2] = {4, 6};
    
    // Array of non-zero columns
    static const unsigned int nzc19[2] = {4, 5};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 8; r++)
    {
      A[r] = 0.0;
    } // end loop over 'r'
    // Number of operations to compute geometry constants: 177.
    double G[21];
    G[0] = det*w[3][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8] - w[4][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]));
    G[1] = det*w[3][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8] - w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[2] = det*w[3][0]*w[4][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]);
    G[3] = det*w[3][0]*w[4][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]);
    G[4] = det*w[3][0]*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]);
    G[5] = det*w[3][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8] - w[4][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]));
    G[6] = det*w[3][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5] - w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[7] = det*w[3][0]*w[4][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]);
    G[8] = det*w[3][0]*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]);
    G[9] = det*w[3][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5] - w[4][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]));
    G[10] = det*w[3][0]*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]);
    G[11] = det*w[3][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2] - w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[12] =  - det*w[2][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]);
    G[13] =  - det*w[2][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]);
    G[14] =  - det*w[2][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]);
    G[15] =  - det*w[2][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]);
    G[16] =  - det*w[2][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]);
    G[17] =  - det*w[2][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]);
    G[18] = -400.0*det;
    G[19] = 600.0*det;
    G[20] = -200.0*det;
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 2310
    for (unsigned int ip = 0; ip < 14; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      double F1 = 0.0;
      double F2 = 0.0;
      double F3 = 0.0;
      double F4 = 0.0;
      double F5 = 0.0;
      double F6 = 0.0;
      double F7 = 0.0;
      double F8 = 0.0;
      double F9 = 0.0;
      double F10 = 0.0;
      double F11 = 0.0;
      
      // Total number of operations to compute function values = 36
      for (unsigned int r = 0; r < 2; r++)
      {
        F3 += FE0_C0_D001[ip][r]*w[0][nzc15[r]];
        F4 += FE0_C0_D001[ip][r]*w[0][nzc14[r]];
        F5 += FE0_C0_D001[ip][r]*w[0][nzc13[r]];
        F6 += FE0_C0_D001[ip][r]*w[0][nzc19[r]];
        F7 += FE0_C0_D001[ip][r]*w[0][nzc18[r]];
        F8 += FE0_C0_D001[ip][r]*w[0][nzc17[r]];
        F9 += FE0_C0_D001[ip][r]*w[1][nzc19[r]];
        F10 += FE0_C0_D001[ip][r]*w[1][nzc18[r]];
        F11 += FE0_C0_D001[ip][r]*w[1][nzc17[r]];
      } // end loop over 'r'
      
      // Total number of operations to compute function values = 24
      for (unsigned int r = 0; r < 4; r++)
      {
        F0 += FE0_C0[ip][r]*w[0][nzc16[r]];
        F1 += FE0_C0[ip][r]*w[0][nzc12[r]];
        F2 += FE0_C0[ip][r]*w[1][nzc12[r]];
      } // end loop over 'r'
      
      // Number of operations to compute ip constants: 65
      double I[8];
      // Number of operations: 12
      I[0] = W14[ip]*(F10*G[0] + F11*G[1] + F6*G[2] + F7*G[3] + F8*G[4] + F9*G[5]);
      
      // Number of operations: 12
      I[1] = W14[ip]*(F10*G[6] + F11*G[0] + F6*G[7] + F7*G[8] + F8*G[3] + F9*G[9]);
      
      // Number of operations: 12
      I[2] = W14[ip]*(F10*G[9] + F11*G[5] + F6*G[10] + F7*G[7] + F8*G[2] + F9*G[11]);
      
      // Number of operations: 6
      I[3] = W14[ip]*(F3*G[12] + F4*G[13] + F5*G[14]);
      
      // Number of operations: 6
      I[4] = W14[ip]*(F3*G[15] + F4*G[16] + F5*G[13]);
      
      // Number of operations: 6
      I[5] = W14[ip]*(F3*G[17] + F4*G[15] + F5*G[12]);
      
      // Number of operations: 3
      I[6] = W14[ip]*det*(F1 - F2);
      
      // Number of operations: 8
      I[7] = W14[ip]*(F0*det + F1*(G[20] + F1*(G[19] + F1*G[18])));
      
      
      // Number of operations for primary indices: 24
      for (unsigned int j = 0; j < 2; j++)
      {
        // Number of operations to compute entry: 2
        A[nzc13[j]] += FE0_C0_D001[ip][j]*I[0];
        // Number of operations to compute entry: 2
        A[nzc14[j]] += FE0_C0_D001[ip][j]*I[1];
        // Number of operations to compute entry: 2
        A[nzc15[j]] += FE0_C0_D001[ip][j]*I[2];
        // Number of operations to compute entry: 2
        A[nzc17[j]] += FE0_C0_D001[ip][j]*I[3];
        // Number of operations to compute entry: 2
        A[nzc18[j]] += FE0_C0_D001[ip][j]*I[4];
        // Number of operations to compute entry: 2
        A[nzc19[j]] += FE0_C0_D001[ip][j]*I[5];
      } // end loop over 'j'
      
      // Number of operations for primary indices: 16
      for (unsigned int j = 0; j < 4; j++)
      {
        // Number of operations to compute entry: 2
        A[nzc12[j]] += FE0_C0[ip][j]*I[6];
        // Number of operations to compute entry: 2
        A[nzc16[j]] += FE0_C0[ip][j]*I[7];
      } // end loop over 'j'
    } // end loop over 'ip'
}

/// Constructor
cahnhilliard3d_cell_integral_1_otherwise::cahnhilliard3d_cell_integral_1_otherwise() : ufc::cell_integral()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_cell_integral_1_otherwise::~cahnhilliard3d_cell_integral_1_otherwise()
{
    // Do nothing
}

/// Tabulate which form coefficients are used by this integral
const std::vector<bool> & cahnhilliard3d_cell_integral_1_otherwise::enabled_coefficients() const
{
    static const std::vector<bool> enabled({true, true, true, true});
    return enabled;
}

/// Tabulate the tensor for the contribution from a local cell
void cahnhilliard3d_cell_integral_1_otherwise::tabulate_tensor(double*  A,
                                    const double * const *  w,
                                    const double*  vertex_coordinates,
                                    int cell_orientation) const
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute cell volume
    
    
    // Compute circumradius
    
    
    // Array of quadrature weights.
    static const double W14[14] = {0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.0147649707904968, 0.0147649707904968, 0.0147649707904968, 0.0147649707904968, 0.0221397911142651, 0.0221397911142651, 0.0221397911142651, 0.0221397911142651};
    // Quadrature points on the UFC reference element: (0.0, 0.5, 0.5), (0.5, 0.0, 0.5), (0.5, 0.5, 0.0), (0.5, 0.0, 0.0), (0.0, 0.5, 0.0), (0.0, 0.0, 0.5), (0.698419704324387, 0.100526765225204, 0.100526765225204), (0.100526765225204, 0.100526765225204, 0.100526765225204), (0.100526765225204, 0.100526765225204, 0.698419704324387), (0.100526765225204, 0.698419704324387, 0.100526765225204), (0.0568813795204234, 0.314372873493192, 0.314372873493192), (0.314372873493192, 0.314372873493192, 0.314372873493192), (0.314372873493192, 0.314372873493192, 0.0568813795204234), (0.314372873493192, 0.0568813795204234, 0.314372873493192)
    
    // Values of basis functions at quadrature points.
    static const double FE0_C0[14][4] = \
    {{0.0, 0.0, 0.5, 0.5},
    {0.0, 0.5, 0.0, 0.5},
    {0.0, 0.5, 0.5, 0.0},
    {0.5, 0.5, 0.0, 0.0},
    {0.5, 0.0, 0.5, 0.0},
    {0.5, 0.0, 0.0, 0.5},
    {0.100526765225205, 0.698419704324386, 0.100526765225205, 0.100526765225205},
    {0.698419704324387, 0.100526765225204, 0.100526765225205, 0.100526765225205},
    {0.100526765225205, 0.100526765225204, 0.100526765225205, 0.698419704324386},
    {0.100526765225205, 0.100526765225204, 0.698419704324386, 0.100526765225205},
    {0.314372873493192, 0.0568813795204234, 0.314372873493192, 0.314372873493192},
    {0.0568813795204235, 0.314372873493192, 0.314372873493192, 0.314372873493192},
    {0.314372873493192, 0.314372873493192, 0.314372873493192, 0.0568813795204234},
    {0.314372873493192, 0.314372873493192, 0.0568813795204235, 0.314372873493192}};
    
    // Array of non-zero columns
    static const unsigned int nzc12[4] = {0, 1, 2, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc16[4] = {4, 5, 6, 7};
    
    static const double FE0_C0_D001[14][2] = \
    {{-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc13[2] = {0, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc14[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc15[2] = {0, 1};
    
    // Array of non-zero columns
    static const unsigned int nzc17[2] = {4, 7};
    
    // Array of non-zero columns
    static const unsigned int nzc18[2] = {4, 6};
    
    // Array of non-zero columns
    static const unsigned int nzc19[2] = {4, 5};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 64; r++)
    {
      A[r] = 0.0;
    } // end loop over 'r'
    // Number of operations to compute geometry constants: 93.
    double G[15];
    G[0] = det*w[2][0]*w[3][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]);
    G[1] = det*w[2][0]*w[3][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]);
    G[2] = det*w[2][0]*w[3][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]);
    G[3] = det*w[2][0]*w[3][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]);
    G[4] = det*w[2][0]*w[3][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]);
    G[5] = det*w[2][0]*w[3][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]);
    G[6] =  - det*w[1][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]);
    G[7] =  - det*w[1][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]);
    G[8] =  - det*w[1][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]);
    G[9] =  - det*w[1][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]);
    G[10] =  - det*w[1][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]);
    G[11] =  - det*w[1][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]);
    G[12] = -200.0*det;
    G[13] = -1200.0*det;
    G[14] = 1200.0*det;
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 5404
    for (unsigned int ip = 0; ip < 14; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      
      // Total number of operations to compute function values = 8
      for (unsigned int r = 0; r < 4; r++)
      {
        F0 += FE0_C0[ip][r]*w[0][nzc12[r]];
      } // end loop over 'r'
      
      // Number of operations to compute ip constants: 18
      double I[14];
      // Number of operations: 1
      I[0] = G[0]*W14[ip];
      
      // Number of operations: 1
      I[1] = G[1]*W14[ip];
      
      // Number of operations: 1
      I[2] = G[2]*W14[ip];
      
      // Number of operations: 1
      I[3] = G[3]*W14[ip];
      
      // Number of operations: 1
      I[4] = G[4]*W14[ip];
      
      // Number of operations: 1
      I[5] = G[5]*W14[ip];
      
      // Number of operations: 1
      I[6] = G[6]*W14[ip];
      
      // Number of operations: 1
      I[7] = G[7]*W14[ip];
      
      // Number of operations: 1
      I[8] = G[8]*W14[ip];
      
      // Number of operations: 1
      I[9] = G[9]*W14[ip];
      
      // Number of operations: 1
      I[10] = G[10]*W14[ip];
      
      // Number of operations: 1
      I[11] = G[11]*W14[ip];
      
      // Number of operations: 1
      I[12] = W14[ip]*det;
      
      // Number of operations: 5
      I[13] = W14[ip]*(G[12] + F0*(G[14] + F0*G[13]));
      
      
      // Number of operations for primary indices: 216
      for (unsigned int j = 0; j < 2; j++)
      {
        for (unsigned int k = 0; k < 2; k++)
        {
          // Number of operations to compute entry: 3
          A[nzc13[j]*8 + nzc17[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[0];
          // Number of operations to compute entry: 3
          A[nzc13[j]*8 + nzc18[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[1];
          // Number of operations to compute entry: 3
          A[nzc13[j]*8 + nzc19[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[2];
          // Number of operations to compute entry: 3
          A[nzc14[j]*8 + nzc17[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[1];
          // Number of operations to compute entry: 3
          A[nzc14[j]*8 + nzc18[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[3];
          // Number of operations to compute entry: 3
          A[nzc14[j]*8 + nzc19[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[4];
          // Number of operations to compute entry: 3
          A[nzc15[j]*8 + nzc17[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[2];
          // Number of operations to compute entry: 3
          A[nzc15[j]*8 + nzc18[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[4];
          // Number of operations to compute entry: 3
          A[nzc15[j]*8 + nzc19[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[5];
          // Number of operations to compute entry: 3
          A[nzc17[j]*8 + nzc13[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[6];
          // Number of operations to compute entry: 3
          A[nzc17[j]*8 + nzc14[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[7];
          // Number of operations to compute entry: 3
          A[nzc17[j]*8 + nzc15[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[8];
          // Number of operations to compute entry: 3
          A[nzc18[j]*8 + nzc13[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[7];
          // Number of operations to compute entry: 3
          A[nzc18[j]*8 + nzc14[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[9];
          // Number of operations to compute entry: 3
          A[nzc18[j]*8 + nzc15[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[10];
          // Number of operations to compute entry: 3
          A[nzc19[j]*8 + nzc13[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[8];
          // Number of operations to compute entry: 3
          A[nzc19[j]*8 + nzc14[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[10];
          // Number of operations to compute entry: 3
          A[nzc19[j]*8 + nzc15[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[11];
        } // end loop over 'k'
      } // end loop over 'j'
      
      // Number of operations for primary indices: 144
      for (unsigned int j = 0; j < 4; j++)
      {
        for (unsigned int k = 0; k < 4; k++)
        {
          // Number of operations to compute entry: 3
          A[nzc12[j]*8 + nzc12[k]] += FE0_C0[ip][j]*FE0_C0[ip][k]*I[12];
          // Number of operations to compute entry: 3
          A[nzc16[j]*8 + nzc12[k]] += FE0_C0[ip][j]*FE0_C0[ip][k]*I[13];
          // Number of operations to compute entry: 3
          A[nzc16[j]*8 + nzc16[k]] += FE0_C0[ip][j]*FE0_C0[ip][k]*I[12];
        } // end loop over 'k'
      } // end loop over 'j'
    } // end loop over 'ip'
}

/// Constructor
cahnhilliard3d_form_0::cahnhilliard3d_form_0() : ufc::form()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_form_0::~cahnhilliard3d_form_0()
{
    // Do nothing
}

/// Return a string identifying the form
const char* cahnhilliard3d_form_0::signature() const
{
    return "c99bedacdb89140447f6fb11076a88d1797617ab5810fff80ddb310b3ac96061d8a283875a26f46c3a1e78fbc73b7fd7465ea8b422408f23dde89fca771a3943";
}

/// Return original coefficient position for each coefficient (0 <= i < n)
std::size_t cahnhilliard3d_form_0::original_coefficient_position(std::size_t i) const
{
    static const std::vector<std::size_t> position({0, 1, 2, 3, 4});
    return position[i];
}

/// Return the rank of the global tensor (r)
std::size_t cahnhilliard3d_form_0::rank() const
{
    return 1;
}

/// Return the number of coefficients (n)
std::size_t cahnhilliard3d_form_0::num_coefficients() const
{
    return 5;
}

/// Return the number of cell domains
std::size_t cahnhilliard3d_form_0::num_cell_domains() const
{
    return 0;
}

/// Return the number of exterior facet domains
std::size_t cahnhilliard3d_form_0::num_exterior_facet_domains() const
{
    return 0;
}

/// Return the number of interior facet domains
std::size_t cahnhilliard3d_form_0::num_interior_facet_domains() const
{
    return 0;
}

/// Return the number of point domains
std::size_t cahnhilliard3d_form_0::num_point_domains() const
{
    return 0;
}

/// Return the number of custom domains
std::size_t cahnhilliard3d_form_0::num_custom_domains() const
{
    return 0;
}

/// Return whether the form has any cell integrals
bool cahnhilliard3d_form_0::has_cell_integrals() const
{
    return true;
}

/// Return whether the form has any exterior facet integrals
bool cahnhilliard3d_form_0::has_exterior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any interior facet integrals
bool cahnhilliard3d_form_0::has_interior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any point integrals
bool cahnhilliard3d_form_0::has_point_integrals() const
{
    return false;
}

/// Return whether the form has any custom integrals
bool cahnhilliard3d_form_0::has_custom_integrals() const
{
    return false;
}

/// Create a new finite element for argument function i
ufc::finite_element* cahnhilliard3d_form_0::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    case 4:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    case 5:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new dofmap for argument function i
ufc::dofmap* cahnhilliard3d_form_0::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    case 4:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    case 5:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new cell integral on sub domain i
ufc::cell_integral* cahnhilliard3d_form_0::create_cell_integral(std::size_t i) const
{
    return 0;
}

/// Create a new exterior facet integral on sub domain i
ufc::exterior_facet_integral* cahnhilliard3d_form_0::create_exterior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new interior facet integral on sub domain i
ufc::interior_facet_integral* cahnhilliard3d_form_0::create_interior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new point integral on sub domain i
ufc::point_integral* cahnhilliard3d_form_0::create_point_integral(std::size_t i) const
{
    return 0;
}

/// Create a new custom integral on sub domain i
ufc::custom_integral* cahnhilliard3d_form_0::create_custom_integral(std::size_t i) const
{
    return 0;
}

/// Create a new cell integral on everywhere else
ufc::cell_integral* cahnhilliard3d_form_0::create_default_cell_integral() const
{
    return new cahnhilliard3d_cell_integral_0_otherwise();
}

/// Create a new exterior facet integral on everywhere else
ufc::exterior_facet_integral* cahnhilliard3d_form_0::create_default_exterior_facet_integral() const
{
    return 0;
}

/// Create a new interior facet integral on everywhere else
ufc::interior_facet_integral* cahnhilliard3d_form_0::create_default_interior_facet_integral() const
{
    return 0;
}

/// Create a new point integral on everywhere else
ufc::point_integral* cahnhilliard3d_form_0::create_default_point_integral() const
{
    return 0;
}

/// Create a new custom integral on everywhere else
ufc::custom_integral* cahnhilliard3d_form_0::create_default_custom_integral() const
{
    return 0;
}


/// Constructor
cahnhilliard3d_form_1::cahnhilliard3d_form_1() : ufc::form()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_form_1::~cahnhilliard3d_form_1()
{
    // Do nothing
}

/// Return a string identifying the form
const char* cahnhilliard3d_form_1::signature() const
{
    return "6ba86e6f9cc2b13cff9b029731e43789c7876b31ca945d316589dfb985a4f52baefe5317f9eb1e527c009fdb4c6fc40a9f702df3ce723ef8e2d39d57a8a5f8a5";
}

/// Return original coefficient position for each coefficient (0 <= i < n)
std::size_t cahnhilliard3d_form_1::original_coefficient_position(std::size_t i) const
{
    static const std::vector<std::size_t> position({0, 2, 3, 4});
    return position[i];
}

/// Return the rank of the global tensor (r)
std::size_t cahnhilliard3d_form_1::rank() const
{
    return 2;
}

/// Return the number of coefficients (n)
std::size_t cahnhilliard3d_form_1::num_coefficients() const
{
    return 4;
}

/// Return the number of cell domains
std::size_t cahnhilliard3d_form_1::num_cell_domains() const
{
    return 0;
}

/// Return the number of exterior facet domains
std::size_t cahnhilliard3d_form_1::num_exterior_facet_domains() const
{
    return 0;
}

/// Return the number of interior facet domains
std::size_t cahnhilliard3d_form_1::num_interior_facet_domains() const
{
    return 0;
}

/// Return the number of point domains
std::size_t cahnhilliard3d_form_1::num_point_domains() const
{
    return 0;
}

/// Return the number of custom domains
std::size_t cahnhilliard3d_form_1::num_custom_domains() const
{
    return 0;
}

/// Return whether the form has any cell integrals
bool cahnhilliard3d_form_1::has_cell_integrals() const
{
    return true;
}

/// Return whether the form has any exterior facet integrals
bool cahnhilliard3d_form_1::has_exterior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any interior facet integrals
bool cahnhilliard3d_form_1::has_interior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any point integrals
bool cahnhilliard3d_form_1::has_point_integrals() const
{
    return false;
}

/// Return whether the form has any custom integrals
bool cahnhilliard3d_form_1::has_custom_integrals() const
{
    return false;
}

/// Create a new finite element for argument function i
ufc::finite_element* cahnhilliard3d_form_1::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    case 4:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    case 5:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new dofmap for argument function i
ufc::dofmap* cahnhilliard3d_form_1::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    case 4:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    case 5:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new cell integral on sub domain i
ufc::cell_integral* cahnhilliard3d_form_1::create_cell_integral(std::size_t i) const
{
    return 0;
}

/// Create a new exterior facet integral on sub domain i
ufc::exterior_facet_integral* cahnhilliard3d_form_1::create_exterior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new interior facet integral on sub domain i
ufc::interior_facet_integral* cahnhilliard3d_form_1::create_interior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new point integral on sub domain i
ufc::point_integral* cahnhilliard3d_form_1::create_point_integral(std::size_t i) const
{
    return 0;
}

/// Create a new custom integral on sub domain i
ufc::custom_integral* cahnhilliard3d_form_1::create_custom_integral(std::size_t i) const
{
    return 0;
}

/// Create a new cell integral on everywhere else
ufc::cell_integral* cahnhilliard3d_form_1::create_default_cell_integral() const
{
    return new cahnhilliard3d_cell_integral_1_otherwise();
}

/// Create a new exterior facet integral on everywhere else
ufc::exterior_facet_integral* cahnhilliard3d_form_1::create_default_exterior_facet_integral() const
{
    return 0;
}

/// Create a new interior facet integral on everywhere else
ufc::interior_facet_integral* cahnhilliard3d_form_1::create_default_interior_facet_integral() const
{
    return 0;
}

/// Create a new point integral on everywhere else
ufc::point_integral* cahnhilliard3d_form_1::create_default_point_integral() const
{
    return 0;
}

/// Create a new custom integral on everywhere else
ufc::custom_integral* cahnhilliard3d_form_1::create_default_custom_integral() const
{
    return 0;
}


