// This code conforms with the UFC specification version 1.5.0
// and was automatically generated by FFC version 1.5.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   restrict_keyword:               ''
//   split:                          True

#include "Poisson3D_2.h"

/// Constructor
poisson3d_2_finite_element_0::poisson3d_2_finite_element_0() : ufc::finite_element()
{
    // Do nothing
}

/// Destructor
poisson3d_2_finite_element_0::~poisson3d_2_finite_element_0()
{
    // Do nothing
}

/// Return a string identifying the finite element
const char* poisson3d_2_finite_element_0::signature() const
{
    return "FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3)), 2, None)";
}

/// Return the cell shape
ufc::shape poisson3d_2_finite_element_0::cell_shape() const
{
    return ufc::tetrahedron;
}

/// Return the topological dimension of the cell shape
std::size_t poisson3d_2_finite_element_0::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the cell shape
std::size_t poisson3d_2_finite_element_0::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the finite element function space
std::size_t poisson3d_2_finite_element_0::space_dimension() const
{
    return 10;
}

/// Return the rank of the value space
std::size_t poisson3d_2_finite_element_0::value_rank() const
{
    return 0;
}

/// Return the dimension of the value space for axis i
std::size_t poisson3d_2_finite_element_0::value_dimension(std::size_t i) const
{
    return 1;
}

/// Evaluate basis function i at given point x in cell
void poisson3d_2_finite_element_0::_evaluate_basis(std::size_t i,
                                    double* values,
                                    const double* x,
                                    const double* vertex_coordinates,
                                    int cell_orientation)
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.0577350269189626, -0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, 0.050395263067897, 0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.0577350269189625, 0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, -0.050395263067897, -0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0702728368926306, -0.0248451997499977, 0.0, 0.0, 0.0, 0.0872871560943969, -0.0475131096733199, 0.0167984210226323};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0, 0.074535599249993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.100790526135794};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, 0.140545673785261, 0.0993807989999906, 0.0, 0.0, 0.0, 0.0, 0.1187827741833, -0.0671936840905293};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, -0.0702728368926307, 0.0993807989999907, 0.0, 0.0, 0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, 0.0702728368926307, -0.0993807989999906, 0.0, 0.100790526135794, -0.0205737799949456, -0.087287156094397, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, -0.0702728368926306, 0.0993807989999906, 0.0, 0.0, -0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, 0.0702728368926306, -0.0993807989999906, 0.0, -0.100790526135794, 0.0205737799949456, -0.0872871560943969, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, -0.140545673785261, -0.0993807989999906, -0.130120009726471, 0.0, 0.0, 0.0290957186981323, 0.02375655483666, 0.0167984210226323};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
}

/// Evaluate all basis functions at given point x in cell
void poisson3d_2_finite_element_0::_evaluate_basis_all(double* values,
                                        const double* x,
                                        const double* vertex_coordinates,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 10; r++)
    {
      _evaluate_basis(r, &dof_values, x, vertex_coordinates, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
}

/// Evaluate order n derivatives of basis function i at given point x in cell
void poisson3d_2_finite_element_0::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double* values,
                                                const double* x,
                                                const double* vertex_coordinates,
                                                int cell_orientation)
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 2)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[9][2];
    for (unsigned int row = 0; row < 9; row++)
    {
      for (unsigned int col = 0; col < 2; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[9][9];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.0577350269189626, -0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, 0.050395263067897, 0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.591607978309969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.0577350269189625, 0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, -0.050395263067897, -0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.591607978309969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0702728368926306, -0.0248451997499977, 0.0, 0.0, 0.0, 0.0872871560943969, -0.0475131096733199, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.591607978309969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0, 0.074535599249993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.100790526135794};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.591607978309969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, 0.140545673785261, 0.0993807989999906, 0.0, 0.0, 0.0, 0.0, 0.1187827741833, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.591607978309969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, -0.0702728368926307, 0.0993807989999907, 0.0, 0.0, 0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.591607978309969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, 0.0702728368926307, -0.0993807989999906, 0.0, 0.100790526135794, -0.0205737799949456, -0.087287156094397, -0.01187827741833, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.591607978309969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, -0.0702728368926306, 0.0993807989999906, 0.0, 0.0, -0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.591607978309969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, 0.0702728368926306, -0.0993807989999906, 0.0, -0.100790526135794, 0.0205737799949456, -0.0872871560943969, -0.01187827741833, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.591607978309969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, -0.140545673785261, -0.0993807989999906, -0.130120009726471, 0.0, 0.0, 0.0290957186981323, 0.02375655483666, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.591607978309969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
}

/// Evaluate order n derivatives of all basis functions at given point x in cell
void poisson3d_2_finite_element_0::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double* values,
                                                    const double* x,
                                                    const double* vertex_coordinates,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 10; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 2)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[9];
    for (unsigned int r = 0; r < 9; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

/// Evaluate linear functional for dof i on the function f
double poisson3d_2_finite_element_0::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double* vertex_coordinates,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
}

/// Evaluate linear functionals for all dofs on the function f
void poisson3d_2_finite_element_0::evaluate_dofs(double* values,
                                  const ufc::function& f,
                                  const double* vertex_coordinates,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
}

/// Interpolate vertex values from dof values
void poisson3d_2_finite_element_0::interpolate_vertex_values(double* vertex_values,
                                              const double* dof_values,
                                              const double* vertex_coordinates,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
}

/// Map coordinate xhat from reference cell to coordinate x in cell
void poisson3d_2_finite_element_0::map_from_reference_cell(double* x,
                                            const double* xhat,
                                            const ufc::cell& c) const
{
    throw std::runtime_error("map_from_reference_cell not yet implemented.");
}

/// Map from coordinate x in cell to coordinate xhat in reference cell
void poisson3d_2_finite_element_0::map_to_reference_cell(double* xhat,
                                          const double* x,
                                          const ufc::cell& c) const
{
    throw std::runtime_error("map_to_reference_cell not yet implemented.");
}

/// Return the number of sub elements (for a mixed element)
std::size_t poisson3d_2_finite_element_0::num_sub_elements() const
{
    return 0;
}

/// Create a new finite element for sub element i (for a mixed element)
ufc::finite_element* poisson3d_2_finite_element_0::create_sub_element(std::size_t i) const
{
    return 0;
}

/// Create a new class instance
ufc::finite_element* poisson3d_2_finite_element_0::create() const
{
    return new poisson3d_2_finite_element_0();
}

/// Constructor
poisson3d_2_dofmap_0::poisson3d_2_dofmap_0() : ufc::dofmap()
{
    // Do nothing
}

/// Destructor
poisson3d_2_dofmap_0::~poisson3d_2_dofmap_0()
{
    // Do nothing
}

/// Return a string identifying the dofmap
const char* poisson3d_2_dofmap_0::signature() const
{
    return "FFC dofmap for FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3)), 2, None)";
}

/// Return true iff mesh entities of topological dimension d are needed
bool poisson3d_2_dofmap_0::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
}

/// Return the topological dimension of the associated cell shape
std::size_t poisson3d_2_dofmap_0::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the associated cell shape
std::size_t poisson3d_2_dofmap_0::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the global finite element function space
std::size_t poisson3d_2_dofmap_0::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return num_global_entities[0] + num_global_entities[1];
}

/// Return the dimension of the local finite element function space for a cell
std::size_t poisson3d_2_dofmap_0::local_dimension() const
{
    return 10;
}

/// Return the number of dofs on each cell facet
std::size_t poisson3d_2_dofmap_0::num_facet_dofs() const
{
    return 6;
}

/// Return the number of dofs associated with each cell entity of dimension d
std::size_t poisson3d_2_dofmap_0::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
}

/// Tabulate the local-to-global mapping of dofs on a cell
void poisson3d_2_dofmap_0::tabulate_dofs(std::size_t* dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const ufc::cell& c) const
{
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[4] = offset + c.entity_indices[1][0];
    dofs[5] = offset + c.entity_indices[1][1];
    dofs[6] = offset + c.entity_indices[1][2];
    dofs[7] = offset + c.entity_indices[1][3];
    dofs[8] = offset + c.entity_indices[1][4];
    dofs[9] = offset + c.entity_indices[1][5];
    offset += num_global_entities[1];
}

/// Tabulate the local-to-local mapping from facet dofs to cell dofs
void poisson3d_2_dofmap_0::tabulate_facet_dofs(std::size_t* dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 7;
      dofs[5] = 8;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 7;
      dofs[5] = 9;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 6;
      dofs[4] = 8;
      dofs[5] = 9;
        break;
      }
    }
    
}

/// Tabulate the local-to-local mapping of dofs on entity (d, i)
void poisson3d_2_dofmap_0::tabulate_entity_dofs(std::size_t* dofs,
                                  std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      throw std::runtime_error("i is larger than number of entities (5)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 6;
          break;
        }
      case 3:
        {
          dofs[0] = 7;
          break;
        }
      case 4:
        {
          dofs[0] = 8;
          break;
        }
      case 5:
        {
          dofs[0] = 9;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
}

/// Tabulate the coordinates of all dofs on a cell
void poisson3d_2_dofmap_0::tabulate_coordinates(double* dof_coordinates,
                                         const double* vertex_coordinates) const
{
    dof_coordinates[0] = vertex_coordinates[0];
    dof_coordinates[1] = vertex_coordinates[1];
    dof_coordinates[2] = vertex_coordinates[2];
    dof_coordinates[3] = vertex_coordinates[3];
    dof_coordinates[4] = vertex_coordinates[4];
    dof_coordinates[5] = vertex_coordinates[5];
    dof_coordinates[6] = vertex_coordinates[6];
    dof_coordinates[7] = vertex_coordinates[7];
    dof_coordinates[8] = vertex_coordinates[8];
    dof_coordinates[9] = vertex_coordinates[9];
    dof_coordinates[10] = vertex_coordinates[10];
    dof_coordinates[11] = vertex_coordinates[11];
    dof_coordinates[12] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    dof_coordinates[13] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    dof_coordinates[14] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    dof_coordinates[15] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    dof_coordinates[16] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    dof_coordinates[17] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    dof_coordinates[18] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    dof_coordinates[19] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    dof_coordinates[20] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    dof_coordinates[21] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
    dof_coordinates[22] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
    dof_coordinates[23] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
    dof_coordinates[24] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    dof_coordinates[25] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    dof_coordinates[26] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    dof_coordinates[27] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    dof_coordinates[28] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    dof_coordinates[29] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
}

/// Return the number of sub dofmaps (for a mixed element)
std::size_t poisson3d_2_dofmap_0::num_sub_dofmaps() const
{
    return 0;
}

/// Create a new dofmap for sub dofmap i (for a mixed element)
ufc::dofmap* poisson3d_2_dofmap_0::create_sub_dofmap(std::size_t i) const
{
    return 0;
}

/// Create a new class instance
ufc::dofmap* poisson3d_2_dofmap_0::create() const
{
    return new poisson3d_2_dofmap_0();
}

/// Constructor
poisson3d_2_cell_integral_0_otherwise::poisson3d_2_cell_integral_0_otherwise() : ufc::cell_integral()
{
    // Do nothing
}

/// Destructor
poisson3d_2_cell_integral_0_otherwise::~poisson3d_2_cell_integral_0_otherwise()
{
    // Do nothing
}

/// Tabulate which form coefficients are used by this integral
const std::vector<bool> & poisson3d_2_cell_integral_0_otherwise::enabled_coefficients() const
{
    static const std::vector<bool> enabled({});
    return enabled;
}

/// Tabulate the tensor for the contribution from a local cell
void poisson3d_2_cell_integral_0_otherwise::tabulate_tensor(double*  A,
                                    const double * const *  w,
                                    const double*  vertex_coordinates,
                                    int cell_orientation) const
{
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    27
    // Number of operations (multiply-add pairs) for tensor contraction: 331
    // Total number of operations (multiply-add pairs):                  361
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]);
    const double G0_0_1 = det*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]);
    const double G0_0_2 = det*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]);
    const double G0_1_0 = det*(K[3]*K[0] + K[4]*K[1] + K[5]*K[2]);
    const double G0_1_1 = det*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]);
    const double G0_1_2 = det*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]);
    const double G0_2_0 = det*(K[6]*K[0] + K[7]*K[1] + K[8]*K[2]);
    const double G0_2_1 = det*(K[6]*K[3] + K[7]*K[4] + K[8]*K[5]);
    const double G0_2_2 = det*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]);
    
    // Compute element tensor
    A[0] = 0.1*G0_0_0 + 0.1*G0_0_1 + 0.1*G0_0_2 + 0.1*G0_1_0 + 0.1*G0_1_1 + 0.1*G0_1_2 + 0.1*G0_2_0 + 0.1*G0_2_1 + 0.1*G0_2_2;
    A[1] = 0.0333333333333333*G0_0_0 + 0.0333333333333333*G0_1_0 + 0.0333333333333333*G0_2_0;
    A[2] = 0.0333333333333334*G0_0_1 + 0.0333333333333334*G0_1_1 + 0.0333333333333334*G0_2_1;
    A[3] = 0.0333333333333334*G0_0_2 + 0.0333333333333334*G0_1_2 + 0.0333333333333334*G0_2_2;
    A[4] = 0.0333333333333345*G0_0_1 + 0.0333333333333344*G0_0_2 + 0.0333333333333346*G0_1_1 + 0.0333333333333345*G0_1_2 + 0.0333333333333344*G0_2_1 + 0.0333333333333344*G0_2_2;
    A[5] = 0.0333333333333345*G0_0_0 + 0.0333333333333345*G0_0_2 + 0.0333333333333345*G0_1_0 + 0.0333333333333346*G0_1_2 + 0.0333333333333344*G0_2_0 + 0.0333333333333345*G0_2_2;
    A[6] = 0.0333333333333345*G0_0_0 + 0.0333333333333344*G0_0_1 + 0.0333333333333345*G0_1_0 + 0.0333333333333345*G0_1_1 + 0.0333333333333344*G0_2_0 + 0.0333333333333344*G0_2_1;
    A[7] = -0.0333333333333345*G0_0_0 - 0.0333333333333345*G0_0_1 - 0.133333333333333*G0_0_2 - 0.0333333333333345*G0_1_0 - 0.0333333333333346*G0_1_1 - 0.133333333333334*G0_1_2 - 0.0333333333333344*G0_2_0 - 0.0333333333333344*G0_2_1 - 0.133333333333334*G0_2_2;
    A[8] = -0.0333333333333345*G0_0_0 - 0.133333333333333*G0_0_1 - 0.0333333333333344*G0_0_2 - 0.0333333333333345*G0_1_0 - 0.133333333333333*G0_1_1 - 0.0333333333333345*G0_1_2 - 0.0333333333333344*G0_2_0 - 0.133333333333333*G0_2_1 - 0.0333333333333344*G0_2_2;
    A[9] = -0.133333333333333*G0_0_0 - 0.0333333333333344*G0_0_1 - 0.0333333333333345*G0_0_2 - 0.133333333333333*G0_1_0 - 0.0333333333333345*G0_1_1 - 0.0333333333333345*G0_1_2 - 0.133333333333333*G0_2_0 - 0.0333333333333344*G0_2_1 - 0.0333333333333345*G0_2_2;
    A[10] = 0.0333333333333333*G0_0_0 + 0.0333333333333333*G0_0_1 + 0.0333333333333333*G0_0_2;
    A[11] = 0.1*G0_0_0;
    A[12] = -0.0333333333333334*G0_0_1;
    A[13] = -0.0333333333333333*G0_0_2;
    A[14] = -0.0333333333333332*G0_0_1 - 0.0333333333333332*G0_0_2;
    A[15] = -0.0333333333333331*G0_0_0 + 0.1*G0_0_2;
    A[16] = -0.0333333333333332*G0_0_0 + 0.1*G0_0_1;
    A[17] = 0.0333333333333331*G0_0_0 + 0.0333333333333331*G0_0_1;
    A[18] = 0.0333333333333332*G0_0_0 + 0.0333333333333332*G0_0_2;
    A[19] = -0.133333333333333*G0_0_0 - 0.1*G0_0_1 - 0.1*G0_0_2;
    A[20] = 0.0333333333333333*G0_1_0 + 0.0333333333333334*G0_1_1 + 0.0333333333333334*G0_1_2;
    A[21] = -0.0333333333333334*G0_1_0;
    A[22] = 0.1*G0_1_1;
    A[23] = -0.0333333333333333*G0_1_2;
    A[24] = -0.0333333333333335*G0_1_1 + 0.1*G0_1_2;
    A[25] = -0.0333333333333335*G0_1_0 - 0.0333333333333336*G0_1_2;
    A[26] = 0.1*G0_1_0 - 0.0333333333333334*G0_1_1;
    A[27] = 0.0333333333333335*G0_1_0 + 0.0333333333333335*G0_1_1;
    A[28] = -0.1*G0_1_0 - 0.133333333333333*G0_1_1 - 0.1*G0_1_2;
    A[29] = 0.0333333333333335*G0_1_1 + 0.0333333333333335*G0_1_2;
    A[30] = 0.0333333333333334*G0_2_0 + 0.0333333333333334*G0_2_1 + 0.0333333333333334*G0_2_2;
    A[31] = -0.0333333333333333*G0_2_0;
    A[32] = -0.0333333333333333*G0_2_1;
    A[33] = 0.1*G0_2_2;
    A[34] = 0.1*G0_2_1 - 0.0333333333333339*G0_2_2;
    A[35] = 0.1*G0_2_0 - 0.0333333333333336*G0_2_2;
    A[36] = -0.0333333333333337*G0_2_0 - 0.0333333333333338*G0_2_1;
    A[37] = -0.1*G0_2_0 - 0.1*G0_2_1 - 0.133333333333334*G0_2_2;
    A[38] = 0.0333333333333337*G0_2_0 + 0.0333333333333338*G0_2_2;
    A[39] = 0.0333333333333337*G0_2_1 + 0.0333333333333336*G0_2_2;
    A[40] = 0.0333333333333345*G0_1_0 + 0.0333333333333346*G0_1_1 + 0.0333333333333344*G0_1_2 + 0.0333333333333344*G0_2_0 + 0.0333333333333345*G0_2_1 + 0.0333333333333344*G0_2_2;
    A[41] = -0.0333333333333332*G0_1_0 - 0.0333333333333332*G0_2_0;
    A[42] = -0.0333333333333335*G0_1_1 + 0.1*G0_2_1;
    A[43] = 0.1*G0_1_2 - 0.0333333333333339*G0_2_2;
    A[44] = 0.266666666666668*G0_1_1 + 0.133333333333334*G0_1_2 + 0.133333333333334*G0_2_1 + 0.266666666666668*G0_2_2;
    A[45] = 0.266666666666668*G0_1_0 + 0.133333333333335*G0_1_2 + 0.133333333333334*G0_2_0 + 0.133333333333335*G0_2_2;
    A[46] = 0.133333333333334*G0_1_0 + 0.133333333333335*G0_1_1 + 0.266666666666668*G0_2_0 + 0.133333333333335*G0_2_1;
    A[47] = -0.266666666666668*G0_1_0 - 0.266666666666668*G0_1_1 - 0.133333333333335*G0_1_2 - 0.133333333333334*G0_2_0 - 0.133333333333334*G0_2_1;
    A[48] = -0.133333333333334*G0_1_0 - 0.133333333333334*G0_1_2 - 0.266666666666668*G0_2_0 - 0.133333333333335*G0_2_1 - 0.266666666666668*G0_2_2;
    A[49] = -0.133333333333334*G0_1_1 - 0.133333333333334*G0_1_2 - 0.133333333333334*G0_2_1 - 0.133333333333334*G0_2_2;
    A[50] = 0.0333333333333345*G0_0_0 + 0.0333333333333345*G0_0_1 + 0.0333333333333344*G0_0_2 + 0.0333333333333345*G0_2_0 + 0.0333333333333346*G0_2_1 + 0.0333333333333345*G0_2_2;
    A[51] = -0.0333333333333331*G0_0_0 + 0.1*G0_2_0;
    A[52] = -0.0333333333333335*G0_0_1 - 0.0333333333333336*G0_2_1;
    A[53] = 0.1*G0_0_2 - 0.0333333333333336*G0_2_2;
    A[54] = 0.266666666666668*G0_0_1 + 0.133333333333334*G0_0_2 + 0.133333333333335*G0_2_1 + 0.133333333333335*G0_2_2;
    A[55] = 0.266666666666668*G0_0_0 + 0.133333333333335*G0_0_2 + 0.133333333333335*G0_2_0 + 0.26666666666667*G0_2_2;
    A[56] = 0.133333333333334*G0_0_0 + 0.133333333333335*G0_0_1 + 0.133333333333335*G0_2_0 + 0.266666666666669*G0_2_1;
    A[57] = -0.266666666666668*G0_0_0 - 0.266666666666668*G0_0_1 - 0.133333333333335*G0_0_2 - 0.133333333333335*G0_2_0 - 0.133333333333335*G0_2_1;
    A[58] = -0.133333333333334*G0_0_0 - 0.133333333333334*G0_0_2 - 0.133333333333335*G0_2_0 - 0.133333333333335*G0_2_2;
    A[59] = -0.133333333333334*G0_0_1 - 0.133333333333334*G0_0_2 - 0.133333333333335*G0_2_0 - 0.266666666666669*G0_2_1 - 0.266666666666669*G0_2_2;
    A[60] = 0.0333333333333345*G0_0_0 + 0.0333333333333345*G0_0_1 + 0.0333333333333344*G0_0_2 + 0.0333333333333344*G0_1_0 + 0.0333333333333345*G0_1_1 + 0.0333333333333344*G0_1_2;
    A[61] = -0.0333333333333332*G0_0_0 + 0.1*G0_1_0;
    A[62] = 0.1*G0_0_1 - 0.0333333333333334*G0_1_1;
    A[63] = -0.0333333333333337*G0_0_2 - 0.0333333333333338*G0_1_2;
    A[64] = 0.133333333333334*G0_0_1 + 0.266666666666668*G0_0_2 + 0.133333333333335*G0_1_1 + 0.133333333333335*G0_1_2;
    A[65] = 0.133333333333334*G0_0_0 + 0.133333333333335*G0_0_2 + 0.133333333333335*G0_1_0 + 0.266666666666669*G0_1_2;
    A[66] = 0.266666666666668*G0_0_0 + 0.133333333333335*G0_0_1 + 0.133333333333335*G0_1_0 + 0.266666666666669*G0_1_1;
    A[67] = -0.133333333333334*G0_0_0 - 0.133333333333334*G0_0_1 - 0.133333333333335*G0_1_0 - 0.133333333333335*G0_1_1;
    A[68] = -0.266666666666668*G0_0_0 - 0.133333333333335*G0_0_1 - 0.266666666666668*G0_0_2 - 0.133333333333335*G0_1_0 - 0.133333333333335*G0_1_2;
    A[69] = -0.133333333333334*G0_0_1 - 0.133333333333334*G0_0_2 - 0.133333333333335*G0_1_0 - 0.266666666666668*G0_1_1 - 0.266666666666668*G0_1_2;
    A[70] = -0.0333333333333345*G0_0_0 - 0.0333333333333345*G0_0_1 - 0.0333333333333344*G0_0_2 - 0.0333333333333345*G0_1_0 - 0.0333333333333346*G0_1_1 - 0.0333333333333344*G0_1_2 - 0.133333333333333*G0_2_0 - 0.133333333333334*G0_2_1 - 0.133333333333334*G0_2_2;
    A[71] = 0.0333333333333331*G0_0_0 + 0.0333333333333331*G0_1_0;
    A[72] = 0.0333333333333335*G0_0_1 + 0.0333333333333335*G0_1_1;
    A[73] = -0.1*G0_0_2 - 0.1*G0_1_2 - 0.133333333333334*G0_2_2;
    A[74] = -0.266666666666668*G0_0_1 - 0.133333333333334*G0_0_2 - 0.266666666666668*G0_1_1 - 0.133333333333334*G0_1_2 - 0.133333333333335*G0_2_1;
    A[75] = -0.266666666666668*G0_0_0 - 0.133333333333335*G0_0_2 - 0.266666666666668*G0_1_0 - 0.133333333333335*G0_1_2 - 0.133333333333335*G0_2_0;
    A[76] = -0.133333333333334*G0_0_0 - 0.133333333333335*G0_0_1 - 0.133333333333334*G0_1_0 - 0.133333333333335*G0_1_1;
    A[77] = 0.266666666666668*G0_0_0 + 0.266666666666668*G0_0_1 + 0.133333333333335*G0_0_2 + 0.266666666666668*G0_1_0 + 0.266666666666668*G0_1_1 + 0.133333333333335*G0_1_2 + 0.133333333333335*G0_2_0 + 0.133333333333335*G0_2_1 + 0.266666666666667*G0_2_2;
    A[78] = 0.133333333333334*G0_0_0 + 0.133333333333334*G0_0_2 + 0.133333333333334*G0_1_0 + 0.133333333333334*G0_1_2 + 0.133333333333333*G0_2_1;
    A[79] = 0.133333333333334*G0_0_1 + 0.133333333333334*G0_0_2 + 0.133333333333334*G0_1_1 + 0.133333333333334*G0_1_2 + 0.133333333333334*G0_2_0;
    A[80] = -0.0333333333333345*G0_0_0 - 0.0333333333333345*G0_0_1 - 0.0333333333333344*G0_0_2 - 0.133333333333333*G0_1_0 - 0.133333333333333*G0_1_1 - 0.133333333333333*G0_1_2 - 0.0333333333333344*G0_2_0 - 0.0333333333333345*G0_2_1 - 0.0333333333333344*G0_2_2;
    A[81] = 0.0333333333333332*G0_0_0 + 0.0333333333333332*G0_2_0;
    A[82] = -0.1*G0_0_1 - 0.133333333333333*G0_1_1 - 0.1*G0_2_1;
    A[83] = 0.0333333333333338*G0_0_2 + 0.0333333333333338*G0_2_2;
    A[84] = -0.133333333333334*G0_0_1 - 0.266666666666668*G0_0_2 - 0.133333333333335*G0_1_2 - 0.133333333333334*G0_2_1 - 0.266666666666668*G0_2_2;
    A[85] = -0.133333333333334*G0_0_0 - 0.133333333333335*G0_0_2 - 0.133333333333334*G0_2_0 - 0.133333333333335*G0_2_2;
    A[86] = -0.266666666666668*G0_0_0 - 0.133333333333335*G0_0_1 - 0.133333333333335*G0_1_0 - 0.266666666666668*G0_2_0 - 0.133333333333335*G0_2_1;
    A[87] = 0.133333333333334*G0_0_0 + 0.133333333333334*G0_0_1 + 0.133333333333333*G0_1_2 + 0.133333333333334*G0_2_0 + 0.133333333333334*G0_2_1;
    A[88] = 0.266666666666668*G0_0_0 + 0.133333333333335*G0_0_1 + 0.266666666666668*G0_0_2 + 0.133333333333335*G0_1_0 + 0.266666666666667*G0_1_1 + 0.133333333333335*G0_1_2 + 0.266666666666668*G0_2_0 + 0.133333333333335*G0_2_1 + 0.266666666666667*G0_2_2;
    A[89] = 0.133333333333334*G0_0_1 + 0.133333333333334*G0_0_2 + 0.133333333333333*G0_1_0 + 0.133333333333334*G0_2_1 + 0.133333333333334*G0_2_2;
    A[90] = -0.133333333333333*G0_0_0 - 0.133333333333333*G0_0_1 - 0.133333333333333*G0_0_2 - 0.0333333333333345*G0_1_0 - 0.0333333333333345*G0_1_1 - 0.0333333333333344*G0_1_2 - 0.0333333333333345*G0_2_0 - 0.0333333333333345*G0_2_1 - 0.0333333333333345*G0_2_2;
    A[91] = -0.133333333333333*G0_0_0 - 0.1*G0_1_0 - 0.1*G0_2_0;
    A[92] = 0.0333333333333335*G0_1_1 + 0.0333333333333335*G0_2_1;
    A[93] = 0.0333333333333337*G0_1_2 + 0.0333333333333336*G0_2_2;
    A[94] = -0.133333333333334*G0_1_1 - 0.133333333333334*G0_1_2 - 0.133333333333334*G0_2_1 - 0.133333333333334*G0_2_2;
    A[95] = -0.133333333333335*G0_0_2 - 0.133333333333334*G0_1_0 - 0.266666666666669*G0_1_2 - 0.133333333333334*G0_2_0 - 0.266666666666669*G0_2_2;
    A[96] = -0.133333333333335*G0_0_1 - 0.133333333333334*G0_1_0 - 0.266666666666668*G0_1_1 - 0.133333333333334*G0_2_0 - 0.266666666666668*G0_2_1;
    A[97] = 0.133333333333334*G0_0_2 + 0.133333333333334*G0_1_0 + 0.133333333333334*G0_1_1 + 0.133333333333334*G0_2_0 + 0.133333333333334*G0_2_1;
    A[98] = 0.133333333333333*G0_0_1 + 0.133333333333334*G0_1_0 + 0.133333333333334*G0_1_2 + 0.133333333333334*G0_2_0 + 0.133333333333334*G0_2_2;
    A[99] = 0.266666666666667*G0_0_0 + 0.133333333333335*G0_0_1 + 0.133333333333335*G0_0_2 + 0.133333333333335*G0_1_0 + 0.266666666666668*G0_1_1 + 0.266666666666667*G0_1_2 + 0.133333333333335*G0_2_0 + 0.266666666666667*G0_2_1 + 0.266666666666667*G0_2_2;
}

/// Constructor
poisson3d_2_cell_integral_1_otherwise::poisson3d_2_cell_integral_1_otherwise() : ufc::cell_integral()
{
    // Do nothing
}

/// Destructor
poisson3d_2_cell_integral_1_otherwise::~poisson3d_2_cell_integral_1_otherwise()
{
    // Do nothing
}

/// Tabulate which form coefficients are used by this integral
const std::vector<bool> & poisson3d_2_cell_integral_1_otherwise::enabled_coefficients() const
{
    static const std::vector<bool> enabled({true});
    return enabled;
}

/// Tabulate the tensor for the contribution from a local cell
void poisson3d_2_cell_integral_1_otherwise::tabulate_tensor(double*  A,
                                    const double * const *  w,
                                    const double*  vertex_coordinates,
                                    int cell_orientation) const
{
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    10
    // Number of operations (multiply-add pairs) for tensor contraction: 95
    // Total number of operations (multiply-add pairs):                  108
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    const double G0_3 = det*w[0][3]*(1.0);
    const double G0_4 = det*w[0][4]*(1.0);
    const double G0_5 = det*w[0][5]*(1.0);
    const double G0_6 = det*w[0][6]*(1.0);
    const double G0_7 = det*w[0][7]*(1.0);
    const double G0_8 = det*w[0][8]*(1.0);
    const double G0_9 = det*w[0][9]*(1.0);
    
    // Compute element tensor
    A[0] = 0.00238095238095238*G0_0 + 0.000396825396825396*G0_1 + 0.000396825396825396*G0_2 + 0.000396825396825396*G0_3 - 0.00238095238095238*G0_4 - 0.00238095238095238*G0_5 - 0.00238095238095238*G0_6 - 0.00158730158730159*G0_7 - 0.00158730158730158*G0_8 - 0.00158730158730159*G0_9;
    A[1] = 0.000396825396825396*G0_0 + 0.00238095238095238*G0_1 + 0.000396825396825395*G0_2 + 0.000396825396825396*G0_3 - 0.00238095238095238*G0_4 - 0.00158730158730158*G0_5 - 0.00158730158730158*G0_6 - 0.00238095238095238*G0_7 - 0.00238095238095238*G0_8 - 0.00158730158730158*G0_9;
    A[2] = 0.000396825396825396*G0_0 + 0.000396825396825395*G0_1 + 0.00238095238095238*G0_2 + 0.000396825396825396*G0_3 - 0.00158730158730159*G0_4 - 0.00238095238095238*G0_5 - 0.00158730158730158*G0_6 - 0.00238095238095238*G0_7 - 0.00158730158730159*G0_8 - 0.00238095238095238*G0_9;
    A[3] = 0.000396825396825396*G0_0 + 0.000396825396825396*G0_1 + 0.000396825396825396*G0_2 + 0.00238095238095238*G0_3 - 0.00158730158730159*G0_4 - 0.00158730158730159*G0_5 - 0.00238095238095238*G0_6 - 0.00158730158730159*G0_7 - 0.00238095238095238*G0_8 - 0.00238095238095238*G0_9;
    A[4] = -0.00238095238095238*G0_0 - 0.00238095238095238*G0_1 - 0.00158730158730159*G0_2 - 0.00158730158730159*G0_3 + 0.0126984126984127*G0_4 + 0.00634920634920635*G0_5 + 0.00634920634920635*G0_6 + 0.00634920634920635*G0_7 + 0.00634920634920634*G0_8 + 0.00317460317460317*G0_9;
    A[5] = -0.00238095238095238*G0_0 - 0.00158730158730158*G0_1 - 0.00238095238095238*G0_2 - 0.00158730158730159*G0_3 + 0.00634920634920635*G0_4 + 0.0126984126984127*G0_5 + 0.00634920634920635*G0_6 + 0.00634920634920635*G0_7 + 0.00317460317460317*G0_8 + 0.00634920634920635*G0_9;
    A[6] = -0.00238095238095238*G0_0 - 0.00158730158730158*G0_1 - 0.00158730158730158*G0_2 - 0.00238095238095238*G0_3 + 0.00634920634920635*G0_4 + 0.00634920634920635*G0_5 + 0.0126984126984127*G0_6 + 0.00317460317460317*G0_7 + 0.00634920634920634*G0_8 + 0.00634920634920635*G0_9;
    A[7] = -0.00158730158730159*G0_0 - 0.00238095238095238*G0_1 - 0.00238095238095238*G0_2 - 0.00158730158730159*G0_3 + 0.00634920634920635*G0_4 + 0.00634920634920635*G0_5 + 0.00317460317460317*G0_6 + 0.0126984126984127*G0_7 + 0.00634920634920635*G0_8 + 0.00634920634920635*G0_9;
    A[8] = -0.00158730158730158*G0_0 - 0.00238095238095238*G0_1 - 0.00158730158730159*G0_2 - 0.00238095238095238*G0_3 + 0.00634920634920634*G0_4 + 0.00317460317460317*G0_5 + 0.00634920634920634*G0_6 + 0.00634920634920635*G0_7 + 0.0126984126984127*G0_8 + 0.00634920634920634*G0_9;
    A[9] = -0.00158730158730159*G0_0 - 0.00158730158730158*G0_1 - 0.00238095238095238*G0_2 - 0.00238095238095238*G0_3 + 0.00317460317460317*G0_4 + 0.00634920634920635*G0_5 + 0.00634920634920635*G0_6 + 0.00634920634920635*G0_7 + 0.00634920634920634*G0_8 + 0.0126984126984127*G0_9;
}

/// Constructor
poisson3d_2_form_0::poisson3d_2_form_0() : ufc::form()
{
    // Do nothing
}

/// Destructor
poisson3d_2_form_0::~poisson3d_2_form_0()
{
    // Do nothing
}

/// Return a string identifying the form
const char* poisson3d_2_form_0::signature() const
{
    return "200b237060f8ef073f4cfcbe8b56b06af165f28cc3fda639445d1bdb621676f45eb02e550cf46078865cd670ca77b3e8d7ff5b525ef23519f48078ef68d334a8";
}

/// Return original coefficient position for each coefficient (0 <= i < n)
std::size_t poisson3d_2_form_0::original_coefficient_position(std::size_t i) const
{
    static const std::vector<std::size_t> position({});
    return position[i];
}

/// Return the rank of the global tensor (r)
std::size_t poisson3d_2_form_0::rank() const
{
    return 2;
}

/// Return the number of coefficients (n)
std::size_t poisson3d_2_form_0::num_coefficients() const
{
    return 0;
}

/// Return the number of cell domains
std::size_t poisson3d_2_form_0::num_cell_domains() const
{
    return 0;
}

/// Return the number of exterior facet domains
std::size_t poisson3d_2_form_0::num_exterior_facet_domains() const
{
    return 0;
}

/// Return the number of interior facet domains
std::size_t poisson3d_2_form_0::num_interior_facet_domains() const
{
    return 0;
}

/// Return the number of point domains
std::size_t poisson3d_2_form_0::num_point_domains() const
{
    return 0;
}

/// Return the number of custom domains
std::size_t poisson3d_2_form_0::num_custom_domains() const
{
    return 0;
}

/// Return whether the form has any cell integrals
bool poisson3d_2_form_0::has_cell_integrals() const
{
    return true;
}

/// Return whether the form has any exterior facet integrals
bool poisson3d_2_form_0::has_exterior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any interior facet integrals
bool poisson3d_2_form_0::has_interior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any point integrals
bool poisson3d_2_form_0::has_point_integrals() const
{
    return false;
}

/// Return whether the form has any custom integrals
bool poisson3d_2_form_0::has_custom_integrals() const
{
    return false;
}

/// Create a new finite element for argument function i
ufc::finite_element* poisson3d_2_form_0::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson3d_2_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson3d_2_finite_element_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new dofmap for argument function i
ufc::dofmap* poisson3d_2_form_0::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson3d_2_dofmap_0();
        break;
      }
    case 1:
      {
        return new poisson3d_2_dofmap_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new cell integral on sub domain i
ufc::cell_integral* poisson3d_2_form_0::create_cell_integral(std::size_t i) const
{
    return 0;
}

/// Create a new exterior facet integral on sub domain i
ufc::exterior_facet_integral* poisson3d_2_form_0::create_exterior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new interior facet integral on sub domain i
ufc::interior_facet_integral* poisson3d_2_form_0::create_interior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new point integral on sub domain i
ufc::point_integral* poisson3d_2_form_0::create_point_integral(std::size_t i) const
{
    return 0;
}

/// Create a new custom integral on sub domain i
ufc::custom_integral* poisson3d_2_form_0::create_custom_integral(std::size_t i) const
{
    return 0;
}

/// Create a new cell integral on everywhere else
ufc::cell_integral* poisson3d_2_form_0::create_default_cell_integral() const
{
    return new poisson3d_2_cell_integral_0_otherwise();
}

/// Create a new exterior facet integral on everywhere else
ufc::exterior_facet_integral* poisson3d_2_form_0::create_default_exterior_facet_integral() const
{
    return 0;
}

/// Create a new interior facet integral on everywhere else
ufc::interior_facet_integral* poisson3d_2_form_0::create_default_interior_facet_integral() const
{
    return 0;
}

/// Create a new point integral on everywhere else
ufc::point_integral* poisson3d_2_form_0::create_default_point_integral() const
{
    return 0;
}

/// Create a new custom integral on everywhere else
ufc::custom_integral* poisson3d_2_form_0::create_default_custom_integral() const
{
    return 0;
}


/// Constructor
poisson3d_2_form_1::poisson3d_2_form_1() : ufc::form()
{
    // Do nothing
}

/// Destructor
poisson3d_2_form_1::~poisson3d_2_form_1()
{
    // Do nothing
}

/// Return a string identifying the form
const char* poisson3d_2_form_1::signature() const
{
    return "14280f26afff16c433cf2017cc4e5a8311d176b7ed68f7c087c7e5f4c219ef81820bc16f078b41360f191473f0abb75e6353ddf46a811574bf764685e083de9a";
}

/// Return original coefficient position for each coefficient (0 <= i < n)
std::size_t poisson3d_2_form_1::original_coefficient_position(std::size_t i) const
{
    static const std::vector<std::size_t> position({0});
    return position[i];
}

/// Return the rank of the global tensor (r)
std::size_t poisson3d_2_form_1::rank() const
{
    return 1;
}

/// Return the number of coefficients (n)
std::size_t poisson3d_2_form_1::num_coefficients() const
{
    return 1;
}

/// Return the number of cell domains
std::size_t poisson3d_2_form_1::num_cell_domains() const
{
    return 0;
}

/// Return the number of exterior facet domains
std::size_t poisson3d_2_form_1::num_exterior_facet_domains() const
{
    return 0;
}

/// Return the number of interior facet domains
std::size_t poisson3d_2_form_1::num_interior_facet_domains() const
{
    return 0;
}

/// Return the number of point domains
std::size_t poisson3d_2_form_1::num_point_domains() const
{
    return 0;
}

/// Return the number of custom domains
std::size_t poisson3d_2_form_1::num_custom_domains() const
{
    return 0;
}

/// Return whether the form has any cell integrals
bool poisson3d_2_form_1::has_cell_integrals() const
{
    return true;
}

/// Return whether the form has any exterior facet integrals
bool poisson3d_2_form_1::has_exterior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any interior facet integrals
bool poisson3d_2_form_1::has_interior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any point integrals
bool poisson3d_2_form_1::has_point_integrals() const
{
    return false;
}

/// Return whether the form has any custom integrals
bool poisson3d_2_form_1::has_custom_integrals() const
{
    return false;
}

/// Create a new finite element for argument function i
ufc::finite_element* poisson3d_2_form_1::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson3d_2_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson3d_2_finite_element_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new dofmap for argument function i
ufc::dofmap* poisson3d_2_form_1::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson3d_2_dofmap_0();
        break;
      }
    case 1:
      {
        return new poisson3d_2_dofmap_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new cell integral on sub domain i
ufc::cell_integral* poisson3d_2_form_1::create_cell_integral(std::size_t i) const
{
    return 0;
}

/// Create a new exterior facet integral on sub domain i
ufc::exterior_facet_integral* poisson3d_2_form_1::create_exterior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new interior facet integral on sub domain i
ufc::interior_facet_integral* poisson3d_2_form_1::create_interior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new point integral on sub domain i
ufc::point_integral* poisson3d_2_form_1::create_point_integral(std::size_t i) const
{
    return 0;
}

/// Create a new custom integral on sub domain i
ufc::custom_integral* poisson3d_2_form_1::create_custom_integral(std::size_t i) const
{
    return 0;
}

/// Create a new cell integral on everywhere else
ufc::cell_integral* poisson3d_2_form_1::create_default_cell_integral() const
{
    return new poisson3d_2_cell_integral_1_otherwise();
}

/// Create a new exterior facet integral on everywhere else
ufc::exterior_facet_integral* poisson3d_2_form_1::create_default_exterior_facet_integral() const
{
    return 0;
}

/// Create a new interior facet integral on everywhere else
ufc::interior_facet_integral* poisson3d_2_form_1::create_default_interior_facet_integral() const
{
    return 0;
}

/// Create a new point integral on everywhere else
ufc::point_integral* poisson3d_2_form_1::create_default_point_integral() const
{
    return 0;
}

/// Create a new custom integral on everywhere else
ufc::custom_integral* poisson3d_2_form_1::create_default_custom_integral() const
{
    return 0;
}


