// This code conforms with the UFC specification version 2.1.0+
// and was automatically generated by FFC version 1.1.0+.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __POISSON3D_4_H
#define __POISSON3D_4_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class poisson3d_4_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  poisson3d_4_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_4_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 4, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 35;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.0137464349807057, -0.0144900147488139, -0.00836581391578935, -0.00591552374999941, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00671936840905292, -0.00567890279999946, -0.00491807409042211, -0.00439885919382573, -0.00380952380952381, -0.00311046316543895, -0.00253968253968254, -0.00219942959691285, -0.00179582674587059, -0.00126984126984129, 0.0136980289516341, 0.0120805260192622, 0.0108051509532101, 0.010209907964538, 0.00913201930108942, 0.00790856070259325, 0.00790856070259325, 0.0070736317340728, 0.00612594477872281, 0.00500181296677924, 0.00456600965054471, 0.00408396318581521, 0.0035368158670364, 0.00288779806280615, 0.00204198159290761};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.0137464349807055, 0.0144900147488139, -0.00836581391578939, -0.00591552374999945, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00671936840905292, -0.00567890279999946, -0.00491807409042212, 0.00439885919382572, 0.00380952380952381, 0.00311046316543896, -0.00253968253968253, -0.00219942959691286, -0.00179582674587059, -0.00126984126984127, 0.0136980289516341, -0.0120805260192622, -0.0108051509532101, 0.010209907964538, 0.00913201930108942, 0.00790856070259326, -0.00790856070259325, -0.0070736317340728, -0.00612594477872282, -0.00500181296677924, 0.00456600965054471, 0.00408396318581521, 0.0035368158670364, 0.00288779806280615, 0.00204198159290761};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.0137464349807054, 0.0, 0.0167316278315787, -0.00591552374999946, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0101587301587302, -0.00659828879073858, 0.00359165349174118, -0.00126984126984126, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0228300482527235, -0.0163358527432608, 0.0106104476011092, -0.00577559612561231, 0.00204198159290761};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.0137464349807055, 0.0, 0.0, 0.0177465712499983, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0126984126984127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0306297238936141};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382572, 0.0, 0.0267706045305259, 0.0189296759999982, 0.0, 0.0, 0.0, 0.0581914373962646, -0.0316754064488799, 0.0111989473484216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0406349206349206, 0.00439885919382571, -0.0143666139669648, 0.00761904761904763, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0367556686723369, -0.0424417904044368, 0.0303218796594646, -0.0122518895574456};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.0329914439536929, 0.0, -0.0200779533978945, -0.0141972569999987, 0.0, 0.0, 0.0, -0.00969857289937745, 0.0712696645099798, -0.050395263067897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.04618802153517, 0.0107749604752236, -0.0190476190476191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0495154221385096, -0.0606437593189292, 0.0306297238936141};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382573, 0.0, 0.026770604530526, 0.0189296759999982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0671936840905293, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0359165349174119, 0.0253968253968254, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0505364660991076, -0.0408396318581521};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382572, 0.0231840235981022, -0.0133853022652629, 0.0189296759999983, 0.0433733365754904, -0.0335968420452646, -0.0274317066599275, 0.0193971457987549, 0.01583770322444, 0.0111989473484215, 0.0268774736362117, -0.0227156111999979, 0.00327871606028142, 0.0175954367753029, -0.00253968253968256, -0.0124418526617558, -0.0101587301587302, 0.00146628639794191, 0.00718330698348239, 0.00761904761904762, 0.0, 0.0, 0.0243115896447228, 0.0, -0.0205470434274512, -0.031634242810373, 0.0, 0.0159156714016638, 0.0245037791148913, 0.026259518075591, 0.0, -0.00918891716808422, -0.0141472634681456, -0.0151609398297323, -0.0122518895574456};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.032991443953693, -0.0173880176985767, 0.0100389766989472, -0.0141972569999986, -0.00722888942924837, 0.00559947367421079, 0.0617213399848368, -0.0032328576331258, -0.0356348322549899, -0.0503952630678969, 0.0, 0.0, 0.0344265186329548, 0.0, -0.0266666666666667, 0.00933138949631687, 0.0, 0.01539600717839, -0.00538748023761179, -0.0190476190476191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0369066166121018, 0.0, 0.0, -0.0285877423007065, -0.052519036151182, 0.0, 0.0, 0.0165051407128365, 0.0303218796594646, 0.0306297238936141};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382573, 0.0231840235981023, -0.013385302265263, 0.0189296759999982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0671936840905293, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0311046316543896, 0.0, 0.0, -0.017958267458706, 0.0253968253968254, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0437658634593183, 0.0, 0.0, 0.0, -0.0252682330495538, -0.0408396318581521};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382572, 0.0231840235981023, 0.013385302265263, -0.0189296759999983, 0.0433733365754904, -0.0335968420452646, -0.0274317066599275, 0.0193971457987549, 0.01583770322444, 0.0111989473484216, 0.0268774736362117, 0.0, -0.0229510124219699, -0.0117302911835353, 0.00761904761904762, 0.0165891368823411, 0.0101587301587302, -0.00146628639794191, -0.0071833069834824, -0.00761904761904762, 0.0, 0.0241610520385245, -0.00270128773830253, -0.0357346778758831, -0.0114150241263618, 0.00395428035129662, 0.0355885231616696, 0.0159156714016638, 0.00306297238936141, -0.00375135972508442, -0.0228300482527235, -0.0112308987609918, -0.00353681586703639, 0.000721949515701544, 0.00204198159290761};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.032991443953693, -0.0173880176985768, -0.0100389766989472, 0.0141972569999986, -0.00722888942924841, 0.0615942104163185, -0.00685792666498186, -0.0614242950293905, -0.00395942580610997, 0.00559947367421077, 0.0, 0.0340734167999968, -0.00491807409042212, 0.0, -0.0266666666666667, 0.00933138949631687, -0.0152380952380953, 0.0175954367753029, 0.00538748023761179, -0.0076190476190476, 0.0, 0.0, 0.0, 0.0357346778758831, -0.00913201930108942, 0.00131809345043221, -0.0593142052694494, 0.0, 0.00714693557517662, -0.00250090648338962, 0.0456600965054471, 0.0040839631858152, -0.00471575448938187, -0.00144389903140308, 0.0020419815929076};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382572, 0.0231840235981022, 0.0133853022652629, -0.0189296759999982, 0.0, 0.0, 0.0, 0.0581914373962647, -0.03167540644888, 0.0111989473484215, 0.0, 0.0, 0.0, 0.0293257279588381, -0.0101587301587302, 0.00207364211029263, 0.0101587301587302, -0.0219942959691286, 0.017958267458706, -0.00761904761904763, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0395428035129662, -0.017684079335182, 0.00612594477872281, -0.0012504532416948, -0.0456600965054471, 0.0142938711503532, 0.0, -0.00360974757850769, 0.00204198159290761};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382571, -0.0231840235981022, -0.013385302265263, 0.0189296759999982, 0.0433733365754904, 0.0335968420452646, 0.0274317066599275, 0.0193971457987549, 0.01583770322444, 0.0111989473484216, -0.0268774736362117, -0.0227156111999978, 0.00327871606028142, -0.0175954367753029, 0.00253968253968254, 0.0124418526617558, -0.0101587301587302, 0.00146628639794191, 0.00718330698348238, 0.00761904761904764, 0.0, 0.0, -0.0243115896447228, 0.0, -0.0205470434274512, -0.031634242810373, 0.0, -0.0159156714016638, -0.0245037791148913, -0.026259518075591, 0.0, -0.00918891716808422, -0.0141472634681456, -0.0151609398297323, -0.0122518895574457};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.0329914439536931, 0.0173880176985767, 0.0100389766989473, -0.0141972569999987, -0.00722888942924837, -0.00559947367421079, -0.0617213399848368, -0.00323285763312578, -0.0356348322549899, -0.050395263067897, 0.0, 0.0, 0.0344265186329548, 0.0, 0.0266666666666667, -0.00933138949631689, 0.0, 0.01539600717839, -0.00538748023761179, -0.0190476190476191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0369066166121018, 0.0, 0.0, 0.0285877423007065, 0.052519036151182, 0.0, 0.0, 0.0165051407128365, 0.0303218796594646, 0.0306297238936141};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382571, -0.0231840235981022, -0.013385302265263, 0.0189296759999982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0671936840905293, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0311046316543896, 0.0, 0.0, -0.017958267458706, 0.0253968253968254, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0437658634593183, 0.0, 0.0, 0.0, -0.0252682330495538, -0.0408396318581521};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382568, -0.0231840235981023, 0.013385302265263, -0.0189296759999982, 0.0433733365754904, 0.0335968420452647, 0.0274317066599274, 0.0193971457987549, 0.01583770322444, 0.0111989473484216, -0.0268774736362117, 0.0, -0.0229510124219699, 0.0117302911835353, -0.00761904761904761, -0.0165891368823411, 0.0101587301587302, -0.0014662863979419, -0.0071833069834824, -0.00761904761904761, 0.0, -0.0241610520385245, 0.00270128773830254, -0.0357346778758831, -0.0114150241263618, 0.00395428035129663, -0.0355885231616696, -0.0159156714016638, -0.00306297238936141, 0.00375135972508442, -0.0228300482527235, -0.0112308987609918, -0.00353681586703639, 0.000721949515701538, 0.0020419815929076};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.0329914439536931, 0.0173880176985767, -0.0100389766989472, 0.0141972569999986, -0.00722888942924842, -0.0615942104163186, 0.0068579266649819, -0.0614242950293904, -0.00395942580610998, 0.00559947367421075, 0.0, 0.0340734167999968, -0.00491807409042211, 0.0, 0.0266666666666667, -0.00933138949631689, -0.0152380952380953, 0.0175954367753029, 0.00538748023761179, -0.0076190476190476, 0.0, 0.0, 0.0, 0.0357346778758831, -0.00913201930108942, 0.00131809345043221, 0.0593142052694494, 0.0, -0.00714693557517663, 0.00250090648338962, 0.0456600965054471, 0.0040839631858152, -0.00471575448938187, -0.00144389903140307, 0.00204198159290761};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382573, -0.0231840235981023, 0.0133853022652629, -0.0189296759999982, 0.0, 0.0, 0.0, 0.0581914373962647, -0.0316754064488799, 0.0111989473484216, 0.0, 0.0, 0.0, -0.0293257279588381, 0.0101587301587302, -0.00207364211029264, 0.0101587301587302, -0.0219942959691286, 0.017958267458706, -0.00761904761904763, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0395428035129663, 0.017684079335182, -0.00612594477872281, 0.00125045324169482, -0.0456600965054471, 0.0142938711503532, 0.0, -0.00360974757850769, 0.0020419815929076};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382574, 0.0, -0.0267706045305259, -0.0189296759999982, 0.0433733365754904, 0.0335968420452646, 0.0274317066599274, 0.0193971457987549, 0.01583770322444, 0.0111989473484216, 0.0134387368181058, -0.0113578055999989, -0.00983614818084424, -0.0205280095711867, -0.0177777777777778, -0.0145154947720485, -0.0152380952380952, -0.0131965775814772, -0.0107749604752236, -0.00761904761904762, -0.0547921158065365, -0.0241610520385245, -0.0216103019064202, -0.00510495398226901, -0.00456600965054471, -0.00395428035129662, 0.00395428035129663, 0.0035368158670364, 0.0030629723893614, 0.00250090648338962, 0.00456600965054471, 0.00408396318581522, 0.0035368158670364, 0.00288779806280615, 0.0020419815929076};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 20:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.032991443953693, 0.0, 0.0200779533978945, 0.0141972569999987, -0.0867466731509807, 0.0, 0.0, 0.00969857289937748, 0.00791885161222, 0.00559947367421076, 0.0, 0.0340734167999968, 0.0295084445425327, 0.0, 0.0, 0.0, -0.0152380952380953, -0.0131965775814771, -0.0107749604752236, -0.00761904761904762, 0.0821881737098047, 0.0, 0.0, -0.010209907964538, -0.00913201930108942, -0.00790856070259324, 0.0, 0.0, 0.0, 0.0, 0.0045660096505447, 0.00408396318581518, 0.00353681586703639, 0.00288779806280616, 0.00204198159290761};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 21:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382572, 0.0, -0.026770604530526, -0.0189296759999982, 0.0433733365754904, -0.0335968420452647, -0.0274317066599274, 0.0193971457987549, 0.01583770322444, 0.0111989473484216, -0.0134387368181058, -0.0113578055999989, -0.00983614818084424, 0.0205280095711867, 0.0177777777777778, 0.0145154947720485, -0.0152380952380952, -0.0131965775814772, -0.0107749604752236, -0.00761904761904762, -0.0547921158065365, 0.0241610520385245, 0.0216103019064202, -0.00510495398226901, -0.00456600965054471, -0.00395428035129662, -0.00395428035129662, -0.0035368158670364, -0.0030629723893614, -0.00250090648338962, 0.00456600965054471, 0.00408396318581522, 0.0035368158670364, 0.00288779806280615, 0.0020419815929076};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 22:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.043988591938257, 0.139104141588614, -0.080311813591578, -0.0567890279999947, 0.0578311154339872, 0.0335968420452646, 0.0274317066599274, -0.0420271492306356, -0.0475131096733199, -0.0167984210226323, 0.0, 0.0454312223999957, 0.039344592723377, -0.0586514559176762, 0.00253968253968255, -0.0601356211984865, 0.0406349206349207, -0.0109971479845643, 0.017958267458706, 0.0393650793650794, 0.0, 0.0, 0.0, 0.0, 0.0410940868549024, -0.0105447476034577, 0.0, -0.053052238005546, -0.0245037791148913, 0.0175063453837273, 0.0, 0.0367556686723369, 0.0235787724469094, 0.0, -0.0122518895574456};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 23:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382571, 0.0, 0.160623627183156, -0.0567890279999947, 0.0, 0.0783926314389509, -0.0274317066599274, 0.00969857289937744, 0.0475131096733199, -0.0167984210226323, 0.0, 0.0, 0.0, 0.0586514559176763, 0.033015873015873, -0.0145154947720484, -0.0609523809523809, 0.0241937255660415, -0.0610581093596003, 0.0393650793650794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.053052238005546, -0.0326717054865217, 0.00875317269186366, 0.0, -0.0551335030085053, 0.0141472634681456, 0.0151609398297323, -0.0122518895574456};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 24:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382572, 0.0, 0.0, 0.170367083999984, 0.0, -0.0111989473484216, 0.0822951199797824, 0.00969857289937745, 0.0475131096733199, -0.0167984210226324, 0.0, 0.0, 0.0, 0.0, 0.0533333333333333, 0.0435464843161453, 0.0, -0.04618802153517, 0.0251415744421883, -0.0825396825396826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0571754846014129, -0.026259518075591, 0.0, 0.0, -0.0495154221385096, -0.0151609398297323, 0.0306297238936141};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 25:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382568, -0.139104141588614, -0.080311813591578, -0.0567890279999948, 0.0578311154339872, -0.0335968420452646, -0.0274317066599275, -0.0420271492306356, -0.0475131096733199, -0.0167984210226323, 0.0, 0.0454312223999957, 0.039344592723377, 0.0586514559176763, -0.00253968253968255, 0.0601356211984865, 0.0406349206349206, -0.0109971479845643, 0.017958267458706, 0.0393650793650794, 0.0, 0.0, 0.0, 0.0, 0.0410940868549024, -0.0105447476034577, 0.0, 0.053052238005546, 0.0245037791148913, -0.0175063453837273, 0.0, 0.0367556686723369, 0.0235787724469094, 0.0, -0.0122518895574456};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 26:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382569, 0.0, 0.160623627183156, -0.0567890279999947, 0.0, -0.0783926314389508, 0.0274317066599275, 0.00969857289937745, 0.0475131096733199, -0.0167984210226323, 0.0, 0.0, 0.0, -0.0586514559176763, -0.033015873015873, 0.0145154947720485, -0.060952380952381, 0.0241937255660415, -0.0610581093596003, 0.0393650793650794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.053052238005546, 0.0326717054865217, -0.00875317269186367, 0.0, -0.0551335030085054, 0.0141472634681456, 0.0151609398297323, -0.0122518895574456};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 27:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.043988591938257, 0.0, 0.0, 0.170367083999984, 0.0, 0.0111989473484216, -0.0822951199797824, 0.0096985728993774, 0.0475131096733199, -0.0167984210226323, 0.0, 0.0, 0.0, 0.0, -0.0533333333333333, -0.0435464843161453, 0.0, -0.0461880215351701, 0.0251415744421884, -0.0825396825396826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0571754846014129, 0.026259518075591, 0.0, 0.0, -0.0495154221385096, -0.0151609398297323, 0.0306297238936141};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 28:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382571, -0.139104141588614, -0.0803118135915778, -0.0567890279999946, -0.0433733365754904, 0.0447957893936862, -0.0548634133198549, 0.0484928644968872, 0.0, -0.0167984210226323, 0.0806324209086351, 0.0227156111999979, -0.00327871606028142, -0.00586514559176761, 0.0304761904761905, 0.0456201264264381, -0.0101587301587302, 0.0271262983619253, 0.0430998419008943, 0.0393650793650794, 0.0, 0.0, 0.0729347689341683, 0.0, 0.0205470434274512, 0.031634242810373, 0.0, -0.00530522380055459, -0.00816792637163041, -0.00875317269186366, 0.0, -0.0091889171680842, -0.0141472634681456, -0.0151609398297323, -0.0122518895574456};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 29:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382572, 0.139104141588614, -0.0803118135915779, -0.0567890279999947, -0.0433733365754903, -0.0447957893936862, 0.0548634133198549, 0.0484928644968873, 0.0, -0.0167984210226323, -0.0806324209086351, 0.0227156111999979, -0.00327871606028139, 0.00586514559176762, -0.0304761904761905, -0.045620126426438, -0.0101587301587302, 0.0271262983619253, 0.0430998419008943, 0.0393650793650794, 0.0, 0.0, -0.0729347689341683, 0.0, 0.0205470434274512, 0.031634242810373, 0.0, 0.00530522380055459, 0.00816792637163041, 0.00875317269186366, 0.0, -0.00918891716808424, -0.0141472634681456, -0.0151609398297323, -0.0122518895574456};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 30:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382574, 0.0, 0.0, 0.170367083999984, 0.0144577788584968, 0.0, 0.0, -0.00323285763312584, -0.0950262193466398, -0.0167984210226324, 0.0, 0.0, -0.0688530372659097, 0.0, 0.0, 0.0, 0.0, 0.01539600717839, -0.0502831488843767, -0.0825396825396825, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0738132332242037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0165051407128365, 0.0303218796594646, 0.0306297238936141};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 31:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382574, -0.139104141588614, -0.0803118135915779, -0.0567890279999946, -0.0433733365754903, -0.0447957893936862, 0.0548634133198549, -0.00969857289937742, 0.0316754064488799, 0.0391963157194754, 0.0806324209086351, 0.0, 0.0229510124219699, 0.0527863103259086, 0.0101587301587302, -0.0124418526617558, 0.0609523809523809, 0.0168622935763319, -0.00718330698348236, -0.013968253968254, 0.0, 0.0724831561155734, -0.00810386321490761, 0.0357346778758831, 0.0114150241263618, -0.00395428035129662, -0.0118628410538899, -0.00530522380055459, -0.00102099079645379, 0.00125045324169481, -0.0228300482527235, -0.0112308987609918, -0.0035368158670364, 0.000721949515701522, 0.00204198159290762};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 32:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.043988591938257, 0.139104141588614, -0.0803118135915779, -0.0567890279999947, -0.0433733365754904, 0.0447957893936862, -0.054863413319855, -0.0096985728993774, 0.0316754064488799, 0.0391963157194754, -0.0806324209086351, 0.0, 0.0229510124219699, -0.0527863103259087, -0.0101587301587302, 0.0124418526617558, 0.060952380952381, 0.0168622935763319, -0.00718330698348237, -0.013968253968254, 0.0, -0.0724831561155734, 0.00810386321490762, 0.0357346778758831, 0.0114150241263618, -0.00395428035129662, 0.0118628410538899, 0.0053052238005546, 0.0010209907964538, -0.00125045324169481, -0.0228300482527236, -0.0112308987609918, -0.0035368158670364, 0.00072194951570152, 0.00204198159290761};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 33:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382573, 0.0, 0.160623627183156, -0.0567890279999947, 0.0144577788584968, 0.0, 0.0, -0.0614242950293905, -0.0633508128977598, 0.0391963157194755, 0.0, -0.0681468335999936, 0.00983614818084426, 0.0, 0.0, 0.0, -0.0914285714285714, 0.0285925847598672, 0.0143666139669647, -0.013968253968254, 0.0, 0.0, 0.0, -0.0714693557517662, 0.0182640386021788, -0.00263618690086443, 0.0, 0.0, 0.0, 0.0, 0.0456600965054471, 0.00408396318581519, -0.00471575448938188, -0.00144389903140306, 0.00204198159290758};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 34:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.351908735506058, 0.0, 0.0, 0.0, -0.115662230867974, 0.0, 0.0, -0.129314305325033, 0.0, -0.134387368181059, 0.0, -0.0908624447999914, -0.0786891854467539, 0.0, 0.0, 0.0, 0.0406349206349207, -0.0879771838765144, 0.0, 0.0711111111111111, 0.0, 0.0, 0.0, 0.0, -0.0821881737098047, 0.0210894952069153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0367556686723369, 0.0235787724469094, 0.0, -0.0122518895574456};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 35; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 35; r++)
    {
      evaluate_basis(r, &dof_values, x, vertex_coordinates, cell_orientation);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.0137464349807057, -0.0144900147488139, -0.00836581391578935, -0.00591552374999941, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00671936840905292, -0.00567890279999946, -0.00491807409042211, -0.00439885919382573, -0.00380952380952381, -0.00311046316543895, -0.00253968253968254, -0.00219942959691285, -0.00179582674587059, -0.00126984126984129, 0.0136980289516341, 0.0120805260192622, 0.0108051509532101, 0.010209907964538, 0.00913201930108942, 0.00790856070259325, 0.00790856070259325, 0.0070736317340728, 0.00612594477872281, 0.00500181296677924, 0.00456600965054471, 0.00408396318581521, 0.0035368158670364, 0.00288779806280615, 0.00204198159290761};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0251891949326e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.00840190190275e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.11022302462516e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661992, 0.0, -1.80596278672359e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, -3.40724761118906e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34211460084998e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.74113374895575e-14, 0.0, 0.0, 0.0, 0.0, -1.03967692597581e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027551, 0.565685424949246, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556635, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.77635683940025e-14, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.03666983567529e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18118899707127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008266, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983253, -1.48131215963608, 0.261861468283195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362399, 0.0, 3.16227766016838, 4.91934955049954, 0.0, 0.0, -1.64426494173481e-14, 0.0, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09141975464799e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, -2.08408744132326e-14, 0.0, 1.14299562489344e-14, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.23340030410525e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.20651414332819e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.60576914948, 0.0, 0.0, 0.0, -4.20458932936042, -3.43303281162799, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841197, 0.529728463363979, 0.432521479156788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171168, -2.50713268211203, 4.78713553878169, 0.0, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709561, 0.0, 18.8034951158402, -0.603122387046457, 0.0, 0.0, 0.0, 1.68183573174417, 0.701283781217658, 0.132137494528683, -0.0934353184302338, 0.0, 0.0, 0.0, 0.0, 1.01657368639936e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095217, 0.0, -1.58564993434418, 4.48489528465111, 4.28174419288838, 0.0, 1.39181061118525e-14, 0.191485421551267, -3.75233260785873, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, -1.38212051998442e-14, 0.0, 0.844371341865037, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 2.04801801850478e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.59512887494071, 0.0, 0.0, 0.0, 10.0285307284481, -0.767649473578741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.096714742912332, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.92428337406971, 5.49285249860477, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08625016632142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278147, 0.0, 0.0, 0.0, 1.37682944358601e-14, 8.91928088068604, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483826, 0.0, 8.12403840463597, -1.64130361329659, 0.0, 1.94236371139386e-14, -1.2084492040842e-14, 11.7728501222092, -2.40312296813959, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741914, 0.30276503540975, -0.0611677741841197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990514, 2.93605316083774, 0.0, 0.0, 1.14892842931746e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6081867662439, -3.09487177319465, 0.68387650554024, 0.0, 0.0, 1.01609667611756e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29782505861522, 0.0, 1.49829835452878, 5.50917601898535, 0.0, 0.0, -3.31921990265919e-14, 0.0, 6.64803945320941, 4.13676892548487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.03538690111428e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 1.4986633192005e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.60576914948, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.39853957981253e-14, 0.0, 0.0, 0.0, 0.0, -1.02599765044344e-14, 1.32507554204647e-14, 1.33226762955019e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, -1.85543680054609e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 7.24568837309471, 4.18330013267038, -0.591607978309956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, -1.70362380559453e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106458, 0.0, 9.66091783079296, 0.683130051063978, 0.0, -1.11458385846514e-14, 1.90959259748689e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, -2.93971798753892e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32889602233148e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.51636339197811e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474619, -0.999999999999996, 9.16515138991168, 7.09929573971953, -0.414039335605403, -2.04939015319192, -0.478091443733749, 0.1690308509457, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974982, 2.12132034355964, -0.408248290463862, 3.17542648054295, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.79999999999999, -5.69209978830308, 4.38178046004133, -0.774596669241487, 0.0, 10.998181667894, 0.962140470884732, 4.76235235991626, -0.740656079818045, 0.130930734141592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824851, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, -1.04204372066163e-14, 0.0, 0.0, 5.1845925587263, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270662, 0.0, -3.16227766016838, -2.2360679774998, 0.0, 2.09911141082732e-14, -1.43433241843284e-14, 13.7477270848675, 0.534522483824851, 0.377964473009234, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.79999999999998, 0.0, 3.65148371670111, -2.84018778721877, 0.0, 0.0, 2.52373632039099e-14, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46002787799886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.76435655866528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.44821019466133e-14, 0.0, 0.0, 0.0},
      {2.20454076850487, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, -1.73899916117335e-14, 0.0, 0.0, 8.97997772825748, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11734754298611e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239551, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229247, -2.78313372537744, -0.524404424085079, 0.370809924354776, 11.1242977306435, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656967, 0.114434427054266, 0.840917865872084, 0.350641890608828, 0.0660687472643419, -0.0467176592151164, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912204761, 2.74642624930238, -0.792824967172091, 2.24244764232556, 2.14087209644419, -0.331662479035537, 6.49923072370879, 0.0957427107756343, -1.87616630392935, -2.15580611373101, 0.0, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932517, 0.590936840285277, 0.522319308773342, 0.0, 0.0, 1.63019078069772e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747036, 3.74574588632197, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789365, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 12.7134831207354, 1.01946290306866, 8.2065180664829, -0.63173805530579, 0.0483573714561638, -2.84282124887606, -0.227958835180084, 0.139595707137604, -0.0394836284566095, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715536, 1.16057691494799, 1.34011878852098, 1.89521416591737, 2.53311402559511, 1.96214168703485, 2.7464262493024, -0.566421515598883, 3.17129986868839, -1.82198870938951, 0.0, 0.0, 11.1699829238239, 0.0, 8.65223156827827, -0.865042958313586, 0.0, -2.49768411251821, -0.998865569685861, 0.441440386136648, 0.0, 0.0, 1.90161127277086e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.12790315683051e-14, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139074, -0.193429485824664, 3.55615782880926, 0.0, 0.0, 4.459640440343, 0.0, -0.85825820290699, 2.67027285925188, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03297925509764e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 7.03562363973515, 4.06201920231798, -0.820651806648291, 0.0, -6.79705818718656, -2.08116553882675, 5.88642506110458, -1.20156148406979, 0.242752078113811, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577677, 0.262202212042538, 5.13809303146605, -0.74161984870957, 0.151382517704875, -0.0305838870920605, 0.0, 1.01167199432803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614215, -2.69693703815182, 2.07610309995257, 1.46802658041887, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090393, -1.41130638568871, 0.0, 0.0, 0.0, 0.0, 13.4039795085887, 2.01017818278147, 0.0, 5.80409338312195, -1.54743588659732, 0.341938252770121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747035, 0.749149177264396, 2.75458800949268, 0.0, 1.12349008676759e-14, 5.75737105184052, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964687, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964686, 1.89521416591737, 0.0, 1.45082713966115e-14, 0.0, -3.39852909359329, -2.77488738510234, -0.5606119105814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.428174419288833, 0.349602949390052, 0.0706304617818625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32758182495306e-14, 0.0, 0.0, 0.0},
      {3.82970843102534, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171168, -4.07409060843207, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.7549743857359, 1.11676565710082, 0.987090711415294, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.32664991614217, -1.16809708692599e-14, 1.73008591662714, -3.18072425757423, 0.0, 1.0893489030894e-14, 0.0, 0.0, 7.67649473578741, -2.38836465270396, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 1.2485144121e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05299100428112e-14, 0.0, 1.09068140157585e-14, 0.0, 0.0, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630364, 0.0, 0.0, 0.0, 0.0, 1.47637052386759e-14, 9.57317681262153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20166278260625e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, -1.60347164931709e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 1.44913767461894, 4.18330013267038, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 7.09929573971953, 0.0, 4.34741302385684, 0.0, 0.0, -1.61480596362451e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, -1.31466507325082e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, -1.21243882593894e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474619, -0.999999999999998, 1.30930734141596, 7.09929573971953, -0.414039335605411, -2.04939015319192, -0.478091443733752, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.40824829046386, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600636, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033675, 4.38178046004133, -0.774596669241484, 0.0, 3.14233761939829, -0.106904496764966, 4.76235235991627, -0.740656079818039, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505162, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222144, 1.8516401995451, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922061358, -6.26099033699941, 0.0, 3.83405790253617, 0.0, 1.38492296223016e-14, 10.5830052442584, 0.0, 1.41526731116184e-14, 5.18459255872631, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499958, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824849, 0.0755928946018443, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 1.10729559076995e-14, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755172, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834956, 0.0, -6.26099033699941, 2.21359436211786, 0.0, 1.28098487007237e-14, 0.0, 0.0, 10.5830052442584, 2.99332590941916, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02980913200997e-14, 0.0, 0.0, 0.0},
      {5.71576766497731, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 1.73372856634452e-14, 12.6996062931101, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229245, -2.78313372537744, -0.524404424085075, 0.37080992435478, 1.23603308118261, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656969, 0.114434427054265, 0.840917865872086, 0.350641890608829, 0.0660687472643404, -0.0467176592151171, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930238, -0.79282496717209, 2.24244764232555, 2.14087209644419, -0.331662479035535, 6.49923072370878, 0.0957427107756321, -1.87616630392936, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932516, 0.590936840285278, 0.522319308773342, 0.0, 0.0, 1.15032771783196e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632197, -1.05945692672795, 0.404586796856339, 5.01426536422406, -0.383824736789359, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 2.82521847127454, -0.0509731451534319, 8.2065180664829, -0.631738055305791, 0.0483573714561628, -2.84282124887606, -0.227958835180081, 0.139595707137603, -0.0394836284566106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227874, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313572, 0.0, -2.49768411251822, -0.998865569685861, 0.441440386136646, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 1.00508909139074, -0.193429485824662, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034302, 0.0, -0.858258202906978, 2.67027285925187, 0.0, 0.0, 12.4373429638327, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190448, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 0.335029697130247, 4.06201920231798, -0.820651806648293, 0.0, 1.69926454679665, -0.0991031208965179, 5.88642506110458, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644417, 0.0124858196210744, 5.13809303146606, -0.741619848709572, 0.151382517704875, -0.0305838870920594, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614216, 0.299659670905759, 2.07610309995257, 1.46802658041887, 0.0, 0.868496237346891, 0.709124208342345, 1.31624465810882, 4.91295663090394, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102535, -0.22335313142017, 0.0, 5.80409338312195, -1.54743588659733, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 0.259512887494073, 0.749149177264395, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036809, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196468, 7.62808987244125, 0.0, 3.11415464992884, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2942239872397e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577669, 0.0, 2.68023757704196, -0.473803541479347, 0.0, 1.64767592289181e-14, -1.02022867713368e-14, 5.09779364038994, -0.792824967172095, 0.140152977645347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933263, 0.0998865569685854, -0.0176576154454661, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205055, 0.0, 1.49829835452879, 0.847565541382358, 0.0, 2.13197388895806e-14, 0.0, 1.62843044502543, 3.54562104171167, -0.814818121686423, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710081, 0.197418142283058, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071083, 0.0, 0.692034366650855, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212812, 3.07059789431496, 1.19418232635198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309061, 0.0, 7.62808987244125, 1.79795802543455, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451479, 0.0, 0.0, 1.19811444974696e-14, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29775342561708e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.0137464349807055, 0.0144900147488139, -0.00836581391578939, -0.00591552374999945, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00671936840905292, -0.00567890279999946, -0.00491807409042212, 0.00439885919382572, 0.00380952380952381, 0.00311046316543896, -0.00253968253968253, -0.00219942959691286, -0.00179582674587059, -0.00126984126984127, 0.0136980289516341, -0.0120805260192622, -0.0108051509532101, 0.010209907964538, 0.00913201930108942, 0.00790856070259326, -0.00790856070259325, -0.0070736317340728, -0.00612594477872282, -0.00500181296677924, 0.00456600965054471, 0.00408396318581521, 0.0035368158670364, 0.00288779806280615, 0.00204198159290761};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0251891949326e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.00840190190275e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.11022302462516e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661992, 0.0, -1.80596278672359e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, -3.40724761118906e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34211460084998e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.74113374895575e-14, 0.0, 0.0, 0.0, 0.0, -1.03967692597581e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027551, 0.565685424949246, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556635, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.77635683940025e-14, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.03666983567529e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18118899707127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008266, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983253, -1.48131215963608, 0.261861468283195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362399, 0.0, 3.16227766016838, 4.91934955049954, 0.0, 0.0, -1.64426494173481e-14, 0.0, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09141975464799e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, -2.08408744132326e-14, 0.0, 1.14299562489344e-14, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.23340030410525e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.20651414332819e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.60576914948, 0.0, 0.0, 0.0, -4.20458932936042, -3.43303281162799, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841197, 0.529728463363979, 0.432521479156788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171168, -2.50713268211203, 4.78713553878169, 0.0, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709561, 0.0, 18.8034951158402, -0.603122387046457, 0.0, 0.0, 0.0, 1.68183573174417, 0.701283781217658, 0.132137494528683, -0.0934353184302338, 0.0, 0.0, 0.0, 0.0, 1.01657368639936e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095217, 0.0, -1.58564993434418, 4.48489528465111, 4.28174419288838, 0.0, 1.39181061118525e-14, 0.191485421551267, -3.75233260785873, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, -1.38212051998442e-14, 0.0, 0.844371341865037, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 2.04801801850478e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.59512887494071, 0.0, 0.0, 0.0, 10.0285307284481, -0.767649473578741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.096714742912332, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.92428337406971, 5.49285249860477, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08625016632142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278147, 0.0, 0.0, 0.0, 1.37682944358601e-14, 8.91928088068604, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483826, 0.0, 8.12403840463597, -1.64130361329659, 0.0, 1.94236371139386e-14, -1.2084492040842e-14, 11.7728501222092, -2.40312296813959, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741914, 0.30276503540975, -0.0611677741841197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990514, 2.93605316083774, 0.0, 0.0, 1.14892842931746e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6081867662439, -3.09487177319465, 0.68387650554024, 0.0, 0.0, 1.01609667611756e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29782505861522, 0.0, 1.49829835452878, 5.50917601898535, 0.0, 0.0, -3.31921990265919e-14, 0.0, 6.64803945320941, 4.13676892548487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.03538690111428e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 1.4986633192005e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.60576914948, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.39853957981253e-14, 0.0, 0.0, 0.0, 0.0, -1.02599765044344e-14, 1.32507554204647e-14, 1.33226762955019e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, -1.85543680054609e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 7.24568837309471, 4.18330013267038, -0.591607978309956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, -1.70362380559453e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106458, 0.0, 9.66091783079296, 0.683130051063978, 0.0, -1.11458385846514e-14, 1.90959259748689e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, -2.93971798753892e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32889602233148e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.51636339197811e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474619, -0.999999999999996, 9.16515138991168, 7.09929573971953, -0.414039335605403, -2.04939015319192, -0.478091443733749, 0.1690308509457, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974982, 2.12132034355964, -0.408248290463862, 3.17542648054295, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.79999999999999, -5.69209978830308, 4.38178046004133, -0.774596669241487, 0.0, 10.998181667894, 0.962140470884732, 4.76235235991626, -0.740656079818045, 0.130930734141592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824851, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, -1.04204372066163e-14, 0.0, 0.0, 5.1845925587263, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270662, 0.0, -3.16227766016838, -2.2360679774998, 0.0, 2.09911141082732e-14, -1.43433241843284e-14, 13.7477270848675, 0.534522483824851, 0.377964473009234, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.79999999999998, 0.0, 3.65148371670111, -2.84018778721877, 0.0, 0.0, 2.52373632039099e-14, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46002787799886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.76435655866528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.44821019466133e-14, 0.0, 0.0, 0.0},
      {2.20454076850487, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, -1.73899916117335e-14, 0.0, 0.0, 8.97997772825748, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11734754298611e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239551, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229247, -2.78313372537744, -0.524404424085079, 0.370809924354776, 11.1242977306435, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656967, 0.114434427054266, 0.840917865872084, 0.350641890608828, 0.0660687472643419, -0.0467176592151164, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912204761, 2.74642624930238, -0.792824967172091, 2.24244764232556, 2.14087209644419, -0.331662479035537, 6.49923072370879, 0.0957427107756343, -1.87616630392935, -2.15580611373101, 0.0, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932517, 0.590936840285277, 0.522319308773342, 0.0, 0.0, 1.63019078069772e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747036, 3.74574588632197, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789365, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 12.7134831207354, 1.01946290306866, 8.2065180664829, -0.63173805530579, 0.0483573714561638, -2.84282124887606, -0.227958835180084, 0.139595707137604, -0.0394836284566095, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715536, 1.16057691494799, 1.34011878852098, 1.89521416591737, 2.53311402559511, 1.96214168703485, 2.7464262493024, -0.566421515598883, 3.17129986868839, -1.82198870938951, 0.0, 0.0, 11.1699829238239, 0.0, 8.65223156827827, -0.865042958313586, 0.0, -2.49768411251821, -0.998865569685861, 0.441440386136648, 0.0, 0.0, 1.90161127277086e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.12790315683051e-14, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139074, -0.193429485824664, 3.55615782880926, 0.0, 0.0, 4.459640440343, 0.0, -0.85825820290699, 2.67027285925188, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03297925509764e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 7.03562363973515, 4.06201920231798, -0.820651806648291, 0.0, -6.79705818718656, -2.08116553882675, 5.88642506110458, -1.20156148406979, 0.242752078113811, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577677, 0.262202212042538, 5.13809303146605, -0.74161984870957, 0.151382517704875, -0.0305838870920605, 0.0, 1.01167199432803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614215, -2.69693703815182, 2.07610309995257, 1.46802658041887, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090393, -1.41130638568871, 0.0, 0.0, 0.0, 0.0, 13.4039795085887, 2.01017818278147, 0.0, 5.80409338312195, -1.54743588659732, 0.341938252770121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747035, 0.749149177264396, 2.75458800949268, 0.0, 1.12349008676759e-14, 5.75737105184052, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964687, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964686, 1.89521416591737, 0.0, 1.45082713966115e-14, 0.0, -3.39852909359329, -2.77488738510234, -0.5606119105814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.428174419288833, 0.349602949390052, 0.0706304617818625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32758182495306e-14, 0.0, 0.0, 0.0},
      {3.82970843102534, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171168, -4.07409060843207, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.7549743857359, 1.11676565710082, 0.987090711415294, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.32664991614217, -1.16809708692599e-14, 1.73008591662714, -3.18072425757423, 0.0, 1.0893489030894e-14, 0.0, 0.0, 7.67649473578741, -2.38836465270396, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 1.2485144121e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05299100428112e-14, 0.0, 1.09068140157585e-14, 0.0, 0.0, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630364, 0.0, 0.0, 0.0, 0.0, 1.47637052386759e-14, 9.57317681262153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20166278260625e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, -1.60347164931709e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 1.44913767461894, 4.18330013267038, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 7.09929573971953, 0.0, 4.34741302385684, 0.0, 0.0, -1.61480596362451e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, -1.31466507325082e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, -1.21243882593894e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474619, -0.999999999999998, 1.30930734141596, 7.09929573971953, -0.414039335605411, -2.04939015319192, -0.478091443733752, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.40824829046386, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600636, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033675, 4.38178046004133, -0.774596669241484, 0.0, 3.14233761939829, -0.106904496764966, 4.76235235991627, -0.740656079818039, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505162, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222144, 1.8516401995451, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922061358, -6.26099033699941, 0.0, 3.83405790253617, 0.0, 1.38492296223016e-14, 10.5830052442584, 0.0, 1.41526731116184e-14, 5.18459255872631, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499958, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824849, 0.0755928946018443, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 1.10729559076995e-14, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755172, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834956, 0.0, -6.26099033699941, 2.21359436211786, 0.0, 1.28098487007237e-14, 0.0, 0.0, 10.5830052442584, 2.99332590941916, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02980913200997e-14, 0.0, 0.0, 0.0},
      {5.71576766497731, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 1.73372856634452e-14, 12.6996062931101, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229245, -2.78313372537744, -0.524404424085075, 0.37080992435478, 1.23603308118261, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656969, 0.114434427054265, 0.840917865872086, 0.350641890608829, 0.0660687472643404, -0.0467176592151171, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930238, -0.79282496717209, 2.24244764232555, 2.14087209644419, -0.331662479035535, 6.49923072370878, 0.0957427107756321, -1.87616630392936, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932516, 0.590936840285278, 0.522319308773342, 0.0, 0.0, 1.15032771783196e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632197, -1.05945692672795, 0.404586796856339, 5.01426536422406, -0.383824736789359, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 2.82521847127454, -0.0509731451534319, 8.2065180664829, -0.631738055305791, 0.0483573714561628, -2.84282124887606, -0.227958835180081, 0.139595707137603, -0.0394836284566106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227874, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313572, 0.0, -2.49768411251822, -0.998865569685861, 0.441440386136646, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 1.00508909139074, -0.193429485824662, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034302, 0.0, -0.858258202906978, 2.67027285925187, 0.0, 0.0, 12.4373429638327, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190448, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 0.335029697130247, 4.06201920231798, -0.820651806648293, 0.0, 1.69926454679665, -0.0991031208965179, 5.88642506110458, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644417, 0.0124858196210744, 5.13809303146606, -0.741619848709572, 0.151382517704875, -0.0305838870920594, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614216, 0.299659670905759, 2.07610309995257, 1.46802658041887, 0.0, 0.868496237346891, 0.709124208342345, 1.31624465810882, 4.91295663090394, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102535, -0.22335313142017, 0.0, 5.80409338312195, -1.54743588659733, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 0.259512887494073, 0.749149177264395, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036809, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196468, 7.62808987244125, 0.0, 3.11415464992884, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2942239872397e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577669, 0.0, 2.68023757704196, -0.473803541479347, 0.0, 1.64767592289181e-14, -1.02022867713368e-14, 5.09779364038994, -0.792824967172095, 0.140152977645347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933263, 0.0998865569685854, -0.0176576154454661, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205055, 0.0, 1.49829835452879, 0.847565541382358, 0.0, 2.13197388895806e-14, 0.0, 1.62843044502543, 3.54562104171167, -0.814818121686423, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710081, 0.197418142283058, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071083, 0.0, 0.692034366650855, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212812, 3.07059789431496, 1.19418232635198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309061, 0.0, 7.62808987244125, 1.79795802543455, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451479, 0.0, 0.0, 1.19811444974696e-14, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29775342561708e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.0137464349807054, 0.0, 0.0167316278315787, -0.00591552374999946, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0101587301587302, -0.00659828879073858, 0.00359165349174118, -0.00126984126984126, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0228300482527235, -0.0163358527432608, 0.0106104476011092, -0.00577559612561231, 0.00204198159290761};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0251891949326e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.00840190190275e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.11022302462516e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661992, 0.0, -1.80596278672359e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, -3.40724761118906e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34211460084998e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.74113374895575e-14, 0.0, 0.0, 0.0, 0.0, -1.03967692597581e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027551, 0.565685424949246, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556635, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.77635683940025e-14, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.03666983567529e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18118899707127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008266, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983253, -1.48131215963608, 0.261861468283195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362399, 0.0, 3.16227766016838, 4.91934955049954, 0.0, 0.0, -1.64426494173481e-14, 0.0, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09141975464799e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, -2.08408744132326e-14, 0.0, 1.14299562489344e-14, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.23340030410525e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.20651414332819e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.60576914948, 0.0, 0.0, 0.0, -4.20458932936042, -3.43303281162799, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841197, 0.529728463363979, 0.432521479156788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171168, -2.50713268211203, 4.78713553878169, 0.0, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709561, 0.0, 18.8034951158402, -0.603122387046457, 0.0, 0.0, 0.0, 1.68183573174417, 0.701283781217658, 0.132137494528683, -0.0934353184302338, 0.0, 0.0, 0.0, 0.0, 1.01657368639936e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095217, 0.0, -1.58564993434418, 4.48489528465111, 4.28174419288838, 0.0, 1.39181061118525e-14, 0.191485421551267, -3.75233260785873, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, -1.38212051998442e-14, 0.0, 0.844371341865037, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 2.04801801850478e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.59512887494071, 0.0, 0.0, 0.0, 10.0285307284481, -0.767649473578741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.096714742912332, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.92428337406971, 5.49285249860477, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08625016632142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278147, 0.0, 0.0, 0.0, 1.37682944358601e-14, 8.91928088068604, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483826, 0.0, 8.12403840463597, -1.64130361329659, 0.0, 1.94236371139386e-14, -1.2084492040842e-14, 11.7728501222092, -2.40312296813959, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741914, 0.30276503540975, -0.0611677741841197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990514, 2.93605316083774, 0.0, 0.0, 1.14892842931746e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6081867662439, -3.09487177319465, 0.68387650554024, 0.0, 0.0, 1.01609667611756e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29782505861522, 0.0, 1.49829835452878, 5.50917601898535, 0.0, 0.0, -3.31921990265919e-14, 0.0, 6.64803945320941, 4.13676892548487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.03538690111428e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 1.4986633192005e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.60576914948, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.39853957981253e-14, 0.0, 0.0, 0.0, 0.0, -1.02599765044344e-14, 1.32507554204647e-14, 1.33226762955019e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, -1.85543680054609e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 7.24568837309471, 4.18330013267038, -0.591607978309956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, -1.70362380559453e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106458, 0.0, 9.66091783079296, 0.683130051063978, 0.0, -1.11458385846514e-14, 1.90959259748689e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, -2.93971798753892e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32889602233148e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.51636339197811e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474619, -0.999999999999996, 9.16515138991168, 7.09929573971953, -0.414039335605403, -2.04939015319192, -0.478091443733749, 0.1690308509457, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974982, 2.12132034355964, -0.408248290463862, 3.17542648054295, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.79999999999999, -5.69209978830308, 4.38178046004133, -0.774596669241487, 0.0, 10.998181667894, 0.962140470884732, 4.76235235991626, -0.740656079818045, 0.130930734141592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824851, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, -1.04204372066163e-14, 0.0, 0.0, 5.1845925587263, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270662, 0.0, -3.16227766016838, -2.2360679774998, 0.0, 2.09911141082732e-14, -1.43433241843284e-14, 13.7477270848675, 0.534522483824851, 0.377964473009234, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.79999999999998, 0.0, 3.65148371670111, -2.84018778721877, 0.0, 0.0, 2.52373632039099e-14, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46002787799886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.76435655866528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.44821019466133e-14, 0.0, 0.0, 0.0},
      {2.20454076850487, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, -1.73899916117335e-14, 0.0, 0.0, 8.97997772825748, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11734754298611e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239551, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229247, -2.78313372537744, -0.524404424085079, 0.370809924354776, 11.1242977306435, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656967, 0.114434427054266, 0.840917865872084, 0.350641890608828, 0.0660687472643419, -0.0467176592151164, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912204761, 2.74642624930238, -0.792824967172091, 2.24244764232556, 2.14087209644419, -0.331662479035537, 6.49923072370879, 0.0957427107756343, -1.87616630392935, -2.15580611373101, 0.0, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932517, 0.590936840285277, 0.522319308773342, 0.0, 0.0, 1.63019078069772e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747036, 3.74574588632197, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789365, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 12.7134831207354, 1.01946290306866, 8.2065180664829, -0.63173805530579, 0.0483573714561638, -2.84282124887606, -0.227958835180084, 0.139595707137604, -0.0394836284566095, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715536, 1.16057691494799, 1.34011878852098, 1.89521416591737, 2.53311402559511, 1.96214168703485, 2.7464262493024, -0.566421515598883, 3.17129986868839, -1.82198870938951, 0.0, 0.0, 11.1699829238239, 0.0, 8.65223156827827, -0.865042958313586, 0.0, -2.49768411251821, -0.998865569685861, 0.441440386136648, 0.0, 0.0, 1.90161127277086e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.12790315683051e-14, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139074, -0.193429485824664, 3.55615782880926, 0.0, 0.0, 4.459640440343, 0.0, -0.85825820290699, 2.67027285925188, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03297925509764e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 7.03562363973515, 4.06201920231798, -0.820651806648291, 0.0, -6.79705818718656, -2.08116553882675, 5.88642506110458, -1.20156148406979, 0.242752078113811, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577677, 0.262202212042538, 5.13809303146605, -0.74161984870957, 0.151382517704875, -0.0305838870920605, 0.0, 1.01167199432803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614215, -2.69693703815182, 2.07610309995257, 1.46802658041887, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090393, -1.41130638568871, 0.0, 0.0, 0.0, 0.0, 13.4039795085887, 2.01017818278147, 0.0, 5.80409338312195, -1.54743588659732, 0.341938252770121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747035, 0.749149177264396, 2.75458800949268, 0.0, 1.12349008676759e-14, 5.75737105184052, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964687, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964686, 1.89521416591737, 0.0, 1.45082713966115e-14, 0.0, -3.39852909359329, -2.77488738510234, -0.5606119105814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.428174419288833, 0.349602949390052, 0.0706304617818625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32758182495306e-14, 0.0, 0.0, 0.0},
      {3.82970843102534, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171168, -4.07409060843207, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.7549743857359, 1.11676565710082, 0.987090711415294, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.32664991614217, -1.16809708692599e-14, 1.73008591662714, -3.18072425757423, 0.0, 1.0893489030894e-14, 0.0, 0.0, 7.67649473578741, -2.38836465270396, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 1.2485144121e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05299100428112e-14, 0.0, 1.09068140157585e-14, 0.0, 0.0, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630364, 0.0, 0.0, 0.0, 0.0, 1.47637052386759e-14, 9.57317681262153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20166278260625e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, -1.60347164931709e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 1.44913767461894, 4.18330013267038, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 7.09929573971953, 0.0, 4.34741302385684, 0.0, 0.0, -1.61480596362451e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, -1.31466507325082e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, -1.21243882593894e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474619, -0.999999999999998, 1.30930734141596, 7.09929573971953, -0.414039335605411, -2.04939015319192, -0.478091443733752, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.40824829046386, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600636, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033675, 4.38178046004133, -0.774596669241484, 0.0, 3.14233761939829, -0.106904496764966, 4.76235235991627, -0.740656079818039, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505162, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222144, 1.8516401995451, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922061358, -6.26099033699941, 0.0, 3.83405790253617, 0.0, 1.38492296223016e-14, 10.5830052442584, 0.0, 1.41526731116184e-14, 5.18459255872631, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499958, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824849, 0.0755928946018443, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 1.10729559076995e-14, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755172, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834956, 0.0, -6.26099033699941, 2.21359436211786, 0.0, 1.28098487007237e-14, 0.0, 0.0, 10.5830052442584, 2.99332590941916, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02980913200997e-14, 0.0, 0.0, 0.0},
      {5.71576766497731, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 1.73372856634452e-14, 12.6996062931101, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229245, -2.78313372537744, -0.524404424085075, 0.37080992435478, 1.23603308118261, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656969, 0.114434427054265, 0.840917865872086, 0.350641890608829, 0.0660687472643404, -0.0467176592151171, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930238, -0.79282496717209, 2.24244764232555, 2.14087209644419, -0.331662479035535, 6.49923072370878, 0.0957427107756321, -1.87616630392936, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932516, 0.590936840285278, 0.522319308773342, 0.0, 0.0, 1.15032771783196e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632197, -1.05945692672795, 0.404586796856339, 5.01426536422406, -0.383824736789359, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 2.82521847127454, -0.0509731451534319, 8.2065180664829, -0.631738055305791, 0.0483573714561628, -2.84282124887606, -0.227958835180081, 0.139595707137603, -0.0394836284566106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227874, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313572, 0.0, -2.49768411251822, -0.998865569685861, 0.441440386136646, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 1.00508909139074, -0.193429485824662, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034302, 0.0, -0.858258202906978, 2.67027285925187, 0.0, 0.0, 12.4373429638327, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190448, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 0.335029697130247, 4.06201920231798, -0.820651806648293, 0.0, 1.69926454679665, -0.0991031208965179, 5.88642506110458, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644417, 0.0124858196210744, 5.13809303146606, -0.741619848709572, 0.151382517704875, -0.0305838870920594, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614216, 0.299659670905759, 2.07610309995257, 1.46802658041887, 0.0, 0.868496237346891, 0.709124208342345, 1.31624465810882, 4.91295663090394, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102535, -0.22335313142017, 0.0, 5.80409338312195, -1.54743588659733, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 0.259512887494073, 0.749149177264395, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036809, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196468, 7.62808987244125, 0.0, 3.11415464992884, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2942239872397e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577669, 0.0, 2.68023757704196, -0.473803541479347, 0.0, 1.64767592289181e-14, -1.02022867713368e-14, 5.09779364038994, -0.792824967172095, 0.140152977645347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933263, 0.0998865569685854, -0.0176576154454661, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205055, 0.0, 1.49829835452879, 0.847565541382358, 0.0, 2.13197388895806e-14, 0.0, 1.62843044502543, 3.54562104171167, -0.814818121686423, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710081, 0.197418142283058, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071083, 0.0, 0.692034366650855, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212812, 3.07059789431496, 1.19418232635198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309061, 0.0, 7.62808987244125, 1.79795802543455, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451479, 0.0, 0.0, 1.19811444974696e-14, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29775342561708e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.0137464349807055, 0.0, 0.0, 0.0177465712499983, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0126984126984127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0306297238936141};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0251891949326e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.00840190190275e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.11022302462516e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661992, 0.0, -1.80596278672359e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, -3.40724761118906e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34211460084998e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.74113374895575e-14, 0.0, 0.0, 0.0, 0.0, -1.03967692597581e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027551, 0.565685424949246, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556635, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.77635683940025e-14, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.03666983567529e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18118899707127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008266, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983253, -1.48131215963608, 0.261861468283195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362399, 0.0, 3.16227766016838, 4.91934955049954, 0.0, 0.0, -1.64426494173481e-14, 0.0, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09141975464799e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, -2.08408744132326e-14, 0.0, 1.14299562489344e-14, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.23340030410525e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.20651414332819e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.60576914948, 0.0, 0.0, 0.0, -4.20458932936042, -3.43303281162799, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841197, 0.529728463363979, 0.432521479156788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171168, -2.50713268211203, 4.78713553878169, 0.0, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709561, 0.0, 18.8034951158402, -0.603122387046457, 0.0, 0.0, 0.0, 1.68183573174417, 0.701283781217658, 0.132137494528683, -0.0934353184302338, 0.0, 0.0, 0.0, 0.0, 1.01657368639936e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095217, 0.0, -1.58564993434418, 4.48489528465111, 4.28174419288838, 0.0, 1.39181061118525e-14, 0.191485421551267, -3.75233260785873, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, -1.38212051998442e-14, 0.0, 0.844371341865037, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 2.04801801850478e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.59512887494071, 0.0, 0.0, 0.0, 10.0285307284481, -0.767649473578741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.096714742912332, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.92428337406971, 5.49285249860477, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08625016632142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278147, 0.0, 0.0, 0.0, 1.37682944358601e-14, 8.91928088068604, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483826, 0.0, 8.12403840463597, -1.64130361329659, 0.0, 1.94236371139386e-14, -1.2084492040842e-14, 11.7728501222092, -2.40312296813959, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741914, 0.30276503540975, -0.0611677741841197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990514, 2.93605316083774, 0.0, 0.0, 1.14892842931746e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6081867662439, -3.09487177319465, 0.68387650554024, 0.0, 0.0, 1.01609667611756e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29782505861522, 0.0, 1.49829835452878, 5.50917601898535, 0.0, 0.0, -3.31921990265919e-14, 0.0, 6.64803945320941, 4.13676892548487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.03538690111428e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 1.4986633192005e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.60576914948, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.39853957981253e-14, 0.0, 0.0, 0.0, 0.0, -1.02599765044344e-14, 1.32507554204647e-14, 1.33226762955019e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, -1.85543680054609e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 7.24568837309471, 4.18330013267038, -0.591607978309956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, -1.70362380559453e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106458, 0.0, 9.66091783079296, 0.683130051063978, 0.0, -1.11458385846514e-14, 1.90959259748689e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, -2.93971798753892e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32889602233148e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.51636339197811e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474619, -0.999999999999996, 9.16515138991168, 7.09929573971953, -0.414039335605403, -2.04939015319192, -0.478091443733749, 0.1690308509457, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974982, 2.12132034355964, -0.408248290463862, 3.17542648054295, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.79999999999999, -5.69209978830308, 4.38178046004133, -0.774596669241487, 0.0, 10.998181667894, 0.962140470884732, 4.76235235991626, -0.740656079818045, 0.130930734141592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824851, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, -1.04204372066163e-14, 0.0, 0.0, 5.1845925587263, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270662, 0.0, -3.16227766016838, -2.2360679774998, 0.0, 2.09911141082732e-14, -1.43433241843284e-14, 13.7477270848675, 0.534522483824851, 0.377964473009234, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.79999999999998, 0.0, 3.65148371670111, -2.84018778721877, 0.0, 0.0, 2.52373632039099e-14, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46002787799886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.76435655866528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.44821019466133e-14, 0.0, 0.0, 0.0},
      {2.20454076850487, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, -1.73899916117335e-14, 0.0, 0.0, 8.97997772825748, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11734754298611e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239551, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229247, -2.78313372537744, -0.524404424085079, 0.370809924354776, 11.1242977306435, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656967, 0.114434427054266, 0.840917865872084, 0.350641890608828, 0.0660687472643419, -0.0467176592151164, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912204761, 2.74642624930238, -0.792824967172091, 2.24244764232556, 2.14087209644419, -0.331662479035537, 6.49923072370879, 0.0957427107756343, -1.87616630392935, -2.15580611373101, 0.0, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932517, 0.590936840285277, 0.522319308773342, 0.0, 0.0, 1.63019078069772e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747036, 3.74574588632197, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789365, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 12.7134831207354, 1.01946290306866, 8.2065180664829, -0.63173805530579, 0.0483573714561638, -2.84282124887606, -0.227958835180084, 0.139595707137604, -0.0394836284566095, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715536, 1.16057691494799, 1.34011878852098, 1.89521416591737, 2.53311402559511, 1.96214168703485, 2.7464262493024, -0.566421515598883, 3.17129986868839, -1.82198870938951, 0.0, 0.0, 11.1699829238239, 0.0, 8.65223156827827, -0.865042958313586, 0.0, -2.49768411251821, -0.998865569685861, 0.441440386136648, 0.0, 0.0, 1.90161127277086e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.12790315683051e-14, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139074, -0.193429485824664, 3.55615782880926, 0.0, 0.0, 4.459640440343, 0.0, -0.85825820290699, 2.67027285925188, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03297925509764e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 7.03562363973515, 4.06201920231798, -0.820651806648291, 0.0, -6.79705818718656, -2.08116553882675, 5.88642506110458, -1.20156148406979, 0.242752078113811, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577677, 0.262202212042538, 5.13809303146605, -0.74161984870957, 0.151382517704875, -0.0305838870920605, 0.0, 1.01167199432803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614215, -2.69693703815182, 2.07610309995257, 1.46802658041887, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090393, -1.41130638568871, 0.0, 0.0, 0.0, 0.0, 13.4039795085887, 2.01017818278147, 0.0, 5.80409338312195, -1.54743588659732, 0.341938252770121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747035, 0.749149177264396, 2.75458800949268, 0.0, 1.12349008676759e-14, 5.75737105184052, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964687, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964686, 1.89521416591737, 0.0, 1.45082713966115e-14, 0.0, -3.39852909359329, -2.77488738510234, -0.5606119105814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.428174419288833, 0.349602949390052, 0.0706304617818625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32758182495306e-14, 0.0, 0.0, 0.0},
      {3.82970843102534, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171168, -4.07409060843207, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.7549743857359, 1.11676565710082, 0.987090711415294, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.32664991614217, -1.16809708692599e-14, 1.73008591662714, -3.18072425757423, 0.0, 1.0893489030894e-14, 0.0, 0.0, 7.67649473578741, -2.38836465270396, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 1.2485144121e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05299100428112e-14, 0.0, 1.09068140157585e-14, 0.0, 0.0, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630364, 0.0, 0.0, 0.0, 0.0, 1.47637052386759e-14, 9.57317681262153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20166278260625e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, -1.60347164931709e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 1.44913767461894, 4.18330013267038, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 7.09929573971953, 0.0, 4.34741302385684, 0.0, 0.0, -1.61480596362451e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, -1.31466507325082e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, -1.21243882593894e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474619, -0.999999999999998, 1.30930734141596, 7.09929573971953, -0.414039335605411, -2.04939015319192, -0.478091443733752, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.40824829046386, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600636, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033675, 4.38178046004133, -0.774596669241484, 0.0, 3.14233761939829, -0.106904496764966, 4.76235235991627, -0.740656079818039, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505162, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222144, 1.8516401995451, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922061358, -6.26099033699941, 0.0, 3.83405790253617, 0.0, 1.38492296223016e-14, 10.5830052442584, 0.0, 1.41526731116184e-14, 5.18459255872631, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499958, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824849, 0.0755928946018443, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 1.10729559076995e-14, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755172, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834956, 0.0, -6.26099033699941, 2.21359436211786, 0.0, 1.28098487007237e-14, 0.0, 0.0, 10.5830052442584, 2.99332590941916, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02980913200997e-14, 0.0, 0.0, 0.0},
      {5.71576766497731, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 1.73372856634452e-14, 12.6996062931101, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229245, -2.78313372537744, -0.524404424085075, 0.37080992435478, 1.23603308118261, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656969, 0.114434427054265, 0.840917865872086, 0.350641890608829, 0.0660687472643404, -0.0467176592151171, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930238, -0.79282496717209, 2.24244764232555, 2.14087209644419, -0.331662479035535, 6.49923072370878, 0.0957427107756321, -1.87616630392936, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932516, 0.590936840285278, 0.522319308773342, 0.0, 0.0, 1.15032771783196e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632197, -1.05945692672795, 0.404586796856339, 5.01426536422406, -0.383824736789359, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 2.82521847127454, -0.0509731451534319, 8.2065180664829, -0.631738055305791, 0.0483573714561628, -2.84282124887606, -0.227958835180081, 0.139595707137603, -0.0394836284566106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227874, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313572, 0.0, -2.49768411251822, -0.998865569685861, 0.441440386136646, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 1.00508909139074, -0.193429485824662, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034302, 0.0, -0.858258202906978, 2.67027285925187, 0.0, 0.0, 12.4373429638327, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190448, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 0.335029697130247, 4.06201920231798, -0.820651806648293, 0.0, 1.69926454679665, -0.0991031208965179, 5.88642506110458, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644417, 0.0124858196210744, 5.13809303146606, -0.741619848709572, 0.151382517704875, -0.0305838870920594, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614216, 0.299659670905759, 2.07610309995257, 1.46802658041887, 0.0, 0.868496237346891, 0.709124208342345, 1.31624465810882, 4.91295663090394, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102535, -0.22335313142017, 0.0, 5.80409338312195, -1.54743588659733, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 0.259512887494073, 0.749149177264395, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036809, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196468, 7.62808987244125, 0.0, 3.11415464992884, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2942239872397e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577669, 0.0, 2.68023757704196, -0.473803541479347, 0.0, 1.64767592289181e-14, -1.02022867713368e-14, 5.09779364038994, -0.792824967172095, 0.140152977645347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933263, 0.0998865569685854, -0.0176576154454661, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205055, 0.0, 1.49829835452879, 0.847565541382358, 0.0, 2.13197388895806e-14, 0.0, 1.62843044502543, 3.54562104171167, -0.814818121686423, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710081, 0.197418142283058, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071083, 0.0, 0.692034366650855, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212812, 3.07059789431496, 1.19418232635198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309061, 0.0, 7.62808987244125, 1.79795802543455, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451479, 0.0, 0.0, 1.19811444974696e-14, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29775342561708e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382572, 0.0, 0.0267706045305259, 0.0189296759999982, 0.0, 0.0, 0.0, 0.0581914373962646, -0.0316754064488799, 0.0111989473484216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0406349206349206, 0.00439885919382571, -0.0143666139669648, 0.00761904761904763, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0367556686723369, -0.0424417904044368, 0.0303218796594646, -0.0122518895574456};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0251891949326e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.00840190190275e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.11022302462516e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661992, 0.0, -1.80596278672359e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, -3.40724761118906e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34211460084998e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.74113374895575e-14, 0.0, 0.0, 0.0, 0.0, -1.03967692597581e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027551, 0.565685424949246, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556635, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.77635683940025e-14, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.03666983567529e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18118899707127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008266, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983253, -1.48131215963608, 0.261861468283195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362399, 0.0, 3.16227766016838, 4.91934955049954, 0.0, 0.0, -1.64426494173481e-14, 0.0, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09141975464799e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, -2.08408744132326e-14, 0.0, 1.14299562489344e-14, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.23340030410525e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.20651414332819e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.60576914948, 0.0, 0.0, 0.0, -4.20458932936042, -3.43303281162799, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841197, 0.529728463363979, 0.432521479156788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171168, -2.50713268211203, 4.78713553878169, 0.0, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709561, 0.0, 18.8034951158402, -0.603122387046457, 0.0, 0.0, 0.0, 1.68183573174417, 0.701283781217658, 0.132137494528683, -0.0934353184302338, 0.0, 0.0, 0.0, 0.0, 1.01657368639936e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095217, 0.0, -1.58564993434418, 4.48489528465111, 4.28174419288838, 0.0, 1.39181061118525e-14, 0.191485421551267, -3.75233260785873, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, -1.38212051998442e-14, 0.0, 0.844371341865037, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 2.04801801850478e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.59512887494071, 0.0, 0.0, 0.0, 10.0285307284481, -0.767649473578741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.096714742912332, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.92428337406971, 5.49285249860477, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08625016632142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278147, 0.0, 0.0, 0.0, 1.37682944358601e-14, 8.91928088068604, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483826, 0.0, 8.12403840463597, -1.64130361329659, 0.0, 1.94236371139386e-14, -1.2084492040842e-14, 11.7728501222092, -2.40312296813959, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741914, 0.30276503540975, -0.0611677741841197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990514, 2.93605316083774, 0.0, 0.0, 1.14892842931746e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6081867662439, -3.09487177319465, 0.68387650554024, 0.0, 0.0, 1.01609667611756e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29782505861522, 0.0, 1.49829835452878, 5.50917601898535, 0.0, 0.0, -3.31921990265919e-14, 0.0, 6.64803945320941, 4.13676892548487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.03538690111428e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 1.4986633192005e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.60576914948, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.39853957981253e-14, 0.0, 0.0, 0.0, 0.0, -1.02599765044344e-14, 1.32507554204647e-14, 1.33226762955019e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, -1.85543680054609e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 7.24568837309471, 4.18330013267038, -0.591607978309956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, -1.70362380559453e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106458, 0.0, 9.66091783079296, 0.683130051063978, 0.0, -1.11458385846514e-14, 1.90959259748689e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, -2.93971798753892e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32889602233148e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.51636339197811e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474619, -0.999999999999996, 9.16515138991168, 7.09929573971953, -0.414039335605403, -2.04939015319192, -0.478091443733749, 0.1690308509457, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974982, 2.12132034355964, -0.408248290463862, 3.17542648054295, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.79999999999999, -5.69209978830308, 4.38178046004133, -0.774596669241487, 0.0, 10.998181667894, 0.962140470884732, 4.76235235991626, -0.740656079818045, 0.130930734141592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824851, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, -1.04204372066163e-14, 0.0, 0.0, 5.1845925587263, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270662, 0.0, -3.16227766016838, -2.2360679774998, 0.0, 2.09911141082732e-14, -1.43433241843284e-14, 13.7477270848675, 0.534522483824851, 0.377964473009234, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.79999999999998, 0.0, 3.65148371670111, -2.84018778721877, 0.0, 0.0, 2.52373632039099e-14, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46002787799886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.76435655866528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.44821019466133e-14, 0.0, 0.0, 0.0},
      {2.20454076850487, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, -1.73899916117335e-14, 0.0, 0.0, 8.97997772825748, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11734754298611e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239551, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229247, -2.78313372537744, -0.524404424085079, 0.370809924354776, 11.1242977306435, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656967, 0.114434427054266, 0.840917865872084, 0.350641890608828, 0.0660687472643419, -0.0467176592151164, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912204761, 2.74642624930238, -0.792824967172091, 2.24244764232556, 2.14087209644419, -0.331662479035537, 6.49923072370879, 0.0957427107756343, -1.87616630392935, -2.15580611373101, 0.0, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932517, 0.590936840285277, 0.522319308773342, 0.0, 0.0, 1.63019078069772e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747036, 3.74574588632197, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789365, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 12.7134831207354, 1.01946290306866, 8.2065180664829, -0.63173805530579, 0.0483573714561638, -2.84282124887606, -0.227958835180084, 0.139595707137604, -0.0394836284566095, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715536, 1.16057691494799, 1.34011878852098, 1.89521416591737, 2.53311402559511, 1.96214168703485, 2.7464262493024, -0.566421515598883, 3.17129986868839, -1.82198870938951, 0.0, 0.0, 11.1699829238239, 0.0, 8.65223156827827, -0.865042958313586, 0.0, -2.49768411251821, -0.998865569685861, 0.441440386136648, 0.0, 0.0, 1.90161127277086e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.12790315683051e-14, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139074, -0.193429485824664, 3.55615782880926, 0.0, 0.0, 4.459640440343, 0.0, -0.85825820290699, 2.67027285925188, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03297925509764e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 7.03562363973515, 4.06201920231798, -0.820651806648291, 0.0, -6.79705818718656, -2.08116553882675, 5.88642506110458, -1.20156148406979, 0.242752078113811, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577677, 0.262202212042538, 5.13809303146605, -0.74161984870957, 0.151382517704875, -0.0305838870920605, 0.0, 1.01167199432803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614215, -2.69693703815182, 2.07610309995257, 1.46802658041887, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090393, -1.41130638568871, 0.0, 0.0, 0.0, 0.0, 13.4039795085887, 2.01017818278147, 0.0, 5.80409338312195, -1.54743588659732, 0.341938252770121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747035, 0.749149177264396, 2.75458800949268, 0.0, 1.12349008676759e-14, 5.75737105184052, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964687, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964686, 1.89521416591737, 0.0, 1.45082713966115e-14, 0.0, -3.39852909359329, -2.77488738510234, -0.5606119105814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.428174419288833, 0.349602949390052, 0.0706304617818625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32758182495306e-14, 0.0, 0.0, 0.0},
      {3.82970843102534, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171168, -4.07409060843207, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.7549743857359, 1.11676565710082, 0.987090711415294, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.32664991614217, -1.16809708692599e-14, 1.73008591662714, -3.18072425757423, 0.0, 1.0893489030894e-14, 0.0, 0.0, 7.67649473578741, -2.38836465270396, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 1.2485144121e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05299100428112e-14, 0.0, 1.09068140157585e-14, 0.0, 0.0, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630364, 0.0, 0.0, 0.0, 0.0, 1.47637052386759e-14, 9.57317681262153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20166278260625e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, -1.60347164931709e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 1.44913767461894, 4.18330013267038, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 7.09929573971953, 0.0, 4.34741302385684, 0.0, 0.0, -1.61480596362451e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, -1.31466507325082e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, -1.21243882593894e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474619, -0.999999999999998, 1.30930734141596, 7.09929573971953, -0.414039335605411, -2.04939015319192, -0.478091443733752, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.40824829046386, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600636, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033675, 4.38178046004133, -0.774596669241484, 0.0, 3.14233761939829, -0.106904496764966, 4.76235235991627, -0.740656079818039, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505162, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222144, 1.8516401995451, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922061358, -6.26099033699941, 0.0, 3.83405790253617, 0.0, 1.38492296223016e-14, 10.5830052442584, 0.0, 1.41526731116184e-14, 5.18459255872631, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499958, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824849, 0.0755928946018443, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 1.10729559076995e-14, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755172, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834956, 0.0, -6.26099033699941, 2.21359436211786, 0.0, 1.28098487007237e-14, 0.0, 0.0, 10.5830052442584, 2.99332590941916, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02980913200997e-14, 0.0, 0.0, 0.0},
      {5.71576766497731, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 1.73372856634452e-14, 12.6996062931101, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229245, -2.78313372537744, -0.524404424085075, 0.37080992435478, 1.23603308118261, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656969, 0.114434427054265, 0.840917865872086, 0.350641890608829, 0.0660687472643404, -0.0467176592151171, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930238, -0.79282496717209, 2.24244764232555, 2.14087209644419, -0.331662479035535, 6.49923072370878, 0.0957427107756321, -1.87616630392936, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932516, 0.590936840285278, 0.522319308773342, 0.0, 0.0, 1.15032771783196e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632197, -1.05945692672795, 0.404586796856339, 5.01426536422406, -0.383824736789359, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 2.82521847127454, -0.0509731451534319, 8.2065180664829, -0.631738055305791, 0.0483573714561628, -2.84282124887606, -0.227958835180081, 0.139595707137603, -0.0394836284566106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227874, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313572, 0.0, -2.49768411251822, -0.998865569685861, 0.441440386136646, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 1.00508909139074, -0.193429485824662, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034302, 0.0, -0.858258202906978, 2.67027285925187, 0.0, 0.0, 12.4373429638327, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190448, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 0.335029697130247, 4.06201920231798, -0.820651806648293, 0.0, 1.69926454679665, -0.0991031208965179, 5.88642506110458, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644417, 0.0124858196210744, 5.13809303146606, -0.741619848709572, 0.151382517704875, -0.0305838870920594, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614216, 0.299659670905759, 2.07610309995257, 1.46802658041887, 0.0, 0.868496237346891, 0.709124208342345, 1.31624465810882, 4.91295663090394, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102535, -0.22335313142017, 0.0, 5.80409338312195, -1.54743588659733, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 0.259512887494073, 0.749149177264395, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036809, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196468, 7.62808987244125, 0.0, 3.11415464992884, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2942239872397e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577669, 0.0, 2.68023757704196, -0.473803541479347, 0.0, 1.64767592289181e-14, -1.02022867713368e-14, 5.09779364038994, -0.792824967172095, 0.140152977645347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933263, 0.0998865569685854, -0.0176576154454661, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205055, 0.0, 1.49829835452879, 0.847565541382358, 0.0, 2.13197388895806e-14, 0.0, 1.62843044502543, 3.54562104171167, -0.814818121686423, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710081, 0.197418142283058, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071083, 0.0, 0.692034366650855, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212812, 3.07059789431496, 1.19418232635198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309061, 0.0, 7.62808987244125, 1.79795802543455, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451479, 0.0, 0.0, 1.19811444974696e-14, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29775342561708e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.0329914439536929, 0.0, -0.0200779533978945, -0.0141972569999987, 0.0, 0.0, 0.0, -0.00969857289937745, 0.0712696645099798, -0.050395263067897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.04618802153517, 0.0107749604752236, -0.0190476190476191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0495154221385096, -0.0606437593189292, 0.0306297238936141};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0251891949326e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.00840190190275e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.11022302462516e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661992, 0.0, -1.80596278672359e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, -3.40724761118906e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34211460084998e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.74113374895575e-14, 0.0, 0.0, 0.0, 0.0, -1.03967692597581e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027551, 0.565685424949246, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556635, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.77635683940025e-14, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.03666983567529e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18118899707127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008266, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983253, -1.48131215963608, 0.261861468283195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362399, 0.0, 3.16227766016838, 4.91934955049954, 0.0, 0.0, -1.64426494173481e-14, 0.0, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09141975464799e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, -2.08408744132326e-14, 0.0, 1.14299562489344e-14, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.23340030410525e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.20651414332819e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.60576914948, 0.0, 0.0, 0.0, -4.20458932936042, -3.43303281162799, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841197, 0.529728463363979, 0.432521479156788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171168, -2.50713268211203, 4.78713553878169, 0.0, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709561, 0.0, 18.8034951158402, -0.603122387046457, 0.0, 0.0, 0.0, 1.68183573174417, 0.701283781217658, 0.132137494528683, -0.0934353184302338, 0.0, 0.0, 0.0, 0.0, 1.01657368639936e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095217, 0.0, -1.58564993434418, 4.48489528465111, 4.28174419288838, 0.0, 1.39181061118525e-14, 0.191485421551267, -3.75233260785873, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, -1.38212051998442e-14, 0.0, 0.844371341865037, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 2.04801801850478e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.59512887494071, 0.0, 0.0, 0.0, 10.0285307284481, -0.767649473578741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.096714742912332, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.92428337406971, 5.49285249860477, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08625016632142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278147, 0.0, 0.0, 0.0, 1.37682944358601e-14, 8.91928088068604, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483826, 0.0, 8.12403840463597, -1.64130361329659, 0.0, 1.94236371139386e-14, -1.2084492040842e-14, 11.7728501222092, -2.40312296813959, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741914, 0.30276503540975, -0.0611677741841197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990514, 2.93605316083774, 0.0, 0.0, 1.14892842931746e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6081867662439, -3.09487177319465, 0.68387650554024, 0.0, 0.0, 1.01609667611756e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29782505861522, 0.0, 1.49829835452878, 5.50917601898535, 0.0, 0.0, -3.31921990265919e-14, 0.0, 6.64803945320941, 4.13676892548487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.03538690111428e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 1.4986633192005e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.60576914948, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.39853957981253e-14, 0.0, 0.0, 0.0, 0.0, -1.02599765044344e-14, 1.32507554204647e-14, 1.33226762955019e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, -1.85543680054609e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 7.24568837309471, 4.18330013267038, -0.591607978309956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, -1.70362380559453e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106458, 0.0, 9.66091783079296, 0.683130051063978, 0.0, -1.11458385846514e-14, 1.90959259748689e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, -2.93971798753892e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32889602233148e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.51636339197811e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474619, -0.999999999999996, 9.16515138991168, 7.09929573971953, -0.414039335605403, -2.04939015319192, -0.478091443733749, 0.1690308509457, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974982, 2.12132034355964, -0.408248290463862, 3.17542648054295, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.79999999999999, -5.69209978830308, 4.38178046004133, -0.774596669241487, 0.0, 10.998181667894, 0.962140470884732, 4.76235235991626, -0.740656079818045, 0.130930734141592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824851, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, -1.04204372066163e-14, 0.0, 0.0, 5.1845925587263, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270662, 0.0, -3.16227766016838, -2.2360679774998, 0.0, 2.09911141082732e-14, -1.43433241843284e-14, 13.7477270848675, 0.534522483824851, 0.377964473009234, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.79999999999998, 0.0, 3.65148371670111, -2.84018778721877, 0.0, 0.0, 2.52373632039099e-14, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46002787799886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.76435655866528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.44821019466133e-14, 0.0, 0.0, 0.0},
      {2.20454076850487, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, -1.73899916117335e-14, 0.0, 0.0, 8.97997772825748, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11734754298611e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239551, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229247, -2.78313372537744, -0.524404424085079, 0.370809924354776, 11.1242977306435, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656967, 0.114434427054266, 0.840917865872084, 0.350641890608828, 0.0660687472643419, -0.0467176592151164, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912204761, 2.74642624930238, -0.792824967172091, 2.24244764232556, 2.14087209644419, -0.331662479035537, 6.49923072370879, 0.0957427107756343, -1.87616630392935, -2.15580611373101, 0.0, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932517, 0.590936840285277, 0.522319308773342, 0.0, 0.0, 1.63019078069772e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747036, 3.74574588632197, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789365, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 12.7134831207354, 1.01946290306866, 8.2065180664829, -0.63173805530579, 0.0483573714561638, -2.84282124887606, -0.227958835180084, 0.139595707137604, -0.0394836284566095, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715536, 1.16057691494799, 1.34011878852098, 1.89521416591737, 2.53311402559511, 1.96214168703485, 2.7464262493024, -0.566421515598883, 3.17129986868839, -1.82198870938951, 0.0, 0.0, 11.1699829238239, 0.0, 8.65223156827827, -0.865042958313586, 0.0, -2.49768411251821, -0.998865569685861, 0.441440386136648, 0.0, 0.0, 1.90161127277086e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.12790315683051e-14, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139074, -0.193429485824664, 3.55615782880926, 0.0, 0.0, 4.459640440343, 0.0, -0.85825820290699, 2.67027285925188, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03297925509764e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 7.03562363973515, 4.06201920231798, -0.820651806648291, 0.0, -6.79705818718656, -2.08116553882675, 5.88642506110458, -1.20156148406979, 0.242752078113811, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577677, 0.262202212042538, 5.13809303146605, -0.74161984870957, 0.151382517704875, -0.0305838870920605, 0.0, 1.01167199432803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614215, -2.69693703815182, 2.07610309995257, 1.46802658041887, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090393, -1.41130638568871, 0.0, 0.0, 0.0, 0.0, 13.4039795085887, 2.01017818278147, 0.0, 5.80409338312195, -1.54743588659732, 0.341938252770121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747035, 0.749149177264396, 2.75458800949268, 0.0, 1.12349008676759e-14, 5.75737105184052, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964687, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964686, 1.89521416591737, 0.0, 1.45082713966115e-14, 0.0, -3.39852909359329, -2.77488738510234, -0.5606119105814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.428174419288833, 0.349602949390052, 0.0706304617818625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32758182495306e-14, 0.0, 0.0, 0.0},
      {3.82970843102534, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171168, -4.07409060843207, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.7549743857359, 1.11676565710082, 0.987090711415294, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.32664991614217, -1.16809708692599e-14, 1.73008591662714, -3.18072425757423, 0.0, 1.0893489030894e-14, 0.0, 0.0, 7.67649473578741, -2.38836465270396, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 1.2485144121e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05299100428112e-14, 0.0, 1.09068140157585e-14, 0.0, 0.0, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630364, 0.0, 0.0, 0.0, 0.0, 1.47637052386759e-14, 9.57317681262153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20166278260625e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, -1.60347164931709e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 1.44913767461894, 4.18330013267038, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 7.09929573971953, 0.0, 4.34741302385684, 0.0, 0.0, -1.61480596362451e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, -1.31466507325082e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, -1.21243882593894e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474619, -0.999999999999998, 1.30930734141596, 7.09929573971953, -0.414039335605411, -2.04939015319192, -0.478091443733752, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.40824829046386, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600636, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033675, 4.38178046004133, -0.774596669241484, 0.0, 3.14233761939829, -0.106904496764966, 4.76235235991627, -0.740656079818039, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505162, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222144, 1.8516401995451, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922061358, -6.26099033699941, 0.0, 3.83405790253617, 0.0, 1.38492296223016e-14, 10.5830052442584, 0.0, 1.41526731116184e-14, 5.18459255872631, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499958, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824849, 0.0755928946018443, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 1.10729559076995e-14, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755172, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834956, 0.0, -6.26099033699941, 2.21359436211786, 0.0, 1.28098487007237e-14, 0.0, 0.0, 10.5830052442584, 2.99332590941916, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02980913200997e-14, 0.0, 0.0, 0.0},
      {5.71576766497731, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 1.73372856634452e-14, 12.6996062931101, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229245, -2.78313372537744, -0.524404424085075, 0.37080992435478, 1.23603308118261, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656969, 0.114434427054265, 0.840917865872086, 0.350641890608829, 0.0660687472643404, -0.0467176592151171, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930238, -0.79282496717209, 2.24244764232555, 2.14087209644419, -0.331662479035535, 6.49923072370878, 0.0957427107756321, -1.87616630392936, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932516, 0.590936840285278, 0.522319308773342, 0.0, 0.0, 1.15032771783196e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632197, -1.05945692672795, 0.404586796856339, 5.01426536422406, -0.383824736789359, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 2.82521847127454, -0.0509731451534319, 8.2065180664829, -0.631738055305791, 0.0483573714561628, -2.84282124887606, -0.227958835180081, 0.139595707137603, -0.0394836284566106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227874, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313572, 0.0, -2.49768411251822, -0.998865569685861, 0.441440386136646, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 1.00508909139074, -0.193429485824662, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034302, 0.0, -0.858258202906978, 2.67027285925187, 0.0, 0.0, 12.4373429638327, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190448, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 0.335029697130247, 4.06201920231798, -0.820651806648293, 0.0, 1.69926454679665, -0.0991031208965179, 5.88642506110458, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644417, 0.0124858196210744, 5.13809303146606, -0.741619848709572, 0.151382517704875, -0.0305838870920594, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614216, 0.299659670905759, 2.07610309995257, 1.46802658041887, 0.0, 0.868496237346891, 0.709124208342345, 1.31624465810882, 4.91295663090394, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102535, -0.22335313142017, 0.0, 5.80409338312195, -1.54743588659733, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 0.259512887494073, 0.749149177264395, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036809, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196468, 7.62808987244125, 0.0, 3.11415464992884, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2942239872397e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577669, 0.0, 2.68023757704196, -0.473803541479347, 0.0, 1.64767592289181e-14, -1.02022867713368e-14, 5.09779364038994, -0.792824967172095, 0.140152977645347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933263, 0.0998865569685854, -0.0176576154454661, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205055, 0.0, 1.49829835452879, 0.847565541382358, 0.0, 2.13197388895806e-14, 0.0, 1.62843044502543, 3.54562104171167, -0.814818121686423, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710081, 0.197418142283058, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071083, 0.0, 0.692034366650855, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212812, 3.07059789431496, 1.19418232635198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309061, 0.0, 7.62808987244125, 1.79795802543455, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451479, 0.0, 0.0, 1.19811444974696e-14, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29775342561708e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382573, 0.0, 0.026770604530526, 0.0189296759999982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0671936840905293, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0359165349174119, 0.0253968253968254, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0505364660991076, -0.0408396318581521};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0251891949326e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.00840190190275e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.11022302462516e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661992, 0.0, -1.80596278672359e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, -3.40724761118906e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34211460084998e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.74113374895575e-14, 0.0, 0.0, 0.0, 0.0, -1.03967692597581e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027551, 0.565685424949246, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556635, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.77635683940025e-14, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.03666983567529e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18118899707127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008266, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983253, -1.48131215963608, 0.261861468283195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362399, 0.0, 3.16227766016838, 4.91934955049954, 0.0, 0.0, -1.64426494173481e-14, 0.0, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09141975464799e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, -2.08408744132326e-14, 0.0, 1.14299562489344e-14, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.23340030410525e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.20651414332819e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.60576914948, 0.0, 0.0, 0.0, -4.20458932936042, -3.43303281162799, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841197, 0.529728463363979, 0.432521479156788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171168, -2.50713268211203, 4.78713553878169, 0.0, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709561, 0.0, 18.8034951158402, -0.603122387046457, 0.0, 0.0, 0.0, 1.68183573174417, 0.701283781217658, 0.132137494528683, -0.0934353184302338, 0.0, 0.0, 0.0, 0.0, 1.01657368639936e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095217, 0.0, -1.58564993434418, 4.48489528465111, 4.28174419288838, 0.0, 1.39181061118525e-14, 0.191485421551267, -3.75233260785873, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, -1.38212051998442e-14, 0.0, 0.844371341865037, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 2.04801801850478e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.59512887494071, 0.0, 0.0, 0.0, 10.0285307284481, -0.767649473578741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.096714742912332, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.92428337406971, 5.49285249860477, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08625016632142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278147, 0.0, 0.0, 0.0, 1.37682944358601e-14, 8.91928088068604, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483826, 0.0, 8.12403840463597, -1.64130361329659, 0.0, 1.94236371139386e-14, -1.2084492040842e-14, 11.7728501222092, -2.40312296813959, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741914, 0.30276503540975, -0.0611677741841197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990514, 2.93605316083774, 0.0, 0.0, 1.14892842931746e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6081867662439, -3.09487177319465, 0.68387650554024, 0.0, 0.0, 1.01609667611756e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29782505861522, 0.0, 1.49829835452878, 5.50917601898535, 0.0, 0.0, -3.31921990265919e-14, 0.0, 6.64803945320941, 4.13676892548487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.03538690111428e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 1.4986633192005e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.60576914948, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.39853957981253e-14, 0.0, 0.0, 0.0, 0.0, -1.02599765044344e-14, 1.32507554204647e-14, 1.33226762955019e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, -1.85543680054609e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 7.24568837309471, 4.18330013267038, -0.591607978309956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, -1.70362380559453e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106458, 0.0, 9.66091783079296, 0.683130051063978, 0.0, -1.11458385846514e-14, 1.90959259748689e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, -2.93971798753892e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32889602233148e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.51636339197811e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474619, -0.999999999999996, 9.16515138991168, 7.09929573971953, -0.414039335605403, -2.04939015319192, -0.478091443733749, 0.1690308509457, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974982, 2.12132034355964, -0.408248290463862, 3.17542648054295, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.79999999999999, -5.69209978830308, 4.38178046004133, -0.774596669241487, 0.0, 10.998181667894, 0.962140470884732, 4.76235235991626, -0.740656079818045, 0.130930734141592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824851, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, -1.04204372066163e-14, 0.0, 0.0, 5.1845925587263, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270662, 0.0, -3.16227766016838, -2.2360679774998, 0.0, 2.09911141082732e-14, -1.43433241843284e-14, 13.7477270848675, 0.534522483824851, 0.377964473009234, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.79999999999998, 0.0, 3.65148371670111, -2.84018778721877, 0.0, 0.0, 2.52373632039099e-14, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46002787799886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.76435655866528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.44821019466133e-14, 0.0, 0.0, 0.0},
      {2.20454076850487, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, -1.73899916117335e-14, 0.0, 0.0, 8.97997772825748, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11734754298611e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239551, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229247, -2.78313372537744, -0.524404424085079, 0.370809924354776, 11.1242977306435, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656967, 0.114434427054266, 0.840917865872084, 0.350641890608828, 0.0660687472643419, -0.0467176592151164, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912204761, 2.74642624930238, -0.792824967172091, 2.24244764232556, 2.14087209644419, -0.331662479035537, 6.49923072370879, 0.0957427107756343, -1.87616630392935, -2.15580611373101, 0.0, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932517, 0.590936840285277, 0.522319308773342, 0.0, 0.0, 1.63019078069772e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747036, 3.74574588632197, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789365, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 12.7134831207354, 1.01946290306866, 8.2065180664829, -0.63173805530579, 0.0483573714561638, -2.84282124887606, -0.227958835180084, 0.139595707137604, -0.0394836284566095, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715536, 1.16057691494799, 1.34011878852098, 1.89521416591737, 2.53311402559511, 1.96214168703485, 2.7464262493024, -0.566421515598883, 3.17129986868839, -1.82198870938951, 0.0, 0.0, 11.1699829238239, 0.0, 8.65223156827827, -0.865042958313586, 0.0, -2.49768411251821, -0.998865569685861, 0.441440386136648, 0.0, 0.0, 1.90161127277086e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.12790315683051e-14, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139074, -0.193429485824664, 3.55615782880926, 0.0, 0.0, 4.459640440343, 0.0, -0.85825820290699, 2.67027285925188, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03297925509764e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 7.03562363973515, 4.06201920231798, -0.820651806648291, 0.0, -6.79705818718656, -2.08116553882675, 5.88642506110458, -1.20156148406979, 0.242752078113811, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577677, 0.262202212042538, 5.13809303146605, -0.74161984870957, 0.151382517704875, -0.0305838870920605, 0.0, 1.01167199432803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614215, -2.69693703815182, 2.07610309995257, 1.46802658041887, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090393, -1.41130638568871, 0.0, 0.0, 0.0, 0.0, 13.4039795085887, 2.01017818278147, 0.0, 5.80409338312195, -1.54743588659732, 0.341938252770121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747035, 0.749149177264396, 2.75458800949268, 0.0, 1.12349008676759e-14, 5.75737105184052, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964687, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964686, 1.89521416591737, 0.0, 1.45082713966115e-14, 0.0, -3.39852909359329, -2.77488738510234, -0.5606119105814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.428174419288833, 0.349602949390052, 0.0706304617818625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32758182495306e-14, 0.0, 0.0, 0.0},
      {3.82970843102534, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171168, -4.07409060843207, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.7549743857359, 1.11676565710082, 0.987090711415294, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.32664991614217, -1.16809708692599e-14, 1.73008591662714, -3.18072425757423, 0.0, 1.0893489030894e-14, 0.0, 0.0, 7.67649473578741, -2.38836465270396, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 1.2485144121e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05299100428112e-14, 0.0, 1.09068140157585e-14, 0.0, 0.0, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630364, 0.0, 0.0, 0.0, 0.0, 1.47637052386759e-14, 9.57317681262153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20166278260625e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, -1.60347164931709e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 1.44913767461894, 4.18330013267038, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 7.09929573971953, 0.0, 4.34741302385684, 0.0, 0.0, -1.61480596362451e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, -1.31466507325082e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, -1.21243882593894e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474619, -0.999999999999998, 1.30930734141596, 7.09929573971953, -0.414039335605411, -2.04939015319192, -0.478091443733752, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.40824829046386, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600636, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033675, 4.38178046004133, -0.774596669241484, 0.0, 3.14233761939829, -0.106904496764966, 4.76235235991627, -0.740656079818039, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505162, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222144, 1.8516401995451, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922061358, -6.26099033699941, 0.0, 3.83405790253617, 0.0, 1.38492296223016e-14, 10.5830052442584, 0.0, 1.41526731116184e-14, 5.18459255872631, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499958, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824849, 0.0755928946018443, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 1.10729559076995e-14, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755172, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834956, 0.0, -6.26099033699941, 2.21359436211786, 0.0, 1.28098487007237e-14, 0.0, 0.0, 10.5830052442584, 2.99332590941916, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02980913200997e-14, 0.0, 0.0, 0.0},
      {5.71576766497731, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 1.73372856634452e-14, 12.6996062931101, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229245, -2.78313372537744, -0.524404424085075, 0.37080992435478, 1.23603308118261, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656969, 0.114434427054265, 0.840917865872086, 0.350641890608829, 0.0660687472643404, -0.0467176592151171, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930238, -0.79282496717209, 2.24244764232555, 2.14087209644419, -0.331662479035535, 6.49923072370878, 0.0957427107756321, -1.87616630392936, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932516, 0.590936840285278, 0.522319308773342, 0.0, 0.0, 1.15032771783196e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632197, -1.05945692672795, 0.404586796856339, 5.01426536422406, -0.383824736789359, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 2.82521847127454, -0.0509731451534319, 8.2065180664829, -0.631738055305791, 0.0483573714561628, -2.84282124887606, -0.227958835180081, 0.139595707137603, -0.0394836284566106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227874, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313572, 0.0, -2.49768411251822, -0.998865569685861, 0.441440386136646, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 1.00508909139074, -0.193429485824662, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034302, 0.0, -0.858258202906978, 2.67027285925187, 0.0, 0.0, 12.4373429638327, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190448, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 0.335029697130247, 4.06201920231798, -0.820651806648293, 0.0, 1.69926454679665, -0.0991031208965179, 5.88642506110458, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644417, 0.0124858196210744, 5.13809303146606, -0.741619848709572, 0.151382517704875, -0.0305838870920594, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614216, 0.299659670905759, 2.07610309995257, 1.46802658041887, 0.0, 0.868496237346891, 0.709124208342345, 1.31624465810882, 4.91295663090394, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102535, -0.22335313142017, 0.0, 5.80409338312195, -1.54743588659733, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 0.259512887494073, 0.749149177264395, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036809, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196468, 7.62808987244125, 0.0, 3.11415464992884, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2942239872397e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577669, 0.0, 2.68023757704196, -0.473803541479347, 0.0, 1.64767592289181e-14, -1.02022867713368e-14, 5.09779364038994, -0.792824967172095, 0.140152977645347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933263, 0.0998865569685854, -0.0176576154454661, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205055, 0.0, 1.49829835452879, 0.847565541382358, 0.0, 2.13197388895806e-14, 0.0, 1.62843044502543, 3.54562104171167, -0.814818121686423, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710081, 0.197418142283058, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071083, 0.0, 0.692034366650855, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212812, 3.07059789431496, 1.19418232635198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309061, 0.0, 7.62808987244125, 1.79795802543455, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451479, 0.0, 0.0, 1.19811444974696e-14, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29775342561708e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382572, 0.0231840235981022, -0.0133853022652629, 0.0189296759999983, 0.0433733365754904, -0.0335968420452646, -0.0274317066599275, 0.0193971457987549, 0.01583770322444, 0.0111989473484215, 0.0268774736362117, -0.0227156111999979, 0.00327871606028142, 0.0175954367753029, -0.00253968253968256, -0.0124418526617558, -0.0101587301587302, 0.00146628639794191, 0.00718330698348239, 0.00761904761904762, 0.0, 0.0, 0.0243115896447228, 0.0, -0.0205470434274512, -0.031634242810373, 0.0, 0.0159156714016638, 0.0245037791148913, 0.026259518075591, 0.0, -0.00918891716808422, -0.0141472634681456, -0.0151609398297323, -0.0122518895574456};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0251891949326e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.00840190190275e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.11022302462516e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661992, 0.0, -1.80596278672359e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, -3.40724761118906e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34211460084998e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.74113374895575e-14, 0.0, 0.0, 0.0, 0.0, -1.03967692597581e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027551, 0.565685424949246, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556635, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.77635683940025e-14, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.03666983567529e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18118899707127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008266, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983253, -1.48131215963608, 0.261861468283195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362399, 0.0, 3.16227766016838, 4.91934955049954, 0.0, 0.0, -1.64426494173481e-14, 0.0, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09141975464799e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, -2.08408744132326e-14, 0.0, 1.14299562489344e-14, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.23340030410525e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.20651414332819e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.60576914948, 0.0, 0.0, 0.0, -4.20458932936042, -3.43303281162799, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841197, 0.529728463363979, 0.432521479156788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171168, -2.50713268211203, 4.78713553878169, 0.0, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709561, 0.0, 18.8034951158402, -0.603122387046457, 0.0, 0.0, 0.0, 1.68183573174417, 0.701283781217658, 0.132137494528683, -0.0934353184302338, 0.0, 0.0, 0.0, 0.0, 1.01657368639936e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095217, 0.0, -1.58564993434418, 4.48489528465111, 4.28174419288838, 0.0, 1.39181061118525e-14, 0.191485421551267, -3.75233260785873, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, -1.38212051998442e-14, 0.0, 0.844371341865037, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 2.04801801850478e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.59512887494071, 0.0, 0.0, 0.0, 10.0285307284481, -0.767649473578741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.096714742912332, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.92428337406971, 5.49285249860477, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08625016632142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278147, 0.0, 0.0, 0.0, 1.37682944358601e-14, 8.91928088068604, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483826, 0.0, 8.12403840463597, -1.64130361329659, 0.0, 1.94236371139386e-14, -1.2084492040842e-14, 11.7728501222092, -2.40312296813959, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741914, 0.30276503540975, -0.0611677741841197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990514, 2.93605316083774, 0.0, 0.0, 1.14892842931746e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6081867662439, -3.09487177319465, 0.68387650554024, 0.0, 0.0, 1.01609667611756e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29782505861522, 0.0, 1.49829835452878, 5.50917601898535, 0.0, 0.0, -3.31921990265919e-14, 0.0, 6.64803945320941, 4.13676892548487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.03538690111428e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 1.4986633192005e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.60576914948, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.39853957981253e-14, 0.0, 0.0, 0.0, 0.0, -1.02599765044344e-14, 1.32507554204647e-14, 1.33226762955019e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, -1.85543680054609e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 7.24568837309471, 4.18330013267038, -0.591607978309956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, -1.70362380559453e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106458, 0.0, 9.66091783079296, 0.683130051063978, 0.0, -1.11458385846514e-14, 1.90959259748689e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, -2.93971798753892e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32889602233148e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.51636339197811e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474619, -0.999999999999996, 9.16515138991168, 7.09929573971953, -0.414039335605403, -2.04939015319192, -0.478091443733749, 0.1690308509457, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974982, 2.12132034355964, -0.408248290463862, 3.17542648054295, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.79999999999999, -5.69209978830308, 4.38178046004133, -0.774596669241487, 0.0, 10.998181667894, 0.962140470884732, 4.76235235991626, -0.740656079818045, 0.130930734141592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824851, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, -1.04204372066163e-14, 0.0, 0.0, 5.1845925587263, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270662, 0.0, -3.16227766016838, -2.2360679774998, 0.0, 2.09911141082732e-14, -1.43433241843284e-14, 13.7477270848675, 0.534522483824851, 0.377964473009234, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.79999999999998, 0.0, 3.65148371670111, -2.84018778721877, 0.0, 0.0, 2.52373632039099e-14, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46002787799886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.76435655866528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.44821019466133e-14, 0.0, 0.0, 0.0},
      {2.20454076850487, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, -1.73899916117335e-14, 0.0, 0.0, 8.97997772825748, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11734754298611e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239551, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229247, -2.78313372537744, -0.524404424085079, 0.370809924354776, 11.1242977306435, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656967, 0.114434427054266, 0.840917865872084, 0.350641890608828, 0.0660687472643419, -0.0467176592151164, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912204761, 2.74642624930238, -0.792824967172091, 2.24244764232556, 2.14087209644419, -0.331662479035537, 6.49923072370879, 0.0957427107756343, -1.87616630392935, -2.15580611373101, 0.0, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932517, 0.590936840285277, 0.522319308773342, 0.0, 0.0, 1.63019078069772e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747036, 3.74574588632197, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789365, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 12.7134831207354, 1.01946290306866, 8.2065180664829, -0.63173805530579, 0.0483573714561638, -2.84282124887606, -0.227958835180084, 0.139595707137604, -0.0394836284566095, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715536, 1.16057691494799, 1.34011878852098, 1.89521416591737, 2.53311402559511, 1.96214168703485, 2.7464262493024, -0.566421515598883, 3.17129986868839, -1.82198870938951, 0.0, 0.0, 11.1699829238239, 0.0, 8.65223156827827, -0.865042958313586, 0.0, -2.49768411251821, -0.998865569685861, 0.441440386136648, 0.0, 0.0, 1.90161127277086e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.12790315683051e-14, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139074, -0.193429485824664, 3.55615782880926, 0.0, 0.0, 4.459640440343, 0.0, -0.85825820290699, 2.67027285925188, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03297925509764e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 7.03562363973515, 4.06201920231798, -0.820651806648291, 0.0, -6.79705818718656, -2.08116553882675, 5.88642506110458, -1.20156148406979, 0.242752078113811, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577677, 0.262202212042538, 5.13809303146605, -0.74161984870957, 0.151382517704875, -0.0305838870920605, 0.0, 1.01167199432803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614215, -2.69693703815182, 2.07610309995257, 1.46802658041887, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090393, -1.41130638568871, 0.0, 0.0, 0.0, 0.0, 13.4039795085887, 2.01017818278147, 0.0, 5.80409338312195, -1.54743588659732, 0.341938252770121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747035, 0.749149177264396, 2.75458800949268, 0.0, 1.12349008676759e-14, 5.75737105184052, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964687, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964686, 1.89521416591737, 0.0, 1.45082713966115e-14, 0.0, -3.39852909359329, -2.77488738510234, -0.5606119105814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.428174419288833, 0.349602949390052, 0.0706304617818625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32758182495306e-14, 0.0, 0.0, 0.0},
      {3.82970843102534, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171168, -4.07409060843207, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.7549743857359, 1.11676565710082, 0.987090711415294, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.32664991614217, -1.16809708692599e-14, 1.73008591662714, -3.18072425757423, 0.0, 1.0893489030894e-14, 0.0, 0.0, 7.67649473578741, -2.38836465270396, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 1.2485144121e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05299100428112e-14, 0.0, 1.09068140157585e-14, 0.0, 0.0, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630364, 0.0, 0.0, 0.0, 0.0, 1.47637052386759e-14, 9.57317681262153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20166278260625e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, -1.60347164931709e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 1.44913767461894, 4.18330013267038, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 7.09929573971953, 0.0, 4.34741302385684, 0.0, 0.0, -1.61480596362451e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, -1.31466507325082e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, -1.21243882593894e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474619, -0.999999999999998, 1.30930734141596, 7.09929573971953, -0.414039335605411, -2.04939015319192, -0.478091443733752, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.40824829046386, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600636, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033675, 4.38178046004133, -0.774596669241484, 0.0, 3.14233761939829, -0.106904496764966, 4.76235235991627, -0.740656079818039, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505162, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222144, 1.8516401995451, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922061358, -6.26099033699941, 0.0, 3.83405790253617, 0.0, 1.38492296223016e-14, 10.5830052442584, 0.0, 1.41526731116184e-14, 5.18459255872631, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499958, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824849, 0.0755928946018443, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 1.10729559076995e-14, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755172, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834956, 0.0, -6.26099033699941, 2.21359436211786, 0.0, 1.28098487007237e-14, 0.0, 0.0, 10.5830052442584, 2.99332590941916, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02980913200997e-14, 0.0, 0.0, 0.0},
      {5.71576766497731, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 1.73372856634452e-14, 12.6996062931101, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229245, -2.78313372537744, -0.524404424085075, 0.37080992435478, 1.23603308118261, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656969, 0.114434427054265, 0.840917865872086, 0.350641890608829, 0.0660687472643404, -0.0467176592151171, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930238, -0.79282496717209, 2.24244764232555, 2.14087209644419, -0.331662479035535, 6.49923072370878, 0.0957427107756321, -1.87616630392936, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932516, 0.590936840285278, 0.522319308773342, 0.0, 0.0, 1.15032771783196e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632197, -1.05945692672795, 0.404586796856339, 5.01426536422406, -0.383824736789359, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 2.82521847127454, -0.0509731451534319, 8.2065180664829, -0.631738055305791, 0.0483573714561628, -2.84282124887606, -0.227958835180081, 0.139595707137603, -0.0394836284566106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227874, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313572, 0.0, -2.49768411251822, -0.998865569685861, 0.441440386136646, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 1.00508909139074, -0.193429485824662, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034302, 0.0, -0.858258202906978, 2.67027285925187, 0.0, 0.0, 12.4373429638327, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190448, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 0.335029697130247, 4.06201920231798, -0.820651806648293, 0.0, 1.69926454679665, -0.0991031208965179, 5.88642506110458, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644417, 0.0124858196210744, 5.13809303146606, -0.741619848709572, 0.151382517704875, -0.0305838870920594, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614216, 0.299659670905759, 2.07610309995257, 1.46802658041887, 0.0, 0.868496237346891, 0.709124208342345, 1.31624465810882, 4.91295663090394, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102535, -0.22335313142017, 0.0, 5.80409338312195, -1.54743588659733, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 0.259512887494073, 0.749149177264395, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036809, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196468, 7.62808987244125, 0.0, 3.11415464992884, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2942239872397e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577669, 0.0, 2.68023757704196, -0.473803541479347, 0.0, 1.64767592289181e-14, -1.02022867713368e-14, 5.09779364038994, -0.792824967172095, 0.140152977645347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933263, 0.0998865569685854, -0.0176576154454661, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205055, 0.0, 1.49829835452879, 0.847565541382358, 0.0, 2.13197388895806e-14, 0.0, 1.62843044502543, 3.54562104171167, -0.814818121686423, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710081, 0.197418142283058, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071083, 0.0, 0.692034366650855, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212812, 3.07059789431496, 1.19418232635198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309061, 0.0, 7.62808987244125, 1.79795802543455, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451479, 0.0, 0.0, 1.19811444974696e-14, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29775342561708e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.032991443953693, -0.0173880176985767, 0.0100389766989472, -0.0141972569999986, -0.00722888942924837, 0.00559947367421079, 0.0617213399848368, -0.0032328576331258, -0.0356348322549899, -0.0503952630678969, 0.0, 0.0, 0.0344265186329548, 0.0, -0.0266666666666667, 0.00933138949631687, 0.0, 0.01539600717839, -0.00538748023761179, -0.0190476190476191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0369066166121018, 0.0, 0.0, -0.0285877423007065, -0.052519036151182, 0.0, 0.0, 0.0165051407128365, 0.0303218796594646, 0.0306297238936141};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0251891949326e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.00840190190275e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.11022302462516e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661992, 0.0, -1.80596278672359e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, -3.40724761118906e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34211460084998e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.74113374895575e-14, 0.0, 0.0, 0.0, 0.0, -1.03967692597581e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027551, 0.565685424949246, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556635, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.77635683940025e-14, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.03666983567529e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18118899707127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008266, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983253, -1.48131215963608, 0.261861468283195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362399, 0.0, 3.16227766016838, 4.91934955049954, 0.0, 0.0, -1.64426494173481e-14, 0.0, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09141975464799e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, -2.08408744132326e-14, 0.0, 1.14299562489344e-14, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.23340030410525e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.20651414332819e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.60576914948, 0.0, 0.0, 0.0, -4.20458932936042, -3.43303281162799, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841197, 0.529728463363979, 0.432521479156788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171168, -2.50713268211203, 4.78713553878169, 0.0, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709561, 0.0, 18.8034951158402, -0.603122387046457, 0.0, 0.0, 0.0, 1.68183573174417, 0.701283781217658, 0.132137494528683, -0.0934353184302338, 0.0, 0.0, 0.0, 0.0, 1.01657368639936e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095217, 0.0, -1.58564993434418, 4.48489528465111, 4.28174419288838, 0.0, 1.39181061118525e-14, 0.191485421551267, -3.75233260785873, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, -1.38212051998442e-14, 0.0, 0.844371341865037, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 2.04801801850478e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.59512887494071, 0.0, 0.0, 0.0, 10.0285307284481, -0.767649473578741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.096714742912332, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.92428337406971, 5.49285249860477, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08625016632142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278147, 0.0, 0.0, 0.0, 1.37682944358601e-14, 8.91928088068604, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483826, 0.0, 8.12403840463597, -1.64130361329659, 0.0, 1.94236371139386e-14, -1.2084492040842e-14, 11.7728501222092, -2.40312296813959, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741914, 0.30276503540975, -0.0611677741841197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990514, 2.93605316083774, 0.0, 0.0, 1.14892842931746e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6081867662439, -3.09487177319465, 0.68387650554024, 0.0, 0.0, 1.01609667611756e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29782505861522, 0.0, 1.49829835452878, 5.50917601898535, 0.0, 0.0, -3.31921990265919e-14, 0.0, 6.64803945320941, 4.13676892548487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.03538690111428e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 1.4986633192005e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.60576914948, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.39853957981253e-14, 0.0, 0.0, 0.0, 0.0, -1.02599765044344e-14, 1.32507554204647e-14, 1.33226762955019e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, -1.85543680054609e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 7.24568837309471, 4.18330013267038, -0.591607978309956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, -1.70362380559453e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106458, 0.0, 9.66091783079296, 0.683130051063978, 0.0, -1.11458385846514e-14, 1.90959259748689e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, -2.93971798753892e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32889602233148e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.51636339197811e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474619, -0.999999999999996, 9.16515138991168, 7.09929573971953, -0.414039335605403, -2.04939015319192, -0.478091443733749, 0.1690308509457, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974982, 2.12132034355964, -0.408248290463862, 3.17542648054295, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.79999999999999, -5.69209978830308, 4.38178046004133, -0.774596669241487, 0.0, 10.998181667894, 0.962140470884732, 4.76235235991626, -0.740656079818045, 0.130930734141592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824851, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, -1.04204372066163e-14, 0.0, 0.0, 5.1845925587263, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270662, 0.0, -3.16227766016838, -2.2360679774998, 0.0, 2.09911141082732e-14, -1.43433241843284e-14, 13.7477270848675, 0.534522483824851, 0.377964473009234, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.79999999999998, 0.0, 3.65148371670111, -2.84018778721877, 0.0, 0.0, 2.52373632039099e-14, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46002787799886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.76435655866528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.44821019466133e-14, 0.0, 0.0, 0.0},
      {2.20454076850487, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, -1.73899916117335e-14, 0.0, 0.0, 8.97997772825748, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11734754298611e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239551, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229247, -2.78313372537744, -0.524404424085079, 0.370809924354776, 11.1242977306435, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656967, 0.114434427054266, 0.840917865872084, 0.350641890608828, 0.0660687472643419, -0.0467176592151164, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912204761, 2.74642624930238, -0.792824967172091, 2.24244764232556, 2.14087209644419, -0.331662479035537, 6.49923072370879, 0.0957427107756343, -1.87616630392935, -2.15580611373101, 0.0, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932517, 0.590936840285277, 0.522319308773342, 0.0, 0.0, 1.63019078069772e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747036, 3.74574588632197, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789365, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 12.7134831207354, 1.01946290306866, 8.2065180664829, -0.63173805530579, 0.0483573714561638, -2.84282124887606, -0.227958835180084, 0.139595707137604, -0.0394836284566095, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715536, 1.16057691494799, 1.34011878852098, 1.89521416591737, 2.53311402559511, 1.96214168703485, 2.7464262493024, -0.566421515598883, 3.17129986868839, -1.82198870938951, 0.0, 0.0, 11.1699829238239, 0.0, 8.65223156827827, -0.865042958313586, 0.0, -2.49768411251821, -0.998865569685861, 0.441440386136648, 0.0, 0.0, 1.90161127277086e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.12790315683051e-14, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139074, -0.193429485824664, 3.55615782880926, 0.0, 0.0, 4.459640440343, 0.0, -0.85825820290699, 2.67027285925188, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03297925509764e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 7.03562363973515, 4.06201920231798, -0.820651806648291, 0.0, -6.79705818718656, -2.08116553882675, 5.88642506110458, -1.20156148406979, 0.242752078113811, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577677, 0.262202212042538, 5.13809303146605, -0.74161984870957, 0.151382517704875, -0.0305838870920605, 0.0, 1.01167199432803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614215, -2.69693703815182, 2.07610309995257, 1.46802658041887, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090393, -1.41130638568871, 0.0, 0.0, 0.0, 0.0, 13.4039795085887, 2.01017818278147, 0.0, 5.80409338312195, -1.54743588659732, 0.341938252770121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747035, 0.749149177264396, 2.75458800949268, 0.0, 1.12349008676759e-14, 5.75737105184052, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964687, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964686, 1.89521416591737, 0.0, 1.45082713966115e-14, 0.0, -3.39852909359329, -2.77488738510234, -0.5606119105814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.428174419288833, 0.349602949390052, 0.0706304617818625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32758182495306e-14, 0.0, 0.0, 0.0},
      {3.82970843102534, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171168, -4.07409060843207, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.7549743857359, 1.11676565710082, 0.987090711415294, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.32664991614217, -1.16809708692599e-14, 1.73008591662714, -3.18072425757423, 0.0, 1.0893489030894e-14, 0.0, 0.0, 7.67649473578741, -2.38836465270396, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 1.2485144121e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05299100428112e-14, 0.0, 1.09068140157585e-14, 0.0, 0.0, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630364, 0.0, 0.0, 0.0, 0.0, 1.47637052386759e-14, 9.57317681262153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20166278260625e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, -1.60347164931709e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 1.44913767461894, 4.18330013267038, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 7.09929573971953, 0.0, 4.34741302385684, 0.0, 0.0, -1.61480596362451e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, -1.31466507325082e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, -1.21243882593894e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474619, -0.999999999999998, 1.30930734141596, 7.09929573971953, -0.414039335605411, -2.04939015319192, -0.478091443733752, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.40824829046386, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600636, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033675, 4.38178046004133, -0.774596669241484, 0.0, 3.14233761939829, -0.106904496764966, 4.76235235991627, -0.740656079818039, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505162, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222144, 1.8516401995451, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922061358, -6.26099033699941, 0.0, 3.83405790253617, 0.0, 1.38492296223016e-14, 10.5830052442584, 0.0, 1.41526731116184e-14, 5.18459255872631, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499958, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824849, 0.0755928946018443, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 1.10729559076995e-14, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755172, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834956, 0.0, -6.26099033699941, 2.21359436211786, 0.0, 1.28098487007237e-14, 0.0, 0.0, 10.5830052442584, 2.99332590941916, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02980913200997e-14, 0.0, 0.0, 0.0},
      {5.71576766497731, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 1.73372856634452e-14, 12.6996062931101, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229245, -2.78313372537744, -0.524404424085075, 0.37080992435478, 1.23603308118261, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656969, 0.114434427054265, 0.840917865872086, 0.350641890608829, 0.0660687472643404, -0.0467176592151171, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930238, -0.79282496717209, 2.24244764232555, 2.14087209644419, -0.331662479035535, 6.49923072370878, 0.0957427107756321, -1.87616630392936, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932516, 0.590936840285278, 0.522319308773342, 0.0, 0.0, 1.15032771783196e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632197, -1.05945692672795, 0.404586796856339, 5.01426536422406, -0.383824736789359, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 2.82521847127454, -0.0509731451534319, 8.2065180664829, -0.631738055305791, 0.0483573714561628, -2.84282124887606, -0.227958835180081, 0.139595707137603, -0.0394836284566106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227874, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313572, 0.0, -2.49768411251822, -0.998865569685861, 0.441440386136646, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 1.00508909139074, -0.193429485824662, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034302, 0.0, -0.858258202906978, 2.67027285925187, 0.0, 0.0, 12.4373429638327, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190448, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 0.335029697130247, 4.06201920231798, -0.820651806648293, 0.0, 1.69926454679665, -0.0991031208965179, 5.88642506110458, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644417, 0.0124858196210744, 5.13809303146606, -0.741619848709572, 0.151382517704875, -0.0305838870920594, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614216, 0.299659670905759, 2.07610309995257, 1.46802658041887, 0.0, 0.868496237346891, 0.709124208342345, 1.31624465810882, 4.91295663090394, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102535, -0.22335313142017, 0.0, 5.80409338312195, -1.54743588659733, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 0.259512887494073, 0.749149177264395, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036809, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196468, 7.62808987244125, 0.0, 3.11415464992884, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2942239872397e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577669, 0.0, 2.68023757704196, -0.473803541479347, 0.0, 1.64767592289181e-14, -1.02022867713368e-14, 5.09779364038994, -0.792824967172095, 0.140152977645347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933263, 0.0998865569685854, -0.0176576154454661, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205055, 0.0, 1.49829835452879, 0.847565541382358, 0.0, 2.13197388895806e-14, 0.0, 1.62843044502543, 3.54562104171167, -0.814818121686423, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710081, 0.197418142283058, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071083, 0.0, 0.692034366650855, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212812, 3.07059789431496, 1.19418232635198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309061, 0.0, 7.62808987244125, 1.79795802543455, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451479, 0.0, 0.0, 1.19811444974696e-14, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29775342561708e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382573, 0.0231840235981023, -0.013385302265263, 0.0189296759999982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0671936840905293, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0311046316543896, 0.0, 0.0, -0.017958267458706, 0.0253968253968254, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0437658634593183, 0.0, 0.0, 0.0, -0.0252682330495538, -0.0408396318581521};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0251891949326e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.00840190190275e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.11022302462516e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661992, 0.0, -1.80596278672359e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, -3.40724761118906e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34211460084998e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.74113374895575e-14, 0.0, 0.0, 0.0, 0.0, -1.03967692597581e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027551, 0.565685424949246, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556635, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.77635683940025e-14, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.03666983567529e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18118899707127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008266, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983253, -1.48131215963608, 0.261861468283195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362399, 0.0, 3.16227766016838, 4.91934955049954, 0.0, 0.0, -1.64426494173481e-14, 0.0, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09141975464799e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, -2.08408744132326e-14, 0.0, 1.14299562489344e-14, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.23340030410525e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.20651414332819e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.60576914948, 0.0, 0.0, 0.0, -4.20458932936042, -3.43303281162799, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841197, 0.529728463363979, 0.432521479156788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171168, -2.50713268211203, 4.78713553878169, 0.0, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709561, 0.0, 18.8034951158402, -0.603122387046457, 0.0, 0.0, 0.0, 1.68183573174417, 0.701283781217658, 0.132137494528683, -0.0934353184302338, 0.0, 0.0, 0.0, 0.0, 1.01657368639936e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095217, 0.0, -1.58564993434418, 4.48489528465111, 4.28174419288838, 0.0, 1.39181061118525e-14, 0.191485421551267, -3.75233260785873, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, -1.38212051998442e-14, 0.0, 0.844371341865037, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 2.04801801850478e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.59512887494071, 0.0, 0.0, 0.0, 10.0285307284481, -0.767649473578741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.096714742912332, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.92428337406971, 5.49285249860477, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08625016632142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278147, 0.0, 0.0, 0.0, 1.37682944358601e-14, 8.91928088068604, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483826, 0.0, 8.12403840463597, -1.64130361329659, 0.0, 1.94236371139386e-14, -1.2084492040842e-14, 11.7728501222092, -2.40312296813959, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741914, 0.30276503540975, -0.0611677741841197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990514, 2.93605316083774, 0.0, 0.0, 1.14892842931746e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6081867662439, -3.09487177319465, 0.68387650554024, 0.0, 0.0, 1.01609667611756e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29782505861522, 0.0, 1.49829835452878, 5.50917601898535, 0.0, 0.0, -3.31921990265919e-14, 0.0, 6.64803945320941, 4.13676892548487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.03538690111428e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 1.4986633192005e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.60576914948, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.39853957981253e-14, 0.0, 0.0, 0.0, 0.0, -1.02599765044344e-14, 1.32507554204647e-14, 1.33226762955019e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, -1.85543680054609e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 7.24568837309471, 4.18330013267038, -0.591607978309956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, -1.70362380559453e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106458, 0.0, 9.66091783079296, 0.683130051063978, 0.0, -1.11458385846514e-14, 1.90959259748689e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, -2.93971798753892e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32889602233148e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.51636339197811e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474619, -0.999999999999996, 9.16515138991168, 7.09929573971953, -0.414039335605403, -2.04939015319192, -0.478091443733749, 0.1690308509457, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974982, 2.12132034355964, -0.408248290463862, 3.17542648054295, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.79999999999999, -5.69209978830308, 4.38178046004133, -0.774596669241487, 0.0, 10.998181667894, 0.962140470884732, 4.76235235991626, -0.740656079818045, 0.130930734141592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824851, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, -1.04204372066163e-14, 0.0, 0.0, 5.1845925587263, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270662, 0.0, -3.16227766016838, -2.2360679774998, 0.0, 2.09911141082732e-14, -1.43433241843284e-14, 13.7477270848675, 0.534522483824851, 0.377964473009234, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.79999999999998, 0.0, 3.65148371670111, -2.84018778721877, 0.0, 0.0, 2.52373632039099e-14, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46002787799886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.76435655866528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.44821019466133e-14, 0.0, 0.0, 0.0},
      {2.20454076850487, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, -1.73899916117335e-14, 0.0, 0.0, 8.97997772825748, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11734754298611e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239551, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229247, -2.78313372537744, -0.524404424085079, 0.370809924354776, 11.1242977306435, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656967, 0.114434427054266, 0.840917865872084, 0.350641890608828, 0.0660687472643419, -0.0467176592151164, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912204761, 2.74642624930238, -0.792824967172091, 2.24244764232556, 2.14087209644419, -0.331662479035537, 6.49923072370879, 0.0957427107756343, -1.87616630392935, -2.15580611373101, 0.0, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932517, 0.590936840285277, 0.522319308773342, 0.0, 0.0, 1.63019078069772e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747036, 3.74574588632197, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789365, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 12.7134831207354, 1.01946290306866, 8.2065180664829, -0.63173805530579, 0.0483573714561638, -2.84282124887606, -0.227958835180084, 0.139595707137604, -0.0394836284566095, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715536, 1.16057691494799, 1.34011878852098, 1.89521416591737, 2.53311402559511, 1.96214168703485, 2.7464262493024, -0.566421515598883, 3.17129986868839, -1.82198870938951, 0.0, 0.0, 11.1699829238239, 0.0, 8.65223156827827, -0.865042958313586, 0.0, -2.49768411251821, -0.998865569685861, 0.441440386136648, 0.0, 0.0, 1.90161127277086e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.12790315683051e-14, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139074, -0.193429485824664, 3.55615782880926, 0.0, 0.0, 4.459640440343, 0.0, -0.85825820290699, 2.67027285925188, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03297925509764e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 7.03562363973515, 4.06201920231798, -0.820651806648291, 0.0, -6.79705818718656, -2.08116553882675, 5.88642506110458, -1.20156148406979, 0.242752078113811, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577677, 0.262202212042538, 5.13809303146605, -0.74161984870957, 0.151382517704875, -0.0305838870920605, 0.0, 1.01167199432803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614215, -2.69693703815182, 2.07610309995257, 1.46802658041887, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090393, -1.41130638568871, 0.0, 0.0, 0.0, 0.0, 13.4039795085887, 2.01017818278147, 0.0, 5.80409338312195, -1.54743588659732, 0.341938252770121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747035, 0.749149177264396, 2.75458800949268, 0.0, 1.12349008676759e-14, 5.75737105184052, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964687, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964686, 1.89521416591737, 0.0, 1.45082713966115e-14, 0.0, -3.39852909359329, -2.77488738510234, -0.5606119105814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.428174419288833, 0.349602949390052, 0.0706304617818625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32758182495306e-14, 0.0, 0.0, 0.0},
      {3.82970843102534, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171168, -4.07409060843207, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.7549743857359, 1.11676565710082, 0.987090711415294, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.32664991614217, -1.16809708692599e-14, 1.73008591662714, -3.18072425757423, 0.0, 1.0893489030894e-14, 0.0, 0.0, 7.67649473578741, -2.38836465270396, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 1.2485144121e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05299100428112e-14, 0.0, 1.09068140157585e-14, 0.0, 0.0, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630364, 0.0, 0.0, 0.0, 0.0, 1.47637052386759e-14, 9.57317681262153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20166278260625e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, -1.60347164931709e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 1.44913767461894, 4.18330013267038, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 7.09929573971953, 0.0, 4.34741302385684, 0.0, 0.0, -1.61480596362451e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, -1.31466507325082e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, -1.21243882593894e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474619, -0.999999999999998, 1.30930734141596, 7.09929573971953, -0.414039335605411, -2.04939015319192, -0.478091443733752, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.40824829046386, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600636, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033675, 4.38178046004133, -0.774596669241484, 0.0, 3.14233761939829, -0.106904496764966, 4.76235235991627, -0.740656079818039, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505162, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222144, 1.8516401995451, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922061358, -6.26099033699941, 0.0, 3.83405790253617, 0.0, 1.38492296223016e-14, 10.5830052442584, 0.0, 1.41526731116184e-14, 5.18459255872631, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499958, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824849, 0.0755928946018443, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 1.10729559076995e-14, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755172, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834956, 0.0, -6.26099033699941, 2.21359436211786, 0.0, 1.28098487007237e-14, 0.0, 0.0, 10.5830052442584, 2.99332590941916, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02980913200997e-14, 0.0, 0.0, 0.0},
      {5.71576766497731, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 1.73372856634452e-14, 12.6996062931101, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229245, -2.78313372537744, -0.524404424085075, 0.37080992435478, 1.23603308118261, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656969, 0.114434427054265, 0.840917865872086, 0.350641890608829, 0.0660687472643404, -0.0467176592151171, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930238, -0.79282496717209, 2.24244764232555, 2.14087209644419, -0.331662479035535, 6.49923072370878, 0.0957427107756321, -1.87616630392936, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932516, 0.590936840285278, 0.522319308773342, 0.0, 0.0, 1.15032771783196e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632197, -1.05945692672795, 0.404586796856339, 5.01426536422406, -0.383824736789359, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 2.82521847127454, -0.0509731451534319, 8.2065180664829, -0.631738055305791, 0.0483573714561628, -2.84282124887606, -0.227958835180081, 0.139595707137603, -0.0394836284566106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227874, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313572, 0.0, -2.49768411251822, -0.998865569685861, 0.441440386136646, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 1.00508909139074, -0.193429485824662, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034302, 0.0, -0.858258202906978, 2.67027285925187, 0.0, 0.0, 12.4373429638327, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190448, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 0.335029697130247, 4.06201920231798, -0.820651806648293, 0.0, 1.69926454679665, -0.0991031208965179, 5.88642506110458, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644417, 0.0124858196210744, 5.13809303146606, -0.741619848709572, 0.151382517704875, -0.0305838870920594, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614216, 0.299659670905759, 2.07610309995257, 1.46802658041887, 0.0, 0.868496237346891, 0.709124208342345, 1.31624465810882, 4.91295663090394, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102535, -0.22335313142017, 0.0, 5.80409338312195, -1.54743588659733, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 0.259512887494073, 0.749149177264395, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036809, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196468, 7.62808987244125, 0.0, 3.11415464992884, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2942239872397e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577669, 0.0, 2.68023757704196, -0.473803541479347, 0.0, 1.64767592289181e-14, -1.02022867713368e-14, 5.09779364038994, -0.792824967172095, 0.140152977645347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933263, 0.0998865569685854, -0.0176576154454661, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205055, 0.0, 1.49829835452879, 0.847565541382358, 0.0, 2.13197388895806e-14, 0.0, 1.62843044502543, 3.54562104171167, -0.814818121686423, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710081, 0.197418142283058, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071083, 0.0, 0.692034366650855, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212812, 3.07059789431496, 1.19418232635198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309061, 0.0, 7.62808987244125, 1.79795802543455, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451479, 0.0, 0.0, 1.19811444974696e-14, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29775342561708e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382572, 0.0231840235981023, 0.013385302265263, -0.0189296759999983, 0.0433733365754904, -0.0335968420452646, -0.0274317066599275, 0.0193971457987549, 0.01583770322444, 0.0111989473484216, 0.0268774736362117, 0.0, -0.0229510124219699, -0.0117302911835353, 0.00761904761904762, 0.0165891368823411, 0.0101587301587302, -0.00146628639794191, -0.0071833069834824, -0.00761904761904762, 0.0, 0.0241610520385245, -0.00270128773830253, -0.0357346778758831, -0.0114150241263618, 0.00395428035129662, 0.0355885231616696, 0.0159156714016638, 0.00306297238936141, -0.00375135972508442, -0.0228300482527235, -0.0112308987609918, -0.00353681586703639, 0.000721949515701544, 0.00204198159290761};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0251891949326e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.00840190190275e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.11022302462516e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661992, 0.0, -1.80596278672359e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, -3.40724761118906e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34211460084998e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.74113374895575e-14, 0.0, 0.0, 0.0, 0.0, -1.03967692597581e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027551, 0.565685424949246, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556635, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.77635683940025e-14, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.03666983567529e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18118899707127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008266, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983253, -1.48131215963608, 0.261861468283195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362399, 0.0, 3.16227766016838, 4.91934955049954, 0.0, 0.0, -1.64426494173481e-14, 0.0, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09141975464799e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, -2.08408744132326e-14, 0.0, 1.14299562489344e-14, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.23340030410525e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.20651414332819e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.60576914948, 0.0, 0.0, 0.0, -4.20458932936042, -3.43303281162799, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841197, 0.529728463363979, 0.432521479156788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171168, -2.50713268211203, 4.78713553878169, 0.0, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709561, 0.0, 18.8034951158402, -0.603122387046457, 0.0, 0.0, 0.0, 1.68183573174417, 0.701283781217658, 0.132137494528683, -0.0934353184302338, 0.0, 0.0, 0.0, 0.0, 1.01657368639936e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095217, 0.0, -1.58564993434418, 4.48489528465111, 4.28174419288838, 0.0, 1.39181061118525e-14, 0.191485421551267, -3.75233260785873, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, -1.38212051998442e-14, 0.0, 0.844371341865037, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 2.04801801850478e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.59512887494071, 0.0, 0.0, 0.0, 10.0285307284481, -0.767649473578741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.096714742912332, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.92428337406971, 5.49285249860477, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08625016632142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278147, 0.0, 0.0, 0.0, 1.37682944358601e-14, 8.91928088068604, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483826, 0.0, 8.12403840463597, -1.64130361329659, 0.0, 1.94236371139386e-14, -1.2084492040842e-14, 11.7728501222092, -2.40312296813959, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741914, 0.30276503540975, -0.0611677741841197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990514, 2.93605316083774, 0.0, 0.0, 1.14892842931746e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6081867662439, -3.09487177319465, 0.68387650554024, 0.0, 0.0, 1.01609667611756e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29782505861522, 0.0, 1.49829835452878, 5.50917601898535, 0.0, 0.0, -3.31921990265919e-14, 0.0, 6.64803945320941, 4.13676892548487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.03538690111428e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 1.4986633192005e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.60576914948, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.39853957981253e-14, 0.0, 0.0, 0.0, 0.0, -1.02599765044344e-14, 1.32507554204647e-14, 1.33226762955019e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, -1.85543680054609e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 7.24568837309471, 4.18330013267038, -0.591607978309956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, -1.70362380559453e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106458, 0.0, 9.66091783079296, 0.683130051063978, 0.0, -1.11458385846514e-14, 1.90959259748689e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, -2.93971798753892e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32889602233148e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.51636339197811e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474619, -0.999999999999996, 9.16515138991168, 7.09929573971953, -0.414039335605403, -2.04939015319192, -0.478091443733749, 0.1690308509457, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974982, 2.12132034355964, -0.408248290463862, 3.17542648054295, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.79999999999999, -5.69209978830308, 4.38178046004133, -0.774596669241487, 0.0, 10.998181667894, 0.962140470884732, 4.76235235991626, -0.740656079818045, 0.130930734141592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824851, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, -1.04204372066163e-14, 0.0, 0.0, 5.1845925587263, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270662, 0.0, -3.16227766016838, -2.2360679774998, 0.0, 2.09911141082732e-14, -1.43433241843284e-14, 13.7477270848675, 0.534522483824851, 0.377964473009234, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.79999999999998, 0.0, 3.65148371670111, -2.84018778721877, 0.0, 0.0, 2.52373632039099e-14, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46002787799886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.76435655866528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.44821019466133e-14, 0.0, 0.0, 0.0},
      {2.20454076850487, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, -1.73899916117335e-14, 0.0, 0.0, 8.97997772825748, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11734754298611e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239551, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229247, -2.78313372537744, -0.524404424085079, 0.370809924354776, 11.1242977306435, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656967, 0.114434427054266, 0.840917865872084, 0.350641890608828, 0.0660687472643419, -0.0467176592151164, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912204761, 2.74642624930238, -0.792824967172091, 2.24244764232556, 2.14087209644419, -0.331662479035537, 6.49923072370879, 0.0957427107756343, -1.87616630392935, -2.15580611373101, 0.0, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932517, 0.590936840285277, 0.522319308773342, 0.0, 0.0, 1.63019078069772e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747036, 3.74574588632197, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789365, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 12.7134831207354, 1.01946290306866, 8.2065180664829, -0.63173805530579, 0.0483573714561638, -2.84282124887606, -0.227958835180084, 0.139595707137604, -0.0394836284566095, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715536, 1.16057691494799, 1.34011878852098, 1.89521416591737, 2.53311402559511, 1.96214168703485, 2.7464262493024, -0.566421515598883, 3.17129986868839, -1.82198870938951, 0.0, 0.0, 11.1699829238239, 0.0, 8.65223156827827, -0.865042958313586, 0.0, -2.49768411251821, -0.998865569685861, 0.441440386136648, 0.0, 0.0, 1.90161127277086e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.12790315683051e-14, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139074, -0.193429485824664, 3.55615782880926, 0.0, 0.0, 4.459640440343, 0.0, -0.85825820290699, 2.67027285925188, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03297925509764e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 7.03562363973515, 4.06201920231798, -0.820651806648291, 0.0, -6.79705818718656, -2.08116553882675, 5.88642506110458, -1.20156148406979, 0.242752078113811, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577677, 0.262202212042538, 5.13809303146605, -0.74161984870957, 0.151382517704875, -0.0305838870920605, 0.0, 1.01167199432803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614215, -2.69693703815182, 2.07610309995257, 1.46802658041887, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090393, -1.41130638568871, 0.0, 0.0, 0.0, 0.0, 13.4039795085887, 2.01017818278147, 0.0, 5.80409338312195, -1.54743588659732, 0.341938252770121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747035, 0.749149177264396, 2.75458800949268, 0.0, 1.12349008676759e-14, 5.75737105184052, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964687, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964686, 1.89521416591737, 0.0, 1.45082713966115e-14, 0.0, -3.39852909359329, -2.77488738510234, -0.5606119105814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.428174419288833, 0.349602949390052, 0.0706304617818625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32758182495306e-14, 0.0, 0.0, 0.0},
      {3.82970843102534, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171168, -4.07409060843207, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.7549743857359, 1.11676565710082, 0.987090711415294, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.32664991614217, -1.16809708692599e-14, 1.73008591662714, -3.18072425757423, 0.0, 1.0893489030894e-14, 0.0, 0.0, 7.67649473578741, -2.38836465270396, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 1.2485144121e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05299100428112e-14, 0.0, 1.09068140157585e-14, 0.0, 0.0, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630364, 0.0, 0.0, 0.0, 0.0, 1.47637052386759e-14, 9.57317681262153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20166278260625e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, -1.60347164931709e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 1.44913767461894, 4.18330013267038, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 7.09929573971953, 0.0, 4.34741302385684, 0.0, 0.0, -1.61480596362451e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, -1.31466507325082e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, -1.21243882593894e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474619, -0.999999999999998, 1.30930734141596, 7.09929573971953, -0.414039335605411, -2.04939015319192, -0.478091443733752, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.40824829046386, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600636, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033675, 4.38178046004133, -0.774596669241484, 0.0, 3.14233761939829, -0.106904496764966, 4.76235235991627, -0.740656079818039, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505162, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222144, 1.8516401995451, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922061358, -6.26099033699941, 0.0, 3.83405790253617, 0.0, 1.38492296223016e-14, 10.5830052442584, 0.0, 1.41526731116184e-14, 5.18459255872631, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499958, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824849, 0.0755928946018443, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 1.10729559076995e-14, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755172, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834956, 0.0, -6.26099033699941, 2.21359436211786, 0.0, 1.28098487007237e-14, 0.0, 0.0, 10.5830052442584, 2.99332590941916, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02980913200997e-14, 0.0, 0.0, 0.0},
      {5.71576766497731, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 1.73372856634452e-14, 12.6996062931101, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229245, -2.78313372537744, -0.524404424085075, 0.37080992435478, 1.23603308118261, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656969, 0.114434427054265, 0.840917865872086, 0.350641890608829, 0.0660687472643404, -0.0467176592151171, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930238, -0.79282496717209, 2.24244764232555, 2.14087209644419, -0.331662479035535, 6.49923072370878, 0.0957427107756321, -1.87616630392936, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932516, 0.590936840285278, 0.522319308773342, 0.0, 0.0, 1.15032771783196e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632197, -1.05945692672795, 0.404586796856339, 5.01426536422406, -0.383824736789359, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 2.82521847127454, -0.0509731451534319, 8.2065180664829, -0.631738055305791, 0.0483573714561628, -2.84282124887606, -0.227958835180081, 0.139595707137603, -0.0394836284566106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227874, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313572, 0.0, -2.49768411251822, -0.998865569685861, 0.441440386136646, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 1.00508909139074, -0.193429485824662, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034302, 0.0, -0.858258202906978, 2.67027285925187, 0.0, 0.0, 12.4373429638327, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190448, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 0.335029697130247, 4.06201920231798, -0.820651806648293, 0.0, 1.69926454679665, -0.0991031208965179, 5.88642506110458, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644417, 0.0124858196210744, 5.13809303146606, -0.741619848709572, 0.151382517704875, -0.0305838870920594, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614216, 0.299659670905759, 2.07610309995257, 1.46802658041887, 0.0, 0.868496237346891, 0.709124208342345, 1.31624465810882, 4.91295663090394, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102535, -0.22335313142017, 0.0, 5.80409338312195, -1.54743588659733, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 0.259512887494073, 0.749149177264395, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036809, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196468, 7.62808987244125, 0.0, 3.11415464992884, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2942239872397e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577669, 0.0, 2.68023757704196, -0.473803541479347, 0.0, 1.64767592289181e-14, -1.02022867713368e-14, 5.09779364038994, -0.792824967172095, 0.140152977645347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933263, 0.0998865569685854, -0.0176576154454661, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205055, 0.0, 1.49829835452879, 0.847565541382358, 0.0, 2.13197388895806e-14, 0.0, 1.62843044502543, 3.54562104171167, -0.814818121686423, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710081, 0.197418142283058, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071083, 0.0, 0.692034366650855, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212812, 3.07059789431496, 1.19418232635198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309061, 0.0, 7.62808987244125, 1.79795802543455, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451479, 0.0, 0.0, 1.19811444974696e-14, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29775342561708e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.032991443953693, -0.0173880176985768, -0.0100389766989472, 0.0141972569999986, -0.00722888942924841, 0.0615942104163185, -0.00685792666498186, -0.0614242950293905, -0.00395942580610997, 0.00559947367421077, 0.0, 0.0340734167999968, -0.00491807409042212, 0.0, -0.0266666666666667, 0.00933138949631687, -0.0152380952380953, 0.0175954367753029, 0.00538748023761179, -0.0076190476190476, 0.0, 0.0, 0.0, 0.0357346778758831, -0.00913201930108942, 0.00131809345043221, -0.0593142052694494, 0.0, 0.00714693557517662, -0.00250090648338962, 0.0456600965054471, 0.0040839631858152, -0.00471575448938187, -0.00144389903140308, 0.0020419815929076};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0251891949326e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.00840190190275e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.11022302462516e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661992, 0.0, -1.80596278672359e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, -3.40724761118906e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34211460084998e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.74113374895575e-14, 0.0, 0.0, 0.0, 0.0, -1.03967692597581e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027551, 0.565685424949246, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556635, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.77635683940025e-14, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.03666983567529e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18118899707127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008266, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983253, -1.48131215963608, 0.261861468283195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362399, 0.0, 3.16227766016838, 4.91934955049954, 0.0, 0.0, -1.64426494173481e-14, 0.0, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09141975464799e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, -2.08408744132326e-14, 0.0, 1.14299562489344e-14, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.23340030410525e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.20651414332819e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.60576914948, 0.0, 0.0, 0.0, -4.20458932936042, -3.43303281162799, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841197, 0.529728463363979, 0.432521479156788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171168, -2.50713268211203, 4.78713553878169, 0.0, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709561, 0.0, 18.8034951158402, -0.603122387046457, 0.0, 0.0, 0.0, 1.68183573174417, 0.701283781217658, 0.132137494528683, -0.0934353184302338, 0.0, 0.0, 0.0, 0.0, 1.01657368639936e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095217, 0.0, -1.58564993434418, 4.48489528465111, 4.28174419288838, 0.0, 1.39181061118525e-14, 0.191485421551267, -3.75233260785873, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, -1.38212051998442e-14, 0.0, 0.844371341865037, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 2.04801801850478e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.59512887494071, 0.0, 0.0, 0.0, 10.0285307284481, -0.767649473578741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.096714742912332, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.92428337406971, 5.49285249860477, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08625016632142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278147, 0.0, 0.0, 0.0, 1.37682944358601e-14, 8.91928088068604, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483826, 0.0, 8.12403840463597, -1.64130361329659, 0.0, 1.94236371139386e-14, -1.2084492040842e-14, 11.7728501222092, -2.40312296813959, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741914, 0.30276503540975, -0.0611677741841197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990514, 2.93605316083774, 0.0, 0.0, 1.14892842931746e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6081867662439, -3.09487177319465, 0.68387650554024, 0.0, 0.0, 1.01609667611756e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29782505861522, 0.0, 1.49829835452878, 5.50917601898535, 0.0, 0.0, -3.31921990265919e-14, 0.0, 6.64803945320941, 4.13676892548487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.03538690111428e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 1.4986633192005e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.60576914948, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.39853957981253e-14, 0.0, 0.0, 0.0, 0.0, -1.02599765044344e-14, 1.32507554204647e-14, 1.33226762955019e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, -1.85543680054609e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 7.24568837309471, 4.18330013267038, -0.591607978309956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, -1.70362380559453e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106458, 0.0, 9.66091783079296, 0.683130051063978, 0.0, -1.11458385846514e-14, 1.90959259748689e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, -2.93971798753892e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32889602233148e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.51636339197811e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474619, -0.999999999999996, 9.16515138991168, 7.09929573971953, -0.414039335605403, -2.04939015319192, -0.478091443733749, 0.1690308509457, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974982, 2.12132034355964, -0.408248290463862, 3.17542648054295, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.79999999999999, -5.69209978830308, 4.38178046004133, -0.774596669241487, 0.0, 10.998181667894, 0.962140470884732, 4.76235235991626, -0.740656079818045, 0.130930734141592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824851, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, -1.04204372066163e-14, 0.0, 0.0, 5.1845925587263, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270662, 0.0, -3.16227766016838, -2.2360679774998, 0.0, 2.09911141082732e-14, -1.43433241843284e-14, 13.7477270848675, 0.534522483824851, 0.377964473009234, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.79999999999998, 0.0, 3.65148371670111, -2.84018778721877, 0.0, 0.0, 2.52373632039099e-14, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46002787799886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.76435655866528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.44821019466133e-14, 0.0, 0.0, 0.0},
      {2.20454076850487, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, -1.73899916117335e-14, 0.0, 0.0, 8.97997772825748, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11734754298611e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239551, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229247, -2.78313372537744, -0.524404424085079, 0.370809924354776, 11.1242977306435, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656967, 0.114434427054266, 0.840917865872084, 0.350641890608828, 0.0660687472643419, -0.0467176592151164, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912204761, 2.74642624930238, -0.792824967172091, 2.24244764232556, 2.14087209644419, -0.331662479035537, 6.49923072370879, 0.0957427107756343, -1.87616630392935, -2.15580611373101, 0.0, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932517, 0.590936840285277, 0.522319308773342, 0.0, 0.0, 1.63019078069772e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747036, 3.74574588632197, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789365, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 12.7134831207354, 1.01946290306866, 8.2065180664829, -0.63173805530579, 0.0483573714561638, -2.84282124887606, -0.227958835180084, 0.139595707137604, -0.0394836284566095, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715536, 1.16057691494799, 1.34011878852098, 1.89521416591737, 2.53311402559511, 1.96214168703485, 2.7464262493024, -0.566421515598883, 3.17129986868839, -1.82198870938951, 0.0, 0.0, 11.1699829238239, 0.0, 8.65223156827827, -0.865042958313586, 0.0, -2.49768411251821, -0.998865569685861, 0.441440386136648, 0.0, 0.0, 1.90161127277086e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.12790315683051e-14, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139074, -0.193429485824664, 3.55615782880926, 0.0, 0.0, 4.459640440343, 0.0, -0.85825820290699, 2.67027285925188, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03297925509764e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 7.03562363973515, 4.06201920231798, -0.820651806648291, 0.0, -6.79705818718656, -2.08116553882675, 5.88642506110458, -1.20156148406979, 0.242752078113811, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577677, 0.262202212042538, 5.13809303146605, -0.74161984870957, 0.151382517704875, -0.0305838870920605, 0.0, 1.01167199432803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614215, -2.69693703815182, 2.07610309995257, 1.46802658041887, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090393, -1.41130638568871, 0.0, 0.0, 0.0, 0.0, 13.4039795085887, 2.01017818278147, 0.0, 5.80409338312195, -1.54743588659732, 0.341938252770121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747035, 0.749149177264396, 2.75458800949268, 0.0, 1.12349008676759e-14, 5.75737105184052, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964687, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964686, 1.89521416591737, 0.0, 1.45082713966115e-14, 0.0, -3.39852909359329, -2.77488738510234, -0.5606119105814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.428174419288833, 0.349602949390052, 0.0706304617818625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32758182495306e-14, 0.0, 0.0, 0.0},
      {3.82970843102534, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171168, -4.07409060843207, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.7549743857359, 1.11676565710082, 0.987090711415294, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.32664991614217, -1.16809708692599e-14, 1.73008591662714, -3.18072425757423, 0.0, 1.0893489030894e-14, 0.0, 0.0, 7.67649473578741, -2.38836465270396, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 1.2485144121e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05299100428112e-14, 0.0, 1.09068140157585e-14, 0.0, 0.0, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630364, 0.0, 0.0, 0.0, 0.0, 1.47637052386759e-14, 9.57317681262153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20166278260625e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, -1.60347164931709e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 1.44913767461894, 4.18330013267038, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 7.09929573971953, 0.0, 4.34741302385684, 0.0, 0.0, -1.61480596362451e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, -1.31466507325082e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, -1.21243882593894e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474619, -0.999999999999998, 1.30930734141596, 7.09929573971953, -0.414039335605411, -2.04939015319192, -0.478091443733752, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.40824829046386, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600636, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033675, 4.38178046004133, -0.774596669241484, 0.0, 3.14233761939829, -0.106904496764966, 4.76235235991627, -0.740656079818039, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505162, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222144, 1.8516401995451, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922061358, -6.26099033699941, 0.0, 3.83405790253617, 0.0, 1.38492296223016e-14, 10.5830052442584, 0.0, 1.41526731116184e-14, 5.18459255872631, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499958, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824849, 0.0755928946018443, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 1.10729559076995e-14, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755172, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834956, 0.0, -6.26099033699941, 2.21359436211786, 0.0, 1.28098487007237e-14, 0.0, 0.0, 10.5830052442584, 2.99332590941916, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02980913200997e-14, 0.0, 0.0, 0.0},
      {5.71576766497731, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 1.73372856634452e-14, 12.6996062931101, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229245, -2.78313372537744, -0.524404424085075, 0.37080992435478, 1.23603308118261, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656969, 0.114434427054265, 0.840917865872086, 0.350641890608829, 0.0660687472643404, -0.0467176592151171, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930238, -0.79282496717209, 2.24244764232555, 2.14087209644419, -0.331662479035535, 6.49923072370878, 0.0957427107756321, -1.87616630392936, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932516, 0.590936840285278, 0.522319308773342, 0.0, 0.0, 1.15032771783196e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632197, -1.05945692672795, 0.404586796856339, 5.01426536422406, -0.383824736789359, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 2.82521847127454, -0.0509731451534319, 8.2065180664829, -0.631738055305791, 0.0483573714561628, -2.84282124887606, -0.227958835180081, 0.139595707137603, -0.0394836284566106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227874, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313572, 0.0, -2.49768411251822, -0.998865569685861, 0.441440386136646, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 1.00508909139074, -0.193429485824662, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034302, 0.0, -0.858258202906978, 2.67027285925187, 0.0, 0.0, 12.4373429638327, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190448, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 0.335029697130247, 4.06201920231798, -0.820651806648293, 0.0, 1.69926454679665, -0.0991031208965179, 5.88642506110458, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644417, 0.0124858196210744, 5.13809303146606, -0.741619848709572, 0.151382517704875, -0.0305838870920594, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614216, 0.299659670905759, 2.07610309995257, 1.46802658041887, 0.0, 0.868496237346891, 0.709124208342345, 1.31624465810882, 4.91295663090394, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102535, -0.22335313142017, 0.0, 5.80409338312195, -1.54743588659733, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 0.259512887494073, 0.749149177264395, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036809, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196468, 7.62808987244125, 0.0, 3.11415464992884, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2942239872397e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577669, 0.0, 2.68023757704196, -0.473803541479347, 0.0, 1.64767592289181e-14, -1.02022867713368e-14, 5.09779364038994, -0.792824967172095, 0.140152977645347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933263, 0.0998865569685854, -0.0176576154454661, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205055, 0.0, 1.49829835452879, 0.847565541382358, 0.0, 2.13197388895806e-14, 0.0, 1.62843044502543, 3.54562104171167, -0.814818121686423, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710081, 0.197418142283058, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071083, 0.0, 0.692034366650855, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212812, 3.07059789431496, 1.19418232635198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309061, 0.0, 7.62808987244125, 1.79795802543455, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451479, 0.0, 0.0, 1.19811444974696e-14, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29775342561708e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382572, 0.0231840235981022, 0.0133853022652629, -0.0189296759999982, 0.0, 0.0, 0.0, 0.0581914373962647, -0.03167540644888, 0.0111989473484215, 0.0, 0.0, 0.0, 0.0293257279588381, -0.0101587301587302, 0.00207364211029263, 0.0101587301587302, -0.0219942959691286, 0.017958267458706, -0.00761904761904763, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0395428035129662, -0.017684079335182, 0.00612594477872281, -0.0012504532416948, -0.0456600965054471, 0.0142938711503532, 0.0, -0.00360974757850769, 0.00204198159290761};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0251891949326e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.00840190190275e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.11022302462516e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661992, 0.0, -1.80596278672359e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, -3.40724761118906e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34211460084998e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.74113374895575e-14, 0.0, 0.0, 0.0, 0.0, -1.03967692597581e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027551, 0.565685424949246, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556635, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.77635683940025e-14, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.03666983567529e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18118899707127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008266, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983253, -1.48131215963608, 0.261861468283195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362399, 0.0, 3.16227766016838, 4.91934955049954, 0.0, 0.0, -1.64426494173481e-14, 0.0, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09141975464799e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, -2.08408744132326e-14, 0.0, 1.14299562489344e-14, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.23340030410525e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.20651414332819e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.60576914948, 0.0, 0.0, 0.0, -4.20458932936042, -3.43303281162799, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841197, 0.529728463363979, 0.432521479156788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171168, -2.50713268211203, 4.78713553878169, 0.0, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709561, 0.0, 18.8034951158402, -0.603122387046457, 0.0, 0.0, 0.0, 1.68183573174417, 0.701283781217658, 0.132137494528683, -0.0934353184302338, 0.0, 0.0, 0.0, 0.0, 1.01657368639936e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095217, 0.0, -1.58564993434418, 4.48489528465111, 4.28174419288838, 0.0, 1.39181061118525e-14, 0.191485421551267, -3.75233260785873, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, -1.38212051998442e-14, 0.0, 0.844371341865037, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 2.04801801850478e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.59512887494071, 0.0, 0.0, 0.0, 10.0285307284481, -0.767649473578741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.096714742912332, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.92428337406971, 5.49285249860477, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08625016632142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278147, 0.0, 0.0, 0.0, 1.37682944358601e-14, 8.91928088068604, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483826, 0.0, 8.12403840463597, -1.64130361329659, 0.0, 1.94236371139386e-14, -1.2084492040842e-14, 11.7728501222092, -2.40312296813959, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741914, 0.30276503540975, -0.0611677741841197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990514, 2.93605316083774, 0.0, 0.0, 1.14892842931746e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6081867662439, -3.09487177319465, 0.68387650554024, 0.0, 0.0, 1.01609667611756e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29782505861522, 0.0, 1.49829835452878, 5.50917601898535, 0.0, 0.0, -3.31921990265919e-14, 0.0, 6.64803945320941, 4.13676892548487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.03538690111428e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 1.4986633192005e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.60576914948, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.39853957981253e-14, 0.0, 0.0, 0.0, 0.0, -1.02599765044344e-14, 1.32507554204647e-14, 1.33226762955019e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, -1.85543680054609e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 7.24568837309471, 4.18330013267038, -0.591607978309956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, -1.70362380559453e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106458, 0.0, 9.66091783079296, 0.683130051063978, 0.0, -1.11458385846514e-14, 1.90959259748689e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, -2.93971798753892e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32889602233148e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.51636339197811e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474619, -0.999999999999996, 9.16515138991168, 7.09929573971953, -0.414039335605403, -2.04939015319192, -0.478091443733749, 0.1690308509457, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974982, 2.12132034355964, -0.408248290463862, 3.17542648054295, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.79999999999999, -5.69209978830308, 4.38178046004133, -0.774596669241487, 0.0, 10.998181667894, 0.962140470884732, 4.76235235991626, -0.740656079818045, 0.130930734141592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824851, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, -1.04204372066163e-14, 0.0, 0.0, 5.1845925587263, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270662, 0.0, -3.16227766016838, -2.2360679774998, 0.0, 2.09911141082732e-14, -1.43433241843284e-14, 13.7477270848675, 0.534522483824851, 0.377964473009234, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.79999999999998, 0.0, 3.65148371670111, -2.84018778721877, 0.0, 0.0, 2.52373632039099e-14, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46002787799886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.76435655866528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.44821019466133e-14, 0.0, 0.0, 0.0},
      {2.20454076850487, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, -1.73899916117335e-14, 0.0, 0.0, 8.97997772825748, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11734754298611e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239551, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229247, -2.78313372537744, -0.524404424085079, 0.370809924354776, 11.1242977306435, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656967, 0.114434427054266, 0.840917865872084, 0.350641890608828, 0.0660687472643419, -0.0467176592151164, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912204761, 2.74642624930238, -0.792824967172091, 2.24244764232556, 2.14087209644419, -0.331662479035537, 6.49923072370879, 0.0957427107756343, -1.87616630392935, -2.15580611373101, 0.0, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932517, 0.590936840285277, 0.522319308773342, 0.0, 0.0, 1.63019078069772e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747036, 3.74574588632197, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789365, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 12.7134831207354, 1.01946290306866, 8.2065180664829, -0.63173805530579, 0.0483573714561638, -2.84282124887606, -0.227958835180084, 0.139595707137604, -0.0394836284566095, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715536, 1.16057691494799, 1.34011878852098, 1.89521416591737, 2.53311402559511, 1.96214168703485, 2.7464262493024, -0.566421515598883, 3.17129986868839, -1.82198870938951, 0.0, 0.0, 11.1699829238239, 0.0, 8.65223156827827, -0.865042958313586, 0.0, -2.49768411251821, -0.998865569685861, 0.441440386136648, 0.0, 0.0, 1.90161127277086e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.12790315683051e-14, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139074, -0.193429485824664, 3.55615782880926, 0.0, 0.0, 4.459640440343, 0.0, -0.85825820290699, 2.67027285925188, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03297925509764e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 7.03562363973515, 4.06201920231798, -0.820651806648291, 0.0, -6.79705818718656, -2.08116553882675, 5.88642506110458, -1.20156148406979, 0.242752078113811, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577677, 0.262202212042538, 5.13809303146605, -0.74161984870957, 0.151382517704875, -0.0305838870920605, 0.0, 1.01167199432803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614215, -2.69693703815182, 2.07610309995257, 1.46802658041887, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090393, -1.41130638568871, 0.0, 0.0, 0.0, 0.0, 13.4039795085887, 2.01017818278147, 0.0, 5.80409338312195, -1.54743588659732, 0.341938252770121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747035, 0.749149177264396, 2.75458800949268, 0.0, 1.12349008676759e-14, 5.75737105184052, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964687, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964686, 1.89521416591737, 0.0, 1.45082713966115e-14, 0.0, -3.39852909359329, -2.77488738510234, -0.5606119105814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.428174419288833, 0.349602949390052, 0.0706304617818625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32758182495306e-14, 0.0, 0.0, 0.0},
      {3.82970843102534, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171168, -4.07409060843207, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.7549743857359, 1.11676565710082, 0.987090711415294, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.32664991614217, -1.16809708692599e-14, 1.73008591662714, -3.18072425757423, 0.0, 1.0893489030894e-14, 0.0, 0.0, 7.67649473578741, -2.38836465270396, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 1.2485144121e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05299100428112e-14, 0.0, 1.09068140157585e-14, 0.0, 0.0, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630364, 0.0, 0.0, 0.0, 0.0, 1.47637052386759e-14, 9.57317681262153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20166278260625e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, -1.60347164931709e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 1.44913767461894, 4.18330013267038, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 7.09929573971953, 0.0, 4.34741302385684, 0.0, 0.0, -1.61480596362451e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, -1.31466507325082e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, -1.21243882593894e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474619, -0.999999999999998, 1.30930734141596, 7.09929573971953, -0.414039335605411, -2.04939015319192, -0.478091443733752, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.40824829046386, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600636, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033675, 4.38178046004133, -0.774596669241484, 0.0, 3.14233761939829, -0.106904496764966, 4.76235235991627, -0.740656079818039, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505162, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222144, 1.8516401995451, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922061358, -6.26099033699941, 0.0, 3.83405790253617, 0.0, 1.38492296223016e-14, 10.5830052442584, 0.0, 1.41526731116184e-14, 5.18459255872631, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499958, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824849, 0.0755928946018443, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 1.10729559076995e-14, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755172, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834956, 0.0, -6.26099033699941, 2.21359436211786, 0.0, 1.28098487007237e-14, 0.0, 0.0, 10.5830052442584, 2.99332590941916, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02980913200997e-14, 0.0, 0.0, 0.0},
      {5.71576766497731, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 1.73372856634452e-14, 12.6996062931101, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229245, -2.78313372537744, -0.524404424085075, 0.37080992435478, 1.23603308118261, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656969, 0.114434427054265, 0.840917865872086, 0.350641890608829, 0.0660687472643404, -0.0467176592151171, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930238, -0.79282496717209, 2.24244764232555, 2.14087209644419, -0.331662479035535, 6.49923072370878, 0.0957427107756321, -1.87616630392936, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932516, 0.590936840285278, 0.522319308773342, 0.0, 0.0, 1.15032771783196e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632197, -1.05945692672795, 0.404586796856339, 5.01426536422406, -0.383824736789359, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 2.82521847127454, -0.0509731451534319, 8.2065180664829, -0.631738055305791, 0.0483573714561628, -2.84282124887606, -0.227958835180081, 0.139595707137603, -0.0394836284566106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227874, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313572, 0.0, -2.49768411251822, -0.998865569685861, 0.441440386136646, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 1.00508909139074, -0.193429485824662, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034302, 0.0, -0.858258202906978, 2.67027285925187, 0.0, 0.0, 12.4373429638327, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190448, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 0.335029697130247, 4.06201920231798, -0.820651806648293, 0.0, 1.69926454679665, -0.0991031208965179, 5.88642506110458, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644417, 0.0124858196210744, 5.13809303146606, -0.741619848709572, 0.151382517704875, -0.0305838870920594, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614216, 0.299659670905759, 2.07610309995257, 1.46802658041887, 0.0, 0.868496237346891, 0.709124208342345, 1.31624465810882, 4.91295663090394, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102535, -0.22335313142017, 0.0, 5.80409338312195, -1.54743588659733, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 0.259512887494073, 0.749149177264395, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036809, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196468, 7.62808987244125, 0.0, 3.11415464992884, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2942239872397e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577669, 0.0, 2.68023757704196, -0.473803541479347, 0.0, 1.64767592289181e-14, -1.02022867713368e-14, 5.09779364038994, -0.792824967172095, 0.140152977645347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933263, 0.0998865569685854, -0.0176576154454661, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205055, 0.0, 1.49829835452879, 0.847565541382358, 0.0, 2.13197388895806e-14, 0.0, 1.62843044502543, 3.54562104171167, -0.814818121686423, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710081, 0.197418142283058, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071083, 0.0, 0.692034366650855, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212812, 3.07059789431496, 1.19418232635198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309061, 0.0, 7.62808987244125, 1.79795802543455, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451479, 0.0, 0.0, 1.19811444974696e-14, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29775342561708e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382571, -0.0231840235981022, -0.013385302265263, 0.0189296759999982, 0.0433733365754904, 0.0335968420452646, 0.0274317066599275, 0.0193971457987549, 0.01583770322444, 0.0111989473484216, -0.0268774736362117, -0.0227156111999978, 0.00327871606028142, -0.0175954367753029, 0.00253968253968254, 0.0124418526617558, -0.0101587301587302, 0.00146628639794191, 0.00718330698348238, 0.00761904761904764, 0.0, 0.0, -0.0243115896447228, 0.0, -0.0205470434274512, -0.031634242810373, 0.0, -0.0159156714016638, -0.0245037791148913, -0.026259518075591, 0.0, -0.00918891716808422, -0.0141472634681456, -0.0151609398297323, -0.0122518895574457};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0251891949326e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.00840190190275e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.11022302462516e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661992, 0.0, -1.80596278672359e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, -3.40724761118906e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34211460084998e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.74113374895575e-14, 0.0, 0.0, 0.0, 0.0, -1.03967692597581e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027551, 0.565685424949246, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556635, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.77635683940025e-14, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.03666983567529e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18118899707127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008266, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983253, -1.48131215963608, 0.261861468283195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362399, 0.0, 3.16227766016838, 4.91934955049954, 0.0, 0.0, -1.64426494173481e-14, 0.0, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09141975464799e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, -2.08408744132326e-14, 0.0, 1.14299562489344e-14, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.23340030410525e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.20651414332819e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.60576914948, 0.0, 0.0, 0.0, -4.20458932936042, -3.43303281162799, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841197, 0.529728463363979, 0.432521479156788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171168, -2.50713268211203, 4.78713553878169, 0.0, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709561, 0.0, 18.8034951158402, -0.603122387046457, 0.0, 0.0, 0.0, 1.68183573174417, 0.701283781217658, 0.132137494528683, -0.0934353184302338, 0.0, 0.0, 0.0, 0.0, 1.01657368639936e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095217, 0.0, -1.58564993434418, 4.48489528465111, 4.28174419288838, 0.0, 1.39181061118525e-14, 0.191485421551267, -3.75233260785873, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, -1.38212051998442e-14, 0.0, 0.844371341865037, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 2.04801801850478e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.59512887494071, 0.0, 0.0, 0.0, 10.0285307284481, -0.767649473578741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.096714742912332, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.92428337406971, 5.49285249860477, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08625016632142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278147, 0.0, 0.0, 0.0, 1.37682944358601e-14, 8.91928088068604, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483826, 0.0, 8.12403840463597, -1.64130361329659, 0.0, 1.94236371139386e-14, -1.2084492040842e-14, 11.7728501222092, -2.40312296813959, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741914, 0.30276503540975, -0.0611677741841197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990514, 2.93605316083774, 0.0, 0.0, 1.14892842931746e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6081867662439, -3.09487177319465, 0.68387650554024, 0.0, 0.0, 1.01609667611756e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29782505861522, 0.0, 1.49829835452878, 5.50917601898535, 0.0, 0.0, -3.31921990265919e-14, 0.0, 6.64803945320941, 4.13676892548487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.03538690111428e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 1.4986633192005e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.60576914948, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.39853957981253e-14, 0.0, 0.0, 0.0, 0.0, -1.02599765044344e-14, 1.32507554204647e-14, 1.33226762955019e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, -1.85543680054609e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 7.24568837309471, 4.18330013267038, -0.591607978309956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, -1.70362380559453e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106458, 0.0, 9.66091783079296, 0.683130051063978, 0.0, -1.11458385846514e-14, 1.90959259748689e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, -2.93971798753892e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32889602233148e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.51636339197811e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474619, -0.999999999999996, 9.16515138991168, 7.09929573971953, -0.414039335605403, -2.04939015319192, -0.478091443733749, 0.1690308509457, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974982, 2.12132034355964, -0.408248290463862, 3.17542648054295, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.79999999999999, -5.69209978830308, 4.38178046004133, -0.774596669241487, 0.0, 10.998181667894, 0.962140470884732, 4.76235235991626, -0.740656079818045, 0.130930734141592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824851, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, -1.04204372066163e-14, 0.0, 0.0, 5.1845925587263, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270662, 0.0, -3.16227766016838, -2.2360679774998, 0.0, 2.09911141082732e-14, -1.43433241843284e-14, 13.7477270848675, 0.534522483824851, 0.377964473009234, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.79999999999998, 0.0, 3.65148371670111, -2.84018778721877, 0.0, 0.0, 2.52373632039099e-14, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46002787799886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.76435655866528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.44821019466133e-14, 0.0, 0.0, 0.0},
      {2.20454076850487, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, -1.73899916117335e-14, 0.0, 0.0, 8.97997772825748, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11734754298611e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239551, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229247, -2.78313372537744, -0.524404424085079, 0.370809924354776, 11.1242977306435, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656967, 0.114434427054266, 0.840917865872084, 0.350641890608828, 0.0660687472643419, -0.0467176592151164, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912204761, 2.74642624930238, -0.792824967172091, 2.24244764232556, 2.14087209644419, -0.331662479035537, 6.49923072370879, 0.0957427107756343, -1.87616630392935, -2.15580611373101, 0.0, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932517, 0.590936840285277, 0.522319308773342, 0.0, 0.0, 1.63019078069772e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747036, 3.74574588632197, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789365, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 12.7134831207354, 1.01946290306866, 8.2065180664829, -0.63173805530579, 0.0483573714561638, -2.84282124887606, -0.227958835180084, 0.139595707137604, -0.0394836284566095, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715536, 1.16057691494799, 1.34011878852098, 1.89521416591737, 2.53311402559511, 1.96214168703485, 2.7464262493024, -0.566421515598883, 3.17129986868839, -1.82198870938951, 0.0, 0.0, 11.1699829238239, 0.0, 8.65223156827827, -0.865042958313586, 0.0, -2.49768411251821, -0.998865569685861, 0.441440386136648, 0.0, 0.0, 1.90161127277086e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.12790315683051e-14, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139074, -0.193429485824664, 3.55615782880926, 0.0, 0.0, 4.459640440343, 0.0, -0.85825820290699, 2.67027285925188, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03297925509764e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 7.03562363973515, 4.06201920231798, -0.820651806648291, 0.0, -6.79705818718656, -2.08116553882675, 5.88642506110458, -1.20156148406979, 0.242752078113811, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577677, 0.262202212042538, 5.13809303146605, -0.74161984870957, 0.151382517704875, -0.0305838870920605, 0.0, 1.01167199432803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614215, -2.69693703815182, 2.07610309995257, 1.46802658041887, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090393, -1.41130638568871, 0.0, 0.0, 0.0, 0.0, 13.4039795085887, 2.01017818278147, 0.0, 5.80409338312195, -1.54743588659732, 0.341938252770121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747035, 0.749149177264396, 2.75458800949268, 0.0, 1.12349008676759e-14, 5.75737105184052, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964687, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964686, 1.89521416591737, 0.0, 1.45082713966115e-14, 0.0, -3.39852909359329, -2.77488738510234, -0.5606119105814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.428174419288833, 0.349602949390052, 0.0706304617818625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32758182495306e-14, 0.0, 0.0, 0.0},
      {3.82970843102534, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171168, -4.07409060843207, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.7549743857359, 1.11676565710082, 0.987090711415294, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.32664991614217, -1.16809708692599e-14, 1.73008591662714, -3.18072425757423, 0.0, 1.0893489030894e-14, 0.0, 0.0, 7.67649473578741, -2.38836465270396, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 1.2485144121e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05299100428112e-14, 0.0, 1.09068140157585e-14, 0.0, 0.0, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630364, 0.0, 0.0, 0.0, 0.0, 1.47637052386759e-14, 9.57317681262153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20166278260625e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, -1.60347164931709e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 1.44913767461894, 4.18330013267038, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 7.09929573971953, 0.0, 4.34741302385684, 0.0, 0.0, -1.61480596362451e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, -1.31466507325082e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, -1.21243882593894e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474619, -0.999999999999998, 1.30930734141596, 7.09929573971953, -0.414039335605411, -2.04939015319192, -0.478091443733752, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.40824829046386, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600636, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033675, 4.38178046004133, -0.774596669241484, 0.0, 3.14233761939829, -0.106904496764966, 4.76235235991627, -0.740656079818039, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505162, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222144, 1.8516401995451, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922061358, -6.26099033699941, 0.0, 3.83405790253617, 0.0, 1.38492296223016e-14, 10.5830052442584, 0.0, 1.41526731116184e-14, 5.18459255872631, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499958, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824849, 0.0755928946018443, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 1.10729559076995e-14, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755172, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834956, 0.0, -6.26099033699941, 2.21359436211786, 0.0, 1.28098487007237e-14, 0.0, 0.0, 10.5830052442584, 2.99332590941916, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02980913200997e-14, 0.0, 0.0, 0.0},
      {5.71576766497731, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 1.73372856634452e-14, 12.6996062931101, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229245, -2.78313372537744, -0.524404424085075, 0.37080992435478, 1.23603308118261, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656969, 0.114434427054265, 0.840917865872086, 0.350641890608829, 0.0660687472643404, -0.0467176592151171, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930238, -0.79282496717209, 2.24244764232555, 2.14087209644419, -0.331662479035535, 6.49923072370878, 0.0957427107756321, -1.87616630392936, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932516, 0.590936840285278, 0.522319308773342, 0.0, 0.0, 1.15032771783196e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632197, -1.05945692672795, 0.404586796856339, 5.01426536422406, -0.383824736789359, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 2.82521847127454, -0.0509731451534319, 8.2065180664829, -0.631738055305791, 0.0483573714561628, -2.84282124887606, -0.227958835180081, 0.139595707137603, -0.0394836284566106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227874, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313572, 0.0, -2.49768411251822, -0.998865569685861, 0.441440386136646, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 1.00508909139074, -0.193429485824662, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034302, 0.0, -0.858258202906978, 2.67027285925187, 0.0, 0.0, 12.4373429638327, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190448, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 0.335029697130247, 4.06201920231798, -0.820651806648293, 0.0, 1.69926454679665, -0.0991031208965179, 5.88642506110458, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644417, 0.0124858196210744, 5.13809303146606, -0.741619848709572, 0.151382517704875, -0.0305838870920594, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614216, 0.299659670905759, 2.07610309995257, 1.46802658041887, 0.0, 0.868496237346891, 0.709124208342345, 1.31624465810882, 4.91295663090394, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102535, -0.22335313142017, 0.0, 5.80409338312195, -1.54743588659733, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 0.259512887494073, 0.749149177264395, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036809, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196468, 7.62808987244125, 0.0, 3.11415464992884, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2942239872397e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577669, 0.0, 2.68023757704196, -0.473803541479347, 0.0, 1.64767592289181e-14, -1.02022867713368e-14, 5.09779364038994, -0.792824967172095, 0.140152977645347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933263, 0.0998865569685854, -0.0176576154454661, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205055, 0.0, 1.49829835452879, 0.847565541382358, 0.0, 2.13197388895806e-14, 0.0, 1.62843044502543, 3.54562104171167, -0.814818121686423, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710081, 0.197418142283058, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071083, 0.0, 0.692034366650855, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212812, 3.07059789431496, 1.19418232635198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309061, 0.0, 7.62808987244125, 1.79795802543455, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451479, 0.0, 0.0, 1.19811444974696e-14, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29775342561708e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {-0.0329914439536931, 0.0173880176985767, 0.0100389766989473, -0.0141972569999987, -0.00722888942924837, -0.00559947367421079, -0.0617213399848368, -0.00323285763312578, -0.0356348322549899, -0.050395263067897, 0.0, 0.0, 0.0344265186329548, 0.0, 0.0266666666666667, -0.00933138949631689, 0.0, 0.01539600717839, -0.00538748023761179, -0.0190476190476191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0369066166121018, 0.0, 0.0, 0.0285877423007065, 0.052519036151182, 0.0, 0.0, 0.0165051407128365, 0.0303218796594646, 0.0306297238936141};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0251891949326e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.00840190190275e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.11022302462516e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661992, 0.0, -1.80596278672359e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, -3.40724761118906e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34211460084998e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.74113374895575e-14, 0.0, 0.0, 0.0, 0.0, -1.03967692597581e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027551, 0.565685424949246, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556635, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.77635683940025e-14, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.03666983567529e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18118899707127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008266, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983253, -1.48131215963608, 0.261861468283195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362399, 0.0, 3.16227766016838, 4.91934955049954, 0.0, 0.0, -1.64426494173481e-14, 0.0, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09141975464799e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, -2.08408744132326e-14, 0.0, 1.14299562489344e-14, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.23340030410525e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.20651414332819e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.60576914948, 0.0, 0.0, 0.0, -4.20458932936042, -3.43303281162799, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841197, 0.529728463363979, 0.432521479156788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171168, -2.50713268211203, 4.78713553878169, 0.0, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709561, 0.0, 18.8034951158402, -0.603122387046457, 0.0, 0.0, 0.0, 1.68183573174417, 0.701283781217658, 0.132137494528683, -0.0934353184302338, 0.0, 0.0, 0.0, 0.0, 1.01657368639936e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095217, 0.0, -1.58564993434418, 4.48489528465111, 4.28174419288838, 0.0, 1.39181061118525e-14, 0.191485421551267, -3.75233260785873, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, -1.38212051998442e-14, 0.0, 0.844371341865037, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 2.04801801850478e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.59512887494071, 0.0, 0.0, 0.0, 10.0285307284481, -0.767649473578741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.096714742912332, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.92428337406971, 5.49285249860477, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08625016632142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278147, 0.0, 0.0, 0.0, 1.37682944358601e-14, 8.91928088068604, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483826, 0.0, 8.12403840463597, -1.64130361329659, 0.0, 1.94236371139386e-14, -1.2084492040842e-14, 11.7728501222092, -2.40312296813959, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741914, 0.30276503540975, -0.0611677741841197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990514, 2.93605316083774, 0.0, 0.0, 1.14892842931746e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.6081867662439, -3.09487177319465, 0.68387650554024, 0.0, 0.0, 1.01609667611756e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29782505861522, 0.0, 1.49829835452878, 5.50917601898535, 0.0, 0.0, -3.31921990265919e-14, 0.0, 6.64803945320941, 4.13676892548487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.03538690111428e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 1.4986633192005e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.60576914948, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.39853957981253e-14, 0.0, 0.0, 0.0, 0.0, -1.02599765044344e-14, 1.32507554204647e-14, 1.33226762955019e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, -1.85543680054609e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 7.24568837309471, 4.18330013267038, -0.591607978309956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, -1.70362380559453e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106458, 0.0, 9.66091783079296, 0.683130051063978, 0.0, -1.11458385846514e-14, 1.90959259748689e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, -2.93971798753892e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32889602233148e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.51636339197811e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474619, -0.999999999999996, 9.16515138991168, 7.09929573971953, -0.414039335605403, -2.04939015319192, -0.478091443733749, 0.1690308509457, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974982, 2.12132034355964, -0.408248290463862, 3.17542648054295, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.79999999999999, -5.69209978830308, 4.38178046004133, -0.774596669241487, 0.0, 10.998181667894, 0.962140470884732, 4.76235235991626, -0.740656079818045, 0.130930734141592, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824851, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, -1.04204372066163e-14, 0.0, 0.0, 5.1845925587263, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270662, 0.0, -3.16227766016838, -2.2360679774998, 0.0, 2.09911141082732e-14, -1.43433241843284e-14, 13.7477270848675, 0.534522483824851, 0.377964473009234, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.79999999999998, 0.0, 3.65148371670111, -2.84018778721877, 0.0, 0.0, 2.52373632039099e-14, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46002787799886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.76435655866528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.44821019466133e-14, 0.0, 0.0, 0.0},
      {2.20454076850487, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, -1.73899916117335e-14, 0.0, 0.0, 8.97997772825748, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11734754298611e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239551, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229247, -2.78313372537744, -0.524404424085079, 0.370809924354776, 11.1242977306435, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656967, 0.114434427054266, 0.840917865872084, 0.350641890608828, 0.0660687472643419, -0.0467176592151164, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912204761, 2.74642624930238, -0.792824967172091, 2.24244764232556, 2.14087209644419, -0.331662479035537, 6.49923072370879, 0.0957427107756343, -1.87616630392935, -2.15580611373101, 0.0, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932517, 0.590936840285277, 0.522319308773342, 0.0, 0.0, 1.63019078069772e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747036, 3.74574588632197, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789365, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 12.7134831207354, 1.01946290306866, 8.2065180664829, -0.63173805530579, 0.0483573714561638, -2.84282124887606, -0.227958835180084, 0.139595707137604, -0.0394836284566095, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715536, 1.16057691494799, 1.34011878852098, 1.89521416591737, 2.53311402559511, 1.96214168703485, 2.7464262493024, -0.566421515598883, 3.17129986868839, -1.82198870938951, 0.0, 0.0, 11.1699829238239, 0.0, 8.65223156827827, -0.865042958313586, 0.0, -2.49768411251821, -0.998865569685861, 0.441440386136648, 0.0, 0.0, 1.90161127277086e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.12790315683051e-14, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139074, -0.193429485824664, 3.55615782880926, 0.0, 0.0, 4.459640440343, 0.0, -0.85825820290699, 2.67027285925188, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.03297925509764e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 7.03562363973515, 4.06201920231798, -0.820651806648291, 0.0, -6.79705818718656, -2.08116553882675, 5.88642506110458, -1.20156148406979, 0.242752078113811, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577677, 0.262202212042538, 5.13809303146605, -0.74161984870957, 0.151382517704875, -0.0305838870920605, 0.0, 1.01167199432803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614215, -2.69693703815182, 2.07610309995257, 1.46802658041887, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090393, -1.41130638568871, 0.0, 0.0, 0.0, 0.0, 13.4039795085887, 2.01017818278147, 0.0, 5.80409338312195, -1.54743588659732, 0.341938252770121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930761, 1.29756443747035, 0.749149177264396, 2.75458800949268, 0.0, 1.12349008676759e-14, 5.75737105184052, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964687, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964686, 1.89521416591737, 0.0, 1.45082713966115e-14, 0.0, -3.39852909359329, -2.77488738510234, -0.5606119105814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.428174419288833, 0.349602949390052, 0.0706304617818625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32758182495306e-14, 0.0, 0.0, 0.0},
      {3.82970843102534, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171168, -4.07409060843207, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.7549743857359, 1.11676565710082, 0.987090711415294, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.32664991614217, -1.16809708692599e-14, 1.73008591662714, -3.18072425757423, 0.0, 1.0893489030894e-14, 0.0, 0.0, 7.67649473578741, -2.38836465270396, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662073, 0.0, 0.0, 1.2485144121e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05299100428112e-14, 0.0, 1.09068140157585e-14, 0.0, 0.0, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630364, 0.0, 0.0, 0.0, 0.0, 1.47637052386759e-14, 9.57317681262153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0508909139074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.20166278260625e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0125945974663e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, -1.60347164931709e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747793, 1.44913767461894, 4.18330013267038, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 7.09929573971953, 0.0, 4.34741302385684, 0.0, 0.0, -1.61480596362451e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, -1.31466507325082e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, -1.21243882593894e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661992, 7.74596669241484, -1.2, -0.979795897113269, 0.346410161513776, 0.282842712474628, 0.200000000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474619, -0.999999999999998, 1.30930734141596, 7.09929573971953, -0.414039335605411, -2.04939015319192, -0.478091443733752, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.40824829046386, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600636, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033675, 4.38178046004133, -0.774596669241484, 0.0, 3.14233761939829, -0.106904496764966, 4.76235235991627, -0.740656079818039, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505162, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222144, 1.8516401995451, 0.0, 5.3452248382485, -1.20948631362952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922061358, -6.26099033699941, 0.0, 3.83405790253617, 0.0, 1.38492296223016e-14, 10.5830052442584, 0.0, 1.41526731116184e-14, 5.18459255872631, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499958, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824849, 0.0755928946018443, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 1.10729559076995e-14, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755172, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834956, 0.0, -6.26099033699941, 2.21359436211786, 0.0, 1.28098487007237e-14, 0.0, 0.0, 10.5830052442584, 2.99332590941916, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02980913200997e-14, 0.0, 0.0, 0.0},
      {5.71576766497731, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 1.73372856634452e-14, 12.6996062931101, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14},
      {2.56904651573301, 5.80288457473997, -2.01017818278147, -1.42141062443803, 8.14215222512715, -2.10229466468021, -1.71651640581399, 0.72825623434142, 0.59461872537907, 0.420458932936042, 9.81070843517429, -1.18450885369836, -1.02581475831037, 0.305838870920596, 0.264864231681988, 0.216260739578393, -0.105945692672795, -0.0917516612761786, -0.0749149177264399, -0.0529728463363993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105602, 2.39356776939085, 6.30376871403131, -0.908295106229245, -2.78313372537744, -0.524404424085075, 0.37080992435478, 1.23603308118261, 9.40174755792013, -0.301561193523229, -2.42752078113806, -0.794200206656969, 0.114434427054265, 0.840917865872086, 0.350641890608829, 0.0660687472643404, -0.0467176592151171, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930238, -0.79282496717209, 2.24244764232555, 2.14087209644419, -0.331662479035535, 6.49923072370878, 0.0957427107756321, -1.87616630392936, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932516, 0.590936840285278, 0.522319308773342, 0.0, 0.0, 1.15032771783196e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632197, -1.05945692672795, 0.404586796856339, 5.01426536422406, -0.383824736789359, 1.80936716113937, -1.1080065755349, 0.313391585264005, 0.0, 2.82521847127454, -0.0509731451534319, 8.2065180664829, -0.631738055305791, 0.0483573714561628, -2.84282124887606, -0.227958835180081, 0.139595707137603, -0.0394836284566106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227874, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313572, 0.0, -2.49768411251822, -0.998865569685861, 0.441440386136646, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 1.00508909139074, -0.193429485824662, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034302, 0.0, -0.858258202906978, 2.67027285925187, 0.0, 0.0, 12.4373429638327, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190448, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 0.335029697130247, 4.06201920231798, -0.820651806648293, 0.0, 1.69926454679665, -0.0991031208965179, 5.88642506110458, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644417, 0.0124858196210744, 5.13809303146606, -0.741619848709572, 0.151382517704875, -0.0305838870920594, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614216, 0.299659670905759, 2.07610309995257, 1.46802658041887, 0.0, 0.868496237346891, 0.709124208342345, 1.31624465810882, 4.91295663090394, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102535, -0.22335313142017, 0.0, 5.80409338312195, -1.54743588659733, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 0.259512887494073, 0.749149177264395, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036809, 0.0, 3.32401972660471, 2.06838446274244, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119209, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196468, 7.62808987244125, 0.0, 3.11415464992884, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2942239872397e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577669, 0.0, 2.68023757704196, -0.473803541479347, 0.0, 1.64767592289181e-14, -1.02022867713368e-14, 5.09779364038994, -0.792824967172095, 0.140152977645347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933263, 0.0998865569685854, -0.0176576154454661, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205055, 0.0, 1.49829835452879, 0.847565541382358, 0.0, 2.13197388895806e-14, 0.0, 1.62843044502543, 3.54562104171167, -0.814818121686423, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710081, 0.197418142283058, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071083, 0.0, 0.692034366650855, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212812, 3.07059789431496, 1.19418232635198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309061, 0.0, 7.62808987244125, 1.79795802543455, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451479, 0.0, 0.0, 1.19811444974696e-14, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29775342561708e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[35][35] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 35; t++)
        {
          for (unsigned int u = 0; u < 35; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 35; t++)
          {
            for (unsigned int u = 0; u < 35; u++)
            {
              for (unsigned int tu = 0; tu < 35; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 35; s++)
        {
          for (unsigned int t = 0; t < 35; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 15:
      {
        
      // Array of basisvalues
      double basisvalues[35] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[20] *= std::sqrt(123.75);
      
      // Table(s) of coefficients
      static const double coefficients0[35] = \
      {0.0439885919382571, -0.0231840235981022, -0.013385302265263, 0.0189296759999982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0671936840905293, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0311046316543896, 0.0, 0.0, -0.017958267458706, 0.0253968253968254, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0437658634593183, 0.0, 0.0, 0.0, -0.0252682330495538, -0.0408396318581521};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[35][35] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0251891949326e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.00840190190275e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.11022302462516e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661992, 0.0, -1.80596278672359e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, -3.40724761118906e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34211460084998e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.74113374895575e-14, 0.0, 0.0, 0.0, 0.0, -1.03967692597581e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027551, 0.565685424949246, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556635, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.77635683940025e-14, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 2.8421709430404e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.03666983567529e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18118899707127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008266, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983253, -1.48131215963608, 0.261861468283195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362399, 0.0, 3.16227766016838, 4.91934955049954, 0.0, 0.0, -1.64426494173481e-14, 0.0, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09141975464799e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, -2.08408744132326e-14, 0.0, 1.14299562489344e-14, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.23340030410525e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.20651414332819e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.60576914948, 0.0, 0.0, 0.0, -4.20458932936042, -3.43303281162799, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841197, 0.529728463363979, 0.432521479156788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171168, -2.50713268211203, 4.78713553878169, 0.0, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709561, 0.0, 18.8034951158402, -0.603122387046457, 0.0, 0.0, 0.0, 1.68183573174417, 0.701283781217658, 0.132137494528683, -0.0934353184302338, 0.0, 0.0, 0.0, 0.0, 1.01657368639936e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095217, 0.0, -1.58564993434418, 4.48489528465111, 4.28174419288838, 0.0, 1.39181061118525e-14, 0.191485421551267, -3.75233260785873, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, -1.38212051998442e-14, 0.0, 0.844371341865037, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 2.04801801850478e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.59512887494071, 0.0, 0.0, 0.0, 10.0285307284481, -0.767649473578741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.096714742912332, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.92428337406971, 5.49285249860477, 0.0, 1.99840144432528e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08625016632142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278147, 0.0, 0.0, 0.0, 1.37682944358601e-14, 8.91928088068604, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483826, 0.0, 8.12403840463597, -1.64130361329659, 0.0, 1.94236371139386e-14, -1.2084492040842e-14, 11.7728501222092, -2.40312296813959, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741914, 0.30276503540975, -0.0611677741841197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990514, 2.93605316083774, 0.0, 0.0, 1.