// An autogenerated docstringfile


// File: index.xml

// File: classdolfin_1_1ALE.xml
%feature("docstring") dolfin::ALE "

This class provides functionality useful for implementation of ALE
(Arbitrary Lagrangian-Eulerian) methods, in particular moving the
boundary vertices of a mesh and then interpolating the new coordinates
for the interior vertices accordingly.

C++ includes: ALE.h ";


// File: classdolfin_1_1Array.xml
%feature("docstring") dolfin::Array "

This class provides a simple wrapper for a pointer to an array. A
purpose of this class is to enable the simple and safe exchange of
data between C++ and Python.

C++ includes: Array.h ";

%feature("docstring")  dolfin::Array::Array "";

%feature("docstring")  dolfin::Array::Array "

Create array of size N. ";

%feature("docstring")  dolfin::Array::Array "

Copy constructor (arg name need to have a different name that 'x'). ";

%feature("docstring")  dolfin::Array::Array "

Construct array from a shared pointer. ";

%feature("docstring")  dolfin::Array::Array "

Construct array from a pointer. Array will not take ownership. ";

%feature("docstring")  dolfin::Array::~Array "

Destructor. ";

%feature("docstring")  dolfin::Array::update "

Construct array from a pointer. Array will not take ownership. ";

%feature("docstring")  dolfin::Array::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::Array::resize "

Resize array to size N. If size changes, contents will be destroyed.
";

%feature("docstring")  dolfin::Array::size "

Return size of array. ";

%feature("docstring")  dolfin::Array::zero "

Zero array. ";

%feature("docstring")  dolfin::Array::zero_eps "

Set entries which meet (abs(x[i]) < eps) to zero. ";

%feature("docstring")  dolfin::Array::min "

Return minimum value of array. ";

%feature("docstring")  dolfin::Array::max "

Return maximum value of array. ";

%feature("docstring")  dolfin::Array::data "

Return pointer to data (const version). ";

%feature("docstring")  dolfin::Array::data "

Return pointer to data (non-const version). ";

%feature("docstring")  dolfin::Array::zero_eps "";


// File: classdolfin_1_1Assembler.xml
%feature("docstring") dolfin::Assembler "

This class provides automated assembly of linear systems, or more
generally, assembly of a sparse tensor from a given variational form.

The MeshFunction arguments can be used to specify assembly over
subdomains of the mesh cells, exterior facets or interior facets.
Either a null pointer or an empty MeshFunction may be used to specify
that the tensor should be assembled over the entire set of cells or
facets.

C++ includes: Assembler.h ";


// File: classdolfin_1_1BasisFunction.xml
%feature("docstring") dolfin::BasisFunction "

This class represents a finite element basis function. It can be used
for computation of basis function values and derivatives.

Evaluation of basis functions is also possible through the use of the
functions evaluate_basis and evaluate_basis_derivatives available in
the FiniteElement class. The BasisFunction class relies on these
functions for evaluation but also implements the ufc::function
interface which allows evaluate_dof to be evaluated for a basis
function (on a possibly different element).

C++ includes: BasisFunction.h ";

%feature("docstring")  dolfin::BasisFunction::BasisFunction "

Create basis function with given index on element on given cell. ";

%feature("docstring")  dolfin::BasisFunction::~BasisFunction "

Destructor. ";

%feature("docstring")  dolfin::BasisFunction::eval "

Evaluate basis function at given point. ";

%feature("docstring")  dolfin::BasisFunction::eval_derivatives "

Evaluate all order n derivatives at given point. ";

%feature("docstring")  dolfin::BasisFunction::evaluate "

Evaluate function at given point in cell. ";


// File: classdolfin_1_1BlockMatrix.xml
%feature("docstring") dolfin::BlockMatrix "";

%feature("docstring")  dolfin::BlockMatrix::BlockMatrix "";

%feature("docstring")  dolfin::BlockMatrix::~BlockMatrix "";

%feature("docstring")  dolfin::BlockMatrix::set "

Set block. ";

%feature("docstring")  dolfin::BlockMatrix::get "

Get block (const version). ";

%feature("docstring")  dolfin::BlockMatrix::get "

Get block. ";

%feature("docstring")  dolfin::BlockMatrix::size "

Return size of given dimension. ";

%feature("docstring")  dolfin::BlockMatrix::zero "

Set all entries to zero and keep any sparse structure. ";

%feature("docstring")  dolfin::BlockMatrix::apply "

Finalize assembly of tensor. ";

%feature("docstring")  dolfin::BlockMatrix::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::BlockMatrix::mult "

Matrix-vector product, y = Ax. ";


// File: classdolfin_1_1BlockVector.xml
%feature("docstring") dolfin::BlockVector "";

%feature("docstring")  dolfin::BlockVector::BlockVector "

Constructor. ";

%feature("docstring")  dolfin::BlockVector::~BlockVector "

Destructor. ";

%feature("docstring")  dolfin::BlockVector::copy "

Return copy of tensor. ";

%feature("docstring")  dolfin::BlockVector::set "

Set function. ";

%feature("docstring")  dolfin::BlockVector::get "

Get functions (const and non-const). ";

%feature("docstring")  dolfin::BlockVector::get "";

%feature("docstring")  dolfin::BlockVector::axpy "

Add multiple of given vector (AXPY operation). ";

%feature("docstring")  dolfin::BlockVector::inner "

Return inner product with given vector. ";

%feature("docstring")  dolfin::BlockVector::norm "

Return norm of vector. ";

%feature("docstring")  dolfin::BlockVector::min "

Return minimum value of vector. ";

%feature("docstring")  dolfin::BlockVector::max "

Return maximum value of vector. ";

%feature("docstring")  dolfin::BlockVector::size "

Number of vectors. ";

%feature("docstring")  dolfin::BlockVector::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1BoolParameter.xml
%feature("docstring") dolfin::BoolParameter "

Parameter with value type bool.

C++ includes: Parameter.h ";

%feature("docstring")  dolfin::BoolParameter::BoolParameter "

Create bool-valued parameter. ";

%feature("docstring")  dolfin::BoolParameter::~BoolParameter "

Destructor. ";

%feature("docstring")  dolfin::BoolParameter::type_str "

Return value type string. ";

%feature("docstring")  dolfin::BoolParameter::value_str "

Return value string. ";

%feature("docstring")  dolfin::BoolParameter::range_str "

Return range string. ";

%feature("docstring")  dolfin::BoolParameter::str "

Return short string description. ";


// File: classdolfin_1_1BoundaryCondition.xml
%feature("docstring") dolfin::BoundaryCondition "

Common base class for boundary conditions.

C++ includes: BoundaryCondition.h ";

%feature("docstring")  dolfin::BoundaryCondition::BoundaryCondition "

Constructor. ";

%feature("docstring")  dolfin::BoundaryCondition::BoundaryCondition "

Constructor. ";

%feature("docstring")  dolfin::BoundaryCondition::~BoundaryCondition "

Destructor. ";

%feature("docstring")  dolfin::BoundaryCondition::apply "

Apply boundary condition to a matrix. ";

%feature("docstring")  dolfin::BoundaryCondition::apply "

Apply boundary condition to a vector. ";

%feature("docstring")  dolfin::BoundaryCondition::apply "

Apply boundary condition to a linear system. ";

%feature("docstring")  dolfin::BoundaryCondition::apply "

Apply boundary condition to a vector for a nonlinear problem. ";

%feature("docstring")  dolfin::BoundaryCondition::apply "

Apply boundary condition to a linear system for a nonlinear problem.
";

%feature("docstring")  dolfin::BoundaryCondition::function_space "

Return function space. ";

%feature("docstring")  dolfin::BoundaryCondition::function_space_ptr "

Return shared pointer to function space. ";


// File: classdolfin_1_1BoundaryMesh.xml
%feature("docstring") dolfin::BoundaryMesh "

A BoundaryMesh is a mesh over the boundary of some given mesh.

C++ includes: BoundaryMesh.h ";

%feature("docstring")  dolfin::BoundaryMesh::BoundaryMesh "

Create an empty boundary mesh. ";

%feature("docstring")  dolfin::BoundaryMesh::BoundaryMesh "

Create (interior) boundary mesh from given mesh. ";

%feature("docstring")  dolfin::BoundaryMesh::~BoundaryMesh "

Destructor. ";

%feature("docstring")  dolfin::BoundaryMesh::init_exterior_boundary "

Initialize exterior boundary of given mesh. ";

%feature("docstring")  dolfin::BoundaryMesh::init_interior_boundary "

Initialize interior boundary of given mesh. ";


// File: classdolfin_1_1Box.xml
%feature("docstring") dolfin::Box "

Tetrahedral mesh of the 3D rectangular prism (x0, y0) x (x1, y1) x
(x2, y2). Given the number of cells (nx, ny, nz) in each direction,
the total number of tetrahedra will be 6*nx*ny*nz and the total number
of vertices will be (nx + 1)*(ny + 1)*(nz + 1).

C++ includes: Box.h ";

%feature("docstring")  dolfin::Box::Box "";


// File: classdolfin_1_1Cell.xml
%feature("docstring") dolfin::Cell "

A Cell is a MeshEntity of topological codimension 0.

C++ includes: Cell.h ";

%feature("docstring")  dolfin::Cell::Cell "

Create empty cell. ";

%feature("docstring")  dolfin::Cell::Cell "

Create cell on given mesh with given index. ";

%feature("docstring")  dolfin::Cell::~Cell "

Destructor. ";

%feature("docstring")  dolfin::Cell::type "

Return type of cell. ";

%feature("docstring")  dolfin::Cell::orientation "

Compute orientation of cell (0 is right, 1 is left). ";

%feature("docstring")  dolfin::Cell::volume "

Compute (generalized) volume of cell. ";

%feature("docstring")  dolfin::Cell::diameter "

Compute diameter of cell. ";

%feature("docstring")  dolfin::Cell::normal "

Compute component i of normal of given facet with respect to the cell.
";

%feature("docstring")  dolfin::Cell::normal "

Compute normal of given facet with respect to the cell. ";

%feature("docstring")  dolfin::Cell::facet_area "

Compute the area/length of given facet with respect to the cell. ";

%feature("docstring")  dolfin::Cell::order "

Order entities locally. ";

%feature("docstring")  dolfin::Cell::ordered "

Check if entities are ordered. ";


// File: classdolfin_1_1CellIterator.xml
%feature("docstring") dolfin::CellIterator "

A CellIterator is a MeshEntityIterator of topological codimension 0.

C++ includes: Cell.h ";

%feature("docstring")  dolfin::CellIterator::CellIterator "";

%feature("docstring")  dolfin::CellIterator::CellIterator "";

%feature("docstring")  dolfin::CellIterator::CellIterator "";


// File: classdolfin_1_1CellSize.xml
%feature("docstring") dolfin::CellSize "

This Function represents the local cell size on a given mesh.

C++ includes: SpecialFunctions.h ";

%feature("docstring")  dolfin::CellSize::CellSize "

Constructor. ";

%feature("docstring")  dolfin::CellSize::eval "

Evaluate function. ";


// File: classdolfin_1_1CellType.xml
%feature("docstring") dolfin::CellType "

This class provides a common interface for different cell types. Each
cell type implements mesh functionality that is specific to a certain
type of cell.

C++ includes: CellType.h ";

%feature("docstring")  dolfin::CellType::CellType "

Constructor. ";

%feature("docstring")  dolfin::CellType::~CellType "

Destructor. ";

%feature("docstring")  dolfin::CellType::cell_type "

Return type of cell. ";

%feature("docstring")  dolfin::CellType::facet_type "

Return type of cell for facets. ";

%feature("docstring")  dolfin::CellType::dim "

Return topological dimension of cell. ";

%feature("docstring")  dolfin::CellType::num_entities "

Return number of entitites of given topological dimension. ";

%feature("docstring")  dolfin::CellType::num_vertices "

Return number of vertices for entity of given topological dimension.
";

%feature("docstring")  dolfin::CellType::orientation "

Return orientation of the cell. ";

%feature("docstring")  dolfin::CellType::create_entities "

Create entities e of given topological dimension from vertices v. ";

%feature("docstring")  dolfin::CellType::refine_cell "

Refine cell uniformly. ";

%feature("docstring")  dolfin::CellType::volume "

Compute (generalized) volume of mesh entity. ";

%feature("docstring")  dolfin::CellType::diameter "

Compute diameter of mesh entity. ";

%feature("docstring")  dolfin::CellType::normal "

Compute component i of normal of given facet with respect to the cell.
";

%feature("docstring")  dolfin::CellType::normal "

Compute of given facet with respect to the cell. ";

%feature("docstring")  dolfin::CellType::facet_area "

Compute the area/length of given facet with respect to the cell. ";

%feature("docstring")  dolfin::CellType::order "

Order entities locally. ";

%feature("docstring")  dolfin::CellType::ordered "

Check if entities are ordered. ";

%feature("docstring")  dolfin::CellType::description "

Return description of cell type. ";


// File: classdolfin_1_1cGqMethod.xml
%feature("docstring") dolfin::cGqMethod "

Contains all numeric constants, such as nodal points and nodal
weights, needed for the cG(q) method. The order q must be at least 1.
Note that q refers to the polynomial order and not the order of
convergence for the method, which is 2q.

C++ includes: cGqMethod.h ";

%feature("docstring")  dolfin::cGqMethod::cGqMethod "";

%feature("docstring")  dolfin::cGqMethod::ueval "

Evaluate solution at given point. ";

%feature("docstring")  dolfin::cGqMethod::ueval "

Evaluate solution at given node (inline optimized). ";

%feature("docstring")  dolfin::cGqMethod::residual "

Compute residual at right end-point. ";

%feature("docstring")  dolfin::cGqMethod::timestep "

Compute new time step based on the given residual. ";

%feature("docstring")  dolfin::cGqMethod::error "

Compute error estimate (modulo stability factor). ";

%feature("docstring")  dolfin::cGqMethod::get_nodal_values "

Replace the solution values with the nodal values solution polynomial.
";

%feature("docstring")  dolfin::cGqMethod::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1CholmodCholeskySolver.xml
%feature("docstring") dolfin::CholmodCholeskySolver "

This class implements the direct solution (Cholesky factorization) of
linear systems of the form Ax = b. Sparse matrices are solved using
CHOLMODhttp://www.cise.ufl.edu/research/sparse/cholmod/ if installed.

C++ includes: CholmodCholeskySolver.h ";

%feature("docstring")
dolfin::CholmodCholeskySolver::CholmodCholeskySolver "

Constructor. ";

%feature("docstring")
dolfin::CholmodCholeskySolver::~CholmodCholeskySolver "

Destructor. ";

%feature("docstring")  dolfin::CholmodCholeskySolver::solve "

Solve linear system Ax = b for a sparse matrix using CHOLMOD. ";

%feature("docstring")  dolfin::CholmodCholeskySolver::factorize "

Cholesky-factor sparse matrix A if CHOLMOD is installed. ";

%feature("docstring")  dolfin::CholmodCholeskySolver::factorized_solve
"

Solve factorized system (CHOLMOD). ";


// File: classdolfin_1_1ComplexODE.xml
%feature("docstring") dolfin::ComplexODE "

A ComplexODE represents an initial value problem for a system of
complex-valued ordinary differential equations:

M(z, t) z'(t) = f(z(t), t) on (0,T]

z(0) = z0,

where z(t) is a complex-valued vector of length n. The imaginary unit
is provided by the member variable j satisfying j^2 = -1.

This class is a wrapper for a standard real-valued ODE, and provides
an interface that automatically translates the given complex-valued
ODE of size n to a standard real-valued ODE of size N = 2n.

The double and imaginary parts of the solution are stored in the
following order in the solution vector u(t):

u = (Re z0, Im z0, Re z1, Im z1, ..., Re z_n-1, Im z_n-1).

C++ includes: ComplexODE.h ";

%feature("docstring")  dolfin::ComplexODE::ComplexODE "

Constructor. ";

%feature("docstring")  dolfin::ComplexODE::~ComplexODE "

Destructor. ";

%feature("docstring")  dolfin::ComplexODE::z0 "

Set initial values. ";

%feature("docstring")  dolfin::ComplexODE::f "

Evaluate right-hand side (multi-adaptive version). ";

%feature("docstring")  dolfin::ComplexODE::f "

Evaluate right-hand side (mono-adaptive version). ";

%feature("docstring")  dolfin::ComplexODE::M "

Compute product y = Mx for implicit system. ";

%feature("docstring")  dolfin::ComplexODE::J "

Compute product y = Jx for Jacobian J. ";

%feature("docstring")  dolfin::ComplexODE::k "

Return time step for component i (optional). ";

%feature("docstring")  dolfin::ComplexODE::update "

Update ODE, return false to stop (optional). ";

%feature("docstring")  dolfin::ComplexODE::u0 "

Return initial value for real-valued ODE. ";

%feature("docstring")  dolfin::ComplexODE::f "

Return right-hand side for real-valued ODE. ";

%feature("docstring")  dolfin::ComplexODE::f "

Evaluate right-hand side for real-valued ODE. ";

%feature("docstring")  dolfin::ComplexODE::M "

Compute product y = Mx for real-valued ODE. ";

%feature("docstring")  dolfin::ComplexODE::J "

Compute product y = Jx for real-valued ODE. ";

%feature("docstring")  dolfin::ComplexODE::timestep "

Return time step for real-valued ODE. ";

%feature("docstring")  dolfin::ComplexODE::update "

Update for real-valued ODE. ";


// File: classdolfin_1_1Constant.xml
%feature("docstring") dolfin::Constant "

This class represents a constant-valued expression.

C++ includes: Constant.h ";

%feature("docstring")  dolfin::Constant::Constant "

Create scalar constant. ";

%feature("docstring")  dolfin::Constant::Constant "

Create vector constant (dim = 2). ";

%feature("docstring")  dolfin::Constant::Constant "

Create vector constant (dim = 3). ";

%feature("docstring")  dolfin::Constant::Constant "

Create vector-valued constant. ";

%feature("docstring")  dolfin::Constant::Constant "

Create tensor-valued constant for flattened array of values. ";

%feature("docstring")  dolfin::Constant::Constant "

Copy constructor. ";

%feature("docstring")  dolfin::Constant::~Constant "

Destructor. ";

%feature("docstring")  dolfin::Constant::eval "

Evaluate function. ";


// File: classdolfin_1_1Data.xml
%feature("docstring") dolfin::Data "

This class holds data for function evaluation, including the
coordinates x, the time t, and auxiliary data that a function may
depend on.

C++ includes: Data.h ";

%feature("docstring")  dolfin::Data::Data "

Constructor. ";

%feature("docstring")  dolfin::Data::~Data "

Destructor. ";

%feature("docstring")  dolfin::Data::cell "

Return current cell (if available). ";

%feature("docstring")  dolfin::Data::ufc_cell "

Return current UFC cell (if available). ";

%feature("docstring")  dolfin::Data::facet "

Return current facet (if available). ";

%feature("docstring")  dolfin::Data::normal "

Return current facet normal (if available). ";

%feature("docstring")  dolfin::Data::geometric_dimension "

Return geometric dimension of cell. ";

%feature("docstring")  dolfin::Data::on_facet "

Check if we are on a facet. ";

%feature("docstring")  dolfin::Data::set "

Set cell and facet data. ";

%feature("docstring")  dolfin::Data::set "

Set UFC cell and coordinate. ";

%feature("docstring")  dolfin::Data::set "";

%feature("docstring")  dolfin::Data::clear "

Clear all cell data. ";


// File: classdolfin_1_1DefaultFactory.xml
%feature("docstring") dolfin::DefaultFactory "";

%feature("docstring")  dolfin::DefaultFactory::DefaultFactory "

Constructor. ";

%feature("docstring")  dolfin::DefaultFactory::~DefaultFactory "

Destructor. ";

%feature("docstring")  dolfin::DefaultFactory::create_matrix "

Create empty matrix. ";

%feature("docstring")  dolfin::DefaultFactory::create_vector "

Create empty vector (global). ";

%feature("docstring")  dolfin::DefaultFactory::create_local_vector "

Create empty vector (local). ";

%feature("docstring")  dolfin::DefaultFactory::create_pattern "

Create empty sparsity pattern. ";


// File: classdolfin_1_1dGqMethod.xml
%feature("docstring") dolfin::dGqMethod "

Contains all numeric constants, such as nodal points and nodal
weights, needed for the dG(q) method. The order q must be at least 0.
Note that q refers to the polynomial order and not the order of
convergence for the method, which is 2q + 1.

C++ includes: dGqMethod.h ";

%feature("docstring")  dolfin::dGqMethod::dGqMethod "";

%feature("docstring")  dolfin::dGqMethod::ueval "

Evaluate solution at given point. ";

%feature("docstring")  dolfin::dGqMethod::ueval "

Evaluate solution at given node (inline optimized). ";

%feature("docstring")  dolfin::dGqMethod::residual "

Compute residual at right end-point. ";

%feature("docstring")  dolfin::dGqMethod::timestep "

Compute new time step based on the given residual. ";

%feature("docstring")  dolfin::dGqMethod::error "

Compute error estimate (modulo stability factor). ";

%feature("docstring")  dolfin::dGqMethod::get_nodal_values "

Get nodal values. ";

%feature("docstring")  dolfin::dGqMethod::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1DirichletBC.xml
%feature("docstring") dolfin::DirichletBC "

This class specifies the interface for setting (strong).

This class specifies the interface for setting (strong) Dirichlet
boundary conditions for partial differential equations,

u = g on G,

where u is the solution to be computed, g is a function and G is a sub
domain of the mesh.

A DirichletBC is specified by the function g, the function space
(trial space) and boundary indicators on (a subset of) the mesh
boundary.

The boundary indicators may be specified in a number of different
ways.

The simplest approach is to specify the boundary by a SubDomain
object, using the inside() function to specify on which facets the
boundary conditions should be applied.

Alternatively, the boundary may be specified by a MeshFunction
labeling all mesh facets together with a number that specifies which
facets should be included in the boundary.

The third option is to attach the boundary information to the mesh.
This is handled automatically when exporting a mesh from for example
VMTK.

The BCMethod variable may be used to specify the type of method used
to identify degrees of freedom on the boundary. Available methods are:
topological approach (default), geometric approach, and pointwise
approach. The topological approach is faster, but will only identify
degrees of freedom that are located on a facet that is entirely on the
boundary. In particular, the topological approach will not identify
degrees of freedom for discontinuous elements (which are all internal
to the cell). A remedy for this is to use the geometric approach. To
apply pointwise boundary conditions e.g. pointloads, one will have to
use the pointwise approach which in turn is the slowest of the three
possible methods. The three possibilties are \"topological\",
\"geometric\" and \"pointwise\".

C++ includes: DirichletBC.h ";

%feature("docstring")  dolfin::DirichletBC::DirichletBC "

Create boundary condition for subdomain. ";

%feature("docstring")  dolfin::DirichletBC::DirichletBC "

Create boundary condition for subdomain. ";

%feature("docstring")  dolfin::DirichletBC::DirichletBC "

Create boundary condition for subdomain specified by index. ";

%feature("docstring")  dolfin::DirichletBC::DirichletBC "

Create boundary condition for subdomain specified by index. ";

%feature("docstring")  dolfin::DirichletBC::DirichletBC "

Create boundary condition for boundary data included in the mesh. ";

%feature("docstring")  dolfin::DirichletBC::DirichletBC "

Create boundary condition for boundary data included in the mesh. ";

%feature("docstring")  dolfin::DirichletBC::DirichletBC "";

%feature("docstring")  dolfin::DirichletBC::DirichletBC "";

%feature("docstring")  dolfin::DirichletBC::DirichletBC "

Copy constructor. ";

%feature("docstring")  dolfin::DirichletBC::~DirichletBC "

Destructor. ";

%feature("docstring")  dolfin::DirichletBC::apply "

Apply boundary condition to a matrix. ";

%feature("docstring")  dolfin::DirichletBC::apply "

Apply boundary condition to a vector. ";

%feature("docstring")  dolfin::DirichletBC::apply "

Apply boundary condition to a linear system. ";

%feature("docstring")  dolfin::DirichletBC::apply "

Apply boundary condition to a vector for a nonlinear problem. ";

%feature("docstring")  dolfin::DirichletBC::apply "

Apply boundary condition to a linear system for a nonlinear problem.
";

%feature("docstring")  dolfin::DirichletBC::zero "

Make row associated with boundary conditions zero, useful for non-
diagonal matrices in a block matrix. ";

%feature("docstring")  dolfin::DirichletBC::markers "

Return boundary markers (facets stored as pairs of cells and local
facet numbers). ";

%feature("docstring")  dolfin::DirichletBC::value "

Return boundary value g. ";

%feature("docstring")  dolfin::DirichletBC::value_ptr "

Return shared pointer to boundary value g. ";

%feature("docstring")  dolfin::DirichletBC::get_bc "

Get Dirichlet values and indicators. ";

%feature("docstring")  dolfin::DirichletBC::is_compatible "

Check if given function is compatible with boundary condition
(checking only vertex values). ";

%feature("docstring")  dolfin::DirichletBC::set_value "

Set value g for boundary condition, domain remains unchanged. ";

%feature("docstring")  dolfin::DirichletBC::set_value "

Set value g for boundary condition, domain remains unchanged. ";


// File: classdolfin_1_1DofMap.xml
%feature("docstring") dolfin::DofMap "

This class handles the mapping of degrees of freedom. It wraps a
ufc::dof_map on a specific mesh and provides optional precomputation
and reordering of dofs.

C++ includes: DofMap.h ";

%feature("docstring")  dolfin::DofMap::DofMap "

Create dof map on mesh. ";

%feature("docstring")  dolfin::DofMap::DofMap "

Create dof map on mesh (const mesh version). ";

%feature("docstring")  dolfin::DofMap::~DofMap "

Destructor. ";

%feature("docstring")  dolfin::DofMap::signature "

Return a string identifying the dof map. ";

%feature("docstring")  dolfin::DofMap::needs_mesh_entities "

Return true iff mesh entities of topological dimension d are needed.
";

%feature("docstring")  dolfin::DofMap::global_dimension "

Return the dimension of the global finite element function space. ";

%feature("docstring")  dolfin::DofMap::local_dimension "

Return the dimension of the local finite element function space on a
cell. ";

%feature("docstring")  dolfin::DofMap::max_local_dimension "

Return the maximum dimension of the local finite element function
space. ";

%feature("docstring")  dolfin::DofMap::geometric_dimension "";

%feature("docstring")  dolfin::DofMap::num_facet_dofs "

Return number of facet dofs. ";

%feature("docstring")  dolfin::DofMap::tabulate_dofs "

Tabulate the local-to-global mapping of dofs on a cell (UFC cell
version). ";

%feature("docstring")  dolfin::DofMap::tabulate_dofs "

Tabulate the local-to-global mapping of dofs on a cell (DOLFIN cell
version). ";

%feature("docstring")  dolfin::DofMap::tabulate_facet_dofs "

Tabulate local-local facet dofs. ";

%feature("docstring")  dolfin::DofMap::tabulate_coordinates "

Tabulate the coordinates of all dofs on a cell (UFC cell version). ";

%feature("docstring")  dolfin::DofMap::tabulate_coordinates "

Tabulate the coordinates of all dofs on a cell (DOLFIN cell version).
";

%feature("docstring")  dolfin::DofMap::renumbered "

Test whether dof map has been renumbered. ";

%feature("docstring")  dolfin::DofMap::extract_sub_dofmap "

Extract sub dofmap component. ";

%feature("docstring")  dolfin::DofMap::collapse "

\"Collapse\" a sub dofmap ";

%feature("docstring")  dolfin::DofMap::dofs "

Return the set of dof indices. ";

%feature("docstring")  dolfin::DofMap::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1DomainBoundary.xml
%feature("docstring") dolfin::DomainBoundary "

This class provides a SubDomain which picks out the boundary of a
mesh, and provides a convenient way to specify boundary conditions on
the entire boundary of a mesh.

C++ includes: DomainBoundary.h ";

%feature("docstring")  dolfin::DomainBoundary::DomainBoundary "

Constructor. ";

%feature("docstring")  dolfin::DomainBoundary::~DomainBoundary "

Destructor. ";

%feature("docstring")  dolfin::DomainBoundary::inside "

Return true for points on the boundary. ";


// File: classdolfin_1_1DynamicMeshEditor.xml
%feature("docstring") dolfin::DynamicMeshEditor "

This class provides an interface for dynamic editing of meshes, that
is, when the number of vertices and cells are not known a priori. If
the number of vertices and cells are known a priori, it is more
efficient to use the default editor MeshEditor.

C++ includes: DynamicMeshEditor.h ";

%feature("docstring")  dolfin::DynamicMeshEditor::DynamicMeshEditor "

Constructor. ";

%feature("docstring")  dolfin::DynamicMeshEditor::~DynamicMeshEditor "

Destructor. ";

%feature("docstring")  dolfin::DynamicMeshEditor::open "

Open mesh of given cell type, topological and geometrical dimension.
";

%feature("docstring")  dolfin::DynamicMeshEditor::open "

Open mesh of given cell type, topological and geometrical dimension.
";

%feature("docstring")  dolfin::DynamicMeshEditor::add_vertex "

Add vertex v at given point p. ";

%feature("docstring")  dolfin::DynamicMeshEditor::add_vertex "

Add vertex v at given coordinate x. ";

%feature("docstring")  dolfin::DynamicMeshEditor::add_vertex "

Add vertex v at given coordinate (x, y). ";

%feature("docstring")  dolfin::DynamicMeshEditor::add_vertex "

Add vertex v at given coordinate (x, y, z). ";

%feature("docstring")  dolfin::DynamicMeshEditor::add_cell "

Add cell with given vertices. ";

%feature("docstring")  dolfin::DynamicMeshEditor::add_cell "

Add cell (interval) with given vertices. ";

%feature("docstring")  dolfin::DynamicMeshEditor::add_cell "

Add cell (triangle) with given vertices. ";

%feature("docstring")  dolfin::DynamicMeshEditor::add_cell "

Add cell (tetrahedron) with given vertices. ";

%feature("docstring")  dolfin::DynamicMeshEditor::close "

Close mesh, finish editing, and order entities locally. ";


// File: classdolfin_1_1Edge.xml
%feature("docstring") dolfin::Edge "

An Edge is a MeshEntity of topological dimension 1.

C++ includes: Edge.h ";

%feature("docstring")  dolfin::Edge::Edge "

Create edge on given mesh. ";

%feature("docstring")  dolfin::Edge::Edge "

Create edge from mesh entity. ";

%feature("docstring")  dolfin::Edge::~Edge "

Destructor. ";

%feature("docstring")  dolfin::Edge::length "

Compute Euclidian length of edge. ";


// File: classdolfin_1_1EdgeIterator.xml
%feature("docstring") dolfin::EdgeIterator "

An EdgeIterator is a MeshEntityIterator of topological dimension 1.

C++ includes: Edge.h ";

%feature("docstring")  dolfin::EdgeIterator::EdgeIterator "";

%feature("docstring")  dolfin::EdgeIterator::EdgeIterator "";


// File: classdolfin_1_1EqualityBC.xml
%feature("docstring") dolfin::EqualityBC "

This class specifies the interface for setting equality boundary
conditions for partial differential equations,

u(x) = u(y), for all x and y on G,

where G is subdomain of the mesh.

The sub domain G may be specified in two different ways. Both of them
produce a set of unknowns (dofs) with should be equal.

The simplest approach is to specify a SubDomain object, using the
inside() function to specify on which facets the boundary condition
should be applied.

Alternatively, the boundary may be specified by the boundary
indicators included in the mesh.

Current implementation assume that the problem is scalar, so in case
of mixed systems (vector-valued and mixed elements) all compoments
will be set equal.

C++ includes: EqualityBC.h ";

%feature("docstring")  dolfin::EqualityBC::EqualityBC "";

%feature("docstring")  dolfin::EqualityBC::EqualityBC "";

%feature("docstring")  dolfin::EqualityBC::EqualityBC "";

%feature("docstring")  dolfin::EqualityBC::EqualityBC "";

%feature("docstring")  dolfin::EqualityBC::~EqualityBC "";

%feature("docstring")  dolfin::EqualityBC::apply "

Apply boundary condition to a matrix. ";

%feature("docstring")  dolfin::EqualityBC::apply "

Apply boundary condition to a vector. ";

%feature("docstring")  dolfin::EqualityBC::apply "

Apply boundary condition to a linear system. ";

%feature("docstring")  dolfin::EqualityBC::apply "

Apply boundary condition to a vector for a nonlinear problem. ";

%feature("docstring")  dolfin::EqualityBC::apply "

Apply boundary condition to a linear system for a nonlinear problem.
";

%feature("docstring")  dolfin::EqualityBC::init_from_sub_domain "";

%feature("docstring")  dolfin::EqualityBC::init_from_mesh "";


// File: classdolfin_1_1Event.xml
%feature("docstring") dolfin::Event "

A event is a string message which is displayed only a limited number
of times.

Example of usage:

Event event(\"System is stiff, damping is needed.\"); while () { ...
if ( ... ) { event(); ... } }

C++ includes: Event.h ";

%feature("docstring")  dolfin::Event::Event "

Constructor. ";

%feature("docstring")  dolfin::Event::~Event "

Destructor. ";

%feature("docstring")  dolfin::Event::count "

Display count. ";

%feature("docstring")  dolfin::Event::maxcount "

Maximum display count. ";


// File: classdolfin_1_1Expression.xml
%feature("docstring") dolfin::Expression "

This class represents a user-defined expression. Expressions can be
used as coefficients in variational forms or interpolated into finite
element spaces.

An expression is defined by overloading the eval() method. Users may
choose to overload either a simple version of eval(), in the case of
expressions only depending on the coordinate x, or an optional version
for expressions depending on x and mesh data like cell indices or
facet normals.

The geometric dimension (the size of x) and the value rank and
dimensions of an expression must supplied as arguments to the
constructor.

C++ includes: Expression.h ";

%feature("docstring")  dolfin::Expression::Expression "

Create scalar expression. ";

%feature("docstring")  dolfin::Expression::Expression "

Create vector-valued expression with given dimension. ";

%feature("docstring")  dolfin::Expression::Expression "

Create matrix-valued expression with given dimensions. ";

%feature("docstring")  dolfin::Expression::Expression "

Create tensor-valued expression with given shape. ";

%feature("docstring")  dolfin::Expression::Expression "

Copy constructor. ";

%feature("docstring")  dolfin::Expression::~Expression "

Destructor. ";

%feature("docstring")  dolfin::Expression::value_rank "

Return value rank. ";

%feature("docstring")  dolfin::Expression::value_dimension "

Return value dimension for given axis. ";

%feature("docstring")  dolfin::Expression::eval "

Evaluate function for given data. ";

%feature("docstring")  dolfin::Expression::restrict "

Restrict function to local cell (compute expansion coefficients w). ";

%feature("docstring")  dolfin::Expression::compute_vertex_values "

Compute values at all mesh vertices. ";

%feature("docstring")  dolfin::Expression::eval "

Evaluate expression, must be overloaded by user (simple version). ";


// File: classdolfin_1_1Face.xml
%feature("docstring") dolfin::Face "

A Face is a MeshEntity of topological dimension 2.

C++ includes: Face.h ";

%feature("docstring")  dolfin::Face::Face "

Constructor. ";

%feature("docstring")  dolfin::Face::~Face "

Destructor. ";


// File: classdolfin_1_1FaceIterator.xml
%feature("docstring") dolfin::FaceIterator "

A FaceIterator is a MeshEntityIterator of topological dimension 2.

C++ includes: Face.h ";

%feature("docstring")  dolfin::FaceIterator::FaceIterator "";

%feature("docstring")  dolfin::FaceIterator::FaceIterator "";


// File: classdolfin_1_1Facet.xml
%feature("docstring") dolfin::Facet "

A Facet is a MeshEntity of topological codimension 1.

C++ includes: Facet.h ";

%feature("docstring")  dolfin::Facet::Facet "

Constructor. ";

%feature("docstring")  dolfin::Facet::~Facet "

Destructor. ";

%feature("docstring")  dolfin::Facet::interior "

Determine whether or not facet is an interior facet. This is
'relative' to the given partition of the mesh if the mesh is
distributed ";

%feature("docstring")  dolfin::Facet::adjacent_cells "

Return adjacent cells. An optional argument that lists for each facet
the index of the first cell may be given to specify the ordering of
the two cells. If not specified, the ordering will depend on the
(arbitrary) ordering of the mesh connectivity. ";


// File: classdolfin_1_1FacetArea.xml
%feature("docstring") dolfin::FacetArea "

This function represents the area/length of a cell facet on a given
mesh.

C++ includes: SpecialFunctions.h ";

%feature("docstring")  dolfin::FacetArea::FacetArea "

Constructor. ";

%feature("docstring")  dolfin::FacetArea::eval "

Evaluate function. ";


// File: classdolfin_1_1FacetCell.xml
%feature("docstring") dolfin::FacetCell "

This class represents a cell in a mesh incident to a facet on the
boundary. It is useful in cases where one needs to iterate over a
boundary mesh and access the corresponding cells in the original mesh.

C++ includes: FacetCell.h ";

%feature("docstring")  dolfin::FacetCell::FacetCell "

Create cell on mesh corresponding to given facet (cell) on boundary.
";

%feature("docstring")  dolfin::FacetCell::~FacetCell "

Destructor. ";

%feature("docstring")  dolfin::FacetCell::facet_index "

Return local index of facet with respect to the cell. ";


// File: classdolfin_1_1FacetIterator.xml
%feature("docstring") dolfin::FacetIterator "

A FacetIterator is a MeshEntityIterator of topological codimension 1.

C++ includes: Facet.h ";

%feature("docstring")  dolfin::FacetIterator::FacetIterator "";

%feature("docstring")  dolfin::FacetIterator::FacetIterator "";


// File: classdolfin_1_1File.xml
%feature("docstring") dolfin::File "

A File represents a data file for reading and writing objects. Unless
specified explicitly, the format is determined by the file name
suffix. A list of objects that can be read/written to file can be
found in GenericFile.h

C++ includes: File.h ";

%feature("docstring")  dolfin::File::File "

Create a file with given name. ";

%feature("docstring")  dolfin::File::File "

Create a file with given name and type (format). ";

%feature("docstring")  dolfin::File::File "

Create a outfile object writing to stream. ";

%feature("docstring")  dolfin::File::~File "

Destructor. ";


// File: classdolfin_1_1FiniteElement.xml
%feature("docstring") dolfin::FiniteElement "

This is a wrapper for a UFC finite element (ufc::finite_element).

C++ includes: FiniteElement.h ";

%feature("docstring")  dolfin::FiniteElement::FiniteElement "

Create finite element from UFC finite element (data may be shared). ";

%feature("docstring")  dolfin::FiniteElement::~FiniteElement "

Destructor. ";

%feature("docstring")  dolfin::FiniteElement::signature "";

%feature("docstring")  dolfin::FiniteElement::hash "

Return simple hash of the signature string. ";

%feature("docstring")  dolfin::FiniteElement::value_rank "";

%feature("docstring")  dolfin::FiniteElement::value_dimension "";

%feature("docstring")  dolfin::FiniteElement::num_sub_elements "";

%feature("docstring")  dolfin::FiniteElement::space_dimension "";

%feature("docstring")
dolfin::FiniteElement::interpolate_vertex_values "";

%feature("docstring")  dolfin::FiniteElement::evaluate_basis "";

%feature("docstring")  dolfin::FiniteElement::evaluate_basis "";

%feature("docstring")
dolfin::FiniteElement::evaluate_basis_derivatives "";

%feature("docstring")  dolfin::FiniteElement::evaluate_dof "";

%feature("docstring")  dolfin::FiniteElement::create_sub_element "

Create sub element. ";

%feature("docstring")  dolfin::FiniteElement::ufc_element "

Return ufc::finite_element. ";

%feature("docstring")  dolfin::FiniteElement::extract_sub_element "

Extract sub finite element for component. ";


// File: classdolfin_1_1Form.xml
%feature("docstring") dolfin::Form "

Base class for UFC code generated by FFC for DOLFIN with option -l.

C++ includes: Form.h ";

%feature("docstring")  dolfin::Form::Form "

Create form of given rank with given number of coefficients. ";

%feature("docstring")  dolfin::Form::Form "

Create form (constructor used from Python interface). ";

%feature("docstring")  dolfin::Form::~Form "

Destructor. ";

%feature("docstring")  dolfin::Form::rank "

Return rank of form (bilinear form = 2, linear form = 1, functional =
0, etc). ";

%feature("docstring")  dolfin::Form::num_coefficients "

Return number of coefficients. ";

%feature("docstring")  dolfin::Form::set_mesh "

Set mesh, necessary for functionals when there are no function spaces.
";

%feature("docstring")  dolfin::Form::set_mesh "

Set mesh, necessary for functionals when there are no function spaces.
";

%feature("docstring")  dolfin::Form::mesh "

Return mesh. ";

%feature("docstring")  dolfin::Form::function_space "

Return function space for given argument. ";

%feature("docstring")  dolfin::Form::function_spaces "

Return function spaces for arguments. ";

%feature("docstring")  dolfin::Form::set_coefficient "

Set coefficient with given number. ";

%feature("docstring")  dolfin::Form::set_coefficient "

Set coefficient with given number (shared pointer version). ";

%feature("docstring")  dolfin::Form::set_coefficient "

Set coefficient with given name. ";

%feature("docstring")  dolfin::Form::set_coefficient "

Set coefficient with given name (shared pointer version). ";

%feature("docstring")  dolfin::Form::set_coefficients "

Set all coefficients in given map, possibly a subset. ";

%feature("docstring")  dolfin::Form::set_coefficients "

Set all coefficients in given map, possibly a subset (shared pointer
version). ";

%feature("docstring")  dolfin::Form::coefficient "

Return coefficient with given number. ";

%feature("docstring")  dolfin::Form::coefficient "

Return coefficient with given name. ";

%feature("docstring")  dolfin::Form::coefficients "

Return all coefficients. ";

%feature("docstring")  dolfin::Form::coefficient_number "

Return the number of the coefficient with this name. ";

%feature("docstring")  dolfin::Form::coefficient_name "

Return the name of the coefficient with this number. ";

%feature("docstring")  dolfin::Form::ufc_form "

Return UFC form. ";

%feature("docstring")  dolfin::Form::check "

Check function spaces and coefficients. ";


// File: classdolfin_1_1Function.xml
%feature("docstring") dolfin::Function "

This class represents a function u_h in a finite element function
space V_h, given by

u_h = sum_i U_i phi_i

where {phi_i}_i is a basis for V_h, and U is a vector of expansion
coefficients for u_h.

C++ includes: Function.h ";

%feature("docstring")  dolfin::Function::Function "

Create function on given function space. ";

%feature("docstring")  dolfin::Function::Function "

Create function on given function space (shared data). ";

%feature("docstring")  dolfin::Function::Function "

Create function on given function space with a given vector. ";

%feature("docstring")  dolfin::Function::Function "

Create function on given function space with a given vector (shared
data) ";

%feature("docstring")  dolfin::Function::Function "

Create function on given function space with a given vector (used by
Python interface) ";

%feature("docstring")  dolfin::Function::Function "

Create function from vector of dofs stored to file. ";

%feature("docstring")  dolfin::Function::Function "

Create function from vector of dofs stored to file (shared data). ";

%feature("docstring")  dolfin::Function::Function "

Copy constructor. ";

%feature("docstring")  dolfin::Function::Function "

Sub-function constructor with shallow copy of vector (used in Python
interface) ";

%feature("docstring")  dolfin::Function::~Function "

Destructor. ";

%feature("docstring")  dolfin::Function::function_space "

Return function space. ";

%feature("docstring")  dolfin::Function::function_space_ptr "

Return shared pointer to function space. ";

%feature("docstring")  dolfin::Function::vector "

Return vector of expansion coefficients (non-const version). ";

%feature("docstring")  dolfin::Function::vector "

Return vector of expansion coefficients (const version). ";

%feature("docstring")  dolfin::Function::in "

Check if function is a member of the given function space. ";

%feature("docstring")  dolfin::Function::geometric_dimension "

Return geometric dimension. ";

%feature("docstring")  dolfin::Function::eval "

Evaluate function for given coordinate. ";

%feature("docstring")  dolfin::Function::eval "

Evaluate function for given coordinate in given cell. ";

%feature("docstring")  dolfin::Function::interpolate "

Interpolate function (possibly non-matching meshes). ";

%feature("docstring")  dolfin::Function::extrapolate "

Extrapolate function (from a possibly lower-degree function space). ";

%feature("docstring")  dolfin::Function::value_rank "

Return value rank. ";

%feature("docstring")  dolfin::Function::value_dimension "

Return value dimension for given axis. ";

%feature("docstring")  dolfin::Function::eval "

Evaluate function for given data. ";

%feature("docstring")  dolfin::Function::restrict "

Restrict function to local cell (compute expansion coefficients w). ";

%feature("docstring")  dolfin::Function::compute_vertex_values "

Compute values at all mesh vertices. ";

%feature("docstring")  dolfin::Function::gather "

Collect off-process coefficients to prepare for interpolation. ";


// File: classdolfin_1_1FunctionPlotData.xml
%feature("docstring") dolfin::FunctionPlotData "

This class is used for communicating plot data for functions to and
from (XML) files. It is used by DOLFIN for plotting Function objects.
The data is stored as a mesh and a vector of interpolated vertex
values.

C++ includes: FunctionPlotData.h ";

%feature("docstring")  dolfin::FunctionPlotData::FunctionPlotData "

Create plot data for given function. ";

%feature("docstring")  dolfin::FunctionPlotData::FunctionPlotData "

Create empty data to be read from file. ";

%feature("docstring")  dolfin::FunctionPlotData::~FunctionPlotData "

Destructor. ";

%feature("docstring")  dolfin::FunctionPlotData::vertex_values "

Return vertex values. ";


// File: classdolfin_1_1FunctionSpace.xml
%feature("docstring") dolfin::FunctionSpace "

This class represents a finite element function space defined by a
mesh, a finite element, and a local-to-global mapping of the degrees
of freedom (dofmap).

C++ includes: FunctionSpace.h ";

%feature("docstring")  dolfin::FunctionSpace::FunctionSpace "

Create function space for given mesh, element and dofmap (shared
data). ";

%feature("docstring")  dolfin::FunctionSpace::FunctionSpace "

Create function space for given mesh, element and dofmap (shared
data). ";

%feature("docstring")  dolfin::FunctionSpace::FunctionSpace "

Copy constructor. ";

%feature("docstring")  dolfin::FunctionSpace::~FunctionSpace "

Destructor. ";

%feature("docstring")  dolfin::FunctionSpace::mesh "

Return mesh. ";

%feature("docstring")  dolfin::FunctionSpace::element "

Return finite element. ";

%feature("docstring")  dolfin::FunctionSpace::dofmap "

Return dofmap. ";

%feature("docstring")  dolfin::FunctionSpace::dim "

Return dimension of function space. ";

%feature("docstring")  dolfin::FunctionSpace::interpolate "

Interpolate function v into function space, returning the vector of
expansion coefficients ";

%feature("docstring")  dolfin::FunctionSpace::extract_sub_space "

Extract sub space for component. ";

%feature("docstring")  dolfin::FunctionSpace::collapse_sub_space "

Return function space with a new dof map. ";

%feature("docstring")  dolfin::FunctionSpace::has_cell "

Check if function space has given cell. ";

%feature("docstring")  dolfin::FunctionSpace::has_element "

Check if function space has given element. ";

%feature("docstring")  dolfin::FunctionSpace::component "

Return component (relative to super space). ";

%feature("docstring")  dolfin::FunctionSpace::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::FunctionSpace::print_dofmap "

Print dofmap (useful for debugging). ";


// File: classdolfin_1_1Function_1_1GatherScratch.xml


// File: classdolfin_1_1GaussianQuadrature.xml
%feature("docstring") dolfin::GaussianQuadrature "

Gaussian-type quadrature rule on the double line, including Gauss,
Radau, and Lobatto quadrature.

Points and weights are computed to be exact within a tolerance of
DOLFIN_EPS. Comparing with known exact values for n <= 3 shows that we
obtain full precision (16 digits, error less than 2e-16).

C++ includes: GaussianQuadrature.h ";

%feature("docstring")  dolfin::GaussianQuadrature::GaussianQuadrature
"";


// File: classdolfin_1_1GaussQuadrature.xml
%feature("docstring") dolfin::GaussQuadrature "

Gauss (Gauss-Legendre) quadrature on the interval [-1,1]. The n
quadrature points are given by the zeros of the n:th Legendre Pn(x).

The quadrature points are computed using Newton's method, and the
quadrature weights are computed by solving a linear system determined
by the condition that Gauss quadrature with n points should be exact
for polynomials of degree 2n-1.

C++ includes: GaussQuadrature.h ";

%feature("docstring")  dolfin::GaussQuadrature::GaussQuadrature "

Create Gauss quadrature with n points. ";

%feature("docstring")  dolfin::GaussQuadrature::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1GenericDofMap.xml
%feature("docstring") dolfin::GenericDofMap "

This class provides a generic interface for dof maps.

C++ includes: GenericDofMap.h ";


// File: classdolfin_1_1GenericFunction.xml
%feature("docstring") dolfin::GenericFunction "

This is a common base class for functions. Functions can be evaluated
at a given point and they can be restricted to a given cell in a
finite element mesh. This functionality is implemented by sub-classes
that implement the eval() and restrict() functions.

DOLFIN provides two implementations of the GenericFunction interface
in the form of the classes Function and Expression.

Sub-classes may optionally implement the gather() function that will
be called prior to restriction when running in parallel.

C++ includes: GenericFunction.h ";

%feature("docstring")  dolfin::GenericFunction::GenericFunction "

Constructor. ";

%feature("docstring")  dolfin::GenericFunction::~GenericFunction "

Destructor. ";

%feature("docstring")  dolfin::GenericFunction::value_rank "

Return value rank. ";

%feature("docstring")  dolfin::GenericFunction::value_dimension "

Return value dimension for given axis. ";

%feature("docstring")  dolfin::GenericFunction::eval "

Evaluate function for given data. ";

%feature("docstring")  dolfin::GenericFunction::restrict "

Restrict function to local cell (compute expansion coefficients w). ";

%feature("docstring")  dolfin::GenericFunction::compute_vertex_values
"

Compute values at all mesh vertices. ";

%feature("docstring")  dolfin::GenericFunction::gather "

Collect off-process coefficients to prepare for interpolation. ";

%feature("docstring")  dolfin::GenericFunction::value_size "

Return value size (product of value dimensions). ";

%feature("docstring")  dolfin::GenericFunction::restrict "

Convenience function for restriction when facet is unknown. ";

%feature("docstring")  dolfin::GenericFunction::evaluate "

Evaluate function at given point in cell. ";


// File: classdolfin_1_1GenericLinearSolver.xml
%feature("docstring") dolfin::GenericLinearSolver "

This class provides a general solver for linear systems Ax = b.

C++ includes: GenericLinearSolver.h ";

%feature("docstring")  dolfin::GenericLinearSolver::solve "

Solve linear system Ax = b. ";


// File: classdolfin_1_1GenericMatrix.xml
%feature("docstring") dolfin::GenericMatrix "

This class defines a common interface for matrices.

C++ includes: GenericMatrix.h ";

%feature("docstring")  dolfin::GenericMatrix::~GenericMatrix "

Destructor. ";

%feature("docstring")  dolfin::GenericMatrix::resize "

Resize tensor with given dimensions. ";

%feature("docstring")  dolfin::GenericMatrix::init "

Initialize zero tensor using sparsity pattern. ";

%feature("docstring")  dolfin::GenericMatrix::copy "

Return copy of tensor. ";

%feature("docstring")  dolfin::GenericMatrix::rank "

Return tensor rank (number of dimensions). ";

%feature("docstring")  dolfin::GenericMatrix::size "

Return size of given dimension. ";

%feature("docstring")  dolfin::GenericMatrix::get "

Get block of values. ";

%feature("docstring")  dolfin::GenericMatrix::set "

Set block of values. ";

%feature("docstring")  dolfin::GenericMatrix::add "

Add block of values. ";

%feature("docstring")  dolfin::GenericMatrix::zero "

Set all entries to zero and keep any sparse structure. ";

%feature("docstring")  dolfin::GenericMatrix::apply "

Finalize assembly of tensor. ";

%feature("docstring")  dolfin::GenericMatrix::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::GenericMatrix::resize "

Resize matrix to M x N. ";

%feature("docstring")  dolfin::GenericMatrix::get "

Get block of values. ";

%feature("docstring")  dolfin::GenericMatrix::set "

Set block of values. ";

%feature("docstring")  dolfin::GenericMatrix::add "

Add block of values. ";

%feature("docstring")  dolfin::GenericMatrix::axpy "

Add multiple of given matrix (AXPY operation). ";

%feature("docstring")  dolfin::GenericMatrix::norm "

Return norm of matrix. ";

%feature("docstring")  dolfin::GenericMatrix::getrow "

Get non-zero values of given row. ";

%feature("docstring")  dolfin::GenericMatrix::setrow "

Set values for given row. ";

%feature("docstring")  dolfin::GenericMatrix::zero "

Set given rows to zero. ";

%feature("docstring")  dolfin::GenericMatrix::ident "

Set given rows to identity matrix. ";

%feature("docstring")  dolfin::GenericMatrix::mult "

Matrix-vector product, y = Ax. ";

%feature("docstring")  dolfin::GenericMatrix::transpmult "

Matrix-vector product, y = A^T x. ";

%feature("docstring")  dolfin::GenericMatrix::data "

Return pointers to underlying compresssed row/column storage data For
compressed row storage, data = (row_pointer[rows +1],
column_index[nz], matrix_values[nz], nz) ";

%feature("docstring")  dolfin::GenericMatrix::getitem "

Get value of given entry. ";

%feature("docstring")  dolfin::GenericMatrix::setitem "

Set given entry to value. ";

%feature("docstring")  dolfin::GenericMatrix::ident_zeros "

Insert one on the diagonal for all zero rows. ";


// File: classdolfin_1_1GenericSparsityPattern.xml
%feature("docstring") dolfin::GenericSparsityPattern "

Base class (interface) for generic tensor sparsity patterns.
Currently, this interface is mostly limited to matrices.

C++ includes: GenericSparsityPattern.h ";

%feature("docstring")
dolfin::GenericSparsityPattern::GenericSparsityPattern "

Create empty sparsity pattern. ";

%feature("docstring")
dolfin::GenericSparsityPattern::~GenericSparsityPattern "

Destructor. ";

%feature("docstring")  dolfin::GenericSparsityPattern::init "

Initialize sparsity pattern for a generic tensor. ";

%feature("docstring")  dolfin::GenericSparsityPattern::insert "

Insert non-zero entries. ";

%feature("docstring")  dolfin::GenericSparsityPattern::rank "

Return rank. ";

%feature("docstring")  dolfin::GenericSparsityPattern::size "

Return global size for dimension i. ";

%feature("docstring")  dolfin::GenericSparsityPattern::local_range "

Return local range for dimension dim. ";

%feature("docstring")  dolfin::GenericSparsityPattern::num_nonzeros "

Return total number of nonzeros in local_range for dimension 0. ";

%feature("docstring")
dolfin::GenericSparsityPattern::num_nonzeros_diagonal "

Fill array with number of nonzeros for diagonal block in local_range
for dimension 0. ";

%feature("docstring")
dolfin::GenericSparsityPattern::num_nonzeros_off_diagonal "

Fill array with number of nonzeros for off-diagonal block in
local_range for dimension 0. ";

%feature("docstring")  dolfin::GenericSparsityPattern::apply "

Finalize sparsity pattern. ";


// File: classdolfin_1_1GenericTensor.xml
%feature("docstring") dolfin::GenericTensor "

This class defines a common interface for arbitrary rank tensors.

C++ includes: GenericTensor.h ";

%feature("docstring")  dolfin::GenericTensor::~GenericTensor "

Destructor. ";

%feature("docstring")  dolfin::GenericTensor::resize "

Resize tensor with given dimensions. ";

%feature("docstring")  dolfin::GenericTensor::init "

Initialize zero tensor using sparsity pattern. ";

%feature("docstring")  dolfin::GenericTensor::copy "

Return copy of tensor. ";

%feature("docstring")  dolfin::GenericTensor::rank "

Return tensor rank (number of dimensions). ";

%feature("docstring")  dolfin::GenericTensor::size "

Return size of given dimension. ";

%feature("docstring")  dolfin::GenericTensor::get "

Get block of values. ";

%feature("docstring")  dolfin::GenericTensor::set "

Set block of values. ";

%feature("docstring")  dolfin::GenericTensor::add "

Add block of values. ";

%feature("docstring")  dolfin::GenericTensor::zero "

Set all entries to zero and keep any sparse structure. ";

%feature("docstring")  dolfin::GenericTensor::apply "

Finalize assembly of tensor. ";

%feature("docstring")  dolfin::GenericTensor::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::GenericTensor::factory "

Return linear algebra backend factory. ";

%feature("docstring")  dolfin::GenericTensor::down_cast "

Cast a GenericTensor to its derived class (const version). ";

%feature("docstring")  dolfin::GenericTensor::down_cast "

Cast a GenericTensor to its derived class (non-const version). ";

%feature("docstring")  dolfin::GenericTensor::has_type "

Check whether the GenericTensor instance matches a specific type. ";

%feature("docstring")  dolfin::GenericTensor::instance "

Return concrete instance / unwrap (const version). ";

%feature("docstring")  dolfin::GenericTensor::instance "

Return concrete instance / unwrap (non-const version). ";


// File: classdolfin_1_1GenericVector.xml
%feature("docstring") dolfin::GenericVector "

This class defines a common interface for vectors.

C++ includes: GenericVector.h ";

%feature("docstring")  dolfin::GenericVector::~GenericVector "

Destructor. ";

%feature("docstring")  dolfin::GenericVector::resize "

Resize tensor with given dimensions. ";

%feature("docstring")  dolfin::GenericVector::init "

Initialize zero tensor using sparsity pattern. ";

%feature("docstring")  dolfin::GenericVector::copy "

Return copy of tensor. ";

%feature("docstring")  dolfin::GenericVector::rank "

Return tensor rank (number of dimensions). ";

%feature("docstring")  dolfin::GenericVector::size "

Return size of given dimension. ";

%feature("docstring")  dolfin::GenericVector::get "

Get block of values. ";

%feature("docstring")  dolfin::GenericVector::set "

Set block of values. ";

%feature("docstring")  dolfin::GenericVector::add "

Add block of values. ";

%feature("docstring")  dolfin::GenericVector::zero "

Set all entries to zero and keep any sparse structure. ";

%feature("docstring")  dolfin::GenericVector::apply "

Finalize assembly of tensor. ";

%feature("docstring")  dolfin::GenericVector::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::GenericVector::resize "

Resize vector to size N. ";

%feature("docstring")  dolfin::GenericVector::size "

Return size of vector. ";

%feature("docstring")  dolfin::GenericVector::local_range "

Return local ownership range of a vector. ";

%feature("docstring")  dolfin::GenericVector::get "

Get block of values (values may live on any process). ";

%feature("docstring")  dolfin::GenericVector::get_local "

Get block of values (values must all live on the local process). ";

%feature("docstring")  dolfin::GenericVector::set "

Set block of values. ";

%feature("docstring")  dolfin::GenericVector::add "

Add block of values. ";

%feature("docstring")  dolfin::GenericVector::get_local "

Get all values on local process. ";

%feature("docstring")  dolfin::GenericVector::set_local "

Set all values on local process. ";

%feature("docstring")  dolfin::GenericVector::add_local "

Add values to each entry on local process. ";

%feature("docstring")  dolfin::GenericVector::gather "

Gather entries into local vector x. ";

%feature("docstring")  dolfin::GenericVector::axpy "

Add multiple of given vector (AXPY operation). ";

%feature("docstring")  dolfin::GenericVector::inner "

Return inner product with given vector. ";

%feature("docstring")  dolfin::GenericVector::norm "

Return norm of vector. ";

%feature("docstring")  dolfin::GenericVector::min "

Return minimum value of vector. ";

%feature("docstring")  dolfin::GenericVector::max "

Return maximum value of vector. ";

%feature("docstring")  dolfin::GenericVector::sum "

Return sum of vector. ";

%feature("docstring")  dolfin::GenericVector::sum "

Return sum of selected rows in vector. Repeated entries only summed
once. ";

%feature("docstring")  dolfin::GenericVector::lambda "

Apply lambda function. ";

%feature("docstring")  dolfin::GenericVector::lambda "

Apply lambda function. ";

%feature("docstring")  dolfin::GenericVector::data "

Return pointer to underlying data (const version). ";

%feature("docstring")  dolfin::GenericVector::data "

Return pointer to underlying data. ";

%feature("docstring")  dolfin::GenericVector::getitem "

Get value of given entry. ";

%feature("docstring")  dolfin::GenericVector::setitem "

Set given entry to value. ";


// File: classdolfin_1_1GlobalParameters.xml
%feature("docstring") dolfin::GlobalParameters "

This class defines the global DOLFIN parameter database.

C++ includes: GlobalParameters.h ";

%feature("docstring")  dolfin::GlobalParameters::GlobalParameters "

Constructor. ";

%feature("docstring")  dolfin::GlobalParameters::~GlobalParameters "

Destructor. ";

%feature("docstring")  dolfin::GlobalParameters::parse "

Parse parameters from command-line. ";


// File: classdolfin_1_1IntersectionOperator.xml
%feature("docstring") dolfin::IntersectionOperator "";

%feature("docstring")
dolfin::IntersectionOperator::IntersectionOperator "

Create intersection detector for the mesh mesh.

Parameters:
-----------

kernel_type:  The CGAL geometric kernel is used to compute predicates,
intersections and such. Depending on this choice the kernel
(kernel_type = \"ExcactPredicates\") can compute predicates excactly
(without roundoff error) or only approximately (default, kernel_type =
\"SimpleCartesian\"). ";

%feature("docstring")
dolfin::IntersectionOperator::IntersectionOperator "";

%feature("docstring")
dolfin::IntersectionOperator::~IntersectionOperator "

Destructor. Needed be explicit written, otherwise default inline here,
with prohibits pImpl with scoped_ptr. ";

%feature("docstring")
dolfin::IntersectionOperator::all_intersected_entities "

Compute all id of all cells which are intersects by a point.

Parameters:
-----------

ids_result:  The ids of the intersected entities are saved in a set
for efficienty reasons, to avoid to sort out duplicates later on. ";

%feature("docstring")
dolfin::IntersectionOperator::all_intersected_entities "

Compute all id of all cells which are intersects any point in points.

Parameters:
-----------

ids_result:  The ids of the intersected entities are saved in a set
for efficienty reasons, to avoid to sort out duplicates later on. ";

%feature("docstring")
dolfin::IntersectionOperator::all_intersected_entities "

Compute all id of all cells which are intersects by a entity.

Parameters:
-----------

ids_result:  The ids of the intersected entities are saved in a
vector. This allows is more efficent than using a set and allows a map
between ";

%feature("docstring")
dolfin::IntersectionOperator::all_intersected_entities "

Compute all id of all cells which are intersects by any of the
entities in entities. This

Parameters:
-----------

ids_result:  The ids of the intersected set are saved in a set for
efficienty reasons, to avoid to sort out duplicates later on. ";

%feature("docstring")
dolfin::IntersectionOperator::all_intersected_entities "

Compute all id of all cells which are intersects by the given mesh
another_mesh;

Parameters:
-----------

ids_result:  The ids of the intersected entities are saved in a set
for efficienty reasons, to avoid to sort out duplicates later on. ";

%feature("docstring")
dolfin::IntersectionOperator::any_intersected_entity "

Computes only the first id of the entity, which contains the point.
Returns -1 if no cell is intersected. ";

%feature("docstring")  dolfin::IntersectionOperator::closest_point "

Computes the point inside the mesh which are closest to the point
query. ";

%feature("docstring")  dolfin::IntersectionOperator::closest_cell "

Computes the index of the cell inside the mesh which are closest to
the point query. ";

%feature("docstring")
dolfin::IntersectionOperator::closest_point_and_cell "

Computes the point inside the mesh and the corresponding cell index
which are closest to the point query. ";

%feature("docstring")  dolfin::IntersectionOperator::reset_kernel "

Rebuilds the underlying search structure from scratch and uses the
kernel kernel_type underlying CGAL Geometry kernel. ";

%feature("docstring")  dolfin::IntersectionOperator::clear "

Clears search structure. Should be used if the mesh has changed. ";

%feature("docstring")  dolfin::IntersectionOperator::mesh "";


// File: classdolfin_1_1Interval.xml
%feature("docstring") dolfin::Interval "

Interval mesh of the 1D line (a,b). Given the number of cells (nx) in
the axial direction, the total number of intervals will be nx and the
total number of vertices will be (nx + 1).

C++ includes: Interval.h ";

%feature("docstring")  dolfin::Interval::Interval "";


// File: classdolfin_1_1IntParameter.xml
%feature("docstring") dolfin::IntParameter "

Parameter with value type int.

C++ includes: Parameter.h ";

%feature("docstring")  dolfin::IntParameter::IntParameter "

Create int-valued parameter. ";

%feature("docstring")  dolfin::IntParameter::~IntParameter "

Destructor. ";

%feature("docstring")  dolfin::IntParameter::set_range "

Set range. ";

%feature("docstring")  dolfin::IntParameter::get_range "

Get range. ";

%feature("docstring")  dolfin::IntParameter::type_str "

Return value type string. ";

%feature("docstring")  dolfin::IntParameter::value_str "

Return value string. ";

%feature("docstring")  dolfin::IntParameter::range_str "

Return range string. ";

%feature("docstring")  dolfin::IntParameter::str "

Return short string description. ";


// File: classdolfin_1_1KrylovSolver.xml
%feature("docstring") dolfin::KrylovSolver "

This class defines an interface for a Krylov solver. The approproiate
solver is chosen on the basis of the matrix/vector type.

C++ includes: KrylovSolver.h ";

%feature("docstring")  dolfin::KrylovSolver::KrylovSolver "

Create Krylov solver. ";

%feature("docstring")  dolfin::KrylovSolver::~KrylovSolver "

Destructor. ";

%feature("docstring")  dolfin::KrylovSolver::solve "

Solve linear system Ax = b. ";


// File: classdolfin_1_1Lagrange.xml
%feature("docstring") dolfin::Lagrange "

Lagrange polynomial (basis) with given degree q determined by n = q +
1 nodal points.

Example: q = 1 (n = 2)

Lagrange p(1); p.set(0, 0.0); p.set(1, 1.0);

This creates a Lagrange polynomial (actually two Lagrange
polynomials):

p(0,x) = 1 - x (one at x = 0, zero at x = 1) p(1,x) = x (zero at x =
0, one at x = 1)

C++ includes: Lagrange.h ";

%feature("docstring")  dolfin::Lagrange::Lagrange "

Constructor. ";

%feature("docstring")  dolfin::Lagrange::Lagrange "

Copy constructor. ";

%feature("docstring")  dolfin::Lagrange::~Lagrange "

Destructor. ";

%feature("docstring")  dolfin::Lagrange::set "

Specify point. ";

%feature("docstring")  dolfin::Lagrange::size "

Return number of points. ";

%feature("docstring")  dolfin::Lagrange::degree "

Return degree. ";

%feature("docstring")  dolfin::Lagrange::point "

Return point. ";

%feature("docstring")  dolfin::Lagrange::eval "

Return value of polynomial i at given point x. ";

%feature("docstring")  dolfin::Lagrange::ddx "

Return derivate of polynomial i at given point x. ";

%feature("docstring")  dolfin::Lagrange::dqdx "

Return derivative q (a constant) of polynomial. ";

%feature("docstring")  dolfin::Lagrange::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1Legendre.xml
%feature("docstring") dolfin::Legendre "

Legendre polynomial of given degree n on the interval [-1,1].

P0(x) = 1 P1(x) = x P2(x) = (3x^2 - 1) / 2 ...

The function values and derivatives are computed using three-term
recurrence formulas.

C++ includes: Legendre.h ";

%feature("docstring")  dolfin::Legendre::Legendre "";

%feature("docstring")  dolfin::Legendre::~Legendre "";

%feature("docstring")  dolfin::Legendre::ddx "

Evaluation of derivative at given point. ";

%feature("docstring")  dolfin::Legendre::d2dx "

Evaluation of second derivative at given point. ";

%feature("docstring")  dolfin::Legendre::eval "

Evaluation of arbitrary order, nn <= n (useful ie in RadauQuadrature).
";

%feature("docstring")  dolfin::Legendre::ddx "";

%feature("docstring")  dolfin::Legendre::d2dx "";


// File: classdolfin_1_1LinearAlgebraFactory.xml
%feature("docstring") dolfin::LinearAlgebraFactory "";

%feature("docstring")
dolfin::LinearAlgebraFactory::LinearAlgebraFactory "

Constructor. ";

%feature("docstring")
dolfin::LinearAlgebraFactory::~LinearAlgebraFactory "

Destructor. ";

%feature("docstring")  dolfin::LinearAlgebraFactory::create_matrix "

Create empty matrix. ";

%feature("docstring")  dolfin::LinearAlgebraFactory::create_vector "

Create empty vector (global). ";

%feature("docstring")
dolfin::LinearAlgebraFactory::create_local_vector "

Create empty vector (local). ";

%feature("docstring")  dolfin::LinearAlgebraFactory::create_pattern "

Create empty sparsity pattern (returning zero if not used/needed). ";


// File: classdolfin_1_1LinearSolver.xml
%feature("docstring") dolfin::LinearSolver "

This class provides a general solver for linear systems Ax = b.

C++ includes: LinearSolver.h ";

%feature("docstring")  dolfin::LinearSolver::LinearSolver "

Create linear solver. ";

%feature("docstring")  dolfin::LinearSolver::~LinearSolver "

Destructor. ";

%feature("docstring")  dolfin::LinearSolver::solve "

Solve linear system Ax = b. ";


// File: classdolfin_1_1LobattoQuadrature.xml
%feature("docstring") dolfin::LobattoQuadrature "

Lobatto (Gauss-Lobatto) quadrature on the interval [-1,1]. The n
quadrature points are given by the end-points -1 and 1, and the zeros
of P{n-1}'(x), where P{n-1}(x) is the (n-1):th Legendre polynomial.

The quadrature points are computed using Newton's method, and the
quadrature weights are computed by solving a linear system determined
by the condition that Lobatto quadrature with n points should be exact
for polynomials of degree 2n-3.

C++ includes: LobattoQuadrature.h ";

%feature("docstring")  dolfin::LobattoQuadrature::LobattoQuadrature "

Create Lobatto quadrature with n points. ";

%feature("docstring")  dolfin::LobattoQuadrature::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1BoundaryCondition_1_1LocalData.xml


// File: classdolfin_1_1LocalMeshData.xml
%feature("docstring") dolfin::LocalMeshData "

This class stores mesh data on a local processor corresponding to a
portion of a (larger) global mesh.

Note that the data stored in this class does typically not correspond
to a topologically connected mesh; it merely stores a list of vertex
coordinates, a list of cell-vertex mappings and a list of global
vertex numbers for the locally stored vertices.

It is typically used for parsing meshes in parallel from mesh XML
files. After local mesh data has been parsed on each processor, a
subsequent repartitioning takes place: first a geometric partitioning
of the vertices followed by a redistribution of vertex and cell data,
and then a topological partitioning again followed by redistribution
of vertex and cell data, at that point corresponding to topologically
connected meshes instead of local mesh data.

C++ includes: LocalMeshData.h ";

%feature("docstring")  dolfin::LocalMeshData::LocalMeshData "

Create empty local mesh data. ";

%feature("docstring")  dolfin::LocalMeshData::LocalMeshData "

Create local mesh data for given mesh. ";

%feature("docstring")  dolfin::LocalMeshData::~LocalMeshData "

Destructor. ";

%feature("docstring")  dolfin::LocalMeshData::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1Function_1_1LocalScratch.xml


// File: classdolfin_1_1LogStream.xml
%feature("docstring") dolfin::LogStream "

This class provides functionality similar to standard C++ streams
(std::cout, std::endl) for output but working through the DOLFIN log
system.

C++ includes: LogStream.h ";

%feature("docstring")  dolfin::LogStream::LogStream "

Create log stream of given type. ";

%feature("docstring")  dolfin::LogStream::~LogStream "

Destructor. ";

%feature("docstring")  dolfin::LogStream::setprecision "";


// File: classdolfin_1_1LUSolver.xml
%feature("docstring") dolfin::LUSolver "";

%feature("docstring")  dolfin::LUSolver::LUSolver "

LU solver for the built-in LA backends. The type can be \"lu\" or
\"cholesky\". Cholesky is suitable only for symmetric positive-
definite matrices. Cholesky is not yet suppprted for all backends
(which will default to LU. ";

%feature("docstring")  dolfin::LUSolver::~LUSolver "";

%feature("docstring")  dolfin::LUSolver::solve "

Solve linear system Ax = b. ";

%feature("docstring")  dolfin::LUSolver::factorize "";

%feature("docstring")  dolfin::LUSolver::factorized_solve "";


// File: classdolfin_1_1Matrix.xml
%feature("docstring") dolfin::Matrix "

This class provides the default DOLFIN matrix class, based on the
default DOLFIN linear algebra backend.

C++ includes: Matrix.h ";

%feature("docstring")  dolfin::Matrix::Matrix "

Create empty matrix. ";

%feature("docstring")  dolfin::Matrix::Matrix "

Create M x N matrix. ";

%feature("docstring")  dolfin::Matrix::Matrix "

Copy constructor. ";

%feature("docstring")  dolfin::Matrix::~Matrix "

Destructor. ";

%feature("docstring")  dolfin::Matrix::init "

Initialize zero tensor using sparsity pattern. ";

%feature("docstring")  dolfin::Matrix::copy "

Return copy of tensor. ";

%feature("docstring")  dolfin::Matrix::size "

Return size of given dimension. ";

%feature("docstring")  dolfin::Matrix::zero "

Set all entries to zero and keep any sparse structure. ";

%feature("docstring")  dolfin::Matrix::apply "

Finalize assembly of tensor. ";

%feature("docstring")  dolfin::Matrix::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::Matrix::resize "

Resize matrix to M x N. ";

%feature("docstring")  dolfin::Matrix::get "

Get block of values. ";

%feature("docstring")  dolfin::Matrix::set "

Set block of values. ";

%feature("docstring")  dolfin::Matrix::add "

Add block of values. ";

%feature("docstring")  dolfin::Matrix::axpy "

Add multiple of given matrix (AXPY operation). ";

%feature("docstring")  dolfin::Matrix::norm "

Return norm of matrix. ";

%feature("docstring")  dolfin::Matrix::getrow "

Get non-zero values of given row. ";

%feature("docstring")  dolfin::Matrix::setrow "

Set values for given row. ";

%feature("docstring")  dolfin::Matrix::zero "

Set given rows to zero. ";

%feature("docstring")  dolfin::Matrix::ident "

Set given rows to identity matrix. ";

%feature("docstring")  dolfin::Matrix::mult "

Matrix-vector product, y = Ax. ";

%feature("docstring")  dolfin::Matrix::transpmult "

Matrix-vector product, y = A^T x. ";

%feature("docstring")  dolfin::Matrix::data "

Return pointers to underlying compressed storage data. See
GenericMatrix for documentation. ";

%feature("docstring")  dolfin::Matrix::factory "

Return linear algebra backend factory. ";

%feature("docstring")  dolfin::Matrix::instance "

Return concrete instance / unwrap (const version). ";

%feature("docstring")  dolfin::Matrix::instance "

Return concrete instance / unwrap (non-const version). ";


// File: classdolfin_1_1Mesh.xml
%feature("docstring") dolfin::Mesh "

A Mesh consists of a set of connected and numbered mesh entities.

Both the representation and the interface are dimension-independent,
but a concrete interface is also provided for standard named mesh
entities:

Entity Dimension Codimension

Vertex 0 - Edge 1 - Face 2 -

Facet - 1 Cell - 0

When working with mesh iterators, all entities and connectivity are
precomputed automatically the first time an iterator is created over
any given topological dimension or connectivity.

Note that for efficiency, only entities of dimension zero (vertices)
and entities of the maximal dimension (cells) exist when creating a
Mesh. Other entities must be explicitly created by calling init(). For
example, all edges in a mesh may be created by a call to mesh.init(1).
Similarly, connectivities such as all edges connected to a given
vertex must also be explicitly created (in this case by a call to
mesh.init(0, 1)).

C++ includes: Mesh.h ";

%feature("docstring")  dolfin::Mesh::Mesh "

Create empty mesh. ";

%feature("docstring")  dolfin::Mesh::Mesh "

Copy constructor. ";

%feature("docstring")  dolfin::Mesh::Mesh "

Create mesh from data file. ";

%feature("docstring")  dolfin::Mesh::~Mesh "

Destructor. ";

%feature("docstring")  dolfin::Mesh::num_vertices "

Return number of vertices. ";

%feature("docstring")  dolfin::Mesh::num_edges "

Return number of edges. ";

%feature("docstring")  dolfin::Mesh::num_faces "

Return number of faces. ";

%feature("docstring")  dolfin::Mesh::num_facets "

Return number of facets. ";

%feature("docstring")  dolfin::Mesh::num_cells "

Return number of cells. ";

%feature("docstring")  dolfin::Mesh::num_entities "

Return number of entities of dimension d. ";

%feature("docstring")  dolfin::Mesh::coordinates "

Return coordinates of all vertices. ";

%feature("docstring")  dolfin::Mesh::coordinates "

Return coordinates of all vertices. ";

%feature("docstring")  dolfin::Mesh::cells "

Return connectivity for all cells. ";

%feature("docstring")  dolfin::Mesh::size "

Return number of entities of given topological dimension. ";

%feature("docstring")  dolfin::Mesh::topology "

Return mesh topology (non-const version). ";

%feature("docstring")  dolfin::Mesh::topology "

Return mesh topology (const version). ";

%feature("docstring")  dolfin::Mesh::geometry "

Return mesh geometry (non-const version). ";

%feature("docstring")  dolfin::Mesh::geometry "

Return mesh geometry (const version). ";

%feature("docstring")  dolfin::Mesh::intersection_operator "

Return intersectionoperator (const version);. ";

%feature("docstring")  dolfin::Mesh::intersection_operator "

Return intersectionoperator (non-const version);. ";

%feature("docstring")  dolfin::Mesh::data "

Return mesh data (non-const version). ";

%feature("docstring")  dolfin::Mesh::data "

Return mesh data (const version). ";

%feature("docstring")  dolfin::Mesh::type "

Return mesh cell type. ";

%feature("docstring")  dolfin::Mesh::type "

Return mesh cell type. ";

%feature("docstring")  dolfin::Mesh::init "

Compute entities of given topological dimension and return number of
entities. ";

%feature("docstring")  dolfin::Mesh::init "

Compute connectivity between given pair of dimensions. ";

%feature("docstring")  dolfin::Mesh::init "

Compute all entities and connectivity. ";

%feature("docstring")  dolfin::Mesh::clear "

Clear all mesh data. ";

%feature("docstring")  dolfin::Mesh::order "

Order all mesh entities (not needed if \"mesh order entities\" is
set). ";

%feature("docstring")  dolfin::Mesh::ordered "

Return true iff topology is ordered according to the UFC numbering. ";

%feature("docstring")  dolfin::Mesh::move "

Move coordinates of mesh according to new boundary coordinates. ";

%feature("docstring")  dolfin::Mesh::move "

Move coordinates of mesh according to adjacent mesh with common global
vertices. ";

%feature("docstring")  dolfin::Mesh::move "

Move coordinates of mesh according to displacement function. ";

%feature("docstring")  dolfin::Mesh::smooth "

Smooth internal vertices of mesh by local averaging. ";

%feature("docstring")  dolfin::Mesh::smooth_boundary "

Smooth boundary vertices of mesh by local averaging. ";

%feature("docstring")  dolfin::Mesh::snap_boundary "

Snap boundary vertices of mesh to match given sub domain. ";

%feature("docstring")  dolfin::Mesh::all_intersected_entities "

Compute all id of all cells which are intersects by a point.

Parameters:
-----------

ids_result:  The ids of the intersected entities are saved in a set
for efficienty reasons, to avoid to sort out duplicates later on. ";

%feature("docstring")  dolfin::Mesh::all_intersected_entities "

Compute all id of all cells which are intersects any point in points.

Parameters:
-----------

ids_result:  The ids of the intersected entities are saved in a set
for efficienty reasons, to avoid to sort out duplicates later on. ";

%feature("docstring")  dolfin::Mesh::all_intersected_entities "

Compute all id of all cells which are intersects by a entity.

Parameters:
-----------

ids_result:  The ids of the intersected entities are saved in a
vector. This allows is more efficent than using a set and allows a map
between ";

%feature("docstring")  dolfin::Mesh::all_intersected_entities "

Compute all id of all cells which are intersects by any of the
entities in entities. This

Parameters:
-----------

ids_result:  The ids of the intersected set are saved in a set for
efficienty reasons, to avoid to sort out duplicates later on. ";

%feature("docstring")  dolfin::Mesh::all_intersected_entities "

Compute all id of all cells which are intersects by the given mesh
another_mesh;

Parameters:
-----------

ids_result:  The ids of the intersected entities are saved in a set
for efficienty reasons, to avoid to sort out duplicates later on. ";

%feature("docstring")  dolfin::Mesh::any_intersected_entity "

Computes only the first id of the entity, which contains the point.
Returns -1 if no cell is intersected. ";

%feature("docstring")  dolfin::Mesh::closest_point "

Computes the point inside the mesh which are closest to the point
query. ";

%feature("docstring")  dolfin::Mesh::closest_cell "

Computes the index of the cell in the mesh which are closest to the
point query. ";

%feature("docstring")  dolfin::Mesh::closest_point_and_cell "

Computes the point inside the mesh and the corresponding cell index
which are closest to the point query. ";

%feature("docstring")  dolfin::Mesh::hmin "

Compute minimum cell diameter. ";

%feature("docstring")  dolfin::Mesh::hmax "

Compute maximum cell diameter. ";

%feature("docstring")  dolfin::Mesh::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1MeshConnectivity.xml
%feature("docstring") dolfin::MeshConnectivity "

Mesh connectivity stores a sparse data structure of connections
(incidence relations) between mesh entities for a fixed pair of
topological dimensions.

The connectivity can be specified either by first giving the number of
entities and the number of connections for each entity, which may
either be equal for all entities or different, or by giving the entire
(sparse) connectivity pattern.

C++ includes: MeshConnectivity.h ";

%feature("docstring")  dolfin::MeshConnectivity::MeshConnectivity "

Create empty connectivity between given dimensions (d0 -- d1). ";

%feature("docstring")  dolfin::MeshConnectivity::MeshConnectivity "

Copy constructor. ";

%feature("docstring")  dolfin::MeshConnectivity::~MeshConnectivity "

Destructor. ";

%feature("docstring")  dolfin::MeshConnectivity::size "

Return total number of connections. ";

%feature("docstring")  dolfin::MeshConnectivity::size "

Return number of connections for given entity. ";

%feature("docstring")  dolfin::MeshConnectivity::clear "

Clear all data. ";

%feature("docstring")  dolfin::MeshConnectivity::init "

Initialize number of entities and number of connections (equal for
all). ";

%feature("docstring")  dolfin::MeshConnectivity::init "

Initialize number of entities and number of connections
(individually). ";

%feature("docstring")  dolfin::MeshConnectivity::set "

Set given connection for given entity. ";

%feature("docstring")  dolfin::MeshConnectivity::set "

Set all connections for given entity. ";

%feature("docstring")  dolfin::MeshConnectivity::set "

Set all connections for given entity. ";

%feature("docstring")  dolfin::MeshConnectivity::set "

Set all connections for all entities. ";

%feature("docstring")  dolfin::MeshConnectivity::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1MeshCoordinates.xml
%feature("docstring") dolfin::MeshCoordinates "

This Function represents the mesh coordinates on a given mesh.

C++ includes: SpecialFunctions.h ";

%feature("docstring")  dolfin::MeshCoordinates::MeshCoordinates "

Constructor. ";

%feature("docstring")  dolfin::MeshCoordinates::eval "

Evaluate function. ";


// File: classdolfin_1_1MeshData.xml
%feature("docstring") dolfin::MeshData "

The class MeshData is a container for auxiliary mesh data, represented
either as MeshFunctions over topological mesh entities, arrays or
maps. Each dataset is identified by a unique user-specified string.
Only uint- valued data are currently supported.

The following named mesh data are recognized by DOLFIN:

Boundary indicators

\"boundary facet cells\" - Array<uint> of size num_facets \"boundary
facet numbers\" - Array<uint> of size num_facets \"boundary
indicators\" - Array<uint> of size num_facets \"material indicators\"
- MeshFunction<uint> of dimension D

Boundary indicators (alternative)

\"exterior facet domains\" - MeshFunction<uint> of dimension D - 1

Facet orientation (used for assembly over interior facets)

\"facet orientation\" - MeshFunction<uint> of dimension D - 1

Boundary extraction

\"vertex map\" - MeshFunction<uint> of dimension 0 \"cell map\" -
MeshFunction<uint> of dimension D

Mesh partitioning

\"global entity indices %d\" - MeshFunction<uint> of dimension 0, 1,
..., D \"exterior facets\" - MeshFunction<uint> of dimension D - 1
\"num global entities\" - Array<uint> of size D + 1 \"overlap\" -
vector mapping

Sub meshes

\"global vertex indices\" - MeshFunction<uint> of dimension 0

C++ includes: MeshData.h ";

%feature("docstring")  dolfin::MeshData::MeshData "

Constructor. ";

%feature("docstring")  dolfin::MeshData::~MeshData "

Destructor. ";

%feature("docstring")  dolfin::MeshData::clear "

Clear all data. ";

%feature("docstring")  dolfin::MeshData::create_mesh_function "

Create MeshFunction with given name (uninitialized). ";

%feature("docstring")  dolfin::MeshData::create_mesh_function "

Create MeshFunction with given name and dimension. ";

%feature("docstring")  dolfin::MeshData::create_array "

Create array (vector) with given name and size. ";

%feature("docstring")  dolfin::MeshData::create_mapping "

Create mapping from uint to uint with given name. ";

%feature("docstring")  dolfin::MeshData::create_vector_mapping "

Create mapping from uint to vector of uint with given name. ";

%feature("docstring")  dolfin::MeshData::mesh_function "

Return MeshFunction with given name (returning zero if data is not
available). ";

%feature("docstring")  dolfin::MeshData::array "

Return array with given name (returning zero if data is not
available). ";

%feature("docstring")  dolfin::MeshData::mapping "

Return mapping with given name (returning zero if data is not
available). ";

%feature("docstring")  dolfin::MeshData::vector_mapping "

Return vector mapping with given name (returning zero if data is not
available). ";

%feature("docstring")  dolfin::MeshData::erase_mesh_function "

Erase MeshFunction with given name. ";

%feature("docstring")  dolfin::MeshData::erase_array "

Erase array with given name. ";

%feature("docstring")  dolfin::MeshData::erase_mapping "

Erase mapping with given name. ";

%feature("docstring")  dolfin::MeshData::erase_vector_mapping "

Erase vector mapping with given name. ";

%feature("docstring")  dolfin::MeshData::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1MeshEditor.xml
%feature("docstring") dolfin::MeshEditor "

A simple mesh editor for creating simplicial meshes in 1D, 2D and 3D.

C++ includes: MeshEditor.h ";

%feature("docstring")  dolfin::MeshEditor::MeshEditor "

Constructor. ";

%feature("docstring")  dolfin::MeshEditor::~MeshEditor "

Destructor. ";

%feature("docstring")  dolfin::MeshEditor::open "

Open mesh of given topological and geometrical dimension. ";

%feature("docstring")  dolfin::MeshEditor::open "

Open mesh of given cell type, topological and geometrical dimension.
";

%feature("docstring")  dolfin::MeshEditor::open "

Open mesh of given cell type, topological and geometrical dimension.
";

%feature("docstring")  dolfin::MeshEditor::init_vertices "

Specify number of vertices. ";

%feature("docstring")  dolfin::MeshEditor::init_higher_order_vertices
"

Specify number of vertices. ";

%feature("docstring")  dolfin::MeshEditor::init_cells "

Specify number of cells. ";

%feature("docstring")  dolfin::MeshEditor::init_higher_order_cells "

Specify number of cells. ";

%feature("docstring")  dolfin::MeshEditor::set_affine_cell_indicator "

Set boolean indicator inside MeshGeometry. ";

%feature("docstring")  dolfin::MeshEditor::add_vertex "

Add vertex v at given point p. ";

%feature("docstring")  dolfin::MeshEditor::add_vertex "

Add vertex v at given coordinate x. ";

%feature("docstring")  dolfin::MeshEditor::add_vertex "

Add vertex v at given coordinate (x, y). ";

%feature("docstring")  dolfin::MeshEditor::add_vertex "

Add vertex v at given coordinate (x, y, z). ";

%feature("docstring")  dolfin::MeshEditor::add_higher_order_vertex "

Add vertex v at given point p. ";

%feature("docstring")  dolfin::MeshEditor::add_higher_order_vertex "

Add vertex v at given coordinate x. ";

%feature("docstring")  dolfin::MeshEditor::add_higher_order_vertex "

Add vertex v at given coordinate (x, y). ";

%feature("docstring")  dolfin::MeshEditor::add_higher_order_vertex "

Add vertex v at given coordinate (x, y, z). ";

%feature("docstring")  dolfin::MeshEditor::add_cell "

Add cell with given vertices. ";

%feature("docstring")  dolfin::MeshEditor::add_cell "

Add cell (interval) with given vertices. ";

%feature("docstring")  dolfin::MeshEditor::add_cell "

Add cell (triangle) with given vertices. ";

%feature("docstring")  dolfin::MeshEditor::add_cell "

Add cell (tetrahedron) with given vertices. ";

%feature("docstring")  dolfin::MeshEditor::add_higher_order_cell_data
"

Add higher order cell data (assume P2 triangle for now). ";

%feature("docstring")  dolfin::MeshEditor::close "

Close mesh, finish editing, and order entities locally. ";


// File: classdolfin_1_1MeshEntity.xml
%feature("docstring") dolfin::MeshEntity "

A MeshEntity represents a mesh entity associated with a specific
topological dimension of some mesh.

C++ includes: MeshEntity.h ";

%feature("docstring")  dolfin::MeshEntity::MeshEntity "

Default Constructor. ";

%feature("docstring")  dolfin::MeshEntity::MeshEntity "

Constructor. ";

%feature("docstring")  dolfin::MeshEntity::~MeshEntity "

Destructor. ";

%feature("docstring")  dolfin::MeshEntity::mesh "

Return mesh associated with mesh entity. ";

%feature("docstring")  dolfin::MeshEntity::dim "

Return topological dimension. ";

%feature("docstring")  dolfin::MeshEntity::index "

Return index of mesh entity. ";

%feature("docstring")  dolfin::MeshEntity::num_entities "

Return number of incident mesh entities of given topological
dimension. ";

%feature("docstring")  dolfin::MeshEntity::entities "

Return array of indices for incident mesh entitites of given
topological dimension. ";

%feature("docstring")  dolfin::MeshEntity::incident "

Check if given entity is indicent. ";

%feature("docstring")  dolfin::MeshEntity::intersects "

Check if given point intersects (using inexact but fast numerics). ";

%feature("docstring")  dolfin::MeshEntity::intersects "

Check if given entity intersects (using inexact but fast numerics). ";

%feature("docstring")  dolfin::MeshEntity::intersects_exactly "

Check if given point intersects (using exact numerics). ";

%feature("docstring")  dolfin::MeshEntity::intersects_exactly "

Check if given entity intersects (using exact numerics). ";

%feature("docstring")  dolfin::MeshEntity::index "

Compute local index of given incident entity (error if not found). ";

%feature("docstring")  dolfin::MeshEntity::midpoint "

Compute midpoint of cell. ";

%feature("docstring")  dolfin::MeshEntity::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1MeshEntityIterator.xml
%feature("docstring") dolfin::MeshEntityIterator "

MeshEntityIterator provides a common iterator for mesh entities over
meshes, boundaries and incidence relations. The basic use is
illustrated below.

The following example shows how to iterate over all mesh entities of a
mesh of topological dimension dim:

for ( MeshEntityIterator e(mesh, dim); !e. end(); ++e) { e->foo(); }

The following example shows how to iterate over mesh entities of
topological dimension dim connected (incident) to some mesh entity f:

for ( MeshEntityIterator e(f, dim); !e. end(); ++e) { e->foo(); }

In addition to the general iterator, a set of specific named iterators
are provided for entities of type Vertex, Edge, Face, Facet and Cell.
These iterators are defined along with their respective classes.

C++ includes: MeshEntityIterator.h ";

%feature("docstring")  dolfin::MeshEntityIterator::MeshEntityIterator
"

Default constructor. ";

%feature("docstring")  dolfin::MeshEntityIterator::MeshEntityIterator
"

Create iterator for mesh entities over given topological dimension. ";

%feature("docstring")  dolfin::MeshEntityIterator::MeshEntityIterator
"

Create iterator for entities of given dimension connected to given
entity. ";

%feature("docstring")  dolfin::MeshEntityIterator::~MeshEntityIterator
"

Destructor. ";

%feature("docstring")  dolfin::MeshEntityIterator::MeshEntityIterator
"

Copy Constructor. ";

%feature("docstring")  dolfin::MeshEntityIterator::pos "

Return current position. ";

%feature("docstring")  dolfin::MeshEntityIterator::end "

Check if iterator has reached the end. ";

%feature("docstring")  dolfin::MeshEntityIterator::end_iterator "

Provide a safeguard iterator pointing beyond the end of an iteration
process, either iterating over the mesh /or incident entities. Added
to be bit more like STL iteratoren, since many algorithms rely on a
kind of beyond iterator. ";


// File: classdolfin_1_1MeshFunction.xml
%feature("docstring") dolfin::MeshFunction "

A MeshFunction is a function that can be evaluated at a set of mesh
entities. A MeshFunction is discrete and is only defined at the set of
mesh entities of a fixed topological dimension. A MeshFunction may for
example be used to store a global numbering scheme for the entities of
a (parallel) mesh, marking sub domains or boolean markers for mesh
refinement.

C++ includes: MeshFunction.h ";

%feature("docstring")  dolfin::MeshFunction::MeshFunction "

Create empty mesh function. ";

%feature("docstring")  dolfin::MeshFunction::MeshFunction "

Create empty mesh function on given mesh. ";

%feature("docstring")  dolfin::MeshFunction::MeshFunction "

Create mesh function on given mesh of given dimension. ";

%feature("docstring")  dolfin::MeshFunction::MeshFunction "

Create mesh function on given mesh of given dimension and initialise
to a value ";

%feature("docstring")  dolfin::MeshFunction::MeshFunction "

Create function from data file. ";

%feature("docstring")  dolfin::MeshFunction::MeshFunction "

Copy constructor. ";

%feature("docstring")  dolfin::MeshFunction::~MeshFunction "

Destructor. ";

%feature("docstring")  dolfin::MeshFunction::mesh "

Return mesh associated with mesh function. ";

%feature("docstring")  dolfin::MeshFunction::dim "

Return topological dimension. ";

%feature("docstring")  dolfin::MeshFunction::size "

Return size (number of entities). ";

%feature("docstring")  dolfin::MeshFunction::values "

Return array of values. ";

%feature("docstring")  dolfin::MeshFunction::values "

Return array of values. ";

%feature("docstring")  dolfin::MeshFunction::init "

Initialize mesh function for given topological dimension. ";

%feature("docstring")  dolfin::MeshFunction::init "

Initialize mesh function for given topological dimension of given
size. ";

%feature("docstring")  dolfin::MeshFunction::init "

Initialize mesh function for given topological dimension. ";

%feature("docstring")  dolfin::MeshFunction::init "

Initialize mesh function for given topological dimension of given
size. ";

%feature("docstring")  dolfin::MeshFunction::set_all "

Set all values to given value. ";

%feature("docstring")  dolfin::MeshFunction::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::MeshFunction::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::MeshFunction::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1MeshGeometry.xml
%feature("docstring") dolfin::MeshGeometry "";

%feature("docstring")  dolfin::MeshGeometry::MeshGeometry "

Create empty set of coordinates. ";

%feature("docstring")  dolfin::MeshGeometry::MeshGeometry "

Copy constructor. ";

%feature("docstring")  dolfin::MeshGeometry::~MeshGeometry "

Destructor. ";

%feature("docstring")  dolfin::MeshGeometry::dim "

Return Euclidean dimension of coordinate system. ";

%feature("docstring")  dolfin::MeshGeometry::size "

Return number of coordinates. ";

%feature("docstring")  dolfin::MeshGeometry::x "

Return value of coordinate n in direction i. ";

%feature("docstring")  dolfin::MeshGeometry::x "

Return value of coordinate n in direction i. ";

%feature("docstring")  dolfin::MeshGeometry::x "

Return array of values for coordinate n. ";

%feature("docstring")  dolfin::MeshGeometry::x "

Return array of values for coordinate n. ";

%feature("docstring")  dolfin::MeshGeometry::x "

Return array of values for all coordinates. ";

%feature("docstring")  dolfin::MeshGeometry::x "

Return array of values for all coordinates. ";

%feature("docstring")  dolfin::MeshGeometry::higher_order_x "

Return array of values for higher order coordinate n. ";

%feature("docstring")  dolfin::MeshGeometry::higher_order_x "

Return array of values for higher order coordinate n. ";

%feature("docstring")  dolfin::MeshGeometry::higher_order_x "

Return array of values for all higher order coordinates. ";

%feature("docstring")  dolfin::MeshGeometry::higher_order_x "

Return array of values for all higher order coordinates. ";

%feature("docstring")
dolfin::MeshGeometry::num_higher_order_vertices_per_cell "

Return number of vertices used (per cell) to represent the higher
order geometry. ";

%feature("docstring")  dolfin::MeshGeometry::higher_order_cell "

Return array of higher order vertex indices for a specific higher
order cell. ";

%feature("docstring")  dolfin::MeshGeometry::higher_order_cell "

Return array of higher order vertex indices for a specific higher
order cell. ";

%feature("docstring")  dolfin::MeshGeometry::higher_order_cells "

Return array of values for all higher order cell data. ";

%feature("docstring")  dolfin::MeshGeometry::higher_order_cells "

Return array of values for all higher order cell data. ";

%feature("docstring")  dolfin::MeshGeometry::point "

Return coordinate n as a 3D point value. ";

%feature("docstring")  dolfin::MeshGeometry::affine_cell_bool "

Return pointer to boolean affine indicator array. ";

%feature("docstring")  dolfin::MeshGeometry::clear "

Clear all data. ";

%feature("docstring")  dolfin::MeshGeometry::init "

Initialize coordinate list to given dimension and size. ";

%feature("docstring")
dolfin::MeshGeometry::init_higher_order_vertices "

Initialize higher order coordinate list to given dimension and size.
";

%feature("docstring")  dolfin::MeshGeometry::init_higher_order_cells "

Initialize higher order cell data list to given number of cells and
dofs. ";

%feature("docstring")  dolfin::MeshGeometry::init_affine_indicator "

Initialize the affine indicator array. ";

%feature("docstring")  dolfin::MeshGeometry::set_affine_indicator "

set affine indicator at index i ";

%feature("docstring")  dolfin::MeshGeometry::set "

Set value of coordinate n in direction i. ";

%feature("docstring")
dolfin::MeshGeometry::set_higher_order_coordinates "

Set value of higher order coordinate N in direction i. ";

%feature("docstring")
dolfin::MeshGeometry::set_higher_order_cell_data "

Set higher order cell data for cell # N in direction i. ";

%feature("docstring")  dolfin::MeshGeometry::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1MeshPartitioning.xml
%feature("docstring") dolfin::MeshPartitioning "

This class partitions and distributes a mesh based on partitioned
local mesh data. Note that the local mesh data will also be
repartitioned and redistributed during the computation of the mesh
partitioning.

After partitioning, each process has a local mesh and set of mesh data
that couples the meshes together.

The following mesh data is created:

1. \"global entity indices 0\" ( MeshFunction<uint>)

This maps each local vertex to its global index.

2. \"overlap\" (std::map<uint, std::vector<uint> >)

This maps each shared vertex to a list of the processes sharing the
vertex.

3. \"global entity indices %d\" ( MeshFunction<uint>)

After partitioning, the function number_entities() may be called to
create global indices for all entities of a given topological
dimension. These are stored as mesh data ( MeshFunction<uint>) named

\"global entity indices 1\" \"global entity indices 2\" etc

4. \"num global entities\" (std::vector<uint>)

The function number_entities also records the number of global
entities for the dimension of the numbered entities in the array named
\"num global entities\". This array has size D + 1, where D is the
topological dimension of the mesh. This array is initially created by
the mesh and then contains only the number entities of dimension 0
(vertices) and dimension D (cells).

C++ includes: MeshPartitioning.h ";


// File: classdolfin_1_1MeshTopology.xml
%feature("docstring") dolfin::MeshTopology "

MeshTopology stores the topology of a mesh, consisting of mesh
entities and connectivity (incidence relations for the mesh entities).
Note that the mesh entities don't need to be stored, only the number
of entities and the connectivity. Any numbering scheme for the mesh
entities is stored separately in a MeshFunction over the entities.

A mesh entity e may be identified globally as a pair e = (dim, i),
where dim is the topological dimension and i is the index of the
entity within that topological dimension.

C++ includes: MeshTopology.h ";

%feature("docstring")  dolfin::MeshTopology::MeshTopology "

Create empty mesh topology. ";

%feature("docstring")  dolfin::MeshTopology::MeshTopology "

Copy constructor. ";

%feature("docstring")  dolfin::MeshTopology::~MeshTopology "

Destructor. ";

%feature("docstring")  dolfin::MeshTopology::dim "

Return topological dimension. ";

%feature("docstring")  dolfin::MeshTopology::size "

Return number of entities for given dimension. ";

%feature("docstring")  dolfin::MeshTopology::clear "

Clear all data. ";

%feature("docstring")  dolfin::MeshTopology::init "

Initialize topology of given maximum dimension. ";

%feature("docstring")  dolfin::MeshTopology::init "

Set number of entities (size) for given topological dimension. ";

%feature("docstring")  dolfin::MeshTopology::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1Method.xml
%feature("docstring") dolfin::Method "

Base class for cGqMethod and dGqMethod, which contain all numeric
constants, such as nodal points and nodal weights, needed for the
method.

C++ includes: Method.h ";

%feature("docstring")  dolfin::Method::Method "

Constructor. ";

%feature("docstring")  dolfin::Method::~Method "

Destructor. ";

%feature("docstring")  dolfin::Method::type "

Return type (inline optimized). ";

%feature("docstring")  dolfin::Method::degree "

Return degree (inline optimized). ";

%feature("docstring")  dolfin::Method::order "

Return order (inline optimized). ";

%feature("docstring")  dolfin::Method::nsize "

Return number of nodal points (inline optimized). ";

%feature("docstring")  dolfin::Method::qsize "

Return number of quadrature points (inline optimized). ";

%feature("docstring")  dolfin::Method::npoint "

Return nodal point (inline optimized). ";

%feature("docstring")  dolfin::Method::qpoint "

Return quadrature point (inline optimized). ";

%feature("docstring")  dolfin::Method::nweight "

Return nodal weight j for node i, including quadrature (inline
optimized). ";

%feature("docstring")  dolfin::Method::qweight "

Return quadrature weight, including only quadrature (inline
optimized). ";

%feature("docstring")  dolfin::Method::eval "

Evaluation of trial space basis function i at given tau (inline
optimized). ";

%feature("docstring")  dolfin::Method::derivative "

Evaluation of derivative of basis function i at t = 1 (inline
optimized). ";

%feature("docstring")  dolfin::Method::update "

Update solution values using fixed-point iteration. ";

%feature("docstring")  dolfin::Method::update "

Update solution values using fixed-point iteration (damped version).
";

%feature("docstring")  dolfin::Method::ueval "

Evaluate solution at given point. ";

%feature("docstring")  dolfin::Method::ueval "

Evaluate solution at given node. ";

%feature("docstring")  dolfin::Method::residual "

Compute residual at right end-point. ";

%feature("docstring")  dolfin::Method::timestep "

Compute new time step based on the given residual. ";

%feature("docstring")  dolfin::Method::error "

Compute error estimate (modulo stability factor). ";

%feature("docstring")  dolfin::Method::get_nodal_values "

Get nodal values. ";

%feature("docstring")  dolfin::Method::get_trial "

Get trial functions. ";

%feature("docstring")  dolfin::Method::get_quadrature_weights "

Get quadrature weights. ";

%feature("docstring")  dolfin::Method::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1MPI.xml
%feature("docstring") dolfin::MPI "

This class provides utility functions for easy communcation with MPI.

C++ includes: MPI.h ";


// File: classdolfin_1_1NewtonSolver.xml
%feature("docstring") dolfin::NewtonSolver "

This class defines a Newton solver for equations of the form F(u) = 0.

C++ includes: NewtonSolver.h ";

%feature("docstring")  dolfin::NewtonSolver::NewtonSolver "

Create nonlinear solver with default linear solver and default linear
algebra backend ";

%feature("docstring")  dolfin::NewtonSolver::NewtonSolver "

Create nonlinear solver using provided linear solver and linear
algebra backend determined by factory ";

%feature("docstring")  dolfin::NewtonSolver::~NewtonSolver "

Destructor. ";

%feature("docstring")  dolfin::NewtonSolver::solve "

Solve abstract nonlinear problem F(x) = 0 for given vector F and
Jacobian dF/dx ";

%feature("docstring")  dolfin::NewtonSolver::iteration "

Return Newton iteration number. ";


// File: classdolfin_1_1NonlinearProblem.xml
%feature("docstring") dolfin::NonlinearProblem "

This is a base class for nonlinear problems which can return the
nonlinear function F(u) and its Jacobian J = dF(u)/du.

C++ includes: NonlinearProblem.h ";

%feature("docstring")  dolfin::NonlinearProblem::NonlinearProblem "

Constructor. ";

%feature("docstring")  dolfin::NonlinearProblem::~NonlinearProblem "

Destructor. ";

%feature("docstring")  dolfin::NonlinearProblem::form "

Function called by Newton solver before requesting F or J. This can be
used to compute F and J together ";

%feature("docstring")  dolfin::NonlinearProblem::F "

Compute F at current point x. ";

%feature("docstring")  dolfin::NonlinearProblem::J "

Compute J = F' at current point x. ";


// File: classdolfin_1_1ODE.xml
%feature("docstring") dolfin::ODE "

An ODE represents an initial value problem of the form

u'(t) = f(u(t), t) on [0, T],

u(0) = u0,

where u(t) is a vector of length N.

To define an ODE, a user must create a subclass of ODE and create the
function u0() defining the initial condition, as well the function f()
defining the right-hand side.

DOLFIN provides two types of ODE solvers: a set of standard mono-
adaptive solvers with equal adaptive time steps for all components as
well as a set of multi-adaptive solvers with individual and adaptive
time steps for the different components. The right-hand side f() is
defined differently for the two sets of methods, with the multi-
adaptive solvers requiring a component-wise evaluation of the right-
hand side. Only one right-hand side function f() needs to be defined
for use of any particular solver.

It is also possible to solve implicit systems of the form

M(u(t), t) u'(t) = f(u(t),t) on (0,T],

u(0) = u0,

by setting the option \"implicit\" to true and defining the function
M().

Two different solve() functions are provided, one to solve the ODE on
the time interval [0, T], including the solution of a dual problem for
error control:

ode.solve();

Alternatively, a time interval may be given in which case the solution
will be computed in a single sweep over the given time interval
without solution of dual problems:

ode.solve(t0, t1);

This mode allows the state to be specified and retrieved in between
intervals by calling set_state() and get_state().

C++ includes: ODE.h ";

%feature("docstring")  dolfin::ODE::ODE "

Create an ODE of size N with final time T. ";

%feature("docstring")  dolfin::ODE::~ODE "

Destructor. ";

%feature("docstring")  dolfin::ODE::u0 "

Set initial values. ";

%feature("docstring")  dolfin::ODE::f "

Evaluate right-hand side y = f(u, t), mono-adaptive version (default,
optional). ";

%feature("docstring")  dolfin::ODE::f "

Evaluate right-hand side f_i(u, t), multi-adaptive version (optional).
";

%feature("docstring")  dolfin::ODE::M "

Compute product dy = M dx for implicit system (optional). ";

%feature("docstring")  dolfin::ODE::J "

Compute product dy = J dx for Jacobian J (optional). ";

%feature("docstring")  dolfin::ODE::JT "

Compute product dy = tranpose(J) dx for Jacobian J (optional, for dual
problem). ";

%feature("docstring")  dolfin::ODE::dfdu "

Compute entry of Jacobian (optional). ";

%feature("docstring")  dolfin::ODE::timestep "

Time step to use for the whole system at a given time t (optional). ";

%feature("docstring")  dolfin::ODE::timestep "

Time step to use for a given component at a given time t (optional).
";

%feature("docstring")  dolfin::ODE::update "

Update ODE, return false to stop (optional). ";

%feature("docstring")  dolfin::ODE::save "

Save sample (optional). ";

%feature("docstring")  dolfin::ODE::size "

Return number of components N. ";

%feature("docstring")  dolfin::ODE::time "

Return current time. ";

%feature("docstring")  dolfin::ODE::time "

Return real time (might be flipped backwards for dual). ";

%feature("docstring")  dolfin::ODE::endtime "

Return end time (final time T). ";

%feature("docstring")  dolfin::ODE::sparse "

Automatically detect sparsity (optional). ";

%feature("docstring")  dolfin::ODE::solve "

Solve ODE on [0, T]. ";

%feature("docstring")  dolfin::ODE::solve "

Solve ODE on [t0, t1]. ";

%feature("docstring")  dolfin::ODE::solve "

Solve ODE on [0, T]. Save solution in u. ";

%feature("docstring")  dolfin::ODE::solve "

Solve ODE on [t0, t1]. Save solution in u. ";

%feature("docstring")  dolfin::ODE::solve_dual "

Solve dual problem given an approximate solution u of the primal
problem. ";

%feature("docstring")  dolfin::ODE::solve_dual "

Solve dual and save soution in z. ";

%feature("docstring")  dolfin::ODE::analyze_stability "

Compute stability factors as function of T (including solving the dual
problem). The stability factor is the integral of the norm of the q'th
derivative of the dual. ";

%feature("docstring")  dolfin::ODE::analyze_stability_discretization "

Compute stability factors as function of T (including solving the dual
problem). The stability factor accounts for stability wrt the
discretization scheme. ";

%feature("docstring")  dolfin::ODE::analyze_stability_computation "

Compute stability factors as function of T (including solving the dual
problem). The stability factor accounts for stability wrt the round-
off errors. ";

%feature("docstring")  dolfin::ODE::analyze_stability_initial "

Compute stability factors as function of T (including solving the dual
problem). The stability factor accounts for stability wrt errors in
initial data. ";

%feature("docstring")  dolfin::ODE::set_state "

Set state for ODE (only available during interval stepping). ";

%feature("docstring")  dolfin::ODE::get_state "

Get state for ODE (only available during interval stepping). ";


// File: classdolfin_1_1ODECollection.xml
%feature("docstring") dolfin::ODECollection "

An ODECollection represents a collection of initial value problems of
the form

u'(t) = f(u(t), t) on (0, T],

u(0) = u0,

where u(t) is a vector of length N.

Each ODE is governed by the same equation but a separate state is
maintained for each ODE. Using ODECollection is recommended when
solving a large number of ODEs and the overhead of instantiating a
large number of ODE objects should be avoided.

C++ includes: ODECollection.h ";

%feature("docstring")  dolfin::ODECollection::ODECollection "

Create a collection of ODEs. ";

%feature("docstring")  dolfin::ODECollection::~ODECollection "

Destructor. ";

%feature("docstring")  dolfin::ODECollection::solve "

Solve ODE collection on [t0, t1]. ";

%feature("docstring")  dolfin::ODECollection::set_state "

Set state for given ODE system. ";

%feature("docstring")  dolfin::ODECollection::set_state "

Set states for all ODE systems. ";

%feature("docstring")  dolfin::ODECollection::get_state "

Get state for given ODE system. ";

%feature("docstring")  dolfin::ODECollection::get_state "

Get states for all ODE systems. ";

%feature("docstring")  dolfin::ODECollection::update "

Optional user-defined update, called between solves. ";


// File: classdolfin_1_1ODESolution.xml
%feature("docstring") dolfin::ODESolution "";

%feature("docstring")  dolfin::ODESolution::ODESolution "

Create solution data for given ODE. ";

%feature("docstring")  dolfin::ODESolution::ODESolution "";

%feature("docstring")  dolfin::ODESolution::~ODESolution "

Destructor. ";

%feature("docstring")  dolfin::ODESolution::init "";

%feature("docstring")  dolfin::ODESolution::add_timeslab "";

%feature("docstring")  dolfin::ODESolution::flush "

Make object ready for evaluating, set to read mode. ";

%feature("docstring")  dolfin::ODESolution::eval "

Evaluate (interpolate) value of solution at given time. ";

%feature("docstring")  dolfin::ODESolution::get_timeslab "

Get timeslab (used when iterating). ";

%feature("docstring")  dolfin::ODESolution::get_weights "

Get pointer to weights. ";

%feature("docstring")  dolfin::ODESolution::set_filename "";

%feature("docstring")  dolfin::ODESolution::save_to_file "";

%feature("docstring")  dolfin::ODESolution::str "";

%feature("docstring")  dolfin::ODESolution::size "";

%feature("docstring")  dolfin::ODESolution::nsize "";

%feature("docstring")  dolfin::ODESolution::endtime "";

%feature("docstring")  dolfin::ODESolution::begin "";

%feature("docstring")  dolfin::ODESolution::end "";


// File: classdolfin_1_1ODESolutionData.xml
%feature("docstring") dolfin::ODESolutionData "";

%feature("docstring")  dolfin::ODESolutionData::ODESolutionData "";

%feature("docstring")  dolfin::ODESolutionData::ODESolutionData "";

%feature("docstring")  dolfin::ODESolutionData::~ODESolutionData "";

%feature("docstring")  dolfin::ODESolutionData::b "";


// File: classdolfin_1_1ODESolutionIterator.xml
%feature("docstring") dolfin::ODESolutionIterator "";

%feature("docstring")
dolfin::ODESolutionIterator::ODESolutionIterator "";

%feature("docstring")
dolfin::ODESolutionIterator::ODESolutionIterator "";

%feature("docstring")
dolfin::ODESolutionIterator::ODESolutionIterator "";

%feature("docstring")  dolfin::ODESolutionIterator::get_index "";

%feature("docstring")  dolfin::ODESolutionIterator::get_ODESolution "";


// File: classdolfin_1_1Parameter.xml
%feature("docstring") dolfin::Parameter "

Base class for parameters.

C++ includes: Parameter.h ";

%feature("docstring")  dolfin::Parameter::Parameter "

Create parameter for given key. ";

%feature("docstring")  dolfin::Parameter::~Parameter "

Destructor. ";

%feature("docstring")  dolfin::Parameter::key "

Return parameter key. ";

%feature("docstring")  dolfin::Parameter::description "

Return parameter description. ";

%feature("docstring")  dolfin::Parameter::access_count "

Return access count (number of times parameter has been accessed). ";

%feature("docstring")  dolfin::Parameter::change_count "

Return change count (number of times parameter has been changed). ";

%feature("docstring")  dolfin::Parameter::set_range "

Set range for int-valued parameter. ";

%feature("docstring")  dolfin::Parameter::set_range "

Set range for double-valued parameter. ";

%feature("docstring")  dolfin::Parameter::set_range "

Set range for string-valued parameter. ";

%feature("docstring")  dolfin::Parameter::get_range "

Get range for int-valued parameter. ";

%feature("docstring")  dolfin::Parameter::get_range "

Get range for double-valued parameter. ";

%feature("docstring")  dolfin::Parameter::get_range "

Get range for string-valued parameter. ";

%feature("docstring")  dolfin::Parameter::get_real "

Get real value of parameter with (possibly) extended precision. ";

%feature("docstring")  dolfin::Parameter::type_str "

Return value type string. ";

%feature("docstring")  dolfin::Parameter::value_str "

Return value string. ";

%feature("docstring")  dolfin::Parameter::range_str "

Return range string. ";

%feature("docstring")  dolfin::Parameter::str "

Return short string description. ";


// File: classdolfin_1_1Parameters.xml
%feature("docstring") dolfin::Parameters "

This class stores a set of parameters. Each parameter is identified by
a unique string (the key) and a value of some given value type.
Parameter sets can be nested at arbitrary depths.

A parameter may be either int, double, string or boolean valued.

Parameters may be added as follows:

Parameters p(\"my_parameters\"); p.add(\"relative_tolerance\", 1e-15);
p.add(\"absolute_tolerance\", 1e-15); p.add(\"gmres_restart\", 30);
p.add(\"monitor_convergence\", false);

Parameters may be changed as follows:

p(\"gmres_restart\") = 50;

Parameter values may be retrieved as follows:

int gmres_restart = p(\"gmres_restart\");

Parameter sets may be nested as follows:

Parameters q(\"nested_parameters\"); p.add(q);

Nested parameters may then be accessed by

p[\"nested_parameters\"](\"...\")

Parameters may be nested at arbitrary depths.

Parameters may be parsed from the command-line as follows:

p.parse(argc, argv);

Note: spaces in parameter keys are not allowed (to simplify usage from
command-line).

C++ includes: Parameters.h ";

%feature("docstring")  dolfin::Parameters::Parameters "

Create empty parameter set. ";

%feature("docstring")  dolfin::Parameters::~Parameters "

Destructor. ";

%feature("docstring")  dolfin::Parameters::Parameters "

Copy constructor. ";

%feature("docstring")  dolfin::Parameters::name "

Return name for parameter set. ";

%feature("docstring")  dolfin::Parameters::rename "

Rename parameter set. ";

%feature("docstring")  dolfin::Parameters::clear "

Clear parameter set. ";

%feature("docstring")  dolfin::Parameters::add "

Add int-valued parameter. ";

%feature("docstring")  dolfin::Parameters::add "

Add int-valued parameter with given range. ";

%feature("docstring")  dolfin::Parameters::add "

Add double-valued parameter. ";

%feature("docstring")  dolfin::Parameters::add "

Add double-valued parameter with given range. ";

%feature("docstring")  dolfin::Parameters::add "

Add string-valued parameter. ";

%feature("docstring")  dolfin::Parameters::add "

Add string-valued parameter. ";

%feature("docstring")  dolfin::Parameters::add "

Add string-valued parameter with given range. ";

%feature("docstring")  dolfin::Parameters::add "

Add string-valued parameter with given range. ";

%feature("docstring")  dolfin::Parameters::add "

Add bool-valued parameter. ";

%feature("docstring")  dolfin::Parameters::add "

Add nested parameter set. ";

%feature("docstring")  dolfin::Parameters::parse "

Parse parameters from command-line. ";

%feature("docstring")  dolfin::Parameters::update "

Update parameters with another set of parameters. ";

%feature("docstring")  dolfin::Parameters::has_key "

Check if parameter set has given key. ";

%feature("docstring")  dolfin::Parameters::get_parameter_keys "

Return a vector of parameter keys. ";

%feature("docstring")  dolfin::Parameters::get_parameter_set_keys "

Return a vector of parameter set keys. ";

%feature("docstring")  dolfin::Parameters::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1PeriodicBC.xml
%feature("docstring") dolfin::PeriodicBC "

This class specifies the interface for setting periodic boundary
conditions for partial differential equations,

u(x) = u(F^{-1}(x)) on G, u(x) = u(F(x)) on H,

where F : H --> G is a map from a subdomain H to a subdomain G.

A periodic boundary condition must be defined by the domain G and the
map F pulling coordinates back from H to G. The domain and the map are
both defined by a subclass of SubDomain which must overload both the
inside() function, which specifies the points of G, and the map()
function, which specifies the map from the points of H to the points
of G.

The implementation is based on matching degrees of freedom on G with
degrees of freedom on H and only works when the mapping F is bijective
between the sets of coordinates associated with the two domains. In
other words, the nodes (degrees of freedom) must be aligned on G and
H.

The matching of degrees of freedom is done at the construction of the
periodic boundary condition and is reused on subsequent applications
to a linear system. The matching may be recomputed by calling the
rebuild() function.

C++ includes: PeriodicBC.h ";

%feature("docstring")  dolfin::PeriodicBC::PeriodicBC "

Create periodic boundary condition for sub domain. ";

%feature("docstring")  dolfin::PeriodicBC::PeriodicBC "

Create periodic boundary condition for sub domain. ";

%feature("docstring")  dolfin::PeriodicBC::~PeriodicBC "

Destructor. ";

%feature("docstring")  dolfin::PeriodicBC::apply "

Apply boundary condition to a matrix. ";

%feature("docstring")  dolfin::PeriodicBC::apply "

Apply boundary condition to a vector. ";

%feature("docstring")  dolfin::PeriodicBC::apply "

Apply boundary condition to a linear system. ";

%feature("docstring")  dolfin::PeriodicBC::apply "

Apply boundary condition to a vector for a nonlinear problem. ";

%feature("docstring")  dolfin::PeriodicBC::apply "

Apply boundary condition to a linear system for a nonlinear problem.
";

%feature("docstring")  dolfin::PeriodicBC::rebuild "

Rebuild mapping between dofs. ";


// File: classdolfin_1_1PETScObject.xml
%feature("docstring") dolfin::PETScObject "

This class calls SubSystemsManger to initialise PETSc.

All PETSc objects must be derived from this class.

C++ includes: PETScObject.h ";

%feature("docstring")  dolfin::PETScObject::PETScObject "";


// File: classdolfin_1_1Point.xml
%feature("docstring") dolfin::Point "

A Point represents a point in R^3 with coordinates x, y, z, or,
alternatively, a vector in R^3, supporting standard operations like
the norm, distances, scalar and vector products etc.

C++ includes: Point.h ";

%feature("docstring")  dolfin::Point::Point "

Create a point at (x, y, z). ";

%feature("docstring")  dolfin::Point::Point "

Create point from array. ";

%feature("docstring")  dolfin::Point::Point "

Copy constructor. ";

%feature("docstring")  dolfin::Point::~Point "

Destructor. ";

%feature("docstring")  dolfin::Point::x "

Return x-coordinate. ";

%feature("docstring")  dolfin::Point::y "

Return y-coordinate. ";

%feature("docstring")  dolfin::Point::z "

Return z-coordinate. ";

%feature("docstring")  dolfin::Point::coordinates "

Return coordinate array. ";

%feature("docstring")  dolfin::Point::distance "

Compute distance to given point. ";

%feature("docstring")  dolfin::Point::norm "

Compute norm of point representing a vector from the origin. ";

%feature("docstring")  dolfin::Point::cross "

Compute cross product with given vector. ";

%feature("docstring")  dolfin::Point::dot "

Compute dot product with given vector. ";

%feature("docstring")  dolfin::Point::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1PrimitiveIntersector.xml
%feature("docstring") dolfin::PrimitiveIntersector "

This class implements an intersection detection, detecting whether two
given (arbitrary) meshentities intersect.

C++ includes: PrimitiveIntersector.h ";


// File: classdolfin_1_1Progress.xml
%feature("docstring") dolfin::Progress "

This class provides a simple way to create and update progress bars
during a computation. A progress bar may be used either in an
iteration with a known number of steps:

Progress p(\"Iterating...\", n); for (int i = 0; i < n; i++) { ...
p++; }

or in an iteration with an unknown number of steps:

Progress p(\"Iterating...\"); while (t < T) { ... p = t / T; }

C++ includes: Progress.h ";

%feature("docstring")  dolfin::Progress::Progress "

Create progress bar with a known number of steps. ";

%feature("docstring")  dolfin::Progress::Progress "

Create progress bar with an unknown number of steps. ";

%feature("docstring")  dolfin::Progress::~Progress "

Destructor. ";


// File: classdolfin_1_1Quadrature.xml
%feature("docstring") dolfin::Quadrature "";

%feature("docstring")  dolfin::Quadrature::Quadrature "

Constructor. ";

%feature("docstring")  dolfin::Quadrature::~Quadrature "

Destructor. ";

%feature("docstring")  dolfin::Quadrature::size "

Return number of quadrature points. ";

%feature("docstring")  dolfin::Quadrature::point "

Return quadrature point. ";

%feature("docstring")  dolfin::Quadrature::weight "

Return quadrature weight. ";

%feature("docstring")  dolfin::Quadrature::measure "

Return sum of weights (length, area, volume). ";


// File: classdolfin_1_1RadauQuadrature.xml
%feature("docstring") dolfin::RadauQuadrature "

Radau (Gauss-Radau) quadrature on the interval [-1,1]. The n
quadrature points are given by the zeros of

( Pn-1(x) + Pn(x) ) / (1+x)

where Pn is the n:th Legendre polynomial.

The quadrature points are computed using Newton's method, and the
quadrature weights are computed by solving a linear system determined
by the condition that Radau quadrature with n points should be exact
for polynomials of degree 2n-2.

C++ includes: RadauQuadrature.h ";

%feature("docstring")  dolfin::RadauQuadrature::RadauQuadrature "

Create Radau quadrature with n points. ";

%feature("docstring")  dolfin::RadauQuadrature::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1RealParameter.xml
%feature("docstring") dolfin::RealParameter "

Parameter with value type double.

C++ includes: Parameter.h ";

%feature("docstring")  dolfin::RealParameter::RealParameter "

Create double-valued parameter. ";

%feature("docstring")  dolfin::RealParameter::~RealParameter "

Destructor. ";

%feature("docstring")  dolfin::RealParameter::set_range "

Set range. ";

%feature("docstring")  dolfin::RealParameter::get_range "

Get range. ";

%feature("docstring")  dolfin::RealParameter::get_real "

Get real value (possibly with extended precision). ";

%feature("docstring")  dolfin::RealParameter::type_str "

Return value type string. ";

%feature("docstring")  dolfin::RealParameter::value_str "

Return value string. ";

%feature("docstring")  dolfin::RealParameter::range_str "

Return range string. ";

%feature("docstring")  dolfin::RealParameter::str "

Return short string description. ";


// File: classdolfin_1_1Rectangle.xml
%feature("docstring") dolfin::Rectangle "

Triangular mesh of the 2D rectangle (x0, y0) x (x1, y1). Given the
number of cells (nx, ny) in each direction, the total number of
triangles will be 2*nx*ny and the total number of vertices will be (nx
+ 1)*(ny + 1).

std::string diagonal (\"left\", \"right\", \"right/left\" or
\"crossed\") indicates the direction of the diagonals.

C++ includes: Rectangle.h ";

%feature("docstring")  dolfin::Rectangle::Rectangle "";


// File: classdolfin_1_1Sample.xml
%feature("docstring") dolfin::Sample "

Sample of solution values at a given point.

C++ includes: Sample.h ";

%feature("docstring")  dolfin::Sample::Sample "

Constructor. ";

%feature("docstring")  dolfin::Sample::~Sample "

Destructor. ";

%feature("docstring")  dolfin::Sample::size "

Return number of components. ";

%feature("docstring")  dolfin::Sample::t "

Return time t. ";

%feature("docstring")  dolfin::Sample::u "

Return value of component with given index. ";

%feature("docstring")  dolfin::Sample::k "

Return time step for component with given index. ";

%feature("docstring")  dolfin::Sample::r "

Return residual for component with given index. ";


// File: classdolfin_1_1Scalar.xml
%feature("docstring") dolfin::Scalar "

This class represents a real-valued scalar quantity and implements the
GenericTensor interface for scalars.

C++ includes: Scalar.h ";

%feature("docstring")  dolfin::Scalar::Scalar "

Create zero scalar. ";

%feature("docstring")  dolfin::Scalar::~Scalar "

Destructor. ";

%feature("docstring")  dolfin::Scalar::resize "

Resize tensor to given dimensions. ";

%feature("docstring")  dolfin::Scalar::init "

Initialize zero tensor using sparsity pattern. ";

%feature("docstring")  dolfin::Scalar::copy "

Return copy of tensor. ";

%feature("docstring")  dolfin::Scalar::rank "

Return tensor rank (number of dimensions). ";

%feature("docstring")  dolfin::Scalar::size "

Return size of given dimension. ";

%feature("docstring")  dolfin::Scalar::get "

Get block of values. ";

%feature("docstring")  dolfin::Scalar::set "

Set block of values. ";

%feature("docstring")  dolfin::Scalar::add "

Add block of values. ";

%feature("docstring")  dolfin::Scalar::zero "

Set all entries to zero and keep any sparse structure. ";

%feature("docstring")  dolfin::Scalar::apply "

Finalize assembly of tensor. ";

%feature("docstring")  dolfin::Scalar::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::Scalar::factory "

Return a factory for the default linear algebra backend. ";

%feature("docstring")  dolfin::Scalar::getval "

Get value. ";


// File: classdolfin_1_1SystemAssembler_1_1Scratch.xml


// File: classdolfin_1_1Set.xml
%feature("docstring") dolfin::Set "

This is a std::set like data structure. It is not ordered and it is
based a std::vector. It can be faster than a std::set for some cases.

C++ includes: Set.h ";

%feature("docstring")  dolfin::Set::Set "

Create empty set. ";

%feature("docstring")  dolfin::Set::Set "

Wrap std::vectpr as a set. Contents will be erased. ";

%feature("docstring")  dolfin::Set::Set "

Copy constructor. ";

%feature("docstring")  dolfin::Set::~Set "

Destructor. ";

%feature("docstring")  dolfin::Set::find "

Find entry in set and return an iterator to the entry. ";

%feature("docstring")  dolfin::Set::find "

Find entry in set and return an iterator to the entry (const). ";

%feature("docstring")  dolfin::Set::insert "

Insert entry. ";

%feature("docstring")  dolfin::Set::begin "";

%feature("docstring")  dolfin::Set::end "";

%feature("docstring")  dolfin::Set::size "

Set size. ";

%feature("docstring")  dolfin::Set::erase "

Erase an entry. ";

%feature("docstring")  dolfin::Set::sort "

Sort set. ";

%feature("docstring")  dolfin::Set::clear "

Clear set. ";

%feature("docstring")  dolfin::Set::resize "

Resize set. ";

%feature("docstring")  dolfin::Set::set "

Return the vector that stores the data in the Set. ";

%feature("docstring")  dolfin::Set::set "

Return the vector that stores the data in the Set. ";


// File: classdolfin_1_1SingularSolver.xml
%feature("docstring") dolfin::SingularSolver "

This class provides a linear solver for singular linear systems Ax = b
where A has a one-dimensional null-space (kernel). This may happen for
example when solving Poisson's equation with pure Neumann boundary
conditions.

The solver attempts to create an extended non-singular system by
adding the constraint [1, 1, 1, ...]^T x = 0.

If an optional mass matrix M is supplied, the solver attempts to
create an extended non-singular system by adding the constraint m^T x
= 0 where m is the lumped mass matrix. This corresponds to setting the
average (integral) of the finite element function with coefficients x
to zero.

The solver makes not attempt to check that the null-space is indeed
one-dimensional. It is also assumed that the system Ax = b retains its
sparsity pattern between calls to solve().

C++ includes: SingularSolver.h ";

%feature("docstring")  dolfin::SingularSolver::SingularSolver "

Create linear solver. ";

%feature("docstring")  dolfin::SingularSolver::~SingularSolver "

Destructor. ";

%feature("docstring")  dolfin::SingularSolver::solve "

Solve linear system Ax = b. ";

%feature("docstring")  dolfin::SingularSolver::solve "

Solve linear system Ax = b using mass matrix M for setting constraint.
";


// File: classdolfin_1_1SparsityPattern.xml
%feature("docstring") dolfin::SparsityPattern "

This class implements the GenericSparsityPattern interface. It is used
by most linear algebra backends, except for Epetra which uses a
special/native implementation.

C++ includes: SparsityPattern.h ";

%feature("docstring")  dolfin::SparsityPattern::SparsityPattern "

Create empty sparsity pattern. ";

%feature("docstring")  dolfin::SparsityPattern::~SparsityPattern "

Destructor. ";

%feature("docstring")  dolfin::SparsityPattern::init "

Initialize sparsity pattern for a generic tensor. ";

%feature("docstring")  dolfin::SparsityPattern::insert "

Insert non-zero entries. ";

%feature("docstring")  dolfin::SparsityPattern::rank "

Return rank. ";

%feature("docstring")  dolfin::SparsityPattern::size "

Return global size for dimension i. ";

%feature("docstring")  dolfin::SparsityPattern::local_range "

Return local range for dimension dim. ";

%feature("docstring")  dolfin::SparsityPattern::num_nonzeros "

Return total number of nonzeros in local_range for dimension 0. ";

%feature("docstring")  dolfin::SparsityPattern::num_nonzeros_diagonal
"

Fill array with number of nonzeros for diagonal block in local_range
for dimension 0 For matrices, fill array with number of nonzeros per
local row for diagonal block ";

%feature("docstring")
dolfin::SparsityPattern::num_nonzeros_off_diagonal "

Fill array with number of nonzeros for off-diagonal block in
local_range for dimension 0 For matrices, fill array with number of
nonzeros per local row for off-diagonal block ";

%feature("docstring")  dolfin::SparsityPattern::apply "

Finalize sparsity pattern. ";

%feature("docstring")  dolfin::SparsityPattern::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::SparsityPattern::diagonal_pattern "

Return underlying sparsity pattern (diagonal). ";

%feature("docstring")  dolfin::SparsityPattern::off_diagonal_pattern "

Return underlying sparsity pattern (off-diagional). ";


// File: classdolfin_1_1StabilityAnalysis.xml
%feature("docstring") dolfin::StabilityAnalysis "";

%feature("docstring")  dolfin::StabilityAnalysis::StabilityAnalysis "

Constructor. ";

%feature("docstring")  dolfin::StabilityAnalysis::~StabilityAnalysis "

Destructor. ";

%feature("docstring")  dolfin::StabilityAnalysis::analyze_integral "

Compute the integral of the q'th derivative of the dual as function of
(primal) endtime T. ";

%feature("docstring")  dolfin::StabilityAnalysis::analyze_endpoint "

Compute z(0) (the endpoint of the dual) as function of (primal)
endtime T. ";


// File: classdolfin_1_1STLFactory.xml
%feature("docstring") dolfin::STLFactory "";

%feature("docstring")  dolfin::STLFactory::~STLFactory "

Destructor. ";

%feature("docstring")  dolfin::STLFactory::create_matrix "

Create empty matrix. ";

%feature("docstring")  dolfin::STLFactory::create_vector "

Create empty vector (global). ";

%feature("docstring")  dolfin::STLFactory::create_local_vector "

Create empty vector (local). ";

%feature("docstring")  dolfin::STLFactory::create_pattern "

Create empty sparsity pattern. ";


// File: classdolfin_1_1STLMatrix.xml
%feature("docstring") dolfin::STLMatrix "

Simple implementation of a GenericMatrix for experimenting with new
assembly. Not sure this will be used later but it might be useful.

C++ includes: STLMatrix.h ";

%feature("docstring")  dolfin::STLMatrix::STLMatrix "

Create empty matrix. ";

%feature("docstring")  dolfin::STLMatrix::STLMatrix "

Create M x N matrix. ";

%feature("docstring")  dolfin::STLMatrix::STLMatrix "

Copy constructor. ";

%feature("docstring")  dolfin::STLMatrix::~STLMatrix "

Destructor. ";

%feature("docstring")  dolfin::STLMatrix::init "

--- Implementation of the GenericTensor interface ---

Initialize zero tensor using sparsity pattern ";

%feature("docstring")  dolfin::STLMatrix::copy "

Return copy of tensor. ";

%feature("docstring")  dolfin::STLMatrix::size "

Return size of given dimension. ";

%feature("docstring")  dolfin::STLMatrix::zero "

Set all entries to zero and keep any sparse structure. ";

%feature("docstring")  dolfin::STLMatrix::apply "

Finalize assembly of tensor. ";

%feature("docstring")  dolfin::STLMatrix::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::STLMatrix::resize "

Initialize M x N matrix. ";

%feature("docstring")  dolfin::STLMatrix::get "

Get block of values. ";

%feature("docstring")  dolfin::STLMatrix::set "

Set block of values. ";

%feature("docstring")  dolfin::STLMatrix::add "

Add block of values. ";

%feature("docstring")  dolfin::STLMatrix::axpy "

Add multiple of given matrix (AXPY operation). ";

%feature("docstring")  dolfin::STLMatrix::norm "

Return norm of matrix. ";

%feature("docstring")  dolfin::STLMatrix::getrow "

Get non-zero values of given row. ";

%feature("docstring")  dolfin::STLMatrix::setrow "

Set values for given row. ";

%feature("docstring")  dolfin::STLMatrix::zero "

Set given rows to zero. ";

%feature("docstring")  dolfin::STLMatrix::ident "

Set given rows to identity matrix. ";

%feature("docstring")  dolfin::STLMatrix::mult "

Matrix-vector product, y = Ax. ";

%feature("docstring")  dolfin::STLMatrix::transpmult "

Matrix-vector product, y = A^T x. ";

%feature("docstring")  dolfin::STLMatrix::factory "

--- Specialized matrix functions ---

Return linear algebra backend factory ";

%feature("docstring")  dolfin::STLMatrix::resize "

Resize tensor of given rank and dimensions. ";


// File: classdolfin_1_1StringParameter.xml
%feature("docstring") dolfin::StringParameter "

Parameter with value type string.

C++ includes: Parameter.h ";

%feature("docstring")  dolfin::StringParameter::StringParameter "

Create string-valued parameter. ";

%feature("docstring")  dolfin::StringParameter::~StringParameter "

Destructor. ";

%feature("docstring")  dolfin::StringParameter::set_range "

Set range. ";

%feature("docstring")  dolfin::StringParameter::get_range "

Get range. ";

%feature("docstring")  dolfin::StringParameter::type_str "

Return value type string. ";

%feature("docstring")  dolfin::StringParameter::value_str "

Return value string. ";

%feature("docstring")  dolfin::StringParameter::range_str "

Return range string. ";

%feature("docstring")  dolfin::StringParameter::str "

Return short string description. ";


// File: classdolfin_1_1SubDomain.xml
%feature("docstring") dolfin::SubDomain "

This class defines the interface for definition of sub domains.
Alternatively, sub domains may be defined by a Mesh and a
MeshFunction<uint> over the mesh.

C++ includes: SubDomain.h ";

%feature("docstring")  dolfin::SubDomain::SubDomain "

Constructor. ";

%feature("docstring")  dolfin::SubDomain::~SubDomain "

Destructor. ";

%feature("docstring")  dolfin::SubDomain::inside "

Return true for points inside the subdomain. ";

%feature("docstring")  dolfin::SubDomain::map "

Map coordinate x in domain H to coordinate y in domain G (used for
periodic boundary conditions) ";

%feature("docstring")  dolfin::SubDomain::snap "

Snap coordinate to boundary of sub domain. ";

%feature("docstring")  dolfin::SubDomain::mark "

Set sub domain markers for given subdomain. ";

%feature("docstring")  dolfin::SubDomain::geometric_dimension "

Return geometric dimension. ";


// File: classdolfin_1_1SubMatrix.xml
%feature("docstring") dolfin::SubMatrix "";

%feature("docstring")  dolfin::SubMatrix::SubMatrix "";

%feature("docstring")  dolfin::SubMatrix::~SubMatrix "";


// File: classdolfin_1_1SubMesh.xml
%feature("docstring") dolfin::SubMesh "

A SubMesh is a mesh defined as a subset of a given mesh. It provides a
convenient way to create matching meshes for multiphysics applications
by creating meshes for subdomains as subsets of a single global mesh.

C++ includes: SubMesh.h ";

%feature("docstring")  dolfin::SubMesh::SubMesh "

Create subset of given mesh marked by sub domain. ";

%feature("docstring")  dolfin::SubMesh::SubMesh "

Create subset of given mesh marked by mesh function. ";

%feature("docstring")  dolfin::SubMesh::~SubMesh "

Destructor. ";


// File: classdolfin_1_1SubSpace.xml
%feature("docstring") dolfin::SubSpace "

This class represents a subspace (component) of a function space.

The subspace is specified by an array of indices. For example, the
array [3, 0, 2] specifies subspace 2 of subspace 0 of subspace 3.

A typical example is the function space W = V x P for Stokes. Here, V
= W[0] is the subspace for the velocity component and P = W[1] is the
subspace for the pressure component. Furthermore, W[0][0] = V[0] is
the first component of the velocity space etc.

C++ includes: SubSpace.h ";

%feature("docstring")  dolfin::SubSpace::SubSpace "

Create subspace for given component (one level). ";

%feature("docstring")  dolfin::SubSpace::SubSpace "

Create subspace for given component (two levels). ";

%feature("docstring")  dolfin::SubSpace::SubSpace "

Create subspace for given component (n levels). ";


// File: classdolfin_1_1SubVector.xml
%feature("docstring") dolfin::SubVector "";

%feature("docstring")  dolfin::SubVector::SubVector "";

%feature("docstring")  dolfin::SubVector::~SubVector "";


// File: classdolfin_1_1SystemAssembler.xml
%feature("docstring") dolfin::SystemAssembler "

This class provides implements an assembler for systems of the form Ax
= b. It differs from the default DOLFIN assembler in that it assembles
both A and b and the same time (leading to better performance) and in
that it applies boundary conditions at the time of assembly.

C++ includes: SystemAssembler.h ";


// File: classdolfin_1_1Table.xml
%feature("docstring") dolfin::Table "

This class provides storage and pretty-printing for tables. Example
usage:

Table table(\"Timings\");

table(\"uBLAS\", \"Assemble\") = 0.010; table(\"uBLAS\", \"Solve\") =
0.020; table(\"PETSc\", \"Assemble\") = 0.011; table(\"PETSc\",
\"Solve\") = 0.019; table(\"Epetra\", \"Assemble\") = 0.012;
table(\"Epetra\", \"Solve\") = 0.018;

info(table);

C++ includes: Table.h ";

%feature("docstring")  dolfin::Table::Table "

Create empty table. ";

%feature("docstring")  dolfin::Table::~Table "

Destructor. ";

%feature("docstring")  dolfin::Table::set "

Set value of table entry. ";

%feature("docstring")  dolfin::Table::set "

Set value of table entry. ";

%feature("docstring")  dolfin::Table::set "

Set value of table entry. ";

%feature("docstring")  dolfin::Table::set "

Set value of table entry. ";

%feature("docstring")  dolfin::Table::get "

Get value of table entry. ";

%feature("docstring")  dolfin::Table::title "

Return table title. ";

%feature("docstring")  dolfin::Table::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::Table::str_latex "

Return informal string representation for LaTeX. ";


// File: classdolfin_1_1TableEntry.xml
%feature("docstring") dolfin::TableEntry "

This class represents an entry in a Table.

C++ includes: Table.h ";

%feature("docstring")  dolfin::TableEntry::TableEntry "

Create table entry. ";

%feature("docstring")  dolfin::TableEntry::~TableEntry "

Destructor. ";


// File: classdolfin_1_1Timer.xml
%feature("docstring") dolfin::Timer "

A timer can be used for timing tasks. The basic usage is

Timer timer(\"Assembling over cells\");

The timer is started at construction and timing ends when the timer is
destroyed (goes out of scope). It is also possible to start and stop a
timer explicitly by

timer.start(); timer.stop();

Timings are stored globally and a summary may be printed by calling

summary();

C++ includes: Timer.h ";

%feature("docstring")  dolfin::Timer::Timer "

Create timer. ";

%feature("docstring")  dolfin::Timer::~Timer "

Destructor. ";

%feature("docstring")  dolfin::Timer::start "

Start timer. ";

%feature("docstring")  dolfin::Timer::stop "

Stop timer. ";

%feature("docstring")  dolfin::Timer::value "

Return value of timer (or time at start if not stopped). ";


// File: classdolfin_1_1TimeSeries.xml
%feature("docstring") dolfin::TimeSeries "

This class stores a time series of objects to file(s) in a binary
format which is efficient for reading and writing.

When objects are retrieved, the object stored at the time closest to
the given time will be used.

A new time series will check if values have been stored to file before
(for a series with the same name) and in that case reuse those values.
If new values are stored, old values will be cleared.

C++ includes: TimeSeries.h ";

%feature("docstring")  dolfin::TimeSeries::TimeSeries "

Create empty time series. ";

%feature("docstring")  dolfin::TimeSeries::~TimeSeries "

Destructor. ";

%feature("docstring")  dolfin::TimeSeries::store "

Store vector at given time. ";

%feature("docstring")  dolfin::TimeSeries::store "

Store mesh at given time. ";

%feature("docstring")  dolfin::TimeSeries::retrieve "

Retrieve vector at given time. ";

%feature("docstring")  dolfin::TimeSeries::retrieve "

Retrieve mesh at given time. ";

%feature("docstring")  dolfin::TimeSeries::vector_times "

Return array of sample times for vectors. ";

%feature("docstring")  dolfin::TimeSeries::mesh_times "

Return array of sample times for meshes. ";

%feature("docstring")  dolfin::TimeSeries::clear "

Clear time series. ";

%feature("docstring")  dolfin::TimeSeries::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1uBLASFactory.xml
%feature("docstring") dolfin::uBLASFactory "";

%feature("docstring")  dolfin::uBLASFactory::~uBLASFactory "

Destructor. ";

%feature("docstring")  dolfin::uBLASFactory::create_matrix "

Create empty matrix. ";

%feature("docstring")  dolfin::uBLASFactory::create_pattern "

Create empty sparsity pattern. ";

%feature("docstring")  dolfin::uBLASFactory::create_vector "

Create empty vector. ";

%feature("docstring")  dolfin::uBLASFactory::create_local_vector "

Create empty vector (local). ";


// File: classdolfin_1_1uBLASILUPreconditioner.xml
%feature("docstring") dolfin::uBLASILUPreconditioner "

This class implements an incomplete LU factorization (ILU)
preconditioner for the uBLAS Krylov solver.

C++ includes: uBLASILUPreconditioner.h ";

%feature("docstring")
dolfin::uBLASILUPreconditioner::uBLASILUPreconditioner "

Constructor. ";

%feature("docstring")
dolfin::uBLASILUPreconditioner::~uBLASILUPreconditioner "

Destructor. ";

%feature("docstring")  dolfin::uBLASILUPreconditioner::init "

Initialise preconditioner (sparse matrix). ";

%feature("docstring")  dolfin::uBLASILUPreconditioner::solve "

Solve linear system Ax = b approximately. ";


// File: classdolfin_1_1uBLASKrylovMatrix.xml
%feature("docstring") dolfin::uBLASKrylovMatrix "

This class provides an interface for matrices that define linear
systems for the uBLASKrylovSolver. This interface is implemented by
the classes uBLASSparseMatrix and DenseMatrix. Users may also overload
the mult() function to specify a linear system only in terms of its
action.

C++ includes: uBLASKrylovMatrix.h ";

%feature("docstring")  dolfin::uBLASKrylovMatrix::uBLASKrylovMatrix "

Constructor. ";

%feature("docstring")  dolfin::uBLASKrylovMatrix::~uBLASKrylovMatrix "

Destructor. ";

%feature("docstring")  dolfin::uBLASKrylovMatrix::size "

Return number of rows (dim = 0) or columns (dim = 1). ";

%feature("docstring")  dolfin::uBLASKrylovMatrix::mult "

Compute product y = Ax. ";

%feature("docstring")  dolfin::uBLASKrylovMatrix::solve "

Solve linear system Ax = b for a Krylov matrix using uBLAS and dense
matrices. ";

%feature("docstring")  dolfin::uBLASKrylovMatrix::str "

Return informal string representation (pretty-print). ";


// File: classdolfin_1_1uBLASKrylovSolver.xml
%feature("docstring") dolfin::uBLASKrylovSolver "

This class implements Krylov methods for linear systems of the form Ax
= b using uBLAS data types.

C++ includes: uBLASKrylovSolver.h ";

%feature("docstring")  dolfin::uBLASKrylovSolver::uBLASKrylovSolver "

Create Krylov solver for a particular method and preconditioner. ";

%feature("docstring")  dolfin::uBLASKrylovSolver::uBLASKrylovSolver "

Create Krylov solver for a particular uBLASPreconditioner. ";

%feature("docstring")  dolfin::uBLASKrylovSolver::uBLASKrylovSolver "

Create Krylov solver for a particular method and uBLASPreconditioner.
";

%feature("docstring")  dolfin::uBLASKrylovSolver::~uBLASKrylovSolver "

Destructor. ";

%feature("docstring")  dolfin::uBLASKrylovSolver::solve "

Solve linear system Ax = b and return number of iterations. ";

%feature("docstring")  dolfin::uBLASKrylovSolver::solve "

Solve linear system Ax = b and return number of iterations (dense
matrix). ";

%feature("docstring")  dolfin::uBLASKrylovSolver::solve "

Solve linear system Ax = b and return number of iterations (sparse
matrix). ";

%feature("docstring")  dolfin::uBLASKrylovSolver::solve "

Solve linear system Ax = b and return number of iterations (virtual
matrix). ";


// File: classdolfin_1_1uBLASMatrix.xml
%feature("docstring") dolfin::uBLASMatrix "

This class provides a simple matrix class based on uBLAS. It is a
simple wrapper for a uBLAS matrix implementing the GenericMatrix
interface.

The interface is intentionally simple. For advanced usage, access the
underlying uBLAS matrix and use the standard uBLAS interface which is
documented athttp://www.boost.org/libs/numeric/ublas/doc/index.htm.

Developer note: specialised member functions must be inlined to avoid
link errors.

C++ includes: uBLASMatrix.h ";

%feature("docstring")  dolfin::uBLASMatrix::uBLASMatrix "

Create empty matrix. ";

%feature("docstring")  dolfin::uBLASMatrix::uBLASMatrix "

Create M x N matrix. ";

%feature("docstring")  dolfin::uBLASMatrix::uBLASMatrix "

Copy constructor. ";

%feature("docstring")  dolfin::uBLASMatrix::uBLASMatrix "

Create matrix from given uBLAS matrix expression. ";

%feature("docstring")  dolfin::uBLASMatrix::~uBLASMatrix "

Destructor. ";

%feature("docstring")  dolfin::uBLASMatrix::init "

Initialize zero tensor using sparsity pattern. ";

%feature("docstring")  dolfin::uBLASMatrix::copy "

Return copy of tensor. ";

%feature("docstring")  dolfin::uBLASMatrix::size "

Return size of given dimension. ";

%feature("docstring")  dolfin::uBLASMatrix::zero "

Set all entries to zero and keep any sparse structure. ";

%feature("docstring")  dolfin::uBLASMatrix::apply "

Finalize assembly of tensor. ";

%feature("docstring")  dolfin::uBLASMatrix::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::uBLASMatrix::resize "

Resize matrix to M x N. ";

%feature("docstring")  dolfin::uBLASMatrix::get "

Get block of values. ";

%feature("docstring")  dolfin::uBLASMatrix::set "

Set block of values. ";

%feature("docstring")  dolfin::uBLASMatrix::add "

Add block of values. ";

%feature("docstring")  dolfin::uBLASMatrix::axpy "

Add multiple of given matrix (AXPY operation). ";

%feature("docstring")  dolfin::uBLASMatrix::norm "

Return norm of matrix. ";

%feature("docstring")  dolfin::uBLASMatrix::getrow "

Get non-zero values of given row. ";

%feature("docstring")  dolfin::uBLASMatrix::setrow "

Set values for given row. ";

%feature("docstring")  dolfin::uBLASMatrix::zero "

Set given rows to zero. ";

%feature("docstring")  dolfin::uBLASMatrix::ident "

Set given rows to identity matrix. ";

%feature("docstring")  dolfin::uBLASMatrix::mult "

Matrix-vector product, y = Ax. ";

%feature("docstring")  dolfin::uBLASMatrix::transpmult "

Matrix-vector product, y = A^T x. ";

%feature("docstring")  dolfin::uBLASMatrix::data "

Return pointers to underlying compresssed storage data See
GenericMatrix for documentation. ";

%feature("docstring")  dolfin::uBLASMatrix::factory "

Return linear algebra backend factory. ";

%feature("docstring")  dolfin::uBLASMatrix::mat "

Return reference to uBLAS matrix (const version). ";

%feature("docstring")  dolfin::uBLASMatrix::mat "

Return reference to uBLAS matrix (non-const version). ";

%feature("docstring")  dolfin::uBLASMatrix::solve "

Solve Ax = b out-of-place using uBLAS (A is not destroyed). ";

%feature("docstring")  dolfin::uBLASMatrix::solveInPlace "

Solve Ax = b in-place using uBLAS(A is destroyed). ";

%feature("docstring")  dolfin::uBLASMatrix::invert "

Compute inverse of matrix. ";

%feature("docstring")  dolfin::uBLASMatrix::lump "

Lump matrix into vector m. ";

%feature("docstring")  dolfin::uBLASMatrix::compress "

Compress matrix (eliminate all non-zeros from a sparse matrix). ";

%feature("docstring")  dolfin::uBLASMatrix::init "

Initialize zero tensor using sparsity pattern. ";

%feature("docstring")  dolfin::uBLASMatrix::apply "

Finalize assembly of tensor. ";

%feature("docstring")  dolfin::uBLASMatrix::data "

Return pointers to underlying compresssed row/column storage data For
compressed row storage, data = (row_pointer[rows +1],
column_index[nz], matrix_values[nz], nz) ";


// File: classdolfin_1_1uBLASPreconditioner.xml
%feature("docstring") dolfin::uBLASPreconditioner "

This class specifies the interface for preconditioners for the uBLAS
Krylov solver.

C++ includes: uBLASPreconditioner.h ";

%feature("docstring")
dolfin::uBLASPreconditioner::uBLASPreconditioner "

Constructor. ";

%feature("docstring")
dolfin::uBLASPreconditioner::~uBLASPreconditioner "

Destructor. ";

%feature("docstring")  dolfin::uBLASPreconditioner::init "

Initialise preconditioner (sparse matrix). ";

%feature("docstring")  dolfin::uBLASPreconditioner::init "

Initialise preconditioner (dense matrix). ";

%feature("docstring")  dolfin::uBLASPreconditioner::init "

Initialise preconditioner (virtual matrix). ";

%feature("docstring")  dolfin::uBLASPreconditioner::solve "

Solve linear system (M^-1)Ax = y. ";


// File: classdolfin_1_1uBLASVector.xml
%feature("docstring") dolfin::uBLASVector "

This class provides a simple vector class based on uBLAS. It is a
simple wrapper for a uBLAS vector implementing the GenericVector
interface.

The interface is intentionally simple. For advanced usage, access the
underlying uBLAS vector and use the standard uBLAS interface which is
documented athttp://www.boost.org/libs/numeric/ublas/doc/index.htm.

C++ includes: uBLASVector.h ";

%feature("docstring")  dolfin::uBLASVector::uBLASVector "

Create empty vector. ";

%feature("docstring")  dolfin::uBLASVector::uBLASVector "

Create vector of size N. ";

%feature("docstring")  dolfin::uBLASVector::uBLASVector "

Copy constructor. ";

%feature("docstring")  dolfin::uBLASVector::uBLASVector "

Construct vector from a ublas_vector. ";

%feature("docstring")  dolfin::uBLASVector::~uBLASVector "

Destructor. ";

%feature("docstring")  dolfin::uBLASVector::copy "

Create copy of tensor. ";

%feature("docstring")  dolfin::uBLASVector::zero "

Set all entries to zero and keep any sparse structure. ";

%feature("docstring")  dolfin::uBLASVector::apply "

Finalize assembly of tensor. ";

%feature("docstring")  dolfin::uBLASVector::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::uBLASVector::resize "

Resize vector to size N. ";

%feature("docstring")  dolfin::uBLASVector::size "

Return size of vector. ";

%feature("docstring")  dolfin::uBLASVector::local_range "

Return local ownership range of a vector. ";

%feature("docstring")  dolfin::uBLASVector::get "

Get block of values. ";

%feature("docstring")  dolfin::uBLASVector::set "

Set block of values. ";

%feature("docstring")  dolfin::uBLASVector::add "

Add block of values. ";

%feature("docstring")  dolfin::uBLASVector::get_local "

Get all values on local process. ";

%feature("docstring")  dolfin::uBLASVector::set_local "

Set all values on local process. ";

%feature("docstring")  dolfin::uBLASVector::add_local "

Add values to each entry on local process. ";

%feature("docstring")  dolfin::uBLASVector::gather "

Gather entries into local vector x. ";

%feature("docstring")  dolfin::uBLASVector::axpy "

Add multiple of given vector (AXPY operation). ";

%feature("docstring")  dolfin::uBLASVector::inner "

Return inner product with given vector. ";

%feature("docstring")  dolfin::uBLASVector::norm "

Compute norm of vector. ";

%feature("docstring")  dolfin::uBLASVector::min "

Return minimum value of vector. ";

%feature("docstring")  dolfin::uBLASVector::max "

Return maximum value of vector. ";

%feature("docstring")  dolfin::uBLASVector::sum "

Return sum of values of vector. ";

%feature("docstring")  dolfin::uBLASVector::data "

Return pointer to underlying data (const version). ";

%feature("docstring")  dolfin::uBLASVector::data "

Return pointer to underlying data. ";

%feature("docstring")  dolfin::uBLASVector::factory "

Return linear algebra backend factory. ";

%feature("docstring")  dolfin::uBLASVector::vec "

Return reference to uBLAS vector (const version). ";

%feature("docstring")  dolfin::uBLASVector::vec "

Return reference to uBLAS vector (non-const version). ";


// File: classdolfin_1_1UmfpackLUSolver.xml
%feature("docstring") dolfin::UmfpackLUSolver "

This class implements the direct solution (LU factorization) of linear
systems of the form Ax = b using uBLAS data types. Dense matrices are
solved using uBLAS LU factorisation, and sparse matrices are solved
using UMFPACK (http://www.cise.ufl.edu/research/sparse/umfpack/) if
installed. Matrices can also be inverted.

C++ includes: UmfpackLUSolver.h ";

%feature("docstring")  dolfin::UmfpackLUSolver::UmfpackLUSolver "

Constructor. ";

%feature("docstring")  dolfin::UmfpackLUSolver::~UmfpackLUSolver "

Destructor. ";

%feature("docstring")  dolfin::UmfpackLUSolver::solve "

Solve uBLAS linear system Ax = b for a sparse matrix using UMFPACK if
installed. ";

%feature("docstring")  dolfin::UmfpackLUSolver::factorize "

LU-factor sparse matrix A if UMFPACK is installed. ";

%feature("docstring")  dolfin::UmfpackLUSolver::factorized_solve "

Solve factorized system (UMFPACK). ";


// File: classdolfin_1_1UnitCircle.xml
%feature("docstring") dolfin::UnitCircle "

std:string transformation (\"maxn\", \"sumn\" or \"rotsumn\")

Triangular mesh of the 2D unit circle. Given the number of cells (nx,
ny) in each direction, the total number of triangles will be 2*nx*ny
and the total number of vertices will be (nx + 1)*(ny + 1).
std::string diagonal (\"left\", \"right\" or \"crossed\") indicates
the direction of the diagonals.

C++ includes: UnitCircle.h ";

%feature("docstring")  dolfin::UnitCircle::UnitCircle "";


// File: classdolfin_1_1UnitCube.xml
%feature("docstring") dolfin::UnitCube "

Tetrahedral mesh of the 3D unit cube (0,1) x (0,1) x (0,1). Given the
number of cells (nx, ny, nz) in each direction, the total number of
tetrahedra will be 6*nx*ny*nz and the total number of vertices will be
(nx + 1)*(ny + 1)*(nz + 1).

C++ includes: UnitCube.h ";

%feature("docstring")  dolfin::UnitCube::UnitCube "";


// File: classdolfin_1_1UnitInterval.xml
%feature("docstring") dolfin::UnitInterval "

Interval mesh of the 1D unit line (0,1). Given the number of cells
(nx) in the axial direction, the total number of intervals will be nx
and the total number of vertices will be (nx + 1).

C++ includes: UnitInterval.h ";

%feature("docstring")  dolfin::UnitInterval::UnitInterval "";


// File: classdolfin_1_1UnitSphere.xml
%feature("docstring") dolfin::UnitSphere "

Triangular mesh of the 3D unit sphere.

Given the number of cells (nx, ny, nz) in each direction, the total
number of tetrahedra will be 6*nx*ny*nz and the total number of
vertices will be (nx + 1)*(ny + 1)*(nz + 1).

C++ includes: UnitSphere.h ";

%feature("docstring")  dolfin::UnitSphere::UnitSphere "";


// File: classdolfin_1_1UnitSquare.xml
%feature("docstring") dolfin::UnitSquare "

Triangular mesh of the 2D unit square (0,1) x (0,1). Given the number
of cells (nx, ny) in each direction, the total number of triangles
will be 2*nx*ny and the total number of vertices will be (nx + 1)*(ny
+ 1). std::string diagonal (\"left\", \"right\", \"right/left\" or
\"crossed\") indicates the direction of the diagonals.

C++ includes: UnitSquare.h ";

%feature("docstring")  dolfin::UnitSquare::UnitSquare "";


// File: classdolfin_1_1Variable.xml
%feature("docstring") dolfin::Variable "

Common base class for DOLFIN variables.

C++ includes: Variable.h ";

%feature("docstring")  dolfin::Variable::Variable "

Create unnamed variable. ";

%feature("docstring")  dolfin::Variable::Variable "

Create variable with given name and label. ";

%feature("docstring")  dolfin::Variable::~Variable "

Destructor. ";

%feature("docstring")  dolfin::Variable::rename "

Rename variable. ";

%feature("docstring")  dolfin::Variable::name "

Return name. ";

%feature("docstring")  dolfin::Variable::label "

Return label (description). ";

%feature("docstring")  dolfin::Variable::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::Variable::disp "

Deprecated, to be removed. ";


// File: classdolfin_1_1VariationalProblem.xml
%feature("docstring") dolfin::VariationalProblem "

This class represents a (system of) partial differential equation(s)
in variational form: Find u in V such that

F_u(v) = 0 for all v in V'.

The variational problem is defined in terms of a bilinear form a(v, u)
and a linear for L(v).

For a linear variational problem, F_u(v) = a(v, u) - L(v), the forms
should correspond to the canonical formulation

a(v, u) = L(v) for all v in V'.

For a nonlinear variational problem, the forms should be given by

a(v, u) = F_u'(v) u = F_u'(v, u), L(v) = F(v),

that is, a(v, u) should be the Frechet derivative of F_u with respect
to u, and L = F.

Parameters:

\"linear solvers\": \"direct\" or \"iterative\" (default: \"direct\")
\"symmetric\": true or false (default: false)

C++ includes: VariationalProblem.h ";

%feature("docstring")  dolfin::VariationalProblem::VariationalProblem
"

Define variational problem with natural boundary conditions. ";

%feature("docstring")  dolfin::VariationalProblem::VariationalProblem
"

Define variational problem with a single Dirichlet boundary
conditions. ";

%feature("docstring")  dolfin::VariationalProblem::VariationalProblem
"

Define variational problem with a list of Dirichlet boundary
conditions. ";

%feature("docstring")  dolfin::VariationalProblem::VariationalProblem
"

Define variational problem with a list of Dirichlet boundary
conditions and subdomains ";

%feature("docstring")  dolfin::VariationalProblem::~VariationalProblem
"

Destructor. ";

%feature("docstring")  dolfin::VariationalProblem::solve "

Solve variational problem. ";

%feature("docstring")  dolfin::VariationalProblem::solve "

Solve variational problem and extract sub functions. ";

%feature("docstring")  dolfin::VariationalProblem::solve "

Solve variational problem and extract sub functions. ";

%feature("docstring")  dolfin::VariationalProblem::F "

Compute F at current point x. ";

%feature("docstring")  dolfin::VariationalProblem::J "

Compute J = F' at current point x. ";

%feature("docstring")  dolfin::VariationalProblem::update "

Optional callback called before calls to F() and J(). ";

%feature("docstring")  dolfin::VariationalProblem::newton_solver "

Return Newton solver (only useful when solving a nonlinear problem).
";


// File: classdolfin_1_1Vector.xml
%feature("docstring") dolfin::Vector "

This class provides the default DOLFIN vector class, based on the
default DOLFIN linear algebra backend.

C++ includes: Vector.h ";

%feature("docstring")  dolfin::Vector::Vector "

Create empty vector. ";

%feature("docstring")  dolfin::Vector::Vector "

Create vector of size N. ";

%feature("docstring")  dolfin::Vector::Vector "

Copy constructor. ";

%feature("docstring")  dolfin::Vector::Vector "

Create a Vector from a GenericVetor. ";

%feature("docstring")  dolfin::Vector::~Vector "

Destructor. ";

%feature("docstring")  dolfin::Vector::copy "

Return copy of tensor. ";

%feature("docstring")  dolfin::Vector::zero "

Set all entries to zero and keep any sparse structure. ";

%feature("docstring")  dolfin::Vector::apply "

Finalize assembly of tensor. ";

%feature("docstring")  dolfin::Vector::str "

Return informal string representation (pretty-print). ";

%feature("docstring")  dolfin::Vector::resize "

Resize vector to size N. ";

%feature("docstring")  dolfin::Vector::size "

Return size of vector. ";

%feature("docstring")  dolfin::Vector::local_range "

Return local ownership range of a vector. ";

%feature("docstring")  dolfin::Vector::get "

Get block of values. ";

%feature("docstring")  dolfin::Vector::get_local "

Get block of values (values must all live on the local process). ";

%feature("docstring")  dolfin::Vector::set "

Set block of values. ";

%feature("docstring")  dolfin::Vector::add "

Add block of values. ";

%feature("docstring")  dolfin::Vector::get_local "

Get all values on local process. ";

%feature("docstring")  dolfin::Vector::set_local "

Set all values on local process. ";

%feature("docstring")  dolfin::Vector::add_local "

Add values to each entry on local process. ";

%feature("docstring")  dolfin::Vector::gather "

Gather entries into local vector x. ";

%feature("docstring")  dolfin::Vector::axpy "

Add multiple of given vector (AXPY operation). ";

%feature("docstring")  dolfin::Vector::inner "

Return inner product with given vector. ";

%feature("docstring")  dolfin::Vector::norm "

Return norm of vector. ";

%feature("docstring")  dolfin::Vector::min "

Return minimum value of vector. ";

%feature("docstring")  dolfin::Vector::max "

Return maximum value of vector. ";

%feature("docstring")  dolfin::Vector::sum "

Return sum of values of vector. ";

%feature("docstring")  dolfin::Vector::sum "

Return sum of selected rows in vector. Repeated entries only summed
once. ";

%feature("docstring")  dolfin::Vector::data "

Return pointer to underlying data (const version). ";

%feature("docstring")  dolfin::Vector::data "

Return pointer to underlying data. ";

%feature("docstring")  dolfin::Vector::factory "

Return linear algebra backend factory. ";

%feature("docstring")  dolfin::Vector::instance "

Return concrete instance / unwrap (const version). ";

%feature("docstring")  dolfin::Vector::instance "

Return concrete instance / unwrap (non-const version). ";


// File: classdolfin_1_1Vertex.xml
%feature("docstring") dolfin::Vertex "

A Vertex is a MeshEntity of topological dimension 0.

C++ includes: Vertex.h ";

%feature("docstring")  dolfin::Vertex::Vertex "

Create vertex on given mesh. ";

%feature("docstring")  dolfin::Vertex::Vertex "

Create vertex from mesh entity. ";

%feature("docstring")  dolfin::Vertex::~Vertex "

Destructor. ";

%feature("docstring")  dolfin::Vertex::x "

Return value of vertex coordinate i. ";

%feature("docstring")  dolfin::Vertex::point "

Return vertex coordinates as a 3D point value. ";

%feature("docstring")  dolfin::Vertex::x "

Return array of vertex coordinates (const version). ";


// File: classdolfin_1_1VertexIterator.xml
%feature("docstring") dolfin::VertexIterator "

A VertexIterator is a MeshEntityIterator of topological dimension 0.

C++ includes: Vertex.h ";

%feature("docstring")  dolfin::VertexIterator::VertexIterator "";

%feature("docstring")  dolfin::VertexIterator::VertexIterator "";


// File: namespaceboost.xml


// File: namespaceboost_1_1program__options.xml


// File: namespacedolfin.xml
%feature("docstring")  dolfin::dolfin_set_precision "";

%feature("docstring")  dolfin::to_double "";

%feature("docstring")  dolfin::to_real "";

%feature("docstring")  dolfin::real_abs "";

%feature("docstring")  dolfin::real_max "";

%feature("docstring")  dolfin::real_min "";

%feature("docstring")  dolfin::real_pow "";

%feature("docstring")  dolfin::pow "";

%feature("docstring")  dolfin::isnormal "";

%feature("docstring")  dolfin::real_pow "";

%feature("docstring")  dolfin::real_sqrt "

Square root. ";

%feature("docstring")  dolfin::real_pi "

Compute pi. ";

%feature("docstring")  dolfin::real_mat_exp "

Compute matrix exponential using Pade approximation og degree p. ";

%feature("docstring")  dolfin::real_frexp "";

%feature("docstring")  dolfin::real_exp "

Exponential function (note: not full precision!). ";

%feature("docstring")  dolfin::real_log "

Logarithmic function (note: not full precision!). ";

%feature("docstring")  dolfin::real_epsilon "";

%feature("docstring")  dolfin::real_decimal_prec "";

%feature("docstring")  dolfin::real_set "";

%feature("docstring")  dolfin::real_set "";

%feature("docstring")  dolfin::real_zero "";

%feature("docstring")  dolfin::real_add "";

%feature("docstring")  dolfin::real_sub "";

%feature("docstring")  dolfin::real_axpy "";

%feature("docstring")  dolfin::real_mult "";

%feature("docstring")  dolfin::real_div "";

%feature("docstring")  dolfin::real_inner "";

%feature("docstring")  dolfin::real_max_abs "";

%feature("docstring")  dolfin::real_norm "";

%feature("docstring")  dolfin::real_identity "";

%feature("docstring")  dolfin::real_mat_prod "";

%feature("docstring")  dolfin::real_mat_prod_inplace "";

%feature("docstring")  dolfin::real_mat_vector_prod "";

%feature("docstring")  dolfin::real_mat_pow "";

%feature("docstring")  dolfin::tic "

Start timing (should not be used internally in DOLFIN!).

Timing functions measure CPU time as determined by clock(), the
precision of which seems to be 0.01 seconds. ";

%feature("docstring")  dolfin::toc "

Return elapsed CPU time (should not be used internally in DOLFIN!). ";

%feature("docstring")  dolfin::time "

Return current CPU time used by process. ";

%feature("docstring")  dolfin::info "

Print message.

The DOLFIN log system provides the following set of functions for
uniform handling of log messages, warnings and errors. In addition,
macros are provided for debug messages and assertions.

Only messages with a debug level higher than or equal to the current
log level are printed (the default being zero). Logging may also be
turned off by calling log(false). ";

%feature("docstring")  dolfin::info "

Print message at given debug level. ";

%feature("docstring")  dolfin::info "

Print parameter (using output of str() method). ";

%feature("docstring")  dolfin::info "

Print variable (using output of str() method). ";

%feature("docstring")  dolfin::info_stream "

Print message to stream. ";

%feature("docstring")  dolfin::info_underline "

Print underlined message. ";

%feature("docstring")  dolfin::warning "

Print warning. ";

%feature("docstring")  dolfin::error "

Print error message and throw an exception. ";

%feature("docstring")  dolfin::begin "

Begin task (increase indentation level). ";

%feature("docstring")  dolfin::begin "

Begin task (increase indentation level). ";

%feature("docstring")  dolfin::end "

End task (decrease indentation level). ";

%feature("docstring")  dolfin::logging "

Turn logging on or off. ";

%feature("docstring")  dolfin::set_log_level "

Set log level. ";

%feature("docstring")  dolfin::get_log_level "

Get log level. ";

%feature("docstring")  dolfin::summary "

Print summary of timings and tasks, optionally clearing stored
timings. ";

%feature("docstring")  dolfin::timing "

Return timing (average) for given task, optionally clearing timing for
task. ";

%feature("docstring")  dolfin::not_working_in_parallel "

Report that functionality has not (yet) been implemented to work in
parallel. ";

%feature("docstring")  dolfin::check_equal "

Check value and print an informative error message if invalid. ";

%feature("docstring")  dolfin::__debug "";

%feature("docstring")  dolfin::solve "

Solve linear system Ax = b. ";

%feature("docstring")  dolfin::residual "

Compute residual ||Ax - b||. ";

%feature("docstring")  dolfin::normalize "

Normalize vector according to given normalization type. ";

%feature("docstring")  dolfin::refine "

Create uniformly refined mesh. ";

%feature("docstring")  dolfin::refine "

Create uniformly refined mesh. ";

%feature("docstring")  dolfin::refine "

Create locally refined mesh. ";

%feature("docstring")  dolfin::refine "

Create locally refined mesh. ";

%feature("docstring")  dolfin::dolfin_init "

Initialize DOLFIN (and PETSc) with command-line arguments. This should
not be needed in most cases since the initialization is otherwise
handled automatically. ";

%feature("docstring")  dolfin::sqr "

Return the square of x. ";

%feature("docstring")  dolfin::ipow "

Return a to the power n. ";

%feature("docstring")  dolfin::rand "

Return a random number, uniformly distributed between [0.0, 1.0). ";

%feature("docstring")  dolfin::seed "

Seed random number generator. ";

%feature("docstring")  dolfin::assemble "

Assemble tensor. ";

%feature("docstring")  dolfin::assemble "

Assemble tensor on sub domain. ";

%feature("docstring")  dolfin::assemble "

Assemble tensor on sub domains. ";

%feature("docstring")  dolfin::assemble_system "

Assemble system (A, b). ";

%feature("docstring")  dolfin::assemble_system "

Assemble system (A, b) and apply Dirichlet boundary condition. ";

%feature("docstring")  dolfin::assemble_system "

Assemble system (A, b) and apply Dirichlet boundary conditions. ";

%feature("docstring")  dolfin::assemble_system "

Assemble system (A, b) on sub domains and apply Dirichlet boundary
conditions. ";

%feature("docstring")  dolfin::assemble "

Assemble scalar. ";

%feature("docstring")  dolfin::assemble "

Assemble scalar on sub domain. ";

%feature("docstring")  dolfin::assemble "

Assemble scalar on sub domains. ";


// File: namespaceufc.xml


// File: TimeSeries_8h.xml


// File: ALE_8h.xml


// File: ALEType_8h.xml


// File: Array_8h.xml


// File: constants_8h.xml


// File: real_8h.xml


// File: Set_8h.xml


// File: Timer_8h.xml


// File: timing_8h.xml


// File: types_8h.xml


// File: Variable_8h.xml


// File: assemble_8h.xml


// File: Assembler_8h.xml


// File: BasisFunction_8h.xml


// File: BoundaryCondition_8h.xml


// File: DirichletBC_8h.xml


// File: DofMap_8h.xml


// File: EqualityBC_8h.xml


// File: FiniteElement_8h.xml


// File: Form_8h.xml


// File: GenericDofMap_8h.xml


// File: PeriodicBC_8h.xml


// File: SystemAssembler_8h.xml


// File: VariationalProblem_8h.xml


// File: Constant_8h.xml


// File: Data_8h.xml


// File: Expression_8h.xml


// File: Function_8h.xml


// File: FunctionSpace_8h.xml


// File: GenericFunction_8h.xml


// File: SpecialFunctions_8h.xml


// File: SubSpace_8h.xml


// File: File_8h.xml


// File: BlockMatrix_8h.xml


// File: BlockVector_8h.xml


// File: CholmodCholeskySolver_8h.xml


// File: DefaultFactory_8h.xml


// File: EpetraFactory_8h.xml


// File: EpetraKrylovSolver_8h.xml


// File: EpetraLUSolver_8h.xml


// File: EpetraMatrix_8h.xml


// File: EpetraSparsityPattern_8h.xml


// File: EpetraVector_8h.xml


// File: GenericLinearSolver_8h.xml


// File: GenericMatrix_8h.xml


// File: GenericSparsityPattern_8h.xml


// File: GenericTensor_8h.xml


// File: GenericVector_8h.xml


// File: KrylovSolver_8h.xml


// File: LinearAlgebraFactory_8h.xml


// File: LinearSolver_8h.xml


// File: LUSolver_8h.xml


// File: Matrix_8h.xml


// File: MTL4Factory_8h.xml


// File: MTL4Matrix_8h.xml


// File: MTL4Vector_8h.xml


// File: PETScFactory_8h.xml


// File: PETScKrylovMatrix_8h.xml


// File: PETScKrylovSolver_8h.xml


// File: PETScLUSolver_8h.xml


// File: PETScMatrix_8h.xml


// File: PETScObject_8h.xml


// File: PETScPreconditioner_8h.xml


// File: PETScUserPreconditioner_8h.xml


// File: PETScVector_8h.xml


// File: Scalar_8h.xml


// File: SingularSolver_8h.xml


// File: SLEPcEigenSolver_8h.xml


// File: solve_8h.xml


// File: SparsityPattern_8h.xml


// File: STLFactory_8h.xml


// File: STLMatrix_8h.xml


// File: TrilinosPreconditioner_8h.xml


// File: ublas_8h.xml


// File: uBLASDenseMatrix_8h.xml


// File: uBLASFactory_8h.xml


// File: uBLASILUPreconditioner_8h.xml


// File: uBLASKrylovMatrix_8h.xml


// File: uBLASKrylovSolver_8h.xml


// File: uBLASMatrix_8h.xml


// File: uBLASPreconditioner_8h.xml


// File: uBLASVector_8h.xml


// File: UmfpackLUSolver_8h.xml


// File: Vector_8h.xml


// File: Event_8h.xml


// File: log_8h.xml


// File: LogStream_8h.xml


// File: Progress_8h.xml


// File: Table_8h.xml


// File: init_8h.xml


// File: MPI_8h.xml


// File: basic_8h.xml


// File: Lagrange_8h.xml


// File: Legendre_8h.xml


// File: BoundaryMesh_8h.xml


// File: Box_8h.xml


// File: Cell_8h.xml


// File: CellType_8h.xml


// File: DomainBoundary_8h.xml


// File: DynamicMeshEditor_8h.xml


// File: Edge_8h.xml


// File: Face_8h.xml


// File: Facet_8h.xml


// File: FacetCell_8h.xml


// File: IntersectionOperator_8h.xml


// File: Interval_8h.xml


// File: LocalMeshData_8h.xml


// File: Mesh_8h.xml


// File: MeshConnectivity_8h.xml


// File: MeshData_8h.xml


// File: MeshEditor_8h.xml


// File: MeshEntity_8h.xml


// File: MeshEntityIterator_8h.xml


// File: MeshFunction_8h.xml


// File: MeshGeometry_8h.xml


// File: MeshPartitioning_8h.xml


// File: MeshPrimitive_8h.xml


// File: MeshTopology_8h.xml


// File: Point_8h.xml


// File: PrimitiveIntersector_8h.xml


// File: PrimitiveTraits_8h.xml


// File: Rectangle_8h.xml


// File: refine_8h.xml


// File: SubDomain_8h.xml


// File: SubMesh_8h.xml


// File: UnitCircle_8h.xml


// File: UnitCube_8h.xml


// File: UnitInterval_8h.xml


// File: UnitSphere_8h.xml


// File: UnitSquare_8h.xml


// File: Vertex_8h.xml


// File: NewtonSolver_8h.xml


// File: NonlinearProblem_8h.xml


// File: cGqMethod_8h.xml


// File: ComplexODE_8h.xml


// File: dGqMethod_8h.xml


// File: Method_8h.xml


// File: ODE_8h.xml


// File: ODECollection_8h.xml


// File: ODESolution_8h.xml


// File: Sample_8h.xml


// File: StabilityAnalysis_8h.xml


// File: GlobalParameters_8h.xml


// File: Parameter_8h.xml


// File: Parameters_8h.xml


// File: FunctionPlotData_8h.xml


// File: BarycenterQuadrature_8h.xml


// File: GaussianQuadrature_8h.xml


// File: GaussQuadrature_8h.xml


// File: LobattoQuadrature_8h.xml


// File: Quadrature_8h.xml


// File: RadauQuadrature_8h.xml


// File: dir_68f858635a27044942e1456f397a257e.xml


// File: dir_be4abbe9be371fb90858f9b708d1b3fd.xml


// File: dir_c9896c264abe1f5ce0b23b00c130609f.xml


// File: dir_96b86ef69f481d1d80becb314010dfa2.xml


// File: dir_13fd81ecff987b0a93366aa1e9319de6.xml


// File: dir_12eaeb6393c8340c3fcc7bb4666dbe6a.xml


// File: dir_5bab3dfda35b11ed9e9fc557c91c04ca.xml


// File: dir_29c16e73653a7fc876ded90673bae460.xml


// File: dir_a36793e7aa99483120927e3d6713b3d9.xml


// File: dir_3f6ea3b079d98368ba4d0298b8edf7e0.xml


// File: dir_e9dae39b13f1287e8917eaa1de874624.xml


// File: dir_8ab656e4681daa02e4b96ad13fdc62c8.xml


// File: dir_bfb3cabb742a51f1c9dcbb782a9883c3.xml


// File: dir_a1ad675c37ae45d8c452a0ce15eff5f1.xml


// File: dir_b6d81790256b0d7b70fdbdc2046bfa2d.xml


// File: dir_dbf2ee81eba2eb363262fc2ffa131006.xml

