// Copyright (C) 2008 Martin Sandve Alnes, Kent-Andre Mardal and Johannes Ring.
// Licensed under the GNU LGPL Version 2.1.
//
// First added:  2008-04-21
// Last changed: 2008-09-28

#ifdef HAS_TRILINOS

#include "EpetraSparsityPattern.h"
#include "EpetraMatrix.h"
#include "EpetraVector.h"
#include "EpetraFactory.h"

#include <Epetra_SerialComm.h>

using namespace dolfin;

//-----------------------------------------------------------------------------
EpetraFactory:: EpetraFactory()
{
  comm = new Epetra_SerialComm();
}
//-----------------------------------------------------------------------------
EpetraFactory:: ~EpetraFactory()
{
  delete comm;
}
//-----------------------------------------------------------------------------
EpetraMatrix* EpetraFactory::create_matrix() const
{
  return new EpetraMatrix();
}
//-----------------------------------------------------------------------------
EpetraVector* EpetraFactory::create_vector() const
{
  return new EpetraVector();
}
//-----------------------------------------------------------------------------
EpetraVector* EpetraFactory::create_local_vector() const
{
  return new EpetraVector();
}
//-----------------------------------------------------------------------------
EpetraSparsityPattern* EpetraFactory::create_pattern() const
{
  return new EpetraSparsityPattern();
}
//-----------------------------------------------------------------------------
Epetra_SerialComm& EpetraFactory::getSerialComm()
{
  return *comm;
}
//-----------------------------------------------------------------------------

// Singleton instance
EpetraFactory EpetraFactory::factory;

#endif
