// This code conforms with the UFC specification version 1.4
// and was automatically generated by FFC version 0.9.2.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   epsilon:                        1e-14
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __POISSON3D_5_H
#define __POISSON3D_5_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class poisson3d_5_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  poisson3d_5_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_5_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 5)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 56;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.000000000000000;
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[56] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    unsigned int tt = 0;
    double tmp5 = 0.000000000000000;
    double tmp6 = 0.000000000000000;
    double tmp7 = 0.000000000000000;
    double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
    double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
    double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
    double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
    double tmp4 = tmp3*tmp3;
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 1; r < 5; r++)
    {
      rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
      ss = r*(r + 1)*(r + 2)/6;
      tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
      basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 5; r++)
    {
      rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
      ss = r*(r + 1)*(r + 2)/6;
      basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
    }// end loop over 'r'
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 1; s < 5 - r; s++)
      {
        rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
        tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 5; r++)
    {
      for (unsigned int s = 0; s < 5 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 0; s < 4 - r; s++)
      {
        for (unsigned int t = 1; t < 5 - r - s; t++)
        {
          rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
          ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
          tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 6; r++)
    {
      for (unsigned int s = 0; s < 6 - r; s++)
      {
        for (unsigned int t = 0; t < 6 - r - s; t++)
        {
          rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[56][56] = \
    {{0.009450674049235, 0.006097881206793, 0.003520613356228, 0.002489449578125, 0.007059462333250, 0.005468236009971, 0.004464796005848, 0.003157087532349, 0.002577751175853, 0.001822745336657, -0.002982674187257, -0.002520819779829, -0.002183093967694, -0.001952618605214, -0.001691017316017, -0.001380709856818, -0.001127344877345, -0.000976309302607, -0.000797153207506, -0.000563672438672, 0.002786871124600, 0.002457789310560, 0.002198313589113, 0.002077211093046, 0.001857914083067, 0.001609000793985, 0.001609000793985, 0.001439134060480, 0.001246326655827, 0.001017621453202, 0.000928957041533, 0.000830884437218, 0.000719567030240, 0.000587524019939, 0.000415442218609, -0.007055935247178, -0.006382333570891, -0.005826246777166, -0.005628689137612, -0.005138266683091, -0.004595805435965, -0.004757110573197, -0.004342627949144, -0.003884164518110, -0.003363785145162, -0.003684842005212, -0.003363785145162, -0.003008660898514, -0.002605576769486, -0.002127444523630, -0.002127444523630, -0.001942082259055, -0.001737051179658, -0.001504330449257, -0.001228280668404, -0.000868525589829},
    {0.009450674049235, -0.006097881206793, 0.003520613356228, 0.002489449578125, 0.007059462333250, -0.005468236009971, -0.004464796005848, 0.003157087532349, 0.002577751175853, 0.001822745336657, 0.002982674187257, -0.002520819779829, -0.002183093967694, 0.001952618605214, 0.001691017316017, 0.001380709856818, -0.001127344877345, -0.000976309302607, -0.000797153207506, -0.000563672438672, 0.002786871124600, -0.002457789310560, -0.002198313589113, 0.002077211093046, 0.001857914083067, 0.001609000793985, -0.001609000793985, -0.001439134060480, -0.001246326655827, -0.001017621453202, 0.000928957041533, 0.000830884437218, 0.000719567030240, 0.000587524019939, 0.000415442218609, 0.007055935247178, -0.006382333570891, -0.005826246777166, 0.005628689137612, 0.005138266683091, 0.004595805435965, -0.004757110573197, -0.004342627949144, -0.003884164518110, -0.003363785145162, 0.003684842005212, 0.003363785145162, 0.003008660898514, 0.002605576769486, 0.002127444523630, -0.002127444523630, -0.001942082259055, -0.001737051179658, -0.001504330449257, -0.001228280668404, -0.000868525589829},
    {0.009450674049235, 0.000000000000000, -0.007041226712456, 0.002489449578125, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.009471262597048, -0.005155502351706, 0.001822745336657, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.004509379509380, -0.002928927907821, 0.001594306415013, -0.000563672438672, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.004644785207667, -0.003323537748873, 0.002158701090720, -0.001175048039879, 0.000415442218609, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.012764667141782, -0.009710411295276, 0.006948204718630, -0.004512991347771, 0.002456561336808, -0.000868525589829},
    {0.009450674049235, 0.000000000000000, 0.000000000000000, -0.007468348734374, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.010936472019943, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.005636724386724, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.006231633279137, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.018239037386404},
    {-0.010023442173431, 0.000000000000000, 0.037471874831140, -0.028961418359372, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.028413787791145, 0.005155502351706, -0.006197334144634, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.031565656565657, -0.011390275197081, 0.002657177358355, -0.000187890812891, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.023223926038334, -0.001661768874437, -0.006476103272161, 0.006462764219333, -0.002908095530264, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.021362904849607, -0.027792818874520, 0.024370153277966, -0.015721992555570, 0.006079679128801},
    {0.010023442173431, 0.000000000000000, -0.028757485335526, 0.053609433984370, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.018942525194097, 0.015466507055117, 0.015311060827920, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.004509379509380, 0.037099753499063, -0.028166079998562, 0.010897667147667, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.029911839739858, -0.004317402181441, -0.012338004418727, 0.008724286590792, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.031266921233836, -0.048740306555932, 0.041270230458372, -0.018239037386404},
    {0.010023442173431, 0.000000000000000, 0.040957630629385, -0.044982628515621, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.018942525194097, -0.005155502351706, -0.021143845905223, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.004556110078832, 0.035606176601956, -0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.030221815270086, 0.004112668139576, -0.014540477651320, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.037909127321280, -0.055026973944496, 0.030398395644007},
    {-0.010023442173431, 0.000000000000000, -0.014814462142544, 0.044982628515621, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.020622009406823, 0.021143845905223, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.010628709433420, 0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.020563340697879, 0.014540477651320, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.034391858715310, -0.030398395644007},
    {-0.010023442173431, 0.032451595531198, -0.018735937415570, -0.028961418359372, 0.021178386999751, -0.016404708029914, 0.004464796005848, 0.009471262597048, -0.002577751175853, -0.006197334144634, 0.020878719310800, -0.017645738458805, -0.008489809874367, 0.013668330236497, 0.006576178451178, 0.002301183094696, -0.007891414141414, -0.003796758399027, -0.001328588679177, -0.000187890812891, 0.013934355623000, -0.012288946552798, -0.001099156794557, 0.010386055465228, 0.000928957041533, -0.004827002381954, -0.008045003969923, -0.000719567030240, 0.003738979967482, 0.005596917992612, 0.004644785207667, 0.000415442218609, -0.002158701090720, -0.003231382109667, -0.002908095530264, 0.000000000000000, 0.000000000000000, 0.012817742909764, 0.000000000000000, -0.011304186702799, -0.018383221743861, 0.000000000000000, 0.009553781488116, 0.015536658072442, 0.018164439783874, 0.000000000000000, -0.007400327319356, -0.012034643594057, -0.014070114555226, -0.013615644951234, 0.000000000000000, 0.004272580969921, 0.006948204718630, 0.008123384425989, 0.007860996277785, 0.006079679128801},
    {0.010023442173431, -0.024904712849524, 0.014378742667763, 0.053609433984370, -0.014118924666501, 0.010936472019943, 0.013394388017543, -0.006314175064699, -0.007733253527559, 0.015311060827920, -0.002982674187257, 0.002520819779829, 0.027652523590797, -0.001952618605214, -0.021419552669553, -0.024392540803780, 0.001127344877345, 0.012366584499688, 0.014083039999281, 0.010897667147667, 0.000000000000000, 0.000000000000000, 0.019784822302020, 0.000000000000000, -0.016721226747600, -0.003218001587969, 0.000000000000000, 0.012952206544323, 0.002492653311655, -0.010685025258623, 0.000000000000000, -0.007477959934964, -0.001439134060480, 0.006169002209364, 0.008724286590792, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.020681124461843, 0.000000000000000, 0.000000000000000, -0.017478740331497, -0.036328879567747, 0.000000000000000, 0.000000000000000, 0.013538974043314, 0.028140229110452, 0.035741067996988, 0.000000000000000, 0.000000000000000, -0.007816730308459, -0.016246768851977, -0.020635115229186, -0.018239037386404},
    {0.010023442173431, 0.035470348603867, -0.020478815314693, -0.044982628515621, 0.014118924666501, -0.010936472019943, -0.004464796005848, 0.006314175064699, 0.002577751175853, -0.021143845905223, 0.000000000000000, 0.000000000000000, 0.003395923949747, 0.000000000000000, -0.002630471380471, 0.030835853468929, 0.000000000000000, 0.001518703359611, -0.017803088300978, -0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.022526011115785, 0.000000000000000, 0.000000000000000, -0.017448573181584, 0.003561675086208, 0.000000000000000, 0.000000000000000, 0.010073938423362, -0.002056334069788, -0.014540477651320, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.028255795219359, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.021886844863685, -0.047654757329318, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.012636375773760, 0.027513486972248, 0.030398395644007},
    {-0.010023442173431, -0.012829700558846, 0.007407231071272, 0.044982628515621, 0.000000000000000, 0.000000000000000, 0.017859184023390, 0.000000000000000, -0.010311004703411, 0.021143845905223, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.009204732378785, 0.000000000000000, 0.000000000000000, -0.005314354716710, 0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.017808375431038, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.010281670348940, 0.014540477651320, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.029784223330824, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.017195929357655, -0.030398395644007},
    {-0.010023442173431, 0.032451595531198, -0.033550399558114, -0.008010605078124, 0.021178386999751, 0.001093647201994, -0.016966224822221, -0.005682757558229, 0.005671052586876, 0.008384628548623, 0.020878719310800, -0.010923552379260, -0.016251921759503, 0.004990025324435, 0.009582431457431, 0.010892266648229, -0.001878908128908, -0.004664588890233, -0.005580072452545, -0.004697270322270, 0.013934355623000, -0.002457789310560, -0.012090724740124, -0.004154422186091, 0.004644785207667, 0.009654004763908, 0.006436003175939, -0.000719567030240, -0.004985306623310, -0.006614539445814, -0.004644785207667, -0.000415442218609, 0.002158701090720, 0.003231382109667, 0.002908095530264, 0.000000000000000, 0.012764667141782, -0.001165249355433, -0.020263280895403, -0.007193573356327, 0.001838322174386, 0.022834130751345, 0.011290832667774, 0.003107331614488, -0.002018271087097, -0.020635115229186, -0.011436869493550, -0.004813857437623, -0.000521115353897, 0.001701955618904, 0.012764667141782, 0.007379912584410, 0.003474102359315, 0.000902598269554, -0.000491312267362, -0.000868525589829},
    {0.010023442173431, -0.024904712849524, 0.055336373297148, -0.004313402734375, -0.014118924666501, 0.015311060827920, 0.008036632810526, 0.008839845090578, -0.015982057290288, 0.000729098134663, -0.002982674187257, 0.027729017578122, -0.001455395978463, -0.030157109569414, -0.011649230399230, 0.003528480745201, 0.019164862914863, 0.009763093026069, 0.001328588679177, -0.002630471380471, 0.000000000000000, 0.019662314484476, -0.002198313589113, -0.007270238825660, -0.014863312664534, 0.004022501984962, -0.007240503572931, 0.012952206544323, 0.006854796607051, -0.004579296539410, 0.009289570415333, -0.006647075497746, -0.005756536241921, -0.000293762009970, 0.002908095530264, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.020263280895403, -0.004110613346472, 0.000459580543597, -0.039959728814854, -0.003039839564401, 0.004272580969921, -0.001009135543549, 0.046429009265669, 0.009082219891937, -0.002707794808663, -0.002345019092538, 0.001276466714178, -0.031911667854454, -0.007768329036221, 0.000868525589829, 0.001805196539109, 0.000245656133681, -0.000868525589829},
    {0.010023442173431, 0.035470348603867, -0.049236300650219, -0.004313402734375, 0.014118924666501, -0.006561883211966, -0.009822551212865, -0.016416855168217, 0.014950956819947, 0.000729098134663, 0.000000000000000, 0.003361093039772, -0.000485131992821, 0.028204490964200, -0.012400793650794, 0.002914831919949, -0.035323472823473, 0.008895262534863, 0.002391459622519, -0.002630471380471, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.021810716476979, -0.005573742249200, 0.000804500396992, -0.004022501984962, -0.014391340604803, 0.009347449918705, -0.002544053633005, -0.009289570415333, 0.014125035432710, -0.002878268120961, -0.003818906129606, 0.002908095530264, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.026639819209903, -0.009119518693202, 0.002330498710866, -0.000336378514516, -0.051587788072965, 0.008409462862904, 0.003008660898514, -0.002866134446435, 0.000850977809452, 0.042548890472605, -0.003884164518110, -0.003474102359315, 0.001203464359406, 0.000982624534723, -0.000868525589829},
    {-0.010023442173431, -0.012829700558846, 0.044879105902412, -0.008010605078124, 0.000000000000000, 0.017498355231909, -0.003571836804678, 0.013259767635868, -0.017528707995799, 0.008384628548623, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.008678304912061, -0.003006253006253, 0.000613648825252, 0.022546897546898, -0.019200749617936, 0.012223015848433, -0.004697270322270, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.016090007939846, -0.007195670302402, 0.002492653311655, -0.000508810726601, 0.004644785207667, -0.010801497683837, 0.010793505453602, -0.007344050249243, 0.002908095530264, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.025793894036483, -0.013455140580647, 0.006017321797029, -0.002084461415589, 0.000425488904726, -0.031911667854454, 0.013594575813387, -0.003474102359315, -0.000902598269554, 0.001719592935765, -0.000868525589829},
    {-0.010023442173431, -0.032451595531198, -0.018735937415570, -0.028961418359372, 0.021178386999751, 0.016404708029914, -0.004464796005848, 0.009471262597048, -0.002577751175853, -0.006197334144634, -0.020878719310800, -0.017645738458805, -0.008489809874367, -0.013668330236497, -0.006576178451178, -0.002301183094696, -0.007891414141414, -0.003796758399027, -0.001328588679177, -0.000187890812891, 0.013934355623000, 0.012288946552798, 0.001099156794557, 0.010386055465228, 0.000928957041533, -0.004827002381954, 0.008045003969923, 0.000719567030240, -0.003738979967482, -0.005596917992612, 0.004644785207667, 0.000415442218609, -0.002158701090720, -0.003231382109667, -0.002908095530264, 0.000000000000000, 0.000000000000000, 0.012817742909764, 0.000000000000000, 0.011304186702799, 0.018383221743861, 0.000000000000000, 0.009553781488116, 0.015536658072442, 0.018164439783874, 0.000000000000000, 0.007400327319356, 0.012034643594057, 0.014070114555226, 0.013615644951234, 0.000000000000000, 0.004272580969921, 0.006948204718630, 0.008123384425989, 0.007860996277785, 0.006079679128801},
    {0.010023442173431, 0.024904712849524, 0.014378742667763, 0.053609433984370, -0.014118924666501, -0.010936472019943, -0.013394388017543, -0.006314175064699, -0.007733253527559, 0.015311060827920, 0.002982674187257, 0.002520819779829, 0.027652523590797, 0.001952618605214, 0.021419552669553, 0.024392540803780, 0.001127344877345, 0.012366584499688, 0.014083039999281, 0.010897667147667, 0.000000000000000, 0.000000000000000, -0.019784822302020, 0.000000000000000, -0.016721226747600, -0.003218001587969, 0.000000000000000, -0.012952206544323, -0.002492653311655, 0.010685025258623, 0.000000000000000, -0.007477959934964, -0.001439134060480, 0.006169002209364, 0.008724286590792, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.020681124461843, 0.000000000000000, 0.000000000000000, -0.017478740331497, -0.036328879567747, 0.000000000000000, 0.000000000000000, -0.013538974043314, -0.028140229110452, -0.035741067996988, 0.000000000000000, 0.000000000000000, -0.007816730308459, -0.016246768851977, -0.020635115229186, -0.018239037386404},
    {0.010023442173431, -0.035470348603867, -0.020478815314693, -0.044982628515621, 0.014118924666501, 0.010936472019943, 0.004464796005848, 0.006314175064699, 0.002577751175853, -0.021143845905223, 0.000000000000000, 0.000000000000000, 0.003395923949747, 0.000000000000000, 0.002630471380471, -0.030835853468929, 0.000000000000000, 0.001518703359611, -0.017803088300978, -0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.022526011115785, 0.000000000000000, 0.000000000000000, 0.017448573181584, -0.003561675086208, 0.000000000000000, 0.000000000000000, 0.010073938423362, -0.002056334069788, -0.014540477651320, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.028255795219359, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.021886844863685, 0.047654757329318, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.012636375773760, 0.027513486972248, 0.030398395644007},
    {-0.010023442173431, 0.012829700558846, 0.007407231071272, 0.044982628515621, 0.000000000000000, 0.000000000000000, -0.017859184023390, 0.000000000000000, -0.010311004703411, 0.021143845905223, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.009204732378785, 0.000000000000000, 0.000000000000000, -0.005314354716710, 0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.017808375431038, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.010281670348940, 0.014540477651320, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.029784223330824, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.017195929357655, -0.030398395644007},
    {-0.010023442173431, -0.032451595531198, -0.033550399558114, -0.008010605078124, 0.021178386999751, -0.001093647201994, 0.016966224822221, -0.005682757558229, 0.005671052586876, 0.008384628548623, -0.020878719310800, -0.010923552379260, -0.016251921759503, -0.004990025324435, -0.009582431457431, -0.010892266648229, -0.001878908128908, -0.004664588890233, -0.005580072452545, -0.004697270322270, 0.013934355623000, 0.002457789310560, 0.012090724740124, -0.004154422186091, 0.004644785207667, 0.009654004763908, -0.006436003175939, 0.000719567030240, 0.004985306623310, 0.006614539445814, -0.004644785207667, -0.000415442218609, 0.002158701090720, 0.003231382109667, 0.002908095530264, 0.000000000000000, 0.012764667141782, -0.001165249355433, 0.020263280895403, 0.007193573356327, -0.001838322174386, 0.022834130751345, 0.011290832667774, 0.003107331614488, -0.002018271087097, 0.020635115229186, 0.011436869493550, 0.004813857437623, 0.000521115353897, -0.001701955618904, 0.012764667141782, 0.007379912584410, 0.003474102359315, 0.000902598269554, -0.000491312267362, -0.000868525589829},
    {0.010023442173431, 0.024904712849524, 0.055336373297148, -0.004313402734375, -0.014118924666501, -0.015311060827920, -0.008036632810526, 0.008839845090578, -0.015982057290288, 0.000729098134663, 0.002982674187257, 0.027729017578122, -0.001455395978463, 0.030157109569414, 0.011649230399230, -0.003528480745201, 0.019164862914863, 0.009763093026069, 0.001328588679177, -0.002630471380471, 0.000000000000000, -0.019662314484476, 0.002198313589113, -0.007270238825660, -0.014863312664534, 0.004022501984962, 0.007240503572931, -0.012952206544323, -0.006854796607051, 0.004579296539410, 0.009289570415334, -0.006647075497746, -0.005756536241921, -0.000293762009970, 0.002908095530264, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.020263280895403, 0.004110613346472, -0.000459580543597, -0.039959728814854, -0.003039839564401, 0.004272580969921, -0.001009135543549, -0.046429009265669, -0.009082219891937, 0.002707794808663, 0.002345019092538, -0.001276466714178, -0.031911667854454, -0.007768329036221, 0.000868525589829, 0.001805196539109, 0.000245656133681, -0.000868525589829},
    {0.010023442173431, -0.035470348603867, -0.049236300650219, -0.004313402734375, 0.014118924666501, 0.006561883211966, 0.009822551212865, -0.016416855168217, 0.014950956819947, 0.000729098134663, 0.000000000000000, 0.003361093039772, -0.000485131992821, -0.028204490964200, 0.012400793650794, -0.002914831919949, -0.035323472823473, 0.008895262534863, 0.002391459622519, -0.002630471380471, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.021810716476979, -0.005573742249200, 0.000804500396992, 0.004022501984962, 0.014391340604803, -0.009347449918705, 0.002544053633005, -0.009289570415334, 0.014125035432710, -0.002878268120961, -0.003818906129606, 0.002908095530264, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.026639819209903, -0.009119518693202, 0.002330498710866, -0.000336378514516, 0.051587788072965, -0.008409462862904, -0.003008660898514, 0.002866134446435, -0.000850977809452, 0.042548890472605, -0.003884164518110, -0.003474102359315, 0.001203464359406, 0.000982624534723, -0.000868525589829},
    {-0.010023442173431, 0.012829700558846, 0.044879105902412, -0.008010605078124, 0.000000000000000, -0.017498355231909, 0.003571836804678, 0.013259767635868, -0.017528707995799, 0.008384628548623, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.008678304912061, 0.003006253006253, -0.000613648825252, 0.022546897546898, -0.019200749617936, 0.012223015848433, -0.004697270322270, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.016090007939846, 0.007195670302402, -0.002492653311655, 0.000508810726601, 0.004644785207667, -0.010801497683837, 0.010793505453602, -0.007344050249243, 0.002908095530264, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.025793894036483, 0.013455140580647, -0.006017321797029, 0.002084461415589, -0.000425488904726, -0.031911667854454, 0.013594575813387, -0.003474102359315, -0.000902598269554, 0.001719592935765, -0.000868525589829},
    {-0.010023442173431, -0.045281296090043, -0.011328706344298, -0.008010605078124, -0.001411892466650, 0.016404708029914, 0.013394388017543, 0.014522602648807, 0.011857655408923, 0.008384628548623, -0.008948022561771, -0.014284645419033, -0.012370865816935, -0.014536160727703, -0.012588684463684, -0.010278617822976, -0.009394540644541, -0.008135910855058, -0.006642943395887, -0.004697270322270, -0.008360613373800, 0.002457789310560, 0.002198313589113, 0.008308844372183, 0.007431656332267, 0.006436003175939, 0.009654004763908, 0.008634804362882, 0.007477959934964, 0.006105728719213, 0.006502699290733, 0.005816191060528, 0.005036969211681, 0.004112668139576, 0.002908095530264, 0.035279676235890, 0.019147000712672, 0.017478740331497, 0.007880164792657, 0.007193573356327, 0.006434127610351, 0.000951422114639, 0.000868525589829, 0.000776832903622, 0.000672757029032, -0.002210905203127, -0.002018271087097, -0.001805196539109, -0.001563346061692, -0.001276466714178, -0.002127444523630, -0.001942082259055, -0.001737051179658, -0.001504330449257, -0.001228280668404, -0.000868525589829},
    {0.010023442173431, 0.060375061453391, -0.006100072646930, -0.004313402734375, -0.005647569866600, -0.021872944039886, -0.017859184023390, 0.001262835012940, 0.001031100470341, 0.000729098134663, 0.041757438621600, 0.016805465198862, 0.014553959784630, -0.000867830491206, -0.000751563251563, -0.000613648825252, -0.005260942760943, -0.004556110078832, -0.003720048301697, -0.002630471380471, 0.005573742249200, -0.019662314484476, -0.017586508712907, -0.010386055465228, -0.009289570415333, -0.008045003969923, 0.003218001587969, 0.002878268120961, 0.002492653311655, 0.002035242906404, 0.006502699290733, 0.005816191060528, 0.005036969211681, 0.004112668139576, 0.002908095530264, -0.070559352471780, -0.012764667141782, -0.011652493554331, 0.004502951310090, 0.004110613346472, 0.003676644348772, 0.003805688458558, 0.003474102359315, 0.003107331614488, 0.002691028116129, -0.000736968401042, -0.000672757029032, -0.000601732179703, -0.000521115353897, -0.000425488904726, -0.002127444523630, -0.001942082259055, -0.001737051179658, -0.001504330449257, -0.001228280668404, -0.000868525589829},
    {0.010023442173431, -0.060375061453391, -0.006100072646930, -0.004313402734375, -0.005647569866600, 0.021872944039886, 0.017859184023390, 0.001262835012940, 0.001031100470341, 0.000729098134663, -0.041757438621600, 0.016805465198862, 0.014553959784630, 0.000867830491206, 0.000751563251563, 0.000613648825252, -0.005260942760943, -0.004556110078832, -0.003720048301697, -0.002630471380471, 0.005573742249200, 0.019662314484476, 0.017586508712907, -0.010386055465228, -0.009289570415333, -0.008045003969923, -0.003218001587969, -0.002878268120961, -0.002492653311655, -0.002035242906404, 0.006502699290733, 0.005816191060528, 0.005036969211681, 0.004112668139576, 0.002908095530264, 0.070559352471780, -0.012764667141782, -0.011652493554331, -0.004502951310090, -0.004110613346472, -0.003676644348772, 0.003805688458558, 0.003474102359315, 0.003107331614488, 0.002691028116129, 0.000736968401042, 0.000672757029032, 0.000601732179703, 0.000521115353897, 0.000425488904726, -0.002127444523630, -0.001942082259055, -0.001737051179658, -0.001504330449257, -0.001228280668404, -0.000868525589829},
    {-0.010023442173431, 0.045281296090044, -0.011328706344298, -0.008010605078124, -0.001411892466650, -0.016404708029914, -0.013394388017543, 0.014522602648807, 0.011857655408923, 0.008384628548623, 0.008948022561771, -0.014284645419033, -0.012370865816935, 0.014536160727703, 0.012588684463684, 0.010278617822976, -0.009394540644541, -0.008135910855058, -0.006642943395887, -0.004697270322270, -0.008360613373800, -0.002457789310560, -0.002198313589113, 0.008308844372183, 0.007431656332267, 0.006436003175939, -0.009654004763908, -0.008634804362882, -0.007477959934964, -0.006105728719213, 0.006502699290733, 0.005816191060528, 0.005036969211681, 0.004112668139576, 0.002908095530264, -0.035279676235890, 0.019147000712672, 0.017478740331497, -0.007880164792657, -0.007193573356327, -0.006434127610351, 0.000951422114639, 0.000868525589829, 0.000776832903622, 0.000672757029032, 0.002210905203127, 0.002018271087097, 0.001805196539109, 0.001563346061692, 0.001276466714178, -0.002127444523630, -0.001942082259055, -0.001737051179658, -0.001504330449257, -0.001228280668404, -0.000868525589829},
    {0.078755617076958, 0.067921944135065, -0.004357194747807, -0.003081001953125, 0.070594623332504, -0.032809416059829, -0.026788776035085, 0.012628350129398, 0.036088516461940, -0.007290981346629, 0.029826741872572, 0.015124918678976, 0.013098563806167, -0.032543643420231, -0.022922679172679, -0.024852777422719, 0.024801587301587, 0.016922694578520, 0.016474499621801, 0.014279701779702, 0.000000000000000, 0.024577893105595, 0.021983135891134, -0.036351194128299, -0.007431656332267, -0.034593517070670, 0.036202517864654, 0.000000000000000, 0.013086429886188, 0.033581507955671, -0.023223926038334, 0.001661768874437, -0.003597835151201, -0.014688100498485, -0.017864015400193, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.022608373405599, -0.004595805435965, 0.000000000000000, -0.033438235208407, -0.019420822590552, 0.009082219891937, 0.000000000000000, 0.033301472937102, 0.027077948086629, 0.007035057277613, -0.010211733713425, 0.000000000000000, -0.021362904849607, -0.019107562976233, -0.008123384425989, 0.001965249069446, 0.006079679128801},
    {-0.021478804657352, 0.003773441340837, 0.002178597373904, -0.021567013671873, 0.000000000000000, 0.098428248179486, -0.031253572040933, -0.085241363373434, -0.018044258230970, 0.030986670723172, 0.000000000000000, 0.045374756036928, -0.011643167827704, 0.000000000000000, 0.023674242424242, -0.001380709856818, -0.020292207792208, -0.033519952722837, -0.000797153207506, 0.003945707070707, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036351194128299, 0.024152883079867, -0.007240503572931, -0.060337529774424, 0.000000000000000, -0.039259289658563, 0.018825996884240, 0.046447852076667, -0.010801497683837, 0.025904413088645, 0.010869194368879, -0.017864015400193, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.033438235208407, -0.015536658072442, 0.003027406630646, 0.000000000000000, -0.055502454895169, 0.000000000000000, 0.016415133647764, -0.006807822475617, 0.000000000000000, 0.042725809699215, 0.006948204718630, -0.010831179234651, -0.003930498138893, 0.006079679128801},
    {0.078755617076958, 0.030187530726696, 0.061000726469297, -0.003081001953125, 0.000000000000000, 0.021872944039886, 0.017859184023390, 0.075770100776386, -0.041244018813646, -0.007290981346629, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.052069829472369, -0.012776575276575, 0.001840946475757, -0.009018759018759, 0.028638406209803, -0.029760386413575, 0.014279701779702, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.040225019849616, 0.014391340604803, -0.013709593214101, 0.004070485812809, -0.046447852076667, 0.018279457618802, -0.034539217451527, 0.036426489236243, -0.017864015400193, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.037001636596780, -0.030086608985143, 0.014070114555226, -0.003403911237808, 0.000000000000000, -0.042725809699215, 0.024318716515205, 0.000000000000000, -0.009826245347231, 0.006079679128801},
    {-0.021478804657352, 0.003773441340837, -0.019607376365131, 0.009243005859374, 0.000000000000000, -0.010936472019943, 0.102690308134494, 0.009471262597048, -0.069599281748027, -0.060150596109686, 0.000000000000000, -0.005041639559659, 0.046572671310816, 0.006508728684046, 0.021419552669553, -0.007824022521967, -0.004509379509380, -0.028963842644005, -0.026306055847714, 0.000563672438672, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.033442453495200, 0.028962014291723, 0.000000000000000, -0.043174021814409, -0.002492653311655, -0.060548476465528, 0.000000000000000, 0.029911839739857, -0.004317402181441, 0.018507006628091, 0.046114086265614, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.034957480662994, -0.012109626522582, 0.000000000000000, 0.000000000000000, -0.045129913477714, -0.028140229110452, 0.023827378664659, 0.000000000000000, 0.000000000000000, 0.031266921233836, 0.027077948086629, 0.000000000000000, -0.018239037386404},
    {-0.021478804657352, -0.015093765363348, 0.013071584243421, 0.009243005859374, 0.000000000000000, -0.010936472019943, -0.008929592011695, 0.009471262597048, 0.123732056440937, -0.060150596109686, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.006508728684046, 0.057494588744589, -0.026693723898476, 0.006764069264069, 0.012692020933890, 0.006377225660052, 0.000563672438672, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.043174021814409, 0.019941226493238, -0.014246700344830, 0.000000000000000, -0.044867759609786, 0.021587010907205, -0.061690022093637, 0.046114086265614, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.045129913477714, -0.037520305480603, 0.011913689332330, 0.000000000000000, 0.000000000000000, -0.046900381850753, 0.016246768851977, 0.020635115229186, -0.018239037386404},
    {0.078755617076958, 0.030187530726696, 0.017428778991228, 0.058539037109370, 0.000000000000000, 0.021872944039886, 0.017859184023390, -0.018942525194097, 0.010311004703411, 0.083846285486229, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.005260942760943, 0.053387447796952, 0.000000000000000, -0.004556110078832, 0.030823257356917, -0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.034897146363167, 0.028493400689660, 0.000000000000000, 0.000000000000000, -0.030221815270086, 0.016450672558303, -0.064393543884415, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.043773689727370, -0.023827378664659, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.037909127321280, -0.013756743486124, 0.030398395644007},
    {0.078755617076958, -0.067921944135065, -0.004357194747807, -0.003081001953125, 0.070594623332504, 0.032809416059829, 0.026788776035085, 0.012628350129398, 0.036088516461940, -0.007290981346629, -0.029826741872572, 0.015124918678976, 0.013098563806167, 0.032543643420231, 0.022922679172679, 0.024852777422719, 0.024801587301587, 0.016922694578520, 0.016474499621801, 0.014279701779702, 0.000000000000000, -0.024577893105595, -0.021983135891134, -0.036351194128299, -0.007431656332267, -0.034593517070670, -0.036202517864654, 0.000000000000000, -0.013086429886188, -0.033581507955671, -0.023223926038334, 0.001661768874437, -0.003597835151201, -0.014688100498485, -0.017864015400193, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.022608373405599, 0.004595805435965, 0.000000000000000, -0.033438235208407, -0.019420822590552, 0.009082219891937, 0.000000000000000, -0.033301472937102, -0.027077948086629, -0.007035057277613, 0.010211733713425, 0.000000000000000, -0.021362904849607, -0.019107562976233, -0.008123384425989, 0.001965249069446, 0.006079679128801},
    {-0.021478804657352, -0.003773441340837, 0.002178597373904, -0.021567013671873, 0.000000000000000, -0.098428248179486, 0.031253572040933, -0.085241363373434, -0.018044258230970, 0.030986670723172, 0.000000000000000, 0.045374756036928, -0.011643167827704, 0.000000000000000, -0.023674242424242, 0.001380709856818, -0.020292207792208, -0.033519952722837, -0.000797153207506, 0.003945707070707, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036351194128299, 0.024152883079867, -0.007240503572931, 0.060337529774424, 0.000000000000000, 0.039259289658563, -0.018825996884240, 0.046447852076667, -0.010801497683837, 0.025904413088645, 0.010869194368879, -0.017864015400193, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.033438235208407, -0.015536658072442, 0.003027406630646, 0.000000000000000, 0.055502454895169, 0.000000000000000, -0.016415133647764, 0.006807822475617, 0.000000000000000, 0.042725809699215, 0.006948204718630, -0.010831179234651, -0.003930498138893, 0.006079679128801},
    {0.078755617076958, -0.030187530726696, 0.061000726469297, -0.003081001953125, 0.000000000000000, -0.021872944039886, -0.017859184023390, 0.075770100776386, -0.041244018813646, -0.007290981346629, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.052069829472369, 0.012776575276575, -0.001840946475757, -0.009018759018759, 0.028638406209803, -0.029760386413575, 0.014279701779702, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.040225019849616, -0.014391340604803, 0.013709593214101, -0.004070485812809, -0.046447852076667, 0.018279457618802, -0.034539217451527, 0.036426489236243, -0.017864015400193, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.037001636596780, 0.030086608985143, -0.014070114555226, 0.003403911237808, 0.000000000000000, -0.042725809699215, 0.024318716515205, 0.000000000000000, -0.009826245347231, 0.006079679128801},
    {-0.021478804657352, -0.003773441340837, -0.019607376365131, 0.009243005859374, 0.000000000000000, 0.010936472019943, -0.102690308134494, 0.009471262597048, -0.069599281748027, -0.060150596109686, 0.000000000000000, -0.005041639559659, 0.046572671310816, -0.006508728684046, -0.021419552669553, 0.007824022521967, -0.004509379509380, -0.028963842644005, -0.026306055847714, 0.000563672438672, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.033442453495200, 0.028962014291723, 0.000000000000000, 0.043174021814409, 0.002492653311655, 0.060548476465528, 0.000000000000000, 0.029911839739857, -0.004317402181441, 0.018507006628091, 0.046114086265614, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.034957480662994, -0.012109626522582, 0.000000000000000, 0.000000000000000, 0.045129913477714, 0.028140229110452, -0.023827378664659, 0.000000000000000, 0.000000000000000, 0.031266921233836, 0.027077948086629, 0.000000000000000, -0.018239037386404},
    {-0.021478804657352, 0.015093765363348, 0.013071584243421, 0.009243005859374, 0.000000000000000, 0.010936472019943, 0.008929592011695, 0.009471262597048, 0.123732056440937, -0.060150596109686, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.006508728684046, -0.057494588744589, 0.026693723898476, 0.006764069264069, 0.012692020933890, 0.006377225660052, 0.000563672438672, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.043174021814409, -0.019941226493238, 0.014246700344830, 0.000000000000000, -0.044867759609786, 0.021587010907205, -0.061690022093637, 0.046114086265614, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.045129913477714, 0.037520305480603, -0.011913689332329, 0.000000000000000, 0.000000000000000, -0.046900381850753, 0.016246768851977, 0.020635115229186, -0.018239037386404},
    {0.078755617076958, -0.030187530726696, 0.017428778991228, 0.058539037109369, 0.000000000000000, -0.021872944039886, -0.017859184023390, -0.018942525194097, 0.010311004703411, 0.083846285486229, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.005260942760943, -0.053387447796952, 0.000000000000000, -0.004556110078832, 0.030823257356917, -0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.034897146363167, -0.028493400689660, 0.000000000000000, 0.000000000000000, -0.030221815270086, 0.016450672558303, -0.064393543884415, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.043773689727370, 0.023827378664659, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.037909127321280, -0.013756743486124, 0.030398395644007},
    {0.078755617076958, -0.037734413408370, -0.056643531721490, -0.003081001953125, 0.042356773999502, 0.054682360099715, 0.044647960058476, 0.037885050388193, 0.005155502351706, -0.007290981346629, 0.041757438621600, -0.005041639559659, 0.029593051562081, -0.024733168999375, 0.010146103896104, 0.026693723898476, -0.020292207792208, 0.002169576228015, 0.013285886791775, 0.014279701779702, -0.055737422492001, -0.024577893105595, -0.002198313589113, -0.005193027732614, -0.013005398581467, -0.016894508336839, 0.004022501984962, -0.015830474665283, -0.026796023100289, -0.029511022142862, 0.004644785207667, -0.010801497683837, -0.019428309816484, -0.021738388737758, -0.017864015400193, 0.000000000000000, 0.000000000000000, -0.051270971639058, 0.000000000000000, -0.022608373405599, -0.036766443487722, 0.000000000000000, -0.004776890744058, -0.007768329036221, -0.009082219891937, 0.000000000000000, 0.003700163659678, 0.006017321797029, 0.007035057277613, 0.006807822475617, 0.000000000000000, 0.004272580969921, 0.006948204718630, 0.008123384425989, 0.007860996277785, 0.006079679128801},
    {-0.021478804657352, 0.000000000000000, -0.004357194747807, -0.021567013671873, -0.127070321998507, 0.000000000000000, 0.000000000000000, 0.028413787791145, 0.036088516461940, 0.030986670723172, 0.000000000000000, 0.045374756036928, -0.042206483375427, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.020292207792208, -0.006183292249844, 0.001594306415013, 0.003945707070707, 0.083606133738001, 0.000000000000000, 0.000000000000000, -0.010386055465228, 0.024152883079867, 0.043443021437585, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.004644785207667, -0.010801497683837, -0.019428309816484, -0.021738388737758, -0.017864015400193, 0.000000000000000, 0.000000000000000, 0.076906457458587, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.009553781488116, -0.015536658072442, -0.018164439783874, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.004272580969921, 0.006948204718630, 0.008123384425989, 0.007860996277785, 0.006079679128801},
    {0.078755617076958, 0.037734413408370, -0.056643531721490, -0.003081001953125, 0.042356773999502, -0.054682360099715, -0.044647960058476, 0.037885050388193, 0.005155502351706, -0.007290981346629, -0.041757438621600, -0.005041639559659, 0.029593051562081, 0.024733168999375, -0.010146103896104, -0.026693723898476, -0.020292207792208, 0.002169576228015, 0.013285886791775, 0.014279701779702, -0.055737422492001, 0.024577893105595, 0.002198313589113, -0.005193027732614, -0.013005398581467, -0.016894508336839, -0.004022501984962, 0.015830474665283, 0.026796023100289, 0.029511022142862, 0.004644785207667, -0.010801497683837, -0.019428309816484, -0.021738388737758, -0.017864015400193, 0.000000000000000, 0.000000000000000, -0.051270971639058, 0.000000000000000, 0.022608373405599, 0.036766443487722, 0.000000000000000, -0.004776890744058, -0.007768329036221, -0.009082219891937, 0.000000000000000, -0.003700163659678, -0.006017321797029, -0.007035057277613, -0.006807822475617, 0.000000000000000, 0.004272580969921, 0.006948204718630, 0.008123384425989, 0.007860996277785, 0.006079679128801},
    {-0.021478804657352, -0.018867206704185, 0.006535792121710, 0.009243005859374, 0.014118924666501, 0.000000000000000, -0.111619900146189, -0.003157087532349, -0.054132774692910, -0.060150596109686, -0.008948022561771, -0.002520819779829, -0.027652523590797, 0.000650872868405, 0.036075036075036, -0.018869701376509, 0.001127344877345, 0.037425189933265, 0.019928830187662, 0.000563672438672, 0.000000000000000, 0.000000000000000, 0.059354466906061, 0.000000000000000, 0.016721226747600, 0.003218001587969, 0.000000000000000, -0.004317402181441, 0.022433879804893, 0.046301776120698, 0.000000000000000, -0.007477959934964, 0.018708742786244, 0.043183015465546, 0.046114086265614, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.062043373385530, 0.000000000000000, 0.000000000000000, 0.017478740331497, 0.036328879567747, 0.000000000000000, 0.000000000000000, -0.004512991347771, -0.009380076370151, -0.011913689332329, 0.000000000000000, 0.000000000000000, -0.007816730308459, -0.016246768851977, -0.020635115229186, -0.018239037386404},
    {-0.021478804657352, 0.018867206704185, 0.006535792121710, 0.009243005859374, 0.014118924666501, 0.000000000000000, 0.111619900146189, -0.003157087532349, -0.054132774692910, -0.060150596109686, 0.008948022561771, -0.002520819779829, -0.027652523590797, -0.000650872868405, -0.036075036075036, 0.018869701376509, 0.001127344877345, 0.037425189933265, 0.019928830187662, 0.000563672438672, 0.000000000000000, 0.000000000000000, -0.059354466906061, 0.000000000000000, 0.016721226747600, 0.003218001587969, 0.000000000000000, 0.004317402181441, -0.022433879804893, -0.046301776120698, 0.000000000000000, -0.007477959934964, 0.018708742786244, 0.043183015465546, 0.046114086265614, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.062043373385530, 0.000000000000000, 0.000000000000000, 0.017478740331497, 0.036328879567747, 0.000000000000000, 0.000000000000000, 0.004512991347771, 0.009380076370151, 0.011913689332330, 0.000000000000000, 0.000000000000000, -0.007816730308459, -0.016246768851977, -0.020635115229186, -0.018239037386404},
    {0.078755617076958, 0.000000000000000, -0.034857557982456, 0.058539037109369, -0.028237849333002, 0.000000000000000, 0.000000000000000, 0.006314175064699, -0.020622009406823, 0.083846285486229, 0.000000000000000, 0.000000000000000, -0.006791847899494, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.001518703359611, -0.061646514713834, -0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.045052022231570, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.010073938423362, -0.032901345116607, -0.064393543884415, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.056511590438718, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.012636375773760, 0.027513486972248, 0.030398395644007},
    {0.078755617076958, -0.037734413408370, -0.021785973739035, -0.052377033203120, 0.042356773999502, 0.054682360099715, 0.044647960058476, 0.000000000000000, 0.025777511758529, 0.029163925386514, 0.041757438621600, 0.028569290838066, -0.009217507863599, 0.027336660472994, -0.007891414141414, -0.024852777422719, 0.018789081289081, -0.003471321964825, -0.014348757735117, -0.015031265031265, -0.055737422492001, -0.004915578621119, -0.024181449480247, -0.019733505383934, -0.009289570415333, -0.002413501190977, -0.039420519452623, -0.015830474665283, -0.000623163327914, 0.007123350172415, -0.032513496453667, -0.014125035432710, -0.002158701090720, 0.004112668139576, 0.005400748841919, 0.000000000000000, -0.051058668567126, 0.004660997421733, -0.040526561790806, -0.014387146712654, 0.003676644348772, -0.011417065375673, -0.005645416333887, -0.001553665807244, 0.001009135543549, 0.010317557614593, 0.005718434746775, 0.002406928718811, 0.000260557676949, -0.000850977809452, 0.012764667141782, 0.007379912584410, 0.003474102359315, 0.000902598269554, -0.000491312267362, -0.000868525589829},
    {-0.021478804657352, 0.000000000000000, -0.021785973739035, 0.003081001953125, -0.127070321998507, 0.000000000000000, 0.000000000000000, 0.047356312985241, 0.025777511758529, 0.012759217356600, 0.000000000000000, -0.035291476917610, 0.050938859246204, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.002254689754690, -0.009437656591867, -0.014348757735117, -0.012964466089466, 0.083606133738001, 0.000000000000000, 0.000000000000000, 0.047775855140050, 0.009289570415333, -0.014481007145862, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.032513496453667, -0.014125035432710, -0.002158701090720, 0.004112668139576, 0.005400748841919, 0.000000000000000, 0.076588002850690, -0.006991496132599, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.022834130751345, -0.011290832667774, -0.003107331614488, 0.002018271087097, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.012764667141782, 0.007379912584410, 0.003474102359315, 0.000902598269554, -0.000491312267362, -0.000868525589829},
    {0.078755617076958, 0.037734413408370, -0.021785973739035, -0.052377033203120, 0.042356773999502, -0.054682360099715, -0.044647960058476, 0.000000000000000, 0.025777511758529, 0.029163925386514, -0.041757438621600, 0.028569290838066, -0.009217507863599, -0.027336660472994, 0.007891414141414, 0.024852777422719, 0.018789081289081, -0.003471321964825, -0.014348757735117, -0.015031265031265, -0.055737422492001, 0.004915578621119, 0.024181449480247, -0.019733505383934, -0.009289570415333, -0.002413501190977, 0.039420519452623, 0.015830474665283, 0.000623163327914, -0.007123350172415, -0.032513496453667, -0.014125035432710, -0.002158701090720, 0.004112668139576, 0.005400748841919, 0.000000000000000, -0.051058668567126, 0.004660997421733, 0.040526561790806, 0.014387146712654, -0.003676644348772, -0.011417065375673, -0.005645416333887, -0.001553665807244, 0.001009135543549, -0.010317557614593, -0.005718434746775, -0.002406928718811, -0.000260557676949, 0.000850977809452, 0.012764667141782, 0.007379912584410, 0.003474102359315, 0.000902598269554, -0.000491312267362, -0.000868525589829},
    {-0.021478804657352, -0.018867206704185, 0.010892986869517, 0.003081001953125, 0.014118924666501, -0.109364720199429, 0.022323980029238, -0.078927188308736, -0.012888755879264, 0.012759217356600, -0.008948022561771, -0.027729017578122, 0.001455395978463, -0.005857855815641, 0.038329725829726, -0.012426388711359, 0.019164862914863, 0.034821698459647, 0.007174378867558, -0.012964466089466, 0.000000000000000, 0.058986943453429, -0.006594940767340, 0.007270238825660, 0.014863312664534, -0.004022501984962, 0.050683525010516, -0.004317402181441, -0.008101123262878, 0.003561675086208, 0.065026992907334, -0.001661768874437, -0.011513072483842, -0.002056334069788, 0.005400748841919, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.060789842686209, -0.012331840039417, 0.001378741630790, 0.039959728814854, 0.003039839564401, -0.004272580969921, 0.001009135543549, -0.015476336421890, -0.003027406630646, 0.000902598269554, 0.000781673030846, -0.000425488904726, -0.031911667854454, -0.007768329036221, 0.000868525589829, 0.001805196539109, 0.000245656133681, -0.000868525589829},
    {-0.021478804657352, 0.018867206704185, 0.010892986869517, 0.003081001953125, 0.014118924666501, 0.109364720199429, -0.022323980029238, -0.078927188308736, -0.012888755879264, 0.012759217356600, 0.008948022561771, -0.027729017578122, 0.001455395978463, 0.005857855815641, -0.038329725829726, 0.012426388711359, 0.019164862914863, 0.034821698459647, 0.007174378867558, -0.012964466089466, 0.000000000000000, -0.058986943453429, 0.006594940767340, 0.007270238825660, 0.014863312664534, -0.004022501984962, -0.050683525010516, 0.004317402181441, 0.008101123262878, -0.003561675086208, 0.065026992907334, -0.001661768874437, -0.011513072483842, -0.002056334069788, 0.005400748841919, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.060789842686209, 0.012331840039417, -0.001378741630790, 0.039959728814854, 0.003039839564401, -0.004272580969921, 0.001009135543549, 0.015476336421890, 0.003027406630646, -0.000902598269554, -0.000781673030846, 0.000425488904726, -0.031911667854454, -0.007768329036221, 0.000868525589829, 0.001805196539109, 0.000245656133681, -0.000868525589829},
    {0.078755617076958, 0.000000000000000, 0.043571947478070, -0.052377033203120, -0.028237849333002, 0.000000000000000, 0.000000000000000, 0.063141750646989, -0.051555023517057, 0.029163925386514, 0.000000000000000, -0.006722186079545, 0.000970263985642, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.060125060125060, -0.012583542122489, 0.028697515470233, -0.015031265031265, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.043621432953959, 0.011147484498400, -0.001609000793985, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.065026992907334, 0.031573608614294, -0.002878268120961, -0.008225336279152, 0.005400748841919, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.053279638419806, 0.018239037386404, -0.004660997421733, 0.000672757029032, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.042548890472605, -0.003884164518110, -0.003474102359315, 0.001203464359406, 0.000982624534723, -0.000868525589829},
    {0.107394023286761, -0.188672067041848, -0.108929868695174, -0.077025048828118, -0.070594623332504, -0.054682360099715, -0.044647960058476, -0.031570875323494, -0.025777511758529, -0.018227453366572, 0.089480225617715, -0.015124918678976, -0.013098563806167, 0.058578558156415, -0.028183621933622, 0.069035492840886, 0.074404761904762, 0.009763093026069, 0.039857660375324, 0.059749278499279, 0.000000000000000, 0.073733679316786, 0.065949407673402, 0.036351194128299, 0.007431656332267, 0.034593517070670, -0.012067505954885, 0.043174021814409, 0.015579083197842, -0.025440536330054, -0.023223926038334, 0.046529528484223, 0.025184846058405, -0.014688100498485, -0.032819935270121, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.067825120216796, -0.013787416307896, 0.000000000000000, 0.033438235208407, 0.019420822590552, -0.009082219891937, 0.000000000000000, -0.011100490979034, -0.009025982695543, -0.002345019092538, 0.003403911237808, 0.000000000000000, -0.021362904849607, -0.019107562976233, -0.008123384425989, 0.001965249069446, 0.006079679128801},
    {0.107394023286761, 0.188672067041848, -0.108929868695174, -0.077025048828118, -0.070594623332504, 0.054682360099715, 0.044647960058476, -0.031570875323494, -0.025777511758529, -0.018227453366572, -0.089480225617715, -0.015124918678976, -0.013098563806167, -0.058578558156415, 0.028183621933622, -0.069035492840886, 0.074404761904762, 0.009763093026069, 0.039857660375324, 0.059749278499278, 0.000000000000000, -0.073733679316786, -0.065949407673402, 0.036351194128299, 0.007431656332267, 0.034593517070670, 0.012067505954885, -0.043174021814409, -0.015579083197842, 0.025440536330054, -0.023223926038334, 0.046529528484223, 0.025184846058405, -0.014688100498485, -0.032819935270121, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.067825120216796, 0.013787416307896, 0.000000000000000, 0.033438235208407, 0.019420822590552, -0.009082219891937, 0.000000000000000, 0.011100490979034, 0.009025982695543, 0.002345019092538, -0.003403911237808, 0.000000000000000, -0.021362904849607, -0.019107562976233, -0.008123384425989, 0.001965249069446, 0.006079679128801},
    {0.107394023286761, 0.000000000000000, 0.217859737390348, -0.077025048828118, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.094712625970483, 0.051555023517057, -0.018227453366572, 0.000000000000000, -0.090749512073855, 0.023286335655408, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.094696969696970, -0.022780550394161, -0.079715320750648, 0.059749278499278, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.072702388256598, -0.048305766159734, 0.014481007145862, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.046447852076667, -0.078103137098517, 0.043174021814409, 0.029376200996970, -0.032819935270121, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.066876470416815, 0.031073316144883, -0.006054813261291, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.042725809699215, 0.006948204718630, -0.010831179234651, -0.003930498138893, 0.006079679128801},
    {0.107394023286761, 0.000000000000000, 0.000000000000000, 0.231075146484353, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.109364720199429, 0.000000000000000, 0.010083279119317, -0.093145342621631, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.004509379509379, -0.104139658944738, 0.000000000000000, -0.092442279942280, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.066884906990401, -0.057924028583447, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.029911839739858, -0.064761032721614, 0.000000000000000, 0.083503885940436, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.069914961325988, 0.024219253045165, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.031266921233836, 0.027077948086629, 0.000000000000000, -0.018239037386404}};
    
    // Compute value(s).
    for (unsigned int r = 0; r < 56; r++)
    {
      *values += coefficients0[dof][r]*basisvalues[r];
    }// end loop over 'r'
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.000000000000000;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 56; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[56] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    unsigned int tt = 0;
    double tmp5 = 0.000000000000000;
    double tmp6 = 0.000000000000000;
    double tmp7 = 0.000000000000000;
    double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
    double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
    double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
    double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
    double tmp4 = tmp3*tmp3;
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 1; r < 5; r++)
    {
      rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
      ss = r*(r + 1)*(r + 2)/6;
      tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
      basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 5; r++)
    {
      rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
      ss = r*(r + 1)*(r + 2)/6;
      basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
    }// end loop over 'r'
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 1; s < 5 - r; s++)
      {
        rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
        tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 5; r++)
    {
      for (unsigned int s = 0; s < 5 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 0; s < 4 - r; s++)
      {
        for (unsigned int t = 1; t < 5 - r - s; t++)
        {
          rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
          ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
          tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 6; r++)
    {
      for (unsigned int s = 0; s < 6 - r; s++)
      {
        for (unsigned int t = 0; t < 6 - r - s; t++)
        {
          rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[56][56] = \
    {{0.009450674049235, 0.006097881206793, 0.003520613356228, 0.002489449578125, 0.007059462333250, 0.005468236009971, 0.004464796005848, 0.003157087532349, 0.002577751175853, 0.001822745336657, -0.002982674187257, -0.002520819779829, -0.002183093967694, -0.001952618605214, -0.001691017316017, -0.001380709856818, -0.001127344877345, -0.000976309302607, -0.000797153207506, -0.000563672438672, 0.002786871124600, 0.002457789310560, 0.002198313589113, 0.002077211093046, 0.001857914083067, 0.001609000793985, 0.001609000793985, 0.001439134060480, 0.001246326655827, 0.001017621453202, 0.000928957041533, 0.000830884437218, 0.000719567030240, 0.000587524019939, 0.000415442218609, -0.007055935247178, -0.006382333570891, -0.005826246777166, -0.005628689137612, -0.005138266683091, -0.004595805435965, -0.004757110573197, -0.004342627949144, -0.003884164518110, -0.003363785145162, -0.003684842005212, -0.003363785145162, -0.003008660898514, -0.002605576769486, -0.002127444523630, -0.002127444523630, -0.001942082259055, -0.001737051179658, -0.001504330449257, -0.001228280668404, -0.000868525589829},
    {0.009450674049235, -0.006097881206793, 0.003520613356228, 0.002489449578125, 0.007059462333250, -0.005468236009971, -0.004464796005848, 0.003157087532349, 0.002577751175853, 0.001822745336657, 0.002982674187257, -0.002520819779829, -0.002183093967694, 0.001952618605214, 0.001691017316017, 0.001380709856818, -0.001127344877345, -0.000976309302607, -0.000797153207506, -0.000563672438672, 0.002786871124600, -0.002457789310560, -0.002198313589113, 0.002077211093046, 0.001857914083067, 0.001609000793985, -0.001609000793985, -0.001439134060480, -0.001246326655827, -0.001017621453202, 0.000928957041533, 0.000830884437218, 0.000719567030240, 0.000587524019939, 0.000415442218609, 0.007055935247178, -0.006382333570891, -0.005826246777166, 0.005628689137612, 0.005138266683091, 0.004595805435965, -0.004757110573197, -0.004342627949144, -0.003884164518110, -0.003363785145162, 0.003684842005212, 0.003363785145162, 0.003008660898514, 0.002605576769486, 0.002127444523630, -0.002127444523630, -0.001942082259055, -0.001737051179658, -0.001504330449257, -0.001228280668404, -0.000868525589829},
    {0.009450674049235, 0.000000000000000, -0.007041226712456, 0.002489449578125, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.009471262597048, -0.005155502351706, 0.001822745336657, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.004509379509380, -0.002928927907821, 0.001594306415013, -0.000563672438672, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.004644785207667, -0.003323537748873, 0.002158701090720, -0.001175048039879, 0.000415442218609, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.012764667141782, -0.009710411295276, 0.006948204718630, -0.004512991347771, 0.002456561336808, -0.000868525589829},
    {0.009450674049235, 0.000000000000000, 0.000000000000000, -0.007468348734374, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.010936472019943, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.005636724386724, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.006231633279137, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.018239037386404},
    {-0.010023442173431, 0.000000000000000, 0.037471874831140, -0.028961418359372, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.028413787791145, 0.005155502351706, -0.006197334144634, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.031565656565657, -0.011390275197081, 0.002657177358355, -0.000187890812891, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.023223926038334, -0.001661768874437, -0.006476103272161, 0.006462764219333, -0.002908095530264, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.021362904849607, -0.027792818874520, 0.024370153277966, -0.015721992555570, 0.006079679128801},
    {0.010023442173431, 0.000000000000000, -0.028757485335526, 0.053609433984370, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.018942525194097, 0.015466507055117, 0.015311060827920, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.004509379509380, 0.037099753499063, -0.028166079998562, 0.010897667147667, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.029911839739858, -0.004317402181441, -0.012338004418727, 0.008724286590792, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.031266921233836, -0.048740306555932, 0.041270230458372, -0.018239037386404},
    {0.010023442173431, 0.000000000000000, 0.040957630629385, -0.044982628515621, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.018942525194097, -0.005155502351706, -0.021143845905223, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.004556110078832, 0.035606176601956, -0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.030221815270086, 0.004112668139576, -0.014540477651320, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.037909127321280, -0.055026973944496, 0.030398395644007},
    {-0.010023442173431, 0.000000000000000, -0.014814462142544, 0.044982628515621, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.020622009406823, 0.021143845905223, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.010628709433420, 0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.020563340697879, 0.014540477651320, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.034391858715310, -0.030398395644007},
    {-0.010023442173431, 0.032451595531198, -0.018735937415570, -0.028961418359372, 0.021178386999751, -0.016404708029914, 0.004464796005848, 0.009471262597048, -0.002577751175853, -0.006197334144634, 0.020878719310800, -0.017645738458805, -0.008489809874367, 0.013668330236497, 0.006576178451178, 0.002301183094696, -0.007891414141414, -0.003796758399027, -0.001328588679177, -0.000187890812891, 0.013934355623000, -0.012288946552798, -0.001099156794557, 0.010386055465228, 0.000928957041533, -0.004827002381954, -0.008045003969923, -0.000719567030240, 0.003738979967482, 0.005596917992612, 0.004644785207667, 0.000415442218609, -0.002158701090720, -0.003231382109667, -0.002908095530264, 0.000000000000000, 0.000000000000000, 0.012817742909764, 0.000000000000000, -0.011304186702799, -0.018383221743861, 0.000000000000000, 0.009553781488116, 0.015536658072442, 0.018164439783874, 0.000000000000000, -0.007400327319356, -0.012034643594057, -0.014070114555226, -0.013615644951234, 0.000000000000000, 0.004272580969921, 0.006948204718630, 0.008123384425989, 0.007860996277785, 0.006079679128801},
    {0.010023442173431, -0.024904712849524, 0.014378742667763, 0.053609433984370, -0.014118924666501, 0.010936472019943, 0.013394388017543, -0.006314175064699, -0.007733253527559, 0.015311060827920, -0.002982674187257, 0.002520819779829, 0.027652523590797, -0.001952618605214, -0.021419552669553, -0.024392540803780, 0.001127344877345, 0.012366584499688, 0.014083039999281, 0.010897667147667, 0.000000000000000, 0.000000000000000, 0.019784822302020, 0.000000000000000, -0.016721226747600, -0.003218001587969, 0.000000000000000, 0.012952206544323, 0.002492653311655, -0.010685025258623, 0.000000000000000, -0.007477959934964, -0.001439134060480, 0.006169002209364, 0.008724286590792, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.020681124461843, 0.000000000000000, 0.000000000000000, -0.017478740331497, -0.036328879567747, 0.000000000000000, 0.000000000000000, 0.013538974043314, 0.028140229110452, 0.035741067996988, 0.000000000000000, 0.000000000000000, -0.007816730308459, -0.016246768851977, -0.020635115229186, -0.018239037386404},
    {0.010023442173431, 0.035470348603867, -0.020478815314693, -0.044982628515621, 0.014118924666501, -0.010936472019943, -0.004464796005848, 0.006314175064699, 0.002577751175853, -0.021143845905223, 0.000000000000000, 0.000000000000000, 0.003395923949747, 0.000000000000000, -0.002630471380471, 0.030835853468929, 0.000000000000000, 0.001518703359611, -0.017803088300978, -0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.022526011115785, 0.000000000000000, 0.000000000000000, -0.017448573181584, 0.003561675086208, 0.000000000000000, 0.000000000000000, 0.010073938423362, -0.002056334069788, -0.014540477651320, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.028255795219359, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.021886844863685, -0.047654757329318, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.012636375773760, 0.027513486972248, 0.030398395644007},
    {-0.010023442173431, -0.012829700558846, 0.007407231071272, 0.044982628515621, 0.000000000000000, 0.000000000000000, 0.017859184023390, 0.000000000000000, -0.010311004703411, 0.021143845905223, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.009204732378785, 0.000000000000000, 0.000000000000000, -0.005314354716710, 0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.017808375431038, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.010281670348940, 0.014540477651320, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.029784223330824, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.017195929357655, -0.030398395644007},
    {-0.010023442173431, 0.032451595531198, -0.033550399558114, -0.008010605078124, 0.021178386999751, 0.001093647201994, -0.016966224822221, -0.005682757558229, 0.005671052586876, 0.008384628548623, 0.020878719310800, -0.010923552379260, -0.016251921759503, 0.004990025324435, 0.009582431457431, 0.010892266648229, -0.001878908128908, -0.004664588890233, -0.005580072452545, -0.004697270322270, 0.013934355623000, -0.002457789310560, -0.012090724740124, -0.004154422186091, 0.004644785207667, 0.009654004763908, 0.006436003175939, -0.000719567030240, -0.004985306623310, -0.006614539445814, -0.004644785207667, -0.000415442218609, 0.002158701090720, 0.003231382109667, 0.002908095530264, 0.000000000000000, 0.012764667141782, -0.001165249355433, -0.020263280895403, -0.007193573356327, 0.001838322174386, 0.022834130751345, 0.011290832667774, 0.003107331614488, -0.002018271087097, -0.020635115229186, -0.011436869493550, -0.004813857437623, -0.000521115353897, 0.001701955618904, 0.012764667141782, 0.007379912584410, 0.003474102359315, 0.000902598269554, -0.000491312267362, -0.000868525589829},
    {0.010023442173431, -0.024904712849524, 0.055336373297148, -0.004313402734375, -0.014118924666501, 0.015311060827920, 0.008036632810526, 0.008839845090578, -0.015982057290288, 0.000729098134663, -0.002982674187257, 0.027729017578122, -0.001455395978463, -0.030157109569414, -0.011649230399230, 0.003528480745201, 0.019164862914863, 0.009763093026069, 0.001328588679177, -0.002630471380471, 0.000000000000000, 0.019662314484476, -0.002198313589113, -0.007270238825660, -0.014863312664534, 0.004022501984962, -0.007240503572931, 0.012952206544323, 0.006854796607051, -0.004579296539410, 0.009289570415333, -0.006647075497746, -0.005756536241921, -0.000293762009970, 0.002908095530264, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.020263280895403, -0.004110613346472, 0.000459580543597, -0.039959728814854, -0.003039839564401, 0.004272580969921, -0.001009135543549, 0.046429009265669, 0.009082219891937, -0.002707794808663, -0.002345019092538, 0.001276466714178, -0.031911667854454, -0.007768329036221, 0.000868525589829, 0.001805196539109, 0.000245656133681, -0.000868525589829},
    {0.010023442173431, 0.035470348603867, -0.049236300650219, -0.004313402734375, 0.014118924666501, -0.006561883211966, -0.009822551212865, -0.016416855168217, 0.014950956819947, 0.000729098134663, 0.000000000000000, 0.003361093039772, -0.000485131992821, 0.028204490964200, -0.012400793650794, 0.002914831919949, -0.035323472823473, 0.008895262534863, 0.002391459622519, -0.002630471380471, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.021810716476979, -0.005573742249200, 0.000804500396992, -0.004022501984962, -0.014391340604803, 0.009347449918705, -0.002544053633005, -0.009289570415333, 0.014125035432710, -0.002878268120961, -0.003818906129606, 0.002908095530264, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.026639819209903, -0.009119518693202, 0.002330498710866, -0.000336378514516, -0.051587788072965, 0.008409462862904, 0.003008660898514, -0.002866134446435, 0.000850977809452, 0.042548890472605, -0.003884164518110, -0.003474102359315, 0.001203464359406, 0.000982624534723, -0.000868525589829},
    {-0.010023442173431, -0.012829700558846, 0.044879105902412, -0.008010605078124, 0.000000000000000, 0.017498355231909, -0.003571836804678, 0.013259767635868, -0.017528707995799, 0.008384628548623, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.008678304912061, -0.003006253006253, 0.000613648825252, 0.022546897546898, -0.019200749617936, 0.012223015848433, -0.004697270322270, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.016090007939846, -0.007195670302402, 0.002492653311655, -0.000508810726601, 0.004644785207667, -0.010801497683837, 0.010793505453602, -0.007344050249243, 0.002908095530264, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.025793894036483, -0.013455140580647, 0.006017321797029, -0.002084461415589, 0.000425488904726, -0.031911667854454, 0.013594575813387, -0.003474102359315, -0.000902598269554, 0.001719592935765, -0.000868525589829},
    {-0.010023442173431, -0.032451595531198, -0.018735937415570, -0.028961418359372, 0.021178386999751, 0.016404708029914, -0.004464796005848, 0.009471262597048, -0.002577751175853, -0.006197334144634, -0.020878719310800, -0.017645738458805, -0.008489809874367, -0.013668330236497, -0.006576178451178, -0.002301183094696, -0.007891414141414, -0.003796758399027, -0.001328588679177, -0.000187890812891, 0.013934355623000, 0.012288946552798, 0.001099156794557, 0.010386055465228, 0.000928957041533, -0.004827002381954, 0.008045003969923, 0.000719567030240, -0.003738979967482, -0.005596917992612, 0.004644785207667, 0.000415442218609, -0.002158701090720, -0.003231382109667, -0.002908095530264, 0.000000000000000, 0.000000000000000, 0.012817742909764, 0.000000000000000, 0.011304186702799, 0.018383221743861, 0.000000000000000, 0.009553781488116, 0.015536658072442, 0.018164439783874, 0.000000000000000, 0.007400327319356, 0.012034643594057, 0.014070114555226, 0.013615644951234, 0.000000000000000, 0.004272580969921, 0.006948204718630, 0.008123384425989, 0.007860996277785, 0.006079679128801},
    {0.010023442173431, 0.024904712849524, 0.014378742667763, 0.053609433984370, -0.014118924666501, -0.010936472019943, -0.013394388017543, -0.006314175064699, -0.007733253527559, 0.015311060827920, 0.002982674187257, 0.002520819779829, 0.027652523590797, 0.001952618605214, 0.021419552669553, 0.024392540803780, 0.001127344877345, 0.012366584499688, 0.014083039999281, 0.010897667147667, 0.000000000000000, 0.000000000000000, -0.019784822302020, 0.000000000000000, -0.016721226747600, -0.003218001587969, 0.000000000000000, -0.012952206544323, -0.002492653311655, 0.010685025258623, 0.000000000000000, -0.007477959934964, -0.001439134060480, 0.006169002209364, 0.008724286590792, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.020681124461843, 0.000000000000000, 0.000000000000000, -0.017478740331497, -0.036328879567747, 0.000000000000000, 0.000000000000000, -0.013538974043314, -0.028140229110452, -0.035741067996988, 0.000000000000000, 0.000000000000000, -0.007816730308459, -0.016246768851977, -0.020635115229186, -0.018239037386404},
    {0.010023442173431, -0.035470348603867, -0.020478815314693, -0.044982628515621, 0.014118924666501, 0.010936472019943, 0.004464796005848, 0.006314175064699, 0.002577751175853, -0.021143845905223, 0.000000000000000, 0.000000000000000, 0.003395923949747, 0.000000000000000, 0.002630471380471, -0.030835853468929, 0.000000000000000, 0.001518703359611, -0.017803088300978, -0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.022526011115785, 0.000000000000000, 0.000000000000000, 0.017448573181584, -0.003561675086208, 0.000000000000000, 0.000000000000000, 0.010073938423362, -0.002056334069788, -0.014540477651320, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.028255795219359, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.021886844863685, 0.047654757329318, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.012636375773760, 0.027513486972248, 0.030398395644007},
    {-0.010023442173431, 0.012829700558846, 0.007407231071272, 0.044982628515621, 0.000000000000000, 0.000000000000000, -0.017859184023390, 0.000000000000000, -0.010311004703411, 0.021143845905223, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.009204732378785, 0.000000000000000, 0.000000000000000, -0.005314354716710, 0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.017808375431038, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.010281670348940, 0.014540477651320, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.029784223330824, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.017195929357655, -0.030398395644007},
    {-0.010023442173431, -0.032451595531198, -0.033550399558114, -0.008010605078124, 0.021178386999751, -0.001093647201994, 0.016966224822221, -0.005682757558229, 0.005671052586876, 0.008384628548623, -0.020878719310800, -0.010923552379260, -0.016251921759503, -0.004990025324435, -0.009582431457431, -0.010892266648229, -0.001878908128908, -0.004664588890233, -0.005580072452545, -0.004697270322270, 0.013934355623000, 0.002457789310560, 0.012090724740124, -0.004154422186091, 0.004644785207667, 0.009654004763908, -0.006436003175939, 0.000719567030240, 0.004985306623310, 0.006614539445814, -0.004644785207667, -0.000415442218609, 0.002158701090720, 0.003231382109667, 0.002908095530264, 0.000000000000000, 0.012764667141782, -0.001165249355433, 0.020263280895403, 0.007193573356327, -0.001838322174386, 0.022834130751345, 0.011290832667774, 0.003107331614488, -0.002018271087097, 0.020635115229186, 0.011436869493550, 0.004813857437623, 0.000521115353897, -0.001701955618904, 0.012764667141782, 0.007379912584410, 0.003474102359315, 0.000902598269554, -0.000491312267362, -0.000868525589829},
    {0.010023442173431, 0.024904712849524, 0.055336373297148, -0.004313402734375, -0.014118924666501, -0.015311060827920, -0.008036632810526, 0.008839845090578, -0.015982057290288, 0.000729098134663, 0.002982674187257, 0.027729017578122, -0.001455395978463, 0.030157109569414, 0.011649230399230, -0.003528480745201, 0.019164862914863, 0.009763093026069, 0.001328588679177, -0.002630471380471, 0.000000000000000, -0.019662314484476, 0.002198313589113, -0.007270238825660, -0.014863312664534, 0.004022501984962, 0.007240503572931, -0.012952206544323, -0.006854796607051, 0.004579296539410, 0.009289570415334, -0.006647075497746, -0.005756536241921, -0.000293762009970, 0.002908095530264, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.020263280895403, 0.004110613346472, -0.000459580543597, -0.039959728814854, -0.003039839564401, 0.004272580969921, -0.001009135543549, -0.046429009265669, -0.009082219891937, 0.002707794808663, 0.002345019092538, -0.001276466714178, -0.031911667854454, -0.007768329036221, 0.000868525589829, 0.001805196539109, 0.000245656133681, -0.000868525589829},
    {0.010023442173431, -0.035470348603867, -0.049236300650219, -0.004313402734375, 0.014118924666501, 0.006561883211966, 0.009822551212865, -0.016416855168217, 0.014950956819947, 0.000729098134663, 0.000000000000000, 0.003361093039772, -0.000485131992821, -0.028204490964200, 0.012400793650794, -0.002914831919949, -0.035323472823473, 0.008895262534863, 0.002391459622519, -0.002630471380471, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.021810716476979, -0.005573742249200, 0.000804500396992, 0.004022501984962, 0.014391340604803, -0.009347449918705, 0.002544053633005, -0.009289570415334, 0.014125035432710, -0.002878268120961, -0.003818906129606, 0.002908095530264, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.026639819209903, -0.009119518693202, 0.002330498710866, -0.000336378514516, 0.051587788072965, -0.008409462862904, -0.003008660898514, 0.002866134446435, -0.000850977809452, 0.042548890472605, -0.003884164518110, -0.003474102359315, 0.001203464359406, 0.000982624534723, -0.000868525589829},
    {-0.010023442173431, 0.012829700558846, 0.044879105902412, -0.008010605078124, 0.000000000000000, -0.017498355231909, 0.003571836804678, 0.013259767635868, -0.017528707995799, 0.008384628548623, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.008678304912061, 0.003006253006253, -0.000613648825252, 0.022546897546898, -0.019200749617936, 0.012223015848433, -0.004697270322270, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.016090007939846, 0.007195670302402, -0.002492653311655, 0.000508810726601, 0.004644785207667, -0.010801497683837, 0.010793505453602, -0.007344050249243, 0.002908095530264, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.025793894036483, 0.013455140580647, -0.006017321797029, 0.002084461415589, -0.000425488904726, -0.031911667854454, 0.013594575813387, -0.003474102359315, -0.000902598269554, 0.001719592935765, -0.000868525589829},
    {-0.010023442173431, -0.045281296090043, -0.011328706344298, -0.008010605078124, -0.001411892466650, 0.016404708029914, 0.013394388017543, 0.014522602648807, 0.011857655408923, 0.008384628548623, -0.008948022561771, -0.014284645419033, -0.012370865816935, -0.014536160727703, -0.012588684463684, -0.010278617822976, -0.009394540644541, -0.008135910855058, -0.006642943395887, -0.004697270322270, -0.008360613373800, 0.002457789310560, 0.002198313589113, 0.008308844372183, 0.007431656332267, 0.006436003175939, 0.009654004763908, 0.008634804362882, 0.007477959934964, 0.006105728719213, 0.006502699290733, 0.005816191060528, 0.005036969211681, 0.004112668139576, 0.002908095530264, 0.035279676235890, 0.019147000712672, 0.017478740331497, 0.007880164792657, 0.007193573356327, 0.006434127610351, 0.000951422114639, 0.000868525589829, 0.000776832903622, 0.000672757029032, -0.002210905203127, -0.002018271087097, -0.001805196539109, -0.001563346061692, -0.001276466714178, -0.002127444523630, -0.001942082259055, -0.001737051179658, -0.001504330449257, -0.001228280668404, -0.000868525589829},
    {0.010023442173431, 0.060375061453391, -0.006100072646930, -0.004313402734375, -0.005647569866600, -0.021872944039886, -0.017859184023390, 0.001262835012940, 0.001031100470341, 0.000729098134663, 0.041757438621600, 0.016805465198862, 0.014553959784630, -0.000867830491206, -0.000751563251563, -0.000613648825252, -0.005260942760943, -0.004556110078832, -0.003720048301697, -0.002630471380471, 0.005573742249200, -0.019662314484476, -0.017586508712907, -0.010386055465228, -0.009289570415333, -0.008045003969923, 0.003218001587969, 0.002878268120961, 0.002492653311655, 0.002035242906404, 0.006502699290733, 0.005816191060528, 0.005036969211681, 0.004112668139576, 0.002908095530264, -0.070559352471780, -0.012764667141782, -0.011652493554331, 0.004502951310090, 0.004110613346472, 0.003676644348772, 0.003805688458558, 0.003474102359315, 0.003107331614488, 0.002691028116129, -0.000736968401042, -0.000672757029032, -0.000601732179703, -0.000521115353897, -0.000425488904726, -0.002127444523630, -0.001942082259055, -0.001737051179658, -0.001504330449257, -0.001228280668404, -0.000868525589829},
    {0.010023442173431, -0.060375061453391, -0.006100072646930, -0.004313402734375, -0.005647569866600, 0.021872944039886, 0.017859184023390, 0.001262835012940, 0.001031100470341, 0.000729098134663, -0.041757438621600, 0.016805465198862, 0.014553959784630, 0.000867830491206, 0.000751563251563, 0.000613648825252, -0.005260942760943, -0.004556110078832, -0.003720048301697, -0.002630471380471, 0.005573742249200, 0.019662314484476, 0.017586508712907, -0.010386055465228, -0.009289570415333, -0.008045003969923, -0.003218001587969, -0.002878268120961, -0.002492653311655, -0.002035242906404, 0.006502699290733, 0.005816191060528, 0.005036969211681, 0.004112668139576, 0.002908095530264, 0.070559352471780, -0.012764667141782, -0.011652493554331, -0.004502951310090, -0.004110613346472, -0.003676644348772, 0.003805688458558, 0.003474102359315, 0.003107331614488, 0.002691028116129, 0.000736968401042, 0.000672757029032, 0.000601732179703, 0.000521115353897, 0.000425488904726, -0.002127444523630, -0.001942082259055, -0.001737051179658, -0.001504330449257, -0.001228280668404, -0.000868525589829},
    {-0.010023442173431, 0.045281296090044, -0.011328706344298, -0.008010605078124, -0.001411892466650, -0.016404708029914, -0.013394388017543, 0.014522602648807, 0.011857655408923, 0.008384628548623, 0.008948022561771, -0.014284645419033, -0.012370865816935, 0.014536160727703, 0.012588684463684, 0.010278617822976, -0.009394540644541, -0.008135910855058, -0.006642943395887, -0.004697270322270, -0.008360613373800, -0.002457789310560, -0.002198313589113, 0.008308844372183, 0.007431656332267, 0.006436003175939, -0.009654004763908, -0.008634804362882, -0.007477959934964, -0.006105728719213, 0.006502699290733, 0.005816191060528, 0.005036969211681, 0.004112668139576, 0.002908095530264, -0.035279676235890, 0.019147000712672, 0.017478740331497, -0.007880164792657, -0.007193573356327, -0.006434127610351, 0.000951422114639, 0.000868525589829, 0.000776832903622, 0.000672757029032, 0.002210905203127, 0.002018271087097, 0.001805196539109, 0.001563346061692, 0.001276466714178, -0.002127444523630, -0.001942082259055, -0.001737051179658, -0.001504330449257, -0.001228280668404, -0.000868525589829},
    {0.078755617076958, 0.067921944135065, -0.004357194747807, -0.003081001953125, 0.070594623332504, -0.032809416059829, -0.026788776035085, 0.012628350129398, 0.036088516461940, -0.007290981346629, 0.029826741872572, 0.015124918678976, 0.013098563806167, -0.032543643420231, -0.022922679172679, -0.024852777422719, 0.024801587301587, 0.016922694578520, 0.016474499621801, 0.014279701779702, 0.000000000000000, 0.024577893105595, 0.021983135891134, -0.036351194128299, -0.007431656332267, -0.034593517070670, 0.036202517864654, 0.000000000000000, 0.013086429886188, 0.033581507955671, -0.023223926038334, 0.001661768874437, -0.003597835151201, -0.014688100498485, -0.017864015400193, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.022608373405599, -0.004595805435965, 0.000000000000000, -0.033438235208407, -0.019420822590552, 0.009082219891937, 0.000000000000000, 0.033301472937102, 0.027077948086629, 0.007035057277613, -0.010211733713425, 0.000000000000000, -0.021362904849607, -0.019107562976233, -0.008123384425989, 0.001965249069446, 0.006079679128801},
    {-0.021478804657352, 0.003773441340837, 0.002178597373904, -0.021567013671873, 0.000000000000000, 0.098428248179486, -0.031253572040933, -0.085241363373434, -0.018044258230970, 0.030986670723172, 0.000000000000000, 0.045374756036928, -0.011643167827704, 0.000000000000000, 0.023674242424242, -0.001380709856818, -0.020292207792208, -0.033519952722837, -0.000797153207506, 0.003945707070707, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036351194128299, 0.024152883079867, -0.007240503572931, -0.060337529774424, 0.000000000000000, -0.039259289658563, 0.018825996884240, 0.046447852076667, -0.010801497683837, 0.025904413088645, 0.010869194368879, -0.017864015400193, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.033438235208407, -0.015536658072442, 0.003027406630646, 0.000000000000000, -0.055502454895169, 0.000000000000000, 0.016415133647764, -0.006807822475617, 0.000000000000000, 0.042725809699215, 0.006948204718630, -0.010831179234651, -0.003930498138893, 0.006079679128801},
    {0.078755617076958, 0.030187530726696, 0.061000726469297, -0.003081001953125, 0.000000000000000, 0.021872944039886, 0.017859184023390, 0.075770100776386, -0.041244018813646, -0.007290981346629, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.052069829472369, -0.012776575276575, 0.001840946475757, -0.009018759018759, 0.028638406209803, -0.029760386413575, 0.014279701779702, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.040225019849616, 0.014391340604803, -0.013709593214101, 0.004070485812809, -0.046447852076667, 0.018279457618802, -0.034539217451527, 0.036426489236243, -0.017864015400193, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.037001636596780, -0.030086608985143, 0.014070114555226, -0.003403911237808, 0.000000000000000, -0.042725809699215, 0.024318716515205, 0.000000000000000, -0.009826245347231, 0.006079679128801},
    {-0.021478804657352, 0.003773441340837, -0.019607376365131, 0.009243005859374, 0.000000000000000, -0.010936472019943, 0.102690308134494, 0.009471262597048, -0.069599281748027, -0.060150596109686, 0.000000000000000, -0.005041639559659, 0.046572671310816, 0.006508728684046, 0.021419552669553, -0.007824022521967, -0.004509379509380, -0.028963842644005, -0.026306055847714, 0.000563672438672, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.033442453495200, 0.028962014291723, 0.000000000000000, -0.043174021814409, -0.002492653311655, -0.060548476465528, 0.000000000000000, 0.029911839739857, -0.004317402181441, 0.018507006628091, 0.046114086265614, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.034957480662994, -0.012109626522582, 0.000000000000000, 0.000000000000000, -0.045129913477714, -0.028140229110452, 0.023827378664659, 0.000000000000000, 0.000000000000000, 0.031266921233836, 0.027077948086629, 0.000000000000000, -0.018239037386404},
    {-0.021478804657352, -0.015093765363348, 0.013071584243421, 0.009243005859374, 0.000000000000000, -0.010936472019943, -0.008929592011695, 0.009471262597048, 0.123732056440937, -0.060150596109686, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.006508728684046, 0.057494588744589, -0.026693723898476, 0.006764069264069, 0.012692020933890, 0.006377225660052, 0.000563672438672, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.043174021814409, 0.019941226493238, -0.014246700344830, 0.000000000000000, -0.044867759609786, 0.021587010907205, -0.061690022093637, 0.046114086265614, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.045129913477714, -0.037520305480603, 0.011913689332330, 0.000000000000000, 0.000000000000000, -0.046900381850753, 0.016246768851977, 0.020635115229186, -0.018239037386404},
    {0.078755617076958, 0.030187530726696, 0.017428778991228, 0.058539037109370, 0.000000000000000, 0.021872944039886, 0.017859184023390, -0.018942525194097, 0.010311004703411, 0.083846285486229, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.005260942760943, 0.053387447796952, 0.000000000000000, -0.004556110078832, 0.030823257356917, -0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.034897146363167, 0.028493400689660, 0.000000000000000, 0.000000000000000, -0.030221815270086, 0.016450672558303, -0.064393543884415, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.043773689727370, -0.023827378664659, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.037909127321280, -0.013756743486124, 0.030398395644007},
    {0.078755617076958, -0.067921944135065, -0.004357194747807, -0.003081001953125, 0.070594623332504, 0.032809416059829, 0.026788776035085, 0.012628350129398, 0.036088516461940, -0.007290981346629, -0.029826741872572, 0.015124918678976, 0.013098563806167, 0.032543643420231, 0.022922679172679, 0.024852777422719, 0.024801587301587, 0.016922694578520, 0.016474499621801, 0.014279701779702, 0.000000000000000, -0.024577893105595, -0.021983135891134, -0.036351194128299, -0.007431656332267, -0.034593517070670, -0.036202517864654, 0.000000000000000, -0.013086429886188, -0.033581507955671, -0.023223926038334, 0.001661768874437, -0.003597835151201, -0.014688100498485, -0.017864015400193, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.022608373405599, 0.004595805435965, 0.000000000000000, -0.033438235208407, -0.019420822590552, 0.009082219891937, 0.000000000000000, -0.033301472937102, -0.027077948086629, -0.007035057277613, 0.010211733713425, 0.000000000000000, -0.021362904849607, -0.019107562976233, -0.008123384425989, 0.001965249069446, 0.006079679128801},
    {-0.021478804657352, -0.003773441340837, 0.002178597373904, -0.021567013671873, 0.000000000000000, -0.098428248179486, 0.031253572040933, -0.085241363373434, -0.018044258230970, 0.030986670723172, 0.000000000000000, 0.045374756036928, -0.011643167827704, 0.000000000000000, -0.023674242424242, 0.001380709856818, -0.020292207792208, -0.033519952722837, -0.000797153207506, 0.003945707070707, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.036351194128299, 0.024152883079867, -0.007240503572931, 0.060337529774424, 0.000000000000000, 0.039259289658563, -0.018825996884240, 0.046447852076667, -0.010801497683837, 0.025904413088645, 0.010869194368879, -0.017864015400193, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.033438235208407, -0.015536658072442, 0.003027406630646, 0.000000000000000, 0.055502454895169, 0.000000000000000, -0.016415133647764, 0.006807822475617, 0.000000000000000, 0.042725809699215, 0.006948204718630, -0.010831179234651, -0.003930498138893, 0.006079679128801},
    {0.078755617076958, -0.030187530726696, 0.061000726469297, -0.003081001953125, 0.000000000000000, -0.021872944039886, -0.017859184023390, 0.075770100776386, -0.041244018813646, -0.007290981346629, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.052069829472369, 0.012776575276575, -0.001840946475757, -0.009018759018759, 0.028638406209803, -0.029760386413575, 0.014279701779702, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.040225019849616, -0.014391340604803, 0.013709593214101, -0.004070485812809, -0.046447852076667, 0.018279457618802, -0.034539217451527, 0.036426489236243, -0.017864015400193, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.037001636596780, 0.030086608985143, -0.014070114555226, 0.003403911237808, 0.000000000000000, -0.042725809699215, 0.024318716515205, 0.000000000000000, -0.009826245347231, 0.006079679128801},
    {-0.021478804657352, -0.003773441340837, -0.019607376365131, 0.009243005859374, 0.000000000000000, 0.010936472019943, -0.102690308134494, 0.009471262597048, -0.069599281748027, -0.060150596109686, 0.000000000000000, -0.005041639559659, 0.046572671310816, -0.006508728684046, -0.021419552669553, 0.007824022521967, -0.004509379509380, -0.028963842644005, -0.026306055847714, 0.000563672438672, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.033442453495200, 0.028962014291723, 0.000000000000000, 0.043174021814409, 0.002492653311655, 0.060548476465528, 0.000000000000000, 0.029911839739857, -0.004317402181441, 0.018507006628091, 0.046114086265614, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.034957480662994, -0.012109626522582, 0.000000000000000, 0.000000000000000, 0.045129913477714, 0.028140229110452, -0.023827378664659, 0.000000000000000, 0.000000000000000, 0.031266921233836, 0.027077948086629, 0.000000000000000, -0.018239037386404},
    {-0.021478804657352, 0.015093765363348, 0.013071584243421, 0.009243005859374, 0.000000000000000, 0.010936472019943, 0.008929592011695, 0.009471262597048, 0.123732056440937, -0.060150596109686, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.006508728684046, -0.057494588744589, 0.026693723898476, 0.006764069264069, 0.012692020933890, 0.006377225660052, 0.000563672438672, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.043174021814409, -0.019941226493238, 0.014246700344830, 0.000000000000000, -0.044867759609786, 0.021587010907205, -0.061690022093637, 0.046114086265614, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.045129913477714, 0.037520305480603, -0.011913689332329, 0.000000000000000, 0.000000000000000, -0.046900381850753, 0.016246768851977, 0.020635115229186, -0.018239037386404},
    {0.078755617076958, -0.030187530726696, 0.017428778991228, 0.058539037109369, 0.000000000000000, -0.021872944039886, -0.017859184023390, -0.018942525194097, 0.010311004703411, 0.083846285486229, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.005260942760943, -0.053387447796952, 0.000000000000000, -0.004556110078832, 0.030823257356917, -0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.034897146363167, -0.028493400689660, 0.000000000000000, 0.000000000000000, -0.030221815270086, 0.016450672558303, -0.064393543884415, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.043773689727370, 0.023827378664659, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.037909127321280, -0.013756743486124, 0.030398395644007},
    {0.078755617076958, -0.037734413408370, -0.056643531721490, -0.003081001953125, 0.042356773999502, 0.054682360099715, 0.044647960058476, 0.037885050388193, 0.005155502351706, -0.007290981346629, 0.041757438621600, -0.005041639559659, 0.029593051562081, -0.024733168999375, 0.010146103896104, 0.026693723898476, -0.020292207792208, 0.002169576228015, 0.013285886791775, 0.014279701779702, -0.055737422492001, -0.024577893105595, -0.002198313589113, -0.005193027732614, -0.013005398581467, -0.016894508336839, 0.004022501984962, -0.015830474665283, -0.026796023100289, -0.029511022142862, 0.004644785207667, -0.010801497683837, -0.019428309816484, -0.021738388737758, -0.017864015400193, 0.000000000000000, 0.000000000000000, -0.051270971639058, 0.000000000000000, -0.022608373405599, -0.036766443487722, 0.000000000000000, -0.004776890744058, -0.007768329036221, -0.009082219891937, 0.000000000000000, 0.003700163659678, 0.006017321797029, 0.007035057277613, 0.006807822475617, 0.000000000000000, 0.004272580969921, 0.006948204718630, 0.008123384425989, 0.007860996277785, 0.006079679128801},
    {-0.021478804657352, 0.000000000000000, -0.004357194747807, -0.021567013671873, -0.127070321998507, 0.000000000000000, 0.000000000000000, 0.028413787791145, 0.036088516461940, 0.030986670723172, 0.000000000000000, 0.045374756036928, -0.042206483375427, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.020292207792208, -0.006183292249844, 0.001594306415013, 0.003945707070707, 0.083606133738001, 0.000000000000000, 0.000000000000000, -0.010386055465228, 0.024152883079867, 0.043443021437585, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.004644785207667, -0.010801497683837, -0.019428309816484, -0.021738388737758, -0.017864015400193, 0.000000000000000, 0.000000000000000, 0.076906457458587, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.009553781488116, -0.015536658072442, -0.018164439783874, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.004272580969921, 0.006948204718630, 0.008123384425989, 0.007860996277785, 0.006079679128801},
    {0.078755617076958, 0.037734413408370, -0.056643531721490, -0.003081001953125, 0.042356773999502, -0.054682360099715, -0.044647960058476, 0.037885050388193, 0.005155502351706, -0.007290981346629, -0.041757438621600, -0.005041639559659, 0.029593051562081, 0.024733168999375, -0.010146103896104, -0.026693723898476, -0.020292207792208, 0.002169576228015, 0.013285886791775, 0.014279701779702, -0.055737422492001, 0.024577893105595, 0.002198313589113, -0.005193027732614, -0.013005398581467, -0.016894508336839, -0.004022501984962, 0.015830474665283, 0.026796023100289, 0.029511022142862, 0.004644785207667, -0.010801497683837, -0.019428309816484, -0.021738388737758, -0.017864015400193, 0.000000000000000, 0.000000000000000, -0.051270971639058, 0.000000000000000, 0.022608373405599, 0.036766443487722, 0.000000000000000, -0.004776890744058, -0.007768329036221, -0.009082219891937, 0.000000000000000, -0.003700163659678, -0.006017321797029, -0.007035057277613, -0.006807822475617, 0.000000000000000, 0.004272580969921, 0.006948204718630, 0.008123384425989, 0.007860996277785, 0.006079679128801},
    {-0.021478804657352, -0.018867206704185, 0.006535792121710, 0.009243005859374, 0.014118924666501, 0.000000000000000, -0.111619900146189, -0.003157087532349, -0.054132774692910, -0.060150596109686, -0.008948022561771, -0.002520819779829, -0.027652523590797, 0.000650872868405, 0.036075036075036, -0.018869701376509, 0.001127344877345, 0.037425189933265, 0.019928830187662, 0.000563672438672, 0.000000000000000, 0.000000000000000, 0.059354466906061, 0.000000000000000, 0.016721226747600, 0.003218001587969, 0.000000000000000, -0.004317402181441, 0.022433879804893, 0.046301776120698, 0.000000000000000, -0.007477959934964, 0.018708742786244, 0.043183015465546, 0.046114086265614, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.062043373385530, 0.000000000000000, 0.000000000000000, 0.017478740331497, 0.036328879567747, 0.000000000000000, 0.000000000000000, -0.004512991347771, -0.009380076370151, -0.011913689332329, 0.000000000000000, 0.000000000000000, -0.007816730308459, -0.016246768851977, -0.020635115229186, -0.018239037386404},
    {-0.021478804657352, 0.018867206704185, 0.006535792121710, 0.009243005859374, 0.014118924666501, 0.000000000000000, 0.111619900146189, -0.003157087532349, -0.054132774692910, -0.060150596109686, 0.008948022561771, -0.002520819779829, -0.027652523590797, -0.000650872868405, -0.036075036075036, 0.018869701376509, 0.001127344877345, 0.037425189933265, 0.019928830187662, 0.000563672438672, 0.000000000000000, 0.000000000000000, -0.059354466906061, 0.000000000000000, 0.016721226747600, 0.003218001587969, 0.000000000000000, 0.004317402181441, -0.022433879804893, -0.046301776120698, 0.000000000000000, -0.007477959934964, 0.018708742786244, 0.043183015465546, 0.046114086265614, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.062043373385530, 0.000000000000000, 0.000000000000000, 0.017478740331497, 0.036328879567747, 0.000000000000000, 0.000000000000000, 0.004512991347771, 0.009380076370151, 0.011913689332330, 0.000000000000000, 0.000000000000000, -0.007816730308459, -0.016246768851977, -0.020635115229186, -0.018239037386404},
    {0.078755617076958, 0.000000000000000, -0.034857557982456, 0.058539037109369, -0.028237849333002, 0.000000000000000, 0.000000000000000, 0.006314175064699, -0.020622009406823, 0.083846285486229, 0.000000000000000, 0.000000000000000, -0.006791847899494, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.001518703359611, -0.061646514713834, -0.031941438191438, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.045052022231570, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.010073938423362, -0.032901345116607, -0.064393543884415, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.056511590438718, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.012636375773760, 0.027513486972248, 0.030398395644007},
    {0.078755617076958, -0.037734413408370, -0.021785973739035, -0.052377033203120, 0.042356773999502, 0.054682360099715, 0.044647960058476, 0.000000000000000, 0.025777511758529, 0.029163925386514, 0.041757438621600, 0.028569290838066, -0.009217507863599, 0.027336660472994, -0.007891414141414, -0.024852777422719, 0.018789081289081, -0.003471321964825, -0.014348757735117, -0.015031265031265, -0.055737422492001, -0.004915578621119, -0.024181449480247, -0.019733505383934, -0.009289570415333, -0.002413501190977, -0.039420519452623, -0.015830474665283, -0.000623163327914, 0.007123350172415, -0.032513496453667, -0.014125035432710, -0.002158701090720, 0.004112668139576, 0.005400748841919, 0.000000000000000, -0.051058668567126, 0.004660997421733, -0.040526561790806, -0.014387146712654, 0.003676644348772, -0.011417065375673, -0.005645416333887, -0.001553665807244, 0.001009135543549, 0.010317557614593, 0.005718434746775, 0.002406928718811, 0.000260557676949, -0.000850977809452, 0.012764667141782, 0.007379912584410, 0.003474102359315, 0.000902598269554, -0.000491312267362, -0.000868525589829},
    {-0.021478804657352, 0.000000000000000, -0.021785973739035, 0.003081001953125, -0.127070321998507, 0.000000000000000, 0.000000000000000, 0.047356312985241, 0.025777511758529, 0.012759217356600, 0.000000000000000, -0.035291476917610, 0.050938859246204, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.002254689754690, -0.009437656591867, -0.014348757735117, -0.012964466089466, 0.083606133738001, 0.000000000000000, 0.000000000000000, 0.047775855140050, 0.009289570415333, -0.014481007145862, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.032513496453667, -0.014125035432710, -0.002158701090720, 0.004112668139576, 0.005400748841919, 0.000000000000000, 0.076588002850690, -0.006991496132599, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.022834130751345, -0.011290832667774, -0.003107331614488, 0.002018271087097, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.012764667141782, 0.007379912584410, 0.003474102359315, 0.000902598269554, -0.000491312267362, -0.000868525589829},
    {0.078755617076958, 0.037734413408370, -0.021785973739035, -0.052377033203120, 0.042356773999502, -0.054682360099715, -0.044647960058476, 0.000000000000000, 0.025777511758529, 0.029163925386514, -0.041757438621600, 0.028569290838066, -0.009217507863599, -0.027336660472994, 0.007891414141414, 0.024852777422719, 0.018789081289081, -0.003471321964825, -0.014348757735117, -0.015031265031265, -0.055737422492001, 0.004915578621119, 0.024181449480247, -0.019733505383934, -0.009289570415333, -0.002413501190977, 0.039420519452623, 0.015830474665283, 0.000623163327914, -0.007123350172415, -0.032513496453667, -0.014125035432710, -0.002158701090720, 0.004112668139576, 0.005400748841919, 0.000000000000000, -0.051058668567126, 0.004660997421733, 0.040526561790806, 0.014387146712654, -0.003676644348772, -0.011417065375673, -0.005645416333887, -0.001553665807244, 0.001009135543549, -0.010317557614593, -0.005718434746775, -0.002406928718811, -0.000260557676949, 0.000850977809452, 0.012764667141782, 0.007379912584410, 0.003474102359315, 0.000902598269554, -0.000491312267362, -0.000868525589829},
    {-0.021478804657352, -0.018867206704185, 0.010892986869517, 0.003081001953125, 0.014118924666501, -0.109364720199429, 0.022323980029238, -0.078927188308736, -0.012888755879264, 0.012759217356600, -0.008948022561771, -0.027729017578122, 0.001455395978463, -0.005857855815641, 0.038329725829726, -0.012426388711359, 0.019164862914863, 0.034821698459647, 0.007174378867558, -0.012964466089466, 0.000000000000000, 0.058986943453429, -0.006594940767340, 0.007270238825660, 0.014863312664534, -0.004022501984962, 0.050683525010516, -0.004317402181441, -0.008101123262878, 0.003561675086208, 0.065026992907334, -0.001661768874437, -0.011513072483842, -0.002056334069788, 0.005400748841919, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.060789842686209, -0.012331840039417, 0.001378741630790, 0.039959728814854, 0.003039839564401, -0.004272580969921, 0.001009135543549, -0.015476336421890, -0.003027406630646, 0.000902598269554, 0.000781673030846, -0.000425488904726, -0.031911667854454, -0.007768329036221, 0.000868525589829, 0.001805196539109, 0.000245656133681, -0.000868525589829},
    {-0.021478804657352, 0.018867206704185, 0.010892986869517, 0.003081001953125, 0.014118924666501, 0.109364720199429, -0.022323980029238, -0.078927188308736, -0.012888755879264, 0.012759217356600, 0.008948022561771, -0.027729017578122, 0.001455395978463, 0.005857855815641, -0.038329725829726, 0.012426388711359, 0.019164862914863, 0.034821698459647, 0.007174378867558, -0.012964466089466, 0.000000000000000, -0.058986943453429, 0.006594940767340, 0.007270238825660, 0.014863312664534, -0.004022501984962, -0.050683525010516, 0.004317402181441, 0.008101123262878, -0.003561675086208, 0.065026992907334, -0.001661768874437, -0.011513072483842, -0.002056334069788, 0.005400748841919, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.060789842686209, 0.012331840039417, -0.001378741630790, 0.039959728814854, 0.003039839564401, -0.004272580969921, 0.001009135543549, 0.015476336421890, 0.003027406630646, -0.000902598269554, -0.000781673030846, 0.000425488904726, -0.031911667854454, -0.007768329036221, 0.000868525589829, 0.001805196539109, 0.000245656133681, -0.000868525589829},
    {0.078755617076958, 0.000000000000000, 0.043571947478070, -0.052377033203120, -0.028237849333002, 0.000000000000000, 0.000000000000000, 0.063141750646989, -0.051555023517057, 0.029163925386514, 0.000000000000000, -0.006722186079545, 0.000970263985642, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.060125060125060, -0.012583542122489, 0.028697515470233, -0.015031265031265, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.043621432953959, 0.011147484498400, -0.001609000793985, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.065026992907334, 0.031573608614294, -0.002878268120961, -0.008225336279152, 0.005400748841919, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.053279638419806, 0.018239037386404, -0.004660997421733, 0.000672757029032, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.042548890472605, -0.003884164518110, -0.003474102359315, 0.001203464359406, 0.000982624534723, -0.000868525589829},
    {0.107394023286761, -0.188672067041848, -0.108929868695174, -0.077025048828118, -0.070594623332504, -0.054682360099715, -0.044647960058476, -0.031570875323494, -0.025777511758529, -0.018227453366572, 0.089480225617715, -0.015124918678976, -0.013098563806167, 0.058578558156415, -0.028183621933622, 0.069035492840886, 0.074404761904762, 0.009763093026069, 0.039857660375324, 0.059749278499279, 0.000000000000000, 0.073733679316786, 0.065949407673402, 0.036351194128299, 0.007431656332267, 0.034593517070670, -0.012067505954885, 0.043174021814409, 0.015579083197842, -0.025440536330054, -0.023223926038334, 0.046529528484223, 0.025184846058405, -0.014688100498485, -0.032819935270121, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.067825120216796, -0.013787416307896, 0.000000000000000, 0.033438235208407, 0.019420822590552, -0.009082219891937, 0.000000000000000, -0.011100490979034, -0.009025982695543, -0.002345019092538, 0.003403911237808, 0.000000000000000, -0.021362904849607, -0.019107562976233, -0.008123384425989, 0.001965249069446, 0.006079679128801},
    {0.107394023286761, 0.188672067041848, -0.108929868695174, -0.077025048828118, -0.070594623332504, 0.054682360099715, 0.044647960058476, -0.031570875323494, -0.025777511758529, -0.018227453366572, -0.089480225617715, -0.015124918678976, -0.013098563806167, -0.058578558156415, 0.028183621933622, -0.069035492840886, 0.074404761904762, 0.009763093026069, 0.039857660375324, 0.059749278499278, 0.000000000000000, -0.073733679316786, -0.065949407673402, 0.036351194128299, 0.007431656332267, 0.034593517070670, 0.012067505954885, -0.043174021814409, -0.015579083197842, 0.025440536330054, -0.023223926038334, 0.046529528484223, 0.025184846058405, -0.014688100498485, -0.032819935270121, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.067825120216796, 0.013787416307896, 0.000000000000000, 0.033438235208407, 0.019420822590552, -0.009082219891937, 0.000000000000000, 0.011100490979034, 0.009025982695543, 0.002345019092538, -0.003403911237808, 0.000000000000000, -0.021362904849607, -0.019107562976233, -0.008123384425989, 0.001965249069446, 0.006079679128801},
    {0.107394023286761, 0.000000000000000, 0.217859737390348, -0.077025048828118, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.094712625970483, 0.051555023517057, -0.018227453366572, 0.000000000000000, -0.090749512073855, 0.023286335655408, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.094696969696970, -0.022780550394161, -0.079715320750648, 0.059749278499278, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.072702388256598, -0.048305766159734, 0.014481007145862, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.046447852076667, -0.078103137098517, 0.043174021814409, 0.029376200996970, -0.032819935270121, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.066876470416815, 0.031073316144883, -0.006054813261291, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.042725809699215, 0.006948204718630, -0.010831179234651, -0.003930498138893, 0.006079679128801},
    {0.107394023286761, 0.000000000000000, 0.000000000000000, 0.231075146484353, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.109364720199429, 0.000000000000000, 0.010083279119317, -0.093145342621631, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.004509379509379, -0.104139658944738, 0.000000000000000, -0.092442279942280, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.066884906990401, -0.057924028583447, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.029911839739858, -0.064761032721614, 0.000000000000000, 0.083503885940436, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.069914961325988, 0.024219253045165, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.031266921233836, 0.027077948086629, 0.000000000000000, -0.018239037386404}};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[56][56] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {6.324555320336756, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 11.224972160321816, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000015, -0.000000000000011, 0.000000000000000, -0.000000000000011, 0.000000000000000, -0.000000000000015, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {4.582575694955836, 0.000000000000000, 8.366600265340768, -1.183215956619931, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.741657386773942, 0.000000000000000, 0.000000000000000, 8.694826047713677, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000016, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.499090833947026, 0.000000000000000, -3.346640106136316, -2.366431913239846, 15.491933384829672, 0.000000000000000, 0.000000000000000, 0.692820323027552, 0.565685424949241, 0.399999999999994, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 4.898979485566354, 0.000000000000000, 0.000000000000000, -0.000000000000011, 14.198591479439090, -0.828078671210823, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 4.242640687119272, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, 14.342743312012722, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000028, 0.000000000000000, 0.000000000000015, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.600000000000004, 0.000000000000000, 8.763560920082664, -1.549193338482977, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.524704719832542, -1.481312159636090, 0.261861468283188, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, -0.000000000000021, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.117691453623974, 0.000000000000000, 3.162277660168384, 4.919349550499525, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.690449676496986, -2.418972627259048, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.545584412271575, 0.000000000000000, 0.000000000000000, 7.668115805072340, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.369185117452599, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-0.000000000000011, 11.605769149479919, 0.000000000000000, 0.000000000000000, 0.000000000000000, -4.204589329360396, -3.433032811627965, 0.000000000000000, 0.000000000000000, 0.000000000000000, 19.621416870348568, 0.000000000000000, 0.000000000000000, 0.611677741841191, 0.529728463363955, 0.432521479156777, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {4.531372124791053, -0.000000000000012, 3.545621041711681, -2.507132682112028, 4.787135538781691, 0.000000000000000, 0.000000000000000, -5.566267450754892, -1.048808848170155, 0.741619848709564, 0.000000000000000, 18.803495115840260, -0.603122387046454, -0.000000000000014, 0.000000000000000, 0.000000000000000, 1.681835731744178, 0.701283781217665, 0.132137494528677, -0.093435318430227, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {4.052982440952184, 0.000000000000000, -1.585649934344195, 4.484895284651103, 4.281744192888375, 0.000000000000000, 0.000000000000000, 0.191485421551264, -3.752332607858742, -4.311612227462030, 0.000000000000000, 0.000000000000000, 18.880717186629344, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.844371341865036, 1.181873680570546, 1.044638617546671, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 2.595128874940718, 0.000000000000020, 0.000000000000000, 0.000000000000000, 10.028530728448137, -0.767649473578733, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000016, 0.000000000000000, 16.413036132965779, -1.263476110611590, 0.096714742912329, 0.000000000000021, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 2.321153829895981, 0.000000000000000, 0.000000000000000, 0.000000000000000, 3.924283374069732, 5.492852498604763, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000016, 17.304463136556532, -1.730085916627159, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000013, 2.010178182781441, 0.000000000000000, 0.000000000000018, 0.000000000000000, 0.000000000000000, 8.919280880686035, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000016, 0.000000000000011, 0.000000000000014, 0.000000000000000, 0.000000000000000, 16.855856488448826, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.966479394838269, 0.000000000000000, 8.124038404635975, -1.641303613296570, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.772850122209162, -2.403122968139581, 0.485504156227611, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000016, 0.000000000000000, 0.000000000000000, 10.276186062932116, -1.483239697419151, 0.302765035409761, -0.061167774184124, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000015, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.653299832284318, 0.000000000000000, 4.152206199905135, 2.936053160837698, 0.000000000000000, 0.000000000000000, 0.000000000000000, 2.632489316217636, 9.825913261807843, -2.822612771377415, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000018, 0.000000000000000, 0.000000000000000, 11.608186766243875, -3.094871773194651, 0.683876505540224, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000},
    {2.297825058615203, 0.000000000000012, 1.498298354528776, 5.509176018985357, 0.000000000000000, 0.000000000000000, 0.000000000000021, 0.000000000000000, 6.648039453209406, 4.136768925484880, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 12.563613642384173, -3.553526561095033, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000018, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000011},
    {1.876166303929369, 0.000000000000000, 0.000000000000000, 6.228309299857704, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 11.054152419533837, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.605769149479958, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {4.831867007225060, 0.000000000000000, -4.410870924536921, -3.118956741678630, 16.674997917707671, 0.000000000000000, 0.000000000000000, 2.130653078209243, 1.739670953500979, 1.230133128253809, 0.000000000000000, -4.366539438350079, -3.781534080237793, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.557935943461986, -0.483186700722509, -0.394520289089679, -0.278967971730987, 23.698101189757800, 0.000000000000000, 0.000000000000000, 0.490653381462656, 0.438853725736251, 0.380058475033044, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.062693389390888, 0.056074672167160, 0.048562090605640, 0.039650780942207, 0.028037336083579, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-0.000000000000012, 6.910506641398753, -0.000000000000015, 0.000000000000000, 0.000000000000011, 10.570624165019542, -2.725540575476989, 0.000000000000000, 0.000000000000011, 0.000000000000000, 4.673328578219160, -0.000000000000020, 0.000000000000000, -7.867058678114565, -2.397192235146138, 0.618094504365250, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 23.105554887659952, -0.469687194424180, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.620657462959064, 0.790669146636839, 0.240926884676763, -0.062120835029096, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-0.000000000000010, 6.308400618805594, 0.000000000000000, 0.000000000000000, 0.000000000000000, -1.523623500550102, 11.196300409382690, 0.000000000000000, 0.000000000000012, 0.000000000000000, 4.266145801540288, 0.000000000000000, 0.000000000000000, 0.132992762321607, -4.722179538289168, -6.676845970130183, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 23.153244422169607, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.721778878560594, 1.111251279552916, 1.190874392277297, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.854496446637711, 0.000000000000000, 5.981718179666505, -2.488066757640599, 1.900292375165216, 0.000000000000000, 0.000000000000000, -0.339934634239530, -2.359221466061621, 0.981306762925310, -0.000000000000011, 9.952267030562421, -0.430945803685660, 0.000000000000000, 0.000000000000000, 0.000000000000000, -6.453644227064522, 0.077089928932761, 0.535021138879225, -0.222539456105687, 0.000000000000000, 0.000000000000000, 0.000000000000000, 21.527329744441733, -1.000240471327277, 0.043311682903133, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 2.750661296150000, 0.648615649442918, -0.007747829375309, -0.053771647653666, 0.022366056877340, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.518657752744985, -0.000000000000015, 1.927248223318869, 2.725540575476998, 1.734721666221784, 0.000000000000000, 0.000000000000000, -2.017056895211065, 3.420526275297419, -4.031128874149291, 0.000000000000000, 4.088310863215476, 5.376437915207848, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.365669640132031, -6.251481940710264, -2.039810137445496, 1.808033220652806, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 22.188097897559590, -1.265215238909802, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.984563807614540, 1.471135785792902, 0.363818136386358, -0.294009452979937, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, -0.000000000000012, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.147183169877762, -0.000000000000012, -0.861891607371339, 6.094494002200431, 1.551582227085432, 0.000000000000012, 0.000000000000011, 0.069388866648869, -3.059411708155676, 1.802775637731990, 0.000000000000000, 0.000000000000000, 9.031221565378779, 0.000000000000000, -0.000000000000015, 0.000000000000000, 0.000000000000000, 0.403888506800980, -3.674619945794644, -5.496506827211931, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 21.784126058856437, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.974215733960547, 1.789748585695769, 1.807919087949294, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000016, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-0.000000000000017, 1.545236260913132, 0.000000000000000, 0.000000000000000, 0.000000000000000, 6.717780245629603, -0.609449400220043, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 14.659398322703204, -1.523449362198713, 0.138210132827972, 0.000000000000021, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 18.119501277094027, -1.473324966326413, 0.153112421864220, -0.013890640994412, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 1.410601261295114, 0.000000000000000, 0.000000000000000, 0.000000000000000, 3.634054100635987, 2.503568881188859, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 3.568570284799074, 11.263055412877963, -1.492988146450640, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 19.367359646220450, -2.650488961241525, 0.266287609379580, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 1.261680123761092, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.422048600513447, 4.478520163753076, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 8.277251288253158, 5.379092809738635, 0.000000000000000, 0.000000000000016, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 19.965481322633931, -2.619923663010045, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 1.092647038627041, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.386822546070828, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 13.437781795811279, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 18.907670401189026, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.523360247522241, 0.000000000000000, 7.371207084158682, -1.628822035855917, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.017130629706447, -2.907243280508784, 0.642416074439625, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000018, 0.000000000000000, 0.000000000000000, 13.985882094425936, -2.725229067324035, 0.659300804656278, -0.145686271816943, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.804383086393749, -1.405634038465480, 0.273895826790429, -0.066262224031040, 0.014642021234013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.303502213799590, -0.000000000000018, 4.415880433163941, 1.784285142399530, 0.000000000000000, 0.000000000000000, -0.000000000000012, 4.266145801540322, 7.837410286567859, -2.638993314558743, 0.000000000000000, 0.000000000000000, 0.000000000000018, 0.000000000000000, -0.000000000000012, 0.000000000000000, 2.234278407003035, 13.222102707209592, -4.673792179091100, 1.183635584662304, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.125885159817845, -3.111503582748132, 0.833612074594106, -0.192474367616156, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000},
    {2.060315014550836, 0.000000000000014, 2.256962018072159, 3.989782869648268, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.953939201416944, 8.011420419804306, 1.180193688704172, 0.000000000000000, 0.000000000000000, -0.000000000000020, 0.000000000000000, -0.000000000000018, 0.000000000000000, 0.000000000000000, 5.552548964214546, 9.622413743884822, -3.598308370505714, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 13.393252032273562, -4.686661925080575, 1.183560867269036, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.784285142399540, 0.000000000000000, 0.814411017927978, 5.067704870359101, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000016, 4.015100465247620, 6.586723057402738, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, -0.000000000000022, 10.015931187414409, 2.832933145007445, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.092945437739802, -4.555527902133852, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012},
    {1.456862718169369, 0.000000000000000, 0.000000000000000, 5.078164540662384, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.014275524755359, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000019, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000016, 13.878481361372332, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.553558727894405, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
    
    static const double dmats1[56][56] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.162277660168378, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.477225575051659, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.958039891549806, 5.612486080160911, -1.080123449734645, -0.763762615825969, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.291287847477919, 7.245688373094715, 4.183300132670381, -0.591607978309961, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.870828693386971, 0.000000000000000, 0.000000000000000, 4.347413023856839, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-2.645751311064590, 0.000000000000000, 9.660917830792961, 0.683130051063956, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.240370349203929, 0.000000000000000, 0.000000000000000, 7.529940238806692, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.749545416973512, 5.796550698475768, -1.673320053068156, -1.183215956619916, 7.745966692414829, -1.199999999999993, -0.979795897113271, 0.346410161513772, 0.282842712474618, 0.199999999999999, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.323790007724462, 2.449489742783157, 2.828427124746195, -1.000000000000000, 9.165151389911680, 7.099295739719539, -0.414039335605412, -2.049390153191914, -0.478091443733760, 0.169030850945705, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.012461179749816, 2.121320343559637, -0.408248290463867, 3.175426480542949, 0.000000000000000, 0.000000000000000, 7.171371656006359, 0.000000000000000, -1.380131118684710, -1.561440116717648, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000018, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.800000000000005, -5.692099788303079, 4.381780460041318, -0.774596669241500, 0.000000000000000, 10.998181667894013, 0.962140470884729, 4.762352359916267, -0.740656079818040, 0.130930734141595, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, -0.000000000000018, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.558845726811993, 2.738612787525824, 1.581138830084193, 2.459674775249772, 0.000000000000000, 0.000000000000000, 9.258200997725520, 0.000000000000000, 5.345224838248487, -1.209486313629520, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000023, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.272792206135788, 0.000000000000000, 0.000000000000000, 3.834057902536170, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.184592558726299, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.196152422706644, 0.000000000000014, -3.162277660168403, -2.236067977499792, 0.000000000000000, 0.000000000000000, 0.000000000000000, 13.747727084867519, 0.534522483824846, 0.377964473009218, 0.000000000000028, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000034, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-1.800000000000006, 0.000000000000000, 3.651483716701104, -2.840187787218813, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.344267996967361, 1.396594497510339, 0.000000000000000, 0.000000000000000, -0.000000000000020, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000000, -0.000000000000013, -0.000000000000013, -0.000000000000016, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000},
    {2.204540768504863, 0.000000000000000, 0.000000000000000, 6.640783086353601, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 8.979977728257468, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.569046515733029, 5.802884574739957, -2.010178182781470, -1.421410624438023, 8.142152225127145, -2.102294664680195, -1.716516405813982, 0.728256234341417, 0.594618725379073, 0.420458932936040, 9.810708435174284, -1.184508853698351, -1.025814758310362, 0.305838870920594, 0.264864231681978, 0.216260739578381, -0.105945692672797, -0.091751661276175, -0.074914917726438, -0.052972846336393, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.265686062395528, 3.070597894314948, 1.772810520855840, -1.253566341056013, 2.393567769390852, 6.303768714031316, -0.908295106229246, -2.783133725377440, -0.524404424085068, 0.370809924354785, 11.124297730643482, 9.401747557920125, -0.301561193523238, -2.427520781138064, -0.794200206656971, 0.114434427054263, 0.840917865872086, 0.350641890608827, 0.066068747264339, -0.046717659215112, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.026491220476093, 2.746426249302371, -0.792824967172098, 2.242447642325558, 2.140872096444185, -0.331662479035533, 6.499230723708768, 0.095742710775633, -1.876166303929375, -2.155806113731010, 0.000000000000011, 0.000000000000000, 9.440358593314677, 0.000000000000000, -1.462494064565355, -2.047065262876646, 0.000000000000000, 0.422185670932526, 0.590936840285272, 0.522319308773348, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.914854215512675, 1.297564437470367, 3.745745886321989, -1.059456926727957, -8.091735937126879, 5.014265364224073, -0.383824736789370, 1.809367161139367, -1.108006575534903, 0.313391585264002, 0.000000000000000, 12.713483120735440, 1.019462903068668, 8.206518066482886, -0.631738055305782, 0.048357371456166, -2.842821248876036, -0.227958835180090, 0.139595707137608, -0.039483628456615, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.712697677155351, 1.160576914947985, 1.340118788520979, 1.895214165917368, 2.533114025595109, 1.962141687034865, 2.746426249302385, -0.566421515598883, 3.171299868688373, -1.821988709389509, 0.000000000000000, 0.000000000000000, 11.169982923823930, 0.000000000000000, 8.652231568278273, -0.865042958313579, 0.000000000000000, -2.497684112518220, -0.998865569685863, 0.441440386136648, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.483239697419142, 1.005089091390716, -0.193429485824662, 3.556157828809276, 0.000000000000000, 0.000000000000000, 4.459640440343020, 0.000000000000000, -0.858258202906997, 2.670272859251877, 0.000000000000000, 0.000000000000000, 0.000000000000018, 0.000000000000000, 0.000000000000000, 8.427928244224415, 0.000000000000000, 0.000000000000000, -1.621955546837944, -2.293791531904478, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.483239697419128, 7.035623639735143, 4.062019202318012, -0.820651806648284, 0.000000000000011, -6.797058187186573, -2.081165538826747, 5.886425061104587, -1.201561484069796, 0.242752078113809, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.832396974191326, 0.856348838577667, 0.262202212042544, 5.138093031466092, -0.741619848709565, 0.151382517704889, -0.030583887092061, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000015, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.326649916142157, -2.696937038151815, 2.076103099952554, 1.468026580418861, 0.000000000000000, 3.039736830714135, -6.382117875081011, 1.316244658108816, 4.912956630903928, -1.411306385688700, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 13.403979508588730, 2.010178182781475, 0.000000000000000, 5.804093383121927, -1.547435886597334, 0.341938252770111, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.148912529307609, 1.297564437470340, 0.749149177264393, 2.754588009492680, 0.000000000000000, 0.000000000000000, 5.757371051840546, 0.000000000000000, 3.324019726604698, 2.068384462742443, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000013, 10.880408577637422, 0.000000000000000, 0.000000000000000, 6.281806821192088, -1.776763280547527, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.938083151964685, 0.000000000000000, 0.000000000000000, 3.114154649928852, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.527076209766919, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.802884574739979, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-3.425395354310711, 0.000000000000000, 9.380831519646886, 1.895214165917388, 0.000000000000000, 0.000000000000000, 0.000000000000000, -3.398529093593277, -2.774887385102336, -0.560611910581389, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, -0.000000000000028, 0.000000000000000, 17.798876369029632, 0.428174419288839, 0.349602949390060, 0.070630461781873, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.829708431025354, 0.000000000000000, -1.498298354528799, 4.237827706911816, 0.000000000000000, 0.000000000000000, -0.000000000000012, 3.799671038392667, -3.545621041711682, -4.074090608432062, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 16.754974385735920, 1.116765657100821, 0.987090711415302, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-1.326649916142174, 0.000000000000000, 1.730085916627129, -3.180724257574241, 0.000000000000000, 0.000000000000000, 0.000000000000020, 0.000000000000000, 7.676494735787390, -2.388364652703972, 0.000000000000011, 0.000000000000000, -0.000000000000014, 0.000000000000000, -0.000000000000011, 0.000000000000014, 0.000000000000000, -0.000000000000015, 14.507211436849923, 2.051629516620718, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000},
    {1.624807680927190, 0.000000000000000, 0.000000000000000, 5.393874076303625, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.573176812621515, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.050890913907351, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.415933503612525, 5.729889410194662, -2.205435462268448, -1.559478370839307, 8.337498958853837, -2.767799538571068, -2.259898859936615, 1.065326539104617, 0.869835476750489, 0.615066564126905, 10.333118277332019, -2.183269719175036, -1.890767040118900, 0.724780051083751, 0.627677936394708, 0.512496888990047, -0.278967971730982, -0.241593350361244, -0.197260144544829, -0.139483985865491, 11.849050594878896, -1.161097820232279, -1.038517461826477, 0.245326690731327, 0.219426862868127, 0.190029237516522, -0.081441101792791, -0.072843135908464, -0.063084006188052, -0.051507875363769, 0.031346694695443, 0.028037336083579, 0.024281045302821, 0.019825390471102, 0.014018668041788, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.185294077254035, 3.455253320699381, 0.997445717412066, -1.410601261295101, 3.232093527642510, 5.285312082509771, -1.362770287738494, -2.890872334978297, -0.393397896234718, 0.556348640264186, 2.336664289109592, 9.027848072288679, -0.732969916135153, -3.933529339057288, -1.198596117573071, 0.309047252182619, 1.640184160889456, 0.655588223176208, 0.089214257119980, -0.126168012376108, 13.099618315050250, 11.552777443829974, -0.234843597212087, -2.440969752646134, -0.907332870306508, 0.073666248316320, 0.810328731479533, 0.395334573318420, 0.120463442338379, -0.031060417514547, -0.311895674167856, -0.164844710568309, -0.065889095553072, -0.008966370206582, 0.012680362351406, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.994891434824133, 3.154200309402794, -1.092647038627026, 1.545236260913133, 2.950484221760412, -0.761811750275048, 5.598150204691354, 0.263899331455871, -1.939256116585494, -2.285435250825167, 2.133072900770151, -0.257539376818853, 9.144461354797652, 0.066496381160802, -2.361089769144595, -3.338422985065090, -0.023035022137998, 0.817905488277892, 1.156463645457697, 1.025058485140821, 0.000000000000000, 0.000000000000000, 11.576622211084802, 0.000000000000000, -1.397718788154710, -2.151928849580047, 0.000000000000000, 0.360889439280297, 0.555625639776455, 0.595437196138647, 0.000000000000000, -0.125015768949705, -0.192474367616160, -0.206265495285700, -0.166687691932936, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.927248223318852, 1.828348200660134, 2.990859089833269, -1.244033378820304, 0.950146187582614, 5.740644563113094, -0.721110255092796, -0.169967317119742, -1.179610733030818, 0.490653381462655, -10.303721010715831, 4.976133515281203, -0.215472901842825, 5.781744669956602, -1.301855818218201, 0.163532434528620, -3.226822113532247, 0.038544964466371, 0.267510569439619, -0.111269728052841, 0.000000000000000, 14.555131461166965, 1.035562925365030, 10.763664872220872, -0.500120235663640, 0.021655841451565, -3.573213839508783, -0.581087203147975, 0.130841432732447, -0.016435628072266, 1.375330648075003, 0.324307824721448, -0.003873914687652, -0.026885823826835, 0.011183028438670, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000018, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.759328876372490, 1.669045920792550, 0.963624111659431, 1.362770287738498, 0.867360833110890, 2.284306362017928, 2.962262648719729, -1.008528447605531, 1.710263137648720, -2.015564437074640, 2.418677324489551, 2.044155431607734, 2.688218957603929, -0.527798662911748, 7.079770532556161, -1.766527397924827, 0.182834820066017, -3.125740970355135, -1.019905068722746, 0.904016610326398, 0.000000000000000, 0.000000000000000, 13.126655739718753, 0.000000000000000, 11.094048948779793, -0.632607619454902, 0.000000000000000, -2.864471121375600, -1.666053566886274, 0.315075748468088, 0.000000000000000, 0.992281903807266, 0.735567892896453, 0.181909068193179, -0.147004726489972, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.573591584938887, 1.492840054584336, -0.430945803685669, 3.047247001100221, 0.775791113542715, -0.120185042515456, 5.299056519796713, 0.034694433324434, -1.529705854077843, 0.901387818865999, 0.000000000000000, 0.000000000000000, 4.515610782689394, 0.000000000000000, -0.699555414372439, 6.364628444622274, 0.000000000000000, 0.201944253400491, -1.837309972897322, -2.748253413605958, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.892063029428213, 0.000000000000000, 0.000000000000000, -1.687391148752677, -3.099935483199605, 0.000000000000000, 0.000000000000000, 0.487107866980272, 0.894874292847881, 0.903959543974654, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.628822035855900, 0.772618130456552, 3.865951141865679, -1.051400103134264, 9.154429060764604, 3.358890122814803, -0.304724700110021, 3.878512233171016, -1.524751692856167, 0.414677792940099, -0.000000000000014, -9.462600928208417, -2.076029373391346, 7.329699161351597, -0.761724681099359, 0.069105066413987, 0.564240504518065, -0.879563899362196, 0.345781182036183, -0.094040084086342, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.374522893812816, 0.951027176355638, 0.208648802584721, 9.059750638547008, -0.736662483163205, 0.076556210932107, -0.006945320497205, -3.487099646637329, -0.056708304394161, 0.088399497979588, -0.034752316375143, 0.009451384065692, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.486904285332951, 0.705300630647550, 2.036027544819891, 1.151751106899782, -2.932214793954144, 1.817027050317993, 1.251784440594413, 0.655663160391206, 3.613590418722872, -1.703462859673124, 0.000000000000000, 2.764202656559508, -9.087838758643279, 1.784285142399538, 5.631527706438987, -0.746494073225335, -0.618094504365250, 2.032102523288362, -2.154942770625517, 0.764033484562604, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 15.001892273964266, 2.138604084623959, 0.000000000000000, 9.683679823110223, -1.325244480620758, 0.133143804689787, 0.000000000000000, -3.354525091571303, -0.478206411017785, 0.384353057392910, -0.124241670058197, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.329927623216077, 0.630840061880562, 0.728431359084682, 2.575393768188560, 0.917928424547684, 0.711024300256717, 2.239260081876555, -0.205255035576794, 2.585674822114009, 0.761811750275056, 0.000000000000011, 0.000000000000000, 5.342942731963067, 0.000000000000000, 4.138625644126570, 2.689546404869326, 0.000000000000000, -1.194718314855791, 3.105620681698605, -2.322698065581250, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.887662776929401, 0.000000000000000, 0.000000000000000, 9.982740661316964, -1.309961831505025, 0.000000000000000, 0.000000000000000, -2.881769004030789, -1.512613632095121, 0.763985254692617, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.151751106899792, 0.546323519313526, -0.105140010313421, 3.271189427732512, 0.000000000000000, 0.000000000000000, 2.693411273035412, 0.000000000000000, -0.518347241175126, 4.251711451233534, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 6.718890897905646, 0.000000000000000, 0.000000000000000, -1.293051156187174, 1.828650481922148, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.453835200594515, 0.000000000000000, 0.000000000000000, 0.000000000000000, -1.819391432645867, -2.940580616357939, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.261680123761113, -6.782630878402055, 3.685603542079335, -0.814411017927961, -0.000000000000012, 10.021690761258087, 2.675105694396104, 6.008565314853227, -1.453621640254394, 0.321208037219808, 0.000000000000000, -0.000000000000018, 0.000000000000000, -7.570080742566716, -2.272705840344215, -0.606656948415857, 6.992941047212960, -1.362614533662020, 0.329650402328135, -0.072843135908473, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 18.713740450071789, 0.760821741084515, 0.228415531250640, 0.060971317404771, 5.402191543196873, -0.702817019232739, 0.136947913395213, -0.033131112015519, 0.007321010617006, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.151751106899791, 3.824264635194591, 2.207940216581973, 0.892142571199766, 0.000000000000000, -2.463060426921489, 6.787396408049259, 2.133072900770164, 3.918705143283937, -1.319496657279373, 0.000000000000000, 0.000000000000000, 0.000000000000011, 3.224903099319407, -7.633784557260368, -4.047622759101923, 1.117139203501527, 6.611051353604815, -2.336896089545546, 0.591817792331162, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.502207652958319, 1.796427431084125, 0.721929233499943, 0.000000000000000, 6.062942579908916, -1.555751791374066, 0.416806037297054, -0.096237183808076, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.030157507275408, -1.465939832270308, 1.128481009036082, 1.994891434824133, 0.000000000000000, 1.101514109457220, -5.203570202960923, 0.476969600708479, 4.005710209902155, 0.590096844352084, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 6.411531278355673, -6.249941060946568, 0.000000000000000, 2.776274482107285, 4.811206871942399, -1.799154185252862, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 15.465195332315286, 3.044076214551790, 0.000000000000000, 0.000000000000000, 6.696626016136778, -2.343330962540286, 0.591780433634517, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.892142571199772, 0.705300630647564, 0.407205508963990, 2.533852435179551, 0.000000000000000, 0.000000000000000, 3.477179001651160, 0.000000000000000, 2.007550232623814, 3.293361528701366, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000013, 8.674050850857721, 0.000000000000000, 0.000000000000000, 5.007965593707215, 1.416466572503726, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.204848763230672, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.046472718869898, -2.277763951066931, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.728431359084684, 0.000000000000000, 0.000000000000000, 2.539082270331192, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.007137762377679, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 6.939240680686166, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 6.276779363947202, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.099019513592791, 0.000000000000000, -4.654746681256356, -3.291402943021939, 0.000000000000000, 0.000000000000000, 0.000000000000000, 13.490737563232045, 1.835856849095382, 1.298146827283098, 0.000000000000000, -0.000000000000028, 0.000000000000000, 0.000000000000036, 0.000000000000000, 0.000000000000000, -3.532704346531165, -3.059411708155679, -0.416333199893229, -0.294392028877619, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 21.832697191750412, 0.355050145839440, 0.307482445914324, 0.041843060964055, 0.029587512153288, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000020, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-2.659855246432180, 0.000000000000000, 5.099019513592800, -2.060315014550834, 0.000000000000000, 0.000000000000000, 0.000000000000000, -1.231530213460728, 9.049861877399001, 3.047247001100220, 0.000000000000000, -0.000000000000021, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 3.869883719183330, -3.816892278630188, -5.396830345469252, -1.366744646854416, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 21.002649183549970, 0.898213715542073, 0.962572311333258, 0.222250255910575, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000018, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, -0.000000000000015, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.973808570665894, 0.000000000000000, -0.814411017927959, 5.758755534498995, 0.000000000000000, 0.000000000000011, -0.000000000000021, 1.376892636821516, -2.890872334978303, 1.703462859673126, -0.000000000000028, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 8.014414097944623, -3.472189478303665, -5.193710765846916, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 19.331494165394105, 1.691153452528779, 1.708322963300205, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-1.030157507275429, 0.000000000000000, 0.940400840863418, -2.925840771075402, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000000, 4.636238668868217, -3.802846330268975, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.565401134476957, -1.635594713866251, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.273131684307565, 2.630135260597833, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.261680123761122, 0.000000000000000, 0.000000000000000, 4.397819496810950, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 8.672617004934871, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000017, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000016, 12.019117424897264, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.871700766256412, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
    
    static const double dmats2[56][56] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.162277660168378, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.825741858350552, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.163977794943219, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.958039891549806, 5.612486080160911, -1.080123449734645, -0.763762615825969, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.291287847477919, 1.449137674618943, 4.183300132670382, -0.591607978309963, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.870828693386971, 7.099295739719534, 0.000000000000000, 4.347413023856843, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.322875655532293, 0.000000000000000, 3.864367132317186, -0.341565025531987, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.080123449734643, 0.000000000000011, 7.099295739719539, 2.509980079602224, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-3.818813079129862, 0.000000000000000, 0.000000000000000, 8.874119674649421, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.749545416973512, 5.796550698475768, -1.673320053068156, -1.183215956619916, 7.745966692414829, -1.199999999999993, -0.979795897113271, 0.346410161513772, 0.282842712474618, 0.199999999999999, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.323790007724451, 2.449489742783184, 2.828427124746184, -1.000000000000002, 1.309307341415956, 7.099295739719546, -0.414039335605414, -2.049390153191922, -0.478091443733759, 0.169030850945708, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.012461179749826, 2.121320343559628, -0.408248290463866, 3.175426480542949, 9.071147352221450, 0.000000000000000, 7.171371656006360, 0.000000000000000, -1.380131118684711, -1.561440116717652, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000018, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.800000000000004, 0.632455532033675, 4.381780460041328, -0.774596669241490, 0.000000000000000, 3.142337619398289, -0.106904496764971, 4.762352359916267, -0.740656079818047, 0.130930734141596, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.558845726811992, 0.547722557505169, 1.581138830084186, 2.459674775249763, 0.000000000000000, 9.071147352221461, 1.851640199545110, 0.000000000000000, 5.345224838248491, -1.209486313629521, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.272792206135791, -6.260990336999416, 0.000000000000000, 3.834057902536166, 0.000000000000000, 0.000000000000000, 10.583005244258356, 0.000000000000000, 0.000000000000000, 5.184592558726296, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.039230484541332, 0.000000000000000, 3.162277660168374, -0.447213595499959, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.891883036371791, -0.534522483824849, 0.075592894601843, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.900000000000004, 0.000000000000011, 1.460593486680430, 1.420093893609389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.071147352221450, 4.937707198786947, -0.698297248755179, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.734846922834951, 0.000000000000000, -6.260990336999419, 2.213594362117856, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 10.583005244258368, 2.993325909419154, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.715767664977284, 0.000000000000000, 0.000000000000000, -4.695742752749549, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.699606293110033, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.569046515733029, 5.802884574739957, -2.010178182781470, -1.421410624438023, 8.142152225127145, -2.102294664680195, -1.716516405813982, 0.728256234341417, 0.594618725379073, 0.420458932936040, 9.810708435174284, -1.184508853698351, -1.025814758310362, 0.305838870920594, 0.264864231681978, 0.216260739578381, -0.105945692672797, -0.091751661276175, -0.074914917726438, -0.052972846336393, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.265686062395531, 3.070597894314947, 1.772810520855840, -1.253566341056015, 2.393567769390843, 6.303768714031315, -0.908295106229247, -2.783133725377442, -0.524404424085080, 0.370809924354784, 1.236033081182612, 9.401747557920128, -0.301561193523228, -2.427520781138058, -0.794200206656964, 0.114434427054262, 0.840917865872091, 0.350641890608831, 0.066068747264339, -0.046717659215110, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.026491220476090, 2.746426249302356, -0.792824967172097, 2.242447642325553, 2.140872096444193, -0.331662479035531, 6.499230723708775, 0.095742710775633, -1.876166303929367, -2.155806113731009, 11.055415967851324, 0.000000000000000, 9.440358593314667, 0.000000000000000, -1.462494064565361, -2.047065262876648, 0.000000000000000, 0.422185670932519, 0.590936840285273, 0.522319308773341, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.914854215512679, 1.297564437470347, 3.745745886321984, -1.059456926727957, 0.404586796856337, 5.014265364224066, -0.383824736789367, 1.809367161139370, -1.108006575534905, 0.313391585264004, 0.000000000000000, 2.825218471274543, -0.050973145153432, 8.206518066482895, -0.631738055305789, 0.048357371456169, -2.842821248876048, -0.227958835180090, 0.139595707137604, -0.039483628456616, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.712697677155355, 1.160576914947988, 1.340118788520986, 1.895214165917372, 0.361873432227868, 1.962141687034861, 2.746426249302385, -0.566421515598884, 3.171299868688371, -1.821988709389502, 0.000000000000000, 11.055415967851346, 1.595711846260563, -0.000000000000015, 8.652231568278278, -0.865042958313580, 0.000000000000011, -2.497684112518221, -0.998865569685860, 0.441440386136652, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.483239697419128, 1.005089091390726, -0.193429485824660, 3.556157828809263, -8.461572802128119, 0.000000000000011, 4.459640440343025, 0.000000000000000, -0.858258202906995, 2.670272859251869, 0.000000000000000, 0.000000000000000, 12.437342963832743, 0.000000000000000, 0.000000000000000, 8.427928244224418, 0.000000000000000, 0.000000000000000, -1.621955546837937, -2.293791531904482, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.483239697419133, 0.335029697130244, 4.062019202317980, -0.820651806648293, 0.000000000000000, 1.699264546796639, -0.099103120896513, 5.886425061104587, -1.201561484069796, 0.242752078113808, 0.000000000000000, 0.000000000000000, 0.000000000000000, 4.944132324730443, -0.214087209644427, 0.012485819621078, 5.138093031466074, -0.741619848709586, 0.151382517704882, -0.030583887092061, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.326649916142155, 0.299659670905760, 2.076103099952564, 1.468026580418849, 0.000000000000000, 0.868496237346897, 0.709124208342337, 1.316244658108818, 4.912956630903919, -1.411306385688701, 0.000000000000000, 0.000000000000000, 0.000000000000000, 11.055415967851328, 3.829708431025340, -0.223353131420161, 0.000000000000000, 5.804093383121938, -1.547435886597324, 0.341938252770106, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.148912529307597, 0.259512887494067, 0.749149177264385, 2.754588009492688, 0.000000000000000, -8.461572802128115, 1.151474210368120, 0.000000000000000, 3.324019726604702, 2.068384462742443, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.437342963832732, 2.176081715527486, 0.000000000000000, 0.000000000000000, 6.281806821192085, -1.776763280547522, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.938083151964689, 7.628089872441247, 0.000000000000015, 3.114154649928860, 0.000000000000000, 0.000000000000000, -7.521398046336104, 0.000000000000000, 0.000000000000000, 5.527076209766916, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.214106244380272, 0.000000000000000, 0.000000000000015, 0.000000000000015, 5.802884574739979, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.856348838577677, 0.000000000000000, 2.680237577041964, -0.473803541479342, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.097793640389934, -0.792824967172095, 0.140152977645348, 0.000000000000000, -0.000000000000021, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.910611719568715, -0.642261628933262, 0.099886556968583, -0.017657615445466, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.765941686205074, 0.000000000000000, 1.498298354528796, 0.847565541382362, 0.000000000000000, 0.000000000000000, -0.000000000000011, 1.628430445025424, 3.545621041711669, -0.814818121686418, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 11.055415967851340, 7.180703308172531, -1.116765657100830, 0.197418142283055, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.663324958071070, -0.000000000000011, 0.692034366650869, 1.590362128787108, 0.000000000000000, 0.000000000000000, 0.000000000000000, -8.461572802128126, 3.070597894314951, 1.194182326351984, -0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 12.437342963832732, 5.802884574739974, -1.025814758310357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.541602560309059, 0.000000000000000, 7.628089872441274, 1.797958025434550, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, -7.521398046336110, 3.191058937540506, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000018, 0.000000000000000, 14.214106244380298, 3.350296971302466, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-5.361591803435479, 0.000000000000000, 0.000000000000000, 8.899438184514782, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -5.264978632435275, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 16.583123951776983, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.415933503612525, 5.729889410194662, -2.205435462268448, -1.559478370839307, 8.337498958853837, -2.767799538571068, -2.259898859936615, 1.065326539104617, 0.869835476750489, 0.615066564126905, 10.333118277332019, -2.183269719175036, -1.890767040118900, 0.724780051083751, 0.627677936394708, 0.512496888990047, -0.278967971730982, -0.241593350361244, -0.197260144544829, -0.139483985865491, 11.849050594878896, -1.161097820232279, -1.038517461826477, 0.245326690731327, 0.219426862868127, 0.190029237516522, -0.081441101792791, -0.072843135908464, -0.063084006188052, -0.051507875363769, 0.031346694695443, 0.028037336083579, 0.024281045302821, 0.019825390471102, 0.014018668041788, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.185294077254049, 3.455253320699371, 0.997445717412061, -1.410601261295100, 3.232093527642508, 5.285312082509771, -1.362770287738494, -2.890872334978294, -0.393397896234715, 0.556348640264188, 2.336664289109576, 9.027848072288679, -0.732969916135162, -3.933529339057288, -1.198596117573073, 0.309047252182621, 1.640184160889451, 0.655588223176213, 0.089214257119977, -0.126168012376106, 1.190874392277298, 11.552777443829973, -0.234843597212088, -2.440969752646136, -0.907332870306509, 0.073666248316321, 0.810328731479531, 0.395334573318418, 0.120463442338381, -0.031060417514546, -0.311895674167857, -0.164844710568313, -0.065889095553070, -0.008966370206583, 0.012680362351407, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.994891434824116, 3.154200309402801, -1.092647038627022, 1.545236260913135, 2.950484221760409, -0.761811750275051, 5.598150204691350, 0.263899331455873, -1.939256116585497, -2.285435250825172, 2.133072900770167, -0.257539376818855, 9.144461354797652, 0.066496381160802, -2.361089769144593, -3.338422985065099, -0.023035022137997, 0.817905488277890, 1.156463645457700, 1.025058485140816, 13.045375356110615, 0.000000000000000, 11.576622211084800, 0.000000000000000, -1.397718788154708, -2.151928849580054, 0.000000000000000, 0.360889439280298, 0.555625639776455, 0.595437196138646, 0.000000000000000, -0.125015768949707, -0.192474367616161, -0.206265495285701, -0.166687691932938, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000010, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.927248223318857, 1.828348200660127, 2.990859089833267, -1.244033378820300, 0.950146187582606, 5.740644563113099, -0.721110255092794, -0.169967317119750, -1.179610733030814, 0.490653381462658, 0.294392028877590, 4.976133515281213, -0.215472901842828, 5.781744669956588, -1.301855818218207, 0.163532434528623, -3.226822113532240, 0.038544964466369, 0.267510569439612, -0.111269728052837, 0.000000000000000, 2.646387538393990, -0.029587512153287, 10.763664872220867, -0.500120235663638, 0.021655841451568, -3.573213839508786, -0.581087203147978, 0.130841432732448, -0.016435628072267, 1.375330648075006, 0.324307824721451, -0.003873914687651, -0.026885823826833, 0.011183028438670, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.759328876372485, 1.669045920792547, 0.963624111659432, 1.362770287738506, 0.867360833110899, 2.284306362017920, 2.962262648719721, -1.008528447605528, 1.710263137648715, -2.015564437074645, 0.268741924943283, 2.044155431607728, 2.688218957603923, -0.527798662911746, 7.079770532556173, -1.766527397924837, 0.182834820066009, -3.125740970355118, -1.019905068722753, 0.904016610326401, 0.000000000000000, 13.045375356110622, 1.458517304413198, 0.000000000000000, 11.094048948779797, -0.632607619454903, 0.000000000000000, -2.864471121375603, -1.666053566886276, 0.315075748468093, 0.000000000000000, 0.992281903807267, 0.735567892896452, 0.181909068193181, -0.147004726489969, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.573591584938885, 1.492840054584345, -0.430945803685668, 3.047247001100219, 0.775791113542718, -0.120185042515459, 5.299056519796713, 0.034694433324432, -1.529705854077835, 0.901387818865997, -10.576283741361021, 0.000000000000000, 4.515610782689397, 0.000000000000000, -0.699555414372449, 6.364628444622277, 0.000000000000000, 0.201944253400484, -1.837309972897321, -2.748253413605962, 0.000000000000000, 0.000000000000000, 14.349912891721683, 0.000000000000000, 0.000000000000000, 10.892063029428215, 0.000000000000000, 0.000000000000000, -1.687391148752678, -3.099935483199610, 0.000000000000000, 0.000000000000000, 0.487107866980270, 0.894874292847885, 0.903959543974647, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000016, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.628822035855902, 0.772618130456564, 3.865951141865676, -1.051400103134264, 0.160604018609906, 3.358890122814801, -0.304724700110025, 3.878512233171007, -1.524751692856162, 0.414677792940095, 0.000000000000014, 1.135512111385008, -0.036421567954233, 7.329699161351600, -0.761724681099354, 0.069105066413990, 0.564240504518054, -0.879563899362191, 0.345781182036183, -0.094040084086339, 0.000000000000000, 0.000000000000000, 0.000000000000000, 4.465778971039858, -0.114123261162678, 0.003660505308504, 9.059750638547008, -0.736662483163207, 0.076556210932110, -0.006945320497206, -3.487099646637335, -0.056708304394158, 0.088399497979585, -0.034752316375138, 0.009451384065693, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.486904285332940, 0.705300630647552, 2.036027544819911, 1.151751106899777, 0.146610739697704, 1.817027050318000, 1.251784440594431, 0.655663160391205, 3.613590418722870, -1.703462859673120, -0.000000000000014, 0.614267257013243, 0.454391937932158, 1.784285142399540, 5.631527706438979, -0.746494073225325, -0.618094504365239, 2.032102523288355, -2.154942770625514, 0.764033484562599, 0.000000000000000, 0.000000000000000, 0.000000000000000, 13.045375356110615, 3.333753838658723, -0.106930204231201, 0.000000000000000, 9.683679823110227, -1.325244480620764, 0.133143804689785, 0.000000000000000, -3.354525091571304, -0.478206411017789, 0.384353057392905, -0.124241670058197, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.329927623216086, 0.630840061880549, 0.728431359084682, 2.575393768188573, 0.131132632078243, 0.711024300256733, 2.239260081876548, -0.205255035576787, 2.585674822114008, 0.761811750275056, 0.000000000000000, -10.576283741361022, 0.763277533137577, 0.000000000000000, 4.138625644126573, 2.689546404869326, 0.000000000000000, -1.194718314855774, 3.105620681698598, -2.322698065581253, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.349912891721667, 1.841094682418488, 0.000000000000000, 0.000000000000000, 9.982740661316964, -1.309961831505021, 0.000000000000000, 0.000000000000000, -2.881769004030783, -1.512613632095121, 0.763985254692621, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.151751106899789, 0.546323519313522, -0.105140010313428, 3.271189427732502, 9.652956204814330, 0.000000000000000, 2.693411273035407, 0.000000000000000, -0.518347241175128, 4.251711451233524, 0.000000000000012, 0.000000000000000, -9.915266007525965, 0.000000000000000, 0.000000000000000, 6.718890897905649, 0.000000000000000, 0.000000000000000, -1.293051156187177, 1.828650481922143, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 15.944347657468526, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.453835200594513, 0.000000000000000, 0.000000000000000, 0.000000000000000, -1.819391432645871, -2.940580616357941, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.261680123761114, 0.199489143482422, 3.685603542079349, -0.814411017927958, 0.000000000000000, 1.027865719103389, -0.078679579246948, 6.008565314853225, -1.453621640254398, 0.321208037219811, 0.000000000000000, 0.000000000000000, 0.000000000000000, 3.028032297026707, -0.233098034907103, 0.017842851423994, 6.992941047212982, -1.362614533662018, 0.329650402328145, -0.072843135908474, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 6.804996527298831, -0.304328696433804, 0.023427233974422, -0.001793274041315, 5.402191543196879, -0.702817019232743, 0.136947913395215, -0.033131112015520, 0.007321010617006, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.151751106899781, 0.182107839771167, 2.207940216581974, 0.892142571199759, 0.000000000000000, 0.615765106730369, 0.323209352764240, 2.133072900770165, 3.918705143283933, -1.319496657279373, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.074967699773151, 1.908446139315083, -0.192743940909617, 1.117139203501520, 6.611051353604800, -2.336896089545551, 0.591817792331152, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 13.045375356110615, 5.834069217652775, -0.449106857771032, 0.034377582547617, 0.000000000000000, 6.062942579908923, -1.555751791374066, 0.416806037297054, -0.096237183808078, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.030157507275415, 0.162882203585606, 1.128481009036076, 1.994891434824122, 0.000000000000000, 0.314718316987776, 0.578174466995670, 0.476969600708481, 4.005710209902158, 0.590096844352079, 0.000000000000000, 0.000000000000000, -0.000000000000014, -10.576283741361030, 1.831866079530181, 0.694437895660741, -0.000000000000014, 2.776274482107278, 4.811206871942414, -1.799154185252865, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.349912891721679, 4.418627237804368, -0.338230690505759, 0.000000000000000, 0.000000000000000, 6.696626016136778, -2.343330962540287, 0.591780433634513, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.892142571199773, 0.141060126129510, 0.407205508964002, 2.533852435179547, 0.000000000000000, 9.652956204814334, 0.695435800330234, 0.000000000000000, 2.007550232623811, 3.293361528701370, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -9.915266007525965, 1.734810170171535, 0.000000000000011, 0.000000000000000, 5.007965593707212, 1.416466572503722, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 15.944347657468533, 2.440969752646137, 0.000000000000000, 0.000000000000000, 0.000000000000000, 7.046472718869902, -2.277763951066928, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.728431359084676, -7.947082637608542, 0.000000000000000, 2.539082270331189, 0.000000000000000, 0.000000000000000, 10.220777158038700, 0.000000000000000, 0.000000000000000, 5.007137762377681, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000023, -8.498799435022210, -0.000000000000011, 0.000000000000000, 0.000000000000012, 6.939240680686179, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.937391114652090, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 6.276779363947208, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.728431359084681, 0.000000000000000, 2.327373340628169, -0.470200420431707, 0.000000000000000, 0.000000000000000, 0.000000000000000, 4.496912521077348, -0.917928424547680, 0.185449546754731, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000018, 0.000000000000000, 0.000000000000000, 7.065408693062291, -1.019803902718555, 0.208166599946616, -0.042056004125375, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.923953268977469, -0.710100291678877, 0.102494148638109, -0.020921530482030, 0.004226787450468, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.664963811608041, 0.000000000000000, 1.456862718169376, 0.515078753637713, 0.000000000000000, 0.000000000000012, -0.000000000000014, 1.847295320191124, 2.585674822113992, -0.761811750275050, -0.000000000000014, -0.000000000000011, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.719948319637037, 5.725338417945245, -1.541951527276928, 0.341686161713602, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 13.045375356110627, 9.334510748244426, -1.347320573313092, 0.275020660380934, -0.055562563977645, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.594761714133175, -0.000000000000014, 0.814411017927956, 1.151751106899809, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.590096844352083, 2.890872334978289, 0.340692571934621, 0.000000000000000, -0.000000000000025, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, -10.576283741361024, 3.434748899119137, 3.472189478303642, -1.038742153169377, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.349912891721672, 8.284926070883195, -1.691153452528773, 0.341664592660038, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.515078753637713, 0.000000000000000, 0.376160336345353, 1.462920385537704, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.652956204814336, 1.854495467547292, 1.901423165134490, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -9.915266007525963, 4.626160453790780, 0.817797356933127, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 15.944347657468533, 6.509252673723024, -1.315067630298918, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.420560041253719, 0.000000000000000, -7.947082637608577, 1.465939832270315, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 10.220777158038704, 2.890872334978290, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000018, -0.000000000000011, -0.000000000000029, 0.000000000000000, -8.498799435022264, 4.006372474965744, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000012, 0.000000000000000, 17.937391114652101, 3.623900255418807, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, 0.000000000000000},
    {6.542378855464981, 0.000000000000000, 0.000000000000000, -6.910506641398733, 0.000000000000000, -0.000000000000018, 0.000000000000012, 0.000000000000000, 0.000000000000000, 12.264932589646449, 0.000000000000000, 0.000000000000000, -0.000000000000014, 0.000000000000000, 0.000000000000025, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000014, -5.665866290014804, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 20.499875559602394, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000015, 0.000000000000011}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      derivatives[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[56][56] = \
    {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[56][56] = \
    {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 56; t++)
      {
        for (unsigned int u = 0; u < 56; u++)
        {
          dmats[t][u] = 0.000000000000000;
          if (t == u)
          {
          dmats[t][u] = 1.000000000000000;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.000000000000000;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            for (unsigned int tu = 0; tu < 56; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            for (unsigned int tu = 0; tu < 56; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 2)
        {
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            for (unsigned int tu = 0; tu < 56; tu++)
            {
              dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 56; s++)
      {
        for (unsigned int t = 0; t < 56; t++)
        {
          derivatives[r] += coefficients0[dof][s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 56; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.800000000000000*x[2][0] + 0.200000000000000*x[3][0];
      y[1] = 0.800000000000000*x[2][1] + 0.200000000000000*x[3][1];
      y[2] = 0.800000000000000*x[2][2] + 0.200000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.600000000000000*x[2][0] + 0.400000000000000*x[3][0];
      y[1] = 0.600000000000000*x[2][1] + 0.400000000000000*x[3][1];
      y[2] = 0.600000000000000*x[2][2] + 0.400000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.400000000000000*x[2][0] + 0.600000000000000*x[3][0];
      y[1] = 0.400000000000000*x[2][1] + 0.600000000000000*x[3][1];
      y[2] = 0.400000000000000*x[2][2] + 0.600000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.200000000000000*x[2][0] + 0.800000000000000*x[3][0];
      y[1] = 0.200000000000000*x[2][1] + 0.800000000000000*x[3][1];
      y[2] = 0.200000000000000*x[2][2] + 0.800000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.800000000000000*x[1][0] + 0.200000000000000*x[3][0];
      y[1] = 0.800000000000000*x[1][1] + 0.200000000000000*x[3][1];
      y[2] = 0.800000000000000*x[1][2] + 0.200000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.600000000000000*x[1][0] + 0.400000000000000*x[3][0];
      y[1] = 0.600000000000000*x[1][1] + 0.400000000000000*x[3][1];
      y[2] = 0.600000000000000*x[1][2] + 0.400000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.400000000000000*x[1][0] + 0.600000000000000*x[3][0];
      y[1] = 0.400000000000000*x[1][1] + 0.600000000000000*x[3][1];
      y[2] = 0.400000000000000*x[1][2] + 0.600000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.200000000000000*x[1][0] + 0.800000000000000*x[3][0];
      y[1] = 0.200000000000000*x[1][1] + 0.800000000000000*x[3][1];
      y[2] = 0.200000000000000*x[1][2] + 0.800000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.800000000000000*x[1][0] + 0.200000000000000*x[2][0];
      y[1] = 0.800000000000000*x[1][1] + 0.200000000000000*x[2][1];
      y[2] = 0.800000000000000*x[1][2] + 0.200000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.600000000000000*x[1][0] + 0.400000000000000*x[2][0];
      y[1] = 0.600000000000000*x[1][1] + 0.400000000000000*x[2][1];
      y[2] = 0.600000000000000*x[1][2] + 0.400000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.400000000000000*x[1][0] + 0.600000000000000*x[2][0];
      y[1] = 0.400000000000000*x[1][1] + 0.600000000000000*x[2][1];
      y[2] = 0.400000000000000*x[1][2] + 0.600000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 15:
      {
        y[0] = 0.200000000000000*x[1][0] + 0.800000000000000*x[2][0];
      y[1] = 0.200000000000000*x[1][1] + 0.800000000000000*x[2][1];
      y[2] = 0.200000000000000*x[1][2] + 0.800000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 16:
      {
        y[0] = 0.800000000000000*x[0][0] + 0.200000000000000*x[3][0];
      y[1] = 0.800000000000000*x[0][1] + 0.200000000000000*x[3][1];
      y[2] = 0.800000000000000*x[0][2] + 0.200000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 17:
      {
        y[0] = 0.600000000000000*x[0][0] + 0.400000000000000*x[3][0];
      y[1] = 0.600000000000000*x[0][1] + 0.400000000000000*x[3][1];
      y[2] = 0.600000000000000*x[0][2] + 0.400000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 18:
      {
        y[0] = 0.400000000000000*x[0][0] + 0.600000000000000*x[3][0];
      y[1] = 0.400000000000000*x[0][1] + 0.600000000000000*x[3][1];
      y[2] = 0.400000000000000*x[0][2] + 0.600000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 19:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.800000000000000*x[3][0];
      y[1] = 0.200000000000000*x[0][1] + 0.800000000000000*x[3][1];
      y[2] = 0.200000000000000*x[0][2] + 0.800000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 20:
      {
        y[0] = 0.800000000000000*x[0][0] + 0.200000000000000*x[2][0];
      y[1] = 0.800000000000000*x[0][1] + 0.200000000000000*x[2][1];
      y[2] = 0.800000000000000*x[0][2] + 0.200000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 21:
      {
        y[0] = 0.600000000000000*x[0][0] + 0.400000000000000*x[2][0];
      y[1] = 0.600000000000000*x[0][1] + 0.400000000000000*x[2][1];
      y[2] = 0.600000000000000*x[0][2] + 0.400000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 22:
      {
        y[0] = 0.400000000000000*x[0][0] + 0.600000000000000*x[2][0];
      y[1] = 0.400000000000000*x[0][1] + 0.600000000000000*x[2][1];
      y[2] = 0.400000000000000*x[0][2] + 0.600000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 23:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.800000000000000*x[2][0];
      y[1] = 0.200000000000000*x[0][1] + 0.800000000000000*x[2][1];
      y[2] = 0.200000000000000*x[0][2] + 0.800000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 24:
      {
        y[0] = 0.800000000000000*x[0][0] + 0.200000000000000*x[1][0];
      y[1] = 0.800000000000000*x[0][1] + 0.200000000000000*x[1][1];
      y[2] = 0.800000000000000*x[0][2] + 0.200000000000000*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 25:
      {
        y[0] = 0.600000000000000*x[0][0] + 0.400000000000000*x[1][0];
      y[1] = 0.600000000000000*x[0][1] + 0.400000000000000*x[1][1];
      y[2] = 0.600000000000000*x[0][2] + 0.400000000000000*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 26:
      {
        y[0] = 0.400000000000000*x[0][0] + 0.600000000000000*x[1][0];
      y[1] = 0.400000000000000*x[0][1] + 0.600000000000000*x[1][1];
      y[2] = 0.400000000000000*x[0][2] + 0.600000000000000*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 27:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.800000000000000*x[1][0];
      y[1] = 0.200000000000000*x[0][1] + 0.800000000000000*x[1][1];
      y[2] = 0.200000000000000*x[0][2] + 0.800000000000000*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 28:
      {
        y[0] = 0.600000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.200000000000000*x[3][0];
      y[1] = 0.600000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.200000000000000*x[3][1];
      y[2] = 0.600000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.200000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 29:
      {
        y[0] = 0.400000000000000*x[1][0] + 0.400000000000000*x[2][0] + 0.200000000000000*x[3][0];
      y[1] = 0.400000000000000*x[1][1] + 0.400000000000000*x[2][1] + 0.200000000000000*x[3][1];
      y[2] = 0.400000000000000*x[1][2] + 0.400000000000000*x[2][2] + 0.200000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 30:
      {
        y[0] = 0.200000000000000*x[1][0] + 0.600000000000000*x[2][0] + 0.200000000000000*x[3][0];
      y[1] = 0.200000000000000*x[1][1] + 0.600000000000000*x[2][1] + 0.200000000000000*x[3][1];
      y[2] = 0.200000000000000*x[1][2] + 0.600000000000000*x[2][2] + 0.200000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 31:
      {
        y[0] = 0.400000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.400000000000000*x[3][0];
      y[1] = 0.400000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.400000000000000*x[3][1];
      y[2] = 0.400000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.400000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 32:
      {
        y[0] = 0.200000000000000*x[1][0] + 0.400000000000000*x[2][0] + 0.400000000000000*x[3][0];
      y[1] = 0.200000000000000*x[1][1] + 0.400000000000000*x[2][1] + 0.400000000000000*x[3][1];
      y[2] = 0.200000000000000*x[1][2] + 0.400000000000000*x[2][2] + 0.400000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 33:
      {
        y[0] = 0.200000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.600000000000000*x[3][0];
      y[1] = 0.200000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.600000000000000*x[3][1];
      y[2] = 0.200000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.600000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 34:
      {
        y[0] = 0.600000000000000*x[0][0] + 0.200000000000000*x[2][0] + 0.200000000000000*x[3][0];
      y[1] = 0.600000000000000*x[0][1] + 0.200000000000000*x[2][1] + 0.200000000000000*x[3][1];
      y[2] = 0.600000000000000*x[0][2] + 0.200000000000000*x[2][2] + 0.200000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 35:
      {
        y[0] = 0.400000000000000*x[0][0] + 0.400000000000000*x[2][0] + 0.200000000000000*x[3][0];
      y[1] = 0.400000000000000*x[0][1] + 0.400000000000000*x[2][1] + 0.200000000000000*x[3][1];
      y[2] = 0.400000000000000*x[0][2] + 0.400000000000000*x[2][2] + 0.200000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 36:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.600000000000000*x[2][0] + 0.200000000000000*x[3][0];
      y[1] = 0.200000000000000*x[0][1] + 0.600000000000000*x[2][1] + 0.200000000000000*x[3][1];
      y[2] = 0.200000000000000*x[0][2] + 0.600000000000000*x[2][2] + 0.200000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 37:
      {
        y[0] = 0.400000000000000*x[0][0] + 0.200000000000000*x[2][0] + 0.400000000000000*x[3][0];
      y[1] = 0.400000000000000*x[0][1] + 0.200000000000000*x[2][1] + 0.400000000000000*x[3][1];
      y[2] = 0.400000000000000*x[0][2] + 0.200000000000000*x[2][2] + 0.400000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 38:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.400000000000000*x[2][0] + 0.400000000000000*x[3][0];
      y[1] = 0.200000000000000*x[0][1] + 0.400000000000000*x[2][1] + 0.400000000000000*x[3][1];
      y[2] = 0.200000000000000*x[0][2] + 0.400000000000000*x[2][2] + 0.400000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 39:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[2][0] + 0.600000000000000*x[3][0];
      y[1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[2][1] + 0.600000000000000*x[3][1];
      y[2] = 0.200000000000000*x[0][2] + 0.200000000000000*x[2][2] + 0.600000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 40:
      {
        y[0] = 0.600000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.200000000000000*x[3][0];
      y[1] = 0.600000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.200000000000000*x[3][1];
      y[2] = 0.600000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.200000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 41:
      {
        y[0] = 0.400000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.200000000000000*x[3][0];
      y[1] = 0.400000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.200000000000000*x[3][1];
      y[2] = 0.400000000000000*x[0][2] + 0.400000000000000*x[1][2] + 0.200000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 42:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.600000000000000*x[1][0] + 0.200000000000000*x[3][0];
      y[1] = 0.200000000000000*x[0][1] + 0.600000000000000*x[1][1] + 0.200000000000000*x[3][1];
      y[2] = 0.200000000000000*x[0][2] + 0.600000000000000*x[1][2] + 0.200000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 43:
      {
        y[0] = 0.400000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.400000000000000*x[3][0];
      y[1] = 0.400000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.400000000000000*x[3][1];
      y[2] = 0.400000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.400000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 44:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.400000000000000*x[3][0];
      y[1] = 0.200000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.400000000000000*x[3][1];
      y[2] = 0.200000000000000*x[0][2] + 0.400000000000000*x[1][2] + 0.400000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 45:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.600000000000000*x[3][0];
      y[1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.600000000000000*x[3][1];
      y[2] = 0.200000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.600000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 46:
      {
        y[0] = 0.600000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.200000000000000*x[2][0];
      y[1] = 0.600000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.200000000000000*x[2][1];
      y[2] = 0.600000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.200000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 47:
      {
        y[0] = 0.400000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.200000000000000*x[2][0];
      y[1] = 0.400000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.200000000000000*x[2][1];
      y[2] = 0.400000000000000*x[0][2] + 0.400000000000000*x[1][2] + 0.200000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 48:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.600000000000000*x[1][0] + 0.200000000000000*x[2][0];
      y[1] = 0.200000000000000*x[0][1] + 0.600000000000000*x[1][1] + 0.200000000000000*x[2][1];
      y[2] = 0.200000000000000*x[0][2] + 0.600000000000000*x[1][2] + 0.200000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 49:
      {
        y[0] = 0.400000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.400000000000000*x[2][0];
      y[1] = 0.400000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.400000000000000*x[2][1];
      y[2] = 0.400000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.400000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 50:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.400000000000000*x[2][0];
      y[1] = 0.200000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.400000000000000*x[2][1];
      y[2] = 0.200000000000000*x[0][2] + 0.400000000000000*x[1][2] + 0.400000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 51:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.600000000000000*x[2][0];
      y[1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.600000000000000*x[2][1];
      y[2] = 0.200000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.600000000000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 52:
      {
        y[0] = 0.400000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.200000000000000*x[3][0];
      y[1] = 0.400000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.200000000000000*x[3][1];
      y[2] = 0.400000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.200000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 53:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.200000000000000*x[3][0];
      y[1] = 0.200000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.200000000000000*x[3][1];
      y[2] = 0.200000000000000*x[0][2] + 0.400000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.200000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 54:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.400000000000000*x[2][0] + 0.200000000000000*x[3][0];
      y[1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.400000000000000*x[2][1] + 0.200000000000000*x[3][1];
      y[2] = 0.200000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.400000000000000*x[2][2] + 0.200000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 55:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.400000000000000*x[3][0];
      y[1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.400000000000000*x[3][1];
      y[2] = 0.200000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.400000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.000000000000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.800000000000000*x[2][0] + 0.200000000000000*x[3][0];
    y[1] = 0.800000000000000*x[2][1] + 0.200000000000000*x[3][1];
    y[2] = 0.800000000000000*x[2][2] + 0.200000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.600000000000000*x[2][0] + 0.400000000000000*x[3][0];
    y[1] = 0.600000000000000*x[2][1] + 0.400000000000000*x[3][1];
    y[2] = 0.600000000000000*x[2][2] + 0.400000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.400000000000000*x[2][0] + 0.600000000000000*x[3][0];
    y[1] = 0.400000000000000*x[2][1] + 0.600000000000000*x[3][1];
    y[2] = 0.400000000000000*x[2][2] + 0.600000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.200000000000000*x[2][0] + 0.800000000000000*x[3][0];
    y[1] = 0.200000000000000*x[2][1] + 0.800000000000000*x[3][1];
    y[2] = 0.200000000000000*x[2][2] + 0.800000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.800000000000000*x[1][0] + 0.200000000000000*x[3][0];
    y[1] = 0.800000000000000*x[1][1] + 0.200000000000000*x[3][1];
    y[2] = 0.800000000000000*x[1][2] + 0.200000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.600000000000000*x[1][0] + 0.400000000000000*x[3][0];
    y[1] = 0.600000000000000*x[1][1] + 0.400000000000000*x[3][1];
    y[2] = 0.600000000000000*x[1][2] + 0.400000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.400000000000000*x[1][0] + 0.600000000000000*x[3][0];
    y[1] = 0.400000000000000*x[1][1] + 0.600000000000000*x[3][1];
    y[2] = 0.400000000000000*x[1][2] + 0.600000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.200000000000000*x[1][0] + 0.800000000000000*x[3][0];
    y[1] = 0.200000000000000*x[1][1] + 0.800000000000000*x[3][1];
    y[2] = 0.200000000000000*x[1][2] + 0.800000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.800000000000000*x[1][0] + 0.200000000000000*x[2][0];
    y[1] = 0.800000000000000*x[1][1] + 0.200000000000000*x[2][1];
    y[2] = 0.800000000000000*x[1][2] + 0.200000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.600000000000000*x[1][0] + 0.400000000000000*x[2][0];
    y[1] = 0.600000000000000*x[1][1] + 0.400000000000000*x[2][1];
    y[2] = 0.600000000000000*x[1][2] + 0.400000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.400000000000000*x[1][0] + 0.600000000000000*x[2][0];
    y[1] = 0.400000000000000*x[1][1] + 0.600000000000000*x[2][1];
    y[2] = 0.400000000000000*x[1][2] + 0.600000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
    y[0] = 0.200000000000000*x[1][0] + 0.800000000000000*x[2][0];
    y[1] = 0.200000000000000*x[1][1] + 0.800000000000000*x[2][1];
    y[2] = 0.200000000000000*x[1][2] + 0.800000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[15] = vals[0];
    y[0] = 0.800000000000000*x[0][0] + 0.200000000000000*x[3][0];
    y[1] = 0.800000000000000*x[0][1] + 0.200000000000000*x[3][1];
    y[2] = 0.800000000000000*x[0][2] + 0.200000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[16] = vals[0];
    y[0] = 0.600000000000000*x[0][0] + 0.400000000000000*x[3][0];
    y[1] = 0.600000000000000*x[0][1] + 0.400000000000000*x[3][1];
    y[2] = 0.600000000000000*x[0][2] + 0.400000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[17] = vals[0];
    y[0] = 0.400000000000000*x[0][0] + 0.600000000000000*x[3][0];
    y[1] = 0.400000000000000*x[0][1] + 0.600000000000000*x[3][1];
    y[2] = 0.400000000000000*x[0][2] + 0.600000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[18] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.800000000000000*x[3][0];
    y[1] = 0.200000000000000*x[0][1] + 0.800000000000000*x[3][1];
    y[2] = 0.200000000000000*x[0][2] + 0.800000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[19] = vals[0];
    y[0] = 0.800000000000000*x[0][0] + 0.200000000000000*x[2][0];
    y[1] = 0.800000000000000*x[0][1] + 0.200000000000000*x[2][1];
    y[2] = 0.800000000000000*x[0][2] + 0.200000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[20] = vals[0];
    y[0] = 0.600000000000000*x[0][0] + 0.400000000000000*x[2][0];
    y[1] = 0.600000000000000*x[0][1] + 0.400000000000000*x[2][1];
    y[2] = 0.600000000000000*x[0][2] + 0.400000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[21] = vals[0];
    y[0] = 0.400000000000000*x[0][0] + 0.600000000000000*x[2][0];
    y[1] = 0.400000000000000*x[0][1] + 0.600000000000000*x[2][1];
    y[2] = 0.400000000000000*x[0][2] + 0.600000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[22] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.800000000000000*x[2][0];
    y[1] = 0.200000000000000*x[0][1] + 0.800000000000000*x[2][1];
    y[2] = 0.200000000000000*x[0][2] + 0.800000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[23] = vals[0];
    y[0] = 0.800000000000000*x[0][0] + 0.200000000000000*x[1][0];
    y[1] = 0.800000000000000*x[0][1] + 0.200000000000000*x[1][1];
    y[2] = 0.800000000000000*x[0][2] + 0.200000000000000*x[1][2];
    f.evaluate(vals, y, c);
    values[24] = vals[0];
    y[0] = 0.600000000000000*x[0][0] + 0.400000000000000*x[1][0];
    y[1] = 0.600000000000000*x[0][1] + 0.400000000000000*x[1][1];
    y[2] = 0.600000000000000*x[0][2] + 0.400000000000000*x[1][2];
    f.evaluate(vals, y, c);
    values[25] = vals[0];
    y[0] = 0.400000000000000*x[0][0] + 0.600000000000000*x[1][0];
    y[1] = 0.400000000000000*x[0][1] + 0.600000000000000*x[1][1];
    y[2] = 0.400000000000000*x[0][2] + 0.600000000000000*x[1][2];
    f.evaluate(vals, y, c);
    values[26] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.800000000000000*x[1][0];
    y[1] = 0.200000000000000*x[0][1] + 0.800000000000000*x[1][1];
    y[2] = 0.200000000000000*x[0][2] + 0.800000000000000*x[1][2];
    f.evaluate(vals, y, c);
    values[27] = vals[0];
    y[0] = 0.600000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.200000000000000*x[3][0];
    y[1] = 0.600000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.200000000000000*x[3][1];
    y[2] = 0.600000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.200000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[28] = vals[0];
    y[0] = 0.400000000000000*x[1][0] + 0.400000000000000*x[2][0] + 0.200000000000000*x[3][0];
    y[1] = 0.400000000000000*x[1][1] + 0.400000000000000*x[2][1] + 0.200000000000000*x[3][1];
    y[2] = 0.400000000000000*x[1][2] + 0.400000000000000*x[2][2] + 0.200000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[29] = vals[0];
    y[0] = 0.200000000000000*x[1][0] + 0.600000000000000*x[2][0] + 0.200000000000000*x[3][0];
    y[1] = 0.200000000000000*x[1][1] + 0.600000000000000*x[2][1] + 0.200000000000000*x[3][1];
    y[2] = 0.200000000000000*x[1][2] + 0.600000000000000*x[2][2] + 0.200000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[30] = vals[0];
    y[0] = 0.400000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.400000000000000*x[3][0];
    y[1] = 0.400000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.400000000000000*x[3][1];
    y[2] = 0.400000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.400000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[31] = vals[0];
    y[0] = 0.200000000000000*x[1][0] + 0.400000000000000*x[2][0] + 0.400000000000000*x[3][0];
    y[1] = 0.200000000000000*x[1][1] + 0.400000000000000*x[2][1] + 0.400000000000000*x[3][1];
    y[2] = 0.200000000000000*x[1][2] + 0.400000000000000*x[2][2] + 0.400000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[32] = vals[0];
    y[0] = 0.200000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.600000000000000*x[3][0];
    y[1] = 0.200000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.600000000000000*x[3][1];
    y[2] = 0.200000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.600000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[33] = vals[0];
    y[0] = 0.600000000000000*x[0][0] + 0.200000000000000*x[2][0] + 0.200000000000000*x[3][0];
    y[1] = 0.600000000000000*x[0][1] + 0.200000000000000*x[2][1] + 0.200000000000000*x[3][1];
    y[2] = 0.600000000000000*x[0][2] + 0.200000000000000*x[2][2] + 0.200000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[34] = vals[0];
    y[0] = 0.400000000000000*x[0][0] + 0.400000000000000*x[2][0] + 0.200000000000000*x[3][0];
    y[1] = 0.400000000000000*x[0][1] + 0.400000000000000*x[2][1] + 0.200000000000000*x[3][1];
    y[2] = 0.400000000000000*x[0][2] + 0.400000000000000*x[2][2] + 0.200000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[35] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.600000000000000*x[2][0] + 0.200000000000000*x[3][0];
    y[1] = 0.200000000000000*x[0][1] + 0.600000000000000*x[2][1] + 0.200000000000000*x[3][1];
    y[2] = 0.200000000000000*x[0][2] + 0.600000000000000*x[2][2] + 0.200000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[36] = vals[0];
    y[0] = 0.400000000000000*x[0][0] + 0.200000000000000*x[2][0] + 0.400000000000000*x[3][0];
    y[1] = 0.400000000000000*x[0][1] + 0.200000000000000*x[2][1] + 0.400000000000000*x[3][1];
    y[2] = 0.400000000000000*x[0][2] + 0.200000000000000*x[2][2] + 0.400000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[37] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.400000000000000*x[2][0] + 0.400000000000000*x[3][0];
    y[1] = 0.200000000000000*x[0][1] + 0.400000000000000*x[2][1] + 0.400000000000000*x[3][1];
    y[2] = 0.200000000000000*x[0][2] + 0.400000000000000*x[2][2] + 0.400000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[38] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[2][0] + 0.600000000000000*x[3][0];
    y[1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[2][1] + 0.600000000000000*x[3][1];
    y[2] = 0.200000000000000*x[0][2] + 0.200000000000000*x[2][2] + 0.600000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[39] = vals[0];
    y[0] = 0.600000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.200000000000000*x[3][0];
    y[1] = 0.600000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.200000000000000*x[3][1];
    y[2] = 0.600000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.200000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[40] = vals[0];
    y[0] = 0.400000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.200000000000000*x[3][0];
    y[1] = 0.400000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.200000000000000*x[3][1];
    y[2] = 0.400000000000000*x[0][2] + 0.400000000000000*x[1][2] + 0.200000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[41] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.600000000000000*x[1][0] + 0.200000000000000*x[3][0];
    y[1] = 0.200000000000000*x[0][1] + 0.600000000000000*x[1][1] + 0.200000000000000*x[3][1];
    y[2] = 0.200000000000000*x[0][2] + 0.600000000000000*x[1][2] + 0.200000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[42] = vals[0];
    y[0] = 0.400000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.400000000000000*x[3][0];
    y[1] = 0.400000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.400000000000000*x[3][1];
    y[2] = 0.400000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.400000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[43] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.400000000000000*x[3][0];
    y[1] = 0.200000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.400000000000000*x[3][1];
    y[2] = 0.200000000000000*x[0][2] + 0.400000000000000*x[1][2] + 0.400000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[44] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.600000000000000*x[3][0];
    y[1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.600000000000000*x[3][1];
    y[2] = 0.200000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.600000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[45] = vals[0];
    y[0] = 0.600000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.200000000000000*x[2][0];
    y[1] = 0.600000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.200000000000000*x[2][1];
    y[2] = 0.600000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.200000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[46] = vals[0];
    y[0] = 0.400000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.200000000000000*x[2][0];
    y[1] = 0.400000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.200000000000000*x[2][1];
    y[2] = 0.400000000000000*x[0][2] + 0.400000000000000*x[1][2] + 0.200000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[47] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.600000000000000*x[1][0] + 0.200000000000000*x[2][0];
    y[1] = 0.200000000000000*x[0][1] + 0.600000000000000*x[1][1] + 0.200000000000000*x[2][1];
    y[2] = 0.200000000000000*x[0][2] + 0.600000000000000*x[1][2] + 0.200000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[48] = vals[0];
    y[0] = 0.400000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.400000000000000*x[2][0];
    y[1] = 0.400000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.400000000000000*x[2][1];
    y[2] = 0.400000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.400000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[49] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.400000000000000*x[2][0];
    y[1] = 0.200000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.400000000000000*x[2][1];
    y[2] = 0.200000000000000*x[0][2] + 0.400000000000000*x[1][2] + 0.400000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[50] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.600000000000000*x[2][0];
    y[1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.600000000000000*x[2][1];
    y[2] = 0.200000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.600000000000000*x[2][2];
    f.evaluate(vals, y, c);
    values[51] = vals[0];
    y[0] = 0.400000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.200000000000000*x[3][0];
    y[1] = 0.400000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.200000000000000*x[3][1];
    y[2] = 0.400000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.200000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[52] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.200000000000000*x[3][0];
    y[1] = 0.200000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.200000000000000*x[3][1];
    y[2] = 0.200000000000000*x[0][2] + 0.400000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.200000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[53] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.400000000000000*x[2][0] + 0.200000000000000*x[3][0];
    y[1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.400000000000000*x[2][1] + 0.200000000000000*x[3][1];
    y[2] = 0.200000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.400000000000000*x[2][2] + 0.200000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[54] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.400000000000000*x[3][0];
    y[1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.400000000000000*x[3][1];
    y[2] = 0.200000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.400000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[55] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class poisson3d_5_dof_map_0: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  poisson3d_5_dof_map_0() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~poisson3d_5_dof_map_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 5)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    case 3:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 4.000000000000000*m.num_entities[1] + 6.000000000000000*m.num_entities[2] + 4.000000000000000*m.num_entities[3];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 56;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 56;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 21;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 4;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    case 3:
      {
        return 4;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
    dofs[4] = offset + 4*c.entity_indices[1][0];
    dofs[5] = offset + 4*c.entity_indices[1][0] + 1;
    dofs[6] = offset + 4*c.entity_indices[1][0] + 2;
    dofs[7] = offset + 4*c.entity_indices[1][0] + 3;
    dofs[8] = offset + 4*c.entity_indices[1][1];
    dofs[9] = offset + 4*c.entity_indices[1][1] + 1;
    dofs[10] = offset + 4*c.entity_indices[1][1] + 2;
    dofs[11] = offset + 4*c.entity_indices[1][1] + 3;
    dofs[12] = offset + 4*c.entity_indices[1][2];
    dofs[13] = offset + 4*c.entity_indices[1][2] + 1;
    dofs[14] = offset + 4*c.entity_indices[1][2] + 2;
    dofs[15] = offset + 4*c.entity_indices[1][2] + 3;
    dofs[16] = offset + 4*c.entity_indices[1][3];
    dofs[17] = offset + 4*c.entity_indices[1][3] + 1;
    dofs[18] = offset + 4*c.entity_indices[1][3] + 2;
    dofs[19] = offset + 4*c.entity_indices[1][3] + 3;
    dofs[20] = offset + 4*c.entity_indices[1][4];
    dofs[21] = offset + 4*c.entity_indices[1][4] + 1;
    dofs[22] = offset + 4*c.entity_indices[1][4] + 2;
    dofs[23] = offset + 4*c.entity_indices[1][4] + 3;
    dofs[24] = offset + 4*c.entity_indices[1][5];
    dofs[25] = offset + 4*c.entity_indices[1][5] + 1;
    dofs[26] = offset + 4*c.entity_indices[1][5] + 2;
    dofs[27] = offset + 4*c.entity_indices[1][5] + 3;
    offset += 4*m.num_entities[1];
    dofs[28] = offset + 6*c.entity_indices[2][0];
    dofs[29] = offset + 6*c.entity_indices[2][0] + 1;
    dofs[30] = offset + 6*c.entity_indices[2][0] + 2;
    dofs[31] = offset + 6*c.entity_indices[2][0] + 3;
    dofs[32] = offset + 6*c.entity_indices[2][0] + 4;
    dofs[33] = offset + 6*c.entity_indices[2][0] + 5;
    dofs[34] = offset + 6*c.entity_indices[2][1];
    dofs[35] = offset + 6*c.entity_indices[2][1] + 1;
    dofs[36] = offset + 6*c.entity_indices[2][1] + 2;
    dofs[37] = offset + 6*c.entity_indices[2][1] + 3;
    dofs[38] = offset + 6*c.entity_indices[2][1] + 4;
    dofs[39] = offset + 6*c.entity_indices[2][1] + 5;
    dofs[40] = offset + 6*c.entity_indices[2][2];
    dofs[41] = offset + 6*c.entity_indices[2][2] + 1;
    dofs[42] = offset + 6*c.entity_indices[2][2] + 2;
    dofs[43] = offset + 6*c.entity_indices[2][2] + 3;
    dofs[44] = offset + 6*c.entity_indices[2][2] + 4;
    dofs[45] = offset + 6*c.entity_indices[2][2] + 5;
    dofs[46] = offset + 6*c.entity_indices[2][3];
    dofs[47] = offset + 6*c.entity_indices[2][3] + 1;
    dofs[48] = offset + 6*c.entity_indices[2][3] + 2;
    dofs[49] = offset + 6*c.entity_indices[2][3] + 3;
    dofs[50] = offset + 6*c.entity_indices[2][3] + 4;
    dofs[51] = offset + 6*c.entity_indices[2][3] + 5;
    offset += 6*m.num_entities[2];
    dofs[52] = offset + 4*c.entity_indices[3][0];
    dofs[53] = offset + 4*c.entity_indices[3][0] + 1;
    dofs[54] = offset + 4*c.entity_indices[3][0] + 2;
    dofs[55] = offset + 4*c.entity_indices[3][0] + 3;
    offset += 4*m.num_entities[3];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 7;
      dofs[7] = 8;
      dofs[8] = 9;
      dofs[9] = 10;
      dofs[10] = 11;
      dofs[11] = 12;
      dofs[12] = 13;
      dofs[13] = 14;
      dofs[14] = 15;
      dofs[15] = 28;
      dofs[16] = 29;
      dofs[17] = 30;
      dofs[18] = 31;
      dofs[19] = 32;
      dofs[20] = 33;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 7;
      dofs[7] = 16;
      dofs[8] = 17;
      dofs[9] = 18;
      dofs[10] = 19;
      dofs[11] = 20;
      dofs[12] = 21;
      dofs[13] = 22;
      dofs[14] = 23;
      dofs[15] = 34;
      dofs[16] = 35;
      dofs[17] = 36;
      dofs[18] = 37;
      dofs[19] = 38;
      dofs[20] = 39;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 8;
      dofs[4] = 9;
      dofs[5] = 10;
      dofs[6] = 11;
      dofs[7] = 16;
      dofs[8] = 17;
      dofs[9] = 18;
      dofs[10] = 19;
      dofs[11] = 24;
      dofs[12] = 25;
      dofs[13] = 26;
      dofs[14] = 27;
      dofs[15] = 40;
      dofs[16] = 41;
      dofs[17] = 42;
      dofs[18] = 43;
      dofs[19] = 44;
      dofs[20] = 45;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 12;
      dofs[4] = 13;
      dofs[5] = 14;
      dofs[6] = 15;
      dofs[7] = 20;
      dofs[8] = 21;
      dofs[9] = 22;
      dofs[10] = 23;
      dofs[11] = 24;
      dofs[12] = 25;
      dofs[13] = 26;
      dofs[14] = 27;
      dofs[15] = 46;
      dofs[16] = 47;
      dofs[17] = 48;
      dofs[18] = 49;
      dofs[19] = 50;
      dofs[20] = 51;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      throw std::runtime_error("i is larger than number of entities (5)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 4;
        dofs[1] = 5;
        dofs[2] = 6;
        dofs[3] = 7;
          break;
        }
      case 1:
        {
          dofs[0] = 8;
        dofs[1] = 9;
        dofs[2] = 10;
        dofs[3] = 11;
          break;
        }
      case 2:
        {
          dofs[0] = 12;
        dofs[1] = 13;
        dofs[2] = 14;
        dofs[3] = 15;
          break;
        }
      case 3:
        {
          dofs[0] = 16;
        dofs[1] = 17;
        dofs[2] = 18;
        dofs[3] = 19;
          break;
        }
      case 4:
        {
          dofs[0] = 20;
        dofs[1] = 21;
        dofs[2] = 22;
        dofs[3] = 23;
          break;
        }
      case 5:
        {
          dofs[0] = 24;
        dofs[1] = 25;
        dofs[2] = 26;
        dofs[3] = 27;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 28;
        dofs[1] = 29;
        dofs[2] = 30;
        dofs[3] = 31;
        dofs[4] = 32;
        dofs[5] = 33;
          break;
        }
      case 1:
        {
          dofs[0] = 34;
        dofs[1] = 35;
        dofs[2] = 36;
        dofs[3] = 37;
        dofs[4] = 38;
        dofs[5] = 39;
          break;
        }
      case 2:
        {
          dofs[0] = 40;
        dofs[1] = 41;
        dofs[2] = 42;
        dofs[3] = 43;
        dofs[4] = 44;
        dofs[5] = 45;
          break;
        }
      case 3:
        {
          dofs[0] = 46;
        dofs[1] = 47;
        dofs[2] = 48;
        dofs[3] = 49;
        dofs[4] = 50;
        dofs[5] = 51;
          break;
        }
      }
      
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 52;
      dofs[1] = 53;
      dofs[2] = 54;
      dofs[3] = 55;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[0][2] = x[0][2];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[1][2] = x[1][2];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[2][2] = x[2][2];
    coordinates[3][0] = x[3][0];
    coordinates[3][1] = x[3][1];
    coordinates[3][2] = x[3][2];
    coordinates[4][0] = 0.800000000000000*x[2][0] + 0.200000000000000*x[3][0];
    coordinates[4][1] = 0.800000000000000*x[2][1] + 0.200000000000000*x[3][1];
    coordinates[4][2] = 0.800000000000000*x[2][2] + 0.200000000000000*x[3][2];
    coordinates[5][0] = 0.600000000000000*x[2][0] + 0.400000000000000*x[3][0];
    coordinates[5][1] = 0.600000000000000*x[2][1] + 0.400000000000000*x[3][1];
    coordinates[5][2] = 0.600000000000000*x[2][2] + 0.400000000000000*x[3][2];
    coordinates[6][0] = 0.400000000000000*x[2][0] + 0.600000000000000*x[3][0];
    coordinates[6][1] = 0.400000000000000*x[2][1] + 0.600000000000000*x[3][1];
    coordinates[6][2] = 0.400000000000000*x[2][2] + 0.600000000000000*x[3][2];
    coordinates[7][0] = 0.200000000000000*x[2][0] + 0.800000000000000*x[3][0];
    coordinates[7][1] = 0.200000000000000*x[2][1] + 0.800000000000000*x[3][1];
    coordinates[7][2] = 0.200000000000000*x[2][2] + 0.800000000000000*x[3][2];
    coordinates[8][0] = 0.800000000000000*x[1][0] + 0.200000000000000*x[3][0];
    coordinates[8][1] = 0.800000000000000*x[1][1] + 0.200000000000000*x[3][1];
    coordinates[8][2] = 0.800000000000000*x[1][2] + 0.200000000000000*x[3][2];
    coordinates[9][0] = 0.600000000000000*x[1][0] + 0.400000000000000*x[3][0];
    coordinates[9][1] = 0.600000000000000*x[1][1] + 0.400000000000000*x[3][1];
    coordinates[9][2] = 0.600000000000000*x[1][2] + 0.400000000000000*x[3][2];
    coordinates[10][0] = 0.400000000000000*x[1][0] + 0.600000000000000*x[3][0];
    coordinates[10][1] = 0.400000000000000*x[1][1] + 0.600000000000000*x[3][1];
    coordinates[10][2] = 0.400000000000000*x[1][2] + 0.600000000000000*x[3][2];
    coordinates[11][0] = 0.200000000000000*x[1][0] + 0.800000000000000*x[3][0];
    coordinates[11][1] = 0.200000000000000*x[1][1] + 0.800000000000000*x[3][1];
    coordinates[11][2] = 0.200000000000000*x[1][2] + 0.800000000000000*x[3][2];
    coordinates[12][0] = 0.800000000000000*x[1][0] + 0.200000000000000*x[2][0];
    coordinates[12][1] = 0.800000000000000*x[1][1] + 0.200000000000000*x[2][1];
    coordinates[12][2] = 0.800000000000000*x[1][2] + 0.200000000000000*x[2][2];
    coordinates[13][0] = 0.600000000000000*x[1][0] + 0.400000000000000*x[2][0];
    coordinates[13][1] = 0.600000000000000*x[1][1] + 0.400000000000000*x[2][1];
    coordinates[13][2] = 0.600000000000000*x[1][2] + 0.400000000000000*x[2][2];
    coordinates[14][0] = 0.400000000000000*x[1][0] + 0.600000000000000*x[2][0];
    coordinates[14][1] = 0.400000000000000*x[1][1] + 0.600000000000000*x[2][1];
    coordinates[14][2] = 0.400000000000000*x[1][2] + 0.600000000000000*x[2][2];
    coordinates[15][0] = 0.200000000000000*x[1][0] + 0.800000000000000*x[2][0];
    coordinates[15][1] = 0.200000000000000*x[1][1] + 0.800000000000000*x[2][1];
    coordinates[15][2] = 0.200000000000000*x[1][2] + 0.800000000000000*x[2][2];
    coordinates[16][0] = 0.800000000000000*x[0][0] + 0.200000000000000*x[3][0];
    coordinates[16][1] = 0.800000000000000*x[0][1] + 0.200000000000000*x[3][1];
    coordinates[16][2] = 0.800000000000000*x[0][2] + 0.200000000000000*x[3][2];
    coordinates[17][0] = 0.600000000000000*x[0][0] + 0.400000000000000*x[3][0];
    coordinates[17][1] = 0.600000000000000*x[0][1] + 0.400000000000000*x[3][1];
    coordinates[17][2] = 0.600000000000000*x[0][2] + 0.400000000000000*x[3][2];
    coordinates[18][0] = 0.400000000000000*x[0][0] + 0.600000000000000*x[3][0];
    coordinates[18][1] = 0.400000000000000*x[0][1] + 0.600000000000000*x[3][1];
    coordinates[18][2] = 0.400000000000000*x[0][2] + 0.600000000000000*x[3][2];
    coordinates[19][0] = 0.200000000000000*x[0][0] + 0.800000000000000*x[3][0];
    coordinates[19][1] = 0.200000000000000*x[0][1] + 0.800000000000000*x[3][1];
    coordinates[19][2] = 0.200000000000000*x[0][2] + 0.800000000000000*x[3][2];
    coordinates[20][0] = 0.800000000000000*x[0][0] + 0.200000000000000*x[2][0];
    coordinates[20][1] = 0.800000000000000*x[0][1] + 0.200000000000000*x[2][1];
    coordinates[20][2] = 0.800000000000000*x[0][2] + 0.200000000000000*x[2][2];
    coordinates[21][0] = 0.600000000000000*x[0][0] + 0.400000000000000*x[2][0];
    coordinates[21][1] = 0.600000000000000*x[0][1] + 0.400000000000000*x[2][1];
    coordinates[21][2] = 0.600000000000000*x[0][2] + 0.400000000000000*x[2][2];
    coordinates[22][0] = 0.400000000000000*x[0][0] + 0.600000000000000*x[2][0];
    coordinates[22][1] = 0.400000000000000*x[0][1] + 0.600000000000000*x[2][1];
    coordinates[22][2] = 0.400000000000000*x[0][2] + 0.600000000000000*x[2][2];
    coordinates[23][0] = 0.200000000000000*x[0][0] + 0.800000000000000*x[2][0];
    coordinates[23][1] = 0.200000000000000*x[0][1] + 0.800000000000000*x[2][1];
    coordinates[23][2] = 0.200000000000000*x[0][2] + 0.800000000000000*x[2][2];
    coordinates[24][0] = 0.800000000000000*x[0][0] + 0.200000000000000*x[1][0];
    coordinates[24][1] = 0.800000000000000*x[0][1] + 0.200000000000000*x[1][1];
    coordinates[24][2] = 0.800000000000000*x[0][2] + 0.200000000000000*x[1][2];
    coordinates[25][0] = 0.600000000000000*x[0][0] + 0.400000000000000*x[1][0];
    coordinates[25][1] = 0.600000000000000*x[0][1] + 0.400000000000000*x[1][1];
    coordinates[25][2] = 0.600000000000000*x[0][2] + 0.400000000000000*x[1][2];
    coordinates[26][0] = 0.400000000000000*x[0][0] + 0.600000000000000*x[1][0];
    coordinates[26][1] = 0.400000000000000*x[0][1] + 0.600000000000000*x[1][1];
    coordinates[26][2] = 0.400000000000000*x[0][2] + 0.600000000000000*x[1][2];
    coordinates[27][0] = 0.200000000000000*x[0][0] + 0.800000000000000*x[1][0];
    coordinates[27][1] = 0.200000000000000*x[0][1] + 0.800000000000000*x[1][1];
    coordinates[27][2] = 0.200000000000000*x[0][2] + 0.800000000000000*x[1][2];
    coordinates[28][0] = 0.600000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.200000000000000*x[3][0];
    coordinates[28][1] = 0.600000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.200000000000000*x[3][1];
    coordinates[28][2] = 0.600000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.200000000000000*x[3][2];
    coordinates[29][0] = 0.400000000000000*x[1][0] + 0.400000000000000*x[2][0] + 0.200000000000000*x[3][0];
    coordinates[29][1] = 0.400000000000000*x[1][1] + 0.400000000000000*x[2][1] + 0.200000000000000*x[3][1];
    coordinates[29][2] = 0.400000000000000*x[1][2] + 0.400000000000000*x[2][2] + 0.200000000000000*x[3][2];
    coordinates[30][0] = 0.200000000000000*x[1][0] + 0.600000000000000*x[2][0] + 0.200000000000000*x[3][0];
    coordinates[30][1] = 0.200000000000000*x[1][1] + 0.600000000000000*x[2][1] + 0.200000000000000*x[3][1];
    coordinates[30][2] = 0.200000000000000*x[1][2] + 0.600000000000000*x[2][2] + 0.200000000000000*x[3][2];
    coordinates[31][0] = 0.400000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.400000000000000*x[3][0];
    coordinates[31][1] = 0.400000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.400000000000000*x[3][1];
    coordinates[31][2] = 0.400000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.400000000000000*x[3][2];
    coordinates[32][0] = 0.200000000000000*x[1][0] + 0.400000000000000*x[2][0] + 0.400000000000000*x[3][0];
    coordinates[32][1] = 0.200000000000000*x[1][1] + 0.400000000000000*x[2][1] + 0.400000000000000*x[3][1];
    coordinates[32][2] = 0.200000000000000*x[1][2] + 0.400000000000000*x[2][2] + 0.400000000000000*x[3][2];
    coordinates[33][0] = 0.200000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.600000000000000*x[3][0];
    coordinates[33][1] = 0.200000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.600000000000000*x[3][1];
    coordinates[33][2] = 0.200000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.600000000000000*x[3][2];
    coordinates[34][0] = 0.600000000000000*x[0][0] + 0.200000000000000*x[2][0] + 0.200000000000000*x[3][0];
    coordinates[34][1] = 0.600000000000000*x[0][1] + 0.200000000000000*x[2][1] + 0.200000000000000*x[3][1];
    coordinates[34][2] = 0.600000000000000*x[0][2] + 0.200000000000000*x[2][2] + 0.200000000000000*x[3][2];
    coordinates[35][0] = 0.400000000000000*x[0][0] + 0.400000000000000*x[2][0] + 0.200000000000000*x[3][0];
    coordinates[35][1] = 0.400000000000000*x[0][1] + 0.400000000000000*x[2][1] + 0.200000000000000*x[3][1];
    coordinates[35][2] = 0.400000000000000*x[0][2] + 0.400000000000000*x[2][2] + 0.200000000000000*x[3][2];
    coordinates[36][0] = 0.200000000000000*x[0][0] + 0.600000000000000*x[2][0] + 0.200000000000000*x[3][0];
    coordinates[36][1] = 0.200000000000000*x[0][1] + 0.600000000000000*x[2][1] + 0.200000000000000*x[3][1];
    coordinates[36][2] = 0.200000000000000*x[0][2] + 0.600000000000000*x[2][2] + 0.200000000000000*x[3][2];
    coordinates[37][0] = 0.400000000000000*x[0][0] + 0.200000000000000*x[2][0] + 0.400000000000000*x[3][0];
    coordinates[37][1] = 0.400000000000000*x[0][1] + 0.200000000000000*x[2][1] + 0.400000000000000*x[3][1];
    coordinates[37][2] = 0.400000000000000*x[0][2] + 0.200000000000000*x[2][2] + 0.400000000000000*x[3][2];
    coordinates[38][0] = 0.200000000000000*x[0][0] + 0.400000000000000*x[2][0] + 0.400000000000000*x[3][0];
    coordinates[38][1] = 0.200000000000000*x[0][1] + 0.400000000000000*x[2][1] + 0.400000000000000*x[3][1];
    coordinates[38][2] = 0.200000000000000*x[0][2] + 0.400000000000000*x[2][2] + 0.400000000000000*x[3][2];
    coordinates[39][0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[2][0] + 0.600000000000000*x[3][0];
    coordinates[39][1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[2][1] + 0.600000000000000*x[3][1];
    coordinates[39][2] = 0.200000000000000*x[0][2] + 0.200000000000000*x[2][2] + 0.600000000000000*x[3][2];
    coordinates[40][0] = 0.600000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.200000000000000*x[3][0];
    coordinates[40][1] = 0.600000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.200000000000000*x[3][1];
    coordinates[40][2] = 0.600000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.200000000000000*x[3][2];
    coordinates[41][0] = 0.400000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.200000000000000*x[3][0];
    coordinates[41][1] = 0.400000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.200000000000000*x[3][1];
    coordinates[41][2] = 0.400000000000000*x[0][2] + 0.400000000000000*x[1][2] + 0.200000000000000*x[3][2];
    coordinates[42][0] = 0.200000000000000*x[0][0] + 0.600000000000000*x[1][0] + 0.200000000000000*x[3][0];
    coordinates[42][1] = 0.200000000000000*x[0][1] + 0.600000000000000*x[1][1] + 0.200000000000000*x[3][1];
    coordinates[42][2] = 0.200000000000000*x[0][2] + 0.600000000000000*x[1][2] + 0.200000000000000*x[3][2];
    coordinates[43][0] = 0.400000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.400000000000000*x[3][0];
    coordinates[43][1] = 0.400000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.400000000000000*x[3][1];
    coordinates[43][2] = 0.400000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.400000000000000*x[3][2];
    coordinates[44][0] = 0.200000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.400000000000000*x[3][0];
    coordinates[44][1] = 0.200000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.400000000000000*x[3][1];
    coordinates[44][2] = 0.200000000000000*x[0][2] + 0.400000000000000*x[1][2] + 0.400000000000000*x[3][2];
    coordinates[45][0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.600000000000000*x[3][0];
    coordinates[45][1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.600000000000000*x[3][1];
    coordinates[45][2] = 0.200000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.600000000000000*x[3][2];
    coordinates[46][0] = 0.600000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.200000000000000*x[2][0];
    coordinates[46][1] = 0.600000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.200000000000000*x[2][1];
    coordinates[46][2] = 0.600000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.200000000000000*x[2][2];
    coordinates[47][0] = 0.400000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.200000000000000*x[2][0];
    coordinates[47][1] = 0.400000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.200000000000000*x[2][1];
    coordinates[47][2] = 0.400000000000000*x[0][2] + 0.400000000000000*x[1][2] + 0.200000000000000*x[2][2];
    coordinates[48][0] = 0.200000000000000*x[0][0] + 0.600000000000000*x[1][0] + 0.200000000000000*x[2][0];
    coordinates[48][1] = 0.200000000000000*x[0][1] + 0.600000000000000*x[1][1] + 0.200000000000000*x[2][1];
    coordinates[48][2] = 0.200000000000000*x[0][2] + 0.600000000000000*x[1][2] + 0.200000000000000*x[2][2];
    coordinates[49][0] = 0.400000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.400000000000000*x[2][0];
    coordinates[49][1] = 0.400000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.400000000000000*x[2][1];
    coordinates[49][2] = 0.400000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.400000000000000*x[2][2];
    coordinates[50][0] = 0.200000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.400000000000000*x[2][0];
    coordinates[50][1] = 0.200000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.400000000000000*x[2][1];
    coordinates[50][2] = 0.200000000000000*x[0][2] + 0.400000000000000*x[1][2] + 0.400000000000000*x[2][2];
    coordinates[51][0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.600000000000000*x[2][0];
    coordinates[51][1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.600000000000000*x[2][1];
    coordinates[51][2] = 0.200000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.600000000000000*x[2][2];
    coordinates[52][0] = 0.400000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.200000000000000*x[3][0];
    coordinates[52][1] = 0.400000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.200000000000000*x[3][1];
    coordinates[52][2] = 0.400000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.200000000000000*x[3][2];
    coordinates[53][0] = 0.200000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.200000000000000*x[3][0];
    coordinates[53][1] = 0.200000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.200000000000000*x[3][1];
    coordinates[53][2] = 0.200000000000000*x[0][2] + 0.400000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.200000000000000*x[3][2];
    coordinates[54][0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.400000000000000*x[2][0] + 0.200000000000000*x[3][0];
    coordinates[54][1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.400000000000000*x[2][1] + 0.200000000000000*x[3][1];
    coordinates[54][2] = 0.200000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.400000000000000*x[2][2] + 0.200000000000000*x[3][2];
    coordinates[55][0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.200000000000000*x[2][0] + 0.400000000000000*x[3][0];
    coordinates[55][1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.200000000000000*x[2][1] + 0.400000000000000*x[3][1];
    coordinates[55][2] = 0.200000000000000*x[0][2] + 0.200000000000000*x[1][2] + 0.200000000000000*x[2][2] + 0.400000000000000*x[3][2];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 0;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class poisson3d_5_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  poisson3d_5_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_5_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      32
    // Number of operations (multiply-add pairs) for geometry tensor:    27
    // Number of operations (multiply-add pairs) for tensor contraction: 18292
    // Total number of operations (multiply-add pairs):                  18351
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K_00*K_00 + K_01*K_01 + K_02*K_02);
    const double G0_0_1 = det*(K_00*K_10 + K_01*K_11 + K_02*K_12);
    const double G0_0_2 = det*(K_00*K_20 + K_01*K_21 + K_02*K_22);
    const double G0_1_0 = det*(K_10*K_00 + K_11*K_01 + K_12*K_02);
    const double G0_1_1 = det*(K_10*K_10 + K_11*K_11 + K_12*K_12);
    const double G0_1_2 = det*(K_10*K_20 + K_11*K_21 + K_12*K_22);
    const double G0_2_0 = det*(K_20*K_00 + K_21*K_01 + K_22*K_02);
    const double G0_2_1 = det*(K_20*K_10 + K_21*K_11 + K_22*K_12);
    const double G0_2_2 = det*(K_20*K_20 + K_21*K_21 + K_22*K_22);
    
    // Compute element tensor
    A[0] = 0.026265256734006*G0_0_0 + 0.026265256734006*G0_0_1 + 0.026265256734006*G0_0_2 + 0.026265256734006*G0_1_0 + 0.026265256734006*G0_1_1 + 0.026265256734006*G0_1_2 + 0.026265256734006*G0_2_0 + 0.026265256734006*G0_2_1 + 0.026265256734006*G0_2_2;
    A[1] = -0.002778905122655*G0_0_0 - 0.002778905122655*G0_1_0 - 0.002778905122655*G0_2_0;
    A[2] = -0.002778905122655*G0_0_1 - 0.002778905122655*G0_1_1 - 0.002778905122655*G0_2_1;
    A[3] = -0.002778905122655*G0_0_2 - 0.002778905122655*G0_1_2 - 0.002778905122655*G0_2_2;
    A[4] = -0.004800349309898*G0_0_1 - 0.004800349309898*G0_0_2 - 0.004800349309898*G0_1_1 - 0.004800349309898*G0_1_2 - 0.004800349309898*G0_2_1 - 0.004800349309898*G0_2_2;
    A[5] = -0.003365072266982*G0_0_1 - 0.003365072266982*G0_0_2 - 0.003365072266982*G0_1_1 - 0.003365072266982*G0_1_2 - 0.003365072266982*G0_2_1 - 0.003365072266982*G0_2_2;
    A[6] = -0.003365072266982*G0_0_1 - 0.003365072266982*G0_0_2 - 0.003365072266982*G0_1_1 - 0.003365072266982*G0_1_2 - 0.003365072266982*G0_2_1 - 0.003365072266982*G0_2_2;
    A[7] = -0.004800349309898*G0_0_1 - 0.004800349309898*G0_0_2 - 0.004800349309898*G0_1_1 - 0.004800349309898*G0_1_2 - 0.004800349309898*G0_2_1 - 0.004800349309898*G0_2_2;
    A[8] = -0.004800349309898*G0_0_0 - 0.004800349309898*G0_0_2 - 0.004800349309898*G0_1_0 - 0.004800349309898*G0_1_2 - 0.004800349309898*G0_2_0 - 0.004800349309898*G0_2_2;
    A[9] = -0.003365072266982*G0_0_0 - 0.003365072266982*G0_0_2 - 0.003365072266982*G0_1_0 - 0.003365072266982*G0_1_2 - 0.003365072266982*G0_2_0 - 0.003365072266982*G0_2_2;
    A[10] = -0.003365072266982*G0_0_0 - 0.003365072266982*G0_0_2 - 0.003365072266982*G0_1_0 - 0.003365072266982*G0_1_2 - 0.003365072266982*G0_2_0 - 0.003365072266982*G0_2_2;
    A[11] = -0.004800349309898*G0_0_0 - 0.004800349309898*G0_0_2 - 0.004800349309898*G0_1_0 - 0.004800349309898*G0_1_2 - 0.004800349309898*G0_2_0 - 0.004800349309898*G0_2_2;
    A[12] = -0.004800349309898*G0_0_0 - 0.004800349309898*G0_0_1 - 0.004800349309898*G0_1_0 - 0.004800349309898*G0_1_1 - 0.004800349309898*G0_2_0 - 0.004800349309898*G0_2_1;
    A[13] = -0.003365072266982*G0_0_0 - 0.003365072266982*G0_0_1 - 0.003365072266982*G0_1_0 - 0.003365072266982*G0_1_1 - 0.003365072266982*G0_2_0 - 0.003365072266982*G0_2_1;
    A[14] = -0.003365072266982*G0_0_0 - 0.003365072266982*G0_0_1 - 0.003365072266982*G0_1_0 - 0.003365072266982*G0_1_1 - 0.003365072266982*G0_2_0 - 0.003365072266982*G0_2_1;
    A[15] = -0.004800349309898*G0_0_0 - 0.004800349309898*G0_0_1 - 0.004800349309898*G0_1_0 - 0.004800349309898*G0_1_1 - 0.004800349309898*G0_2_0 - 0.004800349309898*G0_2_1;
    A[16] = -0.017870503981615*G0_0_0 - 0.017870503981615*G0_0_1 - 0.055127686421089*G0_0_2 - 0.017870503981615*G0_1_0 - 0.017870503981615*G0_1_1 - 0.055127686421089*G0_1_2 - 0.017870503981615*G0_2_0 - 0.017870503981615*G0_2_1 - 0.055127686421089*G0_2_2;
    A[17] = 0.021469134967399*G0_0_0 + 0.021469134967399*G0_0_1 + 0.055127686421089*G0_0_2 + 0.021469134967399*G0_1_0 + 0.021469134967399*G0_1_1 + 0.055127686421089*G0_1_2 + 0.021469134967399*G0_2_0 + 0.021469134967399*G0_2_1 + 0.055127686421089*G0_2_2;
    A[18] = -0.015554488753273*G0_0_0 - 0.015554488753273*G0_0_1 - 0.038817720024317*G0_0_2 - 0.015554488753273*G0_1_0 - 0.015554488753273*G0_1_1 - 0.038817720024317*G0_1_2 - 0.015554488753273*G0_2_0 - 0.015554488753273*G0_2_1 - 0.038817720024317*G0_2_2;
    A[19] = 0.004800349309898*G0_0_0 + 0.004800349309898*G0_0_1 + 0.015331368412966*G0_0_2 + 0.004800349309898*G0_1_0 + 0.004800349309898*G0_1_1 + 0.015331368412966*G0_1_2 + 0.004800349309898*G0_2_0 + 0.004800349309898*G0_2_1 + 0.015331368412966*G0_2_2;
    A[20] = -0.017870503981615*G0_0_0 - 0.055127686421089*G0_0_1 - 0.017870503981615*G0_0_2 - 0.017870503981615*G0_1_0 - 0.055127686421089*G0_1_1 - 0.017870503981615*G0_1_2 - 0.017870503981615*G0_2_0 - 0.055127686421089*G0_2_1 - 0.017870503981615*G0_2_2;
    A[21] = 0.021469134967399*G0_0_0 + 0.055127686421089*G0_0_1 + 0.021469134967398*G0_0_2 + 0.021469134967399*G0_1_0 + 0.055127686421089*G0_1_1 + 0.021469134967398*G0_1_2 + 0.021469134967399*G0_2_0 + 0.055127686421089*G0_2_1 + 0.021469134967399*G0_2_2;
    A[22] = -0.015554488753273*G0_0_0 - 0.038817720024317*G0_0_1 - 0.015554488753273*G0_0_2 - 0.015554488753273*G0_1_0 - 0.038817720024317*G0_1_1 - 0.015554488753273*G0_1_2 - 0.015554488753273*G0_2_0 - 0.038817720024317*G0_2_1 - 0.015554488753273*G0_2_2;
    A[23] = 0.004800349309898*G0_0_0 + 0.015331368412965*G0_0_1 + 0.004800349309898*G0_0_2 + 0.004800349309898*G0_1_0 + 0.015331368412965*G0_1_1 + 0.004800349309898*G0_1_2 + 0.004800349309898*G0_2_0 + 0.015331368412965*G0_2_1 + 0.004800349309898*G0_2_2;
    A[24] = -0.055127686421089*G0_0_0 - 0.017870503981615*G0_0_1 - 0.017870503981615*G0_0_2 - 0.055127686421089*G0_1_0 - 0.017870503981615*G0_1_1 - 0.017870503981615*G0_1_2 - 0.055127686421089*G0_2_0 - 0.017870503981615*G0_2_1 - 0.017870503981615*G0_2_2;
    A[25] = 0.055127686421088*G0_0_0 + 0.021469134967399*G0_0_1 + 0.021469134967399*G0_0_2 + 0.055127686421088*G0_1_0 + 0.021469134967399*G0_1_1 + 0.021469134967399*G0_1_2 + 0.055127686421088*G0_2_0 + 0.021469134967399*G0_2_1 + 0.021469134967399*G0_2_2;
    A[26] = -0.038817720024317*G0_0_0 - 0.015554488753273*G0_0_1 - 0.015554488753273*G0_0_2 - 0.038817720024317*G0_1_0 - 0.015554488753273*G0_1_1 - 0.015554488753273*G0_1_2 - 0.038817720024317*G0_2_0 - 0.015554488753273*G0_2_1 - 0.015554488753273*G0_2_2;
    A[27] = 0.015331368412965*G0_0_0 + 0.004800349309898*G0_0_1 + 0.004800349309898*G0_0_2 + 0.015331368412965*G0_1_0 + 0.004800349309898*G0_1_1 + 0.004800349309898*G0_1_2 + 0.015331368412965*G0_2_0 + 0.004800349309898*G0_2_1 + 0.004800349309898*G0_2_2;
    A[28] = -0.013742125287264*G0_0_0 - 0.013742125287264*G0_0_1 - 0.013742125287264*G0_0_2 - 0.013742125287264*G0_1_0 - 0.013742125287264*G0_1_1 - 0.013742125287264*G0_1_2 - 0.013742125287264*G0_2_0 - 0.013742125287264*G0_2_1 - 0.013742125287264*G0_2_2;
    A[29] = -0.009464999699375*G0_0_0 - 0.009464999699375*G0_0_1 - 0.009464999699375*G0_0_2 - 0.009464999699375*G0_1_0 - 0.009464999699374*G0_1_1 - 0.009464999699375*G0_1_2 - 0.009464999699375*G0_2_0 - 0.009464999699375*G0_2_1 - 0.009464999699375*G0_2_2;
    A[30] = -0.013742125287264*G0_0_0 - 0.013742125287264*G0_0_1 - 0.013742125287264*G0_0_2 - 0.013742125287264*G0_1_0 - 0.013742125287264*G0_1_1 - 0.013742125287264*G0_1_2 - 0.013742125287264*G0_2_0 - 0.013742125287264*G0_2_1 - 0.013742125287264*G0_2_2;
    A[31] = -0.009464999699375*G0_0_0 - 0.009464999699375*G0_0_1 - 0.009464999699375*G0_0_2 - 0.009464999699375*G0_1_0 - 0.009464999699375*G0_1_1 - 0.009464999699375*G0_1_2 - 0.009464999699375*G0_2_0 - 0.009464999699375*G0_2_1 - 0.009464999699375*G0_2_2;
    A[32] = -0.009464999699375*G0_0_0 - 0.009464999699375*G0_0_1 - 0.009464999699375*G0_0_2 - 0.009464999699375*G0_1_0 - 0.009464999699375*G0_1_1 - 0.009464999699375*G0_1_2 - 0.009464999699375*G0_2_0 - 0.009464999699375*G0_2_1 - 0.009464999699375*G0_2_2;
    A[33] = -0.013742125287264*G0_0_0 - 0.013742125287264*G0_0_1 - 0.013742125287264*G0_0_2 - 0.013742125287264*G0_1_0 - 0.013742125287264*G0_1_1 - 0.013742125287264*G0_1_2 - 0.013742125287264*G0_2_0 - 0.013742125287264*G0_2_1 - 0.013742125287264*G0_2_2;
    A[34] = 0.047993054720485*G0_0_0 + 0.033598530777350*G0_0_1 + 0.033598530777350*G0_0_2 + 0.047993054720485*G0_1_0 + 0.033598530777350*G0_1_1 + 0.033598530777350*G0_1_2 + 0.047993054720485*G0_2_0 + 0.033598530777350*G0_2_1 + 0.033598530777350*G0_2_2;
    A[35] = -0.034571909571909*G0_0_0 - 0.029847238506092*G0_0_1 - 0.029847238506092*G0_0_2 - 0.034571909571909*G0_1_0 - 0.029847238506092*G0_1_1 - 0.029847238506092*G0_1_2 - 0.034571909571909*G0_2_0 - 0.029847238506092*G0_2_1 - 0.029847238506092*G0_2_2;
    A[36] = 0.013742125287264*G0_0_0 + 0.018919561020255*G0_0_1 + 0.018919561020255*G0_0_2 + 0.013742125287264*G0_1_0 + 0.018919561020255*G0_1_1 + 0.018919561020255*G0_1_2 + 0.013742125287264*G0_2_0 + 0.018919561020255*G0_2_1 + 0.018919561020255*G0_2_2;
    A[37] = -0.034571909571909*G0_0_0 - 0.029847238506092*G0_0_1 - 0.029847238506092*G0_0_2 - 0.034571909571909*G0_1_0 - 0.029847238506092*G0_1_1 - 0.029847238506092*G0_1_2 - 0.034571909571909*G0_2_0 - 0.029847238506092*G0_2_1 - 0.029847238506092*G0_2_2;
    A[38] = 0.009464999699375*G0_0_0 + 0.011743175805675*G0_0_1 + 0.011743175805676*G0_0_2 + 0.009464999699375*G0_1_0 + 0.011743175805675*G0_1_1 + 0.011743175805676*G0_1_2 + 0.009464999699375*G0_2_0 + 0.011743175805676*G0_2_1 + 0.011743175805676*G0_2_2;
    A[39] = 0.013742125287264*G0_0_0 + 0.018919561020255*G0_0_1 + 0.018919561020255*G0_0_2 + 0.013742125287264*G0_1_0 + 0.018919561020255*G0_1_1 + 0.018919561020255*G0_1_2 + 0.013742125287264*G0_2_0 + 0.018919561020255*G0_2_1 + 0.018919561020255*G0_2_2;
    A[40] = 0.033598530777350*G0_0_0 + 0.047993054720485*G0_0_1 + 0.033598530777350*G0_0_2 + 0.033598530777350*G0_1_0 + 0.047993054720485*G0_1_1 + 0.033598530777350*G0_1_2 + 0.033598530777350*G0_2_0 + 0.047993054720485*G0_2_1 + 0.033598530777350*G0_2_2;
    A[41] = -0.029847238506092*G0_0_0 - 0.034571909571909*G0_0_1 - 0.029847238506092*G0_0_2 - 0.029847238506092*G0_1_0 - 0.034571909571909*G0_1_1 - 0.029847238506092*G0_1_2 - 0.029847238506093*G0_2_0 - 0.034571909571909*G0_2_1 - 0.029847238506092*G0_2_2;
    A[42] = 0.018919561020255*G0_0_0 + 0.013742125287264*G0_0_1 + 0.018919561020255*G0_0_2 + 0.018919561020255*G0_1_0 + 0.013742125287264*G0_1_1 + 0.018919561020255*G0_1_2 + 0.018919561020255*G0_2_0 + 0.013742125287264*G0_2_1 + 0.018919561020255*G0_2_2;
    A[43] = -0.029847238506092*G0_0_0 - 0.034571909571909*G0_0_1 - 0.029847238506092*G0_0_2 - 0.029847238506092*G0_1_0 - 0.034571909571909*G0_1_1 - 0.029847238506092*G0_1_2 - 0.029847238506092*G0_2_0 - 0.034571909571909*G0_2_1 - 0.029847238506092*G0_2_2;
    A[44] = 0.011743175805676*G0_0_0 + 0.009464999699375*G0_0_1 + 0.011743175805676*G0_0_2 + 0.011743175805676*G0_1_0 + 0.009464999699375*G0_1_1 + 0.011743175805676*G0_1_2 + 0.011743175805676*G0_2_0 + 0.009464999699375*G0_2_1 + 0.011743175805676*G0_2_2;
    A[45] = 0.018919561020255*G0_0_0 + 0.013742125287264*G0_0_1 + 0.018919561020255*G0_0_2 + 0.018919561020255*G0_1_0 + 0.013742125287264*G0_1_1 + 0.018919561020255*G0_1_2 + 0.018919561020255*G0_2_0 + 0.013742125287264*G0_2_1 + 0.018919561020255*G0_2_2;
    A[46] = 0.033598530777350*G0_0_0 + 0.033598530777350*G0_0_1 + 0.047993054720485*G0_0_2 + 0.033598530777350*G0_1_0 + 0.033598530777350*G0_1_1 + 0.047993054720485*G0_1_2 + 0.033598530777350*G0_2_0 + 0.033598530777350*G0_2_1 + 0.047993054720485*G0_2_2;
    A[47] = -0.029847238506092*G0_0_0 - 0.029847238506092*G0_0_1 - 0.034571909571909*G0_0_2 - 0.029847238506092*G0_1_0 - 0.029847238506092*G0_1_1 - 0.034571909571909*G0_1_2 - 0.029847238506092*G0_2_0 - 0.029847238506092*G0_2_1 - 0.034571909571909*G0_2_2;
    A[48] = 0.018919561020255*G0_0_0 + 0.018919561020255*G0_0_1 + 0.013742125287264*G0_0_2 + 0.018919561020255*G0_1_0 + 0.018919561020255*G0_1_1 + 0.013742125287264*G0_1_2 + 0.018919561020255*G0_2_0 + 0.018919561020255*G0_2_1 + 0.013742125287264*G0_2_2;
    A[49] = -0.029847238506092*G0_0_0 - 0.029847238506092*G0_0_1 - 0.034571909571909*G0_0_2 - 0.029847238506092*G0_1_0 - 0.029847238506092*G0_1_1 - 0.034571909571909*G0_1_2 - 0.029847238506092*G0_2_0 - 0.029847238506092*G0_2_1 - 0.034571909571909*G0_2_2;
    A[50] = 0.011743175805676*G0_0_0 + 0.011743175805676*G0_0_1 + 0.009464999699375*G0_0_2 + 0.011743175805676*G0_1_0 + 0.011743175805676*G0_1_1 + 0.009464999699375*G0_1_2 + 0.011743175805676*G0_2_0 + 0.011743175805676*G0_2_1 + 0.009464999699375*G0_2_2;
    A[51] = 0.018919561020255*G0_0_0 + 0.018919561020255*G0_0_1 + 0.013742125287264*G0_0_2 + 0.018919561020255*G0_1_0 + 0.018919561020255*G0_1_1 + 0.013742125287264*G0_1_2 + 0.018919561020255*G0_2_0 + 0.018919561020255*G0_2_1 + 0.013742125287264*G0_2_2;
    A[52] = -0.078287838704505*G0_0_0 - 0.078287838704505*G0_0_1 - 0.078287838704504*G0_0_2 - 0.078287838704504*G0_1_0 - 0.078287838704505*G0_1_1 - 0.078287838704505*G0_1_2 - 0.078287838704505*G0_2_0 - 0.078287838704505*G0_2_1 - 0.078287838704505*G0_2_2;
    A[53] = 0.044036909271284*G0_0_0 + 0.044036909271284*G0_0_1 + 0.044036909271284*G0_0_2 + 0.044036909271284*G0_1_0 + 0.044036909271284*G0_1_1 + 0.044036909271284*G0_1_2 + 0.044036909271284*G0_2_0 + 0.044036909271284*G0_2_1 + 0.044036909271284*G0_2_2;
    A[54] = 0.044036909271284*G0_0_0 + 0.044036909271284*G0_0_1 + 0.044036909271284*G0_0_2 + 0.044036909271284*G0_1_0 + 0.044036909271284*G0_1_1 + 0.044036909271284*G0_1_2 + 0.044036909271284*G0_2_0 + 0.044036909271284*G0_2_1 + 0.044036909271284*G0_2_2;
    A[55] = 0.044036909271284*G0_0_0 + 0.044036909271284*G0_0_1 + 0.044036909271284*G0_0_2 + 0.044036909271284*G0_1_0 + 0.044036909271284*G0_1_1 + 0.044036909271284*G0_1_2 + 0.044036909271284*G0_2_0 + 0.044036909271284*G0_2_1 + 0.044036909271284*G0_2_2;
    A[56] = -0.002778905122655*G0_0_0 - 0.002778905122655*G0_0_1 - 0.002778905122655*G0_0_2;
    A[57] = 0.026265256734006*G0_0_0;
    A[58] = 0.002778905122655*G0_0_1;
    A[59] = 0.002778905122655*G0_0_2;
    A[60] = 0.004800349309898*G0_0_1 + 0.004800349309898*G0_0_2;
    A[61] = 0.003365072266982*G0_0_1 + 0.003365072266982*G0_0_2;
    A[62] = 0.003365072266982*G0_0_1 + 0.003365072266982*G0_0_2;
    A[63] = 0.004800349309898*G0_0_1 + 0.004800349309898*G0_0_2;
    A[64] = -0.017870503981615*G0_0_0 + 0.037257182439474*G0_0_2;
    A[65] = 0.021469134967399*G0_0_0 - 0.033658551453690*G0_0_2;
    A[66] = -0.015554488753273*G0_0_0 + 0.023263231271043*G0_0_2;
    A[67] = 0.004800349309898*G0_0_0 - 0.010531019103068*G0_0_2;
    A[68] = -0.017870503981615*G0_0_0 + 0.037257182439474*G0_0_1;
    A[69] = 0.021469134967399*G0_0_0 - 0.033658551453690*G0_0_1;
    A[70] = -0.015554488753273*G0_0_0 + 0.023263231271043*G0_0_1;
    A[71] = 0.004800349309898*G0_0_0 - 0.010531019103068*G0_0_1;
    A[72] = -0.004800349309898*G0_0_0 - 0.004800349309898*G0_0_1;
    A[73] = -0.003365072266982*G0_0_0 - 0.003365072266982*G0_0_1;
    A[74] = -0.003365072266982*G0_0_0 - 0.003365072266982*G0_0_1;
    A[75] = -0.004800349309898*G0_0_0 - 0.004800349309898*G0_0_1;
    A[76] = -0.004800349309898*G0_0_0 - 0.004800349309898*G0_0_2;
    A[77] = -0.003365072266982*G0_0_0 - 0.003365072266982*G0_0_2;
    A[78] = -0.003365072266982*G0_0_0 - 0.003365072266982*G0_0_2;
    A[79] = -0.004800349309898*G0_0_0 - 0.004800349309898*G0_0_2;
    A[80] = 0.015331368412965*G0_0_0 + 0.010531019103068*G0_0_1 + 0.010531019103068*G0_0_2;
    A[81] = -0.038817720024317*G0_0_0 - 0.023263231271043*G0_0_1 - 0.023263231271043*G0_0_2;
    A[82] = 0.055127686421088*G0_0_0 + 0.033658551453690*G0_0_1 + 0.033658551453690*G0_0_2;
    A[83] = -0.055127686421089*G0_0_0 - 0.037257182439474*G0_0_1 - 0.037257182439474*G0_0_2;
    A[84] = 0.047993054720485*G0_0_0 + 0.014394523943135*G0_0_1 + 0.014394523943135*G0_0_2;
    A[85] = -0.034571909571909*G0_0_0 - 0.004724671065817*G0_0_1 - 0.004724671065817*G0_0_2;
    A[86] = 0.013742125287264*G0_0_0 - 0.005177435732991*G0_0_1 - 0.005177435732991*G0_0_2;
    A[87] = -0.034571909571909*G0_0_0 - 0.004724671065817*G0_0_1 - 0.004724671065817*G0_0_2;
    A[88] = 0.009464999699375*G0_0_0 - 0.002278176106301*G0_0_1 - 0.002278176106301*G0_0_2;
    A[89] = 0.013742125287264*G0_0_0 - 0.005177435732991*G0_0_1 - 0.005177435732991*G0_0_2;
    A[90] = -0.013742125287264*G0_0_0;
    A[91] = -0.009464999699375*G0_0_0;
    A[92] = -0.013742125287264*G0_0_0;
    A[93] = -0.009464999699375*G0_0_0;
    A[94] = -0.009464999699375*G0_0_0;
    A[95] = -0.013742125287264*G0_0_0;
    A[96] = 0.018919561020255*G0_0_0 + 0.005177435732991*G0_0_1;
    A[97] = -0.029847238506093*G0_0_0 + 0.004724671065817*G0_0_1;
    A[98] = 0.033598530777350*G0_0_0 - 0.014394523943135*G0_0_1;
    A[99] = 0.011743175805676*G0_0_0 + 0.002278176106301*G0_0_1;
    A[100] = -0.029847238506093*G0_0_0 + 0.004724671065817*G0_0_1;
    A[101] = 0.018919561020255*G0_0_0 + 0.005177435732991*G0_0_1;
    A[102] = 0.018919561020255*G0_0_0 + 0.005177435732991*G0_0_2;
    A[103] = -0.029847238506093*G0_0_0 + 0.004724671065817*G0_0_2;
    A[104] = 0.033598530777350*G0_0_0 - 0.014394523943135*G0_0_2;
    A[105] = 0.011743175805676*G0_0_0 + 0.002278176106301*G0_0_2;
    A[106] = -0.029847238506092*G0_0_0 + 0.004724671065817*G0_0_2;
    A[107] = 0.018919561020255*G0_0_0 + 0.005177435732991*G0_0_2;
    A[108] = 0.044036909271284*G0_0_0;
    A[109] = -0.078287838704505*G0_0_0;
    A[110] = 0.044036909271284*G0_0_0;
    A[111] = 0.044036909271284*G0_0_0;
    A[112] = -0.002778905122655*G0_1_0 - 0.002778905122655*G0_1_1 - 0.002778905122655*G0_1_2;
    A[113] = 0.002778905122655*G0_1_0;
    A[114] = 0.026265256734007*G0_1_1;
    A[115] = 0.002778905122655*G0_1_2;
    A[116] = -0.017870503981615*G0_1_1 + 0.037257182439474*G0_1_2;
    A[117] = 0.021469134967399*G0_1_1 - 0.033658551453690*G0_1_2;
    A[118] = -0.015554488753273*G0_1_1 + 0.023263231271044*G0_1_2;
    A[119] = 0.004800349309898*G0_1_1 - 0.010531019103068*G0_1_2;
    A[120] = 0.004800349309898*G0_1_0 + 0.004800349309898*G0_1_2;
    A[121] = 0.003365072266982*G0_1_0 + 0.003365072266982*G0_1_2;
    A[122] = 0.003365072266982*G0_1_0 + 0.003365072266982*G0_1_2;
    A[123] = 0.004800349309898*G0_1_0 + 0.004800349309898*G0_1_2;
    A[124] = -0.010531019103068*G0_1_0 + 0.004800349309898*G0_1_1;
    A[125] = 0.023263231271043*G0_1_0 - 0.015554488753273*G0_1_1;
    A[126] = -0.033658551453690*G0_1_0 + 0.021469134967399*G0_1_1;
    A[127] = 0.037257182439474*G0_1_0 - 0.017870503981615*G0_1_1;
    A[128] = -0.004800349309898*G0_1_0 - 0.004800349309898*G0_1_1;
    A[129] = -0.003365072266982*G0_1_0 - 0.003365072266982*G0_1_1;
    A[130] = -0.003365072266982*G0_1_0 - 0.003365072266982*G0_1_1;
    A[131] = -0.004800349309898*G0_1_0 - 0.004800349309898*G0_1_1;
    A[132] = 0.010531019103068*G0_1_0 + 0.015331368412966*G0_1_1 + 0.010531019103068*G0_1_2;
    A[133] = -0.023263231271044*G0_1_0 - 0.038817720024317*G0_1_1 - 0.023263231271044*G0_1_2;
    A[134] = 0.033658551453690*G0_1_0 + 0.055127686421089*G0_1_1 + 0.033658551453690*G0_1_2;
    A[135] = -0.037257182439474*G0_1_0 - 0.055127686421089*G0_1_1 - 0.037257182439474*G0_1_2;
    A[136] = -0.004800349309898*G0_1_1 - 0.004800349309898*G0_1_2;
    A[137] = -0.003365072266982*G0_1_1 - 0.003365072266982*G0_1_2;
    A[138] = -0.003365072266982*G0_1_1 - 0.003365072266982*G0_1_2;
    A[139] = -0.004800349309898*G0_1_1 - 0.004800349309898*G0_1_2;
    A[140] = -0.005177435732991*G0_1_0 + 0.013742125287264*G0_1_1 - 0.005177435732991*G0_1_2;
    A[141] = -0.004724671065817*G0_1_0 - 0.034571909571909*G0_1_1 - 0.004724671065817*G0_1_2;
    A[142] = 0.014394523943135*G0_1_0 + 0.047993054720485*G0_1_1 + 0.014394523943135*G0_1_2;
    A[143] = -0.002278176106301*G0_1_0 + 0.009464999699375*G0_1_1 - 0.002278176106301*G0_1_2;
    A[144] = -0.004724671065817*G0_1_0 - 0.034571909571909*G0_1_1 - 0.004724671065817*G0_1_2;
    A[145] = -0.005177435732991*G0_1_0 + 0.013742125287264*G0_1_1 - 0.005177435732991*G0_1_2;
    A[146] = 0.005177435732991*G0_1_0 + 0.018919561020255*G0_1_1;
    A[147] = 0.004724671065817*G0_1_0 - 0.029847238506092*G0_1_1;
    A[148] = -0.014394523943135*G0_1_0 + 0.033598530777350*G0_1_1;
    A[149] = 0.002278176106301*G0_1_0 + 0.011743175805676*G0_1_1;
    A[150] = 0.004724671065817*G0_1_0 - 0.029847238506092*G0_1_1;
    A[151] = 0.005177435732991*G0_1_0 + 0.018919561020255*G0_1_1;
    A[152] = -0.013742125287264*G0_1_1;
    A[153] = -0.009464999699375*G0_1_1;
    A[154] = -0.013742125287264*G0_1_1;
    A[155] = -0.009464999699375*G0_1_1;
    A[156] = -0.009464999699375*G0_1_1;
    A[157] = -0.013742125287264*G0_1_1;
    A[158] = 0.018919561020255*G0_1_1 + 0.005177435732991*G0_1_2;
    A[159] = 0.011743175805676*G0_1_1 + 0.002278176106301*G0_1_2;
    A[160] = 0.018919561020255*G0_1_1 + 0.005177435732991*G0_1_2;
    A[161] = -0.029847238506092*G0_1_1 + 0.004724671065817*G0_1_2;
    A[162] = -0.029847238506093*G0_1_1 + 0.004724671065817*G0_1_2;
    A[163] = 0.033598530777350*G0_1_1 - 0.014394523943135*G0_1_2;
    A[164] = 0.044036909271284*G0_1_1;
    A[165] = 0.044036909271284*G0_1_1;
    A[166] = -0.078287838704505*G0_1_1;
    A[167] = 0.044036909271284*G0_1_1;
    A[168] = -0.002778905122655*G0_2_0 - 0.002778905122655*G0_2_1 - 0.002778905122655*G0_2_2;
    A[169] = 0.002778905122655*G0_2_0;
    A[170] = 0.002778905122655*G0_2_1;
    A[171] = 0.026265256734007*G0_2_2;
    A[172] = -0.010531019103068*G0_2_1 + 0.004800349309898*G0_2_2;
    A[173] = 0.023263231271044*G0_2_1 - 0.015554488753273*G0_2_2;
    A[174] = -0.033658551453690*G0_2_1 + 0.021469134967399*G0_2_2;
    A[175] = 0.037257182439474*G0_2_1 - 0.017870503981615*G0_2_2;
    A[176] = -0.010531019103068*G0_2_0 + 0.004800349309898*G0_2_2;
    A[177] = 0.023263231271044*G0_2_0 - 0.015554488753273*G0_2_2;
    A[178] = -0.033658551453690*G0_2_0 + 0.021469134967399*G0_2_2;
    A[179] = 0.037257182439474*G0_2_0 - 0.017870503981615*G0_2_2;
    A[180] = 0.004800349309898*G0_2_0 + 0.004800349309898*G0_2_1;
    A[181] = 0.003365072266982*G0_2_0 + 0.003365072266982*G0_2_1;
    A[182] = 0.003365072266982*G0_2_0 + 0.003365072266982*G0_2_1;
    A[183] = 0.004800349309898*G0_2_0 + 0.004800349309898*G0_2_1;
    A[184] = 0.010531019103068*G0_2_0 + 0.010531019103068*G0_2_1 + 0.015331368412966*G0_2_2;
    A[185] = -0.023263231271044*G0_2_0 - 0.023263231271044*G0_2_1 - 0.038817720024317*G0_2_2;
    A[186] = 0.033658551453690*G0_2_0 + 0.033658551453690*G0_2_1 + 0.055127686421089*G0_2_2;
    A[187] = -0.037257182439474*G0_2_0 - 0.037257182439474*G0_2_1 - 0.055127686421089*G0_2_2;
    A[188] = -0.004800349309898*G0_2_0 - 0.004800349309898*G0_2_2;
    A[189] = -0.003365072266982*G0_2_0 - 0.003365072266982*G0_2_2;
    A[190] = -0.003365072266982*G0_2_0 - 0.003365072266982*G0_2_2;
    A[191] = -0.004800349309898*G0_2_0 - 0.004800349309898*G0_2_2;
    A[192] = -0.004800349309898*G0_2_1 - 0.004800349309898*G0_2_2;
    A[193] = -0.003365072266982*G0_2_1 - 0.003365072266982*G0_2_2;
    A[194] = -0.003365072266982*G0_2_1 - 0.003365072266982*G0_2_2;
    A[195] = -0.004800349309898*G0_2_1 - 0.004800349309898*G0_2_2;
    A[196] = -0.005177435732991*G0_2_0 - 0.005177435732991*G0_2_1 + 0.013742125287264*G0_2_2;
    A[197] = -0.002278176106301*G0_2_0 - 0.002278176106301*G0_2_1 + 0.009464999699375*G0_2_2;
    A[198] = -0.005177435732991*G0_2_0 - 0.005177435732991*G0_2_1 + 0.013742125287264*G0_2_2;
    A[199] = -0.004724671065817*G0_2_0 - 0.004724671065817*G0_2_1 - 0.034571909571909*G0_2_2;
    A[200] = -0.004724671065817*G0_2_0 - 0.004724671065817*G0_2_1 - 0.034571909571909*G0_2_2;
    A[201] = 0.014394523943135*G0_2_0 + 0.014394523943135*G0_2_1 + 0.047993054720485*G0_2_2;
    A[202] = 0.005177435732991*G0_2_0 + 0.018919561020255*G0_2_2;
    A[203] = 0.002278176106301*G0_2_0 + 0.011743175805676*G0_2_2;
    A[204] = 0.005177435732991*G0_2_0 + 0.018919561020255*G0_2_2;
    A[205] = 0.004724671065817*G0_2_0 - 0.029847238506092*G0_2_2;
    A[206] = 0.004724671065817*G0_2_0 - 0.029847238506093*G0_2_2;
    A[207] = -0.014394523943135*G0_2_0 + 0.033598530777350*G0_2_2;
    A[208] = 0.005177435732991*G0_2_1 + 0.018919561020255*G0_2_2;
    A[209] = 0.002278176106301*G0_2_1 + 0.011743175805676*G0_2_2;
    A[210] = 0.005177435732991*G0_2_1 + 0.018919561020255*G0_2_2;
    A[211] = 0.004724671065817*G0_2_1 - 0.029847238506093*G0_2_2;
    A[212] = 0.004724671065817*G0_2_1 - 0.029847238506092*G0_2_2;
    A[213] = -0.014394523943135*G0_2_1 + 0.033598530777350*G0_2_2;
    A[214] = -0.013742125287264*G0_2_2;
    A[215] = -0.009464999699375*G0_2_2;
    A[216] = -0.013742125287264*G0_2_2;
    A[217] = -0.009464999699375*G0_2_2;
    A[218] = -0.009464999699375*G0_2_2;
    A[219] = -0.013742125287264*G0_2_2;
    A[220] = 0.044036909271284*G0_2_2;
    A[221] = 0.044036909271284*G0_2_2;
    A[222] = 0.044036909271284*G0_2_2;
    A[223] = -0.078287838704505*G0_2_2;
    A[224] = -0.004800349309898*G0_1_0 - 0.004800349309898*G0_1_1 - 0.004800349309898*G0_1_2 - 0.004800349309898*G0_2_0 - 0.004800349309898*G0_2_1 - 0.004800349309898*G0_2_2;
    A[225] = 0.004800349309898*G0_1_0 + 0.004800349309898*G0_2_0;
    A[226] = -0.017870503981615*G0_1_1 + 0.037257182439474*G0_2_1;
    A[227] = -0.010531019103068*G0_1_2 + 0.004800349309898*G0_2_2;
    A[228] = 0.179096479009672*G0_1_1 + 0.069911039963123*G0_1_2 + 0.069911039963123*G0_2_1 + 0.139822079926246*G0_2_2;
    A[229] = -0.147063705006412*G0_1_1 + 0.026383001643418*G0_1_2 - 0.038726384212495*G0_2_1 - 0.108637424175618*G0_2_2;
    A[230] = 0.100717304493345*G0_1_1 - 0.024634573245684*G0_1_2 + 0.018978276899284*G0_2_1 + 0.078894569454465*G0_2_2;
    A[231] = -0.032835224349981*G0_1_1 + 0.020915900907220*G0_1_2 - 0.005375764924376*G0_2_1 - 0.032835224349981*G0_2_2;
    A[232] = -0.010751529848752*G0_1_0 - 0.005375764924376*G0_1_2 - 0.005375764924376*G0_2_0 - 0.005375764924376*G0_2_2;
    A[233] = -0.013974379208754*G0_1_0 - 0.011684459926647*G0_1_2 - 0.002289919282107*G0_2_0 - 0.002289919282107*G0_2_2;
    A[234] = -0.011169064988509*G0_1_0 - 0.008879145706403*G0_1_2 - 0.002289919282107*G0_2_0 - 0.002289919282107*G0_2_2;
    A[235] = -0.032835224349981*G0_1_0 - 0.027459459425605*G0_1_2 - 0.005375764924376*G0_2_0 - 0.005375764924376*G0_2_2;
    A[236] = -0.027459459425605*G0_1_0 - 0.005375764924376*G0_1_1 - 0.032835224349981*G0_2_0 - 0.005375764924376*G0_2_1;
    A[237] = 0.059916292555181*G0_1_0 + 0.028372817543824*G0_1_1 + 0.078894569454465*G0_2_0 + 0.018978276899284*G0_2_1;
    A[238] = -0.069911039963123*G0_1_0 - 0.057417605703195*G0_1_1 - 0.108637424175618*G0_2_0 - 0.038726384212495*G0_2_1;
    A[239] = 0.069911039963123*G0_1_0 + 0.089548239504836*G0_1_1 + 0.139822079926246*G0_2_0 + 0.069911039963123*G0_2_1;
    A[240] = 0.010751529848752*G0_1_0 + 0.010751529848752*G0_1_1 + 0.005375764924376*G0_1_2 + 0.005375764924376*G0_2_0 + 0.005375764924376*G0_2_1;
    A[241] = 0.013974379208754*G0_1_0 + 0.013974379208754*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_1;
    A[242] = 0.011169064988509*G0_1_0 + 0.011169064988509*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_1;
    A[243] = 0.032835224349981*G0_1_0 + 0.032835224349981*G0_1_1 + 0.005375764924376*G0_1_2 + 0.005375764924376*G0_2_0 + 0.005375764924376*G0_2_1;
    A[244] = 0.027459459425605*G0_1_0 + 0.022083694501229*G0_1_1 + 0.027459459425605*G0_1_2 + 0.032835224349981*G0_2_0 + 0.027459459425605*G0_2_1 + 0.032835224349981*G0_2_2;
    A[245] = -0.059916292555181*G0_1_0 - 0.031543475011357*G0_1_1 - 0.059916292555181*G0_1_2 - 0.078894569454465*G0_2_0 - 0.059916292555181*G0_2_1 - 0.078894569454465*G0_2_2;
    A[246] = 0.069911039963123*G0_1_0 + 0.012493434259927*G0_1_1 + 0.069911039963123*G0_1_2 + 0.108637424175618*G0_2_0 + 0.069911039963123*G0_2_1 + 0.108637424175618*G0_2_2;
    A[247] = -0.069911039963123*G0_1_0 + 0.019637199541713*G0_1_1 - 0.069911039963123*G0_1_2 - 0.139822079926246*G0_2_0 - 0.069911039963123*G0_2_1 - 0.139822079926246*G0_2_2;
    A[248] = 0.005375764924376*G0_1_1 + 0.005375764924376*G0_1_2 + 0.005375764924376*G0_2_1 + 0.005375764924376*G0_2_2;
    A[249] = 0.002289919282107*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.002289919282107*G0_2_2;
    A[250] = 0.002289919282107*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.002289919282107*G0_2_2;
    A[251] = 0.005375764924376*G0_1_1 + 0.005375764924376*G0_1_2 + 0.005375764924376*G0_2_1 + 0.005375764924376*G0_2_2;
    A[252] = 0.042536392362781*G0_1_0 - 0.018789081289081*G0_1_1 + 0.021268196181390*G0_1_2 + 0.011873655536850*G0_2_0 - 0.009394540644541*G0_2_1 + 0.011873655536849*G0_2_2;
    A[253] = -0.084550865800865*G0_1_0 + 0.043971669405697*G0_1_1 - 0.042275432900432*G0_1_2 - 0.042960451489097*G0_2_0 - 0.000685018588664*G0_2_1 - 0.042960451489096*G0_2_2;
    A[254] = 0.192588083213082*G0_1_0 - 0.064456987200042*G0_1_1 + 0.096294041606541*G0_1_2 + 0.124738623002511*G0_2_0 + 0.028444581395970*G0_2_1 + 0.124738623002511*G0_2_2;
    A[255] = 0.014287530563572*G0_1_0 - 0.029260079715809*G0_1_1 + 0.008448562593528*G0_1_2 + 0.002544354757896*G0_2_0 - 0.003294613212148*G0_2_1 + 0.002544354757896*G0_2_2;
    A[256] = -0.049321338383838*G0_1_0 + 0.127315597693201*G0_1_1 - 0.007045905483406*G0_1_2 - 0.042960451489097*G0_2_0 - 0.000685018588664*G0_2_1 - 0.042960451489097*G0_2_2;
    A[257] = 0.047755581609748*G0_1_0 - 0.064130787872107*G0_1_1 + 0.026487385428358*G0_1_2 + 0.011873655536850*G0_2_0 - 0.009394540644541*G0_2_1 + 0.011873655536850*G0_2_2;
    A[258] = -0.042536392362781*G0_1_0 - 0.061325473651862*G0_1_1 - 0.021268196181391*G0_1_2 - 0.011873655536850*G0_2_0 - 0.021268196181391*G0_2_1;
    A[259] = 0.084550865800865*G0_1_0 + 0.128522535206562*G0_1_1 + 0.042275432900433*G0_1_2 + 0.042960451489097*G0_2_0 + 0.042275432900433*G0_2_1;
    A[260] = -0.192588083213082*G0_1_0 - 0.257045070413124*G0_1_1 - 0.096294041606541*G0_1_2 - 0.124738623002511*G0_2_0 - 0.096294041606541*G0_2_1;
    A[261] = -0.014287530563572*G0_1_0 - 0.043547610279381*G0_1_1 - 0.005838967970044*G0_1_2 - 0.002544354757896*G0_2_0 - 0.005838967970044*G0_2_1;
    A[262] = 0.049321338383838*G0_1_0 + 0.176636936077039*G0_1_1 + 0.042275432900432*G0_1_2 + 0.042960451489097*G0_2_0 + 0.042275432900433*G0_2_1;
    A[263] = -0.047755581609748*G0_1_0 - 0.111886369481855*G0_1_1 - 0.021268196181390*G0_1_2 - 0.011873655536850*G0_2_0 - 0.021268196181391*G0_2_1;
    A[264] = 0.018789081289081*G0_1_1 + 0.009394540644540*G0_1_2 + 0.009394540644541*G0_2_1;
    A[265] = 0.006589226424296*G0_1_1 + 0.003294613212148*G0_1_2 + 0.003294613212148*G0_2_1;
    A[266] = 0.018789081289081*G0_1_1 + 0.009394540644540*G0_1_2 + 0.009394540644541*G0_2_1;
    A[267] = 0.029260079715809*G0_1_1 + 0.003294613212148*G0_1_2 + 0.003294613212148*G0_2_1;
    A[268] = 0.029260079715809*G0_1_1 + 0.003294613212148*G0_1_2 + 0.003294613212148*G0_2_1;
    A[269] = 0.064130787872107*G0_1_1 + 0.009394540644541*G0_1_2 + 0.009394540644541*G0_2_1;
    A[270] = -0.030662736825931*G0_1_1 - 0.021268196181391*G0_1_2 - 0.021268196181391*G0_2_1 - 0.011873655536850*G0_2_2;
    A[271] = -0.009133581182192*G0_1_1 - 0.005838967970044*G0_1_2 - 0.005838967970044*G0_2_1 - 0.002544354757896*G0_2_2;
    A[272] = -0.030662736825931*G0_1_1 - 0.021268196181390*G0_1_2 - 0.021268196181390*G0_2_1 - 0.011873655536850*G0_2_2;
    A[273] = 0.064261267603281*G0_1_1 + 0.042275432900432*G0_1_2 + 0.042275432900433*G0_2_1 + 0.042960451489097*G0_2_2;
    A[274] = 0.064261267603281*G0_1_1 + 0.042275432900432*G0_1_2 + 0.042275432900432*G0_2_1 + 0.042960451489097*G0_2_2;
    A[275] = -0.128522535206562*G0_1_1 - 0.096294041606540*G0_1_2 - 0.096294041606541*G0_2_1 - 0.124738623002511*G0_2_2;
    A[276] = -0.050560895829993*G0_1_1 - 0.002609594623483*G0_1_2 - 0.002609594623484*G0_2_1;
    A[277] = -0.050560895829993*G0_1_1 - 0.002609594623483*G0_1_2 - 0.002609594623483*G0_2_1;
    A[278] = 0.096228801740954*G0_1_1 - 0.035229527417027*G0_1_2 - 0.035229527417027*G0_2_1;
    A[279] = -0.156575677409010*G0_1_1 - 0.002609594623484*G0_1_2 - 0.002609594623484*G0_2_1;
    A[280] = -0.003365072266982*G0_1_0 - 0.003365072266982*G0_1_1 - 0.003365072266982*G0_1_2 - 0.003365072266982*G0_2_0 - 0.003365072266982*G0_2_1 - 0.003365072266982*G0_2_2;
    A[281] = 0.003365072266982*G0_1_0 + 0.003365072266982*G0_2_0;
    A[282] = 0.021469134967399*G0_1_1 - 0.033658551453690*G0_2_1;
    A[283] = 0.023263231271044*G0_1_2 - 0.015554488753273*G0_2_2;
    A[284] = -0.147063705006412*G0_1_1 - 0.038726384212495*G0_1_2 + 0.026383001643418*G0_2_1 - 0.108637424175618*G0_2_2;
    A[285] = 0.304226541205706*G0_1_1 + 0.078131263027096*G0_1_2 + 0.078131263027096*G0_2_1 + 0.281001149056703*G0_2_2;
    A[286] = -0.204187731314466*G0_1_1 + 0.015305272466731*G0_1_2 - 0.036495180809417*G0_2_1 - 0.204187731314466*G0_2_2;
    A[287] = 0.078894569454465*G0_1_1 - 0.024634573245684*G0_1_2 + 0.018978276899283*G0_2_1 + 0.100717304493345*G0_2_2;
    A[288] = -0.013974379208754*G0_1_0 - 0.002289919282107*G0_1_2 - 0.011684459926647*G0_2_0 - 0.002289919282107*G0_2_2;
    A[289] = 0.026304713804713*G0_1_0 + 0.013152356902356*G0_1_2 + 0.013152356902357*G0_2_0 + 0.013217596767944*G0_2_2;
    A[290] = 0.005232237220084*G0_1_0 + 0.005780252091016*G0_1_2 - 0.000548014870931*G0_2_0 - 0.000482775005344*G0_2_2;
    A[291] = 0.078894569454465*G0_1_0 + 0.059916292555181*G0_1_2 + 0.018978276899284*G0_2_0 + 0.028372817543824*G0_2_2;
    A[292] = -0.008879145706402*G0_1_0 - 0.002289919282107*G0_1_1 - 0.011169064988509*G0_2_0 - 0.002289919282107*G0_2_1;
    A[293] = 0.005780252091016*G0_1_0 - 0.000482775005344*G0_1_1 + 0.005232237220084*G0_2_0 - 0.000548014870931*G0_2_1;
    A[294] = 0.004801654107210*G0_1_0 + 0.005062613569558*G0_1_1 + 0.009603308214420*G0_2_0 + 0.004801654107210*G0_2_1;
    A[295] = -0.038726384212495*G0_1_0 - 0.057417605703195*G0_1_1 - 0.108637424175618*G0_2_0 - 0.069911039963123*G0_2_1;
    A[296] = 0.013974379208754*G0_1_0 + 0.013974379208754*G0_1_1 + 0.011684459926647*G0_1_2 + 0.011684459926647*G0_2_0 + 0.011684459926647*G0_2_1 + 0.009394540644541*G0_2_2;
    A[297] = -0.026304713804713*G0_1_0 - 0.026304713804713*G0_1_1 - 0.013152356902357*G0_1_2 - 0.013152356902357*G0_2_0 - 0.013152356902357*G0_2_1 + 0.000065239865587*G0_2_2;
    A[298] = -0.005232237220084*G0_1_0 - 0.005232237220085*G0_1_1 + 0.000548014870932*G0_1_2 + 0.000548014870931*G0_2_0 + 0.000548014870931*G0_2_1 + 0.000065239865587*G0_2_2;
    A[299] = -0.078894569454465*G0_1_0 - 0.078894569454465*G0_1_1 - 0.018978276899284*G0_1_2 - 0.018978276899283*G0_2_0 - 0.018978276899283*G0_2_1 + 0.009394540644541*G0_2_2;
    A[300] = 0.008879145706402*G0_1_0 + 0.006589226424296*G0_1_1 + 0.008879145706402*G0_1_2 + 0.011169064988509*G0_2_0 + 0.008879145706402*G0_2_1 + 0.011169064988509*G0_2_2;
    A[301] = -0.005780252091016*G0_1_0 - 0.006263027096360*G0_1_1 - 0.005780252091016*G0_1_2 - 0.005232237220084*G0_2_0 - 0.005780252091016*G0_2_1 - 0.005232237220084*G0_2_2;
    A[302] = -0.004801654107210*G0_1_0 + 0.000260959462348*G0_1_1 - 0.004801654107210*G0_1_2 - 0.009603308214419*G0_2_0 - 0.004801654107210*G0_2_1 - 0.009603308214419*G0_2_2;
    A[303] = 0.038726384212495*G0_1_0 - 0.018691221490700*G0_1_1 + 0.038726384212495*G0_1_2 + 0.108637424175618*G0_2_0 + 0.038726384212495*G0_2_1 + 0.108637424175618*G0_2_2;
    A[304] = 0.002289919282107*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.002289919282107*G0_2_2;
    A[305] = 0.001787572317086*G0_1_1 + 0.001787572317086*G0_1_2 + 0.001787572317086*G0_2_1 + 0.001787572317086*G0_2_2;
    A[306] = 0.001787572317086*G0_1_1 + 0.001787572317086*G0_1_2 + 0.001787572317086*G0_2_1 + 0.001787572317086*G0_2_2;
    A[307] = 0.002289919282107*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.002289919282107*G0_2_2;
    A[308] = 0.040318236932820*G0_1_0 + 0.014874689353856*G0_1_1 + 0.001239557446155*G0_1_2 + 0.054018608706109*G0_2_0 + 0.014939929219443*G0_2_1 + 0.001174317580568*G0_2_2;
    A[309] = -0.080832193462401*G0_1_0 - 0.043645470077761*G0_1_1 - 0.006491366625915*G0_1_2 - 0.108232937008978*G0_2_0 - 0.033892110172492*G0_2_1 - 0.003522952741703*G0_2_2;
    A[310] = 0.010960297418630*G0_1_0 + 0.132306447410613*G0_1_1 - 0.062369311501255*G0_1_2 + 0.146659217839772*G0_2_0 + 0.073329608919886*G0_2_1 - 0.124738623002511*G0_2_2;
    A[311] = -0.037773882174923*G0_1_0 + 0.018984800885842*G0_1_1 - 0.018886941087461*G0_1_2 - 0.009394540644540*G0_2_0 + 0.009492400442922*G0_2_1 - 0.015592327875314*G0_2_2;
    A[312] = 0.167731694424401*G0_1_0 - 0.166948816037357*G0_1_1 + 0.083865847212200*G0_1_2 + 0.077700679914221*G0_2_0 - 0.006165167297980*G0_2_1 + 0.182410664181496*G0_2_2;
    A[313] = -0.082332710370904*G0_1_0 + 0.127087258163646*G0_1_1 - 0.046385544432419*G0_1_2 + 0.001826716236438*G0_2_0 + 0.037773882174924*G0_2_1 - 0.051017574889102*G0_2_2;
    A[314] = -0.040318236932819*G0_1_0 - 0.025443547578964*G0_1_1 - 0.039078679486665*G0_1_2 - 0.054018608706108*G0_2_0 - 0.039078679486665*G0_2_1 - 0.052844291125540*G0_2_2;
    A[315] = 0.080832193462401*G0_1_0 + 0.037186723384640*G0_1_1 + 0.074340826836485*G0_1_2 + 0.108232937008977*G0_2_0 + 0.074340826836485*G0_2_1 + 0.104709984267274*G0_2_2;
    A[316] = -0.010960297418630*G0_1_0 + 0.121346149991982*G0_1_1 - 0.073329608919886*G0_1_2 - 0.146659217839772*G0_2_0 - 0.073329608919885*G0_2_1 - 0.271397840842282*G0_2_2;
    A[317] = 0.037773882174923*G0_1_0 + 0.056758683060766*G0_1_1 + 0.018886941087461*G0_1_2 + 0.009394540644540*G0_2_0 + 0.018886941087462*G0_2_1 - 0.006197787230774*G0_2_2;
    A[318] = -0.167731694424401*G0_1_0 - 0.334680510461758*G0_1_1 - 0.083865847212201*G0_1_2 - 0.077700679914221*G0_2_0 - 0.083865847212201*G0_2_1 + 0.104709984267275*G0_2_2;
    A[319] = 0.082332710370904*G0_1_0 + 0.209419968534550*G0_1_1 + 0.035947165938485*G0_1_2 - 0.001826716236438*G0_2_0 + 0.035947165938486*G0_2_1 - 0.052844291125540*G0_2_2;
    A[320] = -0.014874689353855*G0_1_1 - 0.014939929219443*G0_1_2 - 0.014939929219443*G0_2_1 - 0.015005169085030*G0_2_2;
    A[321] = 0.004501550725509*G0_1_1 + 0.001924576034819*G0_1_2 + 0.001924576034819*G0_2_1 - 0.000652398655870*G0_2_2;
    A[322] = -0.014874689353856*G0_1_1 - 0.014939929219443*G0_1_2 - 0.014939929219443*G0_2_1 - 0.015005169085030*G0_2_2;
    A[323] = -0.018984800885843*G0_1_1 - 0.009492400442922*G0_1_2 - 0.009492400442921*G0_2_1 - 0.000652398655871*G0_2_2;
    A[324] = -0.018984800885843*G0_1_1 - 0.009492400442921*G0_1_2 - 0.009492400442922*G0_2_1 - 0.000652398655872*G0_2_2;
    A[325] = -0.127087258163646*G0_1_1 - 0.037773882174923*G0_1_2 - 0.037773882174924*G0_2_1 - 0.015005169085030*G0_2_2;
    A[326] = -0.001304797311741*G0_1_1 - 0.001239557446154*G0_1_2 - 0.001239557446154*G0_2_1 - 0.001174317580568*G0_2_2;
    A[327] = -0.015657567740901*G0_1_1 - 0.013080593050211*G0_1_2 - 0.013080593050211*G0_2_1 - 0.010503618359521*G0_2_2;
    A[328] = -0.001304797311742*G0_1_1 - 0.001239557446155*G0_1_2 - 0.001239557446155*G0_2_1 - 0.001174317580568*G0_2_2;
    A[329] = 0.008807381854257*G0_1_1 + 0.006491366625916*G0_1_2 + 0.006491366625915*G0_2_1 + 0.003522952741703*G0_2_2;
    A[330] = 0.008807381854257*G0_1_1 + 0.006491366625915*G0_1_2 + 0.006491366625916*G0_2_1 + 0.003522952741703*G0_2_2;
    A[331] = 0.047625101878573*G0_1_1 + 0.062369311501255*G0_1_2 + 0.062369311501255*G0_2_1 + 0.124738623002511*G0_2_2;
    A[332] = 0.039143919352252*G0_1_1 + 0.031967534137672*G0_1_2 + 0.031967534137673*G0_2_1 + 0.026095946234835*G0_2_2;
    A[333] = 0.039143919352252*G0_1_1 + 0.031967534137672*G0_1_2 + 0.031967534137672*G0_2_1 + 0.026095946234835*G0_2_2;
    A[334] = -0.156575677409009*G0_1_1 - 0.090357213838115*G0_1_2 - 0.090357213838116*G0_2_1 - 0.185933616923199*G0_2_2;
    A[335] = 0.185933616923200*G0_1_1 + 0.015657567740901*G0_1_2 + 0.015657567740902*G0_2_1 + 0.026095946234835*G0_2_2;
    A[336] = -0.003365072266982*G0_1_0 - 0.003365072266982*G0_1_1 - 0.003365072266982*G0_1_2 - 0.003365072266982*G0_2_0 - 0.003365072266982*G0_2_1 - 0.003365072266982*G0_2_2;
    A[337] = 0.003365072266982*G0_1_0 + 0.003365072266982*G0_2_0;
    A[338] = -0.015554488753273*G0_1_1 + 0.023263231271044*G0_2_1;
    A[339] = -0.033658551453690*G0_1_2 + 0.021469134967399*G0_2_2;
    A[340] = 0.100717304493345*G0_1_1 + 0.018978276899284*G0_1_2 - 0.024634573245684*G0_2_1 + 0.078894569454465*G0_2_2;
    A[341] = -0.204187731314466*G0_1_1 - 0.036495180809417*G0_1_2 + 0.015305272466731*G0_2_1 - 0.204187731314466*G0_2_2;
    A[342] = 0.281001149056702*G0_1_1 + 0.078131263027096*G0_1_2 + 0.078131263027096*G0_2_1 + 0.304226541205706*G0_2_2;
    A[343] = -0.108637424175618*G0_1_1 + 0.026383001643418*G0_1_2 - 0.038726384212495*G0_2_1 - 0.147063705006412*G0_2_2;
    A[344] = -0.011169064988509*G0_1_0 - 0.002289919282107*G0_1_2 - 0.008879145706403*G0_2_0 - 0.002289919282107*G0_2_2;
    A[345] = 0.005232237220084*G0_1_0 - 0.000548014870931*G0_1_2 + 0.005780252091016*G0_2_0 - 0.000482775005344*G0_2_2;
    A[346] = 0.009603308214419*G0_1_0 + 0.004801654107210*G0_1_2 + 0.004801654107209*G0_2_0 + 0.005062613569557*G0_2_2;
    A[347] = -0.108637424175618*G0_1_0 - 0.069911039963123*G0_1_2 - 0.038726384212495*G0_2_0 - 0.057417605703195*G0_2_2;
    A[348] = -0.011684459926647*G0_1_0 - 0.002289919282107*G0_1_1 - 0.013974379208754*G0_2_0 - 0.002289919282107*G0_2_1;
    A[349] = 0.013152356902357*G0_1_0 + 0.013217596767944*G0_1_1 + 0.026304713804714*G0_2_0 + 0.013152356902357*G0_2_1;
    A[350] = -0.000548014870932*G0_1_0 - 0.000482775005344*G0_1_1 + 0.005232237220084*G0_2_0 + 0.005780252091016*G0_2_1;
    A[351] = 0.018978276899284*G0_1_0 + 0.028372817543824*G0_1_1 + 0.078894569454465*G0_2_0 + 0.059916292555181*G0_2_1;
    A[352] = 0.011169064988509*G0_1_0 + 0.011169064988509*G0_1_1 + 0.008879145706403*G0_1_2 + 0.008879145706403*G0_2_0 + 0.008879145706403*G0_2_1 + 0.006589226424296*G0_2_2;
    A[353] = -0.005232237220084*G0_1_0 - 0.005232237220084*G0_1_1 - 0.005780252091016*G0_1_2 - 0.005780252091016*G0_2_0 - 0.005780252091016*G0_2_1 - 0.006263027096360*G0_2_2;
    A[354] = -0.009603308214419*G0_1_0 - 0.009603308214419*G0_1_1 - 0.004801654107210*G0_1_2 - 0.004801654107209*G0_2_0 - 0.004801654107209*G0_2_1 + 0.000260959462348*G0_2_2;
    A[355] = 0.108637424175618*G0_1_0 + 0.108637424175618*G0_1_1 + 0.038726384212495*G0_1_2 + 0.038726384212495*G0_2_0 + 0.038726384212495*G0_2_1 - 0.018691221490700*G0_2_2;
    A[356] = 0.011684459926647*G0_1_0 + 0.009394540644541*G0_1_1 + 0.011684459926647*G0_1_2 + 0.013974379208754*G0_2_0 + 0.011684459926647*G0_2_1 + 0.013974379208754*G0_2_2;
    A[357] = -0.013152356902357*G0_1_0 + 0.000065239865587*G0_1_1 - 0.013152356902357*G0_1_2 - 0.026304713804714*G0_2_0 - 0.013152356902357*G0_2_1 - 0.026304713804714*G0_2_2;
    A[358] = 0.000548014870932*G0_1_0 + 0.000065239865587*G0_1_1 + 0.000548014870932*G0_1_2 - 0.005232237220084*G0_2_0 + 0.000548014870932*G0_2_1 - 0.005232237220084*G0_2_2;
    A[359] = -0.018978276899284*G0_1_0 + 0.009394540644540*G0_1_1 - 0.018978276899284*G0_1_2 - 0.078894569454465*G0_2_0 - 0.018978276899284*G0_2_1 - 0.078894569454465*G0_2_2;
    A[360] = 0.002289919282107*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.002289919282107*G0_2_2;
    A[361] = 0.001787572317086*G0_1_1 + 0.001787572317086*G0_1_2 + 0.001787572317086*G0_2_1 + 0.001787572317086*G0_2_2;
    A[362] = 0.001787572317086*G0_1_1 + 0.001787572317086*G0_1_2 + 0.001787572317086*G0_2_1 + 0.001787572317086*G0_2_2;
    A[363] = 0.002289919282107*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.002289919282107*G0_2_2;
    A[364] = 0.054018608706108*G0_1_0 + 0.001174317580568*G0_1_1 + 0.014939929219443*G0_1_2 + 0.040318236932820*G0_2_0 + 0.001239557446155*G0_2_1 + 0.014874689353855*G0_2_2;
    A[365] = -0.009394540644540*G0_1_0 - 0.015592327875314*G0_1_1 + 0.009492400442921*G0_1_2 - 0.037773882174924*G0_2_0 - 0.018886941087462*G0_2_1 + 0.018984800885842*G0_2_2;
    A[366] = 0.001826716236439*G0_1_0 - 0.051017574889102*G0_1_1 + 0.037773882174923*G0_1_2 - 0.082332710370904*G0_2_0 - 0.046385544432419*G0_2_1 + 0.127087258163646*G0_2_2;
    A[367] = -0.108232937008978*G0_1_0 - 0.003522952741703*G0_1_1 - 0.033892110172492*G0_1_2 - 0.080832193462401*G0_2_0 - 0.006491366625915*G0_2_1 - 0.043645470077761*G0_2_2;
    A[368] = 0.077700679914221*G0_1_0 + 0.182410664181496*G0_1_1 - 0.006165167297979*G0_1_2 + 0.167731694424402*G0_2_0 + 0.083865847212201*G0_2_1 - 0.166948816037356*G0_2_2;
    A[369] = 0.146659217839771*G0_1_0 - 0.124738623002512*G0_1_1 + 0.073329608919886*G0_1_2 + 0.010960297418631*G0_2_0 - 0.062369311501256*G0_2_1 + 0.132306447410613*G0_2_2;
    A[370] = -0.054018608706108*G0_1_0 - 0.052844291125541*G0_1_1 - 0.039078679486665*G0_1_2 - 0.040318236932820*G0_2_0 - 0.039078679486665*G0_2_1 - 0.025443547578964*G0_2_2;
    A[371] = 0.009394540644540*G0_1_0 - 0.006197787230773*G0_1_1 + 0.018886941087461*G0_1_2 + 0.037773882174924*G0_2_0 + 0.018886941087462*G0_2_1 + 0.056758683060766*G0_2_2;
    A[372] = -0.001826716236439*G0_1_0 - 0.052844291125541*G0_1_1 + 0.035947165938485*G0_1_2 + 0.082332710370904*G0_2_0 + 0.035947165938484*G0_2_1 + 0.209419968534550*G0_2_2;
    A[373] = 0.108232937008978*G0_1_0 + 0.104709984267275*G0_1_1 + 0.074340826836486*G0_1_2 + 0.080832193462401*G0_2_0 + 0.074340826836485*G0_2_1 + 0.037186723384640*G0_2_2;
    A[374] = -0.077700679914221*G0_1_0 + 0.104709984267276*G0_1_1 - 0.083865847212200*G0_1_2 - 0.167731694424402*G0_2_0 - 0.083865847212200*G0_2_1 - 0.334680510461758*G0_2_2;
    A[375] = -0.146659217839771*G0_1_0 - 0.271397840842283*G0_1_1 - 0.073329608919886*G0_1_2 - 0.010960297418631*G0_2_0 - 0.073329608919886*G0_2_1 + 0.121346149991982*G0_2_2;
    A[376] = -0.001174317580567*G0_1_1 - 0.001239557446155*G0_1_2 - 0.001239557446154*G0_2_1 - 0.001304797311742*G0_2_2;
    A[377] = -0.010503618359521*G0_1_1 - 0.013080593050211*G0_1_2 - 0.013080593050211*G0_2_1 - 0.015657567740902*G0_2_2;
    A[378] = -0.001174317580567*G0_1_1 - 0.001239557446155*G0_1_2 - 0.001239557446154*G0_2_1 - 0.001304797311742*G0_2_2;
    A[379] = 0.003522952741703*G0_1_1 + 0.006491366625915*G0_1_2 + 0.006491366625915*G0_2_1 + 0.008807381854257*G0_2_2;
    A[380] = 0.003522952741703*G0_1_1 + 0.006491366625915*G0_1_2 + 0.006491366625915*G0_2_1 + 0.008807381854258*G0_2_2;
    A[381] = 0.124738623002512*G0_1_1 + 0.062369311501256*G0_1_2 + 0.062369311501256*G0_2_1 + 0.047625101878573*G0_2_2;
    A[382] = -0.015005169085030*G0_1_1 - 0.014939929219443*G0_1_2 - 0.014939929219443*G0_2_1 - 0.014874689353855*G0_2_2;
    A[383] = -0.000652398655871*G0_1_1 + 0.001924576034819*G0_1_2 + 0.001924576034819*G0_2_1 + 0.004501550725509*G0_2_2;
    A[384] = -0.015005169085030*G0_1_1 - 0.014939929219443*G0_1_2 - 0.014939929219443*G0_2_1 - 0.014874689353855*G0_2_2;
    A[385] = -0.000652398655871*G0_1_1 - 0.009492400442921*G0_1_2 - 0.009492400442921*G0_2_1 - 0.018984800885843*G0_2_2;
    A[386] = -0.000652398655871*G0_1_1 - 0.009492400442921*G0_1_2 - 0.009492400442921*G0_2_1 - 0.018984800885842*G0_2_2;
    A[387] = -0.015005169085030*G0_1_1 - 0.037773882174923*G0_1_2 - 0.037773882174924*G0_2_1 - 0.127087258163646*G0_2_2;
    A[388] = 0.026095946234835*G0_1_1 + 0.031967534137673*G0_1_2 + 0.031967534137672*G0_2_1 + 0.039143919352252*G0_2_2;
    A[389] = 0.026095946234835*G0_1_1 + 0.031967534137673*G0_1_2 + 0.031967534137674*G0_2_1 + 0.039143919352252*G0_2_2;
    A[390] = 0.026095946234835*G0_1_1 + 0.015657567740900*G0_1_2 + 0.015657567740901*G0_2_1 + 0.185933616923199*G0_2_2;
    A[391] = -0.185933616923199*G0_1_1 - 0.090357213838116*G0_1_2 - 0.090357213838116*G0_2_1 - 0.156575677409009*G0_2_2;
    A[392] = -0.004800349309898*G0_1_0 - 0.004800349309898*G0_1_1 - 0.004800349309898*G0_1_2 - 0.004800349309898*G0_2_0 - 0.004800349309898*G0_2_1 - 0.004800349309898*G0_2_2;
    A[393] = 0.004800349309898*G0_1_0 + 0.004800349309898*G0_2_0;
    A[394] = 0.004800349309898*G0_1_1 - 0.010531019103068*G0_2_1;
    A[395] = 0.037257182439474*G0_1_2 - 0.017870503981615*G0_2_2;
    A[396] = -0.032835224349981*G0_1_1 - 0.005375764924376*G0_1_2 + 0.020915900907220*G0_2_1 - 0.032835224349981*G0_2_2;
    A[397] = 0.078894569454465*G0_1_1 + 0.018978276899283*G0_1_2 - 0.024634573245684*G0_2_1 + 0.100717304493345*G0_2_2;
    A[398] = -0.108637424175618*G0_1_1 - 0.038726384212495*G0_1_2 + 0.026383001643418*G0_2_1 - 0.147063705006412*G0_2_2;
    A[399] = 0.139822079926246*G0_1_1 + 0.069911039963123*G0_1_2 + 0.069911039963123*G0_2_1 + 0.179096479009672*G0_2_2;
    A[400] = -0.032835224349981*G0_1_0 - 0.005375764924376*G0_1_2 - 0.027459459425605*G0_2_0 - 0.005375764924376*G0_2_2;
    A[401] = 0.078894569454465*G0_1_0 + 0.018978276899283*G0_1_2 + 0.059916292555181*G0_2_0 + 0.028372817543824*G0_2_2;
    A[402] = -0.108637424175618*G0_1_0 - 0.038726384212495*G0_1_2 - 0.069911039963123*G0_2_0 - 0.057417605703195*G0_2_2;
    A[403] = 0.139822079926246*G0_1_0 + 0.069911039963123*G0_1_2 + 0.069911039963123*G0_2_0 + 0.089548239504836*G0_2_2;
    A[404] = -0.005375764924376*G0_1_0 - 0.005375764924376*G0_1_1 - 0.010751529848752*G0_2_0 - 0.005375764924376*G0_2_1;
    A[405] = -0.002289919282107*G0_1_0 - 0.002289919282107*G0_1_1 - 0.013974379208754*G0_2_0 - 0.011684459926647*G0_2_1;
    A[406] = -0.002289919282107*G0_1_0 - 0.002289919282107*G0_1_1 - 0.011169064988509*G0_2_0 - 0.008879145706403*G0_2_1;
    A[407] = -0.005375764924376*G0_1_0 - 0.005375764924376*G0_1_1 - 0.032835224349981*G0_2_0 - 0.027459459425605*G0_2_1;
    A[408] = 0.032835224349981*G0_1_0 + 0.032835224349981*G0_1_1 + 0.027459459425605*G0_1_2 + 0.027459459425605*G0_2_0 + 0.027459459425605*G0_2_1 + 0.022083694501229*G0_2_2;
    A[409] = -0.078894569454465*G0_1_0 - 0.078894569454465*G0_1_1 - 0.059916292555181*G0_1_2 - 0.059916292555181*G0_2_0 - 0.059916292555181*G0_2_1 - 0.031543475011357*G0_2_2;
    A[410] = 0.108637424175618*G0_1_0 + 0.108637424175618*G0_1_1 + 0.069911039963123*G0_1_2 + 0.069911039963123*G0_2_0 + 0.069911039963123*G0_2_1 + 0.012493434259928*G0_2_2;
    A[411] = -0.139822079926246*G0_1_0 - 0.139822079926246*G0_1_1 - 0.069911039963123*G0_1_2 - 0.069911039963123*G0_2_0 - 0.069911039963123*G0_2_1 + 0.019637199541713*G0_2_2;
    A[412] = 0.005375764924376*G0_1_0 + 0.005375764924376*G0_1_2 + 0.010751529848752*G0_2_0 + 0.005375764924376*G0_2_1 + 0.010751529848752*G0_2_2;
    A[413] = 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_2 + 0.013974379208754*G0_2_0 + 0.002289919282107*G0_2_1 + 0.013974379208754*G0_2_2;
    A[414] = 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_2 + 0.011169064988509*G0_2_0 + 0.002289919282107*G0_2_1 + 0.011169064988509*G0_2_2;
    A[415] = 0.005375764924376*G0_1_0 + 0.005375764924376*G0_1_2 + 0.032835224349981*G0_2_0 + 0.005375764924376*G0_2_1 + 0.032835224349981*G0_2_2;
    A[416] = 0.005375764924376*G0_1_1 + 0.005375764924376*G0_1_2 + 0.005375764924376*G0_2_1 + 0.005375764924376*G0_2_2;
    A[417] = 0.002289919282107*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.002289919282107*G0_2_2;
    A[418] = 0.002289919282107*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.002289919282107*G0_2_2;
    A[419] = 0.005375764924376*G0_1_1 + 0.005375764924376*G0_1_2 + 0.005375764924376*G0_2_1 + 0.005375764924376*G0_2_2;
    A[420] = 0.011873655536850*G0_1_0 + 0.011873655536850*G0_1_1 - 0.009394540644540*G0_1_2 + 0.042536392362781*G0_2_0 + 0.021268196181391*G0_2_1 - 0.018789081289081*G0_2_2;
    A[421] = 0.002544354757896*G0_1_0 + 0.002544354757897*G0_1_1 - 0.003294613212148*G0_1_2 + 0.014287530563572*G0_2_0 + 0.008448562593528*G0_2_1 - 0.029260079715808*G0_2_2;
    A[422] = 0.011873655536850*G0_1_0 + 0.011873655536850*G0_1_1 - 0.009394540644540*G0_1_2 + 0.047755581609748*G0_2_0 + 0.026487385428357*G0_2_1 - 0.064130787872107*G0_2_2;
    A[423] = -0.042960451489097*G0_1_0 - 0.042960451489097*G0_1_1 - 0.000685018588664*G0_1_2 - 0.084550865800865*G0_2_0 - 0.042275432900432*G0_2_1 + 0.043971669405697*G0_2_2;
    A[424] = -0.042960451489097*G0_1_0 - 0.042960451489097*G0_1_1 - 0.000685018588665*G0_1_2 - 0.049321338383839*G0_2_0 - 0.007045905483406*G0_2_1 + 0.127315597693200*G0_2_2;
    A[425] = 0.124738623002512*G0_1_0 + 0.124738623002512*G0_1_1 + 0.028444581395971*G0_1_2 + 0.192588083213082*G0_2_0 + 0.096294041606541*G0_2_1 - 0.064456987200042*G0_2_2;
    A[426] = -0.011873655536850*G0_1_0 - 0.021268196181390*G0_1_2 - 0.042536392362781*G0_2_0 - 0.021268196181391*G0_2_1 - 0.061325473651862*G0_2_2;
    A[427] = -0.002544354757896*G0_1_0 - 0.005838967970044*G0_1_2 - 0.014287530563572*G0_2_0 - 0.005838967970044*G0_2_1 - 0.043547610279381*G0_2_2;
    A[428] = -0.011873655536850*G0_1_0 - 0.021268196181390*G0_1_2 - 0.047755581609748*G0_2_0 - 0.021268196181390*G0_2_1 - 0.111886369481854*G0_2_2;
    A[429] = 0.042960451489097*G0_1_0 + 0.042275432900433*G0_1_2 + 0.084550865800865*G0_2_0 + 0.042275432900433*G0_2_1 + 0.128522535206562*G0_2_2;
    A[430] = 0.042960451489097*G0_1_0 + 0.042275432900432*G0_1_2 + 0.049321338383839*G0_2_0 + 0.042275432900432*G0_2_1 + 0.176636936077039*G0_2_2;
    A[431] = -0.124738623002512*G0_1_0 - 0.096294041606541*G0_1_2 - 0.192588083213082*G0_2_0 - 0.096294041606541*G0_2_1 - 0.257045070413124*G0_2_2;
    A[432] = -0.011873655536850*G0_1_1 - 0.021268196181390*G0_1_2 - 0.021268196181391*G0_2_1 - 0.030662736825931*G0_2_2;
    A[433] = -0.002544354757896*G0_1_1 - 0.005838967970044*G0_1_2 - 0.005838967970044*G0_2_1 - 0.009133581182192*G0_2_2;
    A[434] = -0.011873655536850*G0_1_1 - 0.021268196181390*G0_1_2 - 0.021268196181391*G0_2_1 - 0.030662736825931*G0_2_2;
    A[435] = 0.042960451489097*G0_1_1 + 0.042275432900433*G0_1_2 + 0.042275432900433*G0_2_1 + 0.064261267603281*G0_2_2;
    A[436] = 0.042960451489097*G0_1_1 + 0.042275432900433*G0_1_2 + 0.042275432900433*G0_2_1 + 0.064261267603281*G0_2_2;
    A[437] = -0.124738623002512*G0_1_1 - 0.096294041606541*G0_1_2 - 0.096294041606541*G0_2_1 - 0.128522535206562*G0_2_2;
    A[438] = 0.009394540644541*G0_1_2 + 0.009394540644540*G0_2_1 + 0.018789081289081*G0_2_2;
    A[439] = 0.003294613212148*G0_1_2 + 0.003294613212148*G0_2_1 + 0.006589226424296*G0_2_2;
    A[440] = 0.009394540644540*G0_1_2 + 0.009394540644541*G0_2_1 + 0.018789081289081*G0_2_2;
    A[441] = 0.003294613212148*G0_1_2 + 0.003294613212148*G0_2_1 + 0.029260079715809*G0_2_2;
    A[442] = 0.003294613212148*G0_1_2 + 0.003294613212148*G0_2_1 + 0.029260079715808*G0_2_2;
    A[443] = 0.009394540644540*G0_1_2 + 0.009394540644540*G0_2_1 + 0.064130787872107*G0_2_2;
    A[444] = -0.002609594623483*G0_1_2 - 0.002609594623483*G0_2_1 - 0.050560895829993*G0_2_2;
    A[445] = -0.002609594623484*G0_1_2 - 0.002609594623484*G0_2_1 - 0.050560895829993*G0_2_2;
    A[446] = -0.002609594623483*G0_1_2 - 0.002609594623483*G0_2_1 - 0.156575677409009*G0_2_2;
    A[447] = -0.035229527417028*G0_1_2 - 0.035229527417026*G0_2_1 + 0.096228801740953*G0_2_2;
    A[448] = -0.004800349309898*G0_0_0 - 0.004800349309898*G0_0_1 - 0.004800349309898*G0_0_2 - 0.004800349309898*G0_2_0 - 0.004800349309898*G0_2_1 - 0.004800349309898*G0_2_2;
    A[449] = -0.017870503981615*G0_0_0 + 0.037257182439474*G0_2_0;
    A[450] = 0.004800349309898*G0_0_1 + 0.004800349309898*G0_2_1;
    A[451] = -0.010531019103068*G0_0_2 + 0.004800349309898*G0_2_2;
    A[452] = -0.010751529848752*G0_0_1 - 0.005375764924376*G0_0_2 - 0.005375764924376*G0_2_1 - 0.005375764924376*G0_2_2;
    A[453] = -0.013974379208754*G0_0_1 - 0.011684459926647*G0_0_2 - 0.002289919282107*G0_2_1 - 0.002289919282107*G0_2_2;
    A[454] = -0.011169064988509*G0_0_1 - 0.008879145706403*G0_0_2 - 0.002289919282107*G0_2_1 - 0.002289919282107*G0_2_2;
    A[455] = -0.032835224349981*G0_0_1 - 0.027459459425605*G0_0_2 - 0.005375764924376*G0_2_1 - 0.005375764924376*G0_2_2;
    A[456] = 0.179096479009672*G0_0_0 + 0.069911039963122*G0_0_2 + 0.069911039963122*G0_2_0 + 0.139822079926245*G0_2_2;
    A[457] = -0.147063705006412*G0_0_0 + 0.026383001643418*G0_0_2 - 0.038726384212495*G0_2_0 - 0.108637424175617*G0_2_2;
    A[458] = 0.100717304493345*G0_0_0 - 0.024634573245685*G0_0_2 + 0.018978276899284*G0_2_0 + 0.078894569454464*G0_2_2;
    A[459] = -0.032835224349981*G0_0_0 + 0.020915900907220*G0_0_2 - 0.005375764924376*G0_2_0 - 0.032835224349981*G0_2_2;
    A[460] = 0.089548239504836*G0_0_0 + 0.069911039963122*G0_0_1 + 0.069911039963122*G0_2_0 + 0.139822079926245*G0_2_1;
    A[461] = -0.057417605703195*G0_0_0 - 0.069911039963122*G0_0_1 - 0.038726384212495*G0_2_0 - 0.108637424175617*G0_2_1;
    A[462] = 0.028372817543824*G0_0_0 + 0.059916292555181*G0_0_1 + 0.018978276899284*G0_2_0 + 0.078894569454464*G0_2_1;
    A[463] = -0.005375764924376*G0_0_0 - 0.027459459425605*G0_0_1 - 0.005375764924376*G0_2_0 - 0.032835224349981*G0_2_1;
    A[464] = 0.010751529848752*G0_0_0 + 0.010751529848752*G0_0_1 + 0.005375764924376*G0_0_2 + 0.005375764924376*G0_2_0 + 0.005375764924376*G0_2_1;
    A[465] = 0.013974379208754*G0_0_0 + 0.013974379208754*G0_0_1 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_1;
    A[466] = 0.011169064988509*G0_0_0 + 0.011169064988509*G0_0_1 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_1;
    A[467] = 0.032835224349981*G0_0_0 + 0.032835224349981*G0_0_1 + 0.005375764924376*G0_0_2 + 0.005375764924376*G0_2_0 + 0.005375764924376*G0_2_1;
    A[468] = 0.005375764924376*G0_0_0 + 0.005375764924376*G0_0_2 + 0.005375764924376*G0_2_0 + 0.005375764924376*G0_2_2;
    A[469] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_2;
    A[470] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_2;
    A[471] = 0.005375764924376*G0_0_0 + 0.005375764924376*G0_0_2 + 0.005375764924376*G0_2_0 + 0.005375764924376*G0_2_2;
    A[472] = 0.022083694501229*G0_0_0 + 0.027459459425605*G0_0_1 + 0.027459459425605*G0_0_2 + 0.027459459425605*G0_2_0 + 0.032835224349980*G0_2_1 + 0.032835224349980*G0_2_2;
    A[473] = -0.031543475011356*G0_0_0 - 0.059916292555181*G0_0_1 - 0.059916292555181*G0_0_2 - 0.059916292555180*G0_2_0 - 0.078894569454464*G0_2_1 - 0.078894569454464*G0_2_2;
    A[474] = 0.012493434259927*G0_0_0 + 0.069911039963122*G0_0_1 + 0.069911039963122*G0_0_2 + 0.069911039963122*G0_2_0 + 0.108637424175617*G0_2_1 + 0.108637424175617*G0_2_2;
    A[475] = 0.019637199541714*G0_0_0 - 0.069911039963122*G0_0_1 - 0.069911039963122*G0_0_2 - 0.069911039963122*G0_2_0 - 0.139822079926244*G0_2_1 - 0.139822079926245*G0_2_2;
    A[476] = -0.064456987200042*G0_0_0 + 0.192588083213082*G0_0_1 + 0.096294041606541*G0_0_2 + 0.028444581395971*G0_2_0 + 0.124738623002511*G0_2_1 + 0.124738623002511*G0_2_2;
    A[477] = 0.043971669405697*G0_0_0 - 0.084550865800865*G0_0_1 - 0.042275432900433*G0_0_2 - 0.000685018588665*G0_2_0 - 0.042960451489097*G0_2_1 - 0.042960451489097*G0_2_2;
    A[478] = -0.018789081289081*G0_0_0 + 0.042536392362781*G0_0_1 + 0.021268196181390*G0_0_2 - 0.009394540644541*G0_2_0 + 0.011873655536850*G0_2_1 + 0.011873655536850*G0_2_2;
    A[479] = 0.127315597693200*G0_0_0 - 0.049321338383838*G0_0_1 - 0.007045905483406*G0_0_2 - 0.000685018588665*G0_2_0 - 0.042960451489097*G0_2_1 - 0.042960451489097*G0_2_2;
    A[480] = -0.029260079715808*G0_0_0 + 0.014287530563572*G0_0_1 + 0.008448562593528*G0_0_2 - 0.003294613212148*G0_2_0 + 0.002544354757896*G0_2_1 + 0.002544354757897*G0_2_2;
    A[481] = -0.064130787872107*G0_0_0 + 0.047755581609748*G0_0_1 + 0.026487385428357*G0_0_2 - 0.009394540644541*G0_2_0 + 0.011873655536850*G0_2_1 + 0.011873655536849*G0_2_2;
    A[482] = 0.018789081289081*G0_0_0 + 0.009394540644541*G0_0_2 + 0.009394540644541*G0_2_0;
    A[483] = 0.006589226424296*G0_0_0 + 0.003294613212148*G0_0_2 + 0.003294613212148*G0_2_0;
    A[484] = 0.018789081289081*G0_0_0 + 0.009394540644541*G0_0_2 + 0.009394540644540*G0_2_0;
    A[485] = 0.029260079715809*G0_0_0 + 0.003294613212148*G0_0_2 + 0.003294613212148*G0_2_0;
    A[486] = 0.029260079715808*G0_0_0 + 0.003294613212148*G0_0_2 + 0.003294613212148*G0_2_0;
    A[487] = 0.064130787872107*G0_0_0 + 0.009394540644541*G0_0_2 + 0.009394540644541*G0_2_0;
    A[488] = -0.061325473651862*G0_0_0 - 0.042536392362781*G0_0_1 - 0.021268196181390*G0_0_2 - 0.021268196181390*G0_2_0 - 0.011873655536850*G0_2_1;
    A[489] = 0.128522535206562*G0_0_0 + 0.084550865800865*G0_0_1 + 0.042275432900433*G0_0_2 + 0.042275432900432*G0_2_0 + 0.042960451489096*G0_2_1;
    A[490] = -0.257045070413123*G0_0_0 - 0.192588083213081*G0_0_1 - 0.096294041606541*G0_0_2 - 0.096294041606540*G0_2_0 - 0.124738623002510*G0_2_1;
    A[491] = -0.043547610279381*G0_0_0 - 0.014287530563572*G0_0_1 - 0.005838967970044*G0_0_2 - 0.005838967970044*G0_2_0 - 0.002544354757896*G0_2_1;
    A[492] = 0.176636936077038*G0_0_0 + 0.049321338383838*G0_0_1 + 0.042275432900433*G0_0_2 + 0.042275432900432*G0_2_0 + 0.042960451489097*G0_2_1;
    A[493] = -0.111886369481855*G0_0_0 - 0.047755581609748*G0_0_1 - 0.021268196181390*G0_0_2 - 0.021268196181390*G0_2_0 - 0.011873655536850*G0_2_1;
    A[494] = -0.030662736825931*G0_0_0 - 0.021268196181390*G0_0_2 - 0.021268196181390*G0_2_0 - 0.011873655536849*G0_2_2;
    A[495] = 0.064261267603281*G0_0_0 + 0.042275432900432*G0_0_2 + 0.042275432900432*G0_2_0 + 0.042960451489096*G0_2_2;
    A[496] = -0.128522535206562*G0_0_0 - 0.096294041606541*G0_0_2 - 0.096294041606540*G0_2_0 - 0.124738623002510*G0_2_2;
    A[497] = -0.009133581182193*G0_0_0 - 0.005838967970044*G0_0_2 - 0.005838967970045*G0_2_0 - 0.002544354757896*G0_2_2;
    A[498] = 0.064261267603281*G0_0_0 + 0.042275432900433*G0_0_2 + 0.042275432900433*G0_2_0 + 0.042960451489097*G0_2_2;
    A[499] = -0.030662736825931*G0_0_0 - 0.021268196181390*G0_0_2 - 0.021268196181390*G0_2_0 - 0.011873655536850*G0_2_2;
    A[500] = -0.050560895829993*G0_0_0 - 0.002609594623484*G0_0_2 - 0.002609594623484*G0_2_0;
    A[501] = 0.096228801740954*G0_0_0 - 0.035229527417027*G0_0_2 - 0.035229527417027*G0_2_0;
    A[502] = -0.050560895829993*G0_0_0 - 0.002609594623484*G0_0_2 - 0.002609594623483*G0_2_0;
    A[503] = -0.156575677409009*G0_0_0 - 0.002609594623483*G0_0_2 - 0.002609594623482*G0_2_0;
    A[504] = -0.003365072266982*G0_0_0 - 0.003365072266982*G0_0_1 - 0.003365072266982*G0_0_2 - 0.003365072266982*G0_2_0 - 0.003365072266982*G0_2_1 - 0.003365072266982*G0_2_2;
    A[505] = 0.021469134967399*G0_0_0 - 0.033658551453690*G0_2_0;
    A[506] = 0.003365072266982*G0_0_1 + 0.003365072266982*G0_2_1;
    A[507] = 0.023263231271044*G0_0_2 - 0.015554488753273*G0_2_2;
    A[508] = -0.013974379208754*G0_0_1 - 0.002289919282107*G0_0_2 - 0.011684459926647*G0_2_1 - 0.002289919282107*G0_2_2;
    A[509] = 0.026304713804713*G0_0_1 + 0.013152356902357*G0_0_2 + 0.013152356902356*G0_2_1 + 0.013217596767944*G0_2_2;
    A[510] = 0.005232237220084*G0_0_1 + 0.005780252091016*G0_0_2 - 0.000548014870931*G0_2_1 - 0.000482775005344*G0_2_2;
    A[511] = 0.078894569454465*G0_0_1 + 0.059916292555181*G0_0_2 + 0.018978276899283*G0_2_1 + 0.028372817543824*G0_2_2;
    A[512] = -0.147063705006412*G0_0_0 - 0.038726384212495*G0_0_2 + 0.026383001643419*G0_2_0 - 0.108637424175617*G0_2_2;
    A[513] = 0.304226541205705*G0_0_0 + 0.078131263027095*G0_0_2 + 0.078131263027095*G0_2_0 + 0.281001149056702*G0_2_2;
    A[514] = -0.204187731314466*G0_0_0 + 0.015305272466731*G0_0_2 - 0.036495180809416*G0_2_0 - 0.204187731314465*G0_2_2;
    A[515] = 0.078894569454465*G0_0_0 - 0.024634573245684*G0_0_2 + 0.018978276899284*G0_2_0 + 0.100717304493345*G0_2_2;
    A[516] = -0.057417605703195*G0_0_0 - 0.038726384212495*G0_0_1 - 0.069911039963122*G0_2_0 - 0.108637424175617*G0_2_1;
    A[517] = 0.005062613569558*G0_0_0 + 0.004801654107210*G0_0_1 + 0.004801654107210*G0_2_0 + 0.009603308214419*G0_2_1;
    A[518] = -0.000482775005344*G0_0_0 + 0.005780252091016*G0_0_1 - 0.000548014870931*G0_2_0 + 0.005232237220084*G0_2_1;
    A[519] = -0.002289919282107*G0_0_0 - 0.008879145706402*G0_0_1 - 0.002289919282107*G0_2_0 - 0.011169064988509*G0_2_1;
    A[520] = 0.013974379208754*G0_0_0 + 0.013974379208754*G0_0_1 + 0.011684459926647*G0_0_2 + 0.011684459926647*G0_2_0 + 0.011684459926647*G0_2_1 + 0.009394540644541*G0_2_2;
    A[521] = -0.026304713804713*G0_0_0 - 0.026304713804714*G0_0_1 - 0.013152356902357*G0_0_2 - 0.013152356902357*G0_2_0 - 0.013152356902357*G0_2_1 + 0.000065239865587*G0_2_2;
    A[522] = -0.005232237220084*G0_0_0 - 0.005232237220084*G0_0_1 + 0.000548014870932*G0_0_2 + 0.000548014870932*G0_2_0 + 0.000548014870932*G0_2_1 + 0.000065239865587*G0_2_2;
    A[523] = -0.078894569454465*G0_0_0 - 0.078894569454465*G0_0_1 - 0.018978276899284*G0_0_2 - 0.018978276899284*G0_2_0 - 0.018978276899284*G0_2_1 + 0.009394540644540*G0_2_2;
    A[524] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_2;
    A[525] = 0.001787572317086*G0_0_0 + 0.001787572317086*G0_0_2 + 0.001787572317086*G0_2_0 + 0.001787572317086*G0_2_2;
    A[526] = 0.001787572317086*G0_0_0 + 0.001787572317086*G0_0_2 + 0.001787572317086*G0_2_0 + 0.001787572317086*G0_2_2;
    A[527] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_2;
    A[528] = 0.006589226424296*G0_0_0 + 0.008879145706403*G0_0_1 + 0.008879145706403*G0_0_2 + 0.008879145706403*G0_2_0 + 0.011169064988510*G0_2_1 + 0.011169064988510*G0_2_2;
    A[529] = -0.006263027096361*G0_0_0 - 0.005780252091016*G0_0_1 - 0.005780252091016*G0_0_2 - 0.005780252091017*G0_2_0 - 0.005232237220085*G0_2_1 - 0.005232237220085*G0_2_2;
    A[530] = 0.000260959462349*G0_0_0 - 0.004801654107209*G0_0_1 - 0.004801654107209*G0_0_2 - 0.004801654107209*G0_2_0 - 0.009603308214419*G0_2_1 - 0.009603308214419*G0_2_2;
    A[531] = -0.018691221490701*G0_0_0 + 0.038726384212495*G0_0_1 + 0.038726384212495*G0_0_2 + 0.038726384212495*G0_2_0 + 0.108637424175617*G0_2_1 + 0.108637424175617*G0_2_2;
    A[532] = 0.132306447410613*G0_0_0 + 0.010960297418630*G0_0_1 - 0.062369311501255*G0_0_2 + 0.073329608919886*G0_2_0 + 0.146659217839772*G0_2_1 - 0.124738623002510*G0_2_2;
    A[533] = -0.043645470077762*G0_0_0 - 0.080832193462401*G0_0_1 - 0.006491366625915*G0_0_2 - 0.033892110172492*G0_2_0 - 0.108232937008978*G0_2_1 - 0.003522952741703*G0_2_2;
    A[534] = 0.014874689353856*G0_0_0 + 0.040318236932819*G0_0_1 + 0.001239557446155*G0_0_2 + 0.014939929219443*G0_2_0 + 0.054018608706108*G0_2_1 + 0.001174317580568*G0_2_2;
    A[535] = -0.166948816037356*G0_0_0 + 0.167731694424402*G0_0_1 + 0.083865847212201*G0_0_2 - 0.006165167297979*G0_2_0 + 0.077700679914221*G0_2_1 + 0.182410664181496*G0_2_2;
    A[536] = 0.018984800885842*G0_0_0 - 0.037773882174924*G0_0_1 - 0.018886941087463*G0_0_2 + 0.009492400442921*G0_2_0 - 0.009394540644540*G0_2_1 - 0.015592327875314*G0_2_2;
    A[537] = 0.127087258163646*G0_0_0 - 0.082332710370904*G0_0_1 - 0.046385544432419*G0_0_2 + 0.037773882174923*G0_2_0 + 0.001826716236438*G0_2_1 - 0.051017574889102*G0_2_2;
    A[538] = -0.014874689353856*G0_0_0 - 0.014939929219443*G0_0_2 - 0.014939929219443*G0_2_0 - 0.015005169085030*G0_2_2;
    A[539] = 0.004501550725509*G0_0_0 + 0.001924576034819*G0_0_2 + 0.001924576034819*G0_2_0 - 0.000652398655871*G0_2_2;
    A[540] = -0.014874689353856*G0_0_0 - 0.014939929219443*G0_0_2 - 0.014939929219443*G0_2_0 - 0.015005169085030*G0_2_2;
    A[541] = -0.018984800885842*G0_0_0 - 0.009492400442921*G0_0_2 - 0.009492400442921*G0_2_0 - 0.000652398655870*G0_2_2;
    A[542] = -0.018984800885842*G0_0_0 - 0.009492400442921*G0_0_2 - 0.009492400442921*G0_2_0 - 0.000652398655871*G0_2_2;
    A[543] = -0.127087258163646*G0_0_0 - 0.037773882174924*G0_0_2 - 0.037773882174923*G0_2_0 - 0.015005169085030*G0_2_2;
    A[544] = -0.025443547578964*G0_0_0 - 0.040318236932820*G0_0_1 - 0.039078679486665*G0_0_2 - 0.039078679486665*G0_2_0 - 0.054018608706109*G0_2_1 - 0.052844291125541*G0_2_2;
    A[545] = 0.037186723384640*G0_0_0 + 0.080832193462401*G0_0_1 + 0.074340826836486*G0_0_2 + 0.074340826836486*G0_2_0 + 0.108232937008978*G0_2_1 + 0.104709984267275*G0_2_2;
    A[546] = 0.121346149991982*G0_0_0 - 0.010960297418631*G0_0_1 - 0.073329608919886*G0_0_2 - 0.073329608919887*G0_2_0 - 0.146659217839773*G0_2_1 - 0.271397840842283*G0_2_2;
    A[547] = 0.056758683060765*G0_0_0 + 0.037773882174923*G0_0_1 + 0.018886941087462*G0_0_2 + 0.018886941087461*G0_2_0 + 0.009394540644541*G0_2_1 - 0.006197787230773*G0_2_2;
    A[548] = -0.334680510461757*G0_0_0 - 0.167731694424402*G0_0_1 - 0.083865847212201*G0_0_2 - 0.083865847212200*G0_2_0 - 0.077700679914221*G0_2_1 + 0.104709984267275*G0_2_2;
    A[549] = 0.209419968534550*G0_0_0 + 0.082332710370904*G0_0_1 + 0.035947165938485*G0_0_2 + 0.035947165938484*G0_2_0 - 0.001826716236439*G0_2_1 - 0.052844291125541*G0_2_2;
    A[550] = -0.001304797311742*G0_0_0 - 0.001239557446155*G0_0_2 - 0.001239557446155*G0_2_0 - 0.001174317580568*G0_2_2;
    A[551] = 0.008807381854257*G0_0_0 + 0.006491366625915*G0_0_2 + 0.006491366625916*G0_2_0 + 0.003522952741703*G0_2_2;
    A[552] = 0.047625101878573*G0_0_0 + 0.062369311501255*G0_0_2 + 0.062369311501255*G0_2_0 + 0.124738623002510*G0_2_2;
    A[553] = -0.015657567740901*G0_0_0 - 0.013080593050211*G0_0_2 - 0.013080593050211*G0_2_0 - 0.010503618359521*G0_2_2;
    A[554] = 0.008807381854257*G0_0_0 + 0.006491366625915*G0_0_2 + 0.006491366625915*G0_2_0 + 0.003522952741703*G0_2_2;
    A[555] = -0.001304797311742*G0_0_0 - 0.001239557446155*G0_0_2 - 0.001239557446155*G0_2_0 - 0.001174317580568*G0_2_2;
    A[556] = 0.039143919352252*G0_0_0 + 0.031967534137673*G0_0_2 + 0.031967534137673*G0_2_0 + 0.026095946234835*G0_2_2;
    A[557] = -0.156575677409009*G0_0_0 - 0.090357213838116*G0_0_2 - 0.090357213838116*G0_2_0 - 0.185933616923199*G0_2_2;
    A[558] = 0.039143919352252*G0_0_0 + 0.031967534137673*G0_0_2 + 0.031967534137673*G0_2_0 + 0.026095946234835*G0_2_2;
    A[559] = 0.185933616923198*G0_0_0 + 0.015657567740901*G0_0_2 + 0.015657567740899*G0_2_0 + 0.026095946234834*G0_2_2;
    A[560] = -0.003365072266982*G0_0_0 - 0.003365072266982*G0_0_1 - 0.003365072266982*G0_0_2 - 0.003365072266982*G0_2_0 - 0.003365072266982*G0_2_1 - 0.003365072266982*G0_2_2;
    A[561] = -0.015554488753273*G0_0_0 + 0.023263231271043*G0_2_0;
    A[562] = 0.003365072266982*G0_0_1 + 0.003365072266982*G0_2_1;
    A[563] = -0.033658551453690*G0_0_2 + 0.021469134967399*G0_2_2;
    A[564] = -0.011169064988509*G0_0_1 - 0.002289919282107*G0_0_2 - 0.008879145706403*G0_2_1 - 0.002289919282107*G0_2_2;
    A[565] = 0.005232237220084*G0_0_1 - 0.000548014870931*G0_0_2 + 0.005780252091016*G0_2_1 - 0.000482775005344*G0_2_2;
    A[566] = 0.009603308214419*G0_0_1 + 0.004801654107209*G0_0_2 + 0.004801654107210*G0_2_1 + 0.005062613569557*G0_2_2;
    A[567] = -0.108637424175618*G0_0_1 - 0.069911039963123*G0_0_2 - 0.038726384212495*G0_2_1 - 0.057417605703195*G0_2_2;
    A[568] = 0.100717304493345*G0_0_0 + 0.018978276899284*G0_0_2 - 0.024634573245685*G0_2_0 + 0.078894569454464*G0_2_2;
    A[569] = -0.204187731314466*G0_0_0 - 0.036495180809416*G0_0_2 + 0.015305272466731*G0_2_0 - 0.204187731314465*G0_2_2;
    A[570] = 0.281001149056703*G0_0_0 + 0.078131263027095*G0_0_2 + 0.078131263027095*G0_2_0 + 0.304226541205705*G0_2_2;
    A[571] = -0.108637424175618*G0_0_0 + 0.026383001643418*G0_0_2 - 0.038726384212495*G0_2_0 - 0.147063705006412*G0_2_2;
    A[572] = 0.028372817543824*G0_0_0 + 0.018978276899283*G0_0_1 + 0.059916292555181*G0_2_0 + 0.078894569454464*G0_2_1;
    A[573] = -0.000482775005344*G0_0_0 - 0.000548014870932*G0_0_1 + 0.005780252091016*G0_2_0 + 0.005232237220085*G0_2_1;
    A[574] = 0.013217596767944*G0_0_0 + 0.013152356902357*G0_0_1 + 0.013152356902357*G0_2_0 + 0.026304713804714*G0_2_1;
    A[575] = -0.002289919282107*G0_0_0 - 0.011684459926648*G0_0_1 - 0.002289919282107*G0_2_0 - 0.013974379208754*G0_2_1;
    A[576] = 0.011169064988509*G0_0_0 + 0.011169064988509*G0_0_1 + 0.008879145706402*G0_0_2 + 0.008879145706402*G0_2_0 + 0.008879145706402*G0_2_1 + 0.006589226424296*G0_2_2;
    A[577] = -0.005232237220084*G0_0_0 - 0.005232237220084*G0_0_1 - 0.005780252091016*G0_0_2 - 0.005780252091016*G0_2_0 - 0.005780252091015*G0_2_1 - 0.006263027096360*G0_2_2;
    A[578] = -0.009603308214420*G0_0_0 - 0.009603308214420*G0_0_1 - 0.004801654107210*G0_0_2 - 0.004801654107210*G0_2_0 - 0.004801654107210*G0_2_1 + 0.000260959462348*G0_2_2;
    A[579] = 0.108637424175618*G0_0_0 + 0.108637424175618*G0_0_1 + 0.038726384212495*G0_0_2 + 0.038726384212495*G0_2_0 + 0.038726384212495*G0_2_1 - 0.018691221490700*G0_2_2;
    A[580] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_2;
    A[581] = 0.001787572317086*G0_0_0 + 0.001787572317086*G0_0_2 + 0.001787572317086*G0_2_0 + 0.001787572317086*G0_2_2;
    A[582] = 0.001787572317086*G0_0_0 + 0.001787572317086*G0_0_2 + 0.001787572317086*G0_2_0 + 0.001787572317086*G0_2_2;
    A[583] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_2;
    A[584] = 0.009394540644540*G0_0_0 + 0.011684459926647*G0_0_1 + 0.011684459926647*G0_0_2 + 0.011684459926647*G0_2_0 + 0.013974379208754*G0_2_1 + 0.013974379208754*G0_2_2;
    A[585] = 0.000065239865587*G0_0_0 - 0.013152356902357*G0_0_1 - 0.013152356902357*G0_0_2 - 0.013152356902356*G0_2_0 - 0.026304713804713*G0_2_1 - 0.026304713804713*G0_2_2;
    A[586] = 0.000065239865587*G0_0_0 + 0.000548014870931*G0_0_1 + 0.000548014870931*G0_0_2 + 0.000548014870931*G0_2_0 - 0.005232237220085*G0_2_1 - 0.005232237220085*G0_2_2;
    A[587] = 0.009394540644541*G0_0_0 - 0.018978276899284*G0_0_1 - 0.018978276899283*G0_0_2 - 0.018978276899283*G0_2_0 - 0.078894569454464*G0_2_1 - 0.078894569454464*G0_2_2;
    A[588] = -0.051017574889102*G0_0_0 + 0.001826716236438*G0_0_1 + 0.037773882174923*G0_0_2 - 0.046385544432419*G0_2_0 - 0.082332710370904*G0_2_1 + 0.127087258163645*G0_2_2;
    A[589] = -0.015592327875314*G0_0_0 - 0.009394540644541*G0_0_1 + 0.009492400442921*G0_0_2 - 0.018886941087462*G0_2_0 - 0.037773882174924*G0_2_1 + 0.018984800885842*G0_2_2;
    A[590] = 0.001174317580568*G0_0_0 + 0.054018608706109*G0_0_1 + 0.014939929219443*G0_0_2 + 0.001239557446155*G0_2_0 + 0.040318236932820*G0_2_1 + 0.014874689353856*G0_2_2;
    A[591] = 0.182410664181496*G0_0_0 + 0.077700679914221*G0_0_1 - 0.006165167297980*G0_0_2 + 0.083865847212200*G0_2_0 + 0.167731694424401*G0_2_1 - 0.166948816037356*G0_2_2;
    A[592] = -0.003522952741702*G0_0_0 - 0.108232937008978*G0_0_1 - 0.033892110172491*G0_0_2 - 0.006491366625915*G0_2_0 - 0.080832193462401*G0_2_1 - 0.043645470077761*G0_2_2;
    A[593] = -0.124738623002511*G0_0_0 + 0.146659217839772*G0_0_1 + 0.073329608919886*G0_0_2 - 0.062369311501255*G0_2_0 + 0.010960297418630*G0_2_1 + 0.132306447410612*G0_2_2;
    A[594] = -0.001174317580568*G0_0_0 - 0.001239557446154*G0_0_2 - 0.001239557446154*G0_2_0 - 0.001304797311741*G0_2_2;
    A[595] = -0.010503618359521*G0_0_0 - 0.013080593050211*G0_0_2 - 0.013080593050211*G0_2_0 - 0.015657567740901*G0_2_2;
    A[596] = -0.001174317580568*G0_0_0 - 0.001239557446155*G0_0_2 - 0.001239557446155*G0_2_0 - 0.001304797311742*G0_2_2;
    A[597] = 0.003522952741702*G0_0_0 + 0.006491366625915*G0_0_2 + 0.006491366625914*G0_2_0 + 0.008807381854256*G0_2_2;
    A[598] = 0.003522952741702*G0_0_0 + 0.006491366625915*G0_0_2 + 0.006491366625915*G0_2_0 + 0.008807381854257*G0_2_2;
    A[599] = 0.124738623002511*G0_0_0 + 0.062369311501256*G0_0_2 + 0.062369311501255*G0_2_0 + 0.047625101878574*G0_2_2;
    A[600] = -0.052844291125541*G0_0_0 - 0.054018608706108*G0_0_1 - 0.039078679486665*G0_0_2 - 0.039078679486665*G0_2_0 - 0.040318236932820*G0_2_1 - 0.025443547578964*G0_2_2;
    A[601] = -0.006197787230773*G0_0_0 + 0.009394540644540*G0_0_1 + 0.018886941087462*G0_0_2 + 0.018886941087461*G0_2_0 + 0.037773882174923*G0_2_1 + 0.056758683060766*G0_2_2;
    A[602] = -0.052844291125540*G0_0_0 - 0.001826716236438*G0_0_1 + 0.035947165938485*G0_0_2 + 0.035947165938486*G0_2_0 + 0.082332710370905*G0_2_1 + 0.209419968534550*G0_2_2;
    A[603] = 0.104709984267275*G0_0_0 + 0.108232937008978*G0_0_1 + 0.074340826836486*G0_0_2 + 0.074340826836486*G0_2_0 + 0.080832193462401*G0_2_1 + 0.037186723384639*G0_2_2;
    A[604] = 0.104709984267274*G0_0_0 - 0.077700679914220*G0_0_1 - 0.083865847212201*G0_0_2 - 0.083865847212201*G0_2_0 - 0.167731694424401*G0_2_1 - 0.334680510461758*G0_2_2;
    A[605] = -0.271397840842283*G0_0_0 - 0.146659217839772*G0_0_1 - 0.073329608919886*G0_0_2 - 0.073329608919885*G0_2_0 - 0.010960297418630*G0_2_1 + 0.121346149991983*G0_2_2;
    A[606] = -0.015005169085030*G0_0_0 - 0.014939929219443*G0_0_2 - 0.014939929219443*G0_2_0 - 0.014874689353856*G0_2_2;
    A[607] = -0.000652398655871*G0_0_0 - 0.009492400442921*G0_0_2 - 0.009492400442922*G0_2_0 - 0.018984800885843*G0_2_2;
    A[608] = -0.015005169085030*G0_0_0 - 0.037773882174923*G0_0_2 - 0.037773882174923*G0_2_0 - 0.127087258163645*G0_2_2;
    A[609] = -0.000652398655871*G0_0_0 + 0.001924576034819*G0_0_2 + 0.001924576034819*G0_2_0 + 0.004501550725509*G0_2_2;
    A[610] = -0.000652398655871*G0_0_0 - 0.009492400442921*G0_0_2 - 0.009492400442921*G0_2_0 - 0.018984800885842*G0_2_2;
    A[611] = -0.015005169085030*G0_0_0 - 0.014939929219443*G0_0_2 - 0.014939929219443*G0_2_0 - 0.014874689353856*G0_2_2;
    A[612] = 0.026095946234835*G0_0_0 + 0.031967534137673*G0_0_2 + 0.031967534137673*G0_2_0 + 0.039143919352252*G0_2_2;
    A[613] = 0.026095946234835*G0_0_0 + 0.015657567740901*G0_0_2 + 0.015657567740901*G0_2_0 + 0.185933616923199*G0_2_2;
    A[614] = 0.026095946234835*G0_0_0 + 0.031967534137672*G0_0_2 + 0.031967534137673*G0_2_0 + 0.039143919352252*G0_2_2;
    A[615] = -0.185933616923198*G0_0_0 - 0.090357213838116*G0_0_2 - 0.090357213838114*G0_2_0 - 0.156575677409009*G0_2_2;
    A[616] = -0.004800349309898*G0_0_0 - 0.004800349309898*G0_0_1 - 0.004800349309898*G0_0_2 - 0.004800349309898*G0_2_0 - 0.004800349309898*G0_2_1 - 0.004800349309898*G0_2_2;
    A[617] = 0.004800349309898*G0_0_0 - 0.010531019103068*G0_2_0;
    A[618] = 0.004800349309898*G0_0_1 + 0.004800349309898*G0_2_1;
    A[619] = 0.037257182439474*G0_0_2 - 0.017870503981615*G0_2_2;
    A[620] = -0.032835224349981*G0_0_1 - 0.005375764924376*G0_0_2 - 0.027459459425605*G0_2_1 - 0.005375764924376*G0_2_2;
    A[621] = 0.078894569454465*G0_0_1 + 0.018978276899284*G0_0_2 + 0.059916292555181*G0_2_1 + 0.028372817543824*G0_2_2;
    A[622] = -0.108637424175618*G0_0_1 - 0.038726384212495*G0_0_2 - 0.069911039963123*G0_2_1 - 0.057417605703195*G0_2_2;
    A[623] = 0.139822079926246*G0_0_1 + 0.069911039963123*G0_0_2 + 0.069911039963123*G0_2_1 + 0.089548239504836*G0_2_2;
    A[624] = -0.032835224349981*G0_0_0 - 0.005375764924376*G0_0_2 + 0.020915900907220*G0_2_0 - 0.032835224349981*G0_2_2;
    A[625] = 0.078894569454465*G0_0_0 + 0.018978276899284*G0_0_2 - 0.024634573245684*G0_2_0 + 0.100717304493345*G0_2_2;
    A[626] = -0.108637424175618*G0_0_0 - 0.038726384212495*G0_0_2 + 0.026383001643418*G0_2_0 - 0.147063705006412*G0_2_2;
    A[627] = 0.139822079926246*G0_0_0 + 0.069911039963123*G0_0_2 + 0.069911039963123*G0_2_0 + 0.179096479009672*G0_2_2;
    A[628] = -0.005375764924376*G0_0_0 - 0.005375764924376*G0_0_1 - 0.027459459425605*G0_2_0 - 0.032835224349981*G0_2_1;
    A[629] = -0.002289919282107*G0_0_0 - 0.002289919282107*G0_0_1 - 0.008879145706403*G0_2_0 - 0.011169064988509*G0_2_1;
    A[630] = -0.002289919282107*G0_0_0 - 0.002289919282107*G0_0_1 - 0.011684459926647*G0_2_0 - 0.013974379208754*G0_2_1;
    A[631] = -0.005375764924376*G0_0_0 - 0.005375764924376*G0_0_1 - 0.005375764924376*G0_2_0 - 0.010751529848752*G0_2_1;
    A[632] = 0.032835224349981*G0_0_0 + 0.032835224349981*G0_0_1 + 0.027459459425605*G0_0_2 + 0.027459459425605*G0_2_0 + 0.027459459425605*G0_2_1 + 0.022083694501229*G0_2_2;
    A[633] = -0.078894569454465*G0_0_0 - 0.078894569454465*G0_0_1 - 0.059916292555181*G0_0_2 - 0.059916292555181*G0_2_0 - 0.059916292555181*G0_2_1 - 0.031543475011357*G0_2_2;
    A[634] = 0.108637424175618*G0_0_0 + 0.108637424175618*G0_0_1 + 0.069911039963123*G0_0_2 + 0.069911039963123*G0_2_0 + 0.069911039963123*G0_2_1 + 0.012493434259928*G0_2_2;
    A[635] = -0.139822079926246*G0_0_0 - 0.139822079926246*G0_0_1 - 0.069911039963123*G0_0_2 - 0.069911039963123*G0_2_0 - 0.069911039963123*G0_2_1 + 0.019637199541713*G0_2_2;
    A[636] = 0.005375764924376*G0_0_0 + 0.005375764924376*G0_0_2 + 0.005375764924376*G0_2_0 + 0.005375764924376*G0_2_2;
    A[637] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_2;
    A[638] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_2;
    A[639] = 0.005375764924376*G0_0_0 + 0.005375764924376*G0_0_2 + 0.005375764924376*G0_2_0 + 0.005375764924376*G0_2_2;
    A[640] = 0.005375764924376*G0_0_1 + 0.005375764924376*G0_0_2 + 0.005375764924376*G0_2_0 + 0.010751529848752*G0_2_1 + 0.010751529848752*G0_2_2;
    A[641] = 0.002289919282107*G0_0_1 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.013974379208754*G0_2_1 + 0.013974379208754*G0_2_2;
    A[642] = 0.002289919282107*G0_0_1 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.011169064988510*G0_2_1 + 0.011169064988510*G0_2_2;
    A[643] = 0.005375764924376*G0_0_1 + 0.005375764924376*G0_0_2 + 0.005375764924376*G0_2_0 + 0.032835224349981*G0_2_1 + 0.032835224349981*G0_2_2;
    A[644] = 0.011873655536850*G0_0_0 + 0.011873655536850*G0_0_1 - 0.009394540644540*G0_0_2 + 0.026487385428358*G0_2_0 + 0.047755581609748*G0_2_1 - 0.064130787872107*G0_2_2;
    A[645] = 0.002544354757896*G0_0_0 + 0.002544354757897*G0_0_1 - 0.003294613212148*G0_0_2 + 0.008448562593528*G0_2_0 + 0.014287530563573*G0_2_1 - 0.029260079715808*G0_2_2;
    A[646] = 0.011873655536850*G0_0_0 + 0.011873655536850*G0_0_1 - 0.009394540644540*G0_0_2 + 0.021268196181390*G0_2_0 + 0.042536392362781*G0_2_1 - 0.018789081289081*G0_2_2;
    A[647] = -0.042960451489097*G0_0_0 - 0.042960451489097*G0_0_1 - 0.000685018588664*G0_0_2 - 0.007045905483405*G0_2_0 - 0.049321338383838*G0_2_1 + 0.127315597693201*G0_2_2;
    A[648] = -0.042960451489097*G0_0_0 - 0.042960451489097*G0_0_1 - 0.000685018588665*G0_0_2 - 0.042275432900433*G0_2_0 - 0.084550865800866*G0_2_1 + 0.043971669405696*G0_2_2;
    A[649] = 0.124738623002512*G0_0_0 + 0.124738623002512*G0_0_1 + 0.028444581395971*G0_0_2 + 0.096294041606541*G0_2_0 + 0.192588083213082*G0_2_1 - 0.064456987200042*G0_2_2;
    A[650] = -0.011873655536850*G0_0_0 - 0.021268196181391*G0_0_2 - 0.021268196181391*G0_2_0 - 0.030662736825931*G0_2_2;
    A[651] = -0.002544354757896*G0_0_0 - 0.005838967970044*G0_0_2 - 0.005838967970044*G0_2_0 - 0.009133581182192*G0_2_2;
    A[652] = -0.011873655536850*G0_0_0 - 0.021268196181390*G0_0_2 - 0.021268196181390*G0_2_0 - 0.030662736825931*G0_2_2;
    A[653] = 0.042960451489097*G0_0_0 + 0.042275432900433*G0_0_2 + 0.042275432900433*G0_2_0 + 0.064261267603281*G0_2_2;
    A[654] = 0.042960451489097*G0_0_0 + 0.042275432900432*G0_0_2 + 0.042275432900433*G0_2_0 + 0.064261267603281*G0_2_2;
    A[655] = -0.124738623002512*G0_0_0 - 0.096294041606541*G0_0_2 - 0.096294041606541*G0_2_0 - 0.128522535206562*G0_2_2;
    A[656] = -0.011873655536850*G0_0_1 - 0.021268196181390*G0_0_2 - 0.021268196181391*G0_2_0 - 0.042536392362781*G0_2_1 - 0.061325473651862*G0_2_2;
    A[657] = -0.002544354757896*G0_0_1 - 0.005838967970044*G0_0_2 - 0.005838967970044*G0_2_0 - 0.014287530563572*G0_2_1 - 0.043547610279381*G0_2_2;
    A[658] = -0.011873655536850*G0_0_1 - 0.021268196181390*G0_0_2 - 0.021268196181391*G0_2_0 - 0.047755581609748*G0_2_1 - 0.111886369481855*G0_2_2;
    A[659] = 0.042960451489097*G0_0_1 + 0.042275432900433*G0_0_2 + 0.042275432900433*G0_2_0 + 0.084550865800865*G0_2_1 + 0.128522535206563*G0_2_2;
    A[660] = 0.042960451489097*G0_0_1 + 0.042275432900433*G0_0_2 + 0.042275432900433*G0_2_0 + 0.049321338383838*G0_2_1 + 0.176636936077039*G0_2_2;
    A[661] = -0.124738623002512*G0_0_1 - 0.096294041606541*G0_0_2 - 0.096294041606542*G0_2_0 - 0.192588083213083*G0_2_1 - 0.257045070413125*G0_2_2;
    A[662] = 0.009394540644541*G0_0_2 + 0.009394540644540*G0_2_0 + 0.018789081289081*G0_2_2;
    A[663] = 0.003294613212148*G0_0_2 + 0.003294613212148*G0_2_0 + 0.029260079715809*G0_2_2;
    A[664] = 0.009394540644540*G0_0_2 + 0.009394540644540*G0_2_0 + 0.064130787872106*G0_2_2;
    A[665] = 0.003294613212148*G0_0_2 + 0.003294613212148*G0_2_0 + 0.006589226424296*G0_2_2;
    A[666] = 0.003294613212148*G0_0_2 + 0.003294613212148*G0_2_0 + 0.029260079715808*G0_2_2;
    A[667] = 0.009394540644540*G0_0_2 + 0.009394540644540*G0_2_0 + 0.018789081289081*G0_2_2;
    A[668] = -0.002609594623484*G0_0_2 - 0.002609594623483*G0_2_0 - 0.050560895829993*G0_2_2;
    A[669] = -0.002609594623484*G0_0_2 - 0.002609594623484*G0_2_0 - 0.156575677409010*G0_2_2;
    A[670] = -0.002609594623483*G0_0_2 - 0.002609594623484*G0_2_0 - 0.050560895829992*G0_2_2;
    A[671] = -0.035229527417028*G0_0_2 - 0.035229527417028*G0_2_0 + 0.096228801740953*G0_2_2;
    A[672] = -0.004800349309898*G0_0_0 - 0.004800349309898*G0_0_1 - 0.004800349309898*G0_0_2 - 0.004800349309898*G0_1_0 - 0.004800349309898*G0_1_1 - 0.004800349309898*G0_1_2;
    A[673] = -0.017870503981615*G0_0_0 + 0.037257182439474*G0_1_0;
    A[674] = -0.010531019103068*G0_0_1 + 0.004800349309898*G0_1_1;
    A[675] = 0.004800349309898*G0_0_2 + 0.004800349309898*G0_1_2;
    A[676] = -0.027459459425605*G0_0_1 - 0.032835224349981*G0_0_2 - 0.005375764924376*G0_1_1 - 0.005375764924376*G0_1_2;
    A[677] = -0.008879145706402*G0_0_1 - 0.011169064988509*G0_0_2 - 0.002289919282107*G0_1_1 - 0.002289919282107*G0_1_2;
    A[678] = -0.011684459926647*G0_0_1 - 0.013974379208754*G0_0_2 - 0.002289919282107*G0_1_1 - 0.002289919282107*G0_1_2;
    A[679] = -0.005375764924376*G0_0_1 - 0.010751529848752*G0_0_2 - 0.005375764924376*G0_1_1 - 0.005375764924376*G0_1_2;
    A[680] = 0.089548239504836*G0_0_0 + 0.069911039963122*G0_0_2 + 0.069911039963122*G0_1_0 + 0.139822079926245*G0_1_2;
    A[681] = -0.057417605703195*G0_0_0 - 0.069911039963122*G0_0_2 - 0.038726384212495*G0_1_0 - 0.108637424175617*G0_1_2;
    A[682] = 0.028372817543824*G0_0_0 + 0.059916292555181*G0_0_2 + 0.018978276899283*G0_1_0 + 0.078894569454464*G0_1_2;
    A[683] = -0.005375764924376*G0_0_0 - 0.027459459425605*G0_0_2 - 0.005375764924376*G0_1_0 - 0.032835224349981*G0_1_2;
    A[684] = 0.179096479009672*G0_0_0 + 0.069911039963123*G0_0_1 + 0.069911039963123*G0_1_0 + 0.139822079926245*G0_1_1;
    A[685] = -0.147063705006412*G0_0_0 + 0.026383001643418*G0_0_1 - 0.038726384212495*G0_1_0 - 0.108637424175617*G0_1_1;
    A[686] = 0.100717304493345*G0_0_0 - 0.024634573245684*G0_0_1 + 0.018978276899284*G0_1_0 + 0.078894569454465*G0_1_1;
    A[687] = -0.032835224349981*G0_0_0 + 0.020915900907220*G0_0_1 - 0.005375764924376*G0_1_0 - 0.032835224349981*G0_1_1;
    A[688] = 0.005375764924376*G0_0_0 + 0.005375764924376*G0_0_1 + 0.005375764924376*G0_1_0 + 0.005375764924376*G0_1_1;
    A[689] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_1;
    A[690] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_1;
    A[691] = 0.005375764924376*G0_0_0 + 0.005375764924376*G0_0_1 + 0.005375764924376*G0_1_0 + 0.005375764924376*G0_1_1;
    A[692] = 0.010751529848752*G0_0_0 + 0.005375764924376*G0_0_1 + 0.010751529848752*G0_0_2 + 0.005375764924376*G0_1_0 + 0.005375764924376*G0_1_2;
    A[693] = 0.013974379208755*G0_0_0 + 0.002289919282107*G0_0_1 + 0.013974379208755*G0_0_2 + 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_2;
    A[694] = 0.011169064988509*G0_0_0 + 0.002289919282107*G0_0_1 + 0.011169064988509*G0_0_2 + 0.002289919282106*G0_1_0 + 0.002289919282107*G0_1_2;
    A[695] = 0.032835224349981*G0_0_0 + 0.005375764924376*G0_0_1 + 0.032835224349981*G0_0_2 + 0.005375764924376*G0_1_0 + 0.005375764924376*G0_1_2;
    A[696] = 0.022083694501229*G0_0_0 + 0.027459459425604*G0_0_1 + 0.027459459425605*G0_0_2 + 0.027459459425605*G0_1_0 + 0.032835224349980*G0_1_1 + 0.032835224349980*G0_1_2;
    A[697] = -0.031543475011356*G0_0_0 - 0.059916292555180*G0_0_1 - 0.059916292555180*G0_0_2 - 0.059916292555180*G0_1_0 - 0.078894569454464*G0_1_1 - 0.078894569454464*G0_1_2;
    A[698] = 0.012493434259927*G0_0_0 + 0.069911039963122*G0_0_1 + 0.069911039963122*G0_0_2 + 0.069911039963122*G0_1_0 + 0.108637424175617*G0_1_1 + 0.108637424175617*G0_1_2;
    A[699] = 0.019637199541714*G0_0_0 - 0.069911039963122*G0_0_1 - 0.069911039963122*G0_0_2 - 0.069911039963122*G0_1_0 - 0.139822079926245*G0_1_1 - 0.139822079926245*G0_1_2;
    A[700] = -0.064456987200042*G0_0_0 + 0.096294041606541*G0_0_1 + 0.192588083213082*G0_0_2 + 0.028444581395970*G0_1_0 + 0.124738623002511*G0_1_1 + 0.124738623002511*G0_1_2;
    A[701] = 0.127315597693201*G0_0_0 - 0.007045905483406*G0_0_1 - 0.049321338383838*G0_0_2 - 0.000685018588664*G0_1_0 - 0.042960451489097*G0_1_1 - 0.042960451489097*G0_1_2;
    A[702] = -0.064130787872107*G0_0_0 + 0.026487385428358*G0_0_1 + 0.047755581609747*G0_0_2 - 0.009394540644541*G0_1_0 + 0.011873655536850*G0_1_1 + 0.011873655536850*G0_1_2;
    A[703] = 0.043971669405696*G0_0_0 - 0.042275432900433*G0_0_1 - 0.084550865800865*G0_0_2 - 0.000685018588665*G0_1_0 - 0.042960451489097*G0_1_1 - 0.042960451489097*G0_1_2;
    A[704] = -0.029260079715808*G0_0_0 + 0.008448562593528*G0_0_1 + 0.014287530563573*G0_0_2 - 0.003294613212148*G0_1_0 + 0.002544354757896*G0_1_1 + 0.002544354757897*G0_1_2;
    A[705] = -0.018789081289081*G0_0_0 + 0.021268196181390*G0_0_1 + 0.042536392362780*G0_0_2 - 0.009394540644541*G0_1_0 + 0.011873655536850*G0_1_1 + 0.011873655536849*G0_1_2;
    A[706] = 0.018789081289081*G0_0_0 + 0.009394540644541*G0_0_1 + 0.009394540644541*G0_1_0;
    A[707] = 0.029260079715809*G0_0_0 + 0.003294613212147*G0_0_1 + 0.003294613212148*G0_1_0;
    A[708] = 0.064130787872107*G0_0_0 + 0.009394540644541*G0_0_1 + 0.009394540644541*G0_1_0;
    A[709] = 0.006589226424296*G0_0_0 + 0.003294613212148*G0_0_1 + 0.003294613212148*G0_1_0;
    A[710] = 0.029260079715808*G0_0_0 + 0.003294613212148*G0_0_1 + 0.003294613212148*G0_1_0;
    A[711] = 0.018789081289081*G0_0_0 + 0.009394540644541*G0_0_1 + 0.009394540644541*G0_1_0;
    A[712] = -0.030662736825931*G0_0_0 - 0.021268196181391*G0_0_1 - 0.021268196181390*G0_1_0 - 0.011873655536850*G0_1_1;
    A[713] = 0.064261267603281*G0_0_0 + 0.042275432900432*G0_0_1 + 0.042275432900432*G0_1_0 + 0.042960451489096*G0_1_1;
    A[714] = -0.128522535206561*G0_0_0 - 0.096294041606541*G0_0_1 - 0.096294041606540*G0_1_0 - 0.124738623002510*G0_1_1;
    A[715] = -0.009133581182192*G0_0_0 - 0.005838967970044*G0_0_1 - 0.005838967970044*G0_1_0 - 0.002544354757896*G0_1_1;
    A[716] = 0.064261267603280*G0_0_0 + 0.042275432900433*G0_0_1 + 0.042275432900432*G0_1_0 + 0.042960451489097*G0_1_1;
    A[717] = -0.030662736825931*G0_0_0 - 0.021268196181390*G0_0_1 - 0.021268196181390*G0_1_0 - 0.011873655536850*G0_1_1;
    A[718] = -0.061325473651862*G0_0_0 - 0.021268196181390*G0_0_1 - 0.042536392362780*G0_0_2 - 0.021268196181390*G0_1_0 - 0.011873655536850*G0_1_2;
    A[719] = 0.128522535206562*G0_0_0 + 0.042275432900432*G0_0_1 + 0.084550865800865*G0_0_2 + 0.042275432900432*G0_1_0 + 0.042960451489096*G0_1_2;
    A[720] = -0.257045070413124*G0_0_0 - 0.096294041606540*G0_0_1 - 0.192588083213081*G0_0_2 - 0.096294041606540*G0_1_0 - 0.124738623002510*G0_1_2;
    A[721] = -0.043547610279381*G0_0_0 - 0.005838967970045*G0_0_1 - 0.014287530563573*G0_0_2 - 0.005838967970045*G0_1_0 - 0.002544354757897*G0_1_2;
    A[722] = 0.176636936077039*G0_0_0 + 0.042275432900433*G0_0_1 + 0.049321338383838*G0_0_2 + 0.042275432900433*G0_1_0 + 0.042960451489097*G0_1_2;
    A[723] = -0.111886369481854*G0_0_0 - 0.021268196181390*G0_0_1 - 0.047755581609747*G0_0_2 - 0.021268196181390*G0_1_0 - 0.011873655536850*G0_1_2;
    A[724] = -0.050560895829993*G0_0_0 - 0.002609594623483*G0_0_1 - 0.002609594623484*G0_1_0;
    A[725] = 0.096228801740954*G0_0_0 - 0.035229527417026*G0_0_1 - 0.035229527417027*G0_1_0;
    A[726] = -0.156575677409009*G0_0_0 - 0.002609594623484*G0_0_1 - 0.002609594623483*G0_1_0;
    A[727] = -0.050560895829992*G0_0_0 - 0.002609594623484*G0_0_1 - 0.002609594623482*G0_1_0;
    A[728] = -0.003365072266982*G0_0_0 - 0.003365072266982*G0_0_1 - 0.003365072266982*G0_0_2 - 0.003365072266982*G0_1_0 - 0.003365072266982*G0_1_1 - 0.003365072266982*G0_1_2;
    A[729] = 0.021469134967399*G0_0_0 - 0.033658551453690*G0_1_0;
    A[730] = 0.023263231271043*G0_0_1 - 0.015554488753273*G0_1_1;
    A[731] = 0.003365072266982*G0_0_2 + 0.003365072266982*G0_1_2;
    A[732] = 0.059916292555181*G0_0_1 + 0.078894569454465*G0_0_2 + 0.028372817543824*G0_1_1 + 0.018978276899284*G0_1_2;
    A[733] = 0.005780252091016*G0_0_1 + 0.005232237220084*G0_0_2 - 0.000482775005344*G0_1_1 - 0.000548014870931*G0_1_2;
    A[734] = 0.013152356902357*G0_0_1 + 0.026304713804714*G0_0_2 + 0.013217596767944*G0_1_1 + 0.013152356902357*G0_1_2;
    A[735] = -0.002289919282107*G0_0_1 - 0.013974379208754*G0_0_2 - 0.002289919282107*G0_1_1 - 0.011684459926647*G0_1_2;
    A[736] = -0.057417605703195*G0_0_0 - 0.038726384212495*G0_0_2 - 0.069911039963122*G0_1_0 - 0.108637424175617*G0_1_2;
    A[737] = 0.005062613569558*G0_0_0 + 0.004801654107210*G0_0_2 + 0.004801654107210*G0_1_0 + 0.009603308214419*G0_1_2;
    A[738] = -0.000482775005344*G0_0_0 + 0.005780252091016*G0_0_2 - 0.000548014870932*G0_1_0 + 0.005232237220085*G0_1_2;
    A[739] = -0.002289919282107*G0_0_0 - 0.008879145706403*G0_0_2 - 0.002289919282107*G0_1_0 - 0.011169064988509*G0_1_2;
    A[740] = -0.147063705006412*G0_0_0 - 0.038726384212495*G0_0_1 + 0.026383001643418*G0_1_0 - 0.108637424175617*G0_1_1;
    A[741] = 0.304226541205705*G0_0_0 + 0.078131263027096*G0_0_1 + 0.078131263027096*G0_1_0 + 0.281001149056701*G0_1_1;
    A[742] = -0.204187731314465*G0_0_0 + 0.015305272466730*G0_0_1 - 0.036495180809417*G0_1_0 - 0.204187731314465*G0_1_1;
    A[743] = 0.078894569454465*G0_0_0 - 0.024634573245684*G0_0_1 + 0.018978276899284*G0_1_0 + 0.100717304493345*G0_1_1;
    A[744] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_1;
    A[745] = 0.001787572317086*G0_0_0 + 0.001787572317086*G0_0_1 + 0.001787572317086*G0_1_0 + 0.001787572317086*G0_1_1;
    A[746] = 0.001787572317086*G0_0_0 + 0.001787572317086*G0_0_1 + 0.001787572317086*G0_1_0 + 0.001787572317086*G0_1_1;
    A[747] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_1;
    A[748] = 0.013974379208754*G0_0_0 + 0.011684459926647*G0_0_1 + 0.013974379208754*G0_0_2 + 0.011684459926648*G0_1_0 + 0.009394540644540*G0_1_1 + 0.011684459926648*G0_1_2;
    A[749] = -0.026304713804714*G0_0_0 - 0.013152356902357*G0_0_1 - 0.026304713804714*G0_0_2 - 0.013152356902357*G0_1_0 + 0.000065239865587*G0_1_1 - 0.013152356902357*G0_1_2;
    A[750] = -0.005232237220084*G0_0_0 + 0.000548014870931*G0_0_1 - 0.005232237220084*G0_0_2 + 0.000548014870932*G0_1_0 + 0.000065239865587*G0_1_1 + 0.000548014870932*G0_1_2;
    A[751] = -0.078894569454465*G0_0_0 - 0.018978276899283*G0_0_1 - 0.078894569454465*G0_0_2 - 0.018978276899284*G0_1_0 + 0.009394540644541*G0_1_1 - 0.018978276899284*G0_1_2;
    A[752] = 0.006589226424296*G0_0_0 + 0.008879145706403*G0_0_1 + 0.008879145706403*G0_0_2 + 0.008879145706403*G0_1_0 + 0.011169064988510*G0_1_1 + 0.011169064988510*G0_1_2;
    A[753] = -0.006263027096360*G0_0_0 - 0.005780252091016*G0_0_1 - 0.005780252091016*G0_0_2 - 0.005780252091016*G0_1_0 - 0.005232237220085*G0_1_1 - 0.005232237220085*G0_1_2;
    A[754] = 0.000260959462348*G0_0_0 - 0.004801654107210*G0_0_1 - 0.004801654107210*G0_0_2 - 0.004801654107209*G0_1_0 - 0.009603308214419*G0_1_1 - 0.009603308214419*G0_1_2;
    A[755] = -0.018691221490701*G0_0_0 + 0.038726384212495*G0_0_1 + 0.038726384212495*G0_0_2 + 0.038726384212495*G0_1_0 + 0.108637424175617*G0_1_1 + 0.108637424175617*G0_1_2;
    A[756] = 0.132306447410613*G0_0_0 - 0.062369311501256*G0_0_1 + 0.010960297418630*G0_0_2 + 0.073329608919885*G0_1_0 - 0.124738623002511*G0_1_1 + 0.146659217839772*G0_1_2;
    A[757] = -0.166948816037356*G0_0_0 + 0.083865847212200*G0_0_1 + 0.167731694424401*G0_0_2 - 0.006165167297979*G0_1_0 + 0.182410664181495*G0_1_1 + 0.077700679914221*G0_1_2;
    A[758] = 0.127087258163646*G0_0_0 - 0.046385544432419*G0_0_1 - 0.082332710370903*G0_0_2 + 0.037773882174924*G0_1_0 - 0.051017574889102*G0_1_1 + 0.001826716236439*G0_1_2;
    A[759] = -0.043645470077761*G0_0_0 - 0.006491366625915*G0_0_1 - 0.080832193462401*G0_0_2 - 0.033892110172491*G0_1_0 - 0.003522952741703*G0_1_1 - 0.108232937008978*G0_1_2;
    A[760] = 0.018984800885842*G0_0_0 - 0.018886941087461*G0_0_1 - 0.037773882174924*G0_0_2 + 0.009492400442921*G0_1_0 - 0.015592327875314*G0_1_1 - 0.009394540644541*G0_1_2;
    A[761] = 0.014874689353856*G0_0_0 + 0.001239557446155*G0_0_1 + 0.040318236932820*G0_0_2 + 0.014939929219443*G0_1_0 + 0.001174317580568*G0_1_1 + 0.054018608706108*G0_1_2;
    A[762] = -0.014874689353856*G0_0_0 - 0.014939929219444*G0_0_1 - 0.014939929219443*G0_1_0 - 0.015005169085031*G0_1_1;
    A[763] = -0.018984800885842*G0_0_0 - 0.009492400442920*G0_0_1 - 0.009492400442921*G0_1_0 - 0.000652398655870*G0_1_1;
    A[764] = -0.127087258163646*G0_0_0 - 0.037773882174924*G0_0_1 - 0.037773882174924*G0_1_0 - 0.015005169085030*G0_1_1;
    A[765] = 0.004501550725509*G0_0_0 + 0.001924576034819*G0_0_1 + 0.001924576034819*G0_1_0 - 0.000652398655871*G0_1_1;
    A[766] = -0.018984800885842*G0_0_0 - 0.009492400442921*G0_0_1 - 0.009492400442921*G0_1_0 - 0.000652398655871*G0_1_1;
    A[767] = -0.014874689353856*G0_0_0 - 0.014939929219443*G0_0_1 - 0.014939929219443*G0_1_0 - 0.015005169085030*G0_1_1;
    A[768] = -0.001304797311742*G0_0_0 - 0.001239557446155*G0_0_1 - 0.001239557446155*G0_1_0 - 0.001174317580567*G0_1_1;
    A[769] = 0.008807381854257*G0_0_0 + 0.006491366625915*G0_0_1 + 0.006491366625916*G0_1_0 + 0.003522952741703*G0_1_1;
    A[770] = 0.047625101878574*G0_0_0 + 0.062369311501256*G0_0_1 + 0.062369311501255*G0_1_0 + 0.124738623002510*G0_1_1;
    A[771] = -0.015657567740901*G0_0_0 - 0.013080593050211*G0_0_1 - 0.013080593050211*G0_1_0 - 0.010503618359521*G0_1_1;
    A[772] = 0.008807381854257*G0_0_0 + 0.006491366625915*G0_0_1 + 0.006491366625915*G0_1_0 + 0.003522952741703*G0_1_1;
    A[773] = -0.001304797311742*G0_0_0 - 0.001239557446155*G0_0_1 - 0.001239557446155*G0_1_0 - 0.001174317580568*G0_1_1;
    A[774] = -0.025443547578964*G0_0_0 - 0.039078679486666*G0_0_1 - 0.040318236932820*G0_0_2 - 0.039078679486665*G0_1_0 - 0.052844291125541*G0_1_1 - 0.054018608706108*G0_1_2;
    A[775] = 0.037186723384639*G0_0_0 + 0.074340826836485*G0_0_1 + 0.080832193462401*G0_0_2 + 0.074340826836486*G0_1_0 + 0.104709984267275*G0_1_1 + 0.108232937008978*G0_1_2;
    A[776] = 0.121346149991983*G0_0_0 - 0.073329608919886*G0_0_1 - 0.010960297418630*G0_0_2 - 0.073329608919886*G0_1_0 - 0.271397840842282*G0_1_1 - 0.146659217839772*G0_1_2;
    A[777] = 0.056758683060767*G0_0_0 + 0.018886941087463*G0_0_1 + 0.037773882174924*G0_0_2 + 0.018886941087462*G0_1_0 - 0.006197787230773*G0_1_1 + 0.009394540644541*G0_1_2;
    A[778] = -0.334680510461757*G0_0_0 - 0.083865847212200*G0_0_1 - 0.167731694424401*G0_0_2 - 0.083865847212201*G0_1_0 + 0.104709984267275*G0_1_1 - 0.077700679914221*G0_1_2;
    A[779] = 0.209419968534549*G0_0_0 + 0.035947165938484*G0_0_1 + 0.082332710370904*G0_0_2 + 0.035947165938485*G0_1_0 - 0.052844291125541*G0_1_1 - 0.001826716236438*G0_1_2;
    A[780] = 0.039143919352253*G0_0_0 + 0.031967534137672*G0_0_1 + 0.031967534137673*G0_1_0 + 0.026095946234834*G0_1_1;
    A[781] = -0.156575677409009*G0_0_0 - 0.090357213838115*G0_0_1 - 0.090357213838115*G0_1_0 - 0.185933616923198*G0_1_1;
    A[782] = 0.185933616923198*G0_0_0 + 0.015657567740901*G0_0_1 + 0.015657567740900*G0_1_0 + 0.026095946234835*G0_1_1;
    A[783] = 0.039143919352252*G0_0_0 + 0.031967534137672*G0_0_1 + 0.031967534137672*G0_1_0 + 0.026095946234834*G0_1_1;
    A[784] = -0.003365072266982*G0_0_0 - 0.003365072266982*G0_0_1 - 0.003365072266982*G0_0_2 - 0.003365072266982*G0_1_0 - 0.003365072266982*G0_1_1 - 0.003365072266982*G0_1_2;
    A[785] = -0.015554488753273*G0_0_0 + 0.023263231271043*G0_1_0;
    A[786] = -0.033658551453690*G0_0_1 + 0.021469134967399*G0_1_1;
    A[787] = 0.003365072266982*G0_0_2 + 0.003365072266982*G0_1_2;
    A[788] = -0.069911039963123*G0_0_1 - 0.108637424175618*G0_0_2 - 0.057417605703195*G0_1_1 - 0.038726384212495*G0_1_2;
    A[789] = 0.004801654107210*G0_0_1 + 0.009603308214420*G0_0_2 + 0.005062613569558*G0_1_1 + 0.004801654107210*G0_1_2;
    A[790] = -0.000548014870932*G0_0_1 + 0.005232237220084*G0_0_2 - 0.000482775005344*G0_1_1 + 0.005780252091016*G0_1_2;
    A[791] = -0.002289919282107*G0_0_1 - 0.011169064988509*G0_0_2 - 0.002289919282107*G0_1_1 - 0.008879145706403*G0_1_2;
    A[792] = 0.028372817543824*G0_0_0 + 0.018978276899284*G0_0_2 + 0.059916292555181*G0_1_0 + 0.078894569454464*G0_1_2;
    A[793] = -0.000482775005344*G0_0_0 - 0.000548014870931*G0_0_2 + 0.005780252091016*G0_1_0 + 0.005232237220084*G0_1_2;
    A[794] = 0.013217596767944*G0_0_0 + 0.013152356902357*G0_0_2 + 0.013152356902357*G0_1_0 + 0.026304713804714*G0_1_2;
    A[795] = -0.002289919282107*G0_0_0 - 0.011684459926647*G0_0_2 - 0.002289919282107*G0_1_0 - 0.013974379208754*G0_1_2;
    A[796] = 0.100717304493345*G0_0_0 + 0.018978276899284*G0_0_1 - 0.024634573245684*G0_1_0 + 0.078894569454465*G0_1_1;
    A[797] = -0.204187731314465*G0_0_0 - 0.036495180809417*G0_0_1 + 0.015305272466730*G0_1_0 - 0.204187731314465*G0_1_1;
    A[798] = 0.281001149056701*G0_0_0 + 0.078131263027095*G0_0_1 + 0.078131263027095*G0_1_0 + 0.304226541205705*G0_1_1;
    A[799] = -0.108637424175618*G0_0_0 + 0.026383001643418*G0_0_1 - 0.038726384212495*G0_1_0 - 0.147063705006412*G0_1_1;
    A[800] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_1 + 0.002289919282106*G0_1_0 + 0.002289919282106*G0_1_1;
    A[801] = 0.001787572317086*G0_0_0 + 0.001787572317086*G0_0_1 + 0.001787572317086*G0_1_0 + 0.001787572317086*G0_1_1;
    A[802] = 0.001787572317086*G0_0_0 + 0.001787572317086*G0_0_1 + 0.001787572317086*G0_1_0 + 0.001787572317086*G0_1_1;
    A[803] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_1;
    A[804] = 0.011169064988509*G0_0_0 + 0.008879145706402*G0_0_1 + 0.011169064988509*G0_0_2 + 0.008879145706402*G0_1_0 + 0.006589226424296*G0_1_1 + 0.008879145706402*G0_1_2;
    A[805] = -0.005232237220084*G0_0_0 - 0.005780252091016*G0_0_1 - 0.005232237220084*G0_0_2 - 0.005780252091016*G0_1_0 - 0.006263027096360*G0_1_1 - 0.005780252091016*G0_1_2;
    A[806] = -0.009603308214420*G0_0_0 - 0.004801654107210*G0_0_1 - 0.009603308214420*G0_0_2 - 0.004801654107210*G0_1_0 + 0.000260959462348*G0_1_1 - 0.004801654107210*G0_1_2;
    A[807] = 0.108637424175618*G0_0_0 + 0.038726384212495*G0_0_1 + 0.108637424175618*G0_0_2 + 0.038726384212495*G0_1_0 - 0.018691221490701*G0_1_1 + 0.038726384212495*G0_1_2;
    A[808] = 0.009394540644540*G0_0_0 + 0.011684459926647*G0_0_1 + 0.011684459926647*G0_0_2 + 0.011684459926647*G0_1_0 + 0.013974379208754*G0_1_1 + 0.013974379208754*G0_1_2;
    A[809] = 0.000065239865587*G0_0_0 - 0.013152356902357*G0_0_1 - 0.013152356902357*G0_0_2 - 0.013152356902357*G0_1_0 - 0.026304713804713*G0_1_1 - 0.026304713804713*G0_1_2;
    A[810] = 0.000065239865587*G0_0_0 + 0.000548014870931*G0_0_1 + 0.000548014870931*G0_0_2 + 0.000548014870931*G0_1_0 - 0.005232237220085*G0_1_1 - 0.005232237220085*G0_1_2;
    A[811] = 0.009394540644541*G0_0_0 - 0.018978276899284*G0_0_1 - 0.018978276899284*G0_0_2 - 0.018978276899283*G0_1_0 - 0.078894569454464*G0_1_1 - 0.078894569454464*G0_1_2;
    A[812] = -0.051017574889102*G0_0_0 + 0.037773882174924*G0_0_1 + 0.001826716236439*G0_0_2 - 0.046385544432419*G0_1_0 + 0.127087258163646*G0_1_1 - 0.082332710370904*G0_1_2;
    A[813] = 0.182410664181495*G0_0_0 - 0.006165167297980*G0_0_1 + 0.077700679914220*G0_0_2 + 0.083865847212200*G0_1_0 - 0.166948816037357*G0_1_1 + 0.167731694424400*G0_1_2;
    A[814] = -0.124738623002511*G0_0_0 + 0.073329608919886*G0_0_1 + 0.146659217839771*G0_0_2 - 0.062369311501255*G0_1_0 + 0.132306447410613*G0_1_1 + 0.010960297418631*G0_1_2;
    A[815] = -0.015592327875314*G0_0_0 + 0.009492400442921*G0_0_1 - 0.009394540644541*G0_0_2 - 0.018886941087462*G0_1_0 + 0.018984800885842*G0_1_1 - 0.037773882174924*G0_1_2;
    A[816] = -0.003522952741702*G0_0_0 - 0.033892110172492*G0_0_1 - 0.108232937008977*G0_0_2 - 0.006491366625915*G0_1_0 - 0.043645470077761*G0_1_1 - 0.080832193462400*G0_1_2;
    A[817] = 0.001174317580567*G0_0_0 + 0.014939929219443*G0_0_1 + 0.054018608706108*G0_0_2 + 0.001239557446154*G0_1_0 + 0.014874689353856*G0_1_1 + 0.040318236932820*G0_1_2;
    A[818] = -0.001174317580567*G0_0_0 - 0.001239557446154*G0_0_1 - 0.001239557446155*G0_1_0 - 0.001304797311741*G0_1_1;
    A[819] = 0.003522952741703*G0_0_0 + 0.006491366625914*G0_0_1 + 0.006491366625915*G0_1_0 + 0.008807381854256*G0_1_1;
    A[820] = 0.124738623002511*G0_0_0 + 0.062369311501256*G0_0_1 + 0.062369311501255*G0_1_0 + 0.047625101878574*G0_1_1;
    A[821] = -0.010503618359521*G0_0_0 - 0.013080593050210*G0_0_1 - 0.013080593050211*G0_1_0 - 0.015657567740901*G0_1_1;
    A[822] = 0.003522952741702*G0_0_0 + 0.006491366625914*G0_0_1 + 0.006491366625915*G0_1_0 + 0.008807381854257*G0_1_1;
    A[823] = -0.001174317580567*G0_0_0 - 0.001239557446154*G0_0_1 - 0.001239557446154*G0_1_0 - 0.001304797311742*G0_1_1;
    A[824] = -0.015005169085030*G0_0_0 - 0.014939929219443*G0_0_1 - 0.014939929219443*G0_1_0 - 0.014874689353856*G0_1_1;
    A[825] = -0.000652398655871*G0_0_0 - 0.009492400442922*G0_0_1 - 0.009492400442922*G0_1_0 - 0.018984800885843*G0_1_1;
    A[826] = -0.015005169085030*G0_0_0 - 0.037773882174924*G0_0_1 - 0.037773882174923*G0_1_0 - 0.127087258163646*G0_1_1;
    A[827] = -0.000652398655870*G0_0_0 + 0.001924576034819*G0_0_1 + 0.001924576034819*G0_1_0 + 0.004501550725509*G0_1_1;
    A[828] = -0.000652398655871*G0_0_0 - 0.009492400442921*G0_0_1 - 0.009492400442921*G0_1_0 - 0.018984800885842*G0_1_1;
    A[829] = -0.015005169085030*G0_0_0 - 0.014939929219443*G0_0_1 - 0.014939929219443*G0_1_0 - 0.014874689353856*G0_1_1;
    A[830] = -0.052844291125540*G0_0_0 - 0.039078679486664*G0_0_1 - 0.054018608706108*G0_0_2 - 0.039078679486665*G0_1_0 - 0.025443547578963*G0_1_1 - 0.040318236932820*G0_1_2;
    A[831] = -0.006197787230773*G0_0_0 + 0.018886941087462*G0_0_1 + 0.009394540644540*G0_0_2 + 0.018886941087462*G0_1_0 + 0.056758683060766*G0_1_1 + 0.037773882174923*G0_1_2;
    A[832] = -0.052844291125541*G0_0_0 + 0.035947165938485*G0_0_1 - 0.001826716236439*G0_0_2 + 0.035947165938485*G0_1_0 + 0.209419968534550*G0_1_1 + 0.082332710370904*G0_1_2;
    A[833] = 0.104709984267274*G0_0_0 + 0.074340826836484*G0_0_1 + 0.108232937008976*G0_0_2 + 0.074340826836485*G0_1_0 + 0.037186723384639*G0_1_1 + 0.080832193462400*G0_1_2;
    A[834] = 0.104709984267275*G0_0_0 - 0.083865847212200*G0_0_1 - 0.077700679914220*G0_0_2 - 0.083865847212200*G0_1_0 - 0.334680510461757*G0_1_1 - 0.167731694424400*G0_1_2;
    A[835] = -0.271397840842281*G0_0_0 - 0.073329608919885*G0_0_1 - 0.146659217839771*G0_0_2 - 0.073329608919886*G0_1_0 + 0.121346149991983*G0_1_1 - 0.010960297418631*G0_1_2;
    A[836] = 0.026095946234834*G0_0_0 + 0.031967534137673*G0_0_1 + 0.031967534137673*G0_1_0 + 0.039143919352253*G0_1_1;
    A[837] = 0.026095946234835*G0_0_0 + 0.015657567740901*G0_0_1 + 0.015657567740901*G0_1_0 + 0.185933616923199*G0_1_1;
    A[838] = -0.185933616923198*G0_0_0 - 0.090357213838116*G0_0_1 - 0.090357213838115*G0_1_0 - 0.156575677409009*G0_1_1;
    A[839] = 0.026095946234835*G0_0_0 + 0.031967534137673*G0_0_1 + 0.031967534137673*G0_1_0 + 0.039143919352252*G0_1_1;
    A[840] = -0.004800349309898*G0_0_0 - 0.004800349309898*G0_0_1 - 0.004800349309898*G0_0_2 - 0.004800349309898*G0_1_0 - 0.004800349309898*G0_1_1 - 0.004800349309898*G0_1_2;
    A[841] = 0.004800349309898*G0_0_0 - 0.010531019103068*G0_1_0;
    A[842] = 0.037257182439474*G0_0_1 - 0.017870503981615*G0_1_1;
    A[843] = 0.004800349309898*G0_0_2 + 0.004800349309898*G0_1_2;
    A[844] = 0.069911039963123*G0_0_1 + 0.139822079926246*G0_0_2 + 0.089548239504836*G0_1_1 + 0.069911039963123*G0_1_2;
    A[845] = -0.038726384212495*G0_0_1 - 0.108637424175618*G0_0_2 - 0.057417605703195*G0_1_1 - 0.069911039963123*G0_1_2;
    A[846] = 0.018978276899284*G0_0_1 + 0.078894569454465*G0_0_2 + 0.028372817543824*G0_1_1 + 0.059916292555181*G0_1_2;
    A[847] = -0.005375764924376*G0_0_1 - 0.032835224349981*G0_0_2 - 0.005375764924376*G0_1_1 - 0.027459459425605*G0_1_2;
    A[848] = -0.005375764924376*G0_0_0 - 0.005375764924376*G0_0_2 - 0.027459459425605*G0_1_0 - 0.032835224349981*G0_1_2;
    A[849] = -0.002289919282107*G0_0_0 - 0.002289919282107*G0_0_2 - 0.008879145706402*G0_1_0 - 0.011169064988509*G0_1_2;
    A[850] = -0.002289919282107*G0_0_0 - 0.002289919282107*G0_0_2 - 0.011684459926648*G0_1_0 - 0.013974379208754*G0_1_2;
    A[851] = -0.005375764924376*G0_0_0 - 0.005375764924376*G0_0_2 - 0.005375764924376*G0_1_0 - 0.010751529848752*G0_1_2;
    A[852] = -0.032835224349981*G0_0_0 - 0.005375764924376*G0_0_1 + 0.020915900907220*G0_1_0 - 0.032835224349981*G0_1_1;
    A[853] = 0.078894569454465*G0_0_0 + 0.018978276899284*G0_0_1 - 0.024634573245683*G0_1_0 + 0.100717304493345*G0_1_1;
    A[854] = -0.108637424175618*G0_0_0 - 0.038726384212495*G0_0_1 + 0.026383001643418*G0_1_0 - 0.147063705006412*G0_1_1;
    A[855] = 0.139822079926246*G0_0_0 + 0.069911039963123*G0_0_1 + 0.069911039963123*G0_1_0 + 0.179096479009672*G0_1_1;
    A[856] = 0.005375764924376*G0_0_0 + 0.005375764924376*G0_0_1 + 0.005375764924376*G0_1_0 + 0.005375764924376*G0_1_1;
    A[857] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_1;
    A[858] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_1;
    A[859] = 0.005375764924376*G0_0_0 + 0.005375764924376*G0_0_1 + 0.005375764924376*G0_1_0 + 0.005375764924376*G0_1_1;
    A[860] = 0.032835224349981*G0_0_0 + 0.027459459425605*G0_0_1 + 0.032835224349981*G0_0_2 + 0.027459459425605*G0_1_0 + 0.022083694501229*G0_1_1 + 0.027459459425605*G0_1_2;
    A[861] = -0.078894569454465*G0_0_0 - 0.059916292555181*G0_0_1 - 0.078894569454465*G0_0_2 - 0.059916292555181*G0_1_0 - 0.031543475011357*G0_1_1 - 0.059916292555181*G0_1_2;
    A[862] = 0.108637424175618*G0_0_0 + 0.069911039963123*G0_0_1 + 0.108637424175618*G0_0_2 + 0.069911039963123*G0_1_0 + 0.012493434259927*G0_1_1 + 0.069911039963123*G0_1_2;
    A[863] = -0.139822079926246*G0_0_0 - 0.069911039963123*G0_0_1 - 0.139822079926245*G0_0_2 - 0.069911039963123*G0_1_0 + 0.019637199541713*G0_1_1 - 0.069911039963123*G0_1_2;
    A[864] = 0.005375764924376*G0_0_1 + 0.005375764924376*G0_0_2 + 0.005375764924376*G0_1_0 + 0.010751529848752*G0_1_1 + 0.010751529848752*G0_1_2;
    A[865] = 0.002289919282107*G0_0_1 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_1_0 + 0.013974379208754*G0_1_1 + 0.013974379208754*G0_1_2;
    A[866] = 0.002289919282107*G0_0_1 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_1_0 + 0.011169064988510*G0_1_1 + 0.011169064988510*G0_1_2;
    A[867] = 0.005375764924376*G0_0_1 + 0.005375764924376*G0_0_2 + 0.005375764924376*G0_1_0 + 0.032835224349981*G0_1_1 + 0.032835224349981*G0_1_2;
    A[868] = 0.011873655536850*G0_0_0 - 0.009394540644541*G0_0_1 + 0.011873655536849*G0_0_2 + 0.026487385428358*G0_1_0 - 0.064130787872107*G0_1_1 + 0.047755581609747*G0_1_2;
    A[869] = -0.042960451489097*G0_0_0 - 0.000685018588664*G0_0_1 - 0.042960451489096*G0_0_2 - 0.007045905483405*G0_1_0 + 0.127315597693201*G0_1_1 - 0.049321338383837*G0_1_2;
    A[870] = 0.124738623002511*G0_0_0 + 0.028444581395970*G0_0_1 + 0.124738623002511*G0_0_2 + 0.096294041606541*G0_1_0 - 0.064456987200042*G0_1_1 + 0.192588083213081*G0_1_2;
    A[871] = 0.002544354757896*G0_0_0 - 0.003294613212148*G0_0_1 + 0.002544354757896*G0_0_2 + 0.008448562593528*G0_1_0 - 0.029260079715809*G0_1_1 + 0.014287530563572*G0_1_2;
    A[872] = -0.042960451489097*G0_0_0 - 0.000685018588664*G0_0_1 - 0.042960451489097*G0_0_2 - 0.042275432900433*G0_1_0 + 0.043971669405697*G0_1_1 - 0.084550865800865*G0_1_2;
    A[873] = 0.011873655536850*G0_0_0 - 0.009394540644541*G0_0_1 + 0.011873655536850*G0_0_2 + 0.021268196181391*G0_1_0 - 0.018789081289081*G0_1_1 + 0.042536392362781*G0_1_2;
    A[874] = -0.011873655536850*G0_0_0 - 0.021268196181391*G0_0_1 - 0.021268196181390*G0_1_0 - 0.030662736825931*G0_1_1;
    A[875] = 0.042960451489097*G0_0_0 + 0.042275432900434*G0_0_1 + 0.042275432900433*G0_1_0 + 0.064261267603281*G0_1_1;
    A[876] = -0.124738623002511*G0_0_0 - 0.096294041606542*G0_0_1 - 0.096294041606541*G0_1_0 - 0.128522535206562*G0_1_1;
    A[877] = -0.002544354757896*G0_0_0 - 0.005838967970045*G0_0_1 - 0.005838967970044*G0_1_0 - 0.009133581182192*G0_1_1;
    A[878] = 0.042960451489097*G0_0_0 + 0.042275432900433*G0_0_1 + 0.042275432900433*G0_1_0 + 0.064261267603281*G0_1_1;
    A[879] = -0.011873655536850*G0_0_0 - 0.021268196181391*G0_0_1 - 0.021268196181391*G0_1_0 - 0.030662736825931*G0_1_1;
    A[880] = 0.009394540644541*G0_0_1 + 0.009394540644540*G0_1_0 + 0.018789081289082*G0_1_1;
    A[881] = 0.003294613212148*G0_0_1 + 0.003294613212148*G0_1_0 + 0.029260079715809*G0_1_1;
    A[882] = 0.009394540644541*G0_0_1 + 0.009394540644540*G0_1_0 + 0.064130787872107*G0_1_1;
    A[883] = 0.003294613212148*G0_0_1 + 0.003294613212148*G0_1_0 + 0.006589226424296*G0_1_1;
    A[884] = 0.003294613212148*G0_0_1 + 0.003294613212148*G0_1_0 + 0.029260079715809*G0_1_1;
    A[885] = 0.009394540644541*G0_0_1 + 0.009394540644541*G0_1_0 + 0.018789081289081*G0_1_1;
    A[886] = -0.021268196181391*G0_0_1 - 0.011873655536850*G0_0_2 - 0.021268196181390*G0_1_0 - 0.061325473651862*G0_1_1 - 0.042536392362781*G0_1_2;
    A[887] = -0.005838967970045*G0_0_1 - 0.002544354757896*G0_0_2 - 0.005838967970044*G0_1_0 - 0.043547610279381*G0_1_1 - 0.014287530563572*G0_1_2;
    A[888] = -0.021268196181390*G0_0_1 - 0.011873655536850*G0_0_2 - 0.021268196181390*G0_1_0 - 0.111886369481855*G0_1_1 - 0.047755581609748*G0_1_2;
    A[889] = 0.042275432900433*G0_0_1 + 0.042960451489097*G0_0_2 + 0.042275432900432*G0_1_0 + 0.128522535206562*G0_1_1 + 0.084550865800865*G0_1_2;
    A[890] = 0.042275432900432*G0_0_1 + 0.042960451489097*G0_0_2 + 0.042275432900432*G0_1_0 + 0.176636936077039*G0_1_1 + 0.049321338383838*G0_1_2;
    A[891] = -0.096294041606541*G0_0_1 - 0.124738623002511*G0_0_2 - 0.096294041606540*G0_1_0 - 0.257045070413124*G0_1_1 - 0.192588083213081*G0_1_2;
    A[892] = -0.002609594623484*G0_0_1 - 0.002609594623484*G0_1_0 - 0.050560895829994*G0_1_1;
    A[893] = -0.002609594623483*G0_0_1 - 0.002609594623483*G0_1_0 - 0.156575677409010*G0_1_1;
    A[894] = -0.035229527417027*G0_0_1 - 0.035229527417027*G0_1_0 + 0.096228801740954*G0_1_1;
    A[895] = -0.002609594623484*G0_0_1 - 0.002609594623484*G0_1_0 - 0.050560895829993*G0_1_1;
    A[896] = -0.017870503981615*G0_0_0 - 0.017870503981615*G0_0_1 - 0.017870503981615*G0_0_2 - 0.017870503981615*G0_1_0 - 0.017870503981615*G0_1_1 - 0.017870503981615*G0_1_2 - 0.055127686421089*G0_2_0 - 0.055127686421089*G0_2_1 - 0.055127686421089*G0_2_2;
    A[897] = -0.004800349309898*G0_0_0 - 0.004800349309898*G0_1_0;
    A[898] = -0.004800349309898*G0_0_1 - 0.004800349309898*G0_1_1;
    A[899] = 0.010531019103068*G0_0_2 + 0.010531019103068*G0_1_2 + 0.015331368412966*G0_2_2;
    A[900] = 0.010751529848752*G0_0_1 + 0.005375764924376*G0_0_2 + 0.010751529848752*G0_1_1 + 0.005375764924376*G0_1_2 + 0.005375764924376*G0_2_1;
    A[901] = 0.013974379208754*G0_0_1 + 0.011684459926647*G0_0_2 + 0.013974379208754*G0_1_1 + 0.011684459926647*G0_1_2 + 0.011684459926647*G0_2_1 + 0.009394540644541*G0_2_2;
    A[902] = 0.011169064988509*G0_0_1 + 0.008879145706403*G0_0_2 + 0.011169064988509*G0_1_1 + 0.008879145706403*G0_1_2 + 0.008879145706403*G0_2_1 + 0.006589226424296*G0_2_2;
    A[903] = 0.032835224349981*G0_0_1 + 0.027459459425605*G0_0_2 + 0.032835224349981*G0_1_1 + 0.027459459425605*G0_1_2 + 0.027459459425605*G0_2_1 + 0.022083694501229*G0_2_2;
    A[904] = 0.010751529848752*G0_0_0 + 0.005375764924376*G0_0_2 + 0.010751529848752*G0_1_0 + 0.005375764924376*G0_1_2 + 0.005375764924376*G0_2_0;
    A[905] = 0.013974379208754*G0_0_0 + 0.011684459926647*G0_0_2 + 0.013974379208754*G0_1_0 + 0.011684459926647*G0_1_2 + 0.011684459926647*G0_2_0 + 0.009394540644541*G0_2_2;
    A[906] = 0.011169064988509*G0_0_0 + 0.008879145706402*G0_0_2 + 0.011169064988509*G0_1_0 + 0.008879145706402*G0_1_2 + 0.008879145706402*G0_2_0 + 0.006589226424296*G0_2_2;
    A[907] = 0.032835224349981*G0_0_0 + 0.027459459425605*G0_0_2 + 0.032835224349981*G0_1_0 + 0.027459459425605*G0_1_2 + 0.027459459425605*G0_2_0 + 0.022083694501229*G0_2_2;
    A[908] = 0.005375764924376*G0_0_0 + 0.005375764924376*G0_0_1 + 0.005375764924376*G0_1_0 + 0.005375764924376*G0_1_1;
    A[909] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_1;
    A[910] = 0.002289919282107*G0_0_0 + 0.002289919282106*G0_0_1 + 0.002289919282107*G0_1_0 + 0.002289919282106*G0_1_1;
    A[911] = 0.005375764924376*G0_0_0 + 0.005375764924376*G0_0_1 + 0.005375764924376*G0_1_0 + 0.005375764924376*G0_1_1;
    A[912] = 0.179096479009671*G0_0_0 + 0.179096479009672*G0_0_1 + 0.109185439046549*G0_0_2 + 0.179096479009672*G0_1_0 + 0.179096479009672*G0_1_1 + 0.109185439046549*G0_1_2 + 0.109185439046549*G0_2_0 + 0.109185439046549*G0_2_1 + 0.179096479009672*G0_2_2;
    A[913] = -0.147063705006412*G0_0_0 - 0.147063705006412*G0_0_1 - 0.173446706649830*G0_0_2 - 0.147063705006412*G0_1_0 - 0.147063705006412*G0_1_1 - 0.173446706649830*G0_1_2 - 0.108337320793917*G0_2_0 - 0.108337320793917*G0_2_1 - 0.243357746612953*G0_2_2;
    A[914] = 0.100717304493345*G0_0_0 + 0.100717304493345*G0_0_1 + 0.125351877739030*G0_0_2 + 0.100717304493346*G0_1_0 + 0.100717304493345*G0_1_1 + 0.125351877739030*G0_1_2 + 0.081739027594062*G0_2_0 + 0.081739027594062*G0_2_1 + 0.185268170294211*G0_2_2;
    A[915] = -0.032835224349981*G0_0_0 - 0.032835224349981*G0_0_1 - 0.053751125257201*G0_0_2 - 0.032835224349981*G0_1_0 - 0.032835224349981*G0_1_1 - 0.053751125257201*G0_1_2 - 0.027459459425605*G0_2_0 - 0.027459459425605*G0_2_1 - 0.081210584682806*G0_2_2;
    A[916] = 0.089548239504836*G0_0_0 + 0.019637199541713*G0_0_1 + 0.089548239504836*G0_0_2 + 0.089548239504836*G0_1_0 + 0.019637199541713*G0_1_1 + 0.089548239504836*G0_1_2 + 0.019637199541713*G0_2_0 + 0.089548239504836*G0_2_1 + 0.019637199541713*G0_2_2;
    A[917] = -0.057417605703195*G0_0_0 + 0.012493434259927*G0_0_1 - 0.057417605703195*G0_0_2 - 0.057417605703195*G0_1_0 + 0.012493434259928*G0_1_1 - 0.057417605703196*G0_1_2 - 0.018691221490700*G0_2_0 - 0.057417605703195*G0_2_1 - 0.018691221490700*G0_2_2;
    A[918] = 0.028372817543824*G0_0_0 - 0.031543475011357*G0_0_1 + 0.028372817543824*G0_0_2 + 0.028372817543824*G0_1_0 - 0.031543475011357*G0_1_1 + 0.028372817543824*G0_1_2 + 0.009394540644541*G0_2_0 + 0.028372817543824*G0_2_1 + 0.009394540644541*G0_2_2;
    A[919] = -0.005375764924376*G0_0_0 + 0.022083694501229*G0_0_1 - 0.005375764924376*G0_0_2 - 0.005375764924376*G0_1_0 + 0.022083694501229*G0_1_1 - 0.005375764924376*G0_1_2 - 0.005375764924376*G0_2_1;
    A[920] = 0.019637199541713*G0_0_0 + 0.089548239504836*G0_0_1 + 0.089548239504836*G0_0_2 + 0.019637199541713*G0_1_0 + 0.089548239504836*G0_1_1 + 0.089548239504836*G0_1_2 + 0.089548239504836*G0_2_0 + 0.019637199541713*G0_2_1 + 0.019637199541713*G0_2_2;
    A[921] = 0.012493434259927*G0_0_0 - 0.057417605703195*G0_0_1 - 0.057417605703195*G0_0_2 + 0.012493434259927*G0_1_0 - 0.057417605703195*G0_1_1 - 0.057417605703195*G0_1_2 - 0.057417605703195*G0_2_0 - 0.018691221490700*G0_2_1 - 0.018691221490700*G0_2_2;
    A[922] = -0.031543475011357*G0_0_0 + 0.028372817543824*G0_0_1 + 0.028372817543824*G0_0_2 - 0.031543475011357*G0_1_0 + 0.028372817543824*G0_1_1 + 0.028372817543824*G0_1_2 + 0.028372817543824*G0_2_0 + 0.009394540644541*G0_2_1 + 0.009394540644541*G0_2_2;
    A[923] = 0.022083694501229*G0_0_0 - 0.005375764924376*G0_0_1 - 0.005375764924376*G0_0_2 + 0.022083694501229*G0_1_0 - 0.005375764924376*G0_1_1 - 0.005375764924376*G0_1_2 - 0.005375764924376*G0_2_0;
    A[924] = 0.018789081289081*G0_0_0 + 0.018789081289081*G0_0_1 + 0.009394540644540*G0_0_2 + 0.018789081289081*G0_1_0 + 0.018789081289081*G0_1_1 + 0.009394540644540*G0_1_2 + 0.009394540644540*G0_2_0 + 0.009394540644540*G0_2_1;
    A[925] = 0.006589226424296*G0_0_0 + 0.006589226424296*G0_0_1 + 0.003294613212148*G0_0_2 + 0.006589226424296*G0_1_0 + 0.006589226424296*G0_1_1 + 0.003294613212148*G0_1_2 + 0.003294613212148*G0_2_0 + 0.003294613212148*G0_2_1;
    A[926] = 0.018789081289081*G0_0_0 + 0.018789081289081*G0_0_1 + 0.009394540644541*G0_0_2 + 0.018789081289081*G0_1_0 + 0.018789081289081*G0_1_1 + 0.009394540644541*G0_1_2 + 0.009394540644541*G0_2_0 + 0.009394540644540*G0_2_1;
    A[927] = 0.029260079715808*G0_0_0 + 0.029260079715808*G0_0_1 + 0.025965466503661*G0_0_2 + 0.029260079715808*G0_1_0 + 0.029260079715808*G0_1_1 + 0.025965466503660*G0_1_2 + 0.025965466503661*G0_2_0 + 0.025965466503661*G0_2_1 + 0.022670853291513*G0_2_2;
    A[928] = 0.029260079715808*G0_0_0 + 0.029260079715808*G0_0_1 + 0.025965466503660*G0_0_2 + 0.029260079715808*G0_1_0 + 0.029260079715808*G0_1_1 + 0.025965466503660*G0_1_2 + 0.025965466503661*G0_2_0 + 0.025965466503661*G0_2_1 + 0.022670853291513*G0_2_2;
    A[929] = 0.064130787872107*G0_0_0 + 0.064130787872107*G0_0_1 + 0.054736247227566*G0_0_2 + 0.064130787872107*G0_1_0 + 0.064130787872107*G0_1_1 + 0.054736247227566*G0_1_2 + 0.054736247227567*G0_2_0 + 0.054736247227566*G0_2_1 + 0.045341706583026*G0_2_2;
    A[930] = -0.064456987200042*G0_0_0 - 0.257045070413123*G0_0_1 - 0.160751028806582*G0_0_2 - 0.064456987200042*G0_1_0 - 0.257045070413124*G0_1_1 - 0.160751028806582*G0_1_2 - 0.092901568596012*G0_2_0 - 0.160751028806583*G0_2_1 - 0.064456987200042*G0_2_2;
    A[931] = 0.043971669405696*G0_0_0 + 0.128522535206562*G0_0_1 + 0.086247102306129*G0_0_2 + 0.043971669405697*G0_1_0 + 0.128522535206562*G0_1_1 + 0.086247102306129*G0_1_2 + 0.044656687994361*G0_2_0 + 0.086247102306129*G0_2_1 + 0.043971669405696*G0_2_2;
    A[932] = -0.018789081289081*G0_0_0 - 0.061325473651862*G0_0_1 - 0.040057277470471*G0_0_2 - 0.018789081289081*G0_1_0 - 0.061325473651862*G0_1_1 - 0.040057277470471*G0_1_2 - 0.009394540644541*G0_2_0 - 0.040057277470472*G0_2_1 - 0.018789081289081*G0_2_2;
    A[933] = 0.127315597693200*G0_0_0 + 0.176636936077038*G0_0_1 + 0.134361503176606*G0_0_2 + 0.127315597693201*G0_1_0 + 0.176636936077038*G0_1_1 + 0.134361503176606*G0_1_2 + 0.128000616281865*G0_2_0 + 0.134361503176606*G0_2_1 + 0.092086070276173*G0_2_2;
    A[934] = -0.029260079715808*G0_0_0 - 0.043547610279380*G0_0_1 - 0.037708642309336*G0_0_2 - 0.029260079715808*G0_1_0 - 0.043547610279380*G0_1_1 - 0.037708642309336*G0_1_2 - 0.025965466503661*G0_2_0 - 0.037708642309336*G0_2_1 - 0.031869674339292*G0_2_2;
    A[935] = -0.064130787872107*G0_0_0 - 0.111886369481855*G0_0_1 - 0.090618173300464*G0_0_2 - 0.064130787872107*G0_1_0 - 0.111886369481855*G0_1_1 - 0.090618173300464*G0_1_2 - 0.054736247227567*G0_2_0 - 0.090618173300465*G0_2_1 - 0.069349977119074*G0_2_2;
    A[936] = -0.257045070413123*G0_0_0 - 0.064456987200041*G0_0_1 - 0.160751028806582*G0_0_2 - 0.257045070413123*G0_1_0 - 0.064456987200041*G0_1_1 - 0.160751028806583*G0_1_2 - 0.160751028806583*G0_2_0 - 0.092901568596012*G0_2_1 - 0.064456987200042*G0_2_2;
    A[937] = 0.128522535206561*G0_0_0 + 0.043971669405696*G0_0_1 + 0.086247102306129*G0_0_2 + 0.128522535206561*G0_1_0 + 0.043971669405696*G0_1_1 + 0.086247102306129*G0_1_2 + 0.086247102306130*G0_2_0 + 0.044656687994361*G0_2_1 + 0.043971669405697*G0_2_2;
    A[938] = -0.061325473651862*G0_0_0 - 0.018789081289081*G0_0_1 - 0.040057277470472*G0_0_2 - 0.061325473651862*G0_1_0 - 0.018789081289081*G0_1_1 - 0.040057277470471*G0_1_2 - 0.040057277470472*G0_2_0 - 0.009394540644540*G0_2_1 - 0.018789081289081*G0_2_2;
    A[939] = 0.176636936077038*G0_0_0 + 0.127315597693200*G0_0_1 + 0.134361503176606*G0_0_2 + 0.176636936077038*G0_1_0 + 0.127315597693200*G0_1_1 + 0.134361503176606*G0_1_2 + 0.134361503176606*G0_2_0 + 0.128000616281865*G0_2_1 + 0.092086070276173*G0_2_2;
    A[940] = -0.043547610279380*G0_0_0 - 0.029260079715808*G0_0_1 - 0.037708642309336*G0_0_2 - 0.043547610279380*G0_1_0 - 0.029260079715808*G0_1_1 - 0.037708642309336*G0_1_2 - 0.037708642309336*G0_2_0 - 0.025965466503661*G0_2_1 - 0.031869674339292*G0_2_2;
    A[941] = -0.111886369481855*G0_0_0 - 0.064130787872107*G0_0_1 - 0.090618173300464*G0_0_2 - 0.111886369481855*G0_1_0 - 0.064130787872107*G0_1_1 - 0.090618173300464*G0_1_2 - 0.090618173300464*G0_2_0 - 0.054736247227566*G0_2_1 - 0.069349977119074*G0_2_2;
    A[942] = -0.128522535206561*G0_0_0 - 0.128522535206562*G0_0_1 - 0.032228493600021*G0_0_2 - 0.128522535206561*G0_1_0 - 0.128522535206562*G0_1_1 - 0.032228493600021*G0_1_2 - 0.032228493600021*G0_2_0 - 0.032228493600021*G0_2_1 - 0.060673074995991*G0_2_2;
    A[943] = 0.064261267603281*G0_0_0 + 0.064261267603281*G0_0_1 + 0.021985834702848*G0_0_2 + 0.064261267603281*G0_1_0 + 0.064261267603281*G0_1_1 + 0.021985834702848*G0_1_2 + 0.021985834702849*G0_2_0 + 0.021985834702848*G0_2_1 + 0.022670853291513*G0_2_2;
    A[944] = -0.030662736825930*G0_0_0 - 0.030662736825931*G0_0_1 - 0.009394540644540*G0_0_2 - 0.030662736825931*G0_1_0 - 0.030662736825931*G0_1_1 - 0.009394540644540*G0_1_2 - 0.009394540644541*G0_2_0 - 0.009394540644541*G0_2_1;
    A[945] = 0.064261267603281*G0_0_0 + 0.064261267603281*G0_0_1 + 0.021985834702848*G0_0_2 + 0.064261267603281*G0_1_0 + 0.064261267603281*G0_1_1 + 0.021985834702848*G0_1_2 + 0.021985834702848*G0_2_0 + 0.021985834702848*G0_2_1 + 0.022670853291513*G0_2_2;
    A[946] = -0.009133581182192*G0_0_0 - 0.009133581182192*G0_0_1 - 0.003294613212148*G0_0_2 - 0.009133581182192*G0_1_0 - 0.009133581182192*G0_1_1 - 0.003294613212148*G0_1_2 - 0.003294613212148*G0_2_0 - 0.003294613212148*G0_2_1;
    A[947] = -0.030662736825931*G0_0_0 - 0.030662736825931*G0_0_1 - 0.009394540644540*G0_0_2 - 0.030662736825931*G0_1_0 - 0.030662736825931*G0_1_1 - 0.009394540644540*G0_1_2 - 0.009394540644540*G0_2_0 - 0.009394540644541*G0_2_1;
    A[948] = 0.096228801740952*G0_0_0 + 0.096228801740953*G0_0_1 + 0.131458329157980*G0_0_2 + 0.096228801740952*G0_1_0 + 0.096228801740953*G0_1_1 + 0.131458329157980*G0_1_2 + 0.131458329157980*G0_2_0 + 0.131458329157981*G0_2_1 + 0.166687856575007*G0_2_2;
    A[949] = -0.050560895829992*G0_0_0 - 0.050560895829992*G0_0_1 - 0.047951301206509*G0_0_2 - 0.050560895829992*G0_1_0 - 0.050560895829992*G0_1_1 - 0.047951301206508*G0_1_2 - 0.047951301206509*G0_2_0 - 0.047951301206509*G0_2_1 - 0.045341706583025*G0_2_2;
    A[950] = -0.050560895829992*G0_0_0 - 0.050560895829992*G0_0_1 - 0.047951301206509*G0_0_2 - 0.050560895829992*G0_1_0 - 0.050560895829992*G0_1_1 - 0.047951301206509*G0_1_2 - 0.047951301206509*G0_2_0 - 0.047951301206509*G0_2_1 - 0.045341706583025*G0_2_2;
    A[951] = -0.156575677409008*G0_0_0 - 0.156575677409009*G0_0_1 - 0.153966082785525*G0_0_2 - 0.156575677409009*G0_1_0 - 0.156575677409009*G0_1_1 - 0.153966082785525*G0_1_2 - 0.153966082785526*G0_2_0 - 0.153966082785526*G0_2_1 - 0.151356488162042*G0_2_2;
    A[952] = 0.021469134967399*G0_0_0 + 0.021469134967399*G0_0_1 + 0.021469134967399*G0_0_2 + 0.021469134967399*G0_1_0 + 0.021469134967399*G0_1_1 + 0.021469134967399*G0_1_2 + 0.055127686421089*G0_2_0 + 0.055127686421089*G0_2_1 + 0.055127686421089*G0_2_2;
    A[953] = -0.003365072266982*G0_0_0 - 0.003365072266982*G0_1_0;
    A[954] = -0.003365072266982*G0_0_1 - 0.003365072266982*G0_1_1;
    A[955] = -0.023263231271044*G0_0_2 - 0.023263231271044*G0_1_2 - 0.038817720024317*G0_2_2;
    A[956] = 0.013974379208754*G0_0_1 + 0.002289919282107*G0_0_2 + 0.013974379208754*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1;
    A[957] = -0.026304713804713*G0_0_1 - 0.013152356902357*G0_0_2 - 0.026304713804713*G0_1_1 - 0.013152356902357*G0_1_2 - 0.013152356902357*G0_2_1 + 0.000065239865587*G0_2_2;
    A[958] = -0.005232237220084*G0_0_1 - 0.005780252091016*G0_0_2 - 0.005232237220084*G0_1_1 - 0.005780252091016*G0_1_2 - 0.005780252091016*G0_2_1 - 0.006263027096360*G0_2_2;
    A[959] = -0.078894569454465*G0_0_1 - 0.059916292555181*G0_0_2 - 0.078894569454465*G0_1_1 - 0.059916292555181*G0_1_2 - 0.059916292555181*G0_2_1 - 0.031543475011357*G0_2_2;
    A[960] = 0.013974379208754*G0_0_0 + 0.002289919282107*G0_0_2 + 0.013974379208754*G0_1_0 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_0;
    A[961] = -0.026304713804713*G0_0_0 - 0.013152356902357*G0_0_2 - 0.026304713804714*G0_1_0 - 0.013152356902357*G0_1_2 - 0.013152356902357*G0_2_0 + 0.000065239865587*G0_2_2;
    A[962] = -0.005232237220084*G0_0_0 - 0.005780252091016*G0_0_2 - 0.005232237220084*G0_1_0 - 0.005780252091015*G0_1_2 - 0.005780252091016*G0_2_0 - 0.006263027096360*G0_2_2;
    A[963] = -0.078894569454465*G0_0_0 - 0.059916292555181*G0_0_2 - 0.078894569454465*G0_1_0 - 0.059916292555181*G0_1_2 - 0.059916292555181*G0_2_0 - 0.031543475011357*G0_2_2;
    A[964] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_1;
    A[965] = 0.001787572317086*G0_0_0 + 0.001787572317086*G0_0_1 + 0.001787572317086*G0_1_0 + 0.001787572317086*G0_1_1;
    A[966] = 0.001787572317086*G0_0_0 + 0.001787572317086*G0_0_1 + 0.001787572317086*G0_1_0 + 0.001787572317086*G0_1_1;
    A[967] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_1;
    A[968] = -0.147063705006412*G0_0_0 - 0.147063705006412*G0_0_1 - 0.108337320793917*G0_0_2 - 0.147063705006412*G0_1_0 - 0.147063705006412*G0_1_1 - 0.108337320793917*G0_1_2 - 0.173446706649830*G0_2_0 - 0.173446706649830*G0_2_1 - 0.243357746612953*G0_2_2;
    A[969] = 0.304226541205705*G0_0_0 + 0.304226541205705*G0_0_1 + 0.226095278178610*G0_0_2 + 0.304226541205705*G0_1_0 + 0.304226541205705*G0_1_1 + 0.226095278178610*G0_1_2 + 0.226095278178610*G0_2_0 + 0.226095278178610*G0_2_1 + 0.428965164208217*G0_2_2;
    A[970] = -0.204187731314466*G0_0_0 - 0.204187731314466*G0_0_1 - 0.219493003781197*G0_0_2 - 0.204187731314466*G0_1_0 - 0.204187731314466*G0_1_1 - 0.219493003781197*G0_1_2 - 0.167692550505050*G0_2_0 - 0.167692550505050*G0_2_1 - 0.387185554286246*G0_2_2;
    A[971] = 0.078894569454465*G0_0_0 + 0.078894569454465*G0_0_1 + 0.103529142700149*G0_0_2 + 0.078894569454465*G0_1_0 + 0.078894569454465*G0_1_1 + 0.103529142700149*G0_1_2 + 0.059916292555181*G0_2_0 + 0.059916292555181*G0_2_1 + 0.185268170294211*G0_2_2;
    A[972] = -0.057417605703195*G0_0_0 - 0.018691221490700*G0_0_1 - 0.057417605703195*G0_0_2 - 0.057417605703195*G0_1_0 - 0.018691221490700*G0_1_1 - 0.057417605703195*G0_1_2 + 0.012493434259927*G0_2_0 - 0.057417605703195*G0_2_1 + 0.012493434259927*G0_2_2;
    A[973] = 0.005062613569558*G0_0_0 + 0.000260959462348*G0_0_1 + 0.005062613569558*G0_0_2 + 0.005062613569558*G0_1_0 + 0.000260959462348*G0_1_1 + 0.005062613569558*G0_1_2 + 0.000260959462348*G0_2_0 + 0.005062613569558*G0_2_1 + 0.000260959462348*G0_2_2;
    A[974] = -0.000482775005344*G0_0_0 - 0.006263027096360*G0_0_1 - 0.000482775005344*G0_0_2 - 0.000482775005344*G0_1_0 - 0.006263027096360*G0_1_1 - 0.000482775005344*G0_1_2 + 0.000065239865587*G0_2_0 - 0.000482775005344*G0_2_1 + 0.000065239865587*G0_2_2;
    A[975] = -0.002289919282107*G0_0_0 + 0.006589226424296*G0_0_1 - 0.002289919282107*G0_0_2 - 0.002289919282107*G0_1_0 + 0.006589226424296*G0_1_1 - 0.002289919282107*G0_1_2 - 0.002289919282107*G0_2_1;
    A[976] = -0.018691221490700*G0_0_0 - 0.057417605703195*G0_0_1 - 0.057417605703195*G0_0_2 - 0.018691221490700*G0_1_0 - 0.057417605703195*G0_1_1 - 0.057417605703195*G0_1_2 - 0.057417605703195*G0_2_0 + 0.012493434259927*G0_2_1 + 0.012493434259927*G0_2_2;
    A[977] = 0.000260959462348*G0_0_0 + 0.005062613569558*G0_0_1 + 0.005062613569558*G0_0_2 + 0.000260959462348*G0_1_0 + 0.005062613569558*G0_1_1 + 0.005062613569558*G0_1_2 + 0.005062613569558*G0_2_0 + 0.000260959462348*G0_2_1 + 0.000260959462348*G0_2_2;
    A[978] = -0.006263027096360*G0_0_0 - 0.000482775005344*G0_0_1 - 0.000482775005344*G0_0_2 - 0.006263027096360*G0_1_0 - 0.000482775005344*G0_1_1 - 0.000482775005344*G0_1_2 - 0.000482775005344*G0_2_0 + 0.000065239865587*G0_2_1 + 0.000065239865587*G0_2_2;
    A[979] = 0.006589226424296*G0_0_0 - 0.002289919282107*G0_0_1 - 0.002289919282107*G0_0_2 + 0.006589226424296*G0_1_0 - 0.002289919282107*G0_1_1 - 0.002289919282107*G0_1_2 - 0.002289919282107*G0_2_0;
    A[980] = -0.014874689353856*G0_0_0 - 0.014874689353856*G0_0_1 + 0.000065239865587*G0_0_2 - 0.014874689353856*G0_1_0 - 0.014874689353856*G0_1_1 + 0.000065239865587*G0_1_2 + 0.000065239865587*G0_2_0 + 0.000065239865587*G0_2_1;
    A[981] = 0.004501550725509*G0_0_0 + 0.004501550725509*G0_0_1 + 0.002576974690690*G0_0_2 + 0.004501550725509*G0_1_0 + 0.004501550725509*G0_1_1 + 0.002576974690690*G0_1_2 + 0.002576974690690*G0_2_0 + 0.002576974690690*G0_2_1;
    A[982] = -0.014874689353856*G0_0_0 - 0.014874689353856*G0_0_1 + 0.000065239865587*G0_0_2 - 0.014874689353856*G0_1_0 - 0.014874689353856*G0_1_1 + 0.000065239865587*G0_1_2 + 0.000065239865587*G0_2_0 + 0.000065239865588*G0_2_1;
    A[983] = -0.018984800885842*G0_0_0 - 0.018984800885842*G0_0_1 - 0.009492400442922*G0_0_2 - 0.018984800885842*G0_1_0 - 0.018984800885842*G0_1_1 - 0.009492400442922*G0_1_2 - 0.009492400442922*G0_2_0 - 0.009492400442921*G0_2_1 - 0.000652398655871*G0_2_2;
    A[984] = -0.018984800885841*G0_0_0 - 0.018984800885842*G0_0_1 - 0.009492400442920*G0_0_2 - 0.018984800885841*G0_1_0 - 0.018984800885842*G0_1_1 - 0.009492400442921*G0_1_2 - 0.009492400442921*G0_2_0 - 0.009492400442921*G0_2_1 - 0.000652398655871*G0_2_2;
    A[985] = -0.127087258163647*G0_0_0 - 0.127087258163646*G0_0_1 - 0.089313375988723*G0_0_2 - 0.127087258163647*G0_1_0 - 0.127087258163647*G0_1_1 - 0.089313375988723*G0_1_2 - 0.089313375988723*G0_2_0 - 0.089313375988723*G0_2_1 - 0.066544662898829*G0_2_2;
    A[986] = 0.132306447410613*G0_0_0 + 0.121346149991982*G0_0_1 + 0.194675758911868*G0_0_2 + 0.132306447410613*G0_1_0 + 0.121346149991982*G0_1_1 + 0.194675758911868*G0_1_2 + 0.058976838490727*G0_2_0 + 0.194675758911868*G0_2_1 - 0.003392473010529*G0_2_2;
    A[987] = -0.043645470077761*G0_0_0 + 0.037186723384640*G0_0_1 - 0.037154103451846*G0_0_2 - 0.043645470077761*G0_1_0 + 0.037186723384640*G0_1_1 - 0.037154103451846*G0_1_2 - 0.009753359905269*G0_2_0 - 0.037154103451846*G0_2_1 - 0.006784946021057*G0_2_2;
    A[988] = 0.014874689353856*G0_0_0 - 0.025443547578964*G0_0_1 + 0.013635131907701*G0_0_2 + 0.014874689353856*G0_1_0 - 0.025443547578964*G0_1_1 + 0.013635131907701*G0_1_2 - 0.000065239865587*G0_2_0 + 0.013635131907701*G0_2_1 - 0.000130479731174*G0_2_2;
    A[989] = -0.166948816037356*G0_0_0 - 0.334680510461757*G0_0_1 - 0.250814663249557*G0_0_2 - 0.166948816037356*G0_1_0 - 0.334680510461758*G0_1_1 - 0.250814663249557*G0_1_2 - 0.160783648739377*G0_2_0 - 0.250814663249557*G0_2_1 - 0.062238831770081*G0_2_2;
    A[990] = 0.018984800885841*G0_0_0 + 0.056758683060765*G0_0_1 + 0.037871741973304*G0_0_2 + 0.018984800885842*G0_1_0 + 0.056758683060765*G0_1_1 + 0.037871741973304*G0_1_2 + 0.009492400442921*G0_2_0 + 0.037871741973304*G0_2_1 + 0.012787013655069*G0_2_2;
    A[991] = 0.127087258163647*G0_0_0 + 0.209419968534550*G0_0_1 + 0.173472802596065*G0_0_2 + 0.127087258163647*G0_1_0 + 0.209419968534550*G0_1_1 + 0.173472802596065*G0_1_2 + 0.089313375988723*G0_2_0 + 0.173472802596066*G0_2_1 + 0.084681345532040*G0_2_2;
    A[992] = 0.121346149991982*G0_0_0 + 0.132306447410612*G0_0_1 + 0.194675758911868*G0_0_2 + 0.121346149991982*G0_1_0 + 0.132306447410612*G0_1_1 + 0.194675758911868*G0_1_2 + 0.194675758911868*G0_2_0 + 0.058976838490727*G0_2_1 - 0.003392473010529*G0_2_2;
    A[993] = 0.037186723384640*G0_0_0 - 0.043645470077761*G0_0_1 - 0.037154103451846*G0_0_2 + 0.037186723384640*G0_1_0 - 0.043645470077761*G0_1_1 - 0.037154103451845*G0_1_2 - 0.037154103451847*G0_2_0 - 0.009753359905270*G0_2_1 - 0.006784946021057*G0_2_2;
    A[994] = -0.025443547578964*G0_0_0 + 0.014874689353856*G0_0_1 + 0.013635131907701*G0_0_2 - 0.025443547578964*G0_1_0 + 0.014874689353856*G0_1_1 + 0.013635131907701*G0_1_2 + 0.013635131907702*G0_2_0 - 0.000065239865587*G0_2_1 - 0.000130479731174*G0_2_2;
    A[995] = -0.334680510461757*G0_0_0 - 0.166948816037356*G0_0_1 - 0.250814663249556*G0_0_2 - 0.334680510461757*G0_1_0 - 0.166948816037356*G0_1_1 - 0.250814663249557*G0_1_2 - 0.250814663249556*G0_2_0 - 0.160783648739376*G0_2_1 - 0.062238831770081*G0_2_2;
    A[996] = 0.056758683060765*G0_0_0 + 0.018984800885842*G0_0_1 + 0.037871741973303*G0_0_2 + 0.056758683060765*G0_1_0 + 0.018984800885842*G0_1_1 + 0.037871741973303*G0_1_2 + 0.037871741973303*G0_2_0 + 0.009492400442921*G0_2_1 + 0.012787013655069*G0_2_2;
    A[997] = 0.209419968534550*G0_0_0 + 0.127087258163647*G0_0_1 + 0.173472802596065*G0_0_2 + 0.209419968534550*G0_1_0 + 0.127087258163647*G0_1_1 + 0.173472802596066*G0_1_2 + 0.173472802596065*G0_2_0 + 0.089313375988723*G0_2_1 + 0.084681345532040*G0_2_2;
    A[998] = 0.047625101878573*G0_0_0 + 0.047625101878573*G0_0_1 - 0.014744209622682*G0_0_2 + 0.047625101878573*G0_1_0 + 0.047625101878574*G0_1_1 - 0.014744209622682*G0_1_2 - 0.014744209622682*G0_2_0 - 0.014744209622682*G0_2_1 + 0.047625101878574*G0_2_2;
    A[999] = 0.008807381854257*G0_0_0 + 0.008807381854257*G0_0_1 + 0.002316015228342*G0_0_2 + 0.008807381854257*G0_1_0 + 0.008807381854257*G0_1_1 + 0.002316015228342*G0_1_2 + 0.002316015228341*G0_2_0 + 0.002316015228341*G0_2_1 - 0.000652398655871*G0_2_2;
    A[1000] = -0.001304797311742*G0_0_0 - 0.001304797311742*G0_0_1 - 0.000065239865587*G0_0_2 - 0.001304797311742*G0_1_0 - 0.001304797311742*G0_1_1 - 0.000065239865587*G0_1_2 - 0.000065239865587*G0_2_0 - 0.000065239865587*G0_2_1;
    A[1001] = 0.008807381854257*G0_0_0 + 0.008807381854257*G0_0_1 + 0.002316015228342*G0_0_2 + 0.008807381854257*G0_1_0 + 0.008807381854257*G0_1_1 + 0.002316015228342*G0_1_2 + 0.002316015228342*G0_2_0 + 0.002316015228342*G0_2_1 - 0.000652398655871*G0_2_2;
    A[1002] = -0.015657567740901*G0_0_0 - 0.015657567740901*G0_0_1 - 0.002576974690690*G0_0_2 - 0.015657567740901*G0_1_0 - 0.015657567740901*G0_1_1 - 0.002576974690690*G0_1_2 - 0.002576974690690*G0_2_0 - 0.002576974690690*G0_2_1;
    A[1003] = -0.001304797311742*G0_0_0 - 0.001304797311742*G0_0_1 - 0.000065239865587*G0_0_2 - 0.001304797311742*G0_1_0 - 0.001304797311742*G0_1_1 - 0.000065239865587*G0_1_2 - 0.000065239865587*G0_2_0 - 0.000065239865587*G0_2_1;
    A[1004] = -0.156575677409009*G0_0_0 - 0.156575677409009*G0_0_1 - 0.066218463570893*G0_0_2 - 0.156575677409009*G0_1_0 - 0.156575677409009*G0_1_1 - 0.066218463570893*G0_1_2 - 0.066218463570893*G0_2_0 - 0.066218463570894*G0_2_1 - 0.161794866655976*G0_2_2;
    A[1005] = 0.039143919352252*G0_0_0 + 0.039143919352252*G0_0_1 + 0.007176385214580*G0_0_2 + 0.039143919352252*G0_1_0 + 0.039143919352252*G0_1_1 + 0.007176385214580*G0_1_2 + 0.007176385214579*G0_2_0 + 0.007176385214580*G0_2_1 + 0.001304797311742*G0_2_2;
    A[1006] = 0.039143919352252*G0_0_0 + 0.039143919352252*G0_0_1 + 0.007176385214579*G0_0_2 + 0.039143919352253*G0_1_0 + 0.039143919352252*G0_1_1 + 0.007176385214579*G0_1_2 + 0.007176385214579*G0_2_0 + 0.007176385214579*G0_2_1 + 0.001304797311742*G0_2_2;
    A[1007] = 0.185933616923198*G0_0_0 + 0.185933616923197*G0_0_1 + 0.170276049182297*G0_0_2 + 0.185933616923198*G0_1_0 + 0.185933616923197*G0_1_1 + 0.170276049182297*G0_1_2 + 0.170276049182298*G0_2_0 + 0.170276049182298*G0_2_1 + 0.180714427676232*G0_2_2;
    A[1008] = -0.015554488753273*G0_0_0 - 0.015554488753273*G0_0_1 - 0.015554488753273*G0_0_2 - 0.015554488753273*G0_1_0 - 0.015554488753273*G0_1_1 - 0.015554488753273*G0_1_2 - 0.038817720024317*G0_2_0 - 0.038817720024317*G0_2_1 - 0.038817720024317*G0_2_2;
    A[1009] = -0.003365072266982*G0_0_0 - 0.003365072266982*G0_1_0;
    A[1010] = -0.003365072266982*G0_0_1 - 0.003365072266982*G0_1_1;
    A[1011] = 0.033658551453690*G0_0_2 + 0.033658551453690*G0_1_2 + 0.055127686421089*G0_2_2;
    A[1012] = 0.011169064988509*G0_0_1 + 0.002289919282107*G0_0_2 + 0.011169064988509*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1;
    A[1013] = -0.005232237220084*G0_0_1 + 0.000548014870931*G0_0_2 - 0.005232237220085*G0_1_1 + 0.000548014870931*G0_1_2 + 0.000548014870932*G0_2_1 + 0.000065239865587*G0_2_2;
    A[1014] = -0.009603308214419*G0_0_1 - 0.004801654107209*G0_0_2 - 0.009603308214419*G0_1_1 - 0.004801654107209*G0_1_2 - 0.004801654107210*G0_2_1 + 0.000260959462348*G0_2_2;
    A[1015] = 0.108637424175618*G0_0_1 + 0.069911039963123*G0_0_2 + 0.108637424175618*G0_1_1 + 0.069911039963123*G0_1_2 + 0.069911039963123*G0_2_1 + 0.012493434259928*G0_2_2;
    A[1016] = 0.011169064988509*G0_0_0 + 0.002289919282107*G0_0_2 + 0.011169064988509*G0_1_0 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_0;
    A[1017] = -0.005232237220084*G0_0_0 + 0.000548014870932*G0_0_2 - 0.005232237220084*G0_1_0 + 0.000548014870932*G0_1_2 + 0.000548014870932*G0_2_0 + 0.000065239865587*G0_2_2;
    A[1018] = -0.009603308214420*G0_0_0 - 0.004801654107210*G0_0_2 - 0.009603308214420*G0_1_0 - 0.004801654107210*G0_1_2 - 0.004801654107210*G0_2_0 + 0.000260959462348*G0_2_2;
    A[1019] = 0.108637424175618*G0_0_0 + 0.069911039963123*G0_0_2 + 0.108637424175618*G0_1_0 + 0.069911039963123*G0_1_2 + 0.069911039963123*G0_2_0 + 0.012493434259928*G0_2_2;
    A[1020] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_1;
    A[1021] = 0.001787572317086*G0_0_0 + 0.001787572317086*G0_0_1 + 0.001787572317086*G0_1_0 + 0.001787572317086*G0_1_1;
    A[1022] = 0.001787572317086*G0_0_0 + 0.001787572317086*G0_0_1 + 0.001787572317086*G0_1_0 + 0.001787572317086*G0_1_1;
    A[1023] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_1;
    A[1024] = 0.100717304493345*G0_0_0 + 0.100717304493346*G0_0_1 + 0.081739027594062*G0_0_2 + 0.100717304493345*G0_1_0 + 0.100717304493345*G0_1_1 + 0.081739027594062*G0_1_2 + 0.125351877739030*G0_2_0 + 0.125351877739030*G0_2_1 + 0.185268170294211*G0_2_2;
    A[1025] = -0.204187731314466*G0_0_0 - 0.204187731314466*G0_0_1 - 0.167692550505050*G0_0_2 - 0.204187731314466*G0_1_0 - 0.204187731314466*G0_1_1 - 0.167692550505050*G0_1_2 - 0.219493003781197*G0_2_0 - 0.219493003781197*G0_2_1 - 0.387185554286246*G0_2_2;
    A[1026] = 0.281001149056703*G0_0_0 + 0.281001149056703*G0_0_1 + 0.202869886029607*G0_0_2 + 0.281001149056703*G0_1_0 + 0.281001149056703*G0_1_1 + 0.202869886029607*G0_1_2 + 0.202869886029607*G0_2_0 + 0.202869886029607*G0_2_1 + 0.428965164208217*G0_2_2;
    A[1027] = -0.108637424175618*G0_0_0 - 0.108637424175618*G0_0_1 - 0.135020425819037*G0_0_2 - 0.108637424175618*G0_1_0 - 0.108637424175618*G0_1_1 - 0.135020425819037*G0_1_2 - 0.069911039963123*G0_2_0 - 0.069911039963123*G0_2_1 - 0.243357746612954*G0_2_2;
    A[1028] = 0.028372817543824*G0_0_0 + 0.009394540644541*G0_0_1 + 0.028372817543824*G0_0_2 + 0.028372817543824*G0_1_0 + 0.009394540644541*G0_1_1 + 0.028372817543824*G0_1_2 - 0.031543475011357*G0_2_0 + 0.028372817543824*G0_2_1 - 0.031543475011357*G0_2_2;
    A[1029] = -0.000482775005345*G0_0_0 + 0.000065239865587*G0_0_1 - 0.000482775005345*G0_0_2 - 0.000482775005345*G0_1_0 + 0.000065239865587*G0_1_1 - 0.000482775005345*G0_1_2 - 0.006263027096360*G0_2_0 - 0.000482775005344*G0_2_1 - 0.006263027096360*G0_2_2;
    A[1030] = 0.013217596767944*G0_0_0 + 0.000065239865587*G0_0_1 + 0.013217596767944*G0_0_2 + 0.013217596767944*G0_1_0 + 0.000065239865587*G0_1_1 + 0.013217596767944*G0_1_2 + 0.000065239865587*G0_2_0 + 0.013217596767944*G0_2_1 + 0.000065239865587*G0_2_2;
    A[1031] = -0.002289919282107*G0_0_0 + 0.009394540644541*G0_0_1 - 0.002289919282107*G0_0_2 - 0.002289919282107*G0_1_0 + 0.009394540644541*G0_1_1 - 0.002289919282107*G0_1_2 - 0.002289919282107*G0_2_1;
    A[1032] = 0.009394540644540*G0_0_0 + 0.028372817543824*G0_0_1 + 0.028372817543824*G0_0_2 + 0.009394540644540*G0_1_0 + 0.028372817543824*G0_1_1 + 0.028372817543824*G0_1_2 + 0.028372817543824*G0_2_0 - 0.031543475011357*G0_2_1 - 0.031543475011357*G0_2_2;
    A[1033] = 0.000065239865587*G0_0_0 - 0.000482775005344*G0_0_1 - 0.000482775005344*G0_0_2 + 0.000065239865587*G0_1_0 - 0.000482775005344*G0_1_1 - 0.000482775005344*G0_1_2 - 0.000482775005344*G0_2_0 - 0.006263027096360*G0_2_1 - 0.006263027096360*G0_2_2;
    A[1034] = 0.000065239865587*G0_0_0 + 0.013217596767944*G0_0_1 + 0.013217596767944*G0_0_2 + 0.000065239865587*G0_1_0 + 0.013217596767944*G0_1_1 + 0.013217596767944*G0_1_2 + 0.013217596767944*G0_2_0 + 0.000065239865587*G0_2_1 + 0.000065239865587*G0_2_2;
    A[1035] = 0.009394540644541*G0_0_0 - 0.002289919282107*G0_0_1 - 0.002289919282107*G0_0_2 + 0.009394540644541*G0_1_0 - 0.002289919282106*G0_1_1 - 0.002289919282107*G0_1_2 - 0.002289919282107*G0_2_0;
    A[1036] = -0.001174317580568*G0_0_0 - 0.001174317580567*G0_0_1 + 0.000065239865587*G0_0_2 - 0.001174317580567*G0_1_0 - 0.001174317580567*G0_1_1 + 0.000065239865587*G0_1_2 + 0.000065239865587*G0_2_0 + 0.000065239865587*G0_2_1;
    A[1037] = -0.010503618359521*G0_0_0 - 0.010503618359521*G0_0_1 + 0.002576974690690*G0_0_2 - 0.010503618359521*G0_1_0 - 0.010503618359521*G0_1_1 + 0.002576974690690*G0_1_2 + 0.002576974690690*G0_2_0 + 0.002576974690690*G0_2_1;
    A[1038] = -0.001174317580568*G0_0_0 - 0.001174317580568*G0_0_1 + 0.000065239865587*G0_0_2 - 0.001174317580568*G0_1_0 - 0.001174317580568*G0_1_1 + 0.000065239865587*G0_1_2 + 0.000065239865587*G0_2_0 + 0.000065239865587*G0_2_1;
    A[1039] = 0.003522952741702*G0_0_0 + 0.003522952741702*G0_0_1 - 0.002968413884212*G0_0_2 + 0.003522952741702*G0_1_0 + 0.003522952741702*G0_1_1 - 0.002968413884212*G0_1_2 - 0.002968413884212*G0_2_0 - 0.002968413884213*G0_2_1 - 0.000652398655870*G0_2_2;
    A[1040] = 0.003522952741702*G0_0_0 + 0.003522952741703*G0_0_1 - 0.002968413884213*G0_0_2 + 0.003522952741702*G0_1_0 + 0.003522952741703*G0_1_1 - 0.002968413884213*G0_1_2 - 0.002968413884213*G0_2_0 - 0.002968413884212*G0_2_1 - 0.000652398655870*G0_2_2;
    A[1041] = 0.124738623002512*G0_0_0 + 0.124738623002511*G0_0_1 + 0.062369311501256*G0_0_2 + 0.124738623002512*G0_1_0 + 0.124738623002512*G0_1_1 + 0.062369311501256*G0_1_2 + 0.062369311501256*G0_2_0 + 0.062369311501256*G0_2_1 + 0.047625101878574*G0_2_2;
    A[1042] = -0.051017574889102*G0_0_0 - 0.052844291125541*G0_0_1 - 0.088791457064026*G0_0_2 - 0.051017574889102*G0_1_0 - 0.052844291125541*G0_1_1 - 0.088791457064026*G0_1_2 - 0.004632030456683*G0_2_0 - 0.088791457064026*G0_2_1 + 0.084681345532039*G0_2_2;
    A[1043] = -0.015592327875314*G0_0_0 - 0.006197787230773*G0_0_1 - 0.025084728318235*G0_0_2 - 0.015592327875314*G0_1_0 - 0.006197787230773*G0_1_1 - 0.025084728318235*G0_1_2 + 0.003294613212148*G0_2_0 - 0.025084728318235*G0_2_1 + 0.012787013655069*G0_2_2;
    A[1044] = 0.001174317580568*G0_0_0 - 0.052844291125541*G0_0_1 - 0.013765611638875*G0_0_2 + 0.001174317580568*G0_1_0 - 0.052844291125541*G0_1_1 - 0.013765611638875*G0_1_2 - 0.000065239865587*G0_2_0 - 0.013765611638876*G0_2_1 - 0.000130479731174*G0_2_2;
    A[1045] = 0.182410664181496*G0_0_0 + 0.104709984267275*G0_0_1 + 0.188575831479475*G0_0_2 + 0.182410664181496*G0_1_0 + 0.104709984267275*G0_1_1 + 0.188575831479475*G0_1_2 + 0.098544816969296*G0_2_0 + 0.188575831479476*G0_2_1 - 0.062238831770081*G0_2_2;
    A[1046] = -0.003522952741703*G0_0_0 + 0.104709984267276*G0_0_1 + 0.030369157430789*G0_0_2 - 0.003522952741703*G0_1_0 + 0.104709984267276*G0_1_1 + 0.030369157430789*G0_1_2 + 0.002968413884213*G0_2_0 + 0.030369157430789*G0_2_1 - 0.006784946021057*G0_2_2;
    A[1047] = -0.124738623002512*G0_0_0 - 0.271397840842284*G0_0_1 - 0.198068231922397*G0_0_2 - 0.124738623002512*G0_1_0 - 0.271397840842284*G0_1_1 - 0.198068231922397*G0_1_2 - 0.062369311501257*G0_2_0 - 0.198068231922398*G0_2_1 - 0.003392473010529*G0_2_2;
    A[1048] = -0.052844291125540*G0_0_0 - 0.051017574889102*G0_0_1 - 0.088791457064026*G0_0_2 - 0.052844291125540*G0_1_0 - 0.051017574889102*G0_1_1 - 0.088791457064026*G0_1_2 - 0.088791457064026*G0_2_0 - 0.004632030456683*G0_2_1 + 0.084681345532039*G0_2_2;
    A[1049] = -0.006197787230773*G0_0_0 - 0.015592327875314*G0_0_1 - 0.025084728318235*G0_0_2 - 0.006197787230773*G0_1_0 - 0.015592327875314*G0_1_1 - 0.025084728318235*G0_1_2 - 0.025084728318235*G0_2_0 + 0.003294613212148*G0_2_1 + 0.012787013655069*G0_2_2;
    A[1050] = -0.052844291125541*G0_0_0 + 0.001174317580567*G0_0_1 - 0.013765611638876*G0_0_2 - 0.052844291125541*G0_1_0 + 0.001174317580568*G0_1_1 - 0.013765611638876*G0_1_2 - 0.013765611638876*G0_2_0 - 0.000065239865587*G0_2_1 - 0.000130479731174*G0_2_2;
    A[1051] = 0.104709984267275*G0_0_0 + 0.182410664181496*G0_0_1 + 0.188575831479476*G0_0_2 + 0.104709984267275*G0_1_0 + 0.182410664181496*G0_1_1 + 0.188575831479476*G0_1_2 + 0.188575831479475*G0_2_0 + 0.098544816969295*G0_2_1 - 0.062238831770081*G0_2_2;
    A[1052] = 0.104709984267276*G0_0_0 - 0.003522952741702*G0_0_1 + 0.030369157430790*G0_0_2 + 0.104709984267276*G0_1_0 - 0.003522952741702*G0_1_1 + 0.030369157430790*G0_1_2 + 0.030369157430790*G0_2_0 + 0.002968413884213*G0_2_1 - 0.006784946021056*G0_2_2;
    A[1053] = -0.271397840842283*G0_0_0 - 0.124738623002512*G0_0_1 - 0.198068231922398*G0_0_2 - 0.271397840842283*G0_1_0 - 0.124738623002512*G0_1_1 - 0.198068231922398*G0_1_2 - 0.198068231922398*G0_2_0 - 0.062369311501256*G0_2_1 - 0.003392473010529*G0_2_2;
    A[1054] = -0.015005169085030*G0_0_0 - 0.015005169085030*G0_0_1 + 0.022768713089894*G0_0_2 - 0.015005169085030*G0_1_0 - 0.015005169085030*G0_1_1 + 0.022768713089893*G0_1_2 + 0.022768713089893*G0_2_0 + 0.022768713089894*G0_2_1 - 0.066544662898829*G0_2_2;
    A[1055] = -0.000652398655871*G0_0_0 - 0.000652398655871*G0_0_1 + 0.008840001787050*G0_0_2 - 0.000652398655871*G0_1_0 - 0.000652398655871*G0_1_1 + 0.008840001787050*G0_1_2 + 0.008840001787051*G0_2_0 + 0.008840001787050*G0_2_1 - 0.000652398655871*G0_2_2;
    A[1056] = -0.015005169085030*G0_0_0 - 0.015005169085030*G0_0_1 - 0.000065239865587*G0_0_2 - 0.015005169085030*G0_1_0 - 0.015005169085030*G0_1_1 - 0.000065239865587*G0_1_2 - 0.000065239865587*G0_2_0 - 0.000065239865587*G0_2_1;
    A[1057] = -0.000652398655871*G0_0_0 - 0.000652398655871*G0_0_1 + 0.008840001787050*G0_0_2 - 0.000652398655871*G0_1_0 - 0.000652398655871*G0_1_1 + 0.008840001787050*G0_1_2 + 0.008840001787050*G0_2_0 + 0.008840001787050*G0_2_1 - 0.000652398655871*G0_2_2;
    A[1058] = -0.000652398655871*G0_0_0 - 0.000652398655871*G0_0_1 - 0.002576974690690*G0_0_2 - 0.000652398655871*G0_1_0 - 0.000652398655871*G0_1_1 - 0.002576974690690*G0_1_2 - 0.002576974690690*G0_2_0 - 0.002576974690690*G0_2_1;
    A[1059] = -0.015005169085030*G0_0_0 - 0.015005169085030*G0_0_1 - 0.000065239865587*G0_0_2 - 0.015005169085030*G0_1_0 - 0.015005169085030*G0_1_1 - 0.000065239865587*G0_1_2 - 0.000065239865587*G0_2_0 - 0.000065239865587*G0_2_1;
    A[1060] = 0.026095946234834*G0_0_0 + 0.026095946234835*G0_0_1 + 0.010438378493934*G0_0_2 + 0.026095946234834*G0_1_0 + 0.026095946234835*G0_1_1 + 0.010438378493934*G0_1_2 + 0.010438378493933*G0_2_0 + 0.010438378493934*G0_2_1 + 0.180714427676232*G0_2_2;
    A[1061] = 0.026095946234835*G0_0_0 + 0.026095946234835*G0_0_1 - 0.005871587902838*G0_0_2 + 0.026095946234836*G0_1_0 + 0.026095946234835*G0_1_1 - 0.005871587902838*G0_1_2 - 0.005871587902837*G0_2_0 - 0.005871587902838*G0_2_1 + 0.001304797311741*G0_2_2;
    A[1062] = 0.026095946234834*G0_0_0 + 0.026095946234835*G0_0_1 - 0.005871587902838*G0_0_2 + 0.026095946234834*G0_1_0 + 0.026095946234835*G0_1_1 - 0.005871587902838*G0_1_2 - 0.005871587902838*G0_2_0 - 0.005871587902838*G0_2_1 + 0.001304797311742*G0_2_2;
    A[1063] = -0.185933616923198*G0_0_0 - 0.185933616923198*G0_0_1 - 0.095576403085083*G0_0_2 - 0.185933616923198*G0_1_0 - 0.185933616923198*G0_1_1 - 0.095576403085083*G0_1_2 - 0.095576403085084*G0_2_0 - 0.095576403085083*G0_2_1 - 0.161794866655977*G0_2_2;
    A[1064] = 0.004800349309898*G0_0_0 + 0.004800349309898*G0_0_1 + 0.004800349309898*G0_0_2 + 0.004800349309898*G0_1_0 + 0.004800349309898*G0_1_1 + 0.004800349309898*G0_1_2 + 0.015331368412966*G0_2_0 + 0.015331368412966*G0_2_1 + 0.015331368412966*G0_2_2;
    A[1065] = -0.004800349309898*G0_0_0 - 0.004800349309898*G0_1_0;
    A[1066] = -0.004800349309898*G0_0_1 - 0.004800349309898*G0_1_1;
    A[1067] = -0.037257182439474*G0_0_2 - 0.037257182439474*G0_1_2 - 0.055127686421089*G0_2_2;
    A[1068] = 0.032835224349981*G0_0_1 + 0.005375764924376*G0_0_2 + 0.032835224349981*G0_1_1 + 0.005375764924376*G0_1_2 + 0.005375764924376*G0_2_1;
    A[1069] = -0.078894569454465*G0_0_1 - 0.018978276899283*G0_0_2 - 0.078894569454465*G0_1_1 - 0.018978276899283*G0_1_2 - 0.018978276899284*G0_2_1 + 0.009394540644541*G0_2_2;
    A[1070] = 0.108637424175618*G0_0_1 + 0.038726384212495*G0_0_2 + 0.108637424175618*G0_1_1 + 0.038726384212495*G0_1_2 + 0.038726384212495*G0_2_1 - 0.018691221490700*G0_2_2;
    A[1071] = -0.139822079926246*G0_0_1 - 0.069911039963123*G0_0_2 - 0.139822079926246*G0_1_1 - 0.069911039963123*G0_1_2 - 0.069911039963123*G0_2_1 + 0.019637199541713*G0_2_2;
    A[1072] = 0.032835224349981*G0_0_0 + 0.005375764924376*G0_0_2 + 0.032835224349981*G0_1_0 + 0.005375764924376*G0_1_2 + 0.005375764924376*G0_2_0;
    A[1073] = -0.078894569454465*G0_0_0 - 0.018978276899284*G0_0_2 - 0.078894569454465*G0_1_0 - 0.018978276899284*G0_1_2 - 0.018978276899284*G0_2_0 + 0.009394540644540*G0_2_2;
    A[1074] = 0.108637424175618*G0_0_0 + 0.038726384212495*G0_0_2 + 0.108637424175618*G0_1_0 + 0.038726384212495*G0_1_2 + 0.038726384212495*G0_2_0 - 0.018691221490700*G0_2_2;
    A[1075] = -0.139822079926246*G0_0_0 - 0.069911039963123*G0_0_2 - 0.139822079926246*G0_1_0 - 0.069911039963123*G0_1_2 - 0.069911039963123*G0_2_0 + 0.019637199541713*G0_2_2;
    A[1076] = 0.005375764924376*G0_0_0 + 0.005375764924376*G0_0_1 + 0.005375764924376*G0_1_0 + 0.005375764924376*G0_1_1;
    A[1077] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_1;
    A[1078] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.002289919282107*G0_1_1;
    A[1079] = 0.005375764924376*G0_0_0 + 0.005375764924376*G0_0_1 + 0.005375764924376*G0_1_0 + 0.005375764924376*G0_1_1;
    A[1080] = -0.032835224349981*G0_0_0 - 0.032835224349981*G0_0_1 - 0.027459459425605*G0_0_2 - 0.032835224349981*G0_1_0 - 0.032835224349981*G0_1_1 - 0.027459459425605*G0_1_2 - 0.053751125257201*G0_2_0 - 0.053751125257201*G0_2_1 - 0.081210584682806*G0_2_2;
    A[1081] = 0.078894569454465*G0_0_0 + 0.078894569454465*G0_0_1 + 0.059916292555181*G0_0_2 + 0.078894569454465*G0_1_0 + 0.078894569454465*G0_1_1 + 0.059916292555181*G0_1_2 + 0.103529142700149*G0_2_0 + 0.103529142700149*G0_2_1 + 0.185268170294211*G0_2_2;
    A[1082] = -0.108637424175618*G0_0_0 - 0.108637424175618*G0_0_1 - 0.069911039963123*G0_0_2 - 0.108637424175618*G0_1_0 - 0.108637424175618*G0_1_1 - 0.069911039963123*G0_1_2 - 0.135020425819037*G0_2_0 - 0.135020425819037*G0_2_1 - 0.243357746612954*G0_2_2;
    A[1083] = 0.139822079926246*G0_0_0 + 0.139822079926246*G0_0_1 + 0.069911039963123*G0_0_2 + 0.139822079926246*G0_1_0 + 0.139822079926246*G0_1_1 + 0.069911039963123*G0_1_2 + 0.069911039963123*G0_2_0 + 0.069911039963123*G0_2_1 + 0.179096479009673*G0_2_2;
    A[1084] = -0.005375764924376*G0_0_0 - 0.005375764924376*G0_0_2 - 0.005375764924376*G0_1_0 - 0.005375764924376*G0_1_2 + 0.022083694501229*G0_2_0 - 0.005375764924376*G0_2_1 + 0.022083694501229*G0_2_2;
    A[1085] = -0.002289919282107*G0_0_0 - 0.002289919282107*G0_0_2 - 0.002289919282107*G0_1_0 - 0.002289919282107*G0_1_2 + 0.006589226424296*G0_2_0 - 0.002289919282107*G0_2_1 + 0.006589226424296*G0_2_2;
    A[1086] = -0.002289919282107*G0_0_0 - 0.002289919282107*G0_0_2 - 0.002289919282107*G0_1_0 - 0.002289919282107*G0_1_2 + 0.009394540644541*G0_2_0 - 0.002289919282107*G0_2_1 + 0.009394540644541*G0_2_2;
    A[1087] = -0.005375764924376*G0_0_0 - 0.005375764924376*G0_0_2 - 0.005375764924376*G0_1_0 - 0.005375764924376*G0_1_2 - 0.005375764924376*G0_2_1;
    A[1088] = -0.005375764924376*G0_0_1 - 0.005375764924376*G0_0_2 - 0.005375764924376*G0_1_1 - 0.005375764924376*G0_1_2 - 0.005375764924376*G0_2_0 + 0.022083694501229*G0_2_1 + 0.022083694501229*G0_2_2;
    A[1089] = -0.002289919282107*G0_0_1 - 0.002289919282107*G0_0_2 - 0.002289919282107*G0_1_1 - 0.002289919282107*G0_1_2 - 0.002289919282107*G0_2_0 + 0.006589226424296*G0_2_1 + 0.006589226424296*G0_2_2;
    A[1090] = -0.002289919282107*G0_0_1 - 0.002289919282107*G0_0_2 - 0.002289919282107*G0_1_1 - 0.002289919282107*G0_1_2 - 0.002289919282107*G0_2_0 + 0.009394540644541*G0_2_1 + 0.009394540644541*G0_2_2;
    A[1091] = -0.005375764924376*G0_0_1 - 0.005375764924376*G0_0_2 - 0.005375764924376*G0_1_1 - 0.005375764924376*G0_1_2 - 0.005375764924376*G0_2_0;
    A[1092] = -0.011873655536850*G0_0_0 - 0.011873655536850*G0_0_1 + 0.009394540644540*G0_0_2 - 0.011873655536850*G0_1_0 - 0.011873655536850*G0_1_1 + 0.009394540644540*G0_1_2 + 0.009394540644541*G0_2_0 + 0.009394540644541*G0_2_1;
    A[1093] = -0.002544354757896*G0_0_0 - 0.002544354757897*G0_0_1 + 0.003294613212148*G0_0_2 - 0.002544354757896*G0_1_0 - 0.002544354757897*G0_1_1 + 0.003294613212148*G0_1_2 + 0.003294613212148*G0_2_0 + 0.003294613212148*G0_2_1;
    A[1094] = -0.011873655536850*G0_0_0 - 0.011873655536850*G0_0_1 + 0.009394540644540*G0_0_2 - 0.011873655536850*G0_1_0 - 0.011873655536850*G0_1_1 + 0.009394540644540*G0_1_2 + 0.009394540644541*G0_2_0 + 0.009394540644541*G0_2_1;
    A[1095] = 0.042960451489097*G0_0_0 + 0.042960451489097*G0_0_1 + 0.000685018588664*G0_0_2 + 0.042960451489097*G0_1_0 + 0.042960451489097*G0_1_1 + 0.000685018588664*G0_1_2 + 0.000685018588664*G0_2_0 + 0.000685018588665*G0_2_1 + 0.022670853291512*G0_2_2;
    A[1096] = 0.042960451489098*G0_0_0 + 0.042960451489097*G0_0_1 + 0.000685018588665*G0_0_2 + 0.042960451489097*G0_1_0 + 0.042960451489097*G0_1_1 + 0.000685018588665*G0_1_2 + 0.000685018588664*G0_2_0 + 0.000685018588664*G0_2_1 + 0.022670853291512*G0_2_2;
    A[1097] = -0.124738623002512*G0_0_0 - 0.124738623002512*G0_0_1 - 0.028444581395971*G0_0_2 - 0.124738623002512*G0_1_0 - 0.124738623002512*G0_1_1 - 0.028444581395971*G0_1_2 - 0.028444581395971*G0_2_0 - 0.028444581395971*G0_2_1 - 0.060673074995992*G0_2_2;
    A[1098] = 0.011873655536850*G0_0_0 + 0.021268196181390*G0_0_2 + 0.011873655536850*G0_1_0 + 0.021268196181390*G0_1_2 - 0.014613729891508*G0_2_0 + 0.021268196181390*G0_2_1 - 0.069349977119074*G0_2_2;
    A[1099] = 0.002544354757896*G0_0_0 + 0.005838967970044*G0_0_2 + 0.002544354757896*G0_1_0 + 0.005838967970044*G0_1_2 - 0.005904207835632*G0_2_0 + 0.005838967970044*G0_2_1 - 0.031869674339292*G0_2_2;
    A[1100] = 0.011873655536850*G0_0_0 + 0.021268196181390*G0_0_2 + 0.011873655536850*G0_1_0 + 0.021268196181390*G0_1_2 - 0.009394540644541*G0_2_0 + 0.021268196181391*G0_2_1 - 0.018789081289081*G0_2_2;
    A[1101] = -0.042960451489097*G0_0_0 - 0.042275432900433*G0_0_2 - 0.042960451489097*G0_1_0 - 0.042275432900433*G0_1_2 - 0.035914546005692*G0_2_0 - 0.042275432900433*G0_2_1 + 0.092086070276174*G0_2_2;
    A[1102] = -0.042960451489097*G0_0_0 - 0.042275432900432*G0_0_2 - 0.042960451489097*G0_1_0 - 0.042275432900432*G0_1_2 - 0.000685018588664*G0_2_0 - 0.042275432900433*G0_2_1 + 0.043971669405697*G0_2_2;
    A[1103] = 0.124738623002512*G0_0_0 + 0.096294041606541*G0_0_2 + 0.124738623002512*G0_1_0 + 0.096294041606541*G0_1_2 + 0.028444581395971*G0_2_0 + 0.096294041606541*G0_2_1 - 0.064456987200042*G0_2_2;
    A[1104] = 0.011873655536850*G0_0_1 + 0.021268196181390*G0_0_2 + 0.011873655536850*G0_1_1 + 0.021268196181390*G0_1_2 + 0.021268196181390*G0_2_0 - 0.014613729891508*G0_2_1 - 0.069349977119074*G0_2_2;
    A[1105] = 0.002544354757896*G0_0_1 + 0.005838967970044*G0_0_2 + 0.002544354757896*G0_1_1 + 0.005838967970044*G0_1_2 + 0.005838967970044*G0_2_0 - 0.005904207835631*G0_2_1 - 0.031869674339292*G0_2_2;
    A[1106] = 0.011873655536850*G0_0_1 + 0.021268196181390*G0_0_2 + 0.011873655536850*G0_1_1 + 0.021268196181390*G0_1_2 + 0.021268196181391*G0_2_0 - 0.009394540644541*G0_2_1 - 0.018789081289081*G0_2_2;
    A[1107] = -0.042960451489097*G0_0_1 - 0.042275432900433*G0_0_2 - 0.042960451489097*G0_1_1 - 0.042275432900433*G0_1_2 - 0.042275432900432*G0_2_0 - 0.035914546005692*G0_2_1 + 0.092086070276174*G0_2_2;
    A[1108] = -0.042960451489097*G0_0_1 - 0.042275432900433*G0_0_2 - 0.042960451489097*G0_1_1 - 0.042275432900433*G0_1_2 - 0.042275432900433*G0_2_0 - 0.000685018588665*G0_2_1 + 0.043971669405696*G0_2_2;
    A[1109] = 0.124738623002512*G0_0_1 + 0.096294041606541*G0_0_2 + 0.124738623002512*G0_1_1 + 0.096294041606541*G0_1_2 + 0.096294041606541*G0_2_0 + 0.028444581395971*G0_2_1 - 0.064456987200042*G0_2_2;
    A[1110] = -0.009394540644541*G0_0_2 - 0.009394540644541*G0_1_2 - 0.009394540644541*G0_2_0 - 0.009394540644541*G0_2_1 + 0.045341706583026*G0_2_2;
    A[1111] = -0.003294613212148*G0_0_2 - 0.003294613212148*G0_1_2 - 0.003294613212148*G0_2_0 - 0.003294613212148*G0_2_1 + 0.022670853291513*G0_2_2;
    A[1112] = -0.009394540644540*G0_0_2 - 0.009394540644540*G0_1_2 - 0.009394540644540*G0_2_0 - 0.009394540644541*G0_2_1;
    A[1113] = -0.003294613212148*G0_0_2 - 0.003294613212148*G0_1_2 - 0.003294613212148*G0_2_0 - 0.003294613212148*G0_2_1 + 0.022670853291513*G0_2_2;
    A[1114] = -0.003294613212148*G0_0_2 - 0.003294613212148*G0_1_2 - 0.003294613212148*G0_2_0 - 0.003294613212148*G0_2_1;
    A[1115] = -0.009394540644540*G0_0_2 - 0.009394540644540*G0_1_2 - 0.009394540644541*G0_2_0 - 0.009394540644541*G0_2_1;
    A[1116] = 0.002609594623484*G0_0_2 + 0.002609594623484*G0_1_2 + 0.002609594623484*G0_2_0 + 0.002609594623483*G0_2_1 - 0.151356488162043*G0_2_2;
    A[1117] = 0.002609594623484*G0_0_2 + 0.002609594623484*G0_1_2 + 0.002609594623483*G0_2_0 + 0.002609594623483*G0_2_1 - 0.045341706583025*G0_2_2;
    A[1118] = 0.002609594623483*G0_0_2 + 0.002609594623483*G0_1_2 + 0.002609594623484*G0_2_0 + 0.002609594623484*G0_2_1 - 0.045341706583025*G0_2_2;
    A[1119] = 0.035229527417028*G0_0_2 + 0.035229527417028*G0_1_2 + 0.035229527417028*G0_2_0 + 0.035229527417027*G0_2_1 + 0.166687856575009*G0_2_2;
    A[1120] = -0.017870503981615*G0_0_0 - 0.017870503981615*G0_0_1 - 0.017870503981615*G0_0_2 - 0.055127686421089*G0_1_0 - 0.055127686421089*G0_1_1 - 0.055127686421089*G0_1_2 - 0.017870503981615*G0_2_0 - 0.017870503981615*G0_2_1 - 0.017870503981615*G0_2_2;
    A[1121] = -0.004800349309898*G0_0_0 - 0.004800349309898*G0_2_0;
    A[1122] = 0.010531019103068*G0_0_1 + 0.015331368412966*G0_1_1 + 0.010531019103068*G0_2_1;
    A[1123] = -0.004800349309898*G0_0_2 - 0.004800349309898*G0_2_2;
    A[1124] = 0.027459459425605*G0_0_1 + 0.032835224349981*G0_0_2 + 0.022083694501229*G0_1_1 + 0.027459459425605*G0_1_2 + 0.027459459425605*G0_2_1 + 0.032835224349981*G0_2_2;
    A[1125] = 0.008879145706402*G0_0_1 + 0.011169064988509*G0_0_2 + 0.006589226424296*G0_1_1 + 0.008879145706402*G0_1_2 + 0.008879145706402*G0_2_1 + 0.011169064988509*G0_2_2;
    A[1126] = 0.011684459926647*G0_0_1 + 0.013974379208754*G0_0_2 + 0.009394540644541*G0_1_1 + 0.011684459926647*G0_1_2 + 0.011684459926647*G0_2_1 + 0.013974379208754*G0_2_2;
    A[1127] = 0.005375764924376*G0_0_1 + 0.010751529848752*G0_0_2 + 0.005375764924376*G0_1_2 + 0.005375764924376*G0_2_1 + 0.010751529848752*G0_2_2;
    A[1128] = 0.005375764924376*G0_0_0 + 0.005375764924376*G0_0_2 + 0.005375764924376*G0_2_0 + 0.005375764924376*G0_2_2;
    A[1129] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_2;
    A[1130] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_2;
    A[1131] = 0.005375764924376*G0_0_0 + 0.005375764924376*G0_0_2 + 0.005375764924376*G0_2_0 + 0.005375764924376*G0_2_2;
    A[1132] = 0.010751529848752*G0_0_0 + 0.005375764924376*G0_0_1 + 0.005375764924376*G0_1_0 + 0.010751529848752*G0_2_0 + 0.005375764924376*G0_2_1;
    A[1133] = 0.013974379208754*G0_0_0 + 0.011684459926648*G0_0_1 + 0.011684459926647*G0_1_0 + 0.009394540644540*G0_1_1 + 0.013974379208754*G0_2_0 + 0.011684459926648*G0_2_1;
    A[1134] = 0.011169064988509*G0_0_0 + 0.008879145706402*G0_0_1 + 0.008879145706402*G0_1_0 + 0.006589226424296*G0_1_1 + 0.011169064988509*G0_2_0 + 0.008879145706402*G0_2_1;
    A[1135] = 0.032835224349981*G0_0_0 + 0.027459459425605*G0_0_1 + 0.027459459425605*G0_1_0 + 0.022083694501229*G0_1_1 + 0.032835224349981*G0_2_0 + 0.027459459425605*G0_2_1;
    A[1136] = 0.089548239504836*G0_0_0 + 0.089548239504836*G0_0_1 + 0.019637199541713*G0_0_2 + 0.019637199541713*G0_1_0 + 0.019637199541713*G0_1_1 + 0.089548239504836*G0_1_2 + 0.089548239504836*G0_2_0 + 0.089548239504836*G0_2_1 + 0.019637199541713*G0_2_2;
    A[1137] = -0.057417605703195*G0_0_0 - 0.057417605703195*G0_0_1 + 0.012493434259927*G0_0_2 - 0.018691221490700*G0_1_0 - 0.018691221490700*G0_1_1 - 0.057417605703195*G0_1_2 - 0.057417605703195*G0_2_0 - 0.057417605703195*G0_2_1 + 0.012493434259927*G0_2_2;
    A[1138] = 0.028372817543824*G0_0_0 + 0.028372817543824*G0_0_1 - 0.031543475011357*G0_0_2 + 0.009394540644541*G0_1_0 + 0.009394540644541*G0_1_1 + 0.028372817543824*G0_1_2 + 0.028372817543824*G0_2_0 + 0.028372817543824*G0_2_1 - 0.031543475011357*G0_2_2;
    A[1139] = -0.005375764924376*G0_0_0 - 0.005375764924376*G0_0_1 + 0.022083694501229*G0_0_2 - 0.005375764924376*G0_1_2 - 0.005375764924376*G0_2_0 - 0.005375764924376*G0_2_1 + 0.022083694501229*G0_2_2;
    A[1140] = 0.179096479009671*G0_0_0 + 0.109185439046549*G0_0_1 + 0.179096479009671*G0_0_2 + 0.109185439046549*G0_1_0 + 0.179096479009672*G0_1_1 + 0.109185439046549*G0_1_2 + 0.179096479009671*G0_2_0 + 0.109185439046549*G0_2_1 + 0.179096479009672*G0_2_2;
    A[1141] = -0.147063705006411*G0_0_0 - 0.173446706649830*G0_0_1 - 0.147063705006412*G0_0_2 - 0.108337320793917*G0_1_0 - 0.243357746612952*G0_1_1 - 0.108337320793917*G0_1_2 - 0.147063705006412*G0_2_0 - 0.173446706649830*G0_2_1 - 0.147063705006412*G0_2_2;
    A[1142] = 0.100717304493345*G0_0_0 + 0.125351877739029*G0_0_1 + 0.100717304493345*G0_0_2 + 0.081739027594061*G0_1_0 + 0.185268170294210*G0_1_1 + 0.081739027594061*G0_1_2 + 0.100717304493345*G0_2_0 + 0.125351877739029*G0_2_1 + 0.100717304493345*G0_2_2;
    A[1143] = -0.032835224349981*G0_0_0 - 0.053751125257201*G0_0_1 - 0.032835224349981*G0_0_2 - 0.027459459425605*G0_1_0 - 0.081210584682806*G0_1_1 - 0.027459459425605*G0_1_2 - 0.032835224349981*G0_2_0 - 0.053751125257201*G0_2_1 - 0.032835224349981*G0_2_2;
    A[1144] = 0.019637199541713*G0_0_0 + 0.089548239504836*G0_0_1 + 0.089548239504836*G0_0_2 + 0.089548239504836*G0_1_0 + 0.019637199541713*G0_1_1 + 0.019637199541713*G0_1_2 + 0.019637199541713*G0_2_0 + 0.089548239504836*G0_2_1 + 0.089548239504836*G0_2_2;
    A[1145] = 0.012493434259927*G0_0_0 - 0.057417605703195*G0_0_1 - 0.057417605703195*G0_0_2 - 0.057417605703195*G0_1_0 - 0.018691221490700*G0_1_1 - 0.018691221490700*G0_1_2 + 0.012493434259927*G0_2_0 - 0.057417605703195*G0_2_1 - 0.057417605703195*G0_2_2;
    A[1146] = -0.031543475011357*G0_0_0 + 0.028372817543824*G0_0_1 + 0.028372817543824*G0_0_2 + 0.028372817543824*G0_1_0 + 0.009394540644540*G0_1_1 + 0.009394540644540*G0_1_2 - 0.031543475011357*G0_2_0 + 0.028372817543824*G0_2_1 + 0.028372817543824*G0_2_2;
    A[1147] = 0.022083694501229*G0_0_0 - 0.005375764924376*G0_0_1 - 0.005375764924376*G0_0_2 - 0.005375764924376*G0_1_0 + 0.022083694501229*G0_2_0 - 0.005375764924376*G0_2_1 - 0.005375764924376*G0_2_2;
    A[1148] = 0.018789081289081*G0_0_0 + 0.009394540644540*G0_0_1 + 0.018789081289081*G0_0_2 + 0.009394540644540*G0_1_0 + 0.009394540644540*G0_1_2 + 0.018789081289081*G0_2_0 + 0.009394540644540*G0_2_1 + 0.018789081289081*G0_2_2;
    A[1149] = 0.029260079715808*G0_0_0 + 0.025965466503661*G0_0_1 + 0.029260079715809*G0_0_2 + 0.025965466503661*G0_1_0 + 0.022670853291512*G0_1_1 + 0.025965466503661*G0_1_2 + 0.029260079715808*G0_2_0 + 0.025965466503661*G0_2_1 + 0.029260079715809*G0_2_2;
    A[1150] = 0.064130787872107*G0_0_0 + 0.054736247227566*G0_0_1 + 0.064130787872106*G0_0_2 + 0.054736247227566*G0_1_0 + 0.045341706583025*G0_1_1 + 0.054736247227566*G0_1_2 + 0.064130787872107*G0_2_0 + 0.054736247227566*G0_2_1 + 0.064130787872107*G0_2_2;
    A[1151] = 0.006589226424295*G0_0_0 + 0.003294613212148*G0_0_1 + 0.006589226424296*G0_0_2 + 0.003294613212148*G0_1_0 + 0.003294613212148*G0_1_2 + 0.006589226424295*G0_2_0 + 0.003294613212148*G0_2_1 + 0.006589226424295*G0_2_2;
    A[1152] = 0.029260079715808*G0_0_0 + 0.025965466503660*G0_0_1 + 0.029260079715808*G0_0_2 + 0.025965466503661*G0_1_0 + 0.022670853291513*G0_1_1 + 0.025965466503661*G0_1_2 + 0.029260079715808*G0_2_0 + 0.025965466503661*G0_2_1 + 0.029260079715808*G0_2_2;
    A[1153] = 0.018789081289081*G0_0_0 + 0.009394540644541*G0_0_1 + 0.018789081289081*G0_0_2 + 0.009394540644541*G0_1_0 + 0.009394540644540*G0_1_2 + 0.018789081289081*G0_2_0 + 0.009394540644541*G0_2_1 + 0.018789081289081*G0_2_2;
    A[1154] = -0.064456987200042*G0_0_0 - 0.160751028806583*G0_0_1 - 0.257045070413123*G0_0_2 - 0.092901568596012*G0_1_0 - 0.064456987200042*G0_1_1 - 0.160751028806583*G0_1_2 - 0.064456987200042*G0_2_0 - 0.160751028806583*G0_2_1 - 0.257045070413123*G0_2_2;
    A[1155] = 0.127315597693200*G0_0_0 + 0.134361503176606*G0_0_1 + 0.176636936077038*G0_0_2 + 0.128000616281865*G0_1_0 + 0.092086070276173*G0_1_1 + 0.134361503176606*G0_1_2 + 0.127315597693200*G0_2_0 + 0.134361503176606*G0_2_1 + 0.176636936077039*G0_2_2;
    A[1156] = -0.064130787872107*G0_0_0 - 0.090618173300464*G0_0_1 - 0.111886369481854*G0_0_2 - 0.054736247227566*G0_1_0 - 0.069349977119074*G0_1_1 - 0.090618173300464*G0_1_2 - 0.064130787872107*G0_2_0 - 0.090618173300464*G0_2_1 - 0.111886369481854*G0_2_2;
    A[1157] = 0.043971669405696*G0_0_0 + 0.086247102306129*G0_0_1 + 0.128522535206562*G0_0_2 + 0.044656687994361*G0_1_0 + 0.043971669405697*G0_1_1 + 0.086247102306129*G0_1_2 + 0.043971669405697*G0_2_0 + 0.086247102306129*G0_2_1 + 0.128522535206562*G0_2_2;
    A[1158] = -0.029260079715808*G0_0_0 - 0.037708642309336*G0_0_1 - 0.043547610279381*G0_0_2 - 0.025965466503661*G0_1_0 - 0.031869674339292*G0_1_1 - 0.037708642309337*G0_1_2 - 0.029260079715808*G0_2_0 - 0.037708642309336*G0_2_1 - 0.043547610279381*G0_2_2;
    A[1159] = -0.018789081289081*G0_0_0 - 0.040057277470472*G0_0_1 - 0.061325473651862*G0_0_2 - 0.009394540644541*G0_1_0 - 0.018789081289081*G0_1_1 - 0.040057277470471*G0_1_2 - 0.018789081289081*G0_2_0 - 0.040057277470472*G0_2_1 - 0.061325473651862*G0_2_2;
    A[1160] = -0.128522535206561*G0_0_0 - 0.032228493600020*G0_0_1 - 0.128522535206561*G0_0_2 - 0.032228493600021*G0_1_0 - 0.060673074995991*G0_1_1 - 0.032228493600021*G0_1_2 - 0.128522535206561*G0_2_0 - 0.032228493600020*G0_2_1 - 0.128522535206561*G0_2_2;
    A[1161] = 0.064261267603280*G0_0_0 + 0.021985834702848*G0_0_1 + 0.064261267603280*G0_0_2 + 0.021985834702848*G0_1_0 + 0.022670853291513*G0_1_1 + 0.021985834702848*G0_1_2 + 0.064261267603280*G0_2_0 + 0.021985834702848*G0_2_1 + 0.064261267603281*G0_2_2;
    A[1162] = -0.030662736825930*G0_0_0 - 0.009394540644540*G0_0_1 - 0.030662736825931*G0_0_2 - 0.009394540644540*G0_1_0 - 0.009394540644540*G0_1_2 - 0.030662736825931*G0_2_0 - 0.009394540644540*G0_2_1 - 0.030662736825931*G0_2_2;
    A[1163] = 0.064261267603281*G0_0_0 + 0.021985834702848*G0_0_1 + 0.064261267603281*G0_0_2 + 0.021985834702848*G0_1_0 + 0.022670853291513*G0_1_1 + 0.021985834702848*G0_1_2 + 0.064261267603280*G0_2_0 + 0.021985834702848*G0_2_1 + 0.064261267603281*G0_2_2;
    A[1164] = -0.009133581182192*G0_0_0 - 0.003294613212148*G0_0_1 - 0.009133581182192*G0_0_2 - 0.003294613212148*G0_1_0 - 0.003294613212148*G0_1_2 - 0.009133581182192*G0_2_0 - 0.003294613212148*G0_2_1 - 0.009133581182192*G0_2_2;
    A[1165] = -0.030662736825931*G0_0_0 - 0.009394540644541*G0_0_1 - 0.030662736825931*G0_0_2 - 0.009394540644540*G0_1_0 - 0.009394540644540*G0_1_2 - 0.030662736825931*G0_2_0 - 0.009394540644541*G0_2_1 - 0.030662736825931*G0_2_2;
    A[1166] = -0.257045070413123*G0_0_0 - 0.160751028806582*G0_0_1 - 0.064456987200041*G0_0_2 - 0.160751028806582*G0_1_0 - 0.064456987200041*G0_1_1 - 0.092901568596011*G0_1_2 - 0.257045070413123*G0_2_0 - 0.160751028806583*G0_2_1 - 0.064456987200041*G0_2_2;
    A[1167] = 0.128522535206561*G0_0_0 + 0.086247102306129*G0_0_1 + 0.043971669405696*G0_0_2 + 0.086247102306129*G0_1_0 + 0.043971669405696*G0_1_1 + 0.044656687994361*G0_1_2 + 0.128522535206561*G0_2_0 + 0.086247102306129*G0_2_1 + 0.043971669405696*G0_2_2;
    A[1168] = -0.061325473651861*G0_0_0 - 0.040057277470471*G0_0_1 - 0.018789081289080*G0_0_2 - 0.040057277470471*G0_1_0 - 0.018789081289081*G0_1_1 - 0.009394540644540*G0_1_2 - 0.061325473651861*G0_2_0 - 0.040057277470471*G0_2_1 - 0.018789081289081*G0_2_2;
    A[1169] = 0.176636936077038*G0_0_0 + 0.134361503176606*G0_0_1 + 0.127315597693200*G0_0_2 + 0.134361503176605*G0_1_0 + 0.092086070276173*G0_1_1 + 0.128000616281864*G0_1_2 + 0.176636936077038*G0_2_0 + 0.134361503176606*G0_2_1 + 0.127315597693200*G0_2_2;
    A[1170] = -0.043547610279380*G0_0_0 - 0.037708642309336*G0_0_1 - 0.029260079715808*G0_0_2 - 0.037708642309336*G0_1_0 - 0.031869674339292*G0_1_1 - 0.025965466503660*G0_1_2 - 0.043547610279381*G0_2_0 - 0.037708642309336*G0_2_1 - 0.029260079715809*G0_2_2;
    A[1171] = -0.111886369481854*G0_0_0 - 0.090618173300464*G0_0_1 - 0.064130787872106*G0_0_2 - 0.090618173300464*G0_1_0 - 0.069349977119073*G0_1_1 - 0.054736247227566*G0_1_2 - 0.111886369481854*G0_2_0 - 0.090618173300464*G0_2_1 - 0.064130787872106*G0_2_2;
    A[1172] = 0.096228801740953*G0_0_0 + 0.131458329157980*G0_0_1 + 0.096228801740953*G0_0_2 + 0.131458329157980*G0_1_0 + 0.166687856575007*G0_1_1 + 0.131458329157980*G0_1_2 + 0.096228801740953*G0_2_0 + 0.131458329157980*G0_2_1 + 0.096228801740953*G0_2_2;
    A[1173] = -0.050560895829992*G0_0_0 - 0.047951301206508*G0_0_1 - 0.050560895829992*G0_0_2 - 0.047951301206509*G0_1_0 - 0.045341706583025*G0_1_1 - 0.047951301206509*G0_1_2 - 0.050560895829992*G0_2_0 - 0.047951301206508*G0_2_1 - 0.050560895829992*G0_2_2;
    A[1174] = -0.156575677409009*G0_0_0 - 0.153966082785525*G0_0_1 - 0.156575677409009*G0_0_2 - 0.153966082785525*G0_1_0 - 0.151356488162042*G0_1_1 - 0.153966082785525*G0_1_2 - 0.156575677409009*G0_2_0 - 0.153966082785525*G0_2_1 - 0.156575677409009*G0_2_2;
    A[1175] = -0.050560895829992*G0_0_0 - 0.047951301206509*G0_0_1 - 0.050560895829992*G0_0_2 - 0.047951301206509*G0_1_0 - 0.045341706583025*G0_1_1 - 0.047951301206509*G0_1_2 - 0.050560895829992*G0_2_0 - 0.047951301206509*G0_2_1 - 0.050560895829992*G0_2_2;
    A[1176] = 0.021469134967399*G0_0_0 + 0.021469134967399*G0_0_1 + 0.021469134967399*G0_0_2 + 0.055127686421089*G0_1_0 + 0.055127686421089*G0_1_1 + 0.055127686421089*G0_1_2 + 0.021469134967398*G0_2_0 + 0.021469134967398*G0_2_1 + 0.021469134967399*G0_2_2;
    A[1177] = -0.003365072266982*G0_0_0 - 0.003365072266982*G0_2_0;
    A[1178] = -0.023263231271044*G0_0_1 - 0.038817720024317*G0_1_1 - 0.023263231271044*G0_2_1;
    A[1179] = -0.003365072266982*G0_0_2 - 0.003365072266982*G0_2_2;
    A[1180] = -0.059916292555181*G0_0_1 - 0.078894569454465*G0_0_2 - 0.031543475011357*G0_1_1 - 0.059916292555181*G0_1_2 - 0.059916292555181*G0_2_1 - 0.078894569454465*G0_2_2;
    A[1181] = -0.005780252091016*G0_0_1 - 0.005232237220084*G0_0_2 - 0.006263027096360*G0_1_1 - 0.005780252091016*G0_1_2 - 0.005780252091016*G0_2_1 - 0.005232237220084*G0_2_2;
    A[1182] = -0.013152356902357*G0_0_1 - 0.026304713804714*G0_0_2 + 0.000065239865587*G0_1_1 - 0.013152356902357*G0_1_2 - 0.013152356902357*G0_2_1 - 0.026304713804714*G0_2_2;
    A[1183] = 0.002289919282107*G0_0_1 + 0.013974379208754*G0_0_2 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.013974379208754*G0_2_2;
    A[1184] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_2;
    A[1185] = 0.001787572317086*G0_0_0 + 0.001787572317086*G0_0_2 + 0.001787572317086*G0_2_0 + 0.001787572317086*G0_2_2;
    A[1186] = 0.001787572317086*G0_0_0 + 0.001787572317086*G0_0_2 + 0.001787572317086*G0_2_0 + 0.001787572317086*G0_2_2;
    A[1187] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_2;
    A[1188] = 0.013974379208755*G0_0_0 + 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.013974379208755*G0_2_0 + 0.002289919282107*G0_2_1;
    A[1189] = -0.026304713804714*G0_0_0 - 0.013152356902357*G0_0_1 - 0.013152356902357*G0_1_0 + 0.000065239865587*G0_1_1 - 0.026304713804714*G0_2_0 - 0.013152356902357*G0_2_1;
    A[1190] = -0.005232237220084*G0_0_0 - 0.005780252091016*G0_0_1 - 0.005780252091016*G0_1_0 - 0.006263027096360*G0_1_1 - 0.005232237220084*G0_2_0 - 0.005780252091016*G0_2_1;
    A[1191] = -0.078894569454465*G0_0_0 - 0.059916292555181*G0_0_1 - 0.059916292555181*G0_1_0 - 0.031543475011357*G0_1_1 - 0.078894569454465*G0_2_0 - 0.059916292555181*G0_2_1;
    A[1192] = -0.057417605703195*G0_0_0 - 0.057417605703195*G0_0_1 - 0.018691221490700*G0_0_2 + 0.012493434259927*G0_1_0 + 0.012493434259928*G0_1_1 - 0.057417605703195*G0_1_2 - 0.057417605703195*G0_2_0 - 0.057417605703196*G0_2_1 - 0.018691221490700*G0_2_2;
    A[1193] = 0.005062613569558*G0_0_0 + 0.005062613569558*G0_0_1 + 0.000260959462348*G0_0_2 + 0.000260959462348*G0_1_0 + 0.000260959462348*G0_1_1 + 0.005062613569558*G0_1_2 + 0.005062613569558*G0_2_0 + 0.005062613569558*G0_2_1 + 0.000260959462348*G0_2_2;
    A[1194] = -0.000482775005345*G0_0_0 - 0.000482775005345*G0_0_1 - 0.006263027096360*G0_0_2 + 0.000065239865587*G0_1_0 + 0.000065239865587*G0_1_1 - 0.000482775005344*G0_1_2 - 0.000482775005345*G0_2_0 - 0.000482775005345*G0_2_1 - 0.006263027096360*G0_2_2;
    A[1195] = -0.002289919282107*G0_0_0 - 0.002289919282107*G0_0_1 + 0.006589226424296*G0_0_2 - 0.002289919282107*G0_1_2 - 0.002289919282107*G0_2_0 - 0.002289919282107*G0_2_1 + 0.006589226424296*G0_2_2;
    A[1196] = -0.147063705006411*G0_0_0 - 0.108337320793917*G0_0_1 - 0.147063705006412*G0_0_2 - 0.173446706649830*G0_1_0 - 0.243357746612952*G0_1_1 - 0.173446706649830*G0_1_2 - 0.147063705006412*G0_2_0 - 0.108337320793917*G0_2_1 - 0.147063705006412*G0_2_2;
    A[1197] = 0.304226541205705*G0_0_0 + 0.226095278178609*G0_0_1 + 0.304226541205705*G0_0_2 + 0.226095278178609*G0_1_0 + 0.428965164208215*G0_1_1 + 0.226095278178609*G0_1_2 + 0.304226541205705*G0_2_0 + 0.226095278178609*G0_2_1 + 0.304226541205705*G0_2_2;
    A[1198] = -0.204187731314465*G0_0_0 - 0.219493003781196*G0_0_1 - 0.204187731314466*G0_0_2 - 0.167692550505049*G0_1_0 - 0.387185554286245*G0_1_1 - 0.167692550505049*G0_1_2 - 0.204187731314466*G0_2_0 - 0.219493003781196*G0_2_1 - 0.204187731314466*G0_2_2;
    A[1199] = 0.078894569454465*G0_0_0 + 0.103529142700149*G0_0_1 + 0.078894569454465*G0_0_2 + 0.059916292555181*G0_1_0 + 0.185268170294210*G0_1_1 + 0.059916292555181*G0_1_2 + 0.078894569454465*G0_2_0 + 0.103529142700149*G0_2_1 + 0.078894569454465*G0_2_2;
    A[1200] = -0.018691221490700*G0_0_0 - 0.057417605703195*G0_0_1 - 0.057417605703195*G0_0_2 - 0.057417605703195*G0_1_0 + 0.012493434259927*G0_1_1 + 0.012493434259927*G0_1_2 - 0.018691221490700*G0_2_0 - 0.057417605703196*G0_2_1 - 0.057417605703195*G0_2_2;
    A[1201] = 0.000260959462348*G0_0_0 + 0.005062613569558*G0_0_1 + 0.005062613569558*G0_0_2 + 0.005062613569558*G0_1_0 + 0.000260959462348*G0_1_1 + 0.000260959462348*G0_1_2 + 0.000260959462348*G0_2_0 + 0.005062613569558*G0_2_1 + 0.005062613569558*G0_2_2;
    A[1202] = -0.006263027096360*G0_0_0 - 0.000482775005344*G0_0_1 - 0.000482775005344*G0_0_2 - 0.000482775005344*G0_1_0 + 0.000065239865587*G0_1_1 + 0.000065239865587*G0_1_2 - 0.006263027096360*G0_2_0 - 0.000482775005344*G0_2_1 - 0.000482775005344*G0_2_2;
    A[1203] = 0.006589226424296*G0_0_0 - 0.002289919282107*G0_0_1 - 0.002289919282107*G0_0_2 - 0.002289919282107*G0_1_0 + 0.006589226424296*G0_2_0 - 0.002289919282107*G0_2_1 - 0.002289919282107*G0_2_2;
    A[1204] = -0.014874689353856*G0_0_0 + 0.000065239865588*G0_0_1 - 0.014874689353855*G0_0_2 + 0.000065239865588*G0_1_0 + 0.000065239865588*G0_1_2 - 0.014874689353855*G0_2_0 + 0.000065239865588*G0_2_1 - 0.014874689353855*G0_2_2;
    A[1205] = -0.018984800885842*G0_0_0 - 0.009492400442921*G0_0_1 - 0.018984800885843*G0_0_2 - 0.009492400442921*G0_1_0 - 0.000652398655870*G0_1_1 - 0.009492400442921*G0_1_2 - 0.018984800885842*G0_2_0 - 0.009492400442921*G0_2_1 - 0.018984800885843*G0_2_2;
    A[1206] = -0.127087258163646*G0_0_0 - 0.089313375988722*G0_0_1 - 0.127087258163645*G0_0_2 - 0.089313375988722*G0_1_0 - 0.066544662898829*G0_1_1 - 0.089313375988722*G0_1_2 - 0.127087258163646*G0_2_0 - 0.089313375988722*G0_2_1 - 0.127087258163646*G0_2_2;
    A[1207] = 0.004501550725509*G0_0_0 + 0.002576974690690*G0_0_1 + 0.004501550725509*G0_0_2 + 0.002576974690690*G0_1_0 + 0.002576974690690*G0_1_2 + 0.004501550725509*G0_2_0 + 0.002576974690690*G0_2_1 + 0.004501550725509*G0_2_2;
    A[1208] = -0.018984800885842*G0_0_0 - 0.009492400442921*G0_0_1 - 0.018984800885842*G0_0_2 - 0.009492400442921*G0_1_0 - 0.000652398655871*G0_1_1 - 0.009492400442921*G0_1_2 - 0.018984800885842*G0_2_0 - 0.009492400442921*G0_2_1 - 0.018984800885842*G0_2_2;
    A[1209] = -0.014874689353856*G0_0_0 + 0.000065239865587*G0_0_1 - 0.014874689353856*G0_0_2 + 0.000065239865587*G0_1_0 + 0.000065239865587*G0_1_2 - 0.014874689353856*G0_2_0 + 0.000065239865587*G0_2_1 - 0.014874689353856*G0_2_2;
    A[1210] = 0.132306447410612*G0_0_0 + 0.194675758911868*G0_0_1 + 0.121346149991982*G0_0_2 + 0.058976838490726*G0_1_0 - 0.003392473010529*G0_1_1 + 0.194675758911868*G0_1_2 + 0.132306447410612*G0_2_0 + 0.194675758911869*G0_2_1 + 0.121346149991982*G0_2_2;
    A[1211] = -0.166948816037356*G0_0_0 - 0.250814663249557*G0_0_1 - 0.334680510461757*G0_0_2 - 0.160783648739376*G0_1_0 - 0.062238831770081*G0_1_1 - 0.250814663249557*G0_1_2 - 0.166948816037356*G0_2_0 - 0.250814663249557*G0_2_1 - 0.334680510461757*G0_2_2;
    A[1212] = 0.127087258163646*G0_0_0 + 0.173472802596065*G0_0_1 + 0.209419968534550*G0_0_2 + 0.089313375988722*G0_1_0 + 0.084681345532039*G0_1_1 + 0.173472802596065*G0_1_2 + 0.127087258163646*G0_2_0 + 0.173472802596065*G0_2_1 + 0.209419968534550*G0_2_2;
    A[1213] = -0.043645470077761*G0_0_0 - 0.037154103451846*G0_0_1 + 0.037186723384640*G0_0_2 - 0.009753359905270*G0_1_0 - 0.006784946021057*G0_1_1 - 0.037154103451846*G0_1_2 - 0.043645470077761*G0_2_0 - 0.037154103451846*G0_2_1 + 0.037186723384640*G0_2_2;
    A[1214] = 0.018984800885842*G0_0_0 + 0.037871741973304*G0_0_1 + 0.056758683060766*G0_0_2 + 0.009492400442921*G0_1_0 + 0.012787013655069*G0_1_1 + 0.037871741973305*G0_1_2 + 0.018984800885842*G0_2_0 + 0.037871741973304*G0_2_1 + 0.056758683060766*G0_2_2;
    A[1215] = 0.014874689353856*G0_0_0 + 0.013635131907701*G0_0_1 - 0.025443547578965*G0_0_2 - 0.000065239865587*G0_1_0 - 0.000130479731174*G0_1_1 + 0.013635131907701*G0_1_2 + 0.014874689353856*G0_2_0 + 0.013635131907701*G0_2_1 - 0.025443547578964*G0_2_2;
    A[1216] = 0.047625101878573*G0_0_0 - 0.014744209622682*G0_0_1 + 0.047625101878573*G0_0_2 - 0.014744209622682*G0_1_0 + 0.047625101878573*G0_1_1 - 0.014744209622682*G0_1_2 + 0.047625101878574*G0_2_0 - 0.014744209622683*G0_2_1 + 0.047625101878573*G0_2_2;
    A[1217] = 0.008807381854257*G0_0_0 + 0.002316015228342*G0_0_1 + 0.008807381854257*G0_0_2 + 0.002316015228342*G0_1_0 - 0.000652398655871*G0_1_1 + 0.002316015228342*G0_1_2 + 0.008807381854257*G0_2_0 + 0.002316015228342*G0_2_1 + 0.008807381854257*G0_2_2;
    A[1218] = -0.001304797311742*G0_0_0 - 0.000065239865588*G0_0_1 - 0.001304797311742*G0_0_2 - 0.000065239865587*G0_1_0 - 0.000065239865587*G0_1_2 - 0.001304797311742*G0_2_0 - 0.000065239865588*G0_2_1 - 0.001304797311742*G0_2_2;
    A[1219] = 0.008807381854257*G0_0_0 + 0.002316015228342*G0_0_1 + 0.008807381854257*G0_0_2 + 0.002316015228342*G0_1_0 - 0.000652398655871*G0_1_1 + 0.002316015228342*G0_1_2 + 0.008807381854257*G0_2_0 + 0.002316015228342*G0_2_1 + 0.008807381854257*G0_2_2;
    A[1220] = -0.015657567740901*G0_0_0 - 0.002576974690690*G0_0_1 - 0.015657567740901*G0_0_2 - 0.002576974690690*G0_1_0 - 0.002576974690690*G0_1_2 - 0.015657567740901*G0_2_0 - 0.002576974690690*G0_2_1 - 0.015657567740901*G0_2_2;
    A[1221] = -0.001304797311742*G0_0_0 - 0.000065239865587*G0_0_1 - 0.001304797311742*G0_0_2 - 0.000065239865587*G0_1_0 - 0.000065239865588*G0_1_2 - 0.001304797311742*G0_2_0 - 0.000065239865587*G0_2_1 - 0.001304797311742*G0_2_2;
    A[1222] = 0.121346149991981*G0_0_0 + 0.194675758911868*G0_0_1 + 0.132306447410612*G0_0_2 + 0.194675758911867*G0_1_0 - 0.003392473010529*G0_1_1 + 0.058976838490726*G0_1_2 + 0.121346149991982*G0_2_0 + 0.194675758911869*G0_2_1 + 0.132306447410612*G0_2_2;
    A[1223] = 0.037186723384640*G0_0_0 - 0.037154103451846*G0_0_1 - 0.043645470077761*G0_0_2 - 0.037154103451846*G0_1_0 - 0.006784946021056*G0_1_1 - 0.009753359905269*G0_1_2 + 0.037186723384640*G0_2_0 - 0.037154103451846*G0_2_1 - 0.043645470077761*G0_2_2;
    A[1224] = -0.025443547578965*G0_0_0 + 0.013635131907701*G0_0_1 + 0.014874689353855*G0_0_2 + 0.013635131907701*G0_1_0 - 0.000130479731175*G0_1_1 - 0.000065239865588*G0_1_2 - 0.025443547578965*G0_2_0 + 0.013635131907701*G0_2_1 + 0.014874689353855*G0_2_2;
    A[1225] = -0.334680510461757*G0_0_0 - 0.250814663249557*G0_0_1 - 0.166948816037355*G0_0_2 - 0.250814663249555*G0_1_0 - 0.062238831770081*G0_1_1 - 0.160783648739376*G0_1_2 - 0.334680510461757*G0_2_0 - 0.250814663249557*G0_2_1 - 0.166948816037356*G0_2_2;
    A[1226] = 0.056758683060766*G0_0_0 + 0.037871741973304*G0_0_1 + 0.018984800885842*G0_0_2 + 0.037871741973303*G0_1_0 + 0.012787013655069*G0_1_1 + 0.009492400442921*G0_1_2 + 0.056758683060766*G0_2_0 + 0.037871741973304*G0_2_1 + 0.018984800885842*G0_2_2;
    A[1227] = 0.209419968534549*G0_0_0 + 0.173472802596065*G0_0_1 + 0.127087258163645*G0_0_2 + 0.173472802596064*G0_1_0 + 0.084681345532039*G0_1_1 + 0.089313375988722*G0_1_2 + 0.209419968534549*G0_2_0 + 0.173472802596065*G0_2_1 + 0.127087258163645*G0_2_2;
    A[1228] = -0.156575677409009*G0_0_0 - 0.066218463570892*G0_0_1 - 0.156575677409009*G0_0_2 - 0.066218463570893*G0_1_0 - 0.161794866655976*G0_1_1 - 0.066218463570893*G0_1_2 - 0.156575677409009*G0_2_0 - 0.066218463570892*G0_2_1 - 0.156575677409009*G0_2_2;
    A[1229] = 0.039143919352252*G0_0_0 + 0.007176385214579*G0_0_1 + 0.039143919352252*G0_0_2 + 0.007176385214579*G0_1_0 + 0.001304797311741*G0_1_1 + 0.007176385214579*G0_1_2 + 0.039143919352252*G0_2_0 + 0.007176385214580*G0_2_1 + 0.039143919352252*G0_2_2;
    A[1230] = 0.185933616923198*G0_0_0 + 0.170276049182296*G0_0_1 + 0.185933616923198*G0_0_2 + 0.170276049182297*G0_1_0 + 0.180714427676231*G0_1_1 + 0.170276049182297*G0_1_2 + 0.185933616923198*G0_2_0 + 0.170276049182297*G0_2_1 + 0.185933616923198*G0_2_2;
    A[1231] = 0.039143919352252*G0_0_0 + 0.007176385214580*G0_0_1 + 0.039143919352253*G0_0_2 + 0.007176385214579*G0_1_0 + 0.001304797311742*G0_1_1 + 0.007176385214580*G0_1_2 + 0.039143919352252*G0_2_0 + 0.007176385214580*G0_2_1 + 0.039143919352253*G0_2_2;
    A[1232] = -0.015554488753273*G0_0_0 - 0.015554488753273*G0_0_1 - 0.015554488753273*G0_0_2 - 0.038817720024317*G0_1_0 - 0.038817720024317*G0_1_1 - 0.038817720024317*G0_1_2 - 0.015554488753273*G0_2_0 - 0.015554488753273*G0_2_1 - 0.015554488753273*G0_2_2;
    A[1233] = -0.003365072266982*G0_0_0 - 0.003365072266982*G0_2_0;
    A[1234] = 0.033658551453690*G0_0_1 + 0.055127686421089*G0_1_1 + 0.033658551453690*G0_2_1;
    A[1235] = -0.003365072266982*G0_0_2 - 0.003365072266982*G0_2_2;
    A[1236] = 0.069911039963123*G0_0_1 + 0.108637424175618*G0_0_2 + 0.012493434259927*G0_1_1 + 0.069911039963123*G0_1_2 + 0.069911039963123*G0_2_1 + 0.108637424175618*G0_2_2;
    A[1237] = -0.004801654107210*G0_0_1 - 0.009603308214419*G0_0_2 + 0.000260959462348*G0_1_1 - 0.004801654107210*G0_1_2 - 0.004801654107210*G0_2_1 - 0.009603308214419*G0_2_2;
    A[1238] = 0.000548014870932*G0_0_1 - 0.005232237220084*G0_0_2 + 0.000065239865587*G0_1_1 + 0.000548014870932*G0_1_2 + 0.000548014870932*G0_2_1 - 0.005232237220084*G0_2_2;
    A[1239] = 0.002289919282107*G0_0_1 + 0.011169064988509*G0_0_2 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.011169064988509*G0_2_2;
    A[1240] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_2;
    A[1241] = 0.001787572317086*G0_0_0 + 0.001787572317086*G0_0_2 + 0.001787572317086*G0_2_0 + 0.001787572317086*G0_2_2;
    A[1242] = 0.001787572317086*G0_0_0 + 0.001787572317086*G0_0_2 + 0.001787572317086*G0_2_0 + 0.001787572317086*G0_2_2;
    A[1243] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_2;
    A[1244] = 0.011169064988509*G0_0_0 + 0.002289919282106*G0_0_1 + 0.002289919282107*G0_1_0 + 0.011169064988509*G0_2_0 + 0.002289919282107*G0_2_1;
    A[1245] = -0.005232237220084*G0_0_0 + 0.000548014870932*G0_0_1 + 0.000548014870931*G0_1_0 + 0.000065239865587*G0_1_1 - 0.005232237220084*G0_2_0 + 0.000548014870932*G0_2_1;
    A[1246] = -0.009603308214420*G0_0_0 - 0.004801654107210*G0_0_1 - 0.004801654107210*G0_1_0 + 0.000260959462348*G0_1_1 - 0.009603308214420*G0_2_0 - 0.004801654107210*G0_2_1;
    A[1247] = 0.108637424175618*G0_0_0 + 0.069911039963123*G0_0_1 + 0.069911039963123*G0_1_0 + 0.012493434259927*G0_1_1 + 0.108637424175618*G0_2_0 + 0.069911039963123*G0_2_1;
    A[1248] = 0.028372817543824*G0_0_0 + 0.028372817543824*G0_0_1 + 0.009394540644541*G0_0_2 - 0.031543475011357*G0_1_0 - 0.031543475011357*G0_1_1 + 0.028372817543824*G0_1_2 + 0.028372817543824*G0_2_0 + 0.028372817543824*G0_2_1 + 0.009394540644541*G0_2_2;
    A[1249] = -0.000482775005344*G0_0_0 - 0.000482775005344*G0_0_1 + 0.000065239865587*G0_0_2 - 0.006263027096360*G0_1_0 - 0.006263027096360*G0_1_1 - 0.000482775005344*G0_1_2 - 0.000482775005344*G0_2_0 - 0.000482775005344*G0_2_1 + 0.000065239865587*G0_2_2;
    A[1250] = 0.013217596767944*G0_0_0 + 0.013217596767944*G0_0_1 + 0.000065239865587*G0_0_2 + 0.000065239865587*G0_1_0 + 0.000065239865587*G0_1_1 + 0.013217596767944*G0_1_2 + 0.013217596767944*G0_2_0 + 0.013217596767944*G0_2_1 + 0.000065239865587*G0_2_2;
    A[1251] = -0.002289919282107*G0_0_0 - 0.002289919282107*G0_0_1 + 0.009394540644541*G0_0_2 - 0.002289919282107*G0_1_2 - 0.002289919282107*G0_2_0 - 0.002289919282107*G0_2_1 + 0.009394540644541*G0_2_2;
    A[1252] = 0.100717304493345*G0_0_0 + 0.081739027594061*G0_0_1 + 0.100717304493345*G0_0_2 + 0.125351877739029*G0_1_0 + 0.185268170294210*G0_1_1 + 0.125351877739029*G0_1_2 + 0.100717304493345*G0_2_0 + 0.081739027594061*G0_2_1 + 0.100717304493345*G0_2_2;
    A[1253] = -0.204187731314465*G0_0_0 - 0.167692550505049*G0_0_1 - 0.204187731314466*G0_0_2 - 0.219493003781196*G0_1_0 - 0.387185554286245*G0_1_1 - 0.219493003781196*G0_1_2 - 0.204187731314466*G0_2_0 - 0.167692550505049*G0_2_1 - 0.204187731314466*G0_2_2;
    A[1254] = 0.281001149056702*G0_0_0 + 0.202869886029606*G0_0_1 + 0.281001149056702*G0_0_2 + 0.202869886029606*G0_1_0 + 0.428965164208216*G0_1_1 + 0.202869886029606*G0_1_2 + 0.281001149056702*G0_2_0 + 0.202869886029606*G0_2_1 + 0.281001149056702*G0_2_2;
    A[1255] = -0.108637424175618*G0_0_0 - 0.135020425819036*G0_0_1 - 0.108637424175618*G0_0_2 - 0.069911039963123*G0_1_0 - 0.243357746612953*G0_1_1 - 0.069911039963123*G0_1_2 - 0.108637424175618*G0_2_0 - 0.135020425819036*G0_2_1 - 0.108637424175618*G0_2_2;
    A[1256] = 0.009394540644540*G0_0_0 + 0.028372817543824*G0_0_1 + 0.028372817543824*G0_0_2 + 0.028372817543824*G0_1_0 - 0.031543475011357*G0_1_1 - 0.031543475011357*G0_1_2 + 0.009394540644540*G0_2_0 + 0.028372817543824*G0_2_1 + 0.028372817543824*G0_2_2;
    A[1257] = 0.000065239865587*G0_0_0 - 0.000482775005344*G0_0_1 - 0.000482775005344*G0_0_2 - 0.000482775005344*G0_1_0 - 0.006263027096360*G0_1_1 - 0.006263027096360*G0_1_2 + 0.000065239865587*G0_2_0 - 0.000482775005344*G0_2_1 - 0.000482775005344*G0_2_2;
    A[1258] = 0.000065239865587*G0_0_0 + 0.013217596767944*G0_0_1 + 0.013217596767944*G0_0_2 + 0.013217596767944*G0_1_0 + 0.000065239865587*G0_1_1 + 0.000065239865587*G0_1_2 + 0.000065239865587*G0_2_0 + 0.013217596767944*G0_2_1 + 0.013217596767944*G0_2_2;
    A[1259] = 0.009394540644541*G0_0_0 - 0.002289919282107*G0_0_1 - 0.002289919282107*G0_0_2 - 0.002289919282107*G0_1_0 + 0.009394540644541*G0_2_0 - 0.002289919282107*G0_2_1 - 0.002289919282107*G0_2_2;
    A[1260] = -0.001174317580568*G0_0_0 + 0.000065239865587*G0_0_1 - 0.001174317580568*G0_0_2 + 0.000065239865586*G0_1_0 + 0.000065239865586*G0_1_2 - 0.001174317580568*G0_2_0 + 0.000065239865587*G0_2_1 - 0.001174317580568*G0_2_2;
    A[1261] = 0.003522952741702*G0_0_0 - 0.002968413884212*G0_0_1 + 0.003522952741703*G0_0_2 - 0.002968413884212*G0_1_0 - 0.000652398655871*G0_1_1 - 0.002968413884212*G0_1_2 + 0.003522952741703*G0_2_0 - 0.002968413884212*G0_2_1 + 0.003522952741703*G0_2_2;
    A[1262] = 0.124738623002511*G0_0_0 + 0.062369311501255*G0_0_1 + 0.124738623002511*G0_0_2 + 0.062369311501255*G0_1_0 + 0.047625101878574*G0_1_1 + 0.062369311501255*G0_1_2 + 0.124738623002511*G0_2_0 + 0.062369311501255*G0_2_1 + 0.124738623002511*G0_2_2;
    A[1263] = -0.010503618359522*G0_0_0 + 0.002576974690690*G0_0_1 - 0.010503618359521*G0_0_2 + 0.002576974690690*G0_1_0 + 0.002576974690690*G0_1_2 - 0.010503618359521*G0_2_0 + 0.002576974690690*G0_2_1 - 0.010503618359521*G0_2_2;
    A[1264] = 0.003522952741703*G0_0_0 - 0.002968413884212*G0_0_1 + 0.003522952741702*G0_0_2 - 0.002968413884213*G0_1_0 - 0.000652398655870*G0_1_1 - 0.002968413884212*G0_1_2 + 0.003522952741703*G0_2_0 - 0.002968413884212*G0_2_1 + 0.003522952741702*G0_2_2;
    A[1265] = -0.001174317580567*G0_0_0 + 0.000065239865587*G0_0_1 - 0.001174317580567*G0_0_2 + 0.000065239865587*G0_1_0 + 0.000065239865587*G0_1_2 - 0.001174317580567*G0_2_0 + 0.000065239865587*G0_2_1 - 0.001174317580567*G0_2_2;
    A[1266] = -0.051017574889102*G0_0_0 - 0.088791457064026*G0_0_1 - 0.052844291125541*G0_0_2 - 0.004632030456683*G0_1_0 + 0.084681345532040*G0_1_1 - 0.088791457064025*G0_1_2 - 0.051017574889102*G0_2_0 - 0.088791457064026*G0_2_1 - 0.052844291125541*G0_2_2;
    A[1267] = 0.182410664181496*G0_0_0 + 0.188575831479476*G0_0_1 + 0.104709984267275*G0_0_2 + 0.098544816969295*G0_1_0 - 0.062238831770082*G0_1_1 + 0.188575831479476*G0_1_2 + 0.182410664181496*G0_2_0 + 0.188575831479476*G0_2_1 + 0.104709984267275*G0_2_2;
    A[1268] = -0.124738623002511*G0_0_0 - 0.198068231922397*G0_0_1 - 0.271397840842283*G0_0_2 - 0.062369311501255*G0_1_0 - 0.003392473010529*G0_1_1 - 0.198068231922397*G0_1_2 - 0.124738623002511*G0_2_0 - 0.198068231922398*G0_2_1 - 0.271397840842283*G0_2_2;
    A[1269] = -0.015592327875314*G0_0_0 - 0.025084728318235*G0_0_1 - 0.006197787230773*G0_0_2 + 0.003294613212148*G0_1_0 + 0.012787013655069*G0_1_1 - 0.025084728318236*G0_1_2 - 0.015592327875314*G0_2_0 - 0.025084728318235*G0_2_1 - 0.006197787230773*G0_2_2;
    A[1270] = -0.003522952741703*G0_0_0 + 0.030369157430789*G0_0_1 + 0.104709984267275*G0_0_2 + 0.002968413884213*G0_1_0 - 0.006784946021057*G0_1_1 + 0.030369157430789*G0_1_2 - 0.003522952741703*G0_2_0 + 0.030369157430789*G0_2_1 + 0.104709984267275*G0_2_2;
    A[1271] = 0.001174317580567*G0_0_0 - 0.013765611638876*G0_0_1 - 0.052844291125540*G0_0_2 - 0.000065239865587*G0_1_0 - 0.000130479731174*G0_1_1 - 0.013765611638875*G0_1_2 + 0.001174317580567*G0_2_0 - 0.013765611638876*G0_2_1 - 0.052844291125540*G0_2_2;
    A[1272] = -0.015005169085030*G0_0_0 + 0.022768713089894*G0_0_1 - 0.015005169085030*G0_0_2 + 0.022768713089894*G0_1_0 - 0.066544662898829*G0_1_1 + 0.022768713089894*G0_1_2 - 0.015005169085030*G0_2_0 + 0.022768713089894*G0_2_1 - 0.015005169085030*G0_2_2;
    A[1273] = -0.000652398655871*G0_0_0 + 0.008840001787050*G0_0_1 - 0.000652398655871*G0_0_2 + 0.008840001787050*G0_1_0 - 0.000652398655871*G0_1_1 + 0.008840001787050*G0_1_2 - 0.000652398655871*G0_2_0 + 0.008840001787050*G0_2_1 - 0.000652398655871*G0_2_2;
    A[1274] = -0.015005169085030*G0_0_0 - 0.000065239865587*G0_0_1 - 0.015005169085030*G0_0_2 - 0.000065239865587*G0_1_0 - 0.000065239865587*G0_1_2 - 0.015005169085030*G0_2_0 - 0.000065239865587*G0_2_1 - 0.015005169085030*G0_2_2;
    A[1275] = -0.000652398655871*G0_0_0 + 0.008840001787050*G0_0_1 - 0.000652398655871*G0_0_2 + 0.008840001787050*G0_1_0 - 0.000652398655871*G0_1_1 + 0.008840001787050*G0_1_2 - 0.000652398655871*G0_2_0 + 0.008840001787050*G0_2_1 - 0.000652398655871*G0_2_2;
    A[1276] = -0.000652398655871*G0_0_0 - 0.002576974690690*G0_0_1 - 0.000652398655871*G0_0_2 - 0.002576974690690*G0_1_0 - 0.002576974690690*G0_1_2 - 0.000652398655871*G0_2_0 - 0.002576974690690*G0_2_1 - 0.000652398655871*G0_2_2;
    A[1277] = -0.015005169085030*G0_0_0 - 0.000065239865587*G0_0_1 - 0.015005169085030*G0_0_2 - 0.000065239865587*G0_1_0 - 0.000065239865587*G0_1_2 - 0.015005169085030*G0_2_0 - 0.000065239865587*G0_2_1 - 0.015005169085030*G0_2_2;
    A[1278] = -0.052844291125540*G0_0_0 - 0.088791457064026*G0_0_1 - 0.051017574889102*G0_0_2 - 0.088791457064025*G0_1_0 + 0.084681345532040*G0_1_1 - 0.004632030456683*G0_1_2 - 0.052844291125541*G0_2_0 - 0.088791457064026*G0_2_1 - 0.051017574889102*G0_2_2;
    A[1279] = -0.006197787230773*G0_0_0 - 0.025084728318236*G0_0_1 - 0.015592327875314*G0_0_2 - 0.025084728318235*G0_1_0 + 0.012787013655069*G0_1_1 + 0.003294613212147*G0_1_2 - 0.006197787230773*G0_2_0 - 0.025084728318235*G0_2_1 - 0.015592327875314*G0_2_2;
    A[1280] = -0.052844291125540*G0_0_0 - 0.013765611638875*G0_0_1 + 0.001174317580568*G0_0_2 - 0.013765611638875*G0_1_0 - 0.000130479731173*G0_1_1 - 0.000065239865586*G0_1_2 - 0.052844291125541*G0_2_0 - 0.013765611638875*G0_2_1 + 0.001174317580568*G0_2_2;
    A[1281] = 0.104709984267275*G0_0_0 + 0.188575831479476*G0_0_1 + 0.182410664181496*G0_0_2 + 0.188575831479475*G0_1_0 - 0.062238831770082*G0_1_1 + 0.098544816969295*G0_1_2 + 0.104709984267275*G0_2_0 + 0.188575831479477*G0_2_1 + 0.182410664181496*G0_2_2;
    A[1282] = 0.104709984267275*G0_0_0 + 0.030369157430789*G0_0_1 - 0.003522952741703*G0_0_2 + 0.030369157430790*G0_1_0 - 0.006784946021057*G0_1_1 + 0.002968413884213*G0_1_2 + 0.104709984267275*G0_2_0 + 0.030369157430789*G0_2_1 - 0.003522952741703*G0_2_2;
    A[1283] = -0.271397840842282*G0_0_0 - 0.198068231922397*G0_0_1 - 0.124738623002510*G0_0_2 - 0.198068231922397*G0_1_0 - 0.003392473010528*G0_1_1 - 0.062369311501255*G0_1_2 - 0.271397840842283*G0_2_0 - 0.198068231922397*G0_2_1 - 0.124738623002510*G0_2_2;
    A[1284] = 0.026095946234834*G0_0_0 + 0.010438378493932*G0_0_1 + 0.026095946234834*G0_0_2 + 0.010438378493933*G0_1_0 + 0.180714427676231*G0_1_1 + 0.010438378493934*G0_1_2 + 0.026095946234834*G0_2_0 + 0.010438378493933*G0_2_1 + 0.026095946234835*G0_2_2;
    A[1285] = 0.026095946234835*G0_0_0 - 0.005871587902838*G0_0_1 + 0.026095946234835*G0_0_2 - 0.005871587902837*G0_1_0 + 0.001304797311743*G0_1_1 - 0.005871587902837*G0_1_2 + 0.026095946234835*G0_2_0 - 0.005871587902838*G0_2_1 + 0.026095946234835*G0_2_2;
    A[1286] = -0.185933616923198*G0_0_0 - 0.095576403085081*G0_0_1 - 0.185933616923198*G0_0_2 - 0.095576403085083*G0_1_0 - 0.161794866655977*G0_1_1 - 0.095576403085082*G0_1_2 - 0.185933616923198*G0_2_0 - 0.095576403085081*G0_2_1 - 0.185933616923198*G0_2_2;
    A[1287] = 0.026095946234835*G0_0_0 - 0.005871587902838*G0_0_1 + 0.026095946234835*G0_0_2 - 0.005871587902838*G0_1_0 + 0.001304797311742*G0_1_1 - 0.005871587902838*G0_1_2 + 0.026095946234835*G0_2_0 - 0.005871587902838*G0_2_1 + 0.026095946234835*G0_2_2;
    A[1288] = 0.004800349309898*G0_0_0 + 0.004800349309898*G0_0_1 + 0.004800349309898*G0_0_2 + 0.015331368412965*G0_1_0 + 0.015331368412965*G0_1_1 + 0.015331368412965*G0_1_2 + 0.004800349309898*G0_2_0 + 0.004800349309898*G0_2_1 + 0.004800349309898*G0_2_2;
    A[1289] = -0.004800349309898*G0_0_0 - 0.004800349309898*G0_2_0;
    A[1290] = -0.037257182439474*G0_0_1 - 0.055127686421089*G0_1_1 - 0.037257182439474*G0_2_1;
    A[1291] = -0.004800349309898*G0_0_2 - 0.004800349309898*G0_2_2;
    A[1292] = -0.069911039963123*G0_0_1 - 0.139822079926246*G0_0_2 + 0.019637199541713*G0_1_1 - 0.069911039963123*G0_1_2 - 0.069911039963123*G0_2_1 - 0.139822079926246*G0_2_2;
    A[1293] = 0.038726384212495*G0_0_1 + 0.108637424175618*G0_0_2 - 0.018691221490700*G0_1_1 + 0.038726384212495*G0_1_2 + 0.038726384212495*G0_2_1 + 0.108637424175618*G0_2_2;
    A[1294] = -0.018978276899284*G0_0_1 - 0.078894569454465*G0_0_2 + 0.009394540644540*G0_1_1 - 0.018978276899284*G0_1_2 - 0.018978276899284*G0_2_1 - 0.078894569454465*G0_2_2;
    A[1295] = 0.005375764924376*G0_0_1 + 0.032835224349981*G0_0_2 + 0.005375764924376*G0_1_2 + 0.005375764924376*G0_2_1 + 0.032835224349981*G0_2_2;
    A[1296] = 0.005375764924376*G0_0_0 + 0.005375764924376*G0_0_2 + 0.005375764924376*G0_2_0 + 0.005375764924376*G0_2_2;
    A[1297] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_2;
    A[1298] = 0.002289919282107*G0_0_0 + 0.002289919282107*G0_0_2 + 0.002289919282107*G0_2_0 + 0.002289919282107*G0_2_2;
    A[1299] = 0.005375764924376*G0_0_0 + 0.005375764924376*G0_0_2 + 0.005375764924376*G0_2_0 + 0.005375764924376*G0_2_2;
    A[1300] = 0.032835224349981*G0_0_0 + 0.005375764924376*G0_0_1 + 0.005375764924376*G0_1_0 + 0.032835224349981*G0_2_0 + 0.005375764924376*G0_2_1;
    A[1301] = -0.078894569454465*G0_0_0 - 0.018978276899284*G0_0_1 - 0.018978276899283*G0_1_0 + 0.009394540644541*G0_1_1 - 0.078894569454465*G0_2_0 - 0.018978276899284*G0_2_1;
    A[1302] = 0.108637424175618*G0_0_0 + 0.038726384212495*G0_0_1 + 0.038726384212495*G0_1_0 - 0.018691221490701*G0_1_1 + 0.108637424175618*G0_2_0 + 0.038726384212495*G0_2_1;
    A[1303] = -0.139822079926246*G0_0_0 - 0.069911039963123*G0_0_1 - 0.069911039963123*G0_1_0 + 0.019637199541713*G0_1_1 - 0.139822079926245*G0_2_0 - 0.069911039963123*G0_2_1;
    A[1304] = -0.005375764924376*G0_0_0 - 0.005375764924376*G0_0_1 + 0.022083694501229*G0_1_0 + 0.022083694501229*G0_1_1 - 0.005375764924376*G0_1_2 - 0.005375764924376*G0_2_0 - 0.005375764924376*G0_2_1;
    A[1305] = -0.002289919282107*G0_0_0 - 0.002289919282107*G0_0_1 + 0.006589226424296*G0_1_0 + 0.006589226424296*G0_1_1 - 0.002289919282107*G0_1_2 - 0.002289919282107*G0_2_0 - 0.002289919282107*G0_2_1;
    A[1306] = -0.002289919282107*G0_0_0 - 0.002289919282107*G0_0_1 + 0.009394540644541*G0_1_0 + 0.009394540644541*G0_1_1 - 0.002289919282107*G0_1_2 - 0.002289919282107*G0_2_0 - 0.002289919282107*G0_2_1;
    A[1307] = -0.005375764924376*G0_0_0 - 0.005375764924376*G0_0_1 - 0.005375764924376*G0_1_2 - 0.005375764924376*G0_2_0 - 0.005375764924376*G0_2_1;
    A[1308] = -0.032835224349981*G0_0_0 - 0.027459459425605*G0_0_1 - 0.032835224349981*G0_0_2 - 0.053751125257201*G0_1_0 - 0.081210584682806*G0_1_1 - 0.053751125257201*G0_1_2 - 0.032835224349981*G0_2_0 - 0.027459459425605*G0_2_1 - 0.032835224349981*G0_2_2;
    A[1309] = 0.078894569454465*G0_0_0 + 0.059916292555181*G0_0_1 + 0.078894569454465*G0_0_2 + 0.103529142700149*G0_1_0 + 0.185268170294210*G0_1_1 + 0.103529142700149*G0_1_2 + 0.078894569454465*G0_2_0 + 0.059916292555181*G0_2_1 + 0.078894569454465*G0_2_2;
    A[1310] = -0.108637424175618*G0_0_0 - 0.069911039963123*G0_0_1 - 0.108637424175618*G0_0_2 - 0.135020425819036*G0_1_0 - 0.243357746612953*G0_1_1 - 0.135020425819036*G0_1_2 - 0.108637424175618*G0_2_0 - 0.069911039963123*G0_2_1 - 0.108637424175618*G0_2_2;
    A[1311] = 0.139822079926246*G0_0_0 + 0.069911039963123*G0_0_1 + 0.139822079926245*G0_0_2 + 0.069911039963123*G0_1_0 + 0.179096479009672*G0_1_1 + 0.069911039963123*G0_1_2 + 0.139822079926245*G0_2_0 + 0.069911039963123*G0_2_1 + 0.139822079926245*G0_2_2;
    A[1312] = -0.005375764924376*G0_0_1 - 0.005375764924376*G0_0_2 - 0.005375764924376*G0_1_0 + 0.022083694501229*G0_1_1 + 0.022083694501229*G0_1_2 - 0.005375764924376*G0_2_1 - 0.005375764924376*G0_2_2;
    A[1313] = -0.002289919282107*G0_0_1 - 0.002289919282107*G0_0_2 - 0.002289919282107*G0_1_0 + 0.006589226424296*G0_1_1 + 0.006589226424296*G0_1_2 - 0.002289919282107*G0_2_1 - 0.002289919282107*G0_2_2;
    A[1314] = -0.002289919282107*G0_0_1 - 0.002289919282107*G0_0_2 - 0.002289919282107*G0_1_0 + 0.009394540644541*G0_1_1 + 0.009394540644541*G0_1_2 - 0.002289919282107*G0_2_1 - 0.002289919282107*G0_2_2;
    A[1315] = -0.005375764924376*G0_0_1 - 0.005375764924376*G0_0_2 - 0.005375764924376*G0_1_0 - 0.005375764924376*G0_2_1 - 0.005375764924376*G0_2_2;
    A[1316] = -0.011873655536850*G0_0_0 + 0.009394540644541*G0_0_1 - 0.011873655536849*G0_0_2 + 0.009394540644541*G0_1_0 + 0.009394540644541*G0_1_2 - 0.011873655536850*G0_2_0 + 0.009394540644541*G0_2_1 - 0.011873655536849*G0_2_2;
    A[1317] = 0.042960451489097*G0_0_0 + 0.000685018588664*G0_0_1 + 0.042960451489096*G0_0_2 + 0.000685018588664*G0_1_0 + 0.022670853291513*G0_1_1 + 0.000685018588664*G0_1_2 + 0.042960451489097*G0_2_0 + 0.000685018588664*G0_2_1 + 0.042960451489096*G0_2_2;
    A[1318] = -0.124738623002511*G0_0_0 - 0.028444581395970*G0_0_1 - 0.124738623002511*G0_0_2 - 0.028444581395970*G0_1_0 - 0.060673074995991*G0_1_1 - 0.028444581395970*G0_1_2 - 0.124738623002511*G0_2_0 - 0.028444581395970*G0_2_1 - 0.124738623002511*G0_2_2;
    A[1319] = -0.002544354757896*G0_0_0 + 0.003294613212148*G0_0_1 - 0.002544354757896*G0_0_2 + 0.003294613212148*G0_1_0 + 0.003294613212148*G0_1_2 - 0.002544354757896*G0_2_0 + 0.003294613212148*G0_2_1 - 0.002544354757896*G0_2_2;
    A[1320] = 0.042960451489097*G0_0_0 + 0.000685018588664*G0_0_1 + 0.042960451489097*G0_0_2 + 0.000685018588664*G0_1_0 + 0.022670853291513*G0_1_1 + 0.000685018588665*G0_1_2 + 0.042960451489097*G0_2_0 + 0.000685018588664*G0_2_1 + 0.042960451489097*G0_2_2;
    A[1321] = -0.011873655536850*G0_0_0 + 0.009394540644541*G0_0_1 - 0.011873655536850*G0_0_2 + 0.009394540644541*G0_1_0 + 0.009394540644540*G0_1_2 - 0.011873655536850*G0_2_0 + 0.009394540644541*G0_2_1 - 0.011873655536850*G0_2_2;
    A[1322] = 0.011873655536850*G0_0_0 + 0.021268196181391*G0_0_1 - 0.014613729891508*G0_1_0 - 0.069349977119074*G0_1_1 + 0.021268196181390*G0_1_2 + 0.011873655536850*G0_2_0 + 0.021268196181391*G0_2_1;
    A[1323] = -0.042960451489097*G0_0_0 - 0.042275432900433*G0_0_1 - 0.035914546005692*G0_1_0 + 0.092086070276174*G0_1_1 - 0.042275432900433*G0_1_2 - 0.042960451489097*G0_2_0 - 0.042275432900434*G0_2_1;
    A[1324] = 0.124738623002511*G0_0_0 + 0.096294041606541*G0_0_1 + 0.028444581395970*G0_1_0 - 0.064456987200042*G0_1_1 + 0.096294041606541*G0_1_2 + 0.124738623002511*G0_2_0 + 0.096294041606542*G0_2_1;
    A[1325] = 0.002544354757896*G0_0_0 + 0.005838967970045*G0_0_1 - 0.005904207835631*G0_1_0 - 0.031869674339292*G0_1_1 + 0.005838967970045*G0_1_2 + 0.002544354757896*G0_2_0 + 0.005838967970045*G0_2_1;
    A[1326] = -0.042960451489097*G0_0_0 - 0.042275432900433*G0_0_1 - 0.000685018588664*G0_1_0 + 0.043971669405697*G0_1_1 - 0.042275432900432*G0_1_2 - 0.042960451489097*G0_2_0 - 0.042275432900433*G0_2_1;
    A[1327] = 0.011873655536850*G0_0_0 + 0.021268196181391*G0_0_1 - 0.009394540644541*G0_1_0 - 0.018789081289081*G0_1_1 + 0.021268196181390*G0_1_2 + 0.011873655536850*G0_2_0 + 0.021268196181391*G0_2_1;
    A[1328] = -0.009394540644541*G0_0_1 - 0.009394540644541*G0_1_0 + 0.045341706583025*G0_1_1 - 0.009394540644541*G0_1_2 - 0.009394540644541*G0_2_1;
    A[1329] = -0.003294613212148*G0_0_1 - 0.003294613212148*G0_1_0 + 0.022670853291513*G0_1_1 - 0.003294613212148*G0_1_2 - 0.003294613212148*G0_2_1;
    A[1330] = -0.009394540644541*G0_0_1 - 0.009394540644541*G0_1_0 - 0.009394540644541*G0_1_2 - 0.009394540644541*G0_2_1;
    A[1331] = -0.003294613212148*G0_0_1 - 0.003294613212148*G0_1_0 + 0.022670853291513*G0_1_1 - 0.003294613212148*G0_1_2 - 0.003294613212148*G0_2_1;
    A[1332] = -0.003294613212148*G0_0_1 - 0.003294613212148*G0_1_0 - 0.003294613212148*G0_1_2 - 0.003294613212148*G0_2_1;
    A[1333] = -0.009394540644541*G0_0_1 - 0.009394540644541*G0_1_0 - 0.009394540644541*G0_1_2 - 0.009394540644541*G0_2_1;
    A[1334] = 0.021268196181391*G0_0_1 + 0.011873655536850*G0_0_2 + 0.021268196181390*G0_1_0 - 0.069349977119074*G0_1_1 - 0.014613729891508*G0_1_2 + 0.021268196181391*G0_2_1 + 0.011873655536850*G0_2_2;
    A[1335] = 0.005838967970045*G0_0_1 + 0.002544354757896*G0_0_2 + 0.005838967970044*G0_1_0 - 0.031869674339292*G0_1_1 - 0.005904207835631*G0_1_2 + 0.005838967970045*G0_2_1 + 0.002544354757896*G0_2_2;
    A[1336] = 0.021268196181390*G0_0_1 + 0.011873655536850*G0_0_2 + 0.021268196181391*G0_1_0 - 0.018789081289082*G0_1_1 - 0.009394540644541*G0_1_2 + 0.021268196181390*G0_2_1 + 0.011873655536850*G0_2_2;
    A[1337] = -0.042275432900433*G0_0_1 - 0.042960451489097*G0_0_2 - 0.042275432900432*G0_1_0 + 0.092086070276174*G0_1_1 - 0.035914546005691*G0_1_2 - 0.042275432900433*G0_2_1 - 0.042960451489097*G0_2_2;
    A[1338] = -0.042275432900432*G0_0_1 - 0.042960451489097*G0_0_2 - 0.042275432900433*G0_1_0 + 0.043971669405697*G0_1_1 - 0.000685018588664*G0_1_2 - 0.042275432900432*G0_2_1 - 0.042960451489097*G0_2_2;
    A[1339] = 0.096294041606541*G0_0_1 + 0.124738623002511*G0_0_2 + 0.096294041606541*G0_1_0 - 0.064456987200042*G0_1_1 + 0.028444581395970*G0_1_2 + 0.096294041606541*G0_2_1 + 0.124738623002511*G0_2_2;
    A[1340] = 0.002609594623484*G0_0_1 + 0.002609594623484*G0_1_0 - 0.151356488162042*G0_1_1 + 0.002609594623483*G0_1_2 + 0.002609594623484*G0_2_1;
    A[1341] = 0.002609594623483*G0_0_1 + 0.002609594623483*G0_1_0 - 0.045341706583026*G0_1_1 + 0.002609594623483*G0_1_2 + 0.002609594623483*G0_2_1;
    A[1342] = 0.035229527417027*G0_0_1 + 0.035229527417027*G0_1_0 + 0.166687856575008*G0_1_1 + 0.035229527417027*G0_1_2 + 0.035229527417027*G0_2_1;
    A[1343] = 0.002609594623484*G0_0_1 + 0.002609594623484*G0_1_0 - 0.045341706583026*G0_1_1 + 0.002609594623484*G0_1_2 + 0.002609594623484*G0_2_1;
    A[1344] = -0.055127686421089*G0_0_0 - 0.055127686421089*G0_0_1 - 0.055127686421089*G0_0_2 - 0.017870503981615*G0_1_0 - 0.017870503981615*G0_1_1 - 0.017870503981615*G0_1_2 - 0.017870503981615*G0_2_0 - 0.017870503981615*G0_2_1 - 0.017870503981615*G0_2_2;
    A[1345] = 0.015331368412965*G0_0_0 + 0.010531019103068*G0_1_0 + 0.010531019103068*G0_2_0;
    A[1346] = -0.004800349309898*G0_1_1 - 0.004800349309898*G0_2_1;
    A[1347] = -0.004800349309898*G0_1_2 - 0.004800349309898*G0_2_2;
    A[1348] = 0.005375764924376*G0_1_1 + 0.005375764924376*G0_1_2 + 0.005375764924376*G0_2_1 + 0.005375764924376*G0_2_2;
    A[1349] = 0.002289919282107*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.002289919282107*G0_2_2;
    A[1350] = 0.002289919282107*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.002289919282107*G0_2_2;
    A[1351] = 0.005375764924376*G0_1_1 + 0.005375764924376*G0_1_2 + 0.005375764924376*G0_2_1 + 0.005375764924376*G0_2_2;
    A[1352] = 0.022083694501229*G0_0_0 + 0.027459459425605*G0_0_2 + 0.027459459425605*G0_1_0 + 0.032835224349980*G0_1_2 + 0.027459459425605*G0_2_0 + 0.032835224349980*G0_2_2;
    A[1353] = 0.006589226424296*G0_0_0 + 0.008879145706403*G0_0_2 + 0.008879145706403*G0_1_0 + 0.011169064988510*G0_1_2 + 0.008879145706403*G0_2_0 + 0.011169064988510*G0_2_2;
    A[1354] = 0.009394540644540*G0_0_0 + 0.011684459926647*G0_0_2 + 0.011684459926647*G0_1_0 + 0.013974379208754*G0_1_2 + 0.011684459926647*G0_2_0 + 0.013974379208754*G0_2_2;
    A[1355] = 0.005375764924376*G0_0_2 + 0.005375764924376*G0_1_0 + 0.010751529848752*G0_1_2 + 0.005375764924376*G0_2_0 + 0.010751529848752*G0_2_2;
    A[1356] = 0.022083694501229*G0_0_0 + 0.027459459425605*G0_0_1 + 0.027459459425604*G0_1_0 + 0.032835224349980*G0_1_1 + 0.027459459425605*G0_2_0 + 0.032835224349980*G0_2_1;
    A[1357] = 0.006589226424296*G0_0_0 + 0.008879145706403*G0_0_1 + 0.008879145706403*G0_1_0 + 0.011169064988510*G0_1_1 + 0.008879145706403*G0_2_0 + 0.011169064988510*G0_2_1;
    A[1358] = 0.009394540644540*G0_0_0 + 0.011684459926647*G0_0_1 + 0.011684459926647*G0_1_0 + 0.013974379208754*G0_1_1 + 0.011684459926647*G0_2_0 + 0.013974379208754*G0_2_1;
    A[1359] = 0.005375764924376*G0_0_1 + 0.005375764924376*G0_1_0 + 0.010751529848752*G0_1_1 + 0.005375764924376*G0_2_0 + 0.010751529848752*G0_2_1;
    A[1360] = 0.019637199541713*G0_0_0 + 0.019637199541713*G0_0_1 + 0.089548239504836*G0_0_2 + 0.089548239504836*G0_1_0 + 0.089548239504836*G0_1_1 + 0.019637199541713*G0_1_2 + 0.089548239504836*G0_2_0 + 0.089548239504836*G0_2_1 + 0.019637199541713*G0_2_2;
    A[1361] = -0.018691221490700*G0_0_0 - 0.018691221490700*G0_0_1 - 0.057417605703195*G0_0_2 - 0.057417605703195*G0_1_0 - 0.057417605703195*G0_1_1 + 0.012493434259927*G0_1_2 - 0.057417605703195*G0_2_0 - 0.057417605703195*G0_2_1 + 0.012493434259927*G0_2_2;
    A[1362] = 0.009394540644540*G0_0_0 + 0.009394540644540*G0_0_1 + 0.028372817543824*G0_0_2 + 0.028372817543824*G0_1_0 + 0.028372817543824*G0_1_1 - 0.031543475011357*G0_1_2 + 0.028372817543824*G0_2_0 + 0.028372817543824*G0_2_1 - 0.031543475011357*G0_2_2;
    A[1363] = -0.005375764924376*G0_0_2 - 0.005375764924376*G0_1_0 - 0.005375764924376*G0_1_1 + 0.022083694501229*G0_1_2 - 0.005375764924376*G0_2_0 - 0.005375764924376*G0_2_1 + 0.022083694501229*G0_2_2;
    A[1364] = 0.019637199541713*G0_0_0 + 0.089548239504836*G0_0_1 + 0.019637199541713*G0_0_2 + 0.089548239504836*G0_1_0 + 0.019637199541713*G0_1_1 + 0.089548239504836*G0_1_2 + 0.089548239504835*G0_2_0 + 0.019637199541713*G0_2_1 + 0.089548239504836*G0_2_2;
    A[1365] = -0.018691221490700*G0_0_0 - 0.057417605703195*G0_0_1 - 0.018691221490700*G0_0_2 - 0.057417605703195*G0_1_0 + 0.012493434259927*G0_1_1 - 0.057417605703196*G0_1_2 - 0.057417605703195*G0_2_0 + 0.012493434259927*G0_2_1 - 0.057417605703195*G0_2_2;
    A[1366] = 0.009394540644540*G0_0_0 + 0.028372817543824*G0_0_1 + 0.009394540644540*G0_0_2 + 0.028372817543824*G0_1_0 - 0.031543475011357*G0_1_1 + 0.028372817543824*G0_1_2 + 0.028372817543824*G0_2_0 - 0.031543475011357*G0_2_1 + 0.028372817543824*G0_2_2;
    A[1367] = -0.005375764924376*G0_0_1 - 0.005375764924376*G0_1_0 + 0.022083694501229*G0_1_1 - 0.005375764924376*G0_1_2 - 0.005375764924376*G0_2_0 + 0.022083694501229*G0_2_1 - 0.005375764924376*G0_2_2;
    A[1368] = 0.179096479009671*G0_0_0 + 0.109185439046549*G0_0_1 + 0.109185439046549*G0_0_2 + 0.109185439046549*G0_1_0 + 0.179096479009671*G0_1_1 + 0.179096479009671*G0_1_2 + 0.109185439046549*G0_2_0 + 0.179096479009671*G0_2_1 + 0.179096479009671*G0_2_2;
    A[1369] = -0.243357746612952*G0_0_0 - 0.108337320793916*G0_0_1 - 0.108337320793916*G0_0_2 - 0.173446706649829*G0_1_0 - 0.147063705006411*G0_1_1 - 0.147063705006411*G0_1_2 - 0.173446706649829*G0_2_0 - 0.147063705006411*G0_2_1 - 0.147063705006411*G0_2_2;
    A[1370] = 0.185268170294209*G0_0_0 + 0.081739027594061*G0_0_1 + 0.081739027594061*G0_0_2 + 0.125351877739029*G0_1_0 + 0.100717304493344*G0_1_1 + 0.100717304493344*G0_1_2 + 0.125351877739029*G0_2_0 + 0.100717304493344*G0_2_1 + 0.100717304493344*G0_2_2;
    A[1371] = -0.081210584682806*G0_0_0 - 0.027459459425605*G0_0_1 - 0.027459459425605*G0_0_2 - 0.053751125257201*G0_1_0 - 0.032835224349980*G0_1_1 - 0.032835224349980*G0_1_2 - 0.053751125257201*G0_2_0 - 0.032835224349980*G0_2_1 - 0.032835224349980*G0_2_2;
    A[1372] = 0.045341706583025*G0_0_0 + 0.054736247227566*G0_0_1 + 0.054736247227565*G0_0_2 + 0.054736247227566*G0_1_0 + 0.064130787872106*G0_1_1 + 0.064130787872106*G0_1_2 + 0.054736247227566*G0_2_0 + 0.064130787872106*G0_2_1 + 0.064130787872106*G0_2_2;
    A[1373] = 0.022670853291513*G0_0_0 + 0.025965466503660*G0_0_1 + 0.025965466503661*G0_0_2 + 0.025965466503660*G0_1_0 + 0.029260079715809*G0_1_1 + 0.029260079715809*G0_1_2 + 0.025965466503660*G0_2_0 + 0.029260079715809*G0_2_1 + 0.029260079715808*G0_2_2;
    A[1374] = 0.009394540644540*G0_0_1 + 0.009394540644540*G0_0_2 + 0.009394540644541*G0_1_0 + 0.018789081289081*G0_1_1 + 0.018789081289081*G0_1_2 + 0.009394540644541*G0_2_0 + 0.018789081289081*G0_2_1 + 0.018789081289081*G0_2_2;
    A[1375] = 0.022670853291512*G0_0_0 + 0.025965466503661*G0_0_1 + 0.025965466503661*G0_0_2 + 0.025965466503660*G0_1_0 + 0.029260079715808*G0_1_1 + 0.029260079715808*G0_1_2 + 0.025965466503660*G0_2_0 + 0.029260079715808*G0_2_1 + 0.029260079715808*G0_2_2;
    A[1376] = 0.003294613212148*G0_0_1 + 0.003294613212148*G0_0_2 + 0.003294613212148*G0_1_0 + 0.006589226424296*G0_1_1 + 0.006589226424296*G0_1_2 + 0.003294613212148*G0_2_0 + 0.006589226424296*G0_2_1 + 0.006589226424296*G0_2_2;
    A[1377] = 0.009394540644540*G0_0_1 + 0.009394540644540*G0_0_2 + 0.009394540644541*G0_1_0 + 0.018789081289081*G0_1_1 + 0.018789081289081*G0_1_2 + 0.009394540644541*G0_2_0 + 0.018789081289081*G0_2_1 + 0.018789081289081*G0_2_2;
    A[1378] = -0.060673074995991*G0_0_0 - 0.032228493600021*G0_0_1 - 0.032228493600021*G0_0_2 - 0.032228493600021*G0_1_0 - 0.128522535206562*G0_1_1 - 0.128522535206562*G0_1_2 - 0.032228493600021*G0_2_0 - 0.128522535206562*G0_2_1 - 0.128522535206561*G0_2_2;
    A[1379] = 0.022670853291513*G0_0_0 + 0.021985834702848*G0_0_1 + 0.021985834702848*G0_0_2 + 0.021985834702848*G0_1_0 + 0.064261267603281*G0_1_1 + 0.064261267603281*G0_1_2 + 0.021985834702848*G0_2_0 + 0.064261267603281*G0_2_1 + 0.064261267603281*G0_2_2;
    A[1380] = -0.009394540644541*G0_0_1 - 0.009394540644541*G0_0_2 - 0.009394540644541*G0_1_0 - 0.030662736825931*G0_1_1 - 0.030662736825931*G0_1_2 - 0.009394540644541*G0_2_0 - 0.030662736825931*G0_2_1 - 0.030662736825931*G0_2_2;
    A[1381] = 0.022670853291513*G0_0_0 + 0.021985834702848*G0_0_1 + 0.021985834702848*G0_0_2 + 0.021985834702848*G0_1_0 + 0.064261267603281*G0_1_1 + 0.064261267603281*G0_1_2 + 0.021985834702848*G0_2_0 + 0.064261267603281*G0_2_1 + 0.064261267603281*G0_2_2;
    A[1382] = -0.003294613212148*G0_0_1 - 0.003294613212148*G0_0_2 - 0.003294613212148*G0_1_0 - 0.009133581182192*G0_1_1 - 0.009133581182192*G0_1_2 - 0.003294613212148*G0_2_0 - 0.009133581182192*G0_2_1 - 0.009133581182192*G0_2_2;
    A[1383] = -0.009394540644541*G0_0_1 - 0.009394540644540*G0_0_2 - 0.009394540644541*G0_1_0 - 0.030662736825931*G0_1_1 - 0.030662736825931*G0_1_2 - 0.009394540644541*G0_2_0 - 0.030662736825931*G0_2_1 - 0.030662736825931*G0_2_2;
    A[1384] = -0.064456987200042*G0_0_0 - 0.092901568596012*G0_0_1 - 0.160751028806583*G0_0_2 - 0.160751028806582*G0_1_0 - 0.064456987200042*G0_1_1 - 0.257045070413123*G0_1_2 - 0.160751028806582*G0_2_0 - 0.064456987200042*G0_2_1 - 0.257045070413123*G0_2_2;
    A[1385] = 0.092086070276173*G0_0_0 + 0.128000616281865*G0_0_1 + 0.134361503176606*G0_0_2 + 0.134361503176605*G0_1_0 + 0.127315597693200*G0_1_1 + 0.176636936077038*G0_1_2 + 0.134361503176606*G0_2_0 + 0.127315597693200*G0_2_1 + 0.176636936077038*G0_2_2;
    A[1386] = -0.069349977119073*G0_0_0 - 0.054736247227566*G0_0_1 - 0.090618173300464*G0_0_2 - 0.090618173300463*G0_1_0 - 0.064130787872106*G0_1_1 - 0.111886369481854*G0_1_2 - 0.090618173300463*G0_2_0 - 0.064130787872106*G0_2_1 - 0.111886369481854*G0_2_2;
    A[1387] = 0.043971669405697*G0_0_0 + 0.044656687994361*G0_0_1 + 0.086247102306129*G0_0_2 + 0.086247102306129*G0_1_0 + 0.043971669405697*G0_1_1 + 0.128522535206562*G0_1_2 + 0.086247102306129*G0_2_0 + 0.043971669405697*G0_2_1 + 0.128522535206562*G0_2_2;
    A[1388] = -0.031869674339293*G0_0_0 - 0.025965466503661*G0_0_1 - 0.037708642309337*G0_0_2 - 0.037708642309337*G0_1_0 - 0.029260079715808*G0_1_1 - 0.043547610279380*G0_1_2 - 0.037708642309336*G0_2_0 - 0.029260079715808*G0_2_1 - 0.043547610279380*G0_2_2;
    A[1389] = -0.018789081289081*G0_0_0 - 0.009394540644540*G0_0_1 - 0.040057277470471*G0_0_2 - 0.040057277470471*G0_1_0 - 0.018789081289081*G0_1_1 - 0.061325473651862*G0_1_2 - 0.040057277470471*G0_2_0 - 0.018789081289081*G0_2_1 - 0.061325473651862*G0_2_2;
    A[1390] = -0.064456987200042*G0_0_0 - 0.160751028806582*G0_0_1 - 0.092901568596012*G0_0_2 - 0.160751028806582*G0_1_0 - 0.257045070413123*G0_1_1 - 0.064456987200042*G0_1_2 - 0.160751028806582*G0_2_0 - 0.257045070413123*G0_2_1 - 0.064456987200042*G0_2_2;
    A[1391] = 0.092086070276173*G0_0_0 + 0.134361503176606*G0_0_1 + 0.128000616281865*G0_0_2 + 0.134361503176605*G0_1_0 + 0.176636936077038*G0_1_1 + 0.127315597693200*G0_1_2 + 0.134361503176605*G0_2_0 + 0.176636936077038*G0_2_1 + 0.127315597693200*G0_2_2;
    A[1392] = -0.069349977119073*G0_0_0 - 0.090618173300463*G0_0_1 - 0.054736247227565*G0_0_2 - 0.090618173300463*G0_1_0 - 0.111886369481854*G0_1_1 - 0.064130787872106*G0_1_2 - 0.090618173300463*G0_2_0 - 0.111886369481854*G0_2_1 - 0.064130787872106*G0_2_2;
    A[1393] = 0.043971669405696*G0_0_0 + 0.086247102306129*G0_0_1 + 0.044656687994361*G0_0_2 + 0.086247102306129*G0_1_0 + 0.128522535206562*G0_1_1 + 0.043971669405697*G0_1_2 + 0.086247102306129*G0_2_0 + 0.128522535206562*G0_2_1 + 0.043971669405696*G0_2_2;
    A[1394] = -0.031869674339292*G0_0_0 - 0.037708642309336*G0_0_1 - 0.025965466503661*G0_0_2 - 0.037708642309336*G0_1_0 - 0.043547610279381*G0_1_1 - 0.029260079715809*G0_1_2 - 0.037708642309337*G0_2_0 - 0.043547610279380*G0_2_1 - 0.029260079715809*G0_2_2;
    A[1395] = -0.018789081289081*G0_0_0 - 0.040057277470471*G0_0_1 - 0.009394540644540*G0_0_2 - 0.040057277470471*G0_1_0 - 0.061325473651862*G0_1_1 - 0.018789081289081*G0_1_2 - 0.040057277470471*G0_2_0 - 0.061325473651862*G0_2_1 - 0.018789081289081*G0_2_2;
    A[1396] = 0.166687856575008*G0_0_0 + 0.131458329157981*G0_0_1 + 0.131458329157980*G0_0_2 + 0.131458329157980*G0_1_0 + 0.096228801740953*G0_1_1 + 0.096228801740953*G0_1_2 + 0.131458329157980*G0_2_0 + 0.096228801740953*G0_2_1 + 0.096228801740953*G0_2_2;
    A[1397] = -0.151356488162042*G0_0_0 - 0.153966082785525*G0_0_1 - 0.153966082785525*G0_0_2 - 0.153966082785525*G0_1_0 - 0.156575677409008*G0_1_1 - 0.156575677409009*G0_1_2 - 0.153966082785525*G0_2_0 - 0.156575677409008*G0_2_1 - 0.156575677409008*G0_2_2;
    A[1398] = -0.045341706583025*G0_0_0 - 0.047951301206509*G0_0_1 - 0.047951301206509*G0_0_2 - 0.047951301206509*G0_1_0 - 0.050560895829992*G0_1_1 - 0.050560895829993*G0_1_2 - 0.047951301206509*G0_2_0 - 0.050560895829992*G0_2_1 - 0.050560895829992*G0_2_2;
    A[1399] = -0.045341706583025*G0_0_0 - 0.047951301206509*G0_0_1 - 0.047951301206509*G0_0_2 - 0.047951301206508*G0_1_0 - 0.050560895829992*G0_1_1 - 0.050560895829992*G0_1_2 - 0.047951301206508*G0_2_0 - 0.050560895829992*G0_2_1 - 0.050560895829992*G0_2_2;
    A[1400] = 0.055127686421088*G0_0_0 + 0.055127686421088*G0_0_1 + 0.055127686421088*G0_0_2 + 0.021469134967399*G0_1_0 + 0.021469134967399*G0_1_1 + 0.021469134967399*G0_1_2 + 0.021469134967399*G0_2_0 + 0.021469134967399*G0_2_1 + 0.021469134967399*G0_2_2;
    A[1401] = -0.038817720024317*G0_0_0 - 0.023263231271043*G0_1_0 - 0.023263231271043*G0_2_0;
    A[1402] = -0.003365072266982*G0_1_1 - 0.003365072266982*G0_2_1;
    A[1403] = -0.003365072266982*G0_1_2 - 0.003365072266982*G0_2_2;
    A[1404] = 0.002289919282107*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.002289919282107*G0_2_2;
    A[1405] = 0.001787572317086*G0_1_1 + 0.001787572317086*G0_1_2 + 0.001787572317086*G0_2_1 + 0.001787572317086*G0_2_2;
    A[1406] = 0.001787572317086*G0_1_1 + 0.001787572317086*G0_1_2 + 0.001787572317086*G0_2_1 + 0.001787572317086*G0_2_2;
    A[1407] = 0.002289919282107*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.002289919282107*G0_2_2;
    A[1408] = -0.031543475011356*G0_0_0 - 0.059916292555180*G0_0_2 - 0.059916292555181*G0_1_0 - 0.078894569454464*G0_1_2 - 0.059916292555181*G0_2_0 - 0.078894569454464*G0_2_2;
    A[1409] = -0.006263027096361*G0_0_0 - 0.005780252091017*G0_0_2 - 0.005780252091016*G0_1_0 - 0.005232237220085*G0_1_2 - 0.005780252091016*G0_2_0 - 0.005232237220085*G0_2_2;
    A[1410] = 0.000065239865587*G0_0_0 - 0.013152356902356*G0_0_2 - 0.013152356902357*G0_1_0 - 0.026304713804713*G0_1_2 - 0.013152356902357*G0_2_0 - 0.026304713804713*G0_2_2;
    A[1411] = 0.002289919282107*G0_0_2 + 0.002289919282107*G0_1_0 + 0.013974379208754*G0_1_2 + 0.002289919282107*G0_2_0 + 0.013974379208754*G0_2_2;
    A[1412] = -0.031543475011356*G0_0_0 - 0.059916292555180*G0_0_1 - 0.059916292555180*G0_1_0 - 0.078894569454464*G0_1_1 - 0.059916292555180*G0_2_0 - 0.078894569454464*G0_2_1;
    A[1413] = -0.006263027096360*G0_0_0 - 0.005780252091016*G0_0_1 - 0.005780252091016*G0_1_0 - 0.005232237220085*G0_1_1 - 0.005780252091016*G0_2_0 - 0.005232237220085*G0_2_1;
    A[1414] = 0.000065239865587*G0_0_0 - 0.013152356902357*G0_0_1 - 0.013152356902357*G0_1_0 - 0.026304713804713*G0_1_1 - 0.013152356902357*G0_2_0 - 0.026304713804713*G0_2_1;
    A[1415] = 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.013974379208754*G0_1_1 + 0.002289919282107*G0_2_0 + 0.013974379208754*G0_2_1;
    A[1416] = 0.012493434259927*G0_0_0 + 0.012493434259927*G0_0_1 - 0.057417605703195*G0_0_2 - 0.057417605703195*G0_1_0 - 0.057417605703195*G0_1_1 - 0.018691221490700*G0_1_2 - 0.057417605703195*G0_2_0 - 0.057417605703195*G0_2_1 - 0.018691221490700*G0_2_2;
    A[1417] = 0.000260959462348*G0_0_0 + 0.000260959462348*G0_0_1 + 0.005062613569558*G0_0_2 + 0.005062613569558*G0_1_0 + 0.005062613569558*G0_1_1 + 0.000260959462348*G0_1_2 + 0.005062613569558*G0_2_0 + 0.005062613569558*G0_2_1 + 0.000260959462348*G0_2_2;
    A[1418] = 0.000065239865587*G0_0_0 + 0.000065239865587*G0_0_1 - 0.000482775005344*G0_0_2 - 0.000482775005344*G0_1_0 - 0.000482775005344*G0_1_1 - 0.006263027096360*G0_1_2 - 0.000482775005344*G0_2_0 - 0.000482775005344*G0_2_1 - 0.006263027096360*G0_2_2;
    A[1419] = -0.002289919282107*G0_0_2 - 0.002289919282107*G0_1_0 - 0.002289919282107*G0_1_1 + 0.006589226424296*G0_1_2 - 0.002289919282107*G0_2_0 - 0.002289919282107*G0_2_1 + 0.006589226424296*G0_2_2;
    A[1420] = 0.012493434259927*G0_0_0 - 0.057417605703195*G0_0_1 + 0.012493434259927*G0_0_2 - 0.057417605703195*G0_1_0 - 0.018691221490700*G0_1_1 - 0.057417605703195*G0_1_2 - 0.057417605703195*G0_2_0 - 0.018691221490700*G0_2_1 - 0.057417605703195*G0_2_2;
    A[1421] = 0.000260959462348*G0_0_0 + 0.005062613569558*G0_0_1 + 0.000260959462348*G0_0_2 + 0.005062613569558*G0_1_0 + 0.000260959462348*G0_1_1 + 0.005062613569558*G0_1_2 + 0.005062613569558*G0_2_0 + 0.000260959462348*G0_2_1 + 0.005062613569558*G0_2_2;
    A[1422] = 0.000065239865587*G0_0_0 - 0.000482775005344*G0_0_1 + 0.000065239865587*G0_0_2 - 0.000482775005344*G0_1_0 - 0.006263027096360*G0_1_1 - 0.000482775005344*G0_1_2 - 0.000482775005344*G0_2_0 - 0.006263027096360*G0_2_1 - 0.000482775005344*G0_2_2;
    A[1423] = -0.002289919282107*G0_0_1 - 0.002289919282107*G0_1_0 + 0.006589226424296*G0_1_1 - 0.002289919282107*G0_1_2 - 0.002289919282107*G0_2_0 + 0.006589226424296*G0_2_1 - 0.002289919282107*G0_2_2;
    A[1424] = -0.243357746612952*G0_0_0 - 0.173446706649829*G0_0_1 - 0.173446706649829*G0_0_2 - 0.108337320793916*G0_1_0 - 0.147063705006411*G0_1_1 - 0.147063705006411*G0_1_2 - 0.108337320793916*G0_2_0 - 0.147063705006411*G0_2_1 - 0.147063705006411*G0_2_2;
    A[1425] = 0.428965164208214*G0_0_0 + 0.226095278178608*G0_0_1 + 0.226095278178608*G0_0_2 + 0.226095278178608*G0_1_0 + 0.304226541205704*G0_1_1 + 0.304226541205703*G0_1_2 + 0.226095278178608*G0_2_0 + 0.304226541205703*G0_2_1 + 0.304226541205703*G0_2_2;
    A[1426] = -0.387185554286243*G0_0_0 - 0.167692550505048*G0_0_1 - 0.167692550505047*G0_0_2 - 0.219493003781195*G0_1_0 - 0.204187731314464*G0_1_1 - 0.204187731314464*G0_1_2 - 0.219493003781195*G0_2_0 - 0.204187731314464*G0_2_1 - 0.204187731314464*G0_2_2;
    A[1427] = 0.185268170294209*G0_0_0 + 0.059916292555180*G0_0_1 + 0.059916292555180*G0_0_2 + 0.103529142700148*G0_1_0 + 0.078894569454464*G0_1_1 + 0.078894569454464*G0_1_2 + 0.103529142700148*G0_2_0 + 0.078894569454463*G0_2_1 + 0.078894569454464*G0_2_2;
    A[1428] = -0.066544662898829*G0_0_0 - 0.089313375988722*G0_0_1 - 0.089313375988721*G0_0_2 - 0.089313375988722*G0_1_0 - 0.127087258163645*G0_1_1 - 0.127087258163645*G0_1_2 - 0.089313375988722*G0_2_0 - 0.127087258163645*G0_2_1 - 0.127087258163645*G0_2_2;
    A[1429] = -0.000652398655871*G0_0_0 - 0.009492400442921*G0_0_1 - 0.009492400442921*G0_0_2 - 0.009492400442921*G0_1_0 - 0.018984800885842*G0_1_1 - 0.018984800885842*G0_1_2 - 0.009492400442921*G0_2_0 - 0.018984800885842*G0_2_1 - 0.018984800885842*G0_2_2;
    A[1430] = 0.000065239865587*G0_0_1 + 0.000065239865587*G0_0_2 + 0.000065239865587*G0_1_0 - 0.014874689353856*G0_1_1 - 0.014874689353856*G0_1_2 + 0.000065239865587*G0_2_0 - 0.014874689353856*G0_2_1 - 0.014874689353856*G0_2_2;
    A[1431] = -0.000652398655870*G0_0_0 - 0.009492400442921*G0_0_1 - 0.009492400442921*G0_0_2 - 0.009492400442921*G0_1_0 - 0.018984800885842*G0_1_1 - 0.018984800885843*G0_1_2 - 0.009492400442921*G0_2_0 - 0.018984800885842*G0_2_1 - 0.018984800885842*G0_2_2;
    A[1432] = 0.002576974690690*G0_0_1 + 0.002576974690690*G0_0_2 + 0.002576974690690*G0_1_0 + 0.004501550725509*G0_1_1 + 0.004501550725509*G0_1_2 + 0.002576974690690*G0_2_0 + 0.004501550725509*G0_2_1 + 0.004501550725509*G0_2_2;
    A[1433] = 0.000065239865587*G0_0_1 + 0.000065239865587*G0_0_2 + 0.000065239865587*G0_1_0 - 0.014874689353856*G0_1_1 - 0.014874689353856*G0_1_2 + 0.000065239865587*G0_2_0 - 0.014874689353856*G0_2_1 - 0.014874689353856*G0_2_2;
    A[1434] = 0.047625101878574*G0_0_0 - 0.014744209622682*G0_0_1 - 0.014744209622682*G0_0_2 - 0.014744209622682*G0_1_0 + 0.047625101878573*G0_1_1 + 0.047625101878573*G0_1_2 - 0.014744209622682*G0_2_0 + 0.047625101878573*G0_2_1 + 0.047625101878573*G0_2_2;
    A[1435] = -0.000652398655871*G0_0_0 + 0.002316015228342*G0_0_1 + 0.002316015228342*G0_0_2 + 0.002316015228342*G0_1_0 + 0.008807381854257*G0_1_1 + 0.008807381854257*G0_1_2 + 0.002316015228342*G0_2_0 + 0.008807381854257*G0_2_1 + 0.008807381854257*G0_2_2;
    A[1436] = -0.000065239865587*G0_0_1 - 0.000065239865587*G0_0_2 - 0.000065239865587*G0_1_0 - 0.001304797311742*G0_1_1 - 0.001304797311742*G0_1_2 - 0.000065239865587*G0_2_0 - 0.001304797311742*G0_2_1 - 0.001304797311742*G0_2_2;
    A[1437] = -0.000652398655871*G0_0_0 + 0.002316015228342*G0_0_1 + 0.002316015228342*G0_0_2 + 0.002316015228342*G0_1_0 + 0.008807381854257*G0_1_1 + 0.008807381854257*G0_1_2 + 0.002316015228342*G0_2_0 + 0.008807381854257*G0_2_1 + 0.008807381854257*G0_2_2;
    A[1438] = -0.002576974690690*G0_0_1 - 0.002576974690690*G0_0_2 - 0.002576974690690*G0_1_0 - 0.015657567740901*G0_1_1 - 0.015657567740901*G0_1_2 - 0.002576974690690*G0_2_0 - 0.015657567740901*G0_2_1 - 0.015657567740901*G0_2_2;
    A[1439] = -0.000065239865587*G0_0_1 - 0.000065239865587*G0_0_2 - 0.000065239865587*G0_1_0 - 0.001304797311742*G0_1_1 - 0.001304797311742*G0_1_2 - 0.000065239865587*G0_2_0 - 0.001304797311742*G0_2_1 - 0.001304797311742*G0_2_2;
    A[1440] = -0.003392473010529*G0_0_0 + 0.058976838490726*G0_0_1 + 0.194675758911868*G0_0_2 + 0.194675758911867*G0_1_0 + 0.132306447410612*G0_1_1 + 0.121346149991982*G0_1_2 + 0.194675758911867*G0_2_0 + 0.132306447410612*G0_2_1 + 0.121346149991982*G0_2_2;
    A[1441] = -0.062238831770081*G0_0_0 - 0.160783648739376*G0_0_1 - 0.250814663249556*G0_0_2 - 0.250814663249555*G0_1_0 - 0.166948816037355*G0_1_1 - 0.334680510461757*G0_1_2 - 0.250814663249555*G0_2_0 - 0.166948816037355*G0_2_1 - 0.334680510461757*G0_2_2;
    A[1442] = 0.084681345532038*G0_0_0 + 0.089313375988722*G0_0_1 + 0.173472802596064*G0_0_2 + 0.173472802596064*G0_1_0 + 0.127087258163645*G0_1_1 + 0.209419968534549*G0_1_2 + 0.173472802596064*G0_2_0 + 0.127087258163645*G0_2_1 + 0.209419968534549*G0_2_2;
    A[1443] = -0.006784946021057*G0_0_0 - 0.009753359905270*G0_0_1 - 0.037154103451846*G0_0_2 - 0.037154103451846*G0_1_0 - 0.043645470077762*G0_1_1 + 0.037186723384640*G0_1_2 - 0.037154103451846*G0_2_0 - 0.043645470077761*G0_2_1 + 0.037186723384640*G0_2_2;
    A[1444] = 0.012787013655070*G0_0_0 + 0.009492400442921*G0_0_1 + 0.037871741973304*G0_0_2 + 0.037871741973304*G0_1_0 + 0.018984800885842*G0_1_1 + 0.056758683060766*G0_1_2 + 0.037871741973304*G0_2_0 + 0.018984800885842*G0_2_1 + 0.056758683060766*G0_2_2;
    A[1445] = -0.000130479731175*G0_0_0 - 0.000065239865587*G0_0_1 + 0.013635131907701*G0_0_2 + 0.013635131907701*G0_1_0 + 0.014874689353856*G0_1_1 - 0.025443547578964*G0_1_2 + 0.013635131907701*G0_2_0 + 0.014874689353856*G0_2_1 - 0.025443547578964*G0_2_2;
    A[1446] = -0.003392473010529*G0_0_0 + 0.194675758911868*G0_0_1 + 0.058976838490726*G0_0_2 + 0.194675758911867*G0_1_0 + 0.121346149991981*G0_1_1 + 0.132306447410612*G0_1_2 + 0.194675758911867*G0_2_0 + 0.121346149991981*G0_2_1 + 0.132306447410612*G0_2_2;
    A[1447] = -0.062238831770081*G0_0_0 - 0.250814663249556*G0_0_1 - 0.160783648739376*G0_0_2 - 0.250814663249555*G0_1_0 - 0.334680510461757*G0_1_1 - 0.166948816037355*G0_1_2 - 0.250814663249555*G0_2_0 - 0.334680510461757*G0_2_1 - 0.166948816037355*G0_2_2;
    A[1448] = 0.084681345532038*G0_0_0 + 0.173472802596064*G0_0_1 + 0.089313375988721*G0_0_2 + 0.173472802596064*G0_1_0 + 0.209419968534549*G0_1_1 + 0.127087258163645*G0_1_2 + 0.173472802596064*G0_2_0 + 0.209419968534549*G0_2_1 + 0.127087258163645*G0_2_2;
    A[1449] = -0.006784946021057*G0_0_0 - 0.037154103451846*G0_0_1 - 0.009753359905269*G0_0_2 - 0.037154103451846*G0_1_0 + 0.037186723384640*G0_1_1 - 0.043645470077761*G0_1_2 - 0.037154103451846*G0_2_0 + 0.037186723384640*G0_2_1 - 0.043645470077761*G0_2_2;
    A[1450] = 0.012787013655069*G0_0_0 + 0.037871741973304*G0_0_1 + 0.009492400442921*G0_0_2 + 0.037871741973304*G0_1_0 + 0.056758683060766*G0_1_1 + 0.018984800885842*G0_1_2 + 0.037871741973304*G0_2_0 + 0.056758683060765*G0_2_1 + 0.018984800885842*G0_2_2;
    A[1451] = -0.000130479731174*G0_0_0 + 0.013635131907701*G0_0_1 - 0.000065239865587*G0_0_2 + 0.013635131907701*G0_1_0 - 0.025443547578964*G0_1_1 + 0.014874689353856*G0_1_2 + 0.013635131907701*G0_2_0 - 0.025443547578964*G0_2_1 + 0.014874689353856*G0_2_2;
    A[1452] = -0.161794866655976*G0_0_0 - 0.066218463570894*G0_0_1 - 0.066218463570893*G0_0_2 - 0.066218463570893*G0_1_0 - 0.156575677409009*G0_1_1 - 0.156575677409009*G0_1_2 - 0.066218463570893*G0_2_0 - 0.156575677409009*G0_2_1 - 0.156575677409008*G0_2_2;
    A[1453] = 0.180714427676231*G0_0_0 + 0.170276049182297*G0_0_1 + 0.170276049182297*G0_0_2 + 0.170276049182297*G0_1_0 + 0.185933616923197*G0_1_1 + 0.185933616923198*G0_1_2 + 0.170276049182297*G0_2_0 + 0.185933616923197*G0_2_1 + 0.185933616923198*G0_2_2;
    A[1454] = 0.001304797311741*G0_0_0 + 0.007176385214580*G0_0_1 + 0.007176385214579*G0_0_2 + 0.007176385214579*G0_1_0 + 0.039143919352253*G0_1_1 + 0.039143919352253*G0_1_2 + 0.007176385214579*G0_2_0 + 0.039143919352253*G0_2_1 + 0.039143919352253*G0_2_2;
    A[1455] = 0.001304797311741*G0_0_0 + 0.007176385214580*G0_0_1 + 0.007176385214579*G0_0_2 + 0.007176385214579*G0_1_0 + 0.039143919352253*G0_1_1 + 0.039143919352252*G0_1_2 + 0.007176385214579*G0_2_0 + 0.039143919352253*G0_2_1 + 0.039143919352252*G0_2_2;
    A[1456] = -0.038817720024317*G0_0_0 - 0.038817720024317*G0_0_1 - 0.038817720024317*G0_0_2 - 0.015554488753273*G0_1_0 - 0.015554488753273*G0_1_1 - 0.015554488753273*G0_1_2 - 0.015554488753273*G0_2_0 - 0.015554488753273*G0_2_1 - 0.015554488753273*G0_2_2;
    A[1457] = 0.055127686421088*G0_0_0 + 0.033658551453690*G0_1_0 + 0.033658551453690*G0_2_0;
    A[1458] = -0.003365072266982*G0_1_1 - 0.003365072266982*G0_2_1;
    A[1459] = -0.003365072266982*G0_1_2 - 0.003365072266982*G0_2_2;
    A[1460] = 0.002289919282107*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.002289919282107*G0_2_2;
    A[1461] = 0.001787572317086*G0_1_1 + 0.001787572317086*G0_1_2 + 0.001787572317086*G0_2_1 + 0.001787572317086*G0_2_2;
    A[1462] = 0.001787572317086*G0_1_1 + 0.001787572317086*G0_1_2 + 0.001787572317086*G0_2_1 + 0.001787572317086*G0_2_2;
    A[1463] = 0.002289919282107*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.002289919282107*G0_2_2;
    A[1464] = 0.012493434259927*G0_0_0 + 0.069911039963122*G0_0_2 + 0.069911039963122*G0_1_0 + 0.108637424175617*G0_1_2 + 0.069911039963122*G0_2_0 + 0.108637424175617*G0_2_2;
    A[1465] = 0.000260959462349*G0_0_0 - 0.004801654107209*G0_0_2 - 0.004801654107209*G0_1_0 - 0.009603308214419*G0_1_2 - 0.004801654107209*G0_2_0 - 0.009603308214419*G0_2_2;
    A[1466] = 0.000065239865587*G0_0_0 + 0.000548014870931*G0_0_2 + 0.000548014870931*G0_1_0 - 0.005232237220085*G0_1_2 + 0.000548014870931*G0_2_0 - 0.005232237220085*G0_2_2;
    A[1467] = 0.002289919282107*G0_0_2 + 0.002289919282107*G0_1_0 + 0.011169064988510*G0_1_2 + 0.002289919282107*G0_2_0 + 0.011169064988510*G0_2_2;
    A[1468] = 0.012493434259927*G0_0_0 + 0.069911039963122*G0_0_1 + 0.069911039963122*G0_1_0 + 0.108637424175617*G0_1_1 + 0.069911039963122*G0_2_0 + 0.108637424175617*G0_2_1;
    A[1469] = 0.000260959462348*G0_0_0 - 0.004801654107209*G0_0_1 - 0.004801654107210*G0_1_0 - 0.009603308214419*G0_1_1 - 0.004801654107210*G0_2_0 - 0.009603308214419*G0_2_1;
    A[1470] = 0.000065239865587*G0_0_0 + 0.000548014870931*G0_0_1 + 0.000548014870931*G0_1_0 - 0.005232237220085*G0_1_1 + 0.000548014870931*G0_2_0 - 0.005232237220085*G0_2_1;
    A[1471] = 0.002289919282107*G0_0_1 + 0.002289919282107*G0_1_0 + 0.011169064988510*G0_1_1 + 0.002289919282107*G0_2_0 + 0.011169064988510*G0_2_1;
    A[1472] = -0.031543475011357*G0_0_0 - 0.031543475011357*G0_0_1 + 0.028372817543824*G0_0_2 + 0.028372817543824*G0_1_0 + 0.028372817543824*G0_1_1 + 0.009394540644541*G0_1_2 + 0.028372817543824*G0_2_0 + 0.028372817543824*G0_2_1 + 0.009394540644541*G0_2_2;
    A[1473] = -0.006263027096360*G0_0_0 - 0.006263027096360*G0_0_1 - 0.000482775005344*G0_0_2 - 0.000482775005344*G0_1_0 - 0.000482775005344*G0_1_1 + 0.000065239865587*G0_1_2 - 0.000482775005344*G0_2_0 - 0.000482775005344*G0_2_1 + 0.000065239865587*G0_2_2;
    A[1474] = 0.000065239865587*G0_0_0 + 0.000065239865587*G0_0_1 + 0.013217596767944*G0_0_2 + 0.013217596767944*G0_1_0 + 0.013217596767944*G0_1_1 + 0.000065239865587*G0_1_2 + 0.013217596767944*G0_2_0 + 0.013217596767944*G0_2_1 + 0.000065239865587*G0_2_2;
    A[1475] = -0.002289919282107*G0_0_2 - 0.002289919282107*G0_1_0 - 0.002289919282107*G0_1_1 + 0.009394540644541*G0_1_2 - 0.002289919282107*G0_2_0 - 0.002289919282107*G0_2_1 + 0.009394540644541*G0_2_2;
    A[1476] = -0.031543475011357*G0_0_0 + 0.028372817543824*G0_0_1 - 0.031543475011357*G0_0_2 + 0.028372817543824*G0_1_0 + 0.009394540644540*G0_1_1 + 0.028372817543824*G0_1_2 + 0.028372817543824*G0_2_0 + 0.009394540644540*G0_2_1 + 0.028372817543824*G0_2_2;
    A[1477] = -0.006263027096360*G0_0_0 - 0.000482775005344*G0_0_1 - 0.006263027096360*G0_0_2 - 0.000482775005344*G0_1_0 + 0.000065239865587*G0_1_1 - 0.000482775005344*G0_1_2 - 0.000482775005344*G0_2_0 + 0.000065239865587*G0_2_1 - 0.000482775005344*G0_2_2;
    A[1478] = 0.000065239865587*G0_0_0 + 0.013217596767944*G0_0_1 + 0.000065239865587*G0_0_2 + 0.013217596767944*G0_1_0 + 0.000065239865587*G0_1_1 + 0.013217596767944*G0_1_2 + 0.013217596767944*G0_2_0 + 0.000065239865587*G0_2_1 + 0.013217596767944*G0_2_2;
    A[1479] = -0.002289919282107*G0_0_1 - 0.002289919282107*G0_1_0 + 0.009394540644541*G0_1_1 - 0.002289919282107*G0_1_2 - 0.002289919282107*G0_2_0 + 0.009394540644541*G0_2_1 - 0.002289919282107*G0_2_2;
    A[1480] = 0.185268170294209*G0_0_0 + 0.125351877739029*G0_0_1 + 0.125351877739029*G0_0_2 + 0.081739027594061*G0_1_0 + 0.100717304493344*G0_1_1 + 0.100717304493344*G0_1_2 + 0.081739027594061*G0_2_0 + 0.100717304493344*G0_2_1 + 0.100717304493344*G0_2_2;
    A[1481] = -0.387185554286243*G0_0_0 - 0.219493003781195*G0_0_1 - 0.219493003781195*G0_0_2 - 0.167692550505048*G0_1_0 - 0.204187731314464*G0_1_1 - 0.204187731314464*G0_1_2 - 0.167692550505047*G0_2_0 - 0.204187731314464*G0_2_1 - 0.204187731314464*G0_2_2;
    A[1482] = 0.428965164208214*G0_0_0 + 0.202869886029605*G0_0_1 + 0.202869886029605*G0_0_2 + 0.202869886029605*G0_1_0 + 0.281001149056701*G0_1_1 + 0.281001149056701*G0_1_2 + 0.202869886029605*G0_2_0 + 0.281001149056701*G0_2_1 + 0.281001149056700*G0_2_2;
    A[1483] = -0.243357746612952*G0_0_0 - 0.069911039963122*G0_0_1 - 0.069911039963122*G0_0_2 - 0.135020425819035*G0_1_0 - 0.108637424175617*G0_1_1 - 0.108637424175617*G0_1_2 - 0.135020425819035*G0_2_0 - 0.108637424175617*G0_2_1 - 0.108637424175617*G0_2_2;
    A[1484] = 0.047625101878574*G0_0_0 + 0.062369311501255*G0_0_1 + 0.062369311501254*G0_0_2 + 0.062369311501256*G0_1_0 + 0.124738623002510*G0_1_1 + 0.124738623002510*G0_1_2 + 0.062369311501256*G0_2_0 + 0.124738623002510*G0_2_1 + 0.124738623002510*G0_2_2;
    A[1485] = -0.000652398655871*G0_0_0 - 0.002968413884212*G0_0_1 - 0.002968413884213*G0_0_2 - 0.002968413884213*G0_1_0 + 0.003522952741703*G0_1_1 + 0.003522952741702*G0_1_2 - 0.002968413884212*G0_2_0 + 0.003522952741703*G0_2_1 + 0.003522952741702*G0_2_2;
    A[1486] = 0.000065239865587*G0_0_1 + 0.000065239865587*G0_0_2 + 0.000065239865587*G0_1_0 - 0.001174317580568*G0_1_1 - 0.001174317580567*G0_1_2 + 0.000065239865587*G0_2_0 - 0.001174317580568*G0_2_1 - 0.001174317580567*G0_2_2;
    A[1487] = -0.000652398655871*G0_0_0 - 0.002968413884212*G0_0_1 - 0.002968413884212*G0_0_2 - 0.002968413884213*G0_1_0 + 0.003522952741703*G0_1_1 + 0.003522952741703*G0_1_2 - 0.002968413884213*G0_2_0 + 0.003522952741703*G0_2_1 + 0.003522952741703*G0_2_2;
    A[1488] = 0.002576974690690*G0_0_1 + 0.002576974690690*G0_0_2 + 0.002576974690690*G0_1_0 - 0.010503618359521*G0_1_1 - 0.010503618359521*G0_1_2 + 0.002576974690690*G0_2_0 - 0.010503618359521*G0_2_1 - 0.010503618359521*G0_2_2;
    A[1489] = 0.000065239865587*G0_0_1 + 0.000065239865587*G0_0_2 + 0.000065239865587*G0_1_0 - 0.001174317580568*G0_1_1 - 0.001174317580568*G0_1_2 + 0.000065239865587*G0_2_0 - 0.001174317580568*G0_2_1 - 0.001174317580568*G0_2_2;
    A[1490] = -0.066544662898829*G0_0_0 + 0.022768713089893*G0_0_1 + 0.022768713089894*G0_0_2 + 0.022768713089893*G0_1_0 - 0.015005169085030*G0_1_1 - 0.015005169085030*G0_1_2 + 0.022768713089893*G0_2_0 - 0.015005169085030*G0_2_1 - 0.015005169085030*G0_2_2;
    A[1491] = -0.000652398655871*G0_0_0 + 0.008840001787050*G0_0_1 + 0.008840001787050*G0_0_2 + 0.008840001787050*G0_1_0 - 0.000652398655871*G0_1_1 - 0.000652398655871*G0_1_2 + 0.008840001787050*G0_2_0 - 0.000652398655871*G0_2_1 - 0.000652398655871*G0_2_2;
    A[1492] = -0.000065239865587*G0_0_1 - 0.000065239865587*G0_0_2 - 0.000065239865587*G0_1_0 - 0.015005169085030*G0_1_1 - 0.015005169085030*G0_1_2 - 0.000065239865587*G0_2_0 - 0.015005169085030*G0_2_1 - 0.015005169085030*G0_2_2;
    A[1493] = -0.000652398655871*G0_0_0 + 0.008840001787050*G0_0_1 + 0.008840001787050*G0_0_2 + 0.008840001787050*G0_1_0 - 0.000652398655871*G0_1_1 - 0.000652398655871*G0_1_2 + 0.008840001787050*G0_2_0 - 0.000652398655871*G0_2_1 - 0.000652398655871*G0_2_2;
    A[1494] = -0.002576974690690*G0_0_1 - 0.002576974690690*G0_0_2 - 0.002576974690690*G0_1_0 - 0.000652398655871*G0_1_1 - 0.000652398655871*G0_1_2 - 0.002576974690690*G0_2_0 - 0.000652398655871*G0_2_1 - 0.000652398655871*G0_2_2;
    A[1495] = -0.000065239865587*G0_0_1 - 0.000065239865587*G0_0_2 - 0.000065239865587*G0_1_0 - 0.015005169085030*G0_1_1 - 0.015005169085030*G0_1_2 - 0.000065239865587*G0_2_0 - 0.015005169085030*G0_2_1 - 0.015005169085030*G0_2_2;
    A[1496] = 0.084681345532039*G0_0_0 - 0.004632030456683*G0_0_1 - 0.088791457064025*G0_0_2 - 0.088791457064025*G0_1_0 - 0.051017574889102*G0_1_1 - 0.052844291125540*G0_1_2 - 0.088791457064025*G0_2_0 - 0.051017574889102*G0_2_1 - 0.052844291125540*G0_2_2;
    A[1497] = -0.062238831770082*G0_0_0 + 0.098544816969295*G0_0_1 + 0.188575831479475*G0_0_2 + 0.188575831479474*G0_1_0 + 0.182410664181494*G0_1_1 + 0.104709984267274*G0_1_2 + 0.188575831479474*G0_2_0 + 0.182410664181494*G0_2_1 + 0.104709984267274*G0_2_2;
    A[1498] = -0.003392473010528*G0_0_0 - 0.062369311501255*G0_0_1 - 0.198068231922396*G0_0_2 - 0.198068231922395*G0_1_0 - 0.124738623002510*G0_1_1 - 0.271397840842282*G0_1_2 - 0.198068231922395*G0_2_0 - 0.124738623002510*G0_2_1 - 0.271397840842282*G0_2_2;
    A[1499] = 0.012787013655069*G0_0_0 + 0.003294613212148*G0_0_1 - 0.025084728318235*G0_0_2 - 0.025084728318235*G0_1_0 - 0.015592327875314*G0_1_1 - 0.006197787230773*G0_1_2 - 0.025084728318235*G0_2_0 - 0.015592327875314*G0_2_1 - 0.006197787230773*G0_2_2;
    A[1500] = -0.006784946021058*G0_0_0 + 0.002968413884212*G0_0_1 + 0.030369157430789*G0_0_2 + 0.030369157430789*G0_1_0 - 0.003522952741703*G0_1_1 + 0.104709984267276*G0_1_2 + 0.030369157430789*G0_2_0 - 0.003522952741703*G0_2_1 + 0.104709984267276*G0_2_2;
    A[1501] = -0.000130479731174*G0_0_0 - 0.000065239865587*G0_0_1 - 0.013765611638875*G0_0_2 - 0.013765611638875*G0_1_0 + 0.001174317580568*G0_1_1 - 0.052844291125541*G0_1_2 - 0.013765611638875*G0_2_0 + 0.001174317580568*G0_2_1 - 0.052844291125541*G0_2_2;
    A[1502] = 0.084681345532039*G0_0_0 - 0.088791457064025*G0_0_1 - 0.004632030456683*G0_0_2 - 0.088791457064025*G0_1_0 - 0.052844291125540*G0_1_1 - 0.051017574889101*G0_1_2 - 0.088791457064025*G0_2_0 - 0.052844291125540*G0_2_1 - 0.051017574889101*G0_2_2;
    A[1503] = -0.062238831770082*G0_0_0 + 0.188575831479475*G0_0_1 + 0.098544816969294*G0_0_2 + 0.188575831479474*G0_1_0 + 0.104709984267274*G0_1_1 + 0.182410664181495*G0_1_2 + 0.188575831479474*G0_2_0 + 0.104709984267274*G0_2_1 + 0.182410664181495*G0_2_2;
    A[1504] = -0.003392473010528*G0_0_0 - 0.198068231922396*G0_0_1 - 0.062369311501254*G0_0_2 - 0.198068231922395*G0_1_0 - 0.271397840842282*G0_1_1 - 0.124738623002510*G0_1_2 - 0.198068231922395*G0_2_0 - 0.271397840842282*G0_2_1 - 0.124738623002510*G0_2_2;
    A[1505] = 0.012787013655069*G0_0_0 - 0.025084728318235*G0_0_1 + 0.003294613212148*G0_0_2 - 0.025084728318235*G0_1_0 - 0.006197787230773*G0_1_1 - 0.015592327875314*G0_1_2 - 0.025084728318235*G0_2_0 - 0.006197787230773*G0_2_1 - 0.015592327875314*G0_2_2;
    A[1506] = -0.006784946021057*G0_0_0 + 0.030369157430789*G0_0_1 + 0.002968413884212*G0_0_2 + 0.030369157430789*G0_1_0 + 0.104709984267276*G0_1_1 - 0.003522952741703*G0_1_2 + 0.030369157430789*G0_2_0 + 0.104709984267275*G0_2_1 - 0.003522952741703*G0_2_2;
    A[1507] = -0.000130479731174*G0_0_0 - 0.013765611638875*G0_0_1 - 0.000065239865587*G0_0_2 - 0.013765611638875*G0_1_0 - 0.052844291125541*G0_1_1 + 0.001174317580567*G0_1_2 - 0.013765611638875*G0_2_0 - 0.052844291125541*G0_2_1 + 0.001174317580567*G0_2_2;
    A[1508] = 0.180714427676231*G0_0_0 + 0.010438378493934*G0_0_1 + 0.010438378493934*G0_0_2 + 0.010438378493933*G0_1_0 + 0.026095946234835*G0_1_1 + 0.026095946234834*G0_1_2 + 0.010438378493933*G0_2_0 + 0.026095946234835*G0_2_1 + 0.026095946234834*G0_2_2;
    A[1509] = -0.161794866655976*G0_0_0 - 0.095576403085082*G0_0_1 - 0.095576403085082*G0_0_2 - 0.095576403085082*G0_1_0 - 0.185933616923197*G0_1_1 - 0.185933616923198*G0_1_2 - 0.095576403085082*G0_2_0 - 0.185933616923197*G0_2_1 - 0.185933616923198*G0_2_2;
    A[1510] = 0.001304797311742*G0_0_0 - 0.005871587902838*G0_0_1 - 0.005871587902838*G0_0_2 - 0.005871587902838*G0_1_0 + 0.026095946234835*G0_1_1 + 0.026095946234835*G0_1_2 - 0.005871587902838*G0_2_0 + 0.026095946234835*G0_2_1 + 0.026095946234835*G0_2_2;
    A[1511] = 0.001304797311742*G0_0_0 - 0.005871587902838*G0_0_1 - 0.005871587902838*G0_0_2 - 0.005871587902837*G0_1_0 + 0.026095946234835*G0_1_1 + 0.026095946234836*G0_1_2 - 0.005871587902837*G0_2_0 + 0.026095946234835*G0_2_1 + 0.026095946234836*G0_2_2;
    A[1512] = 0.015331368412965*G0_0_0 + 0.015331368412965*G0_0_1 + 0.015331368412965*G0_0_2 + 0.004800349309898*G0_1_0 + 0.004800349309898*G0_1_1 + 0.004800349309898*G0_1_2 + 0.004800349309898*G0_2_0 + 0.004800349309898*G0_2_1 + 0.004800349309898*G0_2_2;
    A[1513] = -0.055127686421089*G0_0_0 - 0.037257182439474*G0_1_0 - 0.037257182439474*G0_2_0;
    A[1514] = -0.004800349309898*G0_1_1 - 0.004800349309898*G0_2_1;
    A[1515] = -0.004800349309898*G0_1_2 - 0.004800349309898*G0_2_2;
    A[1516] = 0.005375764924376*G0_1_1 + 0.005375764924376*G0_1_2 + 0.005375764924376*G0_2_1 + 0.005375764924376*G0_2_2;
    A[1517] = 0.002289919282107*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.002289919282107*G0_2_2;
    A[1518] = 0.002289919282107*G0_1_1 + 0.002289919282107*G0_1_2 + 0.002289919282107*G0_2_1 + 0.002289919282107*G0_2_2;
    A[1519] = 0.005375764924376*G0_1_1 + 0.005375764924376*G0_1_2 + 0.005375764924376*G0_2_1 + 0.005375764924376*G0_2_2;
    A[1520] = 0.019637199541714*G0_0_0 - 0.069911039963122*G0_0_2 - 0.069911039963122*G0_1_0 - 0.139822079926244*G0_1_2 - 0.069911039963122*G0_2_0 - 0.139822079926245*G0_2_2;
    A[1521] = -0.018691221490701*G0_0_0 + 0.038726384212495*G0_0_2 + 0.038726384212495*G0_1_0 + 0.108637424175617*G0_1_2 + 0.038726384212495*G0_2_0 + 0.108637424175617*G0_2_2;
    A[1522] = 0.009394540644541*G0_0_0 - 0.018978276899283*G0_0_2 - 0.018978276899284*G0_1_0 - 0.078894569454464*G0_1_2 - 0.018978276899283*G0_2_0 - 0.078894569454464*G0_2_2;
    A[1523] = 0.005375764924376*G0_0_2 + 0.005375764924376*G0_1_0 + 0.032835224349981*G0_1_2 + 0.005375764924376*G0_2_0 + 0.032835224349981*G0_2_2;
    A[1524] = 0.019637199541714*G0_0_0 - 0.069911039963122*G0_0_1 - 0.069911039963122*G0_1_0 - 0.139822079926245*G0_1_1 - 0.069911039963122*G0_2_0 - 0.139822079926245*G0_2_1;
    A[1525] = -0.018691221490701*G0_0_0 + 0.038726384212495*G0_0_1 + 0.038726384212495*G0_1_0 + 0.108637424175617*G0_1_1 + 0.038726384212495*G0_2_0 + 0.108637424175617*G0_2_1;
    A[1526] = 0.009394540644541*G0_0_0 - 0.018978276899283*G0_0_1 - 0.018978276899284*G0_1_0 - 0.078894569454464*G0_1_1 - 0.018978276899284*G0_2_0 - 0.078894569454464*G0_2_1;
    A[1527] = 0.005375764924376*G0_0_1 + 0.005375764924376*G0_1_0 + 0.032835224349981*G0_1_1 + 0.005375764924376*G0_2_0 + 0.032835224349981*G0_2_1;
    A[1528] = 0.022083694501229*G0_0_0 + 0.022083694501229*G0_0_1 - 0.005375764924376*G0_0_2 - 0.005375764924376*G0_1_0 - 0.005375764924376*G0_1_1 - 0.005375764924376*G0_2_0 - 0.005375764924376*G0_2_1;
    A[1529] = 0.006589226424296*G0_0_0 + 0.006589226424296*G0_0_1 - 0.002289919282107*G0_0_2 - 0.002289919282107*G0_1_0 - 0.002289919282107*G0_1_1 - 0.002289919282107*G0_2_0 - 0.002289919282107*G0_2_1;
    A[1530] = 0.009394540644541*G0_0_0 + 0.009394540644541*G0_0_1 - 0.002289919282107*G0_0_2 - 0.002289919282107*G0_1_0 - 0.002289919282106*G0_1_1 - 0.002289919282107*G0_2_0 - 0.002289919282107*G0_2_1;
    A[1531] = -0.005375764924376*G0_0_2 - 0.005375764924376*G0_1_0 - 0.005375764924376*G0_1_1 - 0.005375764924376*G0_2_0 - 0.005375764924376*G0_2_1;
    A[1532] = 0.022083694501229*G0_0_0 - 0.005375764924376*G0_0_1 + 0.022083694501229*G0_0_2 - 0.005375764924376*G0_1_0 - 0.005375764924376*G0_1_2 - 0.005375764924376*G0_2_0 - 0.005375764924376*G0_2_2;
    A[1533] = 0.006589226424296*G0_0_0 - 0.002289919282107*G0_0_1 + 0.006589226424296*G0_0_2 - 0.002289919282107*G0_1_0 - 0.002289919282107*G0_1_2 - 0.002289919282107*G0_2_0 - 0.002289919282107*G0_2_2;
    A[1534] = 0.009394540644541*G0_0_0 - 0.002289919282107*G0_0_1 + 0.009394540644541*G0_0_2 - 0.002289919282107*G0_1_0 - 0.002289919282107*G0_1_2 - 0.002289919282107*G0_2_0 - 0.002289919282107*G0_2_2;
    A[1535] = -0.005375764924376*G0_0_1 - 0.005375764924376*G0_1_0 - 0.005375764924376*G0_1_2 - 0.005375764924376*G0_2_0 - 0.005375764924376*G0_2_2;
    A[1536] = -0.081210584682806*G0_0_0 - 0.053751125257201*G0_0_1 - 0.053751125257201*G0_0_2 - 0.027459459425605*G0_1_0 - 0.032835224349980*G0_1_1 - 0.032835224349980*G0_1_2 - 0.027459459425605*G0_2_0 - 0.032835224349980*G0_2_1 - 0.032835224349980*G0_2_2;
    A[1537] = 0.185268170294209*G0_0_0 + 0.103529142700148*G0_0_1 + 0.103529142700148*G0_0_2 + 0.059916292555180*G0_1_0 + 0.078894569454464*G0_1_1 + 0.078894569454463*G0_1_2 + 0.059916292555180*G0_2_0 + 0.078894569454464*G0_2_1 + 0.078894569454464*G0_2_2;
    A[1538] = -0.243357746612952*G0_0_0 - 0.135020425819035*G0_0_1 - 0.135020425819035*G0_0_2 - 0.069911039963122*G0_1_0 - 0.108637424175617*G0_1_1 - 0.108637424175617*G0_1_2 - 0.069911039963122*G0_2_0 - 0.108637424175617*G0_2_1 - 0.108637424175617*G0_2_2;
    A[1539] = 0.179096479009672*G0_0_0 + 0.069911039963122*G0_0_1 + 0.069911039963122*G0_0_2 + 0.069911039963122*G0_1_0 + 0.139822079926244*G0_1_1 + 0.139822079926244*G0_1_2 + 0.069911039963122*G0_2_0 + 0.139822079926244*G0_2_1 + 0.139822079926244*G0_2_2;
    A[1540] = -0.060673074995991*G0_0_0 - 0.028444581395970*G0_0_1 - 0.028444581395970*G0_0_2 - 0.028444581395970*G0_1_0 - 0.124738623002510*G0_1_1 - 0.124738623002510*G0_1_2 - 0.028444581395970*G0_2_0 - 0.124738623002511*G0_2_1 - 0.124738623002511*G0_2_2;
    A[1541] = 0.022670853291513*G0_0_0 + 0.000685018588664*G0_0_1 + 0.000685018588664*G0_0_2 + 0.000685018588665*G0_1_0 + 0.042960451489097*G0_1_1 + 0.042960451489097*G0_1_2 + 0.000685018588665*G0_2_0 + 0.042960451489097*G0_2_1 + 0.042960451489097*G0_2_2;
    A[1542] = 0.009394540644541*G0_0_1 + 0.009394540644540*G0_0_2 + 0.009394540644540*G0_1_0 - 0.011873655536850*G0_1_1 - 0.011873655536850*G0_1_2 + 0.009394540644540*G0_2_0 - 0.011873655536850*G0_2_1 - 0.011873655536850*G0_2_2;
    A[1543] = 0.022670853291513*G0_0_0 + 0.000685018588664*G0_0_1 + 0.000685018588664*G0_0_2 + 0.000685018588665*G0_1_0 + 0.042960451489097*G0_1_1 + 0.042960451489097*G0_1_2 + 0.000685018588665*G0_2_0 + 0.042960451489097*G0_2_1 + 0.042960451489097*G0_2_2;
    A[1544] = 0.003294613212148*G0_0_1 + 0.003294613212148*G0_0_2 + 0.003294613212148*G0_1_0 - 0.002544354757896*G0_1_1 - 0.002544354757897*G0_1_2 + 0.003294613212148*G0_2_0 - 0.002544354757896*G0_2_1 - 0.002544354757897*G0_2_2;
    A[1545] = 0.009394540644541*G0_0_1 + 0.009394540644541*G0_0_2 + 0.009394540644541*G0_1_0 - 0.011873655536850*G0_1_1 - 0.011873655536849*G0_1_2 + 0.009394540644540*G0_2_0 - 0.011873655536850*G0_2_1 - 0.011873655536849*G0_2_2;
    A[1546] = 0.045341706583026*G0_0_0 - 0.009394540644541*G0_0_1 - 0.009394540644541*G0_0_2 - 0.009394540644541*G0_1_0 - 0.009394540644541*G0_2_0;
    A[1547] = 0.022670853291513*G0_0_0 - 0.003294613212148*G0_0_1 - 0.003294613212148*G0_0_2 - 0.003294613212148*G0_1_0 - 0.003294613212148*G0_2_0;
    A[1548] = -0.009394540644540*G0_0_1 - 0.009394540644541*G0_0_2 - 0.009394540644540*G0_1_0 - 0.009394540644540*G0_2_0;
    A[1549] = 0.022670853291513*G0_0_0 - 0.003294613212148*G0_0_1 - 0.003294613212148*G0_0_2 - 0.003294613212148*G0_1_0 - 0.003294613212148*G0_2_0;
    A[1550] = -0.003294613212148*G0_0_1 - 0.003294613212148*G0_0_2 - 0.003294613212148*G0_1_0 - 0.003294613212148*G0_2_0;
    A[1551] = -0.009394540644541*G0_0_1 - 0.009394540644541*G0_0_2 - 0.009394540644541*G0_1_0 - 0.009394540644540*G0_2_0;
    A[1552] = -0.069349977119074*G0_0_0 - 0.014613729891508*G0_0_1 + 0.021268196181390*G0_0_2 + 0.021268196181390*G0_1_0 + 0.011873655536850*G0_1_1 + 0.021268196181390*G0_2_0 + 0.011873655536850*G0_2_1;
    A[1553] = 0.092086070276174*G0_0_0 - 0.035914546005691*G0_0_1 - 0.042275432900432*G0_0_2 - 0.042275432900431*G0_1_0 - 0.042960451489096*G0_1_1 - 0.042275432900431*G0_2_0 - 0.042960451489096*G0_2_1;
    A[1554] = -0.064456987200043*G0_0_0 + 0.028444581395970*G0_0_1 + 0.096294041606540*G0_0_2 + 0.096294041606540*G0_1_0 + 0.124738623002510*G0_1_1 + 0.096294041606540*G0_2_0 + 0.124738623002510*G0_2_1;
    A[1555] = -0.031869674339292*G0_0_0 - 0.005904207835631*G0_0_1 + 0.005838967970044*G0_0_2 + 0.005838967970044*G0_1_0 + 0.002544354757897*G0_1_1 + 0.005838967970044*G0_2_0 + 0.002544354757897*G0_2_1;
    A[1556] = 0.043971669405697*G0_0_0 - 0.000685018588664*G0_0_1 - 0.042275432900433*G0_0_2 - 0.042275432900432*G0_1_0 - 0.042960451489097*G0_1_1 - 0.042275432900432*G0_2_0 - 0.042960451489097*G0_2_1;
    A[1557] = -0.018789081289081*G0_0_0 - 0.009394540644541*G0_0_1 + 0.021268196181390*G0_0_2 + 0.021268196181390*G0_1_0 + 0.011873655536850*G0_1_1 + 0.021268196181390*G0_2_0 + 0.011873655536850*G0_2_1;
    A[1558] = -0.069349977119074*G0_0_0 + 0.021268196181390*G0_0_1 - 0.014613729891508*G0_0_2 + 0.021268196181390*G0_1_0 + 0.011873655536849*G0_1_2 + 0.021268196181390*G0_2_0 + 0.011873655536849*G0_2_2;
    A[1559] = 0.092086070276174*G0_0_0 - 0.042275432900432*G0_0_1 - 0.035914546005691*G0_0_2 - 0.042275432900432*G0_1_0 - 0.042960451489096*G0_1_2 - 0.042275432900432*G0_2_0 - 0.042960451489096*G0_2_2;
    A[1560] = -0.064456987200043*G0_0_0 + 0.096294041606540*G0_0_1 + 0.028444581395970*G0_0_2 + 0.096294041606540*G0_1_0 + 0.124738623002510*G0_1_2 + 0.096294041606540*G0_2_0 + 0.124738623002510*G0_2_2;
    A[1561] = -0.031869674339292*G0_0_0 + 0.005838967970044*G0_0_1 - 0.005904207835632*G0_0_2 + 0.005838967970045*G0_1_0 + 0.002544354757897*G0_1_2 + 0.005838967970045*G0_2_0 + 0.002544354757896*G0_2_2;
    A[1562] = 0.043971669405697*G0_0_0 - 0.042275432900433*G0_0_1 - 0.000685018588664*G0_0_2 - 0.042275432900433*G0_1_0 - 0.042960451489097*G0_1_2 - 0.042275432900433*G0_2_0 - 0.042960451489097*G0_2_2;
    A[1563] = -0.018789081289081*G0_0_0 + 0.021268196181391*G0_0_1 - 0.009394540644540*G0_0_2 + 0.021268196181390*G0_1_0 + 0.011873655536850*G0_1_2 + 0.021268196181390*G0_2_0 + 0.011873655536850*G0_2_2;
    A[1564] = -0.151356488162042*G0_0_0 + 0.002609594623484*G0_0_1 + 0.002609594623484*G0_0_2 + 0.002609594623484*G0_1_0 + 0.002609594623484*G0_2_0;
    A[1565] = 0.166687856575008*G0_0_0 + 0.035229527417027*G0_0_1 + 0.035229527417027*G0_0_2 + 0.035229527417027*G0_1_0 + 0.035229527417027*G0_2_0;
    A[1566] = -0.045341706583026*G0_0_0 + 0.002609594623483*G0_0_1 + 0.002609594623484*G0_0_2 + 0.002609594623483*G0_1_0 + 0.002609594623483*G0_2_0;
    A[1567] = -0.045341706583026*G0_0_0 + 0.002609594623483*G0_0_1 + 0.002609594623483*G0_0_2 + 0.002609594623482*G0_1_0 + 0.002609594623482*G0_2_0;
    A[1568] = -0.013742125287264*G0_0_0 - 0.013742125287264*G0_0_1 - 0.013742125287264*G0_0_2 - 0.013742125287264*G0_1_0 - 0.013742125287264*G0_1_1 - 0.013742125287264*G0_1_2 - 0.013742125287264*G0_2_0 - 0.013742125287264*G0_2_1 - 0.013742125287264*G0_2_2;
    A[1569] = 0.047993054720485*G0_0_0 + 0.014394523943135*G0_1_0 + 0.014394523943135*G0_2_0;
    A[1570] = -0.005177435732991*G0_0_1 + 0.013742125287264*G0_1_1 - 0.005177435732991*G0_2_1;
    A[1571] = -0.005177435732991*G0_0_2 - 0.005177435732991*G0_1_2 + 0.013742125287264*G0_2_2;
    A[1572] = 0.042536392362781*G0_0_1 + 0.011873655536850*G0_0_2 - 0.018789081289081*G0_1_1 - 0.009394540644541*G0_1_2 + 0.021268196181390*G0_2_1 + 0.011873655536849*G0_2_2;
    A[1573] = 0.040318236932820*G0_0_1 + 0.054018608706109*G0_0_2 + 0.014874689353856*G0_1_1 + 0.014939929219443*G0_1_2 + 0.001239557446155*G0_2_1 + 0.001174317580568*G0_2_2;
    A[1574] = 0.054018608706108*G0_0_1 + 0.040318236932820*G0_0_2 + 0.001174317580568*G0_1_1 + 0.001239557446155*G0_1_2 + 0.014939929219443*G0_2_1 + 0.014874689353855*G0_2_2;
    A[1575] = 0.011873655536850*G0_0_1 + 0.042536392362781*G0_0_2 + 0.011873655536850*G0_1_1 + 0.021268196181391*G0_1_2 - 0.009394540644540*G0_2_1 - 0.018789081289081*G0_2_2;
    A[1576] = -0.064456987200042*G0_0_0 + 0.028444581395971*G0_0_2 + 0.192588083213082*G0_1_0 + 0.124738623002511*G0_1_2 + 0.096294041606541*G0_2_0 + 0.124738623002511*G0_2_2;
    A[1577] = 0.132306447410613*G0_0_0 + 0.073329608919886*G0_0_2 + 0.010960297418630*G0_1_0 + 0.146659217839772*G0_1_2 - 0.062369311501255*G0_2_0 - 0.124738623002510*G0_2_2;
    A[1578] = -0.051017574889102*G0_0_0 - 0.046385544432419*G0_0_2 + 0.001826716236438*G0_1_0 - 0.082332710370904*G0_1_2 + 0.037773882174923*G0_2_0 + 0.127087258163645*G0_2_2;
    A[1579] = 0.011873655536850*G0_0_0 + 0.026487385428358*G0_0_2 + 0.011873655536850*G0_1_0 + 0.047755581609748*G0_1_2 - 0.009394540644540*G0_2_0 - 0.064130787872107*G0_2_2;
    A[1580] = -0.064456987200042*G0_0_0 + 0.028444581395970*G0_0_1 + 0.096294041606541*G0_1_0 + 0.124738623002511*G0_1_1 + 0.192588083213082*G0_2_0 + 0.124738623002511*G0_2_1;
    A[1581] = 0.132306447410613*G0_0_0 + 0.073329608919885*G0_0_1 - 0.062369311501256*G0_1_0 - 0.124738623002511*G0_1_1 + 0.010960297418630*G0_2_0 + 0.146659217839772*G0_2_1;
    A[1582] = -0.051017574889102*G0_0_0 - 0.046385544432419*G0_0_1 + 0.037773882174924*G0_1_0 + 0.127087258163646*G0_1_1 + 0.001826716236439*G0_2_0 - 0.082332710370904*G0_2_1;
    A[1583] = 0.011873655536850*G0_0_0 + 0.026487385428358*G0_0_1 - 0.009394540644541*G0_1_0 - 0.064130787872107*G0_1_1 + 0.011873655536849*G0_2_0 + 0.047755581609747*G0_2_1;
    A[1584] = 0.018789081289081*G0_0_0 + 0.018789081289081*G0_0_1 + 0.009394540644540*G0_0_2 + 0.018789081289081*G0_1_0 + 0.018789081289081*G0_1_1 + 0.009394540644540*G0_1_2 + 0.009394540644540*G0_2_0 + 0.009394540644540*G0_2_1;
    A[1585] = -0.014874689353856*G0_0_0 - 0.014874689353856*G0_0_1 + 0.000065239865587*G0_0_2 - 0.014874689353856*G0_1_0 - 0.014874689353856*G0_1_1 + 0.000065239865587*G0_1_2 + 0.000065239865587*G0_2_0 + 0.000065239865587*G0_2_1;
    A[1586] = -0.001174317580568*G0_0_0 - 0.001174317580567*G0_0_1 + 0.000065239865587*G0_0_2 - 0.001174317580567*G0_1_0 - 0.001174317580567*G0_1_1 + 0.000065239865587*G0_1_2 + 0.000065239865587*G0_2_0 + 0.000065239865587*G0_2_1;
    A[1587] = -0.011873655536850*G0_0_0 - 0.011873655536850*G0_0_1 + 0.009394540644541*G0_0_2 - 0.011873655536850*G0_1_0 - 0.011873655536850*G0_1_1 + 0.009394540644541*G0_1_2 + 0.009394540644540*G0_2_0 + 0.009394540644540*G0_2_1;
    A[1588] = 0.018789081289081*G0_0_0 + 0.009394540644540*G0_0_1 + 0.018789081289081*G0_0_2 + 0.009394540644540*G0_1_0 + 0.009394540644540*G0_1_2 + 0.018789081289081*G0_2_0 + 0.009394540644540*G0_2_1 + 0.018789081289081*G0_2_2;
    A[1589] = -0.014874689353856*G0_0_0 + 0.000065239865588*G0_0_1 - 0.014874689353855*G0_0_2 + 0.000065239865588*G0_1_0 + 0.000065239865588*G0_1_2 - 0.014874689353855*G0_2_0 + 0.000065239865588*G0_2_1 - 0.014874689353855*G0_2_2;
    A[1590] = -0.001174317580568*G0_0_0 + 0.000065239865586*G0_0_1 - 0.001174317580568*G0_0_2 + 0.000065239865587*G0_1_0 + 0.000065239865587*G0_1_2 - 0.001174317580568*G0_2_0 + 0.000065239865586*G0_2_1 - 0.001174317580568*G0_2_2;
    A[1591] = -0.011873655536850*G0_0_0 + 0.009394540644541*G0_0_1 - 0.011873655536850*G0_0_2 + 0.009394540644541*G0_1_0 + 0.009394540644541*G0_1_2 - 0.011873655536849*G0_2_0 + 0.009394540644541*G0_2_1 - 0.011873655536849*G0_2_2;
    A[1592] = 0.045341706583025*G0_0_0 + 0.054736247227566*G0_0_1 + 0.054736247227566*G0_0_2 + 0.054736247227566*G0_1_0 + 0.064130787872106*G0_1_1 + 0.064130787872106*G0_1_2 + 0.054736247227565*G0_2_0 + 0.064130787872106*G0_2_1 + 0.064130787872106*G0_2_2;
    A[1593] = -0.066544662898829*G0_0_0 - 0.089313375988722*G0_0_1 - 0.089313375988722*G0_0_2 - 0.089313375988722*G0_1_0 - 0.127087258163645*G0_1_1 - 0.127087258163645*G0_1_2 - 0.089313375988721*G0_2_0 - 0.127087258163645*G0_2_1 - 0.127087258163645*G0_2_2;
    A[1594] = 0.047625101878574*G0_0_0 + 0.062369311501256*G0_0_1 + 0.062369311501256*G0_0_2 + 0.062369311501255*G0_1_0 + 0.124738623002510*G0_1_1 + 0.124738623002510*G0_1_2 + 0.062369311501254*G0_2_0 + 0.124738623002510*G0_2_1 + 0.124738623002510*G0_2_2;
    A[1595] = -0.060673074995991*G0_0_0 - 0.028444581395970*G0_0_1 - 0.028444581395970*G0_0_2 - 0.028444581395970*G0_1_0 - 0.124738623002510*G0_1_1 - 0.124738623002511*G0_1_2 - 0.028444581395970*G0_2_0 - 0.124738623002510*G0_2_1 - 0.124738623002511*G0_2_2;
    A[1596] = 0.647179466623906*G0_0_0 + 0.271397840842283*G0_0_1 + 0.271397840842283*G0_0_2 + 0.271397840842283*G0_1_0 + 0.542795681684566*G0_1_1 + 0.271397840842283*G0_1_2 + 0.271397840842283*G0_2_0 + 0.271397840842283*G0_2_1 + 0.542795681684566*G0_2_2;
    A[1597] = -0.268135847562929*G0_0_0 + 0.180714427676232*G0_0_1 + 0.022507753627545*G0_0_2 - 0.073721048113409*G0_1_0 - 0.209419968534551*G0_1_1 - 0.104709984267275*G0_1_2 - 0.045994105238896*G0_2_0 + 0.081223632655922*G0_2_1 - 0.023486351611352*G0_2_2;
    A[1598] = 0.105688582251081*G0_0_0 - 0.074373446769280*G0_0_1 + 0.000652398655871*G0_0_2 + 0.030010338170060*G0_1_0 + 0.105688582251081*G0_1_1 + 0.052844291125540*G0_1_2 + 0.052844291125540*G0_2_0 + 0.000652398655872*G0_2_1 + 0.053496689781411*G0_2_2;
    A[1599] = -0.268135847562928*G0_0_0 + 0.022507753627546*G0_0_1 + 0.180714427676233*G0_0_2 - 0.045994105238897*G0_1_0 - 0.023486351611351*G0_1_1 + 0.081223632655923*G0_1_2 - 0.073721048113410*G0_2_0 - 0.104709984267275*G0_2_1 - 0.209419968534550*G0_2_2;
    A[1600] = 0.113517366121532*G0_0_0 - 0.085138024591149*G0_0_1 - 0.085138024591149*G0_0_2 + 0.012721773789483*G0_1_0 - 0.013700371773288*G0_1_1 - 0.019898159004061*G0_1_2 + 0.012721773789483*G0_2_0 - 0.019898159004062*G0_2_1 - 0.013700371773287*G0_2_2;
    A[1601] = 0.105688582251081*G0_0_0 + 0.000652398655871*G0_0_1 - 0.074373446769280*G0_0_2 + 0.052844291125540*G0_1_0 + 0.053496689781411*G0_1_1 + 0.000652398655871*G0_1_2 + 0.030010338170060*G0_2_0 + 0.052844291125540*G0_2_1 + 0.105688582251080*G0_2_2;
    A[1602] = -0.060020676340121*G0_0_0 - 0.030010338170060*G0_0_1 - 0.030010338170060*G0_0_2 - 0.030010338170060*G0_1_0 - 0.015005169085030*G0_1_2 - 0.030010338170060*G0_2_0 - 0.015005169085030*G0_2_1;
    A[1603] = -0.025443547578964*G0_0_0 - 0.001304797311741*G0_0_1 - 0.012721773789483*G0_0_2 - 0.001304797311742*G0_1_0 - 0.000652398655872*G0_1_2 - 0.012721773789482*G0_2_0 - 0.000652398655871*G0_2_1;
    A[1604] = -0.105688582251081*G0_0_0 - 0.030010338170061*G0_0_1 - 0.052844291125541*G0_0_2 - 0.030010338170060*G0_1_0 - 0.015005169085030*G0_1_2 - 0.052844291125540*G0_2_0 - 0.015005169085029*G0_2_1;
    A[1605] = -0.025443547578964*G0_0_0 - 0.012721773789483*G0_0_1 - 0.001304797311741*G0_0_2 - 0.012721773789482*G0_1_0 - 0.000652398655871*G0_1_2 - 0.001304797311742*G0_2_0 - 0.000652398655871*G0_2_1;
    A[1606] = -0.113517366121532*G0_0_0 - 0.012721773789482*G0_0_1 - 0.012721773789482*G0_0_2 - 0.012721773789483*G0_1_0 - 0.000652398655871*G0_1_2 - 0.012721773789483*G0_2_0 - 0.000652398655871*G0_2_1;
    A[1607] = -0.105688582251081*G0_0_0 - 0.052844291125540*G0_0_1 - 0.030010338170060*G0_0_2 - 0.052844291125541*G0_1_0 - 0.015005169085030*G0_1_2 - 0.030010338170060*G0_2_0 - 0.015005169085030*G0_2_1;
    A[1608] = -0.045667905910961*G0_0_0 - 0.075678244081022*G0_0_1 - 0.037839122040511*G0_0_2 - 0.075678244081021*G0_1_0 - 0.105688582251082*G0_1_1 - 0.052844291125541*G0_1_2 - 0.037839122040510*G0_2_0 - 0.052844291125541*G0_2_1;
    A[1609] = 0.039143919352253*G0_0_0 + 0.135698920421142*G0_0_1 + 0.067849460210570*G0_0_2 + 0.135698920421141*G0_1_0 + 0.209419968534549*G0_1_1 + 0.104709984267275*G0_1_2 + 0.067849460210570*G0_2_0 + 0.104709984267274*G0_2_1;
    A[1610] = 0.052191892469670*G0_0_0 - 0.271397840842283*G0_0_1 - 0.135698920421142*G0_0_2 - 0.271397840842283*G0_1_0 - 0.542795681684566*G0_1_1 - 0.271397840842283*G0_1_2 - 0.135698920421141*G0_2_0 - 0.271397840842283*G0_2_1;
    A[1611] = 0.039143919352252*G0_0_0 + 0.026422145562770*G0_0_1 - 0.005545388574902*G0_0_2 + 0.026422145562770*G0_1_0 + 0.013700371773288*G0_1_1 - 0.006197787230773*G0_1_2 - 0.005545388574903*G0_2_0 - 0.006197787230774*G0_2_1;
    A[1612] = -0.156575677409009*G0_0_0 - 0.022507753627545*G0_0_1 + 0.067849460210571*G0_0_2 - 0.022507753627545*G0_1_0 + 0.023486351611351*G0_1_1 + 0.104709984267275*G0_1_2 + 0.067849460210570*G0_2_0 + 0.104709984267276*G0_2_1;
    A[1613] = 0.052191892469670*G0_0_0 - 0.000652398655871*G0_0_1 - 0.037839122040511*G0_0_2 - 0.000652398655871*G0_1_0 - 0.053496689781412*G0_1_1 - 0.052844291125541*G0_1_2 - 0.037839122040510*G0_2_0 - 0.052844291125540*G0_2_1;
    A[1614] = -0.045667905910961*G0_0_0 - 0.037839122040510*G0_0_1 - 0.075678244081021*G0_0_2 - 0.037839122040510*G0_1_0 - 0.052844291125540*G0_1_2 - 0.075678244081021*G0_2_0 - 0.052844291125540*G0_2_1 - 0.105688582251081*G0_2_2;
    A[1615] = 0.039143919352253*G0_0_0 + 0.067849460210570*G0_0_1 + 0.135698920421142*G0_0_2 + 0.067849460210571*G0_1_0 + 0.104709984267275*G0_1_2 + 0.135698920421141*G0_2_0 + 0.104709984267274*G0_2_1 + 0.209419968534549*G0_2_2;
    A[1616] = 0.052191892469670*G0_0_0 - 0.135698920421141*G0_0_1 - 0.271397840842282*G0_0_2 - 0.135698920421142*G0_1_0 - 0.271397840842283*G0_1_2 - 0.271397840842282*G0_2_0 - 0.271397840842282*G0_2_1 - 0.542795681684565*G0_2_2;
    A[1617] = 0.039143919352252*G0_0_0 - 0.005545388574902*G0_0_1 + 0.026422145562771*G0_0_2 - 0.005545388574903*G0_1_0 - 0.006197787230774*G0_1_2 + 0.026422145562770*G0_2_0 - 0.006197787230774*G0_2_1 + 0.013700371773288*G0_2_2;
    A[1618] = -0.156575677409009*G0_0_0 + 0.067849460210571*G0_0_1 - 0.022507753627545*G0_0_2 + 0.067849460210571*G0_1_0 + 0.104709984267275*G0_1_2 - 0.022507753627545*G0_2_0 + 0.104709984267275*G0_2_1 + 0.023486351611351*G0_2_2;
    A[1619] = 0.052191892469669*G0_0_0 - 0.037839122040511*G0_0_1 - 0.000652398655870*G0_0_2 - 0.037839122040511*G0_1_0 - 0.052844291125540*G0_1_2 - 0.000652398655871*G0_2_0 - 0.052844291125540*G0_2_1 - 0.053496689781411*G0_2_2;
    A[1620] = 0.195719596761263*G0_0_0 + 0.075025845425150*G0_0_1 + 0.075025845425149*G0_0_2 + 0.075025845425150*G0_1_0 + 0.026095946234834*G0_1_2 + 0.075025845425150*G0_2_0 + 0.026095946234835*G0_2_1;
    A[1621] = -0.782878387045048*G0_0_0 - 0.316413348097374*G0_0_1 - 0.316413348097374*G0_0_2 - 0.316413348097373*G0_1_0 - 0.185933616923199*G0_1_2 - 0.316413348097373*G0_2_0 - 0.185933616923197*G0_2_1;
    A[1622] = 0.293579395141892*G0_0_0 + 0.075025845425151*G0_0_1 + 0.058715879028378*G0_0_2 + 0.075025845425151*G0_1_0 + 0.026095946234835*G0_1_2 + 0.058715879028378*G0_2_0 + 0.026095946234834*G0_2_1;
    A[1623] = 0.293579395141893*G0_0_0 + 0.058715879028379*G0_0_1 + 0.075025845425152*G0_0_2 + 0.058715879028379*G0_1_0 + 0.026095946234836*G0_1_2 + 0.075025845425152*G0_2_0 + 0.026095946234835*G0_2_1;
    A[1624] = -0.009464999699375*G0_0_0 - 0.009464999699375*G0_0_1 - 0.009464999699375*G0_0_2 - 0.009464999699375*G0_1_0 - 0.009464999699374*G0_1_1 - 0.009464999699375*G0_1_2 - 0.009464999699375*G0_2_0 - 0.009464999699375*G0_2_1 - 0.009464999699375*G0_2_2;
    A[1625] = -0.034571909571909*G0_0_0 - 0.004724671065817*G0_1_0 - 0.004724671065817*G0_2_0;
    A[1626] = -0.004724671065817*G0_0_1 - 0.034571909571909*G0_1_1 - 0.004724671065817*G0_2_1;
    A[1627] = -0.002278176106301*G0_0_2 - 0.002278176106301*G0_1_2 + 0.009464999699375*G0_2_2;
    A[1628] = -0.084550865800865*G0_0_1 - 0.042960451489097*G0_0_2 + 0.043971669405697*G0_1_1 - 0.000685018588664*G0_1_2 - 0.042275432900432*G0_2_1 - 0.042960451489096*G0_2_2;
    A[1629] = -0.080832193462401*G0_0_1 - 0.108232937008978*G0_0_2 - 0.043645470077761*G0_1_1 - 0.033892110172492*G0_1_2 - 0.006491366625915*G0_2_1 - 0.003522952741703*G0_2_2;
    A[1630] = -0.009394540644540*G0_0_1 - 0.037773882174924*G0_0_2 - 0.015592327875314*G0_1_1 - 0.018886941087462*G0_1_2 + 0.009492400442921*G0_2_1 + 0.018984800885842*G0_2_2;
    A[1631] = 0.002544354757896*G0_0_1 + 0.014287530563572*G0_0_2 + 0.002544354757897*G0_1_1 + 0.008448562593528*G0_1_2 - 0.003294613212148*G0_2_1 - 0.029260079715808*G0_2_2;
    A[1632] = 0.043971669405697*G0_0_0 - 0.000685018588665*G0_0_2 - 0.084550865800865*G0_1_0 - 0.042960451489097*G0_1_2 - 0.042275432900433*G0_2_0 - 0.042960451489097*G0_2_2;
    A[1633] = -0.043645470077762*G0_0_0 - 0.033892110172492*G0_0_2 - 0.080832193462401*G0_1_0 - 0.108232937008978*G0_1_2 - 0.006491366625915*G0_2_0 - 0.003522952741703*G0_2_2;
    A[1634] = -0.015592327875314*G0_0_0 - 0.018886941087462*G0_0_2 - 0.009394540644541*G0_1_0 - 0.037773882174924*G0_1_2 + 0.009492400442921*G0_2_0 + 0.018984800885842*G0_2_2;
    A[1635] = 0.002544354757896*G0_0_0 + 0.008448562593528*G0_0_2 + 0.002544354757897*G0_1_0 + 0.014287530563573*G0_1_2 - 0.003294613212148*G0_2_0 - 0.029260079715808*G0_2_2;
    A[1636] = 0.127315597693201*G0_0_0 - 0.000685018588664*G0_0_1 - 0.007045905483406*G0_1_0 - 0.042960451489097*G0_1_1 - 0.049321338383838*G0_2_0 - 0.042960451489097*G0_2_1;
    A[1637] = -0.166948816037356*G0_0_0 - 0.006165167297979*G0_0_1 + 0.083865847212200*G0_1_0 + 0.182410664181495*G0_1_1 + 0.167731694424401*G0_2_0 + 0.077700679914221*G0_2_1;
    A[1638] = 0.182410664181495*G0_0_0 + 0.083865847212200*G0_0_1 - 0.006165167297980*G0_1_0 - 0.166948816037357*G0_1_1 + 0.077700679914220*G0_2_0 + 0.167731694424400*G0_2_1;
    A[1639] = -0.042960451489097*G0_0_0 - 0.007045905483405*G0_0_1 - 0.000685018588664*G0_1_0 + 0.127315597693201*G0_1_1 - 0.042960451489096*G0_2_0 - 0.049321338383837*G0_2_1;
    A[1640] = 0.006589226424296*G0_0_0 + 0.006589226424296*G0_0_1 + 0.003294613212148*G0_0_2 + 0.006589226424296*G0_1_0 + 0.006589226424296*G0_1_1 + 0.003294613212148*G0_1_2 + 0.003294613212148*G0_2_0 + 0.003294613212148*G0_2_1;
    A[1641] = 0.004501550725509*G0_0_0 + 0.004501550725509*G0_0_1 + 0.002576974690690*G0_0_2 + 0.004501550725509*G0_1_0 + 0.004501550725509*G0_1_1 + 0.002576974690690*G0_1_2 + 0.002576974690690*G0_2_0 + 0.002576974690690*G0_2_1;
    A[1642] = -0.010503618359521*G0_0_0 - 0.010503618359521*G0_0_1 + 0.002576974690690*G0_0_2 - 0.010503618359521*G0_1_0 - 0.010503618359521*G0_1_1 + 0.002576974690690*G0_1_2 + 0.002576974690690*G0_2_0 + 0.002576974690690*G0_2_1;
    A[1643] = -0.002544354757896*G0_0_0 - 0.002544354757896*G0_0_1 + 0.003294613212148*G0_0_2 - 0.002544354757897*G0_1_0 - 0.002544354757897*G0_1_1 + 0.003294613212148*G0_1_2 + 0.003294613212148*G0_2_0 + 0.003294613212148*G0_2_1;
    A[1644] = 0.029260079715808*G0_0_0 + 0.025965466503661*G0_0_1 + 0.029260079715808*G0_0_2 + 0.025965466503661*G0_1_0 + 0.022670853291512*G0_1_1 + 0.025965466503661*G0_1_2 + 0.029260079715809*G0_2_0 + 0.025965466503661*G0_2_1 + 0.029260079715809*G0_2_2;
    A[1645] = -0.018984800885842*G0_0_0 - 0.009492400442921*G0_0_1 - 0.018984800885842*G0_0_2 - 0.009492400442921*G0_1_0 - 0.000652398655870*G0_1_1 - 0.009492400442921*G0_1_2 - 0.018984800885843*G0_2_0 - 0.009492400442921*G0_2_1 - 0.018984800885843*G0_2_2;
    A[1646] = 0.003522952741702*G0_0_0 - 0.002968413884212*G0_0_1 + 0.003522952741703*G0_0_2 - 0.002968413884212*G0_1_0 - 0.000652398655871*G0_1_1 - 0.002968413884212*G0_1_2 + 0.003522952741703*G0_2_0 - 0.002968413884212*G0_2_1 + 0.003522952741703*G0_2_2;
    A[1647] = 0.042960451489097*G0_0_0 + 0.000685018588664*G0_0_1 + 0.042960451489097*G0_0_2 + 0.000685018588664*G0_1_0 + 0.022670853291513*G0_1_1 + 0.000685018588664*G0_1_2 + 0.042960451489096*G0_2_0 + 0.000685018588664*G0_2_1 + 0.042960451489096*G0_2_2;
    A[1648] = 0.022670853291513*G0_0_0 + 0.025965466503660*G0_0_1 + 0.025965466503660*G0_0_2 + 0.025965466503660*G0_1_0 + 0.029260079715809*G0_1_1 + 0.029260079715809*G0_1_2 + 0.025965466503661*G0_2_0 + 0.029260079715809*G0_2_1 + 0.029260079715808*G0_2_2;
    A[1649] = -0.000652398655871*G0_0_0 - 0.009492400442921*G0_0_1 - 0.009492400442921*G0_0_2 - 0.009492400442921*G0_1_0 - 0.018984800885842*G0_1_1 - 0.018984800885842*G0_1_2 - 0.009492400442921*G0_2_0 - 0.018984800885842*G0_2_1 - 0.018984800885842*G0_2_2;
    A[1650] = -0.000652398655871*G0_0_0 - 0.002968413884213*G0_0_1 - 0.002968413884212*G0_0_2 - 0.002968413884212*G0_1_0 + 0.003522952741703*G0_1_1 + 0.003522952741703*G0_1_2 - 0.002968413884213*G0_2_0 + 0.003522952741702*G0_2_1 + 0.003522952741702*G0_2_2;
    A[1651] = 0.022670853291513*G0_0_0 + 0.000685018588665*G0_0_1 + 0.000685018588665*G0_0_2 + 0.000685018588664*G0_1_0 + 0.042960451489097*G0_1_1 + 0.042960451489097*G0_1_2 + 0.000685018588664*G0_2_0 + 0.042960451489097*G0_2_1 + 0.042960451489097*G0_2_2;
    A[1652] = -0.268135847562929*G0_0_0 - 0.073721048113409*G0_0_1 - 0.045994105238896*G0_0_2 + 0.180714427676232*G0_1_0 - 0.209419968534551*G0_1_1 + 0.081223632655922*G0_1_2 + 0.022507753627545*G0_2_0 - 0.104709984267275*G0_2_1 - 0.023486351611352*G0_2_2;
    A[1653] = 0.726119703984281*G0_0_0 + 0.270093043530542*G0_0_1 + 0.270093043530541*G0_0_2 + 0.270093043530542*G0_1_0 + 0.726119703984281*G0_1_1 + 0.270093043530541*G0_1_2 + 0.270093043530541*G0_2_0 + 0.270093043530541*G0_2_1 + 0.540186087061081*G0_2_2;
    A[1654] = -0.209419968534549*G0_0_0 + 0.180714427676232*G0_0_1 + 0.081223632655923*G0_0_2 - 0.073721048113408*G0_1_0 - 0.268135847562927*G0_1_1 - 0.045994105238896*G0_1_2 - 0.104709984267274*G0_2_0 + 0.022507753627546*G0_2_1 - 0.023486351611351*G0_2_2;
    A[1655] = 0.065566064915022*G0_0_0 - 0.074862745761183*G0_0_1 + 0.027890042538479*G0_0_2 + 0.027890042538480*G0_1_0 - 0.149725491522365*G0_1_1 + 0.177126235068944*G0_1_2 - 0.074862745761182*G0_2_0 - 0.028379341530383*G0_2_1 - 0.149725491522365*G0_2_2;
    A[1656] = -0.149725491522365*G0_0_0 + 0.027890042538480*G0_0_1 + 0.177126235068943*G0_0_2 - 0.074862745761183*G0_1_0 + 0.065566064915022*G0_1_1 + 0.027890042538481*G0_1_2 - 0.028379341530383*G0_2_0 - 0.074862745761182*G0_2_1 - 0.149725491522364*G0_2_2;
    A[1657] = -0.013700371773288*G0_0_0 - 0.019898159004062*G0_0_1 - 0.085138024591149*G0_0_2 - 0.019898159004061*G0_1_0 - 0.013700371773288*G0_1_1 - 0.085138024591150*G0_1_2 + 0.012721773789482*G0_2_0 + 0.012721773789482*G0_2_1 + 0.113517366121531*G0_2_2;
    A[1658] = -0.025443547578964*G0_0_0 - 0.024138750267222*G0_0_1 - 0.012721773789482*G0_0_2 - 0.024138750267222*G0_1_0 - 0.022833952955481*G0_1_1 - 0.012069375133611*G0_1_2 - 0.012721773789482*G0_2_0 - 0.012069375133611*G0_2_1;
    A[1659] = 0.056758683060766*G0_0_0 + 0.028379341530382*G0_0_1 + 0.028379341530383*G0_0_2 + 0.028379341530384*G0_1_0 - 0.004892989919031*G0_1_1 + 0.014189670765192*G0_1_2 + 0.028379341530384*G0_2_0 + 0.014189670765192*G0_2_1;
    A[1660] = 0.209419968534550*G0_0_0 + 0.073721048113409*G0_0_1 + 0.104709984267274*G0_0_2 + 0.073721048113408*G0_1_0 - 0.022833952955481*G0_1_1 + 0.036860524056703*G0_1_2 + 0.104709984267274*G0_2_0 + 0.036860524056704*G0_2_1;
    A[1661] = -0.016636165724706*G0_0_0 + 0.001467896975710*G0_0_1 - 0.018104062700417*G0_0_2 + 0.001467896975710*G0_1_0 + 0.019571959676127*G0_1_1 - 0.010275278829966*G0_1_2 - 0.018104062700416*G0_2_0 - 0.010275278829966*G0_2_1;
    A[1662] = 0.149725491522365*G0_0_0 + 0.074862745761182*G0_0_1 + 0.028379341530383*G0_0_2 + 0.074862745761183*G0_1_0 + 0.019571959676126*G0_1_1 + 0.014189670765192*G0_1_2 + 0.028379341530383*G0_2_0 + 0.014189670765191*G0_2_1;
    A[1663] = 0.013700371773288*G0_0_0 + 0.019898159004061*G0_0_1 - 0.012721773789482*G0_0_2 + 0.019898159004061*G0_1_0 + 0.026095946234835*G0_1_1 - 0.012069375133612*G0_1_2 - 0.012721773789482*G0_2_0 - 0.012069375133611*G0_2_1;
    A[1664] = -0.022833952955480*G0_0_0 - 0.024138750267222*G0_0_1 - 0.012069375133611*G0_0_2 - 0.024138750267222*G0_1_0 - 0.025443547578963*G0_1_1 - 0.012721773789482*G0_1_2 - 0.012069375133611*G0_2_0 - 0.012721773789482*G0_2_1;
    A[1665] = -0.004892989919032*G0_0_0 + 0.028379341530382*G0_0_1 + 0.014189670765191*G0_0_2 + 0.028379341530382*G0_1_0 + 0.056758683060766*G0_1_1 + 0.028379341530383*G0_1_2 + 0.014189670765191*G0_2_0 + 0.028379341530382*G0_2_1;
    A[1666] = -0.022833952955480*G0_0_0 + 0.073721048113409*G0_0_1 + 0.036860524056704*G0_0_2 + 0.073721048113409*G0_1_0 + 0.209419968534550*G0_1_1 + 0.104709984267274*G0_1_2 + 0.036860524056705*G0_2_0 + 0.104709984267275*G0_2_1;
    A[1667] = 0.019571959676126*G0_0_0 + 0.001467896975710*G0_0_1 - 0.010275278829966*G0_0_2 + 0.001467896975710*G0_1_0 - 0.016636165724707*G0_1_1 - 0.018104062700417*G0_1_2 - 0.010275278829966*G0_2_0 - 0.018104062700416*G0_2_1;
    A[1668] = 0.019571959676126*G0_0_0 + 0.074862745761183*G0_0_1 + 0.014189670765191*G0_0_2 + 0.074862745761182*G0_1_0 + 0.149725491522365*G0_1_1 + 0.028379341530383*G0_1_2 + 0.014189670765191*G0_2_0 + 0.028379341530383*G0_2_1;
    A[1669] = 0.026095946234835*G0_0_0 + 0.019898159004062*G0_0_1 - 0.012069375133611*G0_0_2 + 0.019898159004062*G0_1_0 + 0.013700371773288*G0_1_1 - 0.012721773789482*G0_1_2 - 0.012069375133611*G0_2_0 - 0.012721773789482*G0_2_1;
    A[1670] = -0.088073818542567*G0_0_0 - 0.088726217198438*G0_0_1 - 0.100795592332049*G0_0_2 - 0.088726217198438*G0_1_0 - 0.088073818542568*G0_1_1 - 0.100795592332049*G0_1_2 - 0.100795592332049*G0_2_0 - 0.100795592332049*G0_2_1 - 0.113517366121531*G0_2_2;
    A[1671] = 0.019571959676126*G0_0_0 + 0.060673074995991*G0_0_1 + 0.074862745761182*G0_0_2 + 0.060673074995990*G0_1_0 + 0.092966808461598*G0_1_1 + 0.121346149991981*G0_1_2 + 0.074862745761181*G0_2_0 + 0.121346149991981*G0_2_1 + 0.149725491522364*G0_2_2;
    A[1672] = -0.088073818542568*G0_0_0 + 0.009133581182192*G0_0_1 + 0.045994105238896*G0_0_2 + 0.009133581182193*G0_1_0 - 0.185933616923198*G0_1_1 - 0.081223632655922*G0_1_2 + 0.045994105238897*G0_2_0 - 0.081223632655923*G0_2_1 + 0.023486351611352*G0_2_2;
    A[1673] = 0.092966808461598*G0_0_0 + 0.060673074995990*G0_0_1 + 0.121346149991981*G0_0_2 + 0.060673074995991*G0_1_0 + 0.019571959676127*G0_1_1 + 0.074862745761183*G0_1_2 + 0.121346149991982*G0_2_0 + 0.074862745761183*G0_2_1 + 0.149725491522365*G0_2_2;
    A[1674] = 0.092966808461600*G0_0_0 - 0.135046521765270*G0_0_1 - 0.270093043530541*G0_0_2 - 0.135046521765270*G0_1_0 + 0.092966808461601*G0_1_1 - 0.270093043530541*G0_1_2 - 0.270093043530540*G0_2_0 - 0.270093043530539*G0_2_1 - 0.540186087061081*G0_2_2;
    A[1675] = -0.185933616923198*G0_0_0 + 0.009133581182193*G0_0_1 - 0.081223632655923*G0_0_2 + 0.009133581182192*G0_1_0 - 0.088073818542568*G0_1_1 + 0.045994105238897*G0_1_2 - 0.081223632655923*G0_2_0 + 0.045994105238896*G0_2_1 + 0.023486351611351*G0_2_2;
    A[1676] = 0.146789697570944*G0_0_0 + 0.141896707651915*G0_0_1 + 0.092966808461599*G0_0_2 + 0.141896707651914*G0_1_0 + 0.146789697570945*G0_1_1 + 0.092966808461599*G0_1_2 + 0.092966808461599*G0_2_0 + 0.092966808461599*G0_2_1;
    A[1677] = 0.146789697570948*G0_0_0 - 0.298472385060924*G0_0_1 - 0.102752788299662*G0_0_2 - 0.298472385060923*G0_1_0 - 0.782878387045046*G0_1_1 - 0.298472385060924*G0_1_2 - 0.102752788299661*G0_2_0 - 0.298472385060924*G0_2_1;
    A[1678] = -0.782878387045048*G0_0_0 - 0.298472385060925*G0_0_1 - 0.298472385060925*G0_0_2 - 0.298472385060925*G0_1_0 + 0.146789697570946*G0_1_1 - 0.102752788299664*G0_1_2 - 0.298472385060925*G0_2_0 - 0.102752788299663*G0_2_1;
    A[1679] = -0.048929899190316*G0_0_0 - 0.029357939514190*G0_0_1 + 0.092966808461599*G0_0_2 - 0.029357939514190*G0_1_0 - 0.048929899190315*G0_1_1 + 0.092966808461599*G0_1_2 + 0.092966808461598*G0_2_0 + 0.092966808461598*G0_2_1;
    A[1680] = -0.013742125287264*G0_0_0 - 0.013742125287264*G0_0_1 - 0.013742125287264*G0_0_2 - 0.013742125287264*G0_1_0 - 0.013742125287264*G0_1_1 - 0.013742125287264*G0_1_2 - 0.013742125287264*G0_2_0 - 0.013742125287264*G0_2_1 - 0.013742125287264*G0_2_2;
    A[1681] = 0.013742125287264*G0_0_0 - 0.005177435732991*G0_1_0 - 0.005177435732991*G0_2_0;
    A[1682] = 0.014394523943135*G0_0_1 + 0.047993054720485*G0_1_1 + 0.014394523943135*G0_2_1;
    A[1683] = -0.005177435732991*G0_0_2 - 0.005177435732991*G0_1_2 + 0.013742125287264*G0_2_2;
    A[1684] = 0.192588083213082*G0_0_1 + 0.124738623002511*G0_0_2 - 0.064456987200042*G0_1_1 + 0.028444581395970*G0_1_2 + 0.096294041606541*G0_2_1 + 0.124738623002511*G0_2_2;
    A[1685] = 0.010960297418630*G0_0_1 + 0.146659217839771*G0_0_2 + 0.132306447410613*G0_1_1 + 0.073329608919886*G0_1_2 - 0.062369311501255*G0_2_1 - 0.124738623002511*G0_2_2;
    A[1686] = 0.001826716236439*G0_0_1 - 0.082332710370904*G0_0_2 - 0.051017574889102*G0_1_1 - 0.046385544432419*G0_1_2 + 0.037773882174923*G0_2_1 + 0.127087258163646*G0_2_2;
    A[1687] = 0.011873655536850*G0_0_1 + 0.047755581609748*G0_0_2 + 0.011873655536850*G0_1_1 + 0.026487385428357*G0_1_2 - 0.009394540644540*G0_2_1 - 0.064130787872107*G0_2_2;
    A[1688] = -0.018789081289081*G0_0_0 - 0.009394540644541*G0_0_2 + 0.042536392362781*G0_1_0 + 0.011873655536850*G0_1_2 + 0.021268196181390*G0_2_0 + 0.011873655536850*G0_2_2;
    A[1689] = 0.014874689353856*G0_0_0 + 0.014939929219443*G0_0_2 + 0.040318236932819*G0_1_0 + 0.054018608706108*G0_1_2 + 0.001239557446155*G0_2_0 + 0.001174317580568*G0_2_2;
    A[1690] = 0.001174317580568*G0_0_0 + 0.001239557446155*G0_0_2 + 0.054018608706109*G0_1_0 + 0.040318236932820*G0_1_2 + 0.014939929219443*G0_2_0 + 0.014874689353856*G0_2_2;
    A[1691] = 0.011873655536850*G0_0_0 + 0.021268196181390*G0_0_2 + 0.011873655536850*G0_1_0 + 0.042536392362781*G0_1_2 - 0.009394540644540*G0_2_0 - 0.018789081289081*G0_2_2;
    A[1692] = -0.064130787872107*G0_0_0 - 0.009394540644541*G0_0_1 + 0.026487385428358*G0_1_0 + 0.011873655536850*G0_1_1 + 0.047755581609747*G0_2_0 + 0.011873655536850*G0_2_1;
    A[1693] = 0.127087258163646*G0_0_0 + 0.037773882174924*G0_0_1 - 0.046385544432419*G0_1_0 - 0.051017574889102*G0_1_1 - 0.082332710370903*G0_2_0 + 0.001826716236439*G0_2_1;
    A[1694] = -0.124738623002511*G0_0_0 - 0.062369311501255*G0_0_1 + 0.073329608919886*G0_1_0 + 0.132306447410613*G0_1_1 + 0.146659217839771*G0_2_0 + 0.010960297418631*G0_2_1;
    A[1695] = 0.124738623002511*G0_0_0 + 0.096294041606541*G0_0_1 + 0.028444581395970*G0_1_0 - 0.064456987200042*G0_1_1 + 0.124738623002511*G0_2_0 + 0.192588083213081*G0_2_1;
    A[1696] = 0.018789081289081*G0_0_0 + 0.018789081289081*G0_0_1 + 0.009394540644541*G0_0_2 + 0.018789081289081*G0_1_0 + 0.018789081289081*G0_1_1 + 0.009394540644540*G0_1_2 + 0.009394540644541*G0_2_0 + 0.009394540644541*G0_2_1;
    A[1697] = -0.014874689353856*G0_0_0 - 0.014874689353856*G0_0_1 + 0.000065239865587*G0_0_2 - 0.014874689353856*G0_1_0 - 0.014874689353856*G0_1_1 + 0.000065239865588*G0_1_2 + 0.000065239865587*G0_2_0 + 0.000065239865587*G0_2_1;
    A[1698] = -0.001174317580568*G0_0_0 - 0.001174317580568*G0_0_1 + 0.000065239865587*G0_0_2 - 0.001174317580568*G0_1_0 - 0.001174317580568*G0_1_1 + 0.000065239865587*G0_1_2 + 0.000065239865587*G0_2_0 + 0.000065239865587*G0_2_1;
    A[1699] = -0.011873655536850*G0_0_0 - 0.011873655536850*G0_0_1 + 0.009394540644541*G0_0_2 - 0.011873655536850*G0_1_0 - 0.011873655536850*G0_1_1 + 0.009394540644541*G0_1_2 + 0.009394540644540*G0_2_0 + 0.009394540644540*G0_2_1;
    A[1700] = 0.064130787872107*G0_0_0 + 0.054736247227566*G0_0_1 + 0.064130787872107*G0_0_2 + 0.054736247227566*G0_1_0 + 0.045341706583025*G0_1_1 + 0.054736247227566*G0_1_2 + 0.064130787872106*G0_2_0 + 0.054736247227566*G0_2_1 + 0.064130787872107*G0_2_2;
    A[1701] = -0.127087258163646*G0_0_0 - 0.089313375988722*G0_0_1 - 0.127087258163646*G0_0_2 - 0.089313375988722*G0_1_0 - 0.066544662898829*G0_1_1 - 0.089313375988722*G0_1_2 - 0.127087258163645*G0_2_0 - 0.089313375988722*G0_2_1 - 0.127087258163646*G0_2_2;
    A[1702] = 0.124738623002511*G0_0_0 + 0.062369311501255*G0_0_1 + 0.124738623002511*G0_0_2 + 0.062369311501255*G0_1_0 + 0.047625101878574*G0_1_1 + 0.062369311501255*G0_1_2 + 0.124738623002511*G0_2_0 + 0.062369311501255*G0_2_1 + 0.124738623002511*G0_2_2;
    A[1703] = -0.124738623002511*G0_0_0 - 0.028444581395970*G0_0_1 - 0.124738623002511*G0_0_2 - 0.028444581395970*G0_1_0 - 0.060673074995991*G0_1_1 - 0.028444581395970*G0_1_2 - 0.124738623002511*G0_2_0 - 0.028444581395970*G0_2_1 - 0.124738623002511*G0_2_2;
    A[1704] = 0.009394540644541*G0_0_1 + 0.009394540644541*G0_0_2 + 0.009394540644540*G0_1_0 + 0.018789081289081*G0_1_1 + 0.018789081289081*G0_1_2 + 0.009394540644540*G0_2_0 + 0.018789081289081*G0_2_1 + 0.018789081289081*G0_2_2;
    A[1705] = 0.000065239865587*G0_0_1 + 0.000065239865587*G0_0_2 + 0.000065239865587*G0_1_0 - 0.014874689353856*G0_1_1 - 0.014874689353856*G0_1_2 + 0.000065239865587*G0_2_0 - 0.014874689353856*G0_2_1 - 0.014874689353856*G0_2_2;
    A[1706] = 0.000065239865587*G0_0_1 + 0.000065239865587*G0_0_2 + 0.000065239865587*G0_1_0 - 0.001174317580568*G0_1_1 - 0.001174317580568*G0_1_2 + 0.000065239865587*G0_2_0 - 0.001174317580567*G0_2_1 - 0.001174317580567*G0_2_2;
    A[1707] = 0.009394540644540*G0_0_1 + 0.009394540644540*G0_0_2 + 0.009394540644541*G0_1_0 - 0.011873655536850*G0_1_1 - 0.011873655536850*G0_1_2 + 0.009394540644540*G0_2_0 - 0.011873655536850*G0_2_1 - 0.011873655536850*G0_2_2;
    A[1708] = 0.105688582251081*G0_0_0 + 0.030010338170060*G0_0_1 + 0.052844291125540*G0_0_2 - 0.074373446769280*G0_1_0 + 0.105688582251081*G0_1_1 + 0.000652398655872*G0_1_2 + 0.000652398655871*G0_2_0 + 0.052844291125540*G0_2_1 + 0.053496689781411*G0_2_2;
    A[1709] = -0.209419968534549*G0_0_0 - 0.073721048113408*G0_0_1 - 0.104709984267274*G0_0_2 + 0.180714427676232*G0_1_0 - 0.268135847562927*G0_1_1 + 0.022507753627546*G0_1_2 + 0.081223632655923*G0_2_0 - 0.045994105238896*G0_2_1 - 0.023486351611351*G0_2_2;
    A[1710] = 0.542795681684566*G0_0_0 + 0.271397840842282*G0_0_1 + 0.271397840842283*G0_0_2 + 0.271397840842282*G0_1_0 + 0.647179466623904*G0_1_1 + 0.271397840842282*G0_1_2 + 0.271397840842283*G0_2_0 + 0.271397840842282*G0_2_1 + 0.542795681684564*G0_2_2;
    A[1711] = -0.013700371773288*G0_0_0 + 0.012721773789482*G0_0_1 - 0.019898159004061*G0_0_2 - 0.085138024591149*G0_1_0 + 0.113517366121531*G0_1_1 - 0.085138024591150*G0_1_2 - 0.019898159004062*G0_2_0 + 0.012721773789482*G0_2_1 - 0.013700371773288*G0_2_2;
    A[1712] = -0.023486351611352*G0_0_0 - 0.045994105238896*G0_0_1 + 0.081223632655922*G0_0_2 + 0.022507753627545*G0_1_0 - 0.268135847562928*G0_1_1 + 0.180714427676231*G0_1_2 - 0.104709984267275*G0_2_0 - 0.073721048113409*G0_2_1 - 0.209419968534550*G0_2_2;
    A[1713] = 0.053496689781412*G0_0_0 + 0.052844291125541*G0_0_1 + 0.000652398655872*G0_0_2 + 0.000652398655870*G0_1_0 + 0.105688582251081*G0_1_1 - 0.074373446769279*G0_1_2 + 0.052844291125541*G0_2_0 + 0.030010338170060*G0_2_1 + 0.105688582251081*G0_2_2;
    A[1714] = -0.105688582251081*G0_0_0 - 0.075678244081021*G0_0_1 - 0.052844291125541*G0_0_2 - 0.075678244081021*G0_1_0 - 0.045667905910960*G0_1_1 - 0.037839122040511*G0_1_2 - 0.052844291125541*G0_2_0 - 0.037839122040511*G0_2_1;
    A[1715] = 0.209419968534549*G0_0_0 + 0.135698920421142*G0_0_1 + 0.104709984267274*G0_0_2 + 0.135698920421141*G0_1_0 + 0.039143919352252*G0_1_1 + 0.067849460210570*G0_1_2 + 0.104709984267275*G0_2_0 + 0.067849460210570*G0_2_1;
    A[1716] = -0.542795681684566*G0_0_0 - 0.271397840842283*G0_0_1 - 0.271397840842282*G0_0_2 - 0.271397840842282*G0_1_0 + 0.052191892469670*G0_1_1 - 0.135698920421141*G0_1_2 - 0.271397840842283*G0_2_0 - 0.135698920421141*G0_2_1;
    A[1717] = 0.013700371773288*G0_0_0 + 0.026422145562770*G0_0_1 - 0.006197787230773*G0_0_2 + 0.026422145562770*G0_1_0 + 0.039143919352253*G0_1_1 - 0.005545388574902*G0_1_2 - 0.006197787230773*G0_2_0 - 0.005545388574902*G0_2_1;
    A[1718] = 0.023486351611352*G0_0_0 - 0.022507753627544*G0_0_1 + 0.104709984267275*G0_0_2 - 0.022507753627545*G0_1_0 - 0.156575677409010*G0_1_1 + 0.067849460210570*G0_1_2 + 0.104709984267275*G0_2_0 + 0.067849460210570*G0_2_1;
    A[1719] = -0.053496689781412*G0_0_0 - 0.000652398655871*G0_0_1 - 0.052844291125541*G0_0_2 - 0.000652398655870*G0_1_0 + 0.052191892469670*G0_1_1 - 0.037839122040510*G0_1_2 - 0.052844291125541*G0_2_0 - 0.037839122040511*G0_2_1;
    A[1720] = -0.030010338170060*G0_0_1 - 0.015005169085030*G0_0_2 - 0.030010338170060*G0_1_0 - 0.060020676340120*G0_1_1 - 0.030010338170060*G0_1_2 - 0.015005169085030*G0_2_0 - 0.030010338170060*G0_2_1;
    A[1721] = -0.001304797311741*G0_0_1 - 0.000652398655871*G0_0_2 - 0.001304797311742*G0_1_0 - 0.025443547578964*G0_1_1 - 0.012721773789482*G0_1_2 - 0.000652398655870*G0_2_0 - 0.012721773789482*G0_2_1;
    A[1722] = -0.030010338170060*G0_0_1 - 0.015005169085030*G0_0_2 - 0.030010338170060*G0_1_0 - 0.105688582251082*G0_1_1 - 0.052844291125540*G0_1_2 - 0.015005169085030*G0_2_0 - 0.052844291125541*G0_2_1;
    A[1723] = -0.012721773789482*G0_0_1 - 0.000652398655871*G0_0_2 - 0.012721773789482*G0_1_0 - 0.025443547578964*G0_1_1 - 0.001304797311741*G0_1_2 - 0.000652398655871*G0_2_0 - 0.001304797311742*G0_2_1;
    A[1724] = -0.012721773789482*G0_0_1 - 0.000652398655871*G0_0_2 - 0.012721773789482*G0_1_0 - 0.113517366121531*G0_1_1 - 0.012721773789482*G0_1_2 - 0.000652398655871*G0_2_0 - 0.012721773789482*G0_2_1;
    A[1725] = -0.052844291125541*G0_0_1 - 0.015005169085030*G0_0_2 - 0.052844291125541*G0_1_0 - 0.105688582251081*G0_1_1 - 0.030010338170060*G0_1_2 - 0.015005169085030*G0_2_0 - 0.030010338170060*G0_2_1;
    A[1726] = -0.037839122040511*G0_0_1 - 0.052844291125540*G0_0_2 - 0.037839122040510*G0_1_0 - 0.045667905910961*G0_1_1 - 0.075678244081021*G0_1_2 - 0.052844291125540*G0_2_0 - 0.075678244081021*G0_2_1 - 0.105688582251081*G0_2_2;
    A[1727] = -0.005545388574903*G0_0_1 - 0.006197787230773*G0_0_2 - 0.005545388574902*G0_1_0 + 0.039143919352252*G0_1_1 + 0.026422145562771*G0_1_2 - 0.006197787230773*G0_2_0 + 0.026422145562770*G0_2_1 + 0.013700371773289*G0_2_2;
    A[1728] = -0.037839122040510*G0_0_1 - 0.052844291125540*G0_0_2 - 0.037839122040511*G0_1_0 + 0.052191892469670*G0_1_1 - 0.000652398655872*G0_1_2 - 0.052844291125541*G0_2_0 - 0.000652398655871*G0_2_1 - 0.053496689781411*G0_2_2;
    A[1729] = 0.067849460210571*G0_0_1 + 0.104709984267275*G0_0_2 + 0.067849460210570*G0_1_0 + 0.039143919352252*G0_1_1 + 0.135698920421141*G0_1_2 + 0.104709984267273*G0_2_0 + 0.135698920421141*G0_2_1 + 0.209419968534549*G0_2_2;
    A[1730] = 0.067849460210571*G0_0_1 + 0.104709984267275*G0_0_2 + 0.067849460210571*G0_1_0 - 0.156575677409009*G0_1_1 - 0.022507753627545*G0_1_2 + 0.104709984267275*G0_2_0 - 0.022507753627545*G0_2_1 + 0.023486351611351*G0_2_2;
    A[1731] = -0.135698920421142*G0_0_1 - 0.271397840842283*G0_0_2 - 0.135698920421141*G0_1_0 + 0.052191892469670*G0_1_1 - 0.271397840842282*G0_1_2 - 0.271397840842282*G0_2_0 - 0.271397840842282*G0_2_1 - 0.542795681684564*G0_2_2;
    A[1732] = 0.075025845425149*G0_0_1 + 0.026095946234834*G0_0_2 + 0.075025845425151*G0_1_0 + 0.195719596761263*G0_1_1 + 0.075025845425151*G0_1_2 + 0.026095946234835*G0_2_0 + 0.075025845425150*G0_2_1;
    A[1733] = 0.075025845425149*G0_0_1 + 0.026095946234835*G0_0_2 + 0.075025845425150*G0_1_0 + 0.293579395141892*G0_1_1 + 0.058715879028379*G0_1_2 + 0.026095946234835*G0_2_0 + 0.058715879028378*G0_2_1;
    A[1734] = -0.316413348097372*G0_0_1 - 0.185933616923198*G0_0_2 - 0.316413348097373*G0_1_0 - 0.782878387045047*G0_1_1 - 0.316413348097373*G0_1_2 - 0.185933616923198*G0_2_0 - 0.316413348097373*G0_2_1;
    A[1735] = 0.058715879028379*G0_0_1 + 0.026095946234835*G0_0_2 + 0.058715879028378*G0_1_0 + 0.293579395141893*G0_1_1 + 0.075025845425150*G0_1_2 + 0.026095946234835*G0_2_0 + 0.075025845425151*G0_2_1;
    A[1736] = -0.009464999699375*G0_0_0 - 0.009464999699375*G0_0_1 - 0.009464999699375*G0_0_2 - 0.009464999699375*G0_1_0 - 0.009464999699375*G0_1_1 - 0.009464999699375*G0_1_2 - 0.009464999699375*G0_2_0 - 0.009464999699375*G0_2_1 - 0.009464999699375*G0_2_2;
    A[1737] = -0.034571909571909*G0_0_0 - 0.004724671065817*G0_1_0 - 0.004724671065817*G0_2_0;
    A[1738] = -0.002278176106301*G0_0_1 + 0.009464999699375*G0_1_1 - 0.002278176106301*G0_2_1;
    A[1739] = -0.004724671065817*G0_0_2 - 0.004724671065817*G0_1_2 - 0.034571909571909*G0_2_2;
    A[1740] = 0.014287530563572*G0_0_1 + 0.002544354757896*G0_0_2 - 0.029260079715809*G0_1_1 - 0.003294613212148*G0_1_2 + 0.008448562593528*G0_2_1 + 0.002544354757896*G0_2_2;
    A[1741] = -0.037773882174923*G0_0_1 - 0.009394540644540*G0_0_2 + 0.018984800885842*G0_1_1 + 0.009492400442922*G0_1_2 - 0.018886941087461*G0_2_1 - 0.015592327875314*G0_2_2;
    A[1742] = -0.108232937008978*G0_0_1 - 0.080832193462401*G0_0_2 - 0.003522952741703*G0_1_1 - 0.006491366625915*G0_1_2 - 0.033892110172492*G0_2_1 - 0.043645470077761*G0_2_2;
    A[1743] = -0.042960451489097*G0_0_1 - 0.084550865800865*G0_0_2 - 0.042960451489097*G0_1_1 - 0.042275432900432*G0_1_2 - 0.000685018588664*G0_2_1 + 0.043971669405697*G0_2_2;
    A[1744] = 0.127315597693200*G0_0_0 - 0.000685018588665*G0_0_2 - 0.049321338383838*G0_1_0 - 0.042960451489097*G0_1_2 - 0.007045905483406*G0_2_0 - 0.042960451489097*G0_2_2;
    A[1745] = -0.166948816037356*G0_0_0 - 0.006165167297979*G0_0_2 + 0.167731694424402*G0_1_0 + 0.077700679914221*G0_1_2 + 0.083865847212201*G0_2_0 + 0.182410664181496*G0_2_2;
    A[1746] = 0.182410664181496*G0_0_0 + 0.083865847212200*G0_0_2 + 0.077700679914221*G0_1_0 + 0.167731694424401*G0_1_2 - 0.006165167297980*G0_2_0 - 0.166948816037356*G0_2_2;
    A[1747] = -0.042960451489097*G0_0_0 - 0.007045905483405*G0_0_2 - 0.042960451489097*G0_1_0 - 0.049321338383838*G0_1_2 - 0.000685018588664*G0_2_0 + 0.127315597693201*G0_2_2;
    A[1748] = 0.043971669405696*G0_0_0 - 0.000685018588665*G0_0_1 - 0.042275432900433*G0_1_0 - 0.042960451489097*G0_1_1 - 0.084550865800865*G0_2_0 - 0.042960451489097*G0_2_1;
    A[1749] = -0.043645470077761*G0_0_0 - 0.033892110172491*G0_0_1 - 0.006491366625915*G0_1_0 - 0.003522952741703*G0_1_1 - 0.080832193462401*G0_2_0 - 0.108232937008978*G0_2_1;
    A[1750] = -0.015592327875314*G0_0_0 - 0.018886941087462*G0_0_1 + 0.009492400442921*G0_1_0 + 0.018984800885842*G0_1_1 - 0.009394540644541*G0_2_0 - 0.037773882174924*G0_2_1;
    A[1751] = 0.002544354757896*G0_0_0 + 0.008448562593528*G0_0_1 - 0.003294613212148*G0_1_0 - 0.029260079715809*G0_1_1 + 0.002544354757896*G0_2_0 + 0.014287530563572*G0_2_1;
    A[1752] = 0.029260079715808*G0_0_0 + 0.029260079715808*G0_0_1 + 0.025965466503661*G0_0_2 + 0.029260079715808*G0_1_0 + 0.029260079715808*G0_1_1 + 0.025965466503661*G0_1_2 + 0.025965466503661*G0_2_0 + 0.025965466503660*G0_2_1 + 0.022670853291513*G0_2_2;
    A[1753] = -0.018984800885842*G0_0_0 - 0.018984800885842*G0_0_1 - 0.009492400442921*G0_0_2 - 0.018984800885842*G0_1_0 - 0.018984800885842*G0_1_1 - 0.009492400442921*G0_1_2 - 0.009492400442922*G0_2_0 - 0.009492400442922*G0_2_1 - 0.000652398655871*G0_2_2;
    A[1754] = 0.003522952741702*G0_0_0 + 0.003522952741702*G0_0_1 - 0.002968413884212*G0_0_2 + 0.003522952741702*G0_1_0 + 0.003522952741702*G0_1_1 - 0.002968413884213*G0_1_2 - 0.002968413884212*G0_2_0 - 0.002968413884212*G0_2_1 - 0.000652398655870*G0_2_2;
    A[1755] = 0.042960451489097*G0_0_0 + 0.042960451489097*G0_0_1 + 0.000685018588664*G0_0_2 + 0.042960451489097*G0_1_0 + 0.042960451489097*G0_1_1 + 0.000685018588665*G0_1_2 + 0.000685018588664*G0_2_0 + 0.000685018588664*G0_2_1 + 0.022670853291512*G0_2_2;
    A[1756] = 0.006589226424295*G0_0_0 + 0.003294613212148*G0_0_1 + 0.006589226424295*G0_0_2 + 0.003294613212148*G0_1_0 + 0.003294613212148*G0_1_2 + 0.006589226424296*G0_2_0 + 0.003294613212148*G0_2_1 + 0.006589226424295*G0_2_2;
    A[1757] = 0.004501550725509*G0_0_0 + 0.002576974690690*G0_0_1 + 0.004501550725509*G0_0_2 + 0.002576974690690*G0_1_0 + 0.002576974690690*G0_1_2 + 0.004501550725509*G0_2_0 + 0.002576974690690*G0_2_1 + 0.004501550725509*G0_2_2;
    A[1758] = -0.010503618359522*G0_0_0 + 0.002576974690690*G0_0_1 - 0.010503618359521*G0_0_2 + 0.002576974690690*G0_1_0 + 0.002576974690690*G0_1_2 - 0.010503618359521*G0_2_0 + 0.002576974690690*G0_2_1 - 0.010503618359521*G0_2_2;
    A[1759] = -0.002544354757896*G0_0_0 + 0.003294613212148*G0_0_1 - 0.002544354757896*G0_0_2 + 0.003294613212148*G0_1_0 + 0.003294613212148*G0_1_2 - 0.002544354757896*G0_2_0 + 0.003294613212148*G0_2_1 - 0.002544354757896*G0_2_2;
    A[1760] = 0.022670853291512*G0_0_0 + 0.025965466503660*G0_0_1 + 0.025965466503660*G0_0_2 + 0.025965466503661*G0_1_0 + 0.029260079715808*G0_1_1 + 0.029260079715808*G0_1_2 + 0.025965466503661*G0_2_0 + 0.029260079715808*G0_2_1 + 0.029260079715808*G0_2_2;
    A[1761] = -0.000652398655870*G0_0_0 - 0.009492400442921*G0_0_1 - 0.009492400442921*G0_0_2 - 0.009492400442921*G0_1_0 - 0.018984800885842*G0_1_1 - 0.018984800885842*G0_1_2 - 0.009492400442921*G0_2_0 - 0.018984800885843*G0_2_1 - 0.018984800885842*G0_2_2;
    A[1762] = -0.000652398655871*G0_0_0 - 0.002968413884213*G0_0_1 - 0.002968413884213*G0_0_2 - 0.002968413884212*G0_1_0 + 0.003522952741703*G0_1_1 + 0.003522952741703*G0_1_2 - 0.002968413884212*G0_2_0 + 0.003522952741703*G0_2_1 + 0.003522952741703*G0_2_2;
    A[1763] = 0.022670853291513*G0_0_0 + 0.000685018588665*G0_0_1 + 0.000685018588665*G0_0_2 + 0.000685018588664*G0_1_0 + 0.042960451489097*G0_1_1 + 0.042960451489097*G0_1_2 + 0.000685018588664*G0_2_0 + 0.042960451489097*G0_2_1 + 0.042960451489097*G0_2_2;
    A[1764] = -0.268135847562928*G0_0_0 - 0.045994105238897*G0_0_1 - 0.073721048113410*G0_0_2 + 0.022507753627546*G0_1_0 - 0.023486351611351*G0_1_1 - 0.104709984267275*G0_1_2 + 0.180714427676233*G0_2_0 + 0.081223632655923*G0_2_1 - 0.209419968534550*G0_2_2;
    A[1765] = 0.065566064915022*G0_0_0 + 0.027890042538480*G0_0_1 - 0.074862745761182*G0_0_2 - 0.074862745761183*G0_1_0 - 0.149725491522365*G0_1_1 - 0.028379341530383*G0_1_2 + 0.027890042538479*G0_2_0 + 0.177126235068944*G0_2_1 - 0.149725491522365*G0_2_2;
    A[1766] = -0.013700371773288*G0_0_0 - 0.085138024591149*G0_0_1 - 0.019898159004062*G0_0_2 + 0.012721773789482*G0_1_0 + 0.113517366121531*G0_1_1 + 0.012721773789482*G0_1_2 - 0.019898159004061*G0_2_0 - 0.085138024591150*G0_2_1 - 0.013700371773288*G0_2_2;
    A[1767] = 0.726119703984281*G0_0_0 + 0.270093043530542*G0_0_1 + 0.270093043530542*G0_0_2 + 0.270093043530542*G0_1_0 + 0.540186087061083*G0_1_1 + 0.270093043530542*G0_1_2 + 0.270093043530542*G0_2_0 + 0.270093043530542*G0_2_1 + 0.726119703984282*G0_2_2;
    A[1768] = -0.149725491522365*G0_0_0 + 0.177126235068943*G0_0_1 + 0.027890042538480*G0_0_2 - 0.028379341530383*G0_1_0 - 0.149725491522365*G0_1_1 - 0.074862745761183*G0_1_2 - 0.074862745761183*G0_2_0 + 0.027890042538480*G0_2_1 + 0.065566064915022*G0_2_2;
    A[1769] = -0.209419968534549*G0_0_0 + 0.081223632655924*G0_0_1 + 0.180714427676233*G0_0_2 - 0.104709984267275*G0_1_0 - 0.023486351611351*G0_1_1 + 0.022507753627546*G0_1_2 - 0.073721048113408*G0_2_0 - 0.045994105238896*G0_2_1 - 0.268135847562928*G0_2_2;
    A[1770] = -0.025443547578964*G0_0_0 - 0.012721773789481*G0_0_1 - 0.024138750267221*G0_0_2 - 0.012721773789482*G0_1_0 - 0.012069375133611*G0_1_2 - 0.024138750267223*G0_2_0 - 0.012069375133611*G0_2_1 - 0.022833952955480*G0_2_2;
    A[1771] = -0.016636165724707*G0_0_0 - 0.018104062700418*G0_0_1 + 0.001467896975710*G0_0_2 - 0.018104062700417*G0_1_0 - 0.010275278829966*G0_1_2 + 0.001467896975710*G0_2_0 - 0.010275278829967*G0_2_1 + 0.019571959676126*G0_2_2;
    A[1772] = 0.013700371773288*G0_0_0 - 0.012721773789481*G0_0_1 + 0.019898159004061*G0_0_2 - 0.012721773789482*G0_1_0 - 0.012069375133611*G0_1_2 + 0.019898159004061*G0_2_0 - 0.012069375133611*G0_2_1 + 0.026095946234835*G0_2_2;
    A[1773] = 0.056758683060766*G0_0_0 + 0.028379341530383*G0_0_1 + 0.028379341530381*G0_0_2 + 0.028379341530383*G0_1_0 + 0.014189670765191*G0_1_2 + 0.028379341530383*G0_2_0 + 0.014189670765192*G0_2_1 - 0.004892989919032*G0_2_2;
    A[1774] = 0.149725491522365*G0_0_0 + 0.028379341530383*G0_0_1 + 0.074862745761182*G0_0_2 + 0.028379341530383*G0_1_0 + 0.014189670765191*G0_1_2 + 0.074862745761183*G0_2_0 + 0.014189670765191*G0_2_1 + 0.019571959676126*G0_2_2;
    A[1775] = 0.209419968534549*G0_0_0 + 0.104709984267275*G0_0_1 + 0.073721048113410*G0_0_2 + 0.104709984267275*G0_1_0 + 0.036860524056705*G0_1_2 + 0.073721048113408*G0_2_0 + 0.036860524056705*G0_2_1 - 0.022833952955480*G0_2_2;
    A[1776] = -0.088073818542567*G0_0_0 - 0.100795592332050*G0_0_1 - 0.088726217198437*G0_0_2 - 0.100795592332049*G0_1_0 - 0.113517366121532*G0_1_1 - 0.100795592332049*G0_1_2 - 0.088726217198438*G0_2_0 - 0.100795592332050*G0_2_1 - 0.088073818542567*G0_2_2;
    A[1777] = 0.019571959676125*G0_0_0 + 0.074862745761182*G0_0_1 + 0.060673074995991*G0_0_2 + 0.074862745761182*G0_1_0 + 0.149725491522365*G0_1_1 + 0.121346149991982*G0_1_2 + 0.060673074995990*G0_2_0 + 0.121346149991983*G0_2_1 + 0.092966808461599*G0_2_2;
    A[1778] = -0.088073818542567*G0_0_0 + 0.045994105238897*G0_0_1 + 0.009133581182192*G0_0_2 + 0.045994105238897*G0_1_0 + 0.023486351611351*G0_1_1 - 0.081223632655924*G0_1_2 + 0.009133581182193*G0_2_0 - 0.081223632655924*G0_2_1 - 0.185933616923199*G0_2_2;
    A[1779] = 0.092966808461600*G0_0_0 + 0.121346149991982*G0_0_1 + 0.060673074995990*G0_0_2 + 0.121346149991982*G0_1_0 + 0.149725491522365*G0_1_1 + 0.074862745761182*G0_1_2 + 0.060673074995991*G0_2_0 + 0.074862745761182*G0_2_1 + 0.019571959676126*G0_2_2;
    A[1780] = 0.092966808461598*G0_0_0 - 0.270093043530541*G0_0_1 - 0.135046521765271*G0_0_2 - 0.270093043530542*G0_1_0 - 0.540186087061083*G0_1_1 - 0.270093043530541*G0_1_2 - 0.135046521765270*G0_2_0 - 0.270093043530542*G0_2_1 + 0.092966808461600*G0_2_2;
    A[1781] = -0.185933616923198*G0_0_0 - 0.081223632655924*G0_0_1 + 0.009133581182193*G0_0_2 - 0.081223632655923*G0_1_0 + 0.023486351611351*G0_1_1 + 0.045994105238897*G0_1_2 + 0.009133581182192*G0_2_0 + 0.045994105238896*G0_2_1 - 0.088073818542568*G0_2_2;
    A[1782] = -0.022833952955479*G0_0_0 - 0.012069375133610*G0_0_1 - 0.024138750267222*G0_0_2 - 0.012069375133611*G0_1_0 - 0.012721773789482*G0_1_2 - 0.024138750267222*G0_2_0 - 0.012721773789481*G0_2_1 - 0.025443547578964*G0_2_2;
    A[1783] = -0.004892989919033*G0_0_0 + 0.014189670765192*G0_0_1 + 0.028379341530383*G0_0_2 + 0.014189670765191*G0_1_0 + 0.028379341530383*G0_1_2 + 0.028379341530383*G0_2_0 + 0.028379341530383*G0_2_1 + 0.056758683060766*G0_2_2;
    A[1784] = -0.022833952955479*G0_0_0 + 0.036860524056704*G0_0_1 + 0.073721048113409*G0_0_2 + 0.036860524056705*G0_1_0 + 0.104709984267275*G0_1_2 + 0.073721048113408*G0_2_0 + 0.104709984267274*G0_2_1 + 0.209419968534550*G0_2_2;
    A[1785] = 0.019571959676126*G0_0_0 - 0.010275278829967*G0_0_1 + 0.001467896975709*G0_0_2 - 0.010275278829966*G0_1_0 - 0.018104062700417*G0_1_2 + 0.001467896975709*G0_2_0 - 0.018104062700417*G0_2_1 - 0.016636165724707*G0_2_2;
    A[1786] = 0.019571959676126*G0_0_0 + 0.014189670765191*G0_0_1 + 0.074862745761183*G0_0_2 + 0.014189670765191*G0_1_0 + 0.028379341530383*G0_1_2 + 0.074862745761183*G0_2_0 + 0.028379341530384*G0_2_1 + 0.149725491522365*G0_2_2;
    A[1787] = 0.026095946234836*G0_0_0 - 0.012069375133610*G0_0_1 + 0.019898159004062*G0_0_2 - 0.012069375133611*G0_1_0 - 0.012721773789482*G0_1_2 + 0.019898159004062*G0_2_0 - 0.012721773789482*G0_2_1 + 0.013700371773288*G0_2_2;
    A[1788] = 0.146789697570946*G0_0_0 + 0.092966808461599*G0_0_1 + 0.141896707651915*G0_0_2 + 0.092966808461599*G0_1_0 + 0.092966808461599*G0_1_2 + 0.141896707651915*G0_2_0 + 0.092966808461599*G0_2_1 + 0.146789697570946*G0_2_2;
    A[1789] = 0.146789697570946*G0_0_0 - 0.102752788299662*G0_0_1 - 0.298472385060924*G0_0_2 - 0.102752788299663*G0_1_0 - 0.298472385060925*G0_1_2 - 0.298472385060925*G0_2_0 - 0.298472385060925*G0_2_1 - 0.782878387045048*G0_2_2;
    A[1790] = -0.048929899190315*G0_0_0 + 0.092966808461600*G0_0_1 - 0.029357939514189*G0_0_2 + 0.092966808461600*G0_1_0 + 0.092966808461600*G0_1_2 - 0.029357939514189*G0_2_0 + 0.092966808461600*G0_2_1 - 0.048929899190314*G0_2_2;
    A[1791] = -0.782878387045047*G0_0_0 - 0.298472385060925*G0_0_1 - 0.298472385060926*G0_0_2 - 0.298472385060924*G0_1_0 - 0.102752788299663*G0_1_2 - 0.298472385060925*G0_2_0 - 0.102752788299662*G0_2_1 + 0.146789697570946*G0_2_2;
    A[1792] = -0.009464999699375*G0_0_0 - 0.009464999699375*G0_0_1 - 0.009464999699375*G0_0_2 - 0.009464999699375*G0_1_0 - 0.009464999699375*G0_1_1 - 0.009464999699375*G0_1_2 - 0.009464999699375*G0_2_0 - 0.009464999699375*G0_2_1 - 0.009464999699375*G0_2_2;
    A[1793] = 0.009464999699375*G0_0_0 - 0.002278176106301*G0_1_0 - 0.002278176106301*G0_2_0;
    A[1794] = -0.004724671065817*G0_0_1 - 0.034571909571909*G0_1_1 - 0.004724671065817*G0_2_1;
    A[1795] = -0.004724671065817*G0_0_2 - 0.004724671065817*G0_1_2 - 0.034571909571909*G0_2_2;
    A[1796] = -0.049321338383838*G0_0_1 - 0.042960451489097*G0_0_2 + 0.127315597693201*G0_1_1 - 0.000685018588664*G0_1_2 - 0.007045905483406*G0_2_1 - 0.042960451489097*G0_2_2;
    A[1797] = 0.167731694424401*G0_0_1 + 0.077700679914221*G0_0_2 - 0.166948816037357*G0_1_1 - 0.006165167297980*G0_1_2 + 0.083865847212200*G0_2_1 + 0.182410664181496*G0_2_2;
    A[1798] = 0.077700679914221*G0_0_1 + 0.167731694424402*G0_0_2 + 0.182410664181496*G0_1_1 + 0.083865847212201*G0_1_2 - 0.006165167297979*G0_2_1 - 0.166948816037356*G0_2_2;
    A[1799] = -0.042960451489097*G0_0_1 - 0.049321338383839*G0_0_2 - 0.042960451489097*G0_1_1 - 0.007045905483406*G0_1_2 - 0.000685018588665*G0_2_1 + 0.127315597693200*G0_2_2;
    A[1800] = -0.029260079715808*G0_0_0 - 0.003294613212148*G0_0_2 + 0.014287530563572*G0_1_0 + 0.002544354757896*G0_1_2 + 0.008448562593528*G0_2_0 + 0.002544354757897*G0_2_2;
    A[1801] = 0.018984800885842*G0_0_0 + 0.009492400442921*G0_0_2 - 0.037773882174924*G0_1_0 - 0.009394540644540*G0_1_2 - 0.018886941087463*G0_2_0 - 0.015592327875314*G0_2_2;
    A[1802] = -0.003522952741702*G0_0_0 - 0.006491366625915*G0_0_2 - 0.108232937008978*G0_1_0 - 0.080832193462401*G0_1_2 - 0.033892110172491*G0_2_0 - 0.043645470077761*G0_2_2;
    A[1803] = -0.042960451489097*G0_0_0 - 0.042275432900433*G0_0_2 - 0.042960451489097*G0_1_0 - 0.084550865800866*G0_1_2 - 0.000685018588665*G0_2_0 + 0.043971669405696*G0_2_2;
    A[1804] = -0.029260079715808*G0_0_0 - 0.003294613212148*G0_0_1 + 0.008448562593528*G0_1_0 + 0.002544354757896*G0_1_1 + 0.014287530563573*G0_2_0 + 0.002544354757897*G0_2_1;
    A[1805] = 0.018984800885842*G0_0_0 + 0.009492400442921*G0_0_1 - 0.018886941087461*G0_1_0 - 0.015592327875314*G0_1_1 - 0.037773882174924*G0_2_0 - 0.009394540644541*G0_2_1;
    A[1806] = -0.003522952741702*G0_0_0 - 0.006491366625915*G0_0_1 - 0.033892110172492*G0_1_0 - 0.043645470077761*G0_1_1 - 0.108232937008977*G0_2_0 - 0.080832193462400*G0_2_1;
    A[1807] = -0.042960451489097*G0_0_0 - 0.042275432900433*G0_0_1 - 0.000685018588664*G0_1_0 + 0.043971669405697*G0_1_1 - 0.042960451489097*G0_2_0 - 0.084550865800865*G0_2_1;
    A[1808] = 0.029260079715808*G0_0_0 + 0.029260079715808*G0_0_1 + 0.025965466503661*G0_0_2 + 0.029260079715808*G0_1_0 + 0.029260079715808*G0_1_1 + 0.025965466503661*G0_1_2 + 0.025965466503660*G0_2_0 + 0.025965466503660*G0_2_1 + 0.022670853291513*G0_2_2;
    A[1809] = -0.018984800885841*G0_0_0 - 0.018984800885841*G0_0_1 - 0.009492400442921*G0_0_2 - 0.018984800885842*G0_1_0 - 0.018984800885842*G0_1_1 - 0.009492400442921*G0_1_2 - 0.009492400442920*G0_2_0 - 0.009492400442921*G0_2_1 - 0.000652398655871*G0_2_2;
    A[1810] = 0.003522952741702*G0_0_0 + 0.003522952741702*G0_0_1 - 0.002968413884213*G0_0_2 + 0.003522952741703*G0_1_0 + 0.003522952741703*G0_1_1 - 0.002968413884212*G0_1_2 - 0.002968413884213*G0_2_0 - 0.002968413884213*G0_2_1 - 0.000652398655870*G0_2_2;
    A[1811] = 0.042960451489098*G0_0_0 + 0.042960451489097*G0_0_1 + 0.000685018588664*G0_0_2 + 0.042960451489097*G0_1_0 + 0.042960451489097*G0_1_1 + 0.000685018588664*G0_1_2 + 0.000685018588665*G0_2_0 + 0.000685018588665*G0_2_1 + 0.022670853291512*G0_2_2;
    A[1812] = 0.029260079715808*G0_0_0 + 0.025965466503661*G0_0_1 + 0.029260079715808*G0_0_2 + 0.025965466503660*G0_1_0 + 0.022670853291513*G0_1_1 + 0.025965466503661*G0_1_2 + 0.029260079715808*G0_2_0 + 0.025965466503661*G0_2_1 + 0.029260079715808*G0_2_2;
    A[1813] = -0.018984800885842*G0_0_0 - 0.009492400442921*G0_0_1 - 0.018984800885842*G0_0_2 - 0.009492400442921*G0_1_0 - 0.000652398655871*G0_1_1 - 0.009492400442921*G0_1_2 - 0.018984800885842*G0_2_0 - 0.009492400442921*G0_2_1 - 0.018984800885842*G0_2_2;
    A[1814] = 0.003522952741703*G0_0_0 - 0.002968413884213*G0_0_1 + 0.003522952741703*G0_0_2 - 0.002968413884212*G0_1_0 - 0.000652398655870*G0_1_1 - 0.002968413884212*G0_1_2 + 0.003522952741702*G0_2_0 - 0.002968413884212*G0_2_1 + 0.003522952741702*G0_2_2;
    A[1815] = 0.042960451489097*G0_0_0 + 0.000685018588664*G0_0_1 + 0.042960451489097*G0_0_2 + 0.000685018588664*G0_1_0 + 0.022670853291513*G0_1_1 + 0.000685018588664*G0_1_2 + 0.042960451489097*G0_2_0 + 0.000685018588665*G0_2_1 + 0.042960451489097*G0_2_2;
    A[1816] = 0.003294613212148*G0_0_1 + 0.003294613212148*G0_0_2 + 0.003294613212148*G0_1_0 + 0.006589226424296*G0_1_1 + 0.006589226424296*G0_1_2 + 0.003294613212148*G0_2_0 + 0.006589226424296*G0_2_1 + 0.006589226424296*G0_2_2;
    A[1817] = 0.002576974690690*G0_0_1 + 0.002576974690690*G0_0_2 + 0.002576974690690*G0_1_0 + 0.004501550725509*G0_1_1 + 0.004501550725509*G0_1_2 + 0.002576974690690*G0_2_0 + 0.004501550725509*G0_2_1 + 0.004501550725509*G0_2_2;
    A[1818] = 0.002576974690690*G0_0_1 + 0.002576974690690*G0_0_2 + 0.002576974690690*G0_1_0 - 0.010503618359521*G0_1_1 - 0.010503618359521*G0_1_2 + 0.002576974690690*G0_2_0 - 0.010503618359521*G0_2_1 - 0.010503618359521*G0_2_2;
    A[1819] = 0.003294613212148*G0_0_1 + 0.003294613212148*G0_0_2 + 0.003294613212148*G0_1_0 - 0.002544354757896*G0_1_1 - 0.002544354757896*G0_1_2 + 0.003294613212148*G0_2_0 - 0.002544354757897*G0_2_1 - 0.002544354757897*G0_2_2;
    A[1820] = 0.113517366121532*G0_0_0 + 0.012721773789483*G0_0_1 + 0.012721773789483*G0_0_2 - 0.085138024591149*G0_1_0 - 0.013700371773288*G0_1_1 - 0.019898159004062*G0_1_2 - 0.085138024591149*G0_2_0 - 0.019898159004061*G0_2_1 - 0.013700371773287*G0_2_2;
    A[1821] = -0.149725491522365*G0_0_0 - 0.074862745761183*G0_0_1 - 0.028379341530383*G0_0_2 + 0.027890042538480*G0_1_0 + 0.065566064915022*G0_1_1 - 0.074862745761182*G0_1_2 + 0.177126235068943*G0_2_0 + 0.027890042538481*G0_2_1 - 0.149725491522364*G0_2_2;
    A[1822] = -0.023486351611352*G0_0_0 + 0.022507753627545*G0_0_1 - 0.104709984267275*G0_0_2 - 0.045994105238896*G0_1_0 - 0.268135847562929*G0_1_1 - 0.073721048113409*G0_1_2 + 0.081223632655922*G0_2_0 + 0.180714427676231*G0_2_1 - 0.209419968534550*G0_2_2;
    A[1823] = -0.149725491522365*G0_0_0 - 0.028379341530383*G0_0_1 - 0.074862745761183*G0_0_2 + 0.177126235068943*G0_1_0 - 0.149725491522365*G0_1_1 + 0.027890042538480*G0_1_2 + 0.027890042538480*G0_2_0 - 0.074862745761183*G0_2_1 + 0.065566064915022*G0_2_2;
    A[1824] = 0.540186087061083*G0_0_0 + 0.270093043530542*G0_0_1 + 0.270093043530541*G0_0_2 + 0.270093043530542*G0_1_0 + 0.726119703984283*G0_1_1 + 0.270093043530542*G0_1_2 + 0.270093043530541*G0_2_0 + 0.270093043530542*G0_2_1 + 0.726119703984280*G0_2_2;
    A[1825] = -0.023486351611353*G0_0_0 - 0.104709984267276*G0_0_1 + 0.022507753627545*G0_0_2 + 0.081223632655923*G0_1_0 - 0.209419968534551*G0_1_1 + 0.180714427676232*G0_1_2 - 0.045994105238897*G0_2_0 - 0.073721048113409*G0_2_1 - 0.268135847562928*G0_2_2;
    A[1826] = -0.113517366121531*G0_0_0 - 0.100795592332049*G0_0_1 - 0.100795592332049*G0_0_2 - 0.100795592332049*G0_1_0 - 0.088073818542567*G0_1_1 - 0.088726217198438*G0_1_2 - 0.100795592332049*G0_2_0 - 0.088726217198438*G0_2_1 - 0.088073818542566*G0_2_2;
    A[1827] = 0.149725491522365*G0_0_0 + 0.074862745761182*G0_0_1 + 0.121346149991981*G0_0_2 + 0.074862745761182*G0_1_0 + 0.019571959676125*G0_1_1 + 0.060673074995991*G0_1_2 + 0.121346149991981*G0_2_0 + 0.060673074995990*G0_2_1 + 0.092966808461598*G0_2_2;
    A[1828] = 0.023486351611352*G0_0_0 + 0.045994105238897*G0_0_1 - 0.081223632655923*G0_0_2 + 0.045994105238896*G0_1_0 - 0.088073818542567*G0_1_1 + 0.009133581182192*G0_1_2 - 0.081223632655922*G0_2_0 + 0.009133581182193*G0_2_1 - 0.185933616923197*G0_2_2;
    A[1829] = 0.149725491522364*G0_0_0 + 0.121346149991981*G0_0_1 + 0.074862745761182*G0_0_2 + 0.121346149991982*G0_1_0 + 0.092966808461598*G0_1_1 + 0.060673074995990*G0_1_2 + 0.074862745761182*G0_2_0 + 0.060673074995990*G0_2_1 + 0.019571959676125*G0_2_2;
    A[1830] = -0.540186087061083*G0_0_0 - 0.270093043530540*G0_0_1 - 0.270093043530541*G0_0_2 - 0.270093043530542*G0_1_0 + 0.092966808461600*G0_1_1 - 0.135046521765270*G0_1_2 - 0.270093043530541*G0_2_0 - 0.135046521765270*G0_2_1 + 0.092966808461599*G0_2_2;
    A[1831] = 0.023486351611353*G0_0_0 - 0.081223632655924*G0_0_1 + 0.045994105238897*G0_0_2 - 0.081223632655923*G0_1_0 - 0.185933616923199*G0_1_1 + 0.009133581182193*G0_1_2 + 0.045994105238897*G0_2_0 + 0.009133581182192*G0_2_1 - 0.088073818542567*G0_2_2;
    A[1832] = -0.012721773789481*G0_0_1 - 0.012069375133610*G0_0_2 - 0.012721773789482*G0_1_0 - 0.025443547578964*G0_1_1 - 0.024138750267221*G0_1_2 - 0.012069375133611*G0_2_0 - 0.024138750267222*G0_2_1 - 0.022833952955480*G0_2_2;
    A[1833] = -0.018104062700417*G0_0_1 - 0.010275278829966*G0_0_2 - 0.018104062700416*G0_1_0 - 0.016636165724707*G0_1_1 + 0.001467896975710*G0_1_2 - 0.010275278829966*G0_2_0 + 0.001467896975709*G0_2_1 + 0.019571959676126*G0_2_2;
    A[1834] = -0.012721773789482*G0_0_1 - 0.012069375133611*G0_0_2 - 0.012721773789483*G0_1_0 + 0.013700371773288*G0_1_1 + 0.019898159004061*G0_1_2 - 0.012069375133611*G0_2_0 + 0.019898159004061*G0_2_1 + 0.026095946234835*G0_2_2;
    A[1835] = 0.028379341530383*G0_0_1 + 0.014189670765191*G0_0_2 + 0.028379341530382*G0_1_0 + 0.056758683060766*G0_1_1 + 0.028379341530382*G0_1_2 + 0.014189670765191*G0_2_0 + 0.028379341530383*G0_2_1 - 0.004892989919032*G0_2_2;
    A[1836] = 0.028379341530383*G0_0_1 + 0.014189670765192*G0_0_2 + 0.028379341530383*G0_1_0 + 0.149725491522365*G0_1_1 + 0.074862745761182*G0_1_2 + 0.014189670765192*G0_2_0 + 0.074862745761183*G0_2_1 + 0.019571959676126*G0_2_2;
    A[1837] = 0.104709984267276*G0_0_1 + 0.036860524056705*G0_0_2 + 0.104709984267275*G0_1_0 + 0.209419968534551*G0_1_1 + 0.073721048113410*G0_1_2 + 0.036860524056704*G0_2_0 + 0.073721048113409*G0_2_1 - 0.022833952955480*G0_2_2;
    A[1838] = -0.012069375133611*G0_0_1 - 0.012721773789482*G0_0_2 - 0.012069375133611*G0_1_0 - 0.022833952955480*G0_1_1 - 0.024138750267223*G0_1_2 - 0.012721773789482*G0_2_0 - 0.024138750267222*G0_2_1 - 0.025443547578964*G0_2_2;
    A[1839] = -0.010275278829966*G0_0_1 - 0.018104062700416*G0_0_2 - 0.010275278829966*G0_1_0 + 0.019571959676127*G0_1_1 + 0.001467896975710*G0_1_2 - 0.018104062700417*G0_2_0 + 0.001467896975710*G0_2_1 - 0.016636165724707*G0_2_2;
    A[1840] = -0.012069375133611*G0_0_1 - 0.012721773789482*G0_0_2 - 0.012069375133611*G0_1_0 + 0.026095946234835*G0_1_1 + 0.019898159004061*G0_1_2 - 0.012721773789482*G0_2_0 + 0.019898159004062*G0_2_1 + 0.013700371773287*G0_2_2;
    A[1841] = 0.014189670765192*G0_0_1 + 0.028379341530383*G0_0_2 + 0.014189670765192*G0_1_0 - 0.004892989919032*G0_1_1 + 0.028379341530383*G0_1_2 + 0.028379341530384*G0_2_0 + 0.028379341530383*G0_2_1 + 0.056758683060767*G0_2_2;
    A[1842] = 0.014189670765191*G0_0_1 + 0.028379341530383*G0_0_2 + 0.014189670765191*G0_1_0 + 0.019571959676125*G0_1_1 + 0.074862745761183*G0_1_2 + 0.028379341530382*G0_2_0 + 0.074862745761181*G0_2_1 + 0.149725491522364*G0_2_2;
    A[1843] = 0.036860524056704*G0_0_1 + 0.104709984267275*G0_0_2 + 0.036860524056705*G0_1_0 - 0.022833952955480*G0_1_1 + 0.073721048113409*G0_1_2 + 0.104709984267274*G0_2_0 + 0.073721048113409*G0_2_1 + 0.209419968534550*G0_2_2;
    A[1844] = 0.092966808461599*G0_0_1 + 0.092966808461599*G0_0_2 + 0.092966808461599*G0_1_0 + 0.146789697570946*G0_1_1 + 0.141896707651915*G0_1_2 + 0.092966808461599*G0_2_0 + 0.141896707651915*G0_2_1 + 0.146789697570946*G0_2_2;
    A[1845] = 0.092966808461599*G0_0_1 + 0.092966808461599*G0_0_2 + 0.092966808461599*G0_1_0 - 0.048929899190316*G0_1_1 - 0.029357939514189*G0_1_2 + 0.092966808461599*G0_2_0 - 0.029357939514190*G0_2_1 - 0.048929899190316*G0_2_2;
    A[1846] = -0.102752788299662*G0_0_1 - 0.298472385060924*G0_0_2 - 0.102752788299662*G0_1_0 + 0.146789697570947*G0_1_1 - 0.298472385060924*G0_1_2 - 0.298472385060924*G0_2_0 - 0.298472385060924*G0_2_1 - 0.782878387045046*G0_2_2;
    A[1847] = -0.298472385060925*G0_0_1 - 0.102752788299662*G0_0_2 - 0.298472385060924*G0_1_0 - 0.782878387045049*G0_1_1 - 0.298472385060925*G0_1_2 - 0.102752788299662*G0_2_0 - 0.298472385060924*G0_2_1 + 0.146789697570947*G0_2_2;
    A[1848] = -0.013742125287264*G0_0_0 - 0.013742125287264*G0_0_1 - 0.013742125287264*G0_0_2 - 0.013742125287264*G0_1_0 - 0.013742125287264*G0_1_1 - 0.013742125287264*G0_1_2 - 0.013742125287264*G0_2_0 - 0.013742125287264*G0_2_1 - 0.013742125287264*G0_2_2;
    A[1849] = 0.013742125287264*G0_0_0 - 0.005177435732991*G0_1_0 - 0.005177435732991*G0_2_0;
    A[1850] = -0.005177435732991*G0_0_1 + 0.013742125287264*G0_1_1 - 0.005177435732991*G0_2_1;
    A[1851] = 0.014394523943135*G0_0_2 + 0.014394523943135*G0_1_2 + 0.047993054720485*G0_2_2;
    A[1852] = 0.047755581609748*G0_0_1 + 0.011873655536850*G0_0_2 - 0.064130787872107*G0_1_1 - 0.009394540644541*G0_1_2 + 0.026487385428358*G0_2_1 + 0.011873655536850*G0_2_2;
    A[1853] = -0.082332710370904*G0_0_1 + 0.001826716236438*G0_0_2 + 0.127087258163646*G0_1_1 + 0.037773882174924*G0_1_2 - 0.046385544432419*G0_2_1 - 0.051017574889102*G0_2_2;
    A[1854] = 0.146659217839771*G0_0_1 + 0.010960297418631*G0_0_2 - 0.124738623002512*G0_1_1 - 0.062369311501256*G0_1_2 + 0.073329608919886*G0_2_1 + 0.132306447410613*G0_2_2;
    A[1855] = 0.124738623002512*G0_0_1 + 0.192588083213082*G0_0_2 + 0.124738623002512*G0_1_1 + 0.096294041606541*G0_1_2 + 0.028444581395971*G0_2_1 - 0.064456987200042*G0_2_2;
    A[1856] = -0.064130787872107*G0_0_0 - 0.009394540644541*G0_0_2 + 0.047755581609748*G0_1_0 + 0.011873655536850*G0_1_2 + 0.026487385428357*G0_2_0 + 0.011873655536849*G0_2_2;
    A[1857] = 0.127087258163646*G0_0_0 + 0.037773882174923*G0_0_2 - 0.082332710370904*G0_1_0 + 0.001826716236438*G0_1_2 - 0.046385544432419*G0_2_0 - 0.051017574889102*G0_2_2;
    A[1858] = -0.124738623002511*G0_0_0 - 0.062369311501255*G0_0_2 + 0.146659217839772*G0_1_0 + 0.010960297418630*G0_1_2 + 0.073329608919886*G0_2_0 + 0.132306447410612*G0_2_2;
    A[1859] = 0.124738623002512*G0_0_0 + 0.096294041606541*G0_0_2 + 0.124738623002512*G0_1_0 + 0.192588083213082*G0_1_2 + 0.028444581395971*G0_2_0 - 0.064456987200042*G0_2_2;
    A[1860] = -0.018789081289081*G0_0_0 - 0.009394540644541*G0_0_1 + 0.021268196181390*G0_1_0 + 0.011873655536850*G0_1_1 + 0.042536392362780*G0_2_0 + 0.011873655536849*G0_2_1;
    A[1861] = 0.014874689353856*G0_0_0 + 0.014939929219443*G0_0_1 + 0.001239557446155*G0_1_0 + 0.001174317580568*G0_1_1 + 0.040318236932820*G0_2_0 + 0.054018608706108*G0_2_1;
    A[1862] = 0.001174317580567*G0_0_0 + 0.001239557446154*G0_0_1 + 0.014939929219443*G0_1_0 + 0.014874689353856*G0_1_1 + 0.054018608706108*G0_2_0 + 0.040318236932820*G0_2_1;
    A[1863] = 0.011873655536850*G0_0_0 + 0.021268196181391*G0_0_1 - 0.009394540644541*G0_1_0 - 0.018789081289081*G0_1_1 + 0.011873655536850*G0_2_0 + 0.042536392362781*G0_2_1;
    A[1864] = 0.064130787872107*G0_0_0 + 0.064130787872107*G0_0_1 + 0.054736247227567*G0_0_2 + 0.064130787872107*G0_1_0 + 0.064130787872107*G0_1_1 + 0.054736247227566*G0_1_2 + 0.054736247227566*G0_2_0 + 0.054736247227566*G0_2_1 + 0.045341706583026*G0_2_2;
    A[1865] = -0.127087258163647*G0_0_0 - 0.127087258163647*G0_0_1 - 0.089313375988723*G0_0_2 - 0.127087258163646*G0_1_0 - 0.127087258163647*G0_1_1 - 0.089313375988723*G0_1_2 - 0.089313375988723*G0_2_0 - 0.089313375988723*G0_2_1 - 0.066544662898829*G0_2_2;
    A[1866] = 0.124738623002512*G0_0_0 + 0.124738623002512*G0_0_1 + 0.062369311501256*G0_0_2 + 0.124738623002511*G0_1_0 + 0.124738623002512*G0_1_1 + 0.062369311501256*G0_1_2 + 0.062369311501256*G0_2_0 + 0.062369311501256*G0_2_1 + 0.047625101878574*G0_2_2;
    A[1867] = -0.124738623002512*G0_0_0 - 0.124738623002512*G0_0_1 - 0.028444581395971*G0_0_2 - 0.124738623002512*G0_1_0 - 0.124738623002512*G0_1_1 - 0.028444581395971*G0_1_2 - 0.028444581395971*G0_2_0 - 0.028444581395971*G0_2_1 - 0.060673074995992*G0_2_2;
    A[1868] = 0.018789081289081*G0_0_0 + 0.009394540644541*G0_0_1 + 0.018789081289081*G0_0_2 + 0.009394540644541*G0_1_0 + 0.009394540644541*G0_1_2 + 0.018789081289081*G0_2_0 + 0.009394540644540*G0_2_1 + 0.018789081289081*G0_2_2;
    A[1869] = -0.014874689353856*G0_0_0 + 0.000065239865587*G0_0_1 - 0.014874689353856*G0_0_2 + 0.000065239865587*G0_1_0 + 0.000065239865587*G0_1_2 - 0.014874689353856*G0_2_0 + 0.000065239865587*G0_2_1 - 0.014874689353856*G0_2_2;
    A[1870] = -0.001174317580567*G0_0_0 + 0.000065239865587*G0_0_1 - 0.001174317580567*G0_0_2 + 0.000065239865587*G0_1_0 + 0.000065239865587*G0_1_2 - 0.001174317580567*G0_2_0 + 0.000065239865587*G0_2_1 - 0.001174317580567*G0_2_2;
    A[1871] = -0.011873655536850*G0_0_0 + 0.009394540644541*G0_0_1 - 0.011873655536850*G0_0_2 + 0.009394540644541*G0_1_0 + 0.009394540644541*G0_1_2 - 0.011873655536850*G0_2_0 + 0.009394540644540*G0_2_1 - 0.011873655536850*G0_2_2;
    A[1872] = 0.009394540644541*G0_0_1 + 0.009394540644541*G0_0_2 + 0.009394540644540*G0_1_0 + 0.018789081289081*G0_1_1 + 0.018789081289081*G0_1_2 + 0.009394540644540*G0_2_0 + 0.018789081289081*G0_2_1 + 0.018789081289081*G0_2_2;
    A[1873] = 0.000065239865587*G0_0_1 + 0.000065239865587*G0_0_2 + 0.000065239865587*G0_1_0 - 0.014874689353856*G0_1_1 - 0.014874689353856*G0_1_2 + 0.000065239865587*G0_2_0 - 0.014874689353856*G0_2_1 - 0.014874689353856*G0_2_2;
    A[1874] = 0.000065239865587*G0_0_1 + 0.000065239865587*G0_0_2 + 0.000065239865587*G0_1_0 - 0.001174317580568*G0_1_1 - 0.001174317580568*G0_1_2 + 0.000065239865587*G0_2_0 - 0.001174317580568*G0_2_1 - 0.001174317580568*G0_2_2;
    A[1875] = 0.009394540644541*G0_0_1 + 0.009394540644540*G0_0_2 + 0.009394540644541*G0_1_0 - 0.011873655536850*G0_1_1 - 0.011873655536850*G0_1_2 + 0.009394540644541*G0_2_0 - 0.011873655536849*G0_2_1 - 0.011873655536849*G0_2_2;
    A[1876] = 0.105688582251081*G0_0_0 + 0.052844291125540*G0_0_1 + 0.030010338170060*G0_0_2 + 0.000652398655871*G0_1_0 + 0.053496689781411*G0_1_1 + 0.052844291125540*G0_1_2 - 0.074373446769280*G0_2_0 + 0.000652398655871*G0_2_1 + 0.105688582251080*G0_2_2;
    A[1877] = -0.013700371773288*G0_0_0 - 0.019898159004061*G0_0_1 + 0.012721773789482*G0_0_2 - 0.019898159004062*G0_1_0 - 0.013700371773288*G0_1_1 + 0.012721773789482*G0_1_2 - 0.085138024591149*G0_2_0 - 0.085138024591150*G0_2_1 + 0.113517366121531*G0_2_2;
    A[1878] = 0.053496689781412*G0_0_0 + 0.000652398655870*G0_0_1 + 0.052844291125541*G0_0_2 + 0.052844291125541*G0_1_0 + 0.105688582251081*G0_1_1 + 0.030010338170060*G0_1_2 + 0.000652398655872*G0_2_0 - 0.074373446769279*G0_2_1 + 0.105688582251081*G0_2_2;
    A[1879] = -0.209419968534549*G0_0_0 - 0.104709984267275*G0_0_1 - 0.073721048113408*G0_0_2 + 0.081223632655924*G0_1_0 - 0.023486351611351*G0_1_1 - 0.045994105238896*G0_1_2 + 0.180714427676233*G0_2_0 + 0.022507753627546*G0_2_1 - 0.268135847562928*G0_2_2;
    A[1880] = -0.023486351611353*G0_0_0 + 0.081223632655923*G0_0_1 - 0.045994105238897*G0_0_2 - 0.104709984267276*G0_1_0 - 0.209419968534551*G0_1_1 - 0.073721048113409*G0_1_2 + 0.022507753627545*G0_2_0 + 0.180714427676232*G0_2_1 - 0.268135847562928*G0_2_2;
    A[1881] = 0.542795681684568*G0_0_0 + 0.271397840842285*G0_0_1 + 0.271397840842284*G0_0_2 + 0.271397840842285*G0_1_0 + 0.542795681684568*G0_1_1 + 0.271397840842284*G0_1_2 + 0.271397840842284*G0_2_0 + 0.271397840842284*G0_2_1 + 0.647179466623906*G0_2_2;
    A[1882] = -0.105688582251082*G0_0_0 - 0.052844291125541*G0_0_1 - 0.075678244081022*G0_0_2 - 0.052844291125541*G0_1_0 - 0.037839122040511*G0_1_2 - 0.075678244081021*G0_2_0 - 0.037839122040511*G0_2_1 - 0.045667905910961*G0_2_2;
    A[1883] = 0.013700371773289*G0_0_0 - 0.006197787230772*G0_0_1 + 0.026422145562770*G0_0_2 - 0.006197787230772*G0_1_0 - 0.005545388574902*G0_1_2 + 0.026422145562771*G0_2_0 - 0.005545388574902*G0_2_1 + 0.039143919352252*G0_2_2;
    A[1884] = -0.053496689781412*G0_0_0 - 0.052844291125542*G0_0_1 - 0.000652398655871*G0_0_2 - 0.052844291125541*G0_1_0 - 0.037839122040511*G0_1_2 - 0.000652398655872*G0_2_0 - 0.037839122040511*G0_2_1 + 0.052191892469669*G0_2_2;
    A[1885] = 0.209419968534550*G0_0_0 + 0.104709984267275*G0_0_1 + 0.135698920421142*G0_0_2 + 0.104709984267275*G0_1_0 + 0.067849460210571*G0_1_2 + 0.135698920421141*G0_2_0 + 0.067849460210570*G0_2_1 + 0.039143919352252*G0_2_2;
    A[1886] = 0.023486351611353*G0_0_0 + 0.104709984267276*G0_0_1 - 0.022507753627544*G0_0_2 + 0.104709984267276*G0_1_0 + 0.067849460210571*G0_1_2 - 0.022507753627545*G0_2_0 + 0.067849460210571*G0_2_1 - 0.156575677409009*G0_2_2;
    A[1887] = -0.542795681684568*G0_0_0 - 0.271397840842284*G0_0_1 - 0.271397840842285*G0_0_2 - 0.271397840842285*G0_1_0 - 0.135698920421142*G0_1_2 - 0.271397840842284*G0_2_0 - 0.135698920421142*G0_2_1 + 0.052191892469669*G0_2_2;
    A[1888] = -0.052844291125541*G0_0_1 - 0.037839122040511*G0_0_2 - 0.052844291125540*G0_1_0 - 0.105688582251081*G0_1_1 - 0.075678244081021*G0_1_2 - 0.037839122040510*G0_2_0 - 0.075678244081021*G0_2_1 - 0.045667905910961*G0_2_2;
    A[1889] = -0.006197787230773*G0_0_1 - 0.005545388574902*G0_0_2 - 0.006197787230774*G0_1_0 + 0.013700371773288*G0_1_1 + 0.026422145562770*G0_1_2 - 0.005545388574902*G0_2_0 + 0.026422145562770*G0_2_1 + 0.039143919352252*G0_2_2;
    A[1890] = -0.052844291125541*G0_0_1 - 0.037839122040511*G0_0_2 - 0.052844291125540*G0_1_0 - 0.053496689781412*G0_1_1 - 0.000652398655871*G0_1_2 - 0.037839122040511*G0_2_0 - 0.000652398655871*G0_2_1 + 0.052191892469669*G0_2_2;
    A[1891] = 0.104709984267275*G0_0_1 + 0.067849460210571*G0_0_2 + 0.104709984267275*G0_1_0 + 0.209419968534550*G0_1_1 + 0.135698920421141*G0_1_2 + 0.067849460210571*G0_2_0 + 0.135698920421141*G0_2_1 + 0.039143919352252*G0_2_2;
    A[1892] = 0.104709984267275*G0_0_1 + 0.067849460210571*G0_0_2 + 0.104709984267275*G0_1_0 + 0.023486351611352*G0_1_1 - 0.022507753627544*G0_1_2 + 0.067849460210571*G0_2_0 - 0.022507753627545*G0_2_1 - 0.156575677409009*G0_2_2;
    A[1893] = -0.271397840842285*G0_0_1 - 0.135698920421143*G0_0_2 - 0.271397840842283*G0_1_0 - 0.542795681684568*G0_1_1 - 0.271397840842284*G0_1_2 - 0.135698920421141*G0_2_0 - 0.271397840842284*G0_2_1 + 0.052191892469670*G0_2_2;
    A[1894] = -0.015005169085030*G0_0_1 - 0.030010338170060*G0_0_2 - 0.015005169085030*G0_1_0 - 0.030010338170060*G0_1_2 - 0.030010338170060*G0_2_0 - 0.030010338170060*G0_2_1 - 0.060020676340120*G0_2_2;
    A[1895] = -0.000652398655871*G0_0_1 - 0.001304797311742*G0_0_2 - 0.000652398655871*G0_1_0 - 0.012721773789482*G0_1_2 - 0.001304797311742*G0_2_0 - 0.012721773789482*G0_2_1 - 0.025443547578965*G0_2_2;
    A[1896] = -0.015005169085030*G0_0_1 - 0.030010338170060*G0_0_2 - 0.015005169085030*G0_1_0 - 0.052844291125540*G0_1_2 - 0.030010338170059*G0_2_0 - 0.052844291125540*G0_2_1 - 0.105688582251080*G0_2_2;
    A[1897] = -0.000652398655871*G0_0_1 - 0.012721773789482*G0_0_2 - 0.000652398655871*G0_1_0 - 0.001304797311741*G0_1_2 - 0.012721773789482*G0_2_0 - 0.001304797311742*G0_2_1 - 0.025443547578964*G0_2_2;
    A[1898] = -0.000652398655871*G0_0_1 - 0.012721773789482*G0_0_2 - 0.000652398655871*G0_1_0 - 0.012721773789482*G0_1_2 - 0.012721773789482*G0_2_0 - 0.012721773789482*G0_2_1 - 0.113517366121531*G0_2_2;
    A[1899] = -0.015005169085030*G0_0_1 - 0.052844291125541*G0_0_2 - 0.015005169085030*G0_1_0 - 0.030010338170060*G0_1_2 - 0.052844291125540*G0_2_0 - 0.030010338170060*G0_2_1 - 0.105688582251081*G0_2_2;
    A[1900] = 0.026095946234835*G0_0_1 + 0.075025845425151*G0_0_2 + 0.026095946234835*G0_1_0 + 0.075025845425150*G0_1_2 + 0.075025845425150*G0_2_0 + 0.075025845425150*G0_2_1 + 0.195719596761262*G0_2_2;
    A[1901] = 0.026095946234834*G0_0_1 + 0.075025845425151*G0_0_2 + 0.026095946234835*G0_1_0 + 0.058715879028379*G0_1_2 + 0.075025845425151*G0_2_0 + 0.058715879028380*G0_2_1 + 0.293579395141893*G0_2_2;
    A[1902] = 0.026095946234835*G0_0_1 + 0.058715879028378*G0_0_2 + 0.026095946234834*G0_1_0 + 0.075025845425150*G0_1_2 + 0.058715879028378*G0_2_0 + 0.075025845425150*G0_2_1 + 0.293579395141891*G0_2_2;
    A[1903] = -0.185933616923198*G0_0_1 - 0.316413348097374*G0_0_2 - 0.185933616923198*G0_1_0 - 0.316413348097374*G0_1_2 - 0.316413348097373*G0_2_0 - 0.316413348097374*G0_2_1 - 0.782878387045048*G0_2_2;
    A[1904] = 0.047993054720485*G0_0_0 + 0.047993054720485*G0_0_1 + 0.047993054720485*G0_0_2 + 0.033598530777350*G0_1_0 + 0.033598530777350*G0_1_1 + 0.033598530777350*G0_1_2 + 0.033598530777350*G0_2_0 + 0.033598530777350*G0_2_1 + 0.033598530777350*G0_2_2;
    A[1905] = -0.013742125287264*G0_0_0;
    A[1906] = 0.005177435732991*G0_0_1 + 0.018919561020255*G0_1_1;
    A[1907] = 0.005177435732991*G0_0_2 + 0.018919561020255*G0_2_2;
    A[1908] = -0.042536392362781*G0_0_1 - 0.011873655536850*G0_0_2 - 0.061325473651862*G0_1_1 - 0.021268196181391*G0_1_2 - 0.021268196181391*G0_2_1;
    A[1909] = -0.040318236932819*G0_0_1 - 0.054018608706108*G0_0_2 - 0.025443547578964*G0_1_1 - 0.039078679486665*G0_1_2 - 0.039078679486665*G0_2_1 - 0.052844291125540*G0_2_2;
    A[1910] = -0.054018608706108*G0_0_1 - 0.040318236932820*G0_0_2 - 0.052844291125541*G0_1_1 - 0.039078679486665*G0_1_2 - 0.039078679486665*G0_2_1 - 0.025443547578964*G0_2_2;
    A[1911] = -0.011873655536850*G0_0_1 - 0.042536392362781*G0_0_2 - 0.021268196181391*G0_1_2 - 0.021268196181390*G0_2_1 - 0.061325473651862*G0_2_2;
    A[1912] = 0.018789081289081*G0_0_0 + 0.009394540644541*G0_0_2 + 0.009394540644541*G0_2_0;
    A[1913] = -0.014874689353856*G0_0_0 - 0.014939929219443*G0_0_2 - 0.014939929219443*G0_2_0 - 0.015005169085030*G0_2_2;
    A[1914] = -0.001174317580568*G0_0_0 - 0.001239557446154*G0_0_2 - 0.001239557446154*G0_2_0 - 0.001304797311741*G0_2_2;
    A[1915] = -0.011873655536850*G0_0_0 - 0.021268196181391*G0_0_2 - 0.021268196181391*G0_2_0 - 0.030662736825931*G0_2_2;
    A[1916] = 0.018789081289081*G0_0_0 + 0.009394540644541*G0_0_1 + 0.009394540644541*G0_1_0;
    A[1917] = -0.014874689353856*G0_0_0 - 0.014939929219443*G0_0_1 - 0.014939929219444*G0_1_0 - 0.015005169085031*G0_1_1;
    A[1918] = -0.001174317580567*G0_0_0 - 0.001239557446155*G0_0_1 - 0.001239557446154*G0_1_0 - 0.001304797311741*G0_1_1;
    A[1919] = -0.011873655536850*G0_0_0 - 0.021268196181390*G0_0_1 - 0.021268196181391*G0_1_0 - 0.030662736825931*G0_1_1;
    A[1920] = -0.064456987200042*G0_0_0 - 0.064456987200042*G0_0_1 - 0.092901568596012*G0_0_2 - 0.257045070413123*G0_1_0 - 0.257045070413124*G0_1_1 - 0.160751028806583*G0_1_2 - 0.160751028806582*G0_2_0 - 0.160751028806582*G0_2_1 - 0.064456987200042*G0_2_2;
    A[1921] = 0.132306447410613*G0_0_0 + 0.132306447410613*G0_0_1 + 0.058976838490726*G0_0_2 + 0.121346149991982*G0_1_0 + 0.121346149991982*G0_1_1 + 0.194675758911868*G0_1_2 + 0.194675758911868*G0_2_0 + 0.194675758911868*G0_2_1 - 0.003392473010529*G0_2_2;
    A[1922] = -0.051017574889102*G0_0_0 - 0.051017574889102*G0_0_1 - 0.004632030456683*G0_0_2 - 0.052844291125541*G0_1_0 - 0.052844291125541*G0_1_1 - 0.088791457064026*G0_1_2 - 0.088791457064026*G0_2_0 - 0.088791457064026*G0_2_1 + 0.084681345532039*G0_2_2;
    A[1923] = 0.011873655536850*G0_0_0 + 0.011873655536850*G0_0_1 - 0.014613729891508*G0_0_2 + 0.021268196181390*G0_1_2 + 0.021268196181390*G0_2_0 + 0.021268196181390*G0_2_1 - 0.069349977119074*G0_2_2;
    A[1924] = -0.064456987200042*G0_0_0 - 0.092901568596012*G0_0_1 - 0.064456987200042*G0_0_2 - 0.160751028806583*G0_1_0 - 0.064456987200042*G0_1_1 - 0.160751028806583*G0_1_2 - 0.257045070413123*G0_2_0 - 0.160751028806583*G0_2_1 - 0.257045070413123*G0_2_2;
    A[1925] = 0.132306447410612*G0_0_0 + 0.058976838490726*G0_0_1 + 0.132306447410612*G0_0_2 + 0.194675758911868*G0_1_0 - 0.003392473010529*G0_1_1 + 0.194675758911869*G0_1_2 + 0.121346149991982*G0_2_0 + 0.194675758911868*G0_2_1 + 0.121346149991982*G0_2_2;
    A[1926] = -0.051017574889102*G0_0_0 - 0.004632030456683*G0_0_1 - 0.051017574889102*G0_0_2 - 0.088791457064026*G0_1_0 + 0.084681345532040*G0_1_1 - 0.088791457064026*G0_1_2 - 0.052844291125541*G0_2_0 - 0.088791457064025*G0_2_1 - 0.052844291125541*G0_2_2;
    A[1927] = 0.011873655536850*G0_0_0 - 0.014613729891508*G0_0_1 + 0.011873655536850*G0_0_2 + 0.021268196181391*G0_1_0 - 0.069349977119074*G0_1_1 + 0.021268196181391*G0_1_2 + 0.021268196181390*G0_2_1;
    A[1928] = -0.060673074995991*G0_0_0 - 0.032228493600021*G0_0_1 - 0.032228493600021*G0_0_2 - 0.032228493600021*G0_1_0 - 0.128522535206562*G0_1_1 - 0.128522535206562*G0_1_2 - 0.032228493600021*G0_2_0 - 0.128522535206562*G0_2_1 - 0.128522535206561*G0_2_2;
    A[1929] = 0.047625101878574*G0_0_0 - 0.014744209622682*G0_0_1 - 0.014744209622682*G0_0_2 - 0.014744209622682*G0_1_0 + 0.047625101878573*G0_1_1 + 0.047625101878573*G0_1_2 - 0.014744209622682*G0_2_0 + 0.047625101878573*G0_2_1 + 0.047625101878573*G0_2_2;
    A[1930] = -0.066544662898829*G0_0_0 + 0.022768713089893*G0_0_1 + 0.022768713089893*G0_0_2 + 0.022768713089893*G0_1_0 - 0.015005169085030*G0_1_1 - 0.015005169085030*G0_1_2 + 0.022768713089894*G0_2_0 - 0.015005169085030*G0_2_1 - 0.015005169085030*G0_2_2;
    A[1931] = 0.045341706583026*G0_0_0 - 0.009394540644541*G0_0_1 - 0.009394540644541*G0_0_2 - 0.009394540644541*G0_1_0 - 0.009394540644541*G0_2_0;
    A[1932] = -0.060020676340121*G0_0_0 - 0.030010338170060*G0_0_1 - 0.030010338170060*G0_0_2 - 0.030010338170060*G0_1_0 - 0.015005169085030*G0_1_2 - 0.030010338170060*G0_2_0 - 0.015005169085030*G0_2_1;
    A[1933] = -0.025443547578964*G0_0_0 - 0.024138750267222*G0_0_1 - 0.012721773789482*G0_0_2 - 0.024138750267222*G0_1_0 - 0.022833952955481*G0_1_1 - 0.012069375133611*G0_1_2 - 0.012721773789482*G0_2_0 - 0.012069375133611*G0_2_1;
    A[1934] = -0.105688582251081*G0_0_0 - 0.075678244081021*G0_0_1 - 0.052844291125541*G0_0_2 - 0.075678244081021*G0_1_0 - 0.045667905910961*G0_1_1 - 0.037839122040511*G0_1_2 - 0.052844291125541*G0_2_0 - 0.037839122040511*G0_2_1;
    A[1935] = -0.025443547578964*G0_0_0 - 0.012721773789482*G0_0_1 - 0.024138750267223*G0_0_2 - 0.012721773789481*G0_1_0 - 0.012069375133611*G0_1_2 - 0.024138750267221*G0_2_0 - 0.012069375133611*G0_2_1 - 0.022833952955480*G0_2_2;
    A[1936] = -0.113517366121531*G0_0_0 - 0.100795592332049*G0_0_1 - 0.100795592332049*G0_0_2 - 0.100795592332049*G0_1_0 - 0.088073818542567*G0_1_1 - 0.088726217198438*G0_1_2 - 0.100795592332049*G0_2_0 - 0.088726217198438*G0_2_1 - 0.088073818542566*G0_2_2;
    A[1937] = -0.105688582251082*G0_0_0 - 0.052844291125541*G0_0_1 - 0.075678244081021*G0_0_2 - 0.052844291125541*G0_1_0 - 0.037839122040511*G0_1_2 - 0.075678244081022*G0_2_0 - 0.037839122040511*G0_2_1 - 0.045667905910961*G0_2_2;
    A[1938] = 0.647179466623905*G0_0_0 + 0.375781625781622*G0_0_1 + 0.375781625781622*G0_0_2 + 0.375781625781622*G0_1_0 + 0.647179466623906*G0_1_1 + 0.375781625781622*G0_1_2 + 0.375781625781622*G0_2_0 + 0.375781625781622*G0_2_1 + 0.647179466623905*G0_2_2;
    A[1939] = -0.268135847562928*G0_0_0 - 0.448850275239160*G0_0_1 - 0.290643601190472*G0_0_2 - 0.194414799449519*G0_1_0 - 0.584549195660302*G0_1_1 - 0.321632537344339*G0_1_2 - 0.222141742324032*G0_2_0 - 0.321632537344341*G0_2_1 - 0.268135847562928*G0_2_2;
    A[1940] = 0.105688582251081*G0_0_0 + 0.180062029020361*G0_0_1 + 0.105036183595210*G0_0_2 + 0.075678244081021*G0_1_0 + 0.255740273101383*G0_1_1 + 0.127870136550691*G0_1_2 + 0.052844291125541*G0_2_0 + 0.127870136550692*G0_2_1 + 0.105688582251081*G0_2_2;
    A[1941] = -0.268135847562928*G0_0_0 - 0.290643601190473*G0_0_1 - 0.448850275239161*G0_0_2 - 0.222141742324031*G0_1_0 - 0.268135847562928*G0_1_1 - 0.321632537344340*G0_1_2 - 0.194414799449519*G0_2_0 - 0.321632537344339*G0_2_1 - 0.584549195660302*G0_2_2;
    A[1942] = 0.113517366121531*G0_0_0 + 0.198655390712679*G0_0_1 + 0.198655390712680*G0_0_2 + 0.100795592332049*G0_1_0 + 0.172233245149910*G0_1_1 + 0.166035457919136*G0_1_2 + 0.100795592332049*G0_2_0 + 0.166035457919136*G0_2_1 + 0.172233245149910*G0_2_2;
    A[1943] = 0.105688582251082*G0_0_0 + 0.105036183595211*G0_0_1 + 0.180062029020361*G0_0_2 + 0.052844291125541*G0_1_0 + 0.105688582251082*G0_1_1 + 0.127870136550692*G0_1_2 + 0.075678244081022*G0_2_0 + 0.127870136550691*G0_2_1 + 0.255740273101382*G0_2_2;
    A[1944] = 0.052191892469669*G0_0_0 + 0.323589733311953*G0_0_1 + 0.187890812890811*G0_0_2 + 0.323589733311952*G0_1_0 + 0.052191892469669*G0_1_1 + 0.187890812890811*G0_1_2 + 0.187890812890810*G0_2_0 + 0.187890812890810*G0_2_1 + 0.323589733311952*G0_2_2;
    A[1945] = 0.039143919352252*G0_0_0 - 0.096555001068890*G0_0_1 - 0.028705540858318*G0_0_2 - 0.096555001068889*G0_1_0 - 0.022833952955481*G0_1_1 - 0.059694477012185*G0_1_2 - 0.028705540858318*G0_2_0 - 0.059694477012185*G0_2_1 - 0.096555001068889*G0_2_2;
    A[1946] = -0.045667905910961*G0_0_0 + 0.030010338170060*G0_0_1 - 0.007828783870450*G0_0_2 + 0.030010338170060*G0_1_0 + 0.015005169085030*G0_1_2 - 0.007828783870451*G0_2_0 + 0.015005169085030*G0_2_1 + 0.030010338170060*G0_2_2;
    A[1947] = -0.156575677409009*G0_0_0 - 0.134067923781464*G0_0_1 - 0.224425137619581*G0_0_2 - 0.134067923781464*G0_1_0 - 0.088073818542567*G0_1_1 - 0.097207399724760*G0_1_2 - 0.224425137619579*G0_2_0 - 0.097207399724759*G0_2_1 - 0.292274597830151*G0_2_2;
    A[1948] = 0.039143919352252*G0_0_0 + 0.012721773789482*G0_0_1 + 0.044689307927155*G0_0_2 + 0.012721773789482*G0_1_0 + 0.012069375133611*G0_1_2 + 0.044689307927155*G0_2_0 + 0.012069375133611*G0_2_1 + 0.050234696502057*G0_2_2;
    A[1949] = 0.052191892469670*G0_0_0 + 0.052844291125541*G0_0_1 + 0.090031014510181*G0_0_2 + 0.052844291125541*G0_1_0 + 0.037839122040511*G0_1_2 + 0.090031014510180*G0_2_0 + 0.037839122040511*G0_2_1 + 0.127870136550691*G0_2_2;
    A[1950] = 0.052191892469669*G0_0_0 + 0.187890812890811*G0_0_1 + 0.323589733311952*G0_0_2 + 0.187890812890811*G0_1_0 + 0.323589733311953*G0_1_1 + 0.187890812890811*G0_1_2 + 0.323589733311952*G0_2_0 + 0.187890812890811*G0_2_1 + 0.052191892469669*G0_2_2;
    A[1951] = 0.039143919352253*G0_0_0 - 0.028705540858319*G0_0_1 - 0.096555001068890*G0_0_2 - 0.028705540858318*G0_1_0 - 0.096555001068889*G0_1_1 - 0.059694477012185*G0_1_2 - 0.096555001068889*G0_2_0 - 0.059694477012184*G0_2_1 - 0.022833952955480*G0_2_2;
    A[1952] = -0.045667905910961*G0_0_0 - 0.007828783870451*G0_0_1 + 0.030010338170060*G0_0_2 - 0.007828783870451*G0_1_0 + 0.030010338170060*G0_1_1 + 0.015005169085029*G0_1_2 + 0.030010338170059*G0_2_0 + 0.015005169085030*G0_2_1;
    A[1953] = -0.156575677409009*G0_0_0 - 0.224425137619580*G0_0_1 - 0.134067923781464*G0_0_2 - 0.224425137619580*G0_1_0 - 0.292274597830151*G0_1_1 - 0.097207399724760*G0_1_2 - 0.134067923781463*G0_2_0 - 0.097207399724760*G0_2_1 - 0.088073818542568*G0_2_2;
    A[1954] = 0.039143919352253*G0_0_0 + 0.044689307927156*G0_0_1 + 0.012721773789482*G0_0_2 + 0.044689307927155*G0_1_0 + 0.050234696502057*G0_1_1 + 0.012069375133612*G0_1_2 + 0.012721773789482*G0_2_0 + 0.012069375133611*G0_2_1;
    A[1955] = 0.052191892469670*G0_0_0 + 0.090031014510180*G0_0_1 + 0.052844291125540*G0_0_2 + 0.090031014510180*G0_1_0 + 0.127870136550691*G0_1_1 + 0.037839122040510*G0_1_2 + 0.052844291125540*G0_2_0 + 0.037839122040511*G0_2_1;
    A[1956] = -0.782878387045047*G0_0_0 - 0.466465038947673*G0_0_1 - 0.466465038947672*G0_0_2 - 0.466465038947673*G0_1_0 - 0.150051690850299*G0_1_1 - 0.335985307773498*G0_1_2 - 0.466465038947673*G0_2_0 - 0.335985307773498*G0_2_1 - 0.150051690850299*G0_2_2;
    A[1957] = 0.195719596761263*G0_0_0 + 0.120693751336112*G0_0_1 + 0.120693751336112*G0_0_2 + 0.120693751336111*G0_1_0 + 0.045667905910961*G0_1_1 + 0.071763852145795*G0_1_2 + 0.120693751336111*G0_2_0 + 0.071763852145796*G0_2_1 + 0.045667905910961*G0_2_2;
    A[1958] = 0.293579395141891*G0_0_0 + 0.218553549716741*G0_0_1 + 0.234863516113514*G0_0_2 + 0.218553549716741*G0_1_0 + 0.143527704291590*G0_1_1 + 0.185933616923199*G0_1_2 + 0.234863516113513*G0_2_0 + 0.185933616923198*G0_2_1 + 0.176147637085135*G0_2_2;
    A[1959] = 0.293579395141891*G0_0_0 + 0.234863516113513*G0_0_1 + 0.218553549716741*G0_0_2 + 0.234863516113512*G0_1_0 + 0.176147637085135*G0_1_1 + 0.185933616923197*G0_1_2 + 0.218553549716740*G0_2_0 + 0.185933616923197*G0_2_1 + 0.143527704291590*G0_2_2;
    A[1960] = -0.034571909571909*G0_0_0 - 0.034571909571909*G0_0_1 - 0.034571909571909*G0_0_2 - 0.029847238506092*G0_1_0 - 0.029847238506092*G0_1_1 - 0.029847238506092*G0_1_2 - 0.029847238506092*G0_2_0 - 0.029847238506092*G0_2_1 - 0.029847238506092*G0_2_2;
    A[1961] = -0.009464999699375*G0_0_0;
    A[1962] = 0.004724671065817*G0_0_1 - 0.029847238506092*G0_1_1;
    A[1963] = 0.002278176106301*G0_0_2 + 0.011743175805676*G0_2_2;
    A[1964] = 0.084550865800865*G0_0_1 + 0.042960451489097*G0_0_2 + 0.128522535206562*G0_1_1 + 0.042275432900433*G0_1_2 + 0.042275432900433*G0_2_1;
    A[1965] = 0.080832193462401*G0_0_1 + 0.108232937008977*G0_0_2 + 0.037186723384640*G0_1_1 + 0.074340826836485*G0_1_2 + 0.074340826836485*G0_2_1 + 0.104709984267274*G0_2_2;
    A[1966] = 0.009394540644540*G0_0_1 + 0.037773882174924*G0_0_2 - 0.006197787230773*G0_1_1 + 0.018886941087462*G0_1_2 + 0.018886941087461*G0_2_1 + 0.056758683060766*G0_2_2;
    A[1967] = -0.002544354757896*G0_0_1 - 0.014287530563572*G0_0_2 - 0.005838967970044*G0_1_2 - 0.005838967970044*G0_2_1 - 0.043547610279381*G0_2_2;
    A[1968] = 0.006589226424296*G0_0_0 + 0.003294613212148*G0_0_2 + 0.003294613212148*G0_2_0;
    A[1969] = 0.004501550725509*G0_0_0 + 0.001924576034819*G0_0_2 + 0.001924576034819*G0_2_0 - 0.000652398655871*G0_2_2;
    A[1970] = -0.010503618359521*G0_0_0 - 0.013080593050211*G0_0_2 - 0.013080593050211*G0_2_0 - 0.015657567740901*G0_2_2;
    A[1971] = -0.002544354757896*G0_0_0 - 0.005838967970044*G0_0_2 - 0.005838967970044*G0_2_0 - 0.009133581182192*G0_2_2;
    A[1972] = 0.029260079715809*G0_0_0 + 0.003294613212148*G0_0_1 + 0.003294613212147*G0_1_0;
    A[1973] = -0.018984800885842*G0_0_0 - 0.009492400442921*G0_0_1 - 0.009492400442920*G0_1_0 - 0.000652398655870*G0_1_1;
    A[1974] = 0.003522952741703*G0_0_0 + 0.006491366625915*G0_0_1 + 0.006491366625914*G0_1_0 + 0.008807381854256*G0_1_1;
    A[1975] = 0.042960451489097*G0_0_0 + 0.042275432900433*G0_0_1 + 0.042275432900434*G0_1_0 + 0.064261267603281*G0_1_1;
    A[1976] = 0.043971669405696*G0_0_0 + 0.043971669405697*G0_0_1 + 0.044656687994361*G0_0_2 + 0.128522535206562*G0_1_0 + 0.128522535206562*G0_1_1 + 0.086247102306129*G0_1_2 + 0.086247102306129*G0_2_0 + 0.086247102306129*G0_2_1 + 0.043971669405696*G0_2_2;
    A[1977] = -0.043645470077761*G0_0_0 - 0.043645470077761*G0_0_1 - 0.009753359905270*G0_0_2 + 0.037186723384640*G0_1_0 + 0.037186723384640*G0_1_1 - 0.037154103451846*G0_1_2 - 0.037154103451846*G0_2_0 - 0.037154103451846*G0_2_1 - 0.006784946021057*G0_2_2;
    A[1978] = -0.015592327875314*G0_0_0 - 0.015592327875314*G0_0_1 + 0.003294613212148*G0_0_2 - 0.006197787230773*G0_1_0 - 0.006197787230773*G0_1_1 - 0.025084728318235*G0_1_2 - 0.025084728318235*G0_2_0 - 0.025084728318235*G0_2_1 + 0.012787013655069*G0_2_2;
    A[1979] = 0.002544354757896*G0_0_0 + 0.002544354757896*G0_0_1 - 0.005904207835632*G0_0_2 + 0.005838967970044*G0_1_2 + 0.005838967970044*G0_2_0 + 0.005838967970044*G0_2_1 - 0.031869674339292*G0_2_2;
    A[1980] = 0.127315597693200*G0_0_0 + 0.128000616281865*G0_0_1 + 0.127315597693200*G0_0_2 + 0.134361503176606*G0_1_0 + 0.092086070276173*G0_1_1 + 0.134361503176606*G0_1_2 + 0.176636936077038*G0_2_0 + 0.134361503176606*G0_2_1 + 0.176636936077038*G0_2_2;
    A[1981] = -0.166948816037356*G0_0_0 - 0.160783648739376*G0_0_1 - 0.166948816037356*G0_0_2 - 0.250814663249557*G0_1_0 - 0.062238831770081*G0_1_1 - 0.250814663249557*G0_1_2 - 0.334680510461757*G0_2_0 - 0.250814663249557*G0_2_1 - 0.334680510461757*G0_2_2;
    A[1982] = 0.182410664181496*G0_0_0 + 0.098544816969295*G0_0_1 + 0.182410664181496*G0_0_2 + 0.188575831479476*G0_1_0 - 0.062238831770082*G0_1_1 + 0.188575831479476*G0_1_2 + 0.104709984267275*G0_2_0 + 0.188575831479476*G0_2_1 + 0.104709984267275*G0_2_2;
    A[1983] = -0.042960451489097*G0_0_0 - 0.035914546005692*G0_0_1 - 0.042960451489097*G0_0_2 - 0.042275432900433*G0_1_0 + 0.092086070276174*G0_1_1 - 0.042275432900434*G0_1_2 - 0.042275432900433*G0_2_1;
    A[1984] = 0.022670853291513*G0_0_0 + 0.021985834702848*G0_0_1 + 0.021985834702848*G0_0_2 + 0.021985834702848*G0_1_0 + 0.064261267603281*G0_1_1 + 0.064261267603281*G0_1_2 + 0.021985834702848*G0_2_0 + 0.064261267603281*G0_2_1 + 0.064261267603281*G0_2_2;
    A[1985] = -0.000652398655871*G0_0_0 + 0.002316015228342*G0_0_1 + 0.002316015228342*G0_0_2 + 0.002316015228342*G0_1_0 + 0.008807381854257*G0_1_1 + 0.008807381854257*G0_1_2 + 0.002316015228342*G0_2_0 + 0.008807381854257*G0_2_1 + 0.008807381854257*G0_2_2;
    A[1986] = -0.000652398655871*G0_0_0 + 0.008840001787050*G0_0_1 + 0.008840001787050*G0_0_2 + 0.008840001787050*G0_1_0 - 0.000652398655871*G0_1_1 - 0.000652398655871*G0_1_2 + 0.008840001787050*G0_2_0 - 0.000652398655871*G0_2_1 - 0.000652398655871*G0_2_2;
    A[1987] = 0.022670853291513*G0_0_0 - 0.003294613212148*G0_0_1 - 0.003294613212148*G0_0_2 - 0.003294613212148*G0_1_0 - 0.003294613212148*G0_2_0;
    A[1988] = -0.025443547578964*G0_0_0 - 0.001304797311742*G0_0_1 - 0.012721773789482*G0_0_2 - 0.001304797311741*G0_1_0 - 0.000652398655871*G0_1_2 - 0.012721773789483*G0_2_0 - 0.000652398655872*G0_2_1;
    A[1989] = 0.056758683060766*G0_0_0 + 0.028379341530384*G0_0_1 + 0.028379341530384*G0_0_2 + 0.028379341530382*G0_1_0 - 0.004892989919031*G0_1_1 + 0.014189670765192*G0_1_2 + 0.028379341530383*G0_2_0 + 0.014189670765192*G0_2_1;
    A[1990] = 0.209419968534549*G0_0_0 + 0.135698920421141*G0_0_1 + 0.104709984267275*G0_0_2 + 0.135698920421142*G0_1_0 + 0.039143919352252*G0_1_1 + 0.067849460210570*G0_1_2 + 0.104709984267274*G0_2_0 + 0.067849460210570*G0_2_1;
    A[1991] = -0.016636165724707*G0_0_0 - 0.018104062700417*G0_0_1 + 0.001467896975710*G0_0_2 - 0.018104062700418*G0_1_0 - 0.010275278829967*G0_1_2 + 0.001467896975710*G0_2_0 - 0.010275278829966*G0_2_1 + 0.019571959676126*G0_2_2;
    A[1992] = 0.149725491522365*G0_0_0 + 0.074862745761182*G0_0_1 + 0.121346149991981*G0_0_2 + 0.074862745761182*G0_1_0 + 0.019571959676125*G0_1_1 + 0.060673074995990*G0_1_2 + 0.121346149991981*G0_2_0 + 0.060673074995991*G0_2_1 + 0.092966808461599*G0_2_2;
    A[1993] = 0.013700371773289*G0_0_0 - 0.006197787230772*G0_0_1 + 0.026422145562771*G0_0_2 - 0.006197787230772*G0_1_0 - 0.005545388574902*G0_1_2 + 0.026422145562770*G0_2_0 - 0.005545388574902*G0_2_1 + 0.039143919352252*G0_2_2;
    A[1994] = -0.268135847562928*G0_0_0 - 0.194414799449519*G0_0_1 - 0.222141742324032*G0_0_2 - 0.448850275239160*G0_1_0 - 0.584549195660302*G0_1_1 - 0.321632537344341*G0_1_2 - 0.290643601190472*G0_2_0 - 0.321632537344339*G0_2_1 - 0.268135847562928*G0_2_2;
    A[1995] = 0.726119703984281*G0_0_0 + 0.456026660453739*G0_0_1 + 0.456026660453739*G0_0_2 + 0.456026660453739*G0_1_0 + 0.912053320907480*G0_1_1 + 0.456026660453739*G0_1_2 + 0.456026660453739*G0_2_0 + 0.456026660453739*G0_2_1 + 0.726119703984280*G0_2_2;
    A[1996] = -0.209419968534549*G0_0_0 - 0.390134396210782*G0_0_1 - 0.290643601190473*G0_0_2 - 0.135698920421142*G0_1_0 - 0.584549195660303*G0_1_1 - 0.262916658315962*G0_1_2 - 0.104709984267275*G0_2_0 - 0.262916658315962*G0_2_1 - 0.209419968534549*G0_2_2;
    A[1997] = 0.065566064915022*G0_0_0 + 0.140428810676205*G0_0_1 + 0.037676022376543*G0_0_2 + 0.037676022376542*G0_1_0 - 0.037186723384640*G0_1_1 + 0.186912214907006*G0_1_2 + 0.140428810676204*G0_2_0 + 0.186912214907004*G0_2_1 - 0.037186723384640*G0_2_2;
    A[1998] = -0.149725491522365*G0_0_0 - 0.177615534060844*G0_0_1 - 0.326851726591307*G0_0_2 - 0.074862745761182*G0_1_0 - 0.037186723384639*G0_1_1 - 0.224098938291645*G0_1_2 - 0.121346149991981*G0_2_0 - 0.224098938291644*G0_2_1 - 0.448197876583289*G0_2_2;
    A[1999] = -0.013700371773289*G0_0_0 + 0.006197787230773*G0_0_1 + 0.071437652817860*G0_0_2 + 0.006197787230772*G0_1_0 + 0.012395574461546*G0_1_1 + 0.006197787230773*G0_1_2 - 0.026422145562770*G0_2_0 + 0.006197787230773*G0_2_1 + 0.172233245149911*G0_2_2;
    A[2000] = -0.022833952955480*G0_0_0 - 0.096555001068888*G0_0_1 - 0.059694477012184*G0_0_2 - 0.096555001068889*G0_1_0 + 0.039143919352253*G0_1_1 - 0.028705540858319*G0_1_2 - 0.059694477012184*G0_2_0 - 0.028705540858317*G0_2_1 - 0.096555001068888*G0_2_2;
    A[2001] = -0.004892989919032*G0_0_0 - 0.033272331449415*G0_0_1 - 0.019082660684223*G0_0_2 - 0.033272331449415*G0_1_0 - 0.004892989919031*G0_1_1 - 0.019082660684223*G0_1_2 - 0.019082660684224*G0_2_0 - 0.019082660684223*G0_2_1 - 0.033272331449415*G0_2_2;
    A[2002] = -0.022833952955480*G0_0_0 + 0.001304797311742*G0_0_1 - 0.010764577821869*G0_0_2 + 0.001304797311742*G0_1_0 + 0.000652398655871*G0_1_2 - 0.010764577821869*G0_2_0 + 0.000652398655872*G0_2_1 + 0.001304797311742*G0_2_2;
    A[2003] = 0.019571959676126*G0_0_0 - 0.055290786085056*G0_0_1 + 0.005382288910935*G0_0_2 - 0.055290786085056*G0_1_0 + 0.019571959676126*G0_1_1 - 0.041101115319864*G0_1_2 + 0.005382288910935*G0_2_0 - 0.041101115319865*G0_2_1 - 0.008807381854257*G0_2_2;
    A[2004] = 0.019571959676126*G0_0_0 + 0.018104062700416*G0_0_1 + 0.029847238506092*G0_0_2 + 0.018104062700416*G0_1_0 + 0.010275278829966*G0_1_2 + 0.029847238506092*G0_2_0 + 0.010275278829966*G0_2_1 + 0.040122517336058*G0_2_2;
    A[2005] = 0.026095946234834*G0_0_0 + 0.006197787230773*G0_0_1 + 0.038165321368446*G0_0_2 + 0.006197787230773*G0_1_0 + 0.005545388574902*G0_1_2 + 0.038165321368446*G0_2_0 + 0.005545388574903*G0_2_1 + 0.050234696502058*G0_2_2;
    A[2006] = -0.088073818542567*G0_0_0 - 0.097207399724759*G0_0_1 - 0.134067923781463*G0_0_2 - 0.097207399724760*G0_1_0 - 0.292274597830151*G0_1_1 - 0.224425137619579*G0_1_2 - 0.134067923781464*G0_2_0 - 0.224425137619579*G0_2_1 - 0.156575677409008*G0_2_2;
    A[2007] = 0.019571959676126*G0_0_0 - 0.041101115319865*G0_0_1 - 0.055290786085057*G0_0_2 - 0.041101115319865*G0_1_0 - 0.008807381854257*G0_1_1 + 0.005382288910935*G0_1_2 - 0.055290786085057*G0_2_0 + 0.005382288910934*G0_2_1 + 0.019571959676125*G0_2_2;
    A[2008] = -0.088073818542567*G0_0_0 + 0.000652398655871*G0_0_1 + 0.012721773789482*G0_0_2 + 0.000652398655872*G0_1_0 + 0.001304797311741*G0_1_1 + 0.000652398655872*G0_1_2 + 0.012721773789483*G0_2_0 + 0.000652398655871*G0_2_1;
    A[2009] = 0.092966808461599*G0_0_0 + 0.228013330226870*G0_0_1 + 0.363059851992140*G0_0_2 + 0.228013330226870*G0_1_0 + 0.456026660453741*G0_1_1 + 0.228013330226870*G0_1_2 + 0.363059851992140*G0_2_0 + 0.228013330226870*G0_2_1 + 0.092966808461599*G0_2_2;
    A[2010] = 0.092966808461599*G0_0_0 + 0.032293733465608*G0_0_1 - 0.028379341530383*G0_0_2 + 0.032293733465607*G0_1_0 - 0.008807381854256*G0_1_1 - 0.014189670765192*G0_1_2 - 0.028379341530383*G0_2_0 - 0.014189670765191*G0_2_1;
    A[2011] = -0.185933616923198*G0_0_0 - 0.195067198105391*G0_0_1 - 0.104709984267275*G0_0_2 - 0.195067198105390*G0_1_0 - 0.292274597830151*G0_1_1 - 0.067849460210570*G0_1_2 - 0.104709984267275*G0_2_0 - 0.067849460210571*G0_2_1;
    A[2012] = 0.146789697570945*G0_0_0 + 0.445262082631869*G0_0_1 + 0.249542485870607*G0_0_2 + 0.445262082631870*G0_1_0 - 0.039143919352255*G0_1_1 + 0.249542485870607*G0_1_2 + 0.249542485870607*G0_2_0 + 0.249542485870607*G0_2_1 + 0.352295274170270*G0_2_2;
    A[2013] = 0.146789697570946*G0_0_0 + 0.004892989919031*G0_0_1 + 0.053822889109347*G0_0_2 + 0.004892989919031*G0_1_0 + 0.009785979838062*G0_1_1 + 0.004892989919031*G0_1_2 + 0.053822889109348*G0_2_0 + 0.004892989919032*G0_2_1 - 0.039143919352252*G0_2_2;
    A[2014] = -0.782878387045046*G0_0_0 - 0.484406001984121*G0_0_1 - 0.484406001984121*G0_0_2 - 0.484406001984121*G0_1_0 - 0.039143919352249*G0_1_1 - 0.288686405222861*G0_1_2 - 0.484406001984122*G0_2_0 - 0.288686405222860*G0_2_1 - 0.185933616923198*G0_2_2;
    A[2015] = -0.048929899190315*G0_0_0 - 0.019571959676126*G0_0_1 - 0.141896707651914*G0_0_2 - 0.019571959676124*G0_1_0 - 0.039143919352252*G0_1_1 - 0.019571959676125*G0_1_2 - 0.141896707651914*G0_2_0 - 0.019571959676126*G0_2_1 - 0.234863516113514*G0_2_2;
    A[2016] = 0.013742125287264*G0_0_0 + 0.013742125287264*G0_0_1 + 0.013742125287264*G0_0_2 + 0.018919561020255*G0_1_0 + 0.018919561020255*G0_1_1 + 0.018919561020255*G0_1_2 + 0.018919561020255*G0_2_0 + 0.018919561020255*G0_2_1 + 0.018919561020255*G0_2_2;
    A[2017] = -0.013742125287264*G0_0_0;
    A[2018] = -0.014394523943135*G0_0_1 + 0.033598530777350*G0_1_1;
    A[2019] = 0.005177435732991*G0_0_2 + 0.018919561020255*G0_2_2;
    A[2020] = -0.192588083213082*G0_0_1 - 0.124738623002511*G0_0_2 - 0.257045070413124*G0_1_1 - 0.096294041606541*G0_1_2 - 0.096294041606541*G0_2_1;
    A[2021] = -0.010960297418630*G0_0_1 - 0.146659217839772*G0_0_2 + 0.121346149991982*G0_1_1 - 0.073329608919885*G0_1_2 - 0.073329608919886*G0_2_1 - 0.271397840842282*G0_2_2;
    A[2022] = -0.001826716236439*G0_0_1 + 0.082332710370904*G0_0_2 - 0.052844291125541*G0_1_1 + 0.035947165938484*G0_1_2 + 0.035947165938485*G0_2_1 + 0.209419968534550*G0_2_2;
    A[2023] = -0.011873655536850*G0_0_1 - 0.047755581609748*G0_0_2 - 0.021268196181390*G0_1_2 - 0.021268196181390*G0_2_1 - 0.111886369481854*G0_2_2;
    A[2024] = 0.018789081289081*G0_0_0 + 0.009394540644540*G0_0_2 + 0.009394540644541*G0_2_0;
    A[2025] = -0.014874689353856*G0_0_0 - 0.014939929219443*G0_0_2 - 0.014939929219443*G0_2_0 - 0.015005169085030*G0_2_2;
    A[2026] = -0.001174317580568*G0_0_0 - 0.001239557446155*G0_0_2 - 0.001239557446155*G0_2_0 - 0.001304797311742*G0_2_2;
    A[2027] = -0.011873655536850*G0_0_0 - 0.021268196181390*G0_0_2 - 0.021268196181390*G0_2_0 - 0.030662736825931*G0_2_2;
    A[2028] = 0.064130787872107*G0_0_0 + 0.009394540644541*G0_0_1 + 0.009394540644541*G0_1_0;
    A[2029] = -0.127087258163646*G0_0_0 - 0.037773882174924*G0_0_1 - 0.037773882174924*G0_1_0 - 0.015005169085030*G0_1_1;
    A[2030] = 0.124738623002511*G0_0_0 + 0.062369311501255*G0_0_1 + 0.062369311501256*G0_1_0 + 0.047625101878574*G0_1_1;
    A[2031] = -0.124738623002511*G0_0_0 - 0.096294041606541*G0_0_1 - 0.096294041606542*G0_1_0 - 0.128522535206562*G0_1_1;
    A[2032] = -0.018789081289081*G0_0_0 - 0.018789081289081*G0_0_1 - 0.009394540644541*G0_0_2 - 0.061325473651862*G0_1_0 - 0.061325473651862*G0_1_1 - 0.040057277470472*G0_1_2 - 0.040057277470471*G0_2_0 - 0.040057277470471*G0_2_1 - 0.018789081289081*G0_2_2;
    A[2033] = 0.014874689353856*G0_0_0 + 0.014874689353856*G0_0_1 - 0.000065239865587*G0_0_2 - 0.025443547578964*G0_1_0 - 0.025443547578964*G0_1_1 + 0.013635131907701*G0_1_2 + 0.013635131907701*G0_2_0 + 0.013635131907701*G0_2_1 - 0.000130479731174*G0_2_2;
    A[2034] = 0.001174317580568*G0_0_0 + 0.001174317580568*G0_0_1 - 0.000065239865587*G0_0_2 - 0.052844291125541*G0_1_0 - 0.052844291125541*G0_1_1 - 0.013765611638876*G0_1_2 - 0.013765611638875*G0_2_0 - 0.013765611638875*G0_2_1 - 0.000130479731174*G0_2_2;
    A[2035] = 0.011873655536850*G0_0_0 + 0.011873655536850*G0_0_1 - 0.009394540644541*G0_0_2 + 0.021268196181391*G0_1_2 + 0.021268196181390*G0_2_0 + 0.021268196181390*G0_2_1 - 0.018789081289081*G0_2_2;
    A[2036] = -0.064130787872107*G0_0_0 - 0.054736247227566*G0_0_1 - 0.064130787872107*G0_0_2 - 0.090618173300464*G0_1_0 - 0.069349977119074*G0_1_1 - 0.090618173300464*G0_1_2 - 0.111886369481854*G0_2_0 - 0.090618173300464*G0_2_1 - 0.111886369481854*G0_2_2;
    A[2037] = 0.127087258163646*G0_0_0 + 0.089313375988722*G0_0_1 + 0.127087258163646*G0_0_2 + 0.173472802596065*G0_1_0 + 0.084681345532039*G0_1_1 + 0.173472802596065*G0_1_2 + 0.209419968534550*G0_2_0 + 0.173472802596065*G0_2_1 + 0.209419968534550*G0_2_2;
    A[2038] = -0.124738623002511*G0_0_0 - 0.062369311501255*G0_0_1 - 0.124738623002511*G0_0_2 - 0.198068231922397*G0_1_0 - 0.003392473010528*G0_1_1 - 0.198068231922398*G0_1_2 - 0.271397840842283*G0_2_0 - 0.198068231922397*G0_2_1 - 0.271397840842283*G0_2_2;
    A[2039] = 0.124738623002511*G0_0_0 + 0.028444581395970*G0_0_1 + 0.124738623002511*G0_0_2 + 0.096294041606542*G0_1_0 - 0.064456987200042*G0_1_1 + 0.096294041606542*G0_1_2 + 0.096294041606541*G0_2_1;
    A[2040] = -0.009394540644541*G0_0_1 - 0.009394540644541*G0_0_2 - 0.009394540644541*G0_1_0 - 0.030662736825931*G0_1_1 - 0.030662736825931*G0_1_2 - 0.009394540644541*G0_2_0 - 0.030662736825931*G0_2_1 - 0.030662736825931*G0_2_2;
    A[2041] = -0.000065239865587*G0_0_1 - 0.000065239865587*G0_0_2 - 0.000065239865587*G0_1_0 - 0.001304797311742*G0_1_1 - 0.001304797311742*G0_1_2 - 0.000065239865587*G0_2_0 - 0.001304797311742*G0_2_1 - 0.001304797311742*G0_2_2;
    A[2042] = -0.000065239865587*G0_0_1 - 0.000065239865587*G0_0_2 - 0.000065239865587*G0_1_0 - 0.015005169085030*G0_1_1 - 0.015005169085030*G0_1_2 - 0.000065239865587*G0_2_0 - 0.015005169085030*G0_2_1 - 0.015005169085030*G0_2_2;
    A[2043] = -0.009394540644540*G0_0_1 - 0.009394540644540*G0_0_2 - 0.009394540644540*G0_1_0 - 0.009394540644541*G0_2_0;
    A[2044] = -0.105688582251081*G0_0_0 - 0.030010338170060*G0_0_1 - 0.052844291125540*G0_0_2 - 0.030010338170061*G0_1_0 - 0.015005169085029*G0_1_2 - 0.052844291125541*G0_2_0 - 0.015005169085030*G0_2_1;
    A[2045] = 0.209419968534550*G0_0_0 + 0.073721048113408*G0_0_1 + 0.104709984267274*G0_0_2 + 0.073721048113409*G0_1_0 - 0.022833952955481*G0_1_1 + 0.036860524056704*G0_1_2 + 0.104709984267274*G0_2_0 + 0.036860524056703*G0_2_1;
    A[2046] = -0.542795681684566*G0_0_0 - 0.271397840842282*G0_0_1 - 0.271397840842283*G0_0_2 - 0.271397840842283*G0_1_0 + 0.052191892469670*G0_1_1 - 0.135698920421141*G0_1_2 - 0.271397840842282*G0_2_0 - 0.135698920421141*G0_2_1;
    A[2047] = 0.013700371773288*G0_0_0 - 0.012721773789482*G0_0_1 + 0.019898159004061*G0_0_2 - 0.012721773789481*G0_1_0 - 0.012069375133611*G0_1_2 + 0.019898159004061*G0_2_0 - 0.012069375133611*G0_2_1 + 0.026095946234835*G0_2_2;
    A[2048] = 0.023486351611352*G0_0_0 + 0.045994105238896*G0_0_1 - 0.081223632655922*G0_0_2 + 0.045994105238897*G0_1_0 - 0.088073818542567*G0_1_1 + 0.009133581182193*G0_1_2 - 0.081223632655923*G0_2_0 + 0.009133581182192*G0_2_1 - 0.185933616923197*G0_2_2;
    A[2049] = -0.053496689781412*G0_0_0 - 0.052844291125541*G0_0_1 - 0.000652398655872*G0_0_2 - 0.052844291125542*G0_1_0 - 0.037839122040511*G0_1_2 - 0.000652398655871*G0_2_0 - 0.037839122040511*G0_2_1 + 0.052191892469669*G0_2_2;
    A[2050] = 0.105688582251081*G0_0_0 + 0.075678244081021*G0_0_1 + 0.052844291125541*G0_0_2 + 0.180062029020361*G0_1_0 + 0.255740273101383*G0_1_1 + 0.127870136550692*G0_1_2 + 0.105036183595210*G0_2_0 + 0.127870136550691*G0_2_1 + 0.105688582251081*G0_2_2;
    A[2051] = -0.209419968534549*G0_0_0 - 0.135698920421142*G0_0_1 - 0.104709984267275*G0_0_2 - 0.390134396210782*G0_1_0 - 0.584549195660303*G0_1_1 - 0.262916658315962*G0_1_2 - 0.290643601190473*G0_2_0 - 0.262916658315962*G0_2_1 - 0.209419968534549*G0_2_2;
    A[2052] = 0.542795681684567*G0_0_0 + 0.271397840842283*G0_0_1 + 0.271397840842283*G0_0_2 + 0.271397840842283*G0_1_0 + 0.647179466623907*G0_1_1 + 0.271397840842283*G0_1_2 + 0.271397840842283*G0_2_0 + 0.271397840842283*G0_2_1 + 0.542795681684564*G0_2_2;
    A[2053] = -0.013700371773288*G0_0_0 - 0.026422145562770*G0_0_1 + 0.006197787230773*G0_0_2 + 0.071437652817861*G0_1_0 + 0.172233245149911*G0_1_1 + 0.006197787230773*G0_1_2 + 0.006197787230774*G0_2_0 + 0.006197787230774*G0_2_1 + 0.012395574461547*G0_2_2;
    A[2054] = -0.023486351611352*G0_0_0 + 0.022507753627545*G0_0_1 - 0.104709984267275*G0_0_2 - 0.045994105238897*G0_1_0 - 0.268135847562930*G0_1_1 + 0.053496689781412*G0_1_2 + 0.081223632655923*G0_2_0 + 0.053496689781411*G0_2_1 - 0.209419968534550*G0_2_2;
    A[2055] = 0.053496689781412*G0_0_0 + 0.000652398655871*G0_0_1 + 0.052844291125541*G0_0_2 + 0.052844291125542*G0_1_0 + 0.105688582251082*G0_1_1 - 0.022181554299609*G0_1_2 + 0.000652398655871*G0_2_0 - 0.022181554299610*G0_2_1 + 0.105688582251081*G0_2_2;
    A[2056] = 0.030010338170060*G0_0_1 + 0.015005169085030*G0_0_2 + 0.030010338170061*G0_1_0 - 0.045667905910961*G0_1_1 - 0.007828783870450*G0_1_2 + 0.015005169085030*G0_2_0 - 0.007828783870451*G0_2_1 + 0.030010338170060*G0_2_2;
    A[2057] = 0.001304797311741*G0_0_1 + 0.000652398655871*G0_0_2 + 0.001304797311741*G0_1_0 - 0.022833952955481*G0_1_1 - 0.010764577821870*G0_1_2 + 0.000652398655871*G0_2_0 - 0.010764577821869*G0_2_1 + 0.001304797311742*G0_2_2;
    A[2058] = 0.030010338170060*G0_0_1 + 0.015005169085030*G0_0_2 + 0.030010338170060*G0_1_0 + 0.015005169085031*G0_1_2 + 0.015005169085030*G0_2_0 + 0.015005169085030*G0_2_1 + 0.030010338170059*G0_2_2;
    A[2059] = 0.012721773789482*G0_0_1 + 0.000652398655871*G0_0_2 + 0.012721773789482*G0_1_0 - 0.088073818542568*G0_1_1 + 0.000652398655870*G0_1_2 + 0.000652398655871*G0_2_0 + 0.000652398655871*G0_2_1 + 0.001304797311742*G0_2_2;
    A[2060] = 0.012721773789482*G0_0_1 + 0.000652398655871*G0_0_2 + 0.012721773789482*G0_1_0 + 0.012069375133611*G0_1_2 + 0.000652398655871*G0_2_0 + 0.012069375133611*G0_2_1 + 0.001304797311742*G0_2_2;
    A[2061] = 0.052844291125541*G0_0_1 + 0.015005169085030*G0_0_2 + 0.052844291125541*G0_1_0 + 0.037839122040511*G0_1_2 + 0.015005169085030*G0_2_0 + 0.037839122040511*G0_2_1 + 0.030010338170060*G0_2_2;
    A[2062] = 0.037839122040511*G0_0_1 + 0.052844291125541*G0_0_2 + 0.037839122040511*G0_1_0 + 0.127870136550692*G0_1_1 + 0.090031014510180*G0_1_2 + 0.052844291125540*G0_2_0 + 0.090031014510180*G0_2_1 + 0.052191892469670*G0_2_2;
    A[2063] = 0.005545388574903*G0_0_1 + 0.006197787230773*G0_0_2 + 0.005545388574902*G0_1_0 + 0.050234696502057*G0_1_1 + 0.038165321368446*G0_1_2 + 0.006197787230774*G0_2_0 + 0.038165321368447*G0_2_1 + 0.026095946234835*G0_2_2;
    A[2064] = 0.037839122040510*G0_0_1 + 0.052844291125540*G0_0_2 + 0.037839122040510*G0_1_0 + 0.030010338170061*G0_1_1 + 0.015005169085029*G0_1_2 + 0.052844291125540*G0_2_0 + 0.015005169085030*G0_2_1;
    A[2065] = -0.067849460210571*G0_0_1 - 0.104709984267275*G0_0_2 - 0.067849460210571*G0_1_0 - 0.292274597830152*G0_1_1 - 0.195067198105391*G0_1_2 - 0.104709984267275*G0_2_0 - 0.195067198105391*G0_2_1 - 0.185933616923199*G0_2_2;
    A[2066] = -0.067849460210571*G0_0_1 - 0.104709984267275*G0_0_2 - 0.067849460210571*G0_1_0 - 0.096555001068890*G0_1_1 - 0.036860524056704*G0_1_2 - 0.104709984267275*G0_2_0 - 0.036860524056705*G0_2_1;
    A[2067] = 0.135698920421142*G0_0_1 + 0.271397840842283*G0_0_2 + 0.135698920421141*G0_1_0 + 0.323589733311953*G0_1_1 + 0.135698920421141*G0_1_2 + 0.271397840842283*G0_2_0 + 0.135698920421142*G0_2_1;
    A[2068] = -0.075025845425149*G0_0_1 - 0.026095946234835*G0_0_2 - 0.075025845425150*G0_1_0 + 0.143527704291594*G0_1_1 - 0.042405912631606*G0_1_2 - 0.026095946234834*G0_2_0 - 0.042405912631605*G0_2_1 - 0.052191892469669*G0_2_2;
    A[2069] = -0.075025845425149*G0_0_1 - 0.026095946234835*G0_0_2 - 0.075025845425150*G0_1_0 + 0.045667905910962*G0_1_1 - 0.026095946234835*G0_1_2 - 0.026095946234835*G0_2_0 - 0.026095946234834*G0_2_1 - 0.052191892469670*G0_2_2;
    A[2070] = 0.316413348097373*G0_0_1 + 0.185933616923198*G0_0_2 + 0.316413348097373*G0_1_0 - 0.150051690850303*G0_1_1 + 0.185933616923198*G0_1_2 + 0.185933616923198*G0_2_0 + 0.185933616923197*G0_2_1 + 0.371867233846396*G0_2_2;
    A[2071] = -0.058715879028379*G0_0_1 - 0.026095946234835*G0_0_2 - 0.058715879028380*G0_1_0 + 0.176147637085136*G0_1_1 - 0.009785979838063*G0_1_2 - 0.026095946234836*G0_2_0 - 0.009785979838063*G0_2_1 - 0.052191892469670*G0_2_2;
    A[2072] = -0.034571909571909*G0_0_0 - 0.034571909571909*G0_0_1 - 0.034571909571909*G0_0_2 - 0.029847238506092*G0_1_0 - 0.029847238506092*G0_1_1 - 0.029847238506092*G0_1_2 - 0.029847238506092*G0_2_0 - 0.029847238506092*G0_2_1 - 0.029847238506092*G0_2_2;
    A[2073] = -0.009464999699375*G0_0_0;
    A[2074] = 0.002278176106301*G0_0_1 + 0.011743175805676*G0_1_1;
    A[2075] = 0.004724671065817*G0_0_2 - 0.029847238506092*G0_2_2;
    A[2076] = -0.014287530563572*G0_0_1 - 0.002544354757896*G0_0_2 - 0.043547610279381*G0_1_1 - 0.005838967970044*G0_1_2 - 0.005838967970044*G0_2_1;
    A[2077] = 0.037773882174923*G0_0_1 + 0.009394540644540*G0_0_2 + 0.056758683060766*G0_1_1 + 0.018886941087462*G0_1_2 + 0.018886941087461*G0_2_1 - 0.006197787230774*G0_2_2;
    A[2078] = 0.108232937008978*G0_0_1 + 0.080832193462401*G0_0_2 + 0.104709984267275*G0_1_1 + 0.074340826836485*G0_1_2 + 0.074340826836486*G0_2_1 + 0.037186723384640*G0_2_2;
    A[2079] = 0.042960451489097*G0_0_1 + 0.084550865800865*G0_0_2 + 0.042275432900433*G0_1_2 + 0.042275432900433*G0_2_1 + 0.128522535206562*G0_2_2;
    A[2080] = 0.029260079715809*G0_0_0 + 0.003294613212148*G0_0_2 + 0.003294613212148*G0_2_0;
    A[2081] = -0.018984800885842*G0_0_0 - 0.009492400442921*G0_0_2 - 0.009492400442921*G0_2_0 - 0.000652398655870*G0_2_2;
    A[2082] = 0.003522952741702*G0_0_0 + 0.006491366625914*G0_0_2 + 0.006491366625915*G0_2_0 + 0.008807381854256*G0_2_2;
    A[2083] = 0.042960451489097*G0_0_0 + 0.042275432900433*G0_0_2 + 0.042275432900433*G0_2_0 + 0.064261267603281*G0_2_2;
    A[2084] = 0.006589226424296*G0_0_0 + 0.003294613212148*G0_0_1 + 0.003294613212148*G0_1_0;
    A[2085] = 0.004501550725509*G0_0_0 + 0.001924576034819*G0_0_1 + 0.001924576034819*G0_1_0 - 0.000652398655871*G0_1_1;
    A[2086] = -0.010503618359521*G0_0_0 - 0.013080593050211*G0_0_1 - 0.013080593050210*G0_1_0 - 0.015657567740901*G0_1_1;
    A[2087] = -0.002544354757896*G0_0_0 - 0.005838967970044*G0_0_1 - 0.005838967970045*G0_1_0 - 0.009133581182192*G0_1_1;
    A[2088] = 0.127315597693200*G0_0_0 + 0.127315597693201*G0_0_1 + 0.128000616281865*G0_0_2 + 0.176636936077038*G0_1_0 + 0.176636936077038*G0_1_1 + 0.134361503176606*G0_1_2 + 0.134361503176606*G0_2_0 + 0.134361503176606*G0_2_1 + 0.092086070276173*G0_2_2;
    A[2089] = -0.166948816037356*G0_0_0 - 0.166948816037356*G0_0_1 - 0.160783648739377*G0_0_2 - 0.334680510461757*G0_1_0 - 0.334680510461758*G0_1_1 - 0.250814663249557*G0_1_2 - 0.250814663249557*G0_2_0 - 0.250814663249557*G0_2_1 - 0.062238831770081*G0_2_2;
    A[2090] = 0.182410664181496*G0_0_0 + 0.182410664181496*G0_0_1 + 0.098544816969296*G0_0_2 + 0.104709984267275*G0_1_0 + 0.104709984267275*G0_1_1 + 0.188575831479476*G0_1_2 + 0.188575831479475*G0_2_0 + 0.188575831479475*G0_2_1 - 0.062238831770081*G0_2_2;
    A[2091] = -0.042960451489097*G0_0_0 - 0.042960451489097*G0_0_1 - 0.035914546005692*G0_0_2 - 0.042275432900433*G0_1_2 - 0.042275432900433*G0_2_0 - 0.042275432900433*G0_2_1 + 0.092086070276174*G0_2_2;
    A[2092] = 0.043971669405696*G0_0_0 + 0.044656687994361*G0_0_1 + 0.043971669405697*G0_0_2 + 0.086247102306129*G0_1_0 + 0.043971669405697*G0_1_1 + 0.086247102306129*G0_1_2 + 0.128522535206562*G0_2_0 + 0.086247102306129*G0_2_1 + 0.128522535206562*G0_2_2;
    A[2093] = -0.043645470077761*G0_0_0 - 0.009753359905270*G0_0_1 - 0.043645470077761*G0_0_2 - 0.037154103451846*G0_1_0 - 0.006784946021057*G0_1_1 - 0.037154103451846*G0_1_2 + 0.037186723384640*G0_2_0 - 0.037154103451846*G0_2_1 + 0.037186723384640*G0_2_2;
    A[2094] = -0.015592327875314*G0_0_0 + 0.003294613212148*G0_0_1 - 0.015592327875314*G0_0_2 - 0.025084728318235*G0_1_0 + 0.012787013655069*G0_1_1 - 0.025084728318235*G0_1_2 - 0.006197787230773*G0_2_0 - 0.025084728318236*G0_2_1 - 0.006197787230773*G0_2_2;
    A[2095] = 0.002544354757896*G0_0_0 - 0.005904207835631*G0_0_1 + 0.002544354757896*G0_0_2 + 0.005838967970045*G0_1_0 - 0.031869674339292*G0_1_1 + 0.005838967970045*G0_1_2 + 0.005838967970045*G0_2_1;
    A[2096] = 0.022670853291513*G0_0_0 + 0.021985834702848*G0_0_1 + 0.021985834702848*G0_0_2 + 0.021985834702848*G0_1_0 + 0.064261267603281*G0_1_1 + 0.064261267603281*G0_1_2 + 0.021985834702848*G0_2_0 + 0.064261267603281*G0_2_1 + 0.064261267603281*G0_2_2;
    A[2097] = -0.000652398655871*G0_0_0 + 0.002316015228342*G0_0_1 + 0.002316015228342*G0_0_2 + 0.002316015228342*G0_1_0 + 0.008807381854257*G0_1_1 + 0.008807381854257*G0_1_2 + 0.002316015228342*G0_2_0 + 0.008807381854257*G0_2_1 + 0.008807381854257*G0_2_2;
    A[2098] = -0.000652398655871*G0_0_0 + 0.008840001787050*G0_0_1 + 0.008840001787050*G0_0_2 + 0.008840001787050*G0_1_0 - 0.000652398655871*G0_1_1 - 0.000652398655871*G0_1_2 + 0.008840001787050*G0_2_0 - 0.000652398655871*G0_2_1 - 0.000652398655871*G0_2_2;
    A[2099] = 0.022670853291513*G0_0_0 - 0.003294613212148*G0_0_1 - 0.003294613212148*G0_0_2 - 0.003294613212148*G0_1_0 - 0.003294613212148*G0_2_0;
    A[2100] = -0.025443547578964*G0_0_0 - 0.012721773789482*G0_0_1 - 0.001304797311742*G0_0_2 - 0.012721773789483*G0_1_0 - 0.000652398655871*G0_1_2 - 0.001304797311741*G0_2_0 - 0.000652398655871*G0_2_1;
    A[2101] = -0.016636165724706*G0_0_0 + 0.001467896975710*G0_0_1 - 0.018104062700416*G0_0_2 + 0.001467896975710*G0_1_0 + 0.019571959676127*G0_1_1 - 0.010275278829966*G0_1_2 - 0.018104062700417*G0_2_0 - 0.010275278829966*G0_2_1;
    A[2102] = 0.013700371773288*G0_0_0 + 0.026422145562770*G0_0_1 - 0.006197787230773*G0_0_2 + 0.026422145562770*G0_1_0 + 0.039143919352253*G0_1_1 - 0.005545388574902*G0_1_2 - 0.006197787230773*G0_2_0 - 0.005545388574902*G0_2_1;
    A[2103] = 0.056758683060766*G0_0_0 + 0.028379341530383*G0_0_1 + 0.028379341530383*G0_0_2 + 0.028379341530383*G0_1_0 + 0.014189670765192*G0_1_2 + 0.028379341530381*G0_2_0 + 0.014189670765191*G0_2_1 - 0.004892989919032*G0_2_2;
    A[2104] = 0.149725491522364*G0_0_0 + 0.121346149991982*G0_0_1 + 0.074862745761182*G0_0_2 + 0.121346149991981*G0_1_0 + 0.092966808461598*G0_1_1 + 0.060673074995990*G0_1_2 + 0.074862745761182*G0_2_0 + 0.060673074995990*G0_2_1 + 0.019571959676125*G0_2_2;
    A[2105] = 0.209419968534550*G0_0_0 + 0.104709984267275*G0_0_1 + 0.135698920421141*G0_0_2 + 0.104709984267275*G0_1_0 + 0.067849460210570*G0_1_2 + 0.135698920421142*G0_2_0 + 0.067849460210571*G0_2_1 + 0.039143919352252*G0_2_2;
    A[2106] = -0.268135847562928*G0_0_0 - 0.222141742324031*G0_0_1 - 0.194414799449519*G0_0_2 - 0.290643601190473*G0_1_0 - 0.268135847562928*G0_1_1 - 0.321632537344339*G0_1_2 - 0.448850275239161*G0_2_0 - 0.321632537344340*G0_2_1 - 0.584549195660302*G0_2_2;
    A[2107] = 0.065566064915022*G0_0_0 + 0.037676022376542*G0_0_1 + 0.140428810676204*G0_0_2 + 0.140428810676205*G0_1_0 - 0.037186723384640*G0_1_1 + 0.186912214907004*G0_1_2 + 0.037676022376543*G0_2_0 + 0.186912214907006*G0_2_1 - 0.037186723384640*G0_2_2;
    A[2108] = -0.013700371773288*G0_0_0 + 0.071437652817861*G0_0_1 + 0.006197787230774*G0_0_2 - 0.026422145562770*G0_1_0 + 0.172233245149911*G0_1_1 + 0.006197787230774*G0_1_2 + 0.006197787230773*G0_2_0 + 0.006197787230773*G0_2_1 + 0.012395574461547*G0_2_2;
    A[2109] = 0.726119703984281*G0_0_0 + 0.456026660453740*G0_0_1 + 0.456026660453739*G0_0_2 + 0.456026660453740*G0_1_0 + 0.726119703984281*G0_1_1 + 0.456026660453740*G0_1_2 + 0.456026660453739*G0_2_0 + 0.456026660453740*G0_2_1 + 0.912053320907480*G0_2_2;
    A[2110] = -0.149725491522365*G0_0_0 - 0.326851726591306*G0_0_1 - 0.177615534060845*G0_0_2 - 0.121346149991981*G0_1_0 - 0.448197876583289*G0_1_1 - 0.224098938291644*G0_1_2 - 0.074862745761182*G0_2_0 - 0.224098938291644*G0_2_1 - 0.037186723384640*G0_2_2;
    A[2111] = -0.209419968534550*G0_0_0 - 0.290643601190474*G0_0_1 - 0.390134396210782*G0_0_2 - 0.104709984267275*G0_1_0 - 0.209419968534550*G0_1_1 - 0.262916658315962*G0_1_2 - 0.135698920421142*G0_2_0 - 0.262916658315962*G0_2_1 - 0.584549195660302*G0_2_2;
    A[2112] = -0.088073818542567*G0_0_0 - 0.134067923781464*G0_0_1 - 0.097207399724759*G0_0_2 - 0.134067923781463*G0_1_0 - 0.156575677409008*G0_1_1 - 0.224425137619579*G0_1_2 - 0.097207399724760*G0_2_0 - 0.224425137619580*G0_2_1 - 0.292274597830151*G0_2_2;
    A[2113] = 0.019571959676126*G0_0_0 - 0.055290786085057*G0_0_1 - 0.041101115319865*G0_0_2 - 0.055290786085057*G0_1_0 + 0.019571959676125*G0_1_1 + 0.005382288910934*G0_1_2 - 0.041101115319865*G0_2_0 + 0.005382288910935*G0_2_1 - 0.008807381854257*G0_2_2;
    A[2114] = -0.088073818542568*G0_0_0 + 0.012721773789482*G0_0_1 + 0.000652398655870*G0_0_2 + 0.012721773789482*G0_1_0 + 0.000652398655871*G0_1_2 + 0.000652398655871*G0_2_0 + 0.000652398655871*G0_2_1 + 0.001304797311742*G0_2_2;
    A[2115] = 0.092966808461598*G0_0_0 + 0.363059851992140*G0_0_1 + 0.228013330226869*G0_0_2 + 0.363059851992139*G0_1_0 + 0.092966808461598*G0_1_1 + 0.228013330226869*G0_1_2 + 0.228013330226869*G0_2_0 + 0.228013330226869*G0_2_1 + 0.456026660453740*G0_2_2;
    A[2116] = 0.092966808461600*G0_0_0 - 0.028379341530382*G0_0_1 + 0.032293733465610*G0_0_2 - 0.028379341530382*G0_1_0 - 0.014189670765191*G0_1_2 + 0.032293733465608*G0_2_0 - 0.014189670765191*G0_2_1 - 0.008807381854256*G0_2_2;
    A[2117] = -0.185933616923198*G0_0_0 - 0.104709984267275*G0_0_1 - 0.195067198105391*G0_0_2 - 0.104709984267275*G0_1_0 - 0.067849460210571*G0_1_2 - 0.195067198105390*G0_2_0 - 0.067849460210571*G0_2_1 - 0.292274597830151*G0_2_2;
    A[2118] = -0.022833952955480*G0_0_0 - 0.059694477012184*G0_0_1 - 0.096555001068889*G0_0_2 - 0.059694477012184*G0_1_0 - 0.096555001068888*G0_1_1 - 0.028705540858318*G0_1_2 - 0.096555001068889*G0_2_0 - 0.028705540858318*G0_2_1 + 0.039143919352253*G0_2_2;
    A[2119] = -0.004892989919031*G0_0_0 - 0.019082660684223*G0_0_1 - 0.033272331449414*G0_0_2 - 0.019082660684223*G0_1_0 - 0.033272331449415*G0_1_1 - 0.019082660684223*G0_1_2 - 0.033272331449415*G0_2_0 - 0.019082660684223*G0_2_1 - 0.004892989919032*G0_2_2;
    A[2120] = -0.022833952955481*G0_0_0 - 0.010764577821870*G0_0_1 + 0.001304797311742*G0_0_2 - 0.010764577821869*G0_1_0 + 0.001304797311742*G0_1_1 + 0.000652398655871*G0_1_2 + 0.001304797311742*G0_2_0 + 0.000652398655871*G0_2_1;
    A[2121] = 0.019571959676126*G0_0_0 + 0.005382288910934*G0_0_1 - 0.055290786085056*G0_0_2 + 0.005382288910934*G0_1_0 - 0.008807381854258*G0_1_1 - 0.041101115319865*G0_1_2 - 0.055290786085057*G0_2_0 - 0.041101115319865*G0_2_1 + 0.019571959676126*G0_2_2;
    A[2122] = 0.019571959676126*G0_0_0 + 0.029847238506092*G0_0_1 + 0.018104062700416*G0_0_2 + 0.029847238506092*G0_1_0 + 0.040122517336058*G0_1_1 + 0.010275278829966*G0_1_2 + 0.018104062700417*G0_2_0 + 0.010275278829966*G0_2_1;
    A[2123] = 0.026095946234835*G0_0_0 + 0.038165321368446*G0_0_1 + 0.006197787230773*G0_0_2 + 0.038165321368446*G0_1_0 + 0.050234696502058*G0_1_1 + 0.005545388574902*G0_1_2 + 0.006197787230773*G0_2_0 + 0.005545388574902*G0_2_1;
    A[2124] = 0.146789697570944*G0_0_0 + 0.249542485870608*G0_0_1 + 0.445262082631869*G0_0_2 + 0.249542485870607*G0_1_0 + 0.352295274170270*G0_1_1 + 0.249542485870607*G0_1_2 + 0.445262082631870*G0_2_0 + 0.249542485870608*G0_2_1 - 0.039143919352254*G0_2_2;
    A[2125] = 0.146789697570947*G0_0_0 + 0.053822889109347*G0_0_1 + 0.004892989919031*G0_0_2 + 0.053822889109348*G0_1_0 - 0.039143919352252*G0_1_1 + 0.004892989919031*G0_1_2 + 0.004892989919032*G0_2_0 + 0.004892989919032*G0_2_1 + 0.009785979838063*G0_2_2;
    A[2126] = -0.048929899190316*G0_0_0 - 0.141896707651915*G0_0_1 - 0.019571959676126*G0_0_2 - 0.141896707651915*G0_1_0 - 0.234863516113515*G0_1_1 - 0.019571959676126*G0_1_2 - 0.019571959676126*G0_2_0 - 0.019571959676126*G0_2_1 - 0.039143919352251*G0_2_2;
    A[2127] = -0.782878387045046*G0_0_0 - 0.484406001984122*G0_0_1 - 0.484406001984121*G0_0_2 - 0.484406001984122*G0_1_0 - 0.185933616923196*G0_1_1 - 0.288686405222860*G0_1_2 - 0.484406001984120*G0_2_0 - 0.288686405222859*G0_2_1 - 0.039143919352250*G0_2_2;
    A[2128] = 0.009464999699375*G0_0_0 + 0.009464999699375*G0_0_1 + 0.009464999699375*G0_0_2 + 0.011743175805675*G0_1_0 + 0.011743175805675*G0_1_1 + 0.011743175805676*G0_1_2 + 0.011743175805676*G0_2_0 + 0.011743175805676*G0_2_1 + 0.011743175805676*G0_2_2;
    A[2129] = -0.009464999699375*G0_0_0;
    A[2130] = 0.004724671065817*G0_0_1 - 0.029847238506092*G0_1_1;
    A[2131] = 0.004724671065817*G0_0_2 - 0.029847238506093*G0_2_2;
    A[2132] = 0.049321338383838*G0_0_1 + 0.042960451489097*G0_0_2 + 0.176636936077039*G0_1_1 + 0.042275432900433*G0_1_2 + 0.042275432900432*G0_2_1;
    A[2133] = -0.167731694424401*G0_0_1 - 0.077700679914221*G0_0_2 - 0.334680510461758*G0_1_1 - 0.083865847212201*G0_1_2 - 0.083865847212201*G0_2_1 + 0.104709984267275*G0_2_2;
    A[2134] = -0.077700679914221*G0_0_1 - 0.167731694424402*G0_0_2 + 0.104709984267276*G0_1_1 - 0.083865847212200*G0_1_2 - 0.083865847212200*G0_2_1 - 0.334680510461758*G0_2_2;
    A[2135] = 0.042960451489097*G0_0_1 + 0.049321338383839*G0_0_2 + 0.042275432900432*G0_1_2 + 0.042275432900432*G0_2_1 + 0.176636936077039*G0_2_2;
    A[2136] = 0.029260079715808*G0_0_0 + 0.003294613212148*G0_0_2 + 0.003294613212148*G0_2_0;
    A[2137] = -0.018984800885842*G0_0_0 - 0.009492400442921*G0_0_2 - 0.009492400442921*G0_2_0 - 0.000652398655871*G0_2_2;
    A[2138] = 0.003522952741702*G0_0_0 + 0.006491366625915*G0_0_2 + 0.006491366625915*G0_2_0 + 0.008807381854257*G0_2_2;
    A[2139] = 0.042960451489097*G0_0_0 + 0.042275432900433*G0_0_2 + 0.042275432900432*G0_2_0 + 0.064261267603281*G0_2_2;
    A[2140] = 0.029260079715808*G0_0_0 + 0.003294613212148*G0_0_1 + 0.003294613212148*G0_1_0;
    A[2141] = -0.018984800885842*G0_0_0 - 0.009492400442921*G0_0_1 - 0.009492400442921*G0_1_0 - 0.000652398655871*G0_1_1;
    A[2142] = 0.003522952741702*G0_0_0 + 0.006491366625915*G0_0_1 + 0.006491366625914*G0_1_0 + 0.008807381854257*G0_1_1;
    A[2143] = 0.042960451489097*G0_0_0 + 0.042275432900433*G0_0_1 + 0.042275432900433*G0_1_0 + 0.064261267603281*G0_1_1;
    A[2144] = -0.029260079715808*G0_0_0 - 0.029260079715808*G0_0_1 - 0.025965466503661*G0_0_2 - 0.043547610279380*G0_1_0 - 0.043547610279380*G0_1_1 - 0.037708642309336*G0_1_2 - 0.037708642309336*G0_2_0 - 0.037708642309336*G0_2_1 - 0.031869674339292*G0_2_2;
    A[2145] = 0.018984800885841*G0_0_0 + 0.018984800885842*G0_0_1 + 0.009492400442921*G0_0_2 + 0.056758683060765*G0_1_0 + 0.056758683060765*G0_1_1 + 0.037871741973304*G0_1_2 + 0.037871741973304*G0_2_0 + 0.037871741973304*G0_2_1 + 0.012787013655069*G0_2_2;
    A[2146] = -0.003522952741703*G0_0_0 - 0.003522952741703*G0_0_1 + 0.002968413884213*G0_0_2 + 0.104709984267276*G0_1_0 + 0.104709984267276*G0_1_1 + 0.030369157430789*G0_1_2 + 0.030369157430789*G0_2_0 + 0.030369157430789*G0_2_1 - 0.006784946021057*G0_2_2;
    A[2147] = -0.042960451489097*G0_0_0 - 0.042960451489097*G0_0_1 - 0.000685018588664*G0_0_2 - 0.042275432900433*G0_1_2 - 0.042275432900432*G0_2_0 - 0.042275432900432*G0_2_1 + 0.043971669405697*G0_2_2;
    A[2148] = -0.029260079715808*G0_0_0 - 0.025965466503661*G0_0_1 - 0.029260079715808*G0_0_2 - 0.037708642309336*G0_1_0 - 0.031869674339292*G0_1_1 - 0.037708642309336*G0_1_2 - 0.043547610279381*G0_2_0 - 0.037708642309337*G0_2_1 - 0.043547610279381*G0_2_2;
    A[2149] = 0.018984800885842*G0_0_0 + 0.009492400442921*G0_0_1 + 0.018984800885842*G0_0_2 + 0.037871741973304*G0_1_0 + 0.012787013655069*G0_1_1 + 0.037871741973304*G0_1_2 + 0.056758683060766*G0_2_0 + 0.037871741973305*G0_2_1 + 0.056758683060766*G0_2_2;
    A[2150] = -0.003522952741703*G0_0_0 + 0.002968413884213*G0_0_1 - 0.003522952741703*G0_0_2 + 0.030369157430789*G0_1_0 - 0.006784946021057*G0_1_1 + 0.030369157430789*G0_1_2 + 0.104709984267274*G0_2_0 + 0.030369157430789*G0_2_1 + 0.104709984267275*G0_2_2;
    A[2151] = -0.042960451489097*G0_0_0 - 0.000685018588664*G0_0_1 - 0.042960451489097*G0_0_2 - 0.042275432900433*G0_1_0 + 0.043971669405697*G0_1_1 - 0.042275432900433*G0_1_2 - 0.042275432900432*G0_2_1;
    A[2152] = -0.003294613212148*G0_0_1 - 0.003294613212148*G0_0_2 - 0.003294613212148*G0_1_0 - 0.009133581182192*G0_1_1 - 0.009133581182192*G0_1_2 - 0.003294613212148*G0_2_0 - 0.009133581182192*G0_2_1 - 0.009133581182192*G0_2_2;
    A[2153] = -0.002576974690690*G0_0_1 - 0.002576974690690*G0_0_2 - 0.002576974690690*G0_1_0 - 0.015657567740901*G0_1_1 - 0.015657567740901*G0_1_2 - 0.002576974690690*G0_2_0 - 0.015657567740901*G0_2_1 - 0.015657567740901*G0_2_2;
    A[2154] = -0.002576974690690*G0_0_1 - 0.002576974690690*G0_0_2 - 0.002576974690690*G0_1_0 - 0.000652398655871*G0_1_1 - 0.000652398655871*G0_1_2 - 0.002576974690690*G0_2_0 - 0.000652398655871*G0_2_1 - 0.000652398655871*G0_2_2;
    A[2155] = -0.003294613212148*G0_0_1 - 0.003294613212148*G0_0_2 - 0.003294613212148*G0_1_0 - 0.003294613212148*G0_2_0;
    A[2156] = -0.113517366121532*G0_0_0 - 0.012721773789483*G0_0_1 - 0.012721773789483*G0_0_2 - 0.012721773789482*G0_1_0 - 0.000652398655871*G0_1_2 - 0.012721773789482*G0_2_0 - 0.000652398655871*G0_2_1;
    A[2157] = 0.149725491522365*G0_0_0 + 0.074862745761183*G0_0_1 + 0.028379341530383*G0_0_2 + 0.074862745761182*G0_1_0 + 0.019571959676126*G0_1_1 + 0.014189670765191*G0_1_2 + 0.028379341530383*G0_2_0 + 0.014189670765192*G0_2_1;
    A[2158] = 0.023486351611352*G0_0_0 - 0.022507753627545*G0_0_1 + 0.104709984267275*G0_0_2 - 0.022507753627544*G0_1_0 - 0.156575677409010*G0_1_1 + 0.067849460210570*G0_1_2 + 0.104709984267275*G0_2_0 + 0.067849460210570*G0_2_1;
    A[2159] = 0.149725491522365*G0_0_0 + 0.028379341530383*G0_0_1 + 0.074862745761183*G0_0_2 + 0.028379341530383*G0_1_0 + 0.014189670765191*G0_1_2 + 0.074862745761182*G0_2_0 + 0.014189670765191*G0_2_1 + 0.019571959676126*G0_2_2;
    A[2160] = -0.540186087061083*G0_0_0 - 0.270093043530542*G0_0_1 - 0.270093043530541*G0_0_2 - 0.270093043530540*G0_1_0 + 0.092966808461600*G0_1_1 - 0.135046521765270*G0_1_2 - 0.270093043530541*G0_2_0 - 0.135046521765270*G0_2_1 + 0.092966808461599*G0_2_2;
    A[2161] = 0.023486351611353*G0_0_0 + 0.104709984267276*G0_0_1 - 0.022507753627545*G0_0_2 + 0.104709984267276*G0_1_0 + 0.067849460210571*G0_1_2 - 0.022507753627544*G0_2_0 + 0.067849460210571*G0_2_1 - 0.156575677409009*G0_2_2;
    A[2162] = 0.113517366121531*G0_0_0 + 0.100795592332049*G0_0_1 + 0.100795592332049*G0_0_2 + 0.198655390712679*G0_1_0 + 0.172233245149910*G0_1_1 + 0.166035457919136*G0_1_2 + 0.198655390712680*G0_2_0 + 0.166035457919136*G0_2_1 + 0.172233245149910*G0_2_2;
    A[2163] = -0.149725491522365*G0_0_0 - 0.074862745761182*G0_0_1 - 0.121346149991981*G0_0_2 - 0.177615534060844*G0_1_0 - 0.037186723384639*G0_1_1 - 0.224098938291644*G0_1_2 - 0.326851726591307*G0_2_0 - 0.224098938291645*G0_2_1 - 0.448197876583289*G0_2_2;
    A[2164] = -0.023486351611352*G0_0_0 - 0.045994105238897*G0_0_1 + 0.081223632655923*G0_0_2 + 0.022507753627545*G0_1_0 - 0.268135847562930*G0_1_1 + 0.053496689781411*G0_1_2 - 0.104709984267275*G0_2_0 + 0.053496689781412*G0_2_1 - 0.209419968534550*G0_2_2;
    A[2165] = -0.149725491522365*G0_0_0 - 0.121346149991981*G0_0_1 - 0.074862745761182*G0_0_2 - 0.326851726591306*G0_1_0 - 0.448197876583289*G0_1_1 - 0.224098938291644*G0_1_2 - 0.177615534060845*G0_2_0 - 0.224098938291644*G0_2_1 - 0.037186723384640*G0_2_2;
    A[2166] = 0.540186087061083*G0_0_0 + 0.270093043530540*G0_0_1 + 0.270093043530541*G0_0_2 + 0.270093043530540*G0_1_0 + 0.726119703984282*G0_1_1 + 0.270093043530540*G0_1_2 + 0.270093043530541*G0_2_0 + 0.270093043530540*G0_2_1 + 0.726119703984281*G0_2_2;
    A[2167] = -0.023486351611353*G0_0_0 + 0.081223632655924*G0_0_1 - 0.045994105238897*G0_0_2 - 0.104709984267276*G0_1_0 - 0.209419968534551*G0_1_1 + 0.053496689781412*G0_1_2 + 0.022507753627544*G0_2_0 + 0.053496689781412*G0_2_1 - 0.268135847562928*G0_2_2;
    A[2168] = 0.012721773789482*G0_0_1 + 0.012069375133611*G0_0_2 + 0.012721773789481*G0_1_0 + 0.039143919352251*G0_1_1 + 0.044689307927154*G0_1_2 + 0.012069375133611*G0_2_0 + 0.044689307927154*G0_2_1 + 0.050234696502057*G0_2_2;
    A[2169] = 0.018104062700417*G0_0_1 + 0.010275278829966*G0_0_2 + 0.018104062700417*G0_1_0 + 0.019571959676127*G0_1_1 + 0.029847238506093*G0_1_2 + 0.010275278829966*G0_2_0 + 0.029847238506092*G0_2_1 + 0.040122517336058*G0_2_2;
    A[2170] = 0.012721773789482*G0_0_1 + 0.012069375133611*G0_0_2 + 0.012721773789482*G0_1_0 + 0.000652398655871*G0_1_2 + 0.012069375133611*G0_2_0 + 0.000652398655871*G0_2_1 + 0.001304797311742*G0_2_2;
    A[2171] = -0.028379341530383*G0_0_1 - 0.014189670765191*G0_0_2 - 0.028379341530382*G0_1_0 + 0.092966808461601*G0_1_1 + 0.032293733465609*G0_1_2 - 0.014189670765192*G0_2_0 + 0.032293733465608*G0_2_1 - 0.008807381854257*G0_2_2;
    A[2172] = -0.028379341530383*G0_0_1 - 0.014189670765192*G0_0_2 - 0.028379341530383*G0_1_0 - 0.014189670765192*G0_1_2 - 0.014189670765191*G0_2_0 - 0.014189670765191*G0_2_1 - 0.033272331449414*G0_2_2;
    A[2173] = -0.104709984267276*G0_0_1 - 0.036860524056705*G0_0_2 - 0.104709984267276*G0_1_0 - 0.067849460210571*G0_1_2 - 0.036860524056703*G0_2_0 - 0.067849460210571*G0_2_1 - 0.096555001068889*G0_2_2;
    A[2174] = 0.012069375133611*G0_0_1 + 0.012721773789482*G0_0_2 + 0.012069375133610*G0_1_0 + 0.050234696502056*G0_1_1 + 0.044689307927154*G0_1_2 + 0.012721773789482*G0_2_0 + 0.044689307927154*G0_2_1 + 0.039143919352252*G0_2_2;
    A[2175] = 0.010275278829966*G0_0_1 + 0.018104062700416*G0_0_2 + 0.010275278829967*G0_1_0 + 0.040122517336059*G0_1_1 + 0.029847238506092*G0_1_2 + 0.018104062700416*G0_2_0 + 0.029847238506092*G0_2_1 + 0.019571959676126*G0_2_2;
    A[2176] = 0.012069375133611*G0_0_1 + 0.012721773789483*G0_0_2 + 0.012069375133611*G0_1_0 + 0.001304797311742*G0_1_1 + 0.000652398655871*G0_1_2 + 0.012721773789482*G0_2_0 + 0.000652398655871*G0_2_1;
    A[2177] = -0.014189670765192*G0_0_1 - 0.028379341530383*G0_0_2 - 0.014189670765192*G0_1_0 - 0.008807381854256*G0_1_1 + 0.032293733465608*G0_1_2 - 0.028379341530383*G0_2_0 + 0.032293733465608*G0_2_1 + 0.092966808461599*G0_2_2;
    A[2178] = -0.014189670765191*G0_0_1 - 0.028379341530383*G0_0_2 - 0.014189670765191*G0_1_0 - 0.033272331449414*G0_1_1 - 0.014189670765191*G0_1_2 - 0.028379341530383*G0_2_0 - 0.014189670765191*G0_2_1;
    A[2179] = -0.036860524056704*G0_0_1 - 0.104709984267275*G0_0_2 - 0.036860524056704*G0_1_0 - 0.096555001068889*G0_1_1 - 0.067849460210570*G0_1_2 - 0.104709984267275*G0_2_0 - 0.067849460210571*G0_2_1;
    A[2180] = -0.092966808461599*G0_0_1 - 0.092966808461599*G0_0_2 - 0.092966808461598*G0_1_0 - 0.234863516113513*G0_1_1 - 0.215291556437387*G0_1_2 - 0.092966808461599*G0_2_0 - 0.215291556437388*G0_2_1 - 0.234863516113514*G0_2_2;
    A[2181] = -0.092966808461599*G0_0_1 - 0.092966808461599*G0_0_2 - 0.092966808461600*G0_1_0 - 0.039143919352252*G0_1_1 - 0.044036909271283*G0_1_2 - 0.092966808461600*G0_2_0 - 0.044036909271284*G0_2_1 - 0.039143919352252*G0_2_2;
    A[2182] = 0.102752788299662*G0_0_1 + 0.298472385060924*G0_0_2 + 0.102752788299662*G0_1_0 + 0.352295274170272*G0_1_1 + 0.102752788299662*G0_1_2 + 0.298472385060924*G0_2_0 + 0.102752788299663*G0_2_1 - 0.185933616923198*G0_2_2;
    A[2183] = 0.298472385060925*G0_0_1 + 0.102752788299662*G0_0_2 + 0.298472385060924*G0_1_0 - 0.185933616923201*G0_1_1 + 0.102752788299661*G0_1_2 + 0.102752788299663*G0_2_0 + 0.102752788299662*G0_2_1 + 0.352295274170271*G0_2_2;
    A[2184] = 0.013742125287264*G0_0_0 + 0.013742125287264*G0_0_1 + 0.013742125287264*G0_0_2 + 0.018919561020255*G0_1_0 + 0.018919561020255*G0_1_1 + 0.018919561020255*G0_1_2 + 0.018919561020255*G0_2_0 + 0.018919561020255*G0_2_1 + 0.018919561020255*G0_2_2;
    A[2185] = -0.013742125287264*G0_0_0;
    A[2186] = 0.005177435732991*G0_0_1 + 0.018919561020255*G0_1_1;
    A[2187] = -0.014394523943135*G0_0_2 + 0.033598530777350*G0_2_2;
    A[2188] = -0.047755581609748*G0_0_1 - 0.011873655536850*G0_0_2 - 0.111886369481855*G0_1_1 - 0.021268196181391*G0_1_2 - 0.021268196181390*G0_2_1;
    A[2189] = 0.082332710370904*G0_0_1 - 0.001826716236438*G0_0_2 + 0.209419968534550*G0_1_1 + 0.035947165938486*G0_1_2 + 0.035947165938485*G0_2_1 - 0.052844291125540*G0_2_2;
    A[2190] = -0.146659217839771*G0_0_1 - 0.010960297418631*G0_0_2 - 0.271397840842283*G0_1_1 - 0.073329608919886*G0_1_2 - 0.073329608919886*G0_2_1 + 0.121346149991982*G0_2_2;
    A[2191] = -0.124738623002512*G0_0_1 - 0.192588083213082*G0_0_2 - 0.096294041606541*G0_1_2 - 0.096294041606541*G0_2_1 - 0.257045070413124*G0_2_2;
    A[2192] = 0.064130787872107*G0_0_0 + 0.009394540644541*G0_0_2 + 0.009394540644541*G0_2_0;
    A[2193] = -0.127087258163646*G0_0_0 - 0.037773882174923*G0_0_2 - 0.037773882174924*G0_2_0 - 0.015005169085030*G0_2_2;
    A[2194] = 0.124738623002511*G0_0_0 + 0.062369311501255*G0_0_2 + 0.062369311501256*G0_2_0 + 0.047625101878574*G0_2_2;
    A[2195] = -0.124738623002512*G0_0_0 - 0.096294041606541*G0_0_2 - 0.096294041606541*G0_2_0 - 0.128522535206562*G0_2_2;
    A[2196] = 0.018789081289081*G0_0_0 + 0.009394540644541*G0_0_1 + 0.009394540644541*G0_1_0;
    A[2197] = -0.014874689353856*G0_0_0 - 0.014939929219443*G0_0_1 - 0.014939929219443*G0_1_0 - 0.015005169085030*G0_1_1;
    A[2198] = -0.001174317580567*G0_0_0 - 0.001239557446154*G0_0_1 - 0.001239557446154*G0_1_0 - 0.001304797311742*G0_1_1;
    A[2199] = -0.011873655536850*G0_0_0 - 0.021268196181391*G0_0_1 - 0.021268196181391*G0_1_0 - 0.030662736825931*G0_1_1;
    A[2200] = -0.064130787872107*G0_0_0 - 0.064130787872107*G0_0_1 - 0.054736247227567*G0_0_2 - 0.111886369481855*G0_1_0 - 0.111886369481855*G0_1_1 - 0.090618173300465*G0_1_2 - 0.090618173300464*G0_2_0 - 0.090618173300464*G0_2_1 - 0.069349977119074*G0_2_2;
    A[2201] = 0.127087258163647*G0_0_0 + 0.127087258163647*G0_0_1 + 0.089313375988723*G0_0_2 + 0.209419968534550*G0_1_0 + 0.209419968534550*G0_1_1 + 0.173472802596066*G0_1_2 + 0.173472802596065*G0_2_0 + 0.173472802596065*G0_2_1 + 0.084681345532040*G0_2_2;
    A[2202] = -0.124738623002512*G0_0_0 - 0.124738623002512*G0_0_1 - 0.062369311501257*G0_0_2 - 0.271397840842284*G0_1_0 - 0.271397840842284*G0_1_1 - 0.198068231922398*G0_1_2 - 0.198068231922397*G0_2_0 - 0.198068231922397*G0_2_1 - 0.003392473010529*G0_2_2;
    A[2203] = 0.124738623002512*G0_0_0 + 0.124738623002512*G0_0_1 + 0.028444581395971*G0_0_2 + 0.096294041606541*G0_1_2 + 0.096294041606541*G0_2_0 + 0.096294041606541*G0_2_1 - 0.064456987200042*G0_2_2;
    A[2204] = -0.018789081289081*G0_0_0 - 0.009394540644541*G0_0_1 - 0.018789081289081*G0_0_2 - 0.040057277470472*G0_1_0 - 0.018789081289081*G0_1_1 - 0.040057277470472*G0_1_2 - 0.061325473651862*G0_2_0 - 0.040057277470471*G0_2_1 - 0.061325473651862*G0_2_2;
    A[2205] = 0.014874689353856*G0_0_0 - 0.000065239865587*G0_0_1 + 0.014874689353856*G0_0_2 + 0.013635131907701*G0_1_0 - 0.000130479731174*G0_1_1 + 0.013635131907701*G0_1_2 - 0.025443547578965*G0_2_0 + 0.013635131907701*G0_2_1 - 0.025443547578964*G0_2_2;
    A[2206] = 0.001174317580567*G0_0_0 - 0.000065239865587*G0_0_1 + 0.001174317580567*G0_0_2 - 0.013765611638876*G0_1_0 - 0.000130479731174*G0_1_1 - 0.013765611638876*G0_1_2 - 0.052844291125540*G0_2_0 - 0.013765611638875*G0_2_1 - 0.052844291125540*G0_2_2;
    A[2207] = 0.011873655536850*G0_0_0 - 0.009394540644541*G0_0_1 + 0.011873655536850*G0_0_2 + 0.021268196181391*G0_1_0 - 0.018789081289081*G0_1_1 + 0.021268196181391*G0_1_2 + 0.021268196181390*G0_2_1;
    A[2208] = -0.009394540644541*G0_0_1 - 0.009394540644541*G0_0_2 - 0.009394540644541*G0_1_0 - 0.030662736825931*G0_1_1 - 0.030662736825931*G0_1_2 - 0.009394540644540*G0_2_0 - 0.030662736825931*G0_2_1 - 0.030662736825931*G0_2_2;
    A[2209] = -0.000065239865587*G0_0_1 - 0.000065239865587*G0_0_2 - 0.000065239865587*G0_1_0 - 0.001304797311742*G0_1_1 - 0.001304797311742*G0_1_2 - 0.000065239865587*G0_2_0 - 0.001304797311742*G0_2_1 - 0.001304797311742*G0_2_2;
    A[2210] = -0.000065239865587*G0_0_1 - 0.000065239865587*G0_0_2 - 0.000065239865587*G0_1_0 - 0.015005169085030*G0_1_1 - 0.015005169085030*G0_1_2 - 0.000065239865587*G0_2_0 - 0.015005169085030*G0_2_1 - 0.015005169085030*G0_2_2;
    A[2211] = -0.009394540644541*G0_0_1 - 0.009394540644540*G0_0_2 - 0.009394540644541*G0_1_0 - 0.009394540644541*G0_2_0;
    A[2212] = -0.105688582251081*G0_0_0 - 0.052844291125541*G0_0_1 - 0.030010338170060*G0_0_2 - 0.052844291125540*G0_1_0 - 0.015005169085030*G0_1_2 - 0.030010338170060*G0_2_0 - 0.015005169085030*G0_2_1;
    A[2213] = 0.013700371773288*G0_0_0 + 0.019898159004061*G0_0_1 - 0.012721773789482*G0_0_2 + 0.019898159004061*G0_1_0 + 0.026095946234835*G0_1_1 - 0.012069375133611*G0_1_2 - 0.012721773789482*G0_2_0 - 0.012069375133612*G0_2_1;
    A[2214] = -0.053496689781412*G0_0_0 - 0.000652398655870*G0_0_1 - 0.052844291125541*G0_0_2 - 0.000652398655871*G0_1_0 + 0.052191892469670*G0_1_1 - 0.037839122040511*G0_1_2 - 0.052844291125541*G0_2_0 - 0.037839122040510*G0_2_1;
    A[2215] = 0.209419968534549*G0_0_0 + 0.104709984267275*G0_0_1 + 0.073721048113408*G0_0_2 + 0.104709984267275*G0_1_0 + 0.036860524056705*G0_1_2 + 0.073721048113410*G0_2_0 + 0.036860524056705*G0_2_1 - 0.022833952955480*G0_2_2;
    A[2216] = 0.023486351611353*G0_0_0 - 0.081223632655923*G0_0_1 + 0.045994105238897*G0_0_2 - 0.081223632655924*G0_1_0 - 0.185933616923199*G0_1_1 + 0.009133581182192*G0_1_2 + 0.045994105238897*G0_2_0 + 0.009133581182193*G0_2_1 - 0.088073818542567*G0_2_2;
    A[2217] = -0.542795681684568*G0_0_0 - 0.271397840842285*G0_0_1 - 0.271397840842284*G0_0_2 - 0.271397840842284*G0_1_0 - 0.135698920421142*G0_1_2 - 0.271397840842285*G0_2_0 - 0.135698920421142*G0_2_1 + 0.052191892469669*G0_2_2;
    A[2218] = 0.105688582251082*G0_0_0 + 0.052844291125541*G0_0_1 + 0.075678244081022*G0_0_2 + 0.105036183595211*G0_1_0 + 0.105688582251082*G0_1_1 + 0.127870136550691*G0_1_2 + 0.180062029020361*G0_2_0 + 0.127870136550692*G0_2_1 + 0.255740273101382*G0_2_2;
    A[2219] = -0.013700371773289*G0_0_0 + 0.006197787230772*G0_0_1 - 0.026422145562770*G0_0_2 + 0.006197787230773*G0_1_0 + 0.012395574461546*G0_1_1 + 0.006197787230773*G0_1_2 + 0.071437652817860*G0_2_0 + 0.006197787230773*G0_2_1 + 0.172233245149911*G0_2_2;
    A[2220] = 0.053496689781412*G0_0_0 + 0.052844291125542*G0_0_1 + 0.000652398655871*G0_0_2 + 0.000652398655871*G0_1_0 + 0.105688582251082*G0_1_1 - 0.022181554299610*G0_1_2 + 0.052844291125541*G0_2_0 - 0.022181554299609*G0_2_1 + 0.105688582251081*G0_2_2;
    A[2221] = -0.209419968534550*G0_0_0 - 0.104709984267275*G0_0_1 - 0.135698920421142*G0_0_2 - 0.290643601190474*G0_1_0 - 0.209419968534550*G0_1_1 - 0.262916658315962*G0_1_2 - 0.390134396210782*G0_2_0 - 0.262916658315962*G0_2_1 - 0.584549195660302*G0_2_2;
    A[2222] = -0.023486351611352*G0_0_0 - 0.104709984267276*G0_0_1 + 0.022507753627544*G0_0_2 + 0.081223632655924*G0_1_0 - 0.209419968534551*G0_1_1 + 0.053496689781412*G0_1_2 - 0.045994105238897*G0_2_0 + 0.053496689781412*G0_2_1 - 0.268135847562928*G0_2_2;
    A[2223] = 0.542795681684568*G0_0_0 + 0.271397840842284*G0_0_1 + 0.271397840842285*G0_0_2 + 0.271397840842284*G0_1_0 + 0.542795681684567*G0_1_1 + 0.271397840842283*G0_1_2 + 0.271397840842285*G0_2_0 + 0.271397840842283*G0_2_1 + 0.647179466623906*G0_2_2;
    A[2224] = 0.052844291125541*G0_0_1 + 0.037839122040511*G0_0_2 + 0.052844291125541*G0_1_0 + 0.052191892469670*G0_1_1 + 0.090031014510180*G0_1_2 + 0.037839122040510*G0_2_0 + 0.090031014510180*G0_2_1 + 0.127870136550691*G0_2_2;
    A[2225] = 0.006197787230773*G0_0_1 + 0.005545388574902*G0_0_2 + 0.006197787230773*G0_1_0 + 0.026095946234835*G0_1_1 + 0.038165321368446*G0_1_2 + 0.005545388574902*G0_2_0 + 0.038165321368446*G0_2_1 + 0.050234696502058*G0_2_2;
    A[2226] = 0.052844291125541*G0_0_1 + 0.037839122040511*G0_0_2 + 0.052844291125541*G0_1_0 + 0.015005169085030*G0_1_2 + 0.037839122040511*G0_2_0 + 0.015005169085030*G0_2_1 + 0.030010338170060*G0_2_2;
    A[2227] = -0.104709984267275*G0_0_1 - 0.067849460210571*G0_0_2 - 0.104709984267275*G0_1_0 - 0.185933616923199*G0_1_1 - 0.195067198105391*G0_1_2 - 0.067849460210570*G0_2_0 - 0.195067198105390*G0_2_1 - 0.292274597830151*G0_2_2;
    A[2228] = -0.104709984267275*G0_0_1 - 0.067849460210571*G0_0_2 - 0.104709984267276*G0_1_0 - 0.036860524056705*G0_1_2 - 0.067849460210571*G0_2_0 - 0.036860524056705*G0_2_1 - 0.096555001068890*G0_2_2;
    A[2229] = 0.271397840842285*G0_0_1 + 0.135698920421143*G0_0_2 + 0.271397840842283*G0_1_0 + 0.135698920421142*G0_1_2 + 0.135698920421141*G0_2_0 + 0.135698920421142*G0_2_1 + 0.323589733311953*G0_2_2;
    A[2230] = 0.015005169085030*G0_0_1 + 0.030010338170060*G0_0_2 + 0.015005169085031*G0_1_0 + 0.030010338170061*G0_1_1 - 0.007828783870450*G0_1_2 + 0.030010338170060*G0_2_0 - 0.007828783870450*G0_2_1 - 0.045667905910961*G0_2_2;
    A[2231] = 0.000652398655871*G0_0_1 + 0.001304797311741*G0_0_2 + 0.000652398655870*G0_1_0 + 0.001304797311742*G0_1_1 - 0.010764577821869*G0_1_2 + 0.001304797311742*G0_2_0 - 0.010764577821869*G0_2_1 - 0.022833952955480*G0_2_2;
    A[2232] = 0.015005169085030*G0_0_1 + 0.030010338170060*G0_0_2 + 0.015005169085030*G0_1_0 + 0.030010338170060*G0_1_1 + 0.015005169085030*G0_1_2 + 0.030010338170060*G0_2_0 + 0.015005169085030*G0_2_1;
    A[2233] = 0.000652398655871*G0_0_1 + 0.012721773789482*G0_0_2 + 0.000652398655871*G0_1_0 + 0.001304797311741*G0_1_1 + 0.000652398655871*G0_1_2 + 0.012721773789483*G0_2_0 + 0.000652398655871*G0_2_1 - 0.088073818542568*G0_2_2;
    A[2234] = 0.000652398655871*G0_0_1 + 0.012721773789482*G0_0_2 + 0.000652398655871*G0_1_0 + 0.001304797311742*G0_1_1 + 0.012069375133611*G0_1_2 + 0.012721773789482*G0_2_0 + 0.012069375133611*G0_2_1;
    A[2235] = 0.015005169085030*G0_0_1 + 0.052844291125541*G0_0_2 + 0.015005169085030*G0_1_0 + 0.030010338170060*G0_1_1 + 0.037839122040510*G0_1_2 + 0.052844291125540*G0_2_0 + 0.037839122040511*G0_2_1;
    A[2236] = -0.026095946234835*G0_0_1 - 0.075025845425151*G0_0_2 - 0.026095946234835*G0_1_0 - 0.052191892469670*G0_1_1 - 0.042405912631607*G0_1_2 - 0.075025845425150*G0_2_0 - 0.042405912631607*G0_2_1 + 0.143527704291593*G0_2_2;
    A[2237] = -0.026095946234834*G0_0_1 - 0.075025845425150*G0_0_2 - 0.026095946234836*G0_1_0 - 0.052191892469670*G0_1_1 - 0.026095946234836*G0_1_2 - 0.075025845425151*G0_2_0 - 0.026095946234835*G0_2_1 + 0.045667905910961*G0_2_2;
    A[2238] = -0.026095946234835*G0_0_1 - 0.058715879028378*G0_0_2 - 0.026095946234834*G0_1_0 - 0.052191892469669*G0_1_1 - 0.009785979838063*G0_1_2 - 0.058715879028378*G0_2_0 - 0.009785979838063*G0_2_1 + 0.176147637085135*G0_2_2;
    A[2239] = 0.185933616923199*G0_0_1 + 0.316413348097375*G0_0_2 + 0.185933616923198*G0_1_0 + 0.371867233846398*G0_1_1 + 0.185933616923199*G0_1_2 + 0.316413348097372*G0_2_0 + 0.185933616923197*G0_2_1 - 0.150051690850301*G0_2_2;
    A[2240] = 0.033598530777350*G0_0_0 + 0.033598530777350*G0_0_1 + 0.033598530777350*G0_0_2 + 0.047993054720485*G0_1_0 + 0.047993054720485*G0_1_1 + 0.047993054720485*G0_1_2 + 0.033598530777350*G0_2_0 + 0.033598530777350*G0_2_1 + 0.033598530777350*G0_2_2;
    A[2241] = 0.018919561020255*G0_0_0 + 0.005177435732991*G0_1_0;
    A[2242] = -0.013742125287264*G0_1_1;
    A[2243] = 0.005177435732991*G0_1_2 + 0.018919561020255*G0_2_2;
    A[2244] = 0.018789081289081*G0_1_1 + 0.009394540644541*G0_1_2 + 0.009394540644540*G0_2_1;
    A[2245] = -0.014874689353855*G0_1_1 - 0.014939929219443*G0_1_2 - 0.014939929219443*G0_2_1 - 0.015005169085030*G0_2_2;
    A[2246] = -0.001174317580567*G0_1_1 - 0.001239557446154*G0_1_2 - 0.001239557446155*G0_2_1 - 0.001304797311742*G0_2_2;
    A[2247] = -0.011873655536850*G0_1_1 - 0.021268196181391*G0_1_2 - 0.021268196181390*G0_2_1 - 0.030662736825931*G0_2_2;
    A[2248] = -0.061325473651862*G0_0_0 - 0.021268196181390*G0_0_2 - 0.042536392362781*G0_1_0 - 0.011873655536850*G0_1_2 - 0.021268196181390*G0_2_0;
    A[2249] = -0.025443547578964*G0_0_0 - 0.039078679486665*G0_0_2 - 0.040318236932820*G0_1_0 - 0.054018608706109*G0_1_2 - 0.039078679486665*G0_2_0 - 0.052844291125541*G0_2_2;
    A[2250] = -0.052844291125541*G0_0_0 - 0.039078679486665*G0_0_2 - 0.054018608706108*G0_1_0 - 0.040318236932820*G0_1_2 - 0.039078679486665*G0_2_0 - 0.025443547578964*G0_2_2;
    A[2251] = -0.021268196181391*G0_0_2 - 0.011873655536850*G0_1_0 - 0.042536392362781*G0_1_2 - 0.021268196181391*G0_2_0 - 0.061325473651862*G0_2_2;
    A[2252] = -0.030662736825931*G0_0_0 - 0.021268196181390*G0_0_1 - 0.021268196181391*G0_1_0 - 0.011873655536850*G0_1_1;
    A[2253] = -0.001304797311742*G0_0_0 - 0.001239557446155*G0_0_1 - 0.001239557446155*G0_1_0 - 0.001174317580567*G0_1_1;
    A[2254] = -0.015005169085030*G0_0_0 - 0.014939929219443*G0_0_1 - 0.014939929219443*G0_1_0 - 0.014874689353856*G0_1_1;
    A[2255] = 0.009394540644540*G0_0_1 + 0.009394540644541*G0_1_0 + 0.018789081289082*G0_1_1;
    A[2256] = -0.257045070413123*G0_0_0 - 0.257045070413123*G0_0_1 - 0.160751028806583*G0_0_2 - 0.064456987200041*G0_1_0 - 0.064456987200041*G0_1_1 - 0.092901568596012*G0_1_2 - 0.160751028806582*G0_2_0 - 0.160751028806583*G0_2_1 - 0.064456987200042*G0_2_2;
    A[2257] = 0.121346149991982*G0_0_0 + 0.121346149991982*G0_0_1 + 0.194675758911868*G0_0_2 + 0.132306447410612*G0_1_0 + 0.132306447410612*G0_1_1 + 0.058976838490727*G0_1_2 + 0.194675758911868*G0_2_0 + 0.194675758911868*G0_2_1 - 0.003392473010529*G0_2_2;
    A[2258] = -0.052844291125540*G0_0_0 - 0.052844291125540*G0_0_1 - 0.088791457064026*G0_0_2 - 0.051017574889102*G0_1_0 - 0.051017574889102*G0_1_1 - 0.004632030456683*G0_1_2 - 0.088791457064026*G0_2_0 - 0.088791457064026*G0_2_1 + 0.084681345532039*G0_2_2;
    A[2259] = 0.021268196181390*G0_0_2 + 0.011873655536850*G0_1_0 + 0.011873655536850*G0_1_1 - 0.014613729891508*G0_1_2 + 0.021268196181390*G0_2_0 + 0.021268196181390*G0_2_1 - 0.069349977119074*G0_2_2;
    A[2260] = -0.128522535206561*G0_0_0 - 0.032228493600021*G0_0_1 - 0.128522535206561*G0_0_2 - 0.032228493600020*G0_1_0 - 0.060673074995991*G0_1_1 - 0.032228493600020*G0_1_2 - 0.128522535206561*G0_2_0 - 0.032228493600021*G0_2_1 - 0.128522535206561*G0_2_2;
    A[2261] = 0.047625101878573*G0_0_0 - 0.014744209622682*G0_0_1 + 0.047625101878574*G0_0_2 - 0.014744209622682*G0_1_0 + 0.047625101878573*G0_1_1 - 0.014744209622683*G0_1_2 + 0.047625101878573*G0_2_0 - 0.014744209622682*G0_2_1 + 0.047625101878573*G0_2_2;
    A[2262] = -0.015005169085030*G0_0_0 + 0.022768713089894*G0_0_1 - 0.015005169085030*G0_0_2 + 0.022768713089894*G0_1_0 - 0.066544662898829*G0_1_1 + 0.022768713089894*G0_1_2 - 0.015005169085030*G0_2_0 + 0.022768713089894*G0_2_1 - 0.015005169085030*G0_2_2;
    A[2263] = -0.009394540644541*G0_0_1 - 0.009394540644541*G0_1_0 + 0.045341706583025*G0_1_1 - 0.009394540644541*G0_1_2 - 0.009394540644541*G0_2_1;
    A[2264] = -0.064456987200042*G0_0_0 - 0.160751028806582*G0_0_1 - 0.160751028806582*G0_0_2 - 0.092901568596012*G0_1_0 - 0.064456987200042*G0_1_1 - 0.064456987200042*G0_1_2 - 0.160751028806583*G0_2_0 - 0.257045070413123*G0_2_1 - 0.257045070413123*G0_2_2;
    A[2265] = -0.003392473010529*G0_0_0 + 0.194675758911867*G0_0_1 + 0.194675758911867*G0_0_2 + 0.058976838490727*G0_1_0 + 0.132306447410612*G0_1_1 + 0.132306447410612*G0_1_2 + 0.194675758911868*G0_2_0 + 0.121346149991982*G0_2_1 + 0.121346149991982*G0_2_2;
    A[2266] = 0.084681345532039*G0_0_0 - 0.088791457064025*G0_0_1 - 0.088791457064025*G0_0_2 - 0.004632030456683*G0_1_0 - 0.051017574889102*G0_1_1 - 0.051017574889102*G0_1_2 - 0.088791457064025*G0_2_0 - 0.052844291125540*G0_2_1 - 0.052844291125540*G0_2_2;
    A[2267] = -0.069349977119074*G0_0_0 + 0.021268196181390*G0_0_1 + 0.021268196181390*G0_0_2 - 0.014613729891508*G0_1_0 + 0.011873655536850*G0_1_1 + 0.011873655536850*G0_1_2 + 0.021268196181390*G0_2_0;
    A[2268] = -0.045667905910961*G0_0_0 - 0.075678244081021*G0_0_1 - 0.037839122040510*G0_0_2 - 0.075678244081022*G0_1_0 - 0.105688582251082*G0_1_1 - 0.052844291125541*G0_1_2 - 0.037839122040511*G0_2_0 - 0.052844291125541*G0_2_1;
    A[2269] = -0.022833952955480*G0_0_0 - 0.024138750267222*G0_0_1 - 0.012069375133611*G0_0_2 - 0.024138750267222*G0_1_0 - 0.025443547578963*G0_1_1 - 0.012721773789482*G0_1_2 - 0.012069375133611*G0_2_0 - 0.012721773789482*G0_2_1;
    A[2270] = -0.030010338170060*G0_0_1 - 0.015005169085030*G0_0_2 - 0.030010338170060*G0_1_0 - 0.060020676340120*G0_1_1 - 0.030010338170060*G0_1_2 - 0.015005169085030*G0_2_0 - 0.030010338170060*G0_2_1;
    A[2271] = -0.088073818542567*G0_0_0 - 0.100795592332049*G0_0_1 - 0.088726217198438*G0_0_2 - 0.100795592332050*G0_1_0 - 0.113517366121532*G0_1_1 - 0.100795592332050*G0_1_2 - 0.088726217198437*G0_2_0 - 0.100795592332049*G0_2_1 - 0.088073818542567*G0_2_2;
    A[2272] = -0.012721773789482*G0_0_1 - 0.012069375133611*G0_0_2 - 0.012721773789481*G0_1_0 - 0.025443547578964*G0_1_1 - 0.024138750267222*G0_1_2 - 0.012069375133610*G0_2_0 - 0.024138750267221*G0_2_1 - 0.022833952955480*G0_2_2;
    A[2273] = -0.052844291125540*G0_0_1 - 0.037839122040510*G0_0_2 - 0.052844291125541*G0_1_0 - 0.105688582251081*G0_1_1 - 0.075678244081021*G0_1_2 - 0.037839122040511*G0_2_0 - 0.075678244081021*G0_2_1 - 0.045667905910961*G0_2_2;
    A[2274] = 0.052191892469669*G0_0_0 + 0.323589733311952*G0_0_1 + 0.187890812890810*G0_0_2 + 0.323589733311953*G0_1_0 + 0.052191892469669*G0_1_1 + 0.187890812890811*G0_1_2 + 0.187890812890811*G0_2_0 + 0.187890812890811*G0_2_1 + 0.323589733311952*G0_2_2;
    A[2275] = -0.022833952955480*G0_0_0 - 0.096555001068889*G0_0_1 - 0.059694477012184*G0_0_2 - 0.096555001068888*G0_1_0 + 0.039143919352253*G0_1_1 - 0.028705540858317*G0_1_2 - 0.059694477012184*G0_2_0 - 0.028705540858319*G0_2_1 - 0.096555001068888*G0_2_2;
    A[2276] = 0.030010338170061*G0_0_1 + 0.015005169085030*G0_0_2 + 0.030010338170060*G0_1_0 - 0.045667905910961*G0_1_1 - 0.007828783870451*G0_1_2 + 0.015005169085030*G0_2_0 - 0.007828783870450*G0_2_1 + 0.030010338170060*G0_2_2;
    A[2277] = -0.088073818542567*G0_0_0 - 0.134067923781463*G0_0_1 - 0.097207399724760*G0_0_2 - 0.134067923781464*G0_1_0 - 0.156575677409008*G0_1_1 - 0.224425137619580*G0_1_2 - 0.097207399724759*G0_2_0 - 0.224425137619579*G0_2_1 - 0.292274597830150*G0_2_2;
    A[2278] = 0.012721773789481*G0_0_1 + 0.012069375133611*G0_0_2 + 0.012721773789482*G0_1_0 + 0.039143919352251*G0_1_1 + 0.044689307927154*G0_1_2 + 0.012069375133611*G0_2_0 + 0.044689307927154*G0_2_1 + 0.050234696502057*G0_2_2;
    A[2279] = 0.052844291125541*G0_0_1 + 0.037839122040510*G0_0_2 + 0.052844291125541*G0_1_0 + 0.052191892469670*G0_1_1 + 0.090031014510180*G0_1_2 + 0.037839122040511*G0_2_0 + 0.090031014510180*G0_2_1 + 0.127870136550691*G0_2_2;
    A[2280] = 0.647179466623904*G0_0_0 + 0.375781625781622*G0_0_1 + 0.375781625781622*G0_0_2 + 0.375781625781622*G0_1_0 + 0.647179466623905*G0_1_1 + 0.375781625781622*G0_1_2 + 0.375781625781622*G0_2_0 + 0.375781625781622*G0_2_1 + 0.647179466623904*G0_2_2;
    A[2281] = -0.584549195660300*G0_0_0 - 0.194414799449519*G0_0_1 - 0.321632537344339*G0_0_2 - 0.448850275239160*G0_1_0 - 0.268135847562929*G0_1_1 - 0.290643601190473*G0_1_2 - 0.321632537344340*G0_2_0 - 0.222141742324032*G0_2_1 - 0.268135847562928*G0_2_2;
    A[2282] = 0.255740273101381*G0_0_0 + 0.075678244081021*G0_0_1 + 0.127870136550690*G0_0_2 + 0.180062029020360*G0_1_0 + 0.105688582251082*G0_1_1 + 0.105036183595210*G0_1_2 + 0.127870136550691*G0_2_0 + 0.052844291125541*G0_2_1 + 0.105688582251081*G0_2_2;
    A[2283] = -0.268135847562928*G0_0_0 - 0.222141742324032*G0_0_1 - 0.321632537344340*G0_0_2 - 0.290643601190473*G0_1_0 - 0.268135847562928*G0_1_1 - 0.448850275239161*G0_1_2 - 0.321632537344339*G0_2_0 - 0.194414799449520*G0_2_1 - 0.584549195660302*G0_2_2;
    A[2284] = 0.172233245149910*G0_0_0 + 0.100795592332049*G0_0_1 + 0.166035457919137*G0_0_2 + 0.198655390712680*G0_1_0 + 0.113517366121532*G0_1_1 + 0.198655390712681*G0_1_2 + 0.166035457919137*G0_2_0 + 0.100795592332049*G0_2_1 + 0.172233245149910*G0_2_2;
    A[2285] = 0.105688582251081*G0_0_0 + 0.052844291125540*G0_0_1 + 0.127870136550691*G0_0_2 + 0.105036183595211*G0_1_0 + 0.105688582251081*G0_1_1 + 0.180062029020361*G0_1_2 + 0.127870136550691*G0_2_0 + 0.075678244081021*G0_2_1 + 0.255740273101382*G0_2_2;
    A[2286] = 0.323589733311951*G0_0_0 + 0.187890812890811*G0_0_1 + 0.187890812890810*G0_0_2 + 0.187890812890810*G0_1_0 + 0.052191892469669*G0_1_1 + 0.323589733311952*G0_1_2 + 0.187890812890811*G0_2_0 + 0.323589733311952*G0_2_1 + 0.052191892469670*G0_2_2;
    A[2287] = -0.292274597830149*G0_0_0 - 0.224425137619580*G0_0_1 - 0.097207399724760*G0_0_2 - 0.224425137619579*G0_1_0 - 0.156575677409010*G0_1_1 - 0.134067923781465*G0_1_2 - 0.097207399724760*G0_2_0 - 0.134067923781464*G0_2_1 - 0.088073818542568*G0_2_2;
    A[2288] = 0.127870136550690*G0_0_0 + 0.090031014510180*G0_0_1 + 0.037839122040510*G0_0_2 + 0.090031014510180*G0_1_0 + 0.052191892469669*G0_1_1 + 0.052844291125541*G0_1_2 + 0.037839122040510*G0_2_0 + 0.052844291125541*G0_2_1;
    A[2289] = -0.096555001068888*G0_0_0 - 0.028705540858318*G0_0_1 - 0.059694477012185*G0_0_2 - 0.028705540858318*G0_1_0 + 0.039143919352253*G0_1_1 - 0.096555001068889*G0_1_2 - 0.059694477012185*G0_2_0 - 0.096555001068889*G0_2_1 - 0.022833952955481*G0_2_2;
    A[2290] = 0.050234696502057*G0_0_0 + 0.044689307927155*G0_0_1 + 0.012069375133611*G0_0_2 + 0.044689307927155*G0_1_0 + 0.039143919352253*G0_1_1 + 0.012721773789482*G0_1_2 + 0.012069375133611*G0_2_0 + 0.012721773789482*G0_2_1;
    A[2291] = 0.030010338170060*G0_0_0 - 0.007828783870450*G0_0_1 + 0.015005169085030*G0_0_2 - 0.007828783870451*G0_1_0 - 0.045667905910962*G0_1_1 + 0.030010338170059*G0_1_2 + 0.015005169085030*G0_2_0 + 0.030010338170060*G0_2_1;
    A[2292] = -0.150051690850299*G0_0_0 - 0.466465038947673*G0_0_1 - 0.335985307773497*G0_0_2 - 0.466465038947674*G0_1_0 - 0.782878387045047*G0_1_1 - 0.466465038947672*G0_1_2 - 0.335985307773498*G0_2_0 - 0.466465038947673*G0_2_1 - 0.150051690850300*G0_2_2;
    A[2293] = 0.143527704291591*G0_0_0 + 0.218553549716740*G0_0_1 + 0.185933616923197*G0_0_2 + 0.218553549716743*G0_1_0 + 0.293579395141892*G0_1_1 + 0.234863516113515*G0_1_2 + 0.185933616923198*G0_2_0 + 0.234863516113514*G0_2_1 + 0.176147637085135*G0_2_2;
    A[2294] = 0.045667905910961*G0_0_0 + 0.120693751336111*G0_0_1 + 0.071763852145797*G0_0_2 + 0.120693751336111*G0_1_0 + 0.195719596761263*G0_1_1 + 0.120693751336112*G0_1_2 + 0.071763852145796*G0_2_0 + 0.120693751336111*G0_2_1 + 0.045667905910961*G0_2_2;
    A[2295] = 0.176147637085134*G0_0_0 + 0.234863516113514*G0_0_1 + 0.185933616923197*G0_0_2 + 0.234863516113513*G0_1_0 + 0.293579395141892*G0_1_1 + 0.218553549716741*G0_1_2 + 0.185933616923196*G0_2_0 + 0.218553549716741*G0_2_1 + 0.143527704291591*G0_2_2;
    A[2296] = -0.029847238506092*G0_0_0 - 0.029847238506092*G0_0_1 - 0.029847238506093*G0_0_2 - 0.034571909571909*G0_1_0 - 0.034571909571909*G0_1_1 - 0.034571909571909*G0_1_2 - 0.029847238506092*G0_2_0 - 0.029847238506092*G0_2_1 - 0.029847238506092*G0_2_2;
    A[2297] = -0.029847238506093*G0_0_0 + 0.004724671065817*G0_1_0;
    A[2298] = -0.009464999699375*G0_1_1;
    A[2299] = 0.002278176106301*G0_1_2 + 0.011743175805676*G0_2_2;
    A[2300] = 0.006589226424296*G0_1_1 + 0.003294613212148*G0_1_2 + 0.003294613212148*G0_2_1;
    A[2301] = 0.004501550725509*G0_1_1 + 0.001924576034819*G0_1_2 + 0.001924576034819*G0_2_1 - 0.000652398655870*G0_2_2;
    A[2302] = -0.010503618359521*G0_1_1 - 0.013080593050211*G0_1_2 - 0.013080593050211*G0_2_1 - 0.015657567740902*G0_2_2;
    A[2303] = -0.002544354757896*G0_1_1 - 0.005838967970044*G0_1_2 - 0.005838967970044*G0_2_1 - 0.009133581182192*G0_2_2;
    A[2304] = 0.128522535206562*G0_0_0 + 0.042275432900432*G0_0_2 + 0.084550865800865*G0_1_0 + 0.042960451489096*G0_1_2 + 0.042275432900433*G0_2_0;
    A[2305] = 0.037186723384640*G0_0_0 + 0.074340826836486*G0_0_2 + 0.080832193462401*G0_1_0 + 0.108232937008978*G0_1_2 + 0.074340826836486*G0_2_0 + 0.104709984267275*G0_2_2;
    A[2306] = -0.006197787230773*G0_0_0 + 0.018886941087461*G0_0_2 + 0.009394540644540*G0_1_0 + 0.037773882174923*G0_1_2 + 0.018886941087462*G0_2_0 + 0.056758683060766*G0_2_2;
    A[2307] = -0.005838967970044*G0_0_2 - 0.002544354757896*G0_1_0 - 0.014287530563572*G0_1_2 - 0.005838967970044*G0_2_0 - 0.043547610279381*G0_2_2;
    A[2308] = 0.064261267603281*G0_0_0 + 0.042275432900432*G0_0_1 + 0.042275432900432*G0_1_0 + 0.042960451489096*G0_1_1;
    A[2309] = 0.008807381854257*G0_0_0 + 0.006491366625916*G0_0_1 + 0.006491366625915*G0_1_0 + 0.003522952741703*G0_1_1;
    A[2310] = -0.000652398655871*G0_0_0 - 0.009492400442922*G0_0_1 - 0.009492400442922*G0_1_0 - 0.018984800885843*G0_1_1;
    A[2311] = 0.003294613212148*G0_0_1 + 0.003294613212148*G0_1_0 + 0.029260079715809*G0_1_1;
    A[2312] = 0.128522535206561*G0_0_0 + 0.128522535206561*G0_0_1 + 0.086247102306130*G0_0_2 + 0.043971669405696*G0_1_0 + 0.043971669405696*G0_1_1 + 0.044656687994361*G0_1_2 + 0.086247102306129*G0_2_0 + 0.086247102306129*G0_2_1 + 0.043971669405697*G0_2_2;
    A[2313] = 0.037186723384640*G0_0_0 + 0.037186723384640*G0_0_1 - 0.037154103451847*G0_0_2 - 0.043645470077761*G0_1_0 - 0.043645470077761*G0_1_1 - 0.009753359905270*G0_1_2 - 0.037154103451846*G0_2_0 - 0.037154103451845*G0_2_1 - 0.006784946021057*G0_2_2;
    A[2314] = -0.006197787230773*G0_0_0 - 0.006197787230773*G0_0_1 - 0.025084728318235*G0_0_2 - 0.015592327875314*G0_1_0 - 0.015592327875314*G0_1_1 + 0.003294613212148*G0_1_2 - 0.025084728318235*G0_2_0 - 0.025084728318235*G0_2_1 + 0.012787013655069*G0_2_2;
    A[2315] = 0.005838967970044*G0_0_2 + 0.002544354757896*G0_1_0 + 0.002544354757896*G0_1_1 - 0.005904207835631*G0_1_2 + 0.005838967970044*G0_2_0 + 0.005838967970044*G0_2_1 - 0.031869674339292*G0_2_2;
    A[2316] = 0.064261267603280*G0_0_0 + 0.021985834702848*G0_0_1 + 0.064261267603280*G0_0_2 + 0.021985834702848*G0_1_0 + 0.022670853291513*G0_1_1 + 0.021985834702848*G0_1_2 + 0.064261267603280*G0_2_0 + 0.021985834702848*G0_2_1 + 0.064261267603281*G0_2_2;
    A[2317] = 0.008807381854257*G0_0_0 + 0.002316015228342*G0_0_1 + 0.008807381854257*G0_0_2 + 0.002316015228342*G0_1_0 - 0.000652398655871*G0_1_1 + 0.002316015228342*G0_1_2 + 0.008807381854257*G0_2_0 + 0.002316015228342*G0_2_1 + 0.008807381854257*G0_2_2;
    A[2318] = -0.000652398655871*G0_0_0 + 0.008840001787050*G0_0_1 - 0.000652398655871*G0_0_2 + 0.008840001787050*G0_1_0 - 0.000652398655871*G0_1_1 + 0.008840001787050*G0_1_2 - 0.000652398655871*G0_2_0 + 0.008840001787050*G0_2_1 - 0.000652398655871*G0_2_2;
    A[2319] = -0.003294613212148*G0_0_1 - 0.003294613212148*G0_1_0 + 0.022670853291513*G0_1_1 - 0.003294613212148*G0_1_2 - 0.003294613212148*G0_2_1;
    A[2320] = 0.092086070276173*G0_0_0 + 0.134361503176605*G0_0_1 + 0.134361503176606*G0_0_2 + 0.128000616281865*G0_1_0 + 0.127315597693200*G0_1_1 + 0.127315597693200*G0_1_2 + 0.134361503176606*G0_2_0 + 0.176636936077038*G0_2_1 + 0.176636936077038*G0_2_2;
    A[2321] = -0.062238831770081*G0_0_0 - 0.250814663249555*G0_0_1 - 0.250814663249555*G0_0_2 - 0.160783648739376*G0_1_0 - 0.166948816037355*G0_1_1 - 0.166948816037355*G0_1_2 - 0.250814663249556*G0_2_0 - 0.334680510461757*G0_2_1 - 0.334680510461757*G0_2_2;
    A[2322] = -0.062238831770082*G0_0_0 + 0.188575831479474*G0_0_1 + 0.188575831479474*G0_0_2 + 0.098544816969295*G0_1_0 + 0.182410664181494*G0_1_1 + 0.182410664181494*G0_1_2 + 0.188575831479475*G0_2_0 + 0.104709984267274*G0_2_1 + 0.104709984267274*G0_2_2;
    A[2323] = 0.092086070276174*G0_0_0 - 0.042275432900431*G0_0_1 - 0.042275432900431*G0_0_2 - 0.035914546005691*G0_1_0 - 0.042960451489096*G0_1_1 - 0.042960451489096*G0_1_2 - 0.042275432900432*G0_2_0;
    A[2324] = 0.039143919352253*G0_0_0 + 0.135698920421141*G0_0_1 + 0.067849460210570*G0_0_2 + 0.135698920421142*G0_1_0 + 0.209419968534549*G0_1_1 + 0.104709984267274*G0_1_2 + 0.067849460210570*G0_2_0 + 0.104709984267275*G0_2_1;
    A[2325] = -0.004892989919032*G0_0_0 + 0.028379341530382*G0_0_1 + 0.014189670765191*G0_0_2 + 0.028379341530382*G0_1_0 + 0.056758683060766*G0_1_1 + 0.028379341530382*G0_1_2 + 0.014189670765191*G0_2_0 + 0.028379341530383*G0_2_1;
    A[2326] = -0.001304797311742*G0_0_1 - 0.000652398655870*G0_0_2 - 0.001304797311741*G0_1_0 - 0.025443547578964*G0_1_1 - 0.012721773789481*G0_1_2 - 0.000652398655871*G0_2_0 - 0.012721773789482*G0_2_1;
    A[2327] = 0.019571959676125*G0_0_0 + 0.074862745761182*G0_0_1 + 0.060673074995990*G0_0_2 + 0.074862745761182*G0_1_0 + 0.149725491522365*G0_1_1 + 0.121346149991983*G0_1_2 + 0.060673074995991*G0_2_0 + 0.121346149991982*G0_2_1 + 0.092966808461599*G0_2_2;
    A[2328] = -0.018104062700416*G0_0_1 - 0.010275278829966*G0_0_2 - 0.018104062700417*G0_1_0 - 0.016636165724707*G0_1_1 + 0.001467896975709*G0_1_2 - 0.010275278829966*G0_2_0 + 0.001467896975710*G0_2_1 + 0.019571959676126*G0_2_2;
    A[2329] = -0.006197787230774*G0_0_1 - 0.005545388574902*G0_0_2 - 0.006197787230773*G0_1_0 + 0.013700371773288*G0_1_1 + 0.026422145562770*G0_1_2 - 0.005545388574902*G0_2_0 + 0.026422145562770*G0_2_1 + 0.039143919352252*G0_2_2;
    A[2330] = 0.039143919352252*G0_0_0 - 0.096555001068889*G0_0_1 - 0.028705540858318*G0_0_2 - 0.096555001068890*G0_1_0 - 0.022833952955481*G0_1_1 - 0.059694477012185*G0_1_2 - 0.028705540858318*G0_2_0 - 0.059694477012185*G0_2_1 - 0.096555001068889*G0_2_2;
    A[2331] = -0.004892989919032*G0_0_0 - 0.033272331449415*G0_0_1 - 0.019082660684224*G0_0_2 - 0.033272331449415*G0_1_0 - 0.004892989919031*G0_1_1 - 0.019082660684223*G0_1_2 - 0.019082660684223*G0_2_0 - 0.019082660684223*G0_2_1 - 0.033272331449415*G0_2_2;
    A[2332] = 0.001304797311741*G0_0_1 + 0.000652398655871*G0_0_2 + 0.001304797311741*G0_1_0 - 0.022833952955481*G0_1_1 - 0.010764577821869*G0_1_2 + 0.000652398655871*G0_2_0 - 0.010764577821870*G0_2_1 + 0.001304797311742*G0_2_2;
    A[2333] = 0.019571959676126*G0_0_0 - 0.055290786085057*G0_0_1 - 0.041101115319865*G0_0_2 - 0.055290786085057*G0_1_0 + 0.019571959676125*G0_1_1 + 0.005382288910935*G0_1_2 - 0.041101115319865*G0_2_0 + 0.005382288910934*G0_2_1 - 0.008807381854257*G0_2_2;
    A[2334] = 0.018104062700417*G0_0_1 + 0.010275278829966*G0_0_2 + 0.018104062700417*G0_1_0 + 0.019571959676127*G0_1_1 + 0.029847238506092*G0_1_2 + 0.010275278829966*G0_2_0 + 0.029847238506093*G0_2_1 + 0.040122517336058*G0_2_2;
    A[2335] = 0.006197787230773*G0_0_1 + 0.005545388574902*G0_0_2 + 0.006197787230773*G0_1_0 + 0.026095946234835*G0_1_1 + 0.038165321368446*G0_1_2 + 0.005545388574902*G0_2_0 + 0.038165321368446*G0_2_1 + 0.050234696502057*G0_2_2;
    A[2336] = -0.584549195660300*G0_0_0 - 0.448850275239160*G0_0_1 - 0.321632537344340*G0_0_2 - 0.194414799449519*G0_1_0 - 0.268135847562929*G0_1_1 - 0.222141742324032*G0_1_2 - 0.321632537344339*G0_2_0 - 0.290643601190473*G0_2_1 - 0.268135847562928*G0_2_2;
    A[2337] = 0.912053320907477*G0_0_0 + 0.456026660453738*G0_0_1 + 0.456026660453739*G0_0_2 + 0.456026660453738*G0_1_0 + 0.726119703984280*G0_1_1 + 0.456026660453739*G0_1_2 + 0.456026660453739*G0_2_0 + 0.456026660453739*G0_2_1 + 0.726119703984280*G0_2_2;
    A[2338] = -0.584549195660300*G0_0_0 - 0.135698920421141*G0_0_1 - 0.262916658315960*G0_0_2 - 0.390134396210780*G0_1_0 - 0.209419968534549*G0_1_1 - 0.290643601190473*G0_1_2 - 0.262916658315961*G0_2_0 - 0.104709984267275*G0_2_1 - 0.209419968534549*G0_2_2;
    A[2339] = -0.037186723384640*G0_0_0 + 0.037676022376543*G0_0_1 + 0.186912214907006*G0_0_2 + 0.140428810676205*G0_1_0 + 0.065566064915023*G0_1_1 + 0.037676022376543*G0_1_2 + 0.186912214907004*G0_2_0 + 0.140428810676205*G0_2_1 - 0.037186723384640*G0_2_2;
    A[2340] = -0.037186723384640*G0_0_0 - 0.074862745761182*G0_0_1 - 0.224098938291645*G0_0_2 - 0.177615534060845*G0_1_0 - 0.149725491522365*G0_1_1 - 0.326851726591307*G0_1_2 - 0.224098938291644*G0_2_0 - 0.121346149991982*G0_2_1 - 0.448197876583290*G0_2_2;
    A[2341] = 0.012395574461547*G0_0_0 + 0.006197787230774*G0_0_1 + 0.006197787230773*G0_0_2 + 0.006197787230774*G0_1_0 - 0.013700371773288*G0_1_1 + 0.071437652817861*G0_1_2 + 0.006197787230774*G0_2_0 - 0.026422145562770*G0_2_1 + 0.172233245149911*G0_2_2;
    A[2342] = -0.292274597830149*G0_0_0 - 0.097207399724760*G0_0_1 - 0.224425137619579*G0_0_2 - 0.097207399724759*G0_1_0 - 0.088073818542568*G0_1_1 - 0.134067923781464*G0_1_2 - 0.224425137619579*G0_2_0 - 0.134067923781464*G0_2_1 - 0.156575677409009*G0_2_2;
    A[2343] = 0.456026660453737*G0_0_0 + 0.228013330226869*G0_0_1 + 0.228013330226868*G0_0_2 + 0.228013330226868*G0_1_0 + 0.092966808461599*G0_1_1 + 0.363059851992139*G0_1_2 + 0.228013330226869*G0_2_0 + 0.363059851992140*G0_2_1 + 0.092966808461599*G0_2_2;
    A[2344] = -0.292274597830149*G0_0_0 - 0.195067198105390*G0_0_1 - 0.067849460210570*G0_0_2 - 0.195067198105389*G0_1_0 - 0.185933616923198*G0_1_1 - 0.104709984267274*G0_1_2 - 0.067849460210570*G0_2_0 - 0.104709984267275*G0_2_1;
    A[2345] = -0.008807381854257*G0_0_0 - 0.041101115319865*G0_0_1 + 0.005382288910935*G0_0_2 - 0.041101115319865*G0_1_0 + 0.019571959676127*G0_1_1 - 0.055290786085056*G0_1_2 + 0.005382288910935*G0_2_0 - 0.055290786085057*G0_2_1 + 0.019571959676127*G0_2_2;
    A[2346] = -0.008807381854256*G0_0_0 + 0.032293733465609*G0_0_1 - 0.014189670765191*G0_0_2 + 0.032293733465608*G0_1_0 + 0.092966808461599*G0_1_1 - 0.028379341530383*G0_1_2 - 0.014189670765191*G0_2_0 - 0.028379341530383*G0_2_1;
    A[2347] = 0.001304797311742*G0_0_0 + 0.000652398655870*G0_0_1 + 0.000652398655871*G0_0_2 + 0.000652398655871*G0_1_0 - 0.088073818542568*G0_1_1 + 0.012721773789482*G0_1_2 + 0.000652398655871*G0_2_0 + 0.012721773789482*G0_2_1;
    A[2348] = -0.039143919352254*G0_0_0 + 0.445262082631871*G0_0_1 + 0.249542485870607*G0_0_2 + 0.445262082631870*G0_1_0 + 0.146789697570946*G0_1_1 + 0.249542485870608*G0_1_2 + 0.249542485870608*G0_2_0 + 0.249542485870609*G0_2_1 + 0.352295274170271*G0_2_2;
    A[2349] = -0.039143919352252*G0_0_0 - 0.484406001984120*G0_0_1 - 0.288686405222858*G0_0_2 - 0.484406001984122*G0_1_0 - 0.782878387045046*G0_1_1 - 0.484406001984122*G0_1_2 - 0.288686405222860*G0_2_0 - 0.484406001984121*G0_2_1 - 0.185933616923198*G0_2_2;
    A[2350] = 0.009785979838064*G0_0_0 + 0.004892989919031*G0_0_1 + 0.004892989919030*G0_0_2 + 0.004892989919032*G0_1_0 + 0.146789697570946*G0_1_1 + 0.053822889109346*G0_1_2 + 0.004892989919032*G0_2_0 + 0.053822889109347*G0_2_1 - 0.039143919352253*G0_2_2;
    A[2351] = -0.039143919352251*G0_0_0 - 0.019571959676127*G0_0_1 - 0.019571959676125*G0_0_2 - 0.019571959676125*G0_1_0 - 0.048929899190316*G0_1_1 - 0.141896707651914*G0_1_2 - 0.019571959676126*G0_2_0 - 0.141896707651915*G0_2_1 - 0.234863516113513*G0_2_2;
    A[2352] = 0.018919561020255*G0_0_0 + 0.018919561020255*G0_0_1 + 0.018919561020255*G0_0_2 + 0.013742125287264*G0_1_0 + 0.013742125287264*G0_1_1 + 0.013742125287264*G0_1_2 + 0.018919561020255*G0_2_0 + 0.018919561020255*G0_2_1 + 0.018919561020255*G0_2_2;
    A[2353] = 0.033598530777350*G0_0_0 - 0.014394523943135*G0_1_0;
    A[2354] = -0.013742125287264*G0_1_1;
    A[2355] = 0.005177435732991*G0_1_2 + 0.018919561020255*G0_2_2;
    A[2356] = 0.018789081289081*G0_1_1 + 0.009394540644541*G0_1_2 + 0.009394540644540*G0_2_1;
    A[2357] = -0.014874689353856*G0_1_1 - 0.014939929219443*G0_1_2 - 0.014939929219443*G0_2_1 - 0.015005169085030*G0_2_2;
    A[2358] = -0.001174317580567*G0_1_1 - 0.001239557446154*G0_1_2 - 0.001239557446155*G0_2_1 - 0.001304797311742*G0_2_2;
    A[2359] = -0.011873655536850*G0_1_1 - 0.021268196181391*G0_1_2 - 0.021268196181390*G0_2_1 - 0.030662736825931*G0_2_2;
    A[2360] = -0.257045070413123*G0_0_0 - 0.096294041606540*G0_0_2 - 0.192588083213081*G0_1_0 - 0.124738623002510*G0_1_2 - 0.096294041606541*G0_2_0;
    A[2361] = 0.121346149991982*G0_0_0 - 0.073329608919887*G0_0_2 - 0.010960297418631*G0_1_0 - 0.146659217839773*G0_1_2 - 0.073329608919886*G0_2_0 - 0.271397840842283*G0_2_2;
    A[2362] = -0.052844291125540*G0_0_0 + 0.035947165938486*G0_0_2 - 0.001826716236438*G0_1_0 + 0.082332710370905*G0_1_2 + 0.035947165938485*G0_2_0 + 0.209419968534550*G0_2_2;
    A[2363] = -0.021268196181391*G0_0_2 - 0.011873655536850*G0_1_0 - 0.047755581609748*G0_1_2 - 0.021268196181390*G0_2_0 - 0.111886369481855*G0_2_2;
    A[2364] = -0.128522535206561*G0_0_0 - 0.096294041606540*G0_0_1 - 0.096294041606541*G0_1_0 - 0.124738623002510*G0_1_1;
    A[2365] = 0.047625101878574*G0_0_0 + 0.062369311501255*G0_0_1 + 0.062369311501256*G0_1_0 + 0.124738623002510*G0_1_1;
    A[2366] = -0.015005169085030*G0_0_0 - 0.037773882174923*G0_0_1 - 0.037773882174924*G0_1_0 - 0.127087258163646*G0_1_1;
    A[2367] = 0.009394540644540*G0_0_1 + 0.009394540644541*G0_1_0 + 0.064130787872107*G0_1_1;
    A[2368] = -0.061325473651862*G0_0_0 - 0.061325473651862*G0_0_1 - 0.040057277470472*G0_0_2 - 0.018789081289081*G0_1_0 - 0.018789081289081*G0_1_1 - 0.009394540644540*G0_1_2 - 0.040057277470472*G0_2_0 - 0.040057277470471*G0_2_1 - 0.018789081289081*G0_2_2;
    A[2369] = -0.025443547578964*G0_0_0 - 0.025443547578964*G0_0_1 + 0.013635131907702*G0_0_2 + 0.014874689353856*G0_1_0 + 0.014874689353856*G0_1_1 - 0.000065239865587*G0_1_2 + 0.013635131907701*G0_2_0 + 0.013635131907701*G0_2_1 - 0.000130479731174*G0_2_2;
    A[2370] = -0.052844291125541*G0_0_0 - 0.052844291125541*G0_0_1 - 0.013765611638876*G0_0_2 + 0.001174317580567*G0_1_0 + 0.001174317580568*G0_1_1 - 0.000065239865587*G0_1_2 - 0.013765611638876*G0_2_0 - 0.013765611638876*G0_2_1 - 0.000130479731174*G0_2_2;
    A[2371] = 0.021268196181391*G0_0_2 + 0.011873655536850*G0_1_0 + 0.011873655536850*G0_1_1 - 0.009394540644541*G0_1_2 + 0.021268196181390*G0_2_0 + 0.021268196181390*G0_2_1 - 0.018789081289081*G0_2_2;
    A[2372] = -0.030662736825930*G0_0_0 - 0.009394540644540*G0_0_1 - 0.030662736825931*G0_0_2 - 0.009394540644540*G0_1_0 - 0.009394540644540*G0_1_2 - 0.030662736825931*G0_2_0 - 0.009394540644540*G0_2_1 - 0.030662736825931*G0_2_2;
    A[2373] = -0.001304797311742*G0_0_0 - 0.000065239865587*G0_0_1 - 0.001304797311742*G0_0_2 - 0.000065239865588*G0_1_0 - 0.000065239865588*G0_1_2 - 0.001304797311742*G0_2_0 - 0.000065239865587*G0_2_1 - 0.001304797311742*G0_2_2;
    A[2374] = -0.015005169085030*G0_0_0 - 0.000065239865587*G0_0_1 - 0.015005169085030*G0_0_2 - 0.000065239865587*G0_1_0 - 0.000065239865587*G0_1_2 - 0.015005169085030*G0_2_0 - 0.000065239865587*G0_2_1 - 0.015005169085030*G0_2_2;
    A[2375] = -0.009394540644541*G0_0_1 - 0.009394540644541*G0_1_0 - 0.009394540644541*G0_1_2 - 0.009394540644541*G0_2_1;
    A[2376] = -0.069349977119073*G0_0_0 - 0.090618173300463*G0_0_1 - 0.090618173300463*G0_0_2 - 0.054736247227566*G0_1_0 - 0.064130787872106*G0_1_1 - 0.064130787872106*G0_1_2 - 0.090618173300464*G0_2_0 - 0.111886369481854*G0_2_1 - 0.111886369481854*G0_2_2;
    A[2377] = 0.084681345532038*G0_0_0 + 0.173472802596064*G0_0_1 + 0.173472802596064*G0_0_2 + 0.089313375988722*G0_1_0 + 0.127087258163645*G0_1_1 + 0.127087258163645*G0_1_2 + 0.173472802596064*G0_2_0 + 0.209419968534549*G0_2_1 + 0.209419968534549*G0_2_2;
    A[2378] = -0.003392473010528*G0_0_0 - 0.198068231922395*G0_0_1 - 0.198068231922395*G0_0_2 - 0.062369311501255*G0_1_0 - 0.124738623002510*G0_1_1 - 0.124738623002510*G0_1_2 - 0.198068231922396*G0_2_0 - 0.271397840842282*G0_2_1 - 0.271397840842282*G0_2_2;
    A[2379] = -0.064456987200043*G0_0_0 + 0.096294041606540*G0_0_1 + 0.096294041606540*G0_0_2 + 0.028444581395970*G0_1_0 + 0.124738623002510*G0_1_1 + 0.124738623002510*G0_1_2 + 0.096294041606540*G0_2_0;
    A[2380] = 0.052191892469670*G0_0_0 - 0.271397840842283*G0_0_1 - 0.135698920421141*G0_0_2 - 0.271397840842283*G0_1_0 - 0.542795681684566*G0_1_1 - 0.271397840842283*G0_1_2 - 0.135698920421142*G0_2_0 - 0.271397840842283*G0_2_1;
    A[2381] = -0.022833952955480*G0_0_0 + 0.073721048113409*G0_0_1 + 0.036860524056705*G0_0_2 + 0.073721048113409*G0_1_0 + 0.209419968534550*G0_1_1 + 0.104709984267275*G0_1_2 + 0.036860524056704*G0_2_0 + 0.104709984267274*G0_2_1;
    A[2382] = -0.030010338170060*G0_0_1 - 0.015005169085030*G0_0_2 - 0.030010338170060*G0_1_0 - 0.105688582251082*G0_1_1 - 0.052844291125541*G0_1_2 - 0.015005169085030*G0_2_0 - 0.052844291125540*G0_2_1;
    A[2383] = -0.088073818542567*G0_0_0 + 0.045994105238897*G0_0_1 + 0.009133581182193*G0_0_2 + 0.045994105238897*G0_1_0 + 0.023486351611351*G0_1_1 - 0.081223632655924*G0_1_2 + 0.009133581182192*G0_2_0 - 0.081223632655924*G0_2_1 - 0.185933616923199*G0_2_2;
    A[2384] = -0.012721773789483*G0_0_1 - 0.012069375133612*G0_0_2 - 0.012721773789482*G0_1_0 + 0.013700371773288*G0_1_1 + 0.019898159004061*G0_1_2 - 0.012069375133611*G0_2_0 + 0.019898159004061*G0_2_1 + 0.026095946234835*G0_2_2;
    A[2385] = -0.052844291125540*G0_0_1 - 0.037839122040511*G0_0_2 - 0.052844291125541*G0_1_0 - 0.053496689781412*G0_1_1 - 0.000652398655871*G0_1_2 - 0.037839122040511*G0_2_0 - 0.000652398655871*G0_2_1 + 0.052191892469669*G0_2_2;
    A[2386] = -0.045667905910961*G0_0_0 + 0.030010338170060*G0_0_1 - 0.007828783870451*G0_0_2 + 0.030010338170060*G0_1_0 + 0.015005169085030*G0_1_2 - 0.007828783870450*G0_2_0 + 0.015005169085030*G0_2_1 + 0.030010338170060*G0_2_2;
    A[2387] = -0.022833952955480*G0_0_0 + 0.001304797311742*G0_0_1 - 0.010764577821869*G0_0_2 + 0.001304797311742*G0_1_0 + 0.000652398655872*G0_1_2 - 0.010764577821869*G0_2_0 + 0.000652398655871*G0_2_1 + 0.001304797311742*G0_2_2;
    A[2388] = 0.030010338170060*G0_0_1 + 0.015005169085030*G0_0_2 + 0.030010338170060*G0_1_0 + 0.015005169085030*G0_1_2 + 0.015005169085030*G0_2_0 + 0.015005169085031*G0_2_1 + 0.030010338170059*G0_2_2;
    A[2389] = -0.088073818542568*G0_0_0 + 0.012721773789482*G0_0_1 + 0.000652398655871*G0_0_2 + 0.012721773789482*G0_1_0 + 0.000652398655871*G0_1_2 + 0.000652398655870*G0_2_0 + 0.000652398655871*G0_2_1 + 0.001304797311742*G0_2_2;
    A[2390] = 0.012721773789482*G0_0_1 + 0.012069375133611*G0_0_2 + 0.012721773789482*G0_1_0 + 0.000652398655871*G0_1_2 + 0.012069375133611*G0_2_0 + 0.000652398655871*G0_2_1 + 0.001304797311742*G0_2_2;
    A[2391] = 0.052844291125541*G0_0_1 + 0.037839122040511*G0_0_2 + 0.052844291125541*G0_1_0 + 0.015005169085030*G0_1_2 + 0.037839122040511*G0_2_0 + 0.015005169085030*G0_2_1 + 0.030010338170060*G0_2_2;
    A[2392] = 0.255740273101381*G0_0_0 + 0.180062029020360*G0_0_1 + 0.127870136550691*G0_0_2 + 0.075678244081021*G0_1_0 + 0.105688582251082*G0_1_1 + 0.052844291125541*G0_1_2 + 0.127870136550690*G0_2_0 + 0.105036183595210*G0_2_1 + 0.105688582251081*G0_2_2;
    A[2393] = -0.584549195660300*G0_0_0 - 0.390134396210780*G0_0_1 - 0.262916658315961*G0_0_2 - 0.135698920421141*G0_1_0 - 0.209419968534549*G0_1_1 - 0.104709984267275*G0_1_2 - 0.262916658315960*G0_2_0 - 0.290643601190473*G0_2_1 - 0.209419968534549*G0_2_2;
    A[2394] = 0.647179466623904*G0_0_0 + 0.271397840842282*G0_0_1 + 0.271397840842282*G0_0_2 + 0.271397840842282*G0_1_0 + 0.542795681684565*G0_1_1 + 0.271397840842283*G0_1_2 + 0.271397840842282*G0_2_0 + 0.271397840842283*G0_2_1 + 0.542795681684565*G0_2_2;
    A[2395] = 0.172233245149910*G0_0_0 + 0.071437652817860*G0_0_1 + 0.006197787230773*G0_0_2 - 0.026422145562770*G0_1_0 - 0.013700371773288*G0_1_1 + 0.006197787230773*G0_1_2 + 0.006197787230774*G0_2_0 + 0.006197787230773*G0_2_1 + 0.012395574461546*G0_2_2;
    A[2396] = -0.268135847562928*G0_0_0 - 0.045994105238897*G0_0_1 + 0.053496689781411*G0_0_2 + 0.022507753627545*G0_1_0 - 0.023486351611351*G0_1_1 - 0.104709984267275*G0_1_2 + 0.053496689781411*G0_2_0 + 0.081223632655924*G0_2_1 - 0.209419968534551*G0_2_2;
    A[2397] = 0.105688582251081*G0_0_0 + 0.052844291125540*G0_0_1 - 0.022181554299609*G0_0_2 + 0.000652398655871*G0_1_0 + 0.053496689781412*G0_1_1 + 0.052844291125541*G0_1_2 - 0.022181554299609*G0_2_0 + 0.000652398655871*G0_2_1 + 0.105688582251082*G0_2_2;
    A[2398] = 0.127870136550690*G0_0_0 + 0.037839122040510*G0_0_1 + 0.090031014510179*G0_0_2 + 0.037839122040510*G0_1_0 + 0.052844291125541*G0_1_2 + 0.090031014510180*G0_2_0 + 0.052844291125541*G0_2_1 + 0.052191892469669*G0_2_2;
    A[2399] = -0.292274597830149*G0_0_0 - 0.067849460210570*G0_0_1 - 0.195067198105389*G0_0_2 - 0.067849460210571*G0_1_0 - 0.104709984267275*G0_1_2 - 0.195067198105390*G0_2_0 - 0.104709984267275*G0_2_1 - 0.185933616923198*G0_2_2;
    A[2400] = 0.323589733311951*G0_0_0 + 0.135698920421141*G0_0_1 + 0.135698920421140*G0_0_2 + 0.135698920421141*G0_1_0 + 0.271397840842282*G0_1_2 + 0.135698920421141*G0_2_0 + 0.271397840842283*G0_2_1;
    A[2401] = 0.050234696502058*G0_0_0 + 0.005545388574902*G0_0_1 + 0.038165321368446*G0_0_2 + 0.005545388574903*G0_1_0 + 0.006197787230773*G0_1_2 + 0.038165321368446*G0_2_0 + 0.006197787230773*G0_2_1 + 0.026095946234835*G0_2_2;
    A[2402] = -0.096555001068889*G0_0_0 - 0.067849460210571*G0_0_1 - 0.036860524056705*G0_0_2 - 0.067849460210571*G0_1_0 - 0.104709984267275*G0_1_2 - 0.036860524056704*G0_2_0 - 0.104709984267276*G0_2_1;
    A[2403] = 0.030010338170060*G0_0_0 + 0.037839122040511*G0_0_1 + 0.015005169085030*G0_0_2 + 0.037839122040511*G0_1_0 + 0.052844291125541*G0_1_2 + 0.015005169085030*G0_2_0 + 0.052844291125541*G0_2_1;
    A[2404] = 0.143527704291593*G0_0_0 - 0.075025845425151*G0_0_1 - 0.042405912631606*G0_0_2 - 0.075025845425150*G0_1_0 - 0.026095946234834*G0_1_2 - 0.042405912631606*G0_2_0 - 0.026095946234834*G0_2_1 - 0.052191892469669*G0_2_2;
    A[2405] = -0.150051690850302*G0_0_0 + 0.316413348097371*G0_0_1 + 0.185933616923197*G0_0_2 + 0.316413348097373*G0_1_0 + 0.185933616923199*G0_1_2 + 0.185933616923198*G0_2_0 + 0.185933616923197*G0_2_1 + 0.371867233846397*G0_2_2;
    A[2406] = 0.045667905910961*G0_0_0 - 0.075025845425150*G0_0_1 - 0.026095946234834*G0_0_2 - 0.075025845425150*G0_1_0 - 0.026095946234834*G0_1_2 - 0.026095946234835*G0_2_0 - 0.026095946234836*G0_2_1 - 0.052191892469670*G0_2_2;
    A[2407] = 0.176147637085134*G0_0_0 - 0.058715879028377*G0_0_1 - 0.009785979838063*G0_0_2 - 0.058715879028379*G0_1_0 - 0.026095946234836*G0_1_2 - 0.009785979838062*G0_2_0 - 0.026095946234834*G0_2_1 - 0.052191892469670*G0_2_2;
    A[2408] = -0.029847238506092*G0_0_0 - 0.029847238506092*G0_0_1 - 0.029847238506092*G0_0_2 - 0.034571909571909*G0_1_0 - 0.034571909571909*G0_1_1 - 0.034571909571909*G0_1_2 - 0.029847238506092*G0_2_0 - 0.029847238506092*G0_2_1 - 0.029847238506092*G0_2_2;
    A[2409] = 0.011743175805676*G0_0_0 + 0.002278176106301*G0_1_0;
    A[2410] = -0.009464999699375*G0_1_1;
    A[2411] = 0.004724671065817*G0_1_2 - 0.029847238506093*G0_2_2;
    A[2412] = 0.029260079715809*G0_1_1 + 0.003294613212148*G0_1_2 + 0.003294613212148*G0_2_1;
    A[2413] = -0.018984800885843*G0_1_1 - 0.009492400442921*G0_1_2 - 0.009492400442922*G0_2_1 - 0.000652398655871*G0_2_2;
    A[2414] = 0.003522952741703*G0_1_1 + 0.006491366625915*G0_1_2 + 0.006491366625915*G0_2_1 + 0.008807381854257*G0_2_2;
    A[2415] = 0.042960451489097*G0_1_1 + 0.042275432900433*G0_1_2 + 0.042275432900433*G0_2_1 + 0.064261267603281*G0_2_2;
    A[2416] = -0.043547610279381*G0_0_0 - 0.005838967970044*G0_0_2 - 0.014287530563572*G0_1_0 - 0.002544354757896*G0_1_2 - 0.005838967970044*G0_2_0;
    A[2417] = 0.056758683060765*G0_0_0 + 0.018886941087461*G0_0_2 + 0.037773882174923*G0_1_0 + 0.009394540644541*G0_1_2 + 0.018886941087462*G0_2_0 - 0.006197787230773*G0_2_2;
    A[2418] = 0.104709984267275*G0_0_0 + 0.074340826836486*G0_0_2 + 0.108232937008978*G0_1_0 + 0.080832193462401*G0_1_2 + 0.074340826836486*G0_2_0 + 0.037186723384639*G0_2_2;
    A[2419] = 0.042275432900433*G0_0_2 + 0.042960451489097*G0_1_0 + 0.084550865800865*G0_1_2 + 0.042275432900433*G0_2_0 + 0.128522535206563*G0_2_2;
    A[2420] = -0.009133581182192*G0_0_0 - 0.005838967970044*G0_0_1 - 0.005838967970044*G0_1_0 - 0.002544354757896*G0_1_1;
    A[2421] = -0.015657567740901*G0_0_0 - 0.013080593050211*G0_0_1 - 0.013080593050211*G0_1_0 - 0.010503618359521*G0_1_1;
    A[2422] = -0.000652398655870*G0_0_0 + 0.001924576034819*G0_0_1 + 0.001924576034819*G0_1_0 + 0.004501550725509*G0_1_1;
    A[2423] = 0.003294613212148*G0_0_1 + 0.003294613212148*G0_1_0 + 0.006589226424296*G0_1_1;
    A[2424] = 0.176636936077038*G0_0_0 + 0.176636936077038*G0_0_1 + 0.134361503176606*G0_0_2 + 0.127315597693200*G0_1_0 + 0.127315597693200*G0_1_1 + 0.128000616281865*G0_1_2 + 0.134361503176606*G0_2_0 + 0.134361503176606*G0_2_1 + 0.092086070276173*G0_2_2;
    A[2425] = -0.334680510461757*G0_0_0 - 0.334680510461757*G0_0_1 - 0.250814663249556*G0_0_2 - 0.166948816037356*G0_1_0 - 0.166948816037356*G0_1_1 - 0.160783648739376*G0_1_2 - 0.250814663249556*G0_2_0 - 0.250814663249557*G0_2_1 - 0.062238831770081*G0_2_2;
    A[2426] = 0.104709984267275*G0_0_0 + 0.104709984267275*G0_0_1 + 0.188575831479475*G0_0_2 + 0.182410664181496*G0_1_0 + 0.182410664181496*G0_1_1 + 0.098544816969295*G0_1_2 + 0.188575831479476*G0_2_0 + 0.188575831479476*G0_2_1 - 0.062238831770081*G0_2_2;
    A[2427] = -0.042275432900432*G0_0_2 - 0.042960451489097*G0_1_0 - 0.042960451489097*G0_1_1 - 0.035914546005692*G0_1_2 - 0.042275432900433*G0_2_0 - 0.042275432900433*G0_2_1 + 0.092086070276174*G0_2_2;
    A[2428] = 0.064261267603281*G0_0_0 + 0.021985834702848*G0_0_1 + 0.064261267603280*G0_0_2 + 0.021985834702848*G0_1_0 + 0.022670853291513*G0_1_1 + 0.021985834702848*G0_1_2 + 0.064261267603281*G0_2_0 + 0.021985834702848*G0_2_1 + 0.064261267603281*G0_2_2;
    A[2429] = 0.008807381854257*G0_0_0 + 0.002316015228342*G0_0_1 + 0.008807381854257*G0_0_2 + 0.002316015228342*G0_1_0 - 0.000652398655871*G0_1_1 + 0.002316015228342*G0_1_2 + 0.008807381854257*G0_2_0 + 0.002316015228342*G0_2_1 + 0.008807381854257*G0_2_2;
    A[2430] = -0.000652398655871*G0_0_0 + 0.008840001787050*G0_0_1 - 0.000652398655871*G0_0_2 + 0.008840001787050*G0_1_0 - 0.000652398655871*G0_1_1 + 0.008840001787050*G0_1_2 - 0.000652398655871*G0_2_0 + 0.008840001787050*G0_2_1 - 0.000652398655871*G0_2_2;
    A[2431] = -0.003294613212148*G0_0_1 - 0.003294613212148*G0_1_0 + 0.022670853291513*G0_1_1 - 0.003294613212148*G0_1_2 - 0.003294613212148*G0_2_1;
    A[2432] = 0.043971669405697*G0_0_0 + 0.086247102306129*G0_0_1 + 0.086247102306129*G0_0_2 + 0.044656687994361*G0_1_0 + 0.043971669405697*G0_1_1 + 0.043971669405697*G0_1_2 + 0.086247102306129*G0_2_0 + 0.128522535206562*G0_2_1 + 0.128522535206562*G0_2_2;
    A[2433] = -0.006784946021057*G0_0_0 - 0.037154103451846*G0_0_1 - 0.037154103451846*G0_0_2 - 0.009753359905270*G0_1_0 - 0.043645470077761*G0_1_1 - 0.043645470077761*G0_1_2 - 0.037154103451846*G0_2_0 + 0.037186723384640*G0_2_1 + 0.037186723384640*G0_2_2;
    A[2434] = 0.012787013655069*G0_0_0 - 0.025084728318235*G0_0_1 - 0.025084728318235*G0_0_2 + 0.003294613212148*G0_1_0 - 0.015592327875314*G0_1_1 - 0.015592327875314*G0_1_2 - 0.025084728318235*G0_2_0 - 0.006197787230773*G0_2_1 - 0.006197787230773*G0_2_2;
    A[2435] = -0.031869674339292*G0_0_0 + 0.005838967970044*G0_0_1 + 0.005838967970044*G0_0_2 - 0.005904207835631*G0_1_0 + 0.002544354757897*G0_1_1 + 0.002544354757897*G0_1_2 + 0.005838967970044*G0_2_0;
    A[2436] = 0.039143919352252*G0_0_0 + 0.026422145562770*G0_0_1 - 0.005545388574903*G0_0_2 + 0.026422145562770*G0_1_0 + 0.013700371773288*G0_1_1 - 0.006197787230774*G0_1_2 - 0.005545388574902*G0_2_0 - 0.006197787230773*G0_2_1;
    A[2437] = 0.019571959676126*G0_0_0 + 0.001467896975710*G0_0_1 - 0.010275278829966*G0_0_2 + 0.001467896975710*G0_1_0 - 0.016636165724707*G0_1_1 - 0.018104062700416*G0_1_2 - 0.010275278829966*G0_2_0 - 0.018104062700417*G0_2_1;
    A[2438] = -0.012721773789482*G0_0_1 - 0.000652398655871*G0_0_2 - 0.012721773789482*G0_1_0 - 0.025443547578964*G0_1_1 - 0.001304797311742*G0_1_2 - 0.000652398655871*G0_2_0 - 0.001304797311741*G0_2_1;
    A[2439] = 0.092966808461600*G0_0_0 + 0.121346149991982*G0_0_1 + 0.060673074995991*G0_0_2 + 0.121346149991982*G0_1_0 + 0.149725491522365*G0_1_1 + 0.074862745761182*G0_1_2 + 0.060673074995990*G0_2_0 + 0.074862745761182*G0_2_1 + 0.019571959676126*G0_2_2;
    A[2440] = 0.028379341530382*G0_0_1 + 0.014189670765191*G0_0_2 + 0.028379341530383*G0_1_0 + 0.056758683060766*G0_1_1 + 0.028379341530383*G0_1_2 + 0.014189670765191*G0_2_0 + 0.028379341530382*G0_2_1 - 0.004892989919032*G0_2_2;
    A[2441] = 0.104709984267275*G0_0_1 + 0.067849460210571*G0_0_2 + 0.104709984267275*G0_1_0 + 0.209419968534550*G0_1_1 + 0.135698920421141*G0_1_2 + 0.067849460210571*G0_2_0 + 0.135698920421142*G0_2_1 + 0.039143919352252*G0_2_2;
    A[2442] = -0.156575677409009*G0_0_0 - 0.134067923781464*G0_0_1 - 0.224425137619579*G0_0_2 - 0.134067923781464*G0_1_0 - 0.088073818542567*G0_1_1 - 0.097207399724759*G0_1_2 - 0.224425137619581*G0_2_0 - 0.097207399724760*G0_2_1 - 0.292274597830151*G0_2_2;
    A[2443] = 0.019571959676126*G0_0_0 - 0.055290786085056*G0_0_1 + 0.005382288910935*G0_0_2 - 0.055290786085056*G0_1_0 + 0.019571959676126*G0_1_1 - 0.041101115319865*G0_1_2 + 0.005382288910935*G0_2_0 - 0.041101115319864*G0_2_1 - 0.008807381854257*G0_2_2;
    A[2444] = 0.012721773789482*G0_0_1 + 0.000652398655871*G0_0_2 + 0.012721773789482*G0_1_0 - 0.088073818542568*G0_1_1 + 0.000652398655871*G0_1_2 + 0.000652398655871*G0_2_0 + 0.000652398655870*G0_2_1 + 0.001304797311742*G0_2_2;
    A[2445] = 0.092966808461598*G0_0_0 + 0.363059851992139*G0_0_1 + 0.228013330226869*G0_0_2 + 0.363059851992140*G0_1_0 + 0.092966808461598*G0_1_1 + 0.228013330226869*G0_1_2 + 0.228013330226869*G0_2_0 + 0.228013330226869*G0_2_1 + 0.456026660453740*G0_2_2;
    A[2446] = -0.028379341530382*G0_0_1 - 0.014189670765192*G0_0_2 - 0.028379341530383*G0_1_0 + 0.092966808461601*G0_1_1 + 0.032293733465608*G0_1_2 - 0.014189670765191*G0_2_0 + 0.032293733465609*G0_2_1 - 0.008807381854257*G0_2_2;
    A[2447] = -0.104709984267275*G0_0_1 - 0.067849460210570*G0_0_2 - 0.104709984267275*G0_1_0 - 0.185933616923199*G0_1_1 - 0.195067198105390*G0_1_2 - 0.067849460210571*G0_2_0 - 0.195067198105391*G0_2_1 - 0.292274597830151*G0_2_2;
    A[2448] = -0.268135847562928*G0_0_0 - 0.290643601190473*G0_0_1 - 0.321632537344339*G0_0_2 - 0.222141742324032*G0_1_0 - 0.268135847562928*G0_1_1 - 0.194414799449520*G0_1_2 - 0.321632537344340*G0_2_0 - 0.448850275239161*G0_2_1 - 0.584549195660302*G0_2_2;
    A[2449] = -0.037186723384640*G0_0_0 + 0.140428810676205*G0_0_1 + 0.186912214907004*G0_0_2 + 0.037676022376543*G0_1_0 + 0.065566064915023*G0_1_1 + 0.140428810676205*G0_1_2 + 0.186912214907006*G0_2_0 + 0.037676022376543*G0_2_1 - 0.037186723384640*G0_2_2;
    A[2450] = 0.172233245149910*G0_0_0 - 0.026422145562770*G0_0_1 + 0.006197787230774*G0_0_2 + 0.071437652817860*G0_1_0 - 0.013700371773288*G0_1_1 + 0.006197787230773*G0_1_2 + 0.006197787230773*G0_2_0 + 0.006197787230773*G0_2_1 + 0.012395574461546*G0_2_2;
    A[2451] = 0.726119703984279*G0_0_0 + 0.456026660453739*G0_0_1 + 0.456026660453739*G0_0_2 + 0.456026660453739*G0_1_0 + 0.726119703984280*G0_1_1 + 0.456026660453740*G0_1_2 + 0.456026660453739*G0_2_0 + 0.456026660453740*G0_2_1 + 0.912053320907481*G0_2_2;
    A[2452] = -0.448197876583288*G0_0_0 - 0.121346149991982*G0_0_1 - 0.224098938291644*G0_0_2 - 0.326851726591306*G0_1_0 - 0.149725491522364*G0_1_1 - 0.177615534060844*G0_1_2 - 0.224098938291645*G0_2_0 - 0.074862745761182*G0_2_1 - 0.037186723384639*G0_2_2;
    A[2453] = -0.209419968534550*G0_0_0 - 0.104709984267275*G0_0_1 - 0.262916658315962*G0_0_2 - 0.290643601190474*G0_1_0 - 0.209419968534550*G0_1_1 - 0.390134396210782*G0_1_2 - 0.262916658315962*G0_2_0 - 0.135698920421142*G0_2_1 - 0.584549195660303*G0_2_2;
    A[2454] = -0.096555001068888*G0_0_0 - 0.059694477012185*G0_0_1 - 0.028705540858319*G0_0_2 - 0.059694477012185*G0_1_0 - 0.022833952955481*G0_1_1 - 0.096555001068890*G0_1_2 - 0.028705540858318*G0_2_0 - 0.096555001068889*G0_2_1 + 0.039143919352252*G0_2_2;
    A[2455] = -0.008807381854257*G0_0_0 + 0.005382288910935*G0_0_1 - 0.041101115319864*G0_0_2 + 0.005382288910936*G0_1_0 + 0.019571959676127*G0_1_1 - 0.055290786085056*G0_1_2 - 0.041101115319864*G0_2_0 - 0.055290786085056*G0_2_1 + 0.019571959676127*G0_2_2;
    A[2456] = 0.050234696502057*G0_0_0 + 0.038165321368446*G0_0_1 + 0.005545388574903*G0_0_2 + 0.038165321368446*G0_1_0 + 0.026095946234834*G0_1_1 + 0.006197787230774*G0_1_2 + 0.005545388574902*G0_2_0 + 0.006197787230773*G0_2_1;
    A[2457] = -0.033272331449415*G0_0_0 - 0.019082660684223*G0_0_1 - 0.019082660684223*G0_0_2 - 0.019082660684223*G0_1_0 - 0.004892989919032*G0_1_1 - 0.033272331449414*G0_1_2 - 0.019082660684223*G0_2_0 - 0.033272331449414*G0_2_1 - 0.004892989919031*G0_2_2;
    A[2458] = 0.040122517336059*G0_0_0 + 0.029847238506092*G0_0_1 + 0.010275278829965*G0_0_2 + 0.029847238506092*G0_1_0 + 0.019571959676126*G0_1_1 + 0.018104062700416*G0_1_2 + 0.010275278829966*G0_2_0 + 0.018104062700416*G0_2_1;
    A[2459] = 0.001304797311742*G0_0_0 - 0.010764577821869*G0_0_1 + 0.000652398655871*G0_0_2 - 0.010764577821869*G0_1_0 - 0.022833952955481*G0_1_1 + 0.001304797311742*G0_1_2 + 0.000652398655871*G0_2_0 + 0.001304797311742*G0_2_1;
    A[2460] = 0.352295274170270*G0_0_0 + 0.249542485870608*G0_0_1 + 0.249542485870607*G0_0_2 + 0.249542485870607*G0_1_0 + 0.146789697570946*G0_1_1 + 0.445262082631869*G0_1_2 + 0.249542485870608*G0_2_0 + 0.445262082631870*G0_2_1 - 0.039143919352254*G0_2_2;
    A[2461] = -0.234863516113513*G0_0_0 - 0.141896707651915*G0_0_1 - 0.019571959676126*G0_0_2 - 0.141896707651914*G0_1_0 - 0.048929899190315*G0_1_1 - 0.019571959676126*G0_1_2 - 0.019571959676126*G0_2_0 - 0.019571959676126*G0_2_1 - 0.039143919352252*G0_2_2;
    A[2462] = -0.039143919352253*G0_0_0 + 0.053822889109347*G0_0_1 + 0.004892989919032*G0_0_2 + 0.053822889109346*G0_1_0 + 0.146789697570947*G0_1_1 + 0.004892989919031*G0_1_2 + 0.004892989919031*G0_2_0 + 0.004892989919031*G0_2_1 + 0.009785979838064*G0_2_2;
    A[2463] = -0.185933616923198*G0_0_0 - 0.484406001984121*G0_0_1 - 0.288686405222859*G0_0_2 - 0.484406001984122*G0_1_0 - 0.782878387045047*G0_1_1 - 0.484406001984122*G0_1_2 - 0.288686405222859*G0_2_0 - 0.484406001984122*G0_2_1 - 0.039143919352251*G0_2_2;
    A[2464] = 0.011743175805676*G0_0_0 + 0.011743175805676*G0_0_1 + 0.011743175805676*G0_0_2 + 0.009464999699375*G0_1_0 + 0.009464999699375*G0_1_1 + 0.009464999699375*G0_1_2 + 0.011743175805676*G0_2_0 + 0.011743175805676*G0_2_1 + 0.011743175805676*G0_2_2;
    A[2465] = -0.029847238506093*G0_0_0 + 0.004724671065817*G0_1_0;
    A[2466] = -0.009464999699375*G0_1_1;
    A[2467] = 0.004724671065817*G0_1_2 - 0.029847238506092*G0_2_2;
    A[2468] = 0.029260079715809*G0_1_1 + 0.003294613212148*G0_1_2 + 0.003294613212148*G0_2_1;
    A[2469] = -0.018984800885843*G0_1_1 - 0.009492400442922*G0_1_2 - 0.009492400442921*G0_2_1 - 0.000652398655872*G0_2_2;
    A[2470] = 0.003522952741703*G0_1_1 + 0.006491366625915*G0_1_2 + 0.006491366625915*G0_2_1 + 0.008807381854258*G0_2_2;
    A[2471] = 0.042960451489097*G0_1_1 + 0.042275432900433*G0_1_2 + 0.042275432900433*G0_2_1 + 0.064261267603281*G0_2_2;
    A[2472] = 0.176636936077039*G0_0_0 + 0.042275432900432*G0_0_2 + 0.049321338383838*G0_1_0 + 0.042960451489097*G0_1_2 + 0.042275432900433*G0_2_0;
    A[2473] = -0.334680510461757*G0_0_0 - 0.083865847212200*G0_0_2 - 0.167731694424402*G0_1_0 - 0.077700679914221*G0_1_2 - 0.083865847212201*G0_2_0 + 0.104709984267275*G0_2_2;
    A[2474] = 0.104709984267274*G0_0_0 - 0.083865847212201*G0_0_2 - 0.077700679914220*G0_1_0 - 0.167731694424401*G0_1_2 - 0.083865847212201*G0_2_0 - 0.334680510461758*G0_2_2;
    A[2475] = 0.042275432900433*G0_0_2 + 0.042960451489097*G0_1_0 + 0.049321338383838*G0_1_2 + 0.042275432900433*G0_2_0 + 0.176636936077039*G0_2_2;
    A[2476] = 0.064261267603280*G0_0_0 + 0.042275432900432*G0_0_1 + 0.042275432900433*G0_1_0 + 0.042960451489097*G0_1_1;
    A[2477] = 0.008807381854257*G0_0_0 + 0.006491366625915*G0_0_1 + 0.006491366625915*G0_1_0 + 0.003522952741703*G0_1_1;
    A[2478] = -0.000652398655871*G0_0_0 - 0.009492400442921*G0_0_1 - 0.009492400442921*G0_1_0 - 0.018984800885842*G0_1_1;
    A[2479] = 0.003294613212148*G0_0_1 + 0.003294613212148*G0_1_0 + 0.029260079715809*G0_1_1;
    A[2480] = -0.043547610279380*G0_0_0 - 0.043547610279380*G0_0_1 - 0.037708642309336*G0_0_2 - 0.029260079715808*G0_1_0 - 0.029260079715808*G0_1_1 - 0.025965466503661*G0_1_2 - 0.037708642309336*G0_2_0 - 0.037708642309336*G0_2_1 - 0.031869674339292*G0_2_2;
    A[2481] = 0.056758683060765*G0_0_0 + 0.056758683060765*G0_0_1 + 0.037871741973303*G0_0_2 + 0.018984800885842*G0_1_0 + 0.018984800885842*G0_1_1 + 0.009492400442921*G0_1_2 + 0.037871741973303*G0_2_0 + 0.037871741973303*G0_2_1 + 0.012787013655069*G0_2_2;
    A[2482] = 0.104709984267276*G0_0_0 + 0.104709984267276*G0_0_1 + 0.030369157430790*G0_0_2 - 0.003522952741702*G0_1_0 - 0.003522952741702*G0_1_1 + 0.002968413884213*G0_1_2 + 0.030369157430790*G0_2_0 + 0.030369157430790*G0_2_1 - 0.006784946021056*G0_2_2;
    A[2483] = -0.042275432900433*G0_0_2 - 0.042960451489097*G0_1_0 - 0.042960451489097*G0_1_1 - 0.000685018588665*G0_1_2 - 0.042275432900433*G0_2_0 - 0.042275432900433*G0_2_1 + 0.043971669405696*G0_2_2;
    A[2484] = -0.009133581182192*G0_0_0 - 0.003294613212148*G0_0_1 - 0.009133581182192*G0_0_2 - 0.003294613212148*G0_1_0 - 0.003294613212148*G0_1_2 - 0.009133581182192*G0_2_0 - 0.003294613212148*G0_2_1 - 0.009133581182192*G0_2_2;
    A[2485] = -0.015657567740901*G0_0_0 - 0.002576974690690*G0_0_1 - 0.015657567740901*G0_0_2 - 0.002576974690690*G0_1_0 - 0.002576974690690*G0_1_2 - 0.015657567740901*G0_2_0 - 0.002576974690690*G0_2_1 - 0.015657567740901*G0_2_2;
    A[2486] = -0.000652398655871*G0_0_0 - 0.002576974690690*G0_0_1 - 0.000652398655871*G0_0_2 - 0.002576974690690*G0_1_0 - 0.002576974690690*G0_1_2 - 0.000652398655871*G0_2_0 - 0.002576974690690*G0_2_1 - 0.000652398655871*G0_2_2;
    A[2487] = -0.003294613212148*G0_0_1 - 0.003294613212148*G0_1_0 - 0.003294613212148*G0_1_2 - 0.003294613212148*G0_2_1;
    A[2488] = -0.031869674339293*G0_0_0 - 0.037708642309337*G0_0_1 - 0.037708642309336*G0_0_2 - 0.025965466503661*G0_1_0 - 0.029260079715808*G0_1_1 - 0.029260079715808*G0_1_2 - 0.037708642309337*G0_2_0 - 0.043547610279380*G0_2_1 - 0.043547610279380*G0_2_2;
    A[2489] = 0.012787013655070*G0_0_0 + 0.037871741973304*G0_0_1 + 0.037871741973304*G0_0_2 + 0.009492400442921*G0_1_0 + 0.018984800885842*G0_1_1 + 0.018984800885842*G0_1_2 + 0.037871741973304*G0_2_0 + 0.056758683060766*G0_2_1 + 0.056758683060766*G0_2_2;
    A[2490] = -0.006784946021058*G0_0_0 + 0.030369157430789*G0_0_1 + 0.030369157430789*G0_0_2 + 0.002968413884212*G0_1_0 - 0.003522952741703*G0_1_1 - 0.003522952741703*G0_1_2 + 0.030369157430789*G0_2_0 + 0.104709984267276*G0_2_1 + 0.104709984267276*G0_2_2;
    A[2491] = 0.043971669405697*G0_0_0 - 0.042275432900432*G0_0_1 - 0.042275432900432*G0_0_2 - 0.000685018588664*G0_1_0 - 0.042960451489097*G0_1_1 - 0.042960451489097*G0_1_2 - 0.042275432900433*G0_2_0;
    A[2492] = -0.156575677409009*G0_0_0 - 0.022507753627545*G0_0_1 + 0.067849460210570*G0_0_2 - 0.022507753627545*G0_1_0 + 0.023486351611351*G0_1_1 + 0.104709984267276*G0_1_2 + 0.067849460210571*G0_2_0 + 0.104709984267275*G0_2_1;
    A[2493] = 0.019571959676126*G0_0_0 + 0.074862745761182*G0_0_1 + 0.014189670765191*G0_0_2 + 0.074862745761183*G0_1_0 + 0.149725491522365*G0_1_1 + 0.028379341530383*G0_1_2 + 0.014189670765191*G0_2_0 + 0.028379341530383*G0_2_1;
    A[2494] = -0.012721773789482*G0_0_1 - 0.000652398655871*G0_0_2 - 0.012721773789482*G0_1_0 - 0.113517366121531*G0_1_1 - 0.012721773789482*G0_1_2 - 0.000652398655871*G0_2_0 - 0.012721773789482*G0_2_1;
    A[2495] = 0.092966808461598*G0_0_0 - 0.270093043530542*G0_0_1 - 0.135046521765270*G0_0_2 - 0.270093043530541*G0_1_0 - 0.540186087061083*G0_1_1 - 0.270093043530542*G0_1_2 - 0.135046521765271*G0_2_0 - 0.270093043530541*G0_2_1 + 0.092966808461600*G0_2_2;
    A[2496] = 0.028379341530383*G0_0_1 + 0.014189670765192*G0_0_2 + 0.028379341530383*G0_1_0 + 0.149725491522365*G0_1_1 + 0.074862745761183*G0_1_2 + 0.014189670765192*G0_2_0 + 0.074862745761182*G0_2_1 + 0.019571959676126*G0_2_2;
    A[2497] = 0.104709984267275*G0_0_1 + 0.067849460210571*G0_0_2 + 0.104709984267275*G0_1_0 + 0.023486351611352*G0_1_1 - 0.022507753627545*G0_1_2 + 0.067849460210571*G0_2_0 - 0.022507753627544*G0_2_1 - 0.156575677409009*G0_2_2;
    A[2498] = 0.039143919352252*G0_0_0 + 0.012721773789482*G0_0_1 + 0.044689307927155*G0_0_2 + 0.012721773789482*G0_1_0 + 0.012069375133611*G0_1_2 + 0.044689307927155*G0_2_0 + 0.012069375133611*G0_2_1 + 0.050234696502057*G0_2_2;
    A[2499] = 0.019571959676126*G0_0_0 + 0.018104062700416*G0_0_1 + 0.029847238506092*G0_0_2 + 0.018104062700416*G0_1_0 + 0.010275278829966*G0_1_2 + 0.029847238506092*G0_2_0 + 0.010275278829966*G0_2_1 + 0.040122517336058*G0_2_2;
    A[2500] = 0.012721773789482*G0_0_1 + 0.000652398655871*G0_0_2 + 0.012721773789482*G0_1_0 + 0.012069375133611*G0_1_2 + 0.000652398655871*G0_2_0 + 0.012069375133611*G0_2_1 + 0.001304797311742*G0_2_2;
    A[2501] = 0.092966808461600*G0_0_0 - 0.028379341530382*G0_0_1 + 0.032293733465608*G0_0_2 - 0.028379341530382*G0_1_0 - 0.014189670765191*G0_1_2 + 0.032293733465610*G0_2_0 - 0.014189670765191*G0_2_1 - 0.008807381854256*G0_2_2;
    A[2502] = -0.028379341530383*G0_0_1 - 0.014189670765191*G0_0_2 - 0.028379341530383*G0_1_0 - 0.014189670765191*G0_1_2 - 0.014189670765192*G0_2_0 - 0.014189670765192*G0_2_1 - 0.033272331449414*G0_2_2;
    A[2503] = -0.104709984267276*G0_0_1 - 0.067849460210571*G0_0_2 - 0.104709984267275*G0_1_0 - 0.036860524056705*G0_1_2 - 0.067849460210571*G0_2_0 - 0.036860524056705*G0_2_1 - 0.096555001068890*G0_2_2;
    A[2504] = 0.172233245149910*G0_0_0 + 0.198655390712680*G0_0_1 + 0.166035457919137*G0_0_2 + 0.100795592332049*G0_1_0 + 0.113517366121532*G0_1_1 + 0.100795592332049*G0_1_2 + 0.166035457919137*G0_2_0 + 0.198655390712681*G0_2_1 + 0.172233245149910*G0_2_2;
    A[2505] = -0.037186723384640*G0_0_0 - 0.177615534060845*G0_0_1 - 0.224098938291644*G0_0_2 - 0.074862745761182*G0_1_0 - 0.149725491522365*G0_1_1 - 0.121346149991982*G0_1_2 - 0.224098938291645*G0_2_0 - 0.326851726591307*G0_2_1 - 0.448197876583290*G0_2_2;
    A[2506] = -0.268135847562928*G0_0_0 + 0.022507753627545*G0_0_1 + 0.053496689781411*G0_0_2 - 0.045994105238897*G0_1_0 - 0.023486351611351*G0_1_1 + 0.081223632655924*G0_1_2 + 0.053496689781411*G0_2_0 - 0.104709984267275*G0_2_1 - 0.209419968534551*G0_2_2;
    A[2507] = -0.448197876583288*G0_0_0 - 0.326851726591306*G0_0_1 - 0.224098938291645*G0_0_2 - 0.121346149991982*G0_1_0 - 0.149725491522364*G0_1_1 - 0.074862745761182*G0_1_2 - 0.224098938291644*G0_2_0 - 0.177615534060844*G0_2_1 - 0.037186723384639*G0_2_2;
    A[2508] = 0.726119703984280*G0_0_0 + 0.270093043530542*G0_0_1 + 0.270093043530541*G0_0_2 + 0.270093043530542*G0_1_0 + 0.540186087061083*G0_1_1 + 0.270093043530541*G0_1_2 + 0.270093043530541*G0_2_0 + 0.270093043530541*G0_2_1 + 0.726119703984282*G0_2_2;
    A[2509] = -0.209419968534550*G0_0_0 - 0.104709984267275*G0_0_1 + 0.053496689781411*G0_0_2 + 0.081223632655922*G0_1_0 - 0.023486351611352*G0_1_1 - 0.045994105238897*G0_1_2 + 0.053496689781411*G0_2_0 + 0.022507753627545*G0_2_1 - 0.268135847562930*G0_2_2;
    A[2510] = 0.050234696502057*G0_0_0 + 0.012069375133611*G0_0_1 + 0.044689307927155*G0_0_2 + 0.012069375133611*G0_1_0 + 0.012721773789482*G0_1_2 + 0.044689307927155*G0_2_0 + 0.012721773789482*G0_2_1 + 0.039143919352253*G0_2_2;
    A[2511] = -0.008807381854257*G0_0_0 - 0.014189670765192*G0_0_1 + 0.032293733465607*G0_0_2 - 0.014189670765191*G0_1_0 - 0.028379341530383*G0_1_2 + 0.032293733465608*G0_2_0 - 0.028379341530383*G0_2_1 + 0.092966808461599*G0_2_2;
    A[2512] = -0.096555001068888*G0_0_0 - 0.036860524056704*G0_0_1 - 0.067849460210570*G0_0_2 - 0.036860524056705*G0_1_0 - 0.104709984267275*G0_1_2 - 0.067849460210571*G0_2_0 - 0.104709984267276*G0_2_1;
    A[2513] = 0.040122517336058*G0_0_0 + 0.010275278829966*G0_0_1 + 0.029847238506092*G0_0_2 + 0.010275278829966*G0_1_0 + 0.018104062700416*G0_1_2 + 0.029847238506092*G0_2_0 + 0.018104062700417*G0_2_1 + 0.019571959676126*G0_2_2;
    A[2514] = -0.033272331449414*G0_0_0 - 0.014189670765191*G0_0_1 - 0.014189670765191*G0_0_2 - 0.014189670765191*G0_1_0 - 0.028379341530383*G0_1_2 - 0.014189670765191*G0_2_0 - 0.028379341530382*G0_2_1;
    A[2515] = 0.001304797311742*G0_0_0 + 0.012069375133611*G0_0_1 + 0.000652398655871*G0_0_2 + 0.012069375133611*G0_1_0 + 0.012721773789482*G0_1_2 + 0.000652398655871*G0_2_0 + 0.012721773789482*G0_2_1;
    A[2516] = -0.234863516113514*G0_0_0 - 0.092966808461599*G0_0_1 - 0.215291556437387*G0_0_2 - 0.092966808461600*G0_1_0 - 0.092966808461599*G0_1_2 - 0.215291556437388*G0_2_0 - 0.092966808461600*G0_2_1 - 0.234863516113515*G0_2_2;
    A[2517] = 0.352295274170271*G0_0_0 + 0.102752788299662*G0_0_1 + 0.102752788299663*G0_0_2 + 0.102752788299663*G0_1_0 + 0.298472385060924*G0_1_2 + 0.102752788299662*G0_2_0 + 0.298472385060924*G0_2_1 - 0.185933616923199*G0_2_2;
    A[2518] = -0.039143919352252*G0_0_0 - 0.092966808461599*G0_0_1 - 0.044036909271284*G0_0_2 - 0.092966808461599*G0_1_0 - 0.092966808461599*G0_1_2 - 0.044036909271284*G0_2_0 - 0.092966808461599*G0_2_1 - 0.039143919352252*G0_2_2;
    A[2519] = -0.185933616923198*G0_0_0 + 0.298472385060923*G0_0_1 + 0.102752788299661*G0_0_2 + 0.298472385060924*G0_1_0 + 0.102752788299662*G0_1_2 + 0.102752788299661*G0_2_0 + 0.102752788299662*G0_2_1 + 0.352295274170271*G0_2_2;
    A[2520] = 0.018919561020255*G0_0_0 + 0.018919561020255*G0_0_1 + 0.018919561020255*G0_0_2 + 0.013742125287264*G0_1_0 + 0.013742125287264*G0_1_1 + 0.013742125287264*G0_1_2 + 0.018919561020255*G0_2_0 + 0.018919561020255*G0_2_1 + 0.018919561020255*G0_2_2;
    A[2521] = 0.018919561020255*G0_0_0 + 0.005177435732991*G0_1_0;
    A[2522] = -0.013742125287264*G0_1_1;
    A[2523] = -0.014394523943135*G0_1_2 + 0.033598530777350*G0_2_2;
    A[2524] = 0.064130787872107*G0_1_1 + 0.009394540644541*G0_1_2 + 0.009394540644541*G0_2_1;
    A[2525] = -0.127087258163646*G0_1_1 - 0.037773882174924*G0_1_2 - 0.037773882174923*G0_2_1 - 0.015005169085030*G0_2_2;
    A[2526] = 0.124738623002512*G0_1_1 + 0.062369311501256*G0_1_2 + 0.062369311501256*G0_2_1 + 0.047625101878573*G0_2_2;
    A[2527] = -0.124738623002512*G0_1_1 - 0.096294041606541*G0_1_2 - 0.096294041606541*G0_2_1 - 0.128522535206562*G0_2_2;
    A[2528] = -0.111886369481855*G0_0_0 - 0.021268196181390*G0_0_2 - 0.047755581609748*G0_1_0 - 0.011873655536850*G0_1_2 - 0.021268196181390*G0_2_0;
    A[2529] = 0.209419968534550*G0_0_0 + 0.035947165938484*G0_0_2 + 0.082332710370904*G0_1_0 - 0.001826716236439*G0_1_2 + 0.035947165938485*G0_2_0 - 0.052844291125541*G0_2_2;
    A[2530] = -0.271397840842283*G0_0_0 - 0.073329608919885*G0_0_2 - 0.146659217839772*G0_1_0 - 0.010960297418630*G0_1_2 - 0.073329608919886*G0_2_0 + 0.121346149991983*G0_2_2;
    A[2531] = -0.096294041606542*G0_0_2 - 0.124738623002512*G0_1_0 - 0.192588083213083*G0_1_2 - 0.096294041606541*G0_2_0 - 0.257045070413125*G0_2_2;
    A[2532] = -0.030662736825931*G0_0_0 - 0.021268196181390*G0_0_1 - 0.021268196181390*G0_1_0 - 0.011873655536850*G0_1_1;
    A[2533] = -0.001304797311742*G0_0_0 - 0.001239557446155*G0_0_1 - 0.001239557446155*G0_1_0 - 0.001174317580568*G0_1_1;
    A[2534] = -0.015005169085030*G0_0_0 - 0.014939929219443*G0_0_1 - 0.014939929219443*G0_1_0 - 0.014874689353856*G0_1_1;
    A[2535] = 0.009394540644541*G0_0_1 + 0.009394540644541*G0_1_0 + 0.018789081289081*G0_1_1;
    A[2536] = -0.111886369481855*G0_0_0 - 0.111886369481855*G0_0_1 - 0.090618173300464*G0_0_2 - 0.064130787872107*G0_1_0 - 0.064130787872107*G0_1_1 - 0.054736247227566*G0_1_2 - 0.090618173300464*G0_2_0 - 0.090618173300464*G0_2_1 - 0.069349977119074*G0_2_2;
    A[2537] = 0.209419968534550*G0_0_0 + 0.209419968534550*G0_0_1 + 0.173472802596065*G0_0_2 + 0.127087258163647*G0_1_0 + 0.127087258163647*G0_1_1 + 0.089313375988723*G0_1_2 + 0.173472802596065*G0_2_0 + 0.173472802596066*G0_2_1 + 0.084681345532040*G0_2_2;
    A[2538] = -0.271397840842283*G0_0_0 - 0.271397840842283*G0_0_1 - 0.198068231922398*G0_0_2 - 0.124738623002512*G0_1_0 - 0.124738623002512*G0_1_1 - 0.062369311501256*G0_1_2 - 0.198068231922398*G0_2_0 - 0.198068231922398*G0_2_1 - 0.003392473010529*G0_2_2;
    A[2539] = 0.096294041606541*G0_0_2 + 0.124738623002512*G0_1_0 + 0.124738623002512*G0_1_1 + 0.028444581395971*G0_1_2 + 0.096294041606541*G0_2_0 + 0.096294041606541*G0_2_1 - 0.064456987200042*G0_2_2;
    A[2540] = -0.030662736825931*G0_0_0 - 0.009394540644540*G0_0_1 - 0.030662736825931*G0_0_2 - 0.009394540644541*G0_1_0 - 0.009394540644541*G0_1_2 - 0.030662736825931*G0_2_0 - 0.009394540644540*G0_2_1 - 0.030662736825931*G0_2_2;
    A[2541] = -0.001304797311742*G0_0_0 - 0.000065239865587*G0_0_1 - 0.001304797311742*G0_0_2 - 0.000065239865587*G0_1_0 - 0.000065239865587*G0_1_2 - 0.001304797311742*G0_2_0 - 0.000065239865588*G0_2_1 - 0.001304797311742*G0_2_2;
    A[2542] = -0.015005169085030*G0_0_0 - 0.000065239865587*G0_0_1 - 0.015005169085030*G0_0_2 - 0.000065239865587*G0_1_0 - 0.000065239865587*G0_1_2 - 0.015005169085030*G0_2_0 - 0.000065239865587*G0_2_1 - 0.015005169085030*G0_2_2;
    A[2543] = -0.009394540644541*G0_0_1 - 0.009394540644541*G0_1_0 - 0.009394540644541*G0_1_2 - 0.009394540644541*G0_2_1;
    A[2544] = -0.018789081289081*G0_0_0 - 0.040057277470471*G0_0_1 - 0.040057277470471*G0_0_2 - 0.009394540644540*G0_1_0 - 0.018789081289081*G0_1_1 - 0.018789081289081*G0_1_2 - 0.040057277470472*G0_2_0 - 0.061325473651862*G0_2_1 - 0.061325473651862*G0_2_2;
    A[2545] = -0.000130479731175*G0_0_0 + 0.013635131907701*G0_0_1 + 0.013635131907701*G0_0_2 - 0.000065239865587*G0_1_0 + 0.014874689353856*G0_1_1 + 0.014874689353856*G0_1_2 + 0.013635131907701*G0_2_0 - 0.025443547578964*G0_2_1 - 0.025443547578964*G0_2_2;
    A[2546] = -0.000130479731174*G0_0_0 - 0.013765611638875*G0_0_1 - 0.013765611638875*G0_0_2 - 0.000065239865587*G0_1_0 + 0.001174317580568*G0_1_1 + 0.001174317580568*G0_1_2 - 0.013765611638875*G0_2_0 - 0.052844291125541*G0_2_1 - 0.052844291125541*G0_2_2;
    A[2547] = -0.018789081289081*G0_0_0 + 0.021268196181390*G0_0_1 + 0.021268196181390*G0_0_2 - 0.009394540644541*G0_1_0 + 0.011873655536850*G0_1_1 + 0.011873655536850*G0_1_2 + 0.021268196181390*G0_2_0;
    A[2548] = 0.052191892469670*G0_0_0 - 0.000652398655871*G0_0_1 - 0.037839122040510*G0_0_2 - 0.000652398655871*G0_1_0 - 0.053496689781412*G0_1_1 - 0.052844291125540*G0_1_2 - 0.037839122040511*G0_2_0 - 0.052844291125541*G0_2_1;
    A[2549] = 0.026095946234835*G0_0_0 + 0.019898159004062*G0_0_1 - 0.012069375133611*G0_0_2 + 0.019898159004062*G0_1_0 + 0.013700371773288*G0_1_1 - 0.012721773789482*G0_1_2 - 0.012069375133611*G0_2_0 - 0.012721773789482*G0_2_1;
    A[2550] = -0.052844291125541*G0_0_1 - 0.015005169085030*G0_0_2 - 0.052844291125541*G0_1_0 - 0.105688582251081*G0_1_1 - 0.030010338170060*G0_1_2 - 0.015005169085030*G0_2_0 - 0.030010338170060*G0_2_1;
    A[2551] = -0.185933616923198*G0_0_0 - 0.081223632655923*G0_0_1 + 0.009133581182192*G0_0_2 - 0.081223632655924*G0_1_0 + 0.023486351611351*G0_1_1 + 0.045994105238896*G0_1_2 + 0.009133581182193*G0_2_0 + 0.045994105238897*G0_2_1 - 0.088073818542568*G0_2_2;
    A[2552] = 0.104709984267275*G0_0_1 + 0.036860524056704*G0_0_2 + 0.104709984267276*G0_1_0 + 0.209419968534551*G0_1_1 + 0.073721048113409*G0_1_2 + 0.036860524056705*G0_2_0 + 0.073721048113410*G0_2_1 - 0.022833952955480*G0_2_2;
    A[2553] = -0.271397840842283*G0_0_1 - 0.135698920421141*G0_0_2 - 0.271397840842285*G0_1_0 - 0.542795681684568*G0_1_1 - 0.271397840842284*G0_1_2 - 0.135698920421143*G0_2_0 - 0.271397840842284*G0_2_1 + 0.052191892469670*G0_2_2;
    A[2554] = 0.052191892469670*G0_0_0 + 0.052844291125541*G0_0_1 + 0.090031014510180*G0_0_2 + 0.052844291125541*G0_1_0 + 0.037839122040511*G0_1_2 + 0.090031014510181*G0_2_0 + 0.037839122040511*G0_2_1 + 0.127870136550691*G0_2_2;
    A[2555] = 0.026095946234834*G0_0_0 + 0.006197787230773*G0_0_1 + 0.038165321368446*G0_0_2 + 0.006197787230773*G0_1_0 + 0.005545388574903*G0_1_2 + 0.038165321368446*G0_2_0 + 0.005545388574902*G0_2_1 + 0.050234696502058*G0_2_2;
    A[2556] = 0.052844291125541*G0_0_1 + 0.015005169085030*G0_0_2 + 0.052844291125541*G0_1_0 + 0.037839122040511*G0_1_2 + 0.015005169085030*G0_2_0 + 0.037839122040511*G0_2_1 + 0.030010338170060*G0_2_2;
    A[2557] = -0.185933616923198*G0_0_0 - 0.104709984267275*G0_0_1 - 0.195067198105390*G0_0_2 - 0.104709984267275*G0_1_0 - 0.067849460210571*G0_1_2 - 0.195067198105391*G0_2_0 - 0.067849460210571*G0_2_1 - 0.292274597830151*G0_2_2;
    A[2558] = -0.104709984267276*G0_0_1 - 0.036860524056703*G0_0_2 - 0.104709984267276*G0_1_0 - 0.067849460210571*G0_1_2 - 0.036860524056705*G0_2_0 - 0.067849460210571*G0_2_1 - 0.096555001068889*G0_2_2;
    A[2559] = 0.271397840842283*G0_0_1 + 0.135698920421141*G0_0_2 + 0.271397840842285*G0_1_0 + 0.135698920421142*G0_1_2 + 0.135698920421143*G0_2_0 + 0.135698920421142*G0_2_1 + 0.323589733311953*G0_2_2;
    A[2560] = 0.105688582251081*G0_0_0 + 0.105036183595211*G0_0_1 + 0.127870136550691*G0_0_2 + 0.052844291125540*G0_1_0 + 0.105688582251081*G0_1_1 + 0.075678244081021*G0_1_2 + 0.127870136550691*G0_2_0 + 0.180062029020361*G0_2_1 + 0.255740273101382*G0_2_2;
    A[2561] = 0.012395574461547*G0_0_0 + 0.006197787230774*G0_0_1 + 0.006197787230774*G0_0_2 + 0.006197787230774*G0_1_0 - 0.013700371773288*G0_1_1 - 0.026422145562770*G0_1_2 + 0.006197787230773*G0_2_0 + 0.071437652817861*G0_2_1 + 0.172233245149911*G0_2_2;
    A[2562] = 0.105688582251081*G0_0_0 + 0.000652398655871*G0_0_1 - 0.022181554299609*G0_0_2 + 0.052844291125540*G0_1_0 + 0.053496689781412*G0_1_1 + 0.000652398655871*G0_1_2 - 0.022181554299609*G0_2_0 + 0.052844291125541*G0_2_1 + 0.105688582251082*G0_2_2;
    A[2563] = -0.209419968534550*G0_0_0 - 0.290643601190474*G0_0_1 - 0.262916658315962*G0_0_2 - 0.104709984267275*G0_1_0 - 0.209419968534550*G0_1_1 - 0.135698920421142*G0_1_2 - 0.262916658315962*G0_2_0 - 0.390134396210782*G0_2_1 - 0.584549195660303*G0_2_2;
    A[2564] = -0.209419968534550*G0_0_0 + 0.081223632655922*G0_0_1 + 0.053496689781411*G0_0_2 - 0.104709984267275*G0_1_0 - 0.023486351611352*G0_1_1 + 0.022507753627545*G0_1_2 + 0.053496689781411*G0_2_0 - 0.045994105238897*G0_2_1 - 0.268135847562930*G0_2_2;
    A[2565] = 0.542795681684566*G0_0_0 + 0.271397840842284*G0_0_1 + 0.271397840842284*G0_0_2 + 0.271397840842284*G0_1_0 + 0.542795681684568*G0_1_1 + 0.271397840842284*G0_1_2 + 0.271397840842284*G0_2_0 + 0.271397840842284*G0_2_1 + 0.647179466623907*G0_2_2;
    A[2566] = 0.030010338170060*G0_0_0 + 0.015005169085030*G0_0_1 - 0.007828783870450*G0_0_2 + 0.015005169085030*G0_1_0 + 0.030010338170060*G0_1_2 - 0.007828783870451*G0_2_0 + 0.030010338170060*G0_2_1 - 0.045667905910961*G0_2_2;
    A[2567] = 0.001304797311742*G0_0_0 + 0.000652398655871*G0_0_1 + 0.000652398655871*G0_0_2 + 0.000652398655871*G0_1_0 + 0.012721773789482*G0_1_2 + 0.000652398655871*G0_2_0 + 0.012721773789482*G0_2_1 - 0.088073818542568*G0_2_2;
    A[2568] = 0.030010338170060*G0_0_0 + 0.015005169085030*G0_0_1 + 0.037839122040510*G0_0_2 + 0.015005169085030*G0_1_0 + 0.052844291125540*G0_1_2 + 0.037839122040511*G0_2_0 + 0.052844291125541*G0_2_1;
    A[2569] = 0.001304797311742*G0_0_0 + 0.000652398655871*G0_0_1 - 0.010764577821869*G0_0_2 + 0.000652398655871*G0_1_0 + 0.001304797311741*G0_1_2 - 0.010764577821869*G0_2_0 + 0.001304797311741*G0_2_1 - 0.022833952955481*G0_2_2;
    A[2570] = 0.001304797311742*G0_0_0 + 0.000652398655871*G0_0_1 + 0.012069375133611*G0_0_2 + 0.000652398655871*G0_1_0 + 0.012721773789482*G0_1_2 + 0.012069375133611*G0_2_0 + 0.012721773789482*G0_2_1;
    A[2571] = 0.030010338170060*G0_0_0 + 0.015005169085030*G0_0_1 + 0.015005169085030*G0_0_2 + 0.015005169085030*G0_1_0 + 0.030010338170060*G0_1_2 + 0.015005169085030*G0_2_0 + 0.030010338170061*G0_2_1;
    A[2572] = -0.052191892469669*G0_0_0 - 0.026095946234835*G0_0_1 - 0.042405912631607*G0_0_2 - 0.026095946234835*G0_1_0 - 0.075025845425150*G0_1_2 - 0.042405912631606*G0_2_0 - 0.075025845425150*G0_2_1 + 0.143527704291594*G0_2_2;
    A[2573] = -0.052191892469670*G0_0_0 - 0.026095946234835*G0_0_1 - 0.009785979838064*G0_0_2 - 0.026095946234835*G0_1_0 - 0.058715879028378*G0_1_2 - 0.009785979838064*G0_2_0 - 0.058715879028379*G0_2_1 + 0.176147637085135*G0_2_2;
    A[2574] = -0.052191892469669*G0_0_0 - 0.026095946234835*G0_0_1 - 0.026095946234835*G0_0_2 - 0.026095946234834*G0_1_0 - 0.075025845425150*G0_1_2 - 0.026095946234835*G0_2_0 - 0.075025845425151*G0_2_1 + 0.045667905910960*G0_2_2;
    A[2575] = 0.371867233846396*G0_0_0 + 0.185933616923199*G0_0_1 + 0.185933616923199*G0_0_2 + 0.185933616923199*G0_1_0 + 0.316413348097374*G0_1_2 + 0.185933616923198*G0_2_0 + 0.316413348097372*G0_2_1 - 0.150051690850301*G0_2_2;
    A[2576] = 0.033598530777350*G0_0_0 + 0.033598530777350*G0_0_1 + 0.033598530777350*G0_0_2 + 0.033598530777350*G0_1_0 + 0.033598530777350*G0_1_1 + 0.033598530777350*G0_1_2 + 0.047993054720485*G0_2_0 + 0.047993054720485*G0_2_1 + 0.047993054720485*G0_2_2;
    A[2577] = 0.018919561020255*G0_0_0 + 0.005177435732991*G0_2_0;
    A[2578] = 0.018919561020255*G0_1_1 + 0.005177435732991*G0_2_1;
    A[2579] = -0.013742125287264*G0_2_2;
    A[2580] = -0.030662736825931*G0_1_1 - 0.021268196181391*G0_1_2 - 0.021268196181391*G0_2_1 - 0.011873655536850*G0_2_2;
    A[2581] = -0.001304797311741*G0_1_1 - 0.001239557446154*G0_1_2 - 0.001239557446154*G0_2_1 - 0.001174317580568*G0_2_2;
    A[2582] = -0.015005169085030*G0_1_1 - 0.014939929219443*G0_1_2 - 0.014939929219443*G0_2_1 - 0.014874689353855*G0_2_2;
    A[2583] = 0.009394540644540*G0_1_2 + 0.009394540644541*G0_2_1 + 0.018789081289081*G0_2_2;
    A[2584] = -0.030662736825931*G0_0_0 - 0.021268196181390*G0_0_2 - 0.021268196181390*G0_2_0 - 0.011873655536849*G0_2_2;
    A[2585] = -0.001304797311742*G0_0_0 - 0.001239557446155*G0_0_2 - 0.001239557446155*G0_2_0 - 0.001174317580568*G0_2_2;
    A[2586] = -0.015005169085030*G0_0_0 - 0.014939929219443*G0_0_2 - 0.014939929219443*G0_2_0 - 0.014874689353856*G0_2_2;
    A[2587] = 0.009394540644540*G0_0_2 + 0.009394540644541*G0_2_0 + 0.018789081289081*G0_2_2;
    A[2588] = -0.061325473651862*G0_0_0 - 0.021268196181390*G0_0_1 - 0.021268196181390*G0_1_0 - 0.042536392362780*G0_2_0 - 0.011873655536850*G0_2_1;
    A[2589] = -0.025443547578964*G0_0_0 - 0.039078679486665*G0_0_1 - 0.039078679486666*G0_1_0 - 0.052844291125541*G0_1_1 - 0.040318236932820*G0_2_0 - 0.054018608706108*G0_2_1;
    A[2590] = -0.052844291125540*G0_0_0 - 0.039078679486665*G0_0_1 - 0.039078679486664*G0_1_0 - 0.025443547578963*G0_1_1 - 0.054018608706108*G0_2_0 - 0.040318236932820*G0_2_1;
    A[2591] = -0.021268196181390*G0_0_1 - 0.021268196181391*G0_1_0 - 0.061325473651862*G0_1_1 - 0.011873655536850*G0_2_0 - 0.042536392362781*G0_2_1;
    A[2592] = -0.128522535206561*G0_0_0 - 0.128522535206561*G0_0_1 - 0.032228493600021*G0_0_2 - 0.128522535206562*G0_1_0 - 0.128522535206562*G0_1_1 - 0.032228493600021*G0_1_2 - 0.032228493600021*G0_2_0 - 0.032228493600021*G0_2_1 - 0.060673074995991*G0_2_2;
    A[2593] = 0.047625101878573*G0_0_0 + 0.047625101878573*G0_0_1 - 0.014744209622682*G0_0_2 + 0.047625101878573*G0_1_0 + 0.047625101878574*G0_1_1 - 0.014744209622682*G0_1_2 - 0.014744209622682*G0_2_0 - 0.014744209622682*G0_2_1 + 0.047625101878574*G0_2_2;
    A[2594] = -0.015005169085030*G0_0_0 - 0.015005169085030*G0_0_1 + 0.022768713089893*G0_0_2 - 0.015005169085030*G0_1_0 - 0.015005169085030*G0_1_1 + 0.022768713089894*G0_1_2 + 0.022768713089894*G0_2_0 + 0.022768713089893*G0_2_1 - 0.066544662898829*G0_2_2;
    A[2595] = -0.009394540644541*G0_0_2 - 0.009394540644541*G0_1_2 - 0.009394540644541*G0_2_0 - 0.009394540644541*G0_2_1 + 0.045341706583026*G0_2_2;
    A[2596] = -0.257045070413123*G0_0_0 - 0.160751028806582*G0_0_1 - 0.257045070413123*G0_0_2 - 0.160751028806582*G0_1_0 - 0.064456987200041*G0_1_1 - 0.160751028806583*G0_1_2 - 0.064456987200041*G0_2_0 - 0.092901568596011*G0_2_1 - 0.064456987200041*G0_2_2;
    A[2597] = 0.121346149991981*G0_0_0 + 0.194675758911867*G0_0_1 + 0.121346149991982*G0_0_2 + 0.194675758911868*G0_1_0 - 0.003392473010529*G0_1_1 + 0.194675758911869*G0_1_2 + 0.132306447410612*G0_2_0 + 0.058976838490726*G0_2_1 + 0.132306447410612*G0_2_2;
    A[2598] = -0.052844291125540*G0_0_0 - 0.088791457064025*G0_0_1 - 0.052844291125541*G0_0_2 - 0.088791457064026*G0_1_0 + 0.084681345532040*G0_1_1 - 0.088791457064026*G0_1_2 - 0.051017574889102*G0_2_0 - 0.004632030456683*G0_2_1 - 0.051017574889102*G0_2_2;
    A[2599] = 0.021268196181390*G0_0_1 + 0.021268196181391*G0_1_0 - 0.069349977119074*G0_1_1 + 0.021268196181391*G0_1_2 + 0.011873655536850*G0_2_0 - 0.014613729891508*G0_2_1 + 0.011873655536850*G0_2_2;
    A[2600] = -0.064456987200042*G0_0_0 - 0.160751028806582*G0_0_1 - 0.160751028806582*G0_0_2 - 0.160751028806582*G0_1_0 - 0.257045070413123*G0_1_1 - 0.257045070413123*G0_1_2 - 0.092901568596012*G0_2_0 - 0.064456987200042*G0_2_1 - 0.064456987200042*G0_2_2;
    A[2601] = -0.003392473010529*G0_0_0 + 0.194675758911867*G0_0_1 + 0.194675758911867*G0_0_2 + 0.194675758911868*G0_1_0 + 0.121346149991981*G0_1_1 + 0.121346149991981*G0_1_2 + 0.058976838490726*G0_2_0 + 0.132306447410612*G0_2_1 + 0.132306447410612*G0_2_2;
    A[2602] = 0.084681345532039*G0_0_0 - 0.088791457064025*G0_0_1 - 0.088791457064025*G0_0_2 - 0.088791457064025*G0_1_0 - 0.052844291125540*G0_1_1 - 0.052844291125540*G0_1_2 - 0.004632030456683*G0_2_0 - 0.051017574889101*G0_2_1 - 0.051017574889101*G0_2_2;
    A[2603] = -0.069349977119074*G0_0_0 + 0.021268196181390*G0_0_1 + 0.021268196181390*G0_0_2 + 0.021268196181390*G0_1_0 - 0.014613729891508*G0_2_0 + 0.011873655536849*G0_2_1 + 0.011873655536849*G0_2_2;
    A[2604] = -0.045667905910961*G0_0_0 - 0.037839122040510*G0_0_1 - 0.075678244081021*G0_0_2 - 0.037839122040511*G0_1_0 - 0.052844291125540*G0_1_2 - 0.075678244081021*G0_2_0 - 0.052844291125540*G0_2_1 - 0.105688582251081*G0_2_2;
    A[2605] = -0.088073818542567*G0_0_0 - 0.088726217198438*G0_0_1 - 0.100795592332049*G0_0_2 - 0.088726217198438*G0_1_0 - 0.088073818542568*G0_1_1 - 0.100795592332049*G0_1_2 - 0.100795592332049*G0_2_0 - 0.100795592332049*G0_2_1 - 0.113517366121531*G0_2_2;
    A[2606] = -0.037839122040510*G0_0_1 - 0.052844291125540*G0_0_2 - 0.037839122040511*G0_1_0 - 0.045667905910961*G0_1_1 - 0.075678244081021*G0_1_2 - 0.052844291125540*G0_2_0 - 0.075678244081021*G0_2_1 - 0.105688582251081*G0_2_2;
    A[2607] = -0.022833952955479*G0_0_0 - 0.012069375133611*G0_0_1 - 0.024138750267222*G0_0_2 - 0.012069375133610*G0_1_0 - 0.012721773789481*G0_1_2 - 0.024138750267222*G0_2_0 - 0.012721773789482*G0_2_1 - 0.025443547578964*G0_2_2;
    A[2608] = -0.012069375133611*G0_0_1 - 0.012721773789482*G0_0_2 - 0.012069375133611*G0_1_0 - 0.022833952955480*G0_1_1 - 0.024138750267222*G0_1_2 - 0.012721773789482*G0_2_0 - 0.024138750267223*G0_2_1 - 0.025443547578964*G0_2_2;
    A[2609] = -0.015005169085030*G0_0_1 - 0.030010338170060*G0_0_2 - 0.015005169085030*G0_1_0 - 0.030010338170060*G0_1_2 - 0.030010338170060*G0_2_0 - 0.030010338170060*G0_2_1 - 0.060020676340120*G0_2_2;
    A[2610] = 0.052191892469669*G0_0_0 + 0.187890812890811*G0_0_1 + 0.323589733311952*G0_0_2 + 0.187890812890811*G0_1_0 + 0.323589733311953*G0_1_1 + 0.187890812890811*G0_1_2 + 0.323589733311952*G0_2_0 + 0.187890812890811*G0_2_1 + 0.052191892469669*G0_2_2;
    A[2611] = -0.088073818542567*G0_0_0 - 0.097207399724760*G0_0_1 - 0.134067923781464*G0_0_2 - 0.097207399724759*G0_1_0 - 0.292274597830151*G0_1_1 - 0.224425137619579*G0_1_2 - 0.134067923781463*G0_2_0 - 0.224425137619579*G0_2_1 - 0.156575677409008*G0_2_2;
    A[2612] = 0.037839122040511*G0_0_1 + 0.052844291125540*G0_0_2 + 0.037839122040511*G0_1_0 + 0.127870136550692*G0_1_1 + 0.090031014510180*G0_1_2 + 0.052844291125541*G0_2_0 + 0.090031014510180*G0_2_1 + 0.052191892469670*G0_2_2;
    A[2613] = -0.022833952955480*G0_0_0 - 0.059694477012184*G0_0_1 - 0.096555001068889*G0_0_2 - 0.059694477012184*G0_1_0 - 0.096555001068888*G0_1_1 - 0.028705540858318*G0_1_2 - 0.096555001068889*G0_2_0 - 0.028705540858318*G0_2_1 + 0.039143919352253*G0_2_2;
    A[2614] = 0.012069375133610*G0_0_1 + 0.012721773789482*G0_0_2 + 0.012069375133611*G0_1_0 + 0.050234696502056*G0_1_1 + 0.044689307927154*G0_1_2 + 0.012721773789482*G0_2_0 + 0.044689307927154*G0_2_1 + 0.039143919352252*G0_2_2;
    A[2615] = 0.015005169085031*G0_0_1 + 0.030010338170060*G0_0_2 + 0.015005169085030*G0_1_0 + 0.030010338170061*G0_1_1 - 0.007828783870450*G0_1_2 + 0.030010338170060*G0_2_0 - 0.007828783870450*G0_2_1 - 0.045667905910961*G0_2_2;
    A[2616] = 0.323589733311951*G0_0_0 + 0.187890812890810*G0_0_1 + 0.187890812890811*G0_0_2 + 0.187890812890811*G0_1_0 + 0.052191892469669*G0_1_1 + 0.323589733311952*G0_1_2 + 0.187890812890810*G0_2_0 + 0.323589733311952*G0_2_1 + 0.052191892469670*G0_2_2;
    A[2617] = -0.292274597830149*G0_0_0 - 0.097207399724759*G0_0_1 - 0.224425137619579*G0_0_2 - 0.097207399724760*G0_1_0 - 0.088073818542568*G0_1_1 - 0.134067923781464*G0_1_2 - 0.224425137619579*G0_2_0 - 0.134067923781464*G0_2_1 - 0.156575677409009*G0_2_2;
    A[2618] = 0.127870136550690*G0_0_0 + 0.037839122040510*G0_0_1 + 0.090031014510180*G0_0_2 + 0.037839122040510*G0_1_0 + 0.052844291125541*G0_1_2 + 0.090031014510179*G0_2_0 + 0.052844291125540*G0_2_1 + 0.052191892469669*G0_2_2;
    A[2619] = -0.096555001068888*G0_0_0 - 0.059694477012185*G0_0_1 - 0.028705540858318*G0_0_2 - 0.059694477012185*G0_1_0 - 0.022833952955481*G0_1_1 - 0.096555001068889*G0_1_2 - 0.028705540858319*G0_2_0 - 0.096555001068890*G0_2_1 + 0.039143919352252*G0_2_2;
    A[2620] = 0.050234696502057*G0_0_0 + 0.012069375133611*G0_0_1 + 0.044689307927155*G0_0_2 + 0.012069375133611*G0_1_0 + 0.012721773789482*G0_1_2 + 0.044689307927155*G0_2_0 + 0.012721773789482*G0_2_1 + 0.039143919352253*G0_2_2;
    A[2621] = 0.030010338170060*G0_0_0 + 0.015005169085030*G0_0_1 - 0.007828783870451*G0_0_2 + 0.015005169085030*G0_1_0 + 0.030010338170060*G0_1_2 - 0.007828783870450*G0_2_0 + 0.030010338170060*G0_2_1 - 0.045667905910961*G0_2_2;
    A[2622] = 0.647179466623903*G0_0_0 + 0.375781625781621*G0_0_1 + 0.375781625781620*G0_0_2 + 0.375781625781621*G0_1_0 + 0.647179466623905*G0_1_1 + 0.375781625781621*G0_1_2 + 0.375781625781620*G0_2_0 + 0.375781625781621*G0_2_1 + 0.647179466623904*G0_2_2;
    A[2623] = -0.584549195660299*G0_0_0 - 0.321632537344339*G0_0_1 - 0.194414799449519*G0_0_2 - 0.321632537344339*G0_1_0 - 0.268135847562928*G0_1_1 - 0.222141742324031*G0_1_2 - 0.448850275239158*G0_2_0 - 0.290643601190473*G0_2_1 - 0.268135847562928*G0_2_2;
    A[2624] = 0.255740273101381*G0_0_0 + 0.127870136550690*G0_0_1 + 0.075678244081020*G0_0_2 + 0.127870136550690*G0_1_0 + 0.105688582251081*G0_1_1 + 0.052844291125540*G0_1_2 + 0.180062029020359*G0_2_0 + 0.105036183595210*G0_2_1 + 0.105688582251080*G0_2_2;
    A[2625] = -0.268135847562927*G0_0_0 - 0.321632537344339*G0_0_1 - 0.222141742324031*G0_0_2 - 0.321632537344339*G0_1_0 - 0.584549195660302*G0_1_1 - 0.194414799449519*G0_1_2 - 0.290643601190472*G0_2_0 - 0.448850275239159*G0_2_1 - 0.268135847562928*G0_2_2;
    A[2626] = 0.172233245149909*G0_0_0 + 0.166035457919136*G0_0_1 + 0.100795592332049*G0_0_2 + 0.166035457919137*G0_1_0 + 0.172233245149910*G0_1_1 + 0.100795592332049*G0_1_2 + 0.198655390712680*G0_2_0 + 0.198655390712681*G0_2_1 + 0.113517366121531*G0_2_2;
    A[2627] = 0.105688582251081*G0_0_0 + 0.127870136550691*G0_0_1 + 0.052844291125539*G0_0_2 + 0.127870136550690*G0_1_0 + 0.255740273101382*G0_1_1 + 0.075678244081020*G0_1_2 + 0.105036183595209*G0_2_0 + 0.180062029020360*G0_2_1 + 0.105688582251080*G0_2_2;
    A[2628] = -0.150051690850299*G0_0_0 - 0.335985307773498*G0_0_1 - 0.466465038947672*G0_0_2 - 0.335985307773498*G0_1_0 - 0.150051690850299*G0_1_1 - 0.466465038947673*G0_1_2 - 0.466465038947674*G0_2_0 - 0.466465038947673*G0_2_1 - 0.782878387045046*G0_2_2;
    A[2629] = 0.143527704291591*G0_0_0 + 0.185933616923196*G0_0_1 + 0.218553549716741*G0_0_2 + 0.185933616923198*G0_1_0 + 0.176147637085135*G0_1_1 + 0.234863516113513*G0_1_2 + 0.218553549716743*G0_2_0 + 0.234863516113513*G0_2_1 + 0.293579395141892*G0_2_2;
    A[2630] = 0.176147637085134*G0_0_0 + 0.185933616923198*G0_0_1 + 0.234863516113513*G0_0_2 + 0.185933616923197*G0_1_0 + 0.143527704291590*G0_1_1 + 0.218553549716742*G0_1_2 + 0.234863516113512*G0_2_0 + 0.218553549716742*G0_2_1 + 0.293579395141893*G0_2_2;
    A[2631] = 0.045667905910960*G0_0_0 + 0.071763852145796*G0_0_1 + 0.120693751336111*G0_0_2 + 0.071763852145794*G0_1_0 + 0.045667905910961*G0_1_1 + 0.120693751336111*G0_1_2 + 0.120693751336111*G0_2_0 + 0.120693751336112*G0_2_1 + 0.195719596761261*G0_2_2;
    A[2632] = -0.029847238506092*G0_0_0 - 0.029847238506092*G0_0_1 - 0.029847238506092*G0_0_2 - 0.029847238506092*G0_1_0 - 0.029847238506092*G0_1_1 - 0.029847238506092*G0_1_2 - 0.034571909571909*G0_2_0 - 0.034571909571909*G0_2_1 - 0.034571909571909*G0_2_2;
    A[2633] = -0.029847238506093*G0_0_0 + 0.004724671065817*G0_2_0;
    A[2634] = 0.011743175805676*G0_1_1 + 0.002278176106301*G0_2_1;
    A[2635] = -0.009464999699375*G0_2_2;
    A[2636] = -0.009133581182192*G0_1_1 - 0.005838967970044*G0_1_2 - 0.005838967970044*G0_2_1 - 0.002544354757896*G0_2_2;
    A[2637] = -0.015657567740901*G0_1_1 - 0.013080593050211*G0_1_2 - 0.013080593050211*G0_2_1 - 0.010503618359521*G0_2_2;
    A[2638] = -0.000652398655871*G0_1_1 + 0.001924576034819*G0_1_2 + 0.001924576034819*G0_2_1 + 0.004501550725509*G0_2_2;
    A[2639] = 0.003294613212148*G0_1_2 + 0.003294613212148*G0_2_1 + 0.006589226424296*G0_2_2;
    A[2640] = 0.064261267603281*G0_0_0 + 0.042275432900432*G0_0_2 + 0.042275432900432*G0_2_0 + 0.042960451489096*G0_2_2;
    A[2641] = 0.008807381854257*G0_0_0 + 0.006491366625916*G0_0_2 + 0.006491366625915*G0_2_0 + 0.003522952741703*G0_2_2;
    A[2642] = -0.000652398655871*G0_0_0 - 0.009492400442922*G0_0_2 - 0.009492400442921*G0_2_0 - 0.018984800885843*G0_2_2;
    A[2643] = 0.003294613212148*G0_0_2 + 0.003294613212148*G0_2_0 + 0.029260079715809*G0_2_2;
    A[2644] = 0.128522535206562*G0_0_0 + 0.042275432900432*G0_0_1 + 0.042275432900432*G0_1_0 + 0.084550865800865*G0_2_0 + 0.042960451489096*G0_2_1;
    A[2645] = 0.037186723384639*G0_0_0 + 0.074340826836486*G0_0_1 + 0.074340826836485*G0_1_0 + 0.104709984267275*G0_1_1 + 0.080832193462401*G0_2_0 + 0.108232937008978*G0_2_1;
    A[2646] = -0.006197787230773*G0_0_0 + 0.018886941087462*G0_0_1 + 0.018886941087462*G0_1_0 + 0.056758683060766*G0_1_1 + 0.009394540644540*G0_2_0 + 0.037773882174923*G0_2_1;
    A[2647] = -0.005838967970044*G0_0_1 - 0.005838967970045*G0_1_0 - 0.043547610279381*G0_1_1 - 0.002544354757896*G0_2_0 - 0.014287530563572*G0_2_1;
    A[2648] = 0.064261267603281*G0_0_0 + 0.064261267603281*G0_0_1 + 0.021985834702849*G0_0_2 + 0.064261267603281*G0_1_0 + 0.064261267603281*G0_1_1 + 0.021985834702848*G0_1_2 + 0.021985834702848*G0_2_0 + 0.021985834702848*G0_2_1 + 0.022670853291513*G0_2_2;
    A[2649] = 0.008807381854257*G0_0_0 + 0.008807381854257*G0_0_1 + 0.002316015228341*G0_0_2 + 0.008807381854257*G0_1_0 + 0.008807381854257*G0_1_1 + 0.002316015228341*G0_1_2 + 0.002316015228341*G0_2_0 + 0.002316015228342*G0_2_1 - 0.000652398655871*G0_2_2;
    A[2650] = -0.000652398655871*G0_0_0 - 0.000652398655871*G0_0_1 + 0.008840001787051*G0_0_2 - 0.000652398655871*G0_1_0 - 0.000652398655871*G0_1_1 + 0.008840001787050*G0_1_2 + 0.008840001787050*G0_2_0 + 0.008840001787050*G0_2_1 - 0.000652398655871*G0_2_2;
    A[2651] = -0.003294613212148*G0_0_2 - 0.003294613212148*G0_1_2 - 0.003294613212148*G0_2_0 - 0.003294613212148*G0_2_1 + 0.022670853291513*G0_2_2;
    A[2652] = 0.128522535206561*G0_0_0 + 0.086247102306129*G0_0_1 + 0.128522535206561*G0_0_2 + 0.086247102306129*G0_1_0 + 0.043971669405696*G0_1_1 + 0.086247102306129*G0_1_2 + 0.043971669405696*G0_2_0 + 0.044656687994361*G0_2_1 + 0.043971669405696*G0_2_2;
    A[2653] = 0.037186723384640*G0_0_0 - 0.037154103451846*G0_0_1 + 0.037186723384640*G0_0_2 - 0.037154103451846*G0_1_0 - 0.006784946021056*G0_1_1 - 0.037154103451846*G0_1_2 - 0.043645470077761*G0_2_0 - 0.009753359905269*G0_2_1 - 0.043645470077761*G0_2_2;
    A[2654] = -0.006197787230773*G0_0_0 - 0.025084728318235*G0_0_1 - 0.006197787230773*G0_0_2 - 0.025084728318236*G0_1_0 + 0.012787013655069*G0_1_1 - 0.025084728318235*G0_1_2 - 0.015592327875314*G0_2_0 + 0.003294613212147*G0_2_1 - 0.015592327875314*G0_2_2;
    A[2655] = 0.005838967970044*G0_0_1 + 0.005838967970045*G0_1_0 - 0.031869674339292*G0_1_1 + 0.005838967970045*G0_1_2 + 0.002544354757896*G0_2_0 - 0.005904207835631*G0_2_1 + 0.002544354757896*G0_2_2;
    A[2656] = 0.092086070276173*G0_0_0 + 0.134361503176605*G0_0_1 + 0.134361503176605*G0_0_2 + 0.134361503176606*G0_1_0 + 0.176636936077038*G0_1_1 + 0.176636936077038*G0_1_2 + 0.128000616281865*G0_2_0 + 0.127315597693200*G0_2_1 + 0.127315597693200*G0_2_2;
    A[2657] = -0.062238831770080*G0_0_0 - 0.250814663249555*G0_0_1 - 0.250814663249555*G0_0_2 - 0.250814663249556*G0_1_0 - 0.334680510461757*G0_1_1 - 0.334680510461757*G0_1_2 - 0.160783648739376*G0_2_0 - 0.166948816037355*G0_2_1 - 0.166948816037355*G0_2_2;
    A[2658] = -0.062238831770082*G0_0_0 + 0.188575831479474*G0_0_1 + 0.188575831479474*G0_0_2 + 0.188575831479475*G0_1_0 + 0.104709984267274*G0_1_1 + 0.104709984267274*G0_1_2 + 0.098544816969294*G0_2_0 + 0.182410664181495*G0_2_1 + 0.182410664181495*G0_2_2;
    A[2659] = 0.092086070276174*G0_0_0 - 0.042275432900432*G0_0_1 - 0.042275432900432*G0_0_2 - 0.042275432900432*G0_1_0 - 0.035914546005691*G0_2_0 - 0.042960451489096*G0_2_1 - 0.042960451489096*G0_2_2;
    A[2660] = 0.039143919352253*G0_0_0 + 0.067849460210571*G0_0_1 + 0.135698920421141*G0_0_2 + 0.067849460210570*G0_1_0 + 0.104709984267274*G0_1_2 + 0.135698920421142*G0_2_0 + 0.104709984267275*G0_2_1 + 0.209419968534549*G0_2_2;
    A[2661] = 0.019571959676126*G0_0_0 + 0.060673074995990*G0_0_1 + 0.074862745761181*G0_0_2 + 0.060673074995991*G0_1_0 + 0.092966808461598*G0_1_1 + 0.121346149991981*G0_1_2 + 0.074862745761182*G0_2_0 + 0.121346149991981*G0_2_1 + 0.149725491522364*G0_2_2;
    A[2662] = -0.005545388574902*G0_0_1 - 0.006197787230773*G0_0_2 - 0.005545388574903*G0_1_0 + 0.039143919352252*G0_1_1 + 0.026422145562770*G0_1_2 - 0.006197787230773*G0_2_0 + 0.026422145562771*G0_2_1 + 0.013700371773289*G0_2_2;
    A[2663] = -0.004892989919033*G0_0_0 + 0.014189670765191*G0_0_1 + 0.028379341530383*G0_0_2 + 0.014189670765192*G0_1_0 + 0.028379341530383*G0_1_2 + 0.028379341530383*G0_2_0 + 0.028379341530383*G0_2_1 + 0.056758683060766*G0_2_2;
    A[2664] = -0.010275278829966*G0_0_1 - 0.018104062700417*G0_0_2 - 0.010275278829966*G0_1_0 + 0.019571959676127*G0_1_1 + 0.001467896975710*G0_1_2 - 0.018104062700416*G0_2_0 + 0.001467896975710*G0_2_1 - 0.016636165724707*G0_2_2;
    A[2665] = -0.000652398655871*G0_0_1 - 0.001304797311742*G0_0_2 - 0.000652398655871*G0_1_0 - 0.012721773789482*G0_1_2 - 0.001304797311742*G0_2_0 - 0.012721773789482*G0_2_1 - 0.025443547578964*G0_2_2;
    A[2666] = 0.039143919352253*G0_0_0 - 0.028705540858318*G0_0_1 - 0.096555001068889*G0_0_2 - 0.028705540858319*G0_1_0 - 0.096555001068889*G0_1_1 - 0.059694477012184*G0_1_2 - 0.096555001068890*G0_2_0 - 0.059694477012185*G0_2_1 - 0.022833952955480*G0_2_2;
    A[2667] = 0.019571959676126*G0_0_0 - 0.041101115319865*