# Copyright (C) 2009 Anders Logg
#
# This file is part of DOLFIN.
#
# DOLFIN is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# DOLFIN is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with DOLFIN.  If not, see <http://www.gnu.org/licenses/>.
#
# Modified by Johannes Ring, 2009.
#
# First added:  2009-09-16
# Last changed: 2009-09-16

from subprocess import Popen, PIPE, STDOUT

# These are taken from http://ivory.idyll.org/blog/mar-07/replacing-commands-with-subprocess

__all__ = ['getoutput', 'getstatusoutput']

def getoutput(cmd):
    "Replacement for commands.getoutput which does not work on Windows."
    pipe = Popen(cmd, shell=True, stdout=PIPE, stderr=STDOUT, bufsize=-1)
    r = pipe.wait()
    output, error = pipe.communicate()
    return output

def getstatusoutput(cmd, input=None, cwd=None, env=None):
    "Replacement for commands.getstatusoutput which does not work on Windows."
    pipe = Popen(cmd, shell=True, cwd=cwd, env=env, stdout=PIPE, stderr=STDOUT)
    output, error = pipe.communicate(input=input)
    assert not error
    status = pipe.returncode
    return status, output
