package com.netscape.certsrv.property;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

import com.netscape.certsrv.util.JSONSerializer;

public class DescriptorTest {

    private static Descriptor before = new Descriptor(
            IDescriptor.CHOICE,
            "true,false,-",
            "-",
            "CMS_PROFILE_CRITICAL");

    @Test
    public void testJSON() throws Exception {
        // Act
        String json = before.toJSON();
        System.out.println("JSON (before): " + json);

        Descriptor afterJSON = JSONSerializer.fromJSON(json, Descriptor.class);
        System.out.println("JSON (after): " + afterJSON.toJSON());

        // Assert
        assertEquals(before, afterJSON);
    }
}
