<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
                exclude-result-prefixes="doc"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: texifile.xsl,v 1.6 2003/05/24 13:52:46 stevecheng Exp $
     ********************************************************************

     &copy; 2000-2001 Steve Cheng <stevecheng@users.sourceforge.net>

     This file is part of the docbook2X XSLT stylesheets for
     converting DocBook to Texinfo.

     Originally derived from Norman Walsh's XSL DocBook Stylesheet
     Distribution.

     ******************************************************************** -->

<!-- ==================================================================== -->

<doc:reference xmlns="">
<title>Texinfo multiple-file handling</title>
<partintro>
<para>
These templates are used when making cross references between the
multiple Texinfo files that are generated from a single DocBook <sgmltag
class="element">set</sgmltag>.  The user generally does not modify these
templates.
</para>
</partintro>
</doc:reference>

<!-- ==================================================================== -->

<doc:template name="get-texinfo-file-name" xmlns="">
<refpurpose>Find the file that contains the result</refpurpose>
<refdescription>
<para>
Returns the Texinfo file that contains the result when transforming
the context node.
</para>
<para>
In this implementation, every document element starts a new file, unless
the document element is <sgmltag class="element">set</sgmltag>, in which
case each child <sgmltag class="element">book</sgmltag> starts a new
file.
</para>
</refdescription>
<refparameter>
<variablelist>
<varlistentry>
<term><parameter>node</parameter></term>
<listitem><para>
The node to find information for.  Default is the context node.
</para></listitem>
</varlistentry>
</variablelist>
</refparameter>
</doc:template>

<xsl:template match="*" mode="texinfo-file-name">
  <xsl:apply-templates mode="texinfo-file-name" />
</xsl:template>

<!-- This ought to be more stringent -->
<xsl:template match="text()" mode="texinfo-file-name">
  <xsl:value-of select="translate(string(.), &quot;().,:'/\&quot;, &quot;_;;_--&quot;)" />
</xsl:template>

<xsl:template match="/set/book//*" priority="2.0" 
              mode="for-texinfo-file-name">
  <xsl:variable name="book" select="$node/ancestor-or-self::book" />
  <xsl:choose>
    <xsl:when test="$book/bookinfo/titleabbrev[@role='texinfo-file']">
      <xsl:value-of select="$book/bookinfo/titleabbrev[@role='texinfo-file']" />
    </xsl:when>
  
    <xsl:when test="$book/titleabbrev">
      <xsl:apply-templates select="$book/titleabbrev[1]"
                           mode="texinfo-file-name" />
    </xsl:when>
    <xsl:when test="$book/title">
      <xsl:apply-templates select="$book/title[1]"
                           mode="texinfo-file-name" />
    </xsl:when>
    <xsl:when test="$book/bookinfo/titleabbrev">
      <xsl:apply-templates select="$book/bookinfo/titleabbrev[1]"
                           mode="texinfo-file-name" />
    </xsl:when>
    <xsl:when test="$book/bookinfo/title">
      <xsl:apply-templates select="$book/bookinfo/title[1]"
                           mode="texinfo-file-name" />
    </xsl:when>
  
    <xsl:otherwise>
      <xsl:call-template name="user-message">
        <xsl:with-param name="key">Cannot generate Texinfo filename</xsl:with-param>
      </xsl:call-template>
  
      <!-- At the very least we can generate valid files -->
      <xsl:text>book</xsl:text>
      <xsl:value-of select="count($book/preceding-sibling::book) + 1" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="*" mode="for-texinfo-file-name">
  <xsl:variable name="root" select="/*" />
  <xsl:variable name="info" 
      select="$root/docinfo | $root/*[local-name(.)=concat(local-name($root),'info')]" />

  <xsl:choose>
    <xsl:when test="$info/titleabbrev[@role='texinfo-file']">
      <xsl:value-of select="$info/titleabbrev[@role='texinfo-file']" />
    </xsl:when>
    
    <xsl:when test="$root/titleabbrev">
      <xsl:apply-templates select="$root/titleabbrev[1]"
                           mode="texinfo-file-name" />
    </xsl:when>
    <xsl:when test="$root/title">
      <xsl:apply-templates select="$root/title[1]"
                           mode="texinfo-file-name" />
    </xsl:when>
    <xsl:when test="$info/titleabbrev">
      <xsl:apply-templates select="$info/titleabbrev[1]"
                           mode="texinfo-file-name" />
    </xsl:when>
    <xsl:when test="$info/title">
      <xsl:apply-templates select="$info/title[1]"
                           mode="texinfo-file-name" />
    </xsl:when>

    <xsl:otherwise></xsl:otherwise>
  </xsl:choose>
</xsl:template>
 
<xsl:template name="get-texinfo-file-name">
  <xsl:param name="node" select="." />

  <xsl:choose>
    <xsl:when test="$output-file != ''">
      <xsl:value-of select="$output-file" />
    </xsl:when>

    <xsl:otherwise>
      <xsl:apply-templates select="$node" mode="for-texinfo-file-name" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>

