<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
                xmlns:l="http://docbook2x.sourceforge.net/xsl/localization"
                exclude-result-prefixes="doc l"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: xref.xsl,v 1.6 2003/05/24 13:52:45 stevecheng Exp $
     ********************************************************************

     &copy; 2000 Steve Cheng <stevecheng@users.sourceforge.net>

     Part of docbook2X, DocBook to man page conversion.

     ******************************************************************** -->

<!-- ==================================================================== -->

<xsl:template match="xref">
  <xsl:variable name="target" select="key('id', @linkend)"/>

  <xsl:call-template name="check.id">
    <xsl:with-param name="id" select="@linkend" />
  </xsl:call-template>
  
  <xsl:apply-templates select="$target" mode="xref-to" />

</xsl:template>

        
<!-- ==================================================================== -->

<xsl:template match="link">
  <xsl:variable name="target" select="key('id', @linkend)"/>

  <xsl:call-template name="check.id">
    <xsl:with-param name="id" select="@linkend" />
  </xsl:call-template>

  <xsl:apply-templates />

  <xsl:call-template name="gentext-title">
    <xsl:with-param name="content">
      <xsl:apply-templates select="$target" mode="xref-to" />
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="ulink">
  <xsl:apply-templates />
  <xsl:call-template name="gentext-title">
    <xsl:with-param name="content" select="string(@url)" />
  </xsl:call-template>
</xsl:template>

<!-- ==================================================================== -->

<doc:mode mode="xref-to" xmlns="">
<refpurpose>Give cross-reference markup</refpurpose>
<refdescription>
<para>
Processing an element with this mode returns the markup/text that should
be used for referring to it in cross-references.</para>
</refdescription>
</doc:mode>

<xsl:template match="*" mode="xref-to">
  
  <xsl:variable name="refentry" select="ancestor-or-self::refentry[1]" />

  <xsl:choose>
    <xsl:when test="count($refentry) != 0">
      <!-- Get name of man page -->
      <b>
        <xsl:apply-templates select="$refentry" mode="for-title" />
      </b>
      <xsl:text>(</xsl:text>
      <xsl:value-of select="$refentry/refmeta/manvolnum" />
      <xsl:text>)</xsl:text>
    </xsl:when>

    <xsl:otherwise>
      <xsl:call-template name="gentext-rendering">
        <xsl:with-param name="key" select="'xref-non-refentry'" />
        <xsl:with-param name="content" select="string(@id)" />
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>

</xsl:template>


<xsl:template name="check.id">
  <xsl:param name="id" />

  <xsl:if test="not(key('id', $id))">
    <xsl:call-template name="user-message">
      <xsl:with-param name="arg-1" select="@linkend" />
      <xsl:with-param name="key">Reference to non-existent ID</xsl:with-param>
      <xsl:with-param name="content">Reference to non-existent ID "<l:a1/>"</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="gentext-rendering">
      <xsl:with-param name="key" select="'dangling-xref'" />
      <xsl:with-param name="content" select="string(@linkend)" />
    </xsl:call-template>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
