/*
 * Copyright 2005-2009 SPARTA, Inc.  All rights reserved.
 * See the COPYING file distributed with this software for details.
 */
#ifndef VAL_RESQUERY_H
#define VAL_RESQUERY_H

struct glue_fetch_bucket {
    struct queries_for_query *qfq[MAX_GLUE_FETCH_DEPTH];
    int qfq_count;
    struct glue_fetch_bucket *next_bucket;
};

int             fix_glue(val_context_t * context,
                         struct queries_for_query **queries,
                         int *data_missing);
int             res_zi_unverified_ns_list(struct name_server **ns_list,
                                          u_int8_t * zone_name,
                                          struct rrset_rec
                                          *unchecked_zone_info, struct name_server
                                          **pending_glue);
int             find_nslist_for_query(val_context_t * context,
                                      struct queries_for_query *next_qfq,
                                      struct queries_for_query **queries);
int             bootstrap_referral(val_context_t *context,
                                   u_int8_t * referral_zone_n,
                                   struct rrset_rec **learned_zones,
                                   struct queries_for_query *matched_qfq,
                                   struct queries_for_query **queries,
                                   struct name_server **ref_ns_list,
                                   int no_partial);
void            free_referral_members(struct delegation_info *del);
int             process_cname_dname_responses(u_int8_t *name_n, 
                              u_int16_t type_h, 
                              u_int8_t *rdata, 
                              struct val_query_chain *matched_q,
                              struct qname_chain **qnames,
                              int *referral_error);
int             val_resquery_send(val_context_t * context,
                                  struct queries_for_query *matched_qfq);
int             val_resquery_rcv(val_context_t * context,
                                 struct queries_for_query *matched_qfq,
                                 struct domain_info **response,
                                 struct queries_for_query **queries,
                                 fd_set *pending_desc,
                                 struct timeval *closest_event);

#endif                          /* VAL_RESQUERY_H */
