#include <config.h>
#include <string.h>
#include <stdint.h>
#include <limits.h>
#include "dnotify.h"

char *expand_braces(char *spec, char *repl)
{
	int count = 0;
	char *b1;
	char *b2;

	for (b1 = spec; (b2 = strstr(b1, "{}")) != NULL; b1 = b2+2)
		count++;

	if (count > 0) {
		char *out;
		size_t start = 0;
		size_t repllen = strlen(repl);

		/* this is freed when child process terminates */
		out = malloc(strlen(spec) + repllen*count - 2*count + 1);
		if (out == NULL)
			die("out of memory");

		for (b1 = spec; (b2 = strstr(b1, "{}")) != NULL; b1 = b2+2) {
			strncpy(out+start, b1, b2-b1);
			start += b2-b1;
			strcpy(out+start, repl);
			start += repllen;
		}

		strcat(out+start, b1);
		return out;
	}

	return spec;
}

char *concat_dirname(char *file1, char *file2)
{
	int len;
	char *outfile;

	len = strlen(file1);
	outfile = malloc(len+1+strlen(file2)+1);
	if (outfile == NULL)
		die("out of memory");

	strcpy(outfile, file1);
	if (file1[len-1] != '/')
		strcat(outfile, "/");
	strcat(outfile, file2);

	return outfile;
}

int
parse_int32(const char *instr, int32_t *outint)
{
	int32_t value = 0;

	if (*instr == '-') {
		if (instr[1] == '\0')		/* FIXME: this should be done on all!!! */
			return 0;
		for (instr++; *instr != '\0'; instr++) {
			int8_t c = *instr - '0';
			if (c < 0 || c > 9)
				return 0;
			if (value < INT32_MIN/10L || (value == INT32_MIN/10L && c > -(INT32_MIN%10L)))
				return 0;
			value = value*10L - c;
		}
	} else {
		if (*instr == '\0')			/* FIXME: this should be done on all!!! */
			return 0;
		for (; *instr != '\0'; instr++) {
			int8_t c = *instr - '0';
			if (c < 0 || c > 9)
				return 0;
			if (value > INT32_MAX/10L || (value == INT32_MAX/10L && c > INT32_MAX%10L))
				return 0;
			value = value*10L + c;
		}
	}
	*outint = value;

	return 1;
}
