/* ****************************************************************************
 *
 * Copyright (c) Microsoft Corporation. 
 *
 * This source code is subject to terms and conditions of the Microsoft Public License. A 
 * copy of the license can be found in the License.html file at the root of this distribution. If 
 * you cannot locate the  Microsoft Public License, please send an email to 
 * dlr@microsoft.com. By using this source code in any fashion, you are agreeing to be bound 
 * by the terms of the Microsoft Public License.
 *
 * You must not remove this notice, or any other, from this software.
 *
 *
 * ***************************************************************************/

using IronPython.Runtime;
using IronPython.Runtime.Types;
using Microsoft.Scripting;
using Microsoft.Scripting.Runtime;

#if !SILVERLIGHT
namespace IronPython.Modules {
    public static partial class PythonWeakRef {
        public sealed partial class weakproxy {

            #region Generated WeakRef Operators Initialization

            // *** BEGIN GENERATED CODE ***
            // generated by function: weakref_operators from: generate_ops.py

            [SlotField] public static PythonTypeSlot __add__ = new SlotWrapper(Symbols.OperatorAdd, ProxyType);
            [SlotField] public static PythonTypeSlot __radd__ = new SlotWrapper(Symbols.OperatorReverseAdd, ProxyType);
            [SlotField] public static PythonTypeSlot __iadd__ = new SlotWrapper(Symbols.OperatorInPlaceAdd, ProxyType);
            [SlotField] public static PythonTypeSlot __sub__ = new SlotWrapper(Symbols.OperatorSubtract, ProxyType);
            [SlotField] public static PythonTypeSlot __rsub__ = new SlotWrapper(Symbols.OperatorReverseSubtract, ProxyType);
            [SlotField] public static PythonTypeSlot __isub__ = new SlotWrapper(Symbols.OperatorInPlaceSubtract, ProxyType);
            [SlotField] public static PythonTypeSlot __pow__ = new SlotWrapper(Symbols.OperatorPower, ProxyType);
            [SlotField] public static PythonTypeSlot __rpow__ = new SlotWrapper(Symbols.OperatorReversePower, ProxyType);
            [SlotField] public static PythonTypeSlot __ipow__ = new SlotWrapper(Symbols.OperatorInPlacePower, ProxyType);
            [SlotField] public static PythonTypeSlot __mul__ = new SlotWrapper(Symbols.OperatorMultiply, ProxyType);
            [SlotField] public static PythonTypeSlot __rmul__ = new SlotWrapper(Symbols.OperatorReverseMultiply, ProxyType);
            [SlotField] public static PythonTypeSlot __imul__ = new SlotWrapper(Symbols.OperatorInPlaceMultiply, ProxyType);
            [SlotField] public static PythonTypeSlot __floordiv__ = new SlotWrapper(Symbols.OperatorFloorDivide, ProxyType);
            [SlotField] public static PythonTypeSlot __rfloordiv__ = new SlotWrapper(Symbols.OperatorReverseFloorDivide, ProxyType);
            [SlotField] public static PythonTypeSlot __ifloordiv__ = new SlotWrapper(Symbols.OperatorInPlaceFloorDivide, ProxyType);
            [SlotField] public static PythonTypeSlot __div__ = new SlotWrapper(Symbols.OperatorDivide, ProxyType);
            [SlotField] public static PythonTypeSlot __rdiv__ = new SlotWrapper(Symbols.OperatorReverseDivide, ProxyType);
            [SlotField] public static PythonTypeSlot __idiv__ = new SlotWrapper(Symbols.OperatorInPlaceDivide, ProxyType);
            [SlotField] public static PythonTypeSlot __truediv__ = new SlotWrapper(Symbols.OperatorTrueDivide, ProxyType);
            [SlotField] public static PythonTypeSlot __rtruediv__ = new SlotWrapper(Symbols.OperatorReverseTrueDivide, ProxyType);
            [SlotField] public static PythonTypeSlot __itruediv__ = new SlotWrapper(Symbols.OperatorInPlaceTrueDivide, ProxyType);
            [SlotField] public static PythonTypeSlot __mod__ = new SlotWrapper(Symbols.OperatorMod, ProxyType);
            [SlotField] public static PythonTypeSlot __rmod__ = new SlotWrapper(Symbols.OperatorReverseMod, ProxyType);
            [SlotField] public static PythonTypeSlot __imod__ = new SlotWrapper(Symbols.OperatorInPlaceMod, ProxyType);
            [SlotField] public static PythonTypeSlot __lshift__ = new SlotWrapper(Symbols.OperatorLeftShift, ProxyType);
            [SlotField] public static PythonTypeSlot __rlshift__ = new SlotWrapper(Symbols.OperatorReverseLeftShift, ProxyType);
            [SlotField] public static PythonTypeSlot __ilshift__ = new SlotWrapper(Symbols.OperatorInPlaceLeftShift, ProxyType);
            [SlotField] public static PythonTypeSlot __rshift__ = new SlotWrapper(Symbols.OperatorRightShift, ProxyType);
            [SlotField] public static PythonTypeSlot __rrshift__ = new SlotWrapper(Symbols.OperatorReverseRightShift, ProxyType);
            [SlotField] public static PythonTypeSlot __irshift__ = new SlotWrapper(Symbols.OperatorInPlaceRightShift, ProxyType);
            [SlotField] public static PythonTypeSlot __and__ = new SlotWrapper(Symbols.OperatorBitwiseAnd, ProxyType);
            [SlotField] public static PythonTypeSlot __rand__ = new SlotWrapper(Symbols.OperatorReverseBitwiseAnd, ProxyType);
            [SlotField] public static PythonTypeSlot __iand__ = new SlotWrapper(Symbols.OperatorInPlaceBitwiseAnd, ProxyType);
            [SlotField] public static PythonTypeSlot __or__ = new SlotWrapper(Symbols.OperatorBitwiseOr, ProxyType);
            [SlotField] public static PythonTypeSlot __ror__ = new SlotWrapper(Symbols.OperatorReverseBitwiseOr, ProxyType);
            [SlotField] public static PythonTypeSlot __ior__ = new SlotWrapper(Symbols.OperatorInPlaceBitwiseOr, ProxyType);
            [SlotField] public static PythonTypeSlot __xor__ = new SlotWrapper(Symbols.OperatorExclusiveOr, ProxyType);
            [SlotField] public static PythonTypeSlot __rxor__ = new SlotWrapper(Symbols.OperatorReverseExclusiveOr, ProxyType);
            [SlotField] public static PythonTypeSlot __ixor__ = new SlotWrapper(Symbols.OperatorInPlaceExclusiveOr, ProxyType);

            // *** END GENERATED CODE ***

            #endregion

            //[SlotField] public static PythonTypeSlot __cmp__ = new SlotWrapper(Symbols.Cmp, ProxyType);
            [SlotField] public static PythonTypeSlot __delslice__ = new SlotWrapper(Symbols.DeleteSlice, ProxyType);
            [SlotField] public static PythonTypeSlot __divmod__ = new SlotWrapper(Symbols.DivMod, ProxyType);
            [SlotField] public static PythonTypeSlot __float__ = new SlotWrapper(Symbols.ConvertToFloat, ProxyType);
            [SlotField] public static PythonTypeSlot __getslice__ = new SlotWrapper(Symbols.GetSlice, ProxyType);
            [SlotField] public static PythonTypeSlot __index__ = new SlotWrapper(Symbols.Index, ProxyType);
            [SlotField] public static PythonTypeSlot __int__ = new SlotWrapper(Symbols.ConvertToInt, ProxyType);
            [SlotField] public static PythonTypeSlot __iter__ = new SlotWrapper(Symbols.Iter, ProxyType);
            [SlotField] public static PythonTypeSlot __long__ = new SlotWrapper(Symbols.ConvertToLong, ProxyType);
            [SlotField] public static PythonTypeSlot __rdivmod__ = new SlotWrapper(Symbols.ReverseDivMod, ProxyType);
            [SlotField] public static PythonTypeSlot __setslice__ = new SlotWrapper(Symbols.SetSlice, ProxyType);
            [SlotField] public static PythonTypeSlot next = new SlotWrapper(SymbolTable.StringToId("next"), ProxyType);

            [SlotField] public static PythonTypeSlot __getitem__ = new SlotWrapper(Symbols.GetItem, ProxyType);
            [SlotField] public static PythonTypeSlot __setitem__ = new SlotWrapper(Symbols.SetItem, ProxyType);
            [SlotField] public static PythonTypeSlot __delitem__ = new SlotWrapper(Symbols.DelItem, ProxyType);
            [SlotField] public static PythonTypeSlot __len__ = new SlotWrapper(Symbols.Length, ProxyType);
            [SlotField] public static PythonTypeSlot __pos__ = new SlotWrapper(Symbols.Positive, ProxyType);
            [SlotField] public static PythonTypeSlot __neg__ = new SlotWrapper(Symbols.OperatorNegate, ProxyType);
            [SlotField] public static PythonTypeSlot __invert__ = new SlotWrapper(Symbols.OperatorOnesComplement, ProxyType);
            [SlotField] public static PythonTypeSlot __contains__ = new SlotWrapper(Symbols.Contains, ProxyType);
            [SlotField] public static PythonTypeSlot __abs__ = new SlotWrapper(Symbols.AbsoluteValue, ProxyType);
        }


        public sealed partial class weakcallableproxy {
            #region Generated WeakRef Callable Proxy Operators Initialization

            // *** BEGIN GENERATED CODE ***
            // generated by function: weakrefCallabelProxy_operators from: generate_ops.py

            [SlotField] public static PythonTypeSlot __add__ = new SlotWrapper(Symbols.OperatorAdd, CallableProxyType);
            [SlotField] public static PythonTypeSlot __radd__ = new SlotWrapper(Symbols.OperatorReverseAdd, CallableProxyType);
            [SlotField] public static PythonTypeSlot __iadd__ = new SlotWrapper(Symbols.OperatorInPlaceAdd, CallableProxyType);
            [SlotField] public static PythonTypeSlot __sub__ = new SlotWrapper(Symbols.OperatorSubtract, CallableProxyType);
            [SlotField] public static PythonTypeSlot __rsub__ = new SlotWrapper(Symbols.OperatorReverseSubtract, CallableProxyType);
            [SlotField] public static PythonTypeSlot __isub__ = new SlotWrapper(Symbols.OperatorInPlaceSubtract, CallableProxyType);
            [SlotField] public static PythonTypeSlot __pow__ = new SlotWrapper(Symbols.OperatorPower, CallableProxyType);
            [SlotField] public static PythonTypeSlot __rpow__ = new SlotWrapper(Symbols.OperatorReversePower, CallableProxyType);
            [SlotField] public static PythonTypeSlot __ipow__ = new SlotWrapper(Symbols.OperatorInPlacePower, CallableProxyType);
            [SlotField] public static PythonTypeSlot __mul__ = new SlotWrapper(Symbols.OperatorMultiply, CallableProxyType);
            [SlotField] public static PythonTypeSlot __rmul__ = new SlotWrapper(Symbols.OperatorReverseMultiply, CallableProxyType);
            [SlotField] public static PythonTypeSlot __imul__ = new SlotWrapper(Symbols.OperatorInPlaceMultiply, CallableProxyType);
            [SlotField] public static PythonTypeSlot __floordiv__ = new SlotWrapper(Symbols.OperatorFloorDivide, CallableProxyType);
            [SlotField] public static PythonTypeSlot __rfloordiv__ = new SlotWrapper(Symbols.OperatorReverseFloorDivide, CallableProxyType);
            [SlotField] public static PythonTypeSlot __ifloordiv__ = new SlotWrapper(Symbols.OperatorInPlaceFloorDivide, CallableProxyType);
            [SlotField] public static PythonTypeSlot __div__ = new SlotWrapper(Symbols.OperatorDivide, CallableProxyType);
            [SlotField] public static PythonTypeSlot __rdiv__ = new SlotWrapper(Symbols.OperatorReverseDivide, CallableProxyType);
            [SlotField] public static PythonTypeSlot __idiv__ = new SlotWrapper(Symbols.OperatorInPlaceDivide, CallableProxyType);
            [SlotField] public static PythonTypeSlot __truediv__ = new SlotWrapper(Symbols.OperatorTrueDivide, CallableProxyType);
            [SlotField] public static PythonTypeSlot __rtruediv__ = new SlotWrapper(Symbols.OperatorReverseTrueDivide, CallableProxyType);
            [SlotField] public static PythonTypeSlot __itruediv__ = new SlotWrapper(Symbols.OperatorInPlaceTrueDivide, CallableProxyType);
            [SlotField] public static PythonTypeSlot __mod__ = new SlotWrapper(Symbols.OperatorMod, CallableProxyType);
            [SlotField] public static PythonTypeSlot __rmod__ = new SlotWrapper(Symbols.OperatorReverseMod, CallableProxyType);
            [SlotField] public static PythonTypeSlot __imod__ = new SlotWrapper(Symbols.OperatorInPlaceMod, CallableProxyType);
            [SlotField] public static PythonTypeSlot __lshift__ = new SlotWrapper(Symbols.OperatorLeftShift, CallableProxyType);
            [SlotField] public static PythonTypeSlot __rlshift__ = new SlotWrapper(Symbols.OperatorReverseLeftShift, CallableProxyType);
            [SlotField] public static PythonTypeSlot __ilshift__ = new SlotWrapper(Symbols.OperatorInPlaceLeftShift, CallableProxyType);
            [SlotField] public static PythonTypeSlot __rshift__ = new SlotWrapper(Symbols.OperatorRightShift, CallableProxyType);
            [SlotField] public static PythonTypeSlot __rrshift__ = new SlotWrapper(Symbols.OperatorReverseRightShift, CallableProxyType);
            [SlotField] public static PythonTypeSlot __irshift__ = new SlotWrapper(Symbols.OperatorInPlaceRightShift, CallableProxyType);
            [SlotField] public static PythonTypeSlot __and__ = new SlotWrapper(Symbols.OperatorBitwiseAnd, CallableProxyType);
            [SlotField] public static PythonTypeSlot __rand__ = new SlotWrapper(Symbols.OperatorReverseBitwiseAnd, CallableProxyType);
            [SlotField] public static PythonTypeSlot __iand__ = new SlotWrapper(Symbols.OperatorInPlaceBitwiseAnd, CallableProxyType);
            [SlotField] public static PythonTypeSlot __or__ = new SlotWrapper(Symbols.OperatorBitwiseOr, CallableProxyType);
            [SlotField] public static PythonTypeSlot __ror__ = new SlotWrapper(Symbols.OperatorReverseBitwiseOr, CallableProxyType);
            [SlotField] public static PythonTypeSlot __ior__ = new SlotWrapper(Symbols.OperatorInPlaceBitwiseOr, CallableProxyType);
            [SlotField] public static PythonTypeSlot __xor__ = new SlotWrapper(Symbols.OperatorExclusiveOr, CallableProxyType);
            [SlotField] public static PythonTypeSlot __rxor__ = new SlotWrapper(Symbols.OperatorReverseExclusiveOr, CallableProxyType);
            [SlotField] public static PythonTypeSlot __ixor__ = new SlotWrapper(Symbols.OperatorInPlaceExclusiveOr, CallableProxyType);

            // *** END GENERATED CODE ***

            #endregion

            //[SlotField] public static PythonTypeSlot __cmp__ = new SlotWrapper(Symbols.Cmp, CallableProxyType);
            [SlotField] public static PythonTypeSlot __delslice__ = new SlotWrapper(Symbols.DeleteSlice, CallableProxyType);
            [SlotField] public static PythonTypeSlot __divmod__ = new SlotWrapper(Symbols.DivMod, CallableProxyType);
            [SlotField] public static PythonTypeSlot __float__ = new SlotWrapper(Symbols.ConvertToFloat, CallableProxyType);
            [SlotField] public static PythonTypeSlot __getslice__ = new SlotWrapper(Symbols.GetSlice, CallableProxyType);
            [SlotField] public static PythonTypeSlot __index__ = new SlotWrapper(Symbols.Index, CallableProxyType);
            [SlotField] public static PythonTypeSlot __int__ = new SlotWrapper(Symbols.ConvertToInt, CallableProxyType);
            [SlotField] public static PythonTypeSlot __iter__ = new SlotWrapper(Symbols.Iter, CallableProxyType);
            [SlotField] public static PythonTypeSlot __long__ = new SlotWrapper(Symbols.ConvertToLong, CallableProxyType);
            [SlotField] public static PythonTypeSlot __rdivmod__ = new SlotWrapper(Symbols.ReverseDivMod, CallableProxyType);
            [SlotField] public static PythonTypeSlot __setslice__ = new SlotWrapper(Symbols.SetSlice, CallableProxyType);
            [SlotField] public static PythonTypeSlot next = new SlotWrapper(SymbolTable.StringToId("next"), CallableProxyType);

            [SlotField] public static PythonTypeSlot __getitem__ = new SlotWrapper(Symbols.GetItem, CallableProxyType);
            [SlotField] public static PythonTypeSlot __setitem__ = new SlotWrapper(Symbols.SetItem, CallableProxyType);
            [SlotField] public static PythonTypeSlot __delitem__ = new SlotWrapper(Symbols.DelItem, CallableProxyType);
            [SlotField] public static PythonTypeSlot __len__ = new SlotWrapper(Symbols.Length, CallableProxyType);
            [SlotField] public static PythonTypeSlot __pos__ = new SlotWrapper(Symbols.Positive, CallableProxyType);
            [SlotField] public static PythonTypeSlot __neg__ = new SlotWrapper(Symbols.OperatorNegate, CallableProxyType);
            [SlotField] public static PythonTypeSlot __invert__ = new SlotWrapper(Symbols.OperatorOnesComplement, CallableProxyType);
            [SlotField] public static PythonTypeSlot __contains__ = new SlotWrapper(Symbols.Contains, CallableProxyType);
            [SlotField] public static PythonTypeSlot __abs__ = new SlotWrapper(Symbols.AbsoluteValue, CallableProxyType);
            [SlotField] public static PythonTypeSlot __call__ = new SlotWrapper(Symbols.Call, CallableProxyType);

        }
    }
}
#endif
