#
# common.py - DITrack common utility functions
#
# Copyright (c) 2006-2007 The DITrack Project, www.ditrack.org.
#
# $Id: common.py 1846 2007-08-04 11:25:09Z gli $
# $HeadURL: https://127.0.0.1/ditrack/src/tags/0.7/DITrack/Util/common.py $
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

import datetime
import os
import sys

# DITrack modules
import DITrack.DB.Common
import DITrack.DB.Exceptions

# Environment variable pointing to a database root.
DITRACK_ROOT="DITRACK_ROOT"

def err(msg, fatal=True):
    "Print error message and exit with nonzero error status"
    sys.stderr.write("%s\n" % msg)

    if fatal:
        sys.exit(1)

def get_db_root(opts=None):
    "Returns database root, given options"

    if opts and opts.var.has_key("database"):
        return opts.var["database"], "specified in command line"
    elif os.environ.has_key(DITRACK_ROOT):
        return os.environ[DITRACK_ROOT], \
            "specified by " + DITRACK_ROOT + " environment variable"
    else:
        return ".", "default path"

# XXX: Should be moved to somewhere like DITrack.DB.Util.
def open_db(globals, opts, mode="r"):

    assert (mode == "r") or (mode == "w"), mode

    dbroot, source = get_db_root(opts)
    assert(len(dbroot))

    # Now try opening this database.
    globals.get_username(opts);
    try:
        db = DITrack.DB.Common.Database(dbroot, globals.username,
            globals.svn_path, mode)
    except DITrack.DB.Exceptions.NotDatabaseError, e:
        err("'" + dbroot + "' (" + source + ") is not an issue database root")
    except DITrack.DB.Exceptions.NotDirectoryError, e:
        err("'" + dbroot + "' (" + source + ") doesn't exist or is not a "
            "directory")
    except DITrack.DB.Exceptions.InvalidVersionError, e:
        err("'" + dbroot + "' (" + source + ") is not of a supported database "
            "format version")
    except DITrack.DB.Exceptions.InvalidUserError, e:
        err("Invalid user name: '%s'" % globals.username)
    except DITrack.DB.Exceptions.DBIsLockedError, e:
        err("Database '" + dbroot + "' (" + source + ") is locked")
    except DITrack.DB.Exceptions.CorruptedDB_UnparseableListingFormatError, e:
        err(e)
    except:
        raise

    return db

def svn_commit(globals, opts, ops, comment):
    if (not opts.var["no_commits"]) and len(ops):
        txn = DITrack.SVN.Transaction(globals, ops)
        txn.commit(comment)

