#
# UI.py - DITrack User Interface
#
# Copyright (c) 2006-2007 The DITrack Project, www.ditrack.org.
#
# $Id: UI.py 1132 2007-01-21 13:18:37Z oleg $
# $HeadURL: https://127.0.0.1/ditrack/src/tags/0.5/DITrack/UI.py $
#
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation 
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
# POSSIBILITY OF SUCH DAMAGE.
#

import sys

class MenuItem:
	def __init__(self, key, descr):
		self.key = key
		self.descr = descr

		self.enabled = True

class Menu:
	def __init__(self, title, items, eof_returns_value=True):
		"The first item in items should be the default for EOF"

		assert(len(items))

		self.eof_returns_value = eof_returns_value
		self.title = title
		self.default = items[0]

		self.key2item = {}
		for i in items:
			self.key2item[i.key] = i

	def run(self):
		assert(len(self.key2item))

		keys = self.key2item.keys()
		keys.sort()

		while 1:
			print self.title + ":"
			for k in keys:
				item = self.key2item[k]
				if not item.enabled: continue

				print "%s) %s" % (k, item.descr)

			# To avoid print() smartness in including extra blanks
			sys.stdout.write("> ")

			s = sys.stdin.readline()
			if not s: 
				if self.eof_returns_value:
					return self.default
				else:
					return None

			s = s.strip()
			
			if s.isdigit():
				s = int(s)
				
			if self.key2item.has_key(s):
				if self.key2item[s].enabled:
					return self.key2item[s]

			print "Unrecognized input: '" + str(s) + "'"
			print

class EnumMenu:
	def __init__(self, title, items, abort_option=None):
		items_list = []
		for i, v in enumerate(items):
			items_list.append(MenuItem((i + 1), v))

		self.abort_option = None
		if abort_option:
			self.abort_option = MenuItem("a", "abort")
			items_list.append(self.abort_option)
			
		self.menu = Menu(title, items_list, eof_returns_value=None)

	def run(self):
		r = self.menu.run()
		if not r: return None

		if self.abort_option and (r == self.abort_option):
			return None

		return r.descr

class TextInput:
	def __init__(self, title):
		self.title = title

	def run(self):
		print "%s:" % self.title
		sys.stdout.write("> ")
		str = sys.stdin.readline()

		if not str: return None

		return str.strip()
