#
# SVN.py - Subversion interface
#
# Copyright (c) 2006-2007 The DITrack Project, www.ditrack.org.
#
# $Id: SVN.py 1326 2007-02-26 03:46:34Z vss $
# $HeadURL: https://127.0.0.1/ditrack/src/tags/0.5/DITrack/SVN.py $
#
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation 
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
# POSSIBILITY OF SUCH DAMAGE.
#

import os
import popen2

# XXX: obsolete. Need to use globals.svn_path
svn = "svn"

def propget(propname, path):
    p = popen2.Popen3((svn, "propget", propname, path))

    str = ""

    while 1:
	s = p.fromchild.readline()
	if not s: break

	str = str + s

    ec = p.wait()

    if os.WIFEXITED(ec) and (os.WEXITSTATUS(ec) == 0):
	return str.rstrip("\n")

    return None

# Operation types
OP_ADD = 0      # Add file
OP_CHANGE = 1   # Mark file as modified
OP__QTY = 2

class Operation:
    "A basic operation"
    def __init__(self, type, fname):
	assert(type >= 0)
	assert(type < OP__QTY)

	self.type = type
	self.fname = fname

class OLDTransaction:
    "Single transaction: a bunch of operations"
    def __init__(self, globals, ops):
	self.globals = globals
	self.ops = ops

    def commit(self, logmsg):
	commit_list = {}

	for o in self.ops:
	    if o.type == OP_ADD:
		rc = svn_add(self.globals, o.fname)
		# XXX: raise exception here?
		if rc:
		    return rc

		commit_list[o.fname] = 1

	    elif o.type == OP_CHANGE:
		commit_list[o.fname] = 1
	    else:
		raise NotImplementedError

	rc = svn_commit(self.globals, logmsg, commit_list.keys())

	return rc

class Transaction:
    """
    Single Subversion transaction which end with a commit.
    """

    def __init__(self, svn):
	self.files = {}
	self.svn = svn

    def add(self, name):
	"""
	Add new file/directory into the transaction.
	"""
	self.svn.add(name)
	self.include(name)

    def commit(self, logmsg):
	"""
	Perform Subversion commit.
	"""

	fnames = self.files.keys()

	self.svn.commit(logmsg, fnames)

    def include(self, fname):
	"""
	Include file FNAME into the transaction.
	"""

	self.files[fname] = True

class Client:
    """
    Subversion interface class. All Subversion-related operations come through
    this class instance.
    """

    def __init__(self, svn_path):
	"""
	SVN_PATH is a path to Subversion command line client.
	"""

	self.svn_path = svn_path

    def add(self, fname):
	"""
	Schedule addition of a file.
	"""

	args = [ self.svn_path, "add", "-Nq", fname ]

	# XXX: raise exception on failure here
	return os.spawnvp(os.P_WAIT, self.svn_path, args)

    def commit(self, logmsg, fnames):

	assert(fnames)
	assert(logmsg)

	args = [ self.svn_path, "commit", "-q", "-m", logmsg ] + fnames
	# XXX: raise exception on failure here
	return os.spawnvp(os.P_WAIT, self.svn_path, args)


    def start_txn(self):
	"""
	Start a new transaction.
	"""

	return Transaction(self)
