/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio;

import de.xeinfach.kafenio.KafenioMenuBar;
import de.xeinfach.kafenio.KafenioPanel;
import de.xeinfach.kafenio.interfaces.KafenioPanelConfigurationInterface;
import de.xeinfach.kafenio.util.LeanLogger;
import java.awt.Color;
import java.net.URL;
import java.util.Vector;

public class KafenioPanelConfiguration
implements KafenioPanelConfigurationInterface {
    private static LeanLogger log = new LeanLogger("KafenioPanelConfiguration.class");
    public static final int STANDALONE_MODE = 0;
    public static final int APPLET_MODE = 1;
    public static final int JWS_MODE = 2;
    private static String defaultToolbar1Items = "NEW,OPEN,SAVE,SEPARATOR,CUT,COPY,PASTE,SEPARATOR,BOLD,ITALIC,UNDERLINE,SEPARATOR,LEFT,CENTER,RIGHT,JUSTIFY,SEPARATOR,STYLESELECT";
    private static String defaultToolbar2Items = "ULIST,OLIST,SEPARATOR,DEINDENT,INDENT,SEPARATOR,ANCHOR,SEPARATOR,IMAGE,SEPARATOR,CLEARFORMATS,SEPARATOR,VIEWSOURCE,SEPARATOR,STRIKE,SUPERSCRIPT,SUBSCRIPT,INSERTCHARACTER,SEPARATOR,FIND,COLOR,TABLE,SEPARATOR";
    private Object kafenioParent = null;
    private String outputmode = null;
    private String contentParameter = null;
    private String postUrl = null;
    private String servletMode = null;
    private String servletUrl = null;
    private String treePilotSystemID = null;
    private String imageDir = null;
    private String fileDir = null;
    private boolean showMenuBar = true;
    private boolean showToolbar2 = true;
    private boolean showToolbar = true;
    private String document = null;
    private String styleSheet = null;
    private String rawDocument = null;
    private URL urlStyleSheet = null;
    private boolean showViewSource = false;
    private boolean showMenuIcons = true;
    private String language = null;
    private String country = null;
    private boolean base64 = false;
    private boolean debugMode = false;
    private String[] styleSheetFileList = null;
    private String codeBase = null;
    private boolean applet = false;
    private Color bgcolor = null;
    private Vector customMenuItems = null;
    private Vector customToolBar1 = this.parseToolbarItems(defaultToolbar1Items);
    private Vector customToolBar2 = this.parseToolbarItems(defaultToolbar2Items);
    private int mode = 0;

    public boolean isApplet() {
        return this.mode == 1;
    }

    public boolean isWebStart() {
        return this.mode == 2;
    }

    public boolean isStandalone() {
        return this.mode == 0;
    }

    public boolean isBase64() {
        return this.base64;
    }

    public Color getBgcolor() {
        return this.bgcolor;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public String getCodeBase() {
        return this.codeBase;
    }

    public String getCountry() {
        return this.country;
    }

    public String getDocument() {
        return this.document;
    }

    public boolean isShowMenuIcons() {
        return this.showMenuIcons;
    }

    public boolean isShowViewSource() {
        return this.showViewSource;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getRawDocument() {
        return this.rawDocument;
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public String[] getStyleSheetFileList() {
        return this.styleSheetFileList;
    }

    public URL getUrlStyleSheet() {
        return this.urlStyleSheet;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void setBase64(boolean bl) {
        this.base64 = bl;
    }

    public void setBgcolor(Color color) {
        this.bgcolor = color;
    }

    public void setBgcolor(String string) {
        this.bgcolor = this.parseBgColor(string);
    }

    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    public void setCodeBase(String string) {
        this.codeBase = string;
    }

    public void setCountry(String string) {
        this.country = string;
    }

    public void setDocument(String string) {
        this.document = string;
    }

    public void setShowMenuIcons(boolean bl) {
        this.showMenuIcons = bl;
    }

    public void setShowViewSource(boolean bl) {
        this.showViewSource = bl;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setRawDocument(String string) {
        this.rawDocument = string;
    }

    public void setStyleSheet(String string) {
        this.styleSheet = string;
    }

    public void setStyleSheetFileList(String[] stringArray) {
        this.styleSheetFileList = stringArray;
    }

    public void setUrlStyleSheet(URL uRL) {
        this.urlStyleSheet = uRL;
    }

    public int getMode() {
        return this.mode;
    }

    public Vector getCustomMenuItems() {
        return this.customMenuItems;
    }

    public void setCustomMenuItems(Vector vector) {
        this.customMenuItems = vector;
    }

    public void setCustomMenuItems(String string) {
        if (string != null) {
            this.customMenuItems = this.parseMenuItems(string);
        }
    }

    public void setShowToolbar(boolean bl) {
        this.showToolbar = bl;
    }

    public void setShowToolbar2(boolean bl) {
        this.showToolbar2 = bl;
    }

    public void setShowMenuBar(boolean bl) {
        this.showMenuBar = bl;
    }

    public boolean isShowMenuBar() {
        return this.showMenuBar;
    }

    public boolean isShowToolbar() {
        return this.showToolbar;
    }

    public boolean isShowToolbar2() {
        return this.showToolbar2;
    }

    public void setImageDir(String string) {
        this.imageDir = string;
    }

    public void setFileDir(String string) {
        this.fileDir = string;
    }

    public String getFileDir() {
        return this.fileDir;
    }

    public String getImageDir() {
        return this.imageDir;
    }

    public void setTreePilotSystemID(String string) {
        this.treePilotSystemID = string;
    }

    public String getTreePilotSystemID() {
        return this.treePilotSystemID;
    }

    public void setServletUrl(String string) {
        this.servletUrl = string;
    }

    public String getServletUrl() {
        return this.servletUrl;
    }

    public void setServletMode(String string) {
        if (string.equalsIgnoreCase("cgi") || string.equalsIgnoreCase("java")) {
            this.servletMode = string;
        } else if (string == null || "".equals(string) || "none".equalsIgnoreCase(string)) {
            this.servletMode = "cgi";
        } else {
            throw new IllegalArgumentException("Valid arguments: \"cgi\", \"java\", \"none\"");
        }
    }

    public void setPostUrl(String string) {
        this.postUrl = string;
    }

    public String getPostUrl() {
        return this.postUrl;
    }

    public String getServletMode() {
        return this.servletMode;
    }

    public void setContentParameter(String string) {
        this.contentParameter = string;
    }

    public String getContentParameter() {
        return this.contentParameter;
    }

    public void setOutputmode(String string) {
        if ("normal".equalsIgnoreCase(string)) {
            this.outputmode = string.toUpperCase();
        } else if ("off".equalsIgnoreCase(string)) {
            this.outputmode = string.toUpperCase();
        } else if ("base64".equalsIgnoreCase(string)) {
            this.outputmode = string.toUpperCase();
        }
    }

    public String getOutputmode() {
        return this.outputmode;
    }

    public void setKafenioParent(Object object) {
        this.kafenioParent = object;
    }

    public Object getKafenioParent() {
        return this.kafenioParent;
    }

    public Vector getCustomToolBar1() {
        return this.customToolBar1;
    }

    public Vector getCustomToolBar2() {
        return this.customToolBar2;
    }

    public void setCustomToolBar1(Vector vector) {
        this.customToolBar1 = vector;
    }

    public void setCustomToolBar1(String string) {
        if (string != null) {
            this.customToolBar1 = this.parseToolbarItems(string);
        }
    }

    public void setCustomToolBar2(Vector vector) {
        this.customToolBar2 = vector;
    }

    public void setCustomToolBar2(String string) {
        if (string != null) {
            this.customToolBar2 = this.parseToolbarItems(string);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("codebase: " + this.getCodeBase());
        stringBuffer.append("\ncontent parameter: " + this.getContentParameter());
        stringBuffer.append("\ncountry: " + this.getCountry());
        stringBuffer.append("\ncustom menuitems: " + this.getCustomMenuItems());
        stringBuffer.append("\ntoolbar1: " + this.getCustomToolBar1());
        stringBuffer.append("\ntoolbar2: " + this.getCustomToolBar2());
        stringBuffer.append("\ndocument: " + this.getDocument());
        stringBuffer.append("\nfiledir: " + this.getFileDir());
        stringBuffer.append("\nimagedir: " + this.getImageDir());
        stringBuffer.append("\nparent: " + this.getKafenioParent());
        stringBuffer.append("\nlanguage: " + this.getLanguage());
        stringBuffer.append("\noutputmode: " + this.getOutputmode());
        stringBuffer.append("\npost url: " + this.getPostUrl());
        stringBuffer.append("\nraw document: " + this.getRawDocument());
        stringBuffer.append("\nservlet mode: " + this.getServletMode());
        stringBuffer.append("\nservlet url: " + this.getServletUrl());
        stringBuffer.append("\nstylesheet: " + this.getStyleSheet());
        stringBuffer.append("\nstylesheet file list: " + this.getStyleSheetFileList());
        stringBuffer.append("\ntreepilot sys id: " + this.getTreePilotSystemID());
        stringBuffer.append("\nstylesheet url: " + this.getUrlStyleSheet());
        stringBuffer.append("\nisApplet: " + this.isApplet());
        stringBuffer.append("\nisBase64: " + this.isBase64());
        stringBuffer.append("\nisDebugMode: " + this.isDebugMode());
        stringBuffer.append("\nisShowMenuBar: " + this.isShowMenuBar());
        stringBuffer.append("\nisShowMenuIcons: " + this.isShowMenuIcons());
        stringBuffer.append("\nisShowToolbar: " + this.isShowToolbar());
        stringBuffer.append("\nisShowToolbar2: " + this.isShowToolbar2());
        stringBuffer.append("\nisShowViewSource: " + this.isShowViewSource());
        return stringBuffer.toString();
    }

    public Vector parseToolbarItems(String string) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = null;
        if (string != null) {
            stringArray = KafenioPanel.tokenize(string);
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i].toLowerCase());
            }
        }
        if (vector.size() > 0) {
            return vector;
        }
        return null;
    }

    private Vector parseMenuItems(String string) {
        Vector<String> vector = null;
        if (this.isShowMenuBar()) {
            vector = new Vector<String>();
            String[] stringArray = null;
            if (string != null) {
                stringArray = KafenioPanel.tokenize(string.toLowerCase());
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!KafenioMenuBar.getOrderedMenuKeys().contains(stringArray[i])) continue;
                    vector.add(stringArray[i]);
                }
            }
        }
        return vector;
    }

    public Color parseBgColor(String string) {
        try {
            return Color.decode(string);
        }
        catch (Exception exception) {
            log.error("bgcolor-parameter not specified. setting background color to system default.");
            return null;
        }
    }
}

