<?php
require_once 'diogenes.common.inc.php';
require_once 'diogenes.admin.inc.php';

$page = new DiogenesAdmin;
$page->assign('greeting',__("Site options"));
$page->assign('post',$page->script_self());

// handle update request
$action = isset($_REQUEST['action']) ? $_REQUEST['action'] : "";
switch ($action) {
case "update":
  $page->options->updateOption("title", $_REQUEST['title']);
  $page->options->updateOption("description", $_REQUEST['description']);
  $page->options->updateOption("keywords", $_REQUEST['keywords']);
  $page->options->updateOption("favicon", $_REQUEST['favicon']);
  if (isset($_REQUEST['template']))
    $page->options->updateOption("template", $_REQUEST['template']);
  if (isset($_REQUEST['template_dir']))
    $page->options->updateOption("template_dir", $_REQUEST['template_dir']);
  $page->options->updateOption("menu_min_level", $_REQUEST['menu_min_level']);
  $page->options->updateOption("menu_style", $_REQUEST['menu_style']);
  if (isset($_REQUEST['menu_theme']))
    $page->options->updateOption("menu_theme", $_REQUEST['menu_theme']);
  break;
}

// fill out values
/* general options */
$page->assign('title', $page->options->title);
$page->assign('description', $page->options->description);
$page->assign('keywords', $page->options->keywords);
$page->assign('favicon', $page->options->favicon);
/* template options */
$page->assign('template', $page->options->template);
$page->assign('templates', $page->getTemplates());
if ($page->flags->hasFlag('tpl')) {
  $page->assign('template_dir', $page->options->template_dir);
  $res = $globals->db->query("SELECT PID,location from {$page->table_page} ORDER BY location");
  while (list($myPID,$myLocation) = mysql_fetch_row($res)) 
    $template_dirs[$myPID] = $myLocation ? $myLocation : "<home>";
  mysql_free_result($res);
  $page->assign('template_dirs', $template_dirs);
}
/* menu options */
$page->assign('menu_styles', $globals->menu_styles);
$page->assign('menu_style', $page->options->menu_style);
if ($page->options->menu_style == 1 || $page->options->menu_style == 2) {
  $page->assign('menu_themes', $globals->menu_themes);
  $page->assign('menu_theme', $page->options->menu_theme);
}
$page->assign('menu_levels',array(0=> __("fully expanded"), 1=>'1', 2=>'2', 3=>'3', 4=>'4'));
$page->assign('menu_min_level', $page->options->menu_min_level);

// translations
$page->assign('msg_general_options', __("general options"));
$page->assign('msg_title', __("title"));
$page->assign('msg_description', __("description"));
$page->assign('msg_keywords', __("keywords"));
$page->assign('msg_favicon', __("favicon"));
$page->assign('msg_favicon_hint', __("(relative url to a PNG image)"));
$page->assign('msg_template_options', __("template options"));
$page->assign('msg_site_template_dir', __("templates directory"));
$page->assign('msg_site_template', __("default template"));
$page->assign('msg_menu_options', __("menu options"));
$page->assign('msg_menu_style', __("menu style"));
$page->assign('msg_menu_theme', __("menu theme"));
$page->assign('msg_menu_min_level', __("minimum menu levels to expand"));
$page->assign('msg_submit', __("Submit"));
$page->display('admin-options.tpl');
?>
