package DDJDB;

#
# Perl interface to the DigitalDJ database
#
#  Copyright (c) 2002 by Mike Oliphant - oliphant@gtk.org
#
#    http://www.nostatic.org/ddj
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#

use DBI;
use strict;

sub new
{
  my ($pkg,%args)=@_;

  my $self={};

  bless $self,$pkg;

  if($args{dbname}) {
    $self->{dbname}=$args{dbname};
  }

  if($args{dbserver}) {
    $self->{dbserver}=$args{dbserver};
  }

  if($args{dbuser}) {
    $self->{dbuser}=$args{dbuser};
  }

  if($args{dbpswd}) {
    $self->{dbpswd}=$args{dbpswd};
  }

  $self->Connect();

  return $self;
}

sub Connect
{
  my ($self)=@_;

  $self->{DBH}=DBI->connect("DBI:mysql:$self->{dbname}:$self->{dbserver}",
			    $self->{dbuser},$self->{dbpswd});

  return undef if(!$self->{DBH});

  return $self->{DBH};
}

sub Disconnect
{
  my ($self)=@_;

  if($self->{DBH}) {
    $self->{DBH}->disconnect;
        $self->{DBH} = undef;
  }
}

sub DBCmd
{
  my ($self,$sql)=@_;

  return undef if(!$self->{DBH});

  my $sth=$self->{DBH}->prepare($sql);

  return $sth if($sth->execute);

  return undef;
}

sub DBQuote
{
  my ($self,$string)=@_;

  if(!$self->{DBH}) {
    $self->{DBH}=$self->Connect();
  }

  return $self->{DBH}->quote($string);
}

sub AddArtist
{
  my ($self,$artist_name)=@_;

  $artist_name=$self->DBQuote($artist_name);

  my $result=$self->DBCmd("SELECT id FROM artist WHERE artist=$artist_name");

  if($result->rows()) {
    my ($artist_id)=$result->fetchrow();

    return $artist_id;
  }

  return undef if(!$self->DBCmd("INSERT INTO artist (id,artist,num_plays,".
				"last_play,date_added) VALUES ".
				"(NULL,$artist_name,0,NULL,NOW())"));

  my $result=$self->DBCmd("SELECT LAST_INSERT_ID()");
  my ($artist_id)=$result->fetchrow();

  return $artist_id;
}

sub AddDisc
{
  my ($self,$disc_name,$artist_id,$genre,$year)=@_;

  $disc_name=$self->DBQuote($disc_name);

  my $result=$self->DBCmd("SELECT id FROM disc WHERE title=$disc_name AND ".
			  "artistid=$artist_id");

  if($result->rows()) {
    my ($disc_id)=$result->fetchrow();

    return $disc_id;
  }

  if($genre) {
    $genre=$self->DBQuote($genre);
  }
  else {
    $genre='NULL';
  }

  $year='NULL' if(!$year);

  if(!$self->DBCmd("INSERT INTO disc (id,title,artistid,num_plays,last_play,".
		   "date_added,genre,year) VALUES (NULL,$disc_name,".
		   "$artist_id,0,NULL,NOW(),$genre,$year)")) {
    return undef;
  }

  my $result=$self->DBCmd("SELECT LAST_INSERT_ID()");
  my ($disc_id)=$result->fetchrow();

  return $disc_id;
}

sub AddTrack
{
  my ($self,$filename,$artist_id,$disc_id,$title,$genre,$year,$track_num,
      $mins,$secs)=@_;

  my $filename=$self->DBQuote($filename);
  my $title=$self->DBQuote($title);

  my $result=$self->DBCmd("SELECT id FROM song WHERE title=$title AND ".
			  "artistid=$artist_id AND discid=$disc_id");

  return undef if($result->rows());

  if($genre) {
    $genre=$self->DBQuote($genre);
  }
  else {
    $genre='NULL';
  }

  $year='NULL' if(!$year);

  $track_num='NULL' if(!defined $track_num);

  my $play_time;

  if(defined $mins && defined $secs) {
    $play_time=sprintf("%02d:%02d",$mins,$secs);
  }
  else {
    $play_time='NULL';
  }

  if(!$self->DBCmd("INSERT INTO song (date_added,filename,title,".
		   "artistid,discid,genre,track_num,play_time,".
		   "num_plays,last_play,year) VALUES ".
		   "(NOW(),$filename,$title,$artist_id,$disc_id,".
		   "$genre,$track_num,$play_time,0,NULL,$year)")) {
    return undef;
  }
			
  my $result=$self->DBCmd("SELECT LAST_INSERT_ID()");
  my ($track_id)=$result->fetchrow();

  return $track_id;
}

1;

