#
# Table structure for table 'artist'
#

CREATE TABLE artist (
  id int(11) NOT NULL auto_increment,
  artist varchar(80) default NULL,
  num_plays int(11) default NULL,
  last_play datetime default NULL,
  date_added date default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

#
# Table structure for table 'db_info'
#

CREATE TABLE db_info (
  db_version int(10) unsigned default NULL
) TYPE=MyISAM;

INSERT INTO db_info (db_version) VALUES (2);

#
# Table structure for table 'disc'
#

CREATE TABLE disc (
  id int(11) NOT NULL auto_increment,
  title varchar(80) default NULL,
  artistid int(11) default NULL,
  num_plays int(11) default NULL,
  last_play datetime default NULL,
  genre varchar(20) default NULL,
  year int(11) default NULL,
  date_added date default NULL,
  gain_adjustment int(11) default NULL,
  PRIMARY KEY  (id),
  KEY artistid (artistid)
) TYPE=MyISAM;

#
# Table structure for table 'playlist_data'
#

CREATE TABLE playlist_data (
  id int(10) unsigned NOT NULL auto_increment,
  name varchar(255) default NULL,
  type enum('SONG','ARTIST','DISC','GENRE') default 'SONG',
  size int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (id),
  UNIQUE KEY name (name)
) TYPE=MyISAM;

#
# Table structure for table 'playlist_items'
#

CREATE TABLE playlist_items (
  playlist_id int(10) unsigned NOT NULL default '0',
  item_id int(10) unsigned NOT NULL default '0',
  position int(10) unsigned NOT NULL default '0'
) TYPE=MyISAM;

#
# Table structure for table 'song'
#

CREATE TABLE song (
  id int(11) NOT NULL auto_increment,
  filename varchar(255) default NULL,
  title varchar(80) default NULL,
  artistid int(11) default NULL,
  discid int(11) default NULL,
  genre varchar(20) default NULL,
  track_num int(11) default NULL,
  start_frame int(11) default NULL,
  num_frames int(11) default NULL,
  play_time varchar(5) default NULL,
  bpm int(11) default NULL,
  num_plays int(11) default NULL,
  last_play datetime default NULL,
  year int(11) default NULL,
  date_added date default NULL,
  gain_adjustment int(11) default NULL,
  PRIMARY KEY  (id),
  KEY artistid (artistid),
  KEY discid (discid)
) TYPE=MyISAM;

