/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "profileeditor.h"


ProfileEditor::ProfileEditor(PumpController *pumpController,
                             QWidget *parent) : QWidget(parent)
{
    this->setWindowTitle("Dianara - " + tr("Profile Editor"));
    this->setWindowIcon(QIcon::fromTheme("user-properties"));
    this->setWindowFlags(Qt::Window);
    this->setWindowModality(Qt::NonModal);
    this->setMinimumSize(500, 350);

    this->pController = pumpController;

    avatarLabel = new QLabel();
    avatarLabel->setPixmap(QIcon::fromTheme("user-properties").pixmap(64, 64));

    fullNameLineEdit = new QLineEdit();
    hometownLineEdit = new QLineEdit();
    bioTextEdit = new QTextEdit();
    bioTextEdit->setTabChangesFocus(true);


    saveButton = new QPushButton(QIcon::fromTheme("document-save"),
                                 tr("&Save Profile"));
    connect(saveButton, SIGNAL(clicked()), this, SLOT(saveProfile()));

    cancelButton = new QPushButton(QIcon::fromTheme("dialog-cancel"),
                                   tr("&Cancel"));
    connect(cancelButton, SIGNAL(clicked()), this, SLOT(hide()));



    this->bottomLayout = new QHBoxLayout();
    bottomLayout->setAlignment(Qt::AlignRight);
    bottomLayout->addWidget(saveButton);
    bottomLayout->addWidget(cancelButton);


    this->mainLayout = new QFormLayout();
    mainLayout->setSpacing(8);
    mainLayout->addRow(tr("Avatar"),     avatarLabel);
    mainLayout->addRow(tr("Full &Name"), fullNameLineEdit);
    mainLayout->addRow(tr("&Hometown"),  hometownLineEdit);
    mainLayout->addRow(tr("&Bio"),       bioTextEdit);

    mainLayout->addRow(bottomLayout);

    this->setLayout(mainLayout);


    qDebug() << "ProfileEditor created";
}



ProfileEditor::~ProfileEditor()
{
    qDebug() << "ProfileEditor destroyed";
}



/*
 * Fill the fields from received info
 *
 */
void ProfileEditor::setProfileData(QString avatarURL, QString fullName, QString hometown, QString bio)
{
    this->currentAvatarURL = avatarURL;

    QString avatarFilename = MiscHelpers::getCachedAvatarFilename(this->currentAvatarURL);
    if (QFile::exists(avatarFilename))
    {
        this->avatarLabel->setPixmap(QPixmap(avatarFilename).scaled(64, 64,
                                                                    Qt::KeepAspectRatio,
                                                                    Qt::SmoothTransformation));
    }

    this->fullNameLineEdit->setText(fullName);
    this->hometownLineEdit->setText(hometown);
    this->bioTextEdit->setText(bio);
}



/****************************************************************************/
/******************************** SLOTS *************************************/
/****************************************************************************/


void ProfileEditor::saveProfile()
{
    this->pController->updateUserProfile(this->currentAvatarURL,
                                         this->fullNameLineEdit->text().trimmed(),
                                         this->hometownLineEdit->text().trimmed(),
                                         this->bioTextEdit->toPlainText().trimmed());

    this->hide(); // close() would end the program if main window is hidden
}
