/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "minorfeeditem.h"


MinorFeedItem::MinorFeedItem(QString timestamp,
                             QString activityDescription,
                             QString activityActorAvatar,
                             QString activityObjectAuthor,
                             QString activityObjectContent,
                             QWidget *parent) : QFrame(parent)
{
    QFont mainFont;
    mainFont.setPointSize(mainFont.pointSize() - 2);

    avatarLabel = new QLabel();
    if (QFile::exists(activityActorAvatar))
    {
        avatarLabel->setPixmap(QPixmap(activityActorAvatar)
                               .scaledToWidth(32, Qt::SmoothTransformation));
    }
    else
    {
        avatarLabel->setPixmap(QIcon::fromTheme("user-identity")
                               .pixmap(32,32)
                               .scaledToWidth(32, Qt::SmoothTransformation));
    }


    timestampLabel = new QLabel("[ " + Timestamp::fuzzyTime(timestamp) + " ]");
    mainFont.setBold(true);
    timestampLabel->setFont(mainFont);
    timestampLabel->setWordWrap(true);
    timestampLabel->setToolTip(Timestamp::localTimeDate(timestamp));


    QString activityTooltip;
    if (!activityObjectAuthor.isEmpty())
    {
        activityTooltip = "[ " + activityObjectAuthor + " ]"
                          "<br><br>";
    }
    if (!activityObjectContent.isEmpty())
    {
        activityTooltip.append("<b></b>");
        activityTooltip.append(activityObjectContent);
    }

    activityDescriptionLabel = new QLabel(activityDescription);
    mainFont.setBold(false);
    activityDescriptionLabel->setFont(mainFont);
    activityDescriptionLabel->setWordWrap(true);
    activityDescriptionLabel->setOpenExternalLinks(true);
    activityDescriptionLabel->setToolTip(activityTooltip);

    rightLayout = new QVBoxLayout();
    rightLayout->addWidget(timestampLabel);
    rightLayout->addWidget(activityDescriptionLabel);

    mainLayout = new QHBoxLayout();
    mainLayout->addWidget(avatarLabel, 1, Qt::AlignTop | Qt::AlignLeft);
    mainLayout->addLayout(rightLayout, 9);
    this->setLayout(mainLayout);

    qDebug() << "MinorFeedItem created";
}

MinorFeedItem::~MinorFeedItem()
{
    qDebug() << "MinorFeedItem destroyed";
}
